/// Marker trait for tuples of slices.
/// Implemented for tupes upto 16.
pub trait SliceTuple: private::SealedSliceTuple {}
/// Marker trait for tuples of mutable slices.
/// Implemented for tupes upto 16.
pub trait MutSliceTuple: private::SealedMutSliceTuple {}

macro_rules! impl_slice_tuples {
    ($ty:ident) => {
        impl<$ty> SliceTuple for &[$ty] {}
        impl<$ty> MutSliceTuple for &mut [$ty] {}
    }; //base case

    ($first:ident, $($tail:ident), *) => {
        impl<$first, $($tail),*> SliceTuple for (&[$first], $(&[$tail]), *)
            where Self : private::SealedSliceTuple
        {}
        impl<$first, $($tail),*> MutSliceTuple for (&mut [$first], $(&mut [$tail]), *)
            where Self : private::SealedMutSliceTuple {}

        impl_slice_tuples!($($tail),*);
    }
}

impl_slice_tuples!(T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16);

mod private {
    pub trait SealedSliceTuple {}
    pub trait SealedMutSliceTuple {}

    macro_rules! impl_sealed_slice_tuples {
        ($ty:ident) => {
            impl<$ty> SealedSliceTuple for &[$ty] {}
            impl<$ty> SealedMutSliceTuple for &mut [$ty] {}
        }; //base case

        ($first:ident, $($tail:ident), *) => {
            impl<$first, $($tail),*> SealedSliceTuple for (&[$first], $(&[$tail]), *) {}
            impl<$first, $($tail),*> SealedMutSliceTuple for (&mut [$first], $(&mut [$tail]), *) {}

            impl_sealed_slice_tuples!($($tail),*);
        }
    }

    impl_sealed_slice_tuples!(
        T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16
    );
}
