use crate::*;
use std::marker::PhantomData;

//TODO: This allocator is currently broken!
// Needs some serious work. Do NOT use this.

/// Allocator for splitting a component into it's fields and storing the fields in separate subarrays.
/// It splits the memory of the POOLS_PER_ALLOCATION * COMPONENTS_PER_POOL items in the  into segments, storing the same fields of the component next to eachother.
/// Should only be used in cases where SIMD vectorization heavily influences performance.
/// It MUST store exactly POOLS_PER_ALLOCATION * COMPONENTS_PER_POOL elements.
pub struct StructOfArrayAllocator<
    G: for<'s> FieldGroup<'s, FIELD_COUNT>,
    const ALLOCATION_SIZE: usize,
    const ALLOCATION_ALIGNMENT: usize,
    const FIELD_COUNT: usize,
> {
    _phantom: PhantomData<*const G>,
}

impl<
        's,
        C,
        G,
        const ALLOCATION_SIZE: usize,
        const ALLOCATION_ALIGNMENT: usize,
        const FIELD_COUNT: usize,
    > ComponentAllocator<'s, C>
    for StructOfArrayAllocator<G, ALLOCATION_SIZE, ALLOCATION_ALIGNMENT, FIELD_COUNT>
where
    C: Component,
    G: for<'z> FieldGroup<'z, FIELD_COUNT>,
    C: From<<G as FieldGroup<'s, FIELD_COUNT>>::RefType>,
    &'s C: Into<<G as FieldGroup<'s, FIELD_COUNT>>::RefType>,
{
    type RefType = <G as FieldGroup<'s, FIELD_COUNT>>::RefType;
    type MutRefType = <G as FieldGroup<'s, FIELD_COUNT>>::MutRefType;
    type SliceType = <G as FieldGroup<'s, FIELD_COUNT>>::SliceType;
    type MutSliceType = <G as FieldGroup<'s, FIELD_COUNT>>::MutSliceType;

    const ALLOCATION_ALIGNMENT: usize = ALLOCATION_ALIGNMENT;
    const ALLOCATION_SIZE: usize = ALLOCATION_SIZE;
    ///TODO: Implement and test SoA allocator.
    const POOL_STRIDE: usize = 0;

    /// Writes a component into the pool.
    unsafe fn write_component_memory(pool_ptr: *mut u8, index: u16, src: *const u8) {
        let dest: [*mut u8; FIELD_COUNT] = G::offset_pointers_mut(pool_ptr, index);
        {
            // Transmute into a longer lived lifetime to satisfy the typecheck,
            // since due to not having GATs I cannot express this the way I would like to.
            // write_to_pointers is unsafe and discards any lifetime information anyway, so this is safe,
            // since the actual data will live for 's, just destructured.
            let k: &'s C = std::mem::transmute(src as *const C);
            let reftuple: G::RefType = k.into();
            G::write_to_pointers(reftuple, dest);
        } // Drop the reference k. This will NOT drop src.
          // Forget src.
        std::mem::forget(src);
    }

    /// Reads a component from a pool.
    unsafe fn read_component_memory(pool_ptr: *const u8, index: u16, destination: *mut u8) {
        let src: [*const u8; FIELD_COUNT] = G::offset_pointers(pool_ptr, index);
        let obj: C = G::read_from_pointers(src).into();
        std::ptr::copy_nonoverlapping(&obj, destination as *mut C, 1);
    }

    /// Calls the drop handler on the component at the given index.
    unsafe fn drop_component_memory(pool_ptr: *mut u8, index: u16) {
        // Explicit drop!
        //let _obj: C = Self::read_component_memory(pool_ptr, index);
        todo!()
    }

    /// Moves a component from the source pool into the destination pool. Does not call drop.
    unsafe fn move_component(
        source_pool: *const u8,
        src_index: u16,
        destination_pool: *mut u8,
        dst_index: u16,
    ) {
        todo!()
    }

    /// Returns a reference to the component.
    unsafe fn get_component(pool_ptr: *const u8, index: u16) -> Self::RefType {
        let src: [*const u8; FIELD_COUNT] = G::offset_pointers(pool_ptr, index);
        G::read_from_pointers(src)
    }

    /// Returns a mutable reference to the component.
    unsafe fn get_component_mut(pool_ptr: *mut u8, index: u16) -> Self::MutRefType {
        let src: [*mut u8; FIELD_COUNT] = G::offset_pointers_mut(pool_ptr, index);
        G::read_from_pointers_mut(src)
    }

    /// Returns a slice to the components.
    unsafe fn get_component_slice(pool_ptr: *const u8, len: u16) -> Self::SliceType {
        G::slice_pointers(pool_ptr, len)
    }

    /// Returns a mutable slice to the components.
    unsafe fn get_component_slice_mut(pool_ptr: *mut u8, len: u16) -> Self::MutSliceType {
        G::slice_pointers_mut(pool_ptr, len)
    }
}
