//! Shadowsocks Local Transparent Proxy

use std::net::{Ipv4Addr, Ipv6Addr};

pub use self::server::Redir;

mod redir_ext;
mod server;
mod sys;
mod tcprelay;
mod udprelay;

/// Helper function for converting IPv4 mapped IPv6 address
///
/// This is the same as `Ipv6Addr::to_ipv4_mapped`, but it is still unstable in the current libstd
fn to_ipv4_mapped(ipv6: &Ipv6Addr) -> Option<Ipv4Addr> {
    match ipv6.octets() {
        [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xff, 0xff, a, b, c, d] => Some(Ipv4Addr::new(a, b, c, d)),
        _ => None,
    }
}
