 ![Licence](https://img.shields.io/crates/l/sha3sum) ![Version](https://img.shields.io/crates/v/sha3sum) [![dependency status](https://deps.rs/repo/bitbucket/kurdy/sha3sum/status.svg)](https://deps.rs/repo/bitbucket/kurdy/sha3sum) ![Download.io](https://img.shields.io/crates/d/sha3sum)

# sha3 utilities: Print or check SHA3 digests
Command line that wraps sha3 lib from [RustCrypto/hashes](https://github.com/RustCrypto/hashes).  
Commands and options are similar to the GNU Linux command shaXXXsum

## Install
* Using rust toolschain:  `cargo install sha3sum`
* Using archLinux package [AUR](https://aur.archlinux.org/packages/r-sha3sum/)
* Download binaries from [IPFS](https://ipfs.io/ipfs/QmarNEPQqbD7Zj4wMmJLXScju2RNNiK16wQL7Wkgw8sYGi)
    * Uncompress archive.
    * (optional) Check the binary 'sha3sum -c sha3sum.hash'
    * With linux you may use `./install.sh` which just copy files to the system

## Howto
* Get help:  `sha3sum --help`
* Create for a file an hash Sha3-256  `sha3sum -a 256 <path to file>`
* Create for all file in repository with Keccak512  `sha3sum -a Keccak512 <path>`
* Create an hash for a text file using text mode  `sha3sum -a 384 -t <path to file>`
* Create for a file an hash Sha3-256 with output BSD style  `sha3sum -a 256 --tag <path to file>`
* Read SHA3 sums from the FILEs and check them  `sha3sum -c <path to file>`

## Releases
* 1.0.0 Upgrade release
  * Update dependencies
  * Update Rust version
  * Solve some new Clippy warning's
  * Create AUR package
  * Tested architecture:
      * Linux: x86_64
      * Linux aarch64
      * FreeBSD: amd64
      * Windows: x86_64
* 0.1.5 Update release 
    * Update dependencies
    * Update Rust version
    * Solve some new Clippy warning's
    * Remove OpenBuild rpm's
    * Create AUR package
    * Tested architecture: 
         * Linux: x86_64
         * Linux aarch64
         * FreeBSD: amd64
         * Windows: x86_64
* 0.1.4 Add spec files for binaries packages rpm's and generic install

[Sources from GitLab](https://gitlab.com/kurdy/sha3sum.git) `git clone https://gitlab.com/kurdy/sha3sum.git`