% SETTLE(1) Settle 0.36.0 | Settle Manual

# NAME

settle - note manager for the Zettelkasten method

# SYNOPSIS

| *settle* \<command\> [\<args\>]
| *settle* [\-h | \-\-help | \-V | \-\-version]

# DESCRIPTION

Settle is a Zettelkasten note manager. All notes are written in Markdown and are
stored locally.

As of v0.26.0, Settle no longer supports editing a file directly.
Therefore, you're probably going to want to use (or write) a plugin for your
favourite editor, such as [settle.vim](https://github.com/xylous/settle.vim) for
Vim and Neovim.

# OPTIONS

\-h, \-\-help

:   Print usage information

\-V, \-\-version

:   Print version information

# COMMANDS

*help*

:   Print usage information broadly or, if a subcommand is given, usage
    information for said subcommand

*compl*

:   Generate autocompletion file for a certain shell (currently supported: zsh,
    bash, fish) (see: section on autocompletion)

    All subdirectories within the Zettelkasten one are treated as "projects"

*generate*

:   Create and populate the database with all Zettel's metadata

    If ran for the first time, creates a directory to hold all your notes (as
    per your configuration options) and populates it with an 'inbox' project

*ls*

:   List existing files in Zettelkasten, based on database info

*new*

:   Create a new Zettel and add its metadata to the database, but don't
    overwrite; if the file exists and the metadata entry also exists, abort

    With the \-p or \-\-project option, you can specify a certain project
    (directory within the zettelkasten) to create your new note in.

*update*

:   Update the metadata for a given path. If the path isn't a file or
    doesn't exist, print an error message.

*query*

:   Return existing Zettel matching the pattern provided as argument

*ghost*

:   Print a list of Zettel that have links pointing to them, but haven't been
    created

*tags*

:   List all unique tags used in the Zettelkasten

*projects*

:   List all projects that the Zettelkasten contains

*find*

:   Search for Zettel that have the specified tag

*links*

:   Print the Zettel that match the query provided and the forward links they
    contain

*backlinks*

:   Print the Zettel (plural) that match the query provided and the Zettel (also
    plural) that have links pointing to them

*search*

:   Return a list of Zettel that contain the specified text

*zk*

:   Print the absolute path to the directory Settle uses

# CONFIGURATION

zettelkasten

:   Path to Zettelkasten

    If you don't specify an absolute path, e.g. `notes`, it's assumed you want
    your Zettelkasten to be at `~/notes`. You can also use paths containing
    environment variables or paths starting with a tilde (`~`)

db_file

:   Database file Settle uses

template

:   Path to Zettel template

    If empty, or if the path is invalid, then templates won't be used. You can
    use paths containing environment variables, or a leading tilde (`~`).

# TEMPLATES

Template files are used when creating new Zettel. The text they contain gets put
inside said new note, replacing variables.

## Placeholders

`${TITLE}`

: placeholder for the actual title

`${DATE}`

: replaced with the output of `date +%Y-%m-%d`

## Example template

```md
# ${TITLE}



### References


```

# FILES

The configuration file is at either `$XDG_CONFIG_HOME/settle/settle.yaml`, if
`$XDG_CONFIG_HOME` is set, either `~/.config/settle/settle.yaml`, by default.

# WILDCARDS

Settle supports two wildcards that'll come in very handy:

`*`

:   matches zero or more characters

`.`

:   matches a single character

If you want a literal '\*', or a literal '.', you'll need to escape the
character, i.e. '\\\*' or '\\\.'. If you want a literal backslash, you're also going
to have to escape it, i.e. '\\\\'. All other text is matched literally.

# AUTOCOMPLETION

Shell completions can be generated by the user at runtime, by using the `compl`
command. In most cases, you'll need to create a directory for user-defined
completions, then add `settle`'s output to it.

If you want XDG compliance, you probably know what you're doing, so just replace
a few things here and there.

## bash

Add the following text to the `~/.bash_completion` file:

```bash
for comp_file in ~/.bash_completion.d/*; do
    [[ -f "${comp_file}" ]] && . "${comp_file}"
done
```

And then run the following commands:

```bash
mkdir ~/.bash_completion.d
settle compl bash >~/.bash_completion.d/settle
```

## zsh

In your terminal, run:

```zsh
mkdir ~/.zsh_completion.d
settle compl zsh >~/zsh_completion.d/_settle
```

Then add this line in your zshrc:

```zsh
fpath=(${HOME}/.zsh_completion.d $fpath)
```

## fish

Run the following commands:

```fish
mkdir -p ~/.config/fish/completions
settle compl fish >~/.config/fish/completions/settle.fish
```

# AUTHORS

xylous \<xylous.e@gmail.com\>
