use std::error::Error;
use std::process::exit;
use std::{env, fs};
use toml_edit::{value, Document};

const USAGE: &str =
    "Usage: set-cargo-version <path to Cargo.toml> <string to set version to>";

fn main() -> Result<(), Box<dyn Error>> {
    let args: Vec<_> = env::args().collect();

    if args.len() != 3 {
        eprintln!("{}", USAGE);
        exit(1);
    }

    let file_content = fs::read_to_string(&args[1])?;
    let mut toml = file_content.parse::<Document>()?;
    toml["package"]["version"] = value(args[2].as_str());
    fs::write(&args[1], toml.to_string().as_bytes())?;

    Ok(())
}
