#!/usr/bin/env python3
import json
import os

from ucd.unicode import UNICODE_VERSION_MAJOR, UNICODE_VERSION_MINOR, UNICODE_VERSION_UPDATE

UNICODE_DATA_DIR = 'data/{}.{}.{}'.format(
    UNICODE_VERSION_MAJOR,
    UNICODE_VERSION_MINOR,
    UNICODE_VERSION_UPDATE
)

with open(os.path.join(UNICODE_DATA_DIR, 'PropertyValueAliases.json')) as f:
    property_value_aliases = json.load(f)


def to_pascal_case(val: str):
    val = val.lower()
    val = val.title()
    val = val.replace('_', '')

    return val


if __name__ == '__main__':
    sc = property_value_aliases['sc']
    txt = 'pub(crate) fn sc_name(prop: Sc) -> PropertyName {\n'
    txt += '    // This method is generated by `gen-sc-name.py` script.\n'
    txt += '    match prop {\n'
    for alias in sc.keys():
        seshat_enum = to_pascal_case(alias)
        txt += '        Sc::{} => PropertyName {{\n'.format(seshat_enum)
        txt += '            full: "{}",\n'.format(sc[alias])
        txt += '            abbr: "{}",\n'.format(alias)
        txt += '        },\n'
    txt += '    }\n'
    txt += '}\n'
    print(txt)
