#!/usr/bin/env python3
import json
import os

from ucd.unicode import UNICODE_VERSION_MAJOR, UNICODE_VERSION_MINOR, UNICODE_VERSION_UPDATE

UNICODE_DATA_DIR = 'data/{}.{}.{}'.format(
    UNICODE_VERSION_MAJOR,
    UNICODE_VERSION_MINOR,
    UNICODE_VERSION_UPDATE
)

with open(os.path.join(UNICODE_DATA_DIR, 'PropertyValueAliases.json')) as f:
    property_value_aliases = json.load(f)


def to_pascal_case(val: str):
    val = val.lower()
    val = val.title()
    val = val.replace('_', '')

    return val


if __name__ == '__main__':
    blk = property_value_aliases['blk']
    txt = 'pub enum Blk {\n'
    txt += '    // These enum contents are generated by `gen-blk-enum.py` script.\n'
    for k in blk.keys():
        val = to_pascal_case(k)
        txt += '    {},\n'.format(val)
    txt += '}\n'
    print(txt)
