pub const TEST_CASES: &[(&str, &str, &str, &str, &str)] = &[
    ("\u{1E0A}", "\u{1E0A}", "\u{0044}\u{0307}", "\u{1E0A}", "\u{0044}\u{0307}"),
    ("\u{1E0C}", "\u{1E0C}", "\u{0044}\u{0323}", "\u{1E0C}", "\u{0044}\u{0323}"),
    ("\u{1E0A}\u{0323}", "\u{1E0C}\u{0307}", "\u{0044}\u{0323}\u{0307}", "\u{1E0C}\u{0307}", "\u{0044}\u{0323}\u{0307}"),
    ("\u{1E0C}\u{0307}", "\u{1E0C}\u{0307}", "\u{0044}\u{0323}\u{0307}", "\u{1E0C}\u{0307}", "\u{0044}\u{0323}\u{0307}"),
    ("\u{0044}\u{0307}\u{0323}", "\u{1E0C}\u{0307}", "\u{0044}\u{0323}\u{0307}", "\u{1E0C}\u{0307}", "\u{0044}\u{0323}\u{0307}"),
    ("\u{0044}\u{0323}\u{0307}", "\u{1E0C}\u{0307}", "\u{0044}\u{0323}\u{0307}", "\u{1E0C}\u{0307}", "\u{0044}\u{0323}\u{0307}"),
    ("\u{1E0A}\u{031B}", "\u{1E0A}\u{031B}", "\u{0044}\u{031B}\u{0307}", "\u{1E0A}\u{031B}", "\u{0044}\u{031B}\u{0307}"),
    ("\u{1E0C}\u{031B}", "\u{1E0C}\u{031B}", "\u{0044}\u{031B}\u{0323}", "\u{1E0C}\u{031B}", "\u{0044}\u{031B}\u{0323}"),
    ("\u{1E0A}\u{031B}\u{0323}", "\u{1E0C}\u{031B}\u{0307}", "\u{0044}\u{031B}\u{0323}\u{0307}", "\u{1E0C}\u{031B}\u{0307}", "\u{0044}\u{031B}\u{0323}\u{0307}"),
    ("\u{1E0C}\u{031B}\u{0307}", "\u{1E0C}\u{031B}\u{0307}", "\u{0044}\u{031B}\u{0323}\u{0307}", "\u{1E0C}\u{031B}\u{0307}", "\u{0044}\u{031B}\u{0323}\u{0307}"),
    ("\u{0044}\u{031B}\u{0307}\u{0323}", "\u{1E0C}\u{031B}\u{0307}", "\u{0044}\u{031B}\u{0323}\u{0307}", "\u{1E0C}\u{031B}\u{0307}", "\u{0044}\u{031B}\u{0323}\u{0307}"),
    ("\u{0044}\u{031B}\u{0323}\u{0307}", "\u{1E0C}\u{031B}\u{0307}", "\u{0044}\u{031B}\u{0323}\u{0307}", "\u{1E0C}\u{031B}\u{0307}", "\u{0044}\u{031B}\u{0323}\u{0307}"),
    ("\u{00C8}", "\u{00C8}", "\u{0045}\u{0300}", "\u{00C8}", "\u{0045}\u{0300}"),
    ("\u{0112}", "\u{0112}", "\u{0045}\u{0304}", "\u{0112}", "\u{0045}\u{0304}"),
    ("\u{0045}\u{0300}", "\u{00C8}", "\u{0045}\u{0300}", "\u{00C8}", "\u{0045}\u{0300}"),
    ("\u{0045}\u{0304}", "\u{0112}", "\u{0045}\u{0304}", "\u{0112}", "\u{0045}\u{0304}"),
    ("\u{1E14}", "\u{1E14}", "\u{0045}\u{0304}\u{0300}", "\u{1E14}", "\u{0045}\u{0304}\u{0300}"),
    ("\u{0112}\u{0300}", "\u{1E14}", "\u{0045}\u{0304}\u{0300}", "\u{1E14}", "\u{0045}\u{0304}\u{0300}"),
    ("\u{1E14}\u{0304}", "\u{1E14}\u{0304}", "\u{0045}\u{0304}\u{0300}\u{0304}", "\u{1E14}\u{0304}", "\u{0045}\u{0304}\u{0300}\u{0304}"),
    ("\u{0045}\u{0304}\u{0300}", "\u{1E14}", "\u{0045}\u{0304}\u{0300}", "\u{1E14}", "\u{0045}\u{0304}\u{0300}"),
    ("\u{0045}\u{0300}\u{0304}", "\u{00C8}\u{0304}", "\u{0045}\u{0300}\u{0304}", "\u{00C8}\u{0304}", "\u{0045}\u{0300}\u{0304}"),
    ("\u{05B8}\u{05B9}\u{05B1}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}", "\u{05B1}\u{05B8}\u{05B9}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}", "\u{05B1}\u{05B8}\u{05B9}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}", "\u{05B1}\u{05B8}\u{05B9}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}", "\u{05B1}\u{05B8}\u{05B9}\u{0591}\u{05C3}\u{05B0}\u{05AC}\u{059F}"),
    ("\u{0592}\u{05B7}\u{05BC}\u{05A5}\u{05B0}\u{05C0}\u{05C4}\u{05AD}", "\u{05B0}\u{05B7}\u{05BC}\u{05A5}\u{0592}\u{05C0}\u{05AD}\u{05C4}", "\u{05B0}\u{05B7}\u{05BC}\u{05A5}\u{0592}\u{05C0}\u{05AD}\u{05C4}", "\u{05B0}\u{05B7}\u{05BC}\u{05A5}\u{0592}\u{05C0}\u{05AD}\u{05C4}", "\u{05B0}\u{05B7}\u{05BC}\u{05A5}\u{0592}\u{05C0}\u{05AD}\u{05C4}"),
    ("\u{1100}\u{AC00}\u{11A8}", "\u{1100}\u{AC01}", "\u{1100}\u{1100}\u{1161}\u{11A8}", "\u{1100}\u{AC01}", "\u{1100}\u{1100}\u{1161}\u{11A8}"),
    ("\u{1100}\u{AC00}\u{11A8}\u{11A8}", "\u{1100}\u{AC01}\u{11A8}", "\u{1100}\u{1100}\u{1161}\u{11A8}\u{11A8}", "\u{1100}\u{AC01}\u{11A8}", "\u{1100}\u{1100}\u{1161}\u{11A8}\u{11A8}"),
    ("\u{00A0}", "\u{00A0}", "\u{00A0}", "\u{0020}", "\u{0020}"),
    ("\u{00A8}", "\u{00A8}", "\u{00A8}", "\u{0020}\u{0308}", "\u{0020}\u{0308}"),
    ("\u{00AA}", "\u{00AA}", "\u{00AA}", "\u{0061}", "\u{0061}"),
    ("\u{00AF}", "\u{00AF}", "\u{00AF}", "\u{0020}\u{0304}", "\u{0020}\u{0304}"),
    ("\u{00B2}", "\u{00B2}", "\u{00B2}", "\u{0032}", "\u{0032}"),
    ("\u{00B3}", "\u{00B3}", "\u{00B3}", "\u{0033}", "\u{0033}"),
    ("\u{00B4}", "\u{00B4}", "\u{00B4}", "\u{0020}\u{0301}", "\u{0020}\u{0301}"),
    ("\u{00B5}", "\u{00B5}", "\u{00B5}", "\u{03BC}", "\u{03BC}"),
    ("\u{00B8}", "\u{00B8}", "\u{00B8}", "\u{0020}\u{0327}", "\u{0020}\u{0327}"),
    ("\u{00B9}", "\u{00B9}", "\u{00B9}", "\u{0031}", "\u{0031}"),
    ("\u{00BA}", "\u{00BA}", "\u{00BA}", "\u{006F}", "\u{006F}"),
    ("\u{00BC}", "\u{00BC}", "\u{00BC}", "\u{0031}\u{2044}\u{0034}", "\u{0031}\u{2044}\u{0034}"),
    ("\u{00BD}", "\u{00BD}", "\u{00BD}", "\u{0031}\u{2044}\u{0032}", "\u{0031}\u{2044}\u{0032}"),
    ("\u{00BE}", "\u{00BE}", "\u{00BE}", "\u{0033}\u{2044}\u{0034}", "\u{0033}\u{2044}\u{0034}"),
    ("\u{00C0}", "\u{00C0}", "\u{0041}\u{0300}", "\u{00C0}", "\u{0041}\u{0300}"),
    ("\u{00C1}", "\u{00C1}", "\u{0041}\u{0301}", "\u{00C1}", "\u{0041}\u{0301}"),
    ("\u{00C2}", "\u{00C2}", "\u{0041}\u{0302}", "\u{00C2}", "\u{0041}\u{0302}"),
    ("\u{00C3}", "\u{00C3}", "\u{0041}\u{0303}", "\u{00C3}", "\u{0041}\u{0303}"),
    ("\u{00C4}", "\u{00C4}", "\u{0041}\u{0308}", "\u{00C4}", "\u{0041}\u{0308}"),
    ("\u{00C5}", "\u{00C5}", "\u{0041}\u{030A}", "\u{00C5}", "\u{0041}\u{030A}"),
    ("\u{00C7}", "\u{00C7}", "\u{0043}\u{0327}", "\u{00C7}", "\u{0043}\u{0327}"),
    ("\u{00C9}", "\u{00C9}", "\u{0045}\u{0301}", "\u{00C9}", "\u{0045}\u{0301}"),
    ("\u{00CA}", "\u{00CA}", "\u{0045}\u{0302}", "\u{00CA}", "\u{0045}\u{0302}"),
    ("\u{00CB}", "\u{00CB}", "\u{0045}\u{0308}", "\u{00CB}", "\u{0045}\u{0308}"),
    ("\u{00CC}", "\u{00CC}", "\u{0049}\u{0300}", "\u{00CC}", "\u{0049}\u{0300}"),
    ("\u{00CD}", "\u{00CD}", "\u{0049}\u{0301}", "\u{00CD}", "\u{0049}\u{0301}"),
    ("\u{00CE}", "\u{00CE}", "\u{0049}\u{0302}", "\u{00CE}", "\u{0049}\u{0302}"),
    ("\u{00CF}", "\u{00CF}", "\u{0049}\u{0308}", "\u{00CF}", "\u{0049}\u{0308}"),
    ("\u{00D1}", "\u{00D1}", "\u{004E}\u{0303}", "\u{00D1}", "\u{004E}\u{0303}"),
    ("\u{00D2}", "\u{00D2}", "\u{004F}\u{0300}", "\u{00D2}", "\u{004F}\u{0300}"),
    ("\u{00D3}", "\u{00D3}", "\u{004F}\u{0301}", "\u{00D3}", "\u{004F}\u{0301}"),
    ("\u{00D4}", "\u{00D4}", "\u{004F}\u{0302}", "\u{00D4}", "\u{004F}\u{0302}"),
    ("\u{00D5}", "\u{00D5}", "\u{004F}\u{0303}", "\u{00D5}", "\u{004F}\u{0303}"),
    ("\u{00D6}", "\u{00D6}", "\u{004F}\u{0308}", "\u{00D6}", "\u{004F}\u{0308}"),
    ("\u{00D9}", "\u{00D9}", "\u{0055}\u{0300}", "\u{00D9}", "\u{0055}\u{0300}"),
    ("\u{00DA}", "\u{00DA}", "\u{0055}\u{0301}", "\u{00DA}", "\u{0055}\u{0301}"),
    ("\u{00DB}", "\u{00DB}", "\u{0055}\u{0302}", "\u{00DB}", "\u{0055}\u{0302}"),
    ("\u{00DC}", "\u{00DC}", "\u{0055}\u{0308}", "\u{00DC}", "\u{0055}\u{0308}"),
    ("\u{00DD}", "\u{00DD}", "\u{0059}\u{0301}", "\u{00DD}", "\u{0059}\u{0301}"),
    ("\u{00E0}", "\u{00E0}", "\u{0061}\u{0300}", "\u{00E0}", "\u{0061}\u{0300}"),
    ("\u{00E1}", "\u{00E1}", "\u{0061}\u{0301}", "\u{00E1}", "\u{0061}\u{0301}"),
    ("\u{00E2}", "\u{00E2}", "\u{0061}\u{0302}", "\u{00E2}", "\u{0061}\u{0302}"),
    ("\u{00E3}", "\u{00E3}", "\u{0061}\u{0303}", "\u{00E3}", "\u{0061}\u{0303}"),
    ("\u{00E4}", "\u{00E4}", "\u{0061}\u{0308}", "\u{00E4}", "\u{0061}\u{0308}"),
    ("\u{00E5}", "\u{00E5}", "\u{0061}\u{030A}", "\u{00E5}", "\u{0061}\u{030A}"),
    ("\u{00E7}", "\u{00E7}", "\u{0063}\u{0327}", "\u{00E7}", "\u{0063}\u{0327}"),
    ("\u{00E8}", "\u{00E8}", "\u{0065}\u{0300}", "\u{00E8}", "\u{0065}\u{0300}"),
    ("\u{00E9}", "\u{00E9}", "\u{0065}\u{0301}", "\u{00E9}", "\u{0065}\u{0301}"),
    ("\u{00EA}", "\u{00EA}", "\u{0065}\u{0302}", "\u{00EA}", "\u{0065}\u{0302}"),
    ("\u{00EB}", "\u{00EB}", "\u{0065}\u{0308}", "\u{00EB}", "\u{0065}\u{0308}"),
    ("\u{00EC}", "\u{00EC}", "\u{0069}\u{0300}", "\u{00EC}", "\u{0069}\u{0300}"),
    ("\u{00ED}", "\u{00ED}", "\u{0069}\u{0301}", "\u{00ED}", "\u{0069}\u{0301}"),
    ("\u{00EE}", "\u{00EE}", "\u{0069}\u{0302}", "\u{00EE}", "\u{0069}\u{0302}"),
    ("\u{00EF}", "\u{00EF}", "\u{0069}\u{0308}", "\u{00EF}", "\u{0069}\u{0308}"),
    ("\u{00F1}", "\u{00F1}", "\u{006E}\u{0303}", "\u{00F1}", "\u{006E}\u{0303}"),
    ("\u{00F2}", "\u{00F2}", "\u{006F}\u{0300}", "\u{00F2}", "\u{006F}\u{0300}"),
    ("\u{00F3}", "\u{00F3}", "\u{006F}\u{0301}", "\u{00F3}", "\u{006F}\u{0301}"),
    ("\u{00F4}", "\u{00F4}", "\u{006F}\u{0302}", "\u{00F4}", "\u{006F}\u{0302}"),
    ("\u{00F5}", "\u{00F5}", "\u{006F}\u{0303}", "\u{00F5}", "\u{006F}\u{0303}"),
    ("\u{00F6}", "\u{00F6}", "\u{006F}\u{0308}", "\u{00F6}", "\u{006F}\u{0308}"),
    ("\u{00F9}", "\u{00F9}", "\u{0075}\u{0300}", "\u{00F9}", "\u{0075}\u{0300}"),
    ("\u{00FA}", "\u{00FA}", "\u{0075}\u{0301}", "\u{00FA}", "\u{0075}\u{0301}"),
    ("\u{00FB}", "\u{00FB}", "\u{0075}\u{0302}", "\u{00FB}", "\u{0075}\u{0302}"),
    ("\u{00FC}", "\u{00FC}", "\u{0075}\u{0308}", "\u{00FC}", "\u{0075}\u{0308}"),
    ("\u{00FD}", "\u{00FD}", "\u{0079}\u{0301}", "\u{00FD}", "\u{0079}\u{0301}"),
    ("\u{00FF}", "\u{00FF}", "\u{0079}\u{0308}", "\u{00FF}", "\u{0079}\u{0308}"),
    ("\u{0100}", "\u{0100}", "\u{0041}\u{0304}", "\u{0100}", "\u{0041}\u{0304}"),
    ("\u{0101}", "\u{0101}", "\u{0061}\u{0304}", "\u{0101}", "\u{0061}\u{0304}"),
    ("\u{0102}", "\u{0102}", "\u{0041}\u{0306}", "\u{0102}", "\u{0041}\u{0306}"),
    ("\u{0103}", "\u{0103}", "\u{0061}\u{0306}", "\u{0103}", "\u{0061}\u{0306}"),
    ("\u{0104}", "\u{0104}", "\u{0041}\u{0328}", "\u{0104}", "\u{0041}\u{0328}"),
    ("\u{0105}", "\u{0105}", "\u{0061}\u{0328}", "\u{0105}", "\u{0061}\u{0328}"),
    ("\u{0106}", "\u{0106}", "\u{0043}\u{0301}", "\u{0106}", "\u{0043}\u{0301}"),
    ("\u{0107}", "\u{0107}", "\u{0063}\u{0301}", "\u{0107}", "\u{0063}\u{0301}"),
    ("\u{0108}", "\u{0108}", "\u{0043}\u{0302}", "\u{0108}", "\u{0043}\u{0302}"),
    ("\u{0109}", "\u{0109}", "\u{0063}\u{0302}", "\u{0109}", "\u{0063}\u{0302}"),
    ("\u{010A}", "\u{010A}", "\u{0043}\u{0307}", "\u{010A}", "\u{0043}\u{0307}"),
    ("\u{010B}", "\u{010B}", "\u{0063}\u{0307}", "\u{010B}", "\u{0063}\u{0307}"),
    ("\u{010C}", "\u{010C}", "\u{0043}\u{030C}", "\u{010C}", "\u{0043}\u{030C}"),
    ("\u{010D}", "\u{010D}", "\u{0063}\u{030C}", "\u{010D}", "\u{0063}\u{030C}"),
    ("\u{010E}", "\u{010E}", "\u{0044}\u{030C}", "\u{010E}", "\u{0044}\u{030C}"),
    ("\u{010F}", "\u{010F}", "\u{0064}\u{030C}", "\u{010F}", "\u{0064}\u{030C}"),
    ("\u{0113}", "\u{0113}", "\u{0065}\u{0304}", "\u{0113}", "\u{0065}\u{0304}"),
    ("\u{0114}", "\u{0114}", "\u{0045}\u{0306}", "\u{0114}", "\u{0045}\u{0306}"),
    ("\u{0115}", "\u{0115}", "\u{0065}\u{0306}", "\u{0115}", "\u{0065}\u{0306}"),
    ("\u{0116}", "\u{0116}", "\u{0045}\u{0307}", "\u{0116}", "\u{0045}\u{0307}"),
    ("\u{0117}", "\u{0117}", "\u{0065}\u{0307}", "\u{0117}", "\u{0065}\u{0307}"),
    ("\u{0118}", "\u{0118}", "\u{0045}\u{0328}", "\u{0118}", "\u{0045}\u{0328}"),
    ("\u{0119}", "\u{0119}", "\u{0065}\u{0328}", "\u{0119}", "\u{0065}\u{0328}"),
    ("\u{011A}", "\u{011A}", "\u{0045}\u{030C}", "\u{011A}", "\u{0045}\u{030C}"),
    ("\u{011B}", "\u{011B}", "\u{0065}\u{030C}", "\u{011B}", "\u{0065}\u{030C}"),
    ("\u{011C}", "\u{011C}", "\u{0047}\u{0302}", "\u{011C}", "\u{0047}\u{0302}"),
    ("\u{011D}", "\u{011D}", "\u{0067}\u{0302}", "\u{011D}", "\u{0067}\u{0302}"),
    ("\u{011E}", "\u{011E}", "\u{0047}\u{0306}", "\u{011E}", "\u{0047}\u{0306}"),
    ("\u{011F}", "\u{011F}", "\u{0067}\u{0306}", "\u{011F}", "\u{0067}\u{0306}"),
    ("\u{0120}", "\u{0120}", "\u{0047}\u{0307}", "\u{0120}", "\u{0047}\u{0307}"),
    ("\u{0121}", "\u{0121}", "\u{0067}\u{0307}", "\u{0121}", "\u{0067}\u{0307}"),
    ("\u{0122}", "\u{0122}", "\u{0047}\u{0327}", "\u{0122}", "\u{0047}\u{0327}"),
    ("\u{0123}", "\u{0123}", "\u{0067}\u{0327}", "\u{0123}", "\u{0067}\u{0327}"),
    ("\u{0124}", "\u{0124}", "\u{0048}\u{0302}", "\u{0124}", "\u{0048}\u{0302}"),
    ("\u{0125}", "\u{0125}", "\u{0068}\u{0302}", "\u{0125}", "\u{0068}\u{0302}"),
    ("\u{0128}", "\u{0128}", "\u{0049}\u{0303}", "\u{0128}", "\u{0049}\u{0303}"),
    ("\u{0129}", "\u{0129}", "\u{0069}\u{0303}", "\u{0129}", "\u{0069}\u{0303}"),
    ("\u{012A}", "\u{012A}", "\u{0049}\u{0304}", "\u{012A}", "\u{0049}\u{0304}"),
    ("\u{012B}", "\u{012B}", "\u{0069}\u{0304}", "\u{012B}", "\u{0069}\u{0304}"),
    ("\u{012C}", "\u{012C}", "\u{0049}\u{0306}", "\u{012C}", "\u{0049}\u{0306}"),
    ("\u{012D}", "\u{012D}", "\u{0069}\u{0306}", "\u{012D}", "\u{0069}\u{0306}"),
    ("\u{012E}", "\u{012E}", "\u{0049}\u{0328}", "\u{012E}", "\u{0049}\u{0328}"),
    ("\u{012F}", "\u{012F}", "\u{0069}\u{0328}", "\u{012F}", "\u{0069}\u{0328}"),
    ("\u{0130}", "\u{0130}", "\u{0049}\u{0307}", "\u{0130}", "\u{0049}\u{0307}"),
    ("\u{0132}", "\u{0132}", "\u{0132}", "\u{0049}\u{004A}", "\u{0049}\u{004A}"),
    ("\u{0133}", "\u{0133}", "\u{0133}", "\u{0069}\u{006A}", "\u{0069}\u{006A}"),
    ("\u{0134}", "\u{0134}", "\u{004A}\u{0302}", "\u{0134}", "\u{004A}\u{0302}"),
    ("\u{0135}", "\u{0135}", "\u{006A}\u{0302}", "\u{0135}", "\u{006A}\u{0302}"),
    ("\u{0136}", "\u{0136}", "\u{004B}\u{0327}", "\u{0136}", "\u{004B}\u{0327}"),
    ("\u{0137}", "\u{0137}", "\u{006B}\u{0327}", "\u{0137}", "\u{006B}\u{0327}"),
    ("\u{0139}", "\u{0139}", "\u{004C}\u{0301}", "\u{0139}", "\u{004C}\u{0301}"),
    ("\u{013A}", "\u{013A}", "\u{006C}\u{0301}", "\u{013A}", "\u{006C}\u{0301}"),
    ("\u{013B}", "\u{013B}", "\u{004C}\u{0327}", "\u{013B}", "\u{004C}\u{0327}"),
    ("\u{013C}", "\u{013C}", "\u{006C}\u{0327}", "\u{013C}", "\u{006C}\u{0327}"),
    ("\u{013D}", "\u{013D}", "\u{004C}\u{030C}", "\u{013D}", "\u{004C}\u{030C}"),
    ("\u{013E}", "\u{013E}", "\u{006C}\u{030C}", "\u{013E}", "\u{006C}\u{030C}"),
    ("\u{013F}", "\u{013F}", "\u{013F}", "\u{004C}\u{00B7}", "\u{004C}\u{00B7}"),
    ("\u{0140}", "\u{0140}", "\u{0140}", "\u{006C}\u{00B7}", "\u{006C}\u{00B7}"),
    ("\u{0143}", "\u{0143}", "\u{004E}\u{0301}", "\u{0143}", "\u{004E}\u{0301}"),
    ("\u{0144}", "\u{0144}", "\u{006E}\u{0301}", "\u{0144}", "\u{006E}\u{0301}"),
    ("\u{0145}", "\u{0145}", "\u{004E}\u{0327}", "\u{0145}", "\u{004E}\u{0327}"),
    ("\u{0146}", "\u{0146}", "\u{006E}\u{0327}", "\u{0146}", "\u{006E}\u{0327}"),
    ("\u{0147}", "\u{0147}", "\u{004E}\u{030C}", "\u{0147}", "\u{004E}\u{030C}"),
    ("\u{0148}", "\u{0148}", "\u{006E}\u{030C}", "\u{0148}", "\u{006E}\u{030C}"),
    ("\u{0149}", "\u{0149}", "\u{0149}", "\u{02BC}\u{006E}", "\u{02BC}\u{006E}"),
    ("\u{014C}", "\u{014C}", "\u{004F}\u{0304}", "\u{014C}", "\u{004F}\u{0304}"),
    ("\u{014D}", "\u{014D}", "\u{006F}\u{0304}", "\u{014D}", "\u{006F}\u{0304}"),
    ("\u{014E}", "\u{014E}", "\u{004F}\u{0306}", "\u{014E}", "\u{004F}\u{0306}"),
    ("\u{014F}", "\u{014F}", "\u{006F}\u{0306}", "\u{014F}", "\u{006F}\u{0306}"),
    ("\u{0150}", "\u{0150}", "\u{004F}\u{030B}", "\u{0150}", "\u{004F}\u{030B}"),
    ("\u{0151}", "\u{0151}", "\u{006F}\u{030B}", "\u{0151}", "\u{006F}\u{030B}"),
    ("\u{0154}", "\u{0154}", "\u{0052}\u{0301}", "\u{0154}", "\u{0052}\u{0301}"),
    ("\u{0155}", "\u{0155}", "\u{0072}\u{0301}", "\u{0155}", "\u{0072}\u{0301}"),
    ("\u{0156}", "\u{0156}", "\u{0052}\u{0327}", "\u{0156}", "\u{0052}\u{0327}"),
    ("\u{0157}", "\u{0157}", "\u{0072}\u{0327}", "\u{0157}", "\u{0072}\u{0327}"),
    ("\u{0158}", "\u{0158}", "\u{0052}\u{030C}", "\u{0158}", "\u{0052}\u{030C}"),
    ("\u{0159}", "\u{0159}", "\u{0072}\u{030C}", "\u{0159}", "\u{0072}\u{030C}"),
    ("\u{015A}", "\u{015A}", "\u{0053}\u{0301}", "\u{015A}", "\u{0053}\u{0301}"),
    ("\u{015B}", "\u{015B}", "\u{0073}\u{0301}", "\u{015B}", "\u{0073}\u{0301}"),
    ("\u{015C}", "\u{015C}", "\u{0053}\u{0302}", "\u{015C}", "\u{0053}\u{0302}"),
    ("\u{015D}", "\u{015D}", "\u{0073}\u{0302}", "\u{015D}", "\u{0073}\u{0302}"),
    ("\u{015E}", "\u{015E}", "\u{0053}\u{0327}", "\u{015E}", "\u{0053}\u{0327}"),
    ("\u{015F}", "\u{015F}", "\u{0073}\u{0327}", "\u{015F}", "\u{0073}\u{0327}"),
    ("\u{0160}", "\u{0160}", "\u{0053}\u{030C}", "\u{0160}", "\u{0053}\u{030C}"),
    ("\u{0161}", "\u{0161}", "\u{0073}\u{030C}", "\u{0161}", "\u{0073}\u{030C}"),
    ("\u{0162}", "\u{0162}", "\u{0054}\u{0327}", "\u{0162}", "\u{0054}\u{0327}"),
    ("\u{0163}", "\u{0163}", "\u{0074}\u{0327}", "\u{0163}", "\u{0074}\u{0327}"),
    ("\u{0164}", "\u{0164}", "\u{0054}\u{030C}", "\u{0164}", "\u{0054}\u{030C}"),
    ("\u{0165}", "\u{0165}", "\u{0074}\u{030C}", "\u{0165}", "\u{0074}\u{030C}"),
    ("\u{0168}", "\u{0168}", "\u{0055}\u{0303}", "\u{0168}", "\u{0055}\u{0303}"),
    ("\u{0169}", "\u{0169}", "\u{0075}\u{0303}", "\u{0169}", "\u{0075}\u{0303}"),
    ("\u{016A}", "\u{016A}", "\u{0055}\u{0304}", "\u{016A}", "\u{0055}\u{0304}"),
    ("\u{016B}", "\u{016B}", "\u{0075}\u{0304}", "\u{016B}", "\u{0075}\u{0304}"),
    ("\u{016C}", "\u{016C}", "\u{0055}\u{0306}", "\u{016C}", "\u{0055}\u{0306}"),
    ("\u{016D}", "\u{016D}", "\u{0075}\u{0306}", "\u{016D}", "\u{0075}\u{0306}"),
    ("\u{016E}", "\u{016E}", "\u{0055}\u{030A}", "\u{016E}", "\u{0055}\u{030A}"),
    ("\u{016F}", "\u{016F}", "\u{0075}\u{030A}", "\u{016F}", "\u{0075}\u{030A}"),
    ("\u{0170}", "\u{0170}", "\u{0055}\u{030B}", "\u{0170}", "\u{0055}\u{030B}"),
    ("\u{0171}", "\u{0171}", "\u{0075}\u{030B}", "\u{0171}", "\u{0075}\u{030B}"),
    ("\u{0172}", "\u{0172}", "\u{0055}\u{0328}", "\u{0172}", "\u{0055}\u{0328}"),
    ("\u{0173}", "\u{0173}", "\u{0075}\u{0328}", "\u{0173}", "\u{0075}\u{0328}"),
    ("\u{0174}", "\u{0174}", "\u{0057}\u{0302}", "\u{0174}", "\u{0057}\u{0302}"),
    ("\u{0175}", "\u{0175}", "\u{0077}\u{0302}", "\u{0175}", "\u{0077}\u{0302}"),
    ("\u{0176}", "\u{0176}", "\u{0059}\u{0302}", "\u{0176}", "\u{0059}\u{0302}"),
    ("\u{0177}", "\u{0177}", "\u{0079}\u{0302}", "\u{0177}", "\u{0079}\u{0302}"),
    ("\u{0178}", "\u{0178}", "\u{0059}\u{0308}", "\u{0178}", "\u{0059}\u{0308}"),
    ("\u{0179}", "\u{0179}", "\u{005A}\u{0301}", "\u{0179}", "\u{005A}\u{0301}"),
    ("\u{017A}", "\u{017A}", "\u{007A}\u{0301}", "\u{017A}", "\u{007A}\u{0301}"),
    ("\u{017B}", "\u{017B}", "\u{005A}\u{0307}", "\u{017B}", "\u{005A}\u{0307}"),
    ("\u{017C}", "\u{017C}", "\u{007A}\u{0307}", "\u{017C}", "\u{007A}\u{0307}"),
    ("\u{017D}", "\u{017D}", "\u{005A}\u{030C}", "\u{017D}", "\u{005A}\u{030C}"),
    ("\u{017E}", "\u{017E}", "\u{007A}\u{030C}", "\u{017E}", "\u{007A}\u{030C}"),
    ("\u{017F}", "\u{017F}", "\u{017F}", "\u{0073}", "\u{0073}"),
    ("\u{01A0}", "\u{01A0}", "\u{004F}\u{031B}", "\u{01A0}", "\u{004F}\u{031B}"),
    ("\u{01A1}", "\u{01A1}", "\u{006F}\u{031B}", "\u{01A1}", "\u{006F}\u{031B}"),
    ("\u{01AF}", "\u{01AF}", "\u{0055}\u{031B}", "\u{01AF}", "\u{0055}\u{031B}"),
    ("\u{01B0}", "\u{01B0}", "\u{0075}\u{031B}", "\u{01B0}", "\u{0075}\u{031B}"),
    ("\u{01C4}", "\u{01C4}", "\u{01C4}", "\u{0044}\u{017D}", "\u{0044}\u{005A}\u{030C}"),
    ("\u{01C5}", "\u{01C5}", "\u{01C5}", "\u{0044}\u{017E}", "\u{0044}\u{007A}\u{030C}"),
    ("\u{01C6}", "\u{01C6}", "\u{01C6}", "\u{0064}\u{017E}", "\u{0064}\u{007A}\u{030C}"),
    ("\u{01C7}", "\u{01C7}", "\u{01C7}", "\u{004C}\u{004A}", "\u{004C}\u{004A}"),
    ("\u{01C8}", "\u{01C8}", "\u{01C8}", "\u{004C}\u{006A}", "\u{004C}\u{006A}"),
    ("\u{01C9}", "\u{01C9}", "\u{01C9}", "\u{006C}\u{006A}", "\u{006C}\u{006A}"),
    ("\u{01CA}", "\u{01CA}", "\u{01CA}", "\u{004E}\u{004A}", "\u{004E}\u{004A}"),
    ("\u{01CB}", "\u{01CB}", "\u{01CB}", "\u{004E}\u{006A}", "\u{004E}\u{006A}"),
    ("\u{01CC}", "\u{01CC}", "\u{01CC}", "\u{006E}\u{006A}", "\u{006E}\u{006A}"),
    ("\u{01CD}", "\u{01CD}", "\u{0041}\u{030C}", "\u{01CD}", "\u{0041}\u{030C}"),
    ("\u{01CE}", "\u{01CE}", "\u{0061}\u{030C}", "\u{01CE}", "\u{0061}\u{030C}"),
    ("\u{01CF}", "\u{01CF}", "\u{0049}\u{030C}", "\u{01CF}", "\u{0049}\u{030C}"),
    ("\u{01D0}", "\u{01D0}", "\u{0069}\u{030C}", "\u{01D0}", "\u{0069}\u{030C}"),
    ("\u{01D1}", "\u{01D1}", "\u{004F}\u{030C}", "\u{01D1}", "\u{004F}\u{030C}"),
    ("\u{01D2}", "\u{01D2}", "\u{006F}\u{030C}", "\u{01D2}", "\u{006F}\u{030C}"),
    ("\u{01D3}", "\u{01D3}", "\u{0055}\u{030C}", "\u{01D3}", "\u{0055}\u{030C}"),
    ("\u{01D4}", "\u{01D4}", "\u{0075}\u{030C}", "\u{01D4}", "\u{0075}\u{030C}"),
    ("\u{01D5}", "\u{01D5}", "\u{0055}\u{0308}\u{0304}", "\u{01D5}", "\u{0055}\u{0308}\u{0304}"),
    ("\u{01D6}", "\u{01D6}", "\u{0075}\u{0308}\u{0304}", "\u{01D6}", "\u{0075}\u{0308}\u{0304}"),
    ("\u{01D7}", "\u{01D7}", "\u{0055}\u{0308}\u{0301}", "\u{01D7}", "\u{0055}\u{0308}\u{0301}"),
    ("\u{01D8}", "\u{01D8}", "\u{0075}\u{0308}\u{0301}", "\u{01D8}", "\u{0075}\u{0308}\u{0301}"),
    ("\u{01D9}", "\u{01D9}", "\u{0055}\u{0308}\u{030C}", "\u{01D9}", "\u{0055}\u{0308}\u{030C}"),
    ("\u{01DA}", "\u{01DA}", "\u{0075}\u{0308}\u{030C}", "\u{01DA}", "\u{0075}\u{0308}\u{030C}"),
    ("\u{01DB}", "\u{01DB}", "\u{0055}\u{0308}\u{0300}", "\u{01DB}", "\u{0055}\u{0308}\u{0300}"),
    ("\u{01DC}", "\u{01DC}", "\u{0075}\u{0308}\u{0300}", "\u{01DC}", "\u{0075}\u{0308}\u{0300}"),
    ("\u{01DE}", "\u{01DE}", "\u{0041}\u{0308}\u{0304}", "\u{01DE}", "\u{0041}\u{0308}\u{0304}"),
    ("\u{01DF}", "\u{01DF}", "\u{0061}\u{0308}\u{0304}", "\u{01DF}", "\u{0061}\u{0308}\u{0304}"),
    ("\u{01E0}", "\u{01E0}", "\u{0041}\u{0307}\u{0304}", "\u{01E0}", "\u{0041}\u{0307}\u{0304}"),
    ("\u{01E1}", "\u{01E1}", "\u{0061}\u{0307}\u{0304}", "\u{01E1}", "\u{0061}\u{0307}\u{0304}"),
    ("\u{01E2}", "\u{01E2}", "\u{00C6}\u{0304}", "\u{01E2}", "\u{00C6}\u{0304}"),
    ("\u{01E3}", "\u{01E3}", "\u{00E6}\u{0304}", "\u{01E3}", "\u{00E6}\u{0304}"),
    ("\u{01E6}", "\u{01E6}", "\u{0047}\u{030C}", "\u{01E6}", "\u{0047}\u{030C}"),
    ("\u{01E7}", "\u{01E7}", "\u{0067}\u{030C}", "\u{01E7}", "\u{0067}\u{030C}"),
    ("\u{01E8}", "\u{01E8}", "\u{004B}\u{030C}", "\u{01E8}", "\u{004B}\u{030C}"),
    ("\u{01E9}", "\u{01E9}", "\u{006B}\u{030C}", "\u{01E9}", "\u{006B}\u{030C}"),
    ("\u{01EA}", "\u{01EA}", "\u{004F}\u{0328}", "\u{01EA}", "\u{004F}\u{0328}"),
    ("\u{01EB}", "\u{01EB}", "\u{006F}\u{0328}", "\u{01EB}", "\u{006F}\u{0328}"),
    ("\u{01EC}", "\u{01EC}", "\u{004F}\u{0328}\u{0304}", "\u{01EC}", "\u{004F}\u{0328}\u{0304}"),
    ("\u{01ED}", "\u{01ED}", "\u{006F}\u{0328}\u{0304}", "\u{01ED}", "\u{006F}\u{0328}\u{0304}"),
    ("\u{01EE}", "\u{01EE}", "\u{01B7}\u{030C}", "\u{01EE}", "\u{01B7}\u{030C}"),
    ("\u{01EF}", "\u{01EF}", "\u{0292}\u{030C}", "\u{01EF}", "\u{0292}\u{030C}"),
    ("\u{01F0}", "\u{01F0}", "\u{006A}\u{030C}", "\u{01F0}", "\u{006A}\u{030C}"),
    ("\u{01F1}", "\u{01F1}", "\u{01F1}", "\u{0044}\u{005A}", "\u{0044}\u{005A}"),
    ("\u{01F2}", "\u{01F2}", "\u{01F2}", "\u{0044}\u{007A}", "\u{0044}\u{007A}"),
    ("\u{01F3}", "\u{01F3}", "\u{01F3}", "\u{0064}\u{007A}", "\u{0064}\u{007A}"),
    ("\u{01F4}", "\u{01F4}", "\u{0047}\u{0301}", "\u{01F4}", "\u{0047}\u{0301}"),
    ("\u{01F5}", "\u{01F5}", "\u{0067}\u{0301}", "\u{01F5}", "\u{0067}\u{0301}"),
    ("\u{01F8}", "\u{01F8}", "\u{004E}\u{0300}", "\u{01F8}", "\u{004E}\u{0300}"),
    ("\u{01F9}", "\u{01F9}", "\u{006E}\u{0300}", "\u{01F9}", "\u{006E}\u{0300}"),
    ("\u{01FA}", "\u{01FA}", "\u{0041}\u{030A}\u{0301}", "\u{01FA}", "\u{0041}\u{030A}\u{0301}"),
    ("\u{01FB}", "\u{01FB}", "\u{0061}\u{030A}\u{0301}", "\u{01FB}", "\u{0061}\u{030A}\u{0301}"),
    ("\u{01FC}", "\u{01FC}", "\u{00C6}\u{0301}", "\u{01FC}", "\u{00C6}\u{0301}"),
    ("\u{01FD}", "\u{01FD}", "\u{00E6}\u{0301}", "\u{01FD}", "\u{00E6}\u{0301}"),
    ("\u{01FE}", "\u{01FE}", "\u{00D8}\u{0301}", "\u{01FE}", "\u{00D8}\u{0301}"),
    ("\u{01FF}", "\u{01FF}", "\u{00F8}\u{0301}", "\u{01FF}", "\u{00F8}\u{0301}"),
    ("\u{0200}", "\u{0200}", "\u{0041}\u{030F}", "\u{0200}", "\u{0041}\u{030F}"),
    ("\u{0201}", "\u{0201}", "\u{0061}\u{030F}", "\u{0201}", "\u{0061}\u{030F}"),
    ("\u{0202}", "\u{0202}", "\u{0041}\u{0311}", "\u{0202}", "\u{0041}\u{0311}"),
    ("\u{0203}", "\u{0203}", "\u{0061}\u{0311}", "\u{0203}", "\u{0061}\u{0311}"),
    ("\u{0204}", "\u{0204}", "\u{0045}\u{030F}", "\u{0204}", "\u{0045}\u{030F}"),
    ("\u{0205}", "\u{0205}", "\u{0065}\u{030F}", "\u{0205}", "\u{0065}\u{030F}"),
    ("\u{0206}", "\u{0206}", "\u{0045}\u{0311}", "\u{0206}", "\u{0045}\u{0311}"),
    ("\u{0207}", "\u{0207}", "\u{0065}\u{0311}", "\u{0207}", "\u{0065}\u{0311}"),
    ("\u{0208}", "\u{0208}", "\u{0049}\u{030F}", "\u{0208}", "\u{0049}\u{030F}"),
    ("\u{0209}", "\u{0209}", "\u{0069}\u{030F}", "\u{0209}", "\u{0069}\u{030F}"),
    ("\u{020A}", "\u{020A}", "\u{0049}\u{0311}", "\u{020A}", "\u{0049}\u{0311}"),
    ("\u{020B}", "\u{020B}", "\u{0069}\u{0311}", "\u{020B}", "\u{0069}\u{0311}"),
    ("\u{020C}", "\u{020C}", "\u{004F}\u{030F}", "\u{020C}", "\u{004F}\u{030F}"),
    ("\u{020D}", "\u{020D}", "\u{006F}\u{030F}", "\u{020D}", "\u{006F}\u{030F}"),
    ("\u{020E}", "\u{020E}", "\u{004F}\u{0311}", "\u{020E}", "\u{004F}\u{0311}"),
    ("\u{020F}", "\u{020F}", "\u{006F}\u{0311}", "\u{020F}", "\u{006F}\u{0311}"),
    ("\u{0210}", "\u{0210}", "\u{0052}\u{030F}", "\u{0210}", "\u{0052}\u{030F}"),
    ("\u{0211}", "\u{0211}", "\u{0072}\u{030F}", "\u{0211}", "\u{0072}\u{030F}"),
    ("\u{0212}", "\u{0212}", "\u{0052}\u{0311}", "\u{0212}", "\u{0052}\u{0311}"),
    ("\u{0213}", "\u{0213}", "\u{0072}\u{0311}", "\u{0213}", "\u{0072}\u{0311}"),
    ("\u{0214}", "\u{0214}", "\u{0055}\u{030F}", "\u{0214}", "\u{0055}\u{030F}"),
    ("\u{0215}", "\u{0215}", "\u{0075}\u{030F}", "\u{0215}", "\u{0075}\u{030F}"),
    ("\u{0216}", "\u{0216}", "\u{0055}\u{0311}", "\u{0216}", "\u{0055}\u{0311}"),
    ("\u{0217}", "\u{0217}", "\u{0075}\u{0311}", "\u{0217}", "\u{0075}\u{0311}"),
    ("\u{0218}", "\u{0218}", "\u{0053}\u{0326}", "\u{0218}", "\u{0053}\u{0326}"),
    ("\u{0219}", "\u{0219}", "\u{0073}\u{0326}", "\u{0219}", "\u{0073}\u{0326}"),
    ("\u{021A}", "\u{021A}", "\u{0054}\u{0326}", "\u{021A}", "\u{0054}\u{0326}"),
    ("\u{021B}", "\u{021B}", "\u{0074}\u{0326}", "\u{021B}", "\u{0074}\u{0326}"),
    ("\u{021E}", "\u{021E}", "\u{0048}\u{030C}", "\u{021E}", "\u{0048}\u{030C}"),
    ("\u{021F}", "\u{021F}", "\u{0068}\u{030C}", "\u{021F}", "\u{0068}\u{030C}"),
    ("\u{0226}", "\u{0226}", "\u{0041}\u{0307}", "\u{0226}", "\u{0041}\u{0307}"),
    ("\u{0227}", "\u{0227}", "\u{0061}\u{0307}", "\u{0227}", "\u{0061}\u{0307}"),
    ("\u{0228}", "\u{0228}", "\u{0045}\u{0327}", "\u{0228}", "\u{0045}\u{0327}"),
    ("\u{0229}", "\u{0229}", "\u{0065}\u{0327}", "\u{0229}", "\u{0065}\u{0327}"),
    ("\u{022A}", "\u{022A}", "\u{004F}\u{0308}\u{0304}", "\u{022A}", "\u{004F}\u{0308}\u{0304}"),
    ("\u{022B}", "\u{022B}", "\u{006F}\u{0308}\u{0304}", "\u{022B}", "\u{006F}\u{0308}\u{0304}"),
    ("\u{022C}", "\u{022C}", "\u{004F}\u{0303}\u{0304}", "\u{022C}", "\u{004F}\u{0303}\u{0304}"),
    ("\u{022D}", "\u{022D}", "\u{006F}\u{0303}\u{0304}", "\u{022D}", "\u{006F}\u{0303}\u{0304}"),
    ("\u{022E}", "\u{022E}", "\u{004F}\u{0307}", "\u{022E}", "\u{004F}\u{0307}"),
    ("\u{022F}", "\u{022F}", "\u{006F}\u{0307}", "\u{022F}", "\u{006F}\u{0307}"),
    ("\u{0230}", "\u{0230}", "\u{004F}\u{0307}\u{0304}", "\u{0230}", "\u{004F}\u{0307}\u{0304}"),
    ("\u{0231}", "\u{0231}", "\u{006F}\u{0307}\u{0304}", "\u{0231}", "\u{006F}\u{0307}\u{0304}"),
    ("\u{0232}", "\u{0232}", "\u{0059}\u{0304}", "\u{0232}", "\u{0059}\u{0304}"),
    ("\u{0233}", "\u{0233}", "\u{0079}\u{0304}", "\u{0233}", "\u{0079}\u{0304}"),
    ("\u{02B0}", "\u{02B0}", "\u{02B0}", "\u{0068}", "\u{0068}"),
    ("\u{02B1}", "\u{02B1}", "\u{02B1}", "\u{0266}", "\u{0266}"),
    ("\u{02B2}", "\u{02B2}", "\u{02B2}", "\u{006A}", "\u{006A}"),
    ("\u{02B3}", "\u{02B3}", "\u{02B3}", "\u{0072}", "\u{0072}"),
    ("\u{02B4}", "\u{02B4}", "\u{02B4}", "\u{0279}", "\u{0279}"),
    ("\u{02B5}", "\u{02B5}", "\u{02B5}", "\u{027B}", "\u{027B}"),
    ("\u{02B6}", "\u{02B6}", "\u{02B6}", "\u{0281}", "\u{0281}"),
    ("\u{02B7}", "\u{02B7}", "\u{02B7}", "\u{0077}", "\u{0077}"),
    ("\u{02B8}", "\u{02B8}", "\u{02B8}", "\u{0079}", "\u{0079}"),
    ("\u{02D8}", "\u{02D8}", "\u{02D8}", "\u{0020}\u{0306}", "\u{0020}\u{0306}"),
    ("\u{02D9}", "\u{02D9}", "\u{02D9}", "\u{0020}\u{0307}", "\u{0020}\u{0307}"),
    ("\u{02DA}", "\u{02DA}", "\u{02DA}", "\u{0020}\u{030A}", "\u{0020}\u{030A}"),
    ("\u{02DB}", "\u{02DB}", "\u{02DB}", "\u{0020}\u{0328}", "\u{0020}\u{0328}"),
    ("\u{02DC}", "\u{02DC}", "\u{02DC}", "\u{0020}\u{0303}", "\u{0020}\u{0303}"),
    ("\u{02DD}", "\u{02DD}", "\u{02DD}", "\u{0020}\u{030B}", "\u{0020}\u{030B}"),
    ("\u{02E0}", "\u{02E0}", "\u{02E0}", "\u{0263}", "\u{0263}"),
    ("\u{02E1}", "\u{02E1}", "\u{02E1}", "\u{006C}", "\u{006C}"),
    ("\u{02E2}", "\u{02E2}", "\u{02E2}", "\u{0073}", "\u{0073}"),
    ("\u{02E3}", "\u{02E3}", "\u{02E3}", "\u{0078}", "\u{0078}"),
    ("\u{02E4}", "\u{02E4}", "\u{02E4}", "\u{0295}", "\u{0295}"),
    ("\u{0340}", "\u{0300}", "\u{0300}", "\u{0300}", "\u{0300}"),
    ("\u{0341}", "\u{0301}", "\u{0301}", "\u{0301}", "\u{0301}"),
    ("\u{0343}", "\u{0313}", "\u{0313}", "\u{0313}", "\u{0313}"),
    ("\u{0344}", "\u{0308}\u{0301}", "\u{0308}\u{0301}", "\u{0308}\u{0301}", "\u{0308}\u{0301}"),
    ("\u{0374}", "\u{02B9}", "\u{02B9}", "\u{02B9}", "\u{02B9}"),
    ("\u{037A}", "\u{037A}", "\u{037A}", "\u{0020}\u{0345}", "\u{0020}\u{0345}"),
    ("\u{037E}", "\u{003B}", "\u{003B}", "\u{003B}", "\u{003B}"),
    ("\u{0384}", "\u{0384}", "\u{0384}", "\u{0020}\u{0301}", "\u{0020}\u{0301}"),
    ("\u{0385}", "\u{0385}", "\u{00A8}\u{0301}", "\u{0020}\u{0308}\u{0301}", "\u{0020}\u{0308}\u{0301}"),
    ("\u{0386}", "\u{0386}", "\u{0391}\u{0301}", "\u{0386}", "\u{0391}\u{0301}"),
    ("\u{0387}", "\u{00B7}", "\u{00B7}", "\u{00B7}", "\u{00B7}"),
    ("\u{0388}", "\u{0388}", "\u{0395}\u{0301}", "\u{0388}", "\u{0395}\u{0301}"),
    ("\u{0389}", "\u{0389}", "\u{0397}\u{0301}", "\u{0389}", "\u{0397}\u{0301}"),
    ("\u{038A}", "\u{038A}", "\u{0399}\u{0301}", "\u{038A}", "\u{0399}\u{0301}"),
    ("\u{038C}", "\u{038C}", "\u{039F}\u{0301}", "\u{038C}", "\u{039F}\u{0301}"),
    ("\u{038E}", "\u{038E}", "\u{03A5}\u{0301}", "\u{038E}", "\u{03A5}\u{0301}"),
    ("\u{038F}", "\u{038F}", "\u{03A9}\u{0301}", "\u{038F}", "\u{03A9}\u{0301}"),
    ("\u{0390}", "\u{0390}", "\u{03B9}\u{0308}\u{0301}", "\u{0390}", "\u{03B9}\u{0308}\u{0301}"),
    ("\u{03AA}", "\u{03AA}", "\u{0399}\u{0308}", "\u{03AA}", "\u{0399}\u{0308}"),
    ("\u{03AB}", "\u{03AB}", "\u{03A5}\u{0308}", "\u{03AB}", "\u{03A5}\u{0308}"),
    ("\u{03AC}", "\u{03AC}", "\u{03B1}\u{0301}", "\u{03AC}", "\u{03B1}\u{0301}"),
    ("\u{03AD}", "\u{03AD}", "\u{03B5}\u{0301}", "\u{03AD}", "\u{03B5}\u{0301}"),
    ("\u{03AE}", "\u{03AE}", "\u{03B7}\u{0301}", "\u{03AE}", "\u{03B7}\u{0301}"),
    ("\u{03AF}", "\u{03AF}", "\u{03B9}\u{0301}", "\u{03AF}", "\u{03B9}\u{0301}"),
    ("\u{03B0}", "\u{03B0}", "\u{03C5}\u{0308}\u{0301}", "\u{03B0}", "\u{03C5}\u{0308}\u{0301}"),
    ("\u{03CA}", "\u{03CA}", "\u{03B9}\u{0308}", "\u{03CA}", "\u{03B9}\u{0308}"),
    ("\u{03CB}", "\u{03CB}", "\u{03C5}\u{0308}", "\u{03CB}", "\u{03C5}\u{0308}"),
    ("\u{03CC}", "\u{03CC}", "\u{03BF}\u{0301}", "\u{03CC}", "\u{03BF}\u{0301}"),
    ("\u{03CD}", "\u{03CD}", "\u{03C5}\u{0301}", "\u{03CD}", "\u{03C5}\u{0301}"),
    ("\u{03CE}", "\u{03CE}", "\u{03C9}\u{0301}", "\u{03CE}", "\u{03C9}\u{0301}"),
    ("\u{03D0}", "\u{03D0}", "\u{03D0}", "\u{03B2}", "\u{03B2}"),
    ("\u{03D1}", "\u{03D1}", "\u{03D1}", "\u{03B8}", "\u{03B8}"),
    ("\u{03D2}", "\u{03D2}", "\u{03D2}", "\u{03A5}", "\u{03A5}"),
    ("\u{03D3}", "\u{03D3}", "\u{03D2}\u{0301}", "\u{038E}", "\u{03A5}\u{0301}"),
    ("\u{03D4}", "\u{03D4}", "\u{03D2}\u{0308}", "\u{03AB}", "\u{03A5}\u{0308}"),
    ("\u{03D5}", "\u{03D5}", "\u{03D5}", "\u{03C6}", "\u{03C6}"),
    ("\u{03D6}", "\u{03D6}", "\u{03D6}", "\u{03C0}", "\u{03C0}"),
    ("\u{03F0}", "\u{03F0}", "\u{03F0}", "\u{03BA}", "\u{03BA}"),
    ("\u{03F1}", "\u{03F1}", "\u{03F1}", "\u{03C1}", "\u{03C1}"),
    ("\u{03F2}", "\u{03F2}", "\u{03F2}", "\u{03C2}", "\u{03C2}"),
    ("\u{03F4}", "\u{03F4}", "\u{03F4}", "\u{0398}", "\u{0398}"),
    ("\u{03F5}", "\u{03F5}", "\u{03F5}", "\u{03B5}", "\u{03B5}"),
    ("\u{03F9}", "\u{03F9}", "\u{03F9}", "\u{03A3}", "\u{03A3}"),
    ("\u{0400}", "\u{0400}", "\u{0415}\u{0300}", "\u{0400}", "\u{0415}\u{0300}"),
    ("\u{0401}", "\u{0401}", "\u{0415}\u{0308}", "\u{0401}", "\u{0415}\u{0308}"),
    ("\u{0403}", "\u{0403}", "\u{0413}\u{0301}", "\u{0403}", "\u{0413}\u{0301}"),
    ("\u{0407}", "\u{0407}", "\u{0406}\u{0308}", "\u{0407}", "\u{0406}\u{0308}"),
    ("\u{040C}", "\u{040C}", "\u{041A}\u{0301}", "\u{040C}", "\u{041A}\u{0301}"),
    ("\u{040D}", "\u{040D}", "\u{0418}\u{0300}", "\u{040D}", "\u{0418}\u{0300}"),
    ("\u{040E}", "\u{040E}", "\u{0423}\u{0306}", "\u{040E}", "\u{0423}\u{0306}"),
    ("\u{0419}", "\u{0419}", "\u{0418}\u{0306}", "\u{0419}", "\u{0418}\u{0306}"),
    ("\u{0439}", "\u{0439}", "\u{0438}\u{0306}", "\u{0439}", "\u{0438}\u{0306}"),
    ("\u{0450}", "\u{0450}", "\u{0435}\u{0300}", "\u{0450}", "\u{0435}\u{0300}"),
    ("\u{0451}", "\u{0451}", "\u{0435}\u{0308}", "\u{0451}", "\u{0435}\u{0308}"),
    ("\u{0453}", "\u{0453}", "\u{0433}\u{0301}", "\u{0453}", "\u{0433}\u{0301}"),
    ("\u{0457}", "\u{0457}", "\u{0456}\u{0308}", "\u{0457}", "\u{0456}\u{0308}"),
    ("\u{045C}", "\u{045C}", "\u{043A}\u{0301}", "\u{045C}", "\u{043A}\u{0301}"),
    ("\u{045D}", "\u{045D}", "\u{0438}\u{0300}", "\u{045D}", "\u{0438}\u{0300}"),
    ("\u{045E}", "\u{045E}", "\u{0443}\u{0306}", "\u{045E}", "\u{0443}\u{0306}"),
    ("\u{0476}", "\u{0476}", "\u{0474}\u{030F}", "\u{0476}", "\u{0474}\u{030F}"),
    ("\u{0477}", "\u{0477}", "\u{0475}\u{030F}", "\u{0477}", "\u{0475}\u{030F}"),
    ("\u{04C1}", "\u{04C1}", "\u{0416}\u{0306}", "\u{04C1}", "\u{0416}\u{0306}"),
    ("\u{04C2}", "\u{04C2}", "\u{0436}\u{0306}", "\u{04C2}", "\u{0436}\u{0306}"),
    ("\u{04D0}", "\u{04D0}", "\u{0410}\u{0306}", "\u{04D0}", "\u{0410}\u{0306}"),
    ("\u{04D1}", "\u{04D1}", "\u{0430}\u{0306}", "\u{04D1}", "\u{0430}\u{0306}"),
    ("\u{04D2}", "\u{04D2}", "\u{0410}\u{0308}", "\u{04D2}", "\u{0410}\u{0308}"),
    ("\u{04D3}", "\u{04D3}", "\u{0430}\u{0308}", "\u{04D3}", "\u{0430}\u{0308}"),
    ("\u{04D6}", "\u{04D6}", "\u{0415}\u{0306}", "\u{04D6}", "\u{0415}\u{0306}"),
    ("\u{04D7}", "\u{04D7}", "\u{0435}\u{0306}", "\u{04D7}", "\u{0435}\u{0306}"),
    ("\u{04DA}", "\u{04DA}", "\u{04D8}\u{0308}", "\u{04DA}", "\u{04D8}\u{0308}"),
    ("\u{04DB}", "\u{04DB}", "\u{04D9}\u{0308}", "\u{04DB}", "\u{04D9}\u{0308}"),
    ("\u{04DC}", "\u{04DC}", "\u{0416}\u{0308}", "\u{04DC}", "\u{0416}\u{0308}"),
    ("\u{04DD}", "\u{04DD}", "\u{0436}\u{0308}", "\u{04DD}", "\u{0436}\u{0308}"),
    ("\u{04DE}", "\u{04DE}", "\u{0417}\u{0308}", "\u{04DE}", "\u{0417}\u{0308}"),
    ("\u{04DF}", "\u{04DF}", "\u{0437}\u{0308}", "\u{04DF}", "\u{0437}\u{0308}"),
    ("\u{04E2}", "\u{04E2}", "\u{0418}\u{0304}", "\u{04E2}", "\u{0418}\u{0304}"),
    ("\u{04E3}", "\u{04E3}", "\u{0438}\u{0304}", "\u{04E3}", "\u{0438}\u{0304}"),
    ("\u{04E4}", "\u{04E4}", "\u{0418}\u{0308}", "\u{04E4}", "\u{0418}\u{0308}"),
    ("\u{04E5}", "\u{04E5}", "\u{0438}\u{0308}", "\u{04E5}", "\u{0438}\u{0308}"),
    ("\u{04E6}", "\u{04E6}", "\u{041E}\u{0308}", "\u{04E6}", "\u{041E}\u{0308}"),
    ("\u{04E7}", "\u{04E7}", "\u{043E}\u{0308}", "\u{04E7}", "\u{043E}\u{0308}"),
    ("\u{04EA}", "\u{04EA}", "\u{04E8}\u{0308}", "\u{04EA}", "\u{04E8}\u{0308}"),
    ("\u{04EB}", "\u{04EB}", "\u{04E9}\u{0308}", "\u{04EB}", "\u{04E9}\u{0308}"),
    ("\u{04EC}", "\u{04EC}", "\u{042D}\u{0308}", "\u{04EC}", "\u{042D}\u{0308}"),
    ("\u{04ED}", "\u{04ED}", "\u{044D}\u{0308}", "\u{04ED}", "\u{044D}\u{0308}"),
    ("\u{04EE}", "\u{04EE}", "\u{0423}\u{0304}", "\u{04EE}", "\u{0423}\u{0304}"),
    ("\u{04EF}", "\u{04EF}", "\u{0443}\u{0304}", "\u{04EF}", "\u{0443}\u{0304}"),
    ("\u{04F0}", "\u{04F0}", "\u{0423}\u{0308}", "\u{04F0}", "\u{0423}\u{0308}"),
    ("\u{04F1}", "\u{04F1}", "\u{0443}\u{0308}", "\u{04F1}", "\u{0443}\u{0308}"),
    ("\u{04F2}", "\u{04F2}", "\u{0423}\u{030B}", "\u{04F2}", "\u{0423}\u{030B}"),
    ("\u{04F3}", "\u{04F3}", "\u{0443}\u{030B}", "\u{04F3}", "\u{0443}\u{030B}"),
    ("\u{04F4}", "\u{04F4}", "\u{0427}\u{0308}", "\u{04F4}", "\u{0427}\u{0308}"),
    ("\u{04F5}", "\u{04F5}", "\u{0447}\u{0308}", "\u{04F5}", "\u{0447}\u{0308}"),
    ("\u{04F8}", "\u{04F8}", "\u{042B}\u{0308}", "\u{04F8}", "\u{042B}\u{0308}"),
    ("\u{04F9}", "\u{04F9}", "\u{044B}\u{0308}", "\u{04F9}", "\u{044B}\u{0308}"),
    ("\u{0587}", "\u{0587}", "\u{0587}", "\u{0565}\u{0582}", "\u{0565}\u{0582}"),
    ("\u{0622}", "\u{0622}", "\u{0627}\u{0653}", "\u{0622}", "\u{0627}\u{0653}"),
    ("\u{0623}", "\u{0623}", "\u{0627}\u{0654}", "\u{0623}", "\u{0627}\u{0654}"),
    ("\u{0624}", "\u{0624}", "\u{0648}\u{0654}", "\u{0624}", "\u{0648}\u{0654}"),
    ("\u{0625}", "\u{0625}", "\u{0627}\u{0655}", "\u{0625}", "\u{0627}\u{0655}"),
    ("\u{0626}", "\u{0626}", "\u{064A}\u{0654}", "\u{0626}", "\u{064A}\u{0654}"),
    ("\u{0675}", "\u{0675}", "\u{0675}", "\u{0627}\u{0674}", "\u{0627}\u{0674}"),
    ("\u{0676}", "\u{0676}", "\u{0676}", "\u{0648}\u{0674}", "\u{0648}\u{0674}"),
    ("\u{0677}", "\u{0677}", "\u{0677}", "\u{06C7}\u{0674}", "\u{06C7}\u{0674}"),
    ("\u{0678}", "\u{0678}", "\u{0678}", "\u{064A}\u{0674}", "\u{064A}\u{0674}"),
    ("\u{06C0}", "\u{06C0}", "\u{06D5}\u{0654}", "\u{06C0}", "\u{06D5}\u{0654}"),
    ("\u{06C2}", "\u{06C2}", "\u{06C1}\u{0654}", "\u{06C2}", "\u{06C1}\u{0654}"),
    ("\u{06D3}", "\u{06D3}", "\u{06D2}\u{0654}", "\u{06D3}", "\u{06D2}\u{0654}"),
    ("\u{0929}", "\u{0929}", "\u{0928}\u{093C}", "\u{0929}", "\u{0928}\u{093C}"),
    ("\u{0931}", "\u{0931}", "\u{0930}\u{093C}", "\u{0931}", "\u{0930}\u{093C}"),
    ("\u{0934}", "\u{0934}", "\u{0933}\u{093C}", "\u{0934}", "\u{0933}\u{093C}"),
    ("\u{0958}", "\u{0915}\u{093C}", "\u{0915}\u{093C}", "\u{0915}\u{093C}", "\u{0915}\u{093C}"),
    ("\u{0959}", "\u{0916}\u{093C}", "\u{0916}\u{093C}", "\u{0916}\u{093C}", "\u{0916}\u{093C}"),
    ("\u{095A}", "\u{0917}\u{093C}", "\u{0917}\u{093C}", "\u{0917}\u{093C}", "\u{0917}\u{093C}"),
    ("\u{095B}", "\u{091C}\u{093C}", "\u{091C}\u{093C}", "\u{091C}\u{093C}", "\u{091C}\u{093C}"),
    ("\u{095C}", "\u{0921}\u{093C}", "\u{0921}\u{093C}", "\u{0921}\u{093C}", "\u{0921}\u{093C}"),
    ("\u{095D}", "\u{0922}\u{093C}", "\u{0922}\u{093C}", "\u{0922}\u{093C}", "\u{0922}\u{093C}"),
    ("\u{095E}", "\u{092B}\u{093C}", "\u{092B}\u{093C}", "\u{092B}\u{093C}", "\u{092B}\u{093C}"),
    ("\u{095F}", "\u{092F}\u{093C}", "\u{092F}\u{093C}", "\u{092F}\u{093C}", "\u{092F}\u{093C}"),
    ("\u{09CB}", "\u{09CB}", "\u{09C7}\u{09BE}", "\u{09CB}", "\u{09C7}\u{09BE}"),
    ("\u{09CC}", "\u{09CC}", "\u{09C7}\u{09D7}", "\u{09CC}", "\u{09C7}\u{09D7}"),
    ("\u{09DC}", "\u{09A1}\u{09BC}", "\u{09A1}\u{09BC}", "\u{09A1}\u{09BC}", "\u{09A1}\u{09BC}"),
    ("\u{09DD}", "\u{09A2}\u{09BC}", "\u{09A2}\u{09BC}", "\u{09A2}\u{09BC}", "\u{09A2}\u{09BC}"),
    ("\u{09DF}", "\u{09AF}\u{09BC}", "\u{09AF}\u{09BC}", "\u{09AF}\u{09BC}", "\u{09AF}\u{09BC}"),
    ("\u{0A33}", "\u{0A32}\u{0A3C}", "\u{0A32}\u{0A3C}", "\u{0A32}\u{0A3C}", "\u{0A32}\u{0A3C}"),
    ("\u{0A36}", "\u{0A38}\u{0A3C}", "\u{0A38}\u{0A3C}", "\u{0A38}\u{0A3C}", "\u{0A38}\u{0A3C}"),
    ("\u{0A59}", "\u{0A16}\u{0A3C}", "\u{0A16}\u{0A3C}", "\u{0A16}\u{0A3C}", "\u{0A16}\u{0A3C}"),
    ("\u{0A5A}", "\u{0A17}\u{0A3C}", "\u{0A17}\u{0A3C}", "\u{0A17}\u{0A3C}", "\u{0A17}\u{0A3C}"),
    ("\u{0A5B}", "\u{0A1C}\u{0A3C}", "\u{0A1C}\u{0A3C}", "\u{0A1C}\u{0A3C}", "\u{0A1C}\u{0A3C}"),
    ("\u{0A5E}", "\u{0A2B}\u{0A3C}", "\u{0A2B}\u{0A3C}", "\u{0A2B}\u{0A3C}", "\u{0A2B}\u{0A3C}"),
    ("\u{0B48}", "\u{0B48}", "\u{0B47}\u{0B56}", "\u{0B48}", "\u{0B47}\u{0B56}"),
    ("\u{0B4B}", "\u{0B4B}", "\u{0B47}\u{0B3E}", "\u{0B4B}", "\u{0B47}\u{0B3E}"),
    ("\u{0B4C}", "\u{0B4C}", "\u{0B47}\u{0B57}", "\u{0B4C}", "\u{0B47}\u{0B57}"),
    ("\u{0B5C}", "\u{0B21}\u{0B3C}", "\u{0B21}\u{0B3C}", "\u{0B21}\u{0B3C}", "\u{0B21}\u{0B3C}"),
    ("\u{0B5D}", "\u{0B22}\u{0B3C}", "\u{0B22}\u{0B3C}", "\u{0B22}\u{0B3C}", "\u{0B22}\u{0B3C}"),
    ("\u{0B94}", "\u{0B94}", "\u{0B92}\u{0BD7}", "\u{0B94}", "\u{0B92}\u{0BD7}"),
    ("\u{0BCA}", "\u{0BCA}", "\u{0BC6}\u{0BBE}", "\u{0BCA}", "\u{0BC6}\u{0BBE}"),
    ("\u{0BCB}", "\u{0BCB}", "\u{0BC7}\u{0BBE}", "\u{0BCB}", "\u{0BC7}\u{0BBE}"),
    ("\u{0BCC}", "\u{0BCC}", "\u{0BC6}\u{0BD7}", "\u{0BCC}", "\u{0BC6}\u{0BD7}"),
    ("\u{0C48}", "\u{0C48}", "\u{0C46}\u{0C56}", "\u{0C48}", "\u{0C46}\u{0C56}"),
    ("\u{0CC0}", "\u{0CC0}", "\u{0CBF}\u{0CD5}", "\u{0CC0}", "\u{0CBF}\u{0CD5}"),
    ("\u{0CC7}", "\u{0CC7}", "\u{0CC6}\u{0CD5}", "\u{0CC7}", "\u{0CC6}\u{0CD5}"),
    ("\u{0CC8}", "\u{0CC8}", "\u{0CC6}\u{0CD6}", "\u{0CC8}", "\u{0CC6}\u{0CD6}"),
    ("\u{0CCA}", "\u{0CCA}", "\u{0CC6}\u{0CC2}", "\u{0CCA}", "\u{0CC6}\u{0CC2}"),
    ("\u{0CCB}", "\u{0CCB}", "\u{0CC6}\u{0CC2}\u{0CD5}", "\u{0CCB}", "\u{0CC6}\u{0CC2}\u{0CD5}"),
    ("\u{0D4A}", "\u{0D4A}", "\u{0D46}\u{0D3E}", "\u{0D4A}", "\u{0D46}\u{0D3E}"),
    ("\u{0D4B}", "\u{0D4B}", "\u{0D47}\u{0D3E}", "\u{0D4B}", "\u{0D47}\u{0D3E}"),
    ("\u{0D4C}", "\u{0D4C}", "\u{0D46}\u{0D57}", "\u{0D4C}", "\u{0D46}\u{0D57}"),
    ("\u{0DDA}", "\u{0DDA}", "\u{0DD9}\u{0DCA}", "\u{0DDA}", "\u{0DD9}\u{0DCA}"),
    ("\u{0DDC}", "\u{0DDC}", "\u{0DD9}\u{0DCF}", "\u{0DDC}", "\u{0DD9}\u{0DCF}"),
    ("\u{0DDD}", "\u{0DDD}", "\u{0DD9}\u{0DCF}\u{0DCA}", "\u{0DDD}", "\u{0DD9}\u{0DCF}\u{0DCA}"),
    ("\u{0DDE}", "\u{0DDE}", "\u{0DD9}\u{0DDF}", "\u{0DDE}", "\u{0DD9}\u{0DDF}"),
    ("\u{0E33}", "\u{0E33}", "\u{0E33}", "\u{0E4D}\u{0E32}", "\u{0E4D}\u{0E32}"),
    ("\u{0EB3}", "\u{0EB3}", "\u{0EB3}", "\u{0ECD}\u{0EB2}", "\u{0ECD}\u{0EB2}"),
    ("\u{0EDC}", "\u{0EDC}", "\u{0EDC}", "\u{0EAB}\u{0E99}", "\u{0EAB}\u{0E99}"),
    ("\u{0EDD}", "\u{0EDD}", "\u{0EDD}", "\u{0EAB}\u{0EA1}", "\u{0EAB}\u{0EA1}"),
    ("\u{0F0C}", "\u{0F0C}", "\u{0F0C}", "\u{0F0B}", "\u{0F0B}"),
    ("\u{0F43}", "\u{0F42}\u{0FB7}", "\u{0F42}\u{0FB7}", "\u{0F42}\u{0FB7}", "\u{0F42}\u{0FB7}"),
    ("\u{0F4D}", "\u{0F4C}\u{0FB7}", "\u{0F4C}\u{0FB7}", "\u{0F4C}\u{0FB7}", "\u{0F4C}\u{0FB7}"),
    ("\u{0F52}", "\u{0F51}\u{0FB7}", "\u{0F51}\u{0FB7}", "\u{0F51}\u{0FB7}", "\u{0F51}\u{0FB7}"),
    ("\u{0F57}", "\u{0F56}\u{0FB7}", "\u{0F56}\u{0FB7}", "\u{0F56}\u{0FB7}", "\u{0F56}\u{0FB7}"),
    ("\u{0F5C}", "\u{0F5B}\u{0FB7}", "\u{0F5B}\u{0FB7}", "\u{0F5B}\u{0FB7}", "\u{0F5B}\u{0FB7}"),
    ("\u{0F69}", "\u{0F40}\u{0FB5}", "\u{0F40}\u{0FB5}", "\u{0F40}\u{0FB5}", "\u{0F40}\u{0FB5}"),
    ("\u{0F73}", "\u{0F71}\u{0F72}", "\u{0F71}\u{0F72}", "\u{0F71}\u{0F72}", "\u{0F71}\u{0F72}"),
    ("\u{0F75}", "\u{0F71}\u{0F74}", "\u{0F71}\u{0F74}", "\u{0F71}\u{0F74}", "\u{0F71}\u{0F74}"),
    ("\u{0F76}", "\u{0FB2}\u{0F80}", "\u{0FB2}\u{0F80}", "\u{0FB2}\u{0F80}", "\u{0FB2}\u{0F80}"),
    ("\u{0F77}", "\u{0F77}", "\u{0F77}", "\u{0FB2}\u{0F71}\u{0F80}", "\u{0FB2}\u{0F71}\u{0F80}"),
    ("\u{0F78}", "\u{0FB3}\u{0F80}", "\u{0FB3}\u{0F80}", "\u{0FB3}\u{0F80}", "\u{0FB3}\u{0F80}"),
    ("\u{0F79}", "\u{0F79}", "\u{0F79}", "\u{0FB3}\u{0F71}\u{0F80}", "\u{0FB3}\u{0F71}\u{0F80}"),
    ("\u{0F81}", "\u{0F71}\u{0F80}", "\u{0F71}\u{0F80}", "\u{0F71}\u{0F80}", "\u{0F71}\u{0F80}"),
    ("\u{0F93}", "\u{0F92}\u{0FB7}", "\u{0F92}\u{0FB7}", "\u{0F92}\u{0FB7}", "\u{0F92}\u{0FB7}"),
    ("\u{0F9D}", "\u{0F9C}\u{0FB7}", "\u{0F9C}\u{0FB7}", "\u{0F9C}\u{0FB7}", "\u{0F9C}\u{0FB7}"),
    ("\u{0FA2}", "\u{0FA1}\u{0FB7}", "\u{0FA1}\u{0FB7}", "\u{0FA1}\u{0FB7}", "\u{0FA1}\u{0FB7}"),
    ("\u{0FA7}", "\u{0FA6}\u{0FB7}", "\u{0FA6}\u{0FB7}", "\u{0FA6}\u{0FB7}", "\u{0FA6}\u{0FB7}"),
    ("\u{0FAC}", "\u{0FAB}\u{0FB7}", "\u{0FAB}\u{0FB7}", "\u{0FAB}\u{0FB7}", "\u{0FAB}\u{0FB7}"),
    ("\u{0FB9}", "\u{0F90}\u{0FB5}", "\u{0F90}\u{0FB5}", "\u{0F90}\u{0FB5}", "\u{0F90}\u{0FB5}"),
    ("\u{1026}", "\u{1026}", "\u{1025}\u{102E}", "\u{1026}", "\u{1025}\u{102E}"),
    ("\u{10FC}", "\u{10FC}", "\u{10FC}", "\u{10DC}", "\u{10DC}"),
    ("\u{1B06}", "\u{1B06}", "\u{1B05}\u{1B35}", "\u{1B06}", "\u{1B05}\u{1B35}"),
    ("\u{1B08}", "\u{1B08}", "\u{1B07}\u{1B35}", "\u{1B08}", "\u{1B07}\u{1B35}"),
    ("\u{1B0A}", "\u{1B0A}", "\u{1B09}\u{1B35}", "\u{1B0A}", "\u{1B09}\u{1B35}"),
    ("\u{1B0C}", "\u{1B0C}", "\u{1B0B}\u{1B35}", "\u{1B0C}", "\u{1B0B}\u{1B35}"),
    ("\u{1B0E}", "\u{1B0E}", "\u{1B0D}\u{1B35}", "\u{1B0E}", "\u{1B0D}\u{1B35}"),
    ("\u{1B12}", "\u{1B12}", "\u{1B11}\u{1B35}", "\u{1B12}", "\u{1B11}\u{1B35}"),
    ("\u{1B3B}", "\u{1B3B}", "\u{1B3A}\u{1B35}", "\u{1B3B}", "\u{1B3A}\u{1B35}"),
    ("\u{1B3D}", "\u{1B3D}", "\u{1B3C}\u{1B35}", "\u{1B3D}", "\u{1B3C}\u{1B35}"),
    ("\u{1B40}", "\u{1B40}", "\u{1B3E}\u{1B35}", "\u{1B40}", "\u{1B3E}\u{1B35}"),
    ("\u{1B41}", "\u{1B41}", "\u{1B3F}\u{1B35}", "\u{1B41}", "\u{1B3F}\u{1B35}"),
    ("\u{1B43}", "\u{1B43}", "\u{1B42}\u{1B35}", "\u{1B43}", "\u{1B42}\u{1B35}"),
    ("\u{1D2C}", "\u{1D2C}", "\u{1D2C}", "\u{0041}", "\u{0041}"),
    ("\u{1D2D}", "\u{1D2D}", "\u{1D2D}", "\u{00C6}", "\u{00C6}"),
    ("\u{1D2E}", "\u{1D2E}", "\u{1D2E}", "\u{0042}", "\u{0042}"),
    ("\u{1D30}", "\u{1D30}", "\u{1D30}", "\u{0044}", "\u{0044}"),
    ("\u{1D31}", "\u{1D31}", "\u{1D31}", "\u{0045}", "\u{0045}"),
    ("\u{1D32}", "\u{1D32}", "\u{1D32}", "\u{018E}", "\u{018E}"),
    ("\u{1D33}", "\u{1D33}", "\u{1D33}", "\u{0047}", "\u{0047}"),
    ("\u{1D34}", "\u{1D34}", "\u{1D34}", "\u{0048}", "\u{0048}"),
    ("\u{1D35}", "\u{1D35}", "\u{1D35}", "\u{0049}", "\u{0049}"),
    ("\u{1D36}", "\u{1D36}", "\u{1D36}", "\u{004A}", "\u{004A}"),
    ("\u{1D37}", "\u{1D37}", "\u{1D37}", "\u{004B}", "\u{004B}"),
    ("\u{1D38}", "\u{1D38}", "\u{1D38}", "\u{004C}", "\u{004C}"),
    ("\u{1D39}", "\u{1D39}", "\u{1D39}", "\u{004D}", "\u{004D}"),
    ("\u{1D3A}", "\u{1D3A}", "\u{1D3A}", "\u{004E}", "\u{004E}"),
    ("\u{1D3C}", "\u{1D3C}", "\u{1D3C}", "\u{004F}", "\u{004F}"),
    ("\u{1D3D}", "\u{1D3D}", "\u{1D3D}", "\u{0222}", "\u{0222}"),
    ("\u{1D3E}", "\u{1D3E}", "\u{1D3E}", "\u{0050}", "\u{0050}"),
    ("\u{1D3F}", "\u{1D3F}", "\u{1D3F}", "\u{0052}", "\u{0052}"),
    ("\u{1D40}", "\u{1D40}", "\u{1D40}", "\u{0054}", "\u{0054}"),
    ("\u{1D41}", "\u{1D41}", "\u{1D41}", "\u{0055}", "\u{0055}"),
    ("\u{1D42}", "\u{1D42}", "\u{1D42}", "\u{0057}", "\u{0057}"),
    ("\u{1D43}", "\u{1D43}", "\u{1D43}", "\u{0061}", "\u{0061}"),
    ("\u{1D44}", "\u{1D44}", "\u{1D44}", "\u{0250}", "\u{0250}"),
    ("\u{1D45}", "\u{1D45}", "\u{1D45}", "\u{0251}", "\u{0251}"),
    ("\u{1D46}", "\u{1D46}", "\u{1D46}", "\u{1D02}", "\u{1D02}"),
    ("\u{1D47}", "\u{1D47}", "\u{1D47}", "\u{0062}", "\u{0062}"),
    ("\u{1D48}", "\u{1D48}", "\u{1D48}", "\u{0064}", "\u{0064}"),
    ("\u{1D49}", "\u{1D49}", "\u{1D49}", "\u{0065}", "\u{0065}"),
    ("\u{1D4A}", "\u{1D4A}", "\u{1D4A}", "\u{0259}", "\u{0259}"),
    ("\u{1D4B}", "\u{1D4B}", "\u{1D4B}", "\u{025B}", "\u{025B}"),
    ("\u{1D4C}", "\u{1D4C}", "\u{1D4C}", "\u{025C}", "\u{025C}"),
    ("\u{1D4D}", "\u{1D4D}", "\u{1D4D}", "\u{0067}", "\u{0067}"),
    ("\u{1D4F}", "\u{1D4F}", "\u{1D4F}", "\u{006B}", "\u{006B}"),
    ("\u{1D50}", "\u{1D50}", "\u{1D50}", "\u{006D}", "\u{006D}"),
    ("\u{1D51}", "\u{1D51}", "\u{1D51}", "\u{014B}", "\u{014B}"),
    ("\u{1D52}", "\u{1D52}", "\u{1D52}", "\u{006F}", "\u{006F}"),
    ("\u{1D53}", "\u{1D53}", "\u{1D53}", "\u{0254}", "\u{0254}"),
    ("\u{1D54}", "\u{1D54}", "\u{1D54}", "\u{1D16}", "\u{1D16}"),
    ("\u{1D55}", "\u{1D55}", "\u{1D55}", "\u{1D17}", "\u{1D17}"),
    ("\u{1D56}", "\u{1D56}", "\u{1D56}", "\u{0070}", "\u{0070}"),
    ("\u{1D57}", "\u{1D57}", "\u{1D57}", "\u{0074}", "\u{0074}"),
    ("\u{1D58}", "\u{1D58}", "\u{1D58}", "\u{0075}", "\u{0075}"),
    ("\u{1D59}", "\u{1D59}", "\u{1D59}", "\u{1D1D}", "\u{1D1D}"),
    ("\u{1D5A}", "\u{1D5A}", "\u{1D5A}", "\u{026F}", "\u{026F}"),
    ("\u{1D5B}", "\u{1D5B}", "\u{1D5B}", "\u{0076}", "\u{0076}"),
    ("\u{1D5C}", "\u{1D5C}", "\u{1D5C}", "\u{1D25}", "\u{1D25}"),
    ("\u{1D5D}", "\u{1D5D}", "\u{1D5D}", "\u{03B2}", "\u{03B2}"),
    ("\u{1D5E}", "\u{1D5E}", "\u{1D5E}", "\u{03B3}", "\u{03B3}"),
    ("\u{1D5F}", "\u{1D5F}", "\u{1D5F}", "\u{03B4}", "\u{03B4}"),
    ("\u{1D60}", "\u{1D60}", "\u{1D60}", "\u{03C6}", "\u{03C6}"),
    ("\u{1D61}", "\u{1D61}", "\u{1D61}", "\u{03C7}", "\u{03C7}"),
    ("\u{1D62}", "\u{1D62}", "\u{1D62}", "\u{0069}", "\u{0069}"),
    ("\u{1D63}", "\u{1D63}", "\u{1D63}", "\u{0072}", "\u{0072}"),
    ("\u{1D64}", "\u{1D64}", "\u{1D64}", "\u{0075}", "\u{0075}"),
    ("\u{1D65}", "\u{1D65}", "\u{1D65}", "\u{0076}", "\u{0076}"),
    ("\u{1D66}", "\u{1D66}", "\u{1D66}", "\u{03B2}", "\u{03B2}"),
    ("\u{1D67}", "\u{1D67}", "\u{1D67}", "\u{03B3}", "\u{03B3}"),
    ("\u{1D68}", "\u{1D68}", "\u{1D68}", "\u{03C1}", "\u{03C1}"),
    ("\u{1D69}", "\u{1D69}", "\u{1D69}", "\u{03C6}", "\u{03C6}"),
    ("\u{1D6A}", "\u{1D6A}", "\u{1D6A}", "\u{03C7}", "\u{03C7}"),
    ("\u{1D78}", "\u{1D78}", "\u{1D78}", "\u{043D}", "\u{043D}"),
    ("\u{1D9B}", "\u{1D9B}", "\u{1D9B}", "\u{0252}", "\u{0252}"),
    ("\u{1D9C}", "\u{1D9C}", "\u{1D9C}", "\u{0063}", "\u{0063}"),
    ("\u{1D9D}", "\u{1D9D}", "\u{1D9D}", "\u{0255}", "\u{0255}"),
    ("\u{1D9E}", "\u{1D9E}", "\u{1D9E}", "\u{00F0}", "\u{00F0}"),
    ("\u{1D9F}", "\u{1D9F}", "\u{1D9F}", "\u{025C}", "\u{025C}"),
    ("\u{1DA0}", "\u{1DA0}", "\u{1DA0}", "\u{0066}", "\u{0066}"),
    ("\u{1DA1}", "\u{1DA1}", "\u{1DA1}", "\u{025F}", "\u{025F}"),
    ("\u{1DA2}", "\u{1DA2}", "\u{1DA2}", "\u{0261}", "\u{0261}"),
    ("\u{1DA3}", "\u{1DA3}", "\u{1DA3}", "\u{0265}", "\u{0265}"),
    ("\u{1DA4}", "\u{1DA4}", "\u{1DA4}", "\u{0268}", "\u{0268}"),
    ("\u{1DA5}", "\u{1DA5}", "\u{1DA5}", "\u{0269}", "\u{0269}"),
    ("\u{1DA6}", "\u{1DA6}", "\u{1DA6}", "\u{026A}", "\u{026A}"),
    ("\u{1DA7}", "\u{1DA7}", "\u{1DA7}", "\u{1D7B}", "\u{1D7B}"),
    ("\u{1DA8}", "\u{1DA8}", "\u{1DA8}", "\u{029D}", "\u{029D}"),
    ("\u{1DA9}", "\u{1DA9}", "\u{1DA9}", "\u{026D}", "\u{026D}"),
    ("\u{1DAA}", "\u{1DAA}", "\u{1DAA}", "\u{1D85}", "\u{1D85}"),
    ("\u{1DAB}", "\u{1DAB}", "\u{1DAB}", "\u{029F}", "\u{029F}"),
    ("\u{1DAC}", "\u{1DAC}", "\u{1DAC}", "\u{0271}", "\u{0271}"),
    ("\u{1DAD}", "\u{1DAD}", "\u{1DAD}", "\u{0270}", "\u{0270}"),
    ("\u{1DAE}", "\u{1DAE}", "\u{1DAE}", "\u{0272}", "\u{0272}"),
    ("\u{1DAF}", "\u{1DAF}", "\u{1DAF}", "\u{0273}", "\u{0273}"),
    ("\u{1DB0}", "\u{1DB0}", "\u{1DB0}", "\u{0274}", "\u{0274}"),
    ("\u{1DB1}", "\u{1DB1}", "\u{1DB1}", "\u{0275}", "\u{0275}"),
    ("\u{1DB2}", "\u{1DB2}", "\u{1DB2}", "\u{0278}", "\u{0278}"),
    ("\u{1DB3}", "\u{1DB3}", "\u{1DB3}", "\u{0282}", "\u{0282}"),
    ("\u{1DB4}", "\u{1DB4}", "\u{1DB4}", "\u{0283}", "\u{0283}"),
    ("\u{1DB5}", "\u{1DB5}", "\u{1DB5}", "\u{01AB}", "\u{01AB}"),
    ("\u{1DB6}", "\u{1DB6}", "\u{1DB6}", "\u{0289}", "\u{0289}"),
    ("\u{1DB7}", "\u{1DB7}", "\u{1DB7}", "\u{028A}", "\u{028A}"),
    ("\u{1DB8}", "\u{1DB8}", "\u{1DB8}", "\u{1D1C}", "\u{1D1C}"),
    ("\u{1DB9}", "\u{1DB9}", "\u{1DB9}", "\u{028B}", "\u{028B}"),
    ("\u{1DBA}", "\u{1DBA}", "\u{1DBA}", "\u{028C}", "\u{028C}"),
    ("\u{1DBB}", "\u{1DBB}", "\u{1DBB}", "\u{007A}", "\u{007A}"),
    ("\u{1DBC}", "\u{1DBC}", "\u{1DBC}", "\u{0290}", "\u{0290}"),
    ("\u{1DBD}", "\u{1DBD}", "\u{1DBD}", "\u{0291}", "\u{0291}"),
    ("\u{1DBE}", "\u{1DBE}", "\u{1DBE}", "\u{0292}", "\u{0292}"),
    ("\u{1DBF}", "\u{1DBF}", "\u{1DBF}", "\u{03B8}", "\u{03B8}"),
    ("\u{1E00}", "\u{1E00}", "\u{0041}\u{0325}", "\u{1E00}", "\u{0041}\u{0325}"),
    ("\u{1E01}", "\u{1E01}", "\u{0061}\u{0325}", "\u{1E01}", "\u{0061}\u{0325}"),
    ("\u{1E02}", "\u{1E02}", "\u{0042}\u{0307}", "\u{1E02}", "\u{0042}\u{0307}"),
    ("\u{1E03}", "\u{1E03}", "\u{0062}\u{0307}", "\u{1E03}", "\u{0062}\u{0307}"),
    ("\u{1E04}", "\u{1E04}", "\u{0042}\u{0323}", "\u{1E04}", "\u{0042}\u{0323}"),
    ("\u{1E05}", "\u{1E05}", "\u{0062}\u{0323}", "\u{1E05}", "\u{0062}\u{0323}"),
    ("\u{1E06}", "\u{1E06}", "\u{0042}\u{0331}", "\u{1E06}", "\u{0042}\u{0331}"),
    ("\u{1E07}", "\u{1E07}", "\u{0062}\u{0331}", "\u{1E07}", "\u{0062}\u{0331}"),
    ("\u{1E08}", "\u{1E08}", "\u{0043}\u{0327}\u{0301}", "\u{1E08}", "\u{0043}\u{0327}\u{0301}"),
    ("\u{1E09}", "\u{1E09}", "\u{0063}\u{0327}\u{0301}", "\u{1E09}", "\u{0063}\u{0327}\u{0301}"),
    ("\u{1E0B}", "\u{1E0B}", "\u{0064}\u{0307}", "\u{1E0B}", "\u{0064}\u{0307}"),
    ("\u{1E0D}", "\u{1E0D}", "\u{0064}\u{0323}", "\u{1E0D}", "\u{0064}\u{0323}"),
    ("\u{1E0E}", "\u{1E0E}", "\u{0044}\u{0331}", "\u{1E0E}", "\u{0044}\u{0331}"),
    ("\u{1E0F}", "\u{1E0F}", "\u{0064}\u{0331}", "\u{1E0F}", "\u{0064}\u{0331}"),
    ("\u{1E10}", "\u{1E10}", "\u{0044}\u{0327}", "\u{1E10}", "\u{0044}\u{0327}"),
    ("\u{1E11}", "\u{1E11}", "\u{0064}\u{0327}", "\u{1E11}", "\u{0064}\u{0327}"),
    ("\u{1E12}", "\u{1E12}", "\u{0044}\u{032D}", "\u{1E12}", "\u{0044}\u{032D}"),
    ("\u{1E13}", "\u{1E13}", "\u{0064}\u{032D}", "\u{1E13}", "\u{0064}\u{032D}"),
    ("\u{1E15}", "\u{1E15}", "\u{0065}\u{0304}\u{0300}", "\u{1E15}", "\u{0065}\u{0304}\u{0300}"),
    ("\u{1E16}", "\u{1E16}", "\u{0045}\u{0304}\u{0301}", "\u{1E16}", "\u{0045}\u{0304}\u{0301}"),
    ("\u{1E17}", "\u{1E17}", "\u{0065}\u{0304}\u{0301}", "\u{1E17}", "\u{0065}\u{0304}\u{0301}"),
    ("\u{1E18}", "\u{1E18}", "\u{0045}\u{032D}", "\u{1E18}", "\u{0045}\u{032D}"),
    ("\u{1E19}", "\u{1E19}", "\u{0065}\u{032D}", "\u{1E19}", "\u{0065}\u{032D}"),
    ("\u{1E1A}", "\u{1E1A}", "\u{0045}\u{0330}", "\u{1E1A}", "\u{0045}\u{0330}"),
    ("\u{1E1B}", "\u{1E1B}", "\u{0065}\u{0330}", "\u{1E1B}", "\u{0065}\u{0330}"),
    ("\u{1E1C}", "\u{1E1C}", "\u{0045}\u{0327}\u{0306}", "\u{1E1C}", "\u{0045}\u{0327}\u{0306}"),
    ("\u{1E1D}", "\u{1E1D}", "\u{0065}\u{0327}\u{0306}", "\u{1E1D}", "\u{0065}\u{0327}\u{0306}"),
    ("\u{1E1E}", "\u{1E1E}", "\u{0046}\u{0307}", "\u{1E1E}", "\u{0046}\u{0307}"),
    ("\u{1E1F}", "\u{1E1F}", "\u{0066}\u{0307}", "\u{1E1F}", "\u{0066}\u{0307}"),
    ("\u{1E20}", "\u{1E20}", "\u{0047}\u{0304}", "\u{1E20}", "\u{0047}\u{0304}"),
    ("\u{1E21}", "\u{1E21}", "\u{0067}\u{0304}", "\u{1E21}", "\u{0067}\u{0304}"),
    ("\u{1E22}", "\u{1E22}", "\u{0048}\u{0307}", "\u{1E22}", "\u{0048}\u{0307}"),
    ("\u{1E23}", "\u{1E23}", "\u{0068}\u{0307}", "\u{1E23}", "\u{0068}\u{0307}"),
    ("\u{1E24}", "\u{1E24}", "\u{0048}\u{0323}", "\u{1E24}", "\u{0048}\u{0323}"),
    ("\u{1E25}", "\u{1E25}", "\u{0068}\u{0323}", "\u{1E25}", "\u{0068}\u{0323}"),
    ("\u{1E26}", "\u{1E26}", "\u{0048}\u{0308}", "\u{1E26}", "\u{0048}\u{0308}"),
    ("\u{1E27}", "\u{1E27}", "\u{0068}\u{0308}", "\u{1E27}", "\u{0068}\u{0308}"),
    ("\u{1E28}", "\u{1E28}", "\u{0048}\u{0327}", "\u{1E28}", "\u{0048}\u{0327}"),
    ("\u{1E29}", "\u{1E29}", "\u{0068}\u{0327}", "\u{1E29}", "\u{0068}\u{0327}"),
    ("\u{1E2A}", "\u{1E2A}", "\u{0048}\u{032E}", "\u{1E2A}", "\u{0048}\u{032E}"),
    ("\u{1E2B}", "\u{1E2B}", "\u{0068}\u{032E}", "\u{1E2B}", "\u{0068}\u{032E}"),
    ("\u{1E2C}", "\u{1E2C}", "\u{0049}\u{0330}", "\u{1E2C}", "\u{0049}\u{0330}"),
    ("\u{1E2D}", "\u{1E2D}", "\u{0069}\u{0330}", "\u{1E2D}", "\u{0069}\u{0330}"),
    ("\u{1E2E}", "\u{1E2E}", "\u{0049}\u{0308}\u{0301}", "\u{1E2E}", "\u{0049}\u{0308}\u{0301}"),
    ("\u{1E2F}", "\u{1E2F}", "\u{0069}\u{0308}\u{0301}", "\u{1E2F}", "\u{0069}\u{0308}\u{0301}"),
    ("\u{1E30}", "\u{1E30}", "\u{004B}\u{0301}", "\u{1E30}", "\u{004B}\u{0301}"),
    ("\u{1E31}", "\u{1E31}", "\u{006B}\u{0301}", "\u{1E31}", "\u{006B}\u{0301}"),
    ("\u{1E32}", "\u{1E32}", "\u{004B}\u{0323}", "\u{1E32}", "\u{004B}\u{0323}"),
    ("\u{1E33}", "\u{1E33}", "\u{006B}\u{0323}", "\u{1E33}", "\u{006B}\u{0323}"),
    ("\u{1E34}", "\u{1E34}", "\u{004B}\u{0331}", "\u{1E34}", "\u{004B}\u{0331}"),
    ("\u{1E35}", "\u{1E35}", "\u{006B}\u{0331}", "\u{1E35}", "\u{006B}\u{0331}"),
    ("\u{1E36}", "\u{1E36}", "\u{004C}\u{0323}", "\u{1E36}", "\u{004C}\u{0323}"),
    ("\u{1E37}", "\u{1E37}", "\u{006C}\u{0323}", "\u{1E37}", "\u{006C}\u{0323}"),
    ("\u{1E38}", "\u{1E38}", "\u{004C}\u{0323}\u{0304}", "\u{1E38}", "\u{004C}\u{0323}\u{0304}"),
    ("\u{1E39}", "\u{1E39}", "\u{006C}\u{0323}\u{0304}", "\u{1E39}", "\u{006C}\u{0323}\u{0304}"),
    ("\u{1E3A}", "\u{1E3A}", "\u{004C}\u{0331}", "\u{1E3A}", "\u{004C}\u{0331}"),
    ("\u{1E3B}", "\u{1E3B}", "\u{006C}\u{0331}", "\u{1E3B}", "\u{006C}\u{0331}"),
    ("\u{1E3C}", "\u{1E3C}", "\u{004C}\u{032D}", "\u{1E3C}", "\u{004C}\u{032D}"),
    ("\u{1E3D}", "\u{1E3D}", "\u{006C}\u{032D}", "\u{1E3D}", "\u{006C}\u{032D}"),
    ("\u{1E3E}", "\u{1E3E}", "\u{004D}\u{0301}", "\u{1E3E}", "\u{004D}\u{0301}"),
    ("\u{1E3F}", "\u{1E3F}", "\u{006D}\u{0301}", "\u{1E3F}", "\u{006D}\u{0301}"),
    ("\u{1E40}", "\u{1E40}", "\u{004D}\u{0307}", "\u{1E40}", "\u{004D}\u{0307}"),
    ("\u{1E41}", "\u{1E41}", "\u{006D}\u{0307}", "\u{1E41}", "\u{006D}\u{0307}"),
    ("\u{1E42}", "\u{1E42}", "\u{004D}\u{0323}", "\u{1E42}", "\u{004D}\u{0323}"),
    ("\u{1E43}", "\u{1E43}", "\u{006D}\u{0323}", "\u{1E43}", "\u{006D}\u{0323}"),
    ("\u{1E44}", "\u{1E44}", "\u{004E}\u{0307}", "\u{1E44}", "\u{004E}\u{0307}"),
    ("\u{1E45}", "\u{1E45}", "\u{006E}\u{0307}", "\u{1E45}", "\u{006E}\u{0307}"),
    ("\u{1E46}", "\u{1E46}", "\u{004E}\u{0323}", "\u{1E46}", "\u{004E}\u{0323}"),
    ("\u{1E47}", "\u{1E47}", "\u{006E}\u{0323}", "\u{1E47}", "\u{006E}\u{0323}"),
    ("\u{1E48}", "\u{1E48}", "\u{004E}\u{0331}", "\u{1E48}", "\u{004E}\u{0331}"),
    ("\u{1E49}", "\u{1E49}", "\u{006E}\u{0331}", "\u{1E49}", "\u{006E}\u{0331}"),
    ("\u{1E4A}", "\u{1E4A}", "\u{004E}\u{032D}", "\u{1E4A}", "\u{004E}\u{032D}"),
    ("\u{1E4B}", "\u{1E4B}", "\u{006E}\u{032D}", "\u{1E4B}", "\u{006E}\u{032D}"),
    ("\u{1E4C}", "\u{1E4C}", "\u{004F}\u{0303}\u{0301}", "\u{1E4C}", "\u{004F}\u{0303}\u{0301}"),
    ("\u{1E4D}", "\u{1E4D}", "\u{006F}\u{0303}\u{0301}", "\u{1E4D}", "\u{006F}\u{0303}\u{0301}"),
    ("\u{1E4E}", "\u{1E4E}", "\u{004F}\u{0303}\u{0308}", "\u{1E4E}", "\u{004F}\u{0303}\u{0308}"),
    ("\u{1E4F}", "\u{1E4F}", "\u{006F}\u{0303}\u{0308}", "\u{1E4F}", "\u{006F}\u{0303}\u{0308}"),
    ("\u{1E50}", "\u{1E50}", "\u{004F}\u{0304}\u{0300}", "\u{1E50}", "\u{004F}\u{0304}\u{0300}"),
    ("\u{1E51}", "\u{1E51}", "\u{006F}\u{0304}\u{0300}", "\u{1E51}", "\u{006F}\u{0304}\u{0300}"),
    ("\u{1E52}", "\u{1E52}", "\u{004F}\u{0304}\u{0301}", "\u{1E52}", "\u{004F}\u{0304}\u{0301}"),
    ("\u{1E53}", "\u{1E53}", "\u{006F}\u{0304}\u{0301}", "\u{1E53}", "\u{006F}\u{0304}\u{0301}"),
    ("\u{1E54}", "\u{1E54}", "\u{0050}\u{0301}", "\u{1E54}", "\u{0050}\u{0301}"),
    ("\u{1E55}", "\u{1E55}", "\u{0070}\u{0301}", "\u{1E55}", "\u{0070}\u{0301}"),
    ("\u{1E56}", "\u{1E56}", "\u{0050}\u{0307}", "\u{1E56}", "\u{0050}\u{0307}"),
    ("\u{1E57}", "\u{1E57}", "\u{0070}\u{0307}", "\u{1E57}", "\u{0070}\u{0307}"),
    ("\u{1E58}", "\u{1E58}", "\u{0052}\u{0307}", "\u{1E58}", "\u{0052}\u{0307}"),
    ("\u{1E59}", "\u{1E59}", "\u{0072}\u{0307}", "\u{1E59}", "\u{0072}\u{0307}"),
    ("\u{1E5A}", "\u{1E5A}", "\u{0052}\u{0323}", "\u{1E5A}", "\u{0052}\u{0323}"),
    ("\u{1E5B}", "\u{1E5B}", "\u{0072}\u{0323}", "\u{1E5B}", "\u{0072}\u{0323}"),
    ("\u{1E5C}", "\u{1E5C}", "\u{0052}\u{0323}\u{0304}", "\u{1E5C}", "\u{0052}\u{0323}\u{0304}"),
    ("\u{1E5D}", "\u{1E5D}", "\u{0072}\u{0323}\u{0304}", "\u{1E5D}", "\u{0072}\u{0323}\u{0304}"),
    ("\u{1E5E}", "\u{1E5E}", "\u{0052}\u{0331}", "\u{1E5E}", "\u{0052}\u{0331}"),
    ("\u{1E5F}", "\u{1E5F}", "\u{0072}\u{0331}", "\u{1E5F}", "\u{0072}\u{0331}"),
    ("\u{1E60}", "\u{1E60}", "\u{0053}\u{0307}", "\u{1E60}", "\u{0053}\u{0307}"),
    ("\u{1E61}", "\u{1E61}", "\u{0073}\u{0307}", "\u{1E61}", "\u{0073}\u{0307}"),
    ("\u{1E62}", "\u{1E62}", "\u{0053}\u{0323}", "\u{1E62}", "\u{0053}\u{0323}"),
    ("\u{1E63}", "\u{1E63}", "\u{0073}\u{0323}", "\u{1E63}", "\u{0073}\u{0323}"),
    ("\u{1E64}", "\u{1E64}", "\u{0053}\u{0301}\u{0307}", "\u{1E64}", "\u{0053}\u{0301}\u{0307}"),
    ("\u{1E65}", "\u{1E65}", "\u{0073}\u{0301}\u{0307}", "\u{1E65}", "\u{0073}\u{0301}\u{0307}"),
    ("\u{1E66}", "\u{1E66}", "\u{0053}\u{030C}\u{0307}", "\u{1E66}", "\u{0053}\u{030C}\u{0307}"),
    ("\u{1E67}", "\u{1E67}", "\u{0073}\u{030C}\u{0307}", "\u{1E67}", "\u{0073}\u{030C}\u{0307}"),
    ("\u{1E68}", "\u{1E68}", "\u{0053}\u{0323}\u{0307}", "\u{1E68}", "\u{0053}\u{0323}\u{0307}"),
    ("\u{1E69}", "\u{1E69}", "\u{0073}\u{0323}\u{0307}", "\u{1E69}", "\u{0073}\u{0323}\u{0307}"),
    ("\u{1E6A}", "\u{1E6A}", "\u{0054}\u{0307}", "\u{1E6A}", "\u{0054}\u{0307}"),
    ("\u{1E6B}", "\u{1E6B}", "\u{0074}\u{0307}", "\u{1E6B}", "\u{0074}\u{0307}"),
    ("\u{1E6C}", "\u{1E6C}", "\u{0054}\u{0323}", "\u{1E6C}", "\u{0054}\u{0323}"),
    ("\u{1E6D}", "\u{1E6D}", "\u{0074}\u{0323}", "\u{1E6D}", "\u{0074}\u{0323}"),
    ("\u{1E6E}", "\u{1E6E}", "\u{0054}\u{0331}", "\u{1E6E}", "\u{0054}\u{0331}"),
    ("\u{1E6F}", "\u{1E6F}", "\u{0074}\u{0331}", "\u{1E6F}", "\u{0074}\u{0331}"),
    ("\u{1E70}", "\u{1E70}", "\u{0054}\u{032D}", "\u{1E70}", "\u{0054}\u{032D}"),
    ("\u{1E71}", "\u{1E71}", "\u{0074}\u{032D}", "\u{1E71}", "\u{0074}\u{032D}"),
    ("\u{1E72}", "\u{1E72}", "\u{0055}\u{0324}", "\u{1E72}", "\u{0055}\u{0324}"),
    ("\u{1E73}", "\u{1E73}", "\u{0075}\u{0324}", "\u{1E73}", "\u{0075}\u{0324}"),
    ("\u{1E74}", "\u{1E74}", "\u{0055}\u{0330}", "\u{1E74}", "\u{0055}\u{0330}"),
    ("\u{1E75}", "\u{1E75}", "\u{0075}\u{0330}", "\u{1E75}", "\u{0075}\u{0330}"),
    ("\u{1E76}", "\u{1E76}", "\u{0055}\u{032D}", "\u{1E76}", "\u{0055}\u{032D}"),
    ("\u{1E77}", "\u{1E77}", "\u{0075}\u{032D}", "\u{1E77}", "\u{0075}\u{032D}"),
    ("\u{1E78}", "\u{1E78}", "\u{0055}\u{0303}\u{0301}", "\u{1E78}", "\u{0055}\u{0303}\u{0301}"),
    ("\u{1E79}", "\u{1E79}", "\u{0075}\u{0303}\u{0301}", "\u{1E79}", "\u{0075}\u{0303}\u{0301}"),
    ("\u{1E7A}", "\u{1E7A}", "\u{0055}\u{0304}\u{0308}", "\u{1E7A}", "\u{0055}\u{0304}\u{0308}"),
    ("\u{1E7B}", "\u{1E7B}", "\u{0075}\u{0304}\u{0308}", "\u{1E7B}", "\u{0075}\u{0304}\u{0308}"),
    ("\u{1E7C}", "\u{1E7C}", "\u{0056}\u{0303}", "\u{1E7C}", "\u{0056}\u{0303}"),
    ("\u{1E7D}", "\u{1E7D}", "\u{0076}\u{0303}", "\u{1E7D}", "\u{0076}\u{0303}"),
    ("\u{1E7E}", "\u{1E7E}", "\u{0056}\u{0323}", "\u{1E7E}", "\u{0056}\u{0323}"),
    ("\u{1E7F}", "\u{1E7F}", "\u{0076}\u{0323}", "\u{1E7F}", "\u{0076}\u{0323}"),
    ("\u{1E80}", "\u{1E80}", "\u{0057}\u{0300}", "\u{1E80}", "\u{0057}\u{0300}"),
    ("\u{1E81}", "\u{1E81}", "\u{0077}\u{0300}", "\u{1E81}", "\u{0077}\u{0300}"),
    ("\u{1E82}", "\u{1E82}", "\u{0057}\u{0301}", "\u{1E82}", "\u{0057}\u{0301}"),
    ("\u{1E83}", "\u{1E83}", "\u{0077}\u{0301}", "\u{1E83}", "\u{0077}\u{0301}"),
    ("\u{1E84}", "\u{1E84}", "\u{0057}\u{0308}", "\u{1E84}", "\u{0057}\u{0308}"),
    ("\u{1E85}", "\u{1E85}", "\u{0077}\u{0308}", "\u{1E85}", "\u{0077}\u{0308}"),
    ("\u{1E86}", "\u{1E86}", "\u{0057}\u{0307}", "\u{1E86}", "\u{0057}\u{0307}"),
    ("\u{1E87}", "\u{1E87}", "\u{0077}\u{0307}", "\u{1E87}", "\u{0077}\u{0307}"),
    ("\u{1E88}", "\u{1E88}", "\u{0057}\u{0323}", "\u{1E88}", "\u{0057}\u{0323}"),
    ("\u{1E89}", "\u{1E89}", "\u{0077}\u{0323}", "\u{1E89}", "\u{0077}\u{0323}"),
    ("\u{1E8A}", "\u{1E8A}", "\u{0058}\u{0307}", "\u{1E8A}", "\u{0058}\u{0307}"),
    ("\u{1E8B}", "\u{1E8B}", "\u{0078}\u{0307}", "\u{1E8B}", "\u{0078}\u{0307}"),
    ("\u{1E8C}", "\u{1E8C}", "\u{0058}\u{0308}", "\u{1E8C}", "\u{0058}\u{0308}"),
    ("\u{1E8D}", "\u{1E8D}", "\u{0078}\u{0308}", "\u{1E8D}", "\u{0078}\u{0308}"),
    ("\u{1E8E}", "\u{1E8E}", "\u{0059}\u{0307}", "\u{1E8E}", "\u{0059}\u{0307}"),
    ("\u{1E8F}", "\u{1E8F}", "\u{0079}\u{0307}", "\u{1E8F}", "\u{0079}\u{0307}"),
    ("\u{1E90}", "\u{1E90}", "\u{005A}\u{0302}", "\u{1E90}", "\u{005A}\u{0302}"),
    ("\u{1E91}", "\u{1E91}", "\u{007A}\u{0302}", "\u{1E91}", "\u{007A}\u{0302}"),
    ("\u{1E92}", "\u{1E92}", "\u{005A}\u{0323}", "\u{1E92}", "\u{005A}\u{0323}"),
    ("\u{1E93}", "\u{1E93}", "\u{007A}\u{0323}", "\u{1E93}", "\u{007A}\u{0323}"),
    ("\u{1E94}", "\u{1E94}", "\u{005A}\u{0331}", "\u{1E94}", "\u{005A}\u{0331}"),
    ("\u{1E95}", "\u{1E95}", "\u{007A}\u{0331}", "\u{1E95}", "\u{007A}\u{0331}"),
    ("\u{1E96}", "\u{1E96}", "\u{0068}\u{0331}", "\u{1E96}", "\u{0068}\u{0331}"),
    ("\u{1E97}", "\u{1E97}", "\u{0074}\u{0308}", "\u{1E97}", "\u{0074}\u{0308}"),
    ("\u{1E98}", "\u{1E98}", "\u{0077}\u{030A}", "\u{1E98}", "\u{0077}\u{030A}"),
    ("\u{1E99}", "\u{1E99}", "\u{0079}\u{030A}", "\u{1E99}", "\u{0079}\u{030A}"),
    ("\u{1E9A}", "\u{1E9A}", "\u{1E9A}", "\u{0061}\u{02BE}", "\u{0061}\u{02BE}"),
    ("\u{1E9B}", "\u{1E9B}", "\u{017F}\u{0307}", "\u{1E61}", "\u{0073}\u{0307}"),
    ("\u{1EA0}", "\u{1EA0}", "\u{0041}\u{0323}", "\u{1EA0}", "\u{0041}\u{0323}"),
    ("\u{1EA1}", "\u{1EA1}", "\u{0061}\u{0323}", "\u{1EA1}", "\u{0061}\u{0323}"),
    ("\u{1EA2}", "\u{1EA2}", "\u{0041}\u{0309}", "\u{1EA2}", "\u{0041}\u{0309}"),
    ("\u{1EA3}", "\u{1EA3}", "\u{0061}\u{0309}", "\u{1EA3}", "\u{0061}\u{0309}"),
    ("\u{1EA4}", "\u{1EA4}", "\u{0041}\u{0302}\u{0301}", "\u{1EA4}", "\u{0041}\u{0302}\u{0301}"),
    ("\u{1EA5}", "\u{1EA5}", "\u{0061}\u{0302}\u{0301}", "\u{1EA5}", "\u{0061}\u{0302}\u{0301}"),
    ("\u{1EA6}", "\u{1EA6}", "\u{0041}\u{0302}\u{0300}", "\u{1EA6}", "\u{0041}\u{0302}\u{0300}"),
    ("\u{1EA7}", "\u{1EA7}", "\u{0061}\u{0302}\u{0300}", "\u{1EA7}", "\u{0061}\u{0302}\u{0300}"),
    ("\u{1EA8}", "\u{1EA8}", "\u{0041}\u{0302}\u{0309}", "\u{1EA8}", "\u{0041}\u{0302}\u{0309}"),
    ("\u{1EA9}", "\u{1EA9}", "\u{0061}\u{0302}\u{0309}", "\u{1EA9}", "\u{0061}\u{0302}\u{0309}"),
    ("\u{1EAA}", "\u{1EAA}", "\u{0041}\u{0302}\u{0303}", "\u{1EAA}", "\u{0041}\u{0302}\u{0303}"),
    ("\u{1EAB}", "\u{1EAB}", "\u{0061}\u{0302}\u{0303}", "\u{1EAB}", "\u{0061}\u{0302}\u{0303}"),
    ("\u{1EAC}", "\u{1EAC}", "\u{0041}\u{0323}\u{0302}", "\u{1EAC}", "\u{0041}\u{0323}\u{0302}"),
    ("\u{1EAD}", "\u{1EAD}", "\u{0061}\u{0323}\u{0302}", "\u{1EAD}", "\u{0061}\u{0323}\u{0302}"),
    ("\u{1EAE}", "\u{1EAE}", "\u{0041}\u{0306}\u{0301}", "\u{1EAE}", "\u{0041}\u{0306}\u{0301}"),
    ("\u{1EAF}", "\u{1EAF}", "\u{0061}\u{0306}\u{0301}", "\u{1EAF}", "\u{0061}\u{0306}\u{0301}"),
    ("\u{1EB0}", "\u{1EB0}", "\u{0041}\u{0306}\u{0300}", "\u{1EB0}", "\u{0041}\u{0306}\u{0300}"),
    ("\u{1EB1}", "\u{1EB1}", "\u{0061}\u{0306}\u{0300}", "\u{1EB1}", "\u{0061}\u{0306}\u{0300}"),
    ("\u{1EB2}", "\u{1EB2}", "\u{0041}\u{0306}\u{0309}", "\u{1EB2}", "\u{0041}\u{0306}\u{0309}"),
    ("\u{1EB3}", "\u{1EB3}", "\u{0061}\u{0306}\u{0309}", "\u{1EB3}", "\u{0061}\u{0306}\u{0309}"),
    ("\u{1EB4}", "\u{1EB4}", "\u{0041}\u{0306}\u{0303}", "\u{1EB4}", "\u{0041}\u{0306}\u{0303}"),
    ("\u{1EB5}", "\u{1EB5}", "\u{0061}\u{0306}\u{0303}", "\u{1EB5}", "\u{0061}\u{0306}\u{0303}"),
    ("\u{1EB6}", "\u{1EB6}", "\u{0041}\u{0323}\u{0306}", "\u{1EB6}", "\u{0041}\u{0323}\u{0306}"),
    ("\u{1EB7}", "\u{1EB7}", "\u{0061}\u{0323}\u{0306}", "\u{1EB7}", "\u{0061}\u{0323}\u{0306}"),
    ("\u{1EB8}", "\u{1EB8}", "\u{0045}\u{0323}", "\u{1EB8}", "\u{0045}\u{0323}"),
    ("\u{1EB9}", "\u{1EB9}", "\u{0065}\u{0323}", "\u{1EB9}", "\u{0065}\u{0323}"),
    ("\u{1EBA}", "\u{1EBA}", "\u{0045}\u{0309}", "\u{1EBA}", "\u{0045}\u{0309}"),
    ("\u{1EBB}", "\u{1EBB}", "\u{0065}\u{0309}", "\u{1EBB}", "\u{0065}\u{0309}"),
    ("\u{1EBC}", "\u{1EBC}", "\u{0045}\u{0303}", "\u{1EBC}", "\u{0045}\u{0303}"),
    ("\u{1EBD}", "\u{1EBD}", "\u{0065}\u{0303}", "\u{1EBD}", "\u{0065}\u{0303}"),
    ("\u{1EBE}", "\u{1EBE}", "\u{0045}\u{0302}\u{0301}", "\u{1EBE}", "\u{0045}\u{0302}\u{0301}"),
    ("\u{1EBF}", "\u{1EBF}", "\u{0065}\u{0302}\u{0301}", "\u{1EBF}", "\u{0065}\u{0302}\u{0301}"),
    ("\u{1EC0}", "\u{1EC0}", "\u{0045}\u{0302}\u{0300}", "\u{1EC0}", "\u{0045}\u{0302}\u{0300}"),
    ("\u{1EC1}", "\u{1EC1}", "\u{0065}\u{0302}\u{0300}", "\u{1EC1}", "\u{0065}\u{0302}\u{0300}"),
    ("\u{1EC2}", "\u{1EC2}", "\u{0045}\u{0302}\u{0309}", "\u{1EC2}", "\u{0045}\u{0302}\u{0309}"),
    ("\u{1EC3}", "\u{1EC3}", "\u{0065}\u{0302}\u{0309}", "\u{1EC3}", "\u{0065}\u{0302}\u{0309}"),
    ("\u{1EC4}", "\u{1EC4}", "\u{0045}\u{0302}\u{0303}", "\u{1EC4}", "\u{0045}\u{0302}\u{0303}"),
    ("\u{1EC5}", "\u{1EC5}", "\u{0065}\u{0302}\u{0303}", "\u{1EC5}", "\u{0065}\u{0302}\u{0303}"),
    ("\u{1EC6}", "\u{1EC6}", "\u{0045}\u{0323}\u{0302}", "\u{1EC6}", "\u{0045}\u{0323}\u{0302}"),
    ("\u{1EC7}", "\u{1EC7}", "\u{0065}\u{0323}\u{0302}", "\u{1EC7}", "\u{0065}\u{0323}\u{0302}"),
    ("\u{1EC8}", "\u{1EC8}", "\u{0049}\u{0309}", "\u{1EC8}", "\u{0049}\u{0309}"),
    ("\u{1EC9}", "\u{1EC9}", "\u{0069}\u{0309}", "\u{1EC9}", "\u{0069}\u{0309}"),
    ("\u{1ECA}", "\u{1ECA}", "\u{0049}\u{0323}", "\u{1ECA}", "\u{0049}\u{0323}"),
    ("\u{1ECB}", "\u{1ECB}", "\u{0069}\u{0323}", "\u{1ECB}", "\u{0069}\u{0323}"),
    ("\u{1ECC}", "\u{1ECC}", "\u{004F}\u{0323}", "\u{1ECC}", "\u{004F}\u{0323}"),
    ("\u{1ECD}", "\u{1ECD}", "\u{006F}\u{0323}", "\u{1ECD}", "\u{006F}\u{0323}"),
    ("\u{1ECE}", "\u{1ECE}", "\u{004F}\u{0309}", "\u{1ECE}", "\u{004F}\u{0309}"),
    ("\u{1ECF}", "\u{1ECF}", "\u{006F}\u{0309}", "\u{1ECF}", "\u{006F}\u{0309}"),
    ("\u{1ED0}", "\u{1ED0}", "\u{004F}\u{0302}\u{0301}", "\u{1ED0}", "\u{004F}\u{0302}\u{0301}"),
    ("\u{1ED1}", "\u{1ED1}", "\u{006F}\u{0302}\u{0301}", "\u{1ED1}", "\u{006F}\u{0302}\u{0301}"),
    ("\u{1ED2}", "\u{1ED2}", "\u{004F}\u{0302}\u{0300}", "\u{1ED2}", "\u{004F}\u{0302}\u{0300}"),
    ("\u{1ED3}", "\u{1ED3}", "\u{006F}\u{0302}\u{0300}", "\u{1ED3}", "\u{006F}\u{0302}\u{0300}"),
    ("\u{1ED4}", "\u{1ED4}", "\u{004F}\u{0302}\u{0309}", "\u{1ED4}", "\u{004F}\u{0302}\u{0309}"),
    ("\u{1ED5}", "\u{1ED5}", "\u{006F}\u{0302}\u{0309}", "\u{1ED5}", "\u{006F}\u{0302}\u{0309}"),
    ("\u{1ED6}", "\u{1ED6}", "\u{004F}\u{0302}\u{0303}", "\u{1ED6}", "\u{004F}\u{0302}\u{0303}"),
    ("\u{1ED7}", "\u{1ED7}", "\u{006F}\u{0302}\u{0303}", "\u{1ED7}", "\u{006F}\u{0302}\u{0303}"),
    ("\u{1ED8}", "\u{1ED8}", "\u{004F}\u{0323}\u{0302}", "\u{1ED8}", "\u{004F}\u{0323}\u{0302}"),
    ("\u{1ED9}", "\u{1ED9}", "\u{006F}\u{0323}\u{0302}", "\u{1ED9}", "\u{006F}\u{0323}\u{0302}"),
    ("\u{1EDA}", "\u{1EDA}", "\u{004F}\u{031B}\u{0301}", "\u{1EDA}", "\u{004F}\u{031B}\u{0301}"),
    ("\u{1EDB}", "\u{1EDB}", "\u{006F}\u{031B}\u{0301}", "\u{1EDB}", "\u{006F}\u{031B}\u{0301}"),
    ("\u{1EDC}", "\u{1EDC}", "\u{004F}\u{031B}\u{0300}", "\u{1EDC}", "\u{004F}\u{031B}\u{0300}"),
    ("\u{1EDD}", "\u{1EDD}", "\u{006F}\u{031B}\u{0300}", "\u{1EDD}", "\u{006F}\u{031B}\u{0300}"),
    ("\u{1EDE}", "\u{1EDE}", "\u{004F}\u{031B}\u{0309}", "\u{1EDE}", "\u{004F}\u{031B}\u{0309}"),
    ("\u{1EDF}", "\u{1EDF}", "\u{006F}\u{031B}\u{0309}", "\u{1EDF}", "\u{006F}\u{031B}\u{0309}"),
    ("\u{1EE0}", "\u{1EE0}", "\u{004F}\u{031B}\u{0303}", "\u{1EE0}", "\u{004F}\u{031B}\u{0303}"),
    ("\u{1EE1}", "\u{1EE1}", "\u{006F}\u{031B}\u{0303}", "\u{1EE1}", "\u{006F}\u{031B}\u{0303}"),
    ("\u{1EE2}", "\u{1EE2}", "\u{004F}\u{031B}\u{0323}", "\u{1EE2}", "\u{004F}\u{031B}\u{0323}"),
    ("\u{1EE3}", "\u{1EE3}", "\u{006F}\u{031B}\u{0323}", "\u{1EE3}", "\u{006F}\u{031B}\u{0323}"),
    ("\u{1EE4}", "\u{1EE4}", "\u{0055}\u{0323}", "\u{1EE4}", "\u{0055}\u{0323}"),
    ("\u{1EE5}", "\u{1EE5}", "\u{0075}\u{0323}", "\u{1EE5}", "\u{0075}\u{0323}"),
    ("\u{1EE6}", "\u{1EE6}", "\u{0055}\u{0309}", "\u{1EE6}", "\u{0055}\u{0309}"),
    ("\u{1EE7}", "\u{1EE7}", "\u{0075}\u{0309}", "\u{1EE7}", "\u{0075}\u{0309}"),
    ("\u{1EE8}", "\u{1EE8}", "\u{0055}\u{031B}\u{0301}", "\u{1EE8}", "\u{0055}\u{031B}\u{0301}"),
    ("\u{1EE9}", "\u{1EE9}", "\u{0075}\u{031B}\u{0301}", "\u{1EE9}", "\u{0075}\u{031B}\u{0301}"),
    ("\u{1EEA}", "\u{1EEA}", "\u{0055}\u{031B}\u{0300}", "\u{1EEA}", "\u{0055}\u{031B}\u{0300}"),
    ("\u{1EEB}", "\u{1EEB}", "\u{0075}\u{031B}\u{0300}", "\u{1EEB}", "\u{0075}\u{031B}\u{0300}"),
    ("\u{1EEC}", "\u{1EEC}", "\u{0055}\u{031B}\u{0309}", "\u{1EEC}", "\u{0055}\u{031B}\u{0309}"),
    ("\u{1EED}", "\u{1EED}", "\u{0075}\u{031B}\u{0309}", "\u{1EED}", "\u{0075}\u{031B}\u{0309}"),
    ("\u{1EEE}", "\u{1EEE}", "\u{0055}\u{031B}\u{0303}", "\u{1EEE}", "\u{0055}\u{031B}\u{0303}"),
    ("\u{1EEF}", "\u{1EEF}", "\u{0075}\u{031B}\u{0303}", "\u{1EEF}", "\u{0075}\u{031B}\u{0303}"),
    ("\u{1EF0}", "\u{1EF0}", "\u{0055}\u{031B}\u{0323}", "\u{1EF0}", "\u{0055}\u{031B}\u{0323}"),
    ("\u{1EF1}", "\u{1EF1}", "\u{0075}\u{031B}\u{0323}", "\u{1EF1}", "\u{0075}\u{031B}\u{0323}"),
    ("\u{1EF2}", "\u{1EF2}", "\u{0059}\u{0300}", "\u{1EF2}", "\u{0059}\u{0300}"),
    ("\u{1EF3}", "\u{1EF3}", "\u{0079}\u{0300}", "\u{1EF3}", "\u{0079}\u{0300}"),
    ("\u{1EF4}", "\u{1EF4}", "\u{0059}\u{0323}", "\u{1EF4}", "\u{0059}\u{0323}"),
    ("\u{1EF5}", "\u{1EF5}", "\u{0079}\u{0323}", "\u{1EF5}", "\u{0079}\u{0323}"),
    ("\u{1EF6}", "\u{1EF6}", "\u{0059}\u{0309}", "\u{1EF6}", "\u{0059}\u{0309}"),
    ("\u{1EF7}", "\u{1EF7}", "\u{0079}\u{0309}", "\u{1EF7}", "\u{0079}\u{0309}"),
    ("\u{1EF8}", "\u{1EF8}", "\u{0059}\u{0303}", "\u{1EF8}", "\u{0059}\u{0303}"),
    ("\u{1EF9}", "\u{1EF9}", "\u{0079}\u{0303}", "\u{1EF9}", "\u{0079}\u{0303}"),
    ("\u{1F00}", "\u{1F00}", "\u{03B1}\u{0313}", "\u{1F00}", "\u{03B1}\u{0313}"),
    ("\u{1F01}", "\u{1F01}", "\u{03B1}\u{0314}", "\u{1F01}", "\u{03B1}\u{0314}"),
    ("\u{1F02}", "\u{1F02}", "\u{03B1}\u{0313}\u{0300}", "\u{1F02}", "\u{03B1}\u{0313}\u{0300}"),
    ("\u{1F03}", "\u{1F03}", "\u{03B1}\u{0314}\u{0300}", "\u{1F03}", "\u{03B1}\u{0314}\u{0300}"),
    ("\u{1F04}", "\u{1F04}", "\u{03B1}\u{0313}\u{0301}", "\u{1F04}", "\u{03B1}\u{0313}\u{0301}"),
    ("\u{1F05}", "\u{1F05}", "\u{03B1}\u{0314}\u{0301}", "\u{1F05}", "\u{03B1}\u{0314}\u{0301}"),
    ("\u{1F06}", "\u{1F06}", "\u{03B1}\u{0313}\u{0342}", "\u{1F06}", "\u{03B1}\u{0313}\u{0342}"),
    ("\u{1F07}", "\u{1F07}", "\u{03B1}\u{0314}\u{0342}", "\u{1F07}", "\u{03B1}\u{0314}\u{0342}"),
    ("\u{1F08}", "\u{1F08}", "\u{0391}\u{0313}", "\u{1F08}", "\u{0391}\u{0313}"),
    ("\u{1F09}", "\u{1F09}", "\u{0391}\u{0314}", "\u{1F09}", "\u{0391}\u{0314}"),
    ("\u{1F0A}", "\u{1F0A}", "\u{0391}\u{0313}\u{0300}", "\u{1F0A}", "\u{0391}\u{0313}\u{0300}"),
    ("\u{1F0B}", "\u{1F0B}", "\u{0391}\u{0314}\u{0300}", "\u{1F0B}", "\u{0391}\u{0314}\u{0300}"),
    ("\u{1F0C}", "\u{1F0C}", "\u{0391}\u{0313}\u{0301}", "\u{1F0C}", "\u{0391}\u{0313}\u{0301}"),
    ("\u{1F0D}", "\u{1F0D}", "\u{0391}\u{0314}\u{0301}", "\u{1F0D}", "\u{0391}\u{0314}\u{0301}"),
    ("\u{1F0E}", "\u{1F0E}", "\u{0391}\u{0313}\u{0342}", "\u{1F0E}", "\u{0391}\u{0313}\u{0342}"),
    ("\u{1F0F}", "\u{1F0F}", "\u{0391}\u{0314}\u{0342}", "\u{1F0F}", "\u{0391}\u{0314}\u{0342}"),
    ("\u{1F10}", "\u{1F10}", "\u{03B5}\u{0313}", "\u{1F10}", "\u{03B5}\u{0313}"),
    ("\u{1F11}", "\u{1F11}", "\u{03B5}\u{0314}", "\u{1F11}", "\u{03B5}\u{0314}"),
    ("\u{1F12}", "\u{1F12}", "\u{03B5}\u{0313}\u{0300}", "\u{1F12}", "\u{03B5}\u{0313}\u{0300}"),
    ("\u{1F13}", "\u{1F13}", "\u{03B5}\u{0314}\u{0300}", "\u{1F13}", "\u{03B5}\u{0314}\u{0300}"),
    ("\u{1F14}", "\u{1F14}", "\u{03B5}\u{0313}\u{0301}", "\u{1F14}", "\u{03B5}\u{0313}\u{0301}"),
    ("\u{1F15}", "\u{1F15}", "\u{03B5}\u{0314}\u{0301}", "\u{1F15}", "\u{03B5}\u{0314}\u{0301}"),
    ("\u{1F18}", "\u{1F18}", "\u{0395}\u{0313}", "\u{1F18}", "\u{0395}\u{0313}"),
    ("\u{1F19}", "\u{1F19}", "\u{0395}\u{0314}", "\u{1F19}", "\u{0395}\u{0314}"),
    ("\u{1F1A}", "\u{1F1A}", "\u{0395}\u{0313}\u{0300}", "\u{1F1A}", "\u{0395}\u{0313}\u{0300}"),
    ("\u{1F1B}", "\u{1F1B}", "\u{0395}\u{0314}\u{0300}", "\u{1F1B}", "\u{0395}\u{0314}\u{0300}"),
    ("\u{1F1C}", "\u{1F1C}", "\u{0395}\u{0313}\u{0301}", "\u{1F1C}", "\u{0395}\u{0313}\u{0301}"),
    ("\u{1F1D}", "\u{1F1D}", "\u{0395}\u{0314}\u{0301}", "\u{1F1D}", "\u{0395}\u{0314}\u{0301}"),
    ("\u{1F20}", "\u{1F20}", "\u{03B7}\u{0313}", "\u{1F20}", "\u{03B7}\u{0313}"),
    ("\u{1F21}", "\u{1F21}", "\u{03B7}\u{0314}", "\u{1F21}", "\u{03B7}\u{0314}"),
    ("\u{1F22}", "\u{1F22}", "\u{03B7}\u{0313}\u{0300}", "\u{1F22}", "\u{03B7}\u{0313}\u{0300}"),
    ("\u{1F23}", "\u{1F23}", "\u{03B7}\u{0314}\u{0300}", "\u{1F23}", "\u{03B7}\u{0314}\u{0300}"),
    ("\u{1F24}", "\u{1F24}", "\u{03B7}\u{0313}\u{0301}", "\u{1F24}", "\u{03B7}\u{0313}\u{0301}"),
    ("\u{1F25}", "\u{1F25}", "\u{03B7}\u{0314}\u{0301}", "\u{1F25}", "\u{03B7}\u{0314}\u{0301}"),
    ("\u{1F26}", "\u{1F26}", "\u{03B7}\u{0313}\u{0342}", "\u{1F26}", "\u{03B7}\u{0313}\u{0342}"),
    ("\u{1F27}", "\u{1F27}", "\u{03B7}\u{0314}\u{0342}", "\u{1F27}", "\u{03B7}\u{0314}\u{0342}"),
    ("\u{1F28}", "\u{1F28}", "\u{0397}\u{0313}", "\u{1F28}", "\u{0397}\u{0313}"),
    ("\u{1F29}", "\u{1F29}", "\u{0397}\u{0314}", "\u{1F29}", "\u{0397}\u{0314}"),
    ("\u{1F2A}", "\u{1F2A}", "\u{0397}\u{0313}\u{0300}", "\u{1F2A}", "\u{0397}\u{0313}\u{0300}"),
    ("\u{1F2B}", "\u{1F2B}", "\u{0397}\u{0314}\u{0300}", "\u{1F2B}", "\u{0397}\u{0314}\u{0300}"),
    ("\u{1F2C}", "\u{1F2C}", "\u{0397}\u{0313}\u{0301}", "\u{1F2C}", "\u{0397}\u{0313}\u{0301}"),
    ("\u{1F2D}", "\u{1F2D}", "\u{0397}\u{0314}\u{0301}", "\u{1F2D}", "\u{0397}\u{0314}\u{0301}"),
    ("\u{1F2E}", "\u{1F2E}", "\u{0397}\u{0313}\u{0342}", "\u{1F2E}", "\u{0397}\u{0313}\u{0342}"),
    ("\u{1F2F}", "\u{1F2F}", "\u{0397}\u{0314}\u{0342}", "\u{1F2F}", "\u{0397}\u{0314}\u{0342}"),
    ("\u{1F30}", "\u{1F30}", "\u{03B9}\u{0313}", "\u{1F30}", "\u{03B9}\u{0313}"),
    ("\u{1F31}", "\u{1F31}", "\u{03B9}\u{0314}", "\u{1F31}", "\u{03B9}\u{0314}"),
    ("\u{1F32}", "\u{1F32}", "\u{03B9}\u{0313}\u{0300}", "\u{1F32}", "\u{03B9}\u{0313}\u{0300}"),
    ("\u{1F33}", "\u{1F33}", "\u{03B9}\u{0314}\u{0300}", "\u{1F33}", "\u{03B9}\u{0314}\u{0300}"),
    ("\u{1F34}", "\u{1F34}", "\u{03B9}\u{0313}\u{0301}", "\u{1F34}", "\u{03B9}\u{0313}\u{0301}"),
    ("\u{1F35}", "\u{1F35}", "\u{03B9}\u{0314}\u{0301}", "\u{1F35}", "\u{03B9}\u{0314}\u{0301}"),
    ("\u{1F36}", "\u{1F36}", "\u{03B9}\u{0313}\u{0342}", "\u{1F36}", "\u{03B9}\u{0313}\u{0342}"),
    ("\u{1F37}", "\u{1F37}", "\u{03B9}\u{0314}\u{0342}", "\u{1F37}", "\u{03B9}\u{0314}\u{0342}"),
    ("\u{1F38}", "\u{1F38}", "\u{0399}\u{0313}", "\u{1F38}", "\u{0399}\u{0313}"),
    ("\u{1F39}", "\u{1F39}", "\u{0399}\u{0314}", "\u{1F39}", "\u{0399}\u{0314}"),
    ("\u{1F3A}", "\u{1F3A}", "\u{0399}\u{0313}\u{0300}", "\u{1F3A}", "\u{0399}\u{0313}\u{0300}"),
    ("\u{1F3B}", "\u{1F3B}", "\u{0399}\u{0314}\u{0300}", "\u{1F3B}", "\u{0399}\u{0314}\u{0300}"),
    ("\u{1F3C}", "\u{1F3C}", "\u{0399}\u{0313}\u{0301}", "\u{1F3C}", "\u{0399}\u{0313}\u{0301}"),
    ("\u{1F3D}", "\u{1F3D}", "\u{0399}\u{0314}\u{0301}", "\u{1F3D}", "\u{0399}\u{0314}\u{0301}"),
    ("\u{1F3E}", "\u{1F3E}", "\u{0399}\u{0313}\u{0342}", "\u{1F3E}", "\u{0399}\u{0313}\u{0342}"),
    ("\u{1F3F}", "\u{1F3F}", "\u{0399}\u{0314}\u{0342}", "\u{1F3F}", "\u{0399}\u{0314}\u{0342}"),
    ("\u{1F40}", "\u{1F40}", "\u{03BF}\u{0313}", "\u{1F40}", "\u{03BF}\u{0313}"),
    ("\u{1F41}", "\u{1F41}", "\u{03BF}\u{0314}", "\u{1F41}", "\u{03BF}\u{0314}"),
    ("\u{1F42}", "\u{1F42}", "\u{03BF}\u{0313}\u{0300}", "\u{1F42}", "\u{03BF}\u{0313}\u{0300}"),
    ("\u{1F43}", "\u{1F43}", "\u{03BF}\u{0314}\u{0300}", "\u{1F43}", "\u{03BF}\u{0314}\u{0300}"),
    ("\u{1F44}", "\u{1F44}", "\u{03BF}\u{0313}\u{0301}", "\u{1F44}", "\u{03BF}\u{0313}\u{0301}"),
    ("\u{1F45}", "\u{1F45}", "\u{03BF}\u{0314}\u{0301}", "\u{1F45}", "\u{03BF}\u{0314}\u{0301}"),
    ("\u{1F48}", "\u{1F48}", "\u{039F}\u{0313}", "\u{1F48}", "\u{039F}\u{0313}"),
    ("\u{1F49}", "\u{1F49}", "\u{039F}\u{0314}", "\u{1F49}", "\u{039F}\u{0314}"),
    ("\u{1F4A}", "\u{1F4A}", "\u{039F}\u{0313}\u{0300}", "\u{1F4A}", "\u{039F}\u{0313}\u{0300}"),
    ("\u{1F4B}", "\u{1F4B}", "\u{039F}\u{0314}\u{0300}", "\u{1F4B}", "\u{039F}\u{0314}\u{0300}"),
    ("\u{1F4C}", "\u{1F4C}", "\u{039F}\u{0313}\u{0301}", "\u{1F4C}", "\u{039F}\u{0313}\u{0301}"),
    ("\u{1F4D}", "\u{1F4D}", "\u{039F}\u{0314}\u{0301}", "\u{1F4D}", "\u{039F}\u{0314}\u{0301}"),
    ("\u{1F50}", "\u{1F50}", "\u{03C5}\u{0313}", "\u{1F50}", "\u{03C5}\u{0313}"),
    ("\u{1F51}", "\u{1F51}", "\u{03C5}\u{0314}", "\u{1F51}", "\u{03C5}\u{0314}"),
    ("\u{1F52}", "\u{1F52}", "\u{03C5}\u{0313}\u{0300}", "\u{1F52}", "\u{03C5}\u{0313}\u{0300}"),
    ("\u{1F53}", "\u{1F53}", "\u{03C5}\u{0314}\u{0300}", "\u{1F53}", "\u{03C5}\u{0314}\u{0300}"),
    ("\u{1F54}", "\u{1F54}", "\u{03C5}\u{0313}\u{0301}", "\u{1F54}", "\u{03C5}\u{0313}\u{0301}"),
    ("\u{1F55}", "\u{1F55}", "\u{03C5}\u{0314}\u{0301}", "\u{1F55}", "\u{03C5}\u{0314}\u{0301}"),
    ("\u{1F56}", "\u{1F56}", "\u{03C5}\u{0313}\u{0342}", "\u{1F56}", "\u{03C5}\u{0313}\u{0342}"),
    ("\u{1F57}", "\u{1F57}", "\u{03C5}\u{0314}\u{0342}", "\u{1F57}", "\u{03C5}\u{0314}\u{0342}"),
    ("\u{1F59}", "\u{1F59}", "\u{03A5}\u{0314}", "\u{1F59}", "\u{03A5}\u{0314}"),
    ("\u{1F5B}", "\u{1F5B}", "\u{03A5}\u{0314}\u{0300}", "\u{1F5B}", "\u{03A5}\u{0314}\u{0300}"),
    ("\u{1F5D}", "\u{1F5D}", "\u{03A5}\u{0314}\u{0301}", "\u{1F5D}", "\u{03A5}\u{0314}\u{0301}"),
    ("\u{1F5F}", "\u{1F5F}", "\u{03A5}\u{0314}\u{0342}", "\u{1F5F}", "\u{03A5}\u{0314}\u{0342}"),
    ("\u{1F60}", "\u{1F60}", "\u{03C9}\u{0313}", "\u{1F60}", "\u{03C9}\u{0313}"),
    ("\u{1F61}", "\u{1F61}", "\u{03C9}\u{0314}", "\u{1F61}", "\u{03C9}\u{0314}"),
    ("\u{1F62}", "\u{1F62}", "\u{03C9}\u{0313}\u{0300}", "\u{1F62}", "\u{03C9}\u{0313}\u{0300}"),
    ("\u{1F63}", "\u{1F63}", "\u{03C9}\u{0314}\u{0300}", "\u{1F63}", "\u{03C9}\u{0314}\u{0300}"),
    ("\u{1F64}", "\u{1F64}", "\u{03C9}\u{0313}\u{0301}", "\u{1F64}", "\u{03C9}\u{0313}\u{0301}"),
    ("\u{1F65}", "\u{1F65}", "\u{03C9}\u{0314}\u{0301}", "\u{1F65}", "\u{03C9}\u{0314}\u{0301}"),
    ("\u{1F66}", "\u{1F66}", "\u{03C9}\u{0313}\u{0342}", "\u{1F66}", "\u{03C9}\u{0313}\u{0342}"),
    ("\u{1F67}", "\u{1F67}", "\u{03C9}\u{0314}\u{0342}", "\u{1F67}", "\u{03C9}\u{0314}\u{0342}"),
    ("\u{1F68}", "\u{1F68}", "\u{03A9}\u{0313}", "\u{1F68}", "\u{03A9}\u{0313}"),
    ("\u{1F69}", "\u{1F69}", "\u{03A9}\u{0314}", "\u{1F69}", "\u{03A9}\u{0314}"),
    ("\u{1F6A}", "\u{1F6A}", "\u{03A9}\u{0313}\u{0300}", "\u{1F6A}", "\u{03A9}\u{0313}\u{0300}"),
    ("\u{1F6B}", "\u{1F6B}", "\u{03A9}\u{0314}\u{0300}", "\u{1F6B}", "\u{03A9}\u{0314}\u{0300}"),
    ("\u{1F6C}", "\u{1F6C}", "\u{03A9}\u{0313}\u{0301}", "\u{1F6C}", "\u{03A9}\u{0313}\u{0301}"),
    ("\u{1F6D}", "\u{1F6D}", "\u{03A9}\u{0314}\u{0301}", "\u{1F6D}", "\u{03A9}\u{0314}\u{0301}"),
    ("\u{1F6E}", "\u{1F6E}", "\u{03A9}\u{0313}\u{0342}", "\u{1F6E}", "\u{03A9}\u{0313}\u{0342}"),
    ("\u{1F6F}", "\u{1F6F}", "\u{03A9}\u{0314}\u{0342}", "\u{1F6F}", "\u{03A9}\u{0314}\u{0342}"),
    ("\u{1F70}", "\u{1F70}", "\u{03B1}\u{0300}", "\u{1F70}", "\u{03B1}\u{0300}"),
    ("\u{1F71}", "\u{03AC}", "\u{03B1}\u{0301}", "\u{03AC}", "\u{03B1}\u{0301}"),
    ("\u{1F72}", "\u{1F72}", "\u{03B5}\u{0300}", "\u{1F72}", "\u{03B5}\u{0300}"),
    ("\u{1F73}", "\u{03AD}", "\u{03B5}\u{0301}", "\u{03AD}", "\u{03B5}\u{0301}"),
    ("\u{1F74}", "\u{1F74}", "\u{03B7}\u{0300}", "\u{1F74}", "\u{03B7}\u{0300}"),
    ("\u{1F75}", "\u{03AE}", "\u{03B7}\u{0301}", "\u{03AE}", "\u{03B7}\u{0301}"),
    ("\u{1F76}", "\u{1F76}", "\u{03B9}\u{0300}", "\u{1F76}", "\u{03B9}\u{0300}"),
    ("\u{1F77}", "\u{03AF}", "\u{03B9}\u{0301}", "\u{03AF}", "\u{03B9}\u{0301}"),
    ("\u{1F78}", "\u{1F78}", "\u{03BF}\u{0300}", "\u{1F78}", "\u{03BF}\u{0300}"),
    ("\u{1F79}", "\u{03CC}", "\u{03BF}\u{0301}", "\u{03CC}", "\u{03BF}\u{0301}"),
    ("\u{1F7A}", "\u{1F7A}", "\u{03C5}\u{0300}", "\u{1F7A}", "\u{03C5}\u{0300}"),
    ("\u{1F7B}", "\u{03CD}", "\u{03C5}\u{0301}", "\u{03CD}", "\u{03C5}\u{0301}"),
    ("\u{1F7C}", "\u{1F7C}", "\u{03C9}\u{0300}", "\u{1F7C}", "\u{03C9}\u{0300}"),
    ("\u{1F7D}", "\u{03CE}", "\u{03C9}\u{0301}", "\u{03CE}", "\u{03C9}\u{0301}"),
    ("\u{1F80}", "\u{1F80}", "\u{03B1}\u{0313}\u{0345}", "\u{1F80}", "\u{03B1}\u{0313}\u{0345}"),
    ("\u{1F81}", "\u{1F81}", "\u{03B1}\u{0314}\u{0345}", "\u{1F81}", "\u{03B1}\u{0314}\u{0345}"),
    ("\u{1F82}", "\u{1F82}", "\u{03B1}\u{0313}\u{0300}\u{0345}", "\u{1F82}", "\u{03B1}\u{0313}\u{0300}\u{0345}"),
    ("\u{1F83}", "\u{1F83}", "\u{03B1}\u{0314}\u{0300}\u{0345}", "\u{1F83}", "\u{03B1}\u{0314}\u{0300}\u{0345}"),
    ("\u{1F84}", "\u{1F84}", "\u{03B1}\u{0313}\u{0301}\u{0345}", "\u{1F84}", "\u{03B1}\u{0313}\u{0301}\u{0345}"),
    ("\u{1F85}", "\u{1F85}", "\u{03B1}\u{0314}\u{0301}\u{0345}", "\u{1F85}", "\u{03B1}\u{0314}\u{0301}\u{0345}"),
    ("\u{1F86}", "\u{1F86}", "\u{03B1}\u{0313}\u{0342}\u{0345}", "\u{1F86}", "\u{03B1}\u{0313}\u{0342}\u{0345}"),
    ("\u{1F87}", "\u{1F87}", "\u{03B1}\u{0314}\u{0342}\u{0345}", "\u{1F87}", "\u{03B1}\u{0314}\u{0342}\u{0345}"),
    ("\u{1F88}", "\u{1F88}", "\u{0391}\u{0313}\u{0345}", "\u{1F88}", "\u{0391}\u{0313}\u{0345}"),
    ("\u{1F89}", "\u{1F89}", "\u{0391}\u{0314}\u{0345}", "\u{1F89}", "\u{0391}\u{0314}\u{0345}"),
    ("\u{1F8A}", "\u{1F8A}", "\u{0391}\u{0313}\u{0300}\u{0345}", "\u{1F8A}", "\u{0391}\u{0313}\u{0300}\u{0345}"),
    ("\u{1F8B}", "\u{1F8B}", "\u{0391}\u{0314}\u{0300}\u{0345}", "\u{1F8B}", "\u{0391}\u{0314}\u{0300}\u{0345}"),
    ("\u{1F8C}", "\u{1F8C}", "\u{0391}\u{0313}\u{0301}\u{0345}", "\u{1F8C}", "\u{0391}\u{0313}\u{0301}\u{0345}"),
    ("\u{1F8D}", "\u{1F8D}", "\u{0391}\u{0314}\u{0301}\u{0345}", "\u{1F8D}", "\u{0391}\u{0314}\u{0301}\u{0345}"),
    ("\u{1F8E}", "\u{1F8E}", "\u{0391}\u{0313}\u{0342}\u{0345}", "\u{1F8E}", "\u{0391}\u{0313}\u{0342}\u{0345}"),
    ("\u{1F8F}", "\u{1F8F}", "\u{0391}\u{0314}\u{0342}\u{0345}", "\u{1F8F}", "\u{0391}\u{0314}\u{0342}\u{0345}"),
    ("\u{1F90}", "\u{1F90}", "\u{03B7}\u{0313}\u{0345}", "\u{1F90}", "\u{03B7}\u{0313}\u{0345}"),
    ("\u{1F91}", "\u{1F91}", "\u{03B7}\u{0314}\u{0345}", "\u{1F91}", "\u{03B7}\u{0314}\u{0345}"),
    ("\u{1F92}", "\u{1F92}", "\u{03B7}\u{0313}\u{0300}\u{0345}", "\u{1F92}", "\u{03B7}\u{0313}\u{0300}\u{0345}"),
    ("\u{1F93}", "\u{1F93}", "\u{03B7}\u{0314}\u{0300}\u{0345}", "\u{1F93}", "\u{03B7}\u{0314}\u{0300}\u{0345}"),
    ("\u{1F94}", "\u{1F94}", "\u{03B7}\u{0313}\u{0301}\u{0345}", "\u{1F94}", "\u{03B7}\u{0313}\u{0301}\u{0345}"),
    ("\u{1F95}", "\u{1F95}", "\u{03B7}\u{0314}\u{0301}\u{0345}", "\u{1F95}", "\u{03B7}\u{0314}\u{0301}\u{0345}"),
    ("\u{1F96}", "\u{1F96}", "\u{03B7}\u{0313}\u{0342}\u{0345}", "\u{1F96}", "\u{03B7}\u{0313}\u{0342}\u{0345}"),
    ("\u{1F97}", "\u{1F97}", "\u{03B7}\u{0314}\u{0342}\u{0345}", "\u{1F97}", "\u{03B7}\u{0314}\u{0342}\u{0345}"),
    ("\u{1F98}", "\u{1F98}", "\u{0397}\u{0313}\u{0345}", "\u{1F98}", "\u{0397}\u{0313}\u{0345}"),
    ("\u{1F99}", "\u{1F99}", "\u{0397}\u{0314}\u{0345}", "\u{1F99}", "\u{0397}\u{0314}\u{0345}"),
    ("\u{1F9A}", "\u{1F9A}", "\u{0397}\u{0313}\u{0300}\u{0345}", "\u{1F9A}", "\u{0397}\u{0313}\u{0300}\u{0345}"),
    ("\u{1F9B}", "\u{1F9B}", "\u{0397}\u{0314}\u{0300}\u{0345}", "\u{1F9B}", "\u{0397}\u{0314}\u{0300}\u{0345}"),
    ("\u{1F9C}", "\u{1F9C}", "\u{0397}\u{0313}\u{0301}\u{0345}", "\u{1F9C}", "\u{0397}\u{0313}\u{0301}\u{0345}"),
    ("\u{1F9D}", "\u{1F9D}", "\u{0397}\u{0314}\u{0301}\u{0345}", "\u{1F9D}", "\u{0397}\u{0314}\u{0301}\u{0345}"),
    ("\u{1F9E}", "\u{1F9E}", "\u{0397}\u{0313}\u{0342}\u{0345}", "\u{1F9E}", "\u{0397}\u{0313}\u{0342}\u{0345}"),
    ("\u{1F9F}", "\u{1F9F}", "\u{0397}\u{0314}\u{0342}\u{0345}", "\u{1F9F}", "\u{0397}\u{0314}\u{0342}\u{0345}"),
    ("\u{1FA0}", "\u{1FA0}", "\u{03C9}\u{0313}\u{0345}", "\u{1FA0}", "\u{03C9}\u{0313}\u{0345}"),
    ("\u{1FA1}", "\u{1FA1}", "\u{03C9}\u{0314}\u{0345}", "\u{1FA1}", "\u{03C9}\u{0314}\u{0345}"),
    ("\u{1FA2}", "\u{1FA2}", "\u{03C9}\u{0313}\u{0300}\u{0345}", "\u{1FA2}", "\u{03C9}\u{0313}\u{0300}\u{0345}"),
    ("\u{1FA3}", "\u{1FA3}", "\u{03C9}\u{0314}\u{0300}\u{0345}", "\u{1FA3}", "\u{03C9}\u{0314}\u{0300}\u{0345}"),
    ("\u{1FA4}", "\u{1FA4}", "\u{03C9}\u{0313}\u{0301}\u{0345}", "\u{1FA4}", "\u{03C9}\u{0313}\u{0301}\u{0345}"),
    ("\u{1FA5}", "\u{1FA5}", "\u{03C9}\u{0314}\u{0301}\u{0345}", "\u{1FA5}", "\u{03C9}\u{0314}\u{0301}\u{0345}"),
    ("\u{1FA6}", "\u{1FA6}", "\u{03C9}\u{0313}\u{0342}\u{0345}", "\u{1FA6}", "\u{03C9}\u{0313}\u{0342}\u{0345}"),
    ("\u{1FA7}", "\u{1FA7}", "\u{03C9}\u{0314}\u{0342}\u{0345}", "\u{1FA7}", "\u{03C9}\u{0314}\u{0342}\u{0345}"),
    ("\u{1FA8}", "\u{1FA8}", "\u{03A9}\u{0313}\u{0345}", "\u{1FA8}", "\u{03A9}\u{0313}\u{0345}"),
    ("\u{1FA9}", "\u{1FA9}", "\u{03A9}\u{0314}\u{0345}", "\u{1FA9}", "\u{03A9}\u{0314}\u{0345}"),
    ("\u{1FAA}", "\u{1FAA}", "\u{03A9}\u{0313}\u{0300}\u{0345}", "\u{1FAA}", "\u{03A9}\u{0313}\u{0300}\u{0345}"),
    ("\u{1FAB}", "\u{1FAB}", "\u{03A9}\u{0314}\u{0300}\u{0345}", "\u{1FAB}", "\u{03A9}\u{0314}\u{0300}\u{0345}"),
    ("\u{1FAC}", "\u{1FAC}", "\u{03A9}\u{0313}\u{0301}\u{0345}", "\u{1FAC}", "\u{03A9}\u{0313}\u{0301}\u{0345}"),
    ("\u{1FAD}", "\u{1FAD}", "\u{03A9}\u{0314}\u{0301}\u{0345}", "\u{1FAD}", "\u{03A9}\u{0314}\u{0301}\u{0345}"),
    ("\u{1FAE}", "\u{1FAE}", "\u{03A9}\u{0313}\u{0342}\u{0345}", "\u{1FAE}", "\u{03A9}\u{0313}\u{0342}\u{0345}"),
    ("\u{1FAF}", "\u{1FAF}", "\u{03A9}\u{0314}\u{0342}\u{0345}", "\u{1FAF}", "\u{03A9}\u{0314}\u{0342}\u{0345}"),
    ("\u{1FB0}", "\u{1FB0}", "\u{03B1}\u{0306}", "\u{1FB0}", "\u{03B1}\u{0306}"),
    ("\u{1FB1}", "\u{1FB1}", "\u{03B1}\u{0304}", "\u{1FB1}", "\u{03B1}\u{0304}"),
    ("\u{1FB2}", "\u{1FB2}", "\u{03B1}\u{0300}\u{0345}", "\u{1FB2}", "\u{03B1}\u{0300}\u{0345}"),
    ("\u{1FB3}", "\u{1FB3}", "\u{03B1}\u{0345}", "\u{1FB3}", "\u{03B1}\u{0345}"),
    ("\u{1FB4}", "\u{1FB4}", "\u{03B1}\u{0301}\u{0345}", "\u{1FB4}", "\u{03B1}\u{0301}\u{0345}"),
    ("\u{1FB6}", "\u{1FB6}", "\u{03B1}\u{0342}", "\u{1FB6}", "\u{03B1}\u{0342}"),
    ("\u{1FB7}", "\u{1FB7}", "\u{03B1}\u{0342}\u{0345}", "\u{1FB7}", "\u{03B1}\u{0342}\u{0345}"),
    ("\u{1FB8}", "\u{1FB8}", "\u{0391}\u{0306}", "\u{1FB8}", "\u{0391}\u{0306}"),
    ("\u{1FB9}", "\u{1FB9}", "\u{0391}\u{0304}", "\u{1FB9}", "\u{0391}\u{0304}"),
    ("\u{1FBA}", "\u{1FBA}", "\u{0391}\u{0300}", "\u{1FBA}", "\u{0391}\u{0300}"),
    ("\u{1FBB}", "\u{0386}", "\u{0391}\u{0301}", "\u{0386}", "\u{0391}\u{0301}"),
    ("\u{1FBC}", "\u{1FBC}", "\u{0391}\u{0345}", "\u{1FBC}", "\u{0391}\u{0345}"),
    ("\u{1FBD}", "\u{1FBD}", "\u{1FBD}", "\u{0020}\u{0313}", "\u{0020}\u{0313}"),
    ("\u{1FBE}", "\u{03B9}", "\u{03B9}", "\u{03B9}", "\u{03B9}"),
    ("\u{1FBF}", "\u{1FBF}", "\u{1FBF}", "\u{0020}\u{0313}", "\u{0020}\u{0313}"),
    ("\u{1FC0}", "\u{1FC0}", "\u{1FC0}", "\u{0020}\u{0342}", "\u{0020}\u{0342}"),
    ("\u{1FC1}", "\u{1FC1}", "\u{00A8}\u{0342}", "\u{0020}\u{0308}\u{0342}", "\u{0020}\u{0308}\u{0342}"),
    ("\u{1FC2}", "\u{1FC2}", "\u{03B7}\u{0300}\u{0345}", "\u{1FC2}", "\u{03B7}\u{0300}\u{0345}"),
    ("\u{1FC3}", "\u{1FC3}", "\u{03B7}\u{0345}", "\u{1FC3}", "\u{03B7}\u{0345}"),
    ("\u{1FC4}", "\u{1FC4}", "\u{03B7}\u{0301}\u{0345}", "\u{1FC4}", "\u{03B7}\u{0301}\u{0345}"),
    ("\u{1FC6}", "\u{1FC6}", "\u{03B7}\u{0342}", "\u{1FC6}", "\u{03B7}\u{0342}"),
    ("\u{1FC7}", "\u{1FC7}", "\u{03B7}\u{0342}\u{0345}", "\u{1FC7}", "\u{03B7}\u{0342}\u{0345}"),
    ("\u{1FC8}", "\u{1FC8}", "\u{0395}\u{0300}", "\u{1FC8}", "\u{0395}\u{0300}"),
    ("\u{1FC9}", "\u{0388}", "\u{0395}\u{0301}", "\u{0388}", "\u{0395}\u{0301}"),
    ("\u{1FCA}", "\u{1FCA}", "\u{0397}\u{0300}", "\u{1FCA}", "\u{0397}\u{0300}"),
    ("\u{1FCB}", "\u{0389}", "\u{0397}\u{0301}", "\u{0389}", "\u{0397}\u{0301}"),
    ("\u{1FCC}", "\u{1FCC}", "\u{0397}\u{0345}", "\u{1FCC}", "\u{0397}\u{0345}"),
    ("\u{1FCD}", "\u{1FCD}", "\u{1FBF}\u{0300}", "\u{0020}\u{0313}\u{0300}", "\u{0020}\u{0313}\u{0300}"),
    ("\u{1FCE}", "\u{1FCE}", "\u{1FBF}\u{0301}", "\u{0020}\u{0313}\u{0301}", "\u{0020}\u{0313}\u{0301}"),
    ("\u{1FCF}", "\u{1FCF}", "\u{1FBF}\u{0342}", "\u{0020}\u{0313}\u{0342}", "\u{0020}\u{0313}\u{0342}"),
    ("\u{1FD0}", "\u{1FD0}", "\u{03B9}\u{0306}", "\u{1FD0}", "\u{03B9}\u{0306}"),
    ("\u{1FD1}", "\u{1FD1}", "\u{03B9}\u{0304}", "\u{1FD1}", "\u{03B9}\u{0304}"),
    ("\u{1FD2}", "\u{1FD2}", "\u{03B9}\u{0308}\u{0300}", "\u{1FD2}", "\u{03B9}\u{0308}\u{0300}"),
    ("\u{1FD3}", "\u{0390}", "\u{03B9}\u{0308}\u{0301}", "\u{0390}", "\u{03B9}\u{0308}\u{0301}"),
    ("\u{1FD6}", "\u{1FD6}", "\u{03B9}\u{0342}", "\u{1FD6}", "\u{03B9}\u{0342}"),
    ("\u{1FD7}", "\u{1FD7}", "\u{03B9}\u{0308}\u{0342}", "\u{1FD7}", "\u{03B9}\u{0308}\u{0342}"),
    ("\u{1FD8}", "\u{1FD8}", "\u{0399}\u{0306}", "\u{1FD8}", "\u{0399}\u{0306}"),
    ("\u{1FD9}", "\u{1FD9}", "\u{0399}\u{0304}", "\u{1FD9}", "\u{0399}\u{0304}"),
    ("\u{1FDA}", "\u{1FDA}", "\u{0399}\u{0300}", "\u{1FDA}", "\u{0399}\u{0300}"),
    ("\u{1FDB}", "\u{038A}", "\u{0399}\u{0301}", "\u{038A}", "\u{0399}\u{0301}"),
    ("\u{1FDD}", "\u{1FDD}", "\u{1FFE}\u{0300}", "\u{0020}\u{0314}\u{0300}", "\u{0020}\u{0314}\u{0300}"),
    ("\u{1FDE}", "\u{1FDE}", "\u{1FFE}\u{0301}", "\u{0020}\u{0314}\u{0301}", "\u{0020}\u{0314}\u{0301}"),
    ("\u{1FDF}", "\u{1FDF}", "\u{1FFE}\u{0342}", "\u{0020}\u{0314}\u{0342}", "\u{0020}\u{0314}\u{0342}"),
    ("\u{1FE0}", "\u{1FE0}", "\u{03C5}\u{0306}", "\u{1FE0}", "\u{03C5}\u{0306}"),
    ("\u{1FE1}", "\u{1FE1}", "\u{03C5}\u{0304}", "\u{1FE1}", "\u{03C5}\u{0304}"),
    ("\u{1FE2}", "\u{1FE2}", "\u{03C5}\u{0308}\u{0300}", "\u{1FE2}", "\u{03C5}\u{0308}\u{0300}"),
    ("\u{1FE3}", "\u{03B0}", "\u{03C5}\u{0308}\u{0301}", "\u{03B0}", "\u{03C5}\u{0308}\u{0301}"),
    ("\u{1FE4}", "\u{1FE4}", "\u{03C1}\u{0313}", "\u{1FE4}", "\u{03C1}\u{0313}"),
    ("\u{1FE5}", "\u{1FE5}", "\u{03C1}\u{0314}", "\u{1FE5}", "\u{03C1}\u{0314}"),
    ("\u{1FE6}", "\u{1FE6}", "\u{03C5}\u{0342}", "\u{1FE6}", "\u{03C5}\u{0342}"),
    ("\u{1FE7}", "\u{1FE7}", "\u{03C5}\u{0308}\u{0342}", "\u{1FE7}", "\u{03C5}\u{0308}\u{0342}"),
    ("\u{1FE8}", "\u{1FE8}", "\u{03A5}\u{0306}", "\u{1FE8}", "\u{03A5}\u{0306}"),
    ("\u{1FE9}", "\u{1FE9}", "\u{03A5}\u{0304}", "\u{1FE9}", "\u{03A5}\u{0304}"),
    ("\u{1FEA}", "\u{1FEA}", "\u{03A5}\u{0300}", "\u{1FEA}", "\u{03A5}\u{0300}"),
    ("\u{1FEB}", "\u{038E}", "\u{03A5}\u{0301}", "\u{038E}", "\u{03A5}\u{0301}"),
    ("\u{1FEC}", "\u{1FEC}", "\u{03A1}\u{0314}", "\u{1FEC}", "\u{03A1}\u{0314}"),
    ("\u{1FED}", "\u{1FED}", "\u{00A8}\u{0300}", "\u{0020}\u{0308}\u{0300}", "\u{0020}\u{0308}\u{0300}"),
    ("\u{1FEE}", "\u{0385}", "\u{00A8}\u{0301}", "\u{0020}\u{0308}\u{0301}", "\u{0020}\u{0308}\u{0301}"),
    ("\u{1FEF}", "\u{0060}", "\u{0060}", "\u{0060}", "\u{0060}"),
    ("\u{1FF2}", "\u{1FF2}", "\u{03C9}\u{0300}\u{0345}", "\u{1FF2}", "\u{03C9}\u{0300}\u{0345}"),
    ("\u{1FF3}", "\u{1FF3}", "\u{03C9}\u{0345}", "\u{1FF3}", "\u{03C9}\u{0345}"),
    ("\u{1FF4}", "\u{1FF4}", "\u{03C9}\u{0301}\u{0345}", "\u{1FF4}", "\u{03C9}\u{0301}\u{0345}"),
    ("\u{1FF6}", "\u{1FF6}", "\u{03C9}\u{0342}", "\u{1FF6}", "\u{03C9}\u{0342}"),
    ("\u{1FF7}", "\u{1FF7}", "\u{03C9}\u{0342}\u{0345}", "\u{1FF7}", "\u{03C9}\u{0342}\u{0345}"),
    ("\u{1FF8}", "\u{1FF8}", "\u{039F}\u{0300}", "\u{1FF8}", "\u{039F}\u{0300}"),
    ("\u{1FF9}", "\u{038C}", "\u{039F}\u{0301}", "\u{038C}", "\u{039F}\u{0301}"),
    ("\u{1FFA}", "\u{1FFA}", "\u{03A9}\u{0300}", "\u{1FFA}", "\u{03A9}\u{0300}"),
    ("\u{1FFB}", "\u{038F}", "\u{03A9}\u{0301}", "\u{038F}", "\u{03A9}\u{0301}"),
    ("\u{1FFC}", "\u{1FFC}", "\u{03A9}\u{0345}", "\u{1FFC}", "\u{03A9}\u{0345}"),
    ("\u{1FFD}", "\u{00B4}", "\u{00B4}", "\u{0020}\u{0301}", "\u{0020}\u{0301}"),
    ("\u{1FFE}", "\u{1FFE}", "\u{1FFE}", "\u{0020}\u{0314}", "\u{0020}\u{0314}"),
    ("\u{2000}", "\u{2002}", "\u{2002}", "\u{0020}", "\u{0020}"),
    ("\u{2001}", "\u{2003}", "\u{2003}", "\u{0020}", "\u{0020}"),
    ("\u{2002}", "\u{2002}", "\u{2002}", "\u{0020}", "\u{0020}"),
    ("\u{2003}", "\u{2003}", "\u{2003}", "\u{0020}", "\u{0020}"),
    ("\u{2004}", "\u{2004}", "\u{2004}", "\u{0020}", "\u{0020}"),
    ("\u{2005}", "\u{2005}", "\u{2005}", "\u{0020}", "\u{0020}"),
    ("\u{2006}", "\u{2006}", "\u{2006}", "\u{0020}", "\u{0020}"),
    ("\u{2007}", "\u{2007}", "\u{2007}", "\u{0020}", "\u{0020}"),
    ("\u{2008}", "\u{2008}", "\u{2008}", "\u{0020}", "\u{0020}"),
    ("\u{2009}", "\u{2009}", "\u{2009}", "\u{0020}", "\u{0020}"),
    ("\u{200A}", "\u{200A}", "\u{200A}", "\u{0020}", "\u{0020}"),
    ("\u{2011}", "\u{2011}", "\u{2011}", "\u{2010}", "\u{2010}"),
    ("\u{2017}", "\u{2017}", "\u{2017}", "\u{0020}\u{0333}", "\u{0020}\u{0333}"),
    ("\u{2024}", "\u{2024}", "\u{2024}", "\u{002E}", "\u{002E}"),
    ("\u{2025}", "\u{2025}", "\u{2025}", "\u{002E}\u{002E}", "\u{002E}\u{002E}"),
    ("\u{2026}", "\u{2026}", "\u{2026}", "\u{002E}\u{002E}\u{002E}", "\u{002E}\u{002E}\u{002E}"),
    ("\u{202F}", "\u{202F}", "\u{202F}", "\u{0020}", "\u{0020}"),
    ("\u{2033}", "\u{2033}", "\u{2033}", "\u{2032}\u{2032}", "\u{2032}\u{2032}"),
    ("\u{2034}", "\u{2034}", "\u{2034}", "\u{2032}\u{2032}\u{2032}", "\u{2032}\u{2032}\u{2032}"),
    ("\u{2036}", "\u{2036}", "\u{2036}", "\u{2035}\u{2035}", "\u{2035}\u{2035}"),
    ("\u{2037}", "\u{2037}", "\u{2037}", "\u{2035}\u{2035}\u{2035}", "\u{2035}\u{2035}\u{2035}"),
    ("\u{203C}", "\u{203C}", "\u{203C}", "\u{0021}\u{0021}", "\u{0021}\u{0021}"),
    ("\u{203E}", "\u{203E}", "\u{203E}", "\u{0020}\u{0305}", "\u{0020}\u{0305}"),
    ("\u{2047}", "\u{2047}", "\u{2047}", "\u{003F}\u{003F}", "\u{003F}\u{003F}"),
    ("\u{2048}", "\u{2048}", "\u{2048}", "\u{003F}\u{0021}", "\u{003F}\u{0021}"),
    ("\u{2049}", "\u{2049}", "\u{2049}", "\u{0021}\u{003F}", "\u{0021}\u{003F}"),
    ("\u{2057}", "\u{2057}", "\u{2057}", "\u{2032}\u{2032}\u{2032}\u{2032}", "\u{2032}\u{2032}\u{2032}\u{2032}"),
    ("\u{205F}", "\u{205F}", "\u{205F}", "\u{0020}", "\u{0020}"),
    ("\u{2070}", "\u{2070}", "\u{2070}", "\u{0030}", "\u{0030}"),
    ("\u{2071}", "\u{2071}", "\u{2071}", "\u{0069}", "\u{0069}"),
    ("\u{2074}", "\u{2074}", "\u{2074}", "\u{0034}", "\u{0034}"),
    ("\u{2075}", "\u{2075}", "\u{2075}", "\u{0035}", "\u{0035}"),
    ("\u{2076}", "\u{2076}", "\u{2076}", "\u{0036}", "\u{0036}"),
    ("\u{2077}", "\u{2077}", "\u{2077}", "\u{0037}", "\u{0037}"),
    ("\u{2078}", "\u{2078}", "\u{2078}", "\u{0038}", "\u{0038}"),
    ("\u{2079}", "\u{2079}", "\u{2079}", "\u{0039}", "\u{0039}"),
    ("\u{207A}", "\u{207A}", "\u{207A}", "\u{002B}", "\u{002B}"),
    ("\u{207B}", "\u{207B}", "\u{207B}", "\u{2212}", "\u{2212}"),
    ("\u{207C}", "\u{207C}", "\u{207C}", "\u{003D}", "\u{003D}"),
    ("\u{207D}", "\u{207D}", "\u{207D}", "\u{0028}", "\u{0028}"),
    ("\u{207E}", "\u{207E}", "\u{207E}", "\u{0029}", "\u{0029}"),
    ("\u{207F}", "\u{207F}", "\u{207F}", "\u{006E}", "\u{006E}"),
    ("\u{2080}", "\u{2080}", "\u{2080}", "\u{0030}", "\u{0030}"),
    ("\u{2081}", "\u{2081}", "\u{2081}", "\u{0031}", "\u{0031}"),
    ("\u{2082}", "\u{2082}", "\u{2082}", "\u{0032}", "\u{0032}"),
    ("\u{2083}", "\u{2083}", "\u{2083}", "\u{0033}", "\u{0033}"),
    ("\u{2084}", "\u{2084}", "\u{2084}", "\u{0034}", "\u{0034}"),
    ("\u{2085}", "\u{2085}", "\u{2085}", "\u{0035}", "\u{0035}"),
    ("\u{2086}", "\u{2086}", "\u{2086}", "\u{0036}", "\u{0036}"),
    ("\u{2087}", "\u{2087}", "\u{2087}", "\u{0037}", "\u{0037}"),
    ("\u{2088}", "\u{2088}", "\u{2088}", "\u{0038}", "\u{0038}"),
    ("\u{2089}", "\u{2089}", "\u{2089}", "\u{0039}", "\u{0039}"),
    ("\u{208A}", "\u{208A}", "\u{208A}", "\u{002B}", "\u{002B}"),
    ("\u{208B}", "\u{208B}", "\u{208B}", "\u{2212}", "\u{2212}"),
    ("\u{208C}", "\u{208C}", "\u{208C}", "\u{003D}", "\u{003D}"),
    ("\u{208D}", "\u{208D}", "\u{208D}", "\u{0028}", "\u{0028}"),
    ("\u{208E}", "\u{208E}", "\u{208E}", "\u{0029}", "\u{0029}"),
    ("\u{2090}", "\u{2090}", "\u{2090}", "\u{0061}", "\u{0061}"),
    ("\u{2091}", "\u{2091}", "\u{2091}", "\u{0065}", "\u{0065}"),
    ("\u{2092}", "\u{2092}", "\u{2092}", "\u{006F}", "\u{006F}"),
    ("\u{2093}", "\u{2093}", "\u{2093}", "\u{0078}", "\u{0078}"),
    ("\u{2094}", "\u{2094}", "\u{2094}", "\u{0259}", "\u{0259}"),
    ("\u{2095}", "\u{2095}", "\u{2095}", "\u{0068}", "\u{0068}"),
    ("\u{2096}", "\u{2096}", "\u{2096}", "\u{006B}", "\u{006B}"),
    ("\u{2097}", "\u{2097}", "\u{2097}", "\u{006C}", "\u{006C}"),
    ("\u{2098}", "\u{2098}", "\u{2098}", "\u{006D}", "\u{006D}"),
    ("\u{2099}", "\u{2099}", "\u{2099}", "\u{006E}", "\u{006E}"),
    ("\u{209A}", "\u{209A}", "\u{209A}", "\u{0070}", "\u{0070}"),
    ("\u{209B}", "\u{209B}", "\u{209B}", "\u{0073}", "\u{0073}"),
    ("\u{209C}", "\u{209C}", "\u{209C}", "\u{0074}", "\u{0074}"),
    ("\u{20A8}", "\u{20A8}", "\u{20A8}", "\u{0052}\u{0073}", "\u{0052}\u{0073}"),
    ("\u{2100}", "\u{2100}", "\u{2100}", "\u{0061}\u{002F}\u{0063}", "\u{0061}\u{002F}\u{0063}"),
    ("\u{2101}", "\u{2101}", "\u{2101}", "\u{0061}\u{002F}\u{0073}", "\u{0061}\u{002F}\u{0073}"),
    ("\u{2102}", "\u{2102}", "\u{2102}", "\u{0043}", "\u{0043}"),
    ("\u{2103}", "\u{2103}", "\u{2103}", "\u{00B0}\u{0043}", "\u{00B0}\u{0043}"),
    ("\u{2105}", "\u{2105}", "\u{2105}", "\u{0063}\u{002F}\u{006F}", "\u{0063}\u{002F}\u{006F}"),
    ("\u{2106}", "\u{2106}", "\u{2106}", "\u{0063}\u{002F}\u{0075}", "\u{0063}\u{002F}\u{0075}"),
    ("\u{2107}", "\u{2107}", "\u{2107}", "\u{0190}", "\u{0190}"),
    ("\u{2109}", "\u{2109}", "\u{2109}", "\u{00B0}\u{0046}", "\u{00B0}\u{0046}"),
    ("\u{210A}", "\u{210A}", "\u{210A}", "\u{0067}", "\u{0067}"),
    ("\u{210B}", "\u{210B}", "\u{210B}", "\u{0048}", "\u{0048}"),
    ("\u{210C}", "\u{210C}", "\u{210C}", "\u{0048}", "\u{0048}"),
    ("\u{210D}", "\u{210D}", "\u{210D}", "\u{0048}", "\u{0048}"),
    ("\u{210E}", "\u{210E}", "\u{210E}", "\u{0068}", "\u{0068}"),
    ("\u{210F}", "\u{210F}", "\u{210F}", "\u{0127}", "\u{0127}"),
    ("\u{2110}", "\u{2110}", "\u{2110}", "\u{0049}", "\u{0049}"),
    ("\u{2111}", "\u{2111}", "\u{2111}", "\u{0049}", "\u{0049}"),
    ("\u{2112}", "\u{2112}", "\u{2112}", "\u{004C}", "\u{004C}"),
    ("\u{2113}", "\u{2113}", "\u{2113}", "\u{006C}", "\u{006C}"),
    ("\u{2115}", "\u{2115}", "\u{2115}", "\u{004E}", "\u{004E}"),
    ("\u{2116}", "\u{2116}", "\u{2116}", "\u{004E}\u{006F}", "\u{004E}\u{006F}"),
    ("\u{2119}", "\u{2119}", "\u{2119}", "\u{0050}", "\u{0050}"),
    ("\u{211A}", "\u{211A}", "\u{211A}", "\u{0051}", "\u{0051}"),
    ("\u{211B}", "\u{211B}", "\u{211B}", "\u{0052}", "\u{0052}"),
    ("\u{211C}", "\u{211C}", "\u{211C}", "\u{0052}", "\u{0052}"),
    ("\u{211D}", "\u{211D}", "\u{211D}", "\u{0052}", "\u{0052}"),
    ("\u{2120}", "\u{2120}", "\u{2120}", "\u{0053}\u{004D}", "\u{0053}\u{004D}"),
    ("\u{2121}", "\u{2121}", "\u{2121}", "\u{0054}\u{0045}\u{004C}", "\u{0054}\u{0045}\u{004C}"),
    ("\u{2122}", "\u{2122}", "\u{2122}", "\u{0054}\u{004D}", "\u{0054}\u{004D}"),
    ("\u{2124}", "\u{2124}", "\u{2124}", "\u{005A}", "\u{005A}"),
    ("\u{2126}", "\u{03A9}", "\u{03A9}", "\u{03A9}", "\u{03A9}"),
    ("\u{2128}", "\u{2128}", "\u{2128}", "\u{005A}", "\u{005A}"),
    ("\u{212A}", "\u{004B}", "\u{004B}", "\u{004B}", "\u{004B}"),
    ("\u{212B}", "\u{00C5}", "\u{0041}\u{030A}", "\u{00C5}", "\u{0041}\u{030A}"),
    ("\u{212C}", "\u{212C}", "\u{212C}", "\u{0042}", "\u{0042}"),
    ("\u{212D}", "\u{212D}", "\u{212D}", "\u{0043}", "\u{0043}"),
    ("\u{212F}", "\u{212F}", "\u{212F}", "\u{0065}", "\u{0065}"),
    ("\u{2130}", "\u{2130}", "\u{2130}", "\u{0045}", "\u{0045}"),
    ("\u{2131}", "\u{2131}", "\u{2131}", "\u{0046}", "\u{0046}"),
    ("\u{2133}", "\u{2133}", "\u{2133}", "\u{004D}", "\u{004D}"),
    ("\u{2134}", "\u{2134}", "\u{2134}", "\u{006F}", "\u{006F}"),
    ("\u{2135}", "\u{2135}", "\u{2135}", "\u{05D0}", "\u{05D0}"),
    ("\u{2136}", "\u{2136}", "\u{2136}", "\u{05D1}", "\u{05D1}"),
    ("\u{2137}", "\u{2137}", "\u{2137}", "\u{05D2}", "\u{05D2}"),
    ("\u{2138}", "\u{2138}", "\u{2138}", "\u{05D3}", "\u{05D3}"),
    ("\u{2139}", "\u{2139}", "\u{2139}", "\u{0069}", "\u{0069}"),
    ("\u{213B}", "\u{213B}", "\u{213B}", "\u{0046}\u{0041}\u{0058}", "\u{0046}\u{0041}\u{0058}"),
    ("\u{213C}", "\u{213C}", "\u{213C}", "\u{03C0}", "\u{03C0}"),
    ("\u{213D}", "\u{213D}", "\u{213D}", "\u{03B3}", "\u{03B3}"),
    ("\u{213E}", "\u{213E}", "\u{213E}", "\u{0393}", "\u{0393}"),
    ("\u{213F}", "\u{213F}", "\u{213F}", "\u{03A0}", "\u{03A0}"),
    ("\u{2140}", "\u{2140}", "\u{2140}", "\u{2211}", "\u{2211}"),
    ("\u{2145}", "\u{2145}", "\u{2145}", "\u{0044}", "\u{0044}"),
    ("\u{2146}", "\u{2146}", "\u{2146}", "\u{0064}", "\u{0064}"),
    ("\u{2147}", "\u{2147}", "\u{2147}", "\u{0065}", "\u{0065}"),
    ("\u{2148}", "\u{2148}", "\u{2148}", "\u{0069}", "\u{0069}"),
    ("\u{2149}", "\u{2149}", "\u{2149}", "\u{006A}", "\u{006A}"),
    ("\u{2150}", "\u{2150}", "\u{2150}", "\u{0031}\u{2044}\u{0037}", "\u{0031}\u{2044}\u{0037}"),
    ("\u{2151}", "\u{2151}", "\u{2151}", "\u{0031}\u{2044}\u{0039}", "\u{0031}\u{2044}\u{0039}"),
    ("\u{2152}", "\u{2152}", "\u{2152}", "\u{0031}\u{2044}\u{0031}\u{0030}", "\u{0031}\u{2044}\u{0031}\u{0030}"),
    ("\u{2153}", "\u{2153}", "\u{2153}", "\u{0031}\u{2044}\u{0033}", "\u{0031}\u{2044}\u{0033}"),
    ("\u{2154}", "\u{2154}", "\u{2154}", "\u{0032}\u{2044}\u{0033}", "\u{0032}\u{2044}\u{0033}"),
    ("\u{2155}", "\u{2155}", "\u{2155}", "\u{0031}\u{2044}\u{0035}", "\u{0031}\u{2044}\u{0035}"),
    ("\u{2156}", "\u{2156}", "\u{2156}", "\u{0032}\u{2044}\u{0035}", "\u{0032}\u{2044}\u{0035}"),
    ("\u{2157}", "\u{2157}", "\u{2157}", "\u{0033}\u{2044}\u{0035}", "\u{0033}\u{2044}\u{0035}"),
    ("\u{2158}", "\u{2158}", "\u{2158}", "\u{0034}\u{2044}\u{0035}", "\u{0034}\u{2044}\u{0035}"),
    ("\u{2159}", "\u{2159}", "\u{2159}", "\u{0031}\u{2044}\u{0036}", "\u{0031}\u{2044}\u{0036}"),
    ("\u{215A}", "\u{215A}", "\u{215A}", "\u{0035}\u{2044}\u{0036}", "\u{0035}\u{2044}\u{0036}"),
    ("\u{215B}", "\u{215B}", "\u{215B}", "\u{0031}\u{2044}\u{0038}", "\u{0031}\u{2044}\u{0038}"),
    ("\u{215C}", "\u{215C}", "\u{215C}", "\u{0033}\u{2044}\u{0038}", "\u{0033}\u{2044}\u{0038}"),
    ("\u{215D}", "\u{215D}", "\u{215D}", "\u{0035}\u{2044}\u{0038}", "\u{0035}\u{2044}\u{0038}"),
    ("\u{215E}", "\u{215E}", "\u{215E}", "\u{0037}\u{2044}\u{0038}", "\u{0037}\u{2044}\u{0038}"),
    ("\u{215F}", "\u{215F}", "\u{215F}", "\u{0031}\u{2044}", "\u{0031}\u{2044}"),
    ("\u{2160}", "\u{2160}", "\u{2160}", "\u{0049}", "\u{0049}"),
    ("\u{2161}", "\u{2161}", "\u{2161}", "\u{0049}\u{0049}", "\u{0049}\u{0049}"),
    ("\u{2162}", "\u{2162}", "\u{2162}", "\u{0049}\u{0049}\u{0049}", "\u{0049}\u{0049}\u{0049}"),
    ("\u{2163}", "\u{2163}", "\u{2163}", "\u{0049}\u{0056}", "\u{0049}\u{0056}"),
    ("\u{2164}", "\u{2164}", "\u{2164}", "\u{0056}", "\u{0056}"),
    ("\u{2165}", "\u{2165}", "\u{2165}", "\u{0056}\u{0049}", "\u{0056}\u{0049}"),
    ("\u{2166}", "\u{2166}", "\u{2166}", "\u{0056}\u{0049}\u{0049}", "\u{0056}\u{0049}\u{0049}"),
    ("\u{2167}", "\u{2167}", "\u{2167}", "\u{0056}\u{0049}\u{0049}\u{0049}", "\u{0056}\u{0049}\u{0049}\u{0049}"),
    ("\u{2168}", "\u{2168}", "\u{2168}", "\u{0049}\u{0058}", "\u{0049}\u{0058}"),
    ("\u{2169}", "\u{2169}", "\u{2169}", "\u{0058}", "\u{0058}"),
    ("\u{216A}", "\u{216A}", "\u{216A}", "\u{0058}\u{0049}", "\u{0058}\u{0049}"),
    ("\u{216B}", "\u{216B}", "\u{216B}", "\u{0058}\u{0049}\u{0049}", "\u{0058}\u{0049}\u{0049}"),
    ("\u{216C}", "\u{216C}", "\u{216C}", "\u{004C}", "\u{004C}"),
    ("\u{216D}", "\u{216D}", "\u{216D}", "\u{0043}", "\u{0043}"),
    ("\u{216E}", "\u{216E}", "\u{216E}", "\u{0044}", "\u{0044}"),
    ("\u{216F}", "\u{216F}", "\u{216F}", "\u{004D}", "\u{004D}"),
    ("\u{2170}", "\u{2170}", "\u{2170}", "\u{0069}", "\u{0069}"),
    ("\u{2171}", "\u{2171}", "\u{2171}", "\u{0069}\u{0069}", "\u{0069}\u{0069}"),
    ("\u{2172}", "\u{2172}", "\u{2172}", "\u{0069}\u{0069}\u{0069}", "\u{0069}\u{0069}\u{0069}"),
    ("\u{2173}", "\u{2173}", "\u{2173}", "\u{0069}\u{0076}", "\u{0069}\u{0076}"),
    ("\u{2174}", "\u{2174}", "\u{2174}", "\u{0076}", "\u{0076}"),
    ("\u{2175}", "\u{2175}", "\u{2175}", "\u{0076}\u{0069}", "\u{0076}\u{0069}"),
    ("\u{2176}", "\u{2176}", "\u{2176}", "\u{0076}\u{0069}\u{0069}", "\u{0076}\u{0069}\u{0069}"),
    ("\u{2177}", "\u{2177}", "\u{2177}", "\u{0076}\u{0069}\u{0069}\u{0069}", "\u{0076}\u{0069}\u{0069}\u{0069}"),
    ("\u{2178}", "\u{2178}", "\u{2178}", "\u{0069}\u{0078}", "\u{0069}\u{0078}"),
    ("\u{2179}", "\u{2179}", "\u{2179}", "\u{0078}", "\u{0078}"),
    ("\u{217A}", "\u{217A}", "\u{217A}", "\u{0078}\u{0069}", "\u{0078}\u{0069}"),
    ("\u{217B}", "\u{217B}", "\u{217B}", "\u{0078}\u{0069}\u{0069}", "\u{0078}\u{0069}\u{0069}"),
    ("\u{217C}", "\u{217C}", "\u{217C}", "\u{006C}", "\u{006C}"),
    ("\u{217D}", "\u{217D}", "\u{217D}", "\u{0063}", "\u{0063}"),
    ("\u{217E}", "\u{217E}", "\u{217E}", "\u{0064}", "\u{0064}"),
    ("\u{217F}", "\u{217F}", "\u{217F}", "\u{006D}", "\u{006D}"),
    ("\u{2189}", "\u{2189}", "\u{2189}", "\u{0030}\u{2044}\u{0033}", "\u{0030}\u{2044}\u{0033}"),
    ("\u{219A}", "\u{219A}", "\u{2190}\u{0338}", "\u{219A}", "\u{2190}\u{0338}"),
    ("\u{219B}", "\u{219B}", "\u{2192}\u{0338}", "\u{219B}", "\u{2192}\u{0338}"),
    ("\u{21AE}", "\u{21AE}", "\u{2194}\u{0338}", "\u{21AE}", "\u{2194}\u{0338}"),
    ("\u{21CD}", "\u{21CD}", "\u{21D0}\u{0338}", "\u{21CD}", "\u{21D0}\u{0338}"),
    ("\u{21CE}", "\u{21CE}", "\u{21D4}\u{0338}", "\u{21CE}", "\u{21D4}\u{0338}"),
    ("\u{21CF}", "\u{21CF}", "\u{21D2}\u{0338}", "\u{21CF}", "\u{21D2}\u{0338}"),
    ("\u{2204}", "\u{2204}", "\u{2203}\u{0338}", "\u{2204}", "\u{2203}\u{0338}"),
    ("\u{2209}", "\u{2209}", "\u{2208}\u{0338}", "\u{2209}", "\u{2208}\u{0338}"),
    ("\u{220C}", "\u{220C}", "\u{220B}\u{0338}", "\u{220C}", "\u{220B}\u{0338}"),
    ("\u{2224}", "\u{2224}", "\u{2223}\u{0338}", "\u{2224}", "\u{2223}\u{0338}"),
    ("\u{2226}", "\u{2226}", "\u{2225}\u{0338}", "\u{2226}", "\u{2225}\u{0338}"),
    ("\u{222C}", "\u{222C}", "\u{222C}", "\u{222B}\u{222B}", "\u{222B}\u{222B}"),
    ("\u{222D}", "\u{222D}", "\u{222D}", "\u{222B}\u{222B}\u{222B}", "\u{222B}\u{222B}\u{222B}"),
    ("\u{222F}", "\u{222F}", "\u{222F}", "\u{222E}\u{222E}", "\u{222E}\u{222E}"),
    ("\u{2230}", "\u{2230}", "\u{2230}", "\u{222E}\u{222E}\u{222E}", "\u{222E}\u{222E}\u{222E}"),
    ("\u{2241}", "\u{2241}", "\u{223C}\u{0338}", "\u{2241}", "\u{223C}\u{0338}"),
    ("\u{2244}", "\u{2244}", "\u{2243}\u{0338}", "\u{2244}", "\u{2243}\u{0338}"),
    ("\u{2247}", "\u{2247}", "\u{2245}\u{0338}", "\u{2247}", "\u{2245}\u{0338}"),
    ("\u{2249}", "\u{2249}", "\u{2248}\u{0338}", "\u{2249}", "\u{2248}\u{0338}"),
    ("\u{2260}", "\u{2260}", "\u{003D}\u{0338}", "\u{2260}", "\u{003D}\u{0338}"),
    ("\u{2262}", "\u{2262}", "\u{2261}\u{0338}", "\u{2262}", "\u{2261}\u{0338}"),
    ("\u{226D}", "\u{226D}", "\u{224D}\u{0338}", "\u{226D}", "\u{224D}\u{0338}"),
    ("\u{226E}", "\u{226E}", "\u{003C}\u{0338}", "\u{226E}", "\u{003C}\u{0338}"),
    ("\u{226F}", "\u{226F}", "\u{003E}\u{0338}", "\u{226F}", "\u{003E}\u{0338}"),
    ("\u{2270}", "\u{2270}", "\u{2264}\u{0338}", "\u{2270}", "\u{2264}\u{0338}"),
    ("\u{2271}", "\u{2271}", "\u{2265}\u{0338}", "\u{2271}", "\u{2265}\u{0338}"),
    ("\u{2274}", "\u{2274}", "\u{2272}\u{0338}", "\u{2274}", "\u{2272}\u{0338}"),
    ("\u{2275}", "\u{2275}", "\u{2273}\u{0338}", "\u{2275}", "\u{2273}\u{0338}"),
    ("\u{2278}", "\u{2278}", "\u{2276}\u{0338}", "\u{2278}", "\u{2276}\u{0338}"),
    ("\u{2279}", "\u{2279}", "\u{2277}\u{0338}", "\u{2279}", "\u{2277}\u{0338}"),
    ("\u{2280}", "\u{2280}", "\u{227A}\u{0338}", "\u{2280}", "\u{227A}\u{0338}"),
    ("\u{2281}", "\u{2281}", "\u{227B}\u{0338}", "\u{2281}", "\u{227B}\u{0338}"),
    ("\u{2284}", "\u{2284}", "\u{2282}\u{0338}", "\u{2284}", "\u{2282}\u{0338}"),
    ("\u{2285}", "\u{2285}", "\u{2283}\u{0338}", "\u{2285}", "\u{2283}\u{0338}"),
    ("\u{2288}", "\u{2288}", "\u{2286}\u{0338}", "\u{2288}", "\u{2286}\u{0338}"),
    ("\u{2289}", "\u{2289}", "\u{2287}\u{0338}", "\u{2289}", "\u{2287}\u{0338}"),
    ("\u{22AC}", "\u{22AC}", "\u{22A2}\u{0338}", "\u{22AC}", "\u{22A2}\u{0338}"),
    ("\u{22AD}", "\u{22AD}", "\u{22A8}\u{0338}", "\u{22AD}", "\u{22A8}\u{0338}"),
    ("\u{22AE}", "\u{22AE}", "\u{22A9}\u{0338}", "\u{22AE}", "\u{22A9}\u{0338}"),
    ("\u{22AF}", "\u{22AF}", "\u{22AB}\u{0338}", "\u{22AF}", "\u{22AB}\u{0338}"),
    ("\u{22E0}", "\u{22E0}", "\u{227C}\u{0338}", "\u{22E0}", "\u{227C}\u{0338}"),
    ("\u{22E1}", "\u{22E1}", "\u{227D}\u{0338}", "\u{22E1}", "\u{227D}\u{0338}"),
    ("\u{22E2}", "\u{22E2}", "\u{2291}\u{0338}", "\u{22E2}", "\u{2291}\u{0338}"),
    ("\u{22E3}", "\u{22E3}", "\u{2292}\u{0338}", "\u{22E3}", "\u{2292}\u{0338}"),
    ("\u{22EA}", "\u{22EA}", "\u{22B2}\u{0338}", "\u{22EA}", "\u{22B2}\u{0338}"),
    ("\u{22EB}", "\u{22EB}", "\u{22B3}\u{0338}", "\u{22EB}", "\u{22B3}\u{0338}"),
    ("\u{22EC}", "\u{22EC}", "\u{22B4}\u{0338}", "\u{22EC}", "\u{22B4}\u{0338}"),
    ("\u{22ED}", "\u{22ED}", "\u{22B5}\u{0338}", "\u{22ED}", "\u{22B5}\u{0338}"),
    ("\u{2329}", "\u{3008}", "\u{3008}", "\u{3008}", "\u{3008}"),
    ("\u{232A}", "\u{3009}", "\u{3009}", "\u{3009}", "\u{3009}"),
    ("\u{2460}", "\u{2460}", "\u{2460}", "\u{0031}", "\u{0031}"),
    ("\u{2461}", "\u{2461}", "\u{2461}", "\u{0032}", "\u{0032}"),
    ("\u{2462}", "\u{2462}", "\u{2462}", "\u{0033}", "\u{0033}"),
    ("\u{2463}", "\u{2463}", "\u{2463}", "\u{0034}", "\u{0034}"),
    ("\u{2464}", "\u{2464}", "\u{2464}", "\u{0035}", "\u{0035}"),
    ("\u{2465}", "\u{2465}", "\u{2465}", "\u{0036}", "\u{0036}"),
    ("\u{2466}", "\u{2466}", "\u{2466}", "\u{0037}", "\u{0037}"),
    ("\u{2467}", "\u{2467}", "\u{2467}", "\u{0038}", "\u{0038}"),
    ("\u{2468}", "\u{2468}", "\u{2468}", "\u{0039}", "\u{0039}"),
    ("\u{2469}", "\u{2469}", "\u{2469}", "\u{0031}\u{0030}", "\u{0031}\u{0030}"),
    ("\u{246A}", "\u{246A}", "\u{246A}", "\u{0031}\u{0031}", "\u{0031}\u{0031}"),
    ("\u{246B}", "\u{246B}", "\u{246B}", "\u{0031}\u{0032}", "\u{0031}\u{0032}"),
    ("\u{246C}", "\u{246C}", "\u{246C}", "\u{0031}\u{0033}", "\u{0031}\u{0033}"),
    ("\u{246D}", "\u{246D}", "\u{246D}", "\u{0031}\u{0034}", "\u{0031}\u{0034}"),
    ("\u{246E}", "\u{246E}", "\u{246E}", "\u{0031}\u{0035}", "\u{0031}\u{0035}"),
    ("\u{246F}", "\u{246F}", "\u{246F}", "\u{0031}\u{0036}", "\u{0031}\u{0036}"),
    ("\u{2470}", "\u{2470}", "\u{2470}", "\u{0031}\u{0037}", "\u{0031}\u{0037}"),
    ("\u{2471}", "\u{2471}", "\u{2471}", "\u{0031}\u{0038}", "\u{0031}\u{0038}"),
    ("\u{2472}", "\u{2472}", "\u{2472}", "\u{0031}\u{0039}", "\u{0031}\u{0039}"),
    ("\u{2473}", "\u{2473}", "\u{2473}", "\u{0032}\u{0030}", "\u{0032}\u{0030}"),
    ("\u{2474}", "\u{2474}", "\u{2474}", "\u{0028}\u{0031}\u{0029}", "\u{0028}\u{0031}\u{0029}"),
    ("\u{2475}", "\u{2475}", "\u{2475}", "\u{0028}\u{0032}\u{0029}", "\u{0028}\u{0032}\u{0029}"),
    ("\u{2476}", "\u{2476}", "\u{2476}", "\u{0028}\u{0033}\u{0029}", "\u{0028}\u{0033}\u{0029}"),
    ("\u{2477}", "\u{2477}", "\u{2477}", "\u{0028}\u{0034}\u{0029}", "\u{0028}\u{0034}\u{0029}"),
    ("\u{2478}", "\u{2478}", "\u{2478}", "\u{0028}\u{0035}\u{0029}", "\u{0028}\u{0035}\u{0029}"),
    ("\u{2479}", "\u{2479}", "\u{2479}", "\u{0028}\u{0036}\u{0029}", "\u{0028}\u{0036}\u{0029}"),
    ("\u{247A}", "\u{247A}", "\u{247A}", "\u{0028}\u{0037}\u{0029}", "\u{0028}\u{0037}\u{0029}"),
    ("\u{247B}", "\u{247B}", "\u{247B}", "\u{0028}\u{0038}\u{0029}", "\u{0028}\u{0038}\u{0029}"),
    ("\u{247C}", "\u{247C}", "\u{247C}", "\u{0028}\u{0039}\u{0029}", "\u{0028}\u{0039}\u{0029}"),
    ("\u{247D}", "\u{247D}", "\u{247D}", "\u{0028}\u{0031}\u{0030}\u{0029}", "\u{0028}\u{0031}\u{0030}\u{0029}"),
    ("\u{247E}", "\u{247E}", "\u{247E}", "\u{0028}\u{0031}\u{0031}\u{0029}", "\u{0028}\u{0031}\u{0031}\u{0029}"),
    ("\u{247F}", "\u{247F}", "\u{247F}", "\u{0028}\u{0031}\u{0032}\u{0029}", "\u{0028}\u{0031}\u{0032}\u{0029}"),
    ("\u{2480}", "\u{2480}", "\u{2480}", "\u{0028}\u{0031}\u{0033}\u{0029}", "\u{0028}\u{0031}\u{0033}\u{0029}"),
    ("\u{2481}", "\u{2481}", "\u{2481}", "\u{0028}\u{0031}\u{0034}\u{0029}", "\u{0028}\u{0031}\u{0034}\u{0029}"),
    ("\u{2482}", "\u{2482}", "\u{2482}", "\u{0028}\u{0031}\u{0035}\u{0029}", "\u{0028}\u{0031}\u{0035}\u{0029}"),
    ("\u{2483}", "\u{2483}", "\u{2483}", "\u{0028}\u{0031}\u{0036}\u{0029}", "\u{0028}\u{0031}\u{0036}\u{0029}"),
    ("\u{2484}", "\u{2484}", "\u{2484}", "\u{0028}\u{0031}\u{0037}\u{0029}", "\u{0028}\u{0031}\u{0037}\u{0029}"),
    ("\u{2485}", "\u{2485}", "\u{2485}", "\u{0028}\u{0031}\u{0038}\u{0029}", "\u{0028}\u{0031}\u{0038}\u{0029}"),
    ("\u{2486}", "\u{2486}", "\u{2486}", "\u{0028}\u{0031}\u{0039}\u{0029}", "\u{0028}\u{0031}\u{0039}\u{0029}"),
    ("\u{2487}", "\u{2487}", "\u{2487}", "\u{0028}\u{0032}\u{0030}\u{0029}", "\u{0028}\u{0032}\u{0030}\u{0029}"),
    ("\u{2488}", "\u{2488}", "\u{2488}", "\u{0031}\u{002E}", "\u{0031}\u{002E}"),
    ("\u{2489}", "\u{2489}", "\u{2489}", "\u{0032}\u{002E}", "\u{0032}\u{002E}"),
    ("\u{248A}", "\u{248A}", "\u{248A}", "\u{0033}\u{002E}", "\u{0033}\u{002E}"),
    ("\u{248B}", "\u{248B}", "\u{248B}", "\u{0034}\u{002E}", "\u{0034}\u{002E}"),
    ("\u{248C}", "\u{248C}", "\u{248C}", "\u{0035}\u{002E}", "\u{0035}\u{002E}"),
    ("\u{248D}", "\u{248D}", "\u{248D}", "\u{0036}\u{002E}", "\u{0036}\u{002E}"),
    ("\u{248E}", "\u{248E}", "\u{248E}", "\u{0037}\u{002E}", "\u{0037}\u{002E}"),
    ("\u{248F}", "\u{248F}", "\u{248F}", "\u{0038}\u{002E}", "\u{0038}\u{002E}"),
    ("\u{2490}", "\u{2490}", "\u{2490}", "\u{0039}\u{002E}", "\u{0039}\u{002E}"),
    ("\u{2491}", "\u{2491}", "\u{2491}", "\u{0031}\u{0030}\u{002E}", "\u{0031}\u{0030}\u{002E}"),
    ("\u{2492}", "\u{2492}", "\u{2492}", "\u{0031}\u{0031}\u{002E}", "\u{0031}\u{0031}\u{002E}"),
    ("\u{2493}", "\u{2493}", "\u{2493}", "\u{0031}\u{0032}\u{002E}", "\u{0031}\u{0032}\u{002E}"),
    ("\u{2494}", "\u{2494}", "\u{2494}", "\u{0031}\u{0033}\u{002E}", "\u{0031}\u{0033}\u{002E}"),
    ("\u{2495}", "\u{2495}", "\u{2495}", "\u{0031}\u{0034}\u{002E}", "\u{0031}\u{0034}\u{002E}"),
    ("\u{2496}", "\u{2496}", "\u{2496}", "\u{0031}\u{0035}\u{002E}", "\u{0031}\u{0035}\u{002E}"),
    ("\u{2497}", "\u{2497}", "\u{2497}", "\u{0031}\u{0036}\u{002E}", "\u{0031}\u{0036}\u{002E}"),
    ("\u{2498}", "\u{2498}", "\u{2498}", "\u{0031}\u{0037}\u{002E}", "\u{0031}\u{0037}\u{002E}"),
    ("\u{2499}", "\u{2499}", "\u{2499}", "\u{0031}\u{0038}\u{002E}", "\u{0031}\u{0038}\u{002E}"),
    ("\u{249A}", "\u{249A}", "\u{249A}", "\u{0031}\u{0039}\u{002E}", "\u{0031}\u{0039}\u{002E}"),
    ("\u{249B}", "\u{249B}", "\u{249B}", "\u{0032}\u{0030}\u{002E}", "\u{0032}\u{0030}\u{002E}"),
    ("\u{249C}", "\u{249C}", "\u{249C}", "\u{0028}\u{0061}\u{0029}", "\u{0028}\u{0061}\u{0029}"),
    ("\u{249D}", "\u{249D}", "\u{249D}", "\u{0028}\u{0062}\u{0029}", "\u{0028}\u{0062}\u{0029}"),
    ("\u{249E}", "\u{249E}", "\u{249E}", "\u{0028}\u{0063}\u{0029}", "\u{0028}\u{0063}\u{0029}"),
    ("\u{249F}", "\u{249F}", "\u{249F}", "\u{0028}\u{0064}\u{0029}", "\u{0028}\u{0064}\u{0029}"),
    ("\u{24A0}", "\u{24A0}", "\u{24A0}", "\u{0028}\u{0065}\u{0029}", "\u{0028}\u{0065}\u{0029}"),
    ("\u{24A1}", "\u{24A1}", "\u{24A1}", "\u{0028}\u{0066}\u{0029}", "\u{0028}\u{0066}\u{0029}"),
    ("\u{24A2}", "\u{24A2}", "\u{24A2}", "\u{0028}\u{0067}\u{0029}", "\u{0028}\u{0067}\u{0029}"),
    ("\u{24A3}", "\u{24A3}", "\u{24A3}", "\u{0028}\u{0068}\u{0029}", "\u{0028}\u{0068}\u{0029}"),
    ("\u{24A4}", "\u{24A4}", "\u{24A4}", "\u{0028}\u{0069}\u{0029}", "\u{0028}\u{0069}\u{0029}"),
    ("\u{24A5}", "\u{24A5}", "\u{24A5}", "\u{0028}\u{006A}\u{0029}", "\u{0028}\u{006A}\u{0029}"),
    ("\u{24A6}", "\u{24A6}", "\u{24A6}", "\u{0028}\u{006B}\u{0029}", "\u{0028}\u{006B}\u{0029}"),
    ("\u{24A7}", "\u{24A7}", "\u{24A7}", "\u{0028}\u{006C}\u{0029}", "\u{0028}\u{006C}\u{0029}"),
    ("\u{24A8}", "\u{24A8}", "\u{24A8}", "\u{0028}\u{006D}\u{0029}", "\u{0028}\u{006D}\u{0029}"),
    ("\u{24A9}", "\u{24A9}", "\u{24A9}", "\u{0028}\u{006E}\u{0029}", "\u{0028}\u{006E}\u{0029}"),
    ("\u{24AA}", "\u{24AA}", "\u{24AA}", "\u{0028}\u{006F}\u{0029}", "\u{0028}\u{006F}\u{0029}"),
    ("\u{24AB}", "\u{24AB}", "\u{24AB}", "\u{0028}\u{0070}\u{0029}", "\u{0028}\u{0070}\u{0029}"),
    ("\u{24AC}", "\u{24AC}", "\u{24AC}", "\u{0028}\u{0071}\u{0029}", "\u{0028}\u{0071}\u{0029}"),
    ("\u{24AD}", "\u{24AD}", "\u{24AD}", "\u{0028}\u{0072}\u{0029}", "\u{0028}\u{0072}\u{0029}"),
    ("\u{24AE}", "\u{24AE}", "\u{24AE}", "\u{0028}\u{0073}\u{0029}", "\u{0028}\u{0073}\u{0029}"),
    ("\u{24AF}", "\u{24AF}", "\u{24AF}", "\u{0028}\u{0074}\u{0029}", "\u{0028}\u{0074}\u{0029}"),
    ("\u{24B0}", "\u{24B0}", "\u{24B0}", "\u{0028}\u{0075}\u{0029}", "\u{0028}\u{0075}\u{0029}"),
    ("\u{24B1}", "\u{24B1}", "\u{24B1}", "\u{0028}\u{0076}\u{0029}", "\u{0028}\u{0076}\u{0029}"),
    ("\u{24B2}", "\u{24B2}", "\u{24B2}", "\u{0028}\u{0077}\u{0029}", "\u{0028}\u{0077}\u{0029}"),
    ("\u{24B3}", "\u{24B3}", "\u{24B3}", "\u{0028}\u{0078}\u{0029}", "\u{0028}\u{0078}\u{0029}"),
    ("\u{24B4}", "\u{24B4}", "\u{24B4}", "\u{0028}\u{0079}\u{0029}", "\u{0028}\u{0079}\u{0029}"),
    ("\u{24B5}", "\u{24B5}", "\u{24B5}", "\u{0028}\u{007A}\u{0029}", "\u{0028}\u{007A}\u{0029}"),
    ("\u{24B6}", "\u{24B6}", "\u{24B6}", "\u{0041}", "\u{0041}"),
    ("\u{24B7}", "\u{24B7}", "\u{24B7}", "\u{0042}", "\u{0042}"),
    ("\u{24B8}", "\u{24B8}", "\u{24B8}", "\u{0043}", "\u{0043}"),
    ("\u{24B9}", "\u{24B9}", "\u{24B9}", "\u{0044}", "\u{0044}"),
    ("\u{24BA}", "\u{24BA}", "\u{24BA}", "\u{0045}", "\u{0045}"),
    ("\u{24BB}", "\u{24BB}", "\u{24BB}", "\u{0046}", "\u{0046}"),
    ("\u{24BC}", "\u{24BC}", "\u{24BC}", "\u{0047}", "\u{0047}"),
    ("\u{24BD}", "\u{24BD}", "\u{24BD}", "\u{0048}", "\u{0048}"),
    ("\u{24BE}", "\u{24BE}", "\u{24BE}", "\u{0049}", "\u{0049}"),
    ("\u{24BF}", "\u{24BF}", "\u{24BF}", "\u{004A}", "\u{004A}"),
    ("\u{24C0}", "\u{24C0}", "\u{24C0}", "\u{004B}", "\u{004B}"),
    ("\u{24C1}", "\u{24C1}", "\u{24C1}", "\u{004C}", "\u{004C}"),
    ("\u{24C2}", "\u{24C2}", "\u{24C2}", "\u{004D}", "\u{004D}"),
    ("\u{24C3}", "\u{24C3}", "\u{24C3}", "\u{004E}", "\u{004E}"),
    ("\u{24C4}", "\u{24C4}", "\u{24C4}", "\u{004F}", "\u{004F}"),
    ("\u{24C5}", "\u{24C5}", "\u{24C5}", "\u{0050}", "\u{0050}"),
    ("\u{24C6}", "\u{24C6}", "\u{24C6}", "\u{0051}", "\u{0051}"),
    ("\u{24C7}", "\u{24C7}", "\u{24C7}", "\u{0052}", "\u{0052}"),
    ("\u{24C8}", "\u{24C8}", "\u{24C8}", "\u{0053}", "\u{0053}"),
    ("\u{24C9}", "\u{24C9}", "\u{24C9}", "\u{0054}", "\u{0054}"),
    ("\u{24CA}", "\u{24CA}", "\u{24CA}", "\u{0055}", "\u{0055}"),
    ("\u{24CB}", "\u{24CB}", "\u{24CB}", "\u{0056}", "\u{0056}"),
    ("\u{24CC}", "\u{24CC}", "\u{24CC}", "\u{0057}", "\u{0057}"),
    ("\u{24CD}", "\u{24CD}", "\u{24CD}", "\u{0058}", "\u{0058}"),
    ("\u{24CE}", "\u{24CE}", "\u{24CE}", "\u{0059}", "\u{0059}"),
    ("\u{24CF}", "\u{24CF}", "\u{24CF}", "\u{005A}", "\u{005A}"),
    ("\u{24D0}", "\u{24D0}", "\u{24D0}", "\u{0061}", "\u{0061}"),
    ("\u{24D1}", "\u{24D1}", "\u{24D1}", "\u{0062}", "\u{0062}"),
    ("\u{24D2}", "\u{24D2}", "\u{24D2}", "\u{0063}", "\u{0063}"),
    ("\u{24D3}", "\u{24D3}", "\u{24D3}", "\u{0064}", "\u{0064}"),
    ("\u{24D4}", "\u{24D4}", "\u{24D4}", "\u{0065}", "\u{0065}"),
    ("\u{24D5}", "\u{24D5}", "\u{24D5}", "\u{0066}", "\u{0066}"),
    ("\u{24D6}", "\u{24D6}", "\u{24D6}", "\u{0067}", "\u{0067}"),
    ("\u{24D7}", "\u{24D7}", "\u{24D7}", "\u{0068}", "\u{0068}"),
    ("\u{24D8}", "\u{24D8}", "\u{24D8}", "\u{0069}", "\u{0069}"),
    ("\u{24D9}", "\u{24D9}", "\u{24D9}", "\u{006A}", "\u{006A}"),
    ("\u{24DA}", "\u{24DA}", "\u{24DA}", "\u{006B}", "\u{006B}"),
    ("\u{24DB}", "\u{24DB}", "\u{24DB}", "\u{006C}", "\u{006C}"),
    ("\u{24DC}", "\u{24DC}", "\u{24DC}", "\u{006D}", "\u{006D}"),
    ("\u{24DD}", "\u{24DD}", "\u{24DD}", "\u{006E}", "\u{006E}"),
    ("\u{24DE}", "\u{24DE}", "\u{24DE}", "\u{006F}", "\u{006F}"),
    ("\u{24DF}", "\u{24DF}", "\u{24DF}", "\u{0070}", "\u{0070}"),
    ("\u{24E0}", "\u{24E0}", "\u{24E0}", "\u{0071}", "\u{0071}"),
    ("\u{24E1}", "\u{24E1}", "\u{24E1}", "\u{0072}", "\u{0072}"),
    ("\u{24E2}", "\u{24E2}", "\u{24E2}", "\u{0073}", "\u{0073}"),
    ("\u{24E3}", "\u{24E3}", "\u{24E3}", "\u{0074}", "\u{0074}"),
    ("\u{24E4}", "\u{24E4}", "\u{24E4}", "\u{0075}", "\u{0075}"),
    ("\u{24E5}", "\u{24E5}", "\u{24E5}", "\u{0076}", "\u{0076}"),
    ("\u{24E6}", "\u{24E6}", "\u{24E6}", "\u{0077}", "\u{0077}"),
    ("\u{24E7}", "\u{24E7}", "\u{24E7}", "\u{0078}", "\u{0078}"),
    ("\u{24E8}", "\u{24E8}", "\u{24E8}", "\u{0079}", "\u{0079}"),
    ("\u{24E9}", "\u{24E9}", "\u{24E9}", "\u{007A}", "\u{007A}"),
    ("\u{24EA}", "\u{24EA}", "\u{24EA}", "\u{0030}", "\u{0030}"),
    ("\u{2A0C}", "\u{2A0C}", "\u{2A0C}", "\u{222B}\u{222B}\u{222B}\u{222B}", "\u{222B}\u{222B}\u{222B}\u{222B}"),
    ("\u{2A74}", "\u{2A74}", "\u{2A74}", "\u{003A}\u{003A}\u{003D}", "\u{003A}\u{003A}\u{003D}"),
    ("\u{2A75}", "\u{2A75}", "\u{2A75}", "\u{003D}\u{003D}", "\u{003D}\u{003D}"),
    ("\u{2A76}", "\u{2A76}", "\u{2A76}", "\u{003D}\u{003D}\u{003D}", "\u{003D}\u{003D}\u{003D}"),
    ("\u{2ADC}", "\u{2ADD}\u{0338}", "\u{2ADD}\u{0338}", "\u{2ADD}\u{0338}", "\u{2ADD}\u{0338}"),
    ("\u{2C7C}", "\u{2C7C}", "\u{2C7C}", "\u{006A}", "\u{006A}"),
    ("\u{2C7D}", "\u{2C7D}", "\u{2C7D}", "\u{0056}", "\u{0056}"),
    ("\u{2D6F}", "\u{2D6F}", "\u{2D6F}", "\u{2D61}", "\u{2D61}"),
    ("\u{2E9F}", "\u{2E9F}", "\u{2E9F}", "\u{6BCD}", "\u{6BCD}"),
    ("\u{2EF3}", "\u{2EF3}", "\u{2EF3}", "\u{9F9F}", "\u{9F9F}"),
    ("\u{2F00}", "\u{2F00}", "\u{2F00}", "\u{4E00}", "\u{4E00}"),
    ("\u{2F01}", "\u{2F01}", "\u{2F01}", "\u{4E28}", "\u{4E28}"),
    ("\u{2F02}", "\u{2F02}", "\u{2F02}", "\u{4E36}", "\u{4E36}"),
    ("\u{2F03}", "\u{2F03}", "\u{2F03}", "\u{4E3F}", "\u{4E3F}"),
    ("\u{2F04}", "\u{2F04}", "\u{2F04}", "\u{4E59}", "\u{4E59}"),
    ("\u{2F05}", "\u{2F05}", "\u{2F05}", "\u{4E85}", "\u{4E85}"),
    ("\u{2F06}", "\u{2F06}", "\u{2F06}", "\u{4E8C}", "\u{4E8C}"),
    ("\u{2F07}", "\u{2F07}", "\u{2F07}", "\u{4EA0}", "\u{4EA0}"),
    ("\u{2F08}", "\u{2F08}", "\u{2F08}", "\u{4EBA}", "\u{4EBA}"),
    ("\u{2F09}", "\u{2F09}", "\u{2F09}", "\u{513F}", "\u{513F}"),
    ("\u{2F0A}", "\u{2F0A}", "\u{2F0A}", "\u{5165}", "\u{5165}"),
    ("\u{2F0B}", "\u{2F0B}", "\u{2F0B}", "\u{516B}", "\u{516B}"),
    ("\u{2F0C}", "\u{2F0C}", "\u{2F0C}", "\u{5182}", "\u{5182}"),
    ("\u{2F0D}", "\u{2F0D}", "\u{2F0D}", "\u{5196}", "\u{5196}"),
    ("\u{2F0E}", "\u{2F0E}", "\u{2F0E}", "\u{51AB}", "\u{51AB}"),
    ("\u{2F0F}", "\u{2F0F}", "\u{2F0F}", "\u{51E0}", "\u{51E0}"),
    ("\u{2F10}", "\u{2F10}", "\u{2F10}", "\u{51F5}", "\u{51F5}"),
    ("\u{2F11}", "\u{2F11}", "\u{2F11}", "\u{5200}", "\u{5200}"),
    ("\u{2F12}", "\u{2F12}", "\u{2F12}", "\u{529B}", "\u{529B}"),
    ("\u{2F13}", "\u{2F13}", "\u{2F13}", "\u{52F9}", "\u{52F9}"),
    ("\u{2F14}", "\u{2F14}", "\u{2F14}", "\u{5315}", "\u{5315}"),
    ("\u{2F15}", "\u{2F15}", "\u{2F15}", "\u{531A}", "\u{531A}"),
    ("\u{2F16}", "\u{2F16}", "\u{2F16}", "\u{5338}", "\u{5338}"),
    ("\u{2F17}", "\u{2F17}", "\u{2F17}", "\u{5341}", "\u{5341}"),
    ("\u{2F18}", "\u{2F18}", "\u{2F18}", "\u{535C}", "\u{535C}"),
    ("\u{2F19}", "\u{2F19}", "\u{2F19}", "\u{5369}", "\u{5369}"),
    ("\u{2F1A}", "\u{2F1A}", "\u{2F1A}", "\u{5382}", "\u{5382}"),
    ("\u{2F1B}", "\u{2F1B}", "\u{2F1B}", "\u{53B6}", "\u{53B6}"),
    ("\u{2F1C}", "\u{2F1C}", "\u{2F1C}", "\u{53C8}", "\u{53C8}"),
    ("\u{2F1D}", "\u{2F1D}", "\u{2F1D}", "\u{53E3}", "\u{53E3}"),
    ("\u{2F1E}", "\u{2F1E}", "\u{2F1E}", "\u{56D7}", "\u{56D7}"),
    ("\u{2F1F}", "\u{2F1F}", "\u{2F1F}", "\u{571F}", "\u{571F}"),
    ("\u{2F20}", "\u{2F20}", "\u{2F20}", "\u{58EB}", "\u{58EB}"),
    ("\u{2F21}", "\u{2F21}", "\u{2F21}", "\u{5902}", "\u{5902}"),
    ("\u{2F22}", "\u{2F22}", "\u{2F22}", "\u{590A}", "\u{590A}"),
    ("\u{2F23}", "\u{2F23}", "\u{2F23}", "\u{5915}", "\u{5915}"),
    ("\u{2F24}", "\u{2F24}", "\u{2F24}", "\u{5927}", "\u{5927}"),
    ("\u{2F25}", "\u{2F25}", "\u{2F25}", "\u{5973}", "\u{5973}"),
    ("\u{2F26}", "\u{2F26}", "\u{2F26}", "\u{5B50}", "\u{5B50}"),
    ("\u{2F27}", "\u{2F27}", "\u{2F27}", "\u{5B80}", "\u{5B80}"),
    ("\u{2F28}", "\u{2F28}", "\u{2F28}", "\u{5BF8}", "\u{5BF8}"),
    ("\u{2F29}", "\u{2F29}", "\u{2F29}", "\u{5C0F}", "\u{5C0F}"),
    ("\u{2F2A}", "\u{2F2A}", "\u{2F2A}", "\u{5C22}", "\u{5C22}"),
    ("\u{2F2B}", "\u{2F2B}", "\u{2F2B}", "\u{5C38}", "\u{5C38}"),
    ("\u{2F2C}", "\u{2F2C}", "\u{2F2C}", "\u{5C6E}", "\u{5C6E}"),
    ("\u{2F2D}", "\u{2F2D}", "\u{2F2D}", "\u{5C71}", "\u{5C71}"),
    ("\u{2F2E}", "\u{2F2E}", "\u{2F2E}", "\u{5DDB}", "\u{5DDB}"),
    ("\u{2F2F}", "\u{2F2F}", "\u{2F2F}", "\u{5DE5}", "\u{5DE5}"),
    ("\u{2F30}", "\u{2F30}", "\u{2F30}", "\u{5DF1}", "\u{5DF1}"),
    ("\u{2F31}", "\u{2F31}", "\u{2F31}", "\u{5DFE}", "\u{5DFE}"),
    ("\u{2F32}", "\u{2F32}", "\u{2F32}", "\u{5E72}", "\u{5E72}"),
    ("\u{2F33}", "\u{2F33}", "\u{2F33}", "\u{5E7A}", "\u{5E7A}"),
    ("\u{2F34}", "\u{2F34}", "\u{2F34}", "\u{5E7F}", "\u{5E7F}"),
    ("\u{2F35}", "\u{2F35}", "\u{2F35}", "\u{5EF4}", "\u{5EF4}"),
    ("\u{2F36}", "\u{2F36}", "\u{2F36}", "\u{5EFE}", "\u{5EFE}"),
    ("\u{2F37}", "\u{2F37}", "\u{2F37}", "\u{5F0B}", "\u{5F0B}"),
    ("\u{2F38}", "\u{2F38}", "\u{2F38}", "\u{5F13}", "\u{5F13}"),
    ("\u{2F39}", "\u{2F39}", "\u{2F39}", "\u{5F50}", "\u{5F50}"),
    ("\u{2F3A}", "\u{2F3A}", "\u{2F3A}", "\u{5F61}", "\u{5F61}"),
    ("\u{2F3B}", "\u{2F3B}", "\u{2F3B}", "\u{5F73}", "\u{5F73}"),
    ("\u{2F3C}", "\u{2F3C}", "\u{2F3C}", "\u{5FC3}", "\u{5FC3}"),
    ("\u{2F3D}", "\u{2F3D}", "\u{2F3D}", "\u{6208}", "\u{6208}"),
    ("\u{2F3E}", "\u{2F3E}", "\u{2F3E}", "\u{6236}", "\u{6236}"),
    ("\u{2F3F}", "\u{2F3F}", "\u{2F3F}", "\u{624B}", "\u{624B}"),
    ("\u{2F40}", "\u{2F40}", "\u{2F40}", "\u{652F}", "\u{652F}"),
    ("\u{2F41}", "\u{2F41}", "\u{2F41}", "\u{6534}", "\u{6534}"),
    ("\u{2F42}", "\u{2F42}", "\u{2F42}", "\u{6587}", "\u{6587}"),
    ("\u{2F43}", "\u{2F43}", "\u{2F43}", "\u{6597}", "\u{6597}"),
    ("\u{2F44}", "\u{2F44}", "\u{2F44}", "\u{65A4}", "\u{65A4}"),
    ("\u{2F45}", "\u{2F45}", "\u{2F45}", "\u{65B9}", "\u{65B9}"),
    ("\u{2F46}", "\u{2F46}", "\u{2F46}", "\u{65E0}", "\u{65E0}"),
    ("\u{2F47}", "\u{2F47}", "\u{2F47}", "\u{65E5}", "\u{65E5}"),
    ("\u{2F48}", "\u{2F48}", "\u{2F48}", "\u{66F0}", "\u{66F0}"),
    ("\u{2F49}", "\u{2F49}", "\u{2F49}", "\u{6708}", "\u{6708}"),
    ("\u{2F4A}", "\u{2F4A}", "\u{2F4A}", "\u{6728}", "\u{6728}"),
    ("\u{2F4B}", "\u{2F4B}", "\u{2F4B}", "\u{6B20}", "\u{6B20}"),
    ("\u{2F4C}", "\u{2F4C}", "\u{2F4C}", "\u{6B62}", "\u{6B62}"),
    ("\u{2F4D}", "\u{2F4D}", "\u{2F4D}", "\u{6B79}", "\u{6B79}"),
    ("\u{2F4E}", "\u{2F4E}", "\u{2F4E}", "\u{6BB3}", "\u{6BB3}"),
    ("\u{2F4F}", "\u{2F4F}", "\u{2F4F}", "\u{6BCB}", "\u{6BCB}"),
    ("\u{2F50}", "\u{2F50}", "\u{2F50}", "\u{6BD4}", "\u{6BD4}"),
    ("\u{2F51}", "\u{2F51}", "\u{2F51}", "\u{6BDB}", "\u{6BDB}"),
    ("\u{2F52}", "\u{2F52}", "\u{2F52}", "\u{6C0F}", "\u{6C0F}"),
    ("\u{2F53}", "\u{2F53}", "\u{2F53}", "\u{6C14}", "\u{6C14}"),
    ("\u{2F54}", "\u{2F54}", "\u{2F54}", "\u{6C34}", "\u{6C34}"),
    ("\u{2F55}", "\u{2F55}", "\u{2F55}", "\u{706B}", "\u{706B}"),
    ("\u{2F56}", "\u{2F56}", "\u{2F56}", "\u{722A}", "\u{722A}"),
    ("\u{2F57}", "\u{2F57}", "\u{2F57}", "\u{7236}", "\u{7236}"),
    ("\u{2F58}", "\u{2F58}", "\u{2F58}", "\u{723B}", "\u{723B}"),
    ("\u{2F59}", "\u{2F59}", "\u{2F59}", "\u{723F}", "\u{723F}"),
    ("\u{2F5A}", "\u{2F5A}", "\u{2F5A}", "\u{7247}", "\u{7247}"),
    ("\u{2F5B}", "\u{2F5B}", "\u{2F5B}", "\u{7259}", "\u{7259}"),
    ("\u{2F5C}", "\u{2F5C}", "\u{2F5C}", "\u{725B}", "\u{725B}"),
    ("\u{2F5D}", "\u{2F5D}", "\u{2F5D}", "\u{72AC}", "\u{72AC}"),
    ("\u{2F5E}", "\u{2F5E}", "\u{2F5E}", "\u{7384}", "\u{7384}"),
    ("\u{2F5F}", "\u{2F5F}", "\u{2F5F}", "\u{7389}", "\u{7389}"),
    ("\u{2F60}", "\u{2F60}", "\u{2F60}", "\u{74DC}", "\u{74DC}"),
    ("\u{2F61}", "\u{2F61}", "\u{2F61}", "\u{74E6}", "\u{74E6}"),
    ("\u{2F62}", "\u{2F62}", "\u{2F62}", "\u{7518}", "\u{7518}"),
    ("\u{2F63}", "\u{2F63}", "\u{2F63}", "\u{751F}", "\u{751F}"),
    ("\u{2F64}", "\u{2F64}", "\u{2F64}", "\u{7528}", "\u{7528}"),
    ("\u{2F65}", "\u{2F65}", "\u{2F65}", "\u{7530}", "\u{7530}"),
    ("\u{2F66}", "\u{2F66}", "\u{2F66}", "\u{758B}", "\u{758B}"),
    ("\u{2F67}", "\u{2F67}", "\u{2F67}", "\u{7592}", "\u{7592}"),
    ("\u{2F68}", "\u{2F68}", "\u{2F68}", "\u{7676}", "\u{7676}"),
    ("\u{2F69}", "\u{2F69}", "\u{2F69}", "\u{767D}", "\u{767D}"),
    ("\u{2F6A}", "\u{2F6A}", "\u{2F6A}", "\u{76AE}", "\u{76AE}"),
    ("\u{2F6B}", "\u{2F6B}", "\u{2F6B}", "\u{76BF}", "\u{76BF}"),
    ("\u{2F6C}", "\u{2F6C}", "\u{2F6C}", "\u{76EE}", "\u{76EE}"),
    ("\u{2F6D}", "\u{2F6D}", "\u{2F6D}", "\u{77DB}", "\u{77DB}"),
    ("\u{2F6E}", "\u{2F6E}", "\u{2F6E}", "\u{77E2}", "\u{77E2}"),
    ("\u{2F6F}", "\u{2F6F}", "\u{2F6F}", "\u{77F3}", "\u{77F3}"),
    ("\u{2F70}", "\u{2F70}", "\u{2F70}", "\u{793A}", "\u{793A}"),
    ("\u{2F71}", "\u{2F71}", "\u{2F71}", "\u{79B8}", "\u{79B8}"),
    ("\u{2F72}", "\u{2F72}", "\u{2F72}", "\u{79BE}", "\u{79BE}"),
    ("\u{2F73}", "\u{2F73}", "\u{2F73}", "\u{7A74}", "\u{7A74}"),
    ("\u{2F74}", "\u{2F74}", "\u{2F74}", "\u{7ACB}", "\u{7ACB}"),
    ("\u{2F75}", "\u{2F75}", "\u{2F75}", "\u{7AF9}", "\u{7AF9}"),
    ("\u{2F76}", "\u{2F76}", "\u{2F76}", "\u{7C73}", "\u{7C73}"),
    ("\u{2F77}", "\u{2F77}", "\u{2F77}", "\u{7CF8}", "\u{7CF8}"),
    ("\u{2F78}", "\u{2F78}", "\u{2F78}", "\u{7F36}", "\u{7F36}"),
    ("\u{2F79}", "\u{2F79}", "\u{2F79}", "\u{7F51}", "\u{7F51}"),
    ("\u{2F7A}", "\u{2F7A}", "\u{2F7A}", "\u{7F8A}", "\u{7F8A}"),
    ("\u{2F7B}", "\u{2F7B}", "\u{2F7B}", "\u{7FBD}", "\u{7FBD}"),
    ("\u{2F7C}", "\u{2F7C}", "\u{2F7C}", "\u{8001}", "\u{8001}"),
    ("\u{2F7D}", "\u{2F7D}", "\u{2F7D}", "\u{800C}", "\u{800C}"),
    ("\u{2F7E}", "\u{2F7E}", "\u{2F7E}", "\u{8012}", "\u{8012}"),
    ("\u{2F7F}", "\u{2F7F}", "\u{2F7F}", "\u{8033}", "\u{8033}"),
    ("\u{2F80}", "\u{2F80}", "\u{2F80}", "\u{807F}", "\u{807F}"),
    ("\u{2F81}", "\u{2F81}", "\u{2F81}", "\u{8089}", "\u{8089}"),
    ("\u{2F82}", "\u{2F82}", "\u{2F82}", "\u{81E3}", "\u{81E3}"),
    ("\u{2F83}", "\u{2F83}", "\u{2F83}", "\u{81EA}", "\u{81EA}"),
    ("\u{2F84}", "\u{2F84}", "\u{2F84}", "\u{81F3}", "\u{81F3}"),
    ("\u{2F85}", "\u{2F85}", "\u{2F85}", "\u{81FC}", "\u{81FC}"),
    ("\u{2F86}", "\u{2F86}", "\u{2F86}", "\u{820C}", "\u{820C}"),
    ("\u{2F87}", "\u{2F87}", "\u{2F87}", "\u{821B}", "\u{821B}"),
    ("\u{2F88}", "\u{2F88}", "\u{2F88}", "\u{821F}", "\u{821F}"),
    ("\u{2F89}", "\u{2F89}", "\u{2F89}", "\u{826E}", "\u{826E}"),
    ("\u{2F8A}", "\u{2F8A}", "\u{2F8A}", "\u{8272}", "\u{8272}"),
    ("\u{2F8B}", "\u{2F8B}", "\u{2F8B}", "\u{8278}", "\u{8278}"),
    ("\u{2F8C}", "\u{2F8C}", "\u{2F8C}", "\u{864D}", "\u{864D}"),
    ("\u{2F8D}", "\u{2F8D}", "\u{2F8D}", "\u{866B}", "\u{866B}"),
    ("\u{2F8E}", "\u{2F8E}", "\u{2F8E}", "\u{8840}", "\u{8840}"),
    ("\u{2F8F}", "\u{2F8F}", "\u{2F8F}", "\u{884C}", "\u{884C}"),
    ("\u{2F90}", "\u{2F90}", "\u{2F90}", "\u{8863}", "\u{8863}"),
    ("\u{2F91}", "\u{2F91}", "\u{2F91}", "\u{897E}", "\u{897E}"),
    ("\u{2F92}", "\u{2F92}", "\u{2F92}", "\u{898B}", "\u{898B}"),
    ("\u{2F93}", "\u{2F93}", "\u{2F93}", "\u{89D2}", "\u{89D2}"),
    ("\u{2F94}", "\u{2F94}", "\u{2F94}", "\u{8A00}", "\u{8A00}"),
    ("\u{2F95}", "\u{2F95}", "\u{2F95}", "\u{8C37}", "\u{8C37}"),
    ("\u{2F96}", "\u{2F96}", "\u{2F96}", "\u{8C46}", "\u{8C46}"),
    ("\u{2F97}", "\u{2F97}", "\u{2F97}", "\u{8C55}", "\u{8C55}"),
    ("\u{2F98}", "\u{2F98}", "\u{2F98}", "\u{8C78}", "\u{8C78}"),
    ("\u{2F99}", "\u{2F99}", "\u{2F99}", "\u{8C9D}", "\u{8C9D}"),
    ("\u{2F9A}", "\u{2F9A}", "\u{2F9A}", "\u{8D64}", "\u{8D64}"),
    ("\u{2F9B}", "\u{2F9B}", "\u{2F9B}", "\u{8D70}", "\u{8D70}"),
    ("\u{2F9C}", "\u{2F9C}", "\u{2F9C}", "\u{8DB3}", "\u{8DB3}"),
    ("\u{2F9D}", "\u{2F9D}", "\u{2F9D}", "\u{8EAB}", "\u{8EAB}"),
    ("\u{2F9E}", "\u{2F9E}", "\u{2F9E}", "\u{8ECA}", "\u{8ECA}"),
    ("\u{2F9F}", "\u{2F9F}", "\u{2F9F}", "\u{8F9B}", "\u{8F9B}"),
    ("\u{2FA0}", "\u{2FA0}", "\u{2FA0}", "\u{8FB0}", "\u{8FB0}"),
    ("\u{2FA1}", "\u{2FA1}", "\u{2FA1}", "\u{8FB5}", "\u{8FB5}"),
    ("\u{2FA2}", "\u{2FA2}", "\u{2FA2}", "\u{9091}", "\u{9091}"),
    ("\u{2FA3}", "\u{2FA3}", "\u{2FA3}", "\u{9149}", "\u{9149}"),
    ("\u{2FA4}", "\u{2FA4}", "\u{2FA4}", "\u{91C6}", "\u{91C6}"),
    ("\u{2FA5}", "\u{2FA5}", "\u{2FA5}", "\u{91CC}", "\u{91CC}"),
    ("\u{2FA6}", "\u{2FA6}", "\u{2FA6}", "\u{91D1}", "\u{91D1}"),
    ("\u{2FA7}", "\u{2FA7}", "\u{2FA7}", "\u{9577}", "\u{9577}"),
    ("\u{2FA8}", "\u{2FA8}", "\u{2FA8}", "\u{9580}", "\u{9580}"),
    ("\u{2FA9}", "\u{2FA9}", "\u{2FA9}", "\u{961C}", "\u{961C}"),
    ("\u{2FAA}", "\u{2FAA}", "\u{2FAA}", "\u{96B6}", "\u{96B6}"),
    ("\u{2FAB}", "\u{2FAB}", "\u{2FAB}", "\u{96B9}", "\u{96B9}"),
    ("\u{2FAC}", "\u{2FAC}", "\u{2FAC}", "\u{96E8}", "\u{96E8}"),
    ("\u{2FAD}", "\u{2FAD}", "\u{2FAD}", "\u{9751}", "\u{9751}"),
    ("\u{2FAE}", "\u{2FAE}", "\u{2FAE}", "\u{975E}", "\u{975E}"),
    ("\u{2FAF}", "\u{2FAF}", "\u{2FAF}", "\u{9762}", "\u{9762}"),
    ("\u{2FB0}", "\u{2FB0}", "\u{2FB0}", "\u{9769}", "\u{9769}"),
    ("\u{2FB1}", "\u{2FB1}", "\u{2FB1}", "\u{97CB}", "\u{97CB}"),
    ("\u{2FB2}", "\u{2FB2}", "\u{2FB2}", "\u{97ED}", "\u{97ED}"),
    ("\u{2FB3}", "\u{2FB3}", "\u{2FB3}", "\u{97F3}", "\u{97F3}"),
    ("\u{2FB4}", "\u{2FB4}", "\u{2FB4}", "\u{9801}", "\u{9801}"),
    ("\u{2FB5}", "\u{2FB5}", "\u{2FB5}", "\u{98A8}", "\u{98A8}"),
    ("\u{2FB6}", "\u{2FB6}", "\u{2FB6}", "\u{98DB}", "\u{98DB}"),
    ("\u{2FB7}", "\u{2FB7}", "\u{2FB7}", "\u{98DF}", "\u{98DF}"),
    ("\u{2FB8}", "\u{2FB8}", "\u{2FB8}", "\u{9996}", "\u{9996}"),
    ("\u{2FB9}", "\u{2FB9}", "\u{2FB9}", "\u{9999}", "\u{9999}"),
    ("\u{2FBA}", "\u{2FBA}", "\u{2FBA}", "\u{99AC}", "\u{99AC}"),
    ("\u{2FBB}", "\u{2FBB}", "\u{2FBB}", "\u{9AA8}", "\u{9AA8}"),
    ("\u{2FBC}", "\u{2FBC}", "\u{2FBC}", "\u{9AD8}", "\u{9AD8}"),
    ("\u{2FBD}", "\u{2FBD}", "\u{2FBD}", "\u{9ADF}", "\u{9ADF}"),
    ("\u{2FBE}", "\u{2FBE}", "\u{2FBE}", "\u{9B25}", "\u{9B25}"),
    ("\u{2FBF}", "\u{2FBF}", "\u{2FBF}", "\u{9B2F}", "\u{9B2F}"),
    ("\u{2FC0}", "\u{2FC0}", "\u{2FC0}", "\u{9B32}", "\u{9B32}"),
    ("\u{2FC1}", "\u{2FC1}", "\u{2FC1}", "\u{9B3C}", "\u{9B3C}"),
    ("\u{2FC2}", "\u{2FC2}", "\u{2FC2}", "\u{9B5A}", "\u{9B5A}"),
    ("\u{2FC3}", "\u{2FC3}", "\u{2FC3}", "\u{9CE5}", "\u{9CE5}"),
    ("\u{2FC4}", "\u{2FC4}", "\u{2FC4}", "\u{9E75}", "\u{9E75}"),
    ("\u{2FC5}", "\u{2FC5}", "\u{2FC5}", "\u{9E7F}", "\u{9E7F}"),
    ("\u{2FC6}", "\u{2FC6}", "\u{2FC6}", "\u{9EA5}", "\u{9EA5}"),
    ("\u{2FC7}", "\u{2FC7}", "\u{2FC7}", "\u{9EBB}", "\u{9EBB}"),
    ("\u{2FC8}", "\u{2FC8}", "\u{2FC8}", "\u{9EC3}", "\u{9EC3}"),
    ("\u{2FC9}", "\u{2FC9}", "\u{2FC9}", "\u{9ECD}", "\u{9ECD}"),
    ("\u{2FCA}", "\u{2FCA}", "\u{2FCA}", "\u{9ED1}", "\u{9ED1}"),
    ("\u{2FCB}", "\u{2FCB}", "\u{2FCB}", "\u{9EF9}", "\u{9EF9}"),
    ("\u{2FCC}", "\u{2FCC}", "\u{2FCC}", "\u{9EFD}", "\u{9EFD}"),
    ("\u{2FCD}", "\u{2FCD}", "\u{2FCD}", "\u{9F0E}", "\u{9F0E}"),
    ("\u{2FCE}", "\u{2FCE}", "\u{2FCE}", "\u{9F13}", "\u{9F13}"),
    ("\u{2FCF}", "\u{2FCF}", "\u{2FCF}", "\u{9F20}", "\u{9F20}"),
    ("\u{2FD0}", "\u{2FD0}", "\u{2FD0}", "\u{9F3B}", "\u{9F3B}"),
    ("\u{2FD1}", "\u{2FD1}", "\u{2FD1}", "\u{9F4A}", "\u{9F4A}"),
    ("\u{2FD2}", "\u{2FD2}", "\u{2FD2}", "\u{9F52}", "\u{9F52}"),
    ("\u{2FD3}", "\u{2FD3}", "\u{2FD3}", "\u{9F8D}", "\u{9F8D}"),
    ("\u{2FD4}", "\u{2FD4}", "\u{2FD4}", "\u{9F9C}", "\u{9F9C}"),
    ("\u{2FD5}", "\u{2FD5}", "\u{2FD5}", "\u{9FA0}", "\u{9FA0}"),
    ("\u{3000}", "\u{3000}", "\u{3000}", "\u{0020}", "\u{0020}"),
    ("\u{3036}", "\u{3036}", "\u{3036}", "\u{3012}", "\u{3012}"),
    ("\u{3038}", "\u{3038}", "\u{3038}", "\u{5341}", "\u{5341}"),
    ("\u{3039}", "\u{3039}", "\u{3039}", "\u{5344}", "\u{5344}"),
    ("\u{303A}", "\u{303A}", "\u{303A}", "\u{5345}", "\u{5345}"),
    ("\u{304C}", "\u{304C}", "\u{304B}\u{3099}", "\u{304C}", "\u{304B}\u{3099}"),
    ("\u{304E}", "\u{304E}", "\u{304D}\u{3099}", "\u{304E}", "\u{304D}\u{3099}"),
    ("\u{3050}", "\u{3050}", "\u{304F}\u{3099}", "\u{3050}", "\u{304F}\u{3099}"),
    ("\u{3052}", "\u{3052}", "\u{3051}\u{3099}", "\u{3052}", "\u{3051}\u{3099}"),
    ("\u{3054}", "\u{3054}", "\u{3053}\u{3099}", "\u{3054}", "\u{3053}\u{3099}"),
    ("\u{3056}", "\u{3056}", "\u{3055}\u{3099}", "\u{3056}", "\u{3055}\u{3099}"),
    ("\u{3058}", "\u{3058}", "\u{3057}\u{3099}", "\u{3058}", "\u{3057}\u{3099}"),
    ("\u{305A}", "\u{305A}", "\u{3059}\u{3099}", "\u{305A}", "\u{3059}\u{3099}"),
    ("\u{305C}", "\u{305C}", "\u{305B}\u{3099}", "\u{305C}", "\u{305B}\u{3099}"),
    ("\u{305E}", "\u{305E}", "\u{305D}\u{3099}", "\u{305E}", "\u{305D}\u{3099}"),
    ("\u{3060}", "\u{3060}", "\u{305F}\u{3099}", "\u{3060}", "\u{305F}\u{3099}"),
    ("\u{3062}", "\u{3062}", "\u{3061}\u{3099}", "\u{3062}", "\u{3061}\u{3099}"),
    ("\u{3065}", "\u{3065}", "\u{3064}\u{3099}", "\u{3065}", "\u{3064}\u{3099}"),
    ("\u{3067}", "\u{3067}", "\u{3066}\u{3099}", "\u{3067}", "\u{3066}\u{3099}"),
    ("\u{3069}", "\u{3069}", "\u{3068}\u{3099}", "\u{3069}", "\u{3068}\u{3099}"),
    ("\u{3070}", "\u{3070}", "\u{306F}\u{3099}", "\u{3070}", "\u{306F}\u{3099}"),
    ("\u{3071}", "\u{3071}", "\u{306F}\u{309A}", "\u{3071}", "\u{306F}\u{309A}"),
    ("\u{3073}", "\u{3073}", "\u{3072}\u{3099}", "\u{3073}", "\u{3072}\u{3099}"),
    ("\u{3074}", "\u{3074}", "\u{3072}\u{309A}", "\u{3074}", "\u{3072}\u{309A}"),
    ("\u{3076}", "\u{3076}", "\u{3075}\u{3099}", "\u{3076}", "\u{3075}\u{3099}"),
    ("\u{3077}", "\u{3077}", "\u{3075}\u{309A}", "\u{3077}", "\u{3075}\u{309A}"),
    ("\u{3079}", "\u{3079}", "\u{3078}\u{3099}", "\u{3079}", "\u{3078}\u{3099}"),
    ("\u{307A}", "\u{307A}", "\u{3078}\u{309A}", "\u{307A}", "\u{3078}\u{309A}"),
    ("\u{307C}", "\u{307C}", "\u{307B}\u{3099}", "\u{307C}", "\u{307B}\u{3099}"),
    ("\u{307D}", "\u{307D}", "\u{307B}\u{309A}", "\u{307D}", "\u{307B}\u{309A}"),
    ("\u{3094}", "\u{3094}", "\u{3046}\u{3099}", "\u{3094}", "\u{3046}\u{3099}"),
    ("\u{309B}", "\u{309B}", "\u{309B}", "\u{0020}\u{3099}", "\u{0020}\u{3099}"),
    ("\u{309C}", "\u{309C}", "\u{309C}", "\u{0020}\u{309A}", "\u{0020}\u{309A}"),
    ("\u{309E}", "\u{309E}", "\u{309D}\u{3099}", "\u{309E}", "\u{309D}\u{3099}"),
    ("\u{309F}", "\u{309F}", "\u{309F}", "\u{3088}\u{308A}", "\u{3088}\u{308A}"),
    ("\u{30AC}", "\u{30AC}", "\u{30AB}\u{3099}", "\u{30AC}", "\u{30AB}\u{3099}"),
    ("\u{30AE}", "\u{30AE}", "\u{30AD}\u{3099}", "\u{30AE}", "\u{30AD}\u{3099}"),
    ("\u{30B0}", "\u{30B0}", "\u{30AF}\u{3099}", "\u{30B0}", "\u{30AF}\u{3099}"),
    ("\u{30B2}", "\u{30B2}", "\u{30B1}\u{3099}", "\u{30B2}", "\u{30B1}\u{3099}"),
    ("\u{30B4}", "\u{30B4}", "\u{30B3}\u{3099}", "\u{30B4}", "\u{30B3}\u{3099}"),
    ("\u{30B6}", "\u{30B6}", "\u{30B5}\u{3099}", "\u{30B6}", "\u{30B5}\u{3099}"),
    ("\u{30B8}", "\u{30B8}", "\u{30B7}\u{3099}", "\u{30B8}", "\u{30B7}\u{3099}"),
    ("\u{30BA}", "\u{30BA}", "\u{30B9}\u{3099}", "\u{30BA}", "\u{30B9}\u{3099}"),
    ("\u{30BC}", "\u{30BC}", "\u{30BB}\u{3099}", "\u{30BC}", "\u{30BB}\u{3099}"),
    ("\u{30BE}", "\u{30BE}", "\u{30BD}\u{3099}", "\u{30BE}", "\u{30BD}\u{3099}"),
    ("\u{30C0}", "\u{30C0}", "\u{30BF}\u{3099}", "\u{30C0}", "\u{30BF}\u{3099}"),
    ("\u{30C2}", "\u{30C2}", "\u{30C1}\u{3099}", "\u{30C2}", "\u{30C1}\u{3099}"),
    ("\u{30C5}", "\u{30C5}", "\u{30C4}\u{3099}", "\u{30C5}", "\u{30C4}\u{3099}"),
    ("\u{30C7}", "\u{30C7}", "\u{30C6}\u{3099}", "\u{30C7}", "\u{30C6}\u{3099}"),
    ("\u{30C9}", "\u{30C9}", "\u{30C8}\u{3099}", "\u{30C9}", "\u{30C8}\u{3099}"),
    ("\u{30D0}", "\u{30D0}", "\u{30CF}\u{3099}", "\u{30D0}", "\u{30CF}\u{3099}"),
    ("\u{30D1}", "\u{30D1}", "\u{30CF}\u{309A}", "\u{30D1}", "\u{30CF}\u{309A}"),
    ("\u{30D3}", "\u{30D3}", "\u{30D2}\u{3099}", "\u{30D3}", "\u{30D2}\u{3099}"),
    ("\u{30D4}", "\u{30D4}", "\u{30D2}\u{309A}", "\u{30D4}", "\u{30D2}\u{309A}"),
    ("\u{30D6}", "\u{30D6}", "\u{30D5}\u{3099}", "\u{30D6}", "\u{30D5}\u{3099}"),
    ("\u{30D7}", "\u{30D7}", "\u{30D5}\u{309A}", "\u{30D7}", "\u{30D5}\u{309A}"),
    ("\u{30D9}", "\u{30D9}", "\u{30D8}\u{3099}", "\u{30D9}", "\u{30D8}\u{3099}"),
    ("\u{30DA}", "\u{30DA}", "\u{30D8}\u{309A}", "\u{30DA}", "\u{30D8}\u{309A}"),
    ("\u{30DC}", "\u{30DC}", "\u{30DB}\u{3099}", "\u{30DC}", "\u{30DB}\u{3099}"),
    ("\u{30DD}", "\u{30DD}", "\u{30DB}\u{309A}", "\u{30DD}", "\u{30DB}\u{309A}"),
    ("\u{30F4}", "\u{30F4}", "\u{30A6}\u{3099}", "\u{30F4}", "\u{30A6}\u{3099}"),
    ("\u{30F7}", "\u{30F7}", "\u{30EF}\u{3099}", "\u{30F7}", "\u{30EF}\u{3099}"),
    ("\u{30F8}", "\u{30F8}", "\u{30F0}\u{3099}", "\u{30F8}", "\u{30F0}\u{3099}"),
    ("\u{30F9}", "\u{30F9}", "\u{30F1}\u{3099}", "\u{30F9}", "\u{30F1}\u{3099}"),
    ("\u{30FA}", "\u{30FA}", "\u{30F2}\u{3099}", "\u{30FA}", "\u{30F2}\u{3099}"),
    ("\u{30FE}", "\u{30FE}", "\u{30FD}\u{3099}", "\u{30FE}", "\u{30FD}\u{3099}"),
    ("\u{30FF}", "\u{30FF}", "\u{30FF}", "\u{30B3}\u{30C8}", "\u{30B3}\u{30C8}"),
    ("\u{3131}", "\u{3131}", "\u{3131}", "\u{1100}", "\u{1100}"),
    ("\u{3132}", "\u{3132}", "\u{3132}", "\u{1101}", "\u{1101}"),
    ("\u{3133}", "\u{3133}", "\u{3133}", "\u{11AA}", "\u{11AA}"),
    ("\u{3134}", "\u{3134}", "\u{3134}", "\u{1102}", "\u{1102}"),
    ("\u{3135}", "\u{3135}", "\u{3135}", "\u{11AC}", "\u{11AC}"),
    ("\u{3136}", "\u{3136}", "\u{3136}", "\u{11AD}", "\u{11AD}"),
    ("\u{3137}", "\u{3137}", "\u{3137}", "\u{1103}", "\u{1103}"),
    ("\u{3138}", "\u{3138}", "\u{3138}", "\u{1104}", "\u{1104}"),
    ("\u{3139}", "\u{3139}", "\u{3139}", "\u{1105}", "\u{1105}"),
    ("\u{313A}", "\u{313A}", "\u{313A}", "\u{11B0}", "\u{11B0}"),
    ("\u{313B}", "\u{313B}", "\u{313B}", "\u{11B1}", "\u{11B1}"),
    ("\u{313C}", "\u{313C}", "\u{313C}", "\u{11B2}", "\u{11B2}"),
    ("\u{313D}", "\u{313D}", "\u{313D}", "\u{11B3}", "\u{11B3}"),
    ("\u{313E}", "\u{313E}", "\u{313E}", "\u{11B4}", "\u{11B4}"),
    ("\u{313F}", "\u{313F}", "\u{313F}", "\u{11B5}", "\u{11B5}"),
    ("\u{3140}", "\u{3140}", "\u{3140}", "\u{111A}", "\u{111A}"),
    ("\u{3141}", "\u{3141}", "\u{3141}", "\u{1106}", "\u{1106}"),
    ("\u{3142}", "\u{3142}", "\u{3142}", "\u{1107}", "\u{1107}"),
    ("\u{3143}", "\u{3143}", "\u{3143}", "\u{1108}", "\u{1108}"),
    ("\u{3144}", "\u{3144}", "\u{3144}", "\u{1121}", "\u{1121}"),
    ("\u{3145}", "\u{3145}", "\u{3145}", "\u{1109}", "\u{1109}"),
    ("\u{3146}", "\u{3146}", "\u{3146}", "\u{110A}", "\u{110A}"),
    ("\u{3147}", "\u{3147}", "\u{3147}", "\u{110B}", "\u{110B}"),
    ("\u{3148}", "\u{3148}", "\u{3148}", "\u{110C}", "\u{110C}"),
    ("\u{3149}", "\u{3149}", "\u{3149}", "\u{110D}", "\u{110D}"),
    ("\u{314A}", "\u{314A}", "\u{314A}", "\u{110E}", "\u{110E}"),
    ("\u{314B}", "\u{314B}", "\u{314B}", "\u{110F}", "\u{110F}"),
    ("\u{314C}", "\u{314C}", "\u{314C}", "\u{1110}", "\u{1110}"),
    ("\u{314D}", "\u{314D}", "\u{314D}", "\u{1111}", "\u{1111}"),
    ("\u{314E}", "\u{314E}", "\u{314E}", "\u{1112}", "\u{1112}"),
    ("\u{314F}", "\u{314F}", "\u{314F}", "\u{1161}", "\u{1161}"),
    ("\u{3150}", "\u{3150}", "\u{3150}", "\u{1162}", "\u{1162}"),
    ("\u{3151}", "\u{3151}", "\u{3151}", "\u{1163}", "\u{1163}"),
    ("\u{3152}", "\u{3152}", "\u{3152}", "\u{1164}", "\u{1164}"),
    ("\u{3153}", "\u{3153}", "\u{3153}", "\u{1165}", "\u{1165}"),
    ("\u{3154}", "\u{3154}", "\u{3154}", "\u{1166}", "\u{1166}"),
    ("\u{3155}", "\u{3155}", "\u{3155}", "\u{1167}", "\u{1167}"),
    ("\u{3156}", "\u{3156}", "\u{3156}", "\u{1168}", "\u{1168}"),
    ("\u{3157}", "\u{3157}", "\u{3157}", "\u{1169}", "\u{1169}"),
    ("\u{3158}", "\u{3158}", "\u{3158}", "\u{116A}", "\u{116A}"),
    ("\u{3159}", "\u{3159}", "\u{3159}", "\u{116B}", "\u{116B}"),
    ("\u{315A}", "\u{315A}", "\u{315A}", "\u{116C}", "\u{116C}"),
    ("\u{315B}", "\u{315B}", "\u{315B}", "\u{116D}", "\u{116D}"),
    ("\u{315C}", "\u{315C}", "\u{315C}", "\u{116E}", "\u{116E}"),
    ("\u{315D}", "\u{315D}", "\u{315D}", "\u{116F}", "\u{116F}"),
    ("\u{315E}", "\u{315E}", "\u{315E}", "\u{1170}", "\u{1170}"),
    ("\u{315F}", "\u{315F}", "\u{315F}", "\u{1171}", "\u{1171}"),
    ("\u{3160}", "\u{3160}", "\u{3160}", "\u{1172}", "\u{1172}"),
    ("\u{3161}", "\u{3161}", "\u{3161}", "\u{1173}", "\u{1173}"),
    ("\u{3162}", "\u{3162}", "\u{3162}", "\u{1174}", "\u{1174}"),
    ("\u{3163}", "\u{3163}", "\u{3163}", "\u{1175}", "\u{1175}"),
    ("\u{3164}", "\u{3164}", "\u{3164}", "\u{1160}", "\u{1160}"),
    ("\u{3165}", "\u{3165}", "\u{3165}", "\u{1114}", "\u{1114}"),
    ("\u{3166}", "\u{3166}", "\u{3166}", "\u{1115}", "\u{1115}"),
    ("\u{3167}", "\u{3167}", "\u{3167}", "\u{11C7}", "\u{11C7}"),
    ("\u{3168}", "\u{3168}", "\u{3168}", "\u{11C8}", "\u{11C8}"),
    ("\u{3169}", "\u{3169}", "\u{3169}", "\u{11CC}", "\u{11CC}"),
    ("\u{316A}", "\u{316A}", "\u{316A}", "\u{11CE}", "\u{11CE}"),
    ("\u{316B}", "\u{316B}", "\u{316B}", "\u{11D3}", "\u{11D3}"),
    ("\u{316C}", "\u{316C}", "\u{316C}", "\u{11D7}", "\u{11D7}"),
    ("\u{316D}", "\u{316D}", "\u{316D}", "\u{11D9}", "\u{11D9}"),
    ("\u{316E}", "\u{316E}", "\u{316E}", "\u{111C}", "\u{111C}"),
    ("\u{316F}", "\u{316F}", "\u{316F}", "\u{11DD}", "\u{11DD}"),
    ("\u{3170}", "\u{3170}", "\u{3170}", "\u{11DF}", "\u{11DF}"),
    ("\u{3171}", "\u{3171}", "\u{3171}", "\u{111D}", "\u{111D}"),
    ("\u{3172}", "\u{3172}", "\u{3172}", "\u{111E}", "\u{111E}"),
    ("\u{3173}", "\u{3173}", "\u{3173}", "\u{1120}", "\u{1120}"),
    ("\u{3174}", "\u{3174}", "\u{3174}", "\u{1122}", "\u{1122}"),
    ("\u{3175}", "\u{3175}", "\u{3175}", "\u{1123}", "\u{1123}"),
    ("\u{3176}", "\u{3176}", "\u{3176}", "\u{1127}", "\u{1127}"),
    ("\u{3177}", "\u{3177}", "\u{3177}", "\u{1129}", "\u{1129}"),
    ("\u{3178}", "\u{3178}", "\u{3178}", "\u{112B}", "\u{112B}"),
    ("\u{3179}", "\u{3179}", "\u{3179}", "\u{112C}", "\u{112C}"),
    ("\u{317A}", "\u{317A}", "\u{317A}", "\u{112D}", "\u{112D}"),
    ("\u{317B}", "\u{317B}", "\u{317B}", "\u{112E}", "\u{112E}"),
    ("\u{317C}", "\u{317C}", "\u{317C}", "\u{112F}", "\u{112F}"),
    ("\u{317D}", "\u{317D}", "\u{317D}", "\u{1132}", "\u{1132}"),
    ("\u{317E}", "\u{317E}", "\u{317E}", "\u{1136}", "\u{1136}"),
    ("\u{317F}", "\u{317F}", "\u{317F}", "\u{1140}", "\u{1140}"),
    ("\u{3180}", "\u{3180}", "\u{3180}", "\u{1147}", "\u{1147}"),
    ("\u{3181}", "\u{3181}", "\u{3181}", "\u{114C}", "\u{114C}"),
    ("\u{3182}", "\u{3182}", "\u{3182}", "\u{11F1}", "\u{11F1}"),
    ("\u{3183}", "\u{3183}", "\u{3183}", "\u{11F2}", "\u{11F2}"),
    ("\u{3184}", "\u{3184}", "\u{3184}", "\u{1157}", "\u{1157}"),
    ("\u{3185}", "\u{3185}", "\u{3185}", "\u{1158}", "\u{1158}"),
    ("\u{3186}", "\u{3186}", "\u{3186}", "\u{1159}", "\u{1159}"),
    ("\u{3187}", "\u{3187}", "\u{3187}", "\u{1184}", "\u{1184}"),
    ("\u{3188}", "\u{3188}", "\u{3188}", "\u{1185}", "\u{1185}"),
    ("\u{3189}", "\u{3189}", "\u{3189}", "\u{1188}", "\u{1188}"),
    ("\u{318A}", "\u{318A}", "\u{318A}", "\u{1191}", "\u{1191}"),
    ("\u{318B}", "\u{318B}", "\u{318B}", "\u{1192}", "\u{1192}"),
    ("\u{318C}", "\u{318C}", "\u{318C}", "\u{1194}", "\u{1194}"),
    ("\u{318D}", "\u{318D}", "\u{318D}", "\u{119E}", "\u{119E}"),
    ("\u{318E}", "\u{318E}", "\u{318E}", "\u{11A1}", "\u{11A1}"),
    ("\u{3192}", "\u{3192}", "\u{3192}", "\u{4E00}", "\u{4E00}"),
    ("\u{3193}", "\u{3193}", "\u{3193}", "\u{4E8C}", "\u{4E8C}"),
    ("\u{3194}", "\u{3194}", "\u{3194}", "\u{4E09}", "\u{4E09}"),
    ("\u{3195}", "\u{3195}", "\u{3195}", "\u{56DB}", "\u{56DB}"),
    ("\u{3196}", "\u{3196}", "\u{3196}", "\u{4E0A}", "\u{4E0A}"),
    ("\u{3197}", "\u{3197}", "\u{3197}", "\u{4E2D}", "\u{4E2D}"),
    ("\u{3198}", "\u{3198}", "\u{3198}", "\u{4E0B}", "\u{4E0B}"),
    ("\u{3199}", "\u{3199}", "\u{3199}", "\u{7532}", "\u{7532}"),
    ("\u{319A}", "\u{319A}", "\u{319A}", "\u{4E59}", "\u{4E59}"),
    ("\u{319B}", "\u{319B}", "\u{319B}", "\u{4E19}", "\u{4E19}"),
    ("\u{319C}", "\u{319C}", "\u{319C}", "\u{4E01}", "\u{4E01}"),
    ("\u{319D}", "\u{319D}", "\u{319D}", "\u{5929}", "\u{5929}"),
    ("\u{319E}", "\u{319E}", "\u{319E}", "\u{5730}", "\u{5730}"),
    ("\u{319F}", "\u{319F}", "\u{319F}", "\u{4EBA}", "\u{4EBA}"),
    ("\u{3200}", "\u{3200}", "\u{3200}", "\u{0028}\u{1100}\u{0029}", "\u{0028}\u{1100}\u{0029}"),
    ("\u{3201}", "\u{3201}", "\u{3201}", "\u{0028}\u{1102}\u{0029}", "\u{0028}\u{1102}\u{0029}"),
    ("\u{3202}", "\u{3202}", "\u{3202}", "\u{0028}\u{1103}\u{0029}", "\u{0028}\u{1103}\u{0029}"),
    ("\u{3203}", "\u{3203}", "\u{3203}", "\u{0028}\u{1105}\u{0029}", "\u{0028}\u{1105}\u{0029}"),
    ("\u{3204}", "\u{3204}", "\u{3204}", "\u{0028}\u{1106}\u{0029}", "\u{0028}\u{1106}\u{0029}"),
    ("\u{3205}", "\u{3205}", "\u{3205}", "\u{0028}\u{1107}\u{0029}", "\u{0028}\u{1107}\u{0029}"),
    ("\u{3206}", "\u{3206}", "\u{3206}", "\u{0028}\u{1109}\u{0029}", "\u{0028}\u{1109}\u{0029}"),
    ("\u{3207}", "\u{3207}", "\u{3207}", "\u{0028}\u{110B}\u{0029}", "\u{0028}\u{110B}\u{0029}"),
    ("\u{3208}", "\u{3208}", "\u{3208}", "\u{0028}\u{110C}\u{0029}", "\u{0028}\u{110C}\u{0029}"),
    ("\u{3209}", "\u{3209}", "\u{3209}", "\u{0028}\u{110E}\u{0029}", "\u{0028}\u{110E}\u{0029}"),
    ("\u{320A}", "\u{320A}", "\u{320A}", "\u{0028}\u{110F}\u{0029}", "\u{0028}\u{110F}\u{0029}"),
    ("\u{320B}", "\u{320B}", "\u{320B}", "\u{0028}\u{1110}\u{0029}", "\u{0028}\u{1110}\u{0029}"),
    ("\u{320C}", "\u{320C}", "\u{320C}", "\u{0028}\u{1111}\u{0029}", "\u{0028}\u{1111}\u{0029}"),
    ("\u{320D}", "\u{320D}", "\u{320D}", "\u{0028}\u{1112}\u{0029}", "\u{0028}\u{1112}\u{0029}"),
    ("\u{320E}", "\u{320E}", "\u{320E}", "\u{0028}\u{AC00}\u{0029}", "\u{0028}\u{1100}\u{1161}\u{0029}"),
    ("\u{320F}", "\u{320F}", "\u{320F}", "\u{0028}\u{B098}\u{0029}", "\u{0028}\u{1102}\u{1161}\u{0029}"),
    ("\u{3210}", "\u{3210}", "\u{3210}", "\u{0028}\u{B2E4}\u{0029}", "\u{0028}\u{1103}\u{1161}\u{0029}"),
    ("\u{3211}", "\u{3211}", "\u{3211}", "\u{0028}\u{B77C}\u{0029}", "\u{0028}\u{1105}\u{1161}\u{0029}"),
    ("\u{3212}", "\u{3212}", "\u{3212}", "\u{0028}\u{B9C8}\u{0029}", "\u{0028}\u{1106}\u{1161}\u{0029}"),
    ("\u{3213}", "\u{3213}", "\u{3213}", "\u{0028}\u{BC14}\u{0029}", "\u{0028}\u{1107}\u{1161}\u{0029}"),
    ("\u{3214}", "\u{3214}", "\u{3214}", "\u{0028}\u{C0AC}\u{0029}", "\u{0028}\u{1109}\u{1161}\u{0029}"),
    ("\u{3215}", "\u{3215}", "\u{3215}", "\u{0028}\u{C544}\u{0029}", "\u{0028}\u{110B}\u{1161}\u{0029}"),
    ("\u{3216}", "\u{3216}", "\u{3216}", "\u{0028}\u{C790}\u{0029}", "\u{0028}\u{110C}\u{1161}\u{0029}"),
    ("\u{3217}", "\u{3217}", "\u{3217}", "\u{0028}\u{CC28}\u{0029}", "\u{0028}\u{110E}\u{1161}\u{0029}"),
    ("\u{3218}", "\u{3218}", "\u{3218}", "\u{0028}\u{CE74}\u{0029}", "\u{0028}\u{110F}\u{1161}\u{0029}"),
    ("\u{3219}", "\u{3219}", "\u{3219}", "\u{0028}\u{D0C0}\u{0029}", "\u{0028}\u{1110}\u{1161}\u{0029}"),
    ("\u{321A}", "\u{321A}", "\u{321A}", "\u{0028}\u{D30C}\u{0029}", "\u{0028}\u{1111}\u{1161}\u{0029}"),
    ("\u{321B}", "\u{321B}", "\u{321B}", "\u{0028}\u{D558}\u{0029}", "\u{0028}\u{1112}\u{1161}\u{0029}"),
    ("\u{321C}", "\u{321C}", "\u{321C}", "\u{0028}\u{C8FC}\u{0029}", "\u{0028}\u{110C}\u{116E}\u{0029}"),
    ("\u{321D}", "\u{321D}", "\u{321D}", "\u{0028}\u{C624}\u{C804}\u{0029}", "\u{0028}\u{110B}\u{1169}\u{110C}\u{1165}\u{11AB}\u{0029}"),
    ("\u{321E}", "\u{321E}", "\u{321E}", "\u{0028}\u{C624}\u{D6C4}\u{0029}", "\u{0028}\u{110B}\u{1169}\u{1112}\u{116E}\u{0029}"),
    ("\u{3220}", "\u{3220}", "\u{3220}", "\u{0028}\u{4E00}\u{0029}", "\u{0028}\u{4E00}\u{0029}"),
    ("\u{3221}", "\u{3221}", "\u{3221}", "\u{0028}\u{4E8C}\u{0029}", "\u{0028}\u{4E8C}\u{0029}"),
    ("\u{3222}", "\u{3222}", "\u{3222}", "\u{0028}\u{4E09}\u{0029}", "\u{0028}\u{4E09}\u{0029}"),
    ("\u{3223}", "\u{3223}", "\u{3223}", "\u{0028}\u{56DB}\u{0029}", "\u{0028}\u{56DB}\u{0029}"),
    ("\u{3224}", "\u{3224}", "\u{3224}", "\u{0028}\u{4E94}\u{0029}", "\u{0028}\u{4E94}\u{0029}"),
    ("\u{3225}", "\u{3225}", "\u{3225}", "\u{0028}\u{516D}\u{0029}", "\u{0028}\u{516D}\u{0029}"),
    ("\u{3226}", "\u{3226}", "\u{3226}", "\u{0028}\u{4E03}\u{0029}", "\u{0028}\u{4E03}\u{0029}"),
    ("\u{3227}", "\u{3227}", "\u{3227}", "\u{0028}\u{516B}\u{0029}", "\u{0028}\u{516B}\u{0029}"),
    ("\u{3228}", "\u{3228}", "\u{3228}", "\u{0028}\u{4E5D}\u{0029}", "\u{0028}\u{4E5D}\u{0029}"),
    ("\u{3229}", "\u{3229}", "\u{3229}", "\u{0028}\u{5341}\u{0029}", "\u{0028}\u{5341}\u{0029}"),
    ("\u{322A}", "\u{322A}", "\u{322A}", "\u{0028}\u{6708}\u{0029}", "\u{0028}\u{6708}\u{0029}"),
    ("\u{322B}", "\u{322B}", "\u{322B}", "\u{0028}\u{706B}\u{0029}", "\u{0028}\u{706B}\u{0029}"),
    ("\u{322C}", "\u{322C}", "\u{322C}", "\u{0028}\u{6C34}\u{0029}", "\u{0028}\u{6C34}\u{0029}"),
    ("\u{322D}", "\u{322D}", "\u{322D}", "\u{0028}\u{6728}\u{0029}", "\u{0028}\u{6728}\u{0029}"),
    ("\u{322E}", "\u{322E}", "\u{322E}", "\u{0028}\u{91D1}\u{0029}", "\u{0028}\u{91D1}\u{0029}"),
    ("\u{322F}", "\u{322F}", "\u{322F}", "\u{0028}\u{571F}\u{0029}", "\u{0028}\u{571F}\u{0029}"),
    ("\u{3230}", "\u{3230}", "\u{3230}", "\u{0028}\u{65E5}\u{0029}", "\u{0028}\u{65E5}\u{0029}"),
    ("\u{3231}", "\u{3231}", "\u{3231}", "\u{0028}\u{682A}\u{0029}", "\u{0028}\u{682A}\u{0029}"),
    ("\u{3232}", "\u{3232}", "\u{3232}", "\u{0028}\u{6709}\u{0029}", "\u{0028}\u{6709}\u{0029}"),
    ("\u{3233}", "\u{3233}", "\u{3233}", "\u{0028}\u{793E}\u{0029}", "\u{0028}\u{793E}\u{0029}"),
    ("\u{3234}", "\u{3234}", "\u{3234}", "\u{0028}\u{540D}\u{0029}", "\u{0028}\u{540D}\u{0029}"),
    ("\u{3235}", "\u{3235}", "\u{3235}", "\u{0028}\u{7279}\u{0029}", "\u{0028}\u{7279}\u{0029}"),
    ("\u{3236}", "\u{3236}", "\u{3236}", "\u{0028}\u{8CA1}\u{0029}", "\u{0028}\u{8CA1}\u{0029}"),
    ("\u{3237}", "\u{3237}", "\u{3237}", "\u{0028}\u{795D}\u{0029}", "\u{0028}\u{795D}\u{0029}"),
    ("\u{3238}", "\u{3238}", "\u{3238}", "\u{0028}\u{52B4}\u{0029}", "\u{0028}\u{52B4}\u{0029}"),
    ("\u{3239}", "\u{3239}", "\u{3239}", "\u{0028}\u{4EE3}\u{0029}", "\u{0028}\u{4EE3}\u{0029}"),
    ("\u{323A}", "\u{323A}", "\u{323A}", "\u{0028}\u{547C}\u{0029}", "\u{0028}\u{547C}\u{0029}"),
    ("\u{323B}", "\u{323B}", "\u{323B}", "\u{0028}\u{5B66}\u{0029}", "\u{0028}\u{5B66}\u{0029}"),
    ("\u{323C}", "\u{323C}", "\u{323C}", "\u{0028}\u{76E3}\u{0029}", "\u{0028}\u{76E3}\u{0029}"),
    ("\u{323D}", "\u{323D}", "\u{323D}", "\u{0028}\u{4F01}\u{0029}", "\u{0028}\u{4F01}\u{0029}"),
    ("\u{323E}", "\u{323E}", "\u{323E}", "\u{0028}\u{8CC7}\u{0029}", "\u{0028}\u{8CC7}\u{0029}"),
    ("\u{323F}", "\u{323F}", "\u{323F}", "\u{0028}\u{5354}\u{0029}", "\u{0028}\u{5354}\u{0029}"),
    ("\u{3240}", "\u{3240}", "\u{3240}", "\u{0028}\u{796D}\u{0029}", "\u{0028}\u{796D}\u{0029}"),
    ("\u{3241}", "\u{3241}", "\u{3241}", "\u{0028}\u{4F11}\u{0029}", "\u{0028}\u{4F11}\u{0029}"),
    ("\u{3242}", "\u{3242}", "\u{3242}", "\u{0028}\u{81EA}\u{0029}", "\u{0028}\u{81EA}\u{0029}"),
    ("\u{3243}", "\u{3243}", "\u{3243}", "\u{0028}\u{81F3}\u{0029}", "\u{0028}\u{81F3}\u{0029}"),
    ("\u{3244}", "\u{3244}", "\u{3244}", "\u{554F}", "\u{554F}"),
    ("\u{3245}", "\u{3245}", "\u{3245}", "\u{5E7C}", "\u{5E7C}"),
    ("\u{3246}", "\u{3246}", "\u{3246}", "\u{6587}", "\u{6587}"),
    ("\u{3247}", "\u{3247}", "\u{3247}", "\u{7B8F}", "\u{7B8F}"),
    ("\u{3250}", "\u{3250}", "\u{3250}", "\u{0050}\u{0054}\u{0045}", "\u{0050}\u{0054}\u{0045}"),
    ("\u{3251}", "\u{3251}", "\u{3251}", "\u{0032}\u{0031}", "\u{0032}\u{0031}"),
    ("\u{3252}", "\u{3252}", "\u{3252}", "\u{0032}\u{0032}", "\u{0032}\u{0032}"),
    ("\u{3253}", "\u{3253}", "\u{3253}", "\u{0032}\u{0033}", "\u{0032}\u{0033}"),
    ("\u{3254}", "\u{3254}", "\u{3254}", "\u{0032}\u{0034}", "\u{0032}\u{0034}"),
    ("\u{3255}", "\u{3255}", "\u{3255}", "\u{0032}\u{0035}", "\u{0032}\u{0035}"),
    ("\u{3256}", "\u{3256}", "\u{3256}", "\u{0032}\u{0036}", "\u{0032}\u{0036}"),
    ("\u{3257}", "\u{3257}", "\u{3257}", "\u{0032}\u{0037}", "\u{0032}\u{0037}"),
    ("\u{3258}", "\u{3258}", "\u{3258}", "\u{0032}\u{0038}", "\u{0032}\u{0038}"),
    ("\u{3259}", "\u{3259}", "\u{3259}", "\u{0032}\u{0039}", "\u{0032}\u{0039}"),
    ("\u{325A}", "\u{325A}", "\u{325A}", "\u{0033}\u{0030}", "\u{0033}\u{0030}"),
    ("\u{325B}", "\u{325B}", "\u{325B}", "\u{0033}\u{0031}", "\u{0033}\u{0031}"),
    ("\u{325C}", "\u{325C}", "\u{325C}", "\u{0033}\u{0032}", "\u{0033}\u{0032}"),
    ("\u{325D}", "\u{325D}", "\u{325D}", "\u{0033}\u{0033}", "\u{0033}\u{0033}"),
    ("\u{325E}", "\u{325E}", "\u{325E}", "\u{0033}\u{0034}", "\u{0033}\u{0034}"),
    ("\u{325F}", "\u{325F}", "\u{325F}", "\u{0033}\u{0035}", "\u{0033}\u{0035}"),
    ("\u{3260}", "\u{3260}", "\u{3260}", "\u{1100}", "\u{1100}"),
    ("\u{3261}", "\u{3261}", "\u{3261}", "\u{1102}", "\u{1102}"),
    ("\u{3262}", "\u{3262}", "\u{3262}", "\u{1103}", "\u{1103}"),
    ("\u{3263}", "\u{3263}", "\u{3263}", "\u{1105}", "\u{1105}"),
    ("\u{3264}", "\u{3264}", "\u{3264}", "\u{1106}", "\u{1106}"),
    ("\u{3265}", "\u{3265}", "\u{3265}", "\u{1107}", "\u{1107}"),
    ("\u{3266}", "\u{3266}", "\u{3266}", "\u{1109}", "\u{1109}"),
    ("\u{3267}", "\u{3267}", "\u{3267}", "\u{110B}", "\u{110B}"),
    ("\u{3268}", "\u{3268}", "\u{3268}", "\u{110C}", "\u{110C}"),
    ("\u{3269}", "\u{3269}", "\u{3269}", "\u{110E}", "\u{110E}"),
    ("\u{326A}", "\u{326A}", "\u{326A}", "\u{110F}", "\u{110F}"),
    ("\u{326B}", "\u{326B}", "\u{326B}", "\u{1110}", "\u{1110}"),
    ("\u{326C}", "\u{326C}", "\u{326C}", "\u{1111}", "\u{1111}"),
    ("\u{326D}", "\u{326D}", "\u{326D}", "\u{1112}", "\u{1112}"),
    ("\u{326E}", "\u{326E}", "\u{326E}", "\u{AC00}", "\u{1100}\u{1161}"),
    ("\u{326F}", "\u{326F}", "\u{326F}", "\u{B098}", "\u{1102}\u{1161}"),
    ("\u{3270}", "\u{3270}", "\u{3270}", "\u{B2E4}", "\u{1103}\u{1161}"),
    ("\u{3271}", "\u{3271}", "\u{3271}", "\u{B77C}", "\u{1105}\u{1161}"),
    ("\u{3272}", "\u{3272}", "\u{3272}", "\u{B9C8}", "\u{1106}\u{1161}"),
    ("\u{3273}", "\u{3273}", "\u{3273}", "\u{BC14}", "\u{1107}\u{1161}"),
    ("\u{3274}", "\u{3274}", "\u{3274}", "\u{C0AC}", "\u{1109}\u{1161}"),
    ("\u{3275}", "\u{3275}", "\u{3275}", "\u{C544}", "\u{110B}\u{1161}"),
    ("\u{3276}", "\u{3276}", "\u{3276}", "\u{C790}", "\u{110C}\u{1161}"),
    ("\u{3277}", "\u{3277}", "\u{3277}", "\u{CC28}", "\u{110E}\u{1161}"),
    ("\u{3278}", "\u{3278}", "\u{3278}", "\u{CE74}", "\u{110F}\u{1161}"),
    ("\u{3279}", "\u{3279}", "\u{3279}", "\u{D0C0}", "\u{1110}\u{1161}"),
    ("\u{327A}", "\u{327A}", "\u{327A}", "\u{D30C}", "\u{1111}\u{1161}"),
    ("\u{327B}", "\u{327B}", "\u{327B}", "\u{D558}", "\u{1112}\u{1161}"),
    ("\u{327C}", "\u{327C}", "\u{327C}", "\u{CC38}\u{ACE0}", "\u{110E}\u{1161}\u{11B7}\u{1100}\u{1169}"),
    ("\u{327D}", "\u{327D}", "\u{327D}", "\u{C8FC}\u{C758}", "\u{110C}\u{116E}\u{110B}\u{1174}"),
    ("\u{327E}", "\u{327E}", "\u{327E}", "\u{C6B0}", "\u{110B}\u{116E}"),
    ("\u{3280}", "\u{3280}", "\u{3280}", "\u{4E00}", "\u{4E00}"),
    ("\u{3281}", "\u{3281}", "\u{3281}", "\u{4E8C}", "\u{4E8C}"),
    ("\u{3282}", "\u{3282}", "\u{3282}", "\u{4E09}", "\u{4E09}"),
    ("\u{3283}", "\u{3283}", "\u{3283}", "\u{56DB}", "\u{56DB}"),
    ("\u{3284}", "\u{3284}", "\u{3284}", "\u{4E94}", "\u{4E94}"),
    ("\u{3285}", "\u{3285}", "\u{3285}", "\u{516D}", "\u{516D}"),
    ("\u{3286}", "\u{3286}", "\u{3286}", "\u{4E03}", "\u{4E03}"),
    ("\u{3287}", "\u{3287}", "\u{3287}", "\u{516B}", "\u{516B}"),
    ("\u{3288}", "\u{3288}", "\u{3288}", "\u{4E5D}", "\u{4E5D}"),
    ("\u{3289}", "\u{3289}", "\u{3289}", "\u{5341}", "\u{5341}"),
    ("\u{328A}", "\u{328A}", "\u{328A}", "\u{6708}", "\u{6708}"),
    ("\u{328B}", "\u{328B}", "\u{328B}", "\u{706B}", "\u{706B}"),
    ("\u{328C}", "\u{328C}", "\u{328C}", "\u{6C34}", "\u{6C34}"),
    ("\u{328D}", "\u{328D}", "\u{328D}", "\u{6728}", "\u{6728}"),
    ("\u{328E}", "\u{328E}", "\u{328E}", "\u{91D1}", "\u{91D1}"),
    ("\u{328F}", "\u{328F}", "\u{328F}", "\u{571F}", "\u{571F}"),
    ("\u{3290}", "\u{3290}", "\u{3290}", "\u{65E5}", "\u{65E5}"),
    ("\u{3291}", "\u{3291}", "\u{3291}", "\u{682A}", "\u{682A}"),
    ("\u{3292}", "\u{3292}", "\u{3292}", "\u{6709}", "\u{6709}"),
    ("\u{3293}", "\u{3293}", "\u{3293}", "\u{793E}", "\u{793E}"),
    ("\u{3294}", "\u{3294}", "\u{3294}", "\u{540D}", "\u{540D}"),
    ("\u{3295}", "\u{3295}", "\u{3295}", "\u{7279}", "\u{7279}"),
    ("\u{3296}", "\u{3296}", "\u{3296}", "\u{8CA1}", "\u{8CA1}"),
    ("\u{3297}", "\u{3297}", "\u{3297}", "\u{795D}", "\u{795D}"),
    ("\u{3298}", "\u{3298}", "\u{3298}", "\u{52B4}", "\u{52B4}"),
    ("\u{3299}", "\u{3299}", "\u{3299}", "\u{79D8}", "\u{79D8}"),
    ("\u{329A}", "\u{329A}", "\u{329A}", "\u{7537}", "\u{7537}"),
    ("\u{329B}", "\u{329B}", "\u{329B}", "\u{5973}", "\u{5973}"),
    ("\u{329C}", "\u{329C}", "\u{329C}", "\u{9069}", "\u{9069}"),
    ("\u{329D}", "\u{329D}", "\u{329D}", "\u{512A}", "\u{512A}"),
    ("\u{329E}", "\u{329E}", "\u{329E}", "\u{5370}", "\u{5370}"),
    ("\u{329F}", "\u{329F}", "\u{329F}", "\u{6CE8}", "\u{6CE8}"),
    ("\u{32A0}", "\u{32A0}", "\u{32A0}", "\u{9805}", "\u{9805}"),
    ("\u{32A1}", "\u{32A1}", "\u{32A1}", "\u{4F11}", "\u{4F11}"),
    ("\u{32A2}", "\u{32A2}", "\u{32A2}", "\u{5199}", "\u{5199}"),
    ("\u{32A3}", "\u{32A3}", "\u{32A3}", "\u{6B63}", "\u{6B63}"),
    ("\u{32A4}", "\u{32A4}", "\u{32A4}", "\u{4E0A}", "\u{4E0A}"),
    ("\u{32A5}", "\u{32A5}", "\u{32A5}", "\u{4E2D}", "\u{4E2D}"),
    ("\u{32A6}", "\u{32A6}", "\u{32A6}", "\u{4E0B}", "\u{4E0B}"),
    ("\u{32A7}", "\u{32A7}", "\u{32A7}", "\u{5DE6}", "\u{5DE6}"),
    ("\u{32A8}", "\u{32A8}", "\u{32A8}", "\u{53F3}", "\u{53F3}"),
    ("\u{32A9}", "\u{32A9}", "\u{32A9}", "\u{533B}", "\u{533B}"),
    ("\u{32AA}", "\u{32AA}", "\u{32AA}", "\u{5B97}", "\u{5B97}"),
    ("\u{32AB}", "\u{32AB}", "\u{32AB}", "\u{5B66}", "\u{5B66}"),
    ("\u{32AC}", "\u{32AC}", "\u{32AC}", "\u{76E3}", "\u{76E3}"),
    ("\u{32AD}", "\u{32AD}", "\u{32AD}", "\u{4F01}", "\u{4F01}"),
    ("\u{32AE}", "\u{32AE}", "\u{32AE}", "\u{8CC7}", "\u{8CC7}"),
    ("\u{32AF}", "\u{32AF}", "\u{32AF}", "\u{5354}", "\u{5354}"),
    ("\u{32B0}", "\u{32B0}", "\u{32B0}", "\u{591C}", "\u{591C}"),
    ("\u{32B1}", "\u{32B1}", "\u{32B1}", "\u{0033}\u{0036}", "\u{0033}\u{0036}"),
    ("\u{32B2}", "\u{32B2}", "\u{32B2}", "\u{0033}\u{0037}", "\u{0033}\u{0037}"),
    ("\u{32B3}", "\u{32B3}", "\u{32B3}", "\u{0033}\u{0038}", "\u{0033}\u{0038}"),
    ("\u{32B4}", "\u{32B4}", "\u{32B4}", "\u{0033}\u{0039}", "\u{0033}\u{0039}"),
    ("\u{32B5}", "\u{32B5}", "\u{32B5}", "\u{0034}\u{0030}", "\u{0034}\u{0030}"),
    ("\u{32B6}", "\u{32B6}", "\u{32B6}", "\u{0034}\u{0031}", "\u{0034}\u{0031}"),
    ("\u{32B7}", "\u{32B7}", "\u{32B7}", "\u{0034}\u{0032}", "\u{0034}\u{0032}"),
    ("\u{32B8}", "\u{32B8}", "\u{32B8}", "\u{0034}\u{0033}", "\u{0034}\u{0033}"),
    ("\u{32B9}", "\u{32B9}", "\u{32B9}", "\u{0034}\u{0034}", "\u{0034}\u{0034}"),
    ("\u{32BA}", "\u{32BA}", "\u{32BA}", "\u{0034}\u{0035}", "\u{0034}\u{0035}"),
    ("\u{32BB}", "\u{32BB}", "\u{32BB}", "\u{0034}\u{0036}", "\u{0034}\u{0036}"),
    ("\u{32BC}", "\u{32BC}", "\u{32BC}", "\u{0034}\u{0037}", "\u{0034}\u{0037}"),
    ("\u{32BD}", "\u{32BD}", "\u{32BD}", "\u{0034}\u{0038}", "\u{0034}\u{0038}"),
    ("\u{32BE}", "\u{32BE}", "\u{32BE}", "\u{0034}\u{0039}", "\u{0034}\u{0039}"),
    ("\u{32BF}", "\u{32BF}", "\u{32BF}", "\u{0035}\u{0030}", "\u{0035}\u{0030}"),
    ("\u{32C0}", "\u{32C0}", "\u{32C0}", "\u{0031}\u{6708}", "\u{0031}\u{6708}"),
    ("\u{32C1}", "\u{32C1}", "\u{32C1}", "\u{0032}\u{6708}", "\u{0032}\u{6708}"),
    ("\u{32C2}", "\u{32C2}", "\u{32C2}", "\u{0033}\u{6708}", "\u{0033}\u{6708}"),
    ("\u{32C3}", "\u{32C3}", "\u{32C3}", "\u{0034}\u{6708}", "\u{0034}\u{6708}"),
    ("\u{32C4}", "\u{32C4}", "\u{32C4}", "\u{0035}\u{6708}", "\u{0035}\u{6708}"),
    ("\u{32C5}", "\u{32C5}", "\u{32C5}", "\u{0036}\u{6708}", "\u{0036}\u{6708}"),
    ("\u{32C6}", "\u{32C6}", "\u{32C6}", "\u{0037}\u{6708}", "\u{0037}\u{6708}"),
    ("\u{32C7}", "\u{32C7}", "\u{32C7}", "\u{0038}\u{6708}", "\u{0038}\u{6708}"),
    ("\u{32C8}", "\u{32C8}", "\u{32C8}", "\u{0039}\u{6708}", "\u{0039}\u{6708}"),
    ("\u{32C9}", "\u{32C9}", "\u{32C9}", "\u{0031}\u{0030}\u{6708}", "\u{0031}\u{0030}\u{6708}"),
    ("\u{32CA}", "\u{32CA}", "\u{32CA}", "\u{0031}\u{0031}\u{6708}", "\u{0031}\u{0031}\u{6708}"),
    ("\u{32CB}", "\u{32CB}", "\u{32CB}", "\u{0031}\u{0032}\u{6708}", "\u{0031}\u{0032}\u{6708}"),
    ("\u{32CC}", "\u{32CC}", "\u{32CC}", "\u{0048}\u{0067}", "\u{0048}\u{0067}"),
    ("\u{32CD}", "\u{32CD}", "\u{32CD}", "\u{0065}\u{0072}\u{0067}", "\u{0065}\u{0072}\u{0067}"),
    ("\u{32CE}", "\u{32CE}", "\u{32CE}", "\u{0065}\u{0056}", "\u{0065}\u{0056}"),
    ("\u{32CF}", "\u{32CF}", "\u{32CF}", "\u{004C}\u{0054}\u{0044}", "\u{004C}\u{0054}\u{0044}"),
    ("\u{32D0}", "\u{32D0}", "\u{32D0}", "\u{30A2}", "\u{30A2}"),
    ("\u{32D1}", "\u{32D1}", "\u{32D1}", "\u{30A4}", "\u{30A4}"),
    ("\u{32D2}", "\u{32D2}", "\u{32D2}", "\u{30A6}", "\u{30A6}"),
    ("\u{32D3}", "\u{32D3}", "\u{32D3}", "\u{30A8}", "\u{30A8}"),
    ("\u{32D4}", "\u{32D4}", "\u{32D4}", "\u{30AA}", "\u{30AA}"),
    ("\u{32D5}", "\u{32D5}", "\u{32D5}", "\u{30AB}", "\u{30AB}"),
    ("\u{32D6}", "\u{32D6}", "\u{32D6}", "\u{30AD}", "\u{30AD}"),
    ("\u{32D7}", "\u{32D7}", "\u{32D7}", "\u{30AF}", "\u{30AF}"),
    ("\u{32D8}", "\u{32D8}", "\u{32D8}", "\u{30B1}", "\u{30B1}"),
    ("\u{32D9}", "\u{32D9}", "\u{32D9}", "\u{30B3}", "\u{30B3}"),
    ("\u{32DA}", "\u{32DA}", "\u{32DA}", "\u{30B5}", "\u{30B5}"),
    ("\u{32DB}", "\u{32DB}", "\u{32DB}", "\u{30B7}", "\u{30B7}"),
    ("\u{32DC}", "\u{32DC}", "\u{32DC}", "\u{30B9}", "\u{30B9}"),
    ("\u{32DD}", "\u{32DD}", "\u{32DD}", "\u{30BB}", "\u{30BB}"),
    ("\u{32DE}", "\u{32DE}", "\u{32DE}", "\u{30BD}", "\u{30BD}"),
    ("\u{32DF}", "\u{32DF}", "\u{32DF}", "\u{30BF}", "\u{30BF}"),
    ("\u{32E0}", "\u{32E0}", "\u{32E0}", "\u{30C1}", "\u{30C1}"),
    ("\u{32E1}", "\u{32E1}", "\u{32E1}", "\u{30C4}", "\u{30C4}"),
    ("\u{32E2}", "\u{32E2}", "\u{32E2}", "\u{30C6}", "\u{30C6}"),
    ("\u{32E3}", "\u{32E3}", "\u{32E3}", "\u{30C8}", "\u{30C8}"),
    ("\u{32E4}", "\u{32E4}", "\u{32E4}", "\u{30CA}", "\u{30CA}"),
    ("\u{32E5}", "\u{32E5}", "\u{32E5}", "\u{30CB}", "\u{30CB}"),
    ("\u{32E6}", "\u{32E6}", "\u{32E6}", "\u{30CC}", "\u{30CC}"),
    ("\u{32E7}", "\u{32E7}", "\u{32E7}", "\u{30CD}", "\u{30CD}"),
    ("\u{32E8}", "\u{32E8}", "\u{32E8}", "\u{30CE}", "\u{30CE}"),
    ("\u{32E9}", "\u{32E9}", "\u{32E9}", "\u{30CF}", "\u{30CF}"),
    ("\u{32EA}", "\u{32EA}", "\u{32EA}", "\u{30D2}", "\u{30D2}"),
    ("\u{32EB}", "\u{32EB}", "\u{32EB}", "\u{30D5}", "\u{30D5}"),
    ("\u{32EC}", "\u{32EC}", "\u{32EC}", "\u{30D8}", "\u{30D8}"),
    ("\u{32ED}", "\u{32ED}", "\u{32ED}", "\u{30DB}", "\u{30DB}"),
    ("\u{32EE}", "\u{32EE}", "\u{32EE}", "\u{30DE}", "\u{30DE}"),
    ("\u{32EF}", "\u{32EF}", "\u{32EF}", "\u{30DF}", "\u{30DF}"),
    ("\u{32F0}", "\u{32F0}", "\u{32F0}", "\u{30E0}", "\u{30E0}"),
    ("\u{32F1}", "\u{32F1}", "\u{32F1}", "\u{30E1}", "\u{30E1}"),
    ("\u{32F2}", "\u{32F2}", "\u{32F2}", "\u{30E2}", "\u{30E2}"),
    ("\u{32F3}", "\u{32F3}", "\u{32F3}", "\u{30E4}", "\u{30E4}"),
    ("\u{32F4}", "\u{32F4}", "\u{32F4}", "\u{30E6}", "\u{30E6}"),
    ("\u{32F5}", "\u{32F5}", "\u{32F5}", "\u{30E8}", "\u{30E8}"),
    ("\u{32F6}", "\u{32F6}", "\u{32F6}", "\u{30E9}", "\u{30E9}"),
    ("\u{32F7}", "\u{32F7}", "\u{32F7}", "\u{30EA}", "\u{30EA}"),
    ("\u{32F8}", "\u{32F8}", "\u{32F8}", "\u{30EB}", "\u{30EB}"),
    ("\u{32F9}", "\u{32F9}", "\u{32F9}", "\u{30EC}", "\u{30EC}"),
    ("\u{32FA}", "\u{32FA}", "\u{32FA}", "\u{30ED}", "\u{30ED}"),
    ("\u{32FB}", "\u{32FB}", "\u{32FB}", "\u{30EF}", "\u{30EF}"),
    ("\u{32FC}", "\u{32FC}", "\u{32FC}", "\u{30F0}", "\u{30F0}"),
    ("\u{32FD}", "\u{32FD}", "\u{32FD}", "\u{30F1}", "\u{30F1}"),
    ("\u{32FE}", "\u{32FE}", "\u{32FE}", "\u{30F2}", "\u{30F2}"),
    ("\u{32FF}", "\u{32FF}", "\u{32FF}", "\u{4EE4}\u{548C}", "\u{4EE4}\u{548C}"),
    ("\u{3300}", "\u{3300}", "\u{3300}", "\u{30A2}\u{30D1}\u{30FC}\u{30C8}", "\u{30A2}\u{30CF}\u{309A}\u{30FC}\u{30C8}"),
    ("\u{3301}", "\u{3301}", "\u{3301}", "\u{30A2}\u{30EB}\u{30D5}\u{30A1}", "\u{30A2}\u{30EB}\u{30D5}\u{30A1}"),
    ("\u{3302}", "\u{3302}", "\u{3302}", "\u{30A2}\u{30F3}\u{30DA}\u{30A2}", "\u{30A2}\u{30F3}\u{30D8}\u{309A}\u{30A2}"),
    ("\u{3303}", "\u{3303}", "\u{3303}", "\u{30A2}\u{30FC}\u{30EB}", "\u{30A2}\u{30FC}\u{30EB}"),
    ("\u{3304}", "\u{3304}", "\u{3304}", "\u{30A4}\u{30CB}\u{30F3}\u{30B0}", "\u{30A4}\u{30CB}\u{30F3}\u{30AF}\u{3099}"),
    ("\u{3305}", "\u{3305}", "\u{3305}", "\u{30A4}\u{30F3}\u{30C1}", "\u{30A4}\u{30F3}\u{30C1}"),
    ("\u{3306}", "\u{3306}", "\u{3306}", "\u{30A6}\u{30A9}\u{30F3}", "\u{30A6}\u{30A9}\u{30F3}"),
    ("\u{3307}", "\u{3307}", "\u{3307}", "\u{30A8}\u{30B9}\u{30AF}\u{30FC}\u{30C9}", "\u{30A8}\u{30B9}\u{30AF}\u{30FC}\u{30C8}\u{3099}"),
    ("\u{3308}", "\u{3308}", "\u{3308}", "\u{30A8}\u{30FC}\u{30AB}\u{30FC}", "\u{30A8}\u{30FC}\u{30AB}\u{30FC}"),
    ("\u{3309}", "\u{3309}", "\u{3309}", "\u{30AA}\u{30F3}\u{30B9}", "\u{30AA}\u{30F3}\u{30B9}"),
    ("\u{330A}", "\u{330A}", "\u{330A}", "\u{30AA}\u{30FC}\u{30E0}", "\u{30AA}\u{30FC}\u{30E0}"),
    ("\u{330B}", "\u{330B}", "\u{330B}", "\u{30AB}\u{30A4}\u{30EA}", "\u{30AB}\u{30A4}\u{30EA}"),
    ("\u{330C}", "\u{330C}", "\u{330C}", "\u{30AB}\u{30E9}\u{30C3}\u{30C8}", "\u{30AB}\u{30E9}\u{30C3}\u{30C8}"),
    ("\u{330D}", "\u{330D}", "\u{330D}", "\u{30AB}\u{30ED}\u{30EA}\u{30FC}", "\u{30AB}\u{30ED}\u{30EA}\u{30FC}"),
    ("\u{330E}", "\u{330E}", "\u{330E}", "\u{30AC}\u{30ED}\u{30F3}", "\u{30AB}\u{3099}\u{30ED}\u{30F3}"),
    ("\u{330F}", "\u{330F}", "\u{330F}", "\u{30AC}\u{30F3}\u{30DE}", "\u{30AB}\u{3099}\u{30F3}\u{30DE}"),
    ("\u{3310}", "\u{3310}", "\u{3310}", "\u{30AE}\u{30AC}", "\u{30AD}\u{3099}\u{30AB}\u{3099}"),
    ("\u{3311}", "\u{3311}", "\u{3311}", "\u{30AE}\u{30CB}\u{30FC}", "\u{30AD}\u{3099}\u{30CB}\u{30FC}"),
    ("\u{3312}", "\u{3312}", "\u{3312}", "\u{30AD}\u{30E5}\u{30EA}\u{30FC}", "\u{30AD}\u{30E5}\u{30EA}\u{30FC}"),
    ("\u{3313}", "\u{3313}", "\u{3313}", "\u{30AE}\u{30EB}\u{30C0}\u{30FC}", "\u{30AD}\u{3099}\u{30EB}\u{30BF}\u{3099}\u{30FC}"),
    ("\u{3314}", "\u{3314}", "\u{3314}", "\u{30AD}\u{30ED}", "\u{30AD}\u{30ED}"),
    ("\u{3315}", "\u{3315}", "\u{3315}", "\u{30AD}\u{30ED}\u{30B0}\u{30E9}\u{30E0}", "\u{30AD}\u{30ED}\u{30AF}\u{3099}\u{30E9}\u{30E0}"),
    ("\u{3316}", "\u{3316}", "\u{3316}", "\u{30AD}\u{30ED}\u{30E1}\u{30FC}\u{30C8}\u{30EB}", "\u{30AD}\u{30ED}\u{30E1}\u{30FC}\u{30C8}\u{30EB}"),
    ("\u{3317}", "\u{3317}", "\u{3317}", "\u{30AD}\u{30ED}\u{30EF}\u{30C3}\u{30C8}", "\u{30AD}\u{30ED}\u{30EF}\u{30C3}\u{30C8}"),
    ("\u{3318}", "\u{3318}", "\u{3318}", "\u{30B0}\u{30E9}\u{30E0}", "\u{30AF}\u{3099}\u{30E9}\u{30E0}"),
    ("\u{3319}", "\u{3319}", "\u{3319}", "\u{30B0}\u{30E9}\u{30E0}\u{30C8}\u{30F3}", "\u{30AF}\u{3099}\u{30E9}\u{30E0}\u{30C8}\u{30F3}"),
    ("\u{331A}", "\u{331A}", "\u{331A}", "\u{30AF}\u{30EB}\u{30BC}\u{30A4}\u{30ED}", "\u{30AF}\u{30EB}\u{30BB}\u{3099}\u{30A4}\u{30ED}"),
    ("\u{331B}", "\u{331B}", "\u{331B}", "\u{30AF}\u{30ED}\u{30FC}\u{30CD}", "\u{30AF}\u{30ED}\u{30FC}\u{30CD}"),
    ("\u{331C}", "\u{331C}", "\u{331C}", "\u{30B1}\u{30FC}\u{30B9}", "\u{30B1}\u{30FC}\u{30B9}"),
    ("\u{331D}", "\u{331D}", "\u{331D}", "\u{30B3}\u{30EB}\u{30CA}", "\u{30B3}\u{30EB}\u{30CA}"),
    ("\u{331E}", "\u{331E}", "\u{331E}", "\u{30B3}\u{30FC}\u{30DD}", "\u{30B3}\u{30FC}\u{30DB}\u{309A}"),
    ("\u{331F}", "\u{331F}", "\u{331F}", "\u{30B5}\u{30A4}\u{30AF}\u{30EB}", "\u{30B5}\u{30A4}\u{30AF}\u{30EB}"),
    ("\u{3320}", "\u{3320}", "\u{3320}", "\u{30B5}\u{30F3}\u{30C1}\u{30FC}\u{30E0}", "\u{30B5}\u{30F3}\u{30C1}\u{30FC}\u{30E0}"),
    ("\u{3321}", "\u{3321}", "\u{3321}", "\u{30B7}\u{30EA}\u{30F3}\u{30B0}", "\u{30B7}\u{30EA}\u{30F3}\u{30AF}\u{3099}"),
    ("\u{3322}", "\u{3322}", "\u{3322}", "\u{30BB}\u{30F3}\u{30C1}", "\u{30BB}\u{30F3}\u{30C1}"),
    ("\u{3323}", "\u{3323}", "\u{3323}", "\u{30BB}\u{30F3}\u{30C8}", "\u{30BB}\u{30F3}\u{30C8}"),
    ("\u{3324}", "\u{3324}", "\u{3324}", "\u{30C0}\u{30FC}\u{30B9}", "\u{30BF}\u{3099}\u{30FC}\u{30B9}"),
    ("\u{3325}", "\u{3325}", "\u{3325}", "\u{30C7}\u{30B7}", "\u{30C6}\u{3099}\u{30B7}"),
    ("\u{3326}", "\u{3326}", "\u{3326}", "\u{30C9}\u{30EB}", "\u{30C8}\u{3099}\u{30EB}"),
    ("\u{3327}", "\u{3327}", "\u{3327}", "\u{30C8}\u{30F3}", "\u{30C8}\u{30F3}"),
    ("\u{3328}", "\u{3328}", "\u{3328}", "\u{30CA}\u{30CE}", "\u{30CA}\u{30CE}"),
    ("\u{3329}", "\u{3329}", "\u{3329}", "\u{30CE}\u{30C3}\u{30C8}", "\u{30CE}\u{30C3}\u{30C8}"),
    ("\u{332A}", "\u{332A}", "\u{332A}", "\u{30CF}\u{30A4}\u{30C4}", "\u{30CF}\u{30A4}\u{30C4}"),
    ("\u{332B}", "\u{332B}", "\u{332B}", "\u{30D1}\u{30FC}\u{30BB}\u{30F3}\u{30C8}", "\u{30CF}\u{309A}\u{30FC}\u{30BB}\u{30F3}\u{30C8}"),
    ("\u{332C}", "\u{332C}", "\u{332C}", "\u{30D1}\u{30FC}\u{30C4}", "\u{30CF}\u{309A}\u{30FC}\u{30C4}"),
    ("\u{332D}", "\u{332D}", "\u{332D}", "\u{30D0}\u{30FC}\u{30EC}\u{30EB}", "\u{30CF}\u{3099}\u{30FC}\u{30EC}\u{30EB}"),
    ("\u{332E}", "\u{332E}", "\u{332E}", "\u{30D4}\u{30A2}\u{30B9}\u{30C8}\u{30EB}", "\u{30D2}\u{309A}\u{30A2}\u{30B9}\u{30C8}\u{30EB}"),
    ("\u{332F}", "\u{332F}", "\u{332F}", "\u{30D4}\u{30AF}\u{30EB}", "\u{30D2}\u{309A}\u{30AF}\u{30EB}"),
    ("\u{3330}", "\u{3330}", "\u{3330}", "\u{30D4}\u{30B3}", "\u{30D2}\u{309A}\u{30B3}"),
    ("\u{3331}", "\u{3331}", "\u{3331}", "\u{30D3}\u{30EB}", "\u{30D2}\u{3099}\u{30EB}"),
    ("\u{3332}", "\u{3332}", "\u{3332}", "\u{30D5}\u{30A1}\u{30E9}\u{30C3}\u{30C9}", "\u{30D5}\u{30A1}\u{30E9}\u{30C3}\u{30C8}\u{3099}"),
    ("\u{3333}", "\u{3333}", "\u{3333}", "\u{30D5}\u{30A3}\u{30FC}\u{30C8}", "\u{30D5}\u{30A3}\u{30FC}\u{30C8}"),
    ("\u{3334}", "\u{3334}", "\u{3334}", "\u{30D6}\u{30C3}\u{30B7}\u{30A7}\u{30EB}", "\u{30D5}\u{3099}\u{30C3}\u{30B7}\u{30A7}\u{30EB}"),
    ("\u{3335}", "\u{3335}", "\u{3335}", "\u{30D5}\u{30E9}\u{30F3}", "\u{30D5}\u{30E9}\u{30F3}"),
    ("\u{3336}", "\u{3336}", "\u{3336}", "\u{30D8}\u{30AF}\u{30BF}\u{30FC}\u{30EB}", "\u{30D8}\u{30AF}\u{30BF}\u{30FC}\u{30EB}"),
    ("\u{3337}", "\u{3337}", "\u{3337}", "\u{30DA}\u{30BD}", "\u{30D8}\u{309A}\u{30BD}"),
    ("\u{3338}", "\u{3338}", "\u{3338}", "\u{30DA}\u{30CB}\u{30D2}", "\u{30D8}\u{309A}\u{30CB}\u{30D2}"),
    ("\u{3339}", "\u{3339}", "\u{3339}", "\u{30D8}\u{30EB}\u{30C4}", "\u{30D8}\u{30EB}\u{30C4}"),
    ("\u{333A}", "\u{333A}", "\u{333A}", "\u{30DA}\u{30F3}\u{30B9}", "\u{30D8}\u{309A}\u{30F3}\u{30B9}"),
    ("\u{333B}", "\u{333B}", "\u{333B}", "\u{30DA}\u{30FC}\u{30B8}", "\u{30D8}\u{309A}\u{30FC}\u{30B7}\u{3099}"),
    ("\u{333C}", "\u{333C}", "\u{333C}", "\u{30D9}\u{30FC}\u{30BF}", "\u{30D8}\u{3099}\u{30FC}\u{30BF}"),
    ("\u{333D}", "\u{333D}", "\u{333D}", "\u{30DD}\u{30A4}\u{30F3}\u{30C8}", "\u{30DB}\u{309A}\u{30A4}\u{30F3}\u{30C8}"),
    ("\u{333E}", "\u{333E}", "\u{333E}", "\u{30DC}\u{30EB}\u{30C8}", "\u{30DB}\u{3099}\u{30EB}\u{30C8}"),
    ("\u{333F}", "\u{333F}", "\u{333F}", "\u{30DB}\u{30F3}", "\u{30DB}\u{30F3}"),
    ("\u{3340}", "\u{3340}", "\u{3340}", "\u{30DD}\u{30F3}\u{30C9}", "\u{30DB}\u{309A}\u{30F3}\u{30C8}\u{3099}"),
    ("\u{3341}", "\u{3341}", "\u{3341}", "\u{30DB}\u{30FC}\u{30EB}", "\u{30DB}\u{30FC}\u{30EB}"),
    ("\u{3342}", "\u{3342}", "\u{3342}", "\u{30DB}\u{30FC}\u{30F3}", "\u{30DB}\u{30FC}\u{30F3}"),
    ("\u{3343}", "\u{3343}", "\u{3343}", "\u{30DE}\u{30A4}\u{30AF}\u{30ED}", "\u{30DE}\u{30A4}\u{30AF}\u{30ED}"),
    ("\u{3344}", "\u{3344}", "\u{3344}", "\u{30DE}\u{30A4}\u{30EB}", "\u{30DE}\u{30A4}\u{30EB}"),
    ("\u{3345}", "\u{3345}", "\u{3345}", "\u{30DE}\u{30C3}\u{30CF}", "\u{30DE}\u{30C3}\u{30CF}"),
    ("\u{3346}", "\u{3346}", "\u{3346}", "\u{30DE}\u{30EB}\u{30AF}", "\u{30DE}\u{30EB}\u{30AF}"),
    ("\u{3347}", "\u{3347}", "\u{3347}", "\u{30DE}\u{30F3}\u{30B7}\u{30E7}\u{30F3}", "\u{30DE}\u{30F3}\u{30B7}\u{30E7}\u{30F3}"),
    ("\u{3348}", "\u{3348}", "\u{3348}", "\u{30DF}\u{30AF}\u{30ED}\u{30F3}", "\u{30DF}\u{30AF}\u{30ED}\u{30F3}"),
    ("\u{3349}", "\u{3349}", "\u{3349}", "\u{30DF}\u{30EA}", "\u{30DF}\u{30EA}"),
    ("\u{334A}", "\u{334A}", "\u{334A}", "\u{30DF}\u{30EA}\u{30D0}\u{30FC}\u{30EB}", "\u{30DF}\u{30EA}\u{30CF}\u{3099}\u{30FC}\u{30EB}"),
    ("\u{334B}", "\u{334B}", "\u{334B}", "\u{30E1}\u{30AC}", "\u{30E1}\u{30AB}\u{3099}"),
    ("\u{334C}", "\u{334C}", "\u{334C}", "\u{30E1}\u{30AC}\u{30C8}\u{30F3}", "\u{30E1}\u{30AB}\u{3099}\u{30C8}\u{30F3}"),
    ("\u{334D}", "\u{334D}", "\u{334D}", "\u{30E1}\u{30FC}\u{30C8}\u{30EB}", "\u{30E1}\u{30FC}\u{30C8}\u{30EB}"),
    ("\u{334E}", "\u{334E}", "\u{334E}", "\u{30E4}\u{30FC}\u{30C9}", "\u{30E4}\u{30FC}\u{30C8}\u{3099}"),
    ("\u{334F}", "\u{334F}", "\u{334F}", "\u{30E4}\u{30FC}\u{30EB}", "\u{30E4}\u{30FC}\u{30EB}"),
    ("\u{3350}", "\u{3350}", "\u{3350}", "\u{30E6}\u{30A2}\u{30F3}", "\u{30E6}\u{30A2}\u{30F3}"),
    ("\u{3351}", "\u{3351}", "\u{3351}", "\u{30EA}\u{30C3}\u{30C8}\u{30EB}", "\u{30EA}\u{30C3}\u{30C8}\u{30EB}"),
    ("\u{3352}", "\u{3352}", "\u{3352}", "\u{30EA}\u{30E9}", "\u{30EA}\u{30E9}"),
    ("\u{3353}", "\u{3353}", "\u{3353}", "\u{30EB}\u{30D4}\u{30FC}", "\u{30EB}\u{30D2}\u{309A}\u{30FC}"),
    ("\u{3354}", "\u{3354}", "\u{3354}", "\u{30EB}\u{30FC}\u{30D6}\u{30EB}", "\u{30EB}\u{30FC}\u{30D5}\u{3099}\u{30EB}"),
    ("\u{3355}", "\u{3355}", "\u{3355}", "\u{30EC}\u{30E0}", "\u{30EC}\u{30E0}"),
    ("\u{3356}", "\u{3356}", "\u{3356}", "\u{30EC}\u{30F3}\u{30C8}\u{30B2}\u{30F3}", "\u{30EC}\u{30F3}\u{30C8}\u{30B1}\u{3099}\u{30F3}"),
    ("\u{3357}", "\u{3357}", "\u{3357}", "\u{30EF}\u{30C3}\u{30C8}", "\u{30EF}\u{30C3}\u{30C8}"),
    ("\u{3358}", "\u{3358}", "\u{3358}", "\u{0030}\u{70B9}", "\u{0030}\u{70B9}"),
    ("\u{3359}", "\u{3359}", "\u{3359}", "\u{0031}\u{70B9}", "\u{0031}\u{70B9}"),
    ("\u{335A}", "\u{335A}", "\u{335A}", "\u{0032}\u{70B9}", "\u{0032}\u{70B9}"),
    ("\u{335B}", "\u{335B}", "\u{335B}", "\u{0033}\u{70B9}", "\u{0033}\u{70B9}"),
    ("\u{335C}", "\u{335C}", "\u{335C}", "\u{0034}\u{70B9}", "\u{0034}\u{70B9}"),
    ("\u{335D}", "\u{335D}", "\u{335D}", "\u{0035}\u{70B9}", "\u{0035}\u{70B9}"),
    ("\u{335E}", "\u{335E}", "\u{335E}", "\u{0036}\u{70B9}", "\u{0036}\u{70B9}"),
    ("\u{335F}", "\u{335F}", "\u{335F}", "\u{0037}\u{70B9}", "\u{0037}\u{70B9}"),
    ("\u{3360}", "\u{3360}", "\u{3360}", "\u{0038}\u{70B9}", "\u{0038}\u{70B9}"),
    ("\u{3361}", "\u{3361}", "\u{3361}", "\u{0039}\u{70B9}", "\u{0039}\u{70B9}"),
    ("\u{3362}", "\u{3362}", "\u{3362}", "\u{0031}\u{0030}\u{70B9}", "\u{0031}\u{0030}\u{70B9}"),
    ("\u{3363}", "\u{3363}", "\u{3363}", "\u{0031}\u{0031}\u{70B9}", "\u{0031}\u{0031}\u{70B9}"),
    ("\u{3364}", "\u{3364}", "\u{3364}", "\u{0031}\u{0032}\u{70B9}", "\u{0031}\u{0032}\u{70B9}"),
    ("\u{3365}", "\u{3365}", "\u{3365}", "\u{0031}\u{0033}\u{70B9}", "\u{0031}\u{0033}\u{70B9}"),
    ("\u{3366}", "\u{3366}", "\u{3366}", "\u{0031}\u{0034}\u{70B9}", "\u{0031}\u{0034}\u{70B9}"),
    ("\u{3367}", "\u{3367}", "\u{3367}", "\u{0031}\u{0035}\u{70B9}", "\u{0031}\u{0035}\u{70B9}"),
    ("\u{3368}", "\u{3368}", "\u{3368}", "\u{0031}\u{0036}\u{70B9}", "\u{0031}\u{0036}\u{70B9}"),
    ("\u{3369}", "\u{3369}", "\u{3369}", "\u{0031}\u{0037}\u{70B9}", "\u{0031}\u{0037}\u{70B9}"),
    ("\u{336A}", "\u{336A}", "\u{336A}", "\u{0031}\u{0038}\u{70B9}", "\u{0031}\u{0038}\u{70B9}"),
    ("\u{336B}", "\u{336B}", "\u{336B}", "\u{0031}\u{0039}\u{70B9}", "\u{0031}\u{0039}\u{70B9}"),
    ("\u{336C}", "\u{336C}", "\u{336C}", "\u{0032}\u{0030}\u{70B9}", "\u{0032}\u{0030}\u{70B9}"),
    ("\u{336D}", "\u{336D}", "\u{336D}", "\u{0032}\u{0031}\u{70B9}", "\u{0032}\u{0031}\u{70B9}"),
    ("\u{336E}", "\u{336E}", "\u{336E}", "\u{0032}\u{0032}\u{70B9}", "\u{0032}\u{0032}\u{70B9}"),
    ("\u{336F}", "\u{336F}", "\u{336F}", "\u{0032}\u{0033}\u{70B9}", "\u{0032}\u{0033}\u{70B9}"),
    ("\u{3370}", "\u{3370}", "\u{3370}", "\u{0032}\u{0034}\u{70B9}", "\u{0032}\u{0034}\u{70B9}"),
    ("\u{3371}", "\u{3371}", "\u{3371}", "\u{0068}\u{0050}\u{0061}", "\u{0068}\u{0050}\u{0061}"),
    ("\u{3372}", "\u{3372}", "\u{3372}", "\u{0064}\u{0061}", "\u{0064}\u{0061}"),
    ("\u{3373}", "\u{3373}", "\u{3373}", "\u{0041}\u{0055}", "\u{0041}\u{0055}"),
    ("\u{3374}", "\u{3374}", "\u{3374}", "\u{0062}\u{0061}\u{0072}", "\u{0062}\u{0061}\u{0072}"),
    ("\u{3375}", "\u{3375}", "\u{3375}", "\u{006F}\u{0056}", "\u{006F}\u{0056}"),
    ("\u{3376}", "\u{3376}", "\u{3376}", "\u{0070}\u{0063}", "\u{0070}\u{0063}"),
    ("\u{3377}", "\u{3377}", "\u{3377}", "\u{0064}\u{006D}", "\u{0064}\u{006D}"),
    ("\u{3378}", "\u{3378}", "\u{3378}", "\u{0064}\u{006D}\u{0032}", "\u{0064}\u{006D}\u{0032}"),
    ("\u{3379}", "\u{3379}", "\u{3379}", "\u{0064}\u{006D}\u{0033}", "\u{0064}\u{006D}\u{0033}"),
    ("\u{337A}", "\u{337A}", "\u{337A}", "\u{0049}\u{0055}", "\u{0049}\u{0055}"),
    ("\u{337B}", "\u{337B}", "\u{337B}", "\u{5E73}\u{6210}", "\u{5E73}\u{6210}"),
    ("\u{337C}", "\u{337C}", "\u{337C}", "\u{662D}\u{548C}", "\u{662D}\u{548C}"),
    ("\u{337D}", "\u{337D}", "\u{337D}", "\u{5927}\u{6B63}", "\u{5927}\u{6B63}"),
    ("\u{337E}", "\u{337E}", "\u{337E}", "\u{660E}\u{6CBB}", "\u{660E}\u{6CBB}"),
    ("\u{337F}", "\u{337F}", "\u{337F}", "\u{682A}\u{5F0F}\u{4F1A}\u{793E}", "\u{682A}\u{5F0F}\u{4F1A}\u{793E}"),
    ("\u{3380}", "\u{3380}", "\u{3380}", "\u{0070}\u{0041}", "\u{0070}\u{0041}"),
    ("\u{3381}", "\u{3381}", "\u{3381}", "\u{006E}\u{0041}", "\u{006E}\u{0041}"),
    ("\u{3382}", "\u{3382}", "\u{3382}", "\u{03BC}\u{0041}", "\u{03BC}\u{0041}"),
    ("\u{3383}", "\u{3383}", "\u{3383}", "\u{006D}\u{0041}", "\u{006D}\u{0041}"),
    ("\u{3384}", "\u{3384}", "\u{3384}", "\u{006B}\u{0041}", "\u{006B}\u{0041}"),
    ("\u{3385}", "\u{3385}", "\u{3385}", "\u{004B}\u{0042}", "\u{004B}\u{0042}"),
    ("\u{3386}", "\u{3386}", "\u{3386}", "\u{004D}\u{0042}", "\u{004D}\u{0042}"),
    ("\u{3387}", "\u{3387}", "\u{3387}", "\u{0047}\u{0042}", "\u{0047}\u{0042}"),
    ("\u{3388}", "\u{3388}", "\u{3388}", "\u{0063}\u{0061}\u{006C}", "\u{0063}\u{0061}\u{006C}"),
    ("\u{3389}", "\u{3389}", "\u{3389}", "\u{006B}\u{0063}\u{0061}\u{006C}", "\u{006B}\u{0063}\u{0061}\u{006C}"),
    ("\u{338A}", "\u{338A}", "\u{338A}", "\u{0070}\u{0046}", "\u{0070}\u{0046}"),
    ("\u{338B}", "\u{338B}", "\u{338B}", "\u{006E}\u{0046}", "\u{006E}\u{0046}"),
    ("\u{338C}", "\u{338C}", "\u{338C}", "\u{03BC}\u{0046}", "\u{03BC}\u{0046}"),
    ("\u{338D}", "\u{338D}", "\u{338D}", "\u{03BC}\u{0067}", "\u{03BC}\u{0067}"),
    ("\u{338E}", "\u{338E}", "\u{338E}", "\u{006D}\u{0067}", "\u{006D}\u{0067}"),
    ("\u{338F}", "\u{338F}", "\u{338F}", "\u{006B}\u{0067}", "\u{006B}\u{0067}"),
    ("\u{3390}", "\u{3390}", "\u{3390}", "\u{0048}\u{007A}", "\u{0048}\u{007A}"),
    ("\u{3391}", "\u{3391}", "\u{3391}", "\u{006B}\u{0048}\u{007A}", "\u{006B}\u{0048}\u{007A}"),
    ("\u{3392}", "\u{3392}", "\u{3392}", "\u{004D}\u{0048}\u{007A}", "\u{004D}\u{0048}\u{007A}"),
    ("\u{3393}", "\u{3393}", "\u{3393}", "\u{0047}\u{0048}\u{007A}", "\u{0047}\u{0048}\u{007A}"),
    ("\u{3394}", "\u{3394}", "\u{3394}", "\u{0054}\u{0048}\u{007A}", "\u{0054}\u{0048}\u{007A}"),
    ("\u{3395}", "\u{3395}", "\u{3395}", "\u{03BC}\u{006C}", "\u{03BC}\u{006C}"),
    ("\u{3396}", "\u{3396}", "\u{3396}", "\u{006D}\u{006C}", "\u{006D}\u{006C}"),
    ("\u{3397}", "\u{3397}", "\u{3397}", "\u{0064}\u{006C}", "\u{0064}\u{006C}"),
    ("\u{3398}", "\u{3398}", "\u{3398}", "\u{006B}\u{006C}", "\u{006B}\u{006C}"),
    ("\u{3399}", "\u{3399}", "\u{3399}", "\u{0066}\u{006D}", "\u{0066}\u{006D}"),
    ("\u{339A}", "\u{339A}", "\u{339A}", "\u{006E}\u{006D}", "\u{006E}\u{006D}"),
    ("\u{339B}", "\u{339B}", "\u{339B}", "\u{03BC}\u{006D}", "\u{03BC}\u{006D}"),
    ("\u{339C}", "\u{339C}", "\u{339C}", "\u{006D}\u{006D}", "\u{006D}\u{006D}"),
    ("\u{339D}", "\u{339D}", "\u{339D}", "\u{0063}\u{006D}", "\u{0063}\u{006D}"),
    ("\u{339E}", "\u{339E}", "\u{339E}", "\u{006B}\u{006D}", "\u{006B}\u{006D}"),
    ("\u{339F}", "\u{339F}", "\u{339F}", "\u{006D}\u{006D}\u{0032}", "\u{006D}\u{006D}\u{0032}"),
    ("\u{33A0}", "\u{33A0}", "\u{33A0}", "\u{0063}\u{006D}\u{0032}", "\u{0063}\u{006D}\u{0032}"),
    ("\u{33A1}", "\u{33A1}", "\u{33A1}", "\u{006D}\u{0032}", "\u{006D}\u{0032}"),
    ("\u{33A2}", "\u{33A2}", "\u{33A2}", "\u{006B}\u{006D}\u{0032}", "\u{006B}\u{006D}\u{0032}"),
    ("\u{33A3}", "\u{33A3}", "\u{33A3}", "\u{006D}\u{006D}\u{0033}", "\u{006D}\u{006D}\u{0033}"),
    ("\u{33A4}", "\u{33A4}", "\u{33A4}", "\u{0063}\u{006D}\u{0033}", "\u{0063}\u{006D}\u{0033}"),
    ("\u{33A5}", "\u{33A5}", "\u{33A5}", "\u{006D}\u{0033}", "\u{006D}\u{0033}"),
    ("\u{33A6}", "\u{33A6}", "\u{33A6}", "\u{006B}\u{006D}\u{0033}", "\u{006B}\u{006D}\u{0033}"),
    ("\u{33A7}", "\u{33A7}", "\u{33A7}", "\u{006D}\u{2215}\u{0073}", "\u{006D}\u{2215}\u{0073}"),
    ("\u{33A8}", "\u{33A8}", "\u{33A8}", "\u{006D}\u{2215}\u{0073}\u{0032}", "\u{006D}\u{2215}\u{0073}\u{0032}"),
    ("\u{33A9}", "\u{33A9}", "\u{33A9}", "\u{0050}\u{0061}", "\u{0050}\u{0061}"),
    ("\u{33AA}", "\u{33AA}", "\u{33AA}", "\u{006B}\u{0050}\u{0061}", "\u{006B}\u{0050}\u{0061}"),
    ("\u{33AB}", "\u{33AB}", "\u{33AB}", "\u{004D}\u{0050}\u{0061}", "\u{004D}\u{0050}\u{0061}"),
    ("\u{33AC}", "\u{33AC}", "\u{33AC}", "\u{0047}\u{0050}\u{0061}", "\u{0047}\u{0050}\u{0061}"),
    ("\u{33AD}", "\u{33AD}", "\u{33AD}", "\u{0072}\u{0061}\u{0064}", "\u{0072}\u{0061}\u{0064}"),
    ("\u{33AE}", "\u{33AE}", "\u{33AE}", "\u{0072}\u{0061}\u{0064}\u{2215}\u{0073}", "\u{0072}\u{0061}\u{0064}\u{2215}\u{0073}"),
    ("\u{33AF}", "\u{33AF}", "\u{33AF}", "\u{0072}\u{0061}\u{0064}\u{2215}\u{0073}\u{0032}", "\u{0072}\u{0061}\u{0064}\u{2215}\u{0073}\u{0032}"),
    ("\u{33B0}", "\u{33B0}", "\u{33B0}", "\u{0070}\u{0073}", "\u{0070}\u{0073}"),
    ("\u{33B1}", "\u{33B1}", "\u{33B1}", "\u{006E}\u{0073}", "\u{006E}\u{0073}"),
    ("\u{33B2}", "\u{33B2}", "\u{33B2}", "\u{03BC}\u{0073}", "\u{03BC}\u{0073}"),
    ("\u{33B3}", "\u{33B3}", "\u{33B3}", "\u{006D}\u{0073}", "\u{006D}\u{0073}"),
    ("\u{33B4}", "\u{33B4}", "\u{33B4}", "\u{0070}\u{0056}", "\u{0070}\u{0056}"),
    ("\u{33B5}", "\u{33B5}", "\u{33B5}", "\u{006E}\u{0056}", "\u{006E}\u{0056}"),
    ("\u{33B6}", "\u{33B6}", "\u{33B6}", "\u{03BC}\u{0056}", "\u{03BC}\u{0056}"),
    ("\u{33B7}", "\u{33B7}", "\u{33B7}", "\u{006D}\u{0056}", "\u{006D}\u{0056}"),
    ("\u{33B8}", "\u{33B8}", "\u{33B8}", "\u{006B}\u{0056}", "\u{006B}\u{0056}"),
    ("\u{33B9}", "\u{33B9}", "\u{33B9}", "\u{004D}\u{0056}", "\u{004D}\u{0056}"),
    ("\u{33BA}", "\u{33BA}", "\u{33BA}", "\u{0070}\u{0057}", "\u{0070}\u{0057}"),
    ("\u{33BB}", "\u{33BB}", "\u{33BB}", "\u{006E}\u{0057}", "\u{006E}\u{0057}"),
    ("\u{33BC}", "\u{33BC}", "\u{33BC}", "\u{03BC}\u{0057}", "\u{03BC}\u{0057}"),
    ("\u{33BD}", "\u{33BD}", "\u{33BD}", "\u{006D}\u{0057}", "\u{006D}\u{0057}"),
    ("\u{33BE}", "\u{33BE}", "\u{33BE}", "\u{006B}\u{0057}", "\u{006B}\u{0057}"),
    ("\u{33BF}", "\u{33BF}", "\u{33BF}", "\u{004D}\u{0057}", "\u{004D}\u{0057}"),
    ("\u{33C0}", "\u{33C0}", "\u{33C0}", "\u{006B}\u{03A9}", "\u{006B}\u{03A9}"),
    ("\u{33C1}", "\u{33C1}", "\u{33C1}", "\u{004D}\u{03A9}", "\u{004D}\u{03A9}"),
    ("\u{33C2}", "\u{33C2}", "\u{33C2}", "\u{0061}\u{002E}\u{006D}\u{002E}", "\u{0061}\u{002E}\u{006D}\u{002E}"),
    ("\u{33C3}", "\u{33C3}", "\u{33C3}", "\u{0042}\u{0071}", "\u{0042}\u{0071}"),
    ("\u{33C4}", "\u{33C4}", "\u{33C4}", "\u{0063}\u{0063}", "\u{0063}\u{0063}"),
    ("\u{33C5}", "\u{33C5}", "\u{33C5}", "\u{0063}\u{0064}", "\u{0063}\u{0064}"),
    ("\u{33C6}", "\u{33C6}", "\u{33C6}", "\u{0043}\u{2215}\u{006B}\u{0067}", "\u{0043}\u{2215}\u{006B}\u{0067}"),
    ("\u{33C7}", "\u{33C7}", "\u{33C7}", "\u{0043}\u{006F}\u{002E}", "\u{0043}\u{006F}\u{002E}"),
    ("\u{33C8}", "\u{33C8}", "\u{33C8}", "\u{0064}\u{0042}", "\u{0064}\u{0042}"),
    ("\u{33C9}", "\u{33C9}", "\u{33C9}", "\u{0047}\u{0079}", "\u{0047}\u{0079}"),
    ("\u{33CA}", "\u{33CA}", "\u{33CA}", "\u{0068}\u{0061}", "\u{0068}\u{0061}"),
    ("\u{33CB}", "\u{33CB}", "\u{33CB}", "\u{0048}\u{0050}", "\u{0048}\u{0050}"),
    ("\u{33CC}", "\u{33CC}", "\u{33CC}", "\u{0069}\u{006E}", "\u{0069}\u{006E}"),
    ("\u{33CD}", "\u{33CD}", "\u{33CD}", "\u{004B}\u{004B}", "\u{004B}\u{004B}"),
    ("\u{33CE}", "\u{33CE}", "\u{33CE}", "\u{004B}\u{004D}", "\u{004B}\u{004D}"),
    ("\u{33CF}", "\u{33CF}", "\u{33CF}", "\u{006B}\u{0074}", "\u{006B}\u{0074}"),
    ("\u{33D0}", "\u{33D0}", "\u{33D0}", "\u{006C}\u{006D}", "\u{006C}\u{006D}"),
    ("\u{33D1}", "\u{33D1}", "\u{33D1}", "\u{006C}\u{006E}", "\u{006C}\u{006E}"),
    ("\u{33D2}", "\u{33D2}", "\u{33D2}", "\u{006C}\u{006F}\u{0067}", "\u{006C}\u{006F}\u{0067}"),
    ("\u{33D3}", "\u{33D3}", "\u{33D3}", "\u{006C}\u{0078}", "\u{006C}\u{0078}"),
    ("\u{33D4}", "\u{33D4}", "\u{33D4}", "\u{006D}\u{0062}", "\u{006D}\u{0062}"),
    ("\u{33D5}", "\u{33D5}", "\u{33D5}", "\u{006D}\u{0069}\u{006C}", "\u{006D}\u{0069}\u{006C}"),
    ("\u{33D6}", "\u{33D6}", "\u{33D6}", "\u{006D}\u{006F}\u{006C}", "\u{006D}\u{006F}\u{006C}"),
    ("\u{33D7}", "\u{33D7}", "\u{33D7}", "\u{0050}\u{0048}", "\u{0050}\u{0048}"),
    ("\u{33D8}", "\u{33D8}", "\u{33D8}", "\u{0070}\u{002E}\u{006D}\u{002E}", "\u{0070}\u{002E}\u{006D}\u{002E}"),
    ("\u{33D9}", "\u{33D9}", "\u{33D9}", "\u{0050}\u{0050}\u{004D}", "\u{0050}\u{0050}\u{004D}"),
    ("\u{33DA}", "\u{33DA}", "\u{33DA}", "\u{0050}\u{0052}", "\u{0050}\u{0052}"),
    ("\u{33DB}", "\u{33DB}", "\u{33DB}", "\u{0073}\u{0072}", "\u{0073}\u{0072}"),
    ("\u{33DC}", "\u{33DC}", "\u{33DC}", "\u{0053}\u{0076}", "\u{0053}\u{0076}"),
    ("\u{33DD}", "\u{33DD}", "\u{33DD}", "\u{0057}\u{0062}", "\u{0057}\u{0062}"),
    ("\u{33DE}", "\u{33DE}", "\u{33DE}", "\u{0056}\u{2215}\u{006D}", "\u{0056}\u{2215}\u{006D}"),
    ("\u{33DF}", "\u{33DF}", "\u{33DF}", "\u{0041}\u{2215}\u{006D}", "\u{0041}\u{2215}\u{006D}"),
    ("\u{33E0}", "\u{33E0}", "\u{33E0}", "\u{0031}\u{65E5}", "\u{0031}\u{65E5}"),
    ("\u{33E1}", "\u{33E1}", "\u{33E1}", "\u{0032}\u{65E5}", "\u{0032}\u{65E5}"),
    ("\u{33E2}", "\u{33E2}", "\u{33E2}", "\u{0033}\u{65E5}", "\u{0033}\u{65E5}"),
    ("\u{33E3}", "\u{33E3}", "\u{33E3}", "\u{0034}\u{65E5}", "\u{0034}\u{65E5}"),
    ("\u{33E4}", "\u{33E4}", "\u{33E4}", "\u{0035}\u{65E5}", "\u{0035}\u{65E5}"),
    ("\u{33E5}", "\u{33E5}", "\u{33E5}", "\u{0036}\u{65E5}", "\u{0036}\u{65E5}"),
    ("\u{33E6}", "\u{33E6}", "\u{33E6}", "\u{0037}\u{65E5}", "\u{0037}\u{65E5}"),
    ("\u{33E7}", "\u{33E7}", "\u{33E7}", "\u{0038}\u{65E5}", "\u{0038}\u{65E5}"),
    ("\u{33E8}", "\u{33E8}", "\u{33E8}", "\u{0039}\u{65E5}", "\u{0039}\u{65E5}"),
    ("\u{33E9}", "\u{33E9}", "\u{33E9}", "\u{0031}\u{0030}\u{65E5}", "\u{0031}\u{0030}\u{65E5}"),
    ("\u{33EA}", "\u{33EA}", "\u{33EA}", "\u{0031}\u{0031}\u{65E5}", "\u{0031}\u{0031}\u{65E5}"),
    ("\u{33EB}", "\u{33EB}", "\u{33EB}", "\u{0031}\u{0032}\u{65E5}", "\u{0031}\u{0032}\u{65E5}"),
    ("\u{33EC}", "\u{33EC}", "\u{33EC}", "\u{0031}\u{0033}\u{65E5}", "\u{0031}\u{0033}\u{65E5}"),
    ("\u{33ED}", "\u{33ED}", "\u{33ED}", "\u{0031}\u{0034}\u{65E5}", "\u{0031}\u{0034}\u{65E5}"),
    ("\u{33EE}", "\u{33EE}", "\u{33EE}", "\u{0031}\u{0035}\u{65E5}", "\u{0031}\u{0035}\u{65E5}"),
    ("\u{33EF}", "\u{33EF}", "\u{33EF}", "\u{0031}\u{0036}\u{65E5}", "\u{0031}\u{0036}\u{65E5}"),
    ("\u{33F0}", "\u{33F0}", "\u{33F0}", "\u{0031}\u{0037}\u{65E5}", "\u{0031}\u{0037}\u{65E5}"),
    ("\u{33F1}", "\u{33F1}", "\u{33F1}", "\u{0031}\u{0038}\u{65E5}", "\u{0031}\u{0038}\u{65E5}"),
    ("\u{33F2}", "\u{33F2}", "\u{33F2}", "\u{0031}\u{0039}\u{65E5}", "\u{0031}\u{0039}\u{65E5}"),
    ("\u{33F3}", "\u{33F3}", "\u{33F3}", "\u{0032}\u{0030}\u{65E5}", "\u{0032}\u{0030}\u{65E5}"),
    ("\u{33F4}", "\u{33F4}", "\u{33F4}", "\u{0032}\u{0031}\u{65E5}", "\u{0032}\u{0031}\u{65E5}"),
    ("\u{33F5}", "\u{33F5}", "\u{33F5}", "\u{0032}\u{0032}\u{65E5}", "\u{0032}\u{0032}\u{65E5}"),
    ("\u{33F6}", "\u{33F6}", "\u{33F6}", "\u{0032}\u{0033}\u{65E5}", "\u{0032}\u{0033}\u{65E5}"),
    ("\u{33F7}", "\u{33F7}", "\u{33F7}", "\u{0032}\u{0034}\u{65E5}", "\u{0032}\u{0034}\u{65E5}"),
    ("\u{33F8}", "\u{33F8}", "\u{33F8}", "\u{0032}\u{0035}\u{65E5}", "\u{0032}\u{0035}\u{65E5}"),
    ("\u{33F9}", "\u{33F9}", "\u{33F9}", "\u{0032}\u{0036}\u{65E5}", "\u{0032}\u{0036}\u{65E5}"),
    ("\u{33FA}", "\u{33FA}", "\u{33FA}", "\u{0032}\u{0037}\u{65E5}", "\u{0032}\u{0037}\u{65E5}"),
    ("\u{33FB}", "\u{33FB}", "\u{33FB}", "\u{0032}\u{0038}\u{65E5}", "\u{0032}\u{0038}\u{65E5}"),
    ("\u{33FC}", "\u{33FC}", "\u{33FC}", "\u{0032}\u{0039}\u{65E5}", "\u{0032}\u{0039}\u{65E5}"),
    ("\u{33FD}", "\u{33FD}", "\u{33FD}", "\u{0033}\u{0030}\u{65E5}", "\u{0033}\u{0030}\u{65E5}"),
    ("\u{33FE}", "\u{33FE}", "\u{33FE}", "\u{0033}\u{0031}\u{65E5}", "\u{0033}\u{0031}\u{65E5}"),
    ("\u{33FF}", "\u{33FF}", "\u{33FF}", "\u{0067}\u{0061}\u{006C}", "\u{0067}\u{0061}\u{006C}"),
    ("\u{A69C}", "\u{A69C}", "\u{A69C}", "\u{044A}", "\u{044A}"),
    ("\u{A69D}", "\u{A69D}", "\u{A69D}", "\u{044C}", "\u{044C}"),
    ("\u{A770}", "\u{A770}", "\u{A770}", "\u{A76F}", "\u{A76F}"),
    ("\u{A7F8}", "\u{A7F8}", "\u{A7F8}", "\u{0126}", "\u{0126}"),
    ("\u{A7F9}", "\u{A7F9}", "\u{A7F9}", "\u{0153}", "\u{0153}"),
    ("\u{AB5C}", "\u{AB5C}", "\u{AB5C}", "\u{A727}", "\u{A727}"),
    ("\u{AB5D}", "\u{AB5D}", "\u{AB5D}", "\u{AB37}", "\u{AB37}"),
    ("\u{AB5E}", "\u{AB5E}", "\u{AB5E}", "\u{026B}", "\u{026B}"),
    ("\u{AB5F}", "\u{AB5F}", "\u{AB5F}", "\u{AB52}", "\u{AB52}"),
    ("\u{AB69}", "\u{AB69}", "\u{AB69}", "\u{028D}", "\u{028D}"),
    ("\u{AC00}", "\u{AC00}", "\u{1100}\u{1161}", "\u{AC00}", "\u{1100}\u{1161}"),
    ("\u{AC01}", "\u{AC01}", "\u{1100}\u{1161}\u{11A8}", "\u{AC01}", "\u{1100}\u{1161}\u{11A8}"),
    ("\u{AC02}", "\u{AC02}", "\u{1100}\u{1161}\u{11A9}", "\u{AC02}", "\u{1100}\u{1161}\u{11A9}"),
    ("\u{AC03}", "\u{AC03}", "\u{1100}\u{1161}\u{11AA}", "\u{AC03}", "\u{1100}\u{1161}\u{11AA}"),
    ("\u{AC04}", "\u{AC04}", "\u{1100}\u{1161}\u{11AB}", "\u{AC04}", "\u{1100}\u{1161}\u{11AB}"),
    ("\u{AC05}", "\u{AC05}", "\u{1100}\u{1161}\u{11AC}", "\u{AC05}", "\u{1100}\u{1161}\u{11AC}"),
    ("\u{AC06}", "\u{AC06}", "\u{1100}\u{1161}\u{11AD}", "\u{AC06}", "\u{1100}\u{1161}\u{11AD}"),
    ("\u{AC07}", "\u{AC07}", "\u{1100}\u{1161}\u{11AE}", "\u{AC07}", "\u{1100}\u{1161}\u{11AE}"),
    ("\u{AC08}", "\u{AC08}", "\u{1100}\u{1161}\u{11AF}", "\u{AC08}", "\u{1100}\u{1161}\u{11AF}"),
    ("\u{AC09}", "\u{AC09}", "\u{1100}\u{1161}\u{11B0}", "\u{AC09}", "\u{1100}\u{1161}\u{11B0}"),
    ("\u{AC0A}", "\u{AC0A}", "\u{1100}\u{1161}\u{11B1}", "\u{AC0A}", "\u{1100}\u{1161}\u{11B1}"),
    ("\u{AC0B}", "\u{AC0B}", "\u{1100}\u{1161}\u{11B2}", "\u{AC0B}", "\u{1100}\u{1161}\u{11B2}"),
    ("\u{AC0C}", "\u{AC0C}", "\u{1100}\u{1161}\u{11B3}", "\u{AC0C}", "\u{1100}\u{1161}\u{11B3}"),
    ("\u{AC0D}", "\u{AC0D}", "\u{1100}\u{1161}\u{11B4}", "\u{AC0D}", "\u{1100}\u{1161}\u{11B4}"),
    ("\u{AC0E}", "\u{AC0E}", "\u{1100}\u{1161}\u{11B5}", "\u{AC0E}", "\u{1100}\u{1161}\u{11B5}"),
    ("\u{AC0F}", "\u{AC0F}", "\u{1100}\u{1161}\u{11B6}", "\u{AC0F}", "\u{1100}\u{1161}\u{11B6}"),
    ("\u{AC10}", "\u{AC10}", "\u{1100}\u{1161}\u{11B7}", "\u{AC10}", "\u{1100}\u{1161}\u{11B7}"),
    ("\u{AC11}", "\u{AC11}", "\u{1100}\u{1161}\u{11B8}", "\u{AC11}", "\u{1100}\u{1161}\u{11B8}"),
    ("\u{AC12}", "\u{AC12}", "\u{1100}\u{1161}\u{11B9}", "\u{AC12}", "\u{1100}\u{1161}\u{11B9}"),
    ("\u{AC13}", "\u{AC13}", "\u{1100}\u{1161}\u{11BA}", "\u{AC13}", "\u{1100}\u{1161}\u{11BA}"),
    ("\u{AC14}", "\u{AC14}", "\u{1100}\u{1161}\u{11BB}", "\u{AC14}", "\u{1100}\u{1161}\u{11BB}"),
    ("\u{AC15}", "\u{AC15}", "\u{1100}\u{1161}\u{11BC}", "\u{AC15}", "\u{1100}\u{1161}\u{11BC}"),
    ("\u{AC16}", "\u{AC16}", "\u{1100}\u{1161}\u{11BD}", "\u{AC16}", "\u{1100}\u{1161}\u{11BD}"),
    ("\u{AC17}", "\u{AC17}", "\u{1100}\u{1161}\u{11BE}", "\u{AC17}", "\u{1100}\u{1161}\u{11BE}"),
    ("\u{AC18}", "\u{AC18}", "\u{1100}\u{1161}\u{11BF}", "\u{AC18}", "\u{1100}\u{1161}\u{11BF}"),
    ("\u{AC19}", "\u{AC19}", "\u{1100}\u{1161}\u{11C0}", "\u{AC19}", "\u{1100}\u{1161}\u{11C0}"),
    ("\u{AC1A}", "\u{AC1A}", "\u{1100}\u{1161}\u{11C1}", "\u{AC1A}", "\u{1100}\u{1161}\u{11C1}"),
    ("\u{AC1B}", "\u{AC1B}", "\u{1100}\u{1161}\u{11C2}", "\u{AC1B}", "\u{1100}\u{1161}\u{11C2}"),
    ("\u{AC1C}", "\u{AC1C}", "\u{1100}\u{1162}", "\u{AC1C}", "\u{1100}\u{1162}"),
    ("\u{AC1D}", "\u{AC1D}", "\u{1100}\u{1162}\u{11A8}", "\u{AC1D}", "\u{1100}\u{1162}\u{11A8}"),
    ("\u{AC1E}", "\u{AC1E}", "\u{1100}\u{1162}\u{11A9}", "\u{AC1E}", "\u{1100}\u{1162}\u{11A9}"),
    ("\u{AC1F}", "\u{AC1F}", "\u{1100}\u{1162}\u{11AA}", "\u{AC1F}", "\u{1100}\u{1162}\u{11AA}"),
    ("\u{AC20}", "\u{AC20}", "\u{1100}\u{1162}\u{11AB}", "\u{AC20}", "\u{1100}\u{1162}\u{11AB}"),
    ("\u{AC21}", "\u{AC21}", "\u{1100}\u{1162}\u{11AC}", "\u{AC21}", "\u{1100}\u{1162}\u{11AC}"),
    ("\u{AC22}", "\u{AC22}", "\u{1100}\u{1162}\u{11AD}", "\u{AC22}", "\u{1100}\u{1162}\u{11AD}"),
    ("\u{AC23}", "\u{AC23}", "\u{1100}\u{1162}\u{11AE}", "\u{AC23}", "\u{1100}\u{1162}\u{11AE}"),
    ("\u{AC24}", "\u{AC24}", "\u{1100}\u{1162}\u{11AF}", "\u{AC24}", "\u{1100}\u{1162}\u{11AF}"),
    ("\u{AC25}", "\u{AC25}", "\u{1100}\u{1162}\u{11B0}", "\u{AC25}", "\u{1100}\u{1162}\u{11B0}"),
    ("\u{AC26}", "\u{AC26}", "\u{1100}\u{1162}\u{11B1}", "\u{AC26}", "\u{1100}\u{1162}\u{11B1}"),
    ("\u{AC27}", "\u{AC27}", "\u{1100}\u{1162}\u{11B2}", "\u{AC27}", "\u{1100}\u{1162}\u{11B2}"),
    ("\u{AC28}", "\u{AC28}", "\u{1100}\u{1162}\u{11B3}", "\u{AC28}", "\u{1100}\u{1162}\u{11B3}"),
    ("\u{AC29}", "\u{AC29}", "\u{1100}\u{1162}\u{11B4}", "\u{AC29}", "\u{1100}\u{1162}\u{11B4}"),
    ("\u{AC2A}", "\u{AC2A}", "\u{1100}\u{1162}\u{11B5}", "\u{AC2A}", "\u{1100}\u{1162}\u{11B5}"),
    ("\u{AC2B}", "\u{AC2B}", "\u{1100}\u{1162}\u{11B6}", "\u{AC2B}", "\u{1100}\u{1162}\u{11B6}"),
    ("\u{AC2C}", "\u{AC2C}", "\u{1100}\u{1162}\u{11B7}", "\u{AC2C}", "\u{1100}\u{1162}\u{11B7}"),
    ("\u{AC2D}", "\u{AC2D}", "\u{1100}\u{1162}\u{11B8}", "\u{AC2D}", "\u{1100}\u{1162}\u{11B8}"),
    ("\u{AC2E}", "\u{AC2E}", "\u{1100}\u{1162}\u{11B9}", "\u{AC2E}", "\u{1100}\u{1162}\u{11B9}"),
    ("\u{AC2F}", "\u{AC2F}", "\u{1100}\u{1162}\u{11BA}", "\u{AC2F}", "\u{1100}\u{1162}\u{11BA}"),
    ("\u{AC30}", "\u{AC30}", "\u{1100}\u{1162}\u{11BB}", "\u{AC30}", "\u{1100}\u{1162}\u{11BB}"),
    ("\u{AC31}", "\u{AC31}", "\u{1100}\u{1162}\u{11BC}", "\u{AC31}", "\u{1100}\u{1162}\u{11BC}"),
    ("\u{AC32}", "\u{AC32}", "\u{1100}\u{1162}\u{11BD}", "\u{AC32}", "\u{1100}\u{1162}\u{11BD}"),
    ("\u{AC33}", "\u{AC33}", "\u{1100}\u{1162}\u{11BE}", "\u{AC33}", "\u{1100}\u{1162}\u{11BE}"),
    ("\u{AC34}", "\u{AC34}", "\u{1100}\u{1162}\u{11BF}", "\u{AC34}", "\u{1100}\u{1162}\u{11BF}"),
    ("\u{AC35}", "\u{AC35}", "\u{1100}\u{1162}\u{11C0}", "\u{AC35}", "\u{1100}\u{1162}\u{11C0}"),
    ("\u{AC36}", "\u{AC36}", "\u{1100}\u{1162}\u{11C1}", "\u{AC36}", "\u{1100}\u{1162}\u{11C1}"),
    ("\u{AC37}", "\u{AC37}", "\u{1100}\u{1162}\u{11C2}", "\u{AC37}", "\u{1100}\u{1162}\u{11C2}"),
    ("\u{AC38}", "\u{AC38}", "\u{1100}\u{1163}", "\u{AC38}", "\u{1100}\u{1163}"),
    ("\u{AC39}", "\u{AC39}", "\u{1100}\u{1163}\u{11A8}", "\u{AC39}", "\u{1100}\u{1163}\u{11A8}"),
    ("\u{AC3A}", "\u{AC3A}", "\u{1100}\u{1163}\u{11A9}", "\u{AC3A}", "\u{1100}\u{1163}\u{11A9}"),
    ("\u{AC3B}", "\u{AC3B}", "\u{1100}\u{1163}\u{11AA}", "\u{AC3B}", "\u{1100}\u{1163}\u{11AA}"),
    ("\u{AC3C}", "\u{AC3C}", "\u{1100}\u{1163}\u{11AB}", "\u{AC3C}", "\u{1100}\u{1163}\u{11AB}"),
    ("\u{AC3D}", "\u{AC3D}", "\u{1100}\u{1163}\u{11AC}", "\u{AC3D}", "\u{1100}\u{1163}\u{11AC}"),
    ("\u{AC3E}", "\u{AC3E}", "\u{1100}\u{1163}\u{11AD}", "\u{AC3E}", "\u{1100}\u{1163}\u{11AD}"),
    ("\u{AC3F}", "\u{AC3F}", "\u{1100}\u{1163}\u{11AE}", "\u{AC3F}", "\u{1100}\u{1163}\u{11AE}"),
    ("\u{AC40}", "\u{AC40}", "\u{1100}\u{1163}\u{11AF}", "\u{AC40}", "\u{1100}\u{1163}\u{11AF}"),
    ("\u{AC41}", "\u{AC41}", "\u{1100}\u{1163}\u{11B0}", "\u{AC41}", "\u{1100}\u{1163}\u{11B0}"),
    ("\u{AC42}", "\u{AC42}", "\u{1100}\u{1163}\u{11B1}", "\u{AC42}", "\u{1100}\u{1163}\u{11B1}"),
    ("\u{AC43}", "\u{AC43}", "\u{1100}\u{1163}\u{11B2}", "\u{AC43}", "\u{1100}\u{1163}\u{11B2}"),
    ("\u{AC44}", "\u{AC44}", "\u{1100}\u{1163}\u{11B3}", "\u{AC44}", "\u{1100}\u{1163}\u{11B3}"),
    ("\u{AC45}", "\u{AC45}", "\u{1100}\u{1163}\u{11B4}", "\u{AC45}", "\u{1100}\u{1163}\u{11B4}"),
    ("\u{AC46}", "\u{AC46}", "\u{1100}\u{1163}\u{11B5}", "\u{AC46}", "\u{1100}\u{1163}\u{11B5}"),
    ("\u{AC47}", "\u{AC47}", "\u{1100}\u{1163}\u{11B6}", "\u{AC47}", "\u{1100}\u{1163}\u{11B6}"),
    ("\u{AC48}", "\u{AC48}", "\u{1100}\u{1163}\u{11B7}", "\u{AC48}", "\u{1100}\u{1163}\u{11B7}"),
    ("\u{AC49}", "\u{AC49}", "\u{1100}\u{1163}\u{11B8}", "\u{AC49}", "\u{1100}\u{1163}\u{11B8}"),
    ("\u{AC4A}", "\u{AC4A}", "\u{1100}\u{1163}\u{11B9}", "\u{AC4A}", "\u{1100}\u{1163}\u{11B9}"),
    ("\u{AC4B}", "\u{AC4B}", "\u{1100}\u{1163}\u{11BA}", "\u{AC4B}", "\u{1100}\u{1163}\u{11BA}"),
    ("\u{AC4C}", "\u{AC4C}", "\u{1100}\u{1163}\u{11BB}", "\u{AC4C}", "\u{1100}\u{1163}\u{11BB}"),
    ("\u{AC4D}", "\u{AC4D}", "\u{1100}\u{1163}\u{11BC}", "\u{AC4D}", "\u{1100}\u{1163}\u{11BC}"),
    ("\u{AC4E}", "\u{AC4E}", "\u{1100}\u{1163}\u{11BD}", "\u{AC4E}", "\u{1100}\u{1163}\u{11BD}"),
    ("\u{AC4F}", "\u{AC4F}", "\u{1100}\u{1163}\u{11BE}", "\u{AC4F}", "\u{1100}\u{1163}\u{11BE}"),
    ("\u{AC50}", "\u{AC50}", "\u{1100}\u{1163}\u{11BF}", "\u{AC50}", "\u{1100}\u{1163}\u{11BF}"),
    ("\u{AC51}", "\u{AC51}", "\u{1100}\u{1163}\u{11C0}", "\u{AC51}", "\u{1100}\u{1163}\u{11C0}"),
    ("\u{AC52}", "\u{AC52}", "\u{1100}\u{1163}\u{11C1}", "\u{AC52}", "\u{1100}\u{1163}\u{11C1}"),
    ("\u{AC53}", "\u{AC53}", "\u{1100}\u{1163}\u{11C2}", "\u{AC53}", "\u{1100}\u{1163}\u{11C2}"),
    ("\u{AC54}", "\u{AC54}", "\u{1100}\u{1164}", "\u{AC54}", "\u{1100}\u{1164}"),
    ("\u{AC55}", "\u{AC55}", "\u{1100}\u{1164}\u{11A8}", "\u{AC55}", "\u{1100}\u{1164}\u{11A8}"),
    ("\u{AC56}", "\u{AC56}", "\u{1100}\u{1164}\u{11A9}", "\u{AC56}", "\u{1100}\u{1164}\u{11A9}"),
    ("\u{AC57}", "\u{AC57}", "\u{1100}\u{1164}\u{11AA}", "\u{AC57}", "\u{1100}\u{1164}\u{11AA}"),
    ("\u{AC58}", "\u{AC58}", "\u{1100}\u{1164}\u{11AB}", "\u{AC58}", "\u{1100}\u{1164}\u{11AB}"),
    ("\u{AC59}", "\u{AC59}", "\u{1100}\u{1164}\u{11AC}", "\u{AC59}", "\u{1100}\u{1164}\u{11AC}"),
    ("\u{AC5A}", "\u{AC5A}", "\u{1100}\u{1164}\u{11AD}", "\u{AC5A}", "\u{1100}\u{1164}\u{11AD}"),
    ("\u{AC5B}", "\u{AC5B}", "\u{1100}\u{1164}\u{11AE}", "\u{AC5B}", "\u{1100}\u{1164}\u{11AE}"),
    ("\u{AC5C}", "\u{AC5C}", "\u{1100}\u{1164}\u{11AF}", "\u{AC5C}", "\u{1100}\u{1164}\u{11AF}"),
    ("\u{AC5D}", "\u{AC5D}", "\u{1100}\u{1164}\u{11B0}", "\u{AC5D}", "\u{1100}\u{1164}\u{11B0}"),
    ("\u{AC5E}", "\u{AC5E}", "\u{1100}\u{1164}\u{11B1}", "\u{AC5E}", "\u{1100}\u{1164}\u{11B1}"),
    ("\u{AC5F}", "\u{AC5F}", "\u{1100}\u{1164}\u{11B2}", "\u{AC5F}", "\u{1100}\u{1164}\u{11B2}"),
    ("\u{AC60}", "\u{AC60}", "\u{1100}\u{1164}\u{11B3}", "\u{AC60}", "\u{1100}\u{1164}\u{11B3}"),
    ("\u{AC61}", "\u{AC61}", "\u{1100}\u{1164}\u{11B4}", "\u{AC61}", "\u{1100}\u{1164}\u{11B4}"),
    ("\u{AC62}", "\u{AC62}", "\u{1100}\u{1164}\u{11B5}", "\u{AC62}", "\u{1100}\u{1164}\u{11B5}"),
    ("\u{AC63}", "\u{AC63}", "\u{1100}\u{1164}\u{11B6}", "\u{AC63}", "\u{1100}\u{1164}\u{11B6}"),
    ("\u{AC64}", "\u{AC64}", "\u{1100}\u{1164}\u{11B7}", "\u{AC64}", "\u{1100}\u{1164}\u{11B7}"),
    ("\u{AC65}", "\u{AC65}", "\u{1100}\u{1164}\u{11B8}", "\u{AC65}", "\u{1100}\u{1164}\u{11B8}"),
    ("\u{AC66}", "\u{AC66}", "\u{1100}\u{1164}\u{11B9}", "\u{AC66}", "\u{1100}\u{1164}\u{11B9}"),
    ("\u{AC67}", "\u{AC67}", "\u{1100}\u{1164}\u{11BA}", "\u{AC67}", "\u{1100}\u{1164}\u{11BA}"),
    ("\u{AC68}", "\u{AC68}", "\u{1100}\u{1164}\u{11BB}", "\u{AC68}", "\u{1100}\u{1164}\u{11BB}"),
    ("\u{AC69}", "\u{AC69}", "\u{1100}\u{1164}\u{11BC}", "\u{AC69}", "\u{1100}\u{1164}\u{11BC}"),
    ("\u{AC6A}", "\u{AC6A}", "\u{1100}\u{1164}\u{11BD}", "\u{AC6A}", "\u{1100}\u{1164}\u{11BD}"),
    ("\u{AC6B}", "\u{AC6B}", "\u{1100}\u{1164}\u{11BE}", "\u{AC6B}", "\u{1100}\u{1164}\u{11BE}"),
    ("\u{AC6C}", "\u{AC6C}", "\u{1100}\u{1164}\u{11BF}", "\u{AC6C}", "\u{1100}\u{1164}\u{11BF}"),
    ("\u{AC6D}", "\u{AC6D}", "\u{1100}\u{1164}\u{11C0}", "\u{AC6D}", "\u{1100}\u{1164}\u{11C0}"),
    ("\u{AC6E}", "\u{AC6E}", "\u{1100}\u{1164}\u{11C1}", "\u{AC6E}", "\u{1100}\u{1164}\u{11C1}"),
    ("\u{AC6F}", "\u{AC6F}", "\u{1100}\u{1164}\u{11C2}", "\u{AC6F}", "\u{1100}\u{1164}\u{11C2}"),
    ("\u{AC70}", "\u{AC70}", "\u{1100}\u{1165}", "\u{AC70}", "\u{1100}\u{1165}"),
    ("\u{AC71}", "\u{AC71}", "\u{1100}\u{1165}\u{11A8}", "\u{AC71}", "\u{1100}\u{1165}\u{11A8}"),
    ("\u{AC72}", "\u{AC72}", "\u{1100}\u{1165}\u{11A9}", "\u{AC72}", "\u{1100}\u{1165}\u{11A9}"),
    ("\u{AC73}", "\u{AC73}", "\u{1100}\u{1165}\u{11AA}", "\u{AC73}", "\u{1100}\u{1165}\u{11AA}"),
    ("\u{AC74}", "\u{AC74}", "\u{1100}\u{1165}\u{11AB}", "\u{AC74}", "\u{1100}\u{1165}\u{11AB}"),
    ("\u{AC75}", "\u{AC75}", "\u{1100}\u{1165}\u{11AC}", "\u{AC75}", "\u{1100}\u{1165}\u{11AC}"),
    ("\u{AC76}", "\u{AC76}", "\u{1100}\u{1165}\u{11AD}", "\u{AC76}", "\u{1100}\u{1165}\u{11AD}"),
    ("\u{AC77}", "\u{AC77}", "\u{1100}\u{1165}\u{11AE}", "\u{AC77}", "\u{1100}\u{1165}\u{11AE}"),
    ("\u{AC78}", "\u{AC78}", "\u{1100}\u{1165}\u{11AF}", "\u{AC78}", "\u{1100}\u{1165}\u{11AF}"),
    ("\u{AC79}", "\u{AC79}", "\u{1100}\u{1165}\u{11B0}", "\u{AC79}", "\u{1100}\u{1165}\u{11B0}"),
    ("\u{AC7A}", "\u{AC7A}", "\u{1100}\u{1165}\u{11B1}", "\u{AC7A}", "\u{1100}\u{1165}\u{11B1}"),
    ("\u{AC7B}", "\u{AC7B}", "\u{1100}\u{1165}\u{11B2}", "\u{AC7B}", "\u{1100}\u{1165}\u{11B2}"),
    ("\u{AC7C}", "\u{AC7C}", "\u{1100}\u{1165}\u{11B3}", "\u{AC7C}", "\u{1100}\u{1165}\u{11B3}"),
    ("\u{AC7D}", "\u{AC7D}", "\u{1100}\u{1165}\u{11B4}", "\u{AC7D}", "\u{1100}\u{1165}\u{11B4}"),
    ("\u{AC7E}", "\u{AC7E}", "\u{1100}\u{1165}\u{11B5}", "\u{AC7E}", "\u{1100}\u{1165}\u{11B5}"),
    ("\u{AC7F}", "\u{AC7F}", "\u{1100}\u{1165}\u{11B6}", "\u{AC7F}", "\u{1100}\u{1165}\u{11B6}"),
    ("\u{AC80}", "\u{AC80}", "\u{1100}\u{1165}\u{11B7}", "\u{AC80}", "\u{1100}\u{1165}\u{11B7}"),
    ("\u{AC81}", "\u{AC81}", "\u{1100}\u{1165}\u{11B8}", "\u{AC81}", "\u{1100}\u{1165}\u{11B8}"),
    ("\u{AC82}", "\u{AC82}", "\u{1100}\u{1165}\u{11B9}", "\u{AC82}", "\u{1100}\u{1165}\u{11B9}"),
    ("\u{AC83}", "\u{AC83}", "\u{1100}\u{1165}\u{11BA}", "\u{AC83}", "\u{1100}\u{1165}\u{11BA}"),
    ("\u{AC84}", "\u{AC84}", "\u{1100}\u{1165}\u{11BB}", "\u{AC84}", "\u{1100}\u{1165}\u{11BB}"),
    ("\u{AC85}", "\u{AC85}", "\u{1100}\u{1165}\u{11BC}", "\u{AC85}", "\u{1100}\u{1165}\u{11BC}"),
    ("\u{AC86}", "\u{AC86}", "\u{1100}\u{1165}\u{11BD}", "\u{AC86}", "\u{1100}\u{1165}\u{11BD}"),
    ("\u{AC87}", "\u{AC87}", "\u{1100}\u{1165}\u{11BE}", "\u{AC87}", "\u{1100}\u{1165}\u{11BE}"),
    ("\u{AC88}", "\u{AC88}", "\u{1100}\u{1165}\u{11BF}", "\u{AC88}", "\u{1100}\u{1165}\u{11BF}"),
    ("\u{AC89}", "\u{AC89}", "\u{1100}\u{1165}\u{11C0}", "\u{AC89}", "\u{1100}\u{1165}\u{11C0}"),
    ("\u{AC8A}", "\u{AC8A}", "\u{1100}\u{1165}\u{11C1}", "\u{AC8A}", "\u{1100}\u{1165}\u{11C1}"),
    ("\u{AC8B}", "\u{AC8B}", "\u{1100}\u{1165}\u{11C2}", "\u{AC8B}", "\u{1100}\u{1165}\u{11C2}"),
    ("\u{AC8C}", "\u{AC8C}", "\u{1100}\u{1166}", "\u{AC8C}", "\u{1100}\u{1166}"),
    ("\u{AC8D}", "\u{AC8D}", "\u{1100}\u{1166}\u{11A8}", "\u{AC8D}", "\u{1100}\u{1166}\u{11A8}"),
    ("\u{AC8E}", "\u{AC8E}", "\u{1100}\u{1166}\u{11A9}", "\u{AC8E}", "\u{1100}\u{1166}\u{11A9}"),
    ("\u{AC8F}", "\u{AC8F}", "\u{1100}\u{1166}\u{11AA}", "\u{AC8F}", "\u{1100}\u{1166}\u{11AA}"),
    ("\u{AC90}", "\u{AC90}", "\u{1100}\u{1166}\u{11AB}", "\u{AC90}", "\u{1100}\u{1166}\u{11AB}"),
    ("\u{AC91}", "\u{AC91}", "\u{1100}\u{1166}\u{11AC}", "\u{AC91}", "\u{1100}\u{1166}\u{11AC}"),
    ("\u{AC92}", "\u{AC92}", "\u{1100}\u{1166}\u{11AD}", "\u{AC92}", "\u{1100}\u{1166}\u{11AD}"),
    ("\u{AC93}", "\u{AC93}", "\u{1100}\u{1166}\u{11AE}", "\u{AC93}", "\u{1100}\u{1166}\u{11AE}"),
    ("\u{AC94}", "\u{AC94}", "\u{1100}\u{1166}\u{11AF}", "\u{AC94}", "\u{1100}\u{1166}\u{11AF}"),
    ("\u{AC95}", "\u{AC95}", "\u{1100}\u{1166}\u{11B0}", "\u{AC95}", "\u{1100}\u{1166}\u{11B0}"),
    ("\u{AC96}", "\u{AC96}", "\u{1100}\u{1166}\u{11B1}", "\u{AC96}", "\u{1100}\u{1166}\u{11B1}"),
    ("\u{AC97}", "\u{AC97}", "\u{1100}\u{1166}\u{11B2}", "\u{AC97}", "\u{1100}\u{1166}\u{11B2}"),
    ("\u{AC98}", "\u{AC98}", "\u{1100}\u{1166}\u{11B3}", "\u{AC98}", "\u{1100}\u{1166}\u{11B3}"),
    ("\u{AC99}", "\u{AC99}", "\u{1100}\u{1166}\u{11B4}", "\u{AC99}", "\u{1100}\u{1166}\u{11B4}"),
    ("\u{AC9A}", "\u{AC9A}", "\u{1100}\u{1166}\u{11B5}", "\u{AC9A}", "\u{1100}\u{1166}\u{11B5}"),
    ("\u{AC9B}", "\u{AC9B}", "\u{1100}\u{1166}\u{11B6}", "\u{AC9B}", "\u{1100}\u{1166}\u{11B6}"),
    ("\u{AC9C}", "\u{AC9C}", "\u{1100}\u{1166}\u{11B7}", "\u{AC9C}", "\u{1100}\u{1166}\u{11B7}"),
    ("\u{AC9D}", "\u{AC9D}", "\u{1100}\u{1166}\u{11B8}", "\u{AC9D}", "\u{1100}\u{1166}\u{11B8}"),
    ("\u{AC9E}", "\u{AC9E}", "\u{1100}\u{1166}\u{11B9}", "\u{AC9E}", "\u{1100}\u{1166}\u{11B9}"),
    ("\u{AC9F}", "\u{AC9F}", "\u{1100}\u{1166}\u{11BA}", "\u{AC9F}", "\u{1100}\u{1166}\u{11BA}"),
    ("\u{ACA0}", "\u{ACA0}", "\u{1100}\u{1166}\u{11BB}", "\u{ACA0}", "\u{1100}\u{1166}\u{11BB}"),
    ("\u{ACA1}", "\u{ACA1}", "\u{1100}\u{1166}\u{11BC}", "\u{ACA1}", "\u{1100}\u{1166}\u{11BC}"),
    ("\u{ACA2}", "\u{ACA2}", "\u{1100}\u{1166}\u{11BD}", "\u{ACA2}", "\u{1100}\u{1166}\u{11BD}"),
    ("\u{ACA3}", "\u{ACA3}", "\u{1100}\u{1166}\u{11BE}", "\u{ACA3}", "\u{1100}\u{1166}\u{11BE}"),
    ("\u{ACA4}", "\u{ACA4}", "\u{1100}\u{1166}\u{11BF}", "\u{ACA4}", "\u{1100}\u{1166}\u{11BF}"),
    ("\u{ACA5}", "\u{ACA5}", "\u{1100}\u{1166}\u{11C0}", "\u{ACA5}", "\u{1100}\u{1166}\u{11C0}"),
    ("\u{ACA6}", "\u{ACA6}", "\u{1100}\u{1166}\u{11C1}", "\u{ACA6}", "\u{1100}\u{1166}\u{11C1}"),
    ("\u{ACA7}", "\u{ACA7}", "\u{1100}\u{1166}\u{11C2}", "\u{ACA7}", "\u{1100}\u{1166}\u{11C2}"),
    ("\u{ACA8}", "\u{ACA8}", "\u{1100}\u{1167}", "\u{ACA8}", "\u{1100}\u{1167}"),
    ("\u{ACA9}", "\u{ACA9}", "\u{1100}\u{1167}\u{11A8}", "\u{ACA9}", "\u{1100}\u{1167}\u{11A8}"),
    ("\u{ACAA}", "\u{ACAA}", "\u{1100}\u{1167}\u{11A9}", "\u{ACAA}", "\u{1100}\u{1167}\u{11A9}"),
    ("\u{ACAB}", "\u{ACAB}", "\u{1100}\u{1167}\u{11AA}", "\u{ACAB}", "\u{1100}\u{1167}\u{11AA}"),
    ("\u{ACAC}", "\u{ACAC}", "\u{1100}\u{1167}\u{11AB}", "\u{ACAC}", "\u{1100}\u{1167}\u{11AB}"),
    ("\u{ACAD}", "\u{ACAD}", "\u{1100}\u{1167}\u{11AC}", "\u{ACAD}", "\u{1100}\u{1167}\u{11AC}"),
    ("\u{ACAE}", "\u{ACAE}", "\u{1100}\u{1167}\u{11AD}", "\u{ACAE}", "\u{1100}\u{1167}\u{11AD}"),
    ("\u{ACAF}", "\u{ACAF}", "\u{1100}\u{1167}\u{11AE}", "\u{ACAF}", "\u{1100}\u{1167}\u{11AE}"),
    ("\u{ACB0}", "\u{ACB0}", "\u{1100}\u{1167}\u{11AF}", "\u{ACB0}", "\u{1100}\u{1167}\u{11AF}"),
    ("\u{ACB1}", "\u{ACB1}", "\u{1100}\u{1167}\u{11B0}", "\u{ACB1}", "\u{1100}\u{1167}\u{11B0}"),
    ("\u{ACB2}", "\u{ACB2}", "\u{1100}\u{1167}\u{11B1}", "\u{ACB2}", "\u{1100}\u{1167}\u{11B1}"),
    ("\u{ACB3}", "\u{ACB3}", "\u{1100}\u{1167}\u{11B2}", "\u{ACB3}", "\u{1100}\u{1167}\u{11B2}"),
    ("\u{ACB4}", "\u{ACB4}", "\u{1100}\u{1167}\u{11B3}", "\u{ACB4}", "\u{1100}\u{1167}\u{11B3}"),
    ("\u{ACB5}", "\u{ACB5}", "\u{1100}\u{1167}\u{11B4}", "\u{ACB5}", "\u{1100}\u{1167}\u{11B4}"),
    ("\u{ACB6}", "\u{ACB6}", "\u{1100}\u{1167}\u{11B5}", "\u{ACB6}", "\u{1100}\u{1167}\u{11B5}"),
    ("\u{ACB7}", "\u{ACB7}", "\u{1100}\u{1167}\u{11B6}", "\u{ACB7}", "\u{1100}\u{1167}\u{11B6}"),
    ("\u{ACB8}", "\u{ACB8}", "\u{1100}\u{1167}\u{11B7}", "\u{ACB8}", "\u{1100}\u{1167}\u{11B7}"),
    ("\u{ACB9}", "\u{ACB9}", "\u{1100}\u{1167}\u{11B8}", "\u{ACB9}", "\u{1100}\u{1167}\u{11B8}"),
    ("\u{ACBA}", "\u{ACBA}", "\u{1100}\u{1167}\u{11B9}", "\u{ACBA}", "\u{1100}\u{1167}\u{11B9}"),
    ("\u{ACBB}", "\u{ACBB}", "\u{1100}\u{1167}\u{11BA}", "\u{ACBB}", "\u{1100}\u{1167}\u{11BA}"),
    ("\u{ACBC}", "\u{ACBC}", "\u{1100}\u{1167}\u{11BB}", "\u{ACBC}", "\u{1100}\u{1167}\u{11BB}"),
    ("\u{ACBD}", "\u{ACBD}", "\u{1100}\u{1167}\u{11BC}", "\u{ACBD}", "\u{1100}\u{1167}\u{11BC}"),
    ("\u{ACBE}", "\u{ACBE}", "\u{1100}\u{1167}\u{11BD}", "\u{ACBE}", "\u{1100}\u{1167}\u{11BD}"),
    ("\u{ACBF}", "\u{ACBF}", "\u{1100}\u{1167}\u{11BE}", "\u{ACBF}", "\u{1100}\u{1167}\u{11BE}"),
    ("\u{ACC0}", "\u{ACC0}", "\u{1100}\u{1167}\u{11BF}", "\u{ACC0}", "\u{1100}\u{1167}\u{11BF}"),
    ("\u{ACC1}", "\u{ACC1}", "\u{1100}\u{1167}\u{11C0}", "\u{ACC1}", "\u{1100}\u{1167}\u{11C0}"),
    ("\u{ACC2}", "\u{ACC2}", "\u{1100}\u{1167}\u{11C1}", "\u{ACC2}", "\u{1100}\u{1167}\u{11C1}"),
    ("\u{ACC3}", "\u{ACC3}", "\u{1100}\u{1167}\u{11C2}", "\u{ACC3}", "\u{1100}\u{1167}\u{11C2}"),
    ("\u{ACC4}", "\u{ACC4}", "\u{1100}\u{1168}", "\u{ACC4}", "\u{1100}\u{1168}"),
    ("\u{ACC5}", "\u{ACC5}", "\u{1100}\u{1168}\u{11A8}", "\u{ACC5}", "\u{1100}\u{1168}\u{11A8}"),
    ("\u{ACC6}", "\u{ACC6}", "\u{1100}\u{1168}\u{11A9}", "\u{ACC6}", "\u{1100}\u{1168}\u{11A9}"),
    ("\u{ACC7}", "\u{ACC7}", "\u{1100}\u{1168}\u{11AA}", "\u{ACC7}", "\u{1100}\u{1168}\u{11AA}"),
    ("\u{ACC8}", "\u{ACC8}", "\u{1100}\u{1168}\u{11AB}", "\u{ACC8}", "\u{1100}\u{1168}\u{11AB}"),
    ("\u{ACC9}", "\u{ACC9}", "\u{1100}\u{1168}\u{11AC}", "\u{ACC9}", "\u{1100}\u{1168}\u{11AC}"),
    ("\u{ACCA}", "\u{ACCA}", "\u{1100}\u{1168}\u{11AD}", "\u{ACCA}", "\u{1100}\u{1168}\u{11AD}"),
    ("\u{ACCB}", "\u{ACCB}", "\u{1100}\u{1168}\u{11AE}", "\u{ACCB}", "\u{1100}\u{1168}\u{11AE}"),
    ("\u{ACCC}", "\u{ACCC}", "\u{1100}\u{1168}\u{11AF}", "\u{ACCC}", "\u{1100}\u{1168}\u{11AF}"),
    ("\u{ACCD}", "\u{ACCD}", "\u{1100}\u{1168}\u{11B0}", "\u{ACCD}", "\u{1100}\u{1168}\u{11B0}"),
    ("\u{ACCE}", "\u{ACCE}", "\u{1100}\u{1168}\u{11B1}", "\u{ACCE}", "\u{1100}\u{1168}\u{11B1}"),
    ("\u{ACCF}", "\u{ACCF}", "\u{1100}\u{1168}\u{11B2}", "\u{ACCF}", "\u{1100}\u{1168}\u{11B2}"),
    ("\u{ACD0}", "\u{ACD0}", "\u{1100}\u{1168}\u{11B3}", "\u{ACD0}", "\u{1100}\u{1168}\u{11B3}"),
    ("\u{ACD1}", "\u{ACD1}", "\u{1100}\u{1168}\u{11B4}", "\u{ACD1}", "\u{1100}\u{1168}\u{11B4}"),
    ("\u{ACD2}", "\u{ACD2}", "\u{1100}\u{1168}\u{11B5}", "\u{ACD2}", "\u{1100}\u{1168}\u{11B5}"),
    ("\u{ACD3}", "\u{ACD3}", "\u{1100}\u{1168}\u{11B6}", "\u{ACD3}", "\u{1100}\u{1168}\u{11B6}"),
    ("\u{ACD4}", "\u{ACD4}", "\u{1100}\u{1168}\u{11B7}", "\u{ACD4}", "\u{1100}\u{1168}\u{11B7}"),
    ("\u{ACD5}", "\u{ACD5}", "\u{1100}\u{1168}\u{11B8}", "\u{ACD5}", "\u{1100}\u{1168}\u{11B8}"),
    ("\u{ACD6}", "\u{ACD6}", "\u{1100}\u{1168}\u{11B9}", "\u{ACD6}", "\u{1100}\u{1168}\u{11B9}"),
    ("\u{ACD7}", "\u{ACD7}", "\u{1100}\u{1168}\u{11BA}", "\u{ACD7}", "\u{1100}\u{1168}\u{11BA}"),
    ("\u{ACD8}", "\u{ACD8}", "\u{1100}\u{1168}\u{11BB}", "\u{ACD8}", "\u{1100}\u{1168}\u{11BB}"),
    ("\u{ACD9}", "\u{ACD9}", "\u{1100}\u{1168}\u{11BC}", "\u{ACD9}", "\u{1100}\u{1168}\u{11BC}"),
    ("\u{ACDA}", "\u{ACDA}", "\u{1100}\u{1168}\u{11BD}", "\u{ACDA}", "\u{1100}\u{1168}\u{11BD}"),
    ("\u{ACDB}", "\u{ACDB}", "\u{1100}\u{1168}\u{11BE}", "\u{ACDB}", "\u{1100}\u{1168}\u{11BE}"),
    ("\u{ACDC}", "\u{ACDC}", "\u{1100}\u{1168}\u{11BF}", "\u{ACDC}", "\u{1100}\u{1168}\u{11BF}"),
    ("\u{ACDD}", "\u{ACDD}", "\u{1100}\u{1168}\u{11C0}", "\u{ACDD}", "\u{1100}\u{1168}\u{11C0}"),
    ("\u{ACDE}", "\u{ACDE}", "\u{1100}\u{1168}\u{11C1}", "\u{ACDE}", "\u{1100}\u{1168}\u{11C1}"),
    ("\u{ACDF}", "\u{ACDF}", "\u{1100}\u{1168}\u{11C2}", "\u{ACDF}", "\u{1100}\u{1168}\u{11C2}"),
    ("\u{ACE0}", "\u{ACE0}", "\u{1100}\u{1169}", "\u{ACE0}", "\u{1100}\u{1169}"),
    ("\u{ACE1}", "\u{ACE1}", "\u{1100}\u{1169}\u{11A8}", "\u{ACE1}", "\u{1100}\u{1169}\u{11A8}"),
    ("\u{ACE2}", "\u{ACE2}", "\u{1100}\u{1169}\u{11A9}", "\u{ACE2}", "\u{1100}\u{1169}\u{11A9}"),
    ("\u{ACE3}", "\u{ACE3}", "\u{1100}\u{1169}\u{11AA}", "\u{ACE3}", "\u{1100}\u{1169}\u{11AA}"),
    ("\u{ACE4}", "\u{ACE4}", "\u{1100}\u{1169}\u{11AB}", "\u{ACE4}", "\u{1100}\u{1169}\u{11AB}"),
    ("\u{ACE5}", "\u{ACE5}", "\u{1100}\u{1169}\u{11AC}", "\u{ACE5}", "\u{1100}\u{1169}\u{11AC}"),
    ("\u{ACE6}", "\u{ACE6}", "\u{1100}\u{1169}\u{11AD}", "\u{ACE6}", "\u{1100}\u{1169}\u{11AD}"),
    ("\u{ACE7}", "\u{ACE7}", "\u{1100}\u{1169}\u{11AE}", "\u{ACE7}", "\u{1100}\u{1169}\u{11AE}"),
    ("\u{ACE8}", "\u{ACE8}", "\u{1100}\u{1169}\u{11AF}", "\u{ACE8}", "\u{1100}\u{1169}\u{11AF}"),
    ("\u{ACE9}", "\u{ACE9}", "\u{1100}\u{1169}\u{11B0}", "\u{ACE9}", "\u{1100}\u{1169}\u{11B0}"),
    ("\u{ACEA}", "\u{ACEA}", "\u{1100}\u{1169}\u{11B1}", "\u{ACEA}", "\u{1100}\u{1169}\u{11B1}"),
    ("\u{ACEB}", "\u{ACEB}", "\u{1100}\u{1169}\u{11B2}", "\u{ACEB}", "\u{1100}\u{1169}\u{11B2}"),
    ("\u{ACEC}", "\u{ACEC}", "\u{1100}\u{1169}\u{11B3}", "\u{ACEC}", "\u{1100}\u{1169}\u{11B3}"),
    ("\u{ACED}", "\u{ACED}", "\u{1100}\u{1169}\u{11B4}", "\u{ACED}", "\u{1100}\u{1169}\u{11B4}"),
    ("\u{ACEE}", "\u{ACEE}", "\u{1100}\u{1169}\u{11B5}", "\u{ACEE}", "\u{1100}\u{1169}\u{11B5}"),
    ("\u{ACEF}", "\u{ACEF}", "\u{1100}\u{1169}\u{11B6}", "\u{ACEF}", "\u{1100}\u{1169}\u{11B6}"),
    ("\u{ACF0}", "\u{ACF0}", "\u{1100}\u{1169}\u{11B7}", "\u{ACF0}", "\u{1100}\u{1169}\u{11B7}"),
    ("\u{ACF1}", "\u{ACF1}", "\u{1100}\u{1169}\u{11B8}", "\u{ACF1}", "\u{1100}\u{1169}\u{11B8}"),
    ("\u{ACF2}", "\u{ACF2}", "\u{1100}\u{1169}\u{11B9}", "\u{ACF2}", "\u{1100}\u{1169}\u{11B9}"),
    ("\u{ACF3}", "\u{ACF3}", "\u{1100}\u{1169}\u{11BA}", "\u{ACF3}", "\u{1100}\u{1169}\u{11BA}"),
    ("\u{ACF4}", "\u{ACF4}", "\u{1100}\u{1169}\u{11BB}", "\u{ACF4}", "\u{1100}\u{1169}\u{11BB}"),
    ("\u{ACF5}", "\u{ACF5}", "\u{1100}\u{1169}\u{11BC}", "\u{ACF5}", "\u{1100}\u{1169}\u{11BC}"),
    ("\u{ACF6}", "\u{ACF6}", "\u{1100}\u{1169}\u{11BD}", "\u{ACF6}", "\u{1100}\u{1169}\u{11BD}"),
    ("\u{ACF7}", "\u{ACF7}", "\u{1100}\u{1169}\u{11BE}", "\u{ACF7}", "\u{1100}\u{1169}\u{11BE}"),
    ("\u{ACF8}", "\u{ACF8}", "\u{1100}\u{1169}\u{11BF}", "\u{ACF8}", "\u{1100}\u{1169}\u{11BF}"),
    ("\u{ACF9}", "\u{ACF9}", "\u{1100}\u{1169}\u{11C0}", "\u{ACF9}", "\u{1100}\u{1169}\u{11C0}"),
    ("\u{ACFA}", "\u{ACFA}", "\u{1100}\u{1169}\u{11C1}", "\u{ACFA}", "\u{1100}\u{1169}\u{11C1}"),
    ("\u{ACFB}", "\u{ACFB}", "\u{1100}\u{1169}\u{11C2}", "\u{ACFB}", "\u{1100}\u{1169}\u{11C2}"),
    ("\u{ACFC}", "\u{ACFC}", "\u{1100}\u{116A}", "\u{ACFC}", "\u{1100}\u{116A}"),
    ("\u{ACFD}", "\u{ACFD}", "\u{1100}\u{116A}\u{11A8}", "\u{ACFD}", "\u{1100}\u{116A}\u{11A8}"),
    ("\u{ACFE}", "\u{ACFE}", "\u{1100}\u{116A}\u{11A9}", "\u{ACFE}", "\u{1100}\u{116A}\u{11A9}"),
    ("\u{ACFF}", "\u{ACFF}", "\u{1100}\u{116A}\u{11AA}", "\u{ACFF}", "\u{1100}\u{116A}\u{11AA}"),
    ("\u{AD00}", "\u{AD00}", "\u{1100}\u{116A}\u{11AB}", "\u{AD00}", "\u{1100}\u{116A}\u{11AB}"),
    ("\u{AD01}", "\u{AD01}", "\u{1100}\u{116A}\u{11AC}", "\u{AD01}", "\u{1100}\u{116A}\u{11AC}"),
    ("\u{AD02}", "\u{AD02}", "\u{1100}\u{116A}\u{11AD}", "\u{AD02}", "\u{1100}\u{116A}\u{11AD}"),
    ("\u{AD03}", "\u{AD03}", "\u{1100}\u{116A}\u{11AE}", "\u{AD03}", "\u{1100}\u{116A}\u{11AE}"),
    ("\u{AD04}", "\u{AD04}", "\u{1100}\u{116A}\u{11AF}", "\u{AD04}", "\u{1100}\u{116A}\u{11AF}"),
    ("\u{AD05}", "\u{AD05}", "\u{1100}\u{116A}\u{11B0}", "\u{AD05}", "\u{1100}\u{116A}\u{11B0}"),
    ("\u{AD06}", "\u{AD06}", "\u{1100}\u{116A}\u{11B1}", "\u{AD06}", "\u{1100}\u{116A}\u{11B1}"),
    ("\u{AD07}", "\u{AD07}", "\u{1100}\u{116A}\u{11B2}", "\u{AD07}", "\u{1100}\u{116A}\u{11B2}"),
    ("\u{AD08}", "\u{AD08}", "\u{1100}\u{116A}\u{11B3}", "\u{AD08}", "\u{1100}\u{116A}\u{11B3}"),
    ("\u{AD09}", "\u{AD09}", "\u{1100}\u{116A}\u{11B4}", "\u{AD09}", "\u{1100}\u{116A}\u{11B4}"),
    ("\u{AD0A}", "\u{AD0A}", "\u{1100}\u{116A}\u{11B5}", "\u{AD0A}", "\u{1100}\u{116A}\u{11B5}"),
    ("\u{AD0B}", "\u{AD0B}", "\u{1100}\u{116A}\u{11B6}", "\u{AD0B}", "\u{1100}\u{116A}\u{11B6}"),
    ("\u{AD0C}", "\u{AD0C}", "\u{1100}\u{116A}\u{11B7}", "\u{AD0C}", "\u{1100}\u{116A}\u{11B7}"),
    ("\u{AD0D}", "\u{AD0D}", "\u{1100}\u{116A}\u{11B8}", "\u{AD0D}", "\u{1100}\u{116A}\u{11B8}"),
    ("\u{AD0E}", "\u{AD0E}", "\u{1100}\u{116A}\u{11B9}", "\u{AD0E}", "\u{1100}\u{116A}\u{11B9}"),
    ("\u{AD0F}", "\u{AD0F}", "\u{1100}\u{116A}\u{11BA}", "\u{AD0F}", "\u{1100}\u{116A}\u{11BA}"),
    ("\u{AD10}", "\u{AD10}", "\u{1100}\u{116A}\u{11BB}", "\u{AD10}", "\u{1100}\u{116A}\u{11BB}"),
    ("\u{AD11}", "\u{AD11}", "\u{1100}\u{116A}\u{11BC}", "\u{AD11}", "\u{1100}\u{116A}\u{11BC}"),
    ("\u{AD12}", "\u{AD12}", "\u{1100}\u{116A}\u{11BD}", "\u{AD12}", "\u{1100}\u{116A}\u{11BD}"),
    ("\u{AD13}", "\u{AD13}", "\u{1100}\u{116A}\u{11BE}", "\u{AD13}", "\u{1100}\u{116A}\u{11BE}"),
    ("\u{AD14}", "\u{AD14}", "\u{1100}\u{116A}\u{11BF}", "\u{AD14}", "\u{1100}\u{116A}\u{11BF}"),
    ("\u{AD15}", "\u{AD15}", "\u{1100}\u{116A}\u{11C0}", "\u{AD15}", "\u{1100}\u{116A}\u{11C0}"),
    ("\u{AD16}", "\u{AD16}", "\u{1100}\u{116A}\u{11C1}", "\u{AD16}", "\u{1100}\u{116A}\u{11C1}"),
    ("\u{AD17}", "\u{AD17}", "\u{1100}\u{116A}\u{11C2}", "\u{AD17}", "\u{1100}\u{116A}\u{11C2}"),
    ("\u{AD18}", "\u{AD18}", "\u{1100}\u{116B}", "\u{AD18}", "\u{1100}\u{116B}"),
    ("\u{AD19}", "\u{AD19}", "\u{1100}\u{116B}\u{11A8}", "\u{AD19}", "\u{1100}\u{116B}\u{11A8}"),
    ("\u{AD1A}", "\u{AD1A}", "\u{1100}\u{116B}\u{11A9}", "\u{AD1A}", "\u{1100}\u{116B}\u{11A9}"),
    ("\u{AD1B}", "\u{AD1B}", "\u{1100}\u{116B}\u{11AA}", "\u{AD1B}", "\u{1100}\u{116B}\u{11AA}"),
    ("\u{AD1C}", "\u{AD1C}", "\u{1100}\u{116B}\u{11AB}", "\u{AD1C}", "\u{1100}\u{116B}\u{11AB}"),
    ("\u{AD1D}", "\u{AD1D}", "\u{1100}\u{116B}\u{11AC}", "\u{AD1D}", "\u{1100}\u{116B}\u{11AC}"),
    ("\u{AD1E}", "\u{AD1E}", "\u{1100}\u{116B}\u{11AD}", "\u{AD1E}", "\u{1100}\u{116B}\u{11AD}"),
    ("\u{AD1F}", "\u{AD1F}", "\u{1100}\u{116B}\u{11AE}", "\u{AD1F}", "\u{1100}\u{116B}\u{11AE}"),
    ("\u{AD20}", "\u{AD20}", "\u{1100}\u{116B}\u{11AF}", "\u{AD20}", "\u{1100}\u{116B}\u{11AF}"),
    ("\u{AD21}", "\u{AD21}", "\u{1100}\u{116B}\u{11B0}", "\u{AD21}", "\u{1100}\u{116B}\u{11B0}"),
    ("\u{AD22}", "\u{AD22}", "\u{1100}\u{116B}\u{11B1}", "\u{AD22}", "\u{1100}\u{116B}\u{11B1}"),
    ("\u{AD23}", "\u{AD23}", "\u{1100}\u{116B}\u{11B2}", "\u{AD23}", "\u{1100}\u{116B}\u{11B2}"),
    ("\u{AD24}", "\u{AD24}", "\u{1100}\u{116B}\u{11B3}", "\u{AD24}", "\u{1100}\u{116B}\u{11B3}"),
    ("\u{AD25}", "\u{AD25}", "\u{1100}\u{116B}\u{11B4}", "\u{AD25}", "\u{1100}\u{116B}\u{11B4}"),
    ("\u{AD26}", "\u{AD26}", "\u{1100}\u{116B}\u{11B5}", "\u{AD26}", "\u{1100}\u{116B}\u{11B5}"),
    ("\u{AD27}", "\u{AD27}", "\u{1100}\u{116B}\u{11B6}", "\u{AD27}", "\u{1100}\u{116B}\u{11B6}"),
    ("\u{AD28}", "\u{AD28}", "\u{1100}\u{116B}\u{11B7}", "\u{AD28}", "\u{1100}\u{116B}\u{11B7}"),
    ("\u{AD29}", "\u{AD29}", "\u{1100}\u{116B}\u{11B8}", "\u{AD29}", "\u{1100}\u{116B}\u{11B8}"),
    ("\u{AD2A}", "\u{AD2A}", "\u{1100}\u{116B}\u{11B9}", "\u{AD2A}", "\u{1100}\u{116B}\u{11B9}"),
    ("\u{AD2B}", "\u{AD2B}", "\u{1100}\u{116B}\u{11BA}", "\u{AD2B}", "\u{1100}\u{116B}\u{11BA}"),
    ("\u{AD2C}", "\u{AD2C}", "\u{1100}\u{116B}\u{11BB}", "\u{AD2C}", "\u{1100}\u{116B}\u{11BB}"),
    ("\u{AD2D}", "\u{AD2D}", "\u{1100}\u{116B}\u{11BC}", "\u{AD2D}", "\u{1100}\u{116B}\u{11BC}"),
    ("\u{AD2E}", "\u{AD2E}", "\u{1100}\u{116B}\u{11BD}", "\u{AD2E}", "\u{1100}\u{116B}\u{11BD}"),
    ("\u{AD2F}", "\u{AD2F}", "\u{1100}\u{116B}\u{11BE}", "\u{AD2F}", "\u{1100}\u{116B}\u{11BE}"),
    ("\u{AD30}", "\u{AD30}", "\u{1100}\u{116B}\u{11BF}", "\u{AD30}", "\u{1100}\u{116B}\u{11BF}"),
    ("\u{AD31}", "\u{AD31}", "\u{1100}\u{116B}\u{11C0}", "\u{AD31}", "\u{1100}\u{116B}\u{11C0}"),
    ("\u{AD32}", "\u{AD32}", "\u{1100}\u{116B}\u{11C1}", "\u{AD32}", "\u{1100}\u{116B}\u{11C1}"),
    ("\u{AD33}", "\u{AD33}", "\u{1100}\u{116B}\u{11C2}", "\u{AD33}", "\u{1100}\u{116B}\u{11C2}"),
    ("\u{AD34}", "\u{AD34}", "\u{1100}\u{116C}", "\u{AD34}", "\u{1100}\u{116C}"),
    ("\u{AD35}", "\u{AD35}", "\u{1100}\u{116C}\u{11A8}", "\u{AD35}", "\u{1100}\u{116C}\u{11A8}"),
    ("\u{AD36}", "\u{AD36}", "\u{1100}\u{116C}\u{11A9}", "\u{AD36}", "\u{1100}\u{116C}\u{11A9}"),
    ("\u{AD37}", "\u{AD37}", "\u{1100}\u{116C}\u{11AA}", "\u{AD37}", "\u{1100}\u{116C}\u{11AA}"),
    ("\u{AD38}", "\u{AD38}", "\u{1100}\u{116C}\u{11AB}", "\u{AD38}", "\u{1100}\u{116C}\u{11AB}"),
    ("\u{AD39}", "\u{AD39}", "\u{1100}\u{116C}\u{11AC}", "\u{AD39}", "\u{1100}\u{116C}\u{11AC}"),
    ("\u{AD3A}", "\u{AD3A}", "\u{1100}\u{116C}\u{11AD}", "\u{AD3A}", "\u{1100}\u{116C}\u{11AD}"),
    ("\u{AD3B}", "\u{AD3B}", "\u{1100}\u{116C}\u{11AE}", "\u{AD3B}", "\u{1100}\u{116C}\u{11AE}"),
    ("\u{AD3C}", "\u{AD3C}", "\u{1100}\u{116C}\u{11AF}", "\u{AD3C}", "\u{1100}\u{116C}\u{11AF}"),
    ("\u{AD3D}", "\u{AD3D}", "\u{1100}\u{116C}\u{11B0}", "\u{AD3D}", "\u{1100}\u{116C}\u{11B0}"),
    ("\u{AD3E}", "\u{AD3E}", "\u{1100}\u{116C}\u{11B1}", "\u{AD3E}", "\u{1100}\u{116C}\u{11B1}"),
    ("\u{AD3F}", "\u{AD3F}", "\u{1100}\u{116C}\u{11B2}", "\u{AD3F}", "\u{1100}\u{116C}\u{11B2}"),
    ("\u{AD40}", "\u{AD40}", "\u{1100}\u{116C}\u{11B3}", "\u{AD40}", "\u{1100}\u{116C}\u{11B3}"),
    ("\u{AD41}", "\u{AD41}", "\u{1100}\u{116C}\u{11B4}", "\u{AD41}", "\u{1100}\u{116C}\u{11B4}"),
    ("\u{AD42}", "\u{AD42}", "\u{1100}\u{116C}\u{11B5}", "\u{AD42}", "\u{1100}\u{116C}\u{11B5}"),
    ("\u{AD43}", "\u{AD43}", "\u{1100}\u{116C}\u{11B6}", "\u{AD43}", "\u{1100}\u{116C}\u{11B6}"),
    ("\u{AD44}", "\u{AD44}", "\u{1100}\u{116C}\u{11B7}", "\u{AD44}", "\u{1100}\u{116C}\u{11B7}"),
    ("\u{AD45}", "\u{AD45}", "\u{1100}\u{116C}\u{11B8}", "\u{AD45}", "\u{1100}\u{116C}\u{11B8}"),
    ("\u{AD46}", "\u{AD46}", "\u{1100}\u{116C}\u{11B9}", "\u{AD46}", "\u{1100}\u{116C}\u{11B9}"),
    ("\u{AD47}", "\u{AD47}", "\u{1100}\u{116C}\u{11BA}", "\u{AD47}", "\u{1100}\u{116C}\u{11BA}"),
    ("\u{AD48}", "\u{AD48}", "\u{1100}\u{116C}\u{11BB}", "\u{AD48}", "\u{1100}\u{116C}\u{11BB}"),
    ("\u{AD49}", "\u{AD49}", "\u{1100}\u{116C}\u{11BC}", "\u{AD49}", "\u{1100}\u{116C}\u{11BC}"),
    ("\u{AD4A}", "\u{AD4A}", "\u{1100}\u{116C}\u{11BD}", "\u{AD4A}", "\u{1100}\u{116C}\u{11BD}"),
    ("\u{AD4B}", "\u{AD4B}", "\u{1100}\u{116C}\u{11BE}", "\u{AD4B}", "\u{1100}\u{116C}\u{11BE}"),
    ("\u{AD4C}", "\u{AD4C}", "\u{1100}\u{116C}\u{11BF}", "\u{AD4C}", "\u{1100}\u{116C}\u{11BF}"),
    ("\u{AD4D}", "\u{AD4D}", "\u{1100}\u{116C}\u{11C0}", "\u{AD4D}", "\u{1100}\u{116C}\u{11C0}"),
    ("\u{AD4E}", "\u{AD4E}", "\u{1100}\u{116C}\u{11C1}", "\u{AD4E}", "\u{1100}\u{116C}\u{11C1}"),
    ("\u{AD4F}", "\u{AD4F}", "\u{1100}\u{116C}\u{11C2}", "\u{AD4F}", "\u{1100}\u{116C}\u{11C2}"),
    ("\u{AD50}", "\u{AD50}", "\u{1100}\u{116D}", "\u{AD50}", "\u{1100}\u{116D}"),
    ("\u{AD51}", "\u{AD51}", "\u{1100}\u{116D}\u{11A8}", "\u{AD51}", "\u{1100}\u{116D}\u{11A8}"),
    ("\u{AD52}", "\u{AD52}", "\u{1100}\u{116D}\u{11A9}", "\u{AD52}", "\u{1100}\u{116D}\u{11A9}"),
    ("\u{AD53}", "\u{AD53}", "\u{1100}\u{116D}\u{11AA}", "\u{AD53}", "\u{1100}\u{116D}\u{11AA}"),
    ("\u{AD54}", "\u{AD54}", "\u{1100}\u{116D}\u{11AB}", "\u{AD54}", "\u{1100}\u{116D}\u{11AB}"),
    ("\u{AD55}", "\u{AD55}", "\u{1100}\u{116D}\u{11AC}", "\u{AD55}", "\u{1100}\u{116D}\u{11AC}"),
    ("\u{AD56}", "\u{AD56}", "\u{1100}\u{116D}\u{11AD}", "\u{AD56}", "\u{1100}\u{116D}\u{11AD}"),
    ("\u{AD57}", "\u{AD57}", "\u{1100}\u{116D}\u{11AE}", "\u{AD57}", "\u{1100}\u{116D}\u{11AE}"),
    ("\u{AD58}", "\u{AD58}", "\u{1100}\u{116D}\u{11AF}", "\u{AD58}", "\u{1100}\u{116D}\u{11AF}"),
    ("\u{AD59}", "\u{AD59}", "\u{1100}\u{116D}\u{11B0}", "\u{AD59}", "\u{1100}\u{116D}\u{11B0}"),
    ("\u{AD5A}", "\u{AD5A}", "\u{1100}\u{116D}\u{11B1}", "\u{AD5A}", "\u{1100}\u{116D}\u{11B1}"),
    ("\u{AD5B}", "\u{AD5B}", "\u{1100}\u{116D}\u{11B2}", "\u{AD5B}", "\u{1100}\u{116D}\u{11B2}"),
    ("\u{AD5C}", "\u{AD5C}", "\u{1100}\u{116D}\u{11B3}", "\u{AD5C}", "\u{1100}\u{116D}\u{11B3}"),
    ("\u{AD5D}", "\u{AD5D}", "\u{1100}\u{116D}\u{11B4}", "\u{AD5D}", "\u{1100}\u{116D}\u{11B4}"),
    ("\u{AD5E}", "\u{AD5E}", "\u{1100}\u{116D}\u{11B5}", "\u{AD5E}", "\u{1100}\u{116D}\u{11B5}"),
    ("\u{AD5F}", "\u{AD5F}", "\u{1100}\u{116D}\u{11B6}", "\u{AD5F}", "\u{1100}\u{116D}\u{11B6}"),
    ("\u{AD60}", "\u{AD60}", "\u{1100}\u{116D}\u{11B7}", "\u{AD60}", "\u{1100}\u{116D}\u{11B7}"),
    ("\u{AD61}", "\u{AD61}", "\u{1100}\u{116D}\u{11B8}", "\u{AD61}", "\u{1100}\u{116D}\u{11B8}"),
    ("\u{AD62}", "\u{AD62}", "\u{1100}\u{116D}\u{11B9}", "\u{AD62}", "\u{1100}\u{116D}\u{11B9}"),
    ("\u{AD63}", "\u{AD63}", "\u{1100}\u{116D}\u{11BA}", "\u{AD63}", "\u{1100}\u{116D}\u{11BA}"),
    ("\u{AD64}", "\u{AD64}", "\u{1100}\u{116D}\u{11BB}", "\u{AD64}", "\u{1100}\u{116D}\u{11BB}"),
    ("\u{AD65}", "\u{AD65}", "\u{1100}\u{116D}\u{11BC}", "\u{AD65}", "\u{1100}\u{116D}\u{11BC}"),
    ("\u{AD66}", "\u{AD66}", "\u{1100}\u{116D}\u{11BD}", "\u{AD66}", "\u{1100}\u{116D}\u{11BD}"),
    ("\u{AD67}", "\u{AD67}", "\u{1100}\u{116D}\u{11BE}", "\u{AD67}", "\u{1100}\u{116D}\u{11BE}"),
    ("\u{AD68}", "\u{AD68}", "\u{1100}\u{116D}\u{11BF}", "\u{AD68}", "\u{1100}\u{116D}\u{11BF}"),
    ("\u{AD69}", "\u{AD69}", "\u{1100}\u{116D}\u{11C0}", "\u{AD69}", "\u{1100}\u{116D}\u{11C0}"),
    ("\u{AD6A}", "\u{AD6A}", "\u{1100}\u{116D}\u{11C1}", "\u{AD6A}", "\u{1100}\u{116D}\u{11C1}"),
    ("\u{AD6B}", "\u{AD6B}", "\u{1100}\u{116D}\u{11C2}", "\u{AD6B}", "\u{1100}\u{116D}\u{11C2}"),
    ("\u{AD6C}", "\u{AD6C}", "\u{1100}\u{116E}", "\u{AD6C}", "\u{1100}\u{116E}"),
    ("\u{AD6D}", "\u{AD6D}", "\u{1100}\u{116E}\u{11A8}", "\u{AD6D}", "\u{1100}\u{116E}\u{11A8}"),
    ("\u{AD6E}", "\u{AD6E}", "\u{1100}\u{116E}\u{11A9}", "\u{AD6E}", "\u{1100}\u{116E}\u{11A9}"),
    ("\u{AD6F}", "\u{AD6F}", "\u{1100}\u{116E}\u{11AA}", "\u{AD6F}", "\u{1100}\u{116E}\u{11AA}"),
    ("\u{AD70}", "\u{AD70}", "\u{1100}\u{116E}\u{11AB}", "\u{AD70}", "\u{1100}\u{116E}\u{11AB}"),
    ("\u{AD71}", "\u{AD71}", "\u{1100}\u{116E}\u{11AC}", "\u{AD71}", "\u{1100}\u{116E}\u{11AC}"),
    ("\u{AD72}", "\u{AD72}", "\u{1100}\u{116E}\u{11AD}", "\u{AD72}", "\u{1100}\u{116E}\u{11AD}"),
    ("\u{AD73}", "\u{AD73}", "\u{1100}\u{116E}\u{11AE}", "\u{AD73}", "\u{1100}\u{116E}\u{11AE}"),
    ("\u{AD74}", "\u{AD74}", "\u{1100}\u{116E}\u{11AF}", "\u{AD74}", "\u{1100}\u{116E}\u{11AF}"),
    ("\u{AD75}", "\u{AD75}", "\u{1100}\u{116E}\u{11B0}", "\u{AD75}", "\u{1100}\u{116E}\u{11B0}"),
    ("\u{AD76}", "\u{AD76}", "\u{1100}\u{116E}\u{11B1}", "\u{AD76}", "\u{1100}\u{116E}\u{11B1}"),
    ("\u{AD77}", "\u{AD77}", "\u{1100}\u{116E}\u{11B2}", "\u{AD77}", "\u{1100}\u{116E}\u{11B2}"),
    ("\u{AD78}", "\u{AD78}", "\u{1100}\u{116E}\u{11B3}", "\u{AD78}", "\u{1100}\u{116E}\u{11B3}"),
    ("\u{AD79}", "\u{AD79}", "\u{1100}\u{116E}\u{11B4}", "\u{AD79}", "\u{1100}\u{116E}\u{11B4}"),
    ("\u{AD7A}", "\u{AD7A}", "\u{1100}\u{116E}\u{11B5}", "\u{AD7A}", "\u{1100}\u{116E}\u{11B5}"),
    ("\u{AD7B}", "\u{AD7B}", "\u{1100}\u{116E}\u{11B6}", "\u{AD7B}", "\u{1100}\u{116E}\u{11B6}"),
    ("\u{AD7C}", "\u{AD7C}", "\u{1100}\u{116E}\u{11B7}", "\u{AD7C}", "\u{1100}\u{116E}\u{11B7}"),
    ("\u{AD7D}", "\u{AD7D}", "\u{1100}\u{116E}\u{11B8}", "\u{AD7D}", "\u{1100}\u{116E}\u{11B8}"),
    ("\u{AD7E}", "\u{AD7E}", "\u{1100}\u{116E}\u{11B9}", "\u{AD7E}", "\u{1100}\u{116E}\u{11B9}"),
    ("\u{AD7F}", "\u{AD7F}", "\u{1100}\u{116E}\u{11BA}", "\u{AD7F}", "\u{1100}\u{116E}\u{11BA}"),
    ("\u{AD80}", "\u{AD80}", "\u{1100}\u{116E}\u{11BB}", "\u{AD80}", "\u{1100}\u{116E}\u{11BB}"),
    ("\u{AD81}", "\u{AD81}", "\u{1100}\u{116E}\u{11BC}", "\u{AD81}", "\u{1100}\u{116E}\u{11BC}"),
    ("\u{AD82}", "\u{AD82}", "\u{1100}\u{116E}\u{11BD}", "\u{AD82}", "\u{1100}\u{116E}\u{11BD}"),
    ("\u{AD83}", "\u{AD83}", "\u{1100}\u{116E}\u{11BE}", "\u{AD83}", "\u{1100}\u{116E}\u{11BE}"),
    ("\u{AD84}", "\u{AD84}", "\u{1100}\u{116E}\u{11BF}", "\u{AD84}", "\u{1100}\u{116E}\u{11BF}"),
    ("\u{AD85}", "\u{AD85}", "\u{1100}\u{116E}\u{11C0}", "\u{AD85}", "\u{1100}\u{116E}\u{11C0}"),
    ("\u{AD86}", "\u{AD86}", "\u{1100}\u{116E}\u{11C1}", "\u{AD86}", "\u{1100}\u{116E}\u{11C1}"),
    ("\u{AD87}", "\u{AD87}", "\u{1100}\u{116E}\u{11C2}", "\u{AD87}", "\u{1100}\u{116E}\u{11C2}"),
    ("\u{AD88}", "\u{AD88}", "\u{1100}\u{116F}", "\u{AD88}", "\u{1100}\u{116F}"),
    ("\u{AD89}", "\u{AD89}", "\u{1100}\u{116F}\u{11A8}", "\u{AD89}", "\u{1100}\u{116F}\u{11A8}"),
    ("\u{AD8A}", "\u{AD8A}", "\u{1100}\u{116F}\u{11A9}", "\u{AD8A}", "\u{1100}\u{116F}\u{11A9}"),
    ("\u{AD8B}", "\u{AD8B}", "\u{1100}\u{116F}\u{11AA}", "\u{AD8B}", "\u{1100}\u{116F}\u{11AA}"),
    ("\u{AD8C}", "\u{AD8C}", "\u{1100}\u{116F}\u{11AB}", "\u{AD8C}", "\u{1100}\u{116F}\u{11AB}"),
    ("\u{AD8D}", "\u{AD8D}", "\u{1100}\u{116F}\u{11AC}", "\u{AD8D}", "\u{1100}\u{116F}\u{11AC}"),
    ("\u{AD8E}", "\u{AD8E}", "\u{1100}\u{116F}\u{11AD}", "\u{AD8E}", "\u{1100}\u{116F}\u{11AD}"),
    ("\u{AD8F}", "\u{AD8F}", "\u{1100}\u{116F}\u{11AE}", "\u{AD8F}", "\u{1100}\u{116F}\u{11AE}"),
    ("\u{AD90}", "\u{AD90}", "\u{1100}\u{116F}\u{11AF}", "\u{AD90}", "\u{1100}\u{116F}\u{11AF}"),
    ("\u{AD91}", "\u{AD91}", "\u{1100}\u{116F}\u{11B0}", "\u{AD91}", "\u{1100}\u{116F}\u{11B0}"),
    ("\u{AD92}", "\u{AD92}", "\u{1100}\u{116F}\u{11B1}", "\u{AD92}", "\u{1100}\u{116F}\u{11B1}"),
    ("\u{AD93}", "\u{AD93}", "\u{1100}\u{116F}\u{11B2}", "\u{AD93}", "\u{1100}\u{116F}\u{11B2}"),
    ("\u{AD94}", "\u{AD94}", "\u{1100}\u{116F}\u{11B3}", "\u{AD94}", "\u{1100}\u{116F}\u{11B3}"),
    ("\u{AD95}", "\u{AD95}", "\u{1100}\u{116F}\u{11B4}", "\u{AD95}", "\u{1100}\u{116F}\u{11B4}"),
    ("\u{AD96}", "\u{AD96}", "\u{1100}\u{116F}\u{11B5}", "\u{AD96}", "\u{1100}\u{116F}\u{11B5}"),
    ("\u{AD97}", "\u{AD97}", "\u{1100}\u{116F}\u{11B6}", "\u{AD97}", "\u{1100}\u{116F}\u{11B6}"),
    ("\u{AD98}", "\u{AD98}", "\u{1100}\u{116F}\u{11B7}", "\u{AD98}", "\u{1100}\u{116F}\u{11B7}"),
    ("\u{AD99}", "\u{AD99}", "\u{1100}\u{116F}\u{11B8}", "\u{AD99}", "\u{1100}\u{116F}\u{11B8}"),
    ("\u{AD9A}", "\u{AD9A}", "\u{1100}\u{116F}\u{11B9}", "\u{AD9A}", "\u{1100}\u{116F}\u{11B9}"),
    ("\u{AD9B}", "\u{AD9B}", "\u{1100}\u{116F}\u{11BA}", "\u{AD9B}", "\u{1100}\u{116F}\u{11BA}"),
    ("\u{AD9C}", "\u{AD9C}", "\u{1100}\u{116F}\u{11BB}", "\u{AD9C}", "\u{1100}\u{116F}\u{11BB}"),
    ("\u{AD9D}", "\u{AD9D}", "\u{1100}\u{116F}\u{11BC}", "\u{AD9D}", "\u{1100}\u{116F}\u{11BC}"),
    ("\u{AD9E}", "\u{AD9E}", "\u{1100}\u{116F}\u{11BD}", "\u{AD9E}", "\u{1100}\u{116F}\u{11BD}"),
    ("\u{AD9F}", "\u{AD9F}", "\u{1100}\u{116F}\u{11BE}", "\u{AD9F}", "\u{1100}\u{116F}\u{11BE}"),
    ("\u{ADA0}", "\u{ADA0}", "\u{1100}\u{116F}\u{11BF}", "\u{ADA0}", "\u{1100}\u{116F}\u{11BF}"),
    ("\u{ADA1}", "\u{ADA1}", "\u{1100}\u{116F}\u{11C0}", "\u{ADA1}", "\u{1100}\u{116F}\u{11C0}"),
    ("\u{ADA2}", "\u{ADA2}", "\u{1100}\u{116F}\u{11C1}", "\u{ADA2}", "\u{1100}\u{116F}\u{11C1}"),
    ("\u{ADA3}", "\u{ADA3}", "\u{1100}\u{116F}\u{11C2}", "\u{ADA3}", "\u{1100}\u{116F}\u{11C2}"),
    ("\u{ADA4}", "\u{ADA4}", "\u{1100}\u{1170}", "\u{ADA4}", "\u{1100}\u{1170}"),
    ("\u{ADA5}", "\u{ADA5}", "\u{1100}\u{1170}\u{11A8}", "\u{ADA5}", "\u{1100}\u{1170}\u{11A8}"),
    ("\u{ADA6}", "\u{ADA6}", "\u{1100}\u{1170}\u{11A9}", "\u{ADA6}", "\u{1100}\u{1170}\u{11A9}"),
    ("\u{ADA7}", "\u{ADA7}", "\u{1100}\u{1170}\u{11AA}", "\u{ADA7}", "\u{1100}\u{1170}\u{11AA}"),
    ("\u{ADA8}", "\u{ADA8}", "\u{1100}\u{1170}\u{11AB}", "\u{ADA8}", "\u{1100}\u{1170}\u{11AB}"),
    ("\u{ADA9}", "\u{ADA9}", "\u{1100}\u{1170}\u{11AC}", "\u{ADA9}", "\u{1100}\u{1170}\u{11AC}"),
    ("\u{ADAA}", "\u{ADAA}", "\u{1100}\u{1170}\u{11AD}", "\u{ADAA}", "\u{1100}\u{1170}\u{11AD}"),
    ("\u{ADAB}", "\u{ADAB}", "\u{1100}\u{1170}\u{11AE}", "\u{ADAB}", "\u{1100}\u{1170}\u{11AE}"),
    ("\u{ADAC}", "\u{ADAC}", "\u{1100}\u{1170}\u{11AF}", "\u{ADAC}", "\u{1100}\u{1170}\u{11AF}"),
    ("\u{ADAD}", "\u{ADAD}", "\u{1100}\u{1170}\u{11B0}", "\u{ADAD}", "\u{1100}\u{1170}\u{11B0}"),
    ("\u{ADAE}", "\u{ADAE}", "\u{1100}\u{1170}\u{11B1}", "\u{ADAE}", "\u{1100}\u{1170}\u{11B1}"),
    ("\u{ADAF}", "\u{ADAF}", "\u{1100}\u{1170}\u{11B2}", "\u{ADAF}", "\u{1100}\u{1170}\u{11B2}"),
    ("\u{ADB0}", "\u{ADB0}", "\u{1100}\u{1170}\u{11B3}", "\u{ADB0}", "\u{1100}\u{1170}\u{11B3}"),
    ("\u{ADB1}", "\u{ADB1}", "\u{1100}\u{1170}\u{11B4}", "\u{ADB1}", "\u{1100}\u{1170}\u{11B4}"),
    ("\u{ADB2}", "\u{ADB2}", "\u{1100}\u{1170}\u{11B5}", "\u{ADB2}", "\u{1100}\u{1170}\u{11B5}"),
    ("\u{ADB3}", "\u{ADB3}", "\u{1100}\u{1170}\u{11B6}", "\u{ADB3}", "\u{1100}\u{1170}\u{11B6}"),
    ("\u{ADB4}", "\u{ADB4}", "\u{1100}\u{1170}\u{11B7}", "\u{ADB4}", "\u{1100}\u{1170}\u{11B7}"),
    ("\u{ADB5}", "\u{ADB5}", "\u{1100}\u{1170}\u{11B8}", "\u{ADB5}", "\u{1100}\u{1170}\u{11B8}"),
    ("\u{ADB6}", "\u{ADB6}", "\u{1100}\u{1170}\u{11B9}", "\u{ADB6}", "\u{1100}\u{1170}\u{11B9}"),
    ("\u{ADB7}", "\u{ADB7}", "\u{1100}\u{1170}\u{11BA}", "\u{ADB7}", "\u{1100}\u{1170}\u{11BA}"),
    ("\u{ADB8}", "\u{ADB8}", "\u{1100}\u{1170}\u{11BB}", "\u{ADB8}", "\u{1100}\u{1170}\u{11BB}"),
    ("\u{ADB9}", "\u{ADB9}", "\u{1100}\u{1170}\u{11BC}", "\u{ADB9}", "\u{1100}\u{1170}\u{11BC}"),
    ("\u{ADBA}", "\u{ADBA}", "\u{1100}\u{1170}\u{11BD}", "\u{ADBA}", "\u{1100}\u{1170}\u{11BD}"),
    ("\u{ADBB}", "\u{ADBB}", "\u{1100}\u{1170}\u{11BE}", "\u{ADBB}", "\u{1100}\u{1170}\u{11BE}"),
    ("\u{ADBC}", "\u{ADBC}", "\u{1100}\u{1170}\u{11BF}", "\u{ADBC}", "\u{1100}\u{1170}\u{11BF}"),
    ("\u{ADBD}", "\u{ADBD}", "\u{1100}\u{1170}\u{11C0}", "\u{ADBD}", "\u{1100}\u{1170}\u{11C0}"),
    ("\u{ADBE}", "\u{ADBE}", "\u{1100}\u{1170}\u{11C1}", "\u{ADBE}", "\u{1100}\u{1170}\u{11C1}"),
    ("\u{ADBF}", "\u{ADBF}", "\u{1100}\u{1170}\u{11C2}", "\u{ADBF}", "\u{1100}\u{1170}\u{11C2}"),
    ("\u{ADC0}", "\u{ADC0}", "\u{1100}\u{1171}", "\u{ADC0}", "\u{1100}\u{1171}"),
    ("\u{ADC1}", "\u{ADC1}", "\u{1100}\u{1171}\u{11A8}", "\u{ADC1}", "\u{1100}\u{1171}\u{11A8}"),
    ("\u{ADC2}", "\u{ADC2}", "\u{1100}\u{1171}\u{11A9}", "\u{ADC2}", "\u{1100}\u{1171}\u{11A9}"),
    ("\u{ADC3}", "\u{ADC3}", "\u{1100}\u{1171}\u{11AA}", "\u{ADC3}", "\u{1100}\u{1171}\u{11AA}"),
    ("\u{ADC4}", "\u{ADC4}", "\u{1100}\u{1171}\u{11AB}", "\u{ADC4}", "\u{1100}\u{1171}\u{11AB}"),
    ("\u{ADC5}", "\u{ADC5}", "\u{1100}\u{1171}\u{11AC}", "\u{ADC5}", "\u{1100}\u{1171}\u{11AC}"),
    ("\u{ADC6}", "\u{ADC6}", "\u{1100}\u{1171}\u{11AD}", "\u{ADC6}", "\u{1100}\u{1171}\u{11AD}"),
    ("\u{ADC7}", "\u{ADC7}", "\u{1100}\u{1171}\u{11AE}", "\u{ADC7}", "\u{1100}\u{1171}\u{11AE}"),
    ("\u{ADC8}", "\u{ADC8}", "\u{1100}\u{1171}\u{11AF}", "\u{ADC8}", "\u{1100}\u{1171}\u{11AF}"),
    ("\u{ADC9}", "\u{ADC9}", "\u{1100}\u{1171}\u{11B0}", "\u{ADC9}", "\u{1100}\u{1171}\u{11B0}"),
    ("\u{ADCA}", "\u{ADCA}", "\u{1100}\u{1171}\u{11B1}", "\u{ADCA}", "\u{1100}\u{1171}\u{11B1}"),
    ("\u{ADCB}", "\u{ADCB}", "\u{1100}\u{1171}\u{11B2}", "\u{ADCB}", "\u{1100}\u{1171}\u{11B2}"),
    ("\u{ADCC}", "\u{ADCC}", "\u{1100}\u{1171}\u{11B3}", "\u{ADCC}", "\u{1100}\u{1171}\u{11B3}"),
    ("\u{ADCD}", "\u{ADCD}", "\u{1100}\u{1171}\u{11B4}", "\u{ADCD}", "\u{1100}\u{1171}\u{11B4}"),
    ("\u{ADCE}", "\u{ADCE}", "\u{1100}\u{1171}\u{11B5}", "\u{ADCE}", "\u{1100}\u{1171}\u{11B5}"),
    ("\u{ADCF}", "\u{ADCF}", "\u{1100}\u{1171}\u{11B6}", "\u{ADCF}", "\u{1100}\u{1171}\u{11B6}"),
    ("\u{ADD0}", "\u{ADD0}", "\u{1100}\u{1171}\u{11B7}", "\u{ADD0}", "\u{1100}\u{1171}\u{11B7}"),
    ("\u{ADD1}", "\u{ADD1}", "\u{1100}\u{1171}\u{11B8}", "\u{ADD1}", "\u{1100}\u{1171}\u{11B8}"),
    ("\u{ADD2}", "\u{ADD2}", "\u{1100}\u{1171}\u{11B9}", "\u{ADD2}", "\u{1100}\u{1171}\u{11B9}"),
    ("\u{ADD3}", "\u{ADD3}", "\u{1100}\u{1171}\u{11BA}", "\u{ADD3}", "\u{1100}\u{1171}\u{11BA}"),
    ("\u{ADD4}", "\u{ADD4}", "\u{1100}\u{1171}\u{11BB}", "\u{ADD4}", "\u{1100}\u{1171}\u{11BB}"),
    ("\u{ADD5}", "\u{ADD5}", "\u{1100}\u{1171}\u{11BC}", "\u{ADD5}", "\u{1100}\u{1171}\u{11BC}"),
    ("\u{ADD6}", "\u{ADD6}", "\u{1100}\u{1171}\u{11BD}", "\u{ADD6}", "\u{1100}\u{1171}\u{11BD}"),
    ("\u{ADD7}", "\u{ADD7}", "\u{1100}\u{1171}\u{11BE}", "\u{ADD7}", "\u{1100}\u{1171}\u{11BE}"),
    ("\u{ADD8}", "\u{ADD8}", "\u{1100}\u{1171}\u{11BF}", "\u{ADD8}", "\u{1100}\u{1171}\u{11BF}"),
    ("\u{ADD9}", "\u{ADD9}", "\u{1100}\u{1171}\u{11C0}", "\u{ADD9}", "\u{1100}\u{1171}\u{11C0}"),
    ("\u{ADDA}", "\u{ADDA}", "\u{1100}\u{1171}\u{11C1}", "\u{ADDA}", "\u{1100}\u{1171}\u{11C1}"),
    ("\u{ADDB}", "\u{ADDB}", "\u{1100}\u{1171}\u{11C2}", "\u{ADDB}", "\u{1100}\u{1171}\u{11C2}"),
    ("\u{ADDC}", "\u{ADDC}", "\u{1100}\u{1172}", "\u{ADDC}", "\u{1100}\u{1172}"),
    ("\u{ADDD}", "\u{ADDD}", "\u{1100}\u{1172}\u{11A8}", "\u{ADDD}", "\u{1100}\u{1172}\u{11A8}"),
    ("\u{ADDE}", "\u{ADDE}", "\u{1100}\u{1172}\u{11A9}", "\u{ADDE}", "\u{1100}\u{1172}\u{11A9}"),
    ("\u{ADDF}", "\u{ADDF}", "\u{1100}\u{1172}\u{11AA}", "\u{ADDF}", "\u{1100}\u{1172}\u{11AA}"),
    ("\u{ADE0}", "\u{ADE0}", "\u{1100}\u{1172}\u{11AB}", "\u{ADE0}", "\u{1100}\u{1172}\u{11AB}"),
    ("\u{ADE1}", "\u{ADE1}", "\u{1100}\u{1172}\u{11AC}", "\u{ADE1}", "\u{1100}\u{1172}\u{11AC}"),
    ("\u{ADE2}", "\u{ADE2}", "\u{1100}\u{1172}\u{11AD}", "\u{ADE2}", "\u{1100}\u{1172}\u{11AD}"),
    ("\u{ADE3}", "\u{ADE3}", "\u{1100}\u{1172}\u{11AE}", "\u{ADE3}", "\u{1100}\u{1172}\u{11AE}"),
    ("\u{ADE4}", "\u{ADE4}", "\u{1100}\u{1172}\u{11AF}", "\u{ADE4}", "\u{1100}\u{1172}\u{11AF}"),
    ("\u{ADE5}", "\u{ADE5}", "\u{1100}\u{1172}\u{11B0}", "\u{ADE5}", "\u{1100}\u{1172}\u{11B0}"),
    ("\u{ADE6}", "\u{ADE6}", "\u{1100}\u{1172}\u{11B1}", "\u{ADE6}", "\u{1100}\u{1172}\u{11B1}"),
    ("\u{ADE7}", "\u{ADE7}", "\u{1100}\u{1172}\u{11B2}", "\u{ADE7}", "\u{1100}\u{1172}\u{11B2}"),
    ("\u{ADE8}", "\u{ADE8}", "\u{1100}\u{1172}\u{11B3}", "\u{ADE8}", "\u{1100}\u{1172}\u{11B3}"),
    ("\u{ADE9}", "\u{ADE9}", "\u{1100}\u{1172}\u{11B4}", "\u{ADE9}", "\u{1100}\u{1172}\u{11B4}"),
    ("\u{ADEA}", "\u{ADEA}", "\u{1100}\u{1172}\u{11B5}", "\u{ADEA}", "\u{1100}\u{1172}\u{11B5}"),
    ("\u{ADEB}", "\u{ADEB}", "\u{1100}\u{1172}\u{11B6}", "\u{ADEB}", "\u{1100}\u{1172}\u{11B6}"),
    ("\u{ADEC}", "\u{ADEC}", "\u{1100}\u{1172}\u{11B7}", "\u{ADEC}", "\u{1100}\u{1172}\u{11B7}"),
    ("\u{ADED}", "\u{ADED}", "\u{1100}\u{1172}\u{11B8}", "\u{ADED}", "\u{1100}\u{1172}\u{11B8}"),
    ("\u{ADEE}", "\u{ADEE}", "\u{1100}\u{1172}\u{11B9}", "\u{ADEE}", "\u{1100}\u{1172}\u{11B9}"),
    ("\u{ADEF}", "\u{ADEF}", "\u{1100}\u{1172}\u{11BA}", "\u{ADEF}", "\u{1100}\u{1172}\u{11BA}"),
    ("\u{ADF0}", "\u{ADF0}", "\u{1100}\u{1172}\u{11BB}", "\u{ADF0}", "\u{1100}\u{1172}\u{11BB}"),
    ("\u{ADF1}", "\u{ADF1}", "\u{1100}\u{1172}\u{11BC}", "\u{ADF1}", "\u{1100}\u{1172}\u{11BC}"),
    ("\u{ADF2}", "\u{ADF2}", "\u{1100}\u{1172}\u{11BD}", "\u{ADF2}", "\u{1100}\u{1172}\u{11BD}"),
    ("\u{ADF3}", "\u{ADF3}", "\u{1100}\u{1172}\u{11BE}", "\u{ADF3}", "\u{1100}\u{1172}\u{11BE}"),
    ("\u{ADF4}", "\u{ADF4}", "\u{1100}\u{1172}\u{11BF}", "\u{ADF4}", "\u{1100}\u{1172}\u{11BF}"),
    ("\u{ADF5}", "\u{ADF5}", "\u{1100}\u{1172}\u{11C0}", "\u{ADF5}", "\u{1100}\u{1172}\u{11C0}"),
    ("\u{ADF6}", "\u{ADF6}", "\u{1100}\u{1172}\u{11C1}", "\u{ADF6}", "\u{1100}\u{1172}\u{11C1}"),
    ("\u{ADF7}", "\u{ADF7}", "\u{1100}\u{1172}\u{11C2}", "\u{ADF7}", "\u{1100}\u{1172}\u{11C2}"),
    ("\u{ADF8}", "\u{ADF8}", "\u{1100}\u{1173}", "\u{ADF8}", "\u{1100}\u{1173}"),
    ("\u{ADF9}", "\u{ADF9}", "\u{1100}\u{1173}\u{11A8}", "\u{ADF9}", "\u{1100}\u{1173}\u{11A8}"),
    ("\u{ADFA}", "\u{ADFA}", "\u{1100}\u{1173}\u{11A9}", "\u{ADFA}", "\u{1100}\u{1173}\u{11A9}"),
    ("\u{ADFB}", "\u{ADFB}", "\u{1100}\u{1173}\u{11AA}", "\u{ADFB}", "\u{1100}\u{1173}\u{11AA}"),
    ("\u{ADFC}", "\u{ADFC}", "\u{1100}\u{1173}\u{11AB}", "\u{ADFC}", "\u{1100}\u{1173}\u{11AB}"),
    ("\u{ADFD}", "\u{ADFD}", "\u{1100}\u{1173}\u{11AC}", "\u{ADFD}", "\u{1100}\u{1173}\u{11AC}"),
    ("\u{ADFE}", "\u{ADFE}", "\u{1100}\u{1173}\u{11AD}", "\u{ADFE}", "\u{1100}\u{1173}\u{11AD}"),
    ("\u{ADFF}", "\u{ADFF}", "\u{1100}\u{1173}\u{11AE}", "\u{ADFF}", "\u{1100}\u{1173}\u{11AE}"),
    ("\u{AE00}", "\u{AE00}", "\u{1100}\u{1173}\u{11AF}", "\u{AE00}", "\u{1100}\u{1173}\u{11AF}"),
    ("\u{AE01}", "\u{AE01}", "\u{1100}\u{1173}\u{11B0}", "\u{AE01}", "\u{1100}\u{1173}\u{11B0}"),
    ("\u{AE02}", "\u{AE02}", "\u{1100}\u{1173}\u{11B1}", "\u{AE02}", "\u{1100}\u{1173}\u{11B1}"),
    ("\u{AE03}", "\u{AE03}", "\u{1100}\u{1173}\u{11B2}", "\u{AE03}", "\u{1100}\u{1173}\u{11B2}"),
    ("\u{AE04}", "\u{AE04}", "\u{1100}\u{1173}\u{11B3}", "\u{AE04}", "\u{1100}\u{1173}\u{11B3}"),
    ("\u{AE05}", "\u{AE05}", "\u{1100}\u{1173}\u{11B4}", "\u{AE05}", "\u{1100}\u{1173}\u{11B4}"),
    ("\u{AE06}", "\u{AE06}", "\u{1100}\u{1173}\u{11B5}", "\u{AE06}", "\u{1100}\u{1173}\u{11B5}"),
    ("\u{AE07}", "\u{AE07}", "\u{1100}\u{1173}\u{11B6}", "\u{AE07}", "\u{1100}\u{1173}\u{11B6}"),
    ("\u{AE08}", "\u{AE08}", "\u{1100}\u{1173}\u{11B7}", "\u{AE08}", "\u{1100}\u{1173}\u{11B7}"),
    ("\u{AE09}", "\u{AE09}", "\u{1100}\u{1173}\u{11B8}", "\u{AE09}", "\u{1100}\u{1173}\u{11B8}"),
    ("\u{AE0A}", "\u{AE0A}", "\u{1100}\u{1173}\u{11B9}", "\u{AE0A}", "\u{1100}\u{1173}\u{11B9}"),
    ("\u{AE0B}", "\u{AE0B}", "\u{1100}\u{1173}\u{11BA}", "\u{AE0B}", "\u{1100}\u{1173}\u{11BA}"),
    ("\u{AE0C}", "\u{AE0C}", "\u{1100}\u{1173}\u{11BB}", "\u{AE0C}", "\u{1100}\u{1173}\u{11BB}"),
    ("\u{AE0D}", "\u{AE0D}", "\u{1100}\u{1173}\u{11BC}", "\u{AE0D}", "\u{1100}\u{1173}\u{11BC}"),
    ("\u{AE0E}", "\u{AE0E}", "\u{1100}\u{1173}\u{11BD}", "\u{AE0E}", "\u{1100}\u{1173}\u{11BD}"),
    ("\u{AE0F}", "\u{AE0F}", "\u{1100}\u{1173}\u{11BE}", "\u{AE0F}", "\u{1100}\u{1173}\u{11BE}"),
    ("\u{AE10}", "\u{AE10}", "\u{1100}\u{1173}\u{11BF}", "\u{AE10}", "\u{1100}\u{1173}\u{11BF}"),
    ("\u{AE11}", "\u{AE11}", "\u{1100}\u{1173}\u{11C0}", "\u{AE11}", "\u{1100}\u{1173}\u{11C0}"),
    ("\u{AE12}", "\u{AE12}", "\u{1100}\u{1173}\u{11C1}", "\u{AE12}", "\u{1100}\u{1173}\u{11C1}"),
    ("\u{AE13}", "\u{AE13}", "\u{1100}\u{1173}\u{11C2}", "\u{AE13}", "\u{1100}\u{1173}\u{11C2}"),
    ("\u{AE14}", "\u{AE14}", "\u{1100}\u{1174}", "\u{AE14}", "\u{1100}\u{1174}"),
    ("\u{AE15}", "\u{AE15}", "\u{1100}\u{1174}\u{11A8}", "\u{AE15}", "\u{1100}\u{1174}\u{11A8}"),
    ("\u{AE16}", "\u{AE16}", "\u{1100}\u{1174}\u{11A9}", "\u{AE16}", "\u{1100}\u{1174}\u{11A9}"),
    ("\u{AE17}", "\u{AE17}", "\u{1100}\u{1174}\u{11AA}", "\u{AE17}", "\u{1100}\u{1174}\u{11AA}"),
    ("\u{AE18}", "\u{AE18}", "\u{1100}\u{1174}\u{11AB}", "\u{AE18}", "\u{1100}\u{1174}\u{11AB}"),
    ("\u{AE19}", "\u{AE19}", "\u{1100}\u{1174}\u{11AC}", "\u{AE19}", "\u{1100}\u{1174}\u{11AC}"),
    ("\u{AE1A}", "\u{AE1A}", "\u{1100}\u{1174}\u{11AD}", "\u{AE1A}", "\u{1100}\u{1174}\u{11AD}"),
    ("\u{AE1B}", "\u{AE1B}", "\u{1100}\u{1174}\u{11AE}", "\u{AE1B}", "\u{1100}\u{1174}\u{11AE}"),
    ("\u{AE1C}", "\u{AE1C}", "\u{1100}\u{1174}\u{11AF}", "\u{AE1C}", "\u{1100}\u{1174}\u{11AF}"),
    ("\u{AE1D}", "\u{AE1D}", "\u{1100}\u{1174}\u{11B0}", "\u{AE1D}", "\u{1100}\u{1174}\u{11B0}"),
    ("\u{AE1E}", "\u{AE1E}", "\u{1100}\u{1174}\u{11B1}", "\u{AE1E}", "\u{1100}\u{1174}\u{11B1}"),
    ("\u{AE1F}", "\u{AE1F}", "\u{1100}\u{1174}\u{11B2}", "\u{AE1F}", "\u{1100}\u{1174}\u{11B2}"),
    ("\u{AE20}", "\u{AE20}", "\u{1100}\u{1174}\u{11B3}", "\u{AE20}", "\u{1100}\u{1174}\u{11B3}"),
    ("\u{AE21}", "\u{AE21}", "\u{1100}\u{1174}\u{11B4}", "\u{AE21}", "\u{1100}\u{1174}\u{11B4}"),
    ("\u{AE22}", "\u{AE22}", "\u{1100}\u{1174}\u{11B5}", "\u{AE22}", "\u{1100}\u{1174}\u{11B5}"),
    ("\u{AE23}", "\u{AE23}", "\u{1100}\u{1174}\u{11B6}", "\u{AE23}", "\u{1100}\u{1174}\u{11B6}"),
    ("\u{AE24}", "\u{AE24}", "\u{1100}\u{1174}\u{11B7}", "\u{AE24}", "\u{1100}\u{1174}\u{11B7}"),
    ("\u{AE25}", "\u{AE25}", "\u{1100}\u{1174}\u{11B8}", "\u{AE25}", "\u{1100}\u{1174}\u{11B8}"),
    ("\u{AE26}", "\u{AE26}", "\u{1100}\u{1174}\u{11B9}", "\u{AE26}", "\u{1100}\u{1174}\u{11B9}"),
    ("\u{AE27}", "\u{AE27}", "\u{1100}\u{1174}\u{11BA}", "\u{AE27}", "\u{1100}\u{1174}\u{11BA}"),
    ("\u{AE28}", "\u{AE28}", "\u{1100}\u{1174}\u{11BB}", "\u{AE28}", "\u{1100}\u{1174}\u{11BB}"),
    ("\u{AE29}", "\u{AE29}", "\u{1100}\u{1174}\u{11BC}", "\u{AE29}", "\u{1100}\u{1174}\u{11BC}"),
    ("\u{AE2A}", "\u{AE2A}", "\u{1100}\u{1174}\u{11BD}", "\u{AE2A}", "\u{1100}\u{1174}\u{11BD}"),
    ("\u{AE2B}", "\u{AE2B}", "\u{1100}\u{1174}\u{11BE}", "\u{AE2B}", "\u{1100}\u{1174}\u{11BE}"),
    ("\u{AE2C}", "\u{AE2C}", "\u{1100}\u{1174}\u{11BF}", "\u{AE2C}", "\u{1100}\u{1174}\u{11BF}"),
    ("\u{AE2D}", "\u{AE2D}", "\u{1100}\u{1174}\u{11C0}", "\u{AE2D}", "\u{1100}\u{1174}\u{11C0}"),
    ("\u{AE2E}", "\u{AE2E}", "\u{1100}\u{1174}\u{11C1}", "\u{AE2E}", "\u{1100}\u{1174}\u{11C1}"),
    ("\u{AE2F}", "\u{AE2F}", "\u{1100}\u{1174}\u{11C2}", "\u{AE2F}", "\u{1100}\u{1174}\u{11C2}"),
    ("\u{AE30}", "\u{AE30}", "\u{1100}\u{1175}", "\u{AE30}", "\u{1100}\u{1175}"),
    ("\u{AE31}", "\u{AE31}", "\u{1100}\u{1175}\u{11A8}", "\u{AE31}", "\u{1100}\u{1175}\u{11A8}"),
    ("\u{AE32}", "\u{AE32}", "\u{1100}\u{1175}\u{11A9}", "\u{AE32}", "\u{1100}\u{1175}\u{11A9}"),
    ("\u{AE33}", "\u{AE33}", "\u{1100}\u{1175}\u{11AA}", "\u{AE33}", "\u{1100}\u{1175}\u{11AA}"),
    ("\u{AE34}", "\u{AE34}", "\u{1100}\u{1175}\u{11AB}", "\u{AE34}", "\u{1100}\u{1175}\u{11AB}"),
    ("\u{AE35}", "\u{AE35}", "\u{1100}\u{1175}\u{11AC}", "\u{AE35}", "\u{1100}\u{1175}\u{11AC}"),
    ("\u{AE36}", "\u{AE36}", "\u{1100}\u{1175}\u{11AD}", "\u{AE36}", "\u{1100}\u{1175}\u{11AD}"),
    ("\u{AE37}", "\u{AE37}", "\u{1100}\u{1175}\u{11AE}", "\u{AE37}", "\u{1100}\u{1175}\u{11AE}"),
    ("\u{AE38}", "\u{AE38}", "\u{1100}\u{1175}\u{11AF}", "\u{AE38}", "\u{1100}\u{1175}\u{11AF}"),
    ("\u{AE39}", "\u{AE39}", "\u{1100}\u{1175}\u{11B0}", "\u{AE39}", "\u{1100}\u{1175}\u{11B0}"),
    ("\u{AE3A}", "\u{AE3A}", "\u{1100}\u{1175}\u{11B1}", "\u{AE3A}", "\u{1100}\u{1175}\u{11B1}"),
    ("\u{AE3B}", "\u{AE3B}", "\u{1100}\u{1175}\u{11B2}", "\u{AE3B}", "\u{1100}\u{1175}\u{11B2}"),
    ("\u{AE3C}", "\u{AE3C}", "\u{1100}\u{1175}\u{11B3}", "\u{AE3C}", "\u{1100}\u{1175}\u{11B3}"),
    ("\u{AE3D}", "\u{AE3D}", "\u{1100}\u{1175}\u{11B4}", "\u{AE3D}", "\u{1100}\u{1175}\u{11B4}"),
    ("\u{AE3E}", "\u{AE3E}", "\u{1100}\u{1175}\u{11B5}", "\u{AE3E}", "\u{1100}\u{1175}\u{11B5}"),
    ("\u{AE3F}", "\u{AE3F}", "\u{1100}\u{1175}\u{11B6}", "\u{AE3F}", "\u{1100}\u{1175}\u{11B6}"),
    ("\u{AE40}", "\u{AE40}", "\u{1100}\u{1175}\u{11B7}", "\u{AE40}", "\u{1100}\u{1175}\u{11B7}"),
    ("\u{AE41}", "\u{AE41}", "\u{1100}\u{1175}\u{11B8}", "\u{AE41}", "\u{1100}\u{1175}\u{11B8}"),
    ("\u{AE42}", "\u{AE42}", "\u{1100}\u{1175}\u{11B9}", "\u{AE42}", "\u{1100}\u{1175}\u{11B9}"),
    ("\u{AE43}", "\u{AE43}", "\u{1100}\u{1175}\u{11BA}", "\u{AE43}", "\u{1100}\u{1175}\u{11BA}"),
    ("\u{AE44}", "\u{AE44}", "\u{1100}\u{1175}\u{11BB}", "\u{AE44}", "\u{1100}\u{1175}\u{11BB}"),
    ("\u{AE45}", "\u{AE45}", "\u{1100}\u{1175}\u{11BC}", "\u{AE45}", "\u{1100}\u{1175}\u{11BC}"),
    ("\u{AE46}", "\u{AE46}", "\u{1100}\u{1175}\u{11BD}", "\u{AE46}", "\u{1100}\u{1175}\u{11BD}"),
    ("\u{AE47}", "\u{AE47}", "\u{1100}\u{1175}\u{11BE}", "\u{AE47}", "\u{1100}\u{1175}\u{11BE}"),
    ("\u{AE48}", "\u{AE48}", "\u{1100}\u{1175}\u{11BF}", "\u{AE48}", "\u{1100}\u{1175}\u{11BF}"),
    ("\u{AE49}", "\u{AE49}", "\u{1100}\u{1175}\u{11C0}", "\u{AE49}", "\u{1100}\u{1175}\u{11C0}"),
    ("\u{AE4A}", "\u{AE4A}", "\u{1100}\u{1175}\u{11C1}", "\u{AE4A}", "\u{1100}\u{1175}\u{11C1}"),
    ("\u{AE4B}", "\u{AE4B}", "\u{1100}\u{1175}\u{11C2}", "\u{AE4B}", "\u{1100}\u{1175}\u{11C2}"),
    ("\u{AE4C}", "\u{AE4C}", "\u{1101}\u{1161}", "\u{AE4C}", "\u{1101}\u{1161}"),
    ("\u{AE4D}", "\u{AE4D}", "\u{1101}\u{1161}\u{11A8}", "\u{AE4D}", "\u{1101}\u{1161}\u{11A8}"),
    ("\u{AE4E}", "\u{AE4E}", "\u{1101}\u{1161}\u{11A9}", "\u{AE4E}", "\u{1101}\u{1161}\u{11A9}"),
    ("\u{AE4F}", "\u{AE4F}", "\u{1101}\u{1161}\u{11AA}", "\u{AE4F}", "\u{1101}\u{1161}\u{11AA}"),
    ("\u{AE50}", "\u{AE50}", "\u{1101}\u{1161}\u{11AB}", "\u{AE50}", "\u{1101}\u{1161}\u{11AB}"),
    ("\u{AE51}", "\u{AE51}", "\u{1101}\u{1161}\u{11AC}", "\u{AE51}", "\u{1101}\u{1161}\u{11AC}"),
    ("\u{AE52}", "\u{AE52}", "\u{1101}\u{1161}\u{11AD}", "\u{AE52}", "\u{1101}\u{1161}\u{11AD}"),
    ("\u{AE53}", "\u{AE53}", "\u{1101}\u{1161}\u{11AE}", "\u{AE53}", "\u{1101}\u{1161}\u{11AE}"),
    ("\u{AE54}", "\u{AE54}", "\u{1101}\u{1161}\u{11AF}", "\u{AE54}", "\u{1101}\u{1161}\u{11AF}"),
    ("\u{AE55}", "\u{AE55}", "\u{1101}\u{1161}\u{11B0}", "\u{AE55}", "\u{1101}\u{1161}\u{11B0}"),
    ("\u{AE56}", "\u{AE56}", "\u{1101}\u{1161}\u{11B1}", "\u{AE56}", "\u{1101}\u{1161}\u{11B1}"),
    ("\u{AE57}", "\u{AE57}", "\u{1101}\u{1161}\u{11B2}", "\u{AE57}", "\u{1101}\u{1161}\u{11B2}"),
    ("\u{AE58}", "\u{AE58}", "\u{1101}\u{1161}\u{11B3}", "\u{AE58}", "\u{1101}\u{1161}\u{11B3}"),
    ("\u{AE59}", "\u{AE59}", "\u{1101}\u{1161}\u{11B4}", "\u{AE59}", "\u{1101}\u{1161}\u{11B4}"),
    ("\u{AE5A}", "\u{AE5A}", "\u{1101}\u{1161}\u{11B5}", "\u{AE5A}", "\u{1101}\u{1161}\u{11B5}"),
    ("\u{AE5B}", "\u{AE5B}", "\u{1101}\u{1161}\u{11B6}", "\u{AE5B}", "\u{1101}\u{1161}\u{11B6}"),
    ("\u{AE5C}", "\u{AE5C}", "\u{1101}\u{1161}\u{11B7}", "\u{AE5C}", "\u{1101}\u{1161}\u{11B7}"),
    ("\u{AE5D}", "\u{AE5D}", "\u{1101}\u{1161}\u{11B8}", "\u{AE5D}", "\u{1101}\u{1161}\u{11B8}"),
    ("\u{AE5E}", "\u{AE5E}", "\u{1101}\u{1161}\u{11B9}", "\u{AE5E}", "\u{1101}\u{1161}\u{11B9}"),
    ("\u{AE5F}", "\u{AE5F}", "\u{1101}\u{1161}\u{11BA}", "\u{AE5F}", "\u{1101}\u{1161}\u{11BA}"),
    ("\u{AE60}", "\u{AE60}", "\u{1101}\u{1161}\u{11BB}", "\u{AE60}", "\u{1101}\u{1161}\u{11BB}"),
    ("\u{AE61}", "\u{AE61}", "\u{1101}\u{1161}\u{11BC}", "\u{AE61}", "\u{1101}\u{1161}\u{11BC}"),
    ("\u{AE62}", "\u{AE62}", "\u{1101}\u{1161}\u{11BD}", "\u{AE62}", "\u{1101}\u{1161}\u{11BD}"),
    ("\u{AE63}", "\u{AE63}", "\u{1101}\u{1161}\u{11BE}", "\u{AE63}", "\u{1101}\u{1161}\u{11BE}"),
    ("\u{AE64}", "\u{AE64}", "\u{1101}\u{1161}\u{11BF}", "\u{AE64}", "\u{1101}\u{1161}\u{11BF}"),
    ("\u{AE65}", "\u{AE65}", "\u{1101}\u{1161}\u{11C0}", "\u{AE65}", "\u{1101}\u{1161}\u{11C0}"),
    ("\u{AE66}", "\u{AE66}", "\u{1101}\u{1161}\u{11C1}", "\u{AE66}", "\u{1101}\u{1161}\u{11C1}"),
    ("\u{AE67}", "\u{AE67}", "\u{1101}\u{1161}\u{11C2}", "\u{AE67}", "\u{1101}\u{1161}\u{11C2}"),
    ("\u{AE68}", "\u{AE68}", "\u{1101}\u{1162}", "\u{AE68}", "\u{1101}\u{1162}"),
    ("\u{AE69}", "\u{AE69}", "\u{1101}\u{1162}\u{11A8}", "\u{AE69}", "\u{1101}\u{1162}\u{11A8}"),
    ("\u{AE6A}", "\u{AE6A}", "\u{1101}\u{1162}\u{11A9}", "\u{AE6A}", "\u{1101}\u{1162}\u{11A9}"),
    ("\u{AE6B}", "\u{AE6B}", "\u{1101}\u{1162}\u{11AA}", "\u{AE6B}", "\u{1101}\u{1162}\u{11AA}"),
    ("\u{AE6C}", "\u{AE6C}", "\u{1101}\u{1162}\u{11AB}", "\u{AE6C}", "\u{1101}\u{1162}\u{11AB}"),
    ("\u{AE6D}", "\u{AE6D}", "\u{1101}\u{1162}\u{11AC}", "\u{AE6D}", "\u{1101}\u{1162}\u{11AC}"),
    ("\u{AE6E}", "\u{AE6E}", "\u{1101}\u{1162}\u{11AD}", "\u{AE6E}", "\u{1101}\u{1162}\u{11AD}"),
    ("\u{AE6F}", "\u{AE6F}", "\u{1101}\u{1162}\u{11AE}", "\u{AE6F}", "\u{1101}\u{1162}\u{11AE}"),
    ("\u{AE70}", "\u{AE70}", "\u{1101}\u{1162}\u{11AF}", "\u{AE70}", "\u{1101}\u{1162}\u{11AF}"),
    ("\u{AE71}", "\u{AE71}", "\u{1101}\u{1162}\u{11B0}", "\u{AE71}", "\u{1101}\u{1162}\u{11B0}"),
    ("\u{AE72}", "\u{AE72}", "\u{1101}\u{1162}\u{11B1}", "\u{AE72}", "\u{1101}\u{1162}\u{11B1}"),
    ("\u{AE73}", "\u{AE73}", "\u{1101}\u{1162}\u{11B2}", "\u{AE73}", "\u{1101}\u{1162}\u{11B2}"),
    ("\u{AE74}", "\u{AE74}", "\u{1101}\u{1162}\u{11B3}", "\u{AE74}", "\u{1101}\u{1162}\u{11B3}"),
    ("\u{AE75}", "\u{AE75}", "\u{1101}\u{1162}\u{11B4}", "\u{AE75}", "\u{1101}\u{1162}\u{11B4}"),
    ("\u{AE76}", "\u{AE76}", "\u{1101}\u{1162}\u{11B5}", "\u{AE76}", "\u{1101}\u{1162}\u{11B5}"),
    ("\u{AE77}", "\u{AE77}", "\u{1101}\u{1162}\u{11B6}", "\u{AE77}", "\u{1101}\u{1162}\u{11B6}"),
    ("\u{AE78}", "\u{AE78}", "\u{1101}\u{1162}\u{11B7}", "\u{AE78}", "\u{1101}\u{1162}\u{11B7}"),
    ("\u{AE79}", "\u{AE79}", "\u{1101}\u{1162}\u{11B8}", "\u{AE79}", "\u{1101}\u{1162}\u{11B8}"),
    ("\u{AE7A}", "\u{AE7A}", "\u{1101}\u{1162}\u{11B9}", "\u{AE7A}", "\u{1101}\u{1162}\u{11B9}"),
    ("\u{AE7B}", "\u{AE7B}", "\u{1101}\u{1162}\u{11BA}", "\u{AE7B}", "\u{1101}\u{1162}\u{11BA}"),
    ("\u{AE7C}", "\u{AE7C}", "\u{1101}\u{1162}\u{11BB}", "\u{AE7C}", "\u{1101}\u{1162}\u{11BB}"),
    ("\u{AE7D}", "\u{AE7D}", "\u{1101}\u{1162}\u{11BC}", "\u{AE7D}", "\u{1101}\u{1162}\u{11BC}"),
    ("\u{AE7E}", "\u{AE7E}", "\u{1101}\u{1162}\u{11BD}", "\u{AE7E}", "\u{1101}\u{1162}\u{11BD}"),
    ("\u{AE7F}", "\u{AE7F}", "\u{1101}\u{1162}\u{11BE}", "\u{AE7F}", "\u{1101}\u{1162}\u{11BE}"),
    ("\u{AE80}", "\u{AE80}", "\u{1101}\u{1162}\u{11BF}", "\u{AE80}", "\u{1101}\u{1162}\u{11BF}"),
    ("\u{AE81}", "\u{AE81}", "\u{1101}\u{1162}\u{11C0}", "\u{AE81}", "\u{1101}\u{1162}\u{11C0}"),
    ("\u{AE82}", "\u{AE82}", "\u{1101}\u{1162}\u{11C1}", "\u{AE82}", "\u{1101}\u{1162}\u{11C1}"),
    ("\u{AE83}", "\u{AE83}", "\u{1101}\u{1162}\u{11C2}", "\u{AE83}", "\u{1101}\u{1162}\u{11C2}"),
    ("\u{AE84}", "\u{AE84}", "\u{1101}\u{1163}", "\u{AE84}", "\u{1101}\u{1163}"),
    ("\u{AE85}", "\u{AE85}", "\u{1101}\u{1163}\u{11A8}", "\u{AE85}", "\u{1101}\u{1163}\u{11A8}"),
    ("\u{AE86}", "\u{AE86}", "\u{1101}\u{1163}\u{11A9}", "\u{AE86}", "\u{1101}\u{1163}\u{11A9}"),
    ("\u{AE87}", "\u{AE87}", "\u{1101}\u{1163}\u{11AA}", "\u{AE87}", "\u{1101}\u{1163}\u{11AA}"),
    ("\u{AE88}", "\u{AE88}", "\u{1101}\u{1163}\u{11AB}", "\u{AE88}", "\u{1101}\u{1163}\u{11AB}"),
    ("\u{AE89}", "\u{AE89}", "\u{1101}\u{1163}\u{11AC}", "\u{AE89}", "\u{1101}\u{1163}\u{11AC}"),
    ("\u{AE8A}", "\u{AE8A}", "\u{1101}\u{1163}\u{11AD}", "\u{AE8A}", "\u{1101}\u{1163}\u{11AD}"),
    ("\u{AE8B}", "\u{AE8B}", "\u{1101}\u{1163}\u{11AE}", "\u{AE8B}", "\u{1101}\u{1163}\u{11AE}"),
    ("\u{AE8C}", "\u{AE8C}", "\u{1101}\u{1163}\u{11AF}", "\u{AE8C}", "\u{1101}\u{1163}\u{11AF}"),
    ("\u{AE8D}", "\u{AE8D}", "\u{1101}\u{1163}\u{11B0}", "\u{AE8D}", "\u{1101}\u{1163}\u{11B0}"),
    ("\u{AE8E}", "\u{AE8E}", "\u{1101}\u{1163}\u{11B1}", "\u{AE8E}", "\u{1101}\u{1163}\u{11B1}"),
    ("\u{AE8F}", "\u{AE8F}", "\u{1101}\u{1163}\u{11B2}", "\u{AE8F}", "\u{1101}\u{1163}\u{11B2}"),
    ("\u{AE90}", "\u{AE90}", "\u{1101}\u{1163}\u{11B3}", "\u{AE90}", "\u{1101}\u{1163}\u{11B3}"),
    ("\u{AE91}", "\u{AE91}", "\u{1101}\u{1163}\u{11B4}", "\u{AE91}", "\u{1101}\u{1163}\u{11B4}"),
    ("\u{AE92}", "\u{AE92}", "\u{1101}\u{1163}\u{11B5}", "\u{AE92}", "\u{1101}\u{1163}\u{11B5}"),
    ("\u{AE93}", "\u{AE93}", "\u{1101}\u{1163}\u{11B6}", "\u{AE93}", "\u{1101}\u{1163}\u{11B6}"),
    ("\u{AE94}", "\u{AE94}", "\u{1101}\u{1163}\u{11B7}", "\u{AE94}", "\u{1101}\u{1163}\u{11B7}"),
    ("\u{AE95}", "\u{AE95}", "\u{1101}\u{1163}\u{11B8}", "\u{AE95}", "\u{1101}\u{1163}\u{11B8}"),
    ("\u{AE96}", "\u{AE96}", "\u{1101}\u{1163}\u{11B9}", "\u{AE96}", "\u{1101}\u{1163}\u{11B9}"),
    ("\u{AE97}", "\u{AE97}", "\u{1101}\u{1163}\u{11BA}", "\u{AE97}", "\u{1101}\u{1163}\u{11BA}"),
    ("\u{AE98}", "\u{AE98}", "\u{1101}\u{1163}\u{11BB}", "\u{AE98}", "\u{1101}\u{1163}\u{11BB}"),
    ("\u{AE99}", "\u{AE99}", "\u{1101}\u{1163}\u{11BC}", "\u{AE99}", "\u{1101}\u{1163}\u{11BC}"),
    ("\u{AE9A}", "\u{AE9A}", "\u{1101}\u{1163}\u{11BD}", "\u{AE9A}", "\u{1101}\u{1163}\u{11BD}"),
    ("\u{AE9B}", "\u{AE9B}", "\u{1101}\u{1163}\u{11BE}", "\u{AE9B}", "\u{1101}\u{1163}\u{11BE}"),
    ("\u{AE9C}", "\u{AE9C}", "\u{1101}\u{1163}\u{11BF}", "\u{AE9C}", "\u{1101}\u{1163}\u{11BF}"),
    ("\u{AE9D}", "\u{AE9D}", "\u{1101}\u{1163}\u{11C0}", "\u{AE9D}", "\u{1101}\u{1163}\u{11C0}"),
    ("\u{AE9E}", "\u{AE9E}", "\u{1101}\u{1163}\u{11C1}", "\u{AE9E}", "\u{1101}\u{1163}\u{11C1}"),
    ("\u{AE9F}", "\u{AE9F}", "\u{1101}\u{1163}\u{11C2}", "\u{AE9F}", "\u{1101}\u{1163}\u{11C2}"),
    ("\u{AEA0}", "\u{AEA0}", "\u{1101}\u{1164}", "\u{AEA0}", "\u{1101}\u{1164}"),
    ("\u{AEA1}", "\u{AEA1}", "\u{1101}\u{1164}\u{11A8}", "\u{AEA1}", "\u{1101}\u{1164}\u{11A8}"),
    ("\u{AEA2}", "\u{AEA2}", "\u{1101}\u{1164}\u{11A9}", "\u{AEA2}", "\u{1101}\u{1164}\u{11A9}"),
    ("\u{AEA3}", "\u{AEA3}", "\u{1101}\u{1164}\u{11AA}", "\u{AEA3}", "\u{1101}\u{1164}\u{11AA}"),
    ("\u{AEA4}", "\u{AEA4}", "\u{1101}\u{1164}\u{11AB}", "\u{AEA4}", "\u{1101}\u{1164}\u{11AB}"),
    ("\u{AEA5}", "\u{AEA5}", "\u{1101}\u{1164}\u{11AC}", "\u{AEA5}", "\u{1101}\u{1164}\u{11AC}"),
    ("\u{AEA6}", "\u{AEA6}", "\u{1101}\u{1164}\u{11AD}", "\u{AEA6}", "\u{1101}\u{1164}\u{11AD}"),
    ("\u{AEA7}", "\u{AEA7}", "\u{1101}\u{1164}\u{11AE}", "\u{AEA7}", "\u{1101}\u{1164}\u{11AE}"),
    ("\u{AEA8}", "\u{AEA8}", "\u{1101}\u{1164}\u{11AF}", "\u{AEA8}", "\u{1101}\u{1164}\u{11AF}"),
    ("\u{AEA9}", "\u{AEA9}", "\u{1101}\u{1164}\u{11B0}", "\u{AEA9}", "\u{1101}\u{1164}\u{11B0}"),
    ("\u{AEAA}", "\u{AEAA}", "\u{1101}\u{1164}\u{11B1}", "\u{AEAA}", "\u{1101}\u{1164}\u{11B1}"),
    ("\u{AEAB}", "\u{AEAB}", "\u{1101}\u{1164}\u{11B2}", "\u{AEAB}", "\u{1101}\u{1164}\u{11B2}"),
    ("\u{AEAC}", "\u{AEAC}", "\u{1101}\u{1164}\u{11B3}", "\u{AEAC}", "\u{1101}\u{1164}\u{11B3}"),
    ("\u{AEAD}", "\u{AEAD}", "\u{1101}\u{1164}\u{11B4}", "\u{AEAD}", "\u{1101}\u{1164}\u{11B4}"),
    ("\u{AEAE}", "\u{AEAE}", "\u{1101}\u{1164}\u{11B5}", "\u{AEAE}", "\u{1101}\u{1164}\u{11B5}"),
    ("\u{AEAF}", "\u{AEAF}", "\u{1101}\u{1164}\u{11B6}", "\u{AEAF}", "\u{1101}\u{1164}\u{11B6}"),
    ("\u{AEB0}", "\u{AEB0}", "\u{1101}\u{1164}\u{11B7}", "\u{AEB0}", "\u{1101}\u{1164}\u{11B7}"),
    ("\u{AEB1}", "\u{AEB1}", "\u{1101}\u{1164}\u{11B8}", "\u{AEB1}", "\u{1101}\u{1164}\u{11B8}"),
    ("\u{AEB2}", "\u{AEB2}", "\u{1101}\u{1164}\u{11B9}", "\u{AEB2}", "\u{1101}\u{1164}\u{11B9}"),
    ("\u{AEB3}", "\u{AEB3}", "\u{1101}\u{1164}\u{11BA}", "\u{AEB3}", "\u{1101}\u{1164}\u{11BA}"),
    ("\u{AEB4}", "\u{AEB4}", "\u{1101}\u{1164}\u{11BB}", "\u{AEB4}", "\u{1101}\u{1164}\u{11BB}"),
    ("\u{AEB5}", "\u{AEB5}", "\u{1101}\u{1164}\u{11BC}", "\u{AEB5}", "\u{1101}\u{1164}\u{11BC}"),
    ("\u{AEB6}", "\u{AEB6}", "\u{1101}\u{1164}\u{11BD}", "\u{AEB6}", "\u{1101}\u{1164}\u{11BD}"),
    ("\u{AEB7}", "\u{AEB7}", "\u{1101}\u{1164}\u{11BE}", "\u{AEB7}", "\u{1101}\u{1164}\u{11BE}"),
    ("\u{AEB8}", "\u{AEB8}", "\u{1101}\u{1164}\u{11BF}", "\u{AEB8}", "\u{1101}\u{1164}\u{11BF}"),
    ("\u{AEB9}", "\u{AEB9}", "\u{1101}\u{1164}\u{11C0}", "\u{AEB9}", "\u{1101}\u{1164}\u{11C0}"),
    ("\u{AEBA}", "\u{AEBA}", "\u{1101}\u{1164}\u{11C1}", "\u{AEBA}", "\u{1101}\u{1164}\u{11C1}"),
    ("\u{AEBB}", "\u{AEBB}", "\u{1101}\u{1164}\u{11C2}", "\u{AEBB}", "\u{1101}\u{1164}\u{11C2}"),
    ("\u{AEBC}", "\u{AEBC}", "\u{1101}\u{1165}", "\u{AEBC}", "\u{1101}\u{1165}"),
    ("\u{AEBD}", "\u{AEBD}", "\u{1101}\u{1165}\u{11A8}", "\u{AEBD}", "\u{1101}\u{1165}\u{11A8}"),
    ("\u{AEBE}", "\u{AEBE}", "\u{1101}\u{1165}\u{11A9}", "\u{AEBE}", "\u{1101}\u{1165}\u{11A9}"),
    ("\u{AEBF}", "\u{AEBF}", "\u{1101}\u{1165}\u{11AA}", "\u{AEBF}", "\u{1101}\u{1165}\u{11AA}"),
    ("\u{AEC0}", "\u{AEC0}", "\u{1101}\u{1165}\u{11AB}", "\u{AEC0}", "\u{1101}\u{1165}\u{11AB}"),
    ("\u{AEC1}", "\u{AEC1}", "\u{1101}\u{1165}\u{11AC}", "\u{AEC1}", "\u{1101}\u{1165}\u{11AC}"),
    ("\u{AEC2}", "\u{AEC2}", "\u{1101}\u{1165}\u{11AD}", "\u{AEC2}", "\u{1101}\u{1165}\u{11AD}"),
    ("\u{AEC3}", "\u{AEC3}", "\u{1101}\u{1165}\u{11AE}", "\u{AEC3}", "\u{1101}\u{1165}\u{11AE}"),
    ("\u{AEC4}", "\u{AEC4}", "\u{1101}\u{1165}\u{11AF}", "\u{AEC4}", "\u{1101}\u{1165}\u{11AF}"),
    ("\u{AEC5}", "\u{AEC5}", "\u{1101}\u{1165}\u{11B0}", "\u{AEC5}", "\u{1101}\u{1165}\u{11B0}"),
    ("\u{AEC6}", "\u{AEC6}", "\u{1101}\u{1165}\u{11B1}", "\u{AEC6}", "\u{1101}\u{1165}\u{11B1}"),
    ("\u{AEC7}", "\u{AEC7}", "\u{1101}\u{1165}\u{11B2}", "\u{AEC7}", "\u{1101}\u{1165}\u{11B2}"),
    ("\u{AEC8}", "\u{AEC8}", "\u{1101}\u{1165}\u{11B3}", "\u{AEC8}", "\u{1101}\u{1165}\u{11B3}"),
    ("\u{AEC9}", "\u{AEC9}", "\u{1101}\u{1165}\u{11B4}", "\u{AEC9}", "\u{1101}\u{1165}\u{11B4}"),
    ("\u{AECA}", "\u{AECA}", "\u{1101}\u{1165}\u{11B5}", "\u{AECA}", "\u{1101}\u{1165}\u{11B5}"),
    ("\u{AECB}", "\u{AECB}", "\u{1101}\u{1165}\u{11B6}", "\u{AECB}", "\u{1101}\u{1165}\u{11B6}"),
    ("\u{AECC}", "\u{AECC}", "\u{1101}\u{1165}\u{11B7}", "\u{AECC}", "\u{1101}\u{1165}\u{11B7}"),
    ("\u{AECD}", "\u{AECD}", "\u{1101}\u{1165}\u{11B8}", "\u{AECD}", "\u{1101}\u{1165}\u{11B8}"),
    ("\u{AECE}", "\u{AECE}", "\u{1101}\u{1165}\u{11B9}", "\u{AECE}", "\u{1101}\u{1165}\u{11B9}"),
    ("\u{AECF}", "\u{AECF}", "\u{1101}\u{1165}\u{11BA}", "\u{AECF}", "\u{1101}\u{1165}\u{11BA}"),
    ("\u{AED0}", "\u{AED0}", "\u{1101}\u{1165}\u{11BB}", "\u{AED0}", "\u{1101}\u{1165}\u{11BB}"),
    ("\u{AED1}", "\u{AED1}", "\u{1101}\u{1165}\u{11BC}", "\u{AED1}", "\u{1101}\u{1165}\u{11BC}"),
    ("\u{AED2}", "\u{AED2}", "\u{1101}\u{1165}\u{11BD}", "\u{AED2}", "\u{1101}\u{1165}\u{11BD}"),
    ("\u{AED3}", "\u{AED3}", "\u{1101}\u{1165}\u{11BE}", "\u{AED3}", "\u{1101}\u{1165}\u{11BE}"),
    ("\u{AED4}", "\u{AED4}", "\u{1101}\u{1165}\u{11BF}", "\u{AED4}", "\u{1101}\u{1165}\u{11BF}"),
    ("\u{AED5}", "\u{AED5}", "\u{1101}\u{1165}\u{11C0}", "\u{AED5}", "\u{1101}\u{1165}\u{11C0}"),
    ("\u{AED6}", "\u{AED6}", "\u{1101}\u{1165}\u{11C1}", "\u{AED6}", "\u{1101}\u{1165}\u{11C1}"),
    ("\u{AED7}", "\u{AED7}", "\u{1101}\u{1165}\u{11C2}", "\u{AED7}", "\u{1101}\u{1165}\u{11C2}"),
    ("\u{AED8}", "\u{AED8}", "\u{1101}\u{1166}", "\u{AED8}", "\u{1101}\u{1166}"),
    ("\u{AED9}", "\u{AED9}", "\u{1101}\u{1166}\u{11A8}", "\u{AED9}", "\u{1101}\u{1166}\u{11A8}"),
    ("\u{AEDA}", "\u{AEDA}", "\u{1101}\u{1166}\u{11A9}", "\u{AEDA}", "\u{1101}\u{1166}\u{11A9}"),
    ("\u{AEDB}", "\u{AEDB}", "\u{1101}\u{1166}\u{11AA}", "\u{AEDB}", "\u{1101}\u{1166}\u{11AA}"),
    ("\u{AEDC}", "\u{AEDC}", "\u{1101}\u{1166}\u{11AB}", "\u{AEDC}", "\u{1101}\u{1166}\u{11AB}"),
    ("\u{AEDD}", "\u{AEDD}", "\u{1101}\u{1166}\u{11AC}", "\u{AEDD}", "\u{1101}\u{1166}\u{11AC}"),
    ("\u{AEDE}", "\u{AEDE}", "\u{1101}\u{1166}\u{11AD}", "\u{AEDE}", "\u{1101}\u{1166}\u{11AD}"),
    ("\u{AEDF}", "\u{AEDF}", "\u{1101}\u{1166}\u{11AE}", "\u{AEDF}", "\u{1101}\u{1166}\u{11AE}"),
    ("\u{AEE0}", "\u{AEE0}", "\u{1101}\u{1166}\u{11AF}", "\u{AEE0}", "\u{1101}\u{1166}\u{11AF}"),
    ("\u{AEE1}", "\u{AEE1}", "\u{1101}\u{1166}\u{11B0}", "\u{AEE1}", "\u{1101}\u{1166}\u{11B0}"),
    ("\u{AEE2}", "\u{AEE2}", "\u{1101}\u{1166}\u{11B1}", "\u{AEE2}", "\u{1101}\u{1166}\u{11B1}"),
    ("\u{AEE3}", "\u{AEE3}", "\u{1101}\u{1166}\u{11B2}", "\u{AEE3}", "\u{1101}\u{1166}\u{11B2}"),
    ("\u{AEE4}", "\u{AEE4}", "\u{1101}\u{1166}\u{11B3}", "\u{AEE4}", "\u{1101}\u{1166}\u{11B3}"),
    ("\u{AEE5}", "\u{AEE5}", "\u{1101}\u{1166}\u{11B4}", "\u{AEE5}", "\u{1101}\u{1166}\u{11B4}"),
    ("\u{AEE6}", "\u{AEE6}", "\u{1101}\u{1166}\u{11B5}", "\u{AEE6}", "\u{1101}\u{1166}\u{11B5}"),
    ("\u{AEE7}", "\u{AEE7}", "\u{1101}\u{1166}\u{11B6}", "\u{AEE7}", "\u{1101}\u{1166}\u{11B6}"),
    ("\u{AEE8}", "\u{AEE8}", "\u{1101}\u{1166}\u{11B7}", "\u{AEE8}", "\u{1101}\u{1166}\u{11B7}"),
    ("\u{AEE9}", "\u{AEE9}", "\u{1101}\u{1166}\u{11B8}", "\u{AEE9}", "\u{1101}\u{1166}\u{11B8}"),
    ("\u{AEEA}", "\u{AEEA}", "\u{1101}\u{1166}\u{11B9}", "\u{AEEA}", "\u{1101}\u{1166}\u{11B9}"),
    ("\u{AEEB}", "\u{AEEB}", "\u{1101}\u{1166}\u{11BA}", "\u{AEEB}", "\u{1101}\u{1166}\u{11BA}"),
    ("\u{AEEC}", "\u{AEEC}", "\u{1101}\u{1166}\u{11BB}", "\u{AEEC}", "\u{1101}\u{1166}\u{11BB}"),
    ("\u{AEED}", "\u{AEED}", "\u{1101}\u{1166}\u{11BC}", "\u{AEED}", "\u{1101}\u{1166}\u{11BC}"),
    ("\u{AEEE}", "\u{AEEE}", "\u{1101}\u{1166}\u{11BD}", "\u{AEEE}", "\u{1101}\u{1166}\u{11BD}"),
    ("\u{AEEF}", "\u{AEEF}", "\u{1101}\u{1166}\u{11BE}", "\u{AEEF}", "\u{1101}\u{1166}\u{11BE}"),
    ("\u{AEF0}", "\u{AEF0}", "\u{1101}\u{1166}\u{11BF}", "\u{AEF0}", "\u{1101}\u{1166}\u{11BF}"),
    ("\u{AEF1}", "\u{AEF1}", "\u{1101}\u{1166}\u{11C0}", "\u{AEF1}", "\u{1101}\u{1166}\u{11C0}"),
    ("\u{AEF2}", "\u{AEF2}", "\u{1101}\u{1166}\u{11C1}", "\u{AEF2}", "\u{1101}\u{1166}\u{11C1}"),
    ("\u{AEF3}", "\u{AEF3}", "\u{1101}\u{1166}\u{11C2}", "\u{AEF3}", "\u{1101}\u{1166}\u{11C2}"),
    ("\u{AEF4}", "\u{AEF4}", "\u{1101}\u{1167}", "\u{AEF4}", "\u{1101}\u{1167}"),
    ("\u{AEF5}", "\u{AEF5}", "\u{1101}\u{1167}\u{11A8}", "\u{AEF5}", "\u{1101}\u{1167}\u{11A8}"),
    ("\u{AEF6}", "\u{AEF6}", "\u{1101}\u{1167}\u{11A9}", "\u{AEF6}", "\u{1101}\u{1167}\u{11A9}"),
    ("\u{AEF7}", "\u{AEF7}", "\u{1101}\u{1167}\u{11AA}", "\u{AEF7}", "\u{1101}\u{1167}\u{11AA}"),
    ("\u{AEF8}", "\u{AEF8}", "\u{1101}\u{1167}\u{11AB}", "\u{AEF8}", "\u{1101}\u{1167}\u{11AB}"),
    ("\u{AEF9}", "\u{AEF9}", "\u{1101}\u{1167}\u{11AC}", "\u{AEF9}", "\u{1101}\u{1167}\u{11AC}"),
    ("\u{AEFA}", "\u{AEFA}", "\u{1101}\u{1167}\u{11AD}", "\u{AEFA}", "\u{1101}\u{1167}\u{11AD}"),
    ("\u{AEFB}", "\u{AEFB}", "\u{1101}\u{1167}\u{11AE}", "\u{AEFB}", "\u{1101}\u{1167}\u{11AE}"),
    ("\u{AEFC}", "\u{AEFC}", "\u{1101}\u{1167}\u{11AF}", "\u{AEFC}", "\u{1101}\u{1167}\u{11AF}"),
    ("\u{AEFD}", "\u{AEFD}", "\u{1101}\u{1167}\u{11B0}", "\u{AEFD}", "\u{1101}\u{1167}\u{11B0}"),
    ("\u{AEFE}", "\u{AEFE}", "\u{1101}\u{1167}\u{11B1}", "\u{AEFE}", "\u{1101}\u{1167}\u{11B1}"),
    ("\u{AEFF}", "\u{AEFF}", "\u{1101}\u{1167}\u{11B2}", "\u{AEFF}", "\u{1101}\u{1167}\u{11B2}"),
    ("\u{AF00}", "\u{AF00}", "\u{1101}\u{1167}\u{11B3}", "\u{AF00}", "\u{1101}\u{1167}\u{11B3}"),
    ("\u{AF01}", "\u{AF01}", "\u{1101}\u{1167}\u{11B4}", "\u{AF01}", "\u{1101}\u{1167}\u{11B4}"),
    ("\u{AF02}", "\u{AF02}", "\u{1101}\u{1167}\u{11B5}", "\u{AF02}", "\u{1101}\u{1167}\u{11B5}"),
    ("\u{AF03}", "\u{AF03}", "\u{1101}\u{1167}\u{11B6}", "\u{AF03}", "\u{1101}\u{1167}\u{11B6}"),
    ("\u{AF04}", "\u{AF04}", "\u{1101}\u{1167}\u{11B7}", "\u{AF04}", "\u{1101}\u{1167}\u{11B7}"),
    ("\u{AF05}", "\u{AF05}", "\u{1101}\u{1167}\u{11B8}", "\u{AF05}", "\u{1101}\u{1167}\u{11B8}"),
    ("\u{AF06}", "\u{AF06}", "\u{1101}\u{1167}\u{11B9}", "\u{AF06}", "\u{1101}\u{1167}\u{11B9}"),
    ("\u{AF07}", "\u{AF07}", "\u{1101}\u{1167}\u{11BA}", "\u{AF07}", "\u{1101}\u{1167}\u{11BA}"),
    ("\u{AF08}", "\u{AF08}", "\u{1101}\u{1167}\u{11BB}", "\u{AF08}", "\u{1101}\u{1167}\u{11BB}"),
    ("\u{AF09}", "\u{AF09}", "\u{1101}\u{1167}\u{11BC}", "\u{AF09}", "\u{1101}\u{1167}\u{11BC}"),
    ("\u{AF0A}", "\u{AF0A}", "\u{1101}\u{1167}\u{11BD}", "\u{AF0A}", "\u{1101}\u{1167}\u{11BD}"),
    ("\u{AF0B}", "\u{AF0B}", "\u{1101}\u{1167}\u{11BE}", "\u{AF0B}", "\u{1101}\u{1167}\u{11BE}"),
    ("\u{AF0C}", "\u{AF0C}", "\u{1101}\u{1167}\u{11BF}", "\u{AF0C}", "\u{1101}\u{1167}\u{11BF}"),
    ("\u{AF0D}", "\u{AF0D}", "\u{1101}\u{1167}\u{11C0}", "\u{AF0D}", "\u{1101}\u{1167}\u{11C0}"),
    ("\u{AF0E}", "\u{AF0E}", "\u{1101}\u{1167}\u{11C1}", "\u{AF0E}", "\u{1101}\u{1167}\u{11C1}"),
    ("\u{AF0F}", "\u{AF0F}", "\u{1101}\u{1167}\u{11C2}", "\u{AF0F}", "\u{1101}\u{1167}\u{11C2}"),
    ("\u{AF10}", "\u{AF10}", "\u{1101}\u{1168}", "\u{AF10}", "\u{1101}\u{1168}"),
    ("\u{AF11}", "\u{AF11}", "\u{1101}\u{1168}\u{11A8}", "\u{AF11}", "\u{1101}\u{1168}\u{11A8}"),
    ("\u{AF12}", "\u{AF12}", "\u{1101}\u{1168}\u{11A9}", "\u{AF12}", "\u{1101}\u{1168}\u{11A9}"),
    ("\u{AF13}", "\u{AF13}", "\u{1101}\u{1168}\u{11AA}", "\u{AF13}", "\u{1101}\u{1168}\u{11AA}"),
    ("\u{AF14}", "\u{AF14}", "\u{1101}\u{1168}\u{11AB}", "\u{AF14}", "\u{1101}\u{1168}\u{11AB}"),
    ("\u{AF15}", "\u{AF15}", "\u{1101}\u{1168}\u{11AC}", "\u{AF15}", "\u{1101}\u{1168}\u{11AC}"),
    ("\u{AF16}", "\u{AF16}", "\u{1101}\u{1168}\u{11AD}", "\u{AF16}", "\u{1101}\u{1168}\u{11AD}"),
    ("\u{AF17}", "\u{AF17}", "\u{1101}\u{1168}\u{11AE}", "\u{AF17}", "\u{1101}\u{1168}\u{11AE}"),
    ("\u{AF18}", "\u{AF18}", "\u{1101}\u{1168}\u{11AF}", "\u{AF18}", "\u{1101}\u{1168}\u{11AF}"),
    ("\u{AF19}", "\u{AF19}", "\u{1101}\u{1168}\u{11B0}", "\u{AF19}", "\u{1101}\u{1168}\u{11B0}"),
    ("\u{AF1A}", "\u{AF1A}", "\u{1101}\u{1168}\u{11B1}", "\u{AF1A}", "\u{1101}\u{1168}\u{11B1}"),
    ("\u{AF1B}", "\u{AF1B}", "\u{1101}\u{1168}\u{11B2}", "\u{AF1B}", "\u{1101}\u{1168}\u{11B2}"),
    ("\u{AF1C}", "\u{AF1C}", "\u{1101}\u{1168}\u{11B3}", "\u{AF1C}", "\u{1101}\u{1168}\u{11B3}"),
    ("\u{AF1D}", "\u{AF1D}", "\u{1101}\u{1168}\u{11B4}", "\u{AF1D}", "\u{1101}\u{1168}\u{11B4}"),
    ("\u{AF1E}", "\u{AF1E}", "\u{1101}\u{1168}\u{11B5}", "\u{AF1E}", "\u{1101}\u{1168}\u{11B5}"),
    ("\u{AF1F}", "\u{AF1F}", "\u{1101}\u{1168}\u{11B6}", "\u{AF1F}", "\u{1101}\u{1168}\u{11B6}"),
    ("\u{AF20}", "\u{AF20}", "\u{1101}\u{1168}\u{11B7}", "\u{AF20}", "\u{1101}\u{1168}\u{11B7}"),
    ("\u{AF21}", "\u{AF21}", "\u{1101}\u{1168}\u{11B8}", "\u{AF21}", "\u{1101}\u{1168}\u{11B8}"),
    ("\u{AF22}", "\u{AF22}", "\u{1101}\u{1168}\u{11B9}", "\u{AF22}", "\u{1101}\u{1168}\u{11B9}"),
    ("\u{AF23}", "\u{AF23}", "\u{1101}\u{1168}\u{11BA}", "\u{AF23}", "\u{1101}\u{1168}\u{11BA}"),
    ("\u{AF24}", "\u{AF24}", "\u{1101}\u{1168}\u{11BB}", "\u{AF24}", "\u{1101}\u{1168}\u{11BB}"),
    ("\u{AF25}", "\u{AF25}", "\u{1101}\u{1168}\u{11BC}", "\u{AF25}", "\u{1101}\u{1168}\u{11BC}"),
    ("\u{AF26}", "\u{AF26}", "\u{1101}\u{1168}\u{11BD}", "\u{AF26}", "\u{1101}\u{1168}\u{11BD}"),
    ("\u{AF27}", "\u{AF27}", "\u{1101}\u{1168}\u{11BE}", "\u{AF27}", "\u{1101}\u{1168}\u{11BE}"),
    ("\u{AF28}", "\u{AF28}", "\u{1101}\u{1168}\u{11BF}", "\u{AF28}", "\u{1101}\u{1168}\u{11BF}"),
    ("\u{AF29}", "\u{AF29}", "\u{1101}\u{1168}\u{11C0}", "\u{AF29}", "\u{1101}\u{1168}\u{11C0}"),
    ("\u{AF2A}", "\u{AF2A}", "\u{1101}\u{1168}\u{11C1}", "\u{AF2A}", "\u{1101}\u{1168}\u{11C1}"),
    ("\u{AF2B}", "\u{AF2B}", "\u{1101}\u{1168}\u{11C2}", "\u{AF2B}", "\u{1101}\u{1168}\u{11C2}"),
    ("\u{AF2C}", "\u{AF2C}", "\u{1101}\u{1169}", "\u{AF2C}", "\u{1101}\u{1169}"),
    ("\u{AF2D}", "\u{AF2D}", "\u{1101}\u{1169}\u{11A8}", "\u{AF2D}", "\u{1101}\u{1169}\u{11A8}"),
    ("\u{AF2E}", "\u{AF2E}", "\u{1101}\u{1169}\u{11A9}", "\u{AF2E}", "\u{1101}\u{1169}\u{11A9}"),
    ("\u{AF2F}", "\u{AF2F}", "\u{1101}\u{1169}\u{11AA}", "\u{AF2F}", "\u{1101}\u{1169}\u{11AA}"),
    ("\u{AF30}", "\u{AF30}", "\u{1101}\u{1169}\u{11AB}", "\u{AF30}", "\u{1101}\u{1169}\u{11AB}"),
    ("\u{AF31}", "\u{AF31}", "\u{1101}\u{1169}\u{11AC}", "\u{AF31}", "\u{1101}\u{1169}\u{11AC}"),
    ("\u{AF32}", "\u{AF32}", "\u{1101}\u{1169}\u{11AD}", "\u{AF32}", "\u{1101}\u{1169}\u{11AD}"),
    ("\u{AF33}", "\u{AF33}", "\u{1101}\u{1169}\u{11AE}", "\u{AF33}", "\u{1101}\u{1169}\u{11AE}"),
    ("\u{AF34}", "\u{AF34}", "\u{1101}\u{1169}\u{11AF}", "\u{AF34}", "\u{1101}\u{1169}\u{11AF}"),
    ("\u{AF35}", "\u{AF35}", "\u{1101}\u{1169}\u{11B0}", "\u{AF35}", "\u{1101}\u{1169}\u{11B0}"),
    ("\u{AF36}", "\u{AF36}", "\u{1101}\u{1169}\u{11B1}", "\u{AF36}", "\u{1101}\u{1169}\u{11B1}"),
    ("\u{AF37}", "\u{AF37}", "\u{1101}\u{1169}\u{11B2}", "\u{AF37}", "\u{1101}\u{1169}\u{11B2}"),
    ("\u{AF38}", "\u{AF38}", "\u{1101}\u{1169}\u{11B3}", "\u{AF38}", "\u{1101}\u{1169}\u{11B3}"),
    ("\u{AF39}", "\u{AF39}", "\u{1101}\u{1169}\u{11B4}", "\u{AF39}", "\u{1101}\u{1169}\u{11B4}"),
    ("\u{AF3A}", "\u{AF3A}", "\u{1101}\u{1169}\u{11B5}", "\u{AF3A}", "\u{1101}\u{1169}\u{11B5}"),
    ("\u{AF3B}", "\u{AF3B}", "\u{1101}\u{1169}\u{11B6}", "\u{AF3B}", "\u{1101}\u{1169}\u{11B6}"),
    ("\u{AF3C}", "\u{AF3C}", "\u{1101}\u{1169}\u{11B7}", "\u{AF3C}", "\u{1101}\u{1169}\u{11B7}"),
    ("\u{AF3D}", "\u{AF3D}", "\u{1101}\u{1169}\u{11B8}", "\u{AF3D}", "\u{1101}\u{1169}\u{11B8}"),
    ("\u{AF3E}", "\u{AF3E}", "\u{1101}\u{1169}\u{11B9}", "\u{AF3E}", "\u{1101}\u{1169}\u{11B9}"),
    ("\u{AF3F}", "\u{AF3F}", "\u{1101}\u{1169}\u{11BA}", "\u{AF3F}", "\u{1101}\u{1169}\u{11BA}"),
    ("\u{AF40}", "\u{AF40}", "\u{1101}\u{1169}\u{11BB}", "\u{AF40}", "\u{1101}\u{1169}\u{11BB}"),
    ("\u{AF41}", "\u{AF41}", "\u{1101}\u{1169}\u{11BC}", "\u{AF41}", "\u{1101}\u{1169}\u{11BC}"),
    ("\u{AF42}", "\u{AF42}", "\u{1101}\u{1169}\u{11BD}", "\u{AF42}", "\u{1101}\u{1169}\u{11BD}"),
    ("\u{AF43}", "\u{AF43}", "\u{1101}\u{1169}\u{11BE}", "\u{AF43}", "\u{1101}\u{1169}\u{11BE}"),
    ("\u{AF44}", "\u{AF44}", "\u{1101}\u{1169}\u{11BF}", "\u{AF44}", "\u{1101}\u{1169}\u{11BF}"),
    ("\u{AF45}", "\u{AF45}", "\u{1101}\u{1169}\u{11C0}", "\u{AF45}", "\u{1101}\u{1169}\u{11C0}"),
    ("\u{AF46}", "\u{AF46}", "\u{1101}\u{1169}\u{11C1}", "\u{AF46}", "\u{1101}\u{1169}\u{11C1}"),
    ("\u{AF47}", "\u{AF47}", "\u{1101}\u{1169}\u{11C2}", "\u{AF47}", "\u{1101}\u{1169}\u{11C2}"),
    ("\u{AF48}", "\u{AF48}", "\u{1101}\u{116A}", "\u{AF48}", "\u{1101}\u{116A}"),
    ("\u{AF49}", "\u{AF49}", "\u{1101}\u{116A}\u{11A8}", "\u{AF49}", "\u{1101}\u{116A}\u{11A8}"),
    ("\u{AF4A}", "\u{AF4A}", "\u{1101}\u{116A}\u{11A9}", "\u{AF4A}", "\u{1101}\u{116A}\u{11A9}"),
    ("\u{AF4B}", "\u{AF4B}", "\u{1101}\u{116A}\u{11AA}", "\u{AF4B}", "\u{1101}\u{116A}\u{11AA}"),
    ("\u{AF4C}", "\u{AF4C}", "\u{1101}\u{116A}\u{11AB}", "\u{AF4C}", "\u{1101}\u{116A}\u{11AB}"),
    ("\u{AF4D}", "\u{AF4D}", "\u{1101}\u{116A}\u{11AC}", "\u{AF4D}", "\u{1101}\u{116A}\u{11AC}"),
    ("\u{AF4E}", "\u{AF4E}", "\u{1101}\u{116A}\u{11AD}", "\u{AF4E}", "\u{1101}\u{116A}\u{11AD}"),
    ("\u{AF4F}", "\u{AF4F}", "\u{1101}\u{116A}\u{11AE}", "\u{AF4F}", "\u{1101}\u{116A}\u{11AE}"),
    ("\u{AF50}", "\u{AF50}", "\u{1101}\u{116A}\u{11AF}", "\u{AF50}", "\u{1101}\u{116A}\u{11AF}"),
    ("\u{AF51}", "\u{AF51}", "\u{1101}\u{116A}\u{11B0}", "\u{AF51}", "\u{1101}\u{116A}\u{11B0}"),
    ("\u{AF52}", "\u{AF52}", "\u{1101}\u{116A}\u{11B1}", "\u{AF52}", "\u{1101}\u{116A}\u{11B1}"),
    ("\u{AF53}", "\u{AF53}", "\u{1101}\u{116A}\u{11B2}", "\u{AF53}", "\u{1101}\u{116A}\u{11B2}"),
    ("\u{AF54}", "\u{AF54}", "\u{1101}\u{116A}\u{11B3}", "\u{AF54}", "\u{1101}\u{116A}\u{11B3}"),
    ("\u{AF55}", "\u{AF55}", "\u{1101}\u{116A}\u{11B4}", "\u{AF55}", "\u{1101}\u{116A}\u{11B4}"),
    ("\u{AF56}", "\u{AF56}", "\u{1101}\u{116A}\u{11B5}", "\u{AF56}", "\u{1101}\u{116A}\u{11B5}"),
    ("\u{AF57}", "\u{AF57}", "\u{1101}\u{116A}\u{11B6}", "\u{AF57}", "\u{1101}\u{116A}\u{11B6}"),
    ("\u{AF58}", "\u{AF58}", "\u{1101}\u{116A}\u{11B7}", "\u{AF58}", "\u{1101}\u{116A}\u{11B7}"),
    ("\u{AF59}", "\u{AF59}", "\u{1101}\u{116A}\u{11B8}", "\u{AF59}", "\u{1101}\u{116A}\u{11B8}"),
    ("\u{AF5A}", "\u{AF5A}", "\u{1101}\u{116A}\u{11B9}", "\u{AF5A}", "\u{1101}\u{116A}\u{11B9}"),
    ("\u{AF5B}", "\u{AF5B}", "\u{1101}\u{116A}\u{11BA}", "\u{AF5B}", "\u{1101}\u{116A}\u{11BA}"),
    ("\u{AF5C}", "\u{AF5C}", "\u{1101}\u{116A}\u{11BB}", "\u{AF5C}", "\u{1101}\u{116A}\u{11BB}"),
    ("\u{AF5D}", "\u{AF5D}", "\u{1101}\u{116A}\u{11BC}", "\u{AF5D}", "\u{1101}\u{116A}\u{11BC}"),
    ("\u{AF5E}", "\u{AF5E}", "\u{1101}\u{116A}\u{11BD}", "\u{AF5E}", "\u{1101}\u{116A}\u{11BD}"),
    ("\u{AF5F}", "\u{AF5F}", "\u{1101}\u{116A}\u{11BE}", "\u{AF5F}", "\u{1101}\u{116A}\u{11BE}"),
    ("\u{AF60}", "\u{AF60}", "\u{1101}\u{116A}\u{11BF}", "\u{AF60}", "\u{1101}\u{116A}\u{11BF}"),
    ("\u{AF61}", "\u{AF61}", "\u{1101}\u{116A}\u{11C0}", "\u{AF61}", "\u{1101}\u{116A}\u{11C0}"),
    ("\u{AF62}", "\u{AF62}", "\u{1101}\u{116A}\u{11C1}", "\u{AF62}", "\u{1101}\u{116A}\u{11C1}"),
    ("\u{AF63}", "\u{AF63}", "\u{1101}\u{116A}\u{11C2}", "\u{AF63}", "\u{1101}\u{116A}\u{11C2}"),
    ("\u{AF64}", "\u{AF64}", "\u{1101}\u{116B}", "\u{AF64}", "\u{1101}\u{116B}"),
    ("\u{AF65}", "\u{AF65}", "\u{1101}\u{116B}\u{11A8}", "\u{AF65}", "\u{1101}\u{116B}\u{11A8}"),
    ("\u{AF66}", "\u{AF66}", "\u{1101}\u{116B}\u{11A9}", "\u{AF66}", "\u{1101}\u{116B}\u{11A9}"),
    ("\u{AF67}", "\u{AF67}", "\u{1101}\u{116B}\u{11AA}", "\u{AF67}", "\u{1101}\u{116B}\u{11AA}"),
    ("\u{AF68}", "\u{AF68}", "\u{1101}\u{116B}\u{11AB}", "\u{AF68}", "\u{1101}\u{116B}\u{11AB}"),
    ("\u{AF69}", "\u{AF69}", "\u{1101}\u{116B}\u{11AC}", "\u{AF69}", "\u{1101}\u{116B}\u{11AC}"),
    ("\u{AF6A}", "\u{AF6A}", "\u{1101}\u{116B}\u{11AD}", "\u{AF6A}", "\u{1101}\u{116B}\u{11AD}"),
    ("\u{AF6B}", "\u{AF6B}", "\u{1101}\u{116B}\u{11AE}", "\u{AF6B}", "\u{1101}\u{116B}\u{11AE}"),
    ("\u{AF6C}", "\u{AF6C}", "\u{1101}\u{116B}\u{11AF}", "\u{AF6C}", "\u{1101}\u{116B}\u{11AF}"),
    ("\u{AF6D}", "\u{AF6D}", "\u{1101}\u{116B}\u{11B0}", "\u{AF6D}", "\u{1101}\u{116B}\u{11B0}"),
    ("\u{AF6E}", "\u{AF6E}", "\u{1101}\u{116B}\u{11B1}", "\u{AF6E}", "\u{1101}\u{116B}\u{11B1}"),
    ("\u{AF6F}", "\u{AF6F}", "\u{1101}\u{116B}\u{11B2}", "\u{AF6F}", "\u{1101}\u{116B}\u{11B2}"),
    ("\u{AF70}", "\u{AF70}", "\u{1101}\u{116B}\u{11B3}", "\u{AF70}", "\u{1101}\u{116B}\u{11B3}"),
    ("\u{AF71}", "\u{AF71}", "\u{1101}\u{116B}\u{11B4}", "\u{AF71}", "\u{1101}\u{116B}\u{11B4}"),
    ("\u{AF72}", "\u{AF72}", "\u{1101}\u{116B}\u{11B5}", "\u{AF72}", "\u{1101}\u{116B}\u{11B5}"),
    ("\u{AF73}", "\u{AF73}", "\u{1101}\u{116B}\u{11B6}", "\u{AF73}", "\u{1101}\u{116B}\u{11B6}"),
    ("\u{AF74}", "\u{AF74}", "\u{1101}\u{116B}\u{11B7}", "\u{AF74}", "\u{1101}\u{116B}\u{11B7}"),
    ("\u{AF75}", "\u{AF75}", "\u{1101}\u{116B}\u{11B8}", "\u{AF75}", "\u{1101}\u{116B}\u{11B8}"),
    ("\u{AF76}", "\u{AF76}", "\u{1101}\u{116B}\u{11B9}", "\u{AF76}", "\u{1101}\u{116B}\u{11B9}"),
    ("\u{AF77}", "\u{AF77}", "\u{1101}\u{116B}\u{11BA}", "\u{AF77}", "\u{1101}\u{116B}\u{11BA}"),
    ("\u{AF78}", "\u{AF78}", "\u{1101}\u{116B}\u{11BB}", "\u{AF78}", "\u{1101}\u{116B}\u{11BB}"),
    ("\u{AF79}", "\u{AF79}", "\u{1101}\u{116B}\u{11BC}", "\u{AF79}", "\u{1101}\u{116B}\u{11BC}"),
    ("\u{AF7A}", "\u{AF7A}", "\u{1101}\u{116B}\u{11BD}", "\u{AF7A}", "\u{1101}\u{116B}\u{11BD}"),
    ("\u{AF7B}", "\u{AF7B}", "\u{1101}\u{116B}\u{11BE}", "\u{AF7B}", "\u{1101}\u{116B}\u{11BE}"),
    ("\u{AF7C}", "\u{AF7C}", "\u{1101}\u{116B}\u{11BF}", "\u{AF7C}", "\u{1101}\u{116B}\u{11BF}"),
    ("\u{AF7D}", "\u{AF7D}", "\u{1101}\u{116B}\u{11C0}", "\u{AF7D}", "\u{1101}\u{116B}\u{11C0}"),
    ("\u{AF7E}", "\u{AF7E}", "\u{1101}\u{116B}\u{11C1}", "\u{AF7E}", "\u{1101}\u{116B}\u{11C1}"),
    ("\u{AF7F}", "\u{AF7F}", "\u{1101}\u{116B}\u{11C2}", "\u{AF7F}", "\u{1101}\u{116B}\u{11C2}"),
    ("\u{AF80}", "\u{AF80}", "\u{1101}\u{116C}", "\u{AF80}", "\u{1101}\u{116C}"),
    ("\u{AF81}", "\u{AF81}", "\u{1101}\u{116C}\u{11A8}", "\u{AF81}", "\u{1101}\u{116C}\u{11A8}"),
    ("\u{AF82}", "\u{AF82}", "\u{1101}\u{116C}\u{11A9}", "\u{AF82}", "\u{1101}\u{116C}\u{11A9}"),
    ("\u{AF83}", "\u{AF83}", "\u{1101}\u{116C}\u{11AA}", "\u{AF83}", "\u{1101}\u{116C}\u{11AA}"),
    ("\u{AF84}", "\u{AF84}", "\u{1101}\u{116C}\u{11AB}", "\u{AF84}", "\u{1101}\u{116C}\u{11AB}"),
    ("\u{AF85}", "\u{AF85}", "\u{1101}\u{116C}\u{11AC}", "\u{AF85}", "\u{1101}\u{116C}\u{11AC}"),
    ("\u{AF86}", "\u{AF86}", "\u{1101}\u{116C}\u{11AD}", "\u{AF86}", "\u{1101}\u{116C}\u{11AD}"),
    ("\u{AF87}", "\u{AF87}", "\u{1101}\u{116C}\u{11AE}", "\u{AF87}", "\u{1101}\u{116C}\u{11AE}"),
    ("\u{AF88}", "\u{AF88}", "\u{1101}\u{116C}\u{11AF}", "\u{AF88}", "\u{1101}\u{116C}\u{11AF}"),
    ("\u{AF89}", "\u{AF89}", "\u{1101}\u{116C}\u{11B0}", "\u{AF89}", "\u{1101}\u{116C}\u{11B0}"),
    ("\u{AF8A}", "\u{AF8A}", "\u{1101}\u{116C}\u{11B1}", "\u{AF8A}", "\u{1101}\u{116C}\u{11B1}"),
    ("\u{AF8B}", "\u{AF8B}", "\u{1101}\u{116C}\u{11B2}", "\u{AF8B}", "\u{1101}\u{116C}\u{11B2}"),
    ("\u{AF8C}", "\u{AF8C}", "\u{1101}\u{116C}\u{11B3}", "\u{AF8C}", "\u{1101}\u{116C}\u{11B3}"),
    ("\u{AF8D}", "\u{AF8D}", "\u{1101}\u{116C}\u{11B4}", "\u{AF8D}", "\u{1101}\u{116C}\u{11B4}"),
    ("\u{AF8E}", "\u{AF8E}", "\u{1101}\u{116C}\u{11B5}", "\u{AF8E}", "\u{1101}\u{116C}\u{11B5}"),
    ("\u{AF8F}", "\u{AF8F}", "\u{1101}\u{116C}\u{11B6}", "\u{AF8F}", "\u{1101}\u{116C}\u{11B6}"),
    ("\u{AF90}", "\u{AF90}", "\u{1101}\u{116C}\u{11B7}", "\u{AF90}", "\u{1101}\u{116C}\u{11B7}"),
    ("\u{AF91}", "\u{AF91}", "\u{1101}\u{116C}\u{11B8}", "\u{AF91}", "\u{1101}\u{116C}\u{11B8}"),
    ("\u{AF92}", "\u{AF92}", "\u{1101}\u{116C}\u{11B9}", "\u{AF92}", "\u{1101}\u{116C}\u{11B9}"),
    ("\u{AF93}", "\u{AF93}", "\u{1101}\u{116C}\u{11BA}", "\u{AF93}", "\u{1101}\u{116C}\u{11BA}"),
    ("\u{AF94}", "\u{AF94}", "\u{1101}\u{116C}\u{11BB}", "\u{AF94}", "\u{1101}\u{116C}\u{11BB}"),
    ("\u{AF95}", "\u{AF95}", "\u{1101}\u{116C}\u{11BC}", "\u{AF95}", "\u{1101}\u{116C}\u{11BC}"),
    ("\u{AF96}", "\u{AF96}", "\u{1101}\u{116C}\u{11BD}", "\u{AF96}", "\u{1101}\u{116C}\u{11BD}"),
    ("\u{AF97}", "\u{AF97}", "\u{1101}\u{116C}\u{11BE}", "\u{AF97}", "\u{1101}\u{116C}\u{11BE}"),
    ("\u{AF98}", "\u{AF98}", "\u{1101}\u{116C}\u{11BF}", "\u{AF98}", "\u{1101}\u{116C}\u{11BF}"),
    ("\u{AF99}", "\u{AF99}", "\u{1101}\u{116C}\u{11C0}", "\u{AF99}", "\u{1101}\u{116C}\u{11C0}"),
    ("\u{AF9A}", "\u{AF9A}", "\u{1101}\u{116C}\u{11C1}", "\u{AF9A}", "\u{1101}\u{116C}\u{11C1}"),
    ("\u{AF9B}", "\u{AF9B}", "\u{1101}\u{116C}\u{11C2}", "\u{AF9B}", "\u{1101}\u{116C}\u{11C2}"),
    ("\u{AF9C}", "\u{AF9C}", "\u{1101}\u{116D}", "\u{AF9C}", "\u{1101}\u{116D}"),
    ("\u{AF9D}", "\u{AF9D}", "\u{1101}\u{116D}\u{11A8}", "\u{AF9D}", "\u{1101}\u{116D}\u{11A8}"),
    ("\u{AF9E}", "\u{AF9E}", "\u{1101}\u{116D}\u{11A9}", "\u{AF9E}", "\u{1101}\u{116D}\u{11A9}"),
    ("\u{AF9F}", "\u{AF9F}", "\u{1101}\u{116D}\u{11AA}", "\u{AF9F}", "\u{1101}\u{116D}\u{11AA}"),
    ("\u{AFA0}", "\u{AFA0}", "\u{1101}\u{116D}\u{11AB}", "\u{AFA0}", "\u{1101}\u{116D}\u{11AB}"),
    ("\u{AFA1}", "\u{AFA1}", "\u{1101}\u{116D}\u{11AC}", "\u{AFA1}", "\u{1101}\u{116D}\u{11AC}"),
    ("\u{AFA2}", "\u{AFA2}", "\u{1101}\u{116D}\u{11AD}", "\u{AFA2}", "\u{1101}\u{116D}\u{11AD}"),
    ("\u{AFA3}", "\u{AFA3}", "\u{1101}\u{116D}\u{11AE}", "\u{AFA3}", "\u{1101}\u{116D}\u{11AE}"),
    ("\u{AFA4}", "\u{AFA4}", "\u{1101}\u{116D}\u{11AF}", "\u{AFA4}", "\u{1101}\u{116D}\u{11AF}"),
    ("\u{AFA5}", "\u{AFA5}", "\u{1101}\u{116D}\u{11B0}", "\u{AFA5}", "\u{1101}\u{116D}\u{11B0}"),
    ("\u{AFA6}", "\u{AFA6}", "\u{1101}\u{116D}\u{11B1}", "\u{AFA6}", "\u{1101}\u{116D}\u{11B1}"),
    ("\u{AFA7}", "\u{AFA7}", "\u{1101}\u{116D}\u{11B2}", "\u{AFA7}", "\u{1101}\u{116D}\u{11B2}"),
    ("\u{AFA8}", "\u{AFA8}", "\u{1101}\u{116D}\u{11B3}", "\u{AFA8}", "\u{1101}\u{116D}\u{11B3}"),
    ("\u{AFA9}", "\u{AFA9}", "\u{1101}\u{116D}\u{11B4}", "\u{AFA9}", "\u{1101}\u{116D}\u{11B4}"),
    ("\u{AFAA}", "\u{AFAA}", "\u{1101}\u{116D}\u{11B5}", "\u{AFAA}", "\u{1101}\u{116D}\u{11B5}"),
    ("\u{AFAB}", "\u{AFAB}", "\u{1101}\u{116D}\u{11B6}", "\u{AFAB}", "\u{1101}\u{116D}\u{11B6}"),
    ("\u{AFAC}", "\u{AFAC}", "\u{1101}\u{116D}\u{11B7}", "\u{AFAC}", "\u{1101}\u{116D}\u{11B7}"),
    ("\u{AFAD}", "\u{AFAD}", "\u{1101}\u{116D}\u{11B8}", "\u{AFAD}", "\u{1101}\u{116D}\u{11B8}"),
    ("\u{AFAE}", "\u{AFAE}", "\u{1101}\u{116D}\u{11B9}", "\u{AFAE}", "\u{1101}\u{116D}\u{11B9}"),
    ("\u{AFAF}", "\u{AFAF}", "\u{1101}\u{116D}\u{11BA}", "\u{AFAF}", "\u{1101}\u{116D}\u{11BA}"),
    ("\u{AFB0}", "\u{AFB0}", "\u{1101}\u{116D}\u{11BB}", "\u{AFB0}", "\u{1101}\u{116D}\u{11BB}"),
    ("\u{AFB1}", "\u{AFB1}", "\u{1101}\u{116D}\u{11BC}", "\u{AFB1}", "\u{1101}\u{116D}\u{11BC}"),
    ("\u{AFB2}", "\u{AFB2}", "\u{1101}\u{116D}\u{11BD}", "\u{AFB2}", "\u{1101}\u{116D}\u{11BD}"),
    ("\u{AFB3}", "\u{AFB3}", "\u{1101}\u{116D}\u{11BE}", "\u{AFB3}", "\u{1101}\u{116D}\u{11BE}"),
    ("\u{AFB4}", "\u{AFB4}", "\u{1101}\u{116D}\u{11BF}", "\u{AFB4}", "\u{1101}\u{116D}\u{11BF}"),
    ("\u{AFB5}", "\u{AFB5}", "\u{1101}\u{116D}\u{11C0}", "\u{AFB5}", "\u{1101}\u{116D}\u{11C0}"),
    ("\u{AFB6}", "\u{AFB6}", "\u{1101}\u{116D}\u{11C1}", "\u{AFB6}", "\u{1101}\u{116D}\u{11C1}"),
    ("\u{AFB7}", "\u{AFB7}", "\u{1101}\u{116D}\u{11C2}", "\u{AFB7}", "\u{1101}\u{116D}\u{11C2}"),
    ("\u{AFB8}", "\u{AFB8}", "\u{1101}\u{116E}", "\u{AFB8}", "\u{1101}\u{116E}"),
    ("\u{AFB9}", "\u{AFB9}", "\u{1101}\u{116E}\u{11A8}", "\u{AFB9}", "\u{1101}\u{116E}\u{11A8}"),
    ("\u{AFBA}", "\u{AFBA}", "\u{1101}\u{116E}\u{11A9}", "\u{AFBA}", "\u{1101}\u{116E}\u{11A9}"),
    ("\u{AFBB}", "\u{AFBB}", "\u{1101}\u{116E}\u{11AA}", "\u{AFBB}", "\u{1101}\u{116E}\u{11AA}"),
    ("\u{AFBC}", "\u{AFBC}", "\u{1101}\u{116E}\u{11AB}", "\u{AFBC}", "\u{1101}\u{116E}\u{11AB}"),
    ("\u{AFBD}", "\u{AFBD}", "\u{1101}\u{116E}\u{11AC}", "\u{AFBD}", "\u{1101}\u{116E}\u{11AC}"),
    ("\u{AFBE}", "\u{AFBE}", "\u{1101}\u{116E}\u{11AD}", "\u{AFBE}", "\u{1101}\u{116E}\u{11AD}"),
    ("\u{AFBF}", "\u{AFBF}", "\u{1101}\u{116E}\u{11AE}", "\u{AFBF}", "\u{1101}\u{116E}\u{11AE}"),
    ("\u{AFC0}", "\u{AFC0}", "\u{1101}\u{116E}\u{11AF}", "\u{AFC0}", "\u{1101}\u{116E}\u{11AF}"),
    ("\u{AFC1}", "\u{AFC1}", "\u{1101}\u{116E}\u{11B0}", "\u{AFC1}", "\u{1101}\u{116E}\u{11B0}"),
    ("\u{AFC2}", "\u{AFC2}", "\u{1101}\u{116E}\u{11B1}", "\u{AFC2}", "\u{1101}\u{116E}\u{11B1}"),
    ("\u{AFC3}", "\u{AFC3}", "\u{1101}\u{116E}\u{11B2}", "\u{AFC3}", "\u{1101}\u{116E}\u{11B2}"),
    ("\u{AFC4}", "\u{AFC4}", "\u{1101}\u{116E}\u{11B3}", "\u{AFC4}", "\u{1101}\u{116E}\u{11B3}"),
    ("\u{AFC5}", "\u{AFC5}", "\u{1101}\u{116E}\u{11B4}", "\u{AFC5}", "\u{1101}\u{116E}\u{11B4}"),
    ("\u{AFC6}", "\u{AFC6}", "\u{1101}\u{116E}\u{11B5}", "\u{AFC6}", "\u{1101}\u{116E}\u{11B5}"),
    ("\u{AFC7}", "\u{AFC7}", "\u{1101}\u{116E}\u{11B6}", "\u{AFC7}", "\u{1101}\u{116E}\u{11B6}"),
    ("\u{AFC8}", "\u{AFC8}", "\u{1101}\u{116E}\u{11B7}", "\u{AFC8}", "\u{1101}\u{116E}\u{11B7}"),
    ("\u{AFC9}", "\u{AFC9}", "\u{1101}\u{116E}\u{11B8}", "\u{AFC9}", "\u{1101}\u{116E}\u{11B8}"),
    ("\u{AFCA}", "\u{AFCA}", "\u{1101}\u{116E}\u{11B9}", "\u{AFCA}", "\u{1101}\u{116E}\u{11B9}"),
    ("\u{AFCB}", "\u{AFCB}", "\u{1101}\u{116E}\u{11BA}", "\u{AFCB}", "\u{1101}\u{116E}\u{11BA}"),
    ("\u{AFCC}", "\u{AFCC}", "\u{1101}\u{116E}\u{11BB}", "\u{AFCC}", "\u{1101}\u{116E}\u{11BB}"),
    ("\u{AFCD}", "\u{AFCD}", "\u{1101}\u{116E}\u{11BC}", "\u{AFCD}", "\u{1101}\u{116E}\u{11BC}"),
    ("\u{AFCE}", "\u{AFCE}", "\u{1101}\u{116E}\u{11BD}", "\u{AFCE}", "\u{1101}\u{116E}\u{11BD}"),
    ("\u{AFCF}", "\u{AFCF}", "\u{1101}\u{116E}\u{11BE}", "\u{AFCF}", "\u{1101}\u{116E}\u{11BE}"),
    ("\u{AFD0}", "\u{AFD0}", "\u{1101}\u{116E}\u{11BF}", "\u{AFD0}", "\u{1101}\u{116E}\u{11BF}"),
    ("\u{AFD1}", "\u{AFD1}", "\u{1101}\u{116E}\u{11C0}", "\u{AFD1}", "\u{1101}\u{116E}\u{11C0}"),
    ("\u{AFD2}", "\u{AFD2}", "\u{1101}\u{116E}\u{11C1}", "\u{AFD2}", "\u{1101}\u{116E}\u{11C1}"),
    ("\u{AFD3}", "\u{AFD3}", "\u{1101}\u{116E}\u{11C2}", "\u{AFD3}", "\u{1101}\u{116E}\u{11C2}"),
    ("\u{AFD4}", "\u{AFD4}", "\u{1101}\u{116F}", "\u{AFD4}", "\u{1101}\u{116F}"),
    ("\u{AFD5}", "\u{AFD5}", "\u{1101}\u{116F}\u{11A8}", "\u{AFD5}", "\u{1101}\u{116F}\u{11A8}"),
    ("\u{AFD6}", "\u{AFD6}", "\u{1101}\u{116F}\u{11A9}", "\u{AFD6}", "\u{1101}\u{116F}\u{11A9}"),
    ("\u{AFD7}", "\u{AFD7}", "\u{1101}\u{116F}\u{11AA}", "\u{AFD7}", "\u{1101}\u{116F}\u{11AA}"),
    ("\u{AFD8}", "\u{AFD8}", "\u{1101}\u{116F}\u{11AB}", "\u{AFD8}", "\u{1101}\u{116F}\u{11AB}"),
    ("\u{AFD9}", "\u{AFD9}", "\u{1101}\u{116F}\u{11AC}", "\u{AFD9}", "\u{1101}\u{116F}\u{11AC}"),
    ("\u{AFDA}", "\u{AFDA}", "\u{1101}\u{116F}\u{11AD}", "\u{AFDA}", "\u{1101}\u{116F}\u{11AD}"),
    ("\u{AFDB}", "\u{AFDB}", "\u{1101}\u{116F}\u{11AE}", "\u{AFDB}", "\u{1101}\u{116F}\u{11AE}"),
    ("\u{AFDC}", "\u{AFDC}", "\u{1101}\u{116F}\u{11AF}", "\u{AFDC}", "\u{1101}\u{116F}\u{11AF}"),
    ("\u{AFDD}", "\u{AFDD}", "\u{1101}\u{116F}\u{11B0}", "\u{AFDD}", "\u{1101}\u{116F}\u{11B0}"),
    ("\u{AFDE}", "\u{AFDE}", "\u{1101}\u{116F}\u{11B1}", "\u{AFDE}", "\u{1101}\u{116F}\u{11B1}"),
    ("\u{AFDF}", "\u{AFDF}", "\u{1101}\u{116F}\u{11B2}", "\u{AFDF}", "\u{1101}\u{116F}\u{11B2}"),
    ("\u{AFE0}", "\u{AFE0}", "\u{1101}\u{116F}\u{11B3}", "\u{AFE0}", "\u{1101}\u{116F}\u{11B3}"),
    ("\u{AFE1}", "\u{AFE1}", "\u{1101}\u{116F}\u{11B4}", "\u{AFE1}", "\u{1101}\u{116F}\u{11B4}"),
    ("\u{AFE2}", "\u{AFE2}", "\u{1101}\u{116F}\u{11B5}", "\u{AFE2}", "\u{1101}\u{116F}\u{11B5}"),
    ("\u{AFE3}", "\u{AFE3}", "\u{1101}\u{116F}\u{11B6}", "\u{AFE3}", "\u{1101}\u{116F}\u{11B6}"),
    ("\u{AFE4}", "\u{AFE4}", "\u{1101}\u{116F}\u{11B7}", "\u{AFE4}", "\u{1101}\u{116F}\u{11B7}"),
    ("\u{AFE5}", "\u{AFE5}", "\u{1101}\u{116F}\u{11B8}", "\u{AFE5}", "\u{1101}\u{116F}\u{11B8}"),
    ("\u{AFE6}", "\u{AFE6}", "\u{1101}\u{116F}\u{11B9}", "\u{AFE6}", "\u{1101}\u{116F}\u{11B9}"),
    ("\u{AFE7}", "\u{AFE7}", "\u{1101}\u{116F}\u{11BA}", "\u{AFE7}", "\u{1101}\u{116F}\u{11BA}"),
    ("\u{AFE8}", "\u{AFE8}", "\u{1101}\u{116F}\u{11BB}", "\u{AFE8}", "\u{1101}\u{116F}\u{11BB}"),
    ("\u{AFE9}", "\u{AFE9}", "\u{1101}\u{116F}\u{11BC}", "\u{AFE9}", "\u{1101}\u{116F}\u{11BC}"),
    ("\u{AFEA}", "\u{AFEA}", "\u{1101}\u{116F}\u{11BD}", "\u{AFEA}", "\u{1101}\u{116F}\u{11BD}"),
    ("\u{AFEB}", "\u{AFEB}", "\u{1101}\u{116F}\u{11BE}", "\u{AFEB}", "\u{1101}\u{116F}\u{11BE}"),
    ("\u{AFEC}", "\u{AFEC}", "\u{1101}\u{116F}\u{11BF}", "\u{AFEC}", "\u{1101}\u{116F}\u{11BF}"),
    ("\u{AFED}", "\u{AFED}", "\u{1101}\u{116F}\u{11C0}", "\u{AFED}", "\u{1101}\u{116F}\u{11C0}"),
    ("\u{AFEE}", "\u{AFEE}", "\u{1101}\u{116F}\u{11C1}", "\u{AFEE}", "\u{1101}\u{116F}\u{11C1}"),
    ("\u{AFEF}", "\u{AFEF}", "\u{1101}\u{116F}\u{11C2}", "\u{AFEF}", "\u{1101}\u{116F}\u{11C2}"),
    ("\u{AFF0}", "\u{AFF0}", "\u{1101}\u{1170}", "\u{AFF0}", "\u{1101}\u{1170}"),
    ("\u{AFF1}", "\u{AFF1}", "\u{1101}\u{1170}\u{11A8}", "\u{AFF1}", "\u{1101}\u{1170}\u{11A8}"),
    ("\u{AFF2}", "\u{AFF2}", "\u{1101}\u{1170}\u{11A9}", "\u{AFF2}", "\u{1101}\u{1170}\u{11A9}"),
    ("\u{AFF3}", "\u{AFF3}", "\u{1101}\u{1170}\u{11AA}", "\u{AFF3}", "\u{1101}\u{1170}\u{11AA}"),
    ("\u{AFF4}", "\u{AFF4}", "\u{1101}\u{1170}\u{11AB}", "\u{AFF4}", "\u{1101}\u{1170}\u{11AB}"),
    ("\u{AFF5}", "\u{AFF5}", "\u{1101}\u{1170}\u{11AC}", "\u{AFF5}", "\u{1101}\u{1170}\u{11AC}"),
    ("\u{AFF6}", "\u{AFF6}", "\u{1101}\u{1170}\u{11AD}", "\u{AFF6}", "\u{1101}\u{1170}\u{11AD}"),
    ("\u{AFF7}", "\u{AFF7}", "\u{1101}\u{1170}\u{11AE}", "\u{AFF7}", "\u{1101}\u{1170}\u{11AE}"),
    ("\u{AFF8}", "\u{AFF8}", "\u{1101}\u{1170}\u{11AF}", "\u{AFF8}", "\u{1101}\u{1170}\u{11AF}"),
    ("\u{AFF9}", "\u{AFF9}", "\u{1101}\u{1170}\u{11B0}", "\u{AFF9}", "\u{1101}\u{1170}\u{11B0}"),
    ("\u{AFFA}", "\u{AFFA}", "\u{1101}\u{1170}\u{11B1}", "\u{AFFA}", "\u{1101}\u{1170}\u{11B1}"),
    ("\u{AFFB}", "\u{AFFB}", "\u{1101}\u{1170}\u{11B2}", "\u{AFFB}", "\u{1101}\u{1170}\u{11B2}"),
    ("\u{AFFC}", "\u{AFFC}", "\u{1101}\u{1170}\u{11B3}", "\u{AFFC}", "\u{1101}\u{1170}\u{11B3}"),
    ("\u{AFFD}", "\u{AFFD}", "\u{1101}\u{1170}\u{11B4}", "\u{AFFD}", "\u{1101}\u{1170}\u{11B4}"),
    ("\u{AFFE}", "\u{AFFE}", "\u{1101}\u{1170}\u{11B5}", "\u{AFFE}", "\u{1101}\u{1170}\u{11B5}"),
    ("\u{AFFF}", "\u{AFFF}", "\u{1101}\u{1170}\u{11B6}", "\u{AFFF}", "\u{1101}\u{1170}\u{11B6}"),
    ("\u{B000}", "\u{B000}", "\u{1101}\u{1170}\u{11B7}", "\u{B000}", "\u{1101}\u{1170}\u{11B7}"),
    ("\u{B001}", "\u{B001}", "\u{1101}\u{1170}\u{11B8}", "\u{B001}", "\u{1101}\u{1170}\u{11B8}"),
    ("\u{B002}", "\u{B002}", "\u{1101}\u{1170}\u{11B9}", "\u{B002}", "\u{1101}\u{1170}\u{11B9}"),
    ("\u{B003}", "\u{B003}", "\u{1101}\u{1170}\u{11BA}", "\u{B003}", "\u{1101}\u{1170}\u{11BA}"),
    ("\u{B004}", "\u{B004}", "\u{1101}\u{1170}\u{11BB}", "\u{B004}", "\u{1101}\u{1170}\u{11BB}"),
    ("\u{B005}", "\u{B005}", "\u{1101}\u{1170}\u{11BC}", "\u{B005}", "\u{1101}\u{1170}\u{11BC}"),
    ("\u{B006}", "\u{B006}", "\u{1101}\u{1170}\u{11BD}", "\u{B006}", "\u{1101}\u{1170}\u{11BD}"),
    ("\u{B007}", "\u{B007}", "\u{1101}\u{1170}\u{11BE}", "\u{B007}", "\u{1101}\u{1170}\u{11BE}"),
    ("\u{B008}", "\u{B008}", "\u{1101}\u{1170}\u{11BF}", "\u{B008}", "\u{1101}\u{1170}\u{11BF}"),
    ("\u{B009}", "\u{B009}", "\u{1101}\u{1170}\u{11C0}", "\u{B009}", "\u{1101}\u{1170}\u{11C0}"),
    ("\u{B00A}", "\u{B00A}", "\u{1101}\u{1170}\u{11C1}", "\u{B00A}", "\u{1101}\u{1170}\u{11C1}"),
    ("\u{B00B}", "\u{B00B}", "\u{1101}\u{1170}\u{11C2}", "\u{B00B}", "\u{1101}\u{1170}\u{11C2}"),
    ("\u{B00C}", "\u{B00C}", "\u{1101}\u{1171}", "\u{B00C}", "\u{1101}\u{1171}"),
    ("\u{B00D}", "\u{B00D}", "\u{1101}\u{1171}\u{11A8}", "\u{B00D}", "\u{1101}\u{1171}\u{11A8}"),
    ("\u{B00E}", "\u{B00E}", "\u{1101}\u{1171}\u{11A9}", "\u{B00E}", "\u{1101}\u{1171}\u{11A9}"),
    ("\u{B00F}", "\u{B00F}", "\u{1101}\u{1171}\u{11AA}", "\u{B00F}", "\u{1101}\u{1171}\u{11AA}"),
    ("\u{B010}", "\u{B010}", "\u{1101}\u{1171}\u{11AB}", "\u{B010}", "\u{1101}\u{1171}\u{11AB}"),
    ("\u{B011}", "\u{B011}", "\u{1101}\u{1171}\u{11AC}", "\u{B011}", "\u{1101}\u{1171}\u{11AC}"),
    ("\u{B012}", "\u{B012}", "\u{1101}\u{1171}\u{11AD}", "\u{B012}", "\u{1101}\u{1171}\u{11AD}"),
    ("\u{B013}", "\u{B013}", "\u{1101}\u{1171}\u{11AE}", "\u{B013}", "\u{1101}\u{1171}\u{11AE}"),
    ("\u{B014}", "\u{B014}", "\u{1101}\u{1171}\u{11AF}", "\u{B014}", "\u{1101}\u{1171}\u{11AF}"),
    ("\u{B015}", "\u{B015}", "\u{1101}\u{1171}\u{11B0}", "\u{B015}", "\u{1101}\u{1171}\u{11B0}"),
    ("\u{B016}", "\u{B016}", "\u{1101}\u{1171}\u{11B1}", "\u{B016}", "\u{1101}\u{1171}\u{11B1}"),
    ("\u{B017}", "\u{B017}", "\u{1101}\u{1171}\u{11B2}", "\u{B017}", "\u{1101}\u{1171}\u{11B2}"),
    ("\u{B018}", "\u{B018}", "\u{1101}\u{1171}\u{11B3}", "\u{B018}", "\u{1101}\u{1171}\u{11B3}"),
    ("\u{B019}", "\u{B019}", "\u{1101}\u{1171}\u{11B4}", "\u{B019}", "\u{1101}\u{1171}\u{11B4}"),
    ("\u{B01A}", "\u{B01A}", "\u{1101}\u{1171}\u{11B5}", "\u{B01A}", "\u{1101}\u{1171}\u{11B5}"),
    ("\u{B01B}", "\u{B01B}", "\u{1101}\u{1171}\u{11B6}", "\u{B01B}", "\u{1101}\u{1171}\u{11B6}"),
    ("\u{B01C}", "\u{B01C}", "\u{1101}\u{1171}\u{11B7}", "\u{B01C}", "\u{1101}\u{1171}\u{11B7}"),
    ("\u{B01D}", "\u{B01D}", "\u{1101}\u{1171}\u{11B8}", "\u{B01D}", "\u{1101}\u{1171}\u{11B8}"),
    ("\u{B01E}", "\u{B01E}", "\u{1101}\u{1171}\u{11B9}", "\u{B01E}", "\u{1101}\u{1171}\u{11B9}"),
    ("\u{B01F}", "\u{B01F}", "\u{1101}\u{1171}\u{11BA}", "\u{B01F}", "\u{1101}\u{1171}\u{11BA}"),
    ("\u{B020}", "\u{B020}", "\u{1101}\u{1171}\u{11BB}", "\u{B020}", "\u{1101}\u{1171}\u{11BB}"),
    ("\u{B021}", "\u{B021}", "\u{1101}\u{1171}\u{11BC}", "\u{B021}", "\u{1101}\u{1171}\u{11BC}"),
    ("\u{B022}", "\u{B022}", "\u{1101}\u{1171}\u{11BD}", "\u{B022}", "\u{1101}\u{1171}\u{11BD}"),
    ("\u{B023}", "\u{B023}", "\u{1101}\u{1171}\u{11BE}", "\u{B023}", "\u{1101}\u{1171}\u{11BE}"),
    ("\u{B024}", "\u{B024}", "\u{1101}\u{1171}\u{11BF}", "\u{B024}", "\u{1101}\u{1171}\u{11BF}"),
    ("\u{B025}", "\u{B025}", "\u{1101}\u{1171}\u{11C0}", "\u{B025}", "\u{1101}\u{1171}\u{11C0}"),
    ("\u{B026}", "\u{B026}", "\u{1101}\u{1171}\u{11C1}", "\u{B026}", "\u{1101}\u{1171}\u{11C1}"),
    ("\u{B027}", "\u{B027}", "\u{1101}\u{1171}\u{11C2}", "\u{B027}", "\u{1101}\u{1171}\u{11C2}"),
    ("\u{B028}", "\u{B028}", "\u{1101}\u{1172}", "\u{B028}", "\u{1101}\u{1172}"),
    ("\u{B029}", "\u{B029}", "\u{1101}\u{1172}\u{11A8}", "\u{B029}", "\u{1101}\u{1172}\u{11A8}"),
    ("\u{B02A}", "\u{B02A}", "\u{1101}\u{1172}\u{11A9}", "\u{B02A}", "\u{1101}\u{1172}\u{11A9}"),
    ("\u{B02B}", "\u{B02B}", "\u{1101}\u{1172}\u{11AA}", "\u{B02B}", "\u{1101}\u{1172}\u{11AA}"),
    ("\u{B02C}", "\u{B02C}", "\u{1101}\u{1172}\u{11AB}", "\u{B02C}", "\u{1101}\u{1172}\u{11AB}"),
    ("\u{B02D}", "\u{B02D}", "\u{1101}\u{1172}\u{11AC}", "\u{B02D}", "\u{1101}\u{1172}\u{11AC}"),
    ("\u{B02E}", "\u{B02E}", "\u{1101}\u{1172}\u{11AD}", "\u{B02E}", "\u{1101}\u{1172}\u{11AD}"),
    ("\u{B02F}", "\u{B02F}", "\u{1101}\u{1172}\u{11AE}", "\u{B02F}", "\u{1101}\u{1172}\u{11AE}"),
    ("\u{B030}", "\u{B030}", "\u{1101}\u{1172}\u{11AF}", "\u{B030}", "\u{1101}\u{1172}\u{11AF}"),
    ("\u{B031}", "\u{B031}", "\u{1101}\u{1172}\u{11B0}", "\u{B031}", "\u{1101}\u{1172}\u{11B0}"),
    ("\u{B032}", "\u{B032}", "\u{1101}\u{1172}\u{11B1}", "\u{B032}", "\u{1101}\u{1172}\u{11B1}"),
    ("\u{B033}", "\u{B033}", "\u{1101}\u{1172}\u{11B2}", "\u{B033}", "\u{1101}\u{1172}\u{11B2}"),
    ("\u{B034}", "\u{B034}", "\u{1101}\u{1172}\u{11B3}", "\u{B034}", "\u{1101}\u{1172}\u{11B3}"),
    ("\u{B035}", "\u{B035}", "\u{1101}\u{1172}\u{11B4}", "\u{B035}", "\u{1101}\u{1172}\u{11B4}"),
    ("\u{B036}", "\u{B036}", "\u{1101}\u{1172}\u{11B5}", "\u{B036}", "\u{1101}\u{1172}\u{11B5}"),
    ("\u{B037}", "\u{B037}", "\u{1101}\u{1172}\u{11B6}", "\u{B037}", "\u{1101}\u{1172}\u{11B6}"),
    ("\u{B038}", "\u{B038}", "\u{1101}\u{1172}\u{11B7}", "\u{B038}", "\u{1101}\u{1172}\u{11B7}"),
    ("\u{B039}", "\u{B039}", "\u{1101}\u{1172}\u{11B8}", "\u{B039}", "\u{1101}\u{1172}\u{11B8}"),
    ("\u{B03A}", "\u{B03A}", "\u{1101}\u{1172}\u{11B9}", "\u{B03A}", "\u{1101}\u{1172}\u{11B9}"),
    ("\u{B03B}", "\u{B03B}", "\u{1101}\u{1172}\u{11BA}", "\u{B03B}", "\u{1101}\u{1172}\u{11BA}"),
    ("\u{B03C}", "\u{B03C}", "\u{1101}\u{1172}\u{11BB}", "\u{B03C}", "\u{1101}\u{1172}\u{11BB}"),
    ("\u{B03D}", "\u{B03D}", "\u{1101}\u{1172}\u{11BC}", "\u{B03D}", "\u{1101}\u{1172}\u{11BC}"),
    ("\u{B03E}", "\u{B03E}", "\u{1101}\u{1172}\u{11BD}", "\u{B03E}", "\u{1101}\u{1172}\u{11BD}"),
    ("\u{B03F}", "\u{B03F}", "\u{1101}\u{1172}\u{11BE}", "\u{B03F}", "\u{1101}\u{1172}\u{11BE}"),
    ("\u{B040}", "\u{B040}", "\u{1101}\u{1172}\u{11BF}", "\u{B040}", "\u{1101}\u{1172}\u{11BF}"),
    ("\u{B041}", "\u{B041}", "\u{1101}\u{1172}\u{11C0}", "\u{B041}", "\u{1101}\u{1172}\u{11C0}"),
    ("\u{B042}", "\u{B042}", "\u{1101}\u{1172}\u{11C1}", "\u{B042}", "\u{1101}\u{1172}\u{11C1}"),
    ("\u{B043}", "\u{B043}", "\u{1101}\u{1172}\u{11C2}", "\u{B043}", "\u{1101}\u{1172}\u{11C2}"),
    ("\u{B044}", "\u{B044}", "\u{1101}\u{1173}", "\u{B044}", "\u{1101}\u{1173}"),
    ("\u{B045}", "\u{B045}", "\u{1101}\u{1173}\u{11A8}", "\u{B045}", "\u{1101}\u{1173}\u{11A8}"),
    ("\u{B046}", "\u{B046}", "\u{1101}\u{1173}\u{11A9}", "\u{B046}", "\u{1101}\u{1173}\u{11A9}"),
    ("\u{B047}", "\u{B047}", "\u{1101}\u{1173}\u{11AA}", "\u{B047}", "\u{1101}\u{1173}\u{11AA}"),
    ("\u{B048}", "\u{B048}", "\u{1101}\u{1173}\u{11AB}", "\u{B048}", "\u{1101}\u{1173}\u{11AB}"),
    ("\u{B049}", "\u{B049}", "\u{1101}\u{1173}\u{11AC}", "\u{B049}", "\u{1101}\u{1173}\u{11AC}"),
    ("\u{B04A}", "\u{B04A}", "\u{1101}\u{1173}\u{11AD}", "\u{B04A}", "\u{1101}\u{1173}\u{11AD}"),
    ("\u{B04B}", "\u{B04B}", "\u{1101}\u{1173}\u{11AE}", "\u{B04B}", "\u{1101}\u{1173}\u{11AE}"),
    ("\u{B04C}", "\u{B04C}", "\u{1101}\u{1173}\u{11AF}", "\u{B04C}", "\u{1101}\u{1173}\u{11AF}"),
    ("\u{B04D}", "\u{B04D}", "\u{1101}\u{1173}\u{11B0}", "\u{B04D}", "\u{1101}\u{1173}\u{11B0}"),
    ("\u{B04E}", "\u{B04E}", "\u{1101}\u{1173}\u{11B1}", "\u{B04E}", "\u{1101}\u{1173}\u{11B1}"),
    ("\u{B04F}", "\u{B04F}", "\u{1101}\u{1173}\u{11B2}", "\u{B04F}", "\u{1101}\u{1173}\u{11B2}"),
    ("\u{B050}", "\u{B050}", "\u{1101}\u{1173}\u{11B3}", "\u{B050}", "\u{1101}\u{1173}\u{11B3}"),
    ("\u{B051}", "\u{B051}", "\u{1101}\u{1173}\u{11B4}", "\u{B051}", "\u{1101}\u{1173}\u{11B4}"),
    ("\u{B052}", "\u{B052}", "\u{1101}\u{1173}\u{11B5}", "\u{B052}", "\u{1101}\u{1173}\u{11B5}"),
    ("\u{B053}", "\u{B053}", "\u{1101}\u{1173}\u{11B6}", "\u{B053}", "\u{1101}\u{1173}\u{11B6}"),
    ("\u{B054}", "\u{B054}", "\u{1101}\u{1173}\u{11B7}", "\u{B054}", "\u{1101}\u{1173}\u{11B7}"),
    ("\u{B055}", "\u{B055}", "\u{1101}\u{1173}\u{11B8}", "\u{B055}", "\u{1101}\u{1173}\u{11B8}"),
    ("\u{B056}", "\u{B056}", "\u{1101}\u{1173}\u{11B9}", "\u{B056}", "\u{1101}\u{1173}\u{11B9}"),
    ("\u{B057}", "\u{B057}", "\u{1101}\u{1173}\u{11BA}", "\u{B057}", "\u{1101}\u{1173}\u{11BA}"),
    ("\u{B058}", "\u{B058}", "\u{1101}\u{1173}\u{11BB}", "\u{B058}", "\u{1101}\u{1173}\u{11BB}"),
    ("\u{B059}", "\u{B059}", "\u{1101}\u{1173}\u{11BC}", "\u{B059}", "\u{1101}\u{1173}\u{11BC}"),
    ("\u{B05A}", "\u{B05A}", "\u{1101}\u{1173}\u{11BD}", "\u{B05A}", "\u{1101}\u{1173}\u{11BD}"),
    ("\u{B05B}", "\u{B05B}", "\u{1101}\u{1173}\u{11BE}", "\u{B05B}", "\u{1101}\u{1173}\u{11BE}"),
    ("\u{B05C}", "\u{B05C}", "\u{1101}\u{1173}\u{11BF}", "\u{B05C}", "\u{1101}\u{1173}\u{11BF}"),
    ("\u{B05D}", "\u{B05D}", "\u{1101}\u{1173}\u{11C0}", "\u{B05D}", "\u{1101}\u{1173}\u{11C0}"),
    ("\u{B05E}", "\u{B05E}", "\u{1101}\u{1173}\u{11C1}", "\u{B05E}", "\u{1101}\u{1173}\u{11C1}"),
    ("\u{B05F}", "\u{B05F}", "\u{1101}\u{1173}\u{11C2}", "\u{B05F}", "\u{1101}\u{1173}\u{11C2}"),
    ("\u{B060}", "\u{B060}", "\u{1101}\u{1174}", "\u{B060}", "\u{1101}\u{1174}"),
    ("\u{B061}", "\u{B061}", "\u{1101}\u{1174}\u{11A8}", "\u{B061}", "\u{1101}\u{1174}\u{11A8}"),
    ("\u{B062}", "\u{B062}", "\u{1101}\u{1174}\u{11A9}", "\u{B062}", "\u{1101}\u{1174}\u{11A9}"),
    ("\u{B063}", "\u{B063}", "\u{1101}\u{1174}\u{11AA}", "\u{B063}", "\u{1101}\u{1174}\u{11AA}"),
    ("\u{B064}", "\u{B064}", "\u{1101}\u{1174}\u{11AB}", "\u{B064}", "\u{1101}\u{1174}\u{11AB}"),
    ("\u{B065}", "\u{B065}", "\u{1101}\u{1174}\u{11AC}", "\u{B065}", "\u{1101}\u{1174}\u{11AC}"),
    ("\u{B066}", "\u{B066}", "\u{1101}\u{1174}\u{11AD}", "\u{B066}", "\u{1101}\u{1174}\u{11AD}"),
    ("\u{B067}", "\u{B067}", "\u{1101}\u{1174}\u{11AE}", "\u{B067}", "\u{1101}\u{1174}\u{11AE}"),
    ("\u{B068}", "\u{B068}", "\u{1101}\u{1174}\u{11AF}", "\u{B068}", "\u{1101}\u{1174}\u{11AF}"),
    ("\u{B069}", "\u{B069}", "\u{1101}\u{1174}\u{11B0}", "\u{B069}", "\u{1101}\u{1174}\u{11B0}"),
    ("\u{B06A}", "\u{B06A}", "\u{1101}\u{1174}\u{11B1}", "\u{B06A}", "\u{1101}\u{1174}\u{11B1}"),
    ("\u{B06B}", "\u{B06B}", "\u{1101}\u{1174}\u{11B2}", "\u{B06B}", "\u{1101}\u{1174}\u{11B2}"),
    ("\u{B06C}", "\u{B06C}", "\u{1101}\u{1174}\u{11B3}", "\u{B06C}", "\u{1101}\u{1174}\u{11B3}"),
    ("\u{B06D}", "\u{B06D}", "\u{1101}\u{1174}\u{11B4}", "\u{B06D}", "\u{1101}\u{1174}\u{11B4}"),
    ("\u{B06E}", "\u{B06E}", "\u{1101}\u{1174}\u{11B5}", "\u{B06E}", "\u{1101}\u{1174}\u{11B5}"),
    ("\u{B06F}", "\u{B06F}", "\u{1101}\u{1174}\u{11B6}", "\u{B06F}", "\u{1101}\u{1174}\u{11B6}"),
    ("\u{B070}", "\u{B070}", "\u{1101}\u{1174}\u{11B7}", "\u{B070}", "\u{1101}\u{1174}\u{11B7}"),
    ("\u{B071}", "\u{B071}", "\u{1101}\u{1174}\u{11B8}", "\u{B071}", "\u{1101}\u{1174}\u{11B8}"),
    ("\u{B072}", "\u{B072}", "\u{1101}\u{1174}\u{11B9}", "\u{B072}", "\u{1101}\u{1174}\u{11B9}"),
    ("\u{B073}", "\u{B073}", "\u{1101}\u{1174}\u{11BA}", "\u{B073}", "\u{1101}\u{1174}\u{11BA}"),
    ("\u{B074}", "\u{B074}", "\u{1101}\u{1174}\u{11BB}", "\u{B074}", "\u{1101}\u{1174}\u{11BB}"),
    ("\u{B075}", "\u{B075}", "\u{1101}\u{1174}\u{11BC}", "\u{B075}", "\u{1101}\u{1174}\u{11BC}"),
    ("\u{B076}", "\u{B076}", "\u{1101}\u{1174}\u{11BD}", "\u{B076}", "\u{1101}\u{1174}\u{11BD}"),
    ("\u{B077}", "\u{B077}", "\u{1101}\u{1174}\u{11BE}", "\u{B077}", "\u{1101}\u{1174}\u{11BE}"),
    ("\u{B078}", "\u{B078}", "\u{1101}\u{1174}\u{11BF}", "\u{B078}", "\u{1101}\u{1174}\u{11BF}"),
    ("\u{B079}", "\u{B079}", "\u{1101}\u{1174}\u{11C0}", "\u{B079}", "\u{1101}\u{1174}\u{11C0}"),
    ("\u{B07A}", "\u{B07A}", "\u{1101}\u{1174}\u{11C1}", "\u{B07A}", "\u{1101}\u{1174}\u{11C1}"),
    ("\u{B07B}", "\u{B07B}", "\u{1101}\u{1174}\u{11C2}", "\u{B07B}", "\u{1101}\u{1174}\u{11C2}"),
    ("\u{B07C}", "\u{B07C}", "\u{1101}\u{1175}", "\u{B07C}", "\u{1101}\u{1175}"),
    ("\u{B07D}", "\u{B07D}", "\u{1101}\u{1175}\u{11A8}", "\u{B07D}", "\u{1101}\u{1175}\u{11A8}"),
    ("\u{B07E}", "\u{B07E}", "\u{1101}\u{1175}\u{11A9}", "\u{B07E}", "\u{1101}\u{1175}\u{11A9}"),
    ("\u{B07F}", "\u{B07F}", "\u{1101}\u{1175}\u{11AA}", "\u{B07F}", "\u{1101}\u{1175}\u{11AA}"),
    ("\u{B080}", "\u{B080}", "\u{1101}\u{1175}\u{11AB}", "\u{B080}", "\u{1101}\u{1175}\u{11AB}"),
    ("\u{B081}", "\u{B081}", "\u{1101}\u{1175}\u{11AC}", "\u{B081}", "\u{1101}\u{1175}\u{11AC}"),
    ("\u{B082}", "\u{B082}", "\u{1101}\u{1175}\u{11AD}", "\u{B082}", "\u{1101}\u{1175}\u{11AD}"),
    ("\u{B083}", "\u{B083}", "\u{1101}\u{1175}\u{11AE}", "\u{B083}", "\u{1101}\u{1175}\u{11AE}"),
    ("\u{B084}", "\u{B084}", "\u{1101}\u{1175}\u{11AF}", "\u{B084}", "\u{1101}\u{1175}\u{11AF}"),
    ("\u{B085}", "\u{B085}", "\u{1101}\u{1175}\u{11B0}", "\u{B085}", "\u{1101}\u{1175}\u{11B0}"),
    ("\u{B086}", "\u{B086}", "\u{1101}\u{1175}\u{11B1}", "\u{B086}", "\u{1101}\u{1175}\u{11B1}"),
    ("\u{B087}", "\u{B087}", "\u{1101}\u{1175}\u{11B2}", "\u{B087}", "\u{1101}\u{1175}\u{11B2}"),
    ("\u{B088}", "\u{B088}", "\u{1101}\u{1175}\u{11B3}", "\u{B088}", "\u{1101}\u{1175}\u{11B3}"),
    ("\u{B089}", "\u{B089}", "\u{1101}\u{1175}\u{11B4}", "\u{B089}", "\u{1101}\u{1175}\u{11B4}"),
    ("\u{B08A}", "\u{B08A}", "\u{1101}\u{1175}\u{11B5}", "\u{B08A}", "\u{1101}\u{1175}\u{11B5}"),
    ("\u{B08B}", "\u{B08B}", "\u{1101}\u{1175}\u{11B6}", "\u{B08B}", "\u{1101}\u{1175}\u{11B6}"),
    ("\u{B08C}", "\u{B08C}", "\u{1101}\u{1175}\u{11B7}", "\u{B08C}", "\u{1101}\u{1175}\u{11B7}"),
    ("\u{B08D}", "\u{B08D}", "\u{1101}\u{1175}\u{11B8}", "\u{B08D}", "\u{1101}\u{1175}\u{11B8}"),
    ("\u{B08E}", "\u{B08E}", "\u{1101}\u{1175}\u{11B9}", "\u{B08E}", "\u{1101}\u{1175}\u{11B9}"),
    ("\u{B08F}", "\u{B08F}", "\u{1101}\u{1175}\u{11BA}", "\u{B08F}", "\u{1101}\u{1175}\u{11BA}"),
    ("\u{B090}", "\u{B090}", "\u{1101}\u{1175}\u{11BB}", "\u{B090}", "\u{1101}\u{1175}\u{11BB}"),
    ("\u{B091}", "\u{B091}", "\u{1101}\u{1175}\u{11BC}", "\u{B091}", "\u{1101}\u{1175}\u{11BC}"),
    ("\u{B092}", "\u{B092}", "\u{1101}\u{1175}\u{11BD}", "\u{B092}", "\u{1101}\u{1175}\u{11BD}"),
    ("\u{B093}", "\u{B093}", "\u{1101}\u{1175}\u{11BE}", "\u{B093}", "\u{1101}\u{1175}\u{11BE}"),
    ("\u{B094}", "\u{B094}", "\u{1101}\u{1175}\u{11BF}", "\u{B094}", "\u{1101}\u{1175}\u{11BF}"),
    ("\u{B095}", "\u{B095}", "\u{1101}\u{1175}\u{11C0}", "\u{B095}", "\u{1101}\u{1175}\u{11C0}"),
    ("\u{B096}", "\u{B096}", "\u{1101}\u{1175}\u{11C1}", "\u{B096}", "\u{1101}\u{1175}\u{11C1}"),
    ("\u{B097}", "\u{B097}", "\u{1101}\u{1175}\u{11C2}", "\u{B097}", "\u{1101}\u{1175}\u{11C2}"),
    ("\u{B098}", "\u{B098}", "\u{1102}\u{1161}", "\u{B098}", "\u{1102}\u{1161}"),
    ("\u{B099}", "\u{B099}", "\u{1102}\u{1161}\u{11A8}", "\u{B099}", "\u{1102}\u{1161}\u{11A8}"),
    ("\u{B09A}", "\u{B09A}", "\u{1102}\u{1161}\u{11A9}", "\u{B09A}", "\u{1102}\u{1161}\u{11A9}"),
    ("\u{B09B}", "\u{B09B}", "\u{1102}\u{1161}\u{11AA}", "\u{B09B}", "\u{1102}\u{1161}\u{11AA}"),
    ("\u{B09C}", "\u{B09C}", "\u{1102}\u{1161}\u{11AB}", "\u{B09C}", "\u{1102}\u{1161}\u{11AB}"),
    ("\u{B09D}", "\u{B09D}", "\u{1102}\u{1161}\u{11AC}", "\u{B09D}", "\u{1102}\u{1161}\u{11AC}"),
    ("\u{B09E}", "\u{B09E}", "\u{1102}\u{1161}\u{11AD}", "\u{B09E}", "\u{1102}\u{1161}\u{11AD}"),
    ("\u{B09F}", "\u{B09F}", "\u{1102}\u{1161}\u{11AE}", "\u{B09F}", "\u{1102}\u{1161}\u{11AE}"),
    ("\u{B0A0}", "\u{B0A0}", "\u{1102}\u{1161}\u{11AF}", "\u{B0A0}", "\u{1102}\u{1161}\u{11AF}"),
    ("\u{B0A1}", "\u{B0A1}", "\u{1102}\u{1161}\u{11B0}", "\u{B0A1}", "\u{1102}\u{1161}\u{11B0}"),
    ("\u{B0A2}", "\u{B0A2}", "\u{1102}\u{1161}\u{11B1}", "\u{B0A2}", "\u{1102}\u{1161}\u{11B1}"),
    ("\u{B0A3}", "\u{B0A3}", "\u{1102}\u{1161}\u{11B2}", "\u{B0A3}", "\u{1102}\u{1161}\u{11B2}"),
    ("\u{B0A4}", "\u{B0A4}", "\u{1102}\u{1161}\u{11B3}", "\u{B0A4}", "\u{1102}\u{1161}\u{11B3}"),
    ("\u{B0A5}", "\u{B0A5}", "\u{1102}\u{1161}\u{11B4}", "\u{B0A5}", "\u{1102}\u{1161}\u{11B4}"),
    ("\u{B0A6}", "\u{B0A6}", "\u{1102}\u{1161}\u{11B5}", "\u{B0A6}", "\u{1102}\u{1161}\u{11B5}"),
    ("\u{B0A7}", "\u{B0A7}", "\u{1102}\u{1161}\u{11B6}", "\u{B0A7}", "\u{1102}\u{1161}\u{11B6}"),
    ("\u{B0A8}", "\u{B0A8}", "\u{1102}\u{1161}\u{11B7}", "\u{B0A8}", "\u{1102}\u{1161}\u{11B7}"),
    ("\u{B0A9}", "\u{B0A9}", "\u{1102}\u{1161}\u{11B8}", "\u{B0A9}", "\u{1102}\u{1161}\u{11B8}"),
    ("\u{B0AA}", "\u{B0AA}", "\u{1102}\u{1161}\u{11B9}", "\u{B0AA}", "\u{1102}\u{1161}\u{11B9}"),
    ("\u{B0AB}", "\u{B0AB}", "\u{1102}\u{1161}\u{11BA}", "\u{B0AB}", "\u{1102}\u{1161}\u{11BA}"),
    ("\u{B0AC}", "\u{B0AC}", "\u{1102}\u{1161}\u{11BB}", "\u{B0AC}", "\u{1102}\u{1161}\u{11BB}"),
    ("\u{B0AD}", "\u{B0AD}", "\u{1102}\u{1161}\u{11BC}", "\u{B0AD}", "\u{1102}\u{1161}\u{11BC}"),
    ("\u{B0AE}", "\u{B0AE}", "\u{1102}\u{1161}\u{11BD}", "\u{B0AE}", "\u{1102}\u{1161}\u{11BD}"),
    ("\u{B0AF}", "\u{B0AF}", "\u{1102}\u{1161}\u{11BE}", "\u{B0AF}", "\u{1102}\u{1161}\u{11BE}"),
    ("\u{B0B0}", "\u{B0B0}", "\u{1102}\u{1161}\u{11BF}", "\u{B0B0}", "\u{1102}\u{1161}\u{11BF}"),
    ("\u{B0B1}", "\u{B0B1}", "\u{1102}\u{1161}\u{11C0}", "\u{B0B1}", "\u{1102}\u{1161}\u{11C0}"),
    ("\u{B0B2}", "\u{B0B2}", "\u{1102}\u{1161}\u{11C1}", "\u{B0B2}", "\u{1102}\u{1161}\u{11C1}"),
    ("\u{B0B3}", "\u{B0B3}", "\u{1102}\u{1161}\u{11C2}", "\u{B0B3}", "\u{1102}\u{1161}\u{11C2}"),
    ("\u{B0B4}", "\u{B0B4}", "\u{1102}\u{1162}", "\u{B0B4}", "\u{1102}\u{1162}"),
    ("\u{B0B5}", "\u{B0B5}", "\u{1102}\u{1162}\u{11A8}", "\u{B0B5}", "\u{1102}\u{1162}\u{11A8}"),
    ("\u{B0B6}", "\u{B0B6}", "\u{1102}\u{1162}\u{11A9}", "\u{B0B6}", "\u{1102}\u{1162}\u{11A9}"),
    ("\u{B0B7}", "\u{B0B7}", "\u{1102}\u{1162}\u{11AA}", "\u{B0B7}", "\u{1102}\u{1162}\u{11AA}"),
    ("\u{B0B8}", "\u{B0B8}", "\u{1102}\u{1162}\u{11AB}", "\u{B0B8}", "\u{1102}\u{1162}\u{11AB}"),
    ("\u{B0B9}", "\u{B0B9}", "\u{1102}\u{1162}\u{11AC}", "\u{B0B9}", "\u{1102}\u{1162}\u{11AC}"),
    ("\u{B0BA}", "\u{B0BA}", "\u{1102}\u{1162}\u{11AD}", "\u{B0BA}", "\u{1102}\u{1162}\u{11AD}"),
    ("\u{B0BB}", "\u{B0BB}", "\u{1102}\u{1162}\u{11AE}", "\u{B0BB}", "\u{1102}\u{1162}\u{11AE}"),
    ("\u{B0BC}", "\u{B0BC}", "\u{1102}\u{1162}\u{11AF}", "\u{B0BC}", "\u{1102}\u{1162}\u{11AF}"),
    ("\u{B0BD}", "\u{B0BD}", "\u{1102}\u{1162}\u{11B0}", "\u{B0BD}", "\u{1102}\u{1162}\u{11B0}"),
    ("\u{B0BE}", "\u{B0BE}", "\u{1102}\u{1162}\u{11B1}", "\u{B0BE}", "\u{1102}\u{1162}\u{11B1}"),
    ("\u{B0BF}", "\u{B0BF}", "\u{1102}\u{1162}\u{11B2}", "\u{B0BF}", "\u{1102}\u{1162}\u{11B2}"),
    ("\u{B0C0}", "\u{B0C0}", "\u{1102}\u{1162}\u{11B3}", "\u{B0C0}", "\u{1102}\u{1162}\u{11B3}"),
    ("\u{B0C1}", "\u{B0C1}", "\u{1102}\u{1162}\u{11B4}", "\u{B0C1}", "\u{1102}\u{1162}\u{11B4}"),
    ("\u{B0C2}", "\u{B0C2}", "\u{1102}\u{1162}\u{11B5}", "\u{B0C2}", "\u{1102}\u{1162}\u{11B5}"),
    ("\u{B0C3}", "\u{B0C3}", "\u{1102}\u{1162}\u{11B6}", "\u{B0C3}", "\u{1102}\u{1162}\u{11B6}"),
    ("\u{B0C4}", "\u{B0C4}", "\u{1102}\u{1162}\u{11B7}", "\u{B0C4}", "\u{1102}\u{1162}\u{11B7}"),
    ("\u{B0C5}", "\u{B0C5}", "\u{1102}\u{1162}\u{11B8}", "\u{B0C5}", "\u{1102}\u{1162}\u{11B8}"),
    ("\u{B0C6}", "\u{B0C6}", "\u{1102}\u{1162}\u{11B9}", "\u{B0C6}", "\u{1102}\u{1162}\u{11B9}"),
    ("\u{B0C7}", "\u{B0C7}", "\u{1102}\u{1162}\u{11BA}", "\u{B0C7}", "\u{1102}\u{1162}\u{11BA}"),
    ("\u{B0C8}", "\u{B0C8}", "\u{1102}\u{1162}\u{11BB}", "\u{B0C8}", "\u{1102}\u{1162}\u{11BB}"),
    ("\u{B0C9}", "\u{B0C9}", "\u{1102}\u{1162}\u{11BC}", "\u{B0C9}", "\u{1102}\u{1162}\u{11BC}"),
    ("\u{B0CA}", "\u{B0CA}", "\u{1102}\u{1162}\u{11BD}", "\u{B0CA}", "\u{1102}\u{1162}\u{11BD}"),
    ("\u{B0CB}", "\u{B0CB}", "\u{1102}\u{1162}\u{11BE}", "\u{B0CB}", "\u{1102}\u{1162}\u{11BE}"),
    ("\u{B0CC}", "\u{B0CC}", "\u{1102}\u{1162}\u{11BF}", "\u{B0CC}", "\u{1102}\u{1162}\u{11BF}"),
    ("\u{B0CD}", "\u{B0CD}", "\u{1102}\u{1162}\u{11C0}", "\u{B0CD}", "\u{1102}\u{1162}\u{11C0}"),
    ("\u{B0CE}", "\u{B0CE}", "\u{1102}\u{1162}\u{11C1}", "\u{B0CE}", "\u{1102}\u{1162}\u{11C1}"),
    ("\u{B0CF}", "\u{B0CF}", "\u{1102}\u{1162}\u{11C2}", "\u{B0CF}", "\u{1102}\u{1162}\u{11C2}"),
    ("\u{B0D0}", "\u{B0D0}", "\u{1102}\u{1163}", "\u{B0D0}", "\u{1102}\u{1163}"),
    ("\u{B0D1}", "\u{B0D1}", "\u{1102}\u{1163}\u{11A8}", "\u{B0D1}", "\u{1102}\u{1163}\u{11A8}"),
    ("\u{B0D2}", "\u{B0D2}", "\u{1102}\u{1163}\u{11A9}", "\u{B0D2}", "\u{1102}\u{1163}\u{11A9}"),
    ("\u{B0D3}", "\u{B0D3}", "\u{1102}\u{1163}\u{11AA}", "\u{B0D3}", "\u{1102}\u{1163}\u{11AA}"),
    ("\u{B0D4}", "\u{B0D4}", "\u{1102}\u{1163}\u{11AB}", "\u{B0D4}", "\u{1102}\u{1163}\u{11AB}"),
    ("\u{B0D5}", "\u{B0D5}", "\u{1102}\u{1163}\u{11AC}", "\u{B0D5}", "\u{1102}\u{1163}\u{11AC}"),
    ("\u{B0D6}", "\u{B0D6}", "\u{1102}\u{1163}\u{11AD}", "\u{B0D6}", "\u{1102}\u{1163}\u{11AD}"),
    ("\u{B0D7}", "\u{B0D7}", "\u{1102}\u{1163}\u{11AE}", "\u{B0D7}", "\u{1102}\u{1163}\u{11AE}"),
    ("\u{B0D8}", "\u{B0D8}", "\u{1102}\u{1163}\u{11AF}", "\u{B0D8}", "\u{1102}\u{1163}\u{11AF}"),
    ("\u{B0D9}", "\u{B0D9}", "\u{1102}\u{1163}\u{11B0}", "\u{B0D9}", "\u{1102}\u{1163}\u{11B0}"),
    ("\u{B0DA}", "\u{B0DA}", "\u{1102}\u{1163}\u{11B1}", "\u{B0DA}", "\u{1102}\u{1163}\u{11B1}"),
    ("\u{B0DB}", "\u{B0DB}", "\u{1102}\u{1163}\u{11B2}", "\u{B0DB}", "\u{1102}\u{1163}\u{11B2}"),
    ("\u{B0DC}", "\u{B0DC}", "\u{1102}\u{1163}\u{11B3}", "\u{B0DC}", "\u{1102}\u{1163}\u{11B3}"),
    ("\u{B0DD}", "\u{B0DD}", "\u{1102}\u{1163}\u{11B4}", "\u{B0DD}", "\u{1102}\u{1163}\u{11B4}"),
    ("\u{B0DE}", "\u{B0DE}", "\u{1102}\u{1163}\u{11B5}", "\u{B0DE}", "\u{1102}\u{1163}\u{11B5}"),
    ("\u{B0DF}", "\u{B0DF}", "\u{1102}\u{1163}\u{11B6}", "\u{B0DF}", "\u{1102}\u{1163}\u{11B6}"),
    ("\u{B0E0}", "\u{B0E0}", "\u{1102}\u{1163}\u{11B7}", "\u{B0E0}", "\u{1102}\u{1163}\u{11B7}"),
    ("\u{B0E1}", "\u{B0E1}", "\u{1102}\u{1163}\u{11B8}", "\u{B0E1}", "\u{1102}\u{1163}\u{11B8}"),
    ("\u{B0E2}", "\u{B0E2}", "\u{1102}\u{1163}\u{11B9}", "\u{B0E2}", "\u{1102}\u{1163}\u{11B9}"),
    ("\u{B0E3}", "\u{B0E3}", "\u{1102}\u{1163}\u{11BA}", "\u{B0E3}", "\u{1102}\u{1163}\u{11BA}"),
    ("\u{B0E4}", "\u{B0E4}", "\u{1102}\u{1163}\u{11BB}", "\u{B0E4}", "\u{1102}\u{1163}\u{11BB}"),
    ("\u{B0E5}", "\u{B0E5}", "\u{1102}\u{1163}\u{11BC}", "\u{B0E5}", "\u{1102}\u{1163}\u{11BC}"),
    ("\u{B0E6}", "\u{B0E6}", "\u{1102}\u{1163}\u{11BD}", "\u{B0E6}", "\u{1102}\u{1163}\u{11BD}"),
    ("\u{B0E7}", "\u{B0E7}", "\u{1102}\u{1163}\u{11BE}", "\u{B0E7}", "\u{1102}\u{1163}\u{11BE}"),
    ("\u{B0E8}", "\u{B0E8}", "\u{1102}\u{1163}\u{11BF}", "\u{B0E8}", "\u{1102}\u{1163}\u{11BF}"),
    ("\u{B0E9}", "\u{B0E9}", "\u{1102}\u{1163}\u{11C0}", "\u{B0E9}", "\u{1102}\u{1163}\u{11C0}"),
    ("\u{B0EA}", "\u{B0EA}", "\u{1102}\u{1163}\u{11C1}", "\u{B0EA}", "\u{1102}\u{1163}\u{11C1}"),
    ("\u{B0EB}", "\u{B0EB}", "\u{1102}\u{1163}\u{11C2}", "\u{B0EB}", "\u{1102}\u{1163}\u{11C2}"),
    ("\u{B0EC}", "\u{B0EC}", "\u{1102}\u{1164}", "\u{B0EC}", "\u{1102}\u{1164}"),
    ("\u{B0ED}", "\u{B0ED}", "\u{1102}\u{1164}\u{11A8}", "\u{B0ED}", "\u{1102}\u{1164}\u{11A8}"),
    ("\u{B0EE}", "\u{B0EE}", "\u{1102}\u{1164}\u{11A9}", "\u{B0EE}", "\u{1102}\u{1164}\u{11A9}"),
    ("\u{B0EF}", "\u{B0EF}", "\u{1102}\u{1164}\u{11AA}", "\u{B0EF}", "\u{1102}\u{1164}\u{11AA}"),
    ("\u{B0F0}", "\u{B0F0}", "\u{1102}\u{1164}\u{11AB}", "\u{B0F0}", "\u{1102}\u{1164}\u{11AB}"),
    ("\u{B0F1}", "\u{B0F1}", "\u{1102}\u{1164}\u{11AC}", "\u{B0F1}", "\u{1102}\u{1164}\u{11AC}"),
    ("\u{B0F2}", "\u{B0F2}", "\u{1102}\u{1164}\u{11AD}", "\u{B0F2}", "\u{1102}\u{1164}\u{11AD}"),
    ("\u{B0F3}", "\u{B0F3}", "\u{1102}\u{1164}\u{11AE}", "\u{B0F3}", "\u{1102}\u{1164}\u{11AE}"),
    ("\u{B0F4}", "\u{B0F4}", "\u{1102}\u{1164}\u{11AF}", "\u{B0F4}", "\u{1102}\u{1164}\u{11AF}"),
    ("\u{B0F5}", "\u{B0F5}", "\u{1102}\u{1164}\u{11B0}", "\u{B0F5}", "\u{1102}\u{1164}\u{11B0}"),
    ("\u{B0F6}", "\u{B0F6}", "\u{1102}\u{1164}\u{11B1}", "\u{B0F6}", "\u{1102}\u{1164}\u{11B1}"),
    ("\u{B0F7}", "\u{B0F7}", "\u{1102}\u{1164}\u{11B2}", "\u{B0F7}", "\u{1102}\u{1164}\u{11B2}"),
    ("\u{B0F8}", "\u{B0F8}", "\u{1102}\u{1164}\u{11B3}", "\u{B0F8}", "\u{1102}\u{1164}\u{11B3}"),
    ("\u{B0F9}", "\u{B0F9}", "\u{1102}\u{1164}\u{11B4}", "\u{B0F9}", "\u{1102}\u{1164}\u{11B4}"),
    ("\u{B0FA}", "\u{B0FA}", "\u{1102}\u{1164}\u{11B5}", "\u{B0FA}", "\u{1102}\u{1164}\u{11B5}"),
    ("\u{B0FB}", "\u{B0FB}", "\u{1102}\u{1164}\u{11B6}", "\u{B0FB}", "\u{1102}\u{1164}\u{11B6}"),
    ("\u{B0FC}", "\u{B0FC}", "\u{1102}\u{1164}\u{11B7}", "\u{B0FC}", "\u{1102}\u{1164}\u{11B7}"),
    ("\u{B0FD}", "\u{B0FD}", "\u{1102}\u{1164}\u{11B8}", "\u{B0FD}", "\u{1102}\u{1164}\u{11B8}"),
    ("\u{B0FE}", "\u{B0FE}", "\u{1102}\u{1164}\u{11B9}", "\u{B0FE}", "\u{1102}\u{1164}\u{11B9}"),
    ("\u{B0FF}", "\u{B0FF}", "\u{1102}\u{1164}\u{11BA}", "\u{B0FF}", "\u{1102}\u{1164}\u{11BA}"),
    ("\u{B100}", "\u{B100}", "\u{1102}\u{1164}\u{11BB}", "\u{B100}", "\u{1102}\u{1164}\u{11BB}"),
    ("\u{B101}", "\u{B101}", "\u{1102}\u{1164}\u{11BC}", "\u{B101}", "\u{1102}\u{1164}\u{11BC}"),
    ("\u{B102}", "\u{B102}", "\u{1102}\u{1164}\u{11BD}", "\u{B102}", "\u{1102}\u{1164}\u{11BD}"),
    ("\u{B103}", "\u{B103}", "\u{1102}\u{1164}\u{11BE}", "\u{B103}", "\u{1102}\u{1164}\u{11BE}"),
    ("\u{B104}", "\u{B104}", "\u{1102}\u{1164}\u{11BF}", "\u{B104}", "\u{1102}\u{1164}\u{11BF}"),
    ("\u{B105}", "\u{B105}", "\u{1102}\u{1164}\u{11C0}", "\u{B105}", "\u{1102}\u{1164}\u{11C0}"),
    ("\u{B106}", "\u{B106}", "\u{1102}\u{1164}\u{11C1}", "\u{B106}", "\u{1102}\u{1164}\u{11C1}"),
    ("\u{B107}", "\u{B107}", "\u{1102}\u{1164}\u{11C2}", "\u{B107}", "\u{1102}\u{1164}\u{11C2}"),
    ("\u{B108}", "\u{B108}", "\u{1102}\u{1165}", "\u{B108}", "\u{1102}\u{1165}"),
    ("\u{B109}", "\u{B109}", "\u{1102}\u{1165}\u{11A8}", "\u{B109}", "\u{1102}\u{1165}\u{11A8}"),
    ("\u{B10A}", "\u{B10A}", "\u{1102}\u{1165}\u{11A9}", "\u{B10A}", "\u{1102}\u{1165}\u{11A9}"),
    ("\u{B10B}", "\u{B10B}", "\u{1102}\u{1165}\u{11AA}", "\u{B10B}", "\u{1102}\u{1165}\u{11AA}"),
    ("\u{B10C}", "\u{B10C}", "\u{1102}\u{1165}\u{11AB}", "\u{B10C}", "\u{1102}\u{1165}\u{11AB}"),
    ("\u{B10D}", "\u{B10D}", "\u{1102}\u{1165}\u{11AC}", "\u{B10D}", "\u{1102}\u{1165}\u{11AC}"),
    ("\u{B10E}", "\u{B10E}", "\u{1102}\u{1165}\u{11AD}", "\u{B10E}", "\u{1102}\u{1165}\u{11AD}"),
    ("\u{B10F}", "\u{B10F}", "\u{1102}\u{1165}\u{11AE}", "\u{B10F}", "\u{1102}\u{1165}\u{11AE}"),
    ("\u{B110}", "\u{B110}", "\u{1102}\u{1165}\u{11AF}", "\u{B110}", "\u{1102}\u{1165}\u{11AF}"),
    ("\u{B111}", "\u{B111}", "\u{1102}\u{1165}\u{11B0}", "\u{B111}", "\u{1102}\u{1165}\u{11B0}"),
    ("\u{B112}", "\u{B112}", "\u{1102}\u{1165}\u{11B1}", "\u{B112}", "\u{1102}\u{1165}\u{11B1}"),
    ("\u{B113}", "\u{B113}", "\u{1102}\u{1165}\u{11B2}", "\u{B113}", "\u{1102}\u{1165}\u{11B2}"),
    ("\u{B114}", "\u{B114}", "\u{1102}\u{1165}\u{11B3}", "\u{B114}", "\u{1102}\u{1165}\u{11B3}"),
    ("\u{B115}", "\u{B115}", "\u{1102}\u{1165}\u{11B4}", "\u{B115}", "\u{1102}\u{1165}\u{11B4}"),
    ("\u{B116}", "\u{B116}", "\u{1102}\u{1165}\u{11B5}", "\u{B116}", "\u{1102}\u{1165}\u{11B5}"),
    ("\u{B117}", "\u{B117}", "\u{1102}\u{1165}\u{11B6}", "\u{B117}", "\u{1102}\u{1165}\u{11B6}"),
    ("\u{B118}", "\u{B118}", "\u{1102}\u{1165}\u{11B7}", "\u{B118}", "\u{1102}\u{1165}\u{11B7}"),
    ("\u{B119}", "\u{B119}", "\u{1102}\u{1165}\u{11B8}", "\u{B119}", "\u{1102}\u{1165}\u{11B8}"),
    ("\u{B11A}", "\u{B11A}", "\u{1102}\u{1165}\u{11B9}", "\u{B11A}", "\u{1102}\u{1165}\u{11B9}"),
    ("\u{B11B}", "\u{B11B}", "\u{1102}\u{1165}\u{11BA}", "\u{B11B}", "\u{1102}\u{1165}\u{11BA}"),
    ("\u{B11C}", "\u{B11C}", "\u{1102}\u{1165}\u{11BB}", "\u{B11C}", "\u{1102}\u{1165}\u{11BB}"),
    ("\u{B11D}", "\u{B11D}", "\u{1102}\u{1165}\u{11BC}", "\u{B11D}", "\u{1102}\u{1165}\u{11BC}"),
    ("\u{B11E}", "\u{B11E}", "\u{1102}\u{1165}\u{11BD}", "\u{B11E}", "\u{1102}\u{1165}\u{11BD}"),
    ("\u{B11F}", "\u{B11F}", "\u{1102}\u{1165}\u{11BE}", "\u{B11F}", "\u{1102}\u{1165}\u{11BE}"),
    ("\u{B120}", "\u{B120}", "\u{1102}\u{1165}\u{11BF}", "\u{B120}", "\u{1102}\u{1165}\u{11BF}"),
    ("\u{B121}", "\u{B121}", "\u{1102}\u{1165}\u{11C0}", "\u{B121}", "\u{1102}\u{1165}\u{11C0}"),
    ("\u{B122}", "\u{B122}", "\u{1102}\u{1165}\u{11C1}", "\u{B122}", "\u{1102}\u{1165}\u{11C1}"),
    ("\u{B123}", "\u{B123}", "\u{1102}\u{1165}\u{11C2}", "\u{B123}", "\u{1102}\u{1165}\u{11C2}"),
    ("\u{B124}", "\u{B124}", "\u{1102}\u{1166}", "\u{B124}", "\u{1102}\u{1166}"),
    ("\u{B125}", "\u{B125}", "\u{1102}\u{1166}\u{11A8}", "\u{B125}", "\u{1102}\u{1166}\u{11A8}"),
    ("\u{B126}", "\u{B126}", "\u{1102}\u{1166}\u{11A9}", "\u{B126}", "\u{1102}\u{1166}\u{11A9}"),
    ("\u{B127}", "\u{B127}", "\u{1102}\u{1166}\u{11AA}", "\u{B127}", "\u{1102}\u{1166}\u{11AA}"),
    ("\u{B128}", "\u{B128}", "\u{1102}\u{1166}\u{11AB}", "\u{B128}", "\u{1102}\u{1166}\u{11AB}"),
    ("\u{B129}", "\u{B129}", "\u{1102}\u{1166}\u{11AC}", "\u{B129}", "\u{1102}\u{1166}\u{11AC}"),
    ("\u{B12A}", "\u{B12A}", "\u{1102}\u{1166}\u{11AD}", "\u{B12A}", "\u{1102}\u{1166}\u{11AD}"),
    ("\u{B12B}", "\u{B12B}", "\u{1102}\u{1166}\u{11AE}", "\u{B12B}", "\u{1102}\u{1166}\u{11AE}"),
    ("\u{B12C}", "\u{B12C}", "\u{1102}\u{1166}\u{11AF}", "\u{B12C}", "\u{1102}\u{1166}\u{11AF}"),
    ("\u{B12D}", "\u{B12D}", "\u{1102}\u{1166}\u{11B0}", "\u{B12D}", "\u{1102}\u{1166}\u{11B0}"),
    ("\u{B12E}", "\u{B12E}", "\u{1102}\u{1166}\u{11B1}", "\u{B12E}", "\u{1102}\u{1166}\u{11B1}"),
    ("\u{B12F}", "\u{B12F}", "\u{1102}\u{1166}\u{11B2}", "\u{B12F}", "\u{1102}\u{1166}\u{11B2}"),
    ("\u{B130}", "\u{B130}", "\u{1102}\u{1166}\u{11B3}", "\u{B130}", "\u{1102}\u{1166}\u{11B3}"),
    ("\u{B131}", "\u{B131}", "\u{1102}\u{1166}\u{11B4}", "\u{B131}", "\u{1102}\u{1166}\u{11B4}"),
    ("\u{B132}", "\u{B132}", "\u{1102}\u{1166}\u{11B5}", "\u{B132}", "\u{1102}\u{1166}\u{11B5}"),
    ("\u{B133}", "\u{B133}", "\u{1102}\u{1166}\u{11B6}", "\u{B133}", "\u{1102}\u{1166}\u{11B6}"),
    ("\u{B134}", "\u{B134}", "\u{1102}\u{1166}\u{11B7}", "\u{B134}", "\u{1102}\u{1166}\u{11B7}"),
    ("\u{B135}", "\u{B135}", "\u{1102}\u{1166}\u{11B8}", "\u{B135}", "\u{1102}\u{1166}\u{11B8}"),
    ("\u{B136}", "\u{B136}", "\u{1102}\u{1166}\u{11B9}", "\u{B136}", "\u{1102}\u{1166}\u{11B9}"),
    ("\u{B137}", "\u{B137}", "\u{1102}\u{1166}\u{11BA}", "\u{B137}", "\u{1102}\u{1166}\u{11BA}"),
    ("\u{B138}", "\u{B138}", "\u{1102}\u{1166}\u{11BB}", "\u{B138}", "\u{1102}\u{1166}\u{11BB}"),
    ("\u{B139}", "\u{B139}", "\u{1102}\u{1166}\u{11BC}", "\u{B139}", "\u{1102}\u{1166}\u{11BC}"),
    ("\u{B13A}", "\u{B13A}", "\u{1102}\u{1166}\u{11BD}", "\u{B13A}", "\u{1102}\u{1166}\u{11BD}"),
    ("\u{B13B}", "\u{B13B}", "\u{1102}\u{1166}\u{11BE}", "\u{B13B}", "\u{1102}\u{1166}\u{11BE}"),
    ("\u{B13C}", "\u{B13C}", "\u{1102}\u{1166}\u{11BF}", "\u{B13C}", "\u{1102}\u{1166}\u{11BF}"),
    ("\u{B13D}", "\u{B13D}", "\u{1102}\u{1166}\u{11C0}", "\u{B13D}", "\u{1102}\u{1166}\u{11C0}"),
    ("\u{B13E}", "\u{B13E}", "\u{1102}\u{1166}\u{11C1}", "\u{B13E}", "\u{1102}\u{1166}\u{11C1}"),
    ("\u{B13F}", "\u{B13F}", "\u{1102}\u{1166}\u{11C2}", "\u{B13F}", "\u{1102}\u{1166}\u{11C2}"),
    ("\u{B140}", "\u{B140}", "\u{1102}\u{1167}", "\u{B140}", "\u{1102}\u{1167}"),
    ("\u{B141}", "\u{B141}", "\u{1102}\u{1167}\u{11A8}", "\u{B141}", "\u{1102}\u{1167}\u{11A8}"),
    ("\u{B142}", "\u{B142}", "\u{1102}\u{1167}\u{11A9}", "\u{B142}", "\u{1102}\u{1167}\u{11A9}"),
    ("\u{B143}", "\u{B143}", "\u{1102}\u{1167}\u{11AA}", "\u{B143}", "\u{1102}\u{1167}\u{11AA}"),
    ("\u{B144}", "\u{B144}", "\u{1102}\u{1167}\u{11AB}", "\u{B144}", "\u{1102}\u{1167}\u{11AB}"),
    ("\u{B145}", "\u{B145}", "\u{1102}\u{1167}\u{11AC}", "\u{B145}", "\u{1102}\u{1167}\u{11AC}"),
    ("\u{B146}", "\u{B146}", "\u{1102}\u{1167}\u{11AD}", "\u{B146}", "\u{1102}\u{1167}\u{11AD}"),
    ("\u{B147}", "\u{B147}", "\u{1102}\u{1167}\u{11AE}", "\u{B147}", "\u{1102}\u{1167}\u{11AE}"),
    ("\u{B148}", "\u{B148}", "\u{1102}\u{1167}\u{11AF}", "\u{B148}", "\u{1102}\u{1167}\u{11AF}"),
    ("\u{B149}", "\u{B149}", "\u{1102}\u{1167}\u{11B0}", "\u{B149}", "\u{1102}\u{1167}\u{11B0}"),
    ("\u{B14A}", "\u{B14A}", "\u{1102}\u{1167}\u{11B1}", "\u{B14A}", "\u{1102}\u{1167}\u{11B1}"),
    ("\u{B14B}", "\u{B14B}", "\u{1102}\u{1167}\u{11B2}", "\u{B14B}", "\u{1102}\u{1167}\u{11B2}"),
    ("\u{B14C}", "\u{B14C}", "\u{1102}\u{1167}\u{11B3}", "\u{B14C}", "\u{1102}\u{1167}\u{11B3}"),
    ("\u{B14D}", "\u{B14D}", "\u{1102}\u{1167}\u{11B4}", "\u{B14D}", "\u{1102}\u{1167}\u{11B4}"),
    ("\u{B14E}", "\u{B14E}", "\u{1102}\u{1167}\u{11B5}", "\u{B14E}", "\u{1102}\u{1167}\u{11B5}"),
    ("\u{B14F}", "\u{B14F}", "\u{1102}\u{1167}\u{11B6}", "\u{B14F}", "\u{1102}\u{1167}\u{11B6}"),
    ("\u{B150}", "\u{B150}", "\u{1102}\u{1167}\u{11B7}", "\u{B150}", "\u{1102}\u{1167}\u{11B7}"),
    ("\u{B151}", "\u{B151}", "\u{1102}\u{1167}\u{11B8}", "\u{B151}", "\u{1102}\u{1167}\u{11B8}"),
    ("\u{B152}", "\u{B152}", "\u{1102}\u{1167}\u{11B9}", "\u{B152}", "\u{1102}\u{1167}\u{11B9}"),
    ("\u{B153}", "\u{B153}", "\u{1102}\u{1167}\u{11BA}", "\u{B153}", "\u{1102}\u{1167}\u{11BA}"),
    ("\u{B154}", "\u{B154}", "\u{1102}\u{1167}\u{11BB}", "\u{B154}", "\u{1102}\u{1167}\u{11BB}"),
    ("\u{B155}", "\u{B155}", "\u{1102}\u{1167}\u{11BC}", "\u{B155}", "\u{1102}\u{1167}\u{11BC}"),
    ("\u{B156}", "\u{B156}", "\u{1102}\u{1167}\u{11BD}", "\u{B156}", "\u{1102}\u{1167}\u{11BD}"),
    ("\u{B157}", "\u{B157}", "\u{1102}\u{1167}\u{11BE}", "\u{B157}", "\u{1102}\u{1167}\u{11BE}"),
    ("\u{B158}", "\u{B158}", "\u{1102}\u{1167}\u{11BF}", "\u{B158}", "\u{1102}\u{1167}\u{11BF}"),
    ("\u{B159}", "\u{B159}", "\u{1102}\u{1167}\u{11C0}", "\u{B159}", "\u{1102}\u{1167}\u{11C0}"),
    ("\u{B15A}", "\u{B15A}", "\u{1102}\u{1167}\u{11C1}", "\u{B15A}", "\u{1102}\u{1167}\u{11C1}"),
    ("\u{B15B}", "\u{B15B}", "\u{1102}\u{1167}\u{11C2}", "\u{B15B}", "\u{1102}\u{1167}\u{11C2}"),
    ("\u{B15C}", "\u{B15C}", "\u{1102}\u{1168}", "\u{B15C}", "\u{1102}\u{1168}"),
    ("\u{B15D}", "\u{B15D}", "\u{1102}\u{1168}\u{11A8}", "\u{B15D}", "\u{1102}\u{1168}\u{11A8}"),
    ("\u{B15E}", "\u{B15E}", "\u{1102}\u{1168}\u{11A9}", "\u{B15E}", "\u{1102}\u{1168}\u{11A9}"),
    ("\u{B15F}", "\u{B15F}", "\u{1102}\u{1168}\u{11AA}", "\u{B15F}", "\u{1102}\u{1168}\u{11AA}"),
    ("\u{B160}", "\u{B160}", "\u{1102}\u{1168}\u{11AB}", "\u{B160}", "\u{1102}\u{1168}\u{11AB}"),
    ("\u{B161}", "\u{B161}", "\u{1102}\u{1168}\u{11AC}", "\u{B161}", "\u{1102}\u{1168}\u{11AC}"),
    ("\u{B162}", "\u{B162}", "\u{1102}\u{1168}\u{11AD}", "\u{B162}", "\u{1102}\u{1168}\u{11AD}"),
    ("\u{B163}", "\u{B163}", "\u{1102}\u{1168}\u{11AE}", "\u{B163}", "\u{1102}\u{1168}\u{11AE}"),
    ("\u{B164}", "\u{B164}", "\u{1102}\u{1168}\u{11AF}", "\u{B164}", "\u{1102}\u{1168}\u{11AF}"),
    ("\u{B165}", "\u{B165}", "\u{1102}\u{1168}\u{11B0}", "\u{B165}", "\u{1102}\u{1168}\u{11B0}"),
    ("\u{B166}", "\u{B166}", "\u{1102}\u{1168}\u{11B1}", "\u{B166}", "\u{1102}\u{1168}\u{11B1}"),
    ("\u{B167}", "\u{B167}", "\u{1102}\u{1168}\u{11B2}", "\u{B167}", "\u{1102}\u{1168}\u{11B2}"),
    ("\u{B168}", "\u{B168}", "\u{1102}\u{1168}\u{11B3}", "\u{B168}", "\u{1102}\u{1168}\u{11B3}"),
    ("\u{B169}", "\u{B169}", "\u{1102}\u{1168}\u{11B4}", "\u{B169}", "\u{1102}\u{1168}\u{11B4}"),
    ("\u{B16A}", "\u{B16A}", "\u{1102}\u{1168}\u{11B5}", "\u{B16A}", "\u{1102}\u{1168}\u{11B5}"),
    ("\u{B16B}", "\u{B16B}", "\u{1102}\u{1168}\u{11B6}", "\u{B16B}", "\u{1102}\u{1168}\u{11B6}"),
    ("\u{B16C}", "\u{B16C}", "\u{1102}\u{1168}\u{11B7}", "\u{B16C}", "\u{1102}\u{1168}\u{11B7}"),
    ("\u{B16D}", "\u{B16D}", "\u{1102}\u{1168}\u{11B8}", "\u{B16D}", "\u{1102}\u{1168}\u{11B8}"),
    ("\u{B16E}", "\u{B16E}", "\u{1102}\u{1168}\u{11B9}", "\u{B16E}", "\u{1102}\u{1168}\u{11B9}"),
    ("\u{B16F}", "\u{B16F}", "\u{1102}\u{1168}\u{11BA}", "\u{B16F}", "\u{1102}\u{1168}\u{11BA}"),
    ("\u{B170}", "\u{B170}", "\u{1102}\u{1168}\u{11BB}", "\u{B170}", "\u{1102}\u{1168}\u{11BB}"),
    ("\u{B171}", "\u{B171}", "\u{1102}\u{1168}\u{11BC}", "\u{B171}", "\u{1102}\u{1168}\u{11BC}"),
    ("\u{B172}", "\u{B172}", "\u{1102}\u{1168}\u{11BD}", "\u{B172}", "\u{1102}\u{1168}\u{11BD}"),
    ("\u{B173}", "\u{B173}", "\u{1102}\u{1168}\u{11BE}", "\u{B173}", "\u{1102}\u{1168}\u{11BE}"),
    ("\u{B174}", "\u{B174}", "\u{1102}\u{1168}\u{11BF}", "\u{B174}", "\u{1102}\u{1168}\u{11BF}"),
    ("\u{B175}", "\u{B175}", "\u{1102}\u{1168}\u{11C0}", "\u{B175}", "\u{1102}\u{1168}\u{11C0}"),
    ("\u{B176}", "\u{B176}", "\u{1102}\u{1168}\u{11C1}", "\u{B176}", "\u{1102}\u{1168}\u{11C1}"),
    ("\u{B177}", "\u{B177}", "\u{1102}\u{1168}\u{11C2}", "\u{B177}", "\u{1102}\u{1168}\u{11C2}"),
    ("\u{B178}", "\u{B178}", "\u{1102}\u{1169}", "\u{B178}", "\u{1102}\u{1169}"),
    ("\u{B179}", "\u{B179}", "\u{1102}\u{1169}\u{11A8}", "\u{B179}", "\u{1102}\u{1169}\u{11A8}"),
    ("\u{B17A}", "\u{B17A}", "\u{1102}\u{1169}\u{11A9}", "\u{B17A}", "\u{1102}\u{1169}\u{11A9}"),
    ("\u{B17B}", "\u{B17B}", "\u{1102}\u{1169}\u{11AA}", "\u{B17B}", "\u{1102}\u{1169}\u{11AA}"),
    ("\u{B17C}", "\u{B17C}", "\u{1102}\u{1169}\u{11AB}", "\u{B17C}", "\u{1102}\u{1169}\u{11AB}"),
    ("\u{B17D}", "\u{B17D}", "\u{1102}\u{1169}\u{11AC}", "\u{B17D}", "\u{1102}\u{1169}\u{11AC}"),
    ("\u{B17E}", "\u{B17E}", "\u{1102}\u{1169}\u{11AD}", "\u{B17E}", "\u{1102}\u{1169}\u{11AD}"),
    ("\u{B17F}", "\u{B17F}", "\u{1102}\u{1169}\u{11AE}", "\u{B17F}", "\u{1102}\u{1169}\u{11AE}"),
    ("\u{B180}", "\u{B180}", "\u{1102}\u{1169}\u{11AF}", "\u{B180}", "\u{1102}\u{1169}\u{11AF}"),
    ("\u{B181}", "\u{B181}", "\u{1102}\u{1169}\u{11B0}", "\u{B181}", "\u{1102}\u{1169}\u{11B0}"),
    ("\u{B182}", "\u{B182}", "\u{1102}\u{1169}\u{11B1}", "\u{B182}", "\u{1102}\u{1169}\u{11B1}"),
    ("\u{B183}", "\u{B183}", "\u{1102}\u{1169}\u{11B2}", "\u{B183}", "\u{1102}\u{1169}\u{11B2}"),
    ("\u{B184}", "\u{B184}", "\u{1102}\u{1169}\u{11B3}", "\u{B184}", "\u{1102}\u{1169}\u{11B3}"),
    ("\u{B185}", "\u{B185}", "\u{1102}\u{1169}\u{11B4}", "\u{B185}", "\u{1102}\u{1169}\u{11B4}"),
    ("\u{B186}", "\u{B186}", "\u{1102}\u{1169}\u{11B5}", "\u{B186}", "\u{1102}\u{1169}\u{11B5}"),
    ("\u{B187}", "\u{B187}", "\u{1102}\u{1169}\u{11B6}", "\u{B187}", "\u{1102}\u{1169}\u{11B6}"),
    ("\u{B188}", "\u{B188}", "\u{1102}\u{1169}\u{11B7}", "\u{B188}", "\u{1102}\u{1169}\u{11B7}"),
    ("\u{B189}", "\u{B189}", "\u{1102}\u{1169}\u{11B8}", "\u{B189}", "\u{1102}\u{1169}\u{11B8}"),
    ("\u{B18A}", "\u{B18A}", "\u{1102}\u{1169}\u{11B9}", "\u{B18A}", "\u{1102}\u{1169}\u{11B9}"),
    ("\u{B18B}", "\u{B18B}", "\u{1102}\u{1169}\u{11BA}", "\u{B18B}", "\u{1102}\u{1169}\u{11BA}"),
    ("\u{B18C}", "\u{B18C}", "\u{1102}\u{1169}\u{11BB}", "\u{B18C}", "\u{1102}\u{1169}\u{11BB}"),
    ("\u{B18D}", "\u{B18D}", "\u{1102}\u{1169}\u{11BC}", "\u{B18D}", "\u{1102}\u{1169}\u{11BC}"),
    ("\u{B18E}", "\u{B18E}", "\u{1102}\u{1169}\u{11BD}", "\u{B18E}", "\u{1102}\u{1169}\u{11BD}"),
    ("\u{B18F}", "\u{B18F}", "\u{1102}\u{1169}\u{11BE}", "\u{B18F}", "\u{1102}\u{1169}\u{11BE}"),
    ("\u{B190}", "\u{B190}", "\u{1102}\u{1169}\u{11BF}", "\u{B190}", "\u{1102}\u{1169}\u{11BF}"),
    ("\u{B191}", "\u{B191}", "\u{1102}\u{1169}\u{11C0}", "\u{B191}", "\u{1102}\u{1169}\u{11C0}"),
    ("\u{B192}", "\u{B192}", "\u{1102}\u{1169}\u{11C1}", "\u{B192}", "\u{1102}\u{1169}\u{11C1}"),
    ("\u{B193}", "\u{B193}", "\u{1102}\u{1169}\u{11C2}", "\u{B193}", "\u{1102}\u{1169}\u{11C2}"),
    ("\u{B194}", "\u{B194}", "\u{1102}\u{116A}", "\u{B194}", "\u{1102}\u{116A}"),
    ("\u{B195}", "\u{B195}", "\u{1102}\u{116A}\u{11A8}", "\u{B195}", "\u{1102}\u{116A}\u{11A8}"),
    ("\u{B196}", "\u{B196}", "\u{1102}\u{116A}\u{11A9}", "\u{B196}", "\u{1102}\u{116A}\u{11A9}"),
    ("\u{B197}", "\u{B197}", "\u{1102}\u{116A}\u{11AA}", "\u{B197}", "\u{1102}\u{116A}\u{11AA}"),
    ("\u{B198}", "\u{B198}", "\u{1102}\u{116A}\u{11AB}", "\u{B198}", "\u{1102}\u{116A}\u{11AB}"),
    ("\u{B199}", "\u{B199}", "\u{1102}\u{116A}\u{11AC}", "\u{B199}", "\u{1102}\u{116A}\u{11AC}"),
    ("\u{B19A}", "\u{B19A}", "\u{1102}\u{116A}\u{11AD}", "\u{B19A}", "\u{1102}\u{116A}\u{11AD}"),
    ("\u{B19B}", "\u{B19B}", "\u{1102}\u{116A}\u{11AE}", "\u{B19B}", "\u{1102}\u{116A}\u{11AE}"),
    ("\u{B19C}", "\u{B19C}", "\u{1102}\u{116A}\u{11AF}", "\u{B19C}", "\u{1102}\u{116A}\u{11AF}"),
    ("\u{B19D}", "\u{B19D}", "\u{1102}\u{116A}\u{11B0}", "\u{B19D}", "\u{1102}\u{116A}\u{11B0}"),
    ("\u{B19E}", "\u{B19E}", "\u{1102}\u{116A}\u{11B1}", "\u{B19E}", "\u{1102}\u{116A}\u{11B1}"),
    ("\u{B19F}", "\u{B19F}", "\u{1102}\u{116A}\u{11B2}", "\u{B19F}", "\u{1102}\u{116A}\u{11B2}"),
    ("\u{B1A0}", "\u{B1A0}", "\u{1102}\u{116A}\u{11B3}", "\u{B1A0}", "\u{1102}\u{116A}\u{11B3}"),
    ("\u{B1A1}", "\u{B1A1}", "\u{1102}\u{116A}\u{11B4}", "\u{B1A1}", "\u{1102}\u{116A}\u{11B4}"),
    ("\u{B1A2}", "\u{B1A2}", "\u{1102}\u{116A}\u{11B5}", "\u{B1A2}", "\u{1102}\u{116A}\u{11B5}"),
    ("\u{B1A3}", "\u{B1A3}", "\u{1102}\u{116A}\u{11B6}", "\u{B1A3}", "\u{1102}\u{116A}\u{11B6}"),
    ("\u{B1A4}", "\u{B1A4}", "\u{1102}\u{116A}\u{11B7}", "\u{B1A4}", "\u{1102}\u{116A}\u{11B7}"),
    ("\u{B1A5}", "\u{B1A5}", "\u{1102}\u{116A}\u{11B8}", "\u{B1A5}", "\u{1102}\u{116A}\u{11B8}"),
    ("\u{B1A6}", "\u{B1A6}", "\u{1102}\u{116A}\u{11B9}", "\u{B1A6}", "\u{1102}\u{116A}\u{11B9}"),
    ("\u{B1A7}", "\u{B1A7}", "\u{1102}\u{116A}\u{11BA}", "\u{B1A7}", "\u{1102}\u{116A}\u{11BA}"),
    ("\u{B1A8}", "\u{B1A8}", "\u{1102}\u{116A}\u{11BB}", "\u{B1A8}", "\u{1102}\u{116A}\u{11BB}"),
    ("\u{B1A9}", "\u{B1A9}", "\u{1102}\u{116A}\u{11BC}", "\u{B1A9}", "\u{1102}\u{116A}\u{11BC}"),
    ("\u{B1AA}", "\u{B1AA}", "\u{1102}\u{116A}\u{11BD}", "\u{B1AA}", "\u{1102}\u{116A}\u{11BD}"),
    ("\u{B1AB}", "\u{B1AB}", "\u{1102}\u{116A}\u{11BE}", "\u{B1AB}", "\u{1102}\u{116A}\u{11BE}"),
    ("\u{B1AC}", "\u{B1AC}", "\u{1102}\u{116A}\u{11BF}", "\u{B1AC}", "\u{1102}\u{116A}\u{11BF}"),
    ("\u{B1AD}", "\u{B1AD}", "\u{1102}\u{116A}\u{11C0}", "\u{B1AD}", "\u{1102}\u{116A}\u{11C0}"),
    ("\u{B1AE}", "\u{B1AE}", "\u{1102}\u{116A}\u{11C1}", "\u{B1AE}", "\u{1102}\u{116A}\u{11C1}"),
    ("\u{B1AF}", "\u{B1AF}", "\u{1102}\u{116A}\u{11C2}", "\u{B1AF}", "\u{1102}\u{116A}\u{11C2}"),
    ("\u{B1B0}", "\u{B1B0}", "\u{1102}\u{116B}", "\u{B1B0}", "\u{1102}\u{116B}"),
    ("\u{B1B1}", "\u{B1B1}", "\u{1102}\u{116B}\u{11A8}", "\u{B1B1}", "\u{1102}\u{116B}\u{11A8}"),
    ("\u{B1B2}", "\u{B1B2}", "\u{1102}\u{116B}\u{11A9}", "\u{B1B2}", "\u{1102}\u{116B}\u{11A9}"),
    ("\u{B1B3}", "\u{B1B3}", "\u{1102}\u{116B}\u{11AA}", "\u{B1B3}", "\u{1102}\u{116B}\u{11AA}"),
    ("\u{B1B4}", "\u{B1B4}", "\u{1102}\u{116B}\u{11AB}", "\u{B1B4}", "\u{1102}\u{116B}\u{11AB}"),
    ("\u{B1B5}", "\u{B1B5}", "\u{1102}\u{116B}\u{11AC}", "\u{B1B5}", "\u{1102}\u{116B}\u{11AC}"),
    ("\u{B1B6}", "\u{B1B6}", "\u{1102}\u{116B}\u{11AD}", "\u{B1B6}", "\u{1102}\u{116B}\u{11AD}"),
    ("\u{B1B7}", "\u{B1B7}", "\u{1102}\u{116B}\u{11AE}", "\u{B1B7}", "\u{1102}\u{116B}\u{11AE}"),
    ("\u{B1B8}", "\u{B1B8}", "\u{1102}\u{116B}\u{11AF}", "\u{B1B8}", "\u{1102}\u{116B}\u{11AF}"),
    ("\u{B1B9}", "\u{B1B9}", "\u{1102}\u{116B}\u{11B0}", "\u{B1B9}", "\u{1102}\u{116B}\u{11B0}"),
    ("\u{B1BA}", "\u{B1BA}", "\u{1102}\u{116B}\u{11B1}", "\u{B1BA}", "\u{1102}\u{116B}\u{11B1}"),
    ("\u{B1BB}", "\u{B1BB}", "\u{1102}\u{116B}\u{11B2}", "\u{B1BB}", "\u{1102}\u{116B}\u{11B2}"),
    ("\u{B1BC}", "\u{B1BC}", "\u{1102}\u{116B}\u{11B3}", "\u{B1BC}", "\u{1102}\u{116B}\u{11B3}"),
    ("\u{B1BD}", "\u{B1BD}", "\u{1102}\u{116B}\u{11B4}", "\u{B1BD}", "\u{1102}\u{116B}\u{11B4}"),
    ("\u{B1BE}", "\u{B1BE}", "\u{1102}\u{116B}\u{11B5}", "\u{B1BE}", "\u{1102}\u{116B}\u{11B5}"),
    ("\u{B1BF}", "\u{B1BF}", "\u{1102}\u{116B}\u{11B6}", "\u{B1BF}", "\u{1102}\u{116B}\u{11B6}"),
    ("\u{B1C0}", "\u{B1C0}", "\u{1102}\u{116B}\u{11B7}", "\u{B1C0}", "\u{1102}\u{116B}\u{11B7}"),
    ("\u{B1C1}", "\u{B1C1}", "\u{1102}\u{116B}\u{11B8}", "\u{B1C1}", "\u{1102}\u{116B}\u{11B8}"),
    ("\u{B1C2}", "\u{B1C2}", "\u{1102}\u{116B}\u{11B9}", "\u{B1C2}", "\u{1102}\u{116B}\u{11B9}"),
    ("\u{B1C3}", "\u{B1C3}", "\u{1102}\u{116B}\u{11BA}", "\u{B1C3}", "\u{1102}\u{116B}\u{11BA}"),
    ("\u{B1C4}", "\u{B1C4}", "\u{1102}\u{116B}\u{11BB}", "\u{B1C4}", "\u{1102}\u{116B}\u{11BB}"),
    ("\u{B1C5}", "\u{B1C5}", "\u{1102}\u{116B}\u{11BC}", "\u{B1C5}", "\u{1102}\u{116B}\u{11BC}"),
    ("\u{B1C6}", "\u{B1C6}", "\u{1102}\u{116B}\u{11BD}", "\u{B1C6}", "\u{1102}\u{116B}\u{11BD}"),
    ("\u{B1C7}", "\u{B1C7}", "\u{1102}\u{116B}\u{11BE}", "\u{B1C7}", "\u{1102}\u{116B}\u{11BE}"),
    ("\u{B1C8}", "\u{B1C8}", "\u{1102}\u{116B}\u{11BF}", "\u{B1C8}", "\u{1102}\u{116B}\u{11BF}"),
    ("\u{B1C9}", "\u{B1C9}", "\u{1102}\u{116B}\u{11C0}", "\u{B1C9}", "\u{1102}\u{116B}\u{11C0}"),
    ("\u{B1CA}", "\u{B1CA}", "\u{1102}\u{116B}\u{11C1}", "\u{B1CA}", "\u{1102}\u{116B}\u{11C1}"),
    ("\u{B1CB}", "\u{B1CB}", "\u{1102}\u{116B}\u{11C2}", "\u{B1CB}", "\u{1102}\u{116B}\u{11C2}"),
    ("\u{B1CC}", "\u{B1CC}", "\u{1102}\u{116C}", "\u{B1CC}", "\u{1102}\u{116C}"),
    ("\u{B1CD}", "\u{B1CD}", "\u{1102}\u{116C}\u{11A8}", "\u{B1CD}", "\u{1102}\u{116C}\u{11A8}"),
    ("\u{B1CE}", "\u{B1CE}", "\u{1102}\u{116C}\u{11A9}", "\u{B1CE}", "\u{1102}\u{116C}\u{11A9}"),
    ("\u{B1CF}", "\u{B1CF}", "\u{1102}\u{116C}\u{11AA}", "\u{B1CF}", "\u{1102}\u{116C}\u{11AA}"),
    ("\u{B1D0}", "\u{B1D0}", "\u{1102}\u{116C}\u{11AB}", "\u{B1D0}", "\u{1102}\u{116C}\u{11AB}"),
    ("\u{B1D1}", "\u{B1D1}", "\u{1102}\u{116C}\u{11AC}", "\u{B1D1}", "\u{1102}\u{116C}\u{11AC}"),
    ("\u{B1D2}", "\u{B1D2}", "\u{1102}\u{116C}\u{11AD}", "\u{B1D2}", "\u{1102}\u{116C}\u{11AD}"),
    ("\u{B1D3}", "\u{B1D3}", "\u{1102}\u{116C}\u{11AE}", "\u{B1D3}", "\u{1102}\u{116C}\u{11AE}"),
    ("\u{B1D4}", "\u{B1D4}", "\u{1102}\u{116C}\u{11AF}", "\u{B1D4}", "\u{1102}\u{116C}\u{11AF}"),
    ("\u{B1D5}", "\u{B1D5}", "\u{1102}\u{116C}\u{11B0}", "\u{B1D5}", "\u{1102}\u{116C}\u{11B0}"),
    ("\u{B1D6}", "\u{B1D6}", "\u{1102}\u{116C}\u{11B1}", "\u{B1D6}", "\u{1102}\u{116C}\u{11B1}"),
    ("\u{B1D7}", "\u{B1D7}", "\u{1102}\u{116C}\u{11B2}", "\u{B1D7}", "\u{1102}\u{116C}\u{11B2}"),
    ("\u{B1D8}", "\u{B1D8}", "\u{1102}\u{116C}\u{11B3}", "\u{B1D8}", "\u{1102}\u{116C}\u{11B3}"),
    ("\u{B1D9}", "\u{B1D9}", "\u{1102}\u{116C}\u{11B4}", "\u{B1D9}", "\u{1102}\u{116C}\u{11B4}"),
    ("\u{B1DA}", "\u{B1DA}", "\u{1102}\u{116C}\u{11B5}", "\u{B1DA}", "\u{1102}\u{116C}\u{11B5}"),
    ("\u{B1DB}", "\u{B1DB}", "\u{1102}\u{116C}\u{11B6}", "\u{B1DB}", "\u{1102}\u{116C}\u{11B6}"),
    ("\u{B1DC}", "\u{B1DC}", "\u{1102}\u{116C}\u{11B7}", "\u{B1DC}", "\u{1102}\u{116C}\u{11B7}"),
    ("\u{B1DD}", "\u{B1DD}", "\u{1102}\u{116C}\u{11B8}", "\u{B1DD}", "\u{1102}\u{116C}\u{11B8}"),
    ("\u{B1DE}", "\u{B1DE}", "\u{1102}\u{116C}\u{11B9}", "\u{B1DE}", "\u{1102}\u{116C}\u{11B9}"),
    ("\u{B1DF}", "\u{B1DF}", "\u{1102}\u{116C}\u{11BA}", "\u{B1DF}", "\u{1102}\u{116C}\u{11BA}"),
    ("\u{B1E0}", "\u{B1E0}", "\u{1102}\u{116C}\u{11BB}", "\u{B1E0}", "\u{1102}\u{116C}\u{11BB}"),
    ("\u{B1E1}", "\u{B1E1}", "\u{1102}\u{116C}\u{11BC}", "\u{B1E1}", "\u{1102}\u{116C}\u{11BC}"),
    ("\u{B1E2}", "\u{B1E2}", "\u{1102}\u{116C}\u{11BD}", "\u{B1E2}", "\u{1102}\u{116C}\u{11BD}"),
    ("\u{B1E3}", "\u{B1E3}", "\u{1102}\u{116C}\u{11BE}", "\u{B1E3}", "\u{1102}\u{116C}\u{11BE}"),
    ("\u{B1E4}", "\u{B1E4}", "\u{1102}\u{116C}\u{11BF}", "\u{B1E4}", "\u{1102}\u{116C}\u{11BF}"),
    ("\u{B1E5}", "\u{B1E5}", "\u{1102}\u{116C}\u{11C0}", "\u{B1E5}", "\u{1102}\u{116C}\u{11C0}"),
    ("\u{B1E6}", "\u{B1E6}", "\u{1102}\u{116C}\u{11C1}", "\u{B1E6}", "\u{1102}\u{116C}\u{11C1}"),
    ("\u{B1E7}", "\u{B1E7}", "\u{1102}\u{116C}\u{11C2}", "\u{B1E7}", "\u{1102}\u{116C}\u{11C2}"),
    ("\u{B1E8}", "\u{B1E8}", "\u{1102}\u{116D}", "\u{B1E8}", "\u{1102}\u{116D}"),
    ("\u{B1E9}", "\u{B1E9}", "\u{1102}\u{116D}\u{11A8}", "\u{B1E9}", "\u{1102}\u{116D}\u{11A8}"),
    ("\u{B1EA}", "\u{B1EA}", "\u{1102}\u{116D}\u{11A9}", "\u{B1EA}", "\u{1102}\u{116D}\u{11A9}"),
    ("\u{B1EB}", "\u{B1EB}", "\u{1102}\u{116D}\u{11AA}", "\u{B1EB}", "\u{1102}\u{116D}\u{11AA}"),
    ("\u{B1EC}", "\u{B1EC}", "\u{1102}\u{116D}\u{11AB}", "\u{B1EC}", "\u{1102}\u{116D}\u{11AB}"),
    ("\u{B1ED}", "\u{B1ED}", "\u{1102}\u{116D}\u{11AC}", "\u{B1ED}", "\u{1102}\u{116D}\u{11AC}"),
    ("\u{B1EE}", "\u{B1EE}", "\u{1102}\u{116D}\u{11AD}", "\u{B1EE}", "\u{1102}\u{116D}\u{11AD}"),
    ("\u{B1EF}", "\u{B1EF}", "\u{1102}\u{116D}\u{11AE}", "\u{B1EF}", "\u{1102}\u{116D}\u{11AE}"),
    ("\u{B1F0}", "\u{B1F0}", "\u{1102}\u{116D}\u{11AF}", "\u{B1F0}", "\u{1102}\u{116D}\u{11AF}"),
    ("\u{B1F1}", "\u{B1F1}", "\u{1102}\u{116D}\u{11B0}", "\u{B1F1}", "\u{1102}\u{116D}\u{11B0}"),
    ("\u{B1F2}", "\u{B1F2}", "\u{1102}\u{116D}\u{11B1}", "\u{B1F2}", "\u{1102}\u{116D}\u{11B1}"),
    ("\u{B1F3}", "\u{B1F3}", "\u{1102}\u{116D}\u{11B2}", "\u{B1F3}", "\u{1102}\u{116D}\u{11B2}"),
    ("\u{B1F4}", "\u{B1F4}", "\u{1102}\u{116D}\u{11B3}", "\u{B1F4}", "\u{1102}\u{116D}\u{11B3}"),
    ("\u{B1F5}", "\u{B1F5}", "\u{1102}\u{116D}\u{11B4}", "\u{B1F5}", "\u{1102}\u{116D}\u{11B4}"),
    ("\u{B1F6}", "\u{B1F6}", "\u{1102}\u{116D}\u{11B5}", "\u{B1F6}", "\u{1102}\u{116D}\u{11B5}"),
    ("\u{B1F7}", "\u{B1F7}", "\u{1102}\u{116D}\u{11B6}", "\u{B1F7}", "\u{1102}\u{116D}\u{11B6}"),
    ("\u{B1F8}", "\u{B1F8}", "\u{1102}\u{116D}\u{11B7}", "\u{B1F8}", "\u{1102}\u{116D}\u{11B7}"),
    ("\u{B1F9}", "\u{B1F9}", "\u{1102}\u{116D}\u{11B8}", "\u{B1F9}", "\u{1102}\u{116D}\u{11B8}"),
    ("\u{B1FA}", "\u{B1FA}", "\u{1102}\u{116D}\u{11B9}", "\u{B1FA}", "\u{1102}\u{116D}\u{11B9}"),
    ("\u{B1FB}", "\u{B1FB}", "\u{1102}\u{116D}\u{11BA}", "\u{B1FB}", "\u{1102}\u{116D}\u{11BA}"),
    ("\u{B1FC}", "\u{B1FC}", "\u{1102}\u{116D}\u{11BB}", "\u{B1FC}", "\u{1102}\u{116D}\u{11BB}"),
    ("\u{B1FD}", "\u{B1FD}", "\u{1102}\u{116D}\u{11BC}", "\u{B1FD}", "\u{1102}\u{116D}\u{11BC}"),
    ("\u{B1FE}", "\u{B1FE}", "\u{1102}\u{116D}\u{11BD}", "\u{B1FE}", "\u{1102}\u{116D}\u{11BD}"),
    ("\u{B1FF}", "\u{B1FF}", "\u{1102}\u{116D}\u{11BE}", "\u{B1FF}", "\u{1102}\u{116D}\u{11BE}"),
    ("\u{B200}", "\u{B200}", "\u{1102}\u{116D}\u{11BF}", "\u{B200}", "\u{1102}\u{116D}\u{11BF}"),
    ("\u{B201}", "\u{B201}", "\u{1102}\u{116D}\u{11C0}", "\u{B201}", "\u{1102}\u{116D}\u{11C0}"),
    ("\u{B202}", "\u{B202}", "\u{1102}\u{116D}\u{11C1}", "\u{B202}", "\u{1102}\u{116D}\u{11C1}"),
    ("\u{B203}", "\u{B203}", "\u{1102}\u{116D}\u{11C2}", "\u{B203}", "\u{1102}\u{116D}\u{11C2}"),
    ("\u{B204}", "\u{B204}", "\u{1102}\u{116E}", "\u{B204}", "\u{1102}\u{116E}"),
    ("\u{B205}", "\u{B205}", "\u{1102}\u{116E}\u{11A8}", "\u{B205}", "\u{1102}\u{116E}\u{11A8}"),
    ("\u{B206}", "\u{B206}", "\u{1102}\u{116E}\u{11A9}", "\u{B206}", "\u{1102}\u{116E}\u{11A9}"),
    ("\u{B207}", "\u{B207}", "\u{1102}\u{116E}\u{11AA}", "\u{B207}", "\u{1102}\u{116E}\u{11AA}"),
    ("\u{B208}", "\u{B208}", "\u{1102}\u{116E}\u{11AB}", "\u{B208}", "\u{1102}\u{116E}\u{11AB}"),
    ("\u{B209}", "\u{B209}", "\u{1102}\u{116E}\u{11AC}", "\u{B209}", "\u{1102}\u{116E}\u{11AC}"),
    ("\u{B20A}", "\u{B20A}", "\u{1102}\u{116E}\u{11AD}", "\u{B20A}", "\u{1102}\u{116E}\u{11AD}"),
    ("\u{B20B}", "\u{B20B}", "\u{1102}\u{116E}\u{11AE}", "\u{B20B}", "\u{1102}\u{116E}\u{11AE}"),
    ("\u{B20C}", "\u{B20C}", "\u{1102}\u{116E}\u{11AF}", "\u{B20C}", "\u{1102}\u{116E}\u{11AF}"),
    ("\u{B20D}", "\u{B20D}", "\u{1102}\u{116E}\u{11B0}", "\u{B20D}", "\u{1102}\u{116E}\u{11B0}"),
    ("\u{B20E}", "\u{B20E}", "\u{1102}\u{116E}\u{11B1}", "\u{B20E}", "\u{1102}\u{116E}\u{11B1}"),
    ("\u{B20F}", "\u{B20F}", "\u{1102}\u{116E}\u{11B2}", "\u{B20F}", "\u{1102}\u{116E}\u{11B2}"),
    ("\u{B210}", "\u{B210}", "\u{1102}\u{116E}\u{11B3}", "\u{B210}", "\u{1102}\u{116E}\u{11B3}"),
    ("\u{B211}", "\u{B211}", "\u{1102}\u{116E}\u{11B4}", "\u{B211}", "\u{1102}\u{116E}\u{11B4}"),
    ("\u{B212}", "\u{B212}", "\u{1102}\u{116E}\u{11B5}", "\u{B212}", "\u{1102}\u{116E}\u{11B5}"),
    ("\u{B213}", "\u{B213}", "\u{1102}\u{116E}\u{11B6}", "\u{B213}", "\u{1102}\u{116E}\u{11B6}"),
    ("\u{B214}", "\u{B214}", "\u{1102}\u{116E}\u{11B7}", "\u{B214}", "\u{1102}\u{116E}\u{11B7}"),
    ("\u{B215}", "\u{B215}", "\u{1102}\u{116E}\u{11B8}", "\u{B215}", "\u{1102}\u{116E}\u{11B8}"),
    ("\u{B216}", "\u{B216}", "\u{1102}\u{116E}\u{11B9}", "\u{B216}", "\u{1102}\u{116E}\u{11B9}"),
    ("\u{B217}", "\u{B217}", "\u{1102}\u{116E}\u{11BA}", "\u{B217}", "\u{1102}\u{116E}\u{11BA}"),
    ("\u{B218}", "\u{B218}", "\u{1102}\u{116E}\u{11BB}", "\u{B218}", "\u{1102}\u{116E}\u{11BB}"),
    ("\u{B219}", "\u{B219}", "\u{1102}\u{116E}\u{11BC}", "\u{B219}", "\u{1102}\u{116E}\u{11BC}"),
    ("\u{B21A}", "\u{B21A}", "\u{1102}\u{116E}\u{11BD}", "\u{B21A}", "\u{1102}\u{116E}\u{11BD}"),
    ("\u{B21B}", "\u{B21B}", "\u{1102}\u{116E}\u{11BE}", "\u{B21B}", "\u{1102}\u{116E}\u{11BE}"),
    ("\u{B21C}", "\u{B21C}", "\u{1102}\u{116E}\u{11BF}", "\u{B21C}", "\u{1102}\u{116E}\u{11BF}"),
    ("\u{B21D}", "\u{B21D}", "\u{1102}\u{116E}\u{11C0}", "\u{B21D}", "\u{1102}\u{116E}\u{11C0}"),
    ("\u{B21E}", "\u{B21E}", "\u{1102}\u{116E}\u{11C1}", "\u{B21E}", "\u{1102}\u{116E}\u{11C1}"),
    ("\u{B21F}", "\u{B21F}", "\u{1102}\u{116E}\u{11C2}", "\u{B21F}", "\u{1102}\u{116E}\u{11C2}"),
    ("\u{B220}", "\u{B220}", "\u{1102}\u{116F}", "\u{B220}", "\u{1102}\u{116F}"),
    ("\u{B221}", "\u{B221}", "\u{1102}\u{116F}\u{11A8}", "\u{B221}", "\u{1102}\u{116F}\u{11A8}"),
    ("\u{B222}", "\u{B222}", "\u{1102}\u{116F}\u{11A9}", "\u{B222}", "\u{1102}\u{116F}\u{11A9}"),
    ("\u{B223}", "\u{B223}", "\u{1102}\u{116F}\u{11AA}", "\u{B223}", "\u{1102}\u{116F}\u{11AA}"),
    ("\u{B224}", "\u{B224}", "\u{1102}\u{116F}\u{11AB}", "\u{B224}", "\u{1102}\u{116F}\u{11AB}"),
    ("\u{B225}", "\u{B225}", "\u{1102}\u{116F}\u{11AC}", "\u{B225}", "\u{1102}\u{116F}\u{11AC}"),
    ("\u{B226}", "\u{B226}", "\u{1102}\u{116F}\u{11AD}", "\u{B226}", "\u{1102}\u{116F}\u{11AD}"),
    ("\u{B227}", "\u{B227}", "\u{1102}\u{116F}\u{11AE}", "\u{B227}", "\u{1102}\u{116F}\u{11AE}"),
    ("\u{B228}", "\u{B228}", "\u{1102}\u{116F}\u{11AF}", "\u{B228}", "\u{1102}\u{116F}\u{11AF}"),
    ("\u{B229}", "\u{B229}", "\u{1102}\u{116F}\u{11B0}", "\u{B229}", "\u{1102}\u{116F}\u{11B0}"),
    ("\u{B22A}", "\u{B22A}", "\u{1102}\u{116F}\u{11B1}", "\u{B22A}", "\u{1102}\u{116F}\u{11B1}"),
    ("\u{B22B}", "\u{B22B}", "\u{1102}\u{116F}\u{11B2}", "\u{B22B}", "\u{1102}\u{116F}\u{11B2}"),
    ("\u{B22C}", "\u{B22C}", "\u{1102}\u{116F}\u{11B3}", "\u{B22C}", "\u{1102}\u{116F}\u{11B3}"),
    ("\u{B22D}", "\u{B22D}", "\u{1102}\u{116F}\u{11B4}", "\u{B22D}", "\u{1102}\u{116F}\u{11B4}"),
    ("\u{B22E}", "\u{B22E}", "\u{1102}\u{116F}\u{11B5}", "\u{B22E}", "\u{1102}\u{116F}\u{11B5}"),
    ("\u{B22F}", "\u{B22F}", "\u{1102}\u{116F}\u{11B6}", "\u{B22F}", "\u{1102}\u{116F}\u{11B6}"),
    ("\u{B230}", "\u{B230}", "\u{1102}\u{116F}\u{11B7}", "\u{B230}", "\u{1102}\u{116F}\u{11B7}"),
    ("\u{B231}", "\u{B231}", "\u{1102}\u{116F}\u{11B8}", "\u{B231}", "\u{1102}\u{116F}\u{11B8}"),
    ("\u{B232}", "\u{B232}", "\u{1102}\u{116F}\u{11B9}", "\u{B232}", "\u{1102}\u{116F}\u{11B9}"),
    ("\u{B233}", "\u{B233}", "\u{1102}\u{116F}\u{11BA}", "\u{B233}", "\u{1102}\u{116F}\u{11BA}"),
    ("\u{B234}", "\u{B234}", "\u{1102}\u{116F}\u{11BB}", "\u{B234}", "\u{1102}\u{116F}\u{11BB}"),
    ("\u{B235}", "\u{B235}", "\u{1102}\u{116F}\u{11BC}", "\u{B235}", "\u{1102}\u{116F}\u{11BC}"),
    ("\u{B236}", "\u{B236}", "\u{1102}\u{116F}\u{11BD}", "\u{B236}", "\u{1102}\u{116F}\u{11BD}"),
    ("\u{B237}", "\u{B237}", "\u{1102}\u{116F}\u{11BE}", "\u{B237}", "\u{1102}\u{116F}\u{11BE}"),
    ("\u{B238}", "\u{B238}", "\u{1102}\u{116F}\u{11BF}", "\u{B238}", "\u{1102}\u{116F}\u{11BF}"),
    ("\u{B239}", "\u{B239}", "\u{1102}\u{116F}\u{11C0}", "\u{B239}", "\u{1102}\u{116F}\u{11C0}"),
    ("\u{B23A}", "\u{B23A}", "\u{1102}\u{116F}\u{11C1}", "\u{B23A}", "\u{1102}\u{116F}\u{11C1}"),
    ("\u{B23B}", "\u{B23B}", "\u{1102}\u{116F}\u{11C2}", "\u{B23B}", "\u{1102}\u{116F}\u{11C2}"),
    ("\u{B23C}", "\u{B23C}", "\u{1102}\u{1170}", "\u{B23C}", "\u{1102}\u{1170}"),
    ("\u{B23D}", "\u{B23D}", "\u{1102}\u{1170}\u{11A8}", "\u{B23D}", "\u{1102}\u{1170}\u{11A8}"),
    ("\u{B23E}", "\u{B23E}", "\u{1102}\u{1170}\u{11A9}", "\u{B23E}", "\u{1102}\u{1170}\u{11A9}"),
    ("\u{B23F}", "\u{B23F}", "\u{1102}\u{1170}\u{11AA}", "\u{B23F}", "\u{1102}\u{1170}\u{11AA}"),
    ("\u{B240}", "\u{B240}", "\u{1102}\u{1170}\u{11AB}", "\u{B240}", "\u{1102}\u{1170}\u{11AB}"),
    ("\u{B241}", "\u{B241}", "\u{1102}\u{1170}\u{11AC}", "\u{B241}", "\u{1102}\u{1170}\u{11AC}"),
    ("\u{B242}", "\u{B242}", "\u{1102}\u{1170}\u{11AD}", "\u{B242}", "\u{1102}\u{1170}\u{11AD}"),
    ("\u{B243}", "\u{B243}", "\u{1102}\u{1170}\u{11AE}", "\u{B243}", "\u{1102}\u{1170}\u{11AE}"),
    ("\u{B244}", "\u{B244}", "\u{1102}\u{1170}\u{11AF}", "\u{B244}", "\u{1102}\u{1170}\u{11AF}"),
    ("\u{B245}", "\u{B245}", "\u{1102}\u{1170}\u{11B0}", "\u{B245}", "\u{1102}\u{1170}\u{11B0}"),
    ("\u{B246}", "\u{B246}", "\u{1102}\u{1170}\u{11B1}", "\u{B246}", "\u{1102}\u{1170}\u{11B1}"),
    ("\u{B247}", "\u{B247}", "\u{1102}\u{1170}\u{11B2}", "\u{B247}", "\u{1102}\u{1170}\u{11B2}"),
    ("\u{B248}", "\u{B248}", "\u{1102}\u{1170}\u{11B3}", "\u{B248}", "\u{1102}\u{1170}\u{11B3}"),
    ("\u{B249}", "\u{B249}", "\u{1102}\u{1170}\u{11B4}", "\u{B249}", "\u{1102}\u{1170}\u{11B4}"),
    ("\u{B24A}", "\u{B24A}", "\u{1102}\u{1170}\u{11B5}", "\u{B24A}", "\u{1102}\u{1170}\u{11B5}"),
    ("\u{B24B}", "\u{B24B}", "\u{1102}\u{1170}\u{11B6}", "\u{B24B}", "\u{1102}\u{1170}\u{11B6}"),
    ("\u{B24C}", "\u{B24C}", "\u{1102}\u{1170}\u{11B7}", "\u{B24C}", "\u{1102}\u{1170}\u{11B7}"),
    ("\u{B24D}", "\u{B24D}", "\u{1102}\u{1170}\u{11B8}", "\u{B24D}", "\u{1102}\u{1170}\u{11B8}"),
    ("\u{B24E}", "\u{B24E}", "\u{1102}\u{1170}\u{11B9}", "\u{B24E}", "\u{1102}\u{1170}\u{11B9}"),
    ("\u{B24F}", "\u{B24F}", "\u{1102}\u{1170}\u{11BA}", "\u{B24F}", "\u{1102}\u{1170}\u{11BA}"),
    ("\u{B250}", "\u{B250}", "\u{1102}\u{1170}\u{11BB}", "\u{B250}", "\u{1102}\u{1170}\u{11BB}"),
    ("\u{B251}", "\u{B251}", "\u{1102}\u{1170}\u{11BC}", "\u{B251}", "\u{1102}\u{1170}\u{11BC}"),
    ("\u{B252}", "\u{B252}", "\u{1102}\u{1170}\u{11BD}", "\u{B252}", "\u{1102}\u{1170}\u{11BD}"),
    ("\u{B253}", "\u{B253}", "\u{1102}\u{1170}\u{11BE}", "\u{B253}", "\u{1102}\u{1170}\u{11BE}"),
    ("\u{B254}", "\u{B254}", "\u{1102}\u{1170}\u{11BF}", "\u{B254}", "\u{1102}\u{1170}\u{11BF}"),
    ("\u{B255}", "\u{B255}", "\u{1102}\u{1170}\u{11C0}", "\u{B255}", "\u{1102}\u{1170}\u{11C0}"),
    ("\u{B256}", "\u{B256}", "\u{1102}\u{1170}\u{11C1}", "\u{B256}", "\u{1102}\u{1170}\u{11C1}"),
    ("\u{B257}", "\u{B257}", "\u{1102}\u{1170}\u{11C2}", "\u{B257}", "\u{1102}\u{1170}\u{11C2}"),
    ("\u{B258}", "\u{B258}", "\u{1102}\u{1171}", "\u{B258}", "\u{1102}\u{1171}"),
    ("\u{B259}", "\u{B259}", "\u{1102}\u{1171}\u{11A8}", "\u{B259}", "\u{1102}\u{1171}\u{11A8}"),
    ("\u{B25A}", "\u{B25A}", "\u{1102}\u{1171}\u{11A9}", "\u{B25A}", "\u{1102}\u{1171}\u{11A9}"),
    ("\u{B25B}", "\u{B25B}", "\u{1102}\u{1171}\u{11AA}", "\u{B25B}", "\u{1102}\u{1171}\u{11AA}"),
    ("\u{B25C}", "\u{B25C}", "\u{1102}\u{1171}\u{11AB}", "\u{B25C}", "\u{1102}\u{1171}\u{11AB}"),
    ("\u{B25D}", "\u{B25D}", "\u{1102}\u{1171}\u{11AC}", "\u{B25D}", "\u{1102}\u{1171}\u{11AC}"),
    ("\u{B25E}", "\u{B25E}", "\u{1102}\u{1171}\u{11AD}", "\u{B25E}", "\u{1102}\u{1171}\u{11AD}"),
    ("\u{B25F}", "\u{B25F}", "\u{1102}\u{1171}\u{11AE}", "\u{B25F}", "\u{1102}\u{1171}\u{11AE}"),
    ("\u{B260}", "\u{B260}", "\u{1102}\u{1171}\u{11AF}", "\u{B260}", "\u{1102}\u{1171}\u{11AF}"),
    ("\u{B261}", "\u{B261}", "\u{1102}\u{1171}\u{11B0}", "\u{B261}", "\u{1102}\u{1171}\u{11B0}"),
    ("\u{B262}", "\u{B262}", "\u{1102}\u{1171}\u{11B1}", "\u{B262}", "\u{1102}\u{1171}\u{11B1}"),
    ("\u{B263}", "\u{B263}", "\u{1102}\u{1171}\u{11B2}", "\u{B263}", "\u{1102}\u{1171}\u{11B2}"),
    ("\u{B264}", "\u{B264}", "\u{1102}\u{1171}\u{11B3}", "\u{B264}", "\u{1102}\u{1171}\u{11B3}"),
    ("\u{B265}", "\u{B265}", "\u{1102}\u{1171}\u{11B4}", "\u{B265}", "\u{1102}\u{1171}\u{11B4}"),
    ("\u{B266}", "\u{B266}", "\u{1102}\u{1171}\u{11B5}", "\u{B266}", "\u{1102}\u{1171}\u{11B5}"),
    ("\u{B267}", "\u{B267}", "\u{1102}\u{1171}\u{11B6}", "\u{B267}", "\u{1102}\u{1171}\u{11B6}"),
    ("\u{B268}", "\u{B268}", "\u{1102}\u{1171}\u{11B7}", "\u{B268}", "\u{1102}\u{1171}\u{11B7}"),
    ("\u{B269}", "\u{B269}", "\u{1102}\u{1171}\u{11B8}", "\u{B269}", "\u{1102}\u{1171}\u{11B8}"),
    ("\u{B26A}", "\u{B26A}", "\u{1102}\u{1171}\u{11B9}", "\u{B26A}", "\u{1102}\u{1171}\u{11B9}"),
    ("\u{B26B}", "\u{B26B}", "\u{1102}\u{1171}\u{11BA}", "\u{B26B}", "\u{1102}\u{1171}\u{11BA}"),
    ("\u{B26C}", "\u{B26C}", "\u{1102}\u{1171}\u{11BB}", "\u{B26C}", "\u{1102}\u{1171}\u{11BB}"),
    ("\u{B26D}", "\u{B26D}", "\u{1102}\u{1171}\u{11BC}", "\u{B26D}", "\u{1102}\u{1171}\u{11BC}"),
    ("\u{B26E}", "\u{B26E}", "\u{1102}\u{1171}\u{11BD}", "\u{B26E}", "\u{1102}\u{1171}\u{11BD}"),
    ("\u{B26F}", "\u{B26F}", "\u{1102}\u{1171}\u{11BE}", "\u{B26F}", "\u{1102}\u{1171}\u{11BE}"),
    ("\u{B270}", "\u{B270}", "\u{1102}\u{1171}\u{11BF}", "\u{B270}", "\u{1102}\u{1171}\u{11BF}"),
    ("\u{B271}", "\u{B271}", "\u{1102}\u{1171}\u{11C0}", "\u{B271}", "\u{1102}\u{1171}\u{11C0}"),
    ("\u{B272}", "\u{B272}", "\u{1102}\u{1171}\u{11C1}", "\u{B272}", "\u{1102}\u{1171}\u{11C1}"),
    ("\u{B273}", "\u{B273}", "\u{1102}\u{1171}\u{11C2}", "\u{B273}", "\u{1102}\u{1171}\u{11C2}"),
    ("\u{B274}", "\u{B274}", "\u{1102}\u{1172}", "\u{B274}", "\u{1102}\u{1172}"),
    ("\u{B275}", "\u{B275}", "\u{1102}\u{1172}\u{11A8}", "\u{B275}", "\u{1102}\u{1172}\u{11A8}"),
    ("\u{B276}", "\u{B276}", "\u{1102}\u{1172}\u{11A9}", "\u{B276}", "\u{1102}\u{1172}\u{11A9}"),
    ("\u{B277}", "\u{B277}", "\u{1102}\u{1172}\u{11AA}", "\u{B277}", "\u{1102}\u{1172}\u{11AA}"),
    ("\u{B278}", "\u{B278}", "\u{1102}\u{1172}\u{11AB}", "\u{B278}", "\u{1102}\u{1172}\u{11AB}"),
    ("\u{B279}", "\u{B279}", "\u{1102}\u{1172}\u{11AC}", "\u{B279}", "\u{1102}\u{1172}\u{11AC}"),
    ("\u{B27A}", "\u{B27A}", "\u{1102}\u{1172}\u{11AD}", "\u{B27A}", "\u{1102}\u{1172}\u{11AD}"),
    ("\u{B27B}", "\u{B27B}", "\u{1102}\u{1172}\u{11AE}", "\u{B27B}", "\u{1102}\u{1172}\u{11AE}"),
    ("\u{B27C}", "\u{B27C}", "\u{1102}\u{1172}\u{11AF}", "\u{B27C}", "\u{1102}\u{1172}\u{11AF}"),
    ("\u{B27D}", "\u{B27D}", "\u{1102}\u{1172}\u{11B0}", "\u{B27D}", "\u{1102}\u{1172}\u{11B0}"),
    ("\u{B27E}", "\u{B27E}", "\u{1102}\u{1172}\u{11B1}", "\u{B27E}", "\u{1102}\u{1172}\u{11B1}"),
    ("\u{B27F}", "\u{B27F}", "\u{1102}\u{1172}\u{11B2}", "\u{B27F}", "\u{1102}\u{1172}\u{11B2}"),
    ("\u{B280}", "\u{B280}", "\u{1102}\u{1172}\u{11B3}", "\u{B280}", "\u{1102}\u{1172}\u{11B3}"),
    ("\u{B281}", "\u{B281}", "\u{1102}\u{1172}\u{11B4}", "\u{B281}", "\u{1102}\u{1172}\u{11B4}"),
    ("\u{B282}", "\u{B282}", "\u{1102}\u{1172}\u{11B5}", "\u{B282}", "\u{1102}\u{1172}\u{11B5}"),
    ("\u{B283}", "\u{B283}", "\u{1102}\u{1172}\u{11B6}", "\u{B283}", "\u{1102}\u{1172}\u{11B6}"),
    ("\u{B284}", "\u{B284}", "\u{1102}\u{1172}\u{11B7}", "\u{B284}", "\u{1102}\u{1172}\u{11B7}"),
    ("\u{B285}", "\u{B285}", "\u{1102}\u{1172}\u{11B8}", "\u{B285}", "\u{1102}\u{1172}\u{11B8}"),
    ("\u{B286}", "\u{B286}", "\u{1102}\u{1172}\u{11B9}", "\u{B286}", "\u{1102}\u{1172}\u{11B9}"),
    ("\u{B287}", "\u{B287}", "\u{1102}\u{1172}\u{11BA}", "\u{B287}", "\u{1102}\u{1172}\u{11BA}"),
    ("\u{B288}", "\u{B288}", "\u{1102}\u{1172}\u{11BB}", "\u{B288}", "\u{1102}\u{1172}\u{11BB}"),
    ("\u{B289}", "\u{B289}", "\u{1102}\u{1172}\u{11BC}", "\u{B289}", "\u{1102}\u{1172}\u{11BC}"),
    ("\u{B28A}", "\u{B28A}", "\u{1102}\u{1172}\u{11BD}", "\u{B28A}", "\u{1102}\u{1172}\u{11BD}"),
    ("\u{B28B}", "\u{B28B}", "\u{1102}\u{1172}\u{11BE}", "\u{B28B}", "\u{1102}\u{1172}\u{11BE}"),
    ("\u{B28C}", "\u{B28C}", "\u{1102}\u{1172}\u{11BF}", "\u{B28C}", "\u{1102}\u{1172}\u{11BF}"),
    ("\u{B28D}", "\u{B28D}", "\u{1102}\u{1172}\u{11C0}", "\u{B28D}", "\u{1102}\u{1172}\u{11C0}"),
    ("\u{B28E}", "\u{B28E}", "\u{1102}\u{1172}\u{11C1}", "\u{B28E}", "\u{1102}\u{1172}\u{11C1}"),
    ("\u{B28F}", "\u{B28F}", "\u{1102}\u{1172}\u{11C2}", "\u{B28F}", "\u{1102}\u{1172}\u{11C2}"),
    ("\u{B290}", "\u{B290}", "\u{1102}\u{1173}", "\u{B290}", "\u{1102}\u{1173}"),
    ("\u{B291}", "\u{B291}", "\u{1102}\u{1173}\u{11A8}", "\u{B291}", "\u{1102}\u{1173}\u{11A8}"),
    ("\u{B292}", "\u{B292}", "\u{1102}\u{1173}\u{11A9}", "\u{B292}", "\u{1102}\u{1173}\u{11A9}"),
    ("\u{B293}", "\u{B293}", "\u{1102}\u{1173}\u{11AA}", "\u{B293}", "\u{1102}\u{1173}\u{11AA}"),
    ("\u{B294}", "\u{B294}", "\u{1102}\u{1173}\u{11AB}", "\u{B294}", "\u{1102}\u{1173}\u{11AB}"),
    ("\u{B295}", "\u{B295}", "\u{1102}\u{1173}\u{11AC}", "\u{B295}", "\u{1102}\u{1173}\u{11AC}"),
    ("\u{B296}", "\u{B296}", "\u{1102}\u{1173}\u{11AD}", "\u{B296}", "\u{1102}\u{1173}\u{11AD}"),
    ("\u{B297}", "\u{B297}", "\u{1102}\u{1173}\u{11AE}", "\u{B297}", "\u{1102}\u{1173}\u{11AE}"),
    ("\u{B298}", "\u{B298}", "\u{1102}\u{1173}\u{11AF}", "\u{B298}", "\u{1102}\u{1173}\u{11AF}"),
    ("\u{B299}", "\u{B299}", "\u{1102}\u{1173}\u{11B0}", "\u{B299}", "\u{1102}\u{1173}\u{11B0}"),
    ("\u{B29A}", "\u{B29A}", "\u{1102}\u{1173}\u{11B1}", "\u{B29A}", "\u{1102}\u{1173}\u{11B1}"),
    ("\u{B29B}", "\u{B29B}", "\u{1102}\u{1173}\u{11B2}", "\u{B29B}", "\u{1102}\u{1173}\u{11B2}"),
    ("\u{B29C}", "\u{B29C}", "\u{1102}\u{1173}\u{11B3}", "\u{B29C}", "\u{1102}\u{1173}\u{11B3}"),
    ("\u{B29D}", "\u{B29D}", "\u{1102}\u{1173}\u{11B4}", "\u{B29D}", "\u{1102}\u{1173}\u{11B4}"),
    ("\u{B29E}", "\u{B29E}", "\u{1102}\u{1173}\u{11B5}", "\u{B29E}", "\u{1102}\u{1173}\u{11B5}"),
    ("\u{B29F}", "\u{B29F}", "\u{1102}\u{1173}\u{11B6}", "\u{B29F}", "\u{1102}\u{1173}\u{11B6}"),
    ("\u{B2A0}", "\u{B2A0}", "\u{1102}\u{1173}\u{11B7}", "\u{B2A0}", "\u{1102}\u{1173}\u{11B7}"),
    ("\u{B2A1}", "\u{B2A1}", "\u{1102}\u{1173}\u{11B8}", "\u{B2A1}", "\u{1102}\u{1173}\u{11B8}"),
    ("\u{B2A2}", "\u{B2A2}", "\u{1102}\u{1173}\u{11B9}", "\u{B2A2}", "\u{1102}\u{1173}\u{11B9}"),
    ("\u{B2A3}", "\u{B2A3}", "\u{1102}\u{1173}\u{11BA}", "\u{B2A3}", "\u{1102}\u{1173}\u{11BA}"),
    ("\u{B2A4}", "\u{B2A4}", "\u{1102}\u{1173}\u{11BB}", "\u{B2A4}", "\u{1102}\u{1173}\u{11BB}"),
    ("\u{B2A5}", "\u{B2A5}", "\u{1102}\u{1173}\u{11BC}", "\u{B2A5}", "\u{1102}\u{1173}\u{11BC}"),
    ("\u{B2A6}", "\u{B2A6}", "\u{1102}\u{1173}\u{11BD}", "\u{B2A6}", "\u{1102}\u{1173}\u{11BD}"),
    ("\u{B2A7}", "\u{B2A7}", "\u{1102}\u{1173}\u{11BE}", "\u{B2A7}", "\u{1102}\u{1173}\u{11BE}"),
    ("\u{B2A8}", "\u{B2A8}", "\u{1102}\u{1173}\u{11BF}", "\u{B2A8}", "\u{1102}\u{1173}\u{11BF}"),
    ("\u{B2A9}", "\u{B2A9}", "\u{1102}\u{1173}\u{11C0}", "\u{B2A9}", "\u{1102}\u{1173}\u{11C0}"),
    ("\u{B2AA}", "\u{B2AA}", "\u{1102}\u{1173}\u{11C1}", "\u{B2AA}", "\u{1102}\u{1173}\u{11C1}"),
    ("\u{B2AB}", "\u{B2AB}", "\u{1102}\u{1173}\u{11C2}", "\u{B2AB}", "\u{1102}\u{1173}\u{11C2}"),
    ("\u{B2AC}", "\u{B2AC}", "\u{1102}\u{1174}", "\u{B2AC}", "\u{1102}\u{1174}"),
    ("\u{B2AD}", "\u{B2AD}", "\u{1102}\u{1174}\u{11A8}", "\u{B2AD}", "\u{1102}\u{1174}\u{11A8}"),
    ("\u{B2AE}", "\u{B2AE}", "\u{1102}\u{1174}\u{11A9}", "\u{B2AE}", "\u{1102}\u{1174}\u{11A9}"),
    ("\u{B2AF}", "\u{B2AF}", "\u{1102}\u{1174}\u{11AA}", "\u{B2AF}", "\u{1102}\u{1174}\u{11AA}"),
    ("\u{B2B0}", "\u{B2B0}", "\u{1102}\u{1174}\u{11AB}", "\u{B2B0}", "\u{1102}\u{1174}\u{11AB}"),
    ("\u{B2B1}", "\u{B2B1}", "\u{1102}\u{1174}\u{11AC}", "\u{B2B1}", "\u{1102}\u{1174}\u{11AC}"),
    ("\u{B2B2}", "\u{B2B2}", "\u{1102}\u{1174}\u{11AD}", "\u{B2B2}", "\u{1102}\u{1174}\u{11AD}"),
    ("\u{B2B3}", "\u{B2B3}", "\u{1102}\u{1174}\u{11AE}", "\u{B2B3}", "\u{1102}\u{1174}\u{11AE}"),
    ("\u{B2B4}", "\u{B2B4}", "\u{1102}\u{1174}\u{11AF}", "\u{B2B4}", "\u{1102}\u{1174}\u{11AF}"),
    ("\u{B2B5}", "\u{B2B5}", "\u{1102}\u{1174}\u{11B0}", "\u{B2B5}", "\u{1102}\u{1174}\u{11B0}"),
    ("\u{B2B6}", "\u{B2B6}", "\u{1102}\u{1174}\u{11B1}", "\u{B2B6}", "\u{1102}\u{1174}\u{11B1}"),
    ("\u{B2B7}", "\u{B2B7}", "\u{1102}\u{1174}\u{11B2}", "\u{B2B7}", "\u{1102}\u{1174}\u{11B2}"),
    ("\u{B2B8}", "\u{B2B8}", "\u{1102}\u{1174}\u{11B3}", "\u{B2B8}", "\u{1102}\u{1174}\u{11B3}"),
    ("\u{B2B9}", "\u{B2B9}", "\u{1102}\u{1174}\u{11B4}", "\u{B2B9}", "\u{1102}\u{1174}\u{11B4}"),
    ("\u{B2BA}", "\u{B2BA}", "\u{1102}\u{1174}\u{11B5}", "\u{B2BA}", "\u{1102}\u{1174}\u{11B5}"),
    ("\u{B2BB}", "\u{B2BB}", "\u{1102}\u{1174}\u{11B6}", "\u{B2BB}", "\u{1102}\u{1174}\u{11B6}"),
    ("\u{B2BC}", "\u{B2BC}", "\u{1102}\u{1174}\u{11B7}", "\u{B2BC}", "\u{1102}\u{1174}\u{11B7}"),
    ("\u{B2BD}", "\u{B2BD}", "\u{1102}\u{1174}\u{11B8}", "\u{B2BD}", "\u{1102}\u{1174}\u{11B8}"),
    ("\u{B2BE}", "\u{B2BE}", "\u{1102}\u{1174}\u{11B9}", "\u{B2BE}", "\u{1102}\u{1174}\u{11B9}"),
    ("\u{B2BF}", "\u{B2BF}", "\u{1102}\u{1174}\u{11BA}", "\u{B2BF}", "\u{1102}\u{1174}\u{11BA}"),
    ("\u{B2C0}", "\u{B2C0}", "\u{1102}\u{1174}\u{11BB}", "\u{B2C0}", "\u{1102}\u{1174}\u{11BB}"),
    ("\u{B2C1}", "\u{B2C1}", "\u{1102}\u{1174}\u{11BC}", "\u{B2C1}", "\u{1102}\u{1174}\u{11BC}"),
    ("\u{B2C2}", "\u{B2C2}", "\u{1102}\u{1174}\u{11BD}", "\u{B2C2}", "\u{1102}\u{1174}\u{11BD}"),
    ("\u{B2C3}", "\u{B2C3}", "\u{1102}\u{1174}\u{11BE}", "\u{B2C3}", "\u{1102}\u{1174}\u{11BE}"),
    ("\u{B2C4}", "\u{B2C4}", "\u{1102}\u{1174}\u{11BF}", "\u{B2C4}", "\u{1102}\u{1174}\u{11BF}"),
    ("\u{B2C5}", "\u{B2C5}", "\u{1102}\u{1174}\u{11C0}", "\u{B2C5}", "\u{1102}\u{1174}\u{11C0}"),
    ("\u{B2C6}", "\u{B2C6}", "\u{1102}\u{1174}\u{11C1}", "\u{B2C6}", "\u{1102}\u{1174}\u{11C1}"),
    ("\u{B2C7}", "\u{B2C7}", "\u{1102}\u{1174}\u{11C2}", "\u{B2C7}", "\u{1102}\u{1174}\u{11C2}"),
    ("\u{B2C8}", "\u{B2C8}", "\u{1102}\u{1175}", "\u{B2C8}", "\u{1102}\u{1175}"),
    ("\u{B2C9}", "\u{B2C9}", "\u{1102}\u{1175}\u{11A8}", "\u{B2C9}", "\u{1102}\u{1175}\u{11A8}"),
    ("\u{B2CA}", "\u{B2CA}", "\u{1102}\u{1175}\u{11A9}", "\u{B2CA}", "\u{1102}\u{1175}\u{11A9}"),
    ("\u{B2CB}", "\u{B2CB}", "\u{1102}\u{1175}\u{11AA}", "\u{B2CB}", "\u{1102}\u{1175}\u{11AA}"),
    ("\u{B2CC}", "\u{B2CC}", "\u{1102}\u{1175}\u{11AB}", "\u{B2CC}", "\u{1102}\u{1175}\u{11AB}"),
    ("\u{B2CD}", "\u{B2CD}", "\u{1102}\u{1175}\u{11AC}", "\u{B2CD}", "\u{1102}\u{1175}\u{11AC}"),
    ("\u{B2CE}", "\u{B2CE}", "\u{1102}\u{1175}\u{11AD}", "\u{B2CE}", "\u{1102}\u{1175}\u{11AD}"),
    ("\u{B2CF}", "\u{B2CF}", "\u{1102}\u{1175}\u{11AE}", "\u{B2CF}", "\u{1102}\u{1175}\u{11AE}"),
    ("\u{B2D0}", "\u{B2D0}", "\u{1102}\u{1175}\u{11AF}", "\u{B2D0}", "\u{1102}\u{1175}\u{11AF}"),
    ("\u{B2D1}", "\u{B2D1}", "\u{1102}\u{1175}\u{11B0}", "\u{B2D1}", "\u{1102}\u{1175}\u{11B0}"),
    ("\u{B2D2}", "\u{B2D2}", "\u{1102}\u{1175}\u{11B1}", "\u{B2D2}", "\u{1102}\u{1175}\u{11B1}"),
    ("\u{B2D3}", "\u{B2D3}", "\u{1102}\u{1175}\u{11B2}", "\u{B2D3}", "\u{1102}\u{1175}\u{11B2}"),
    ("\u{B2D4}", "\u{B2D4}", "\u{1102}\u{1175}\u{11B3}", "\u{B2D4}", "\u{1102}\u{1175}\u{11B3}"),
    ("\u{B2D5}", "\u{B2D5}", "\u{1102}\u{1175}\u{11B4}", "\u{B2D5}", "\u{1102}\u{1175}\u{11B4}"),
    ("\u{B2D6}", "\u{B2D6}", "\u{1102}\u{1175}\u{11B5}", "\u{B2D6}", "\u{1102}\u{1175}\u{11B5}"),
    ("\u{B2D7}", "\u{B2D7}", "\u{1102}\u{1175}\u{11B6}", "\u{B2D7}", "\u{1102}\u{1175}\u{11B6}"),
    ("\u{B2D8}", "\u{B2D8}", "\u{1102}\u{1175}\u{11B7}", "\u{B2D8}", "\u{1102}\u{1175}\u{11B7}"),
    ("\u{B2D9}", "\u{B2D9}", "\u{1102}\u{1175}\u{11B8}", "\u{B2D9}", "\u{1102}\u{1175}\u{11B8}"),
    ("\u{B2DA}", "\u{B2DA}", "\u{1102}\u{1175}\u{11B9}", "\u{B2DA}", "\u{1102}\u{1175}\u{11B9}"),
    ("\u{B2DB}", "\u{B2DB}", "\u{1102}\u{1175}\u{11BA}", "\u{B2DB}", "\u{1102}\u{1175}\u{11BA}"),
    ("\u{B2DC}", "\u{B2DC}", "\u{1102}\u{1175}\u{11BB}", "\u{B2DC}", "\u{1102}\u{1175}\u{11BB}"),
    ("\u{B2DD}", "\u{B2DD}", "\u{1102}\u{1175}\u{11BC}", "\u{B2DD}", "\u{1102}\u{1175}\u{11BC}"),
    ("\u{B2DE}", "\u{B2DE}", "\u{1102}\u{1175}\u{11BD}", "\u{B2DE}", "\u{1102}\u{1175}\u{11BD}"),
    ("\u{B2DF}", "\u{B2DF}", "\u{1102}\u{1175}\u{11BE}", "\u{B2DF}", "\u{1102}\u{1175}\u{11BE}"),
    ("\u{B2E0}", "\u{B2E0}", "\u{1102}\u{1175}\u{11BF}", "\u{B2E0}", "\u{1102}\u{1175}\u{11BF}"),
    ("\u{B2E1}", "\u{B2E1}", "\u{1102}\u{1175}\u{11C0}", "\u{B2E1}", "\u{1102}\u{1175}\u{11C0}"),
    ("\u{B2E2}", "\u{B2E2}", "\u{1102}\u{1175}\u{11C1}", "\u{B2E2}", "\u{1102}\u{1175}\u{11C1}"),
    ("\u{B2E3}", "\u{B2E3}", "\u{1102}\u{1175}\u{11C2}", "\u{B2E3}", "\u{1102}\u{1175}\u{11C2}"),
    ("\u{B2E4}", "\u{B2E4}", "\u{1103}\u{1161}", "\u{B2E4}", "\u{1103}\u{1161}"),
    ("\u{B2E5}", "\u{B2E5}", "\u{1103}\u{1161}\u{11A8}", "\u{B2E5}", "\u{1103}\u{1161}\u{11A8}"),
    ("\u{B2E6}", "\u{B2E6}", "\u{1103}\u{1161}\u{11A9}", "\u{B2E6}", "\u{1103}\u{1161}\u{11A9}"),
    ("\u{B2E7}", "\u{B2E7}", "\u{1103}\u{1161}\u{11AA}", "\u{B2E7}", "\u{1103}\u{1161}\u{11AA}"),
    ("\u{B2E8}", "\u{B2E8}", "\u{1103}\u{1161}\u{11AB}", "\u{B2E8}", "\u{1103}\u{1161}\u{11AB}"),
    ("\u{B2E9}", "\u{B2E9}", "\u{1103}\u{1161}\u{11AC}", "\u{B2E9}", "\u{1103}\u{1161}\u{11AC}"),
    ("\u{B2EA}", "\u{B2EA}", "\u{1103}\u{1161}\u{11AD}", "\u{B2EA}", "\u{1103}\u{1161}\u{11AD}"),
    ("\u{B2EB}", "\u{B2EB}", "\u{1103}\u{1161}\u{11AE}", "\u{B2EB}", "\u{1103}\u{1161}\u{11AE}"),
    ("\u{B2EC}", "\u{B2EC}", "\u{1103}\u{1161}\u{11AF}", "\u{B2EC}", "\u{1103}\u{1161}\u{11AF}"),
    ("\u{B2ED}", "\u{B2ED}", "\u{1103}\u{1161}\u{11B0}", "\u{B2ED}", "\u{1103}\u{1161}\u{11B0}"),
    ("\u{B2EE}", "\u{B2EE}", "\u{1103}\u{1161}\u{11B1}", "\u{B2EE}", "\u{1103}\u{1161}\u{11B1}"),
    ("\u{B2EF}", "\u{B2EF}", "\u{1103}\u{1161}\u{11B2}", "\u{B2EF}", "\u{1103}\u{1161}\u{11B2}"),
    ("\u{B2F0}", "\u{B2F0}", "\u{1103}\u{1161}\u{11B3}", "\u{B2F0}", "\u{1103}\u{1161}\u{11B3}"),
    ("\u{B2F1}", "\u{B2F1}", "\u{1103}\u{1161}\u{11B4}", "\u{B2F1}", "\u{1103}\u{1161}\u{11B4}"),
    ("\u{B2F2}", "\u{B2F2}", "\u{1103}\u{1161}\u{11B5}", "\u{B2F2}", "\u{1103}\u{1161}\u{11B5}"),
    ("\u{B2F3}", "\u{B2F3}", "\u{1103}\u{1161}\u{11B6}", "\u{B2F3}", "\u{1103}\u{1161}\u{11B6}"),
    ("\u{B2F4}", "\u{B2F4}", "\u{1103}\u{1161}\u{11B7}", "\u{B2F4}", "\u{1103}\u{1161}\u{11B7}"),
    ("\u{B2F5}", "\u{B2F5}", "\u{1103}\u{1161}\u{11B8}", "\u{B2F5}", "\u{1103}\u{1161}\u{11B8}"),
    ("\u{B2F6}", "\u{B2F6}", "\u{1103}\u{1161}\u{11B9}", "\u{B2F6}", "\u{1103}\u{1161}\u{11B9}"),
    ("\u{B2F7}", "\u{B2F7}", "\u{1103}\u{1161}\u{11BA}", "\u{B2F7}", "\u{1103}\u{1161}\u{11BA}"),
    ("\u{B2F8}", "\u{B2F8}", "\u{1103}\u{1161}\u{11BB}", "\u{B2F8}", "\u{1103}\u{1161}\u{11BB}"),
    ("\u{B2F9}", "\u{B2F9}", "\u{1103}\u{1161}\u{11BC}", "\u{B2F9}", "\u{1103}\u{1161}\u{11BC}"),
    ("\u{B2FA}", "\u{B2FA}", "\u{1103}\u{1161}\u{11BD}", "\u{B2FA}", "\u{1103}\u{1161}\u{11BD}"),
    ("\u{B2FB}", "\u{B2FB}", "\u{1103}\u{1161}\u{11BE}", "\u{B2FB}", "\u{1103}\u{1161}\u{11BE}"),
    ("\u{B2FC}", "\u{B2FC}", "\u{1103}\u{1161}\u{11BF}", "\u{B2FC}", "\u{1103}\u{1161}\u{11BF}"),
    ("\u{B2FD}", "\u{B2FD}", "\u{1103}\u{1161}\u{11C0}", "\u{B2FD}", "\u{1103}\u{1161}\u{11C0}"),
    ("\u{B2FE}", "\u{B2FE}", "\u{1103}\u{1161}\u{11C1}", "\u{B2FE}", "\u{1103}\u{1161}\u{11C1}"),
    ("\u{B2FF}", "\u{B2FF}", "\u{1103}\u{1161}\u{11C2}", "\u{B2FF}", "\u{1103}\u{1161}\u{11C2}"),
    ("\u{B300}", "\u{B300}", "\u{1103}\u{1162}", "\u{B300}", "\u{1103}\u{1162}"),
    ("\u{B301}", "\u{B301}", "\u{1103}\u{1162}\u{11A8}", "\u{B301}", "\u{1103}\u{1162}\u{11A8}"),
    ("\u{B302}", "\u{B302}", "\u{1103}\u{1162}\u{11A9}", "\u{B302}", "\u{1103}\u{1162}\u{11A9}"),
    ("\u{B303}", "\u{B303}", "\u{1103}\u{1162}\u{11AA}", "\u{B303}", "\u{1103}\u{1162}\u{11AA}"),
    ("\u{B304}", "\u{B304}", "\u{1103}\u{1162}\u{11AB}", "\u{B304}", "\u{1103}\u{1162}\u{11AB}"),
    ("\u{B305}", "\u{B305}", "\u{1103}\u{1162}\u{11AC}", "\u{B305}", "\u{1103}\u{1162}\u{11AC}"),
    ("\u{B306}", "\u{B306}", "\u{1103}\u{1162}\u{11AD}", "\u{B306}", "\u{1103}\u{1162}\u{11AD}"),
    ("\u{B307}", "\u{B307}", "\u{1103}\u{1162}\u{11AE}", "\u{B307}", "\u{1103}\u{1162}\u{11AE}"),
    ("\u{B308}", "\u{B308}", "\u{1103}\u{1162}\u{11AF}", "\u{B308}", "\u{1103}\u{1162}\u{11AF}"),
    ("\u{B309}", "\u{B309}", "\u{1103}\u{1162}\u{11B0}", "\u{B309}", "\u{1103}\u{1162}\u{11B0}"),
    ("\u{B30A}", "\u{B30A}", "\u{1103}\u{1162}\u{11B1}", "\u{B30A}", "\u{1103}\u{1162}\u{11B1}"),
    ("\u{B30B}", "\u{B30B}", "\u{1103}\u{1162}\u{11B2}", "\u{B30B}", "\u{1103}\u{1162}\u{11B2}"),
    ("\u{B30C}", "\u{B30C}", "\u{1103}\u{1162}\u{11B3}", "\u{B30C}", "\u{1103}\u{1162}\u{11B3}"),
    ("\u{B30D}", "\u{B30D}", "\u{1103}\u{1162}\u{11B4}", "\u{B30D}", "\u{1103}\u{1162}\u{11B4}"),
    ("\u{B30E}", "\u{B30E}", "\u{1103}\u{1162}\u{11B5}", "\u{B30E}", "\u{1103}\u{1162}\u{11B5}"),
    ("\u{B30F}", "\u{B30F}", "\u{1103}\u{1162}\u{11B6}", "\u{B30F}", "\u{1103}\u{1162}\u{11B6}"),
    ("\u{B310}", "\u{B310}", "\u{1103}\u{1162}\u{11B7}", "\u{B310}", "\u{1103}\u{1162}\u{11B7}"),
    ("\u{B311}", "\u{B311}", "\u{1103}\u{1162}\u{11B8}", "\u{B311}", "\u{1103}\u{1162}\u{11B8}"),
    ("\u{B312}", "\u{B312}", "\u{1103}\u{1162}\u{11B9}", "\u{B312}", "\u{1103}\u{1162}\u{11B9}"),
    ("\u{B313}", "\u{B313}", "\u{1103}\u{1162}\u{11BA}", "\u{B313}", "\u{1103}\u{1162}\u{11BA}"),
    ("\u{B314}", "\u{B314}", "\u{1103}\u{1162}\u{11BB}", "\u{B314}", "\u{1103}\u{1162}\u{11BB}"),
    ("\u{B315}", "\u{B315}", "\u{1103}\u{1162}\u{11BC}", "\u{B315}", "\u{1103}\u{1162}\u{11BC}"),
    ("\u{B316}", "\u{B316}", "\u{1103}\u{1162}\u{11BD}", "\u{B316}", "\u{1103}\u{1162}\u{11BD}"),
    ("\u{B317}", "\u{B317}", "\u{1103}\u{1162}\u{11BE}", "\u{B317}", "\u{1103}\u{1162}\u{11BE}"),
    ("\u{B318}", "\u{B318}", "\u{1103}\u{1162}\u{11BF}", "\u{B318}", "\u{1103}\u{1162}\u{11BF}"),
    ("\u{B319}", "\u{B319}", "\u{1103}\u{1162}\u{11C0}", "\u{B319}", "\u{1103}\u{1162}\u{11C0}"),
    ("\u{B31A}", "\u{B31A}", "\u{1103}\u{1162}\u{11C1}", "\u{B31A}", "\u{1103}\u{1162}\u{11C1}"),
    ("\u{B31B}", "\u{B31B}", "\u{1103}\u{1162}\u{11C2}", "\u{B31B}", "\u{1103}\u{1162}\u{11C2}"),
    ("\u{B31C}", "\u{B31C}", "\u{1103}\u{1163}", "\u{B31C}", "\u{1103}\u{1163}"),
    ("\u{B31D}", "\u{B31D}", "\u{1103}\u{1163}\u{11A8}", "\u{B31D}", "\u{1103}\u{1163}\u{11A8}"),
    ("\u{B31E}", "\u{B31E}", "\u{1103}\u{1163}\u{11A9}", "\u{B31E}", "\u{1103}\u{1163}\u{11A9}"),
    ("\u{B31F}", "\u{B31F}", "\u{1103}\u{1163}\u{11AA}", "\u{B31F}", "\u{1103}\u{1163}\u{11AA}"),
    ("\u{B320}", "\u{B320}", "\u{1103}\u{1163}\u{11AB}", "\u{B320}", "\u{1103}\u{1163}\u{11AB}"),
    ("\u{B321}", "\u{B321}", "\u{1103}\u{1163}\u{11AC}", "\u{B321}", "\u{1103}\u{1163}\u{11AC}"),
    ("\u{B322}", "\u{B322}", "\u{1103}\u{1163}\u{11AD}", "\u{B322}", "\u{1103}\u{1163}\u{11AD}"),
    ("\u{B323}", "\u{B323}", "\u{1103}\u{1163}\u{11AE}", "\u{B323}", "\u{1103}\u{1163}\u{11AE}"),
    ("\u{B324}", "\u{B324}", "\u{1103}\u{1163}\u{11AF}", "\u{B324}", "\u{1103}\u{1163}\u{11AF}"),
    ("\u{B325}", "\u{B325}", "\u{1103}\u{1163}\u{11B0}", "\u{B325}", "\u{1103}\u{1163}\u{11B0}"),
    ("\u{B326}", "\u{B326}", "\u{1103}\u{1163}\u{11B1}", "\u{B326}", "\u{1103}\u{1163}\u{11B1}"),
    ("\u{B327}", "\u{B327}", "\u{1103}\u{1163}\u{11B2}", "\u{B327}", "\u{1103}\u{1163}\u{11B2}"),
    ("\u{B328}", "\u{B328}", "\u{1103}\u{1163}\u{11B3}", "\u{B328}", "\u{1103}\u{1163}\u{11B3}"),
    ("\u{B329}", "\u{B329}", "\u{1103}\u{1163}\u{11B4}", "\u{B329}", "\u{1103}\u{1163}\u{11B4}"),
    ("\u{B32A}", "\u{B32A}", "\u{1103}\u{1163}\u{11B5}", "\u{B32A}", "\u{1103}\u{1163}\u{11B5}"),
    ("\u{B32B}", "\u{B32B}", "\u{1103}\u{1163}\u{11B6}", "\u{B32B}", "\u{1103}\u{1163}\u{11B6}"),
    ("\u{B32C}", "\u{B32C}", "\u{1103}\u{1163}\u{11B7}", "\u{B32C}", "\u{1103}\u{1163}\u{11B7}"),
    ("\u{B32D}", "\u{B32D}", "\u{1103}\u{1163}\u{11B8}", "\u{B32D}", "\u{1103}\u{1163}\u{11B8}"),
    ("\u{B32E}", "\u{B32E}", "\u{1103}\u{1163}\u{11B9}", "\u{B32E}", "\u{1103}\u{1163}\u{11B9}"),
    ("\u{B32F}", "\u{B32F}", "\u{1103}\u{1163}\u{11BA}", "\u{B32F}", "\u{1103}\u{1163}\u{11BA}"),
    ("\u{B330}", "\u{B330}", "\u{1103}\u{1163}\u{11BB}", "\u{B330}", "\u{1103}\u{1163}\u{11BB}"),
    ("\u{B331}", "\u{B331}", "\u{1103}\u{1163}\u{11BC}", "\u{B331}", "\u{1103}\u{1163}\u{11BC}"),
    ("\u{B332}", "\u{B332}", "\u{1103}\u{1163}\u{11BD}", "\u{B332}", "\u{1103}\u{1163}\u{11BD}"),
    ("\u{B333}", "\u{B333}", "\u{1103}\u{1163}\u{11BE}", "\u{B333}", "\u{1103}\u{1163}\u{11BE}"),
    ("\u{B334}", "\u{B334}", "\u{1103}\u{1163}\u{11BF}", "\u{B334}", "\u{1103}\u{1163}\u{11BF}"),
    ("\u{B335}", "\u{B335}", "\u{1103}\u{1163}\u{11C0}", "\u{B335}", "\u{1103}\u{1163}\u{11C0}"),
    ("\u{B336}", "\u{B336}", "\u{1103}\u{1163}\u{11C1}", "\u{B336}", "\u{1103}\u{1163}\u{11C1}"),
    ("\u{B337}", "\u{B337}", "\u{1103}\u{1163}\u{11C2}", "\u{B337}", "\u{1103}\u{1163}\u{11C2}"),
    ("\u{B338}", "\u{B338}", "\u{1103}\u{1164}", "\u{B338}", "\u{1103}\u{1164}"),
    ("\u{B339}", "\u{B339}", "\u{1103}\u{1164}\u{11A8}", "\u{B339}", "\u{1103}\u{1164}\u{11A8}"),
    ("\u{B33A}", "\u{B33A}", "\u{1103}\u{1164}\u{11A9}", "\u{B33A}", "\u{1103}\u{1164}\u{11A9}"),
    ("\u{B33B}", "\u{B33B}", "\u{1103}\u{1164}\u{11AA}", "\u{B33B}", "\u{1103}\u{1164}\u{11AA}"),
    ("\u{B33C}", "\u{B33C}", "\u{1103}\u{1164}\u{11AB}", "\u{B33C}", "\u{1103}\u{1164}\u{11AB}"),
    ("\u{B33D}", "\u{B33D}", "\u{1103}\u{1164}\u{11AC}", "\u{B33D}", "\u{1103}\u{1164}\u{11AC}"),
    ("\u{B33E}", "\u{B33E}", "\u{1103}\u{1164}\u{11AD}", "\u{B33E}", "\u{1103}\u{1164}\u{11AD}"),
    ("\u{B33F}", "\u{B33F}", "\u{1103}\u{1164}\u{11AE}", "\u{B33F}", "\u{1103}\u{1164}\u{11AE}"),
    ("\u{B340}", "\u{B340}", "\u{1103}\u{1164}\u{11AF}", "\u{B340}", "\u{1103}\u{1164}\u{11AF}"),
    ("\u{B341}", "\u{B341}", "\u{1103}\u{1164}\u{11B0}", "\u{B341}", "\u{1103}\u{1164}\u{11B0}"),
    ("\u{B342}", "\u{B342}", "\u{1103}\u{1164}\u{11B1}", "\u{B342}", "\u{1103}\u{1164}\u{11B1}"),
    ("\u{B343}", "\u{B343}", "\u{1103}\u{1164}\u{11B2}", "\u{B343}", "\u{1103}\u{1164}\u{11B2}"),
    ("\u{B344}", "\u{B344}", "\u{1103}\u{1164}\u{11B3}", "\u{B344}", "\u{1103}\u{1164}\u{11B3}"),
    ("\u{B345}", "\u{B345}", "\u{1103}\u{1164}\u{11B4}", "\u{B345}", "\u{1103}\u{1164}\u{11B4}"),
    ("\u{B346}", "\u{B346}", "\u{1103}\u{1164}\u{11B5}", "\u{B346}", "\u{1103}\u{1164}\u{11B5}"),
    ("\u{B347}", "\u{B347}", "\u{1103}\u{1164}\u{11B6}", "\u{B347}", "\u{1103}\u{1164}\u{11B6}"),
    ("\u{B348}", "\u{B348}", "\u{1103}\u{1164}\u{11B7}", "\u{B348}", "\u{1103}\u{1164}\u{11B7}"),
    ("\u{B349}", "\u{B349}", "\u{1103}\u{1164}\u{11B8}", "\u{B349}", "\u{1103}\u{1164}\u{11B8}"),
    ("\u{B34A}", "\u{B34A}", "\u{1103}\u{1164}\u{11B9}", "\u{B34A}", "\u{1103}\u{1164}\u{11B9}"),
    ("\u{B34B}", "\u{B34B}", "\u{1103}\u{1164}\u{11BA}", "\u{B34B}", "\u{1103}\u{1164}\u{11BA}"),
    ("\u{B34C}", "\u{B34C}", "\u{1103}\u{1164}\u{11BB}", "\u{B34C}", "\u{1103}\u{1164}\u{11BB}"),
    ("\u{B34D}", "\u{B34D}", "\u{1103}\u{1164}\u{11BC}", "\u{B34D}", "\u{1103}\u{1164}\u{11BC}"),
    ("\u{B34E}", "\u{B34E}", "\u{1103}\u{1164}\u{11BD}", "\u{B34E}", "\u{1103}\u{1164}\u{11BD}"),
    ("\u{B34F}", "\u{B34F}", "\u{1103}\u{1164}\u{11BE}", "\u{B34F}", "\u{1103}\u{1164}\u{11BE}"),
    ("\u{B350}", "\u{B350}", "\u{1103}\u{1164}\u{11BF}", "\u{B350}", "\u{1103}\u{1164}\u{11BF}"),
    ("\u{B351}", "\u{B351}", "\u{1103}\u{1164}\u{11C0}", "\u{B351}", "\u{1103}\u{1164}\u{11C0}"),
    ("\u{B352}", "\u{B352}", "\u{1103}\u{1164}\u{11C1}", "\u{B352}", "\u{1103}\u{1164}\u{11C1}"),
    ("\u{B353}", "\u{B353}", "\u{1103}\u{1164}\u{11C2}", "\u{B353}", "\u{1103}\u{1164}\u{11C2}"),
    ("\u{B354}", "\u{B354}", "\u{1103}\u{1165}", "\u{B354}", "\u{1103}\u{1165}"),
    ("\u{B355}", "\u{B355}", "\u{1103}\u{1165}\u{11A8}", "\u{B355}", "\u{1103}\u{1165}\u{11A8}"),
    ("\u{B356}", "\u{B356}", "\u{1103}\u{1165}\u{11A9}", "\u{B356}", "\u{1103}\u{1165}\u{11A9}"),
    ("\u{B357}", "\u{B357}", "\u{1103}\u{1165}\u{11AA}", "\u{B357}", "\u{1103}\u{1165}\u{11AA}"),
    ("\u{B358}", "\u{B358}", "\u{1103}\u{1165}\u{11AB}", "\u{B358}", "\u{1103}\u{1165}\u{11AB}"),
    ("\u{B359}", "\u{B359}", "\u{1103}\u{1165}\u{11AC}", "\u{B359}", "\u{1103}\u{1165}\u{11AC}"),
    ("\u{B35A}", "\u{B35A}", "\u{1103}\u{1165}\u{11AD}", "\u{B35A}", "\u{1103}\u{1165}\u{11AD}"),
    ("\u{B35B}", "\u{B35B}", "\u{1103}\u{1165}\u{11AE}", "\u{B35B}", "\u{1103}\u{1165}\u{11AE}"),
    ("\u{B35C}", "\u{B35C}", "\u{1103}\u{1165}\u{11AF}", "\u{B35C}", "\u{1103}\u{1165}\u{11AF}"),
    ("\u{B35D}", "\u{B35D}", "\u{1103}\u{1165}\u{11B0}", "\u{B35D}", "\u{1103}\u{1165}\u{11B0}"),
    ("\u{B35E}", "\u{B35E}", "\u{1103}\u{1165}\u{11B1}", "\u{B35E}", "\u{1103}\u{1165}\u{11B1}"),
    ("\u{B35F}", "\u{B35F}", "\u{1103}\u{1165}\u{11B2}", "\u{B35F}", "\u{1103}\u{1165}\u{11B2}"),
    ("\u{B360}", "\u{B360}", "\u{1103}\u{1165}\u{11B3}", "\u{B360}", "\u{1103}\u{1165}\u{11B3}"),
    ("\u{B361}", "\u{B361}", "\u{1103}\u{1165}\u{11B4}", "\u{B361}", "\u{1103}\u{1165}\u{11B4}"),
    ("\u{B362}", "\u{B362}", "\u{1103}\u{1165}\u{11B5}", "\u{B362}", "\u{1103}\u{1165}\u{11B5}"),
    ("\u{B363}", "\u{B363}", "\u{1103}\u{1165}\u{11B6}", "\u{B363}", "\u{1103}\u{1165}\u{11B6}"),
    ("\u{B364}", "\u{B364}", "\u{1103}\u{1165}\u{11B7}", "\u{B364}", "\u{1103}\u{1165}\u{11B7}"),
    ("\u{B365}", "\u{B365}", "\u{1103}\u{1165}\u{11B8}", "\u{B365}", "\u{1103}\u{1165}\u{11B8}"),
    ("\u{B366}", "\u{B366}", "\u{1103}\u{1165}\u{11B9}", "\u{B366}", "\u{1103}\u{1165}\u{11B9}"),
    ("\u{B367}", "\u{B367}", "\u{1103}\u{1165}\u{11BA}", "\u{B367}", "\u{1103}\u{1165}\u{11BA}"),
    ("\u{B368}", "\u{B368}", "\u{1103}\u{1165}\u{11BB}", "\u{B368}", "\u{1103}\u{1165}\u{11BB}"),
    ("\u{B369}", "\u{B369}", "\u{1103}\u{1165}\u{11BC}", "\u{B369}", "\u{1103}\u{1165}\u{11BC}"),
    ("\u{B36A}", "\u{B36A}", "\u{1103}\u{1165}\u{11BD}", "\u{B36A}", "\u{1103}\u{1165}\u{11BD}"),
    ("\u{B36B}", "\u{B36B}", "\u{1103}\u{1165}\u{11BE}", "\u{B36B}", "\u{1103}\u{1165}\u{11BE}"),
    ("\u{B36C}", "\u{B36C}", "\u{1103}\u{1165}\u{11BF}", "\u{B36C}", "\u{1103}\u{1165}\u{11BF}"),
    ("\u{B36D}", "\u{B36D}", "\u{1103}\u{1165}\u{11C0}", "\u{B36D}", "\u{1103}\u{1165}\u{11C0}"),
    ("\u{B36E}", "\u{B36E}", "\u{1103}\u{1165}\u{11C1}", "\u{B36E}", "\u{1103}\u{1165}\u{11C1}"),
    ("\u{B36F}", "\u{B36F}", "\u{1103}\u{1165}\u{11C2}", "\u{B36F}", "\u{1103}\u{1165}\u{11C2}"),
    ("\u{B370}", "\u{B370}", "\u{1103}\u{1166}", "\u{B370}", "\u{1103}\u{1166}"),
    ("\u{B371}", "\u{B371}", "\u{1103}\u{1166}\u{11A8}", "\u{B371}", "\u{1103}\u{1166}\u{11A8}"),
    ("\u{B372}", "\u{B372}", "\u{1103}\u{1166}\u{11A9}", "\u{B372}", "\u{1103}\u{1166}\u{11A9}"),
    ("\u{B373}", "\u{B373}", "\u{1103}\u{1166}\u{11AA}", "\u{B373}", "\u{1103}\u{1166}\u{11AA}"),
    ("\u{B374}", "\u{B374}", "\u{1103}\u{1166}\u{11AB}", "\u{B374}", "\u{1103}\u{1166}\u{11AB}"),
    ("\u{B375}", "\u{B375}", "\u{1103}\u{1166}\u{11AC}", "\u{B375}", "\u{1103}\u{1166}\u{11AC}"),
    ("\u{B376}", "\u{B376}", "\u{1103}\u{1166}\u{11AD}", "\u{B376}", "\u{1103}\u{1166}\u{11AD}"),
    ("\u{B377}", "\u{B377}", "\u{1103}\u{1166}\u{11AE}", "\u{B377}", "\u{1103}\u{1166}\u{11AE}"),
    ("\u{B378}", "\u{B378}", "\u{1103}\u{1166}\u{11AF}", "\u{B378}", "\u{1103}\u{1166}\u{11AF}"),
    ("\u{B379}", "\u{B379}", "\u{1103}\u{1166}\u{11B0}", "\u{B379}", "\u{1103}\u{1166}\u{11B0}"),
    ("\u{B37A}", "\u{B37A}", "\u{1103}\u{1166}\u{11B1}", "\u{B37A}", "\u{1103}\u{1166}\u{11B1}"),
    ("\u{B37B}", "\u{B37B}", "\u{1103}\u{1166}\u{11B2}", "\u{B37B}", "\u{1103}\u{1166}\u{11B2}"),
    ("\u{B37C}", "\u{B37C}", "\u{1103}\u{1166}\u{11B3}", "\u{B37C}", "\u{1103}\u{1166}\u{11B3}"),
    ("\u{B37D}", "\u{B37D}", "\u{1103}\u{1166}\u{11B4}", "\u{B37D}", "\u{1103}\u{1166}\u{11B4}"),
    ("\u{B37E}", "\u{B37E}", "\u{1103}\u{1166}\u{11B5}", "\u{B37E}", "\u{1103}\u{1166}\u{11B5}"),
    ("\u{B37F}", "\u{B37F}", "\u{1103}\u{1166}\u{11B6}", "\u{B37F}", "\u{1103}\u{1166}\u{11B6}"),
    ("\u{B380}", "\u{B380}", "\u{1103}\u{1166}\u{11B7}", "\u{B380}", "\u{1103}\u{1166}\u{11B7}"),
    ("\u{B381}", "\u{B381}", "\u{1103}\u{1166}\u{11B8}", "\u{B381}", "\u{1103}\u{1166}\u{11B8}"),
    ("\u{B382}", "\u{B382}", "\u{1103}\u{1166}\u{11B9}", "\u{B382}", "\u{1103}\u{1166}\u{11B9}"),
    ("\u{B383}", "\u{B383}", "\u{1103}\u{1166}\u{11BA}", "\u{B383}", "\u{1103}\u{1166}\u{11BA}"),
    ("\u{B384}", "\u{B384}", "\u{1103}\u{1166}\u{11BB}", "\u{B384}", "\u{1103}\u{1166}\u{11BB}"),
    ("\u{B385}", "\u{B385}", "\u{1103}\u{1166}\u{11BC}", "\u{B385}", "\u{1103}\u{1166}\u{11BC}"),
    ("\u{B386}", "\u{B386}", "\u{1103}\u{1166}\u{11BD}", "\u{B386}", "\u{1103}\u{1166}\u{11BD}"),
    ("\u{B387}", "\u{B387}", "\u{1103}\u{1166}\u{11BE}", "\u{B387}", "\u{1103}\u{1166}\u{11BE}"),
    ("\u{B388}", "\u{B388}", "\u{1103}\u{1166}\u{11BF}", "\u{B388}", "\u{1103}\u{1166}\u{11BF}"),
    ("\u{B389}", "\u{B389}", "\u{1103}\u{1166}\u{11C0}", "\u{B389}", "\u{1103}\u{1166}\u{11C0}"),
    ("\u{B38A}", "\u{B38A}", "\u{1103}\u{1166}\u{11C1}", "\u{B38A}", "\u{1103}\u{1166}\u{11C1}"),
    ("\u{B38B}", "\u{B38B}", "\u{1103}\u{1166}\u{11C2}", "\u{B38B}", "\u{1103}\u{1166}\u{11C2}"),
    ("\u{B38C}", "\u{B38C}", "\u{1103}\u{1167}", "\u{B38C}", "\u{1103}\u{1167}"),
    ("\u{B38D}", "\u{B38D}", "\u{1103}\u{1167}\u{11A8}", "\u{B38D}", "\u{1103}\u{1167}\u{11A8}"),
    ("\u{B38E}", "\u{B38E}", "\u{1103}\u{1167}\u{11A9}", "\u{B38E}", "\u{1103}\u{1167}\u{11A9}"),
    ("\u{B38F}", "\u{B38F}", "\u{1103}\u{1167}\u{11AA}", "\u{B38F}", "\u{1103}\u{1167}\u{11AA}"),
    ("\u{B390}", "\u{B390}", "\u{1103}\u{1167}\u{11AB}", "\u{B390}", "\u{1103}\u{1167}\u{11AB}"),
    ("\u{B391}", "\u{B391}", "\u{1103}\u{1167}\u{11AC}", "\u{B391}", "\u{1103}\u{1167}\u{11AC}"),
    ("\u{B392}", "\u{B392}", "\u{1103}\u{1167}\u{11AD}", "\u{B392}", "\u{1103}\u{1167}\u{11AD}"),
    ("\u{B393}", "\u{B393}", "\u{1103}\u{1167}\u{11AE}", "\u{B393}", "\u{1103}\u{1167}\u{11AE}"),
    ("\u{B394}", "\u{B394}", "\u{1103}\u{1167}\u{11AF}", "\u{B394}", "\u{1103}\u{1167}\u{11AF}"),
    ("\u{B395}", "\u{B395}", "\u{1103}\u{1167}\u{11B0}", "\u{B395}", "\u{1103}\u{1167}\u{11B0}"),
    ("\u{B396}", "\u{B396}", "\u{1103}\u{1167}\u{11B1}", "\u{B396}", "\u{1103}\u{1167}\u{11B1}"),
    ("\u{B397}", "\u{B397}", "\u{1103}\u{1167}\u{11B2}", "\u{B397}", "\u{1103}\u{1167}\u{11B2}"),
    ("\u{B398}", "\u{B398}", "\u{1103}\u{1167}\u{11B3}", "\u{B398}", "\u{1103}\u{1167}\u{11B3}"),
    ("\u{B399}", "\u{B399}", "\u{1103}\u{1167}\u{11B4}", "\u{B399}", "\u{1103}\u{1167}\u{11B4}"),
    ("\u{B39A}", "\u{B39A}", "\u{1103}\u{1167}\u{11B5}", "\u{B39A}", "\u{1103}\u{1167}\u{11B5}"),
    ("\u{B39B}", "\u{B39B}", "\u{1103}\u{1167}\u{11B6}", "\u{B39B}", "\u{1103}\u{1167}\u{11B6}"),
    ("\u{B39C}", "\u{B39C}", "\u{1103}\u{1167}\u{11B7}", "\u{B39C}", "\u{1103}\u{1167}\u{11B7}"),
    ("\u{B39D}", "\u{B39D}", "\u{1103}\u{1167}\u{11B8}", "\u{B39D}", "\u{1103}\u{1167}\u{11B8}"),
    ("\u{B39E}", "\u{B39E}", "\u{1103}\u{1167}\u{11B9}", "\u{B39E}", "\u{1103}\u{1167}\u{11B9}"),
    ("\u{B39F}", "\u{B39F}", "\u{1103}\u{1167}\u{11BA}", "\u{B39F}", "\u{1103}\u{1167}\u{11BA}"),
    ("\u{B3A0}", "\u{B3A0}", "\u{1103}\u{1167}\u{11BB}", "\u{B3A0}", "\u{1103}\u{1167}\u{11BB}"),
    ("\u{B3A1}", "\u{B3A1}", "\u{1103}\u{1167}\u{11BC}", "\u{B3A1}", "\u{1103}\u{1167}\u{11BC}"),
    ("\u{B3A2}", "\u{B3A2}", "\u{1103}\u{1167}\u{11BD}", "\u{B3A2}", "\u{1103}\u{1167}\u{11BD}"),
    ("\u{B3A3}", "\u{B3A3}", "\u{1103}\u{1167}\u{11BE}", "\u{B3A3}", "\u{1103}\u{1167}\u{11BE}"),
    ("\u{B3A4}", "\u{B3A4}", "\u{1103}\u{1167}\u{11BF}", "\u{B3A4}", "\u{1103}\u{1167}\u{11BF}"),
    ("\u{B3A5}", "\u{B3A5}", "\u{1103}\u{1167}\u{11C0}", "\u{B3A5}", "\u{1103}\u{1167}\u{11C0}"),
    ("\u{B3A6}", "\u{B3A6}", "\u{1103}\u{1167}\u{11C1}", "\u{B3A6}", "\u{1103}\u{1167}\u{11C1}"),
    ("\u{B3A7}", "\u{B3A7}", "\u{1103}\u{1167}\u{11C2}", "\u{B3A7}", "\u{1103}\u{1167}\u{11C2}"),
    ("\u{B3A8}", "\u{B3A8}", "\u{1103}\u{1168}", "\u{B3A8}", "\u{1103}\u{1168}"),
    ("\u{B3A9}", "\u{B3A9}", "\u{1103}\u{1168}\u{11A8}", "\u{B3A9}", "\u{1103}\u{1168}\u{11A8}"),
    ("\u{B3AA}", "\u{B3AA}", "\u{1103}\u{1168}\u{11A9}", "\u{B3AA}", "\u{1103}\u{1168}\u{11A9}"),
    ("\u{B3AB}", "\u{B3AB}", "\u{1103}\u{1168}\u{11AA}", "\u{B3AB}", "\u{1103}\u{1168}\u{11AA}"),
    ("\u{B3AC}", "\u{B3AC}", "\u{1103}\u{1168}\u{11AB}", "\u{B3AC}", "\u{1103}\u{1168}\u{11AB}"),
    ("\u{B3AD}", "\u{B3AD}", "\u{1103}\u{1168}\u{11AC}", "\u{B3AD}", "\u{1103}\u{1168}\u{11AC}"),
    ("\u{B3AE}", "\u{B3AE}", "\u{1103}\u{1168}\u{11AD}", "\u{B3AE}", "\u{1103}\u{1168}\u{11AD}"),
    ("\u{B3AF}", "\u{B3AF}", "\u{1103}\u{1168}\u{11AE}", "\u{B3AF}", "\u{1103}\u{1168}\u{11AE}"),
    ("\u{B3B0}", "\u{B3B0}", "\u{1103}\u{1168}\u{11AF}", "\u{B3B0}", "\u{1103}\u{1168}\u{11AF}"),
    ("\u{B3B1}", "\u{B3B1}", "\u{1103}\u{1168}\u{11B0}", "\u{B3B1}", "\u{1103}\u{1168}\u{11B0}"),
    ("\u{B3B2}", "\u{B3B2}", "\u{1103}\u{1168}\u{11B1}", "\u{B3B2}", "\u{1103}\u{1168}\u{11B1}"),
    ("\u{B3B3}", "\u{B3B3}", "\u{1103}\u{1168}\u{11B2}", "\u{B3B3}", "\u{1103}\u{1168}\u{11B2}"),
    ("\u{B3B4}", "\u{B3B4}", "\u{1103}\u{1168}\u{11B3}", "\u{B3B4}", "\u{1103}\u{1168}\u{11B3}"),
    ("\u{B3B5}", "\u{B3B5}", "\u{1103}\u{1168}\u{11B4}", "\u{B3B5}", "\u{1103}\u{1168}\u{11B4}"),
    ("\u{B3B6}", "\u{B3B6}", "\u{1103}\u{1168}\u{11B5}", "\u{B3B6}", "\u{1103}\u{1168}\u{11B5}"),
    ("\u{B3B7}", "\u{B3B7}", "\u{1103}\u{1168}\u{11B6}", "\u{B3B7}", "\u{1103}\u{1168}\u{11B6}"),
    ("\u{B3B8}", "\u{B3B8}", "\u{1103}\u{1168}\u{11B7}", "\u{B3B8}", "\u{1103}\u{1168}\u{11B7}"),
    ("\u{B3B9}", "\u{B3B9}", "\u{1103}\u{1168}\u{11B8}", "\u{B3B9}", "\u{1103}\u{1168}\u{11B8}"),
    ("\u{B3BA}", "\u{B3BA}", "\u{1103}\u{1168}\u{11B9}", "\u{B3BA}", "\u{1103}\u{1168}\u{11B9}"),
    ("\u{B3BB}", "\u{B3BB}", "\u{1103}\u{1168}\u{11BA}", "\u{B3BB}", "\u{1103}\u{1168}\u{11BA}"),
    ("\u{B3BC}", "\u{B3BC}", "\u{1103}\u{1168}\u{11BB}", "\u{B3BC}", "\u{1103}\u{1168}\u{11BB}"),
    ("\u{B3BD}", "\u{B3BD}", "\u{1103}\u{1168}\u{11BC}", "\u{B3BD}", "\u{1103}\u{1168}\u{11BC}"),
    ("\u{B3BE}", "\u{B3BE}", "\u{1103}\u{1168}\u{11BD}", "\u{B3BE}", "\u{1103}\u{1168}\u{11BD}"),
    ("\u{B3BF}", "\u{B3BF}", "\u{1103}\u{1168}\u{11BE}", "\u{B3BF}", "\u{1103}\u{1168}\u{11BE}"),
    ("\u{B3C0}", "\u{B3C0}", "\u{1103}\u{1168}\u{11BF}", "\u{B3C0}", "\u{1103}\u{1168}\u{11BF}"),
    ("\u{B3C1}", "\u{B3C1}", "\u{1103}\u{1168}\u{11C0}", "\u{B3C1}", "\u{1103}\u{1168}\u{11C0}"),
    ("\u{B3C2}", "\u{B3C2}", "\u{1103}\u{1168}\u{11C1}", "\u{B3C2}", "\u{1103}\u{1168}\u{11C1}"),
    ("\u{B3C3}", "\u{B3C3}", "\u{1103}\u{1168}\u{11C2}", "\u{B3C3}", "\u{1103}\u{1168}\u{11C2}"),
    ("\u{B3C4}", "\u{B3C4}", "\u{1103}\u{1169}", "\u{B3C4}", "\u{1103}\u{1169}"),
    ("\u{B3C5}", "\u{B3C5}", "\u{1103}\u{1169}\u{11A8}", "\u{B3C5}", "\u{1103}\u{1169}\u{11A8}"),
    ("\u{B3C6}", "\u{B3C6}", "\u{1103}\u{1169}\u{11A9}", "\u{B3C6}", "\u{1103}\u{1169}\u{11A9}"),
    ("\u{B3C7}", "\u{B3C7}", "\u{1103}\u{1169}\u{11AA}", "\u{B3C7}", "\u{1103}\u{1169}\u{11AA}"),
    ("\u{B3C8}", "\u{B3C8}", "\u{1103}\u{1169}\u{11AB}", "\u{B3C8}", "\u{1103}\u{1169}\u{11AB}"),
    ("\u{B3C9}", "\u{B3C9}", "\u{1103}\u{1169}\u{11AC}", "\u{B3C9}", "\u{1103}\u{1169}\u{11AC}"),
    ("\u{B3CA}", "\u{B3CA}", "\u{1103}\u{1169}\u{11AD}", "\u{B3CA}", "\u{1103}\u{1169}\u{11AD}"),
    ("\u{B3CB}", "\u{B3CB}", "\u{1103}\u{1169}\u{11AE}", "\u{B3CB}", "\u{1103}\u{1169}\u{11AE}"),
    ("\u{B3CC}", "\u{B3CC}", "\u{1103}\u{1169}\u{11AF}", "\u{B3CC}", "\u{1103}\u{1169}\u{11AF}"),
    ("\u{B3CD}", "\u{B3CD}", "\u{1103}\u{1169}\u{11B0}", "\u{B3CD}", "\u{1103}\u{1169}\u{11B0}"),
    ("\u{B3CE}", "\u{B3CE}", "\u{1103}\u{1169}\u{11B1}", "\u{B3CE}", "\u{1103}\u{1169}\u{11B1}"),
    ("\u{B3CF}", "\u{B3CF}", "\u{1103}\u{1169}\u{11B2}", "\u{B3CF}", "\u{1103}\u{1169}\u{11B2}"),
    ("\u{B3D0}", "\u{B3D0}", "\u{1103}\u{1169}\u{11B3}", "\u{B3D0}", "\u{1103}\u{1169}\u{11B3}"),
    ("\u{B3D1}", "\u{B3D1}", "\u{1103}\u{1169}\u{11B4}", "\u{B3D1}", "\u{1103}\u{1169}\u{11B4}"),
    ("\u{B3D2}", "\u{B3D2}", "\u{1103}\u{1169}\u{11B5}", "\u{B3D2}", "\u{1103}\u{1169}\u{11B5}"),
    ("\u{B3D3}", "\u{B3D3}", "\u{1103}\u{1169}\u{11B6}", "\u{B3D3}", "\u{1103}\u{1169}\u{11B6}"),
    ("\u{B3D4}", "\u{B3D4}", "\u{1103}\u{1169}\u{11B7}", "\u{B3D4}", "\u{1103}\u{1169}\u{11B7}"),
    ("\u{B3D5}", "\u{B3D5}", "\u{1103}\u{1169}\u{11B8}", "\u{B3D5}", "\u{1103}\u{1169}\u{11B8}"),
    ("\u{B3D6}", "\u{B3D6}", "\u{1103}\u{1169}\u{11B9}", "\u{B3D6}", "\u{1103}\u{1169}\u{11B9}"),
    ("\u{B3D7}", "\u{B3D7}", "\u{1103}\u{1169}\u{11BA}", "\u{B3D7}", "\u{1103}\u{1169}\u{11BA}"),
    ("\u{B3D8}", "\u{B3D8}", "\u{1103}\u{1169}\u{11BB}", "\u{B3D8}", "\u{1103}\u{1169}\u{11BB}"),
    ("\u{B3D9}", "\u{B3D9}", "\u{1103}\u{1169}\u{11BC}", "\u{B3D9}", "\u{1103}\u{1169}\u{11BC}"),
    ("\u{B3DA}", "\u{B3DA}", "\u{1103}\u{1169}\u{11BD}", "\u{B3DA}", "\u{1103}\u{1169}\u{11BD}"),
    ("\u{B3DB}", "\u{B3DB}", "\u{1103}\u{1169}\u{11BE}", "\u{B3DB}", "\u{1103}\u{1169}\u{11BE}"),
    ("\u{B3DC}", "\u{B3DC}", "\u{1103}\u{1169}\u{11BF}", "\u{B3DC}", "\u{1103}\u{1169}\u{11BF}"),
    ("\u{B3DD}", "\u{B3DD}", "\u{1103}\u{1169}\u{11C0}", "\u{B3DD}", "\u{1103}\u{1169}\u{11C0}"),
    ("\u{B3DE}", "\u{B3DE}", "\u{1103}\u{1169}\u{11C1}", "\u{B3DE}", "\u{1103}\u{1169}\u{11C1}"),
    ("\u{B3DF}", "\u{B3DF}", "\u{1103}\u{1169}\u{11C2}", "\u{B3DF}", "\u{1103}\u{1169}\u{11C2}"),
    ("\u{B3E0}", "\u{B3E0}", "\u{1103}\u{116A}", "\u{B3E0}", "\u{1103}\u{116A}"),
    ("\u{B3E1}", "\u{B3E1}", "\u{1103}\u{116A}\u{11A8}", "\u{B3E1}", "\u{1103}\u{116A}\u{11A8}"),
    ("\u{B3E2}", "\u{B3E2}", "\u{1103}\u{116A}\u{11A9}", "\u{B3E2}", "\u{1103}\u{116A}\u{11A9}"),
    ("\u{B3E3}", "\u{B3E3}", "\u{1103}\u{116A}\u{11AA}", "\u{B3E3}", "\u{1103}\u{116A}\u{11AA}"),
    ("\u{B3E4}", "\u{B3E4}", "\u{1103}\u{116A}\u{11AB}", "\u{B3E4}", "\u{1103}\u{116A}\u{11AB}"),
    ("\u{B3E5}", "\u{B3E5}", "\u{1103}\u{116A}\u{11AC}", "\u{B3E5}", "\u{1103}\u{116A}\u{11AC}"),
    ("\u{B3E6}", "\u{B3E6}", "\u{1103}\u{116A}\u{11AD}", "\u{B3E6}", "\u{1103}\u{116A}\u{11AD}"),
    ("\u{B3E7}", "\u{B3E7}", "\u{1103}\u{116A}\u{11AE}", "\u{B3E7}", "\u{1103}\u{116A}\u{11AE}"),
    ("\u{B3E8}", "\u{B3E8}", "\u{1103}\u{116A}\u{11AF}", "\u{B3E8}", "\u{1103}\u{116A}\u{11AF}"),
    ("\u{B3E9}", "\u{B3E9}", "\u{1103}\u{116A}\u{11B0}", "\u{B3E9}", "\u{1103}\u{116A}\u{11B0}"),
    ("\u{B3EA}", "\u{B3EA}", "\u{1103}\u{116A}\u{11B1}", "\u{B3EA}", "\u{1103}\u{116A}\u{11B1}"),
    ("\u{B3EB}", "\u{B3EB}", "\u{1103}\u{116A}\u{11B2}", "\u{B3EB}", "\u{1103}\u{116A}\u{11B2}"),
    ("\u{B3EC}", "\u{B3EC}", "\u{1103}\u{116A}\u{11B3}", "\u{B3EC}", "\u{1103}\u{116A}\u{11B3}"),
    ("\u{B3ED}", "\u{B3ED}", "\u{1103}\u{116A}\u{11B4}", "\u{B3ED}", "\u{1103}\u{116A}\u{11B4}"),
    ("\u{B3EE}", "\u{B3EE}", "\u{1103}\u{116A}\u{11B5}", "\u{B3EE}", "\u{1103}\u{116A}\u{11B5}"),
    ("\u{B3EF}", "\u{B3EF}", "\u{1103}\u{116A}\u{11B6}", "\u{B3EF}", "\u{1103}\u{116A}\u{11B6}"),
    ("\u{B3F0}", "\u{B3F0}", "\u{1103}\u{116A}\u{11B7}", "\u{B3F0}", "\u{1103}\u{116A}\u{11B7}"),
    ("\u{B3F1}", "\u{B3F1}", "\u{1103}\u{116A}\u{11B8}", "\u{B3F1}", "\u{1103}\u{116A}\u{11B8}"),
    ("\u{B3F2}", "\u{B3F2}", "\u{1103}\u{116A}\u{11B9}", "\u{B3F2}", "\u{1103}\u{116A}\u{11B9}"),
    ("\u{B3F3}", "\u{B3F3}", "\u{1103}\u{116A}\u{11BA}", "\u{B3F3}", "\u{1103}\u{116A}\u{11BA}"),
    ("\u{B3F4}", "\u{B3F4}", "\u{1103}\u{116A}\u{11BB}", "\u{B3F4}", "\u{1103}\u{116A}\u{11BB}"),
    ("\u{B3F5}", "\u{B3F5}", "\u{1103}\u{116A}\u{11BC}", "\u{B3F5}", "\u{1103}\u{116A}\u{11BC}"),
    ("\u{B3F6}", "\u{B3F6}", "\u{1103}\u{116A}\u{11BD}", "\u{B3F6}", "\u{1103}\u{116A}\u{11BD}"),
    ("\u{B3F7}", "\u{B3F7}", "\u{1103}\u{116A}\u{11BE}", "\u{B3F7}", "\u{1103}\u{116A}\u{11BE}"),
    ("\u{B3F8}", "\u{B3F8}", "\u{1103}\u{116A}\u{11BF}", "\u{B3F8}", "\u{1103}\u{116A}\u{11BF}"),
    ("\u{B3F9}", "\u{B3F9}", "\u{1103}\u{116A}\u{11C0}", "\u{B3F9}", "\u{1103}\u{116A}\u{11C0}"),
    ("\u{B3FA}", "\u{B3FA}", "\u{1103}\u{116A}\u{11C1}", "\u{B3FA}", "\u{1103}\u{116A}\u{11C1}"),
    ("\u{B3FB}", "\u{B3FB}", "\u{1103}\u{116A}\u{11C2}", "\u{B3FB}", "\u{1103}\u{116A}\u{11C2}"),
    ("\u{B3FC}", "\u{B3FC}", "\u{1103}\u{116B}", "\u{B3FC}", "\u{1103}\u{116B}"),
    ("\u{B3FD}", "\u{B3FD}", "\u{1103}\u{116B}\u{11A8}", "\u{B3FD}", "\u{1103}\u{116B}\u{11A8}"),
    ("\u{B3FE}", "\u{B3FE}", "\u{1103}\u{116B}\u{11A9}", "\u{B3FE}", "\u{1103}\u{116B}\u{11A9}"),
    ("\u{B3FF}", "\u{B3FF}", "\u{1103}\u{116B}\u{11AA}", "\u{B3FF}", "\u{1103}\u{116B}\u{11AA}"),
    ("\u{B400}", "\u{B400}", "\u{1103}\u{116B}\u{11AB}", "\u{B400}", "\u{1103}\u{116B}\u{11AB}"),
    ("\u{B401}", "\u{B401}", "\u{1103}\u{116B}\u{11AC}", "\u{B401}", "\u{1103}\u{116B}\u{11AC}"),
    ("\u{B402}", "\u{B402}", "\u{1103}\u{116B}\u{11AD}", "\u{B402}", "\u{1103}\u{116B}\u{11AD}"),
    ("\u{B403}", "\u{B403}", "\u{1103}\u{116B}\u{11AE}", "\u{B403}", "\u{1103}\u{116B}\u{11AE}"),
    ("\u{B404}", "\u{B404}", "\u{1103}\u{116B}\u{11AF}", "\u{B404}", "\u{1103}\u{116B}\u{11AF}"),
    ("\u{B405}", "\u{B405}", "\u{1103}\u{116B}\u{11B0}", "\u{B405}", "\u{1103}\u{116B}\u{11B0}"),
    ("\u{B406}", "\u{B406}", "\u{1103}\u{116B}\u{11B1}", "\u{B406}", "\u{1103}\u{116B}\u{11B1}"),
    ("\u{B407}", "\u{B407}", "\u{1103}\u{116B}\u{11B2}", "\u{B407}", "\u{1103}\u{116B}\u{11B2}"),
    ("\u{B408}", "\u{B408}", "\u{1103}\u{116B}\u{11B3}", "\u{B408}", "\u{1103}\u{116B}\u{11B3}"),
    ("\u{B409}", "\u{B409}", "\u{1103}\u{116B}\u{11B4}", "\u{B409}", "\u{1103}\u{116B}\u{11B4}"),
    ("\u{B40A}", "\u{B40A}", "\u{1103}\u{116B}\u{11B5}", "\u{B40A}", "\u{1103}\u{116B}\u{11B5}"),
    ("\u{B40B}", "\u{B40B}", "\u{1103}\u{116B}\u{11B6}", "\u{B40B}", "\u{1103}\u{116B}\u{11B6}"),
    ("\u{B40C}", "\u{B40C}", "\u{1103}\u{116B}\u{11B7}", "\u{B40C}", "\u{1103}\u{116B}\u{11B7}"),
    ("\u{B40D}", "\u{B40D}", "\u{1103}\u{116B}\u{11B8}", "\u{B40D}", "\u{1103}\u{116B}\u{11B8}"),
    ("\u{B40E}", "\u{B40E}", "\u{1103}\u{116B}\u{11B9}", "\u{B40E}", "\u{1103}\u{116B}\u{11B9}"),
    ("\u{B40F}", "\u{B40F}", "\u{1103}\u{116B}\u{11BA}", "\u{B40F}", "\u{1103}\u{116B}\u{11BA}"),
    ("\u{B410}", "\u{B410}", "\u{1103}\u{116B}\u{11BB}", "\u{B410}", "\u{1103}\u{116B}\u{11BB}"),
    ("\u{B411}", "\u{B411}", "\u{1103}\u{116B}\u{11BC}", "\u{B411}", "\u{1103}\u{116B}\u{11BC}"),
    ("\u{B412}", "\u{B412}", "\u{1103}\u{116B}\u{11BD}", "\u{B412}", "\u{1103}\u{116B}\u{11BD}"),
    ("\u{B413}", "\u{B413}", "\u{1103}\u{116B}\u{11BE}", "\u{B413}", "\u{1103}\u{116B}\u{11BE}"),
    ("\u{B414}", "\u{B414}", "\u{1103}\u{116B}\u{11BF}", "\u{B414}", "\u{1103}\u{116B}\u{11BF}"),
    ("\u{B415}", "\u{B415}", "\u{1103}\u{116B}\u{11C0}", "\u{B415}", "\u{1103}\u{116B}\u{11C0}"),
    ("\u{B416}", "\u{B416}", "\u{1103}\u{116B}\u{11C1}", "\u{B416}", "\u{1103}\u{116B}\u{11C1}"),
    ("\u{B417}", "\u{B417}", "\u{1103}\u{116B}\u{11C2}", "\u{B417}", "\u{1103}\u{116B}\u{11C2}"),
    ("\u{B418}", "\u{B418}", "\u{1103}\u{116C}", "\u{B418}", "\u{1103}\u{116C}"),
    ("\u{B419}", "\u{B419}", "\u{1103}\u{116C}\u{11A8}", "\u{B419}", "\u{1103}\u{116C}\u{11A8}"),
    ("\u{B41A}", "\u{B41A}", "\u{1103}\u{116C}\u{11A9}", "\u{B41A}", "\u{1103}\u{116C}\u{11A9}"),
    ("\u{B41B}", "\u{B41B}", "\u{1103}\u{116C}\u{11AA}", "\u{B41B}", "\u{1103}\u{116C}\u{11AA}"),
    ("\u{B41C}", "\u{B41C}", "\u{1103}\u{116C}\u{11AB}", "\u{B41C}", "\u{1103}\u{116C}\u{11AB}"),
    ("\u{B41D}", "\u{B41D}", "\u{1103}\u{116C}\u{11AC}", "\u{B41D}", "\u{1103}\u{116C}\u{11AC}"),
    ("\u{B41E}", "\u{B41E}", "\u{1103}\u{116C}\u{11AD}", "\u{B41E}", "\u{1103}\u{116C}\u{11AD}"),
    ("\u{B41F}", "\u{B41F}", "\u{1103}\u{116C}\u{11AE}", "\u{B41F}", "\u{1103}\u{116C}\u{11AE}"),
    ("\u{B420}", "\u{B420}", "\u{1103}\u{116C}\u{11AF}", "\u{B420}", "\u{1103}\u{116C}\u{11AF}"),
    ("\u{B421}", "\u{B421}", "\u{1103}\u{116C}\u{11B0}", "\u{B421}", "\u{1103}\u{116C}\u{11B0}"),
    ("\u{B422}", "\u{B422}", "\u{1103}\u{116C}\u{11B1}", "\u{B422}", "\u{1103}\u{116C}\u{11B1}"),
    ("\u{B423}", "\u{B423}", "\u{1103}\u{116C}\u{11B2}", "\u{B423}", "\u{1103}\u{116C}\u{11B2}"),
    ("\u{B424}", "\u{B424}", "\u{1103}\u{116C}\u{11B3}", "\u{B424}", "\u{1103}\u{116C}\u{11B3}"),
    ("\u{B425}", "\u{B425}", "\u{1103}\u{116C}\u{11B4}", "\u{B425}", "\u{1103}\u{116C}\u{11B4}"),
    ("\u{B426}", "\u{B426}", "\u{1103}\u{116C}\u{11B5}", "\u{B426}", "\u{1103}\u{116C}\u{11B5}"),
    ("\u{B427}", "\u{B427}", "\u{1103}\u{116C}\u{11B6}", "\u{B427}", "\u{1103}\u{116C}\u{11B6}"),
    ("\u{B428}", "\u{B428}", "\u{1103}\u{116C}\u{11B7}", "\u{B428}", "\u{1103}\u{116C}\u{11B7}"),
    ("\u{B429}", "\u{B429}", "\u{1103}\u{116C}\u{11B8}", "\u{B429}", "\u{1103}\u{116C}\u{11B8}"),
    ("\u{B42A}", "\u{B42A}", "\u{1103}\u{116C}\u{11B9}", "\u{B42A}", "\u{1103}\u{116C}\u{11B9}"),
    ("\u{B42B}", "\u{B42B}", "\u{1103}\u{116C}\u{11BA}", "\u{B42B}", "\u{1103}\u{116C}\u{11BA}"),
    ("\u{B42C}", "\u{B42C}", "\u{1103}\u{116C}\u{11BB}", "\u{B42C}", "\u{1103}\u{116C}\u{11BB}"),
    ("\u{B42D}", "\u{B42D}", "\u{1103}\u{116C}\u{11BC}", "\u{B42D}", "\u{1103}\u{116C}\u{11BC}"),
    ("\u{B42E}", "\u{B42E}", "\u{1103}\u{116C}\u{11BD}", "\u{B42E}", "\u{1103}\u{116C}\u{11BD}"),
    ("\u{B42F}", "\u{B42F}", "\u{1103}\u{116C}\u{11BE}", "\u{B42F}", "\u{1103}\u{116C}\u{11BE}"),
    ("\u{B430}", "\u{B430}", "\u{1103}\u{116C}\u{11BF}", "\u{B430}", "\u{1103}\u{116C}\u{11BF}"),
    ("\u{B431}", "\u{B431}", "\u{1103}\u{116C}\u{11C0}", "\u{B431}", "\u{1103}\u{116C}\u{11C0}"),
    ("\u{B432}", "\u{B432}", "\u{1103}\u{116C}\u{11C1}", "\u{B432}", "\u{1103}\u{116C}\u{11C1}"),
    ("\u{B433}", "\u{B433}", "\u{1103}\u{116C}\u{11C2}", "\u{B433}", "\u{1103}\u{116C}\u{11C2}"),
    ("\u{B434}", "\u{B434}", "\u{1103}\u{116D}", "\u{B434}", "\u{1103}\u{116D}"),
    ("\u{B435}", "\u{B435}", "\u{1103}\u{116D}\u{11A8}", "\u{B435}", "\u{1103}\u{116D}\u{11A8}"),
    ("\u{B436}", "\u{B436}", "\u{1103}\u{116D}\u{11A9}", "\u{B436}", "\u{1103}\u{116D}\u{11A9}"),
    ("\u{B437}", "\u{B437}", "\u{1103}\u{116D}\u{11AA}", "\u{B437}", "\u{1103}\u{116D}\u{11AA}"),
    ("\u{B438}", "\u{B438}", "\u{1103}\u{116D}\u{11AB}", "\u{B438}", "\u{1103}\u{116D}\u{11AB}"),
    ("\u{B439}", "\u{B439}", "\u{1103}\u{116D}\u{11AC}", "\u{B439}", "\u{1103}\u{116D}\u{11AC}"),
    ("\u{B43A}", "\u{B43A}", "\u{1103}\u{116D}\u{11AD}", "\u{B43A}", "\u{1103}\u{116D}\u{11AD}"),
    ("\u{B43B}", "\u{B43B}", "\u{1103}\u{116D}\u{11AE}", "\u{B43B}", "\u{1103}\u{116D}\u{11AE}"),
    ("\u{B43C}", "\u{B43C}", "\u{1103}\u{116D}\u{11AF}", "\u{B43C}", "\u{1103}\u{116D}\u{11AF}"),
    ("\u{B43D}", "\u{B43D}", "\u{1103}\u{116D}\u{11B0}", "\u{B43D}", "\u{1103}\u{116D}\u{11B0}"),
    ("\u{B43E}", "\u{B43E}", "\u{1103}\u{116D}\u{11B1}", "\u{B43E}", "\u{1103}\u{116D}\u{11B1}"),
    ("\u{B43F}", "\u{B43F}", "\u{1103}\u{116D}\u{11B2}", "\u{B43F}", "\u{1103}\u{116D}\u{11B2}"),
    ("\u{B440}", "\u{B440}", "\u{1103}\u{116D}\u{11B3}", "\u{B440}", "\u{1103}\u{116D}\u{11B3}"),
    ("\u{B441}", "\u{B441}", "\u{1103}\u{116D}\u{11B4}", "\u{B441}", "\u{1103}\u{116D}\u{11B4}"),
    ("\u{B442}", "\u{B442}", "\u{1103}\u{116D}\u{11B5}", "\u{B442}", "\u{1103}\u{116D}\u{11B5}"),
    ("\u{B443}", "\u{B443}", "\u{1103}\u{116D}\u{11B6}", "\u{B443}", "\u{1103}\u{116D}\u{11B6}"),
    ("\u{B444}", "\u{B444}", "\u{1103}\u{116D}\u{11B7}", "\u{B444}", "\u{1103}\u{116D}\u{11B7}"),
    ("\u{B445}", "\u{B445}", "\u{1103}\u{116D}\u{11B8}", "\u{B445}", "\u{1103}\u{116D}\u{11B8}"),
    ("\u{B446}", "\u{B446}", "\u{1103}\u{116D}\u{11B9}", "\u{B446}", "\u{1103}\u{116D}\u{11B9}"),
    ("\u{B447}", "\u{B447}", "\u{1103}\u{116D}\u{11BA}", "\u{B447}", "\u{1103}\u{116D}\u{11BA}"),
    ("\u{B448}", "\u{B448}", "\u{1103}\u{116D}\u{11BB}", "\u{B448}", "\u{1103}\u{116D}\u{11BB}"),
    ("\u{B449}", "\u{B449}", "\u{1103}\u{116D}\u{11BC}", "\u{B449}", "\u{1103}\u{116D}\u{11BC}"),
    ("\u{B44A}", "\u{B44A}", "\u{1103}\u{116D}\u{11BD}", "\u{B44A}", "\u{1103}\u{116D}\u{11BD}"),
    ("\u{B44B}", "\u{B44B}", "\u{1103}\u{116D}\u{11BE}", "\u{B44B}", "\u{1103}\u{116D}\u{11BE}"),
    ("\u{B44C}", "\u{B44C}", "\u{1103}\u{116D}\u{11BF}", "\u{B44C}", "\u{1103}\u{116D}\u{11BF}"),
    ("\u{B44D}", "\u{B44D}", "\u{1103}\u{116D}\u{11C0}", "\u{B44D}", "\u{1103}\u{116D}\u{11C0}"),
    ("\u{B44E}", "\u{B44E}", "\u{1103}\u{116D}\u{11C1}", "\u{B44E}", "\u{1103}\u{116D}\u{11C1}"),
    ("\u{B44F}", "\u{B44F}", "\u{1103}\u{116D}\u{11C2}", "\u{B44F}", "\u{1103}\u{116D}\u{11C2}"),
    ("\u{B450}", "\u{B450}", "\u{1103}\u{116E}", "\u{B450}", "\u{1103}\u{116E}"),
    ("\u{B451}", "\u{B451}", "\u{1103}\u{116E}\u{11A8}", "\u{B451}", "\u{1103}\u{116E}\u{11A8}"),
    ("\u{B452}", "\u{B452}", "\u{1103}\u{116E}\u{11A9}", "\u{B452}", "\u{1103}\u{116E}\u{11A9}"),
    ("\u{B453}", "\u{B453}", "\u{1103}\u{116E}\u{11AA}", "\u{B453}", "\u{1103}\u{116E}\u{11AA}"),
    ("\u{B454}", "\u{B454}", "\u{1103}\u{116E}\u{11AB}", "\u{B454}", "\u{1103}\u{116E}\u{11AB}"),
    ("\u{B455}", "\u{B455}", "\u{1103}\u{116E}\u{11AC}", "\u{B455}", "\u{1103}\u{116E}\u{11AC}"),
    ("\u{B456}", "\u{B456}", "\u{1103}\u{116E}\u{11AD}", "\u{B456}", "\u{1103}\u{116E}\u{11AD}"),
    ("\u{B457}", "\u{B457}", "\u{1103}\u{116E}\u{11AE}", "\u{B457}", "\u{1103}\u{116E}\u{11AE}"),
    ("\u{B458}", "\u{B458}", "\u{1103}\u{116E}\u{11AF}", "\u{B458}", "\u{1103}\u{116E}\u{11AF}"),
    ("\u{B459}", "\u{B459}", "\u{1103}\u{116E}\u{11B0}", "\u{B459}", "\u{1103}\u{116E}\u{11B0}"),
    ("\u{B45A}", "\u{B45A}", "\u{1103}\u{116E}\u{11B1}", "\u{B45A}", "\u{1103}\u{116E}\u{11B1}"),
    ("\u{B45B}", "\u{B45B}", "\u{1103}\u{116E}\u{11B2}", "\u{B45B}", "\u{1103}\u{116E}\u{11B2}"),
    ("\u{B45C}", "\u{B45C}", "\u{1103}\u{116E}\u{11B3}", "\u{B45C}", "\u{1103}\u{116E}\u{11B3}"),
    ("\u{B45D}", "\u{B45D}", "\u{1103}\u{116E}\u{11B4}", "\u{B45D}", "\u{1103}\u{116E}\u{11B4}"),
    ("\u{B45E}", "\u{B45E}", "\u{1103}\u{116E}\u{11B5}", "\u{B45E}", "\u{1103}\u{116E}\u{11B5}"),
    ("\u{B45F}", "\u{B45F}", "\u{1103}\u{116E}\u{11B6}", "\u{B45F}", "\u{1103}\u{116E}\u{11B6}"),
    ("\u{B460}", "\u{B460}", "\u{1103}\u{116E}\u{11B7}", "\u{B460}", "\u{1103}\u{116E}\u{11B7}"),
    ("\u{B461}", "\u{B461}", "\u{1103}\u{116E}\u{11B8}", "\u{B461}", "\u{1103}\u{116E}\u{11B8}"),
    ("\u{B462}", "\u{B462}", "\u{1103}\u{116E}\u{11B9}", "\u{B462}", "\u{1103}\u{116E}\u{11B9}"),
    ("\u{B463}", "\u{B463}", "\u{1103}\u{116E}\u{11BA}", "\u{B463}", "\u{1103}\u{116E}\u{11BA}"),
    ("\u{B464}", "\u{B464}", "\u{1103}\u{116E}\u{11BB}", "\u{B464}", "\u{1103}\u{116E}\u{11BB}"),
    ("\u{B465}", "\u{B465}", "\u{1103}\u{116E}\u{11BC}", "\u{B465}", "\u{1103}\u{116E}\u{11BC}"),
    ("\u{B466}", "\u{B466}", "\u{1103}\u{116E}\u{11BD}", "\u{B466}", "\u{1103}\u{116E}\u{11BD}"),
    ("\u{B467}", "\u{B467}", "\u{1103}\u{116E}\u{11BE}", "\u{B467}", "\u{1103}\u{116E}\u{11BE}"),
    ("\u{B468}", "\u{B468}", "\u{1103}\u{116E}\u{11BF}", "\u{B468}", "\u{1103}\u{116E}\u{11BF}"),
    ("\u{B469}", "\u{B469}", "\u{1103}\u{116E}\u{11C0}", "\u{B469}", "\u{1103}\u{116E}\u{11C0}"),
    ("\u{B46A}", "\u{B46A}", "\u{1103}\u{116E}\u{11C1}", "\u{B46A}", "\u{1103}\u{116E}\u{11C1}"),
    ("\u{B46B}", "\u{B46B}", "\u{1103}\u{116E}\u{11C2}", "\u{B46B}", "\u{1103}\u{116E}\u{11C2}"),
    ("\u{B46C}", "\u{B46C}", "\u{1103}\u{116F}", "\u{B46C}", "\u{1103}\u{116F}"),
    ("\u{B46D}", "\u{B46D}", "\u{1103}\u{116F}\u{11A8}", "\u{B46D}", "\u{1103}\u{116F}\u{11A8}"),
    ("\u{B46E}", "\u{B46E}", "\u{1103}\u{116F}\u{11A9}", "\u{B46E}", "\u{1103}\u{116F}\u{11A9}"),
    ("\u{B46F}", "\u{B46F}", "\u{1103}\u{116F}\u{11AA}", "\u{B46F}", "\u{1103}\u{116F}\u{11AA}"),
    ("\u{B470}", "\u{B470}", "\u{1103}\u{116F}\u{11AB}", "\u{B470}", "\u{1103}\u{116F}\u{11AB}"),
    ("\u{B471}", "\u{B471}", "\u{1103}\u{116F}\u{11AC}", "\u{B471}", "\u{1103}\u{116F}\u{11AC}"),
    ("\u{B472}", "\u{B472}", "\u{1103}\u{116F}\u{11AD}", "\u{B472}", "\u{1103}\u{116F}\u{11AD}"),
    ("\u{B473}", "\u{B473}", "\u{1103}\u{116F}\u{11AE}", "\u{B473}", "\u{1103}\u{116F}\u{11AE}"),
    ("\u{B474}", "\u{B474}", "\u{1103}\u{116F}\u{11AF}", "\u{B474}", "\u{1103}\u{116F}\u{11AF}"),
    ("\u{B475}", "\u{B475}", "\u{1103}\u{116F}\u{11B0}", "\u{B475}", "\u{1103}\u{116F}\u{11B0}"),
    ("\u{B476}", "\u{B476}", "\u{1103}\u{116F}\u{11B1}", "\u{B476}", "\u{1103}\u{116F}\u{11B1}"),
    ("\u{B477}", "\u{B477}", "\u{1103}\u{116F}\u{11B2}", "\u{B477}", "\u{1103}\u{116F}\u{11B2}"),
    ("\u{B478}", "\u{B478}", "\u{1103}\u{116F}\u{11B3}", "\u{B478}", "\u{1103}\u{116F}\u{11B3}"),
    ("\u{B479}", "\u{B479}", "\u{1103}\u{116F}\u{11B4}", "\u{B479}", "\u{1103}\u{116F}\u{11B4}"),
    ("\u{B47A}", "\u{B47A}", "\u{1103}\u{116F}\u{11B5}", "\u{B47A}", "\u{1103}\u{116F}\u{11B5}"),
    ("\u{B47B}", "\u{B47B}", "\u{1103}\u{116F}\u{11B6}", "\u{B47B}", "\u{1103}\u{116F}\u{11B6}"),
    ("\u{B47C}", "\u{B47C}", "\u{1103}\u{116F}\u{11B7}", "\u{B47C}", "\u{1103}\u{116F}\u{11B7}"),
    ("\u{B47D}", "\u{B47D}", "\u{1103}\u{116F}\u{11B8}", "\u{B47D}", "\u{1103}\u{116F}\u{11B8}"),
    ("\u{B47E}", "\u{B47E}", "\u{1103}\u{116F}\u{11B9}", "\u{B47E}", "\u{1103}\u{116F}\u{11B9}"),
    ("\u{B47F}", "\u{B47F}", "\u{1103}\u{116F}\u{11BA}", "\u{B47F}", "\u{1103}\u{116F}\u{11BA}"),
    ("\u{B480}", "\u{B480}", "\u{1103}\u{116F}\u{11BB}", "\u{B480}", "\u{1103}\u{116F}\u{11BB}"),
    ("\u{B481}", "\u{B481}", "\u{1103}\u{116F}\u{11BC}", "\u{B481}", "\u{1103}\u{116F}\u{11BC}"),
    ("\u{B482}", "\u{B482}", "\u{1103}\u{116F}\u{11BD}", "\u{B482}", "\u{1103}\u{116F}\u{11BD}"),
    ("\u{B483}", "\u{B483}", "\u{1103}\u{116F}\u{11BE}", "\u{B483}", "\u{1103}\u{116F}\u{11BE}"),
    ("\u{B484}", "\u{B484}", "\u{1103}\u{116F}\u{11BF}", "\u{B484}", "\u{1103}\u{116F}\u{11BF}"),
    ("\u{B485}", "\u{B485}", "\u{1103}\u{116F}\u{11C0}", "\u{B485}", "\u{1103}\u{116F}\u{11C0}"),
    ("\u{B486}", "\u{B486}", "\u{1103}\u{116F}\u{11C1}", "\u{B486}", "\u{1103}\u{116F}\u{11C1}"),
    ("\u{B487}", "\u{B487}", "\u{1103}\u{116F}\u{11C2}", "\u{B487}", "\u{1103}\u{116F}\u{11C2}"),
    ("\u{B488}", "\u{B488}", "\u{1103}\u{1170}", "\u{B488}", "\u{1103}\u{1170}"),
    ("\u{B489}", "\u{B489}", "\u{1103}\u{1170}\u{11A8}", "\u{B489}", "\u{1103}\u{1170}\u{11A8}"),
    ("\u{B48A}", "\u{B48A}", "\u{1103}\u{1170}\u{11A9}", "\u{B48A}", "\u{1103}\u{1170}\u{11A9}"),
    ("\u{B48B}", "\u{B48B}", "\u{1103}\u{1170}\u{11AA}", "\u{B48B}", "\u{1103}\u{1170}\u{11AA}"),
    ("\u{B48C}", "\u{B48C}", "\u{1103}\u{1170}\u{11AB}", "\u{B48C}", "\u{1103}\u{1170}\u{11AB}"),
    ("\u{B48D}", "\u{B48D}", "\u{1103}\u{1170}\u{11AC}", "\u{B48D}", "\u{1103}\u{1170}\u{11AC}"),
    ("\u{B48E}", "\u{B48E}", "\u{1103}\u{1170}\u{11AD}", "\u{B48E}", "\u{1103}\u{1170}\u{11AD}"),
    ("\u{B48F}", "\u{B48F}", "\u{1103}\u{1170}\u{11AE}", "\u{B48F}", "\u{1103}\u{1170}\u{11AE}"),
    ("\u{B490}", "\u{B490}", "\u{1103}\u{1170}\u{11AF}", "\u{B490}", "\u{1103}\u{1170}\u{11AF}"),
    ("\u{B491}", "\u{B491}", "\u{1103}\u{1170}\u{11B0}", "\u{B491}", "\u{1103}\u{1170}\u{11B0}"),
    ("\u{B492}", "\u{B492}", "\u{1103}\u{1170}\u{11B1}", "\u{B492}", "\u{1103}\u{1170}\u{11B1}"),
    ("\u{B493}", "\u{B493}", "\u{1103}\u{1170}\u{11B2}", "\u{B493}", "\u{1103}\u{1170}\u{11B2}"),
    ("\u{B494}", "\u{B494}", "\u{1103}\u{1170}\u{11B3}", "\u{B494}", "\u{1103}\u{1170}\u{11B3}"),
    ("\u{B495}", "\u{B495}", "\u{1103}\u{1170}\u{11B4}", "\u{B495}", "\u{1103}\u{1170}\u{11B4}"),
    ("\u{B496}", "\u{B496}", "\u{1103}\u{1170}\u{11B5}", "\u{B496}", "\u{1103}\u{1170}\u{11B5}"),
    ("\u{B497}", "\u{B497}", "\u{1103}\u{1170}\u{11B6}", "\u{B497}", "\u{1103}\u{1170}\u{11B6}"),
    ("\u{B498}", "\u{B498}", "\u{1103}\u{1170}\u{11B7}", "\u{B498}", "\u{1103}\u{1170}\u{11B7}"),
    ("\u{B499}", "\u{B499}", "\u{1103}\u{1170}\u{11B8}", "\u{B499}", "\u{1103}\u{1170}\u{11B8}"),
    ("\u{B49A}", "\u{B49A}", "\u{1103}\u{1170}\u{11B9}", "\u{B49A}", "\u{1103}\u{1170}\u{11B9}"),
    ("\u{B49B}", "\u{B49B}", "\u{1103}\u{1170}\u{11BA}", "\u{B49B}", "\u{1103}\u{1170}\u{11BA}"),
    ("\u{B49C}", "\u{B49C}", "\u{1103}\u{1170}\u{11BB}", "\u{B49C}", "\u{1103}\u{1170}\u{11BB}"),
    ("\u{B49D}", "\u{B49D}", "\u{1103}\u{1170}\u{11BC}", "\u{B49D}", "\u{1103}\u{1170}\u{11BC}"),
    ("\u{B49E}", "\u{B49E}", "\u{1103}\u{1170}\u{11BD}", "\u{B49E}", "\u{1103}\u{1170}\u{11BD}"),
    ("\u{B49F}", "\u{B49F}", "\u{1103}\u{1170}\u{11BE}", "\u{B49F}", "\u{1103}\u{1170}\u{11BE}"),
    ("\u{B4A0}", "\u{B4A0}", "\u{1103}\u{1170}\u{11BF}", "\u{B4A0}", "\u{1103}\u{1170}\u{11BF}"),
    ("\u{B4A1}", "\u{B4A1}", "\u{1103}\u{1170}\u{11C0}", "\u{B4A1}", "\u{1103}\u{1170}\u{11C0}"),
    ("\u{B4A2}", "\u{B4A2}", "\u{1103}\u{1170}\u{11C1}", "\u{B4A2}", "\u{1103}\u{1170}\u{11C1}"),
    ("\u{B4A3}", "\u{B4A3}", "\u{1103}\u{1170}\u{11C2}", "\u{B4A3}", "\u{1103}\u{1170}\u{11C2}"),
    ("\u{B4A4}", "\u{B4A4}", "\u{1103}\u{1171}", "\u{B4A4}", "\u{1103}\u{1171}"),
    ("\u{B4A5}", "\u{B4A5}", "\u{1103}\u{1171}\u{11A8}", "\u{B4A5}", "\u{1103}\u{1171}\u{11A8}"),
    ("\u{B4A6}", "\u{B4A6}", "\u{1103}\u{1171}\u{11A9}", "\u{B4A6}", "\u{1103}\u{1171}\u{11A9}"),
    ("\u{B4A7}", "\u{B4A7}", "\u{1103}\u{1171}\u{11AA}", "\u{B4A7}", "\u{1103}\u{1171}\u{11AA}"),
    ("\u{B4A8}", "\u{B4A8}", "\u{1103}\u{1171}\u{11AB}", "\u{B4A8}", "\u{1103}\u{1171}\u{11AB}"),
    ("\u{B4A9}", "\u{B4A9}", "\u{1103}\u{1171}\u{11AC}", "\u{B4A9}", "\u{1103}\u{1171}\u{11AC}"),
    ("\u{B4AA}", "\u{B4AA}", "\u{1103}\u{1171}\u{11AD}", "\u{B4AA}", "\u{1103}\u{1171}\u{11AD}"),
    ("\u{B4AB}", "\u{B4AB}", "\u{1103}\u{1171}\u{11AE}", "\u{B4AB}", "\u{1103}\u{1171}\u{11AE}"),
    ("\u{B4AC}", "\u{B4AC}", "\u{1103}\u{1171}\u{11AF}", "\u{B4AC}", "\u{1103}\u{1171}\u{11AF}"),
    ("\u{B4AD}", "\u{B4AD}", "\u{1103}\u{1171}\u{11B0}", "\u{B4AD}", "\u{1103}\u{1171}\u{11B0}"),
    ("\u{B4AE}", "\u{B4AE}", "\u{1103}\u{1171}\u{11B1}", "\u{B4AE}", "\u{1103}\u{1171}\u{11B1}"),
    ("\u{B4AF}", "\u{B4AF}", "\u{1103}\u{1171}\u{11B2}", "\u{B4AF}", "\u{1103}\u{1171}\u{11B2}"),
    ("\u{B4B0}", "\u{B4B0}", "\u{1103}\u{1171}\u{11B3}", "\u{B4B0}", "\u{1103}\u{1171}\u{11B3}"),
    ("\u{B4B1}", "\u{B4B1}", "\u{1103}\u{1171}\u{11B4}", "\u{B4B1}", "\u{1103}\u{1171}\u{11B4}"),
    ("\u{B4B2}", "\u{B4B2}", "\u{1103}\u{1171}\u{11B5}", "\u{B4B2}", "\u{1103}\u{1171}\u{11B5}"),
    ("\u{B4B3}", "\u{B4B3}", "\u{1103}\u{1171}\u{11B6}", "\u{B4B3}", "\u{1103}\u{1171}\u{11B6}"),
    ("\u{B4B4}", "\u{B4B4}", "\u{1103}\u{1171}\u{11B7}", "\u{B4B4}", "\u{1103}\u{1171}\u{11B7}"),
    ("\u{B4B5}", "\u{B4B5}", "\u{1103}\u{1171}\u{11B8}", "\u{B4B5}", "\u{1103}\u{1171}\u{11B8}"),
    ("\u{B4B6}", "\u{B4B6}", "\u{1103}\u{1171}\u{11B9}", "\u{B4B6}", "\u{1103}\u{1171}\u{11B9}"),
    ("\u{B4B7}", "\u{B4B7}", "\u{1103}\u{1171}\u{11BA}", "\u{B4B7}", "\u{1103}\u{1171}\u{11BA}"),
    ("\u{B4B8}", "\u{B4B8}", "\u{1103}\u{1171}\u{11BB}", "\u{B4B8}", "\u{1103}\u{1171}\u{11BB}"),
    ("\u{B4B9}", "\u{B4B9}", "\u{1103}\u{1171}\u{11BC}", "\u{B4B9}", "\u{1103}\u{1171}\u{11BC}"),
    ("\u{B4BA}", "\u{B4BA}", "\u{1103}\u{1171}\u{11BD}", "\u{B4BA}", "\u{1103}\u{1171}\u{11BD}"),
    ("\u{B4BB}", "\u{B4BB}", "\u{1103}\u{1171}\u{11BE}", "\u{B4BB}", "\u{1103}\u{1171}\u{11BE}"),
    ("\u{B4BC}", "\u{B4BC}", "\u{1103}\u{1171}\u{11BF}", "\u{B4BC}", "\u{1103}\u{1171}\u{11BF}"),
    ("\u{B4BD}", "\u{B4BD}", "\u{1103}\u{1171}\u{11C0}", "\u{B4BD}", "\u{1103}\u{1171}\u{11C0}"),
    ("\u{B4BE}", "\u{B4BE}", "\u{1103}\u{1171}\u{11C1}", "\u{B4BE}", "\u{1103}\u{1171}\u{11C1}"),
    ("\u{B4BF}", "\u{B4BF}", "\u{1103}\u{1171}\u{11C2}", "\u{B4BF}", "\u{1103}\u{1171}\u{11C2}"),
    ("\u{B4C0}", "\u{B4C0}", "\u{1103}\u{1172}", "\u{B4C0}", "\u{1103}\u{1172}"),
    ("\u{B4C1}", "\u{B4C1}", "\u{1103}\u{1172}\u{11A8}", "\u{B4C1}", "\u{1103}\u{1172}\u{11A8}"),
    ("\u{B4C2}", "\u{B4C2}", "\u{1103}\u{1172}\u{11A9}", "\u{B4C2}", "\u{1103}\u{1172}\u{11A9}"),
    ("\u{B4C3}", "\u{B4C3}", "\u{1103}\u{1172}\u{11AA}", "\u{B4C3}", "\u{1103}\u{1172}\u{11AA}"),
    ("\u{B4C4}", "\u{B4C4}", "\u{1103}\u{1172}\u{11AB}", "\u{B4C4}", "\u{1103}\u{1172}\u{11AB}"),
    ("\u{B4C5}", "\u{B4C5}", "\u{1103}\u{1172}\u{11AC}", "\u{B4C5}", "\u{1103}\u{1172}\u{11AC}"),
    ("\u{B4C6}", "\u{B4C6}", "\u{1103}\u{1172}\u{11AD}", "\u{B4C6}", "\u{1103}\u{1172}\u{11AD}"),
    ("\u{B4C7}", "\u{B4C7}", "\u{1103}\u{1172}\u{11AE}", "\u{B4C7}", "\u{1103}\u{1172}\u{11AE}"),
    ("\u{B4C8}", "\u{B4C8}", "\u{1103}\u{1172}\u{11AF}", "\u{B4C8}", "\u{1103}\u{1172}\u{11AF}"),
    ("\u{B4C9}", "\u{B4C9}", "\u{1103}\u{1172}\u{11B0}", "\u{B4C9}", "\u{1103}\u{1172}\u{11B0}"),
    ("\u{B4CA}", "\u{B4CA}", "\u{1103}\u{1172}\u{11B1}", "\u{B4CA}", "\u{1103}\u{1172}\u{11B1}"),
    ("\u{B4CB}", "\u{B4CB}", "\u{1103}\u{1172}\u{11B2}", "\u{B4CB}", "\u{1103}\u{1172}\u{11B2}"),
    ("\u{B4CC}", "\u{B4CC}", "\u{1103}\u{1172}\u{11B3}", "\u{B4CC}", "\u{1103}\u{1172}\u{11B3}"),
    ("\u{B4CD}", "\u{B4CD}", "\u{1103}\u{1172}\u{11B4}", "\u{B4CD}", "\u{1103}\u{1172}\u{11B4}"),
    ("\u{B4CE}", "\u{B4CE}", "\u{1103}\u{1172}\u{11B5}", "\u{B4CE}", "\u{1103}\u{1172}\u{11B5}"),
    ("\u{B4CF}", "\u{B4CF}", "\u{1103}\u{1172}\u{11B6}", "\u{B4CF}", "\u{1103}\u{1172}\u{11B6}"),
    ("\u{B4D0}", "\u{B4D0}", "\u{1103}\u{1172}\u{11B7}", "\u{B4D0}", "\u{1103}\u{1172}\u{11B7}"),
    ("\u{B4D1}", "\u{B4D1}", "\u{1103}\u{1172}\u{11B8}", "\u{B4D1}", "\u{1103}\u{1172}\u{11B8}"),
    ("\u{B4D2}", "\u{B4D2}", "\u{1103}\u{1172}\u{11B9}", "\u{B4D2}", "\u{1103}\u{1172}\u{11B9}"),
    ("\u{B4D3}", "\u{B4D3}", "\u{1103}\u{1172}\u{11BA}", "\u{B4D3}", "\u{1103}\u{1172}\u{11BA}"),
    ("\u{B4D4}", "\u{B4D4}", "\u{1103}\u{1172}\u{11BB}", "\u{B4D4}", "\u{1103}\u{1172}\u{11BB}"),
    ("\u{B4D5}", "\u{B4D5}", "\u{1103}\u{1172}\u{11BC}", "\u{B4D5}", "\u{1103}\u{1172}\u{11BC}"),
    ("\u{B4D6}", "\u{B4D6}", "\u{1103}\u{1172}\u{11BD}", "\u{B4D6}", "\u{1103}\u{1172}\u{11BD}"),
    ("\u{B4D7}", "\u{B4D7}", "\u{1103}\u{1172}\u{11BE}", "\u{B4D7}", "\u{1103}\u{1172}\u{11BE}"),
    ("\u{B4D8}", "\u{B4D8}", "\u{1103}\u{1172}\u{11BF}", "\u{B4D8}", "\u{1103}\u{1172}\u{11BF}"),
    ("\u{B4D9}", "\u{B4D9}", "\u{1103}\u{1172}\u{11C0}", "\u{B4D9}", "\u{1103}\u{1172}\u{11C0}"),
    ("\u{B4DA}", "\u{B4DA}", "\u{1103}\u{1172}\u{11C1}", "\u{B4DA}", "\u{1103}\u{1172}\u{11C1}"),
    ("\u{B4DB}", "\u{B4DB}", "\u{1103}\u{1172}\u{11C2}", "\u{B4DB}", "\u{1103}\u{1172}\u{11C2}"),
    ("\u{B4DC}", "\u{B4DC}", "\u{1103}\u{1173}", "\u{B4DC}", "\u{1103}\u{1173}"),
    ("\u{B4DD}", "\u{B4DD}", "\u{1103}\u{1173}\u{11A8}", "\u{B4DD}", "\u{1103}\u{1173}\u{11A8}"),
    ("\u{B4DE}", "\u{B4DE}", "\u{1103}\u{1173}\u{11A9}", "\u{B4DE}", "\u{1103}\u{1173}\u{11A9}"),
    ("\u{B4DF}", "\u{B4DF}", "\u{1103}\u{1173}\u{11AA}", "\u{B4DF}", "\u{1103}\u{1173}\u{11AA}"),
    ("\u{B4E0}", "\u{B4E0}", "\u{1103}\u{1173}\u{11AB}", "\u{B4E0}", "\u{1103}\u{1173}\u{11AB}"),
    ("\u{B4E1}", "\u{B4E1}", "\u{1103}\u{1173}\u{11AC}", "\u{B4E1}", "\u{1103}\u{1173}\u{11AC}"),
    ("\u{B4E2}", "\u{B4E2}", "\u{1103}\u{1173}\u{11AD}", "\u{B4E2}", "\u{1103}\u{1173}\u{11AD}"),
    ("\u{B4E3}", "\u{B4E3}", "\u{1103}\u{1173}\u{11AE}", "\u{B4E3}", "\u{1103}\u{1173}\u{11AE}"),
    ("\u{B4E4}", "\u{B4E4}", "\u{1103}\u{1173}\u{11AF}", "\u{B4E4}", "\u{1103}\u{1173}\u{11AF}"),
    ("\u{B4E5}", "\u{B4E5}", "\u{1103}\u{1173}\u{11B0}", "\u{B4E5}", "\u{1103}\u{1173}\u{11B0}"),
    ("\u{B4E6}", "\u{B4E6}", "\u{1103}\u{1173}\u{11B1}", "\u{B4E6}", "\u{1103}\u{1173}\u{11B1}"),
    ("\u{B4E7}", "\u{B4E7}", "\u{1103}\u{1173}\u{11B2}", "\u{B4E7}", "\u{1103}\u{1173}\u{11B2}"),
    ("\u{B4E8}", "\u{B4E8}", "\u{1103}\u{1173}\u{11B3}", "\u{B4E8}", "\u{1103}\u{1173}\u{11B3}"),
    ("\u{B4E9}", "\u{B4E9}", "\u{1103}\u{1173}\u{11B4}", "\u{B4E9}", "\u{1103}\u{1173}\u{11B4}"),
    ("\u{B4EA}", "\u{B4EA}", "\u{1103}\u{1173}\u{11B5}", "\u{B4EA}", "\u{1103}\u{1173}\u{11B5}"),
    ("\u{B4EB}", "\u{B4EB}", "\u{1103}\u{1173}\u{11B6}", "\u{B4EB}", "\u{1103}\u{1173}\u{11B6}"),
    ("\u{B4EC}", "\u{B4EC}", "\u{1103}\u{1173}\u{11B7}", "\u{B4EC}", "\u{1103}\u{1173}\u{11B7}"),
    ("\u{B4ED}", "\u{B4ED}", "\u{1103}\u{1173}\u{11B8}", "\u{B4ED}", "\u{1103}\u{1173}\u{11B8}"),
    ("\u{B4EE}", "\u{B4EE}", "\u{1103}\u{1173}\u{11B9}", "\u{B4EE}", "\u{1103}\u{1173}\u{11B9}"),
    ("\u{B4EF}", "\u{B4EF}", "\u{1103}\u{1173}\u{11BA}", "\u{B4EF}", "\u{1103}\u{1173}\u{11BA}"),
    ("\u{B4F0}", "\u{B4F0}", "\u{1103}\u{1173}\u{11BB}", "\u{B4F0}", "\u{1103}\u{1173}\u{11BB}"),
    ("\u{B4F1}", "\u{B4F1}", "\u{1103}\u{1173}\u{11BC}", "\u{B4F1}", "\u{1103}\u{1173}\u{11BC}"),
    ("\u{B4F2}", "\u{B4F2}", "\u{1103}\u{1173}\u{11BD}", "\u{B4F2}", "\u{1103}\u{1173}\u{11BD}"),
    ("\u{B4F3}", "\u{B4F3}", "\u{1103}\u{1173}\u{11BE}", "\u{B4F3}", "\u{1103}\u{1173}\u{11BE}"),
    ("\u{B4F4}", "\u{B4F4}", "\u{1103}\u{1173}\u{11BF}", "\u{B4F4}", "\u{1103}\u{1173}\u{11BF}"),
    ("\u{B4F5}", "\u{B4F5}", "\u{1103}\u{1173}\u{11C0}", "\u{B4F5}", "\u{1103}\u{1173}\u{11C0}"),
    ("\u{B4F6}", "\u{B4F6}", "\u{1103}\u{1173}\u{11C1}", "\u{B4F6}", "\u{1103}\u{1173}\u{11C1}"),
    ("\u{B4F7}", "\u{B4F7}", "\u{1103}\u{1173}\u{11C2}", "\u{B4F7}", "\u{1103}\u{1173}\u{11C2}"),
    ("\u{B4F8}", "\u{B4F8}", "\u{1103}\u{1174}", "\u{B4F8}", "\u{1103}\u{1174}"),
    ("\u{B4F9}", "\u{B4F9}", "\u{1103}\u{1174}\u{11A8}", "\u{B4F9}", "\u{1103}\u{1174}\u{11A8}"),
    ("\u{B4FA}", "\u{B4FA}", "\u{1103}\u{1174}\u{11A9}", "\u{B4FA}", "\u{1103}\u{1174}\u{11A9}"),
    ("\u{B4FB}", "\u{B4FB}", "\u{1103}\u{1174}\u{11AA}", "\u{B4FB}", "\u{1103}\u{1174}\u{11AA}"),
    ("\u{B4FC}", "\u{B4FC}", "\u{1103}\u{1174}\u{11AB}", "\u{B4FC}", "\u{1103}\u{1174}\u{11AB}"),
    ("\u{B4FD}", "\u{B4FD}", "\u{1103}\u{1174}\u{11AC}", "\u{B4FD}", "\u{1103}\u{1174}\u{11AC}"),
    ("\u{B4FE}", "\u{B4FE}", "\u{1103}\u{1174}\u{11AD}", "\u{B4FE}", "\u{1103}\u{1174}\u{11AD}"),
    ("\u{B4FF}", "\u{B4FF}", "\u{1103}\u{1174}\u{11AE}", "\u{B4FF}", "\u{1103}\u{1174}\u{11AE}"),
    ("\u{B500}", "\u{B500}", "\u{1103}\u{1174}\u{11AF}", "\u{B500}", "\u{1103}\u{1174}\u{11AF}"),
    ("\u{B501}", "\u{B501}", "\u{1103}\u{1174}\u{11B0}", "\u{B501}", "\u{1103}\u{1174}\u{11B0}"),
    ("\u{B502}", "\u{B502}", "\u{1103}\u{1174}\u{11B1}", "\u{B502}", "\u{1103}\u{1174}\u{11B1}"),
    ("\u{B503}", "\u{B503}", "\u{1103}\u{1174}\u{11B2}", "\u{B503}", "\u{1103}\u{1174}\u{11B2}"),
    ("\u{B504}", "\u{B504}", "\u{1103}\u{1174}\u{11B3}", "\u{B504}", "\u{1103}\u{1174}\u{11B3}"),
    ("\u{B505}", "\u{B505}", "\u{1103}\u{1174}\u{11B4}", "\u{B505}", "\u{1103}\u{1174}\u{11B4}"),
    ("\u{B506}", "\u{B506}", "\u{1103}\u{1174}\u{11B5}", "\u{B506}", "\u{1103}\u{1174}\u{11B5}"),
    ("\u{B507}", "\u{B507}", "\u{1103}\u{1174}\u{11B6}", "\u{B507}", "\u{1103}\u{1174}\u{11B6}"),
    ("\u{B508}", "\u{B508}", "\u{1103}\u{1174}\u{11B7}", "\u{B508}", "\u{1103}\u{1174}\u{11B7}"),
    ("\u{B509}", "\u{B509}", "\u{1103}\u{1174}\u{11B8}", "\u{B509}", "\u{1103}\u{1174}\u{11B8}"),
    ("\u{B50A}", "\u{B50A}", "\u{1103}\u{1174}\u{11B9}", "\u{B50A}", "\u{1103}\u{1174}\u{11B9}"),
    ("\u{B50B}", "\u{B50B}", "\u{1103}\u{1174}\u{11BA}", "\u{B50B}", "\u{1103}\u{1174}\u{11BA}"),
    ("\u{B50C}", "\u{B50C}", "\u{1103}\u{1174}\u{11BB}", "\u{B50C}", "\u{1103}\u{1174}\u{11BB}"),
    ("\u{B50D}", "\u{B50D}", "\u{1103}\u{1174}\u{11BC}", "\u{B50D}", "\u{1103}\u{1174}\u{11BC}"),
    ("\u{B50E}", "\u{B50E}", "\u{1103}\u{1174}\u{11BD}", "\u{B50E}", "\u{1103}\u{1174}\u{11BD}"),
    ("\u{B50F}", "\u{B50F}", "\u{1103}\u{1174}\u{11BE}", "\u{B50F}", "\u{1103}\u{1174}\u{11BE}"),
    ("\u{B510}", "\u{B510}", "\u{1103}\u{1174}\u{11BF}", "\u{B510}", "\u{1103}\u{1174}\u{11BF}"),
    ("\u{B511}", "\u{B511}", "\u{1103}\u{1174}\u{11C0}", "\u{B511}", "\u{1103}\u{1174}\u{11C0}"),
    ("\u{B512}", "\u{B512}", "\u{1103}\u{1174}\u{11C1}", "\u{B512}", "\u{1103}\u{1174}\u{11C1}"),
    ("\u{B513}", "\u{B513}", "\u{1103}\u{1174}\u{11C2}", "\u{B513}", "\u{1103}\u{1174}\u{11C2}"),
    ("\u{B514}", "\u{B514}", "\u{1103}\u{1175}", "\u{B514}", "\u{1103}\u{1175}"),
    ("\u{B515}", "\u{B515}", "\u{1103}\u{1175}\u{11A8}", "\u{B515}", "\u{1103}\u{1175}\u{11A8}"),
    ("\u{B516}", "\u{B516}", "\u{1103}\u{1175}\u{11A9}", "\u{B516}", "\u{1103}\u{1175}\u{11A9}"),
    ("\u{B517}", "\u{B517}", "\u{1103}\u{1175}\u{11AA}", "\u{B517}", "\u{1103}\u{1175}\u{11AA}"),
    ("\u{B518}", "\u{B518}", "\u{1103}\u{1175}\u{11AB}", "\u{B518}", "\u{1103}\u{1175}\u{11AB}"),
    ("\u{B519}", "\u{B519}", "\u{1103}\u{1175}\u{11AC}", "\u{B519}", "\u{1103}\u{1175}\u{11AC}"),
    ("\u{B51A}", "\u{B51A}", "\u{1103}\u{1175}\u{11AD}", "\u{B51A}", "\u{1103}\u{1175}\u{11AD}"),
    ("\u{B51B}", "\u{B51B}", "\u{1103}\u{1175}\u{11AE}", "\u{B51B}", "\u{1103}\u{1175}\u{11AE}"),
    ("\u{B51C}", "\u{B51C}", "\u{1103}\u{1175}\u{11AF}", "\u{B51C}", "\u{1103}\u{1175}\u{11AF}"),
    ("\u{B51D}", "\u{B51D}", "\u{1103}\u{1175}\u{11B0}", "\u{B51D}", "\u{1103}\u{1175}\u{11B0}"),
    ("\u{B51E}", "\u{B51E}", "\u{1103}\u{1175}\u{11B1}", "\u{B51E}", "\u{1103}\u{1175}\u{11B1}"),
    ("\u{B51F}", "\u{B51F}", "\u{1103}\u{1175}\u{11B2}", "\u{B51F}", "\u{1103}\u{1175}\u{11B2}"),
    ("\u{B520}", "\u{B520}", "\u{1103}\u{1175}\u{11B3}", "\u{B520}", "\u{1103}\u{1175}\u{11B3}"),
    ("\u{B521}", "\u{B521}", "\u{1103}\u{1175}\u{11B4}", "\u{B521}", "\u{1103}\u{1175}\u{11B4}"),
    ("\u{B522}", "\u{B522}", "\u{1103}\u{1175}\u{11B5}", "\u{B522}", "\u{1103}\u{1175}\u{11B5}"),
    ("\u{B523}", "\u{B523}", "\u{1103}\u{1175}\u{11B6}", "\u{B523}", "\u{1103}\u{1175}\u{11B6}"),
    ("\u{B524}", "\u{B524}", "\u{1103}\u{1175}\u{11B7}", "\u{B524}", "\u{1103}\u{1175}\u{11B7}"),
    ("\u{B525}", "\u{B525}", "\u{1103}\u{1175}\u{11B8}", "\u{B525}", "\u{1103}\u{1175}\u{11B8}"),
    ("\u{B526}", "\u{B526}", "\u{1103}\u{1175}\u{11B9}", "\u{B526}", "\u{1103}\u{1175}\u{11B9}"),
    ("\u{B527}", "\u{B527}", "\u{1103}\u{1175}\u{11BA}", "\u{B527}", "\u{1103}\u{1175}\u{11BA}"),
    ("\u{B528}", "\u{B528}", "\u{1103}\u{1175}\u{11BB}", "\u{B528}", "\u{1103}\u{1175}\u{11BB}"),
    ("\u{B529}", "\u{B529}", "\u{1103}\u{1175}\u{11BC}", "\u{B529}", "\u{1103}\u{1175}\u{11BC}"),
    ("\u{B52A}", "\u{B52A}", "\u{1103}\u{1175}\u{11BD}", "\u{B52A}", "\u{1103}\u{1175}\u{11BD}"),
    ("\u{B52B}", "\u{B52B}", "\u{1103}\u{1175}\u{11BE}", "\u{B52B}", "\u{1103}\u{1175}\u{11BE}"),
    ("\u{B52C}", "\u{B52C}", "\u{1103}\u{1175}\u{11BF}", "\u{B52C}", "\u{1103}\u{1175}\u{11BF}"),
    ("\u{B52D}", "\u{B52D}", "\u{1103}\u{1175}\u{11C0}", "\u{B52D}", "\u{1103}\u{1175}\u{11C0}"),
    ("\u{B52E}", "\u{B52E}", "\u{1103}\u{1175}\u{11C1}", "\u{B52E}", "\u{1103}\u{1175}\u{11C1}"),
    ("\u{B52F}", "\u{B52F}", "\u{1103}\u{1175}\u{11C2}", "\u{B52F}", "\u{1103}\u{1175}\u{11C2}"),
    ("\u{B530}", "\u{B530}", "\u{1104}\u{1161}", "\u{B530}", "\u{1104}\u{1161}"),
    ("\u{B531}", "\u{B531}", "\u{1104}\u{1161}\u{11A8}", "\u{B531}", "\u{1104}\u{1161}\u{11A8}"),
    ("\u{B532}", "\u{B532}", "\u{1104}\u{1161}\u{11A9}", "\u{B532}", "\u{1104}\u{1161}\u{11A9}"),
    ("\u{B533}", "\u{B533}", "\u{1104}\u{1161}\u{11AA}", "\u{B533}", "\u{1104}\u{1161}\u{11AA}"),
    ("\u{B534}", "\u{B534}", "\u{1104}\u{1161}\u{11AB}", "\u{B534}", "\u{1104}\u{1161}\u{11AB}"),
    ("\u{B535}", "\u{B535}", "\u{1104}\u{1161}\u{11AC}", "\u{B535}", "\u{1104}\u{1161}\u{11AC}"),
    ("\u{B536}", "\u{B536}", "\u{1104}\u{1161}\u{11AD}", "\u{B536}", "\u{1104}\u{1161}\u{11AD}"),
    ("\u{B537}", "\u{B537}", "\u{1104}\u{1161}\u{11AE}", "\u{B537}", "\u{1104}\u{1161}\u{11AE}"),
    ("\u{B538}", "\u{B538}", "\u{1104}\u{1161}\u{11AF}", "\u{B538}", "\u{1104}\u{1161}\u{11AF}"),
    ("\u{B539}", "\u{B539}", "\u{1104}\u{1161}\u{11B0}", "\u{B539}", "\u{1104}\u{1161}\u{11B0}"),
    ("\u{B53A}", "\u{B53A}", "\u{1104}\u{1161}\u{11B1}", "\u{B53A}", "\u{1104}\u{1161}\u{11B1}"),
    ("\u{B53B}", "\u{B53B}", "\u{1104}\u{1161}\u{11B2}", "\u{B53B}", "\u{1104}\u{1161}\u{11B2}"),
    ("\u{B53C}", "\u{B53C}", "\u{1104}\u{1161}\u{11B3}", "\u{B53C}", "\u{1104}\u{1161}\u{11B3}"),
    ("\u{B53D}", "\u{B53D}", "\u{1104}\u{1161}\u{11B4}", "\u{B53D}", "\u{1104}\u{1161}\u{11B4}"),
    ("\u{B53E}", "\u{B53E}", "\u{1104}\u{1161}\u{11B5}", "\u{B53E}", "\u{1104}\u{1161}\u{11B5}"),
    ("\u{B53F}", "\u{B53F}", "\u{1104}\u{1161}\u{11B6}", "\u{B53F}", "\u{1104}\u{1161}\u{11B6}"),
    ("\u{B540}", "\u{B540}", "\u{1104}\u{1161}\u{11B7}", "\u{B540}", "\u{1104}\u{1161}\u{11B7}"),
    ("\u{B541}", "\u{B541}", "\u{1104}\u{1161}\u{11B8}", "\u{B541}", "\u{1104}\u{1161}\u{11B8}"),
    ("\u{B542}", "\u{B542}", "\u{1104}\u{1161}\u{11B9}", "\u{B542}", "\u{1104}\u{1161}\u{11B9}"),
    ("\u{B543}", "\u{B543}", "\u{1104}\u{1161}\u{11BA}", "\u{B543}", "\u{1104}\u{1161}\u{11BA}"),
    ("\u{B544}", "\u{B544}", "\u{1104}\u{1161}\u{11BB}", "\u{B544}", "\u{1104}\u{1161}\u{11BB}"),
    ("\u{B545}", "\u{B545}", "\u{1104}\u{1161}\u{11BC}", "\u{B545}", "\u{1104}\u{1161}\u{11BC}"),
    ("\u{B546}", "\u{B546}", "\u{1104}\u{1161}\u{11BD}", "\u{B546}", "\u{1104}\u{1161}\u{11BD}"),
    ("\u{B547}", "\u{B547}", "\u{1104}\u{1161}\u{11BE}", "\u{B547}", "\u{1104}\u{1161}\u{11BE}"),
    ("\u{B548}", "\u{B548}", "\u{1104}\u{1161}\u{11BF}", "\u{B548}", "\u{1104}\u{1161}\u{11BF}"),
    ("\u{B549}", "\u{B549}", "\u{1104}\u{1161}\u{11C0}", "\u{B549}", "\u{1104}\u{1161}\u{11C0}"),
    ("\u{B54A}", "\u{B54A}", "\u{1104}\u{1161}\u{11C1}", "\u{B54A}", "\u{1104}\u{1161}\u{11C1}"),
    ("\u{B54B}", "\u{B54B}", "\u{1104}\u{1161}\u{11C2}", "\u{B54B}", "\u{1104}\u{1161}\u{11C2}"),
    ("\u{B54C}", "\u{B54C}", "\u{1104}\u{1162}", "\u{B54C}", "\u{1104}\u{1162}"),
    ("\u{B54D}", "\u{B54D}", "\u{1104}\u{1162}\u{11A8}", "\u{B54D}", "\u{1104}\u{1162}\u{11A8}"),
    ("\u{B54E}", "\u{B54E}", "\u{1104}\u{1162}\u{11A9}", "\u{B54E}", "\u{1104}\u{1162}\u{11A9}"),
    ("\u{B54F}", "\u{B54F}", "\u{1104}\u{1162}\u{11AA}", "\u{B54F}", "\u{1104}\u{1162}\u{11AA}"),
    ("\u{B550}", "\u{B550}", "\u{1104}\u{1162}\u{11AB}", "\u{B550}", "\u{1104}\u{1162}\u{11AB}"),
    ("\u{B551}", "\u{B551}", "\u{1104}\u{1162}\u{11AC}", "\u{B551}", "\u{1104}\u{1162}\u{11AC}"),
    ("\u{B552}", "\u{B552}", "\u{1104}\u{1162}\u{11AD}", "\u{B552}", "\u{1104}\u{1162}\u{11AD}"),
    ("\u{B553}", "\u{B553}", "\u{1104}\u{1162}\u{11AE}", "\u{B553}", "\u{1104}\u{1162}\u{11AE}"),
    ("\u{B554}", "\u{B554}", "\u{1104}\u{1162}\u{11AF}", "\u{B554}", "\u{1104}\u{1162}\u{11AF}"),
    ("\u{B555}", "\u{B555}", "\u{1104}\u{1162}\u{11B0}", "\u{B555}", "\u{1104}\u{1162}\u{11B0}"),
    ("\u{B556}", "\u{B556}", "\u{1104}\u{1162}\u{11B1}", "\u{B556}", "\u{1104}\u{1162}\u{11B1}"),
    ("\u{B557}", "\u{B557}", "\u{1104}\u{1162}\u{11B2}", "\u{B557}", "\u{1104}\u{1162}\u{11B2}"),
    ("\u{B558}", "\u{B558}", "\u{1104}\u{1162}\u{11B3}", "\u{B558}", "\u{1104}\u{1162}\u{11B3}"),
    ("\u{B559}", "\u{B559}", "\u{1104}\u{1162}\u{11B4}", "\u{B559}", "\u{1104}\u{1162}\u{11B4}"),
    ("\u{B55A}", "\u{B55A}", "\u{1104}\u{1162}\u{11B5}", "\u{B55A}", "\u{1104}\u{1162}\u{11B5}"),
    ("\u{B55B}", "\u{B55B}", "\u{1104}\u{1162}\u{11B6}", "\u{B55B}", "\u{1104}\u{1162}\u{11B6}"),
    ("\u{B55C}", "\u{B55C}", "\u{1104}\u{1162}\u{11B7}", "\u{B55C}", "\u{1104}\u{1162}\u{11B7}"),
    ("\u{B55D}", "\u{B55D}", "\u{1104}\u{1162}\u{11B8}", "\u{B55D}", "\u{1104}\u{1162}\u{11B8}"),
    ("\u{B55E}", "\u{B55E}", "\u{1104}\u{1162}\u{11B9}", "\u{B55E}", "\u{1104}\u{1162}\u{11B9}"),
    ("\u{B55F}", "\u{B55F}", "\u{1104}\u{1162}\u{11BA}", "\u{B55F}", "\u{1104}\u{1162}\u{11BA}"),
    ("\u{B560}", "\u{B560}", "\u{1104}\u{1162}\u{11BB}", "\u{B560}", "\u{1104}\u{1162}\u{11BB}"),
    ("\u{B561}", "\u{B561}", "\u{1104}\u{1162}\u{11BC}", "\u{B561}", "\u{1104}\u{1162}\u{11BC}"),
    ("\u{B562}", "\u{B562}", "\u{1104}\u{1162}\u{11BD}", "\u{B562}", "\u{1104}\u{1162}\u{11BD}"),
    ("\u{B563}", "\u{B563}", "\u{1104}\u{1162}\u{11BE}", "\u{B563}", "\u{1104}\u{1162}\u{11BE}"),
    ("\u{B564}", "\u{B564}", "\u{1104}\u{1162}\u{11BF}", "\u{B564}", "\u{1104}\u{1162}\u{11BF}"),
    ("\u{B565}", "\u{B565}", "\u{1104}\u{1162}\u{11C0}", "\u{B565}", "\u{1104}\u{1162}\u{11C0}"),
    ("\u{B566}", "\u{B566}", "\u{1104}\u{1162}\u{11C1}", "\u{B566}", "\u{1104}\u{1162}\u{11C1}"),
    ("\u{B567}", "\u{B567}", "\u{1104}\u{1162}\u{11C2}", "\u{B567}", "\u{1104}\u{1162}\u{11C2}"),
    ("\u{B568}", "\u{B568}", "\u{1104}\u{1163}", "\u{B568}", "\u{1104}\u{1163}"),
    ("\u{B569}", "\u{B569}", "\u{1104}\u{1163}\u{11A8}", "\u{B569}", "\u{1104}\u{1163}\u{11A8}"),
    ("\u{B56A}", "\u{B56A}", "\u{1104}\u{1163}\u{11A9}", "\u{B56A}", "\u{1104}\u{1163}\u{11A9}"),
    ("\u{B56B}", "\u{B56B}", "\u{1104}\u{1163}\u{11AA}", "\u{B56B}", "\u{1104}\u{1163}\u{11AA}"),
    ("\u{B56C}", "\u{B56C}", "\u{1104}\u{1163}\u{11AB}", "\u{B56C}", "\u{1104}\u{1163}\u{11AB}"),
    ("\u{B56D}", "\u{B56D}", "\u{1104}\u{1163}\u{11AC}", "\u{B56D}", "\u{1104}\u{1163}\u{11AC}"),
    ("\u{B56E}", "\u{B56E}", "\u{1104}\u{1163}\u{11AD}", "\u{B56E}", "\u{1104}\u{1163}\u{11AD}"),
    ("\u{B56F}", "\u{B56F}", "\u{1104}\u{1163}\u{11AE}", "\u{B56F}", "\u{1104}\u{1163}\u{11AE}"),
    ("\u{B570}", "\u{B570}", "\u{1104}\u{1163}\u{11AF}", "\u{B570}", "\u{1104}\u{1163}\u{11AF}"),
    ("\u{B571}", "\u{B571}", "\u{1104}\u{1163}\u{11B0}", "\u{B571}", "\u{1104}\u{1163}\u{11B0}"),
    ("\u{B572}", "\u{B572}", "\u{1104}\u{1163}\u{11B1}", "\u{B572}", "\u{1104}\u{1163}\u{11B1}"),
    ("\u{B573}", "\u{B573}", "\u{1104}\u{1163}\u{11B2}", "\u{B573}", "\u{1104}\u{1163}\u{11B2}"),
    ("\u{B574}", "\u{B574}", "\u{1104}\u{1163}\u{11B3}", "\u{B574}", "\u{1104}\u{1163}\u{11B3}"),
    ("\u{B575}", "\u{B575}", "\u{1104}\u{1163}\u{11B4}", "\u{B575}", "\u{1104}\u{1163}\u{11B4}"),
    ("\u{B576}", "\u{B576}", "\u{1104}\u{1163}\u{11B5}", "\u{B576}", "\u{1104}\u{1163}\u{11B5}"),
    ("\u{B577}", "\u{B577}", "\u{1104}\u{1163}\u{11B6}", "\u{B577}", "\u{1104}\u{1163}\u{11B6}"),
    ("\u{B578}", "\u{B578}", "\u{1104}\u{1163}\u{11B7}", "\u{B578}", "\u{1104}\u{1163}\u{11B7}"),
    ("\u{B579}", "\u{B579}", "\u{1104}\u{1163}\u{11B8}", "\u{B579}", "\u{1104}\u{1163}\u{11B8}"),
    ("\u{B57A}", "\u{B57A}", "\u{1104}\u{1163}\u{11B9}", "\u{B57A}", "\u{1104}\u{1163}\u{11B9}"),
    ("\u{B57B}", "\u{B57B}", "\u{1104}\u{1163}\u{11BA}", "\u{B57B}", "\u{1104}\u{1163}\u{11BA}"),
    ("\u{B57C}", "\u{B57C}", "\u{1104}\u{1163}\u{11BB}", "\u{B57C}", "\u{1104}\u{1163}\u{11BB}"),
    ("\u{B57D}", "\u{B57D}", "\u{1104}\u{1163}\u{11BC}", "\u{B57D}", "\u{1104}\u{1163}\u{11BC}"),
    ("\u{B57E}", "\u{B57E}", "\u{1104}\u{1163}\u{11BD}", "\u{B57E}", "\u{1104}\u{1163}\u{11BD}"),
    ("\u{B57F}", "\u{B57F}", "\u{1104}\u{1163}\u{11BE}", "\u{B57F}", "\u{1104}\u{1163}\u{11BE}"),
    ("\u{B580}", "\u{B580}", "\u{1104}\u{1163}\u{11BF}", "\u{B580}", "\u{1104}\u{1163}\u{11BF}"),
    ("\u{B581}", "\u{B581}", "\u{1104}\u{1163}\u{11C0}", "\u{B581}", "\u{1104}\u{1163}\u{11C0}"),
    ("\u{B582}", "\u{B582}", "\u{1104}\u{1163}\u{11C1}", "\u{B582}", "\u{1104}\u{1163}\u{11C1}"),
    ("\u{B583}", "\u{B583}", "\u{1104}\u{1163}\u{11C2}", "\u{B583}", "\u{1104}\u{1163}\u{11C2}"),
    ("\u{B584}", "\u{B584}", "\u{1104}\u{1164}", "\u{B584}", "\u{1104}\u{1164}"),
    ("\u{B585}", "\u{B585}", "\u{1104}\u{1164}\u{11A8}", "\u{B585}", "\u{1104}\u{1164}\u{11A8}"),
    ("\u{B586}", "\u{B586}", "\u{1104}\u{1164}\u{11A9}", "\u{B586}", "\u{1104}\u{1164}\u{11A9}"),
    ("\u{B587}", "\u{B587}", "\u{1104}\u{1164}\u{11AA}", "\u{B587}", "\u{1104}\u{1164}\u{11AA}"),
    ("\u{B588}", "\u{B588}", "\u{1104}\u{1164}\u{11AB}", "\u{B588}", "\u{1104}\u{1164}\u{11AB}"),
    ("\u{B589}", "\u{B589}", "\u{1104}\u{1164}\u{11AC}", "\u{B589}", "\u{1104}\u{1164}\u{11AC}"),
    ("\u{B58A}", "\u{B58A}", "\u{1104}\u{1164}\u{11AD}", "\u{B58A}", "\u{1104}\u{1164}\u{11AD}"),
    ("\u{B58B}", "\u{B58B}", "\u{1104}\u{1164}\u{11AE}", "\u{B58B}", "\u{1104}\u{1164}\u{11AE}"),
    ("\u{B58C}", "\u{B58C}", "\u{1104}\u{1164}\u{11AF}", "\u{B58C}", "\u{1104}\u{1164}\u{11AF}"),
    ("\u{B58D}", "\u{B58D}", "\u{1104}\u{1164}\u{11B0}", "\u{B58D}", "\u{1104}\u{1164}\u{11B0}"),
    ("\u{B58E}", "\u{B58E}", "\u{1104}\u{1164}\u{11B1}", "\u{B58E}", "\u{1104}\u{1164}\u{11B1}"),
    ("\u{B58F}", "\u{B58F}", "\u{1104}\u{1164}\u{11B2}", "\u{B58F}", "\u{1104}\u{1164}\u{11B2}"),
    ("\u{B590}", "\u{B590}", "\u{1104}\u{1164}\u{11B3}", "\u{B590}", "\u{1104}\u{1164}\u{11B3}"),
    ("\u{B591}", "\u{B591}", "\u{1104}\u{1164}\u{11B4}", "\u{B591}", "\u{1104}\u{1164}\u{11B4}"),
    ("\u{B592}", "\u{B592}", "\u{1104}\u{1164}\u{11B5}", "\u{B592}", "\u{1104}\u{1164}\u{11B5}"),
    ("\u{B593}", "\u{B593}", "\u{1104}\u{1164}\u{11B6}", "\u{B593}", "\u{1104}\u{1164}\u{11B6}"),
    ("\u{B594}", "\u{B594}", "\u{1104}\u{1164}\u{11B7}", "\u{B594}", "\u{1104}\u{1164}\u{11B7}"),
    ("\u{B595}", "\u{B595}", "\u{1104}\u{1164}\u{11B8}", "\u{B595}", "\u{1104}\u{1164}\u{11B8}"),
    ("\u{B596}", "\u{B596}", "\u{1104}\u{1164}\u{11B9}", "\u{B596}", "\u{1104}\u{1164}\u{11B9}"),
    ("\u{B597}", "\u{B597}", "\u{1104}\u{1164}\u{11BA}", "\u{B597}", "\u{1104}\u{1164}\u{11BA}"),
    ("\u{B598}", "\u{B598}", "\u{1104}\u{1164}\u{11BB}", "\u{B598}", "\u{1104}\u{1164}\u{11BB}"),
    ("\u{B599}", "\u{B599}", "\u{1104}\u{1164}\u{11BC}", "\u{B599}", "\u{1104}\u{1164}\u{11BC}"),
    ("\u{B59A}", "\u{B59A}", "\u{1104}\u{1164}\u{11BD}", "\u{B59A}", "\u{1104}\u{1164}\u{11BD}"),
    ("\u{B59B}", "\u{B59B}", "\u{1104}\u{1164}\u{11BE}", "\u{B59B}", "\u{1104}\u{1164}\u{11BE}"),
    ("\u{B59C}", "\u{B59C}", "\u{1104}\u{1164}\u{11BF}", "\u{B59C}", "\u{1104}\u{1164}\u{11BF}"),
    ("\u{B59D}", "\u{B59D}", "\u{1104}\u{1164}\u{11C0}", "\u{B59D}", "\u{1104}\u{1164}\u{11C0}"),
    ("\u{B59E}", "\u{B59E}", "\u{1104}\u{1164}\u{11C1}", "\u{B59E}", "\u{1104}\u{1164}\u{11C1}"),
    ("\u{B59F}", "\u{B59F}", "\u{1104}\u{1164}\u{11C2}", "\u{B59F}", "\u{1104}\u{1164}\u{11C2}"),
    ("\u{B5A0}", "\u{B5A0}", "\u{1104}\u{1165}", "\u{B5A0}", "\u{1104}\u{1165}"),
    ("\u{B5A1}", "\u{B5A1}", "\u{1104}\u{1165}\u{11A8}", "\u{B5A1}", "\u{1104}\u{1165}\u{11A8}"),
    ("\u{B5A2}", "\u{B5A2}", "\u{1104}\u{1165}\u{11A9}", "\u{B5A2}", "\u{1104}\u{1165}\u{11A9}"),
    ("\u{B5A3}", "\u{B5A3}", "\u{1104}\u{1165}\u{11AA}", "\u{B5A3}", "\u{1104}\u{1165}\u{11AA}"),
    ("\u{B5A4}", "\u{B5A4}", "\u{1104}\u{1165}\u{11AB}", "\u{B5A4}", "\u{1104}\u{1165}\u{11AB}"),
    ("\u{B5A5}", "\u{B5A5}", "\u{1104}\u{1165}\u{11AC}", "\u{B5A5}", "\u{1104}\u{1165}\u{11AC}"),
    ("\u{B5A6}", "\u{B5A6}", "\u{1104}\u{1165}\u{11AD}", "\u{B5A6}", "\u{1104}\u{1165}\u{11AD}"),
    ("\u{B5A7}", "\u{B5A7}", "\u{1104}\u{1165}\u{11AE}", "\u{B5A7}", "\u{1104}\u{1165}\u{11AE}"),
    ("\u{B5A8}", "\u{B5A8}", "\u{1104}\u{1165}\u{11AF}", "\u{B5A8}", "\u{1104}\u{1165}\u{11AF}"),
    ("\u{B5A9}", "\u{B5A9}", "\u{1104}\u{1165}\u{11B0}", "\u{B5A9}", "\u{1104}\u{1165}\u{11B0}"),
    ("\u{B5AA}", "\u{B5AA}", "\u{1104}\u{1165}\u{11B1}", "\u{B5AA}", "\u{1104}\u{1165}\u{11B1}"),
    ("\u{B5AB}", "\u{B5AB}", "\u{1104}\u{1165}\u{11B2}", "\u{B5AB}", "\u{1104}\u{1165}\u{11B2}"),
    ("\u{B5AC}", "\u{B5AC}", "\u{1104}\u{1165}\u{11B3}", "\u{B5AC}", "\u{1104}\u{1165}\u{11B3}"),
    ("\u{B5AD}", "\u{B5AD}", "\u{1104}\u{1165}\u{11B4}", "\u{B5AD}", "\u{1104}\u{1165}\u{11B4}"),
    ("\u{B5AE}", "\u{B5AE}", "\u{1104}\u{1165}\u{11B5}", "\u{B5AE}", "\u{1104}\u{1165}\u{11B5}"),
    ("\u{B5AF}", "\u{B5AF}", "\u{1104}\u{1165}\u{11B6}", "\u{B5AF}", "\u{1104}\u{1165}\u{11B6}"),
    ("\u{B5B0}", "\u{B5B0}", "\u{1104}\u{1165}\u{11B7}", "\u{B5B0}", "\u{1104}\u{1165}\u{11B7}"),
    ("\u{B5B1}", "\u{B5B1}", "\u{1104}\u{1165}\u{11B8}", "\u{B5B1}", "\u{1104}\u{1165}\u{11B8}"),
    ("\u{B5B2}", "\u{B5B2}", "\u{1104}\u{1165}\u{11B9}", "\u{B5B2}", "\u{1104}\u{1165}\u{11B9}"),
    ("\u{B5B3}", "\u{B5B3}", "\u{1104}\u{1165}\u{11BA}", "\u{B5B3}", "\u{1104}\u{1165}\u{11BA}"),
    ("\u{B5B4}", "\u{B5B4}", "\u{1104}\u{1165}\u{11BB}", "\u{B5B4}", "\u{1104}\u{1165}\u{11BB}"),
    ("\u{B5B5}", "\u{B5B5}", "\u{1104}\u{1165}\u{11BC}", "\u{B5B5}", "\u{1104}\u{1165}\u{11BC}"),
    ("\u{B5B6}", "\u{B5B6}", "\u{1104}\u{1165}\u{11BD}", "\u{B5B6}", "\u{1104}\u{1165}\u{11BD}"),
    ("\u{B5B7}", "\u{B5B7}", "\u{1104}\u{1165}\u{11BE}", "\u{B5B7}", "\u{1104}\u{1165}\u{11BE}"),
    ("\u{B5B8}", "\u{B5B8}", "\u{1104}\u{1165}\u{11BF}", "\u{B5B8}", "\u{1104}\u{1165}\u{11BF}"),
    ("\u{B5B9}", "\u{B5B9}", "\u{1104}\u{1165}\u{11C0}", "\u{B5B9}", "\u{1104}\u{1165}\u{11C0}"),
    ("\u{B5BA}", "\u{B5BA}", "\u{1104}\u{1165}\u{11C1}", "\u{B5BA}", "\u{1104}\u{1165}\u{11C1}"),
    ("\u{B5BB}", "\u{B5BB}", "\u{1104}\u{1165}\u{11C2}", "\u{B5BB}", "\u{1104}\u{1165}\u{11C2}"),
    ("\u{B5BC}", "\u{B5BC}", "\u{1104}\u{1166}", "\u{B5BC}", "\u{1104}\u{1166}"),
    ("\u{B5BD}", "\u{B5BD}", "\u{1104}\u{1166}\u{11A8}", "\u{B5BD}", "\u{1104}\u{1166}\u{11A8}"),
    ("\u{B5BE}", "\u{B5BE}", "\u{1104}\u{1166}\u{11A9}", "\u{B5BE}", "\u{1104}\u{1166}\u{11A9}"),
    ("\u{B5BF}", "\u{B5BF}", "\u{1104}\u{1166}\u{11AA}", "\u{B5BF}", "\u{1104}\u{1166}\u{11AA}"),
    ("\u{B5C0}", "\u{B5C0}", "\u{1104}\u{1166}\u{11AB}", "\u{B5C0}", "\u{1104}\u{1166}\u{11AB}"),
    ("\u{B5C1}", "\u{B5C1}", "\u{1104}\u{1166}\u{11AC}", "\u{B5C1}", "\u{1104}\u{1166}\u{11AC}"),
    ("\u{B5C2}", "\u{B5C2}", "\u{1104}\u{1166}\u{11AD}", "\u{B5C2}", "\u{1104}\u{1166}\u{11AD}"),
    ("\u{B5C3}", "\u{B5C3}", "\u{1104}\u{1166}\u{11AE}", "\u{B5C3}", "\u{1104}\u{1166}\u{11AE}"),
    ("\u{B5C4}", "\u{B5C4}", "\u{1104}\u{1166}\u{11AF}", "\u{B5C4}", "\u{1104}\u{1166}\u{11AF}"),
    ("\u{B5C5}", "\u{B5C5}", "\u{1104}\u{1166}\u{11B0}", "\u{B5C5}", "\u{1104}\u{1166}\u{11B0}"),
    ("\u{B5C6}", "\u{B5C6}", "\u{1104}\u{1166}\u{11B1}", "\u{B5C6}", "\u{1104}\u{1166}\u{11B1}"),
    ("\u{B5C7}", "\u{B5C7}", "\u{1104}\u{1166}\u{11B2}", "\u{B5C7}", "\u{1104}\u{1166}\u{11B2}"),
    ("\u{B5C8}", "\u{B5C8}", "\u{1104}\u{1166}\u{11B3}", "\u{B5C8}", "\u{1104}\u{1166}\u{11B3}"),
    ("\u{B5C9}", "\u{B5C9}", "\u{1104}\u{1166}\u{11B4}", "\u{B5C9}", "\u{1104}\u{1166}\u{11B4}"),
    ("\u{B5CA}", "\u{B5CA}", "\u{1104}\u{1166}\u{11B5}", "\u{B5CA}", "\u{1104}\u{1166}\u{11B5}"),
    ("\u{B5CB}", "\u{B5CB}", "\u{1104}\u{1166}\u{11B6}", "\u{B5CB}", "\u{1104}\u{1166}\u{11B6}"),
    ("\u{B5CC}", "\u{B5CC}", "\u{1104}\u{1166}\u{11B7}", "\u{B5CC}", "\u{1104}\u{1166}\u{11B7}"),
    ("\u{B5CD}", "\u{B5CD}", "\u{1104}\u{1166}\u{11B8}", "\u{B5CD}", "\u{1104}\u{1166}\u{11B8}"),
    ("\u{B5CE}", "\u{B5CE}", "\u{1104}\u{1166}\u{11B9}", "\u{B5CE}", "\u{1104}\u{1166}\u{11B9}"),
    ("\u{B5CF}", "\u{B5CF}", "\u{1104}\u{1166}\u{11BA}", "\u{B5CF}", "\u{1104}\u{1166}\u{11BA}"),
    ("\u{B5D0}", "\u{B5D0}", "\u{1104}\u{1166}\u{11BB}", "\u{B5D0}", "\u{1104}\u{1166}\u{11BB}"),
    ("\u{B5D1}", "\u{B5D1}", "\u{1104}\u{1166}\u{11BC}", "\u{B5D1}", "\u{1104}\u{1166}\u{11BC}"),
    ("\u{B5D2}", "\u{B5D2}", "\u{1104}\u{1166}\u{11BD}", "\u{B5D2}", "\u{1104}\u{1166}\u{11BD}"),
    ("\u{B5D3}", "\u{B5D3}", "\u{1104}\u{1166}\u{11BE}", "\u{B5D3}", "\u{1104}\u{1166}\u{11BE}"),
    ("\u{B5D4}", "\u{B5D4}", "\u{1104}\u{1166}\u{11BF}", "\u{B5D4}", "\u{1104}\u{1166}\u{11BF}"),
    ("\u{B5D5}", "\u{B5D5}", "\u{1104}\u{1166}\u{11C0}", "\u{B5D5}", "\u{1104}\u{1166}\u{11C0}"),
    ("\u{B5D6}", "\u{B5D6}", "\u{1104}\u{1166}\u{11C1}", "\u{B5D6}", "\u{1104}\u{1166}\u{11C1}"),
    ("\u{B5D7}", "\u{B5D7}", "\u{1104}\u{1166}\u{11C2}", "\u{B5D7}", "\u{1104}\u{1166}\u{11C2}"),
    ("\u{B5D8}", "\u{B5D8}", "\u{1104}\u{1167}", "\u{B5D8}", "\u{1104}\u{1167}"),
    ("\u{B5D9}", "\u{B5D9}", "\u{1104}\u{1167}\u{11A8}", "\u{B5D9}", "\u{1104}\u{1167}\u{11A8}"),
    ("\u{B5DA}", "\u{B5DA}", "\u{1104}\u{1167}\u{11A9}", "\u{B5DA}", "\u{1104}\u{1167}\u{11A9}"),
    ("\u{B5DB}", "\u{B5DB}", "\u{1104}\u{1167}\u{11AA}", "\u{B5DB}", "\u{1104}\u{1167}\u{11AA}"),
    ("\u{B5DC}", "\u{B5DC}", "\u{1104}\u{1167}\u{11AB}", "\u{B5DC}", "\u{1104}\u{1167}\u{11AB}"),
    ("\u{B5DD}", "\u{B5DD}", "\u{1104}\u{1167}\u{11AC}", "\u{B5DD}", "\u{1104}\u{1167}\u{11AC}"),
    ("\u{B5DE}", "\u{B5DE}", "\u{1104}\u{1167}\u{11AD}", "\u{B5DE}", "\u{1104}\u{1167}\u{11AD}"),
    ("\u{B5DF}", "\u{B5DF}", "\u{1104}\u{1167}\u{11AE}", "\u{B5DF}", "\u{1104}\u{1167}\u{11AE}"),
    ("\u{B5E0}", "\u{B5E0}", "\u{1104}\u{1167}\u{11AF}", "\u{B5E0}", "\u{1104}\u{1167}\u{11AF}"),
    ("\u{B5E1}", "\u{B5E1}", "\u{1104}\u{1167}\u{11B0}", "\u{B5E1}", "\u{1104}\u{1167}\u{11B0}"),
    ("\u{B5E2}", "\u{B5E2}", "\u{1104}\u{1167}\u{11B1}", "\u{B5E2}", "\u{1104}\u{1167}\u{11B1}"),
    ("\u{B5E3}", "\u{B5E3}", "\u{1104}\u{1167}\u{11B2}", "\u{B5E3}", "\u{1104}\u{1167}\u{11B2}"),
    ("\u{B5E4}", "\u{B5E4}", "\u{1104}\u{1167}\u{11B3}", "\u{B5E4}", "\u{1104}\u{1167}\u{11B3}"),
    ("\u{B5E5}", "\u{B5E5}", "\u{1104}\u{1167}\u{11B4}", "\u{B5E5}", "\u{1104}\u{1167}\u{11B4}"),
    ("\u{B5E6}", "\u{B5E6}", "\u{1104}\u{1167}\u{11B5}", "\u{B5E6}", "\u{1104}\u{1167}\u{11B5}"),
    ("\u{B5E7}", "\u{B5E7}", "\u{1104}\u{1167}\u{11B6}", "\u{B5E7}", "\u{1104}\u{1167}\u{11B6}"),
    ("\u{B5E8}", "\u{B5E8}", "\u{1104}\u{1167}\u{11B7}", "\u{B5E8}", "\u{1104}\u{1167}\u{11B7}"),
    ("\u{B5E9}", "\u{B5E9}", "\u{1104}\u{1167}\u{11B8}", "\u{B5E9}", "\u{1104}\u{1167}\u{11B8}"),
    ("\u{B5EA}", "\u{B5EA}", "\u{1104}\u{1167}\u{11B9}", "\u{B5EA}", "\u{1104}\u{1167}\u{11B9}"),
    ("\u{B5EB}", "\u{B5EB}", "\u{1104}\u{1167}\u{11BA}", "\u{B5EB}", "\u{1104}\u{1167}\u{11BA}"),
    ("\u{B5EC}", "\u{B5EC}", "\u{1104}\u{1167}\u{11BB}", "\u{B5EC}", "\u{1104}\u{1167}\u{11BB}"),
    ("\u{B5ED}", "\u{B5ED}", "\u{1104}\u{1167}\u{11BC}", "\u{B5ED}", "\u{1104}\u{1167}\u{11BC}"),
    ("\u{B5EE}", "\u{B5EE}", "\u{1104}\u{1167}\u{11BD}", "\u{B5EE}", "\u{1104}\u{1167}\u{11BD}"),
    ("\u{B5EF}", "\u{B5EF}", "\u{1104}\u{1167}\u{11BE}", "\u{B5EF}", "\u{1104}\u{1167}\u{11BE}"),
    ("\u{B5F0}", "\u{B5F0}", "\u{1104}\u{1167}\u{11BF}", "\u{B5F0}", "\u{1104}\u{1167}\u{11BF}"),
    ("\u{B5F1}", "\u{B5F1}", "\u{1104}\u{1167}\u{11C0}", "\u{B5F1}", "\u{1104}\u{1167}\u{11C0}"),
    ("\u{B5F2}", "\u{B5F2}", "\u{1104}\u{1167}\u{11C1}", "\u{B5F2}", "\u{1104}\u{1167}\u{11C1}"),
    ("\u{B5F3}", "\u{B5F3}", "\u{1104}\u{1167}\u{11C2}", "\u{B5F3}", "\u{1104}\u{1167}\u{11C2}"),
    ("\u{B5F4}", "\u{B5F4}", "\u{1104}\u{1168}", "\u{B5F4}", "\u{1104}\u{1168}"),
    ("\u{B5F5}", "\u{B5F5}", "\u{1104}\u{1168}\u{11A8}", "\u{B5F5}", "\u{1104}\u{1168}\u{11A8}"),
    ("\u{B5F6}", "\u{B5F6}", "\u{1104}\u{1168}\u{11A9}", "\u{B5F6}", "\u{1104}\u{1168}\u{11A9}"),
    ("\u{B5F7}", "\u{B5F7}", "\u{1104}\u{1168}\u{11AA}", "\u{B5F7}", "\u{1104}\u{1168}\u{11AA}"),
    ("\u{B5F8}", "\u{B5F8}", "\u{1104}\u{1168}\u{11AB}", "\u{B5F8}", "\u{1104}\u{1168}\u{11AB}"),
    ("\u{B5F9}", "\u{B5F9}", "\u{1104}\u{1168}\u{11AC}", "\u{B5F9}", "\u{1104}\u{1168}\u{11AC}"),
    ("\u{B5FA}", "\u{B5FA}", "\u{1104}\u{1168}\u{11AD}", "\u{B5FA}", "\u{1104}\u{1168}\u{11AD}"),
    ("\u{B5FB}", "\u{B5FB}", "\u{1104}\u{1168}\u{11AE}", "\u{B5FB}", "\u{1104}\u{1168}\u{11AE}"),
    ("\u{B5FC}", "\u{B5FC}", "\u{1104}\u{1168}\u{11AF}", "\u{B5FC}", "\u{1104}\u{1168}\u{11AF}"),
    ("\u{B5FD}", "\u{B5FD}", "\u{1104}\u{1168}\u{11B0}", "\u{B5FD}", "\u{1104}\u{1168}\u{11B0}"),
    ("\u{B5FE}", "\u{B5FE}", "\u{1104}\u{1168}\u{11B1}", "\u{B5FE}", "\u{1104}\u{1168}\u{11B1}"),
    ("\u{B5FF}", "\u{B5FF}", "\u{1104}\u{1168}\u{11B2}", "\u{B5FF}", "\u{1104}\u{1168}\u{11B2}"),
    ("\u{B600}", "\u{B600}", "\u{1104}\u{1168}\u{11B3}", "\u{B600}", "\u{1104}\u{1168}\u{11B3}"),
    ("\u{B601}", "\u{B601}", "\u{1104}\u{1168}\u{11B4}", "\u{B601}", "\u{1104}\u{1168}\u{11B4}"),
    ("\u{B602}", "\u{B602}", "\u{1104}\u{1168}\u{11B5}", "\u{B602}", "\u{1104}\u{1168}\u{11B5}"),
    ("\u{B603}", "\u{B603}", "\u{1104}\u{1168}\u{11B6}", "\u{B603}", "\u{1104}\u{1168}\u{11B6}"),
    ("\u{B604}", "\u{B604}", "\u{1104}\u{1168}\u{11B7}", "\u{B604}", "\u{1104}\u{1168}\u{11B7}"),
    ("\u{B605}", "\u{B605}", "\u{1104}\u{1168}\u{11B8}", "\u{B605}", "\u{1104}\u{1168}\u{11B8}"),
    ("\u{B606}", "\u{B606}", "\u{1104}\u{1168}\u{11B9}", "\u{B606}", "\u{1104}\u{1168}\u{11B9}"),
    ("\u{B607}", "\u{B607}", "\u{1104}\u{1168}\u{11BA}", "\u{B607}", "\u{1104}\u{1168}\u{11BA}"),
    ("\u{B608}", "\u{B608}", "\u{1104}\u{1168}\u{11BB}", "\u{B608}", "\u{1104}\u{1168}\u{11BB}"),
    ("\u{B609}", "\u{B609}", "\u{1104}\u{1168}\u{11BC}", "\u{B609}", "\u{1104}\u{1168}\u{11BC}"),
    ("\u{B60A}", "\u{B60A}", "\u{1104}\u{1168}\u{11BD}", "\u{B60A}", "\u{1104}\u{1168}\u{11BD}"),
    ("\u{B60B}", "\u{B60B}", "\u{1104}\u{1168}\u{11BE}", "\u{B60B}", "\u{1104}\u{1168}\u{11BE}"),
    ("\u{B60C}", "\u{B60C}", "\u{1104}\u{1168}\u{11BF}", "\u{B60C}", "\u{1104}\u{1168}\u{11BF}"),
    ("\u{B60D}", "\u{B60D}", "\u{1104}\u{1168}\u{11C0}", "\u{B60D}", "\u{1104}\u{1168}\u{11C0}"),
    ("\u{B60E}", "\u{B60E}", "\u{1104}\u{1168}\u{11C1}", "\u{B60E}", "\u{1104}\u{1168}\u{11C1}"),
    ("\u{B60F}", "\u{B60F}", "\u{1104}\u{1168}\u{11C2}", "\u{B60F}", "\u{1104}\u{1168}\u{11C2}"),
    ("\u{B610}", "\u{B610}", "\u{1104}\u{1169}", "\u{B610}", "\u{1104}\u{1169}"),
    ("\u{B611}", "\u{B611}", "\u{1104}\u{1169}\u{11A8}", "\u{B611}", "\u{1104}\u{1169}\u{11A8}"),
    ("\u{B612}", "\u{B612}", "\u{1104}\u{1169}\u{11A9}", "\u{B612}", "\u{1104}\u{1169}\u{11A9}"),
    ("\u{B613}", "\u{B613}", "\u{1104}\u{1169}\u{11AA}", "\u{B613}", "\u{1104}\u{1169}\u{11AA}"),
    ("\u{B614}", "\u{B614}", "\u{1104}\u{1169}\u{11AB}", "\u{B614}", "\u{1104}\u{1169}\u{11AB}"),
    ("\u{B615}", "\u{B615}", "\u{1104}\u{1169}\u{11AC}", "\u{B615}", "\u{1104}\u{1169}\u{11AC}"),
    ("\u{B616}", "\u{B616}", "\u{1104}\u{1169}\u{11AD}", "\u{B616}", "\u{1104}\u{1169}\u{11AD}"),
    ("\u{B617}", "\u{B617}", "\u{1104}\u{1169}\u{11AE}", "\u{B617}", "\u{1104}\u{1169}\u{11AE}"),
    ("\u{B618}", "\u{B618}", "\u{1104}\u{1169}\u{11AF}", "\u{B618}", "\u{1104}\u{1169}\u{11AF}"),
    ("\u{B619}", "\u{B619}", "\u{1104}\u{1169}\u{11B0}", "\u{B619}", "\u{1104}\u{1169}\u{11B0}"),
    ("\u{B61A}", "\u{B61A}", "\u{1104}\u{1169}\u{11B1}", "\u{B61A}", "\u{1104}\u{1169}\u{11B1}"),
    ("\u{B61B}", "\u{B61B}", "\u{1104}\u{1169}\u{11B2}", "\u{B61B}", "\u{1104}\u{1169}\u{11B2}"),
    ("\u{B61C}", "\u{B61C}", "\u{1104}\u{1169}\u{11B3}", "\u{B61C}", "\u{1104}\u{1169}\u{11B3}"),
    ("\u{B61D}", "\u{B61D}", "\u{1104}\u{1169}\u{11B4}", "\u{B61D}", "\u{1104}\u{1169}\u{11B4}"),
    ("\u{B61E}", "\u{B61E}", "\u{1104}\u{1169}\u{11B5}", "\u{B61E}", "\u{1104}\u{1169}\u{11B5}"),
    ("\u{B61F}", "\u{B61F}", "\u{1104}\u{1169}\u{11B6}", "\u{B61F}", "\u{1104}\u{1169}\u{11B6}"),
    ("\u{B620}", "\u{B620}", "\u{1104}\u{1169}\u{11B7}", "\u{B620}", "\u{1104}\u{1169}\u{11B7}"),
    ("\u{B621}", "\u{B621}", "\u{1104}\u{1169}\u{11B8}", "\u{B621}", "\u{1104}\u{1169}\u{11B8}"),
    ("\u{B622}", "\u{B622}", "\u{1104}\u{1169}\u{11B9}", "\u{B622}", "\u{1104}\u{1169}\u{11B9}"),
    ("\u{B623}", "\u{B623}", "\u{1104}\u{1169}\u{11BA}", "\u{B623}", "\u{1104}\u{1169}\u{11BA}"),
    ("\u{B624}", "\u{B624}", "\u{1104}\u{1169}\u{11BB}", "\u{B624}", "\u{1104}\u{1169}\u{11BB}"),
    ("\u{B625}", "\u{B625}", "\u{1104}\u{1169}\u{11BC}", "\u{B625}", "\u{1104}\u{1169}\u{11BC}"),
    ("\u{B626}", "\u{B626}", "\u{1104}\u{1169}\u{11BD}", "\u{B626}", "\u{1104}\u{1169}\u{11BD}"),
    ("\u{B627}", "\u{B627}", "\u{1104}\u{1169}\u{11BE}", "\u{B627}", "\u{1104}\u{1169}\u{11BE}"),
    ("\u{B628}", "\u{B628}", "\u{1104}\u{1169}\u{11BF}", "\u{B628}", "\u{1104}\u{1169}\u{11BF}"),
    ("\u{B629}", "\u{B629}", "\u{1104}\u{1169}\u{11C0}", "\u{B629}", "\u{1104}\u{1169}\u{11C0}"),
    ("\u{B62A}", "\u{B62A}", "\u{1104}\u{1169}\u{11C1}", "\u{B62A}", "\u{1104}\u{1169}\u{11C1}"),
    ("\u{B62B}", "\u{B62B}", "\u{1104}\u{1169}\u{11C2}", "\u{B62B}", "\u{1104}\u{1169}\u{11C2}"),
    ("\u{B62C}", "\u{B62C}", "\u{1104}\u{116A}", "\u{B62C}", "\u{1104}\u{116A}"),
    ("\u{B62D}", "\u{B62D}", "\u{1104}\u{116A}\u{11A8}", "\u{B62D}", "\u{1104}\u{116A}\u{11A8}"),
    ("\u{B62E}", "\u{B62E}", "\u{1104}\u{116A}\u{11A9}", "\u{B62E}", "\u{1104}\u{116A}\u{11A9}"),
    ("\u{B62F}", "\u{B62F}", "\u{1104}\u{116A}\u{11AA}", "\u{B62F}", "\u{1104}\u{116A}\u{11AA}"),
    ("\u{B630}", "\u{B630}", "\u{1104}\u{116A}\u{11AB}", "\u{B630}", "\u{1104}\u{116A}\u{11AB}"),
    ("\u{B631}", "\u{B631}", "\u{1104}\u{116A}\u{11AC}", "\u{B631}", "\u{1104}\u{116A}\u{11AC}"),
    ("\u{B632}", "\u{B632}", "\u{1104}\u{116A}\u{11AD}", "\u{B632}", "\u{1104}\u{116A}\u{11AD}"),
    ("\u{B633}", "\u{B633}", "\u{1104}\u{116A}\u{11AE}", "\u{B633}", "\u{1104}\u{116A}\u{11AE}"),
    ("\u{B634}", "\u{B634}", "\u{1104}\u{116A}\u{11AF}", "\u{B634}", "\u{1104}\u{116A}\u{11AF}"),
    ("\u{B635}", "\u{B635}", "\u{1104}\u{116A}\u{11B0}", "\u{B635}", "\u{1104}\u{116A}\u{11B0}"),
    ("\u{B636}", "\u{B636}", "\u{1104}\u{116A}\u{11B1}", "\u{B636}", "\u{1104}\u{116A}\u{11B1}"),
    ("\u{B637}", "\u{B637}", "\u{1104}\u{116A}\u{11B2}", "\u{B637}", "\u{1104}\u{116A}\u{11B2}"),
    ("\u{B638}", "\u{B638}", "\u{1104}\u{116A}\u{11B3}", "\u{B638}", "\u{1104}\u{116A}\u{11B3}"),
    ("\u{B639}", "\u{B639}", "\u{1104}\u{116A}\u{11B4}", "\u{B639}", "\u{1104}\u{116A}\u{11B4}"),
    ("\u{B63A}", "\u{B63A}", "\u{1104}\u{116A}\u{11B5}", "\u{B63A}", "\u{1104}\u{116A}\u{11B5}"),
    ("\u{B63B}", "\u{B63B}", "\u{1104}\u{116A}\u{11B6}", "\u{B63B}", "\u{1104}\u{116A}\u{11B6}"),
    ("\u{B63C}", "\u{B63C}", "\u{1104}\u{116A}\u{11B7}", "\u{B63C}", "\u{1104}\u{116A}\u{11B7}"),
    ("\u{B63D}", "\u{B63D}", "\u{1104}\u{116A}\u{11B8}", "\u{B63D}", "\u{1104}\u{116A}\u{11B8}"),
    ("\u{B63E}", "\u{B63E}", "\u{1104}\u{116A}\u{11B9}", "\u{B63E}", "\u{1104}\u{116A}\u{11B9}"),
    ("\u{B63F}", "\u{B63F}", "\u{1104}\u{116A}\u{11BA}", "\u{B63F}", "\u{1104}\u{116A}\u{11BA}"),
    ("\u{B640}", "\u{B640}", "\u{1104}\u{116A}\u{11BB}", "\u{B640}", "\u{1104}\u{116A}\u{11BB}"),
    ("\u{B641}", "\u{B641}", "\u{1104}\u{116A}\u{11BC}", "\u{B641}", "\u{1104}\u{116A}\u{11BC}"),
    ("\u{B642}", "\u{B642}", "\u{1104}\u{116A}\u{11BD}", "\u{B642}", "\u{1104}\u{116A}\u{11BD}"),
    ("\u{B643}", "\u{B643}", "\u{1104}\u{116A}\u{11BE}", "\u{B643}", "\u{1104}\u{116A}\u{11BE}"),
    ("\u{B644}", "\u{B644}", "\u{1104}\u{116A}\u{11BF}", "\u{B644}", "\u{1104}\u{116A}\u{11BF}"),
    ("\u{B645}", "\u{B645}", "\u{1104}\u{116A}\u{11C0}", "\u{B645}", "\u{1104}\u{116A}\u{11C0}"),
    ("\u{B646}", "\u{B646}", "\u{1104}\u{116A}\u{11C1}", "\u{B646}", "\u{1104}\u{116A}\u{11C1}"),
    ("\u{B647}", "\u{B647}", "\u{1104}\u{116A}\u{11C2}", "\u{B647}", "\u{1104}\u{116A}\u{11C2}"),
    ("\u{B648}", "\u{B648}", "\u{1104}\u{116B}", "\u{B648}", "\u{1104}\u{116B}"),
    ("\u{B649}", "\u{B649}", "\u{1104}\u{116B}\u{11A8}", "\u{B649}", "\u{1104}\u{116B}\u{11A8}"),
    ("\u{B64A}", "\u{B64A}", "\u{1104}\u{116B}\u{11A9}", "\u{B64A}", "\u{1104}\u{116B}\u{11A9}"),
    ("\u{B64B}", "\u{B64B}", "\u{1104}\u{116B}\u{11AA}", "\u{B64B}", "\u{1104}\u{116B}\u{11AA}"),
    ("\u{B64C}", "\u{B64C}", "\u{1104}\u{116B}\u{11AB}", "\u{B64C}", "\u{1104}\u{116B}\u{11AB}"),
    ("\u{B64D}", "\u{B64D}", "\u{1104}\u{116B}\u{11AC}", "\u{B64D}", "\u{1104}\u{116B}\u{11AC}"),
    ("\u{B64E}", "\u{B64E}", "\u{1104}\u{116B}\u{11AD}", "\u{B64E}", "\u{1104}\u{116B}\u{11AD}"),
    ("\u{B64F}", "\u{B64F}", "\u{1104}\u{116B}\u{11AE}", "\u{B64F}", "\u{1104}\u{116B}\u{11AE}"),
    ("\u{B650}", "\u{B650}", "\u{1104}\u{116B}\u{11AF}", "\u{B650}", "\u{1104}\u{116B}\u{11AF}"),
    ("\u{B651}", "\u{B651}", "\u{1104}\u{116B}\u{11B0}", "\u{B651}", "\u{1104}\u{116B}\u{11B0}"),
    ("\u{B652}", "\u{B652}", "\u{1104}\u{116B}\u{11B1}", "\u{B652}", "\u{1104}\u{116B}\u{11B1}"),
    ("\u{B653}", "\u{B653}", "\u{1104}\u{116B}\u{11B2}", "\u{B653}", "\u{1104}\u{116B}\u{11B2}"),
    ("\u{B654}", "\u{B654}", "\u{1104}\u{116B}\u{11B3}", "\u{B654}", "\u{1104}\u{116B}\u{11B3}"),
    ("\u{B655}", "\u{B655}", "\u{1104}\u{116B}\u{11B4}", "\u{B655}", "\u{1104}\u{116B}\u{11B4}"),
    ("\u{B656}", "\u{B656}", "\u{1104}\u{116B}\u{11B5}", "\u{B656}", "\u{1104}\u{116B}\u{11B5}"),
    ("\u{B657}", "\u{B657}", "\u{1104}\u{116B}\u{11B6}", "\u{B657}", "\u{1104}\u{116B}\u{11B6}"),
    ("\u{B658}", "\u{B658}", "\u{1104}\u{116B}\u{11B7}", "\u{B658}", "\u{1104}\u{116B}\u{11B7}"),
    ("\u{B659}", "\u{B659}", "\u{1104}\u{116B}\u{11B8}", "\u{B659}", "\u{1104}\u{116B}\u{11B8}"),
    ("\u{B65A}", "\u{B65A}", "\u{1104}\u{116B}\u{11B9}", "\u{B65A}", "\u{1104}\u{116B}\u{11B9}"),
    ("\u{B65B}", "\u{B65B}", "\u{1104}\u{116B}\u{11BA}", "\u{B65B}", "\u{1104}\u{116B}\u{11BA}"),
    ("\u{B65C}", "\u{B65C}", "\u{1104}\u{116B}\u{11BB}", "\u{B65C}", "\u{1104}\u{116B}\u{11BB}"),
    ("\u{B65D}", "\u{B65D}", "\u{1104}\u{116B}\u{11BC}", "\u{B65D}", "\u{1104}\u{116B}\u{11BC}"),
    ("\u{B65E}", "\u{B65E}", "\u{1104}\u{116B}\u{11BD}", "\u{B65E}", "\u{1104}\u{116B}\u{11BD}"),
    ("\u{B65F}", "\u{B65F}", "\u{1104}\u{116B}\u{11BE}", "\u{B65F}", "\u{1104}\u{116B}\u{11BE}"),
    ("\u{B660}", "\u{B660}", "\u{1104}\u{116B}\u{11BF}", "\u{B660}", "\u{1104}\u{116B}\u{11BF}"),
    ("\u{B661}", "\u{B661}", "\u{1104}\u{116B}\u{11C0}", "\u{B661}", "\u{1104}\u{116B}\u{11C0}"),
    ("\u{B662}", "\u{B662}", "\u{1104}\u{116B}\u{11C1}", "\u{B662}", "\u{1104}\u{116B}\u{11C1}"),
    ("\u{B663}", "\u{B663}", "\u{1104}\u{116B}\u{11C2}", "\u{B663}", "\u{1104}\u{116B}\u{11C2}"),
    ("\u{B664}", "\u{B664}", "\u{1104}\u{116C}", "\u{B664}", "\u{1104}\u{116C}"),
    ("\u{B665}", "\u{B665}", "\u{1104}\u{116C}\u{11A8}", "\u{B665}", "\u{1104}\u{116C}\u{11A8}"),
    ("\u{B666}", "\u{B666}", "\u{1104}\u{116C}\u{11A9}", "\u{B666}", "\u{1104}\u{116C}\u{11A9}"),
    ("\u{B667}", "\u{B667}", "\u{1104}\u{116C}\u{11AA}", "\u{B667}", "\u{1104}\u{116C}\u{11AA}"),
    ("\u{B668}", "\u{B668}", "\u{1104}\u{116C}\u{11AB}", "\u{B668}", "\u{1104}\u{116C}\u{11AB}"),
    ("\u{B669}", "\u{B669}", "\u{1104}\u{116C}\u{11AC}", "\u{B669}", "\u{1104}\u{116C}\u{11AC}"),
    ("\u{B66A}", "\u{B66A}", "\u{1104}\u{116C}\u{11AD}", "\u{B66A}", "\u{1104}\u{116C}\u{11AD}"),
    ("\u{B66B}", "\u{B66B}", "\u{1104}\u{116C}\u{11AE}", "\u{B66B}", "\u{1104}\u{116C}\u{11AE}"),
    ("\u{B66C}", "\u{B66C}", "\u{1104}\u{116C}\u{11AF}", "\u{B66C}", "\u{1104}\u{116C}\u{11AF}"),
    ("\u{B66D}", "\u{B66D}", "\u{1104}\u{116C}\u{11B0}", "\u{B66D}", "\u{1104}\u{116C}\u{11B0}"),
    ("\u{B66E}", "\u{B66E}", "\u{1104}\u{116C}\u{11B1}", "\u{B66E}", "\u{1104}\u{116C}\u{11B1}"),
    ("\u{B66F}", "\u{B66F}", "\u{1104}\u{116C}\u{11B2}", "\u{B66F}", "\u{1104}\u{116C}\u{11B2}"),
    ("\u{B670}", "\u{B670}", "\u{1104}\u{116C}\u{11B3}", "\u{B670}", "\u{1104}\u{116C}\u{11B3}"),
    ("\u{B671}", "\u{B671}", "\u{1104}\u{116C}\u{11B4}", "\u{B671}", "\u{1104}\u{116C}\u{11B4}"),
    ("\u{B672}", "\u{B672}", "\u{1104}\u{116C}\u{11B5}", "\u{B672}", "\u{1104}\u{116C}\u{11B5}"),
    ("\u{B673}", "\u{B673}", "\u{1104}\u{116C}\u{11B6}", "\u{B673}", "\u{1104}\u{116C}\u{11B6}"),
    ("\u{B674}", "\u{B674}", "\u{1104}\u{116C}\u{11B7}", "\u{B674}", "\u{1104}\u{116C}\u{11B7}"),
    ("\u{B675}", "\u{B675}", "\u{1104}\u{116C}\u{11B8}", "\u{B675}", "\u{1104}\u{116C}\u{11B8}"),
    ("\u{B676}", "\u{B676}", "\u{1104}\u{116C}\u{11B9}", "\u{B676}", "\u{1104}\u{116C}\u{11B9}"),
    ("\u{B677}", "\u{B677}", "\u{1104}\u{116C}\u{11BA}", "\u{B677}", "\u{1104}\u{116C}\u{11BA}"),
    ("\u{B678}", "\u{B678}", "\u{1104}\u{116C}\u{11BB}", "\u{B678}", "\u{1104}\u{116C}\u{11BB}"),
    ("\u{B679}", "\u{B679}", "\u{1104}\u{116C}\u{11BC}", "\u{B679}", "\u{1104}\u{116C}\u{11BC}"),
    ("\u{B67A}", "\u{B67A}", "\u{1104}\u{116C}\u{11BD}", "\u{B67A}", "\u{1104}\u{116C}\u{11BD}"),
    ("\u{B67B}", "\u{B67B}", "\u{1104}\u{116C}\u{11BE}", "\u{B67B}", "\u{1104}\u{116C}\u{11BE}"),
    ("\u{B67C}", "\u{B67C}", "\u{1104}\u{116C}\u{11BF}", "\u{B67C}", "\u{1104}\u{116C}\u{11BF}"),
    ("\u{B67D}", "\u{B67D}", "\u{1104}\u{116C}\u{11C0}", "\u{B67D}", "\u{1104}\u{116C}\u{11C0}"),
    ("\u{B67E}", "\u{B67E}", "\u{1104}\u{116C}\u{11C1}", "\u{B67E}", "\u{1104}\u{116C}\u{11C1}"),
    ("\u{B67F}", "\u{B67F}", "\u{1104}\u{116C}\u{11C2}", "\u{B67F}", "\u{1104}\u{116C}\u{11C2}"),
    ("\u{B680}", "\u{B680}", "\u{1104}\u{116D}", "\u{B680}", "\u{1104}\u{116D}"),
    ("\u{B681}", "\u{B681}", "\u{1104}\u{116D}\u{11A8}", "\u{B681}", "\u{1104}\u{116D}\u{11A8}"),
    ("\u{B682}", "\u{B682}", "\u{1104}\u{116D}\u{11A9}", "\u{B682}", "\u{1104}\u{116D}\u{11A9}"),
    ("\u{B683}", "\u{B683}", "\u{1104}\u{116D}\u{11AA}", "\u{B683}", "\u{1104}\u{116D}\u{11AA}"),
    ("\u{B684}", "\u{B684}", "\u{1104}\u{116D}\u{11AB}", "\u{B684}", "\u{1104}\u{116D}\u{11AB}"),
    ("\u{B685}", "\u{B685}", "\u{1104}\u{116D}\u{11AC}", "\u{B685}", "\u{1104}\u{116D}\u{11AC}"),
    ("\u{B686}", "\u{B686}", "\u{1104}\u{116D}\u{11AD}", "\u{B686}", "\u{1104}\u{116D}\u{11AD}"),
    ("\u{B687}", "\u{B687}", "\u{1104}\u{116D}\u{11AE}", "\u{B687}", "\u{1104}\u{116D}\u{11AE}"),
    ("\u{B688}", "\u{B688}", "\u{1104}\u{116D}\u{11AF}", "\u{B688}", "\u{1104}\u{116D}\u{11AF}"),
    ("\u{B689}", "\u{B689}", "\u{1104}\u{116D}\u{11B0}", "\u{B689}", "\u{1104}\u{116D}\u{11B0}"),
    ("\u{B68A}", "\u{B68A}", "\u{1104}\u{116D}\u{11B1}", "\u{B68A}", "\u{1104}\u{116D}\u{11B1}"),
    ("\u{B68B}", "\u{B68B}", "\u{1104}\u{116D}\u{11B2}", "\u{B68B}", "\u{1104}\u{116D}\u{11B2}"),
    ("\u{B68C}", "\u{B68C}", "\u{1104}\u{116D}\u{11B3}", "\u{B68C}", "\u{1104}\u{116D}\u{11B3}"),
    ("\u{B68D}", "\u{B68D}", "\u{1104}\u{116D}\u{11B4}", "\u{B68D}", "\u{1104}\u{116D}\u{11B4}"),
    ("\u{B68E}", "\u{B68E}", "\u{1104}\u{116D}\u{11B5}", "\u{B68E}", "\u{1104}\u{116D}\u{11B5}"),
    ("\u{B68F}", "\u{B68F}", "\u{1104}\u{116D}\u{11B6}", "\u{B68F}", "\u{1104}\u{116D}\u{11B6}"),
    ("\u{B690}", "\u{B690}", "\u{1104}\u{116D}\u{11B7}", "\u{B690}", "\u{1104}\u{116D}\u{11B7}"),
    ("\u{B691}", "\u{B691}", "\u{1104}\u{116D}\u{11B8}", "\u{B691}", "\u{1104}\u{116D}\u{11B8}"),
    ("\u{B692}", "\u{B692}", "\u{1104}\u{116D}\u{11B9}", "\u{B692}", "\u{1104}\u{116D}\u{11B9}"),
    ("\u{B693}", "\u{B693}", "\u{1104}\u{116D}\u{11BA}", "\u{B693}", "\u{1104}\u{116D}\u{11BA}"),
    ("\u{B694}", "\u{B694}", "\u{1104}\u{116D}\u{11BB}", "\u{B694}", "\u{1104}\u{116D}\u{11BB}"),
    ("\u{B695}", "\u{B695}", "\u{1104}\u{116D}\u{11BC}", "\u{B695}", "\u{1104}\u{116D}\u{11BC}"),
    ("\u{B696}", "\u{B696}", "\u{1104}\u{116D}\u{11BD}", "\u{B696}", "\u{1104}\u{116D}\u{11BD}"),
    ("\u{B697}", "\u{B697}", "\u{1104}\u{116D}\u{11BE}", "\u{B697}", "\u{1104}\u{116D}\u{11BE}"),
    ("\u{B698}", "\u{B698}", "\u{1104}\u{116D}\u{11BF}", "\u{B698}", "\u{1104}\u{116D}\u{11BF}"),
    ("\u{B699}", "\u{B699}", "\u{1104}\u{116D}\u{11C0}", "\u{B699}", "\u{1104}\u{116D}\u{11C0}"),
    ("\u{B69A}", "\u{B69A}", "\u{1104}\u{116D}\u{11C1}", "\u{B69A}", "\u{1104}\u{116D}\u{11C1}"),
    ("\u{B69B}", "\u{B69B}", "\u{1104}\u{116D}\u{11C2}", "\u{B69B}", "\u{1104}\u{116D}\u{11C2}"),
    ("\u{B69C}", "\u{B69C}", "\u{1104}\u{116E}", "\u{B69C}", "\u{1104}\u{116E}"),
    ("\u{B69D}", "\u{B69D}", "\u{1104}\u{116E}\u{11A8}", "\u{B69D}", "\u{1104}\u{116E}\u{11A8}"),
    ("\u{B69E}", "\u{B69E}", "\u{1104}\u{116E}\u{11A9}", "\u{B69E}", "\u{1104}\u{116E}\u{11A9}"),
    ("\u{B69F}", "\u{B69F}", "\u{1104}\u{116E}\u{11AA}", "\u{B69F}", "\u{1104}\u{116E}\u{11AA}"),
    ("\u{B6A0}", "\u{B6A0}", "\u{1104}\u{116E}\u{11AB}", "\u{B6A0}", "\u{1104}\u{116E}\u{11AB}"),
    ("\u{B6A1}", "\u{B6A1}", "\u{1104}\u{116E}\u{11AC}", "\u{B6A1}", "\u{1104}\u{116E}\u{11AC}"),
    ("\u{B6A2}", "\u{B6A2}", "\u{1104}\u{116E}\u{11AD}", "\u{B6A2}", "\u{1104}\u{116E}\u{11AD}"),
    ("\u{B6A3}", "\u{B6A3}", "\u{1104}\u{116E}\u{11AE}", "\u{B6A3}", "\u{1104}\u{116E}\u{11AE}"),
    ("\u{B6A4}", "\u{B6A4}", "\u{1104}\u{116E}\u{11AF}", "\u{B6A4}", "\u{1104}\u{116E}\u{11AF}"),
    ("\u{B6A5}", "\u{B6A5}", "\u{1104}\u{116E}\u{11B0}", "\u{B6A5}", "\u{1104}\u{116E}\u{11B0}"),
    ("\u{B6A6}", "\u{B6A6}", "\u{1104}\u{116E}\u{11B1}", "\u{B6A6}", "\u{1104}\u{116E}\u{11B1}"),
    ("\u{B6A7}", "\u{B6A7}", "\u{1104}\u{116E}\u{11B2}", "\u{B6A7}", "\u{1104}\u{116E}\u{11B2}"),
    ("\u{B6A8}", "\u{B6A8}", "\u{1104}\u{116E}\u{11B3}", "\u{B6A8}", "\u{1104}\u{116E}\u{11B3}"),
    ("\u{B6A9}", "\u{B6A9}", "\u{1104}\u{116E}\u{11B4}", "\u{B6A9}", "\u{1104}\u{116E}\u{11B4}"),
    ("\u{B6AA}", "\u{B6AA}", "\u{1104}\u{116E}\u{11B5}", "\u{B6AA}", "\u{1104}\u{116E}\u{11B5}"),
    ("\u{B6AB}", "\u{B6AB}", "\u{1104}\u{116E}\u{11B6}", "\u{B6AB}", "\u{1104}\u{116E}\u{11B6}"),
    ("\u{B6AC}", "\u{B6AC}", "\u{1104}\u{116E}\u{11B7}", "\u{B6AC}", "\u{1104}\u{116E}\u{11B7}"),
    ("\u{B6AD}", "\u{B6AD}", "\u{1104}\u{116E}\u{11B8}", "\u{B6AD}", "\u{1104}\u{116E}\u{11B8}"),
    ("\u{B6AE}", "\u{B6AE}", "\u{1104}\u{116E}\u{11B9}", "\u{B6AE}", "\u{1104}\u{116E}\u{11B9}"),
    ("\u{B6AF}", "\u{B6AF}", "\u{1104}\u{116E}\u{11BA}", "\u{B6AF}", "\u{1104}\u{116E}\u{11BA}"),
    ("\u{B6B0}", "\u{B6B0}", "\u{1104}\u{116E}\u{11BB}", "\u{B6B0}", "\u{1104}\u{116E}\u{11BB}"),
    ("\u{B6B1}", "\u{B6B1}", "\u{1104}\u{116E}\u{11BC}", "\u{B6B1}", "\u{1104}\u{116E}\u{11BC}"),
    ("\u{B6B2}", "\u{B6B2}", "\u{1104}\u{116E}\u{11BD}", "\u{B6B2}", "\u{1104}\u{116E}\u{11BD}"),
    ("\u{B6B3}", "\u{B6B3}", "\u{1104}\u{116E}\u{11BE}", "\u{B6B3}", "\u{1104}\u{116E}\u{11BE}"),
    ("\u{B6B4}", "\u{B6B4}", "\u{1104}\u{116E}\u{11BF}", "\u{B6B4}", "\u{1104}\u{116E}\u{11BF}"),
    ("\u{B6B5}", "\u{B6B5}", "\u{1104}\u{116E}\u{11C0}", "\u{B6B5}", "\u{1104}\u{116E}\u{11C0}"),
    ("\u{B6B6}", "\u{B6B6}", "\u{1104}\u{116E}\u{11C1}", "\u{B6B6}", "\u{1104}\u{116E}\u{11C1}"),
    ("\u{B6B7}", "\u{B6B7}", "\u{1104}\u{116E}\u{11C2}", "\u{B6B7}", "\u{1104}\u{116E}\u{11C2}"),
    ("\u{B6B8}", "\u{B6B8}", "\u{1104}\u{116F}", "\u{B6B8}", "\u{1104}\u{116F}"),
    ("\u{B6B9}", "\u{B6B9}", "\u{1104}\u{116F}\u{11A8}", "\u{B6B9}", "\u{1104}\u{116F}\u{11A8}"),
    ("\u{B6BA}", "\u{B6BA}", "\u{1104}\u{116F}\u{11A9}", "\u{B6BA}", "\u{1104}\u{116F}\u{11A9}"),
    ("\u{B6BB}", "\u{B6BB}", "\u{1104}\u{116F}\u{11AA}", "\u{B6BB}", "\u{1104}\u{116F}\u{11AA}"),
    ("\u{B6BC}", "\u{B6BC}", "\u{1104}\u{116F}\u{11AB}", "\u{B6BC}", "\u{1104}\u{116F}\u{11AB}"),
    ("\u{B6BD}", "\u{B6BD}", "\u{1104}\u{116F}\u{11AC}", "\u{B6BD}", "\u{1104}\u{116F}\u{11AC}"),
    ("\u{B6BE}", "\u{B6BE}", "\u{1104}\u{116F}\u{11AD}", "\u{B6BE}", "\u{1104}\u{116F}\u{11AD}"),
    ("\u{B6BF}", "\u{B6BF}", "\u{1104}\u{116F}\u{11AE}", "\u{B6BF}", "\u{1104}\u{116F}\u{11AE}"),
    ("\u{B6C0}", "\u{B6C0}", "\u{1104}\u{116F}\u{11AF}", "\u{B6C0}", "\u{1104}\u{116F}\u{11AF}"),
    ("\u{B6C1}", "\u{B6C1}", "\u{1104}\u{116F}\u{11B0}", "\u{B6C1}", "\u{1104}\u{116F}\u{11B0}"),
    ("\u{B6C2}", "\u{B6C2}", "\u{1104}\u{116F}\u{11B1}", "\u{B6C2}", "\u{1104}\u{116F}\u{11B1}"),
    ("\u{B6C3}", "\u{B6C3}", "\u{1104}\u{116F}\u{11B2}", "\u{B6C3}", "\u{1104}\u{116F}\u{11B2}"),
    ("\u{B6C4}", "\u{B6C4}", "\u{1104}\u{116F}\u{11B3}", "\u{B6C4}", "\u{1104}\u{116F}\u{11B3}"),
    ("\u{B6C5}", "\u{B6C5}", "\u{1104}\u{116F}\u{11B4}", "\u{B6C5}", "\u{1104}\u{116F}\u{11B4}"),
    ("\u{B6C6}", "\u{B6C6}", "\u{1104}\u{116F}\u{11B5}", "\u{B6C6}", "\u{1104}\u{116F}\u{11B5}"),
    ("\u{B6C7}", "\u{B6C7}", "\u{1104}\u{116F}\u{11B6}", "\u{B6C7}", "\u{1104}\u{116F}\u{11B6}"),
    ("\u{B6C8}", "\u{B6C8}", "\u{1104}\u{116F}\u{11B7}", "\u{B6C8}", "\u{1104}\u{116F}\u{11B7}"),
    ("\u{B6C9}", "\u{B6C9}", "\u{1104}\u{116F}\u{11B8}", "\u{B6C9}", "\u{1104}\u{116F}\u{11B8}"),
    ("\u{B6CA}", "\u{B6CA}", "\u{1104}\u{116F}\u{11B9}", "\u{B6CA}", "\u{1104}\u{116F}\u{11B9}"),
    ("\u{B6CB}", "\u{B6CB}", "\u{1104}\u{116F}\u{11BA}", "\u{B6CB}", "\u{1104}\u{116F}\u{11BA}"),
    ("\u{B6CC}", "\u{B6CC}", "\u{1104}\u{116F}\u{11BB}", "\u{B6CC}", "\u{1104}\u{116F}\u{11BB}"),
    ("\u{B6CD}", "\u{B6CD}", "\u{1104}\u{116F}\u{11BC}", "\u{B6CD}", "\u{1104}\u{116F}\u{11BC}"),
    ("\u{B6CE}", "\u{B6CE}", "\u{1104}\u{116F}\u{11BD}", "\u{B6CE}", "\u{1104}\u{116F}\u{11BD}"),
    ("\u{B6CF}", "\u{B6CF}", "\u{1104}\u{116F}\u{11BE}", "\u{B6CF}", "\u{1104}\u{116F}\u{11BE}"),
    ("\u{B6D0}", "\u{B6D0}", "\u{1104}\u{116F}\u{11BF}", "\u{B6D0}", "\u{1104}\u{116F}\u{11BF}"),
    ("\u{B6D1}", "\u{B6D1}", "\u{1104}\u{116F}\u{11C0}", "\u{B6D1}", "\u{1104}\u{116F}\u{11C0}"),
    ("\u{B6D2}", "\u{B6D2}", "\u{1104}\u{116F}\u{11C1}", "\u{B6D2}", "\u{1104}\u{116F}\u{11C1}"),
    ("\u{B6D3}", "\u{B6D3}", "\u{1104}\u{116F}\u{11C2}", "\u{B6D3}", "\u{1104}\u{116F}\u{11C2}"),
    ("\u{B6D4}", "\u{B6D4}", "\u{1104}\u{1170}", "\u{B6D4}", "\u{1104}\u{1170}"),
    ("\u{B6D5}", "\u{B6D5}", "\u{1104}\u{1170}\u{11A8}", "\u{B6D5}", "\u{1104}\u{1170}\u{11A8}"),
    ("\u{B6D6}", "\u{B6D6}", "\u{1104}\u{1170}\u{11A9}", "\u{B6D6}", "\u{1104}\u{1170}\u{11A9}"),
    ("\u{B6D7}", "\u{B6D7}", "\u{1104}\u{1170}\u{11AA}", "\u{B6D7}", "\u{1104}\u{1170}\u{11AA}"),
    ("\u{B6D8}", "\u{B6D8}", "\u{1104}\u{1170}\u{11AB}", "\u{B6D8}", "\u{1104}\u{1170}\u{11AB}"),
    ("\u{B6D9}", "\u{B6D9}", "\u{1104}\u{1170}\u{11AC}", "\u{B6D9}", "\u{1104}\u{1170}\u{11AC}"),
    ("\u{B6DA}", "\u{B6DA}", "\u{1104}\u{1170}\u{11AD}", "\u{B6DA}", "\u{1104}\u{1170}\u{11AD}"),
    ("\u{B6DB}", "\u{B6DB}", "\u{1104}\u{1170}\u{11AE}", "\u{B6DB}", "\u{1104}\u{1170}\u{11AE}"),
    ("\u{B6DC}", "\u{B6DC}", "\u{1104}\u{1170}\u{11AF}", "\u{B6DC}", "\u{1104}\u{1170}\u{11AF}"),
    ("\u{B6DD}", "\u{B6DD}", "\u{1104}\u{1170}\u{11B0}", "\u{B6DD}", "\u{1104}\u{1170}\u{11B0}"),
    ("\u{B6DE}", "\u{B6DE}", "\u{1104}\u{1170}\u{11B1}", "\u{B6DE}", "\u{1104}\u{1170}\u{11B1}"),
    ("\u{B6DF}", "\u{B6DF}", "\u{1104}\u{1170}\u{11B2}", "\u{B6DF}", "\u{1104}\u{1170}\u{11B2}"),
    ("\u{B6E0}", "\u{B6E0}", "\u{1104}\u{1170}\u{11B3}", "\u{B6E0}", "\u{1104}\u{1170}\u{11B3}"),
    ("\u{B6E1}", "\u{B6E1}", "\u{1104}\u{1170}\u{11B4}", "\u{B6E1}", "\u{1104}\u{1170}\u{11B4}"),
    ("\u{B6E2}", "\u{B6E2}", "\u{1104}\u{1170}\u{11B5}", "\u{B6E2}", "\u{1104}\u{1170}\u{11B5}"),
    ("\u{B6E3}", "\u{B6E3}", "\u{1104}\u{1170}\u{11B6}", "\u{B6E3}", "\u{1104}\u{1170}\u{11B6}"),
    ("\u{B6E4}", "\u{B6E4}", "\u{1104}\u{1170}\u{11B7}", "\u{B6E4}", "\u{1104}\u{1170}\u{11B7}"),
    ("\u{B6E5}", "\u{B6E5}", "\u{1104}\u{1170}\u{11B8}", "\u{B6E5}", "\u{1104}\u{1170}\u{11B8}"),
    ("\u{B6E6}", "\u{B6E6}", "\u{1104}\u{1170}\u{11B9}", "\u{B6E6}", "\u{1104}\u{1170}\u{11B9}"),
    ("\u{B6E7}", "\u{B6E7}", "\u{1104}\u{1170}\u{11BA}", "\u{B6E7}", "\u{1104}\u{1170}\u{11BA}"),
    ("\u{B6E8}", "\u{B6E8}", "\u{1104}\u{1170}\u{11BB}", "\u{B6E8}", "\u{1104}\u{1170}\u{11BB}"),
    ("\u{B6E9}", "\u{B6E9}", "\u{1104}\u{1170}\u{11BC}", "\u{B6E9}", "\u{1104}\u{1170}\u{11BC}"),
    ("\u{B6EA}", "\u{B6EA}", "\u{1104}\u{1170}\u{11BD}", "\u{B6EA}", "\u{1104}\u{1170}\u{11BD}"),
    ("\u{B6EB}", "\u{B6EB}", "\u{1104}\u{1170}\u{11BE}", "\u{B6EB}", "\u{1104}\u{1170}\u{11BE}"),
    ("\u{B6EC}", "\u{B6EC}", "\u{1104}\u{1170}\u{11BF}", "\u{B6EC}", "\u{1104}\u{1170}\u{11BF}"),
    ("\u{B6ED}", "\u{B6ED}", "\u{1104}\u{1170}\u{11C0}", "\u{B6ED}", "\u{1104}\u{1170}\u{11C0}"),
    ("\u{B6EE}", "\u{B6EE}", "\u{1104}\u{1170}\u{11C1}", "\u{B6EE}", "\u{1104}\u{1170}\u{11C1}"),
    ("\u{B6EF}", "\u{B6EF}", "\u{1104}\u{1170}\u{11C2}", "\u{B6EF}", "\u{1104}\u{1170}\u{11C2}"),
    ("\u{B6F0}", "\u{B6F0}", "\u{1104}\u{1171}", "\u{B6F0}", "\u{1104}\u{1171}"),
    ("\u{B6F1}", "\u{B6F1}", "\u{1104}\u{1171}\u{11A8}", "\u{B6F1}", "\u{1104}\u{1171}\u{11A8}"),
    ("\u{B6F2}", "\u{B6F2}", "\u{1104}\u{1171}\u{11A9}", "\u{B6F2}", "\u{1104}\u{1171}\u{11A9}"),
    ("\u{B6F3}", "\u{B6F3}", "\u{1104}\u{1171}\u{11AA}", "\u{B6F3}", "\u{1104}\u{1171}\u{11AA}"),
    ("\u{B6F4}", "\u{B6F4}", "\u{1104}\u{1171}\u{11AB}", "\u{B6F4}", "\u{1104}\u{1171}\u{11AB}"),
    ("\u{B6F5}", "\u{B6F5}", "\u{1104}\u{1171}\u{11AC}", "\u{B6F5}", "\u{1104}\u{1171}\u{11AC}"),
    ("\u{B6F6}", "\u{B6F6}", "\u{1104}\u{1171}\u{11AD}", "\u{B6F6}", "\u{1104}\u{1171}\u{11AD}"),
    ("\u{B6F7}", "\u{B6F7}", "\u{1104}\u{1171}\u{11AE}", "\u{B6F7}", "\u{1104}\u{1171}\u{11AE}"),
    ("\u{B6F8}", "\u{B6F8}", "\u{1104}\u{1171}\u{11AF}", "\u{B6F8}", "\u{1104}\u{1171}\u{11AF}"),
    ("\u{B6F9}", "\u{B6F9}", "\u{1104}\u{1171}\u{11B0}", "\u{B6F9}", "\u{1104}\u{1171}\u{11B0}"),
    ("\u{B6FA}", "\u{B6FA}", "\u{1104}\u{1171}\u{11B1}", "\u{B6FA}", "\u{1104}\u{1171}\u{11B1}"),
    ("\u{B6FB}", "\u{B6FB}", "\u{1104}\u{1171}\u{11B2}", "\u{B6FB}", "\u{1104}\u{1171}\u{11B2}"),
    ("\u{B6FC}", "\u{B6FC}", "\u{1104}\u{1171}\u{11B3}", "\u{B6FC}", "\u{1104}\u{1171}\u{11B3}"),
    ("\u{B6FD}", "\u{B6FD}", "\u{1104}\u{1171}\u{11B4}", "\u{B6FD}", "\u{1104}\u{1171}\u{11B4}"),
    ("\u{B6FE}", "\u{B6FE}", "\u{1104}\u{1171}\u{11B5}", "\u{B6FE}", "\u{1104}\u{1171}\u{11B5}"),
    ("\u{B6FF}", "\u{B6FF}", "\u{1104}\u{1171}\u{11B6}", "\u{B6FF}", "\u{1104}\u{1171}\u{11B6}"),
    ("\u{B700}", "\u{B700}", "\u{1104}\u{1171}\u{11B7}", "\u{B700}", "\u{1104}\u{1171}\u{11B7}"),
    ("\u{B701}", "\u{B701}", "\u{1104}\u{1171}\u{11B8}", "\u{B701}", "\u{1104}\u{1171}\u{11B8}"),
    ("\u{B702}", "\u{B702}", "\u{1104}\u{1171}\u{11B9}", "\u{B702}", "\u{1104}\u{1171}\u{11B9}"),
    ("\u{B703}", "\u{B703}", "\u{1104}\u{1171}\u{11BA}", "\u{B703}", "\u{1104}\u{1171}\u{11BA}"),
    ("\u{B704}", "\u{B704}", "\u{1104}\u{1171}\u{11BB}", "\u{B704}", "\u{1104}\u{1171}\u{11BB}"),
    ("\u{B705}", "\u{B705}", "\u{1104}\u{1171}\u{11BC}", "\u{B705}", "\u{1104}\u{1171}\u{11BC}"),
    ("\u{B706}", "\u{B706}", "\u{1104}\u{1171}\u{11BD}", "\u{B706}", "\u{1104}\u{1171}\u{11BD}"),
    ("\u{B707}", "\u{B707}", "\u{1104}\u{1171}\u{11BE}", "\u{B707}", "\u{1104}\u{1171}\u{11BE}"),
    ("\u{B708}", "\u{B708}", "\u{1104}\u{1171}\u{11BF}", "\u{B708}", "\u{1104}\u{1171}\u{11BF}"),
    ("\u{B709}", "\u{B709}", "\u{1104}\u{1171}\u{11C0}", "\u{B709}", "\u{1104}\u{1171}\u{11C0}"),
    ("\u{B70A}", "\u{B70A}", "\u{1104}\u{1171}\u{11C1}", "\u{B70A}", "\u{1104}\u{1171}\u{11C1}"),
    ("\u{B70B}", "\u{B70B}", "\u{1104}\u{1171}\u{11C2}", "\u{B70B}", "\u{1104}\u{1171}\u{11C2}"),
    ("\u{B70C}", "\u{B70C}", "\u{1104}\u{1172}", "\u{B70C}", "\u{1104}\u{1172}"),
    ("\u{B70D}", "\u{B70D}", "\u{1104}\u{1172}\u{11A8}", "\u{B70D}", "\u{1104}\u{1172}\u{11A8}"),
    ("\u{B70E}", "\u{B70E}", "\u{1104}\u{1172}\u{11A9}", "\u{B70E}", "\u{1104}\u{1172}\u{11A9}"),
    ("\u{B70F}", "\u{B70F}", "\u{1104}\u{1172}\u{11AA}", "\u{B70F}", "\u{1104}\u{1172}\u{11AA}"),
    ("\u{B710}", "\u{B710}", "\u{1104}\u{1172}\u{11AB}", "\u{B710}", "\u{1104}\u{1172}\u{11AB}"),
    ("\u{B711}", "\u{B711}", "\u{1104}\u{1172}\u{11AC}", "\u{B711}", "\u{1104}\u{1172}\u{11AC}"),
    ("\u{B712}", "\u{B712}", "\u{1104}\u{1172}\u{11AD}", "\u{B712}", "\u{1104}\u{1172}\u{11AD}"),
    ("\u{B713}", "\u{B713}", "\u{1104}\u{1172}\u{11AE}", "\u{B713}", "\u{1104}\u{1172}\u{11AE}"),
    ("\u{B714}", "\u{B714}", "\u{1104}\u{1172}\u{11AF}", "\u{B714}", "\u{1104}\u{1172}\u{11AF}"),
    ("\u{B715}", "\u{B715}", "\u{1104}\u{1172}\u{11B0}", "\u{B715}", "\u{1104}\u{1172}\u{11B0}"),
    ("\u{B716}", "\u{B716}", "\u{1104}\u{1172}\u{11B1}", "\u{B716}", "\u{1104}\u{1172}\u{11B1}"),
    ("\u{B717}", "\u{B717}", "\u{1104}\u{1172}\u{11B2}", "\u{B717}", "\u{1104}\u{1172}\u{11B2}"),
    ("\u{B718}", "\u{B718}", "\u{1104}\u{1172}\u{11B3}", "\u{B718}", "\u{1104}\u{1172}\u{11B3}"),
    ("\u{B719}", "\u{B719}", "\u{1104}\u{1172}\u{11B4}", "\u{B719}", "\u{1104}\u{1172}\u{11B4}"),
    ("\u{B71A}", "\u{B71A}", "\u{1104}\u{1172}\u{11B5}", "\u{B71A}", "\u{1104}\u{1172}\u{11B5}"),
    ("\u{B71B}", "\u{B71B}", "\u{1104}\u{1172}\u{11B6}", "\u{B71B}", "\u{1104}\u{1172}\u{11B6}"),
    ("\u{B71C}", "\u{B71C}", "\u{1104}\u{1172}\u{11B7}", "\u{B71C}", "\u{1104}\u{1172}\u{11B7}"),
    ("\u{B71D}", "\u{B71D}", "\u{1104}\u{1172}\u{11B8}", "\u{B71D}", "\u{1104}\u{1172}\u{11B8}"),
    ("\u{B71E}", "\u{B71E}", "\u{1104}\u{1172}\u{11B9}", "\u{B71E}", "\u{1104}\u{1172}\u{11B9}"),
    ("\u{B71F}", "\u{B71F}", "\u{1104}\u{1172}\u{11BA}", "\u{B71F}", "\u{1104}\u{1172}\u{11BA}"),
    ("\u{B720}", "\u{B720}", "\u{1104}\u{1172}\u{11BB}", "\u{B720}", "\u{1104}\u{1172}\u{11BB}"),
    ("\u{B721}", "\u{B721}", "\u{1104}\u{1172}\u{11BC}", "\u{B721}", "\u{1104}\u{1172}\u{11BC}"),
    ("\u{B722}", "\u{B722}", "\u{1104}\u{1172}\u{11BD}", "\u{B722}", "\u{1104}\u{1172}\u{11BD}"),
    ("\u{B723}", "\u{B723}", "\u{1104}\u{1172}\u{11BE}", "\u{B723}", "\u{1104}\u{1172}\u{11BE}"),
    ("\u{B724}", "\u{B724}", "\u{1104}\u{1172}\u{11BF}", "\u{B724}", "\u{1104}\u{1172}\u{11BF}"),
    ("\u{B725}", "\u{B725}", "\u{1104}\u{1172}\u{11C0}", "\u{B725}", "\u{1104}\u{1172}\u{11C0}"),
    ("\u{B726}", "\u{B726}", "\u{1104}\u{1172}\u{11C1}", "\u{B726}", "\u{1104}\u{1172}\u{11C1}"),
    ("\u{B727}", "\u{B727}", "\u{1104}\u{1172}\u{11C2}", "\u{B727}", "\u{1104}\u{1172}\u{11C2}"),
    ("\u{B728}", "\u{B728}", "\u{1104}\u{1173}", "\u{B728}", "\u{1104}\u{1173}"),
    ("\u{B729}", "\u{B729}", "\u{1104}\u{1173}\u{11A8}", "\u{B729}", "\u{1104}\u{1173}\u{11A8}"),
    ("\u{B72A}", "\u{B72A}", "\u{1104}\u{1173}\u{11A9}", "\u{B72A}", "\u{1104}\u{1173}\u{11A9}"),
    ("\u{B72B}", "\u{B72B}", "\u{1104}\u{1173}\u{11AA}", "\u{B72B}", "\u{1104}\u{1173}\u{11AA}"),
    ("\u{B72C}", "\u{B72C}", "\u{1104}\u{1173}\u{11AB}", "\u{B72C}", "\u{1104}\u{1173}\u{11AB}"),
    ("\u{B72D}", "\u{B72D}", "\u{1104}\u{1173}\u{11AC}", "\u{B72D}", "\u{1104}\u{1173}\u{11AC}"),
    ("\u{B72E}", "\u{B72E}", "\u{1104}\u{1173}\u{11AD}", "\u{B72E}", "\u{1104}\u{1173}\u{11AD}"),
    ("\u{B72F}", "\u{B72F}", "\u{1104}\u{1173}\u{11AE}", "\u{B72F}", "\u{1104}\u{1173}\u{11AE}"),
    ("\u{B730}", "\u{B730}", "\u{1104}\u{1173}\u{11AF}", "\u{B730}", "\u{1104}\u{1173}\u{11AF}"),
    ("\u{B731}", "\u{B731}", "\u{1104}\u{1173}\u{11B0}", "\u{B731}", "\u{1104}\u{1173}\u{11B0}"),
    ("\u{B732}", "\u{B732}", "\u{1104}\u{1173}\u{11B1}", "\u{B732}", "\u{1104}\u{1173}\u{11B1}"),
    ("\u{B733}", "\u{B733}", "\u{1104}\u{1173}\u{11B2}", "\u{B733}", "\u{1104}\u{1173}\u{11B2}"),
    ("\u{B734}", "\u{B734}", "\u{1104}\u{1173}\u{11B3}", "\u{B734}", "\u{1104}\u{1173}\u{11B3}"),
    ("\u{B735}", "\u{B735}", "\u{1104}\u{1173}\u{11B4}", "\u{B735}", "\u{1104}\u{1173}\u{11B4}"),
    ("\u{B736}", "\u{B736}", "\u{1104}\u{1173}\u{11B5}", "\u{B736}", "\u{1104}\u{1173}\u{11B5}"),
    ("\u{B737}", "\u{B737}", "\u{1104}\u{1173}\u{11B6}", "\u{B737}", "\u{1104}\u{1173}\u{11B6}"),
    ("\u{B738}", "\u{B738}", "\u{1104}\u{1173}\u{11B7}", "\u{B738}", "\u{1104}\u{1173}\u{11B7}"),
    ("\u{B739}", "\u{B739}", "\u{1104}\u{1173}\u{11B8}", "\u{B739}", "\u{1104}\u{1173}\u{11B8}"),
    ("\u{B73A}", "\u{B73A}", "\u{1104}\u{1173}\u{11B9}", "\u{B73A}", "\u{1104}\u{1173}\u{11B9}"),
    ("\u{B73B}", "\u{B73B}", "\u{1104}\u{1173}\u{11BA}", "\u{B73B}", "\u{1104}\u{1173}\u{11BA}"),
    ("\u{B73C}", "\u{B73C}", "\u{1104}\u{1173}\u{11BB}", "\u{B73C}", "\u{1104}\u{1173}\u{11BB}"),
    ("\u{B73D}", "\u{B73D}", "\u{1104}\u{1173}\u{11BC}", "\u{B73D}", "\u{1104}\u{1173}\u{11BC}"),
    ("\u{B73E}", "\u{B73E}", "\u{1104}\u{1173}\u{11BD}", "\u{B73E}", "\u{1104}\u{1173}\u{11BD}"),
    ("\u{B73F}", "\u{B73F}", "\u{1104}\u{1173}\u{11BE}", "\u{B73F}", "\u{1104}\u{1173}\u{11BE}"),
    ("\u{B740}", "\u{B740}", "\u{1104}\u{1173}\u{11BF}", "\u{B740}", "\u{1104}\u{1173}\u{11BF}"),
    ("\u{B741}", "\u{B741}", "\u{1104}\u{1173}\u{11C0}", "\u{B741}", "\u{1104}\u{1173}\u{11C0}"),
    ("\u{B742}", "\u{B742}", "\u{1104}\u{1173}\u{11C1}", "\u{B742}", "\u{1104}\u{1173}\u{11C1}"),
    ("\u{B743}", "\u{B743}", "\u{1104}\u{1173}\u{11C2}", "\u{B743}", "\u{1104}\u{1173}\u{11C2}"),
    ("\u{B744}", "\u{B744}", "\u{1104}\u{1174}", "\u{B744}", "\u{1104}\u{1174}"),
    ("\u{B745}", "\u{B745}", "\u{1104}\u{1174}\u{11A8}", "\u{B745}", "\u{1104}\u{1174}\u{11A8}"),
    ("\u{B746}", "\u{B746}", "\u{1104}\u{1174}\u{11A9}", "\u{B746}", "\u{1104}\u{1174}\u{11A9}"),
    ("\u{B747}", "\u{B747}", "\u{1104}\u{1174}\u{11AA}", "\u{B747}", "\u{1104}\u{1174}\u{11AA}"),
    ("\u{B748}", "\u{B748}", "\u{1104}\u{1174}\u{11AB}", "\u{B748}", "\u{1104}\u{1174}\u{11AB}"),
    ("\u{B749}", "\u{B749}", "\u{1104}\u{1174}\u{11AC}", "\u{B749}", "\u{1104}\u{1174}\u{11AC}"),
    ("\u{B74A}", "\u{B74A}", "\u{1104}\u{1174}\u{11AD}", "\u{B74A}", "\u{1104}\u{1174}\u{11AD}"),
    ("\u{B74B}", "\u{B74B}", "\u{1104}\u{1174}\u{11AE}", "\u{B74B}", "\u{1104}\u{1174}\u{11AE}"),
    ("\u{B74C}", "\u{B74C}", "\u{1104}\u{1174}\u{11AF}", "\u{B74C}", "\u{1104}\u{1174}\u{11AF}"),
    ("\u{B74D}", "\u{B74D}", "\u{1104}\u{1174}\u{11B0}", "\u{B74D}", "\u{1104}\u{1174}\u{11B0}"),
    ("\u{B74E}", "\u{B74E}", "\u{1104}\u{1174}\u{11B1}", "\u{B74E}", "\u{1104}\u{1174}\u{11B1}"),
    ("\u{B74F}", "\u{B74F}", "\u{1104}\u{1174}\u{11B2}", "\u{B74F}", "\u{1104}\u{1174}\u{11B2}"),
    ("\u{B750}", "\u{B750}", "\u{1104}\u{1174}\u{11B3}", "\u{B750}", "\u{1104}\u{1174}\u{11B3}"),
    ("\u{B751}", "\u{B751}", "\u{1104}\u{1174}\u{11B4}", "\u{B751}", "\u{1104}\u{1174}\u{11B4}"),
    ("\u{B752}", "\u{B752}", "\u{1104}\u{1174}\u{11B5}", "\u{B752}", "\u{1104}\u{1174}\u{11B5}"),
    ("\u{B753}", "\u{B753}", "\u{1104}\u{1174}\u{11B6}", "\u{B753}", "\u{1104}\u{1174}\u{11B6}"),
    ("\u{B754}", "\u{B754}", "\u{1104}\u{1174}\u{11B7}", "\u{B754}", "\u{1104}\u{1174}\u{11B7}"),
    ("\u{B755}", "\u{B755}", "\u{1104}\u{1174}\u{11B8}", "\u{B755}", "\u{1104}\u{1174}\u{11B8}"),
    ("\u{B756}", "\u{B756}", "\u{1104}\u{1174}\u{11B9}", "\u{B756}", "\u{1104}\u{1174}\u{11B9}"),
    ("\u{B757}", "\u{B757}", "\u{1104}\u{1174}\u{11BA}", "\u{B757}", "\u{1104}\u{1174}\u{11BA}"),
    ("\u{B758}", "\u{B758}", "\u{1104}\u{1174}\u{11BB}", "\u{B758}", "\u{1104}\u{1174}\u{11BB}"),
    ("\u{B759}", "\u{B759}", "\u{1104}\u{1174}\u{11BC}", "\u{B759}", "\u{1104}\u{1174}\u{11BC}"),
    ("\u{B75A}", "\u{B75A}", "\u{1104}\u{1174}\u{11BD}", "\u{B75A}", "\u{1104}\u{1174}\u{11BD}"),
    ("\u{B75B}", "\u{B75B}", "\u{1104}\u{1174}\u{11BE}", "\u{B75B}", "\u{1104}\u{1174}\u{11BE}"),
    ("\u{B75C}", "\u{B75C}", "\u{1104}\u{1174}\u{11BF}", "\u{B75C}", "\u{1104}\u{1174}\u{11BF}"),
    ("\u{B75D}", "\u{B75D}", "\u{1104}\u{1174}\u{11C0}", "\u{B75D}", "\u{1104}\u{1174}\u{11C0}"),
    ("\u{B75E}", "\u{B75E}", "\u{1104}\u{1174}\u{11C1}", "\u{B75E}", "\u{1104}\u{1174}\u{11C1}"),
    ("\u{B75F}", "\u{B75F}", "\u{1104}\u{1174}\u{11C2}", "\u{B75F}", "\u{1104}\u{1174}\u{11C2}"),
    ("\u{B760}", "\u{B760}", "\u{1104}\u{1175}", "\u{B760}", "\u{1104}\u{1175}"),
    ("\u{B761}", "\u{B761}", "\u{1104}\u{1175}\u{11A8}", "\u{B761}", "\u{1104}\u{1175}\u{11A8}"),
    ("\u{B762}", "\u{B762}", "\u{1104}\u{1175}\u{11A9}", "\u{B762}", "\u{1104}\u{1175}\u{11A9}"),
    ("\u{B763}", "\u{B763}", "\u{1104}\u{1175}\u{11AA}", "\u{B763}", "\u{1104}\u{1175}\u{11AA}"),
    ("\u{B764}", "\u{B764}", "\u{1104}\u{1175}\u{11AB}", "\u{B764}", "\u{1104}\u{1175}\u{11AB}"),
    ("\u{B765}", "\u{B765}", "\u{1104}\u{1175}\u{11AC}", "\u{B765}", "\u{1104}\u{1175}\u{11AC}"),
    ("\u{B766}", "\u{B766}", "\u{1104}\u{1175}\u{11AD}", "\u{B766}", "\u{1104}\u{1175}\u{11AD}"),
    ("\u{B767}", "\u{B767}", "\u{1104}\u{1175}\u{11AE}", "\u{B767}", "\u{1104}\u{1175}\u{11AE}"),
    ("\u{B768}", "\u{B768}", "\u{1104}\u{1175}\u{11AF}", "\u{B768}", "\u{1104}\u{1175}\u{11AF}"),
    ("\u{B769}", "\u{B769}", "\u{1104}\u{1175}\u{11B0}", "\u{B769}", "\u{1104}\u{1175}\u{11B0}"),
    ("\u{B76A}", "\u{B76A}", "\u{1104}\u{1175}\u{11B1}", "\u{B76A}", "\u{1104}\u{1175}\u{11B1}"),
    ("\u{B76B}", "\u{B76B}", "\u{1104}\u{1175}\u{11B2}", "\u{B76B}", "\u{1104}\u{1175}\u{11B2}"),
    ("\u{B76C}", "\u{B76C}", "\u{1104}\u{1175}\u{11B3}", "\u{B76C}", "\u{1104}\u{1175}\u{11B3}"),
    ("\u{B76D}", "\u{B76D}", "\u{1104}\u{1175}\u{11B4}", "\u{B76D}", "\u{1104}\u{1175}\u{11B4}"),
    ("\u{B76E}", "\u{B76E}", "\u{1104}\u{1175}\u{11B5}", "\u{B76E}", "\u{1104}\u{1175}\u{11B5}"),
    ("\u{B76F}", "\u{B76F}", "\u{1104}\u{1175}\u{11B6}", "\u{B76F}", "\u{1104}\u{1175}\u{11B6}"),
    ("\u{B770}", "\u{B770}", "\u{1104}\u{1175}\u{11B7}", "\u{B770}", "\u{1104}\u{1175}\u{11B7}"),
    ("\u{B771}", "\u{B771}", "\u{1104}\u{1175}\u{11B8}", "\u{B771}", "\u{1104}\u{1175}\u{11B8}"),
    ("\u{B772}", "\u{B772}", "\u{1104}\u{1175}\u{11B9}", "\u{B772}", "\u{1104}\u{1175}\u{11B9}"),
    ("\u{B773}", "\u{B773}", "\u{1104}\u{1175}\u{11BA}", "\u{B773}", "\u{1104}\u{1175}\u{11BA}"),
    ("\u{B774}", "\u{B774}", "\u{1104}\u{1175}\u{11BB}", "\u{B774}", "\u{1104}\u{1175}\u{11BB}"),
    ("\u{B775}", "\u{B775}", "\u{1104}\u{1175}\u{11BC}", "\u{B775}", "\u{1104}\u{1175}\u{11BC}"),
    ("\u{B776}", "\u{B776}", "\u{1104}\u{1175}\u{11BD}", "\u{B776}", "\u{1104}\u{1175}\u{11BD}"),
    ("\u{B777}", "\u{B777}", "\u{1104}\u{1175}\u{11BE}", "\u{B777}", "\u{1104}\u{1175}\u{11BE}"),
    ("\u{B778}", "\u{B778}", "\u{1104}\u{1175}\u{11BF}", "\u{B778}", "\u{1104}\u{1175}\u{11BF}"),
    ("\u{B779}", "\u{B779}", "\u{1104}\u{1175}\u{11C0}", "\u{B779}", "\u{1104}\u{1175}\u{11C0}"),
    ("\u{B77A}", "\u{B77A}", "\u{1104}\u{1175}\u{11C1}", "\u{B77A}", "\u{1104}\u{1175}\u{11C1}"),
    ("\u{B77B}", "\u{B77B}", "\u{1104}\u{1175}\u{11C2}", "\u{B77B}", "\u{1104}\u{1175}\u{11C2}"),
    ("\u{B77C}", "\u{B77C}", "\u{1105}\u{1161}", "\u{B77C}", "\u{1105}\u{1161}"),
    ("\u{B77D}", "\u{B77D}", "\u{1105}\u{1161}\u{11A8}", "\u{B77D}", "\u{1105}\u{1161}\u{11A8}"),
    ("\u{B77E}", "\u{B77E}", "\u{1105}\u{1161}\u{11A9}", "\u{B77E}", "\u{1105}\u{1161}\u{11A9}"),
    ("\u{B77F}", "\u{B77F}", "\u{1105}\u{1161}\u{11AA}", "\u{B77F}", "\u{1105}\u{1161}\u{11AA}"),
    ("\u{B780}", "\u{B780}", "\u{1105}\u{1161}\u{11AB}", "\u{B780}", "\u{1105}\u{1161}\u{11AB}"),
    ("\u{B781}", "\u{B781}", "\u{1105}\u{1161}\u{11AC}", "\u{B781}", "\u{1105}\u{1161}\u{11AC}"),
    ("\u{B782}", "\u{B782}", "\u{1105}\u{1161}\u{11AD}", "\u{B782}", "\u{1105}\u{1161}\u{11AD}"),
    ("\u{B783}", "\u{B783}", "\u{1105}\u{1161}\u{11AE}", "\u{B783}", "\u{1105}\u{1161}\u{11AE}"),
    ("\u{B784}", "\u{B784}", "\u{1105}\u{1161}\u{11AF}", "\u{B784}", "\u{1105}\u{1161}\u{11AF}"),
    ("\u{B785}", "\u{B785}", "\u{1105}\u{1161}\u{11B0}", "\u{B785}", "\u{1105}\u{1161}\u{11B0}"),
    ("\u{B786}", "\u{B786}", "\u{1105}\u{1161}\u{11B1}", "\u{B786}", "\u{1105}\u{1161}\u{11B1}"),
    ("\u{B787}", "\u{B787}", "\u{1105}\u{1161}\u{11B2}", "\u{B787}", "\u{1105}\u{1161}\u{11B2}"),
    ("\u{B788}", "\u{B788}", "\u{1105}\u{1161}\u{11B3}", "\u{B788}", "\u{1105}\u{1161}\u{11B3}"),
    ("\u{B789}", "\u{B789}", "\u{1105}\u{1161}\u{11B4}", "\u{B789}", "\u{1105}\u{1161}\u{11B4}"),
    ("\u{B78A}", "\u{B78A}", "\u{1105}\u{1161}\u{11B5}", "\u{B78A}", "\u{1105}\u{1161}\u{11B5}"),
    ("\u{B78B}", "\u{B78B}", "\u{1105}\u{1161}\u{11B6}", "\u{B78B}", "\u{1105}\u{1161}\u{11B6}"),
    ("\u{B78C}", "\u{B78C}", "\u{1105}\u{1161}\u{11B7}", "\u{B78C}", "\u{1105}\u{1161}\u{11B7}"),
    ("\u{B78D}", "\u{B78D}", "\u{1105}\u{1161}\u{11B8}", "\u{B78D}", "\u{1105}\u{1161}\u{11B8}"),
    ("\u{B78E}", "\u{B78E}", "\u{1105}\u{1161}\u{11B9}", "\u{B78E}", "\u{1105}\u{1161}\u{11B9}"),
    ("\u{B78F}", "\u{B78F}", "\u{1105}\u{1161}\u{11BA}", "\u{B78F}", "\u{1105}\u{1161}\u{11BA}"),
    ("\u{B790}", "\u{B790}", "\u{1105}\u{1161}\u{11BB}", "\u{B790}", "\u{1105}\u{1161}\u{11BB}"),
    ("\u{B791}", "\u{B791}", "\u{1105}\u{1161}\u{11BC}", "\u{B791}", "\u{1105}\u{1161}\u{11BC}"),
    ("\u{B792}", "\u{B792}", "\u{1105}\u{1161}\u{11BD}", "\u{B792}", "\u{1105}\u{1161}\u{11BD}"),
    ("\u{B793}", "\u{B793}", "\u{1105}\u{1161}\u{11BE}", "\u{B793}", "\u{1105}\u{1161}\u{11BE}"),
    ("\u{B794}", "\u{B794}", "\u{1105}\u{1161}\u{11BF}", "\u{B794}", "\u{1105}\u{1161}\u{11BF}"),
    ("\u{B795}", "\u{B795}", "\u{1105}\u{1161}\u{11C0}", "\u{B795}", "\u{1105}\u{1161}\u{11C0}"),
    ("\u{B796}", "\u{B796}", "\u{1105}\u{1161}\u{11C1}", "\u{B796}", "\u{1105}\u{1161}\u{11C1}"),
    ("\u{B797}", "\u{B797}", "\u{1105}\u{1161}\u{11C2}", "\u{B797}", "\u{1105}\u{1161}\u{11C2}"),
    ("\u{B798}", "\u{B798}", "\u{1105}\u{1162}", "\u{B798}", "\u{1105}\u{1162}"),
    ("\u{B799}", "\u{B799}", "\u{1105}\u{1162}\u{11A8}", "\u{B799}", "\u{1105}\u{1162}\u{11A8}"),
    ("\u{B79A}", "\u{B79A}", "\u{1105}\u{1162}\u{11A9}", "\u{B79A}", "\u{1105}\u{1162}\u{11A9}"),
    ("\u{B79B}", "\u{B79B}", "\u{1105}\u{1162}\u{11AA}", "\u{B79B}", "\u{1105}\u{1162}\u{11AA}"),
    ("\u{B79C}", "\u{B79C}", "\u{1105}\u{1162}\u{11AB}", "\u{B79C}", "\u{1105}\u{1162}\u{11AB}"),
    ("\u{B79D}", "\u{B79D}", "\u{1105}\u{1162}\u{11AC}", "\u{B79D}", "\u{1105}\u{1162}\u{11AC}"),
    ("\u{B79E}", "\u{B79E}", "\u{1105}\u{1162}\u{11AD}", "\u{B79E}", "\u{1105}\u{1162}\u{11AD}"),
    ("\u{B79F}", "\u{B79F}", "\u{1105}\u{1162}\u{11AE}", "\u{B79F}", "\u{1105}\u{1162}\u{11AE}"),
    ("\u{B7A0}", "\u{B7A0}", "\u{1105}\u{1162}\u{11AF}", "\u{B7A0}", "\u{1105}\u{1162}\u{11AF}"),
    ("\u{B7A1}", "\u{B7A1}", "\u{1105}\u{1162}\u{11B0}", "\u{B7A1}", "\u{1105}\u{1162}\u{11B0}"),
    ("\u{B7A2}", "\u{B7A2}", "\u{1105}\u{1162}\u{11B1}", "\u{B7A2}", "\u{1105}\u{1162}\u{11B1}"),
    ("\u{B7A3}", "\u{B7A3}", "\u{1105}\u{1162}\u{11B2}", "\u{B7A3}", "\u{1105}\u{1162}\u{11B2}"),
    ("\u{B7A4}", "\u{B7A4}", "\u{1105}\u{1162}\u{11B3}", "\u{B7A4}", "\u{1105}\u{1162}\u{11B3}"),
    ("\u{B7A5}", "\u{B7A5}", "\u{1105}\u{1162}\u{11B4}", "\u{B7A5}", "\u{1105}\u{1162}\u{11B4}"),
    ("\u{B7A6}", "\u{B7A6}", "\u{1105}\u{1162}\u{11B5}", "\u{B7A6}", "\u{1105}\u{1162}\u{11B5}"),
    ("\u{B7A7}", "\u{B7A7}", "\u{1105}\u{1162}\u{11B6}", "\u{B7A7}", "\u{1105}\u{1162}\u{11B6}"),
    ("\u{B7A8}", "\u{B7A8}", "\u{1105}\u{1162}\u{11B7}", "\u{B7A8}", "\u{1105}\u{1162}\u{11B7}"),
    ("\u{B7A9}", "\u{B7A9}", "\u{1105}\u{1162}\u{11B8}", "\u{B7A9}", "\u{1105}\u{1162}\u{11B8}"),
    ("\u{B7AA}", "\u{B7AA}", "\u{1105}\u{1162}\u{11B9}", "\u{B7AA}", "\u{1105}\u{1162}\u{11B9}"),
    ("\u{B7AB}", "\u{B7AB}", "\u{1105}\u{1162}\u{11BA}", "\u{B7AB}", "\u{1105}\u{1162}\u{11BA}"),
    ("\u{B7AC}", "\u{B7AC}", "\u{1105}\u{1162}\u{11BB}", "\u{B7AC}", "\u{1105}\u{1162}\u{11BB}"),
    ("\u{B7AD}", "\u{B7AD}", "\u{1105}\u{1162}\u{11BC}", "\u{B7AD}", "\u{1105}\u{1162}\u{11BC}"),
    ("\u{B7AE}", "\u{B7AE}", "\u{1105}\u{1162}\u{11BD}", "\u{B7AE}", "\u{1105}\u{1162}\u{11BD}"),
    ("\u{B7AF}", "\u{B7AF}", "\u{1105}\u{1162}\u{11BE}", "\u{B7AF}", "\u{1105}\u{1162}\u{11BE}"),
    ("\u{B7B0}", "\u{B7B0}", "\u{1105}\u{1162}\u{11BF}", "\u{B7B0}", "\u{1105}\u{1162}\u{11BF}"),
    ("\u{B7B1}", "\u{B7B1}", "\u{1105}\u{1162}\u{11C0}", "\u{B7B1}", "\u{1105}\u{1162}\u{11C0}"),
    ("\u{B7B2}", "\u{B7B2}", "\u{1105}\u{1162}\u{11C1}", "\u{B7B2}", "\u{1105}\u{1162}\u{11C1}"),
    ("\u{B7B3}", "\u{B7B3}", "\u{1105}\u{1162}\u{11C2}", "\u{B7B3}", "\u{1105}\u{1162}\u{11C2}"),
    ("\u{B7B4}", "\u{B7B4}", "\u{1105}\u{1163}", "\u{B7B4}", "\u{1105}\u{1163}"),
    ("\u{B7B5}", "\u{B7B5}", "\u{1105}\u{1163}\u{11A8}", "\u{B7B5}", "\u{1105}\u{1163}\u{11A8}"),
    ("\u{B7B6}", "\u{B7B6}", "\u{1105}\u{1163}\u{11A9}", "\u{B7B6}", "\u{1105}\u{1163}\u{11A9}"),
    ("\u{B7B7}", "\u{B7B7}", "\u{1105}\u{1163}\u{11AA}", "\u{B7B7}", "\u{1105}\u{1163}\u{11AA}"),
    ("\u{B7B8}", "\u{B7B8}", "\u{1105}\u{1163}\u{11AB}", "\u{B7B8}", "\u{1105}\u{1163}\u{11AB}"),
    ("\u{B7B9}", "\u{B7B9}", "\u{1105}\u{1163}\u{11AC}", "\u{B7B9}", "\u{1105}\u{1163}\u{11AC}"),
    ("\u{B7BA}", "\u{B7BA}", "\u{1105}\u{1163}\u{11AD}", "\u{B7BA}", "\u{1105}\u{1163}\u{11AD}"),
    ("\u{B7BB}", "\u{B7BB}", "\u{1105}\u{1163}\u{11AE}", "\u{B7BB}", "\u{1105}\u{1163}\u{11AE}"),
    ("\u{B7BC}", "\u{B7BC}", "\u{1105}\u{1163}\u{11AF}", "\u{B7BC}", "\u{1105}\u{1163}\u{11AF}"),
    ("\u{B7BD}", "\u{B7BD}", "\u{1105}\u{1163}\u{11B0}", "\u{B7BD}", "\u{1105}\u{1163}\u{11B0}"),
    ("\u{B7BE}", "\u{B7BE}", "\u{1105}\u{1163}\u{11B1}", "\u{B7BE}", "\u{1105}\u{1163}\u{11B1}"),
    ("\u{B7BF}", "\u{B7BF}", "\u{1105}\u{1163}\u{11B2}", "\u{B7BF}", "\u{1105}\u{1163}\u{11B2}"),
    ("\u{B7C0}", "\u{B7C0}", "\u{1105}\u{1163}\u{11B3}", "\u{B7C0}", "\u{1105}\u{1163}\u{11B3}"),
    ("\u{B7C1}", "\u{B7C1}", "\u{1105}\u{1163}\u{11B4}", "\u{B7C1}", "\u{1105}\u{1163}\u{11B4}"),
    ("\u{B7C2}", "\u{B7C2}", "\u{1105}\u{1163}\u{11B5}", "\u{B7C2}", "\u{1105}\u{1163}\u{11B5}"),
    ("\u{B7C3}", "\u{B7C3}", "\u{1105}\u{1163}\u{11B6}", "\u{B7C3}", "\u{1105}\u{1163}\u{11B6}"),
    ("\u{B7C4}", "\u{B7C4}", "\u{1105}\u{1163}\u{11B7}", "\u{B7C4}", "\u{1105}\u{1163}\u{11B7}"),
    ("\u{B7C5}", "\u{B7C5}", "\u{1105}\u{1163}\u{11B8}", "\u{B7C5}", "\u{1105}\u{1163}\u{11B8}"),
    ("\u{B7C6}", "\u{B7C6}", "\u{1105}\u{1163}\u{11B9}", "\u{B7C6}", "\u{1105}\u{1163}\u{11B9}"),
    ("\u{B7C7}", "\u{B7C7}", "\u{1105}\u{1163}\u{11BA}", "\u{B7C7}", "\u{1105}\u{1163}\u{11BA}"),
    ("\u{B7C8}", "\u{B7C8}", "\u{1105}\u{1163}\u{11BB}", "\u{B7C8}", "\u{1105}\u{1163}\u{11BB}"),
    ("\u{B7C9}", "\u{B7C9}", "\u{1105}\u{1163}\u{11BC}", "\u{B7C9}", "\u{1105}\u{1163}\u{11BC}"),
    ("\u{B7CA}", "\u{B7CA}", "\u{1105}\u{1163}\u{11BD}", "\u{B7CA}", "\u{1105}\u{1163}\u{11BD}"),
    ("\u{B7CB}", "\u{B7CB}", "\u{1105}\u{1163}\u{11BE}", "\u{B7CB}", "\u{1105}\u{1163}\u{11BE}"),
    ("\u{B7CC}", "\u{B7CC}", "\u{1105}\u{1163}\u{11BF}", "\u{B7CC}", "\u{1105}\u{1163}\u{11BF}"),
    ("\u{B7CD}", "\u{B7CD}", "\u{1105}\u{1163}\u{11C0}", "\u{B7CD}", "\u{1105}\u{1163}\u{11C0}"),
    ("\u{B7CE}", "\u{B7CE}", "\u{1105}\u{1163}\u{11C1}", "\u{B7CE}", "\u{1105}\u{1163}\u{11C1}"),
    ("\u{B7CF}", "\u{B7CF}", "\u{1105}\u{1163}\u{11C2}", "\u{B7CF}", "\u{1105}\u{1163}\u{11C2}"),
    ("\u{B7D0}", "\u{B7D0}", "\u{1105}\u{1164}", "\u{B7D0}", "\u{1105}\u{1164}"),
    ("\u{B7D1}", "\u{B7D1}", "\u{1105}\u{1164}\u{11A8}", "\u{B7D1}", "\u{1105}\u{1164}\u{11A8}"),
    ("\u{B7D2}", "\u{B7D2}", "\u{1105}\u{1164}\u{11A9}", "\u{B7D2}", "\u{1105}\u{1164}\u{11A9}"),
    ("\u{B7D3}", "\u{B7D3}", "\u{1105}\u{1164}\u{11AA}", "\u{B7D3}", "\u{1105}\u{1164}\u{11AA}"),
    ("\u{B7D4}", "\u{B7D4}", "\u{1105}\u{1164}\u{11AB}", "\u{B7D4}", "\u{1105}\u{1164}\u{11AB}"),
    ("\u{B7D5}", "\u{B7D5}", "\u{1105}\u{1164}\u{11AC}", "\u{B7D5}", "\u{1105}\u{1164}\u{11AC}"),
    ("\u{B7D6}", "\u{B7D6}", "\u{1105}\u{1164}\u{11AD}", "\u{B7D6}", "\u{1105}\u{1164}\u{11AD}"),
    ("\u{B7D7}", "\u{B7D7}", "\u{1105}\u{1164}\u{11AE}", "\u{B7D7}", "\u{1105}\u{1164}\u{11AE}"),
    ("\u{B7D8}", "\u{B7D8}", "\u{1105}\u{1164}\u{11AF}", "\u{B7D8}", "\u{1105}\u{1164}\u{11AF}"),
    ("\u{B7D9}", "\u{B7D9}", "\u{1105}\u{1164}\u{11B0}", "\u{B7D9}", "\u{1105}\u{1164}\u{11B0}"),
    ("\u{B7DA}", "\u{B7DA}", "\u{1105}\u{1164}\u{11B1}", "\u{B7DA}", "\u{1105}\u{1164}\u{11B1}"),
    ("\u{B7DB}", "\u{B7DB}", "\u{1105}\u{1164}\u{11B2}", "\u{B7DB}", "\u{1105}\u{1164}\u{11B2}"),
    ("\u{B7DC}", "\u{B7DC}", "\u{1105}\u{1164}\u{11B3}", "\u{B7DC}", "\u{1105}\u{1164}\u{11B3}"),
    ("\u{B7DD}", "\u{B7DD}", "\u{1105}\u{1164}\u{11B4}", "\u{B7DD}", "\u{1105}\u{1164}\u{11B4}"),
    ("\u{B7DE}", "\u{B7DE}", "\u{1105}\u{1164}\u{11B5}", "\u{B7DE}", "\u{1105}\u{1164}\u{11B5}"),
    ("\u{B7DF}", "\u{B7DF}", "\u{1105}\u{1164}\u{11B6}", "\u{B7DF}", "\u{1105}\u{1164}\u{11B6}"),
    ("\u{B7E0}", "\u{B7E0}", "\u{1105}\u{1164}\u{11B7}", "\u{B7E0}", "\u{1105}\u{1164}\u{11B7}"),
    ("\u{B7E1}", "\u{B7E1}", "\u{1105}\u{1164}\u{11B8}", "\u{B7E1}", "\u{1105}\u{1164}\u{11B8}"),
    ("\u{B7E2}", "\u{B7E2}", "\u{1105}\u{1164}\u{11B9}", "\u{B7E2}", "\u{1105}\u{1164}\u{11B9}"),
    ("\u{B7E3}", "\u{B7E3}", "\u{1105}\u{1164}\u{11BA}", "\u{B7E3}", "\u{1105}\u{1164}\u{11BA}"),
    ("\u{B7E4}", "\u{B7E4}", "\u{1105}\u{1164}\u{11BB}", "\u{B7E4}", "\u{1105}\u{1164}\u{11BB}"),
    ("\u{B7E5}", "\u{B7E5}", "\u{1105}\u{1164}\u{11BC}", "\u{B7E5}", "\u{1105}\u{1164}\u{11BC}"),
    ("\u{B7E6}", "\u{B7E6}", "\u{1105}\u{1164}\u{11BD}", "\u{B7E6}", "\u{1105}\u{1164}\u{11BD}"),
    ("\u{B7E7}", "\u{B7E7}", "\u{1105}\u{1164}\u{11BE}", "\u{B7E7}", "\u{1105}\u{1164}\u{11BE}"),
    ("\u{B7E8}", "\u{B7E8}", "\u{1105}\u{1164}\u{11BF}", "\u{B7E8}", "\u{1105}\u{1164}\u{11BF}"),
    ("\u{B7E9}", "\u{B7E9}", "\u{1105}\u{1164}\u{11C0}", "\u{B7E9}", "\u{1105}\u{1164}\u{11C0}"),
    ("\u{B7EA}", "\u{B7EA}", "\u{1105}\u{1164}\u{11C1}", "\u{B7EA}", "\u{1105}\u{1164}\u{11C1}"),
    ("\u{B7EB}", "\u{B7EB}", "\u{1105}\u{1164}\u{11C2}", "\u{B7EB}", "\u{1105}\u{1164}\u{11C2}"),
    ("\u{B7EC}", "\u{B7EC}", "\u{1105}\u{1165}", "\u{B7EC}", "\u{1105}\u{1165}"),
    ("\u{B7ED}", "\u{B7ED}", "\u{1105}\u{1165}\u{11A8}", "\u{B7ED}", "\u{1105}\u{1165}\u{11A8}"),
    ("\u{B7EE}", "\u{B7EE}", "\u{1105}\u{1165}\u{11A9}", "\u{B7EE}", "\u{1105}\u{1165}\u{11A9}"),
    ("\u{B7EF}", "\u{B7EF}", "\u{1105}\u{1165}\u{11AA}", "\u{B7EF}", "\u{1105}\u{1165}\u{11AA}"),
    ("\u{B7F0}", "\u{B7F0}", "\u{1105}\u{1165}\u{11AB}", "\u{B7F0}", "\u{1105}\u{1165}\u{11AB}"),
    ("\u{B7F1}", "\u{B7F1}", "\u{1105}\u{1165}\u{11AC}", "\u{B7F1}", "\u{1105}\u{1165}\u{11AC}"),
    ("\u{B7F2}", "\u{B7F2}", "\u{1105}\u{1165}\u{11AD}", "\u{B7F2}", "\u{1105}\u{1165}\u{11AD}"),
    ("\u{B7F3}", "\u{B7F3}", "\u{1105}\u{1165}\u{11AE}", "\u{B7F3}", "\u{1105}\u{1165}\u{11AE}"),
    ("\u{B7F4}", "\u{B7F4}", "\u{1105}\u{1165}\u{11AF}", "\u{B7F4}", "\u{1105}\u{1165}\u{11AF}"),
    ("\u{B7F5}", "\u{B7F5}", "\u{1105}\u{1165}\u{11B0}", "\u{B7F5}", "\u{1105}\u{1165}\u{11B0}"),
    ("\u{B7F6}", "\u{B7F6}", "\u{1105}\u{1165}\u{11B1}", "\u{B7F6}", "\u{1105}\u{1165}\u{11B1}"),
    ("\u{B7F7}", "\u{B7F7}", "\u{1105}\u{1165}\u{11B2}", "\u{B7F7}", "\u{1105}\u{1165}\u{11B2}"),
    ("\u{B7F8}", "\u{B7F8}", "\u{1105}\u{1165}\u{11B3}", "\u{B7F8}", "\u{1105}\u{1165}\u{11B3}"),
    ("\u{B7F9}", "\u{B7F9}", "\u{1105}\u{1165}\u{11B4}", "\u{B7F9}", "\u{1105}\u{1165}\u{11B4}"),
    ("\u{B7FA}", "\u{B7FA}", "\u{1105}\u{1165}\u{11B5}", "\u{B7FA}", "\u{1105}\u{1165}\u{11B5}"),
    ("\u{B7FB}", "\u{B7FB}", "\u{1105}\u{1165}\u{11B6}", "\u{B7FB}", "\u{1105}\u{1165}\u{11B6}"),
    ("\u{B7FC}", "\u{B7FC}", "\u{1105}\u{1165}\u{11B7}", "\u{B7FC}", "\u{1105}\u{1165}\u{11B7}"),
    ("\u{B7FD}", "\u{B7FD}", "\u{1105}\u{1165}\u{11B8}", "\u{B7FD}", "\u{1105}\u{1165}\u{11B8}"),
    ("\u{B7FE}", "\u{B7FE}", "\u{1105}\u{1165}\u{11B9}", "\u{B7FE}", "\u{1105}\u{1165}\u{11B9}"),
    ("\u{B7FF}", "\u{B7FF}", "\u{1105}\u{1165}\u{11BA}", "\u{B7FF}", "\u{1105}\u{1165}\u{11BA}"),
    ("\u{B800}", "\u{B800}", "\u{1105}\u{1165}\u{11BB}", "\u{B800}", "\u{1105}\u{1165}\u{11BB}"),
    ("\u{B801}", "\u{B801}", "\u{1105}\u{1165}\u{11BC}", "\u{B801}", "\u{1105}\u{1165}\u{11BC}"),
    ("\u{B802}", "\u{B802}", "\u{1105}\u{1165}\u{11BD}", "\u{B802}", "\u{1105}\u{1165}\u{11BD}"),
    ("\u{B803}", "\u{B803}", "\u{1105}\u{1165}\u{11BE}", "\u{B803}", "\u{1105}\u{1165}\u{11BE}"),
    ("\u{B804}", "\u{B804}", "\u{1105}\u{1165}\u{11BF}", "\u{B804}", "\u{1105}\u{1165}\u{11BF}"),
    ("\u{B805}", "\u{B805}", "\u{1105}\u{1165}\u{11C0}", "\u{B805}", "\u{1105}\u{1165}\u{11C0}"),
    ("\u{B806}", "\u{B806}", "\u{1105}\u{1165}\u{11C1}", "\u{B806}", "\u{1105}\u{1165}\u{11C1}"),
    ("\u{B807}", "\u{B807}", "\u{1105}\u{1165}\u{11C2}", "\u{B807}", "\u{1105}\u{1165}\u{11C2}"),
    ("\u{B808}", "\u{B808}", "\u{1105}\u{1166}", "\u{B808}", "\u{1105}\u{1166}"),
    ("\u{B809}", "\u{B809}", "\u{1105}\u{1166}\u{11A8}", "\u{B809}", "\u{1105}\u{1166}\u{11A8}"),
    ("\u{B80A}", "\u{B80A}", "\u{1105}\u{1166}\u{11A9}", "\u{B80A}", "\u{1105}\u{1166}\u{11A9}"),
    ("\u{B80B}", "\u{B80B}", "\u{1105}\u{1166}\u{11AA}", "\u{B80B}", "\u{1105}\u{1166}\u{11AA}"),
    ("\u{B80C}", "\u{B80C}", "\u{1105}\u{1166}\u{11AB}", "\u{B80C}", "\u{1105}\u{1166}\u{11AB}"),
    ("\u{B80D}", "\u{B80D}", "\u{1105}\u{1166}\u{11AC}", "\u{B80D}", "\u{1105}\u{1166}\u{11AC}"),
    ("\u{B80E}", "\u{B80E}", "\u{1105}\u{1166}\u{11AD}", "\u{B80E}", "\u{1105}\u{1166}\u{11AD}"),
    ("\u{B80F}", "\u{B80F}", "\u{1105}\u{1166}\u{11AE}", "\u{B80F}", "\u{1105}\u{1166}\u{11AE}"),
    ("\u{B810}", "\u{B810}", "\u{1105}\u{1166}\u{11AF}", "\u{B810}", "\u{1105}\u{1166}\u{11AF}"),
    ("\u{B811}", "\u{B811}", "\u{1105}\u{1166}\u{11B0}", "\u{B811}", "\u{1105}\u{1166}\u{11B0}"),
    ("\u{B812}", "\u{B812}", "\u{1105}\u{1166}\u{11B1}", "\u{B812}", "\u{1105}\u{1166}\u{11B1}"),
    ("\u{B813}", "\u{B813}", "\u{1105}\u{1166}\u{11B2}", "\u{B813}", "\u{1105}\u{1166}\u{11B2}"),
    ("\u{B814}", "\u{B814}", "\u{1105}\u{1166}\u{11B3}", "\u{B814}", "\u{1105}\u{1166}\u{11B3}"),
    ("\u{B815}", "\u{B815}", "\u{1105}\u{1166}\u{11B4}", "\u{B815}", "\u{1105}\u{1166}\u{11B4}"),
    ("\u{B816}", "\u{B816}", "\u{1105}\u{1166}\u{11B5}", "\u{B816}", "\u{1105}\u{1166}\u{11B5}"),
    ("\u{B817}", "\u{B817}", "\u{1105}\u{1166}\u{11B6}", "\u{B817}", "\u{1105}\u{1166}\u{11B6}"),
    ("\u{B818}", "\u{B818}", "\u{1105}\u{1166}\u{11B7}", "\u{B818}", "\u{1105}\u{1166}\u{11B7}"),
    ("\u{B819}", "\u{B819}", "\u{1105}\u{1166}\u{11B8}", "\u{B819}", "\u{1105}\u{1166}\u{11B8}"),
    ("\u{B81A}", "\u{B81A}", "\u{1105}\u{1166}\u{11B9}", "\u{B81A}", "\u{1105}\u{1166}\u{11B9}"),
    ("\u{B81B}", "\u{B81B}", "\u{1105}\u{1166}\u{11BA}", "\u{B81B}", "\u{1105}\u{1166}\u{11BA}"),
    ("\u{B81C}", "\u{B81C}", "\u{1105}\u{1166}\u{11BB}", "\u{B81C}", "\u{1105}\u{1166}\u{11BB}"),
    ("\u{B81D}", "\u{B81D}", "\u{1105}\u{1166}\u{11BC}", "\u{B81D}", "\u{1105}\u{1166}\u{11BC}"),
    ("\u{B81E}", "\u{B81E}", "\u{1105}\u{1166}\u{11BD}", "\u{B81E}", "\u{1105}\u{1166}\u{11BD}"),
    ("\u{B81F}", "\u{B81F}", "\u{1105}\u{1166}\u{11BE}", "\u{B81F}", "\u{1105}\u{1166}\u{11BE}"),
    ("\u{B820}", "\u{B820}", "\u{1105}\u{1166}\u{11BF}", "\u{B820}", "\u{1105}\u{1166}\u{11BF}"),
    ("\u{B821}", "\u{B821}", "\u{1105}\u{1166}\u{11C0}", "\u{B821}", "\u{1105}\u{1166}\u{11C0}"),
    ("\u{B822}", "\u{B822}", "\u{1105}\u{1166}\u{11C1}", "\u{B822}", "\u{1105}\u{1166}\u{11C1}"),
    ("\u{B823}", "\u{B823}", "\u{1105}\u{1166}\u{11C2}", "\u{B823}", "\u{1105}\u{1166}\u{11C2}"),
    ("\u{B824}", "\u{B824}", "\u{1105}\u{1167}", "\u{B824}", "\u{1105}\u{1167}"),
    ("\u{B825}", "\u{B825}", "\u{1105}\u{1167}\u{11A8}", "\u{B825}", "\u{1105}\u{1167}\u{11A8}"),
    ("\u{B826}", "\u{B826}", "\u{1105}\u{1167}\u{11A9}", "\u{B826}", "\u{1105}\u{1167}\u{11A9}"),
    ("\u{B827}", "\u{B827}", "\u{1105}\u{1167}\u{11AA}", "\u{B827}", "\u{1105}\u{1167}\u{11AA}"),
    ("\u{B828}", "\u{B828}", "\u{1105}\u{1167}\u{11AB}", "\u{B828}", "\u{1105}\u{1167}\u{11AB}"),
    ("\u{B829}", "\u{B829}", "\u{1105}\u{1167}\u{11AC}", "\u{B829}", "\u{1105}\u{1167}\u{11AC}"),
    ("\u{B82A}", "\u{B82A}", "\u{1105}\u{1167}\u{11AD}", "\u{B82A}", "\u{1105}\u{1167}\u{11AD}"),
    ("\u{B82B}", "\u{B82B}", "\u{1105}\u{1167}\u{11AE}", "\u{B82B}", "\u{1105}\u{1167}\u{11AE}"),
    ("\u{B82C}", "\u{B82C}", "\u{1105}\u{1167}\u{11AF}", "\u{B82C}", "\u{1105}\u{1167}\u{11AF}"),
    ("\u{B82D}", "\u{B82D}", "\u{1105}\u{1167}\u{11B0}", "\u{B82D}", "\u{1105}\u{1167}\u{11B0}"),
    ("\u{B82E}", "\u{B82E}", "\u{1105}\u{1167}\u{11B1}", "\u{B82E}", "\u{1105}\u{1167}\u{11B1}"),
    ("\u{B82F}", "\u{B82F}", "\u{1105}\u{1167}\u{11B2}", "\u{B82F}", "\u{1105}\u{1167}\u{11B2}"),
    ("\u{B830}", "\u{B830}", "\u{1105}\u{1167}\u{11B3}", "\u{B830}", "\u{1105}\u{1167}\u{11B3}"),
    ("\u{B831}", "\u{B831}", "\u{1105}\u{1167}\u{11B4}", "\u{B831}", "\u{1105}\u{1167}\u{11B4}"),
    ("\u{B832}", "\u{B832}", "\u{1105}\u{1167}\u{11B5}", "\u{B832}", "\u{1105}\u{1167}\u{11B5}"),
    ("\u{B833}", "\u{B833}", "\u{1105}\u{1167}\u{11B6}", "\u{B833}", "\u{1105}\u{1167}\u{11B6}"),
    ("\u{B834}", "\u{B834}", "\u{1105}\u{1167}\u{11B7}", "\u{B834}", "\u{1105}\u{1167}\u{11B7}"),
    ("\u{B835}", "\u{B835}", "\u{1105}\u{1167}\u{11B8}", "\u{B835}", "\u{1105}\u{1167}\u{11B8}"),
    ("\u{B836}", "\u{B836}", "\u{1105}\u{1167}\u{11B9}", "\u{B836}", "\u{1105}\u{1167}\u{11B9}"),
    ("\u{B837}", "\u{B837}", "\u{1105}\u{1167}\u{11BA}", "\u{B837}", "\u{1105}\u{1167}\u{11BA}"),
    ("\u{B838}", "\u{B838}", "\u{1105}\u{1167}\u{11BB}", "\u{B838}", "\u{1105}\u{1167}\u{11BB}"),
    ("\u{B839}", "\u{B839}", "\u{1105}\u{1167}\u{11BC}", "\u{B839}", "\u{1105}\u{1167}\u{11BC}"),
    ("\u{B83A}", "\u{B83A}", "\u{1105}\u{1167}\u{11BD}", "\u{B83A}", "\u{1105}\u{1167}\u{11BD}"),
    ("\u{B83B}", "\u{B83B}", "\u{1105}\u{1167}\u{11BE}", "\u{B83B}", "\u{1105}\u{1167}\u{11BE}"),
    ("\u{B83C}", "\u{B83C}", "\u{1105}\u{1167}\u{11BF}", "\u{B83C}", "\u{1105}\u{1167}\u{11BF}"),
    ("\u{B83D}", "\u{B83D}", "\u{1105}\u{1167}\u{11C0}", "\u{B83D}", "\u{1105}\u{1167}\u{11C0}"),
    ("\u{B83E}", "\u{B83E}", "\u{1105}\u{1167}\u{11C1}", "\u{B83E}", "\u{1105}\u{1167}\u{11C1}"),
    ("\u{B83F}", "\u{B83F}", "\u{1105}\u{1167}\u{11C2}", "\u{B83F}", "\u{1105}\u{1167}\u{11C2}"),
    ("\u{B840}", "\u{B840}", "\u{1105}\u{1168}", "\u{B840}", "\u{1105}\u{1168}"),
    ("\u{B841}", "\u{B841}", "\u{1105}\u{1168}\u{11A8}", "\u{B841}", "\u{1105}\u{1168}\u{11A8}"),
    ("\u{B842}", "\u{B842}", "\u{1105}\u{1168}\u{11A9}", "\u{B842}", "\u{1105}\u{1168}\u{11A9}"),
    ("\u{B843}", "\u{B843}", "\u{1105}\u{1168}\u{11AA}", "\u{B843}", "\u{1105}\u{1168}\u{11AA}"),
    ("\u{B844}", "\u{B844}", "\u{1105}\u{1168}\u{11AB}", "\u{B844}", "\u{1105}\u{1168}\u{11AB}"),
    ("\u{B845}", "\u{B845}", "\u{1105}\u{1168}\u{11AC}", "\u{B845}", "\u{1105}\u{1168}\u{11AC}"),
    ("\u{B846}", "\u{B846}", "\u{1105}\u{1168}\u{11AD}", "\u{B846}", "\u{1105}\u{1168}\u{11AD}"),
    ("\u{B847}", "\u{B847}", "\u{1105}\u{1168}\u{11AE}", "\u{B847}", "\u{1105}\u{1168}\u{11AE}"),
    ("\u{B848}", "\u{B848}", "\u{1105}\u{1168}\u{11AF}", "\u{B848}", "\u{1105}\u{1168}\u{11AF}"),
    ("\u{B849}", "\u{B849}", "\u{1105}\u{1168}\u{11B0}", "\u{B849}", "\u{1105}\u{1168}\u{11B0}"),
    ("\u{B84A}", "\u{B84A}", "\u{1105}\u{1168}\u{11B1}", "\u{B84A}", "\u{1105}\u{1168}\u{11B1}"),
    ("\u{B84B}", "\u{B84B}", "\u{1105}\u{1168}\u{11B2}", "\u{B84B}", "\u{1105}\u{1168}\u{11B2}"),
    ("\u{B84C}", "\u{B84C}", "\u{1105}\u{1168}\u{11B3}", "\u{B84C}", "\u{1105}\u{1168}\u{11B3}"),
    ("\u{B84D}", "\u{B84D}", "\u{1105}\u{1168}\u{11B4}", "\u{B84D}", "\u{1105}\u{1168}\u{11B4}"),
    ("\u{B84E}", "\u{B84E}", "\u{1105}\u{1168}\u{11B5}", "\u{B84E}", "\u{1105}\u{1168}\u{11B5}"),
    ("\u{B84F}", "\u{B84F}", "\u{1105}\u{1168}\u{11B6}", "\u{B84F}", "\u{1105}\u{1168}\u{11B6}"),
    ("\u{B850}", "\u{B850}", "\u{1105}\u{1168}\u{11B7}", "\u{B850}", "\u{1105}\u{1168}\u{11B7}"),
    ("\u{B851}", "\u{B851}", "\u{1105}\u{1168}\u{11B8}", "\u{B851}", "\u{1105}\u{1168}\u{11B8}"),
    ("\u{B852}", "\u{B852}", "\u{1105}\u{1168}\u{11B9}", "\u{B852}", "\u{1105}\u{1168}\u{11B9}"),
    ("\u{B853}", "\u{B853}", "\u{1105}\u{1168}\u{11BA}", "\u{B853}", "\u{1105}\u{1168}\u{11BA}"),
    ("\u{B854}", "\u{B854}", "\u{1105}\u{1168}\u{11BB}", "\u{B854}", "\u{1105}\u{1168}\u{11BB}"),
    ("\u{B855}", "\u{B855}", "\u{1105}\u{1168}\u{11BC}", "\u{B855}", "\u{1105}\u{1168}\u{11BC}"),
    ("\u{B856}", "\u{B856}", "\u{1105}\u{1168}\u{11BD}", "\u{B856}", "\u{1105}\u{1168}\u{11BD}"),
    ("\u{B857}", "\u{B857}", "\u{1105}\u{1168}\u{11BE}", "\u{B857}", "\u{1105}\u{1168}\u{11BE}"),
    ("\u{B858}", "\u{B858}", "\u{1105}\u{1168}\u{11BF}", "\u{B858}", "\u{1105}\u{1168}\u{11BF}"),
    ("\u{B859}", "\u{B859}", "\u{1105}\u{1168}\u{11C0}", "\u{B859}", "\u{1105}\u{1168}\u{11C0}"),
    ("\u{B85A}", "\u{B85A}", "\u{1105}\u{1168}\u{11C1}", "\u{B85A}", "\u{1105}\u{1168}\u{11C1}"),
    ("\u{B85B}", "\u{B85B}", "\u{1105}\u{1168}\u{11C2}", "\u{B85B}", "\u{1105}\u{1168}\u{11C2}"),
    ("\u{B85C}", "\u{B85C}", "\u{1105}\u{1169}", "\u{B85C}", "\u{1105}\u{1169}"),
    ("\u{B85D}", "\u{B85D}", "\u{1105}\u{1169}\u{11A8}", "\u{B85D}", "\u{1105}\u{1169}\u{11A8}"),
    ("\u{B85E}", "\u{B85E}", "\u{1105}\u{1169}\u{11A9}", "\u{B85E}", "\u{1105}\u{1169}\u{11A9}"),
    ("\u{B85F}", "\u{B85F}", "\u{1105}\u{1169}\u{11AA}", "\u{B85F}", "\u{1105}\u{1169}\u{11AA}"),
    ("\u{B860}", "\u{B860}", "\u{1105}\u{1169}\u{11AB}", "\u{B860}", "\u{1105}\u{1169}\u{11AB}"),
    ("\u{B861}", "\u{B861}", "\u{1105}\u{1169}\u{11AC}", "\u{B861}", "\u{1105}\u{1169}\u{11AC}"),
    ("\u{B862}", "\u{B862}", "\u{1105}\u{1169}\u{11AD}", "\u{B862}", "\u{1105}\u{1169}\u{11AD}"),
    ("\u{B863}", "\u{B863}", "\u{1105}\u{1169}\u{11AE}", "\u{B863}", "\u{1105}\u{1169}\u{11AE}"),
    ("\u{B864}", "\u{B864}", "\u{1105}\u{1169}\u{11AF}", "\u{B864}", "\u{1105}\u{1169}\u{11AF}"),
    ("\u{B865}", "\u{B865}", "\u{1105}\u{1169}\u{11B0}", "\u{B865}", "\u{1105}\u{1169}\u{11B0}"),
    ("\u{B866}", "\u{B866}", "\u{1105}\u{1169}\u{11B1}", "\u{B866}", "\u{1105}\u{1169}\u{11B1}"),
    ("\u{B867}", "\u{B867}", "\u{1105}\u{1169}\u{11B2}", "\u{B867}", "\u{1105}\u{1169}\u{11B2}"),
    ("\u{B868}", "\u{B868}", "\u{1105}\u{1169}\u{11B3}", "\u{B868}", "\u{1105}\u{1169}\u{11B3}"),
    ("\u{B869}", "\u{B869}", "\u{1105}\u{1169}\u{11B4}", "\u{B869}", "\u{1105}\u{1169}\u{11B4}"),
    ("\u{B86A}", "\u{B86A}", "\u{1105}\u{1169}\u{11B5}", "\u{B86A}", "\u{1105}\u{1169}\u{11B5}"),
    ("\u{B86B}", "\u{B86B}", "\u{1105}\u{1169}\u{11B6}", "\u{B86B}", "\u{1105}\u{1169}\u{11B6}"),
    ("\u{B86C}", "\u{B86C}", "\u{1105}\u{1169}\u{11B7}", "\u{B86C}", "\u{1105}\u{1169}\u{11B7}"),
    ("\u{B86D}", "\u{B86D}", "\u{1105}\u{1169}\u{11B8}", "\u{B86D}", "\u{1105}\u{1169}\u{11B8}"),
    ("\u{B86E}", "\u{B86E}", "\u{1105}\u{1169}\u{11B9}", "\u{B86E}", "\u{1105}\u{1169}\u{11B9}"),
    ("\u{B86F}", "\u{B86F}", "\u{1105}\u{1169}\u{11BA}", "\u{B86F}", "\u{1105}\u{1169}\u{11BA}"),
    ("\u{B870}", "\u{B870}", "\u{1105}\u{1169}\u{11BB}", "\u{B870}", "\u{1105}\u{1169}\u{11BB}"),
    ("\u{B871}", "\u{B871}", "\u{1105}\u{1169}\u{11BC}", "\u{B871}", "\u{1105}\u{1169}\u{11BC}"),
    ("\u{B872}", "\u{B872}", "\u{1105}\u{1169}\u{11BD}", "\u{B872}", "\u{1105}\u{1169}\u{11BD}"),
    ("\u{B873}", "\u{B873}", "\u{1105}\u{1169}\u{11BE}", "\u{B873}", "\u{1105}\u{1169}\u{11BE}"),
    ("\u{B874}", "\u{B874}", "\u{1105}\u{1169}\u{11BF}", "\u{B874}", "\u{1105}\u{1169}\u{11BF}"),
    ("\u{B875}", "\u{B875}", "\u{1105}\u{1169}\u{11C0}", "\u{B875}", "\u{1105}\u{1169}\u{11C0}"),
    ("\u{B876}", "\u{B876}", "\u{1105}\u{1169}\u{11C1}", "\u{B876}", "\u{1105}\u{1169}\u{11C1}"),
    ("\u{B877}", "\u{B877}", "\u{1105}\u{1169}\u{11C2}", "\u{B877}", "\u{1105}\u{1169}\u{11C2}"),
    ("\u{B878}", "\u{B878}", "\u{1105}\u{116A}", "\u{B878}", "\u{1105}\u{116A}"),
    ("\u{B879}", "\u{B879}", "\u{1105}\u{116A}\u{11A8}", "\u{B879}", "\u{1105}\u{116A}\u{11A8}"),
    ("\u{B87A}", "\u{B87A}", "\u{1105}\u{116A}\u{11A9}", "\u{B87A}", "\u{1105}\u{116A}\u{11A9}"),
    ("\u{B87B}", "\u{B87B}", "\u{1105}\u{116A}\u{11AA}", "\u{B87B}", "\u{1105}\u{116A}\u{11AA}"),
    ("\u{B87C}", "\u{B87C}", "\u{1105}\u{116A}\u{11AB}", "\u{B87C}", "\u{1105}\u{116A}\u{11AB}"),
    ("\u{B87D}", "\u{B87D}", "\u{1105}\u{116A}\u{11AC}", "\u{B87D}", "\u{1105}\u{116A}\u{11AC}"),
    ("\u{B87E}", "\u{B87E}", "\u{1105}\u{116A}\u{11AD}", "\u{B87E}", "\u{1105}\u{116A}\u{11AD}"),
    ("\u{B87F}", "\u{B87F}", "\u{1105}\u{116A}\u{11AE}", "\u{B87F}", "\u{1105}\u{116A}\u{11AE}"),
    ("\u{B880}", "\u{B880}", "\u{1105}\u{116A}\u{11AF}", "\u{B880}", "\u{1105}\u{116A}\u{11AF}"),
    ("\u{B881}", "\u{B881}", "\u{1105}\u{116A}\u{11B0}", "\u{B881}", "\u{1105}\u{116A}\u{11B0}"),
    ("\u{B882}", "\u{B882}", "\u{1105}\u{116A}\u{11B1}", "\u{B882}", "\u{1105}\u{116A}\u{11B1}"),
    ("\u{B883}", "\u{B883}", "\u{1105}\u{116A}\u{11B2}", "\u{B883}", "\u{1105}\u{116A}\u{11B2}"),
    ("\u{B884}", "\u{B884}", "\u{1105}\u{116A}\u{11B3}", "\u{B884}", "\u{1105}\u{116A}\u{11B3}"),
    ("\u{B885}", "\u{B885}", "\u{1105}\u{116A}\u{11B4}", "\u{B885}", "\u{1105}\u{116A}\u{11B4}"),
    ("\u{B886}", "\u{B886}", "\u{1105}\u{116A}\u{11B5}", "\u{B886}", "\u{1105}\u{116A}\u{11B5}"),
    ("\u{B887}", "\u{B887}", "\u{1105}\u{116A}\u{11B6}", "\u{B887}", "\u{1105}\u{116A}\u{11B6}"),
    ("\u{B888}", "\u{B888}", "\u{1105}\u{116A}\u{11B7}", "\u{B888}", "\u{1105}\u{116A}\u{11B7}"),
    ("\u{B889}", "\u{B889}", "\u{1105}\u{116A}\u{11B8}", "\u{B889}", "\u{1105}\u{116A}\u{11B8}"),
    ("\u{B88A}", "\u{B88A}", "\u{1105}\u{116A}\u{11B9}", "\u{B88A}", "\u{1105}\u{116A}\u{11B9}"),
    ("\u{B88B}", "\u{B88B}", "\u{1105}\u{116A}\u{11BA}", "\u{B88B}", "\u{1105}\u{116A}\u{11BA}"),
    ("\u{B88C}", "\u{B88C}", "\u{1105}\u{116A}\u{11BB}", "\u{B88C}", "\u{1105}\u{116A}\u{11BB}"),
    ("\u{B88D}", "\u{B88D}", "\u{1105}\u{116A}\u{11BC}", "\u{B88D}", "\u{1105}\u{116A}\u{11BC}"),
    ("\u{B88E}", "\u{B88E}", "\u{1105}\u{116A}\u{11BD}", "\u{B88E}", "\u{1105}\u{116A}\u{11BD}"),
    ("\u{B88F}", "\u{B88F}", "\u{1105}\u{116A}\u{11BE}", "\u{B88F}", "\u{1105}\u{116A}\u{11BE}"),
    ("\u{B890}", "\u{B890}", "\u{1105}\u{116A}\u{11BF}", "\u{B890}", "\u{1105}\u{116A}\u{11BF}"),
    ("\u{B891}", "\u{B891}", "\u{1105}\u{116A}\u{11C0}", "\u{B891}", "\u{1105}\u{116A}\u{11C0}"),
    ("\u{B892}", "\u{B892}", "\u{1105}\u{116A}\u{11C1}", "\u{B892}", "\u{1105}\u{116A}\u{11C1}"),
    ("\u{B893}", "\u{B893}", "\u{1105}\u{116A}\u{11C2}", "\u{B893}", "\u{1105}\u{116A}\u{11C2}"),
    ("\u{B894}", "\u{B894}", "\u{1105}\u{116B}", "\u{B894}", "\u{1105}\u{116B}"),
    ("\u{B895}", "\u{B895}", "\u{1105}\u{116B}\u{11A8}", "\u{B895}", "\u{1105}\u{116B}\u{11A8}"),
    ("\u{B896}", "\u{B896}", "\u{1105}\u{116B}\u{11A9}", "\u{B896}", "\u{1105}\u{116B}\u{11A9}"),
    ("\u{B897}", "\u{B897}", "\u{1105}\u{116B}\u{11AA}", "\u{B897}", "\u{1105}\u{116B}\u{11AA}"),
    ("\u{B898}", "\u{B898}", "\u{1105}\u{116B}\u{11AB}", "\u{B898}", "\u{1105}\u{116B}\u{11AB}"),
    ("\u{B899}", "\u{B899}", "\u{1105}\u{116B}\u{11AC}", "\u{B899}", "\u{1105}\u{116B}\u{11AC}"),
    ("\u{B89A}", "\u{B89A}", "\u{1105}\u{116B}\u{11AD}", "\u{B89A}", "\u{1105}\u{116B}\u{11AD}"),
    ("\u{B89B}", "\u{B89B}", "\u{1105}\u{116B}\u{11AE}", "\u{B89B}", "\u{1105}\u{116B}\u{11AE}"),
    ("\u{B89C}", "\u{B89C}", "\u{1105}\u{116B}\u{11AF}", "\u{B89C}", "\u{1105}\u{116B}\u{11AF}"),
    ("\u{B89D}", "\u{B89D}", "\u{1105}\u{116B}\u{11B0}", "\u{B89D}", "\u{1105}\u{116B}\u{11B0}"),
    ("\u{B89E}", "\u{B89E}", "\u{1105}\u{116B}\u{11B1}", "\u{B89E}", "\u{1105}\u{116B}\u{11B1}"),
    ("\u{B89F}", "\u{B89F}", "\u{1105}\u{116B}\u{11B2}", "\u{B89F}", "\u{1105}\u{116B}\u{11B2}"),
    ("\u{B8A0}", "\u{B8A0}", "\u{1105}\u{116B}\u{11B3}", "\u{B8A0}", "\u{1105}\u{116B}\u{11B3}"),
    ("\u{B8A1}", "\u{B8A1}", "\u{1105}\u{116B}\u{11B4}", "\u{B8A1}", "\u{1105}\u{116B}\u{11B4}"),
    ("\u{B8A2}", "\u{B8A2}", "\u{1105}\u{116B}\u{11B5}", "\u{B8A2}", "\u{1105}\u{116B}\u{11B5}"),
    ("\u{B8A3}", "\u{B8A3}", "\u{1105}\u{116B}\u{11B6}", "\u{B8A3}", "\u{1105}\u{116B}\u{11B6}"),
    ("\u{B8A4}", "\u{B8A4}", "\u{1105}\u{116B}\u{11B7}", "\u{B8A4}", "\u{1105}\u{116B}\u{11B7}"),
    ("\u{B8A5}", "\u{B8A5}", "\u{1105}\u{116B}\u{11B8}", "\u{B8A5}", "\u{1105}\u{116B}\u{11B8}"),
    ("\u{B8A6}", "\u{B8A6}", "\u{1105}\u{116B}\u{11B9}", "\u{B8A6}", "\u{1105}\u{116B}\u{11B9}"),
    ("\u{B8A7}", "\u{B8A7}", "\u{1105}\u{116B}\u{11BA}", "\u{B8A7}", "\u{1105}\u{116B}\u{11BA}"),
    ("\u{B8A8}", "\u{B8A8}", "\u{1105}\u{116B}\u{11BB}", "\u{B8A8}", "\u{1105}\u{116B}\u{11BB}"),
    ("\u{B8A9}", "\u{B8A9}", "\u{1105}\u{116B}\u{11BC}", "\u{B8A9}", "\u{1105}\u{116B}\u{11BC}"),
    ("\u{B8AA}", "\u{B8AA}", "\u{1105}\u{116B}\u{11BD}", "\u{B8AA}", "\u{1105}\u{116B}\u{11BD}"),
    ("\u{B8AB}", "\u{B8AB}", "\u{1105}\u{116B}\u{11BE}", "\u{B8AB}", "\u{1105}\u{116B}\u{11BE}"),
    ("\u{B8AC}", "\u{B8AC}", "\u{1105}\u{116B}\u{11BF}", "\u{B8AC}", "\u{1105}\u{116B}\u{11BF}"),
    ("\u{B8AD}", "\u{B8AD}", "\u{1105}\u{116B}\u{11C0}", "\u{B8AD}", "\u{1105}\u{116B}\u{11C0}"),
    ("\u{B8AE}", "\u{B8AE}", "\u{1105}\u{116B}\u{11C1}", "\u{B8AE}", "\u{1105}\u{116B}\u{11C1}"),
    ("\u{B8AF}", "\u{B8AF}", "\u{1105}\u{116B}\u{11C2}", "\u{B8AF}", "\u{1105}\u{116B}\u{11C2}"),
    ("\u{B8B0}", "\u{B8B0}", "\u{1105}\u{116C}", "\u{B8B0}", "\u{1105}\u{116C}"),
    ("\u{B8B1}", "\u{B8B1}", "\u{1105}\u{116C}\u{11A8}", "\u{B8B1}", "\u{1105}\u{116C}\u{11A8}"),
    ("\u{B8B2}", "\u{B8B2}", "\u{1105}\u{116C}\u{11A9}", "\u{B8B2}", "\u{1105}\u{116C}\u{11A9}"),
    ("\u{B8B3}", "\u{B8B3}", "\u{1105}\u{116C}\u{11AA}", "\u{B8B3}", "\u{1105}\u{116C}\u{11AA}"),
    ("\u{B8B4}", "\u{B8B4}", "\u{1105}\u{116C}\u{11AB}", "\u{B8B4}", "\u{1105}\u{116C}\u{11AB}"),
    ("\u{B8B5}", "\u{B8B5}", "\u{1105}\u{116C}\u{11AC}", "\u{B8B5}", "\u{1105}\u{116C}\u{11AC}"),
    ("\u{B8B6}", "\u{B8B6}", "\u{1105}\u{116C}\u{11AD}", "\u{B8B6}", "\u{1105}\u{116C}\u{11AD}"),
    ("\u{B8B7}", "\u{B8B7}", "\u{1105}\u{116C}\u{11AE}", "\u{B8B7}", "\u{1105}\u{116C}\u{11AE}"),
    ("\u{B8B8}", "\u{B8B8}", "\u{1105}\u{116C}\u{11AF}", "\u{B8B8}", "\u{1105}\u{116C}\u{11AF}"),
    ("\u{B8B9}", "\u{B8B9}", "\u{1105}\u{116C}\u{11B0}", "\u{B8B9}", "\u{1105}\u{116C}\u{11B0}"),
    ("\u{B8BA}", "\u{B8BA}", "\u{1105}\u{116C}\u{11B1}", "\u{B8BA}", "\u{1105}\u{116C}\u{11B1}"),
    ("\u{B8BB}", "\u{B8BB}", "\u{1105}\u{116C}\u{11B2}", "\u{B8BB}", "\u{1105}\u{116C}\u{11B2}"),
    ("\u{B8BC}", "\u{B8BC}", "\u{1105}\u{116C}\u{11B3}", "\u{B8BC}", "\u{1105}\u{116C}\u{11B3}"),
    ("\u{B8BD}", "\u{B8BD}", "\u{1105}\u{116C}\u{11B4}", "\u{B8BD}", "\u{1105}\u{116C}\u{11B4}"),
    ("\u{B8BE}", "\u{B8BE}", "\u{1105}\u{116C}\u{11B5}", "\u{B8BE}", "\u{1105}\u{116C}\u{11B5}"),
    ("\u{B8BF}", "\u{B8BF}", "\u{1105}\u{116C}\u{11B6}", "\u{B8BF}", "\u{1105}\u{116C}\u{11B6}"),
    ("\u{B8C0}", "\u{B8C0}", "\u{1105}\u{116C}\u{11B7}", "\u{B8C0}", "\u{1105}\u{116C}\u{11B7}"),
    ("\u{B8C1}", "\u{B8C1}", "\u{1105}\u{116C}\u{11B8}", "\u{B8C1}", "\u{1105}\u{116C}\u{11B8}"),
    ("\u{B8C2}", "\u{B8C2}", "\u{1105}\u{116C}\u{11B9}", "\u{B8C2}", "\u{1105}\u{116C}\u{11B9}"),
    ("\u{B8C3}", "\u{B8C3}", "\u{1105}\u{116C}\u{11BA}", "\u{B8C3}", "\u{1105}\u{116C}\u{11BA}"),
    ("\u{B8C4}", "\u{B8C4}", "\u{1105}\u{116C}\u{11BB}", "\u{B8C4}", "\u{1105}\u{116C}\u{11BB}"),
    ("\u{B8C5}", "\u{B8C5}", "\u{1105}\u{116C}\u{11BC}", "\u{B8C5}", "\u{1105}\u{116C}\u{11BC}"),
    ("\u{B8C6}", "\u{B8C6}", "\u{1105}\u{116C}\u{11BD}", "\u{B8C6}", "\u{1105}\u{116C}\u{11BD}"),
    ("\u{B8C7}", "\u{B8C7}", "\u{1105}\u{116C}\u{11BE}", "\u{B8C7}", "\u{1105}\u{116C}\u{11BE}"),
    ("\u{B8C8}", "\u{B8C8}", "\u{1105}\u{116C}\u{11BF}", "\u{B8C8}", "\u{1105}\u{116C}\u{11BF}"),
    ("\u{B8C9}", "\u{B8C9}", "\u{1105}\u{116C}\u{11C0}", "\u{B8C9}", "\u{1105}\u{116C}\u{11C0}"),
    ("\u{B8CA}", "\u{B8CA}", "\u{1105}\u{116C}\u{11C1}", "\u{B8CA}", "\u{1105}\u{116C}\u{11C1}"),
    ("\u{B8CB}", "\u{B8CB}", "\u{1105}\u{116C}\u{11C2}", "\u{B8CB}", "\u{1105}\u{116C}\u{11C2}"),
    ("\u{B8CC}", "\u{B8CC}", "\u{1105}\u{116D}", "\u{B8CC}", "\u{1105}\u{116D}"),
    ("\u{B8CD}", "\u{B8CD}", "\u{1105}\u{116D}\u{11A8}", "\u{B8CD}", "\u{1105}\u{116D}\u{11A8}"),
    ("\u{B8CE}", "\u{B8CE}", "\u{1105}\u{116D}\u{11A9}", "\u{B8CE}", "\u{1105}\u{116D}\u{11A9}"),
    ("\u{B8CF}", "\u{B8CF}", "\u{1105}\u{116D}\u{11AA}", "\u{B8CF}", "\u{1105}\u{116D}\u{11AA}"),
    ("\u{B8D0}", "\u{B8D0}", "\u{1105}\u{116D}\u{11AB}", "\u{B8D0}", "\u{1105}\u{116D}\u{11AB}"),
    ("\u{B8D1}", "\u{B8D1}", "\u{1105}\u{116D}\u{11AC}", "\u{B8D1}", "\u{1105}\u{116D}\u{11AC}"),
    ("\u{B8D2}", "\u{B8D2}", "\u{1105}\u{116D}\u{11AD}", "\u{B8D2}", "\u{1105}\u{116D}\u{11AD}"),
    ("\u{B8D3}", "\u{B8D3}", "\u{1105}\u{116D}\u{11AE}", "\u{B8D3}", "\u{1105}\u{116D}\u{11AE}"),
    ("\u{B8D4}", "\u{B8D4}", "\u{1105}\u{116D}\u{11AF}", "\u{B8D4}", "\u{1105}\u{116D}\u{11AF}"),
    ("\u{B8D5}", "\u{B8D5}", "\u{1105}\u{116D}\u{11B0}", "\u{B8D5}", "\u{1105}\u{116D}\u{11B0}"),
    ("\u{B8D6}", "\u{B8D6}", "\u{1105}\u{116D}\u{11B1}", "\u{B8D6}", "\u{1105}\u{116D}\u{11B1}"),
    ("\u{B8D7}", "\u{B8D7}", "\u{1105}\u{116D}\u{11B2}", "\u{B8D7}", "\u{1105}\u{116D}\u{11B2}"),
    ("\u{B8D8}", "\u{B8D8}", "\u{1105}\u{116D}\u{11B3}", "\u{B8D8}", "\u{1105}\u{116D}\u{11B3}"),
    ("\u{B8D9}", "\u{B8D9}", "\u{1105}\u{116D}\u{11B4}", "\u{B8D9}", "\u{1105}\u{116D}\u{11B4}"),
    ("\u{B8DA}", "\u{B8DA}", "\u{1105}\u{116D}\u{11B5}", "\u{B8DA}", "\u{1105}\u{116D}\u{11B5}"),
    ("\u{B8DB}", "\u{B8DB}", "\u{1105}\u{116D}\u{11B6}", "\u{B8DB}", "\u{1105}\u{116D}\u{11B6}"),
    ("\u{B8DC}", "\u{B8DC}", "\u{1105}\u{116D}\u{11B7}", "\u{B8DC}", "\u{1105}\u{116D}\u{11B7}"),
    ("\u{B8DD}", "\u{B8DD}", "\u{1105}\u{116D}\u{11B8}", "\u{B8DD}", "\u{1105}\u{116D}\u{11B8}"),
    ("\u{B8DE}", "\u{B8DE}", "\u{1105}\u{116D}\u{11B9}", "\u{B8DE}", "\u{1105}\u{116D}\u{11B9}"),
    ("\u{B8DF}", "\u{B8DF}", "\u{1105}\u{116D}\u{11BA}", "\u{B8DF}", "\u{1105}\u{116D}\u{11BA}"),
    ("\u{B8E0}", "\u{B8E0}", "\u{1105}\u{116D}\u{11BB}", "\u{B8E0}", "\u{1105}\u{116D}\u{11BB}"),
    ("\u{B8E1}", "\u{B8E1}", "\u{1105}\u{116D}\u{11BC}", "\u{B8E1}", "\u{1105}\u{116D}\u{11BC}"),
    ("\u{B8E2}", "\u{B8E2}", "\u{1105}\u{116D}\u{11BD}", "\u{B8E2}", "\u{1105}\u{116D}\u{11BD}"),
    ("\u{B8E3}", "\u{B8E3}", "\u{1105}\u{116D}\u{11BE}", "\u{B8E3}", "\u{1105}\u{116D}\u{11BE}"),
    ("\u{B8E4}", "\u{B8E4}", "\u{1105}\u{116D}\u{11BF}", "\u{B8E4}", "\u{1105}\u{116D}\u{11BF}"),
    ("\u{B8E5}", "\u{B8E5}", "\u{1105}\u{116D}\u{11C0}", "\u{B8E5}", "\u{1105}\u{116D}\u{11C0}"),
    ("\u{B8E6}", "\u{B8E6}", "\u{1105}\u{116D}\u{11C1}", "\u{B8E6}", "\u{1105}\u{116D}\u{11C1}"),
    ("\u{B8E7}", "\u{B8E7}", "\u{1105}\u{116D}\u{11C2}", "\u{B8E7}", "\u{1105}\u{116D}\u{11C2}"),
    ("\u{B8E8}", "\u{B8E8}", "\u{1105}\u{116E}", "\u{B8E8}", "\u{1105}\u{116E}"),
    ("\u{B8E9}", "\u{B8E9}", "\u{1105}\u{116E}\u{11A8}", "\u{B8E9}", "\u{1105}\u{116E}\u{11A8}"),
    ("\u{B8EA}", "\u{B8EA}", "\u{1105}\u{116E}\u{11A9}", "\u{B8EA}", "\u{1105}\u{116E}\u{11A9}"),
    ("\u{B8EB}", "\u{B8EB}", "\u{1105}\u{116E}\u{11AA}", "\u{B8EB}", "\u{1105}\u{116E}\u{11AA}"),
    ("\u{B8EC}", "\u{B8EC}", "\u{1105}\u{116E}\u{11AB}", "\u{B8EC}", "\u{1105}\u{116E}\u{11AB}"),
    ("\u{B8ED}", "\u{B8ED}", "\u{1105}\u{116E}\u{11AC}", "\u{B8ED}", "\u{1105}\u{116E}\u{11AC}"),
    ("\u{B8EE}", "\u{B8EE}", "\u{1105}\u{116E}\u{11AD}", "\u{B8EE}", "\u{1105}\u{116E}\u{11AD}"),
    ("\u{B8EF}", "\u{B8EF}", "\u{1105}\u{116E}\u{11AE}", "\u{B8EF}", "\u{1105}\u{116E}\u{11AE}"),
    ("\u{B8F0}", "\u{B8F0}", "\u{1105}\u{116E}\u{11AF}", "\u{B8F0}", "\u{1105}\u{116E}\u{11AF}"),
    ("\u{B8F1}", "\u{B8F1}", "\u{1105}\u{116E}\u{11B0}", "\u{B8F1}", "\u{1105}\u{116E}\u{11B0}"),
    ("\u{B8F2}", "\u{B8F2}", "\u{1105}\u{116E}\u{11B1}", "\u{B8F2}", "\u{1105}\u{116E}\u{11B1}"),
    ("\u{B8F3}", "\u{B8F3}", "\u{1105}\u{116E}\u{11B2}", "\u{B8F3}", "\u{1105}\u{116E}\u{11B2}"),
    ("\u{B8F4}", "\u{B8F4}", "\u{1105}\u{116E}\u{11B3}", "\u{B8F4}", "\u{1105}\u{116E}\u{11B3}"),
    ("\u{B8F5}", "\u{B8F5}", "\u{1105}\u{116E}\u{11B4}", "\u{B8F5}", "\u{1105}\u{116E}\u{11B4}"),
    ("\u{B8F6}", "\u{B8F6}", "\u{1105}\u{116E}\u{11B5}", "\u{B8F6}", "\u{1105}\u{116E}\u{11B5}"),
    ("\u{B8F7}", "\u{B8F7}", "\u{1105}\u{116E}\u{11B6}", "\u{B8F7}", "\u{1105}\u{116E}\u{11B6}"),
    ("\u{B8F8}", "\u{B8F8}", "\u{1105}\u{116E}\u{11B7}", "\u{B8F8}", "\u{1105}\u{116E}\u{11B7}"),
    ("\u{B8F9}", "\u{B8F9}", "\u{1105}\u{116E}\u{11B8}", "\u{B8F9}", "\u{1105}\u{116E}\u{11B8}"),
    ("\u{B8FA}", "\u{B8FA}", "\u{1105}\u{116E}\u{11B9}", "\u{B8FA}", "\u{1105}\u{116E}\u{11B9}"),
    ("\u{B8FB}", "\u{B8FB}", "\u{1105}\u{116E}\u{11BA}", "\u{B8FB}", "\u{1105}\u{116E}\u{11BA}"),
    ("\u{B8FC}", "\u{B8FC}", "\u{1105}\u{116E}\u{11BB}", "\u{B8FC}", "\u{1105}\u{116E}\u{11BB}"),
    ("\u{B8FD}", "\u{B8FD}", "\u{1105}\u{116E}\u{11BC}", "\u{B8FD}", "\u{1105}\u{116E}\u{11BC}"),
    ("\u{B8FE}", "\u{B8FE}", "\u{1105}\u{116E}\u{11BD}", "\u{B8FE}", "\u{1105}\u{116E}\u{11BD}"),
    ("\u{B8FF}", "\u{B8FF}", "\u{1105}\u{116E}\u{11BE}", "\u{B8FF}", "\u{1105}\u{116E}\u{11BE}"),
    ("\u{B900}", "\u{B900}", "\u{1105}\u{116E}\u{11BF}", "\u{B900}", "\u{1105}\u{116E}\u{11BF}"),
    ("\u{B901}", "\u{B901}", "\u{1105}\u{116E}\u{11C0}", "\u{B901}", "\u{1105}\u{116E}\u{11C0}"),
    ("\u{B902}", "\u{B902}", "\u{1105}\u{116E}\u{11C1}", "\u{B902}", "\u{1105}\u{116E}\u{11C1}"),
    ("\u{B903}", "\u{B903}", "\u{1105}\u{116E}\u{11C2}", "\u{B903}", "\u{1105}\u{116E}\u{11C2}"),
    ("\u{B904}", "\u{B904}", "\u{1105}\u{116F}", "\u{B904}", "\u{1105}\u{116F}"),
    ("\u{B905}", "\u{B905}", "\u{1105}\u{116F}\u{11A8}", "\u{B905}", "\u{1105}\u{116F}\u{11A8}"),
    ("\u{B906}", "\u{B906}", "\u{1105}\u{116F}\u{11A9}", "\u{B906}", "\u{1105}\u{116F}\u{11A9}"),
    ("\u{B907}", "\u{B907}", "\u{1105}\u{116F}\u{11AA}", "\u{B907}", "\u{1105}\u{116F}\u{11AA}"),
    ("\u{B908}", "\u{B908}", "\u{1105}\u{116F}\u{11AB}", "\u{B908}", "\u{1105}\u{116F}\u{11AB}"),
    ("\u{B909}", "\u{B909}", "\u{1105}\u{116F}\u{11AC}", "\u{B909}", "\u{1105}\u{116F}\u{11AC}"),
    ("\u{B90A}", "\u{B90A}", "\u{1105}\u{116F}\u{11AD}", "\u{B90A}", "\u{1105}\u{116F}\u{11AD}"),
    ("\u{B90B}", "\u{B90B}", "\u{1105}\u{116F}\u{11AE}", "\u{B90B}", "\u{1105}\u{116F}\u{11AE}"),
    ("\u{B90C}", "\u{B90C}", "\u{1105}\u{116F}\u{11AF}", "\u{B90C}", "\u{1105}\u{116F}\u{11AF}"),
    ("\u{B90D}", "\u{B90D}", "\u{1105}\u{116F}\u{11B0}", "\u{B90D}", "\u{1105}\u{116F}\u{11B0}"),
    ("\u{B90E}", "\u{B90E}", "\u{1105}\u{116F}\u{11B1}", "\u{B90E}", "\u{1105}\u{116F}\u{11B1}"),
    ("\u{B90F}", "\u{B90F}", "\u{1105}\u{116F}\u{11B2}", "\u{B90F}", "\u{1105}\u{116F}\u{11B2}"),
    ("\u{B910}", "\u{B910}", "\u{1105}\u{116F}\u{11B3}", "\u{B910}", "\u{1105}\u{116F}\u{11B3}"),
    ("\u{B911}", "\u{B911}", "\u{1105}\u{116F}\u{11B4}", "\u{B911}", "\u{1105}\u{116F}\u{11B4}"),
    ("\u{B912}", "\u{B912}", "\u{1105}\u{116F}\u{11B5}", "\u{B912}", "\u{1105}\u{116F}\u{11B5}"),
    ("\u{B913}", "\u{B913}", "\u{1105}\u{116F}\u{11B6}", "\u{B913}", "\u{1105}\u{116F}\u{11B6}"),
    ("\u{B914}", "\u{B914}", "\u{1105}\u{116F}\u{11B7}", "\u{B914}", "\u{1105}\u{116F}\u{11B7}"),
    ("\u{B915}", "\u{B915}", "\u{1105}\u{116F}\u{11B8}", "\u{B915}", "\u{1105}\u{116F}\u{11B8}"),
    ("\u{B916}", "\u{B916}", "\u{1105}\u{116F}\u{11B9}", "\u{B916}", "\u{1105}\u{116F}\u{11B9}"),
    ("\u{B917}", "\u{B917}", "\u{1105}\u{116F}\u{11BA}", "\u{B917}", "\u{1105}\u{116F}\u{11BA}"),
    ("\u{B918}", "\u{B918}", "\u{1105}\u{116F}\u{11BB}", "\u{B918}", "\u{1105}\u{116F}\u{11BB}"),
    ("\u{B919}", "\u{B919}", "\u{1105}\u{116F}\u{11BC}", "\u{B919}", "\u{1105}\u{116F}\u{11BC}"),
    ("\u{B91A}", "\u{B91A}", "\u{1105}\u{116F}\u{11BD}", "\u{B91A}", "\u{1105}\u{116F}\u{11BD}"),
    ("\u{B91B}", "\u{B91B}", "\u{1105}\u{116F}\u{11BE}", "\u{B91B}", "\u{1105}\u{116F}\u{11BE}"),
    ("\u{B91C}", "\u{B91C}", "\u{1105}\u{116F}\u{11BF}", "\u{B91C}", "\u{1105}\u{116F}\u{11BF}"),
    ("\u{B91D}", "\u{B91D}", "\u{1105}\u{116F}\u{11C0}", "\u{B91D}", "\u{1105}\u{116F}\u{11C0}"),
    ("\u{B91E}", "\u{B91E}", "\u{1105}\u{116F}\u{11C1}", "\u{B91E}", "\u{1105}\u{116F}\u{11C1}"),
    ("\u{B91F}", "\u{B91F}", "\u{1105}\u{116F}\u{11C2}", "\u{B91F}", "\u{1105}\u{116F}\u{11C2}"),
    ("\u{B920}", "\u{B920}", "\u{1105}\u{1170}", "\u{B920}", "\u{1105}\u{1170}"),
    ("\u{B921}", "\u{B921}", "\u{1105}\u{1170}\u{11A8}", "\u{B921}", "\u{1105}\u{1170}\u{11A8}"),
    ("\u{B922}", "\u{B922}", "\u{1105}\u{1170}\u{11A9}", "\u{B922}", "\u{1105}\u{1170}\u{11A9}"),
    ("\u{B923}", "\u{B923}", "\u{1105}\u{1170}\u{11AA}", "\u{B923}", "\u{1105}\u{1170}\u{11AA}"),
    ("\u{B924}", "\u{B924}", "\u{1105}\u{1170}\u{11AB}", "\u{B924}", "\u{1105}\u{1170}\u{11AB}"),
    ("\u{B925}", "\u{B925}", "\u{1105}\u{1170}\u{11AC}", "\u{B925}", "\u{1105}\u{1170}\u{11AC}"),
    ("\u{B926}", "\u{B926}", "\u{1105}\u{1170}\u{11AD}", "\u{B926}", "\u{1105}\u{1170}\u{11AD}"),
    ("\u{B927}", "\u{B927}", "\u{1105}\u{1170}\u{11AE}", "\u{B927}", "\u{1105}\u{1170}\u{11AE}"),
    ("\u{B928}", "\u{B928}", "\u{1105}\u{1170}\u{11AF}", "\u{B928}", "\u{1105}\u{1170}\u{11AF}"),
    ("\u{B929}", "\u{B929}", "\u{1105}\u{1170}\u{11B0}", "\u{B929}", "\u{1105}\u{1170}\u{11B0}"),
    ("\u{B92A}", "\u{B92A}", "\u{1105}\u{1170}\u{11B1}", "\u{B92A}", "\u{1105}\u{1170}\u{11B1}"),
    ("\u{B92B}", "\u{B92B}", "\u{1105}\u{1170}\u{11B2}", "\u{B92B}", "\u{1105}\u{1170}\u{11B2}"),
    ("\u{B92C}", "\u{B92C}", "\u{1105}\u{1170}\u{11B3}", "\u{B92C}", "\u{1105}\u{1170}\u{11B3}"),
    ("\u{B92D}", "\u{B92D}", "\u{1105}\u{1170}\u{11B4}", "\u{B92D}", "\u{1105}\u{1170}\u{11B4}"),
    ("\u{B92E}", "\u{B92E}", "\u{1105}\u{1170}\u{11B5}", "\u{B92E}", "\u{1105}\u{1170}\u{11B5}"),
    ("\u{B92F}", "\u{B92F}", "\u{1105}\u{1170}\u{11B6}", "\u{B92F}", "\u{1105}\u{1170}\u{11B6}"),
    ("\u{B930}", "\u{B930}", "\u{1105}\u{1170}\u{11B7}", "\u{B930}", "\u{1105}\u{1170}\u{11B7}"),
    ("\u{B931}", "\u{B931}", "\u{1105}\u{1170}\u{11B8}", "\u{B931}", "\u{1105}\u{1170}\u{11B8}"),
    ("\u{B932}", "\u{B932}", "\u{1105}\u{1170}\u{11B9}", "\u{B932}", "\u{1105}\u{1170}\u{11B9}"),
    ("\u{B933}", "\u{B933}", "\u{1105}\u{1170}\u{11BA}", "\u{B933}", "\u{1105}\u{1170}\u{11BA}"),
    ("\u{B934}", "\u{B934}", "\u{1105}\u{1170}\u{11BB}", "\u{B934}", "\u{1105}\u{1170}\u{11BB}"),
    ("\u{B935}", "\u{B935}", "\u{1105}\u{1170}\u{11BC}", "\u{B935}", "\u{1105}\u{1170}\u{11BC}"),
    ("\u{B936}", "\u{B936}", "\u{1105}\u{1170}\u{11BD}", "\u{B936}", "\u{1105}\u{1170}\u{11BD}"),
    ("\u{B937}", "\u{B937}", "\u{1105}\u{1170}\u{11BE}", "\u{B937}", "\u{1105}\u{1170}\u{11BE}"),
    ("\u{B938}", "\u{B938}", "\u{1105}\u{1170}\u{11BF}", "\u{B938}", "\u{1105}\u{1170}\u{11BF}"),
    ("\u{B939}", "\u{B939}", "\u{1105}\u{1170}\u{11C0}", "\u{B939}", "\u{1105}\u{1170}\u{11C0}"),
    ("\u{B93A}", "\u{B93A}", "\u{1105}\u{1170}\u{11C1}", "\u{B93A}", "\u{1105}\u{1170}\u{11C1}"),
    ("\u{B93B}", "\u{B93B}", "\u{1105}\u{1170}\u{11C2}", "\u{B93B}", "\u{1105}\u{1170}\u{11C2}"),
    ("\u{B93C}", "\u{B93C}", "\u{1105}\u{1171}", "\u{B93C}", "\u{1105}\u{1171}"),
    ("\u{B93D}", "\u{B93D}", "\u{1105}\u{1171}\u{11A8}", "\u{B93D}", "\u{1105}\u{1171}\u{11A8}"),
    ("\u{B93E}", "\u{B93E}", "\u{1105}\u{1171}\u{11A9}", "\u{B93E}", "\u{1105}\u{1171}\u{11A9}"),
    ("\u{B93F}", "\u{B93F}", "\u{1105}\u{1171}\u{11AA}", "\u{B93F}", "\u{1105}\u{1171}\u{11AA}"),
    ("\u{B940}", "\u{B940}", "\u{1105}\u{1171}\u{11AB}", "\u{B940}", "\u{1105}\u{1171}\u{11AB}"),
    ("\u{B941}", "\u{B941}", "\u{1105}\u{1171}\u{11AC}", "\u{B941}", "\u{1105}\u{1171}\u{11AC}"),
    ("\u{B942}", "\u{B942}", "\u{1105}\u{1171}\u{11AD}", "\u{B942}", "\u{1105}\u{1171}\u{11AD}"),
    ("\u{B943}", "\u{B943}", "\u{1105}\u{1171}\u{11AE}", "\u{B943}", "\u{1105}\u{1171}\u{11AE}"),
    ("\u{B944}", "\u{B944}", "\u{1105}\u{1171}\u{11AF}", "\u{B944}", "\u{1105}\u{1171}\u{11AF}"),
    ("\u{B945}", "\u{B945}", "\u{1105}\u{1171}\u{11B0}", "\u{B945}", "\u{1105}\u{1171}\u{11B0}"),
    ("\u{B946}", "\u{B946}", "\u{1105}\u{1171}\u{11B1}", "\u{B946}", "\u{1105}\u{1171}\u{11B1}"),
    ("\u{B947}", "\u{B947}", "\u{1105}\u{1171}\u{11B2}", "\u{B947}", "\u{1105}\u{1171}\u{11B2}"),
    ("\u{B948}", "\u{B948}", "\u{1105}\u{1171}\u{11B3}", "\u{B948}", "\u{1105}\u{1171}\u{11B3}"),
    ("\u{B949}", "\u{B949}", "\u{1105}\u{1171}\u{11B4}", "\u{B949}", "\u{1105}\u{1171}\u{11B4}"),
    ("\u{B94A}", "\u{B94A}", "\u{1105}\u{1171}\u{11B5}", "\u{B94A}", "\u{1105}\u{1171}\u{11B5}"),
    ("\u{B94B}", "\u{B94B}", "\u{1105}\u{1171}\u{11B6}", "\u{B94B}", "\u{1105}\u{1171}\u{11B6}"),
    ("\u{B94C}", "\u{B94C}", "\u{1105}\u{1171}\u{11B7}", "\u{B94C}", "\u{1105}\u{1171}\u{11B7}"),
    ("\u{B94D}", "\u{B94D}", "\u{1105}\u{1171}\u{11B8}", "\u{B94D}", "\u{1105}\u{1171}\u{11B8}"),
    ("\u{B94E}", "\u{B94E}", "\u{1105}\u{1171}\u{11B9}", "\u{B94E}", "\u{1105}\u{1171}\u{11B9}"),
    ("\u{B94F}", "\u{B94F}", "\u{1105}\u{1171}\u{11BA}", "\u{B94F}", "\u{1105}\u{1171}\u{11BA}"),
    ("\u{B950}", "\u{B950}", "\u{1105}\u{1171}\u{11BB}", "\u{B950}", "\u{1105}\u{1171}\u{11BB}"),
    ("\u{B951}", "\u{B951}", "\u{1105}\u{1171}\u{11BC}", "\u{B951}", "\u{1105}\u{1171}\u{11BC}"),
    ("\u{B952}", "\u{B952}", "\u{1105}\u{1171}\u{11BD}", "\u{B952}", "\u{1105}\u{1171}\u{11BD}"),
    ("\u{B953}", "\u{B953}", "\u{1105}\u{1171}\u{11BE}", "\u{B953}", "\u{1105}\u{1171}\u{11BE}"),
    ("\u{B954}", "\u{B954}", "\u{1105}\u{1171}\u{11BF}", "\u{B954}", "\u{1105}\u{1171}\u{11BF}"),
    ("\u{B955}", "\u{B955}", "\u{1105}\u{1171}\u{11C0}", "\u{B955}", "\u{1105}\u{1171}\u{11C0}"),
    ("\u{B956}", "\u{B956}", "\u{1105}\u{1171}\u{11C1}", "\u{B956}", "\u{1105}\u{1171}\u{11C1}"),
    ("\u{B957}", "\u{B957}", "\u{1105}\u{1171}\u{11C2}", "\u{B957}", "\u{1105}\u{1171}\u{11C2}"),
    ("\u{B958}", "\u{B958}", "\u{1105}\u{1172}", "\u{B958}", "\u{1105}\u{1172}"),
    ("\u{B959}", "\u{B959}", "\u{1105}\u{1172}\u{11A8}", "\u{B959}", "\u{1105}\u{1172}\u{11A8}"),
    ("\u{B95A}", "\u{B95A}", "\u{1105}\u{1172}\u{11A9}", "\u{B95A}", "\u{1105}\u{1172}\u{11A9}"),
    ("\u{B95B}", "\u{B95B}", "\u{1105}\u{1172}\u{11AA}", "\u{B95B}", "\u{1105}\u{1172}\u{11AA}"),
    ("\u{B95C}", "\u{B95C}", "\u{1105}\u{1172}\u{11AB}", "\u{B95C}", "\u{1105}\u{1172}\u{11AB}"),
    ("\u{B95D}", "\u{B95D}", "\u{1105}\u{1172}\u{11AC}", "\u{B95D}", "\u{1105}\u{1172}\u{11AC}"),
    ("\u{B95E}", "\u{B95E}", "\u{1105}\u{1172}\u{11AD}", "\u{B95E}", "\u{1105}\u{1172}\u{11AD}"),
    ("\u{B95F}", "\u{B95F}", "\u{1105}\u{1172}\u{11AE}", "\u{B95F}", "\u{1105}\u{1172}\u{11AE}"),
    ("\u{B960}", "\u{B960}", "\u{1105}\u{1172}\u{11AF}", "\u{B960}", "\u{1105}\u{1172}\u{11AF}"),
    ("\u{B961}", "\u{B961}", "\u{1105}\u{1172}\u{11B0}", "\u{B961}", "\u{1105}\u{1172}\u{11B0}"),
    ("\u{B962}", "\u{B962}", "\u{1105}\u{1172}\u{11B1}", "\u{B962}", "\u{1105}\u{1172}\u{11B1}"),
    ("\u{B963}", "\u{B963}", "\u{1105}\u{1172}\u{11B2}", "\u{B963}", "\u{1105}\u{1172}\u{11B2}"),
    ("\u{B964}", "\u{B964}", "\u{1105}\u{1172}\u{11B3}", "\u{B964}", "\u{1105}\u{1172}\u{11B3}"),
    ("\u{B965}", "\u{B965}", "\u{1105}\u{1172}\u{11B4}", "\u{B965}", "\u{1105}\u{1172}\u{11B4}"),
    ("\u{B966}", "\u{B966}", "\u{1105}\u{1172}\u{11B5}", "\u{B966}", "\u{1105}\u{1172}\u{11B5}"),
    ("\u{B967}", "\u{B967}", "\u{1105}\u{1172}\u{11B6}", "\u{B967}", "\u{1105}\u{1172}\u{11B6}"),
    ("\u{B968}", "\u{B968}", "\u{1105}\u{1172}\u{11B7}", "\u{B968}", "\u{1105}\u{1172}\u{11B7}"),
    ("\u{B969}", "\u{B969}", "\u{1105}\u{1172}\u{11B8}", "\u{B969}", "\u{1105}\u{1172}\u{11B8}"),
    ("\u{B96A}", "\u{B96A}", "\u{1105}\u{1172}\u{11B9}", "\u{B96A}", "\u{1105}\u{1172}\u{11B9}"),
    ("\u{B96B}", "\u{B96B}", "\u{1105}\u{1172}\u{11BA}", "\u{B96B}", "\u{1105}\u{1172}\u{11BA}"),
    ("\u{B96C}", "\u{B96C}", "\u{1105}\u{1172}\u{11BB}", "\u{B96C}", "\u{1105}\u{1172}\u{11BB}"),
    ("\u{B96D}", "\u{B96D}", "\u{1105}\u{1172}\u{11BC}", "\u{B96D}", "\u{1105}\u{1172}\u{11BC}"),
    ("\u{B96E}", "\u{B96E}", "\u{1105}\u{1172}\u{11BD}", "\u{B96E}", "\u{1105}\u{1172}\u{11BD}"),
    ("\u{B96F}", "\u{B96F}", "\u{1105}\u{1172}\u{11BE}", "\u{B96F}", "\u{1105}\u{1172}\u{11BE}"),
    ("\u{B970}", "\u{B970}", "\u{1105}\u{1172}\u{11BF}", "\u{B970}", "\u{1105}\u{1172}\u{11BF}"),
    ("\u{B971}", "\u{B971}", "\u{1105}\u{1172}\u{11C0}", "\u{B971}", "\u{1105}\u{1172}\u{11C0}"),
    ("\u{B972}", "\u{B972}", "\u{1105}\u{1172}\u{11C1}", "\u{B972}", "\u{1105}\u{1172}\u{11C1}"),
    ("\u{B973}", "\u{B973}", "\u{1105}\u{1172}\u{11C2}", "\u{B973}", "\u{1105}\u{1172}\u{11C2}"),
    ("\u{B974}", "\u{B974}", "\u{1105}\u{1173}", "\u{B974}", "\u{1105}\u{1173}"),
    ("\u{B975}", "\u{B975}", "\u{1105}\u{1173}\u{11A8}", "\u{B975}", "\u{1105}\u{1173}\u{11A8}"),
    ("\u{B976}", "\u{B976}", "\u{1105}\u{1173}\u{11A9}", "\u{B976}", "\u{1105}\u{1173}\u{11A9}"),
    ("\u{B977}", "\u{B977}", "\u{1105}\u{1173}\u{11AA}", "\u{B977}", "\u{1105}\u{1173}\u{11AA}"),
    ("\u{B978}", "\u{B978}", "\u{1105}\u{1173}\u{11AB}", "\u{B978}", "\u{1105}\u{1173}\u{11AB}"),
    ("\u{B979}", "\u{B979}", "\u{1105}\u{1173}\u{11AC}", "\u{B979}", "\u{1105}\u{1173}\u{11AC}"),
    ("\u{B97A}", "\u{B97A}", "\u{1105}\u{1173}\u{11AD}", "\u{B97A}", "\u{1105}\u{1173}\u{11AD}"),
    ("\u{B97B}", "\u{B97B}", "\u{1105}\u{1173}\u{11AE}", "\u{B97B}", "\u{1105}\u{1173}\u{11AE}"),
    ("\u{B97C}", "\u{B97C}", "\u{1105}\u{1173}\u{11AF}", "\u{B97C}", "\u{1105}\u{1173}\u{11AF}"),
    ("\u{B97D}", "\u{B97D}", "\u{1105}\u{1173}\u{11B0}", "\u{B97D}", "\u{1105}\u{1173}\u{11B0}"),
    ("\u{B97E}", "\u{B97E}", "\u{1105}\u{1173}\u{11B1}", "\u{B97E}", "\u{1105}\u{1173}\u{11B1}"),
    ("\u{B97F}", "\u{B97F}", "\u{1105}\u{1173}\u{11B2}", "\u{B97F}", "\u{1105}\u{1173}\u{11B2}"),
    ("\u{B980}", "\u{B980}", "\u{1105}\u{1173}\u{11B3}", "\u{B980}", "\u{1105}\u{1173}\u{11B3}"),
    ("\u{B981}", "\u{B981}", "\u{1105}\u{1173}\u{11B4}", "\u{B981}", "\u{1105}\u{1173}\u{11B4}"),
    ("\u{B982}", "\u{B982}", "\u{1105}\u{1173}\u{11B5}", "\u{B982}", "\u{1105}\u{1173}\u{11B5}"),
    ("\u{B983}", "\u{B983}", "\u{1105}\u{1173}\u{11B6}", "\u{B983}", "\u{1105}\u{1173}\u{11B6}"),
    ("\u{B984}", "\u{B984}", "\u{1105}\u{1173}\u{11B7}", "\u{B984}", "\u{1105}\u{1173}\u{11B7}"),
    ("\u{B985}", "\u{B985}", "\u{1105}\u{1173}\u{11B8}", "\u{B985}", "\u{1105}\u{1173}\u{11B8}"),
    ("\u{B986}", "\u{B986}", "\u{1105}\u{1173}\u{11B9}", "\u{B986}", "\u{1105}\u{1173}\u{11B9}"),
    ("\u{B987}", "\u{B987}", "\u{1105}\u{1173}\u{11BA}", "\u{B987}", "\u{1105}\u{1173}\u{11BA}"),
    ("\u{B988}", "\u{B988}", "\u{1105}\u{1173}\u{11BB}", "\u{B988}", "\u{1105}\u{1173}\u{11BB}"),
    ("\u{B989}", "\u{B989}", "\u{1105}\u{1173}\u{11BC}", "\u{B989}", "\u{1105}\u{1173}\u{11BC}"),
    ("\u{B98A}", "\u{B98A}", "\u{1105}\u{1173}\u{11BD}", "\u{B98A}", "\u{1105}\u{1173}\u{11BD}"),
    ("\u{B98B}", "\u{B98B}", "\u{1105}\u{1173}\u{11BE}", "\u{B98B}", "\u{1105}\u{1173}\u{11BE}"),
    ("\u{B98C}", "\u{B98C}", "\u{1105}\u{1173}\u{11BF}", "\u{B98C}", "\u{1105}\u{1173}\u{11BF}"),
    ("\u{B98D}", "\u{B98D}", "\u{1105}\u{1173}\u{11C0}", "\u{B98D}", "\u{1105}\u{1173}\u{11C0}"),
    ("\u{B98E}", "\u{B98E}", "\u{1105}\u{1173}\u{11C1}", "\u{B98E}", "\u{1105}\u{1173}\u{11C1}"),
    ("\u{B98F}", "\u{B98F}", "\u{1105}\u{1173}\u{11C2}", "\u{B98F}", "\u{1105}\u{1173}\u{11C2}"),
    ("\u{B990}", "\u{B990}", "\u{1105}\u{1174}", "\u{B990}", "\u{1105}\u{1174}"),
    ("\u{B991}", "\u{B991}", "\u{1105}\u{1174}\u{11A8}", "\u{B991}", "\u{1105}\u{1174}\u{11A8}"),
    ("\u{B992}", "\u{B992}", "\u{1105}\u{1174}\u{11A9}", "\u{B992}", "\u{1105}\u{1174}\u{11A9}"),
    ("\u{B993}", "\u{B993}", "\u{1105}\u{1174}\u{11AA}", "\u{B993}", "\u{1105}\u{1174}\u{11AA}"),
    ("\u{B994}", "\u{B994}", "\u{1105}\u{1174}\u{11AB}", "\u{B994}", "\u{1105}\u{1174}\u{11AB}"),
    ("\u{B995}", "\u{B995}", "\u{1105}\u{1174}\u{11AC}", "\u{B995}", "\u{1105}\u{1174}\u{11AC}"),
    ("\u{B996}", "\u{B996}", "\u{1105}\u{1174}\u{11AD}", "\u{B996}", "\u{1105}\u{1174}\u{11AD}"),
    ("\u{B997}", "\u{B997}", "\u{1105}\u{1174}\u{11AE}", "\u{B997}", "\u{1105}\u{1174}\u{11AE}"),
    ("\u{B998}", "\u{B998}", "\u{1105}\u{1174}\u{11AF}", "\u{B998}", "\u{1105}\u{1174}\u{11AF}"),
    ("\u{B999}", "\u{B999}", "\u{1105}\u{1174}\u{11B0}", "\u{B999}", "\u{1105}\u{1174}\u{11B0}"),
    ("\u{B99A}", "\u{B99A}", "\u{1105}\u{1174}\u{11B1}", "\u{B99A}", "\u{1105}\u{1174}\u{11B1}"),
    ("\u{B99B}", "\u{B99B}", "\u{1105}\u{1174}\u{11B2}", "\u{B99B}", "\u{1105}\u{1174}\u{11B2}"),
    ("\u{B99C}", "\u{B99C}", "\u{1105}\u{1174}\u{11B3}", "\u{B99C}", "\u{1105}\u{1174}\u{11B3}"),
    ("\u{B99D}", "\u{B99D}", "\u{1105}\u{1174}\u{11B4}", "\u{B99D}", "\u{1105}\u{1174}\u{11B4}"),
    ("\u{B99E}", "\u{B99E}", "\u{1105}\u{1174}\u{11B5}", "\u{B99E}", "\u{1105}\u{1174}\u{11B5}"),
    ("\u{B99F}", "\u{B99F}", "\u{1105}\u{1174}\u{11B6}", "\u{B99F}", "\u{1105}\u{1174}\u{11B6}"),
    ("\u{B9A0}", "\u{B9A0}", "\u{1105}\u{1174}\u{11B7}", "\u{B9A0}", "\u{1105}\u{1174}\u{11B7}"),
    ("\u{B9A1}", "\u{B9A1}", "\u{1105}\u{1174}\u{11B8}", "\u{B9A1}", "\u{1105}\u{1174}\u{11B8}"),
    ("\u{B9A2}", "\u{B9A2}", "\u{1105}\u{1174}\u{11B9}", "\u{B9A2}", "\u{1105}\u{1174}\u{11B9}"),
    ("\u{B9A3}", "\u{B9A3}", "\u{1105}\u{1174}\u{11BA}", "\u{B9A3}", "\u{1105}\u{1174}\u{11BA}"),
    ("\u{B9A4}", "\u{B9A4}", "\u{1105}\u{1174}\u{11BB}", "\u{B9A4}", "\u{1105}\u{1174}\u{11BB}"),
    ("\u{B9A5}", "\u{B9A5}", "\u{1105}\u{1174}\u{11BC}", "\u{B9A5}", "\u{1105}\u{1174}\u{11BC}"),
    ("\u{B9A6}", "\u{B9A6}", "\u{1105}\u{1174}\u{11BD}", "\u{B9A6}", "\u{1105}\u{1174}\u{11BD}"),
    ("\u{B9A7}", "\u{B9A7}", "\u{1105}\u{1174}\u{11BE}", "\u{B9A7}", "\u{1105}\u{1174}\u{11BE}"),
    ("\u{B9A8}", "\u{B9A8}", "\u{1105}\u{1174}\u{11BF}", "\u{B9A8}", "\u{1105}\u{1174}\u{11BF}"),
    ("\u{B9A9}", "\u{B9A9}", "\u{1105}\u{1174}\u{11C0}", "\u{B9A9}", "\u{1105}\u{1174}\u{11C0}"),
    ("\u{B9AA}", "\u{B9AA}", "\u{1105}\u{1174}\u{11C1}", "\u{B9AA}", "\u{1105}\u{1174}\u{11C1}"),
    ("\u{B9AB}", "\u{B9AB}", "\u{1105}\u{1174}\u{11C2}", "\u{B9AB}", "\u{1105}\u{1174}\u{11C2}"),
    ("\u{B9AC}", "\u{B9AC}", "\u{1105}\u{1175}", "\u{B9AC}", "\u{1105}\u{1175}"),
    ("\u{B9AD}", "\u{B9AD}", "\u{1105}\u{1175}\u{11A8}", "\u{B9AD}", "\u{1105}\u{1175}\u{11A8}"),
    ("\u{B9AE}", "\u{B9AE}", "\u{1105}\u{1175}\u{11A9}", "\u{B9AE}", "\u{1105}\u{1175}\u{11A9}"),
    ("\u{B9AF}", "\u{B9AF}", "\u{1105}\u{1175}\u{11AA}", "\u{B9AF}", "\u{1105}\u{1175}\u{11AA}"),
    ("\u{B9B0}", "\u{B9B0}", "\u{1105}\u{1175}\u{11AB}", "\u{B9B0}", "\u{1105}\u{1175}\u{11AB}"),
    ("\u{B9B1}", "\u{B9B1}", "\u{1105}\u{1175}\u{11AC}", "\u{B9B1}", "\u{1105}\u{1175}\u{11AC}"),
    ("\u{B9B2}", "\u{B9B2}", "\u{1105}\u{1175}\u{11AD}", "\u{B9B2}", "\u{1105}\u{1175}\u{11AD}"),
    ("\u{B9B3}", "\u{B9B3}", "\u{1105}\u{1175}\u{11AE}", "\u{B9B3}", "\u{1105}\u{1175}\u{11AE}"),
    ("\u{B9B4}", "\u{B9B4}", "\u{1105}\u{1175}\u{11AF}", "\u{B9B4}", "\u{1105}\u{1175}\u{11AF}"),
    ("\u{B9B5}", "\u{B9B5}", "\u{1105}\u{1175}\u{11B0}", "\u{B9B5}", "\u{1105}\u{1175}\u{11B0}"),
    ("\u{B9B6}", "\u{B9B6}", "\u{1105}\u{1175}\u{11B1}", "\u{B9B6}", "\u{1105}\u{1175}\u{11B1}"),
    ("\u{B9B7}", "\u{B9B7}", "\u{1105}\u{1175}\u{11B2}", "\u{B9B7}", "\u{1105}\u{1175}\u{11B2}"),
    ("\u{B9B8}", "\u{B9B8}", "\u{1105}\u{1175}\u{11B3}", "\u{B9B8}", "\u{1105}\u{1175}\u{11B3}"),
    ("\u{B9B9}", "\u{B9B9}", "\u{1105}\u{1175}\u{11B4}", "\u{B9B9}", "\u{1105}\u{1175}\u{11B4}"),
    ("\u{B9BA}", "\u{B9BA}", "\u{1105}\u{1175}\u{11B5}", "\u{B9BA}", "\u{1105}\u{1175}\u{11B5}"),
    ("\u{B9BB}", "\u{B9BB}", "\u{1105}\u{1175}\u{11B6}", "\u{B9BB}", "\u{1105}\u{1175}\u{11B6}"),
    ("\u{B9BC}", "\u{B9BC}", "\u{1105}\u{1175}\u{11B7}", "\u{B9BC}", "\u{1105}\u{1175}\u{11B7}"),
    ("\u{B9BD}", "\u{B9BD}", "\u{1105}\u{1175}\u{11B8}", "\u{B9BD}", "\u{1105}\u{1175}\u{11B8}"),
    ("\u{B9BE}", "\u{B9BE}", "\u{1105}\u{1175}\u{11B9}", "\u{B9BE}", "\u{1105}\u{1175}\u{11B9}"),
    ("\u{B9BF}", "\u{B9BF}", "\u{1105}\u{1175}\u{11BA}", "\u{B9BF}", "\u{1105}\u{1175}\u{11BA}"),
    ("\u{B9C0}", "\u{B9C0}", "\u{1105}\u{1175}\u{11BB}", "\u{B9C0}", "\u{1105}\u{1175}\u{11BB}"),
    ("\u{B9C1}", "\u{B9C1}", "\u{1105}\u{1175}\u{11BC}", "\u{B9C1}", "\u{1105}\u{1175}\u{11BC}"),
    ("\u{B9C2}", "\u{B9C2}", "\u{1105}\u{1175}\u{11BD}", "\u{B9C2}", "\u{1105}\u{1175}\u{11BD}"),
    ("\u{B9C3}", "\u{B9C3}", "\u{1105}\u{1175}\u{11BE}", "\u{B9C3}", "\u{1105}\u{1175}\u{11BE}"),
    ("\u{B9C4}", "\u{B9C4}", "\u{1105}\u{1175}\u{11BF}", "\u{B9C4}", "\u{1105}\u{1175}\u{11BF}"),
    ("\u{B9C5}", "\u{B9C5}", "\u{1105}\u{1175}\u{11C0}", "\u{B9C5}", "\u{1105}\u{1175}\u{11C0}"),
    ("\u{B9C6}", "\u{B9C6}", "\u{1105}\u{1175}\u{11C1}", "\u{B9C6}", "\u{1105}\u{1175}\u{11C1}"),
    ("\u{B9C7}", "\u{B9C7}", "\u{1105}\u{1175}\u{11C2}", "\u{B9C7}", "\u{1105}\u{1175}\u{11C2}"),
    ("\u{B9C8}", "\u{B9C8}", "\u{1106}\u{1161}", "\u{B9C8}", "\u{1106}\u{1161}"),
    ("\u{B9C9}", "\u{B9C9}", "\u{1106}\u{1161}\u{11A8}", "\u{B9C9}", "\u{1106}\u{1161}\u{11A8}"),
    ("\u{B9CA}", "\u{B9CA}", "\u{1106}\u{1161}\u{11A9}", "\u{B9CA}", "\u{1106}\u{1161}\u{11A9}"),
    ("\u{B9CB}", "\u{B9CB}", "\u{1106}\u{1161}\u{11AA}", "\u{B9CB}", "\u{1106}\u{1161}\u{11AA}"),
    ("\u{B9CC}", "\u{B9CC}", "\u{1106}\u{1161}\u{11AB}", "\u{B9CC}", "\u{1106}\u{1161}\u{11AB}"),
    ("\u{B9CD}", "\u{B9CD}", "\u{1106}\u{1161}\u{11AC}", "\u{B9CD}", "\u{1106}\u{1161}\u{11AC}"),
    ("\u{B9CE}", "\u{B9CE}", "\u{1106}\u{1161}\u{11AD}", "\u{B9CE}", "\u{1106}\u{1161}\u{11AD}"),
    ("\u{B9CF}", "\u{B9CF}", "\u{1106}\u{1161}\u{11AE}", "\u{B9CF}", "\u{1106}\u{1161}\u{11AE}"),
    ("\u{B9D0}", "\u{B9D0}", "\u{1106}\u{1161}\u{11AF}", "\u{B9D0}", "\u{1106}\u{1161}\u{11AF}"),
    ("\u{B9D1}", "\u{B9D1}", "\u{1106}\u{1161}\u{11B0}", "\u{B9D1}", "\u{1106}\u{1161}\u{11B0}"),
    ("\u{B9D2}", "\u{B9D2}", "\u{1106}\u{1161}\u{11B1}", "\u{B9D2}", "\u{1106}\u{1161}\u{11B1}"),
    ("\u{B9D3}", "\u{B9D3}", "\u{1106}\u{1161}\u{11B2}", "\u{B9D3}", "\u{1106}\u{1161}\u{11B2}"),
    ("\u{B9D4}", "\u{B9D4}", "\u{1106}\u{1161}\u{11B3}", "\u{B9D4}", "\u{1106}\u{1161}\u{11B3}"),
    ("\u{B9D5}", "\u{B9D5}", "\u{1106}\u{1161}\u{11B4}", "\u{B9D5}", "\u{1106}\u{1161}\u{11B4}"),
    ("\u{B9D6}", "\u{B9D6}", "\u{1106}\u{1161}\u{11B5}", "\u{B9D6}", "\u{1106}\u{1161}\u{11B5}"),
    ("\u{B9D7}", "\u{B9D7}", "\u{1106}\u{1161}\u{11B6}", "\u{B9D7}", "\u{1106}\u{1161}\u{11B6}"),
    ("\u{B9D8}", "\u{B9D8}", "\u{1106}\u{1161}\u{11B7}", "\u{B9D8}", "\u{1106}\u{1161}\u{11B7}"),
    ("\u{B9D9}", "\u{B9D9}", "\u{1106}\u{1161}\u{11B8}", "\u{B9D9}", "\u{1106}\u{1161}\u{11B8}"),
    ("\u{B9DA}", "\u{B9DA}", "\u{1106}\u{1161}\u{11B9}", "\u{B9DA}", "\u{1106}\u{1161}\u{11B9}"),
    ("\u{B9DB}", "\u{B9DB}", "\u{1106}\u{1161}\u{11BA}", "\u{B9DB}", "\u{1106}\u{1161}\u{11BA}"),
    ("\u{B9DC}", "\u{B9DC}", "\u{1106}\u{1161}\u{11BB}", "\u{B9DC}", "\u{1106}\u{1161}\u{11BB}"),
    ("\u{B9DD}", "\u{B9DD}", "\u{1106}\u{1161}\u{11BC}", "\u{B9DD}", "\u{1106}\u{1161}\u{11BC}"),
    ("\u{B9DE}", "\u{B9DE}", "\u{1106}\u{1161}\u{11BD}", "\u{B9DE}", "\u{1106}\u{1161}\u{11BD}"),
    ("\u{B9DF}", "\u{B9DF}", "\u{1106}\u{1161}\u{11BE}", "\u{B9DF}", "\u{1106}\u{1161}\u{11BE}"),
    ("\u{B9E0}", "\u{B9E0}", "\u{1106}\u{1161}\u{11BF}", "\u{B9E0}", "\u{1106}\u{1161}\u{11BF}"),
    ("\u{B9E1}", "\u{B9E1}", "\u{1106}\u{1161}\u{11C0}", "\u{B9E1}", "\u{1106}\u{1161}\u{11C0}"),
    ("\u{B9E2}", "\u{B9E2}", "\u{1106}\u{1161}\u{11C1}", "\u{B9E2}", "\u{1106}\u{1161}\u{11C1}"),
    ("\u{B9E3}", "\u{B9E3}", "\u{1106}\u{1161}\u{11C2}", "\u{B9E3}", "\u{1106}\u{1161}\u{11C2}"),
    ("\u{B9E4}", "\u{B9E4}", "\u{1106}\u{1162}", "\u{B9E4}", "\u{1106}\u{1162}"),
    ("\u{B9E5}", "\u{B9E5}", "\u{1106}\u{1162}\u{11A8}", "\u{B9E5}", "\u{1106}\u{1162}\u{11A8}"),
    ("\u{B9E6}", "\u{B9E6}", "\u{1106}\u{1162}\u{11A9}", "\u{B9E6}", "\u{1106}\u{1162}\u{11A9}"),
    ("\u{B9E7}", "\u{B9E7}", "\u{1106}\u{1162}\u{11AA}", "\u{B9E7}", "\u{1106}\u{1162}\u{11AA}"),
    ("\u{B9E8}", "\u{B9E8}", "\u{1106}\u{1162}\u{11AB}", "\u{B9E8}", "\u{1106}\u{1162}\u{11AB}"),
    ("\u{B9E9}", "\u{B9E9}", "\u{1106}\u{1162}\u{11AC}", "\u{B9E9}", "\u{1106}\u{1162}\u{11AC}"),
    ("\u{B9EA}", "\u{B9EA}", "\u{1106}\u{1162}\u{11AD}", "\u{B9EA}", "\u{1106}\u{1162}\u{11AD}"),
    ("\u{B9EB}", "\u{B9EB}", "\u{1106}\u{1162}\u{11AE}", "\u{B9EB}", "\u{1106}\u{1162}\u{11AE}"),
    ("\u{B9EC}", "\u{B9EC}", "\u{1106}\u{1162}\u{11AF}", "\u{B9EC}", "\u{1106}\u{1162}\u{11AF}"),
    ("\u{B9ED}", "\u{B9ED}", "\u{1106}\u{1162}\u{11B0}", "\u{B9ED}", "\u{1106}\u{1162}\u{11B0}"),
    ("\u{B9EE}", "\u{B9EE}", "\u{1106}\u{1162}\u{11B1}", "\u{B9EE}", "\u{1106}\u{1162}\u{11B1}"),
    ("\u{B9EF}", "\u{B9EF}", "\u{1106}\u{1162}\u{11B2}", "\u{B9EF}", "\u{1106}\u{1162}\u{11B2}"),
    ("\u{B9F0}", "\u{B9F0}", "\u{1106}\u{1162}\u{11B3}", "\u{B9F0}", "\u{1106}\u{1162}\u{11B3}"),
    ("\u{B9F1}", "\u{B9F1}", "\u{1106}\u{1162}\u{11B4}", "\u{B9F1}", "\u{1106}\u{1162}\u{11B4}"),
    ("\u{B9F2}", "\u{B9F2}", "\u{1106}\u{1162}\u{11B5}", "\u{B9F2}", "\u{1106}\u{1162}\u{11B5}"),
    ("\u{B9F3}", "\u{B9F3}", "\u{1106}\u{1162}\u{11B6}", "\u{B9F3}", "\u{1106}\u{1162}\u{11B6}"),
    ("\u{B9F4}", "\u{B9F4}", "\u{1106}\u{1162}\u{11B7}", "\u{B9F4}", "\u{1106}\u{1162}\u{11B7}"),
    ("\u{B9F5}", "\u{B9F5}", "\u{1106}\u{1162}\u{11B8}", "\u{B9F5}", "\u{1106}\u{1162}\u{11B8}"),
    ("\u{B9F6}", "\u{B9F6}", "\u{1106}\u{1162}\u{11B9}", "\u{B9F6}", "\u{1106}\u{1162}\u{11B9}"),
    ("\u{B9F7}", "\u{B9F7}", "\u{1106}\u{1162}\u{11BA}", "\u{B9F7}", "\u{1106}\u{1162}\u{11BA}"),
    ("\u{B9F8}", "\u{B9F8}", "\u{1106}\u{1162}\u{11BB}", "\u{B9F8}", "\u{1106}\u{1162}\u{11BB}"),
    ("\u{B9F9}", "\u{B9F9}", "\u{1106}\u{1162}\u{11BC}", "\u{B9F9}", "\u{1106}\u{1162}\u{11BC}"),
    ("\u{B9FA}", "\u{B9FA}", "\u{1106}\u{1162}\u{11BD}", "\u{B9FA}", "\u{1106}\u{1162}\u{11BD}"),
    ("\u{B9FB}", "\u{B9FB}", "\u{1106}\u{1162}\u{11BE}", "\u{B9FB}", "\u{1106}\u{1162}\u{11BE}"),
    ("\u{B9FC}", "\u{B9FC}", "\u{1106}\u{1162}\u{11BF}", "\u{B9FC}", "\u{1106}\u{1162}\u{11BF}"),
    ("\u{B9FD}", "\u{B9FD}", "\u{1106}\u{1162}\u{11C0}", "\u{B9FD}", "\u{1106}\u{1162}\u{11C0}"),
    ("\u{B9FE}", "\u{B9FE}", "\u{1106}\u{1162}\u{11C1}", "\u{B9FE}", "\u{1106}\u{1162}\u{11C1}"),
    ("\u{B9FF}", "\u{B9FF}", "\u{1106}\u{1162}\u{11C2}", "\u{B9FF}", "\u{1106}\u{1162}\u{11C2}"),
    ("\u{BA00}", "\u{BA00}", "\u{1106}\u{1163}", "\u{BA00}", "\u{1106}\u{1163}"),
    ("\u{BA01}", "\u{BA01}", "\u{1106}\u{1163}\u{11A8}", "\u{BA01}", "\u{1106}\u{1163}\u{11A8}"),
    ("\u{BA02}", "\u{BA02}", "\u{1106}\u{1163}\u{11A9}", "\u{BA02}", "\u{1106}\u{1163}\u{11A9}"),
    ("\u{BA03}", "\u{BA03}", "\u{1106}\u{1163}\u{11AA}", "\u{BA03}", "\u{1106}\u{1163}\u{11AA}"),
    ("\u{BA04}", "\u{BA04}", "\u{1106}\u{1163}\u{11AB}", "\u{BA04}", "\u{1106}\u{1163}\u{11AB}"),
    ("\u{BA05}", "\u{BA05}", "\u{1106}\u{1163}\u{11AC}", "\u{BA05}", "\u{1106}\u{1163}\u{11AC}"),
    ("\u{BA06}", "\u{BA06}", "\u{1106}\u{1163}\u{11AD}", "\u{BA06}", "\u{1106}\u{1163}\u{11AD}"),
    ("\u{BA07}", "\u{BA07}", "\u{1106}\u{1163}\u{11AE}", "\u{BA07}", "\u{1106}\u{1163}\u{11AE}"),
    ("\u{BA08}", "\u{BA08}", "\u{1106}\u{1163}\u{11AF}", "\u{BA08}", "\u{1106}\u{1163}\u{11AF}"),
    ("\u{BA09}", "\u{BA09}", "\u{1106}\u{1163}\u{11B0}", "\u{BA09}", "\u{1106}\u{1163}\u{11B0}"),
    ("\u{BA0A}", "\u{BA0A}", "\u{1106}\u{1163}\u{11B1}", "\u{BA0A}", "\u{1106}\u{1163}\u{11B1}"),
    ("\u{BA0B}", "\u{BA0B}", "\u{1106}\u{1163}\u{11B2}", "\u{BA0B}", "\u{1106}\u{1163}\u{11B2}"),
    ("\u{BA0C}", "\u{BA0C}", "\u{1106}\u{1163}\u{11B3}", "\u{BA0C}", "\u{1106}\u{1163}\u{11B3}"),
    ("\u{BA0D}", "\u{BA0D}", "\u{1106}\u{1163}\u{11B4}", "\u{BA0D}", "\u{1106}\u{1163}\u{11B4}"),
    ("\u{BA0E}", "\u{BA0E}", "\u{1106}\u{1163}\u{11B5}", "\u{BA0E}", "\u{1106}\u{1163}\u{11B5}"),
    ("\u{BA0F}", "\u{BA0F}", "\u{1106}\u{1163}\u{11B6}", "\u{BA0F}", "\u{1106}\u{1163}\u{11B6}"),
    ("\u{BA10}", "\u{BA10}", "\u{1106}\u{1163}\u{11B7}", "\u{BA10}", "\u{1106}\u{1163}\u{11B7}"),
    ("\u{BA11}", "\u{BA11}", "\u{1106}\u{1163}\u{11B8}", "\u{BA11}", "\u{1106}\u{1163}\u{11B8}"),
    ("\u{BA12}", "\u{BA12}", "\u{1106}\u{1163}\u{11B9}", "\u{BA12}", "\u{1106}\u{1163}\u{11B9}"),
    ("\u{BA13}", "\u{BA13}", "\u{1106}\u{1163}\u{11BA}", "\u{BA13}", "\u{1106}\u{1163}\u{11BA}"),
    ("\u{BA14}", "\u{BA14}", "\u{1106}\u{1163}\u{11BB}", "\u{BA14}", "\u{1106}\u{1163}\u{11BB}"),
    ("\u{BA15}", "\u{BA15}", "\u{1106}\u{1163}\u{11BC}", "\u{BA15}", "\u{1106}\u{1163}\u{11BC}"),
    ("\u{BA16}", "\u{BA16}", "\u{1106}\u{1163}\u{11BD}", "\u{BA16}", "\u{1106}\u{1163}\u{11BD}"),
    ("\u{BA17}", "\u{BA17}", "\u{1106}\u{1163}\u{11BE}", "\u{BA17}", "\u{1106}\u{1163}\u{11BE}"),
    ("\u{BA18}", "\u{BA18}", "\u{1106}\u{1163}\u{11BF}", "\u{BA18}", "\u{1106}\u{1163}\u{11BF}"),
    ("\u{BA19}", "\u{BA19}", "\u{1106}\u{1163}\u{11C0}", "\u{BA19}", "\u{1106}\u{1163}\u{11C0}"),
    ("\u{BA1A}", "\u{BA1A}", "\u{1106}\u{1163}\u{11C1}", "\u{BA1A}", "\u{1106}\u{1163}\u{11C1}"),
    ("\u{BA1B}", "\u{BA1B}", "\u{1106}\u{1163}\u{11C2}", "\u{BA1B}", "\u{1106}\u{1163}\u{11C2}"),
    ("\u{BA1C}", "\u{BA1C}", "\u{1106}\u{1164}", "\u{BA1C}", "\u{1106}\u{1164}"),
    ("\u{BA1D}", "\u{BA1D}", "\u{1106}\u{1164}\u{11A8}", "\u{BA1D}", "\u{1106}\u{1164}\u{11A8}"),
    ("\u{BA1E}", "\u{BA1E}", "\u{1106}\u{1164}\u{11A9}", "\u{BA1E}", "\u{1106}\u{1164}\u{11A9}"),
    ("\u{BA1F}", "\u{BA1F}", "\u{1106}\u{1164}\u{11AA}", "\u{BA1F}", "\u{1106}\u{1164}\u{11AA}"),
    ("\u{BA20}", "\u{BA20}", "\u{1106}\u{1164}\u{11AB}", "\u{BA20}", "\u{1106}\u{1164}\u{11AB}"),
    ("\u{BA21}", "\u{BA21}", "\u{1106}\u{1164}\u{11AC}", "\u{BA21}", "\u{1106}\u{1164}\u{11AC}"),
    ("\u{BA22}", "\u{BA22}", "\u{1106}\u{1164}\u{11AD}", "\u{BA22}", "\u{1106}\u{1164}\u{11AD}"),
    ("\u{BA23}", "\u{BA23}", "\u{1106}\u{1164}\u{11AE}", "\u{BA23}", "\u{1106}\u{1164}\u{11AE}"),
    ("\u{BA24}", "\u{BA24}", "\u{1106}\u{1164}\u{11AF}", "\u{BA24}", "\u{1106}\u{1164}\u{11AF}"),
    ("\u{BA25}", "\u{BA25}", "\u{1106}\u{1164}\u{11B0}", "\u{BA25}", "\u{1106}\u{1164}\u{11B0}"),
    ("\u{BA26}", "\u{BA26}", "\u{1106}\u{1164}\u{11B1}", "\u{BA26}", "\u{1106}\u{1164}\u{11B1}"),
    ("\u{BA27}", "\u{BA27}", "\u{1106}\u{1164}\u{11B2}", "\u{BA27}", "\u{1106}\u{1164}\u{11B2}"),
    ("\u{BA28}", "\u{BA28}", "\u{1106}\u{1164}\u{11B3}", "\u{BA28}", "\u{1106}\u{1164}\u{11B3}"),
    ("\u{BA29}", "\u{BA29}", "\u{1106}\u{1164}\u{11B4}", "\u{BA29}", "\u{1106}\u{1164}\u{11B4}"),
    ("\u{BA2A}", "\u{BA2A}", "\u{1106}\u{1164}\u{11B5}", "\u{BA2A}", "\u{1106}\u{1164}\u{11B5}"),
    ("\u{BA2B}", "\u{BA2B}", "\u{1106}\u{1164}\u{11B6}", "\u{BA2B}", "\u{1106}\u{1164}\u{11B6}"),
    ("\u{BA2C}", "\u{BA2C}", "\u{1106}\u{1164}\u{11B7}", "\u{BA2C}", "\u{1106}\u{1164}\u{11B7}"),
    ("\u{BA2D}", "\u{BA2D}", "\u{1106}\u{1164}\u{11B8}", "\u{BA2D}", "\u{1106}\u{1164}\u{11B8}"),
    ("\u{BA2E}", "\u{BA2E}", "\u{1106}\u{1164}\u{11B9}", "\u{BA2E}", "\u{1106}\u{1164}\u{11B9}"),
    ("\u{BA2F}", "\u{BA2F}", "\u{1106}\u{1164}\u{11BA}", "\u{BA2F}", "\u{1106}\u{1164}\u{11BA}"),
    ("\u{BA30}", "\u{BA30}", "\u{1106}\u{1164}\u{11BB}", "\u{BA30}", "\u{1106}\u{1164}\u{11BB}"),
    ("\u{BA31}", "\u{BA31}", "\u{1106}\u{1164}\u{11BC}", "\u{BA31}", "\u{1106}\u{1164}\u{11BC}"),
    ("\u{BA32}", "\u{BA32}", "\u{1106}\u{1164}\u{11BD}", "\u{BA32}", "\u{1106}\u{1164}\u{11BD}"),
    ("\u{BA33}", "\u{BA33}", "\u{1106}\u{1164}\u{11BE}", "\u{BA33}", "\u{1106}\u{1164}\u{11BE}"),
    ("\u{BA34}", "\u{BA34}", "\u{1106}\u{1164}\u{11BF}", "\u{BA34}", "\u{1106}\u{1164}\u{11BF}"),
    ("\u{BA35}", "\u{BA35}", "\u{1106}\u{1164}\u{11C0}", "\u{BA35}", "\u{1106}\u{1164}\u{11C0}"),
    ("\u{BA36}", "\u{BA36}", "\u{1106}\u{1164}\u{11C1}", "\u{BA36}", "\u{1106}\u{1164}\u{11C1}"),
    ("\u{BA37}", "\u{BA37}", "\u{1106}\u{1164}\u{11C2}", "\u{BA37}", "\u{1106}\u{1164}\u{11C2}"),
    ("\u{BA38}", "\u{BA38}", "\u{1106}\u{1165}", "\u{BA38}", "\u{1106}\u{1165}"),
    ("\u{BA39}", "\u{BA39}", "\u{1106}\u{1165}\u{11A8}", "\u{BA39}", "\u{1106}\u{1165}\u{11A8}"),
    ("\u{BA3A}", "\u{BA3A}", "\u{1106}\u{1165}\u{11A9}", "\u{BA3A}", "\u{1106}\u{1165}\u{11A9}"),
    ("\u{BA3B}", "\u{BA3B}", "\u{1106}\u{1165}\u{11AA}", "\u{BA3B}", "\u{1106}\u{1165}\u{11AA}"),
    ("\u{BA3C}", "\u{BA3C}", "\u{1106}\u{1165}\u{11AB}", "\u{BA3C}", "\u{1106}\u{1165}\u{11AB}"),
    ("\u{BA3D}", "\u{BA3D}", "\u{1106}\u{1165}\u{11AC}", "\u{BA3D}", "\u{1106}\u{1165}\u{11AC}"),
    ("\u{BA3E}", "\u{BA3E}", "\u{1106}\u{1165}\u{11AD}", "\u{BA3E}", "\u{1106}\u{1165}\u{11AD}"),
    ("\u{BA3F}", "\u{BA3F}", "\u{1106}\u{1165}\u{11AE}", "\u{BA3F}", "\u{1106}\u{1165}\u{11AE}"),
    ("\u{BA40}", "\u{BA40}", "\u{1106}\u{1165}\u{11AF}", "\u{BA40}", "\u{1106}\u{1165}\u{11AF}"),
    ("\u{BA41}", "\u{BA41}", "\u{1106}\u{1165}\u{11B0}", "\u{BA41}", "\u{1106}\u{1165}\u{11B0}"),
    ("\u{BA42}", "\u{BA42}", "\u{1106}\u{1165}\u{11B1}", "\u{BA42}", "\u{1106}\u{1165}\u{11B1}"),
    ("\u{BA43}", "\u{BA43}", "\u{1106}\u{1165}\u{11B2}", "\u{BA43}", "\u{1106}\u{1165}\u{11B2}"),
    ("\u{BA44}", "\u{BA44}", "\u{1106}\u{1165}\u{11B3}", "\u{BA44}", "\u{1106}\u{1165}\u{11B3}"),
    ("\u{BA45}", "\u{BA45}", "\u{1106}\u{1165}\u{11B4}", "\u{BA45}", "\u{1106}\u{1165}\u{11B4}"),
    ("\u{BA46}", "\u{BA46}", "\u{1106}\u{1165}\u{11B5}", "\u{BA46}", "\u{1106}\u{1165}\u{11B5}"),
    ("\u{BA47}", "\u{BA47}", "\u{1106}\u{1165}\u{11B6}", "\u{BA47}", "\u{1106}\u{1165}\u{11B6}"),
    ("\u{BA48}", "\u{BA48}", "\u{1106}\u{1165}\u{11B7}", "\u{BA48}", "\u{1106}\u{1165}\u{11B7}"),
    ("\u{BA49}", "\u{BA49}", "\u{1106}\u{1165}\u{11B8}", "\u{BA49}", "\u{1106}\u{1165}\u{11B8}"),
    ("\u{BA4A}", "\u{BA4A}", "\u{1106}\u{1165}\u{11B9}", "\u{BA4A}", "\u{1106}\u{1165}\u{11B9}"),
    ("\u{BA4B}", "\u{BA4B}", "\u{1106}\u{1165}\u{11BA}", "\u{BA4B}", "\u{1106}\u{1165}\u{11BA}"),
    ("\u{BA4C}", "\u{BA4C}", "\u{1106}\u{1165}\u{11BB}", "\u{BA4C}", "\u{1106}\u{1165}\u{11BB}"),
    ("\u{BA4D}", "\u{BA4D}", "\u{1106}\u{1165}\u{11BC}", "\u{BA4D}", "\u{1106}\u{1165}\u{11BC}"),
    ("\u{BA4E}", "\u{BA4E}", "\u{1106}\u{1165}\u{11BD}", "\u{BA4E}", "\u{1106}\u{1165}\u{11BD}"),
    ("\u{BA4F}", "\u{BA4F}", "\u{1106}\u{1165}\u{11BE}", "\u{BA4F}", "\u{1106}\u{1165}\u{11BE}"),
    ("\u{BA50}", "\u{BA50}", "\u{1106}\u{1165}\u{11BF}", "\u{BA50}", "\u{1106}\u{1165}\u{11BF}"),
    ("\u{BA51}", "\u{BA51}", "\u{1106}\u{1165}\u{11C0}", "\u{BA51}", "\u{1106}\u{1165}\u{11C0}"),
    ("\u{BA52}", "\u{BA52}", "\u{1106}\u{1165}\u{11C1}", "\u{BA52}", "\u{1106}\u{1165}\u{11C1}"),
    ("\u{BA53}", "\u{BA53}", "\u{1106}\u{1165}\u{11C2}", "\u{BA53}", "\u{1106}\u{1165}\u{11C2}"),
    ("\u{BA54}", "\u{BA54}", "\u{1106}\u{1166}", "\u{BA54}", "\u{1106}\u{1166}"),
    ("\u{BA55}", "\u{BA55}", "\u{1106}\u{1166}\u{11A8}", "\u{BA55}", "\u{1106}\u{1166}\u{11A8}"),
    ("\u{BA56}", "\u{BA56}", "\u{1106}\u{1166}\u{11A9}", "\u{BA56}", "\u{1106}\u{1166}\u{11A9}"),
    ("\u{BA57}", "\u{BA57}", "\u{1106}\u{1166}\u{11AA}", "\u{BA57}", "\u{1106}\u{1166}\u{11AA}"),
    ("\u{BA58}", "\u{BA58}", "\u{1106}\u{1166}\u{11AB}", "\u{BA58}", "\u{1106}\u{1166}\u{11AB}"),
    ("\u{BA59}", "\u{BA59}", "\u{1106}\u{1166}\u{11AC}", "\u{BA59}", "\u{1106}\u{1166}\u{11AC}"),
    ("\u{BA5A}", "\u{BA5A}", "\u{1106}\u{1166}\u{11AD}", "\u{BA5A}", "\u{1106}\u{1166}\u{11AD}"),
    ("\u{BA5B}", "\u{BA5B}", "\u{1106}\u{1166}\u{11AE}", "\u{BA5B}", "\u{1106}\u{1166}\u{11AE}"),
    ("\u{BA5C}", "\u{BA5C}", "\u{1106}\u{1166}\u{11AF}", "\u{BA5C}", "\u{1106}\u{1166}\u{11AF}"),
    ("\u{BA5D}", "\u{BA5D}", "\u{1106}\u{1166}\u{11B0}", "\u{BA5D}", "\u{1106}\u{1166}\u{11B0}"),
    ("\u{BA5E}", "\u{BA5E}", "\u{1106}\u{1166}\u{11B1}", "\u{BA5E}", "\u{1106}\u{1166}\u{11B1}"),
    ("\u{BA5F}", "\u{BA5F}", "\u{1106}\u{1166}\u{11B2}", "\u{BA5F}", "\u{1106}\u{1166}\u{11B2}"),
    ("\u{BA60}", "\u{BA60}", "\u{1106}\u{1166}\u{11B3}", "\u{BA60}", "\u{1106}\u{1166}\u{11B3}"),
    ("\u{BA61}", "\u{BA61}", "\u{1106}\u{1166}\u{11B4}", "\u{BA61}", "\u{1106}\u{1166}\u{11B4}"),
    ("\u{BA62}", "\u{BA62}", "\u{1106}\u{1166}\u{11B5}", "\u{BA62}", "\u{1106}\u{1166}\u{11B5}"),
    ("\u{BA63}", "\u{BA63}", "\u{1106}\u{1166}\u{11B6}", "\u{BA63}", "\u{1106}\u{1166}\u{11B6}"),
    ("\u{BA64}", "\u{BA64}", "\u{1106}\u{1166}\u{11B7}", "\u{BA64}", "\u{1106}\u{1166}\u{11B7}"),
    ("\u{BA65}", "\u{BA65}", "\u{1106}\u{1166}\u{11B8}", "\u{BA65}", "\u{1106}\u{1166}\u{11B8}"),
    ("\u{BA66}", "\u{BA66}", "\u{1106}\u{1166}\u{11B9}", "\u{BA66}", "\u{1106}\u{1166}\u{11B9}"),
    ("\u{BA67}", "\u{BA67}", "\u{1106}\u{1166}\u{11BA}", "\u{BA67}", "\u{1106}\u{1166}\u{11BA}"),
    ("\u{BA68}", "\u{BA68}", "\u{1106}\u{1166}\u{11BB}", "\u{BA68}", "\u{1106}\u{1166}\u{11BB}"),
    ("\u{BA69}", "\u{BA69}", "\u{1106}\u{1166}\u{11BC}", "\u{BA69}", "\u{1106}\u{1166}\u{11BC}"),
    ("\u{BA6A}", "\u{BA6A}", "\u{1106}\u{1166}\u{11BD}", "\u{BA6A}", "\u{1106}\u{1166}\u{11BD}"),
    ("\u{BA6B}", "\u{BA6B}", "\u{1106}\u{1166}\u{11BE}", "\u{BA6B}", "\u{1106}\u{1166}\u{11BE}"),
    ("\u{BA6C}", "\u{BA6C}", "\u{1106}\u{1166}\u{11BF}", "\u{BA6C}", "\u{1106}\u{1166}\u{11BF}"),
    ("\u{BA6D}", "\u{BA6D}", "\u{1106}\u{1166}\u{11C0}", "\u{BA6D}", "\u{1106}\u{1166}\u{11C0}"),
    ("\u{BA6E}", "\u{BA6E}", "\u{1106}\u{1166}\u{11C1}", "\u{BA6E}", "\u{1106}\u{1166}\u{11C1}"),
    ("\u{BA6F}", "\u{BA6F}", "\u{1106}\u{1166}\u{11C2}", "\u{BA6F}", "\u{1106}\u{1166}\u{11C2}"),
    ("\u{BA70}", "\u{BA70}", "\u{1106}\u{1167}", "\u{BA70}", "\u{1106}\u{1167}"),
    ("\u{BA71}", "\u{BA71}", "\u{1106}\u{1167}\u{11A8}", "\u{BA71}", "\u{1106}\u{1167}\u{11A8}"),
    ("\u{BA72}", "\u{BA72}", "\u{1106}\u{1167}\u{11A9}", "\u{BA72}", "\u{1106}\u{1167}\u{11A9}"),
    ("\u{BA73}", "\u{BA73}", "\u{1106}\u{1167}\u{11AA}", "\u{BA73}", "\u{1106}\u{1167}\u{11AA}"),
    ("\u{BA74}", "\u{BA74}", "\u{1106}\u{1167}\u{11AB}", "\u{BA74}", "\u{1106}\u{1167}\u{11AB}"),
    ("\u{BA75}", "\u{BA75}", "\u{1106}\u{1167}\u{11AC}", "\u{BA75}", "\u{1106}\u{1167}\u{11AC}"),
    ("\u{BA76}", "\u{BA76}", "\u{1106}\u{1167}\u{11AD}", "\u{BA76}", "\u{1106}\u{1167}\u{11AD}"),
    ("\u{BA77}", "\u{BA77}", "\u{1106}\u{1167}\u{11AE}", "\u{BA77}", "\u{1106}\u{1167}\u{11AE}"),
    ("\u{BA78}", "\u{BA78}", "\u{1106}\u{1167}\u{11AF}", "\u{BA78}", "\u{1106}\u{1167}\u{11AF}"),
    ("\u{BA79}", "\u{BA79}", "\u{1106}\u{1167}\u{11B0}", "\u{BA79}", "\u{1106}\u{1167}\u{11B0}"),
    ("\u{BA7A}", "\u{BA7A}", "\u{1106}\u{1167}\u{11B1}", "\u{BA7A}", "\u{1106}\u{1167}\u{11B1}"),
    ("\u{BA7B}", "\u{BA7B}", "\u{1106}\u{1167}\u{11B2}", "\u{BA7B}", "\u{1106}\u{1167}\u{11B2}"),
    ("\u{BA7C}", "\u{BA7C}", "\u{1106}\u{1167}\u{11B3}", "\u{BA7C}", "\u{1106}\u{1167}\u{11B3}"),
    ("\u{BA7D}", "\u{BA7D}", "\u{1106}\u{1167}\u{11B4}", "\u{BA7D}", "\u{1106}\u{1167}\u{11B4}"),
    ("\u{BA7E}", "\u{BA7E}", "\u{1106}\u{1167}\u{11B5}", "\u{BA7E}", "\u{1106}\u{1167}\u{11B5}"),
    ("\u{BA7F}", "\u{BA7F}", "\u{1106}\u{1167}\u{11B6}", "\u{BA7F}", "\u{1106}\u{1167}\u{11B6}"),
    ("\u{BA80}", "\u{BA80}", "\u{1106}\u{1167}\u{11B7}", "\u{BA80}", "\u{1106}\u{1167}\u{11B7}"),
    ("\u{BA81}", "\u{BA81}", "\u{1106}\u{1167}\u{11B8}", "\u{BA81}", "\u{1106}\u{1167}\u{11B8}"),
    ("\u{BA82}", "\u{BA82}", "\u{1106}\u{1167}\u{11B9}", "\u{BA82}", "\u{1106}\u{1167}\u{11B9}"),
    ("\u{BA83}", "\u{BA83}", "\u{1106}\u{1167}\u{11BA}", "\u{BA83}", "\u{1106}\u{1167}\u{11BA}"),
    ("\u{BA84}", "\u{BA84}", "\u{1106}\u{1167}\u{11BB}", "\u{BA84}", "\u{1106}\u{1167}\u{11BB}"),
    ("\u{BA85}", "\u{BA85}", "\u{1106}\u{1167}\u{11BC}", "\u{BA85}", "\u{1106}\u{1167}\u{11BC}"),
    ("\u{BA86}", "\u{BA86}", "\u{1106}\u{1167}\u{11BD}", "\u{BA86}", "\u{1106}\u{1167}\u{11BD}"),
    ("\u{BA87}", "\u{BA87}", "\u{1106}\u{1167}\u{11BE}", "\u{BA87}", "\u{1106}\u{1167}\u{11BE}"),
    ("\u{BA88}", "\u{BA88}", "\u{1106}\u{1167}\u{11BF}", "\u{BA88}", "\u{1106}\u{1167}\u{11BF}"),
    ("\u{BA89}", "\u{BA89}", "\u{1106}\u{1167}\u{11C0}", "\u{BA89}", "\u{1106}\u{1167}\u{11C0}"),
    ("\u{BA8A}", "\u{BA8A}", "\u{1106}\u{1167}\u{11C1}", "\u{BA8A}", "\u{1106}\u{1167}\u{11C1}"),
    ("\u{BA8B}", "\u{BA8B}", "\u{1106}\u{1167}\u{11C2}", "\u{BA8B}", "\u{1106}\u{1167}\u{11C2}"),
    ("\u{BA8C}", "\u{BA8C}", "\u{1106}\u{1168}", "\u{BA8C}", "\u{1106}\u{1168}"),
    ("\u{BA8D}", "\u{BA8D}", "\u{1106}\u{1168}\u{11A8}", "\u{BA8D}", "\u{1106}\u{1168}\u{11A8}"),
    ("\u{BA8E}", "\u{BA8E}", "\u{1106}\u{1168}\u{11A9}", "\u{BA8E}", "\u{1106}\u{1168}\u{11A9}"),
    ("\u{BA8F}", "\u{BA8F}", "\u{1106}\u{1168}\u{11AA}", "\u{BA8F}", "\u{1106}\u{1168}\u{11AA}"),
    ("\u{BA90}", "\u{BA90}", "\u{1106}\u{1168}\u{11AB}", "\u{BA90}", "\u{1106}\u{1168}\u{11AB}"),
    ("\u{BA91}", "\u{BA91}", "\u{1106}\u{1168}\u{11AC}", "\u{BA91}", "\u{1106}\u{1168}\u{11AC}"),
    ("\u{BA92}", "\u{BA92}", "\u{1106}\u{1168}\u{11AD}", "\u{BA92}", "\u{1106}\u{1168}\u{11AD}"),
    ("\u{BA93}", "\u{BA93}", "\u{1106}\u{1168}\u{11AE}", "\u{BA93}", "\u{1106}\u{1168}\u{11AE}"),
    ("\u{BA94}", "\u{BA94}", "\u{1106}\u{1168}\u{11AF}", "\u{BA94}", "\u{1106}\u{1168}\u{11AF}"),
    ("\u{BA95}", "\u{BA95}", "\u{1106}\u{1168}\u{11B0}", "\u{BA95}", "\u{1106}\u{1168}\u{11B0}"),
    ("\u{BA96}", "\u{BA96}", "\u{1106}\u{1168}\u{11B1}", "\u{BA96}", "\u{1106}\u{1168}\u{11B1}"),
    ("\u{BA97}", "\u{BA97}", "\u{1106}\u{1168}\u{11B2}", "\u{BA97}", "\u{1106}\u{1168}\u{11B2}"),
    ("\u{BA98}", "\u{BA98}", "\u{1106}\u{1168}\u{11B3}", "\u{BA98}", "\u{1106}\u{1168}\u{11B3}"),
    ("\u{BA99}", "\u{BA99}", "\u{1106}\u{1168}\u{11B4}", "\u{BA99}", "\u{1106}\u{1168}\u{11B4}"),
    ("\u{BA9A}", "\u{BA9A}", "\u{1106}\u{1168}\u{11B5}", "\u{BA9A}", "\u{1106}\u{1168}\u{11B5}"),
    ("\u{BA9B}", "\u{BA9B}", "\u{1106}\u{1168}\u{11B6}", "\u{BA9B}", "\u{1106}\u{1168}\u{11B6}"),
    ("\u{BA9C}", "\u{BA9C}", "\u{1106}\u{1168}\u{11B7}", "\u{BA9C}", "\u{1106}\u{1168}\u{11B7}"),
    ("\u{BA9D}", "\u{BA9D}", "\u{1106}\u{1168}\u{11B8}", "\u{BA9D}", "\u{1106}\u{1168}\u{11B8}"),
    ("\u{BA9E}", "\u{BA9E}", "\u{1106}\u{1168}\u{11B9}", "\u{BA9E}", "\u{1106}\u{1168}\u{11B9}"),
    ("\u{BA9F}", "\u{BA9F}", "\u{1106}\u{1168}\u{11BA}", "\u{BA9F}", "\u{1106}\u{1168}\u{11BA}"),
    ("\u{BAA0}", "\u{BAA0}", "\u{1106}\u{1168}\u{11BB}", "\u{BAA0}", "\u{1106}\u{1168}\u{11BB}"),
    ("\u{BAA1}", "\u{BAA1}", "\u{1106}\u{1168}\u{11BC}", "\u{BAA1}", "\u{1106}\u{1168}\u{11BC}"),
    ("\u{BAA2}", "\u{BAA2}", "\u{1106}\u{1168}\u{11BD}", "\u{BAA2}", "\u{1106}\u{1168}\u{11BD}"),
    ("\u{BAA3}", "\u{BAA3}", "\u{1106}\u{1168}\u{11BE}", "\u{BAA3}", "\u{1106}\u{1168}\u{11BE}"),
    ("\u{BAA4}", "\u{BAA4}", "\u{1106}\u{1168}\u{11BF}", "\u{BAA4}", "\u{1106}\u{1168}\u{11BF}"),
    ("\u{BAA5}", "\u{BAA5}", "\u{1106}\u{1168}\u{11C0}", "\u{BAA5}", "\u{1106}\u{1168}\u{11C0}"),
    ("\u{BAA6}", "\u{BAA6}", "\u{1106}\u{1168}\u{11C1}", "\u{BAA6}", "\u{1106}\u{1168}\u{11C1}"),
    ("\u{BAA7}", "\u{BAA7}", "\u{1106}\u{1168}\u{11C2}", "\u{BAA7}", "\u{1106}\u{1168}\u{11C2}"),
    ("\u{BAA8}", "\u{BAA8}", "\u{1106}\u{1169}", "\u{BAA8}", "\u{1106}\u{1169}"),
    ("\u{BAA9}", "\u{BAA9}", "\u{1106}\u{1169}\u{11A8}", "\u{BAA9}", "\u{1106}\u{1169}\u{11A8}"),
    ("\u{BAAA}", "\u{BAAA}", "\u{1106}\u{1169}\u{11A9}", "\u{BAAA}", "\u{1106}\u{1169}\u{11A9}"),
    ("\u{BAAB}", "\u{BAAB}", "\u{1106}\u{1169}\u{11AA}", "\u{BAAB}", "\u{1106}\u{1169}\u{11AA}"),
    ("\u{BAAC}", "\u{BAAC}", "\u{1106}\u{1169}\u{11AB}", "\u{BAAC}", "\u{1106}\u{1169}\u{11AB}"),
    ("\u{BAAD}", "\u{BAAD}", "\u{1106}\u{1169}\u{11AC}", "\u{BAAD}", "\u{1106}\u{1169}\u{11AC}"),
    ("\u{BAAE}", "\u{BAAE}", "\u{1106}\u{1169}\u{11AD}", "\u{BAAE}", "\u{1106}\u{1169}\u{11AD}"),
    ("\u{BAAF}", "\u{BAAF}", "\u{1106}\u{1169}\u{11AE}", "\u{BAAF}", "\u{1106}\u{1169}\u{11AE}"),
    ("\u{BAB0}", "\u{BAB0}", "\u{1106}\u{1169}\u{11AF}", "\u{BAB0}", "\u{1106}\u{1169}\u{11AF}"),
    ("\u{BAB1}", "\u{BAB1}", "\u{1106}\u{1169}\u{11B0}", "\u{BAB1}", "\u{1106}\u{1169}\u{11B0}"),
    ("\u{BAB2}", "\u{BAB2}", "\u{1106}\u{1169}\u{11B1}", "\u{BAB2}", "\u{1106}\u{1169}\u{11B1}"),
    ("\u{BAB3}", "\u{BAB3}", "\u{1106}\u{1169}\u{11B2}", "\u{BAB3}", "\u{1106}\u{1169}\u{11B2}"),
    ("\u{BAB4}", "\u{BAB4}", "\u{1106}\u{1169}\u{11B3}", "\u{BAB4}", "\u{1106}\u{1169}\u{11B3}"),
    ("\u{BAB5}", "\u{BAB5}", "\u{1106}\u{1169}\u{11B4}", "\u{BAB5}", "\u{1106}\u{1169}\u{11B4}"),
    ("\u{BAB6}", "\u{BAB6}", "\u{1106}\u{1169}\u{11B5}", "\u{BAB6}", "\u{1106}\u{1169}\u{11B5}"),
    ("\u{BAB7}", "\u{BAB7}", "\u{1106}\u{1169}\u{11B6}", "\u{BAB7}", "\u{1106}\u{1169}\u{11B6}"),
    ("\u{BAB8}", "\u{BAB8}", "\u{1106}\u{1169}\u{11B7}", "\u{BAB8}", "\u{1106}\u{1169}\u{11B7}"),
    ("\u{BAB9}", "\u{BAB9}", "\u{1106}\u{1169}\u{11B8}", "\u{BAB9}", "\u{1106}\u{1169}\u{11B8}"),
    ("\u{BABA}", "\u{BABA}", "\u{1106}\u{1169}\u{11B9}", "\u{BABA}", "\u{1106}\u{1169}\u{11B9}"),
    ("\u{BABB}", "\u{BABB}", "\u{1106}\u{1169}\u{11BA}", "\u{BABB}", "\u{1106}\u{1169}\u{11BA}"),
    ("\u{BABC}", "\u{BABC}", "\u{1106}\u{1169}\u{11BB}", "\u{BABC}", "\u{1106}\u{1169}\u{11BB}"),
    ("\u{BABD}", "\u{BABD}", "\u{1106}\u{1169}\u{11BC}", "\u{BABD}", "\u{1106}\u{1169}\u{11BC}"),
    ("\u{BABE}", "\u{BABE}", "\u{1106}\u{1169}\u{11BD}", "\u{BABE}", "\u{1106}\u{1169}\u{11BD}"),
    ("\u{BABF}", "\u{BABF}", "\u{1106}\u{1169}\u{11BE}", "\u{BABF}", "\u{1106}\u{1169}\u{11BE}"),
    ("\u{BAC0}", "\u{BAC0}", "\u{1106}\u{1169}\u{11BF}", "\u{BAC0}", "\u{1106}\u{1169}\u{11BF}"),
    ("\u{BAC1}", "\u{BAC1}", "\u{1106}\u{1169}\u{11C0}", "\u{BAC1}", "\u{1106}\u{1169}\u{11C0}"),
    ("\u{BAC2}", "\u{BAC2}", "\u{1106}\u{1169}\u{11C1}", "\u{BAC2}", "\u{1106}\u{1169}\u{11C1}"),
    ("\u{BAC3}", "\u{BAC3}", "\u{1106}\u{1169}\u{11C2}", "\u{BAC3}", "\u{1106}\u{1169}\u{11C2}"),
    ("\u{BAC4}", "\u{BAC4}", "\u{1106}\u{116A}", "\u{BAC4}", "\u{1106}\u{116A}"),
    ("\u{BAC5}", "\u{BAC5}", "\u{1106}\u{116A}\u{11A8}", "\u{BAC5}", "\u{1106}\u{116A}\u{11A8}"),
    ("\u{BAC6}", "\u{BAC6}", "\u{1106}\u{116A}\u{11A9}", "\u{BAC6}", "\u{1106}\u{116A}\u{11A9}"),
    ("\u{BAC7}", "\u{BAC7}", "\u{1106}\u{116A}\u{11AA}", "\u{BAC7}", "\u{1106}\u{116A}\u{11AA}"),
    ("\u{BAC8}", "\u{BAC8}", "\u{1106}\u{116A}\u{11AB}", "\u{BAC8}", "\u{1106}\u{116A}\u{11AB}"),
    ("\u{BAC9}", "\u{BAC9}", "\u{1106}\u{116A}\u{11AC}", "\u{BAC9}", "\u{1106}\u{116A}\u{11AC}"),
    ("\u{BACA}", "\u{BACA}", "\u{1106}\u{116A}\u{11AD}", "\u{BACA}", "\u{1106}\u{116A}\u{11AD}"),
    ("\u{BACB}", "\u{BACB}", "\u{1106}\u{116A}\u{11AE}", "\u{BACB}", "\u{1106}\u{116A}\u{11AE}"),
    ("\u{BACC}", "\u{BACC}", "\u{1106}\u{116A}\u{11AF}", "\u{BACC}", "\u{1106}\u{116A}\u{11AF}"),
    ("\u{BACD}", "\u{BACD}", "\u{1106}\u{116A}\u{11B0}", "\u{BACD}", "\u{1106}\u{116A}\u{11B0}"),
    ("\u{BACE}", "\u{BACE}", "\u{1106}\u{116A}\u{11B1}", "\u{BACE}", "\u{1106}\u{116A}\u{11B1}"),
    ("\u{BACF}", "\u{BACF}", "\u{1106}\u{116A}\u{11B2}", "\u{BACF}", "\u{1106}\u{116A}\u{11B2}"),
    ("\u{BAD0}", "\u{BAD0}", "\u{1106}\u{116A}\u{11B3}", "\u{BAD0}", "\u{1106}\u{116A}\u{11B3}"),
    ("\u{BAD1}", "\u{BAD1}", "\u{1106}\u{116A}\u{11B4}", "\u{BAD1}", "\u{1106}\u{116A}\u{11B4}"),
    ("\u{BAD2}", "\u{BAD2}", "\u{1106}\u{116A}\u{11B5}", "\u{BAD2}", "\u{1106}\u{116A}\u{11B5}"),
    ("\u{BAD3}", "\u{BAD3}", "\u{1106}\u{116A}\u{11B6}", "\u{BAD3}", "\u{1106}\u{116A}\u{11B6}"),
    ("\u{BAD4}", "\u{BAD4}", "\u{1106}\u{116A}\u{11B7}", "\u{BAD4}", "\u{1106}\u{116A}\u{11B7}"),
    ("\u{BAD5}", "\u{BAD5}", "\u{1106}\u{116A}\u{11B8}", "\u{BAD5}", "\u{1106}\u{116A}\u{11B8}"),
    ("\u{BAD6}", "\u{BAD6}", "\u{1106}\u{116A}\u{11B9}", "\u{BAD6}", "\u{1106}\u{116A}\u{11B9}"),
    ("\u{BAD7}", "\u{BAD7}", "\u{1106}\u{116A}\u{11BA}", "\u{BAD7}", "\u{1106}\u{116A}\u{11BA}"),
    ("\u{BAD8}", "\u{BAD8}", "\u{1106}\u{116A}\u{11BB}", "\u{BAD8}", "\u{1106}\u{116A}\u{11BB}"),
    ("\u{BAD9}", "\u{BAD9}", "\u{1106}\u{116A}\u{11BC}", "\u{BAD9}", "\u{1106}\u{116A}\u{11BC}"),
    ("\u{BADA}", "\u{BADA}", "\u{1106}\u{116A}\u{11BD}", "\u{BADA}", "\u{1106}\u{116A}\u{11BD}"),
    ("\u{BADB}", "\u{BADB}", "\u{1106}\u{116A}\u{11BE}", "\u{BADB}", "\u{1106}\u{116A}\u{11BE}"),
    ("\u{BADC}", "\u{BADC}", "\u{1106}\u{116A}\u{11BF}", "\u{BADC}", "\u{1106}\u{116A}\u{11BF}"),
    ("\u{BADD}", "\u{BADD}", "\u{1106}\u{116A}\u{11C0}", "\u{BADD}", "\u{1106}\u{116A}\u{11C0}"),
    ("\u{BADE}", "\u{BADE}", "\u{1106}\u{116A}\u{11C1}", "\u{BADE}", "\u{1106}\u{116A}\u{11C1}"),
    ("\u{BADF}", "\u{BADF}", "\u{1106}\u{116A}\u{11C2}", "\u{BADF}", "\u{1106}\u{116A}\u{11C2}"),
    ("\u{BAE0}", "\u{BAE0}", "\u{1106}\u{116B}", "\u{BAE0}", "\u{1106}\u{116B}"),
    ("\u{BAE1}", "\u{BAE1}", "\u{1106}\u{116B}\u{11A8}", "\u{BAE1}", "\u{1106}\u{116B}\u{11A8}"),
    ("\u{BAE2}", "\u{BAE2}", "\u{1106}\u{116B}\u{11A9}", "\u{BAE2}", "\u{1106}\u{116B}\u{11A9}"),
    ("\u{BAE3}", "\u{BAE3}", "\u{1106}\u{116B}\u{11AA}", "\u{BAE3}", "\u{1106}\u{116B}\u{11AA}"),
    ("\u{BAE4}", "\u{BAE4}", "\u{1106}\u{116B}\u{11AB}", "\u{BAE4}", "\u{1106}\u{116B}\u{11AB}"),
    ("\u{BAE5}", "\u{BAE5}", "\u{1106}\u{116B}\u{11AC}", "\u{BAE5}", "\u{1106}\u{116B}\u{11AC}"),
    ("\u{BAE6}", "\u{BAE6}", "\u{1106}\u{116B}\u{11AD}", "\u{BAE6}", "\u{1106}\u{116B}\u{11AD}"),
    ("\u{BAE7}", "\u{BAE7}", "\u{1106}\u{116B}\u{11AE}", "\u{BAE7}", "\u{1106}\u{116B}\u{11AE}"),
    ("\u{BAE8}", "\u{BAE8}", "\u{1106}\u{116B}\u{11AF}", "\u{BAE8}", "\u{1106}\u{116B}\u{11AF}"),
    ("\u{BAE9}", "\u{BAE9}", "\u{1106}\u{116B}\u{11B0}", "\u{BAE9}", "\u{1106}\u{116B}\u{11B0}"),
    ("\u{BAEA}", "\u{BAEA}", "\u{1106}\u{116B}\u{11B1}", "\u{BAEA}", "\u{1106}\u{116B}\u{11B1}"),
    ("\u{BAEB}", "\u{BAEB}", "\u{1106}\u{116B}\u{11B2}", "\u{BAEB}", "\u{1106}\u{116B}\u{11B2}"),
    ("\u{BAEC}", "\u{BAEC}", "\u{1106}\u{116B}\u{11B3}", "\u{BAEC}", "\u{1106}\u{116B}\u{11B3}"),
    ("\u{BAED}", "\u{BAED}", "\u{1106}\u{116B}\u{11B4}", "\u{BAED}", "\u{1106}\u{116B}\u{11B4}"),
    ("\u{BAEE}", "\u{BAEE}", "\u{1106}\u{116B}\u{11B5}", "\u{BAEE}", "\u{1106}\u{116B}\u{11B5}"),
    ("\u{BAEF}", "\u{BAEF}", "\u{1106}\u{116B}\u{11B6}", "\u{BAEF}", "\u{1106}\u{116B}\u{11B6}"),
    ("\u{BAF0}", "\u{BAF0}", "\u{1106}\u{116B}\u{11B7}", "\u{BAF0}", "\u{1106}\u{116B}\u{11B7}"),
    ("\u{BAF1}", "\u{BAF1}", "\u{1106}\u{116B}\u{11B8}", "\u{BAF1}", "\u{1106}\u{116B}\u{11B8}"),
    ("\u{BAF2}", "\u{BAF2}", "\u{1106}\u{116B}\u{11B9}", "\u{BAF2}", "\u{1106}\u{116B}\u{11B9}"),
    ("\u{BAF3}", "\u{BAF3}", "\u{1106}\u{116B}\u{11BA}", "\u{BAF3}", "\u{1106}\u{116B}\u{11BA}"),
    ("\u{BAF4}", "\u{BAF4}", "\u{1106}\u{116B}\u{11BB}", "\u{BAF4}", "\u{1106}\u{116B}\u{11BB}"),
    ("\u{BAF5}", "\u{BAF5}", "\u{1106}\u{116B}\u{11BC}", "\u{BAF5}", "\u{1106}\u{116B}\u{11BC}"),
    ("\u{BAF6}", "\u{BAF6}", "\u{1106}\u{116B}\u{11BD}", "\u{BAF6}", "\u{1106}\u{116B}\u{11BD}"),
    ("\u{BAF7}", "\u{BAF7}", "\u{1106}\u{116B}\u{11BE}", "\u{BAF7}", "\u{1106}\u{116B}\u{11BE}"),
    ("\u{BAF8}", "\u{BAF8}", "\u{1106}\u{116B}\u{11BF}", "\u{BAF8}", "\u{1106}\u{116B}\u{11BF}"),
    ("\u{BAF9}", "\u{BAF9}", "\u{1106}\u{116B}\u{11C0}", "\u{BAF9}", "\u{1106}\u{116B}\u{11C0}"),
    ("\u{BAFA}", "\u{BAFA}", "\u{1106}\u{116B}\u{11C1}", "\u{BAFA}", "\u{1106}\u{116B}\u{11C1}"),
    ("\u{BAFB}", "\u{BAFB}", "\u{1106}\u{116B}\u{11C2}", "\u{BAFB}", "\u{1106}\u{116B}\u{11C2}"),
    ("\u{BAFC}", "\u{BAFC}", "\u{1106}\u{116C}", "\u{BAFC}", "\u{1106}\u{116C}"),
    ("\u{BAFD}", "\u{BAFD}", "\u{1106}\u{116C}\u{11A8}", "\u{BAFD}", "\u{1106}\u{116C}\u{11A8}"),
    ("\u{BAFE}", "\u{BAFE}", "\u{1106}\u{116C}\u{11A9}", "\u{BAFE}", "\u{1106}\u{116C}\u{11A9}"),
    ("\u{BAFF}", "\u{BAFF}", "\u{1106}\u{116C}\u{11AA}", "\u{BAFF}", "\u{1106}\u{116C}\u{11AA}"),
    ("\u{BB00}", "\u{BB00}", "\u{1106}\u{116C}\u{11AB}", "\u{BB00}", "\u{1106}\u{116C}\u{11AB}"),
    ("\u{BB01}", "\u{BB01}", "\u{1106}\u{116C}\u{11AC}", "\u{BB01}", "\u{1106}\u{116C}\u{11AC}"),
    ("\u{BB02}", "\u{BB02}", "\u{1106}\u{116C}\u{11AD}", "\u{BB02}", "\u{1106}\u{116C}\u{11AD}"),
    ("\u{BB03}", "\u{BB03}", "\u{1106}\u{116C}\u{11AE}", "\u{BB03}", "\u{1106}\u{116C}\u{11AE}"),
    ("\u{BB04}", "\u{BB04}", "\u{1106}\u{116C}\u{11AF}", "\u{BB04}", "\u{1106}\u{116C}\u{11AF}"),
    ("\u{BB05}", "\u{BB05}", "\u{1106}\u{116C}\u{11B0}", "\u{BB05}", "\u{1106}\u{116C}\u{11B0}"),
    ("\u{BB06}", "\u{BB06}", "\u{1106}\u{116C}\u{11B1}", "\u{BB06}", "\u{1106}\u{116C}\u{11B1}"),
    ("\u{BB07}", "\u{BB07}", "\u{1106}\u{116C}\u{11B2}", "\u{BB07}", "\u{1106}\u{116C}\u{11B2}"),
    ("\u{BB08}", "\u{BB08}", "\u{1106}\u{116C}\u{11B3}", "\u{BB08}", "\u{1106}\u{116C}\u{11B3}"),
    ("\u{BB09}", "\u{BB09}", "\u{1106}\u{116C}\u{11B4}", "\u{BB09}", "\u{1106}\u{116C}\u{11B4}"),
    ("\u{BB0A}", "\u{BB0A}", "\u{1106}\u{116C}\u{11B5}", "\u{BB0A}", "\u{1106}\u{116C}\u{11B5}"),
    ("\u{BB0B}", "\u{BB0B}", "\u{1106}\u{116C}\u{11B6}", "\u{BB0B}", "\u{1106}\u{116C}\u{11B6}"),
    ("\u{BB0C}", "\u{BB0C}", "\u{1106}\u{116C}\u{11B7}", "\u{BB0C}", "\u{1106}\u{116C}\u{11B7}"),
    ("\u{BB0D}", "\u{BB0D}", "\u{1106}\u{116C}\u{11B8}", "\u{BB0D}", "\u{1106}\u{116C}\u{11B8}"),
    ("\u{BB0E}", "\u{BB0E}", "\u{1106}\u{116C}\u{11B9}", "\u{BB0E}", "\u{1106}\u{116C}\u{11B9}"),
    ("\u{BB0F}", "\u{BB0F}", "\u{1106}\u{116C}\u{11BA}", "\u{BB0F}", "\u{1106}\u{116C}\u{11BA}"),
    ("\u{BB10}", "\u{BB10}", "\u{1106}\u{116C}\u{11BB}", "\u{BB10}", "\u{1106}\u{116C}\u{11BB}"),
    ("\u{BB11}", "\u{BB11}", "\u{1106}\u{116C}\u{11BC}", "\u{BB11}", "\u{1106}\u{116C}\u{11BC}"),
    ("\u{BB12}", "\u{BB12}", "\u{1106}\u{116C}\u{11BD}", "\u{BB12}", "\u{1106}\u{116C}\u{11BD}"),
    ("\u{BB13}", "\u{BB13}", "\u{1106}\u{116C}\u{11BE}", "\u{BB13}", "\u{1106}\u{116C}\u{11BE}"),
    ("\u{BB14}", "\u{BB14}", "\u{1106}\u{116C}\u{11BF}", "\u{BB14}", "\u{1106}\u{116C}\u{11BF}"),
    ("\u{BB15}", "\u{BB15}", "\u{1106}\u{116C}\u{11C0}", "\u{BB15}", "\u{1106}\u{116C}\u{11C0}"),
    ("\u{BB16}", "\u{BB16}", "\u{1106}\u{116C}\u{11C1}", "\u{BB16}", "\u{1106}\u{116C}\u{11C1}"),
    ("\u{BB17}", "\u{BB17}", "\u{1106}\u{116C}\u{11C2}", "\u{BB17}", "\u{1106}\u{116C}\u{11C2}"),
    ("\u{BB18}", "\u{BB18}", "\u{1106}\u{116D}", "\u{BB18}", "\u{1106}\u{116D}"),
    ("\u{BB19}", "\u{BB19}", "\u{1106}\u{116D}\u{11A8}", "\u{BB19}", "\u{1106}\u{116D}\u{11A8}"),
    ("\u{BB1A}", "\u{BB1A}", "\u{1106}\u{116D}\u{11A9}", "\u{BB1A}", "\u{1106}\u{116D}\u{11A9}"),
    ("\u{BB1B}", "\u{BB1B}", "\u{1106}\u{116D}\u{11AA}", "\u{BB1B}", "\u{1106}\u{116D}\u{11AA}"),
    ("\u{BB1C}", "\u{BB1C}", "\u{1106}\u{116D}\u{11AB}", "\u{BB1C}", "\u{1106}\u{116D}\u{11AB}"),
    ("\u{BB1D}", "\u{BB1D}", "\u{1106}\u{116D}\u{11AC}", "\u{BB1D}", "\u{1106}\u{116D}\u{11AC}"),
    ("\u{BB1E}", "\u{BB1E}", "\u{1106}\u{116D}\u{11AD}", "\u{BB1E}", "\u{1106}\u{116D}\u{11AD}"),
    ("\u{BB1F}", "\u{BB1F}", "\u{1106}\u{116D}\u{11AE}", "\u{BB1F}", "\u{1106}\u{116D}\u{11AE}"),
    ("\u{BB20}", "\u{BB20}", "\u{1106}\u{116D}\u{11AF}", "\u{BB20}", "\u{1106}\u{116D}\u{11AF}"),
    ("\u{BB21}", "\u{BB21}", "\u{1106}\u{116D}\u{11B0}", "\u{BB21}", "\u{1106}\u{116D}\u{11B0}"),
    ("\u{BB22}", "\u{BB22}", "\u{1106}\u{116D}\u{11B1}", "\u{BB22}", "\u{1106}\u{116D}\u{11B1}"),
    ("\u{BB23}", "\u{BB23}", "\u{1106}\u{116D}\u{11B2}", "\u{BB23}", "\u{1106}\u{116D}\u{11B2}"),
    ("\u{BB24}", "\u{BB24}", "\u{1106}\u{116D}\u{11B3}", "\u{BB24}", "\u{1106}\u{116D}\u{11B3}"),
    ("\u{BB25}", "\u{BB25}", "\u{1106}\u{116D}\u{11B4}", "\u{BB25}", "\u{1106}\u{116D}\u{11B4}"),
    ("\u{BB26}", "\u{BB26}", "\u{1106}\u{116D}\u{11B5}", "\u{BB26}", "\u{1106}\u{116D}\u{11B5}"),
    ("\u{BB27}", "\u{BB27}", "\u{1106}\u{116D}\u{11B6}", "\u{BB27}", "\u{1106}\u{116D}\u{11B6}"),
    ("\u{BB28}", "\u{BB28}", "\u{1106}\u{116D}\u{11B7}", "\u{BB28}", "\u{1106}\u{116D}\u{11B7}"),
    ("\u{BB29}", "\u{BB29}", "\u{1106}\u{116D}\u{11B8}", "\u{BB29}", "\u{1106}\u{116D}\u{11B8}"),
    ("\u{BB2A}", "\u{BB2A}", "\u{1106}\u{116D}\u{11B9}", "\u{BB2A}", "\u{1106}\u{116D}\u{11B9}"),
    ("\u{BB2B}", "\u{BB2B}", "\u{1106}\u{116D}\u{11BA}", "\u{BB2B}", "\u{1106}\u{116D}\u{11BA}"),
    ("\u{BB2C}", "\u{BB2C}", "\u{1106}\u{116D}\u{11BB}", "\u{BB2C}", "\u{1106}\u{116D}\u{11BB}"),
    ("\u{BB2D}", "\u{BB2D}", "\u{1106}\u{116D}\u{11BC}", "\u{BB2D}", "\u{1106}\u{116D}\u{11BC}"),
    ("\u{BB2E}", "\u{BB2E}", "\u{1106}\u{116D}\u{11BD}", "\u{BB2E}", "\u{1106}\u{116D}\u{11BD}"),
    ("\u{BB2F}", "\u{BB2F}", "\u{1106}\u{116D}\u{11BE}", "\u{BB2F}", "\u{1106}\u{116D}\u{11BE}"),
    ("\u{BB30}", "\u{BB30}", "\u{1106}\u{116D}\u{11BF}", "\u{BB30}", "\u{1106}\u{116D}\u{11BF}"),
    ("\u{BB31}", "\u{BB31}", "\u{1106}\u{116D}\u{11C0}", "\u{BB31}", "\u{1106}\u{116D}\u{11C0}"),
    ("\u{BB32}", "\u{BB32}", "\u{1106}\u{116D}\u{11C1}", "\u{BB32}", "\u{1106}\u{116D}\u{11C1}"),
    ("\u{BB33}", "\u{BB33}", "\u{1106}\u{116D}\u{11C2}", "\u{BB33}", "\u{1106}\u{116D}\u{11C2}"),
    ("\u{BB34}", "\u{BB34}", "\u{1106}\u{116E}", "\u{BB34}", "\u{1106}\u{116E}"),
    ("\u{BB35}", "\u{BB35}", "\u{1106}\u{116E}\u{11A8}", "\u{BB35}", "\u{1106}\u{116E}\u{11A8}"),
    ("\u{BB36}", "\u{BB36}", "\u{1106}\u{116E}\u{11A9}", "\u{BB36}", "\u{1106}\u{116E}\u{11A9}"),
    ("\u{BB37}", "\u{BB37}", "\u{1106}\u{116E}\u{11AA}", "\u{BB37}", "\u{1106}\u{116E}\u{11AA}"),
    ("\u{BB38}", "\u{BB38}", "\u{1106}\u{116E}\u{11AB}", "\u{BB38}", "\u{1106}\u{116E}\u{11AB}"),
    ("\u{BB39}", "\u{BB39}", "\u{1106}\u{116E}\u{11AC}", "\u{BB39}", "\u{1106}\u{116E}\u{11AC}"),
    ("\u{BB3A}", "\u{BB3A}", "\u{1106}\u{116E}\u{11AD}", "\u{BB3A}", "\u{1106}\u{116E}\u{11AD}"),
    ("\u{BB3B}", "\u{BB3B}", "\u{1106}\u{116E}\u{11AE}", "\u{BB3B}", "\u{1106}\u{116E}\u{11AE}"),
    ("\u{BB3C}", "\u{BB3C}", "\u{1106}\u{116E}\u{11AF}", "\u{BB3C}", "\u{1106}\u{116E}\u{11AF}"),
    ("\u{BB3D}", "\u{BB3D}", "\u{1106}\u{116E}\u{11B0}", "\u{BB3D}", "\u{1106}\u{116E}\u{11B0}"),
    ("\u{BB3E}", "\u{BB3E}", "\u{1106}\u{116E}\u{11B1}", "\u{BB3E}", "\u{1106}\u{116E}\u{11B1}"),
    ("\u{BB3F}", "\u{BB3F}", "\u{1106}\u{116E}\u{11B2}", "\u{BB3F}", "\u{1106}\u{116E}\u{11B2}"),
    ("\u{BB40}", "\u{BB40}", "\u{1106}\u{116E}\u{11B3}", "\u{BB40}", "\u{1106}\u{116E}\u{11B3}"),
    ("\u{BB41}", "\u{BB41}", "\u{1106}\u{116E}\u{11B4}", "\u{BB41}", "\u{1106}\u{116E}\u{11B4}"),
    ("\u{BB42}", "\u{BB42}", "\u{1106}\u{116E}\u{11B5}", "\u{BB42}", "\u{1106}\u{116E}\u{11B5}"),
    ("\u{BB43}", "\u{BB43}", "\u{1106}\u{116E}\u{11B6}", "\u{BB43}", "\u{1106}\u{116E}\u{11B6}"),
    ("\u{BB44}", "\u{BB44}", "\u{1106}\u{116E}\u{11B7}", "\u{BB44}", "\u{1106}\u{116E}\u{11B7}"),
    ("\u{BB45}", "\u{BB45}", "\u{1106}\u{116E}\u{11B8}", "\u{BB45}", "\u{1106}\u{116E}\u{11B8}"),
    ("\u{BB46}", "\u{BB46}", "\u{1106}\u{116E}\u{11B9}", "\u{BB46}", "\u{1106}\u{116E}\u{11B9}"),
    ("\u{BB47}", "\u{BB47}", "\u{1106}\u{116E}\u{11BA}", "\u{BB47}", "\u{1106}\u{116E}\u{11BA}"),
    ("\u{BB48}", "\u{BB48}", "\u{1106}\u{116E}\u{11BB}", "\u{BB48}", "\u{1106}\u{116E}\u{11BB}"),
    ("\u{BB49}", "\u{BB49}", "\u{1106}\u{116E}\u{11BC}", "\u{BB49}", "\u{1106}\u{116E}\u{11BC}"),
    ("\u{BB4A}", "\u{BB4A}", "\u{1106}\u{116E}\u{11BD}", "\u{BB4A}", "\u{1106}\u{116E}\u{11BD}"),
    ("\u{BB4B}", "\u{BB4B}", "\u{1106}\u{116E}\u{11BE}", "\u{BB4B}", "\u{1106}\u{116E}\u{11BE}"),
    ("\u{BB4C}", "\u{BB4C}", "\u{1106}\u{116E}\u{11BF}", "\u{BB4C}", "\u{1106}\u{116E}\u{11BF}"),
    ("\u{BB4D}", "\u{BB4D}", "\u{1106}\u{116E}\u{11C0}", "\u{BB4D}", "\u{1106}\u{116E}\u{11C0}"),
    ("\u{BB4E}", "\u{BB4E}", "\u{1106}\u{116E}\u{11C1}", "\u{BB4E}", "\u{1106}\u{116E}\u{11C1}"),
    ("\u{BB4F}", "\u{BB4F}", "\u{1106}\u{116E}\u{11C2}", "\u{BB4F}", "\u{1106}\u{116E}\u{11C2}"),
    ("\u{BB50}", "\u{BB50}", "\u{1106}\u{116F}", "\u{BB50}", "\u{1106}\u{116F}"),
    ("\u{BB51}", "\u{BB51}", "\u{1106}\u{116F}\u{11A8}", "\u{BB51}", "\u{1106}\u{116F}\u{11A8}"),
    ("\u{BB52}", "\u{BB52}", "\u{1106}\u{116F}\u{11A9}", "\u{BB52}", "\u{1106}\u{116F}\u{11A9}"),
    ("\u{BB53}", "\u{BB53}", "\u{1106}\u{116F}\u{11AA}", "\u{BB53}", "\u{1106}\u{116F}\u{11AA}"),
    ("\u{BB54}", "\u{BB54}", "\u{1106}\u{116F}\u{11AB}", "\u{BB54}", "\u{1106}\u{116F}\u{11AB}"),
    ("\u{BB55}", "\u{BB55}", "\u{1106}\u{116F}\u{11AC}", "\u{BB55}", "\u{1106}\u{116F}\u{11AC}"),
    ("\u{BB56}", "\u{BB56}", "\u{1106}\u{116F}\u{11AD}", "\u{BB56}", "\u{1106}\u{116F}\u{11AD}"),
    ("\u{BB57}", "\u{BB57}", "\u{1106}\u{116F}\u{11AE}", "\u{BB57}", "\u{1106}\u{116F}\u{11AE}"),
    ("\u{BB58}", "\u{BB58}", "\u{1106}\u{116F}\u{11AF}", "\u{BB58}", "\u{1106}\u{116F}\u{11AF}"),
    ("\u{BB59}", "\u{BB59}", "\u{1106}\u{116F}\u{11B0}", "\u{BB59}", "\u{1106}\u{116F}\u{11B0}"),
    ("\u{BB5A}", "\u{BB5A}", "\u{1106}\u{116F}\u{11B1}", "\u{BB5A}", "\u{1106}\u{116F}\u{11B1}"),
    ("\u{BB5B}", "\u{BB5B}", "\u{1106}\u{116F}\u{11B2}", "\u{BB5B}", "\u{1106}\u{116F}\u{11B2}"),
    ("\u{BB5C}", "\u{BB5C}", "\u{1106}\u{116F}\u{11B3}", "\u{BB5C}", "\u{1106}\u{116F}\u{11B3}"),
    ("\u{BB5D}", "\u{BB5D}", "\u{1106}\u{116F}\u{11B4}", "\u{BB5D}", "\u{1106}\u{116F}\u{11B4}"),
    ("\u{BB5E}", "\u{BB5E}", "\u{1106}\u{116F}\u{11B5}", "\u{BB5E}", "\u{1106}\u{116F}\u{11B5}"),
    ("\u{BB5F}", "\u{BB5F}", "\u{1106}\u{116F}\u{11B6}", "\u{BB5F}", "\u{1106}\u{116F}\u{11B6}"),
    ("\u{BB60}", "\u{BB60}", "\u{1106}\u{116F}\u{11B7}", "\u{BB60}", "\u{1106}\u{116F}\u{11B7}"),
    ("\u{BB61}", "\u{BB61}", "\u{1106}\u{116F}\u{11B8}", "\u{BB61}", "\u{1106}\u{116F}\u{11B8}"),
    ("\u{BB62}", "\u{BB62}", "\u{1106}\u{116F}\u{11B9}", "\u{BB62}", "\u{1106}\u{116F}\u{11B9}"),
    ("\u{BB63}", "\u{BB63}", "\u{1106}\u{116F}\u{11BA}", "\u{BB63}", "\u{1106}\u{116F}\u{11BA}"),
    ("\u{BB64}", "\u{BB64}", "\u{1106}\u{116F}\u{11BB}", "\u{BB64}", "\u{1106}\u{116F}\u{11BB}"),
    ("\u{BB65}", "\u{BB65}", "\u{1106}\u{116F}\u{11BC}", "\u{BB65}", "\u{1106}\u{116F}\u{11BC}"),
    ("\u{BB66}", "\u{BB66}", "\u{1106}\u{116F}\u{11BD}", "\u{BB66}", "\u{1106}\u{116F}\u{11BD}"),
    ("\u{BB67}", "\u{BB67}", "\u{1106}\u{116F}\u{11BE}", "\u{BB67}", "\u{1106}\u{116F}\u{11BE}"),
    ("\u{BB68}", "\u{BB68}", "\u{1106}\u{116F}\u{11BF}", "\u{BB68}", "\u{1106}\u{116F}\u{11BF}"),
    ("\u{BB69}", "\u{BB69}", "\u{1106}\u{116F}\u{11C0}", "\u{BB69}", "\u{1106}\u{116F}\u{11C0}"),
    ("\u{BB6A}", "\u{BB6A}", "\u{1106}\u{116F}\u{11C1}", "\u{BB6A}", "\u{1106}\u{116F}\u{11C1}"),
    ("\u{BB6B}", "\u{BB6B}", "\u{1106}\u{116F}\u{11C2}", "\u{BB6B}", "\u{1106}\u{116F}\u{11C2}"),
    ("\u{BB6C}", "\u{BB6C}", "\u{1106}\u{1170}", "\u{BB6C}", "\u{1106}\u{1170}"),
    ("\u{BB6D}", "\u{BB6D}", "\u{1106}\u{1170}\u{11A8}", "\u{BB6D}", "\u{1106}\u{1170}\u{11A8}"),
    ("\u{BB6E}", "\u{BB6E}", "\u{1106}\u{1170}\u{11A9}", "\u{BB6E}", "\u{1106}\u{1170}\u{11A9}"),
    ("\u{BB6F}", "\u{BB6F}", "\u{1106}\u{1170}\u{11AA}", "\u{BB6F}", "\u{1106}\u{1170}\u{11AA}"),
    ("\u{BB70}", "\u{BB70}", "\u{1106}\u{1170}\u{11AB}", "\u{BB70}", "\u{1106}\u{1170}\u{11AB}"),
    ("\u{BB71}", "\u{BB71}", "\u{1106}\u{1170}\u{11AC}", "\u{BB71}", "\u{1106}\u{1170}\u{11AC}"),
    ("\u{BB72}", "\u{BB72}", "\u{1106}\u{1170}\u{11AD}", "\u{BB72}", "\u{1106}\u{1170}\u{11AD}"),
    ("\u{BB73}", "\u{BB73}", "\u{1106}\u{1170}\u{11AE}", "\u{BB73}", "\u{1106}\u{1170}\u{11AE}"),
    ("\u{BB74}", "\u{BB74}", "\u{1106}\u{1170}\u{11AF}", "\u{BB74}", "\u{1106}\u{1170}\u{11AF}"),
    ("\u{BB75}", "\u{BB75}", "\u{1106}\u{1170}\u{11B0}", "\u{BB75}", "\u{1106}\u{1170}\u{11B0}"),
    ("\u{BB76}", "\u{BB76}", "\u{1106}\u{1170}\u{11B1}", "\u{BB76}", "\u{1106}\u{1170}\u{11B1}"),
    ("\u{BB77}", "\u{BB77}", "\u{1106}\u{1170}\u{11B2}", "\u{BB77}", "\u{1106}\u{1170}\u{11B2}"),
    ("\u{BB78}", "\u{BB78}", "\u{1106}\u{1170}\u{11B3}", "\u{BB78}", "\u{1106}\u{1170}\u{11B3}"),
    ("\u{BB79}", "\u{BB79}", "\u{1106}\u{1170}\u{11B4}", "\u{BB79}", "\u{1106}\u{1170}\u{11B4}"),
    ("\u{BB7A}", "\u{BB7A}", "\u{1106}\u{1170}\u{11B5}", "\u{BB7A}", "\u{1106}\u{1170}\u{11B5}"),
    ("\u{BB7B}", "\u{BB7B}", "\u{1106}\u{1170}\u{11B6}", "\u{BB7B}", "\u{1106}\u{1170}\u{11B6}"),
    ("\u{BB7C}", "\u{BB7C}", "\u{1106}\u{1170}\u{11B7}", "\u{BB7C}", "\u{1106}\u{1170}\u{11B7}"),
    ("\u{BB7D}", "\u{BB7D}", "\u{1106}\u{1170}\u{11B8}", "\u{BB7D}", "\u{1106}\u{1170}\u{11B8}"),
    ("\u{BB7E}", "\u{BB7E}", "\u{1106}\u{1170}\u{11B9}", "\u{BB7E}", "\u{1106}\u{1170}\u{11B9}"),
    ("\u{BB7F}", "\u{BB7F}", "\u{1106}\u{1170}\u{11BA}", "\u{BB7F}", "\u{1106}\u{1170}\u{11BA}"),
    ("\u{BB80}", "\u{BB80}", "\u{1106}\u{1170}\u{11BB}", "\u{BB80}", "\u{1106}\u{1170}\u{11BB}"),
    ("\u{BB81}", "\u{BB81}", "\u{1106}\u{1170}\u{11BC}", "\u{BB81}", "\u{1106}\u{1170}\u{11BC}"),
    ("\u{BB82}", "\u{BB82}", "\u{1106}\u{1170}\u{11BD}", "\u{BB82}", "\u{1106}\u{1170}\u{11BD}"),
    ("\u{BB83}", "\u{BB83}", "\u{1106}\u{1170}\u{11BE}", "\u{BB83}", "\u{1106}\u{1170}\u{11BE}"),
    ("\u{BB84}", "\u{BB84}", "\u{1106}\u{1170}\u{11BF}", "\u{BB84}", "\u{1106}\u{1170}\u{11BF}"),
    ("\u{BB85}", "\u{BB85}", "\u{1106}\u{1170}\u{11C0}", "\u{BB85}", "\u{1106}\u{1170}\u{11C0}"),
    ("\u{BB86}", "\u{BB86}", "\u{1106}\u{1170}\u{11C1}", "\u{BB86}", "\u{1106}\u{1170}\u{11C1}"),
    ("\u{BB87}", "\u{BB87}", "\u{1106}\u{1170}\u{11C2}", "\u{BB87}", "\u{1106}\u{1170}\u{11C2}"),
    ("\u{BB88}", "\u{BB88}", "\u{1106}\u{1171}", "\u{BB88}", "\u{1106}\u{1171}"),
    ("\u{BB89}", "\u{BB89}", "\u{1106}\u{1171}\u{11A8}", "\u{BB89}", "\u{1106}\u{1171}\u{11A8}"),
    ("\u{BB8A}", "\u{BB8A}", "\u{1106}\u{1171}\u{11A9}", "\u{BB8A}", "\u{1106}\u{1171}\u{11A9}"),
    ("\u{BB8B}", "\u{BB8B}", "\u{1106}\u{1171}\u{11AA}", "\u{BB8B}", "\u{1106}\u{1171}\u{11AA}"),
    ("\u{BB8C}", "\u{BB8C}", "\u{1106}\u{1171}\u{11AB}", "\u{BB8C}", "\u{1106}\u{1171}\u{11AB}"),
    ("\u{BB8D}", "\u{BB8D}", "\u{1106}\u{1171}\u{11AC}", "\u{BB8D}", "\u{1106}\u{1171}\u{11AC}"),
    ("\u{BB8E}", "\u{BB8E}", "\u{1106}\u{1171}\u{11AD}", "\u{BB8E}", "\u{1106}\u{1171}\u{11AD}"),
    ("\u{BB8F}", "\u{BB8F}", "\u{1106}\u{1171}\u{11AE}", "\u{BB8F}", "\u{1106}\u{1171}\u{11AE}"),
    ("\u{BB90}", "\u{BB90}", "\u{1106}\u{1171}\u{11AF}", "\u{BB90}", "\u{1106}\u{1171}\u{11AF}"),
    ("\u{BB91}", "\u{BB91}", "\u{1106}\u{1171}\u{11B0}", "\u{BB91}", "\u{1106}\u{1171}\u{11B0}"),
    ("\u{BB92}", "\u{BB92}", "\u{1106}\u{1171}\u{11B1}", "\u{BB92}", "\u{1106}\u{1171}\u{11B1}"),
    ("\u{BB93}", "\u{BB93}", "\u{1106}\u{1171}\u{11B2}", "\u{BB93}", "\u{1106}\u{1171}\u{11B2}"),
    ("\u{BB94}", "\u{BB94}", "\u{1106}\u{1171}\u{11B3}", "\u{BB94}", "\u{1106}\u{1171}\u{11B3}"),
    ("\u{BB95}", "\u{BB95}", "\u{1106}\u{1171}\u{11B4}", "\u{BB95}", "\u{1106}\u{1171}\u{11B4}"),
    ("\u{BB96}", "\u{BB96}", "\u{1106}\u{1171}\u{11B5}", "\u{BB96}", "\u{1106}\u{1171}\u{11B5}"),
    ("\u{BB97}", "\u{BB97}", "\u{1106}\u{1171}\u{11B6}", "\u{BB97}", "\u{1106}\u{1171}\u{11B6}"),
    ("\u{BB98}", "\u{BB98}", "\u{1106}\u{1171}\u{11B7}", "\u{BB98}", "\u{1106}\u{1171}\u{11B7}"),
    ("\u{BB99}", "\u{BB99}", "\u{1106}\u{1171}\u{11B8}", "\u{BB99}", "\u{1106}\u{1171}\u{11B8}"),
    ("\u{BB9A}", "\u{BB9A}", "\u{1106}\u{1171}\u{11B9}", "\u{BB9A}", "\u{1106}\u{1171}\u{11B9}"),
    ("\u{BB9B}", "\u{BB9B}", "\u{1106}\u{1171}\u{11BA}", "\u{BB9B}", "\u{1106}\u{1171}\u{11BA}"),
    ("\u{BB9C}", "\u{BB9C}", "\u{1106}\u{1171}\u{11BB}", "\u{BB9C}", "\u{1106}\u{1171}\u{11BB}"),
    ("\u{BB9D}", "\u{BB9D}", "\u{1106}\u{1171}\u{11BC}", "\u{BB9D}", "\u{1106}\u{1171}\u{11BC}"),
    ("\u{BB9E}", "\u{BB9E}", "\u{1106}\u{1171}\u{11BD}", "\u{BB9E}", "\u{1106}\u{1171}\u{11BD}"),
    ("\u{BB9F}", "\u{BB9F}", "\u{1106}\u{1171}\u{11BE}", "\u{BB9F}", "\u{1106}\u{1171}\u{11BE}"),
    ("\u{BBA0}", "\u{BBA0}", "\u{1106}\u{1171}\u{11BF}", "\u{BBA0}", "\u{1106}\u{1171}\u{11BF}"),
    ("\u{BBA1}", "\u{BBA1}", "\u{1106}\u{1171}\u{11C0}", "\u{BBA1}", "\u{1106}\u{1171}\u{11C0}"),
    ("\u{BBA2}", "\u{BBA2}", "\u{1106}\u{1171}\u{11C1}", "\u{BBA2}", "\u{1106}\u{1171}\u{11C1}"),
    ("\u{BBA3}", "\u{BBA3}", "\u{1106}\u{1171}\u{11C2}", "\u{BBA3}", "\u{1106}\u{1171}\u{11C2}"),
    ("\u{BBA4}", "\u{BBA4}", "\u{1106}\u{1172}", "\u{BBA4}", "\u{1106}\u{1172}"),
    ("\u{BBA5}", "\u{BBA5}", "\u{1106}\u{1172}\u{11A8}", "\u{BBA5}", "\u{1106}\u{1172}\u{11A8}"),
    ("\u{BBA6}", "\u{BBA6}", "\u{1106}\u{1172}\u{11A9}", "\u{BBA6}", "\u{1106}\u{1172}\u{11A9}"),
    ("\u{BBA7}", "\u{BBA7}", "\u{1106}\u{1172}\u{11AA}", "\u{BBA7}", "\u{1106}\u{1172}\u{11AA}"),
    ("\u{BBA8}", "\u{BBA8}", "\u{1106}\u{1172}\u{11AB}", "\u{BBA8}", "\u{1106}\u{1172}\u{11AB}"),
    ("\u{BBA9}", "\u{BBA9}", "\u{1106}\u{1172}\u{11AC}", "\u{BBA9}", "\u{1106}\u{1172}\u{11AC}"),
    ("\u{BBAA}", "\u{BBAA}", "\u{1106}\u{1172}\u{11AD}", "\u{BBAA}", "\u{1106}\u{1172}\u{11AD}"),
    ("\u{BBAB}", "\u{BBAB}", "\u{1106}\u{1172}\u{11AE}", "\u{BBAB}", "\u{1106}\u{1172}\u{11AE}"),
    ("\u{BBAC}", "\u{BBAC}", "\u{1106}\u{1172}\u{11AF}", "\u{BBAC}", "\u{1106}\u{1172}\u{11AF}"),
    ("\u{BBAD}", "\u{BBAD}", "\u{1106}\u{1172}\u{11B0}", "\u{BBAD}", "\u{1106}\u{1172}\u{11B0}"),
    ("\u{BBAE}", "\u{BBAE}", "\u{1106}\u{1172}\u{11B1}", "\u{BBAE}", "\u{1106}\u{1172}\u{11B1}"),
    ("\u{BBAF}", "\u{BBAF}", "\u{1106}\u{1172}\u{11B2}", "\u{BBAF}", "\u{1106}\u{1172}\u{11B2}"),
    ("\u{BBB0}", "\u{BBB0}", "\u{1106}\u{1172}\u{11B3}", "\u{BBB0}", "\u{1106}\u{1172}\u{11B3}"),
    ("\u{BBB1}", "\u{BBB1}", "\u{1106}\u{1172}\u{11B4}", "\u{BBB1}", "\u{1106}\u{1172}\u{11B4}"),
    ("\u{BBB2}", "\u{BBB2}", "\u{1106}\u{1172}\u{11B5}", "\u{BBB2}", "\u{1106}\u{1172}\u{11B5}"),
    ("\u{BBB3}", "\u{BBB3}", "\u{1106}\u{1172}\u{11B6}", "\u{BBB3}", "\u{1106}\u{1172}\u{11B6}"),
    ("\u{BBB4}", "\u{BBB4}", "\u{1106}\u{1172}\u{11B7}", "\u{BBB4}", "\u{1106}\u{1172}\u{11B7}"),
    ("\u{BBB5}", "\u{BBB5}", "\u{1106}\u{1172}\u{11B8}", "\u{BBB5}", "\u{1106}\u{1172}\u{11B8}"),
    ("\u{BBB6}", "\u{BBB6}", "\u{1106}\u{1172}\u{11B9}", "\u{BBB6}", "\u{1106}\u{1172}\u{11B9}"),
    ("\u{BBB7}", "\u{BBB7}", "\u{1106}\u{1172}\u{11BA}", "\u{BBB7}", "\u{1106}\u{1172}\u{11BA}"),
    ("\u{BBB8}", "\u{BBB8}", "\u{1106}\u{1172}\u{11BB}", "\u{BBB8}", "\u{1106}\u{1172}\u{11BB}"),
    ("\u{BBB9}", "\u{BBB9}", "\u{1106}\u{1172}\u{11BC}", "\u{BBB9}", "\u{1106}\u{1172}\u{11BC}"),
    ("\u{BBBA}", "\u{BBBA}", "\u{1106}\u{1172}\u{11BD}", "\u{BBBA}", "\u{1106}\u{1172}\u{11BD}"),
    ("\u{BBBB}", "\u{BBBB}", "\u{1106}\u{1172}\u{11BE}", "\u{BBBB}", "\u{1106}\u{1172}\u{11BE}"),
    ("\u{BBBC}", "\u{BBBC}", "\u{1106}\u{1172}\u{11BF}", "\u{BBBC}", "\u{1106}\u{1172}\u{11BF}"),
    ("\u{BBBD}", "\u{BBBD}", "\u{1106}\u{1172}\u{11C0}", "\u{BBBD}", "\u{1106}\u{1172}\u{11C0}"),
    ("\u{BBBE}", "\u{BBBE}", "\u{1106}\u{1172}\u{11C1}", "\u{BBBE}", "\u{1106}\u{1172}\u{11C1}"),
    ("\u{BBBF}", "\u{BBBF}", "\u{1106}\u{1172}\u{11C2}", "\u{BBBF}", "\u{1106}\u{1172}\u{11C2}"),
    ("\u{BBC0}", "\u{BBC0}", "\u{1106}\u{1173}", "\u{BBC0}", "\u{1106}\u{1173}"),
    ("\u{BBC1}", "\u{BBC1}", "\u{1106}\u{1173}\u{11A8}", "\u{BBC1}", "\u{1106}\u{1173}\u{11A8}"),
    ("\u{BBC2}", "\u{BBC2}", "\u{1106}\u{1173}\u{11A9}", "\u{BBC2}", "\u{1106}\u{1173}\u{11A9}"),
    ("\u{BBC3}", "\u{BBC3}", "\u{1106}\u{1173}\u{11AA}", "\u{BBC3}", "\u{1106}\u{1173}\u{11AA}"),
    ("\u{BBC4}", "\u{BBC4}", "\u{1106}\u{1173}\u{11AB}", "\u{BBC4}", "\u{1106}\u{1173}\u{11AB}"),
    ("\u{BBC5}", "\u{BBC5}", "\u{1106}\u{1173}\u{11AC}", "\u{BBC5}", "\u{1106}\u{1173}\u{11AC}"),
    ("\u{BBC6}", "\u{BBC6}", "\u{1106}\u{1173}\u{11AD}", "\u{BBC6}", "\u{1106}\u{1173}\u{11AD}"),
    ("\u{BBC7}", "\u{BBC7}", "\u{1106}\u{1173}\u{11AE}", "\u{BBC7}", "\u{1106}\u{1173}\u{11AE}"),
    ("\u{BBC8}", "\u{BBC8}", "\u{1106}\u{1173}\u{11AF}", "\u{BBC8}", "\u{1106}\u{1173}\u{11AF}"),
    ("\u{BBC9}", "\u{BBC9}", "\u{1106}\u{1173}\u{11B0}", "\u{BBC9}", "\u{1106}\u{1173}\u{11B0}"),
    ("\u{BBCA}", "\u{BBCA}", "\u{1106}\u{1173}\u{11B1}", "\u{BBCA}", "\u{1106}\u{1173}\u{11B1}"),
    ("\u{BBCB}", "\u{BBCB}", "\u{1106}\u{1173}\u{11B2}", "\u{BBCB}", "\u{1106}\u{1173}\u{11B2}"),
    ("\u{BBCC}", "\u{BBCC}", "\u{1106}\u{1173}\u{11B3}", "\u{BBCC}", "\u{1106}\u{1173}\u{11B3}"),
    ("\u{BBCD}", "\u{BBCD}", "\u{1106}\u{1173}\u{11B4}", "\u{BBCD}", "\u{1106}\u{1173}\u{11B4}"),
    ("\u{BBCE}", "\u{BBCE}", "\u{1106}\u{1173}\u{11B5}", "\u{BBCE}", "\u{1106}\u{1173}\u{11B5}"),
    ("\u{BBCF}", "\u{BBCF}", "\u{1106}\u{1173}\u{11B6}", "\u{BBCF}", "\u{1106}\u{1173}\u{11B6}"),
    ("\u{BBD0}", "\u{BBD0}", "\u{1106}\u{1173}\u{11B7}", "\u{BBD0}", "\u{1106}\u{1173}\u{11B7}"),
    ("\u{BBD1}", "\u{BBD1}", "\u{1106}\u{1173}\u{11B8}", "\u{BBD1}", "\u{1106}\u{1173}\u{11B8}"),
    ("\u{BBD2}", "\u{BBD2}", "\u{1106}\u{1173}\u{11B9}", "\u{BBD2}", "\u{1106}\u{1173}\u{11B9}"),
    ("\u{BBD3}", "\u{BBD3}", "\u{1106}\u{1173}\u{11BA}", "\u{BBD3}", "\u{1106}\u{1173}\u{11BA}"),
    ("\u{BBD4}", "\u{BBD4}", "\u{1106}\u{1173}\u{11BB}", "\u{BBD4}", "\u{1106}\u{1173}\u{11BB}"),
    ("\u{BBD5}", "\u{BBD5}", "\u{1106}\u{1173}\u{11BC}", "\u{BBD5}", "\u{1106}\u{1173}\u{11BC}"),
    ("\u{BBD6}", "\u{BBD6}", "\u{1106}\u{1173}\u{11BD}", "\u{BBD6}", "\u{1106}\u{1173}\u{11BD}"),
    ("\u{BBD7}", "\u{BBD7}", "\u{1106}\u{1173}\u{11BE}", "\u{BBD7}", "\u{1106}\u{1173}\u{11BE}"),
    ("\u{BBD8}", "\u{BBD8}", "\u{1106}\u{1173}\u{11BF}", "\u{BBD8}", "\u{1106}\u{1173}\u{11BF}"),
    ("\u{BBD9}", "\u{BBD9}", "\u{1106}\u{1173}\u{11C0}", "\u{BBD9}", "\u{1106}\u{1173}\u{11C0}"),
    ("\u{BBDA}", "\u{BBDA}", "\u{1106}\u{1173}\u{11C1}", "\u{BBDA}", "\u{1106}\u{1173}\u{11C1}"),
    ("\u{BBDB}", "\u{BBDB}", "\u{1106}\u{1173}\u{11C2}", "\u{BBDB}", "\u{1106}\u{1173}\u{11C2}"),
    ("\u{BBDC}", "\u{BBDC}", "\u{1106}\u{1174}", "\u{BBDC}", "\u{1106}\u{1174}"),
    ("\u{BBDD}", "\u{BBDD}", "\u{1106}\u{1174}\u{11A8}", "\u{BBDD}", "\u{1106}\u{1174}\u{11A8}"),
    ("\u{BBDE}", "\u{BBDE}", "\u{1106}\u{1174}\u{11A9}", "\u{BBDE}", "\u{1106}\u{1174}\u{11A9}"),
    ("\u{BBDF}", "\u{BBDF}", "\u{1106}\u{1174}\u{11AA}", "\u{BBDF}", "\u{1106}\u{1174}\u{11AA}"),
    ("\u{BBE0}", "\u{BBE0}", "\u{1106}\u{1174}\u{11AB}", "\u{BBE0}", "\u{1106}\u{1174}\u{11AB}"),
    ("\u{BBE1}", "\u{BBE1}", "\u{1106}\u{1174}\u{11AC}", "\u{BBE1}", "\u{1106}\u{1174}\u{11AC}"),
    ("\u{BBE2}", "\u{BBE2}", "\u{1106}\u{1174}\u{11AD}", "\u{BBE2}", "\u{1106}\u{1174}\u{11AD}"),
    ("\u{BBE3}", "\u{BBE3}", "\u{1106}\u{1174}\u{11AE}", "\u{BBE3}", "\u{1106}\u{1174}\u{11AE}"),
    ("\u{BBE4}", "\u{BBE4}", "\u{1106}\u{1174}\u{11AF}", "\u{BBE4}", "\u{1106}\u{1174}\u{11AF}"),
    ("\u{BBE5}", "\u{BBE5}", "\u{1106}\u{1174}\u{11B0}", "\u{BBE5}", "\u{1106}\u{1174}\u{11B0}"),
    ("\u{BBE6}", "\u{BBE6}", "\u{1106}\u{1174}\u{11B1}", "\u{BBE6}", "\u{1106}\u{1174}\u{11B1}"),
    ("\u{BBE7}", "\u{BBE7}", "\u{1106}\u{1174}\u{11B2}", "\u{BBE7}", "\u{1106}\u{1174}\u{11B2}"),
    ("\u{BBE8}", "\u{BBE8}", "\u{1106}\u{1174}\u{11B3}", "\u{BBE8}", "\u{1106}\u{1174}\u{11B3}"),
    ("\u{BBE9}", "\u{BBE9}", "\u{1106}\u{1174}\u{11B4}", "\u{BBE9}", "\u{1106}\u{1174}\u{11B4}"),
    ("\u{BBEA}", "\u{BBEA}", "\u{1106}\u{1174}\u{11B5}", "\u{BBEA}", "\u{1106}\u{1174}\u{11B5}"),
    ("\u{BBEB}", "\u{BBEB}", "\u{1106}\u{1174}\u{11B6}", "\u{BBEB}", "\u{1106}\u{1174}\u{11B6}"),
    ("\u{BBEC}", "\u{BBEC}", "\u{1106}\u{1174}\u{11B7}", "\u{BBEC}", "\u{1106}\u{1174}\u{11B7}"),
    ("\u{BBED}", "\u{BBED}", "\u{1106}\u{1174}\u{11B8}", "\u{BBED}", "\u{1106}\u{1174}\u{11B8}"),
    ("\u{BBEE}", "\u{BBEE}", "\u{1106}\u{1174}\u{11B9}", "\u{BBEE}", "\u{1106}\u{1174}\u{11B9}"),
    ("\u{BBEF}", "\u{BBEF}", "\u{1106}\u{1174}\u{11BA}", "\u{BBEF}", "\u{1106}\u{1174}\u{11BA}"),
    ("\u{BBF0}", "\u{BBF0}", "\u{1106}\u{1174}\u{11BB}", "\u{BBF0}", "\u{1106}\u{1174}\u{11BB}"),
    ("\u{BBF1}", "\u{BBF1}", "\u{1106}\u{1174}\u{11BC}", "\u{BBF1}", "\u{1106}\u{1174}\u{11BC}"),
    ("\u{BBF2}", "\u{BBF2}", "\u{1106}\u{1174}\u{11BD}", "\u{BBF2}", "\u{1106}\u{1174}\u{11BD}"),
    ("\u{BBF3}", "\u{BBF3}", "\u{1106}\u{1174}\u{11BE}", "\u{BBF3}", "\u{1106}\u{1174}\u{11BE}"),
    ("\u{BBF4}", "\u{BBF4}", "\u{1106}\u{1174}\u{11BF}", "\u{BBF4}", "\u{1106}\u{1174}\u{11BF}"),
    ("\u{BBF5}", "\u{BBF5}", "\u{1106}\u{1174}\u{11C0}", "\u{BBF5}", "\u{1106}\u{1174}\u{11C0}"),
    ("\u{BBF6}", "\u{BBF6}", "\u{1106}\u{1174}\u{11C1}", "\u{BBF6}", "\u{1106}\u{1174}\u{11C1}"),
    ("\u{BBF7}", "\u{BBF7}", "\u{1106}\u{1174}\u{11C2}", "\u{BBF7}", "\u{1106}\u{1174}\u{11C2}"),
    ("\u{BBF8}", "\u{BBF8}", "\u{1106}\u{1175}", "\u{BBF8}", "\u{1106}\u{1175}"),
    ("\u{BBF9}", "\u{BBF9}", "\u{1106}\u{1175}\u{11A8}", "\u{BBF9}", "\u{1106}\u{1175}\u{11A8}"),
    ("\u{BBFA}", "\u{BBFA}", "\u{1106}\u{1175}\u{11A9}", "\u{BBFA}", "\u{1106}\u{1175}\u{11A9}"),
    ("\u{BBFB}", "\u{BBFB}", "\u{1106}\u{1175}\u{11AA}", "\u{BBFB}", "\u{1106}\u{1175}\u{11AA}"),
    ("\u{BBFC}", "\u{BBFC}", "\u{1106}\u{1175}\u{11AB}", "\u{BBFC}", "\u{1106}\u{1175}\u{11AB}"),
    ("\u{BBFD}", "\u{BBFD}", "\u{1106}\u{1175}\u{11AC}", "\u{BBFD}", "\u{1106}\u{1175}\u{11AC}"),
    ("\u{BBFE}", "\u{BBFE}", "\u{1106}\u{1175}\u{11AD}", "\u{BBFE}", "\u{1106}\u{1175}\u{11AD}"),
    ("\u{BBFF}", "\u{BBFF}", "\u{1106}\u{1175}\u{11AE}", "\u{BBFF}", "\u{1106}\u{1175}\u{11AE}"),
    ("\u{BC00}", "\u{BC00}", "\u{1106}\u{1175}\u{11AF}", "\u{BC00}", "\u{1106}\u{1175}\u{11AF}"),
    ("\u{BC01}", "\u{BC01}", "\u{1106}\u{1175}\u{11B0}", "\u{BC01}", "\u{1106}\u{1175}\u{11B0}"),
    ("\u{BC02}", "\u{BC02}", "\u{1106}\u{1175}\u{11B1}", "\u{BC02}", "\u{1106}\u{1175}\u{11B1}"),
    ("\u{BC03}", "\u{BC03}", "\u{1106}\u{1175}\u{11B2}", "\u{BC03}", "\u{1106}\u{1175}\u{11B2}"),
    ("\u{BC04}", "\u{BC04}", "\u{1106}\u{1175}\u{11B3}", "\u{BC04}", "\u{1106}\u{1175}\u{11B3}"),
    ("\u{BC05}", "\u{BC05}", "\u{1106}\u{1175}\u{11B4}", "\u{BC05}", "\u{1106}\u{1175}\u{11B4}"),
    ("\u{BC06}", "\u{BC06}", "\u{1106}\u{1175}\u{11B5}", "\u{BC06}", "\u{1106}\u{1175}\u{11B5}"),
    ("\u{BC07}", "\u{BC07}", "\u{1106}\u{1175}\u{11B6}", "\u{BC07}", "\u{1106}\u{1175}\u{11B6}"),
    ("\u{BC08}", "\u{BC08}", "\u{1106}\u{1175}\u{11B7}", "\u{BC08}", "\u{1106}\u{1175}\u{11B7}"),
    ("\u{BC09}", "\u{BC09}", "\u{1106}\u{1175}\u{11B8}", "\u{BC09}", "\u{1106}\u{1175}\u{11B8}"),
    ("\u{BC0A}", "\u{BC0A}", "\u{1106}\u{1175}\u{11B9}", "\u{BC0A}", "\u{1106}\u{1175}\u{11B9}"),
    ("\u{BC0B}", "\u{BC0B}", "\u{1106}\u{1175}\u{11BA}", "\u{BC0B}", "\u{1106}\u{1175}\u{11BA}"),
    ("\u{BC0C}", "\u{BC0C}", "\u{1106}\u{1175}\u{11BB}", "\u{BC0C}", "\u{1106}\u{1175}\u{11BB}"),
    ("\u{BC0D}", "\u{BC0D}", "\u{1106}\u{1175}\u{11BC}", "\u{BC0D}", "\u{1106}\u{1175}\u{11BC}"),
    ("\u{BC0E}", "\u{BC0E}", "\u{1106}\u{1175}\u{11BD}", "\u{BC0E}", "\u{1106}\u{1175}\u{11BD}"),
    ("\u{BC0F}", "\u{BC0F}", "\u{1106}\u{1175}\u{11BE}", "\u{BC0F}", "\u{1106}\u{1175}\u{11BE}"),
    ("\u{BC10}", "\u{BC10}", "\u{1106}\u{1175}\u{11BF}", "\u{BC10}", "\u{1106}\u{1175}\u{11BF}"),
    ("\u{BC11}", "\u{BC11}", "\u{1106}\u{1175}\u{11C0}", "\u{BC11}", "\u{1106}\u{1175}\u{11C0}"),
    ("\u{BC12}", "\u{BC12}", "\u{1106}\u{1175}\u{11C1}", "\u{BC12}", "\u{1106}\u{1175}\u{11C1}"),
    ("\u{BC13}", "\u{BC13}", "\u{1106}\u{1175}\u{11C2}", "\u{BC13}", "\u{1106}\u{1175}\u{11C2}"),
    ("\u{BC14}", "\u{BC14}", "\u{1107}\u{1161}", "\u{BC14}", "\u{1107}\u{1161}"),
    ("\u{BC15}", "\u{BC15}", "\u{1107}\u{1161}\u{11A8}", "\u{BC15}", "\u{1107}\u{1161}\u{11A8}"),
    ("\u{BC16}", "\u{BC16}", "\u{1107}\u{1161}\u{11A9}", "\u{BC16}", "\u{1107}\u{1161}\u{11A9}"),
    ("\u{BC17}", "\u{BC17}", "\u{1107}\u{1161}\u{11AA}", "\u{BC17}", "\u{1107}\u{1161}\u{11AA}"),
    ("\u{BC18}", "\u{BC18}", "\u{1107}\u{1161}\u{11AB}", "\u{BC18}", "\u{1107}\u{1161}\u{11AB}"),
    ("\u{BC19}", "\u{BC19}", "\u{1107}\u{1161}\u{11AC}", "\u{BC19}", "\u{1107}\u{1161}\u{11AC}"),
    ("\u{BC1A}", "\u{BC1A}", "\u{1107}\u{1161}\u{11AD}", "\u{BC1A}", "\u{1107}\u{1161}\u{11AD}"),
    ("\u{BC1B}", "\u{BC1B}", "\u{1107}\u{1161}\u{11AE}", "\u{BC1B}", "\u{1107}\u{1161}\u{11AE}"),
    ("\u{BC1C}", "\u{BC1C}", "\u{1107}\u{1161}\u{11AF}", "\u{BC1C}", "\u{1107}\u{1161}\u{11AF}"),
    ("\u{BC1D}", "\u{BC1D}", "\u{1107}\u{1161}\u{11B0}", "\u{BC1D}", "\u{1107}\u{1161}\u{11B0}"),
    ("\u{BC1E}", "\u{BC1E}", "\u{1107}\u{1161}\u{11B1}", "\u{BC1E}", "\u{1107}\u{1161}\u{11B1}"),
    ("\u{BC1F}", "\u{BC1F}", "\u{1107}\u{1161}\u{11B2}", "\u{BC1F}", "\u{1107}\u{1161}\u{11B2}"),
    ("\u{BC20}", "\u{BC20}", "\u{1107}\u{1161}\u{11B3}", "\u{BC20}", "\u{1107}\u{1161}\u{11B3}"),
    ("\u{BC21}", "\u{BC21}", "\u{1107}\u{1161}\u{11B4}", "\u{BC21}", "\u{1107}\u{1161}\u{11B4}"),
    ("\u{BC22}", "\u{BC22}", "\u{1107}\u{1161}\u{11B5}", "\u{BC22}", "\u{1107}\u{1161}\u{11B5}"),
    ("\u{BC23}", "\u{BC23}", "\u{1107}\u{1161}\u{11B6}", "\u{BC23}", "\u{1107}\u{1161}\u{11B6}"),
    ("\u{BC24}", "\u{BC24}", "\u{1107}\u{1161}\u{11B7}", "\u{BC24}", "\u{1107}\u{1161}\u{11B7}"),
    ("\u{BC25}", "\u{BC25}", "\u{1107}\u{1161}\u{11B8}", "\u{BC25}", "\u{1107}\u{1161}\u{11B8}"),
    ("\u{BC26}", "\u{BC26}", "\u{1107}\u{1161}\u{11B9}", "\u{BC26}", "\u{1107}\u{1161}\u{11B9}"),
    ("\u{BC27}", "\u{BC27}", "\u{1107}\u{1161}\u{11BA}", "\u{BC27}", "\u{1107}\u{1161}\u{11BA}"),
    ("\u{BC28}", "\u{BC28}", "\u{1107}\u{1161}\u{11BB}", "\u{BC28}", "\u{1107}\u{1161}\u{11BB}"),
    ("\u{BC29}", "\u{BC29}", "\u{1107}\u{1161}\u{11BC}", "\u{BC29}", "\u{1107}\u{1161}\u{11BC}"),
    ("\u{BC2A}", "\u{BC2A}", "\u{1107}\u{1161}\u{11BD}", "\u{BC2A}", "\u{1107}\u{1161}\u{11BD}"),
    ("\u{BC2B}", "\u{BC2B}", "\u{1107}\u{1161}\u{11BE}", "\u{BC2B}", "\u{1107}\u{1161}\u{11BE}"),
    ("\u{BC2C}", "\u{BC2C}", "\u{1107}\u{1161}\u{11BF}", "\u{BC2C}", "\u{1107}\u{1161}\u{11BF}"),
    ("\u{BC2D}", "\u{BC2D}", "\u{1107}\u{1161}\u{11C0}", "\u{BC2D}", "\u{1107}\u{1161}\u{11C0}"),
    ("\u{BC2E}", "\u{BC2E}", "\u{1107}\u{1161}\u{11C1}", "\u{BC2E}", "\u{1107}\u{1161}\u{11C1}"),
    ("\u{BC2F}", "\u{BC2F}", "\u{1107}\u{1161}\u{11C2}", "\u{BC2F}", "\u{1107}\u{1161}\u{11C2}"),
    ("\u{BC30}", "\u{BC30}", "\u{1107}\u{1162}", "\u{BC30}", "\u{1107}\u{1162}"),
    ("\u{BC31}", "\u{BC31}", "\u{1107}\u{1162}\u{11A8}", "\u{BC31}", "\u{1107}\u{1162}\u{11A8}"),
    ("\u{BC32}", "\u{BC32}", "\u{1107}\u{1162}\u{11A9}", "\u{BC32}", "\u{1107}\u{1162}\u{11A9}"),
    ("\u{BC33}", "\u{BC33}", "\u{1107}\u{1162}\u{11AA}", "\u{BC33}", "\u{1107}\u{1162}\u{11AA}"),
    ("\u{BC34}", "\u{BC34}", "\u{1107}\u{1162}\u{11AB}", "\u{BC34}", "\u{1107}\u{1162}\u{11AB}"),
    ("\u{BC35}", "\u{BC35}", "\u{1107}\u{1162}\u{11AC}", "\u{BC35}", "\u{1107}\u{1162}\u{11AC}"),
    ("\u{BC36}", "\u{BC36}", "\u{1107}\u{1162}\u{11AD}", "\u{BC36}", "\u{1107}\u{1162}\u{11AD}"),
    ("\u{BC37}", "\u{BC37}", "\u{1107}\u{1162}\u{11AE}", "\u{BC37}", "\u{1107}\u{1162}\u{11AE}"),
    ("\u{BC38}", "\u{BC38}", "\u{1107}\u{1162}\u{11AF}", "\u{BC38}", "\u{1107}\u{1162}\u{11AF}"),
    ("\u{BC39}", "\u{BC39}", "\u{1107}\u{1162}\u{11B0}", "\u{BC39}", "\u{1107}\u{1162}\u{11B0}"),
    ("\u{BC3A}", "\u{BC3A}", "\u{1107}\u{1162}\u{11B1}", "\u{BC3A}", "\u{1107}\u{1162}\u{11B1}"),
    ("\u{BC3B}", "\u{BC3B}", "\u{1107}\u{1162}\u{11B2}", "\u{BC3B}", "\u{1107}\u{1162}\u{11B2}"),
    ("\u{BC3C}", "\u{BC3C}", "\u{1107}\u{1162}\u{11B3}", "\u{BC3C}", "\u{1107}\u{1162}\u{11B3}"),
    ("\u{BC3D}", "\u{BC3D}", "\u{1107}\u{1162}\u{11B4}", "\u{BC3D}", "\u{1107}\u{1162}\u{11B4}"),
    ("\u{BC3E}", "\u{BC3E}", "\u{1107}\u{1162}\u{11B5}", "\u{BC3E}", "\u{1107}\u{1162}\u{11B5}"),
    ("\u{BC3F}", "\u{BC3F}", "\u{1107}\u{1162}\u{11B6}", "\u{BC3F}", "\u{1107}\u{1162}\u{11B6}"),
    ("\u{BC40}", "\u{BC40}", "\u{1107}\u{1162}\u{11B7}", "\u{BC40}", "\u{1107}\u{1162}\u{11B7}"),
    ("\u{BC41}", "\u{BC41}", "\u{1107}\u{1162}\u{11B8}", "\u{BC41}", "\u{1107}\u{1162}\u{11B8}"),
    ("\u{BC42}", "\u{BC42}", "\u{1107}\u{1162}\u{11B9}", "\u{BC42}", "\u{1107}\u{1162}\u{11B9}"),
    ("\u{BC43}", "\u{BC43}", "\u{1107}\u{1162}\u{11BA}", "\u{BC43}", "\u{1107}\u{1162}\u{11BA}"),
    ("\u{BC44}", "\u{BC44}", "\u{1107}\u{1162}\u{11BB}", "\u{BC44}", "\u{1107}\u{1162}\u{11BB}"),
    ("\u{BC45}", "\u{BC45}", "\u{1107}\u{1162}\u{11BC}", "\u{BC45}", "\u{1107}\u{1162}\u{11BC}"),
    ("\u{BC46}", "\u{BC46}", "\u{1107}\u{1162}\u{11BD}", "\u{BC46}", "\u{1107}\u{1162}\u{11BD}"),
    ("\u{BC47}", "\u{BC47}", "\u{1107}\u{1162}\u{11BE}", "\u{BC47}", "\u{1107}\u{1162}\u{11BE}"),
    ("\u{BC48}", "\u{BC48}", "\u{1107}\u{1162}\u{11BF}", "\u{BC48}", "\u{1107}\u{1162}\u{11BF}"),
    ("\u{BC49}", "\u{BC49}", "\u{1107}\u{1162}\u{11C0}", "\u{BC49}", "\u{1107}\u{1162}\u{11C0}"),
    ("\u{BC4A}", "\u{BC4A}", "\u{1107}\u{1162}\u{11C1}", "\u{BC4A}", "\u{1107}\u{1162}\u{11C1}"),
    ("\u{BC4B}", "\u{BC4B}", "\u{1107}\u{1162}\u{11C2}", "\u{BC4B}", "\u{1107}\u{1162}\u{11C2}"),
    ("\u{BC4C}", "\u{BC4C}", "\u{1107}\u{1163}", "\u{BC4C}", "\u{1107}\u{1163}"),
    ("\u{BC4D}", "\u{BC4D}", "\u{1107}\u{1163}\u{11A8}", "\u{BC4D}", "\u{1107}\u{1163}\u{11A8}"),
    ("\u{BC4E}", "\u{BC4E}", "\u{1107}\u{1163}\u{11A9}", "\u{BC4E}", "\u{1107}\u{1163}\u{11A9}"),
    ("\u{BC4F}", "\u{BC4F}", "\u{1107}\u{1163}\u{11AA}", "\u{BC4F}", "\u{1107}\u{1163}\u{11AA}"),
    ("\u{BC50}", "\u{BC50}", "\u{1107}\u{1163}\u{11AB}", "\u{BC50}", "\u{1107}\u{1163}\u{11AB}"),
    ("\u{BC51}", "\u{BC51}", "\u{1107}\u{1163}\u{11AC}", "\u{BC51}", "\u{1107}\u{1163}\u{11AC}"),
    ("\u{BC52}", "\u{BC52}", "\u{1107}\u{1163}\u{11AD}", "\u{BC52}", "\u{1107}\u{1163}\u{11AD}"),
    ("\u{BC53}", "\u{BC53}", "\u{1107}\u{1163}\u{11AE}", "\u{BC53}", "\u{1107}\u{1163}\u{11AE}"),
    ("\u{BC54}", "\u{BC54}", "\u{1107}\u{1163}\u{11AF}", "\u{BC54}", "\u{1107}\u{1163}\u{11AF}"),
    ("\u{BC55}", "\u{BC55}", "\u{1107}\u{1163}\u{11B0}", "\u{BC55}", "\u{1107}\u{1163}\u{11B0}"),
    ("\u{BC56}", "\u{BC56}", "\u{1107}\u{1163}\u{11B1}", "\u{BC56}", "\u{1107}\u{1163}\u{11B1}"),
    ("\u{BC57}", "\u{BC57}", "\u{1107}\u{1163}\u{11B2}", "\u{BC57}", "\u{1107}\u{1163}\u{11B2}"),
    ("\u{BC58}", "\u{BC58}", "\u{1107}\u{1163}\u{11B3}", "\u{BC58}", "\u{1107}\u{1163}\u{11B3}"),
    ("\u{BC59}", "\u{BC59}", "\u{1107}\u{1163}\u{11B4}", "\u{BC59}", "\u{1107}\u{1163}\u{11B4}"),
    ("\u{BC5A}", "\u{BC5A}", "\u{1107}\u{1163}\u{11B5}", "\u{BC5A}", "\u{1107}\u{1163}\u{11B5}"),
    ("\u{BC5B}", "\u{BC5B}", "\u{1107}\u{1163}\u{11B6}", "\u{BC5B}", "\u{1107}\u{1163}\u{11B6}"),
    ("\u{BC5C}", "\u{BC5C}", "\u{1107}\u{1163}\u{11B7}", "\u{BC5C}", "\u{1107}\u{1163}\u{11B7}"),
    ("\u{BC5D}", "\u{BC5D}", "\u{1107}\u{1163}\u{11B8}", "\u{BC5D}", "\u{1107}\u{1163}\u{11B8}"),
    ("\u{BC5E}", "\u{BC5E}", "\u{1107}\u{1163}\u{11B9}", "\u{BC5E}", "\u{1107}\u{1163}\u{11B9}"),
    ("\u{BC5F}", "\u{BC5F}", "\u{1107}\u{1163}\u{11BA}", "\u{BC5F}", "\u{1107}\u{1163}\u{11BA}"),
    ("\u{BC60}", "\u{BC60}", "\u{1107}\u{1163}\u{11BB}", "\u{BC60}", "\u{1107}\u{1163}\u{11BB}"),
    ("\u{BC61}", "\u{BC61}", "\u{1107}\u{1163}\u{11BC}", "\u{BC61}", "\u{1107}\u{1163}\u{11BC}"),
    ("\u{BC62}", "\u{BC62}", "\u{1107}\u{1163}\u{11BD}", "\u{BC62}", "\u{1107}\u{1163}\u{11BD}"),
    ("\u{BC63}", "\u{BC63}", "\u{1107}\u{1163}\u{11BE}", "\u{BC63}", "\u{1107}\u{1163}\u{11BE}"),
    ("\u{BC64}", "\u{BC64}", "\u{1107}\u{1163}\u{11BF}", "\u{BC64}", "\u{1107}\u{1163}\u{11BF}"),
    ("\u{BC65}", "\u{BC65}", "\u{1107}\u{1163}\u{11C0}", "\u{BC65}", "\u{1107}\u{1163}\u{11C0}"),
    ("\u{BC66}", "\u{BC66}", "\u{1107}\u{1163}\u{11C1}", "\u{BC66}", "\u{1107}\u{1163}\u{11C1}"),
    ("\u{BC67}", "\u{BC67}", "\u{1107}\u{1163}\u{11C2}", "\u{BC67}", "\u{1107}\u{1163}\u{11C2}"),
    ("\u{BC68}", "\u{BC68}", "\u{1107}\u{1164}", "\u{BC68}", "\u{1107}\u{1164}"),
    ("\u{BC69}", "\u{BC69}", "\u{1107}\u{1164}\u{11A8}", "\u{BC69}", "\u{1107}\u{1164}\u{11A8}"),
    ("\u{BC6A}", "\u{BC6A}", "\u{1107}\u{1164}\u{11A9}", "\u{BC6A}", "\u{1107}\u{1164}\u{11A9}"),
    ("\u{BC6B}", "\u{BC6B}", "\u{1107}\u{1164}\u{11AA}", "\u{BC6B}", "\u{1107}\u{1164}\u{11AA}"),
    ("\u{BC6C}", "\u{BC6C}", "\u{1107}\u{1164}\u{11AB}", "\u{BC6C}", "\u{1107}\u{1164}\u{11AB}"),
    ("\u{BC6D}", "\u{BC6D}", "\u{1107}\u{1164}\u{11AC}", "\u{BC6D}", "\u{1107}\u{1164}\u{11AC}"),
    ("\u{BC6E}", "\u{BC6E}", "\u{1107}\u{1164}\u{11AD}", "\u{BC6E}", "\u{1107}\u{1164}\u{11AD}"),
    ("\u{BC6F}", "\u{BC6F}", "\u{1107}\u{1164}\u{11AE}", "\u{BC6F}", "\u{1107}\u{1164}\u{11AE}"),
    ("\u{BC70}", "\u{BC70}", "\u{1107}\u{1164}\u{11AF}", "\u{BC70}", "\u{1107}\u{1164}\u{11AF}"),
    ("\u{BC71}", "\u{BC71}", "\u{1107}\u{1164}\u{11B0}", "\u{BC71}", "\u{1107}\u{1164}\u{11B0}"),
    ("\u{BC72}", "\u{BC72}", "\u{1107}\u{1164}\u{11B1}", "\u{BC72}", "\u{1107}\u{1164}\u{11B1}"),
    ("\u{BC73}", "\u{BC73}", "\u{1107}\u{1164}\u{11B2}", "\u{BC73}", "\u{1107}\u{1164}\u{11B2}"),
    ("\u{BC74}", "\u{BC74}", "\u{1107}\u{1164}\u{11B3}", "\u{BC74}", "\u{1107}\u{1164}\u{11B3}"),
    ("\u{BC75}", "\u{BC75}", "\u{1107}\u{1164}\u{11B4}", "\u{BC75}", "\u{1107}\u{1164}\u{11B4}"),
    ("\u{BC76}", "\u{BC76}", "\u{1107}\u{1164}\u{11B5}", "\u{BC76}", "\u{1107}\u{1164}\u{11B5}"),
    ("\u{BC77}", "\u{BC77}", "\u{1107}\u{1164}\u{11B6}", "\u{BC77}", "\u{1107}\u{1164}\u{11B6}"),
    ("\u{BC78}", "\u{BC78}", "\u{1107}\u{1164}\u{11B7}", "\u{BC78}", "\u{1107}\u{1164}\u{11B7}"),
    ("\u{BC79}", "\u{BC79}", "\u{1107}\u{1164}\u{11B8}", "\u{BC79}", "\u{1107}\u{1164}\u{11B8}"),
    ("\u{BC7A}", "\u{BC7A}", "\u{1107}\u{1164}\u{11B9}", "\u{BC7A}", "\u{1107}\u{1164}\u{11B9}"),
    ("\u{BC7B}", "\u{BC7B}", "\u{1107}\u{1164}\u{11BA}", "\u{BC7B}", "\u{1107}\u{1164}\u{11BA}"),
    ("\u{BC7C}", "\u{BC7C}", "\u{1107}\u{1164}\u{11BB}", "\u{BC7C}", "\u{1107}\u{1164}\u{11BB}"),
    ("\u{BC7D}", "\u{BC7D}", "\u{1107}\u{1164}\u{11BC}", "\u{BC7D}", "\u{1107}\u{1164}\u{11BC}"),
    ("\u{BC7E}", "\u{BC7E}", "\u{1107}\u{1164}\u{11BD}", "\u{BC7E}", "\u{1107}\u{1164}\u{11BD}"),
    ("\u{BC7F}", "\u{BC7F}", "\u{1107}\u{1164}\u{11BE}", "\u{BC7F}", "\u{1107}\u{1164}\u{11BE}"),
    ("\u{BC80}", "\u{BC80}", "\u{1107}\u{1164}\u{11BF}", "\u{BC80}", "\u{1107}\u{1164}\u{11BF}"),
    ("\u{BC81}", "\u{BC81}", "\u{1107}\u{1164}\u{11C0}", "\u{BC81}", "\u{1107}\u{1164}\u{11C0}"),
    ("\u{BC82}", "\u{BC82}", "\u{1107}\u{1164}\u{11C1}", "\u{BC82}", "\u{1107}\u{1164}\u{11C1}"),
    ("\u{BC83}", "\u{BC83}", "\u{1107}\u{1164}\u{11C2}", "\u{BC83}", "\u{1107}\u{1164}\u{11C2}"),
    ("\u{BC84}", "\u{BC84}", "\u{1107}\u{1165}", "\u{BC84}", "\u{1107}\u{1165}"),
    ("\u{BC85}", "\u{BC85}", "\u{1107}\u{1165}\u{11A8}", "\u{BC85}", "\u{1107}\u{1165}\u{11A8}"),
    ("\u{BC86}", "\u{BC86}", "\u{1107}\u{1165}\u{11A9}", "\u{BC86}", "\u{1107}\u{1165}\u{11A9}"),
    ("\u{BC87}", "\u{BC87}", "\u{1107}\u{1165}\u{11AA}", "\u{BC87}", "\u{1107}\u{1165}\u{11AA}"),
    ("\u{BC88}", "\u{BC88}", "\u{1107}\u{1165}\u{11AB}", "\u{BC88}", "\u{1107}\u{1165}\u{11AB}"),
    ("\u{BC89}", "\u{BC89}", "\u{1107}\u{1165}\u{11AC}", "\u{BC89}", "\u{1107}\u{1165}\u{11AC}"),
    ("\u{BC8A}", "\u{BC8A}", "\u{1107}\u{1165}\u{11AD}", "\u{BC8A}", "\u{1107}\u{1165}\u{11AD}"),
    ("\u{BC8B}", "\u{BC8B}", "\u{1107}\u{1165}\u{11AE}", "\u{BC8B}", "\u{1107}\u{1165}\u{11AE}"),
    ("\u{BC8C}", "\u{BC8C}", "\u{1107}\u{1165}\u{11AF}", "\u{BC8C}", "\u{1107}\u{1165}\u{11AF}"),
    ("\u{BC8D}", "\u{BC8D}", "\u{1107}\u{1165}\u{11B0}", "\u{BC8D}", "\u{1107}\u{1165}\u{11B0}"),
    ("\u{BC8E}", "\u{BC8E}", "\u{1107}\u{1165}\u{11B1}", "\u{BC8E}", "\u{1107}\u{1165}\u{11B1}"),
    ("\u{BC8F}", "\u{BC8F}", "\u{1107}\u{1165}\u{11B2}", "\u{BC8F}", "\u{1107}\u{1165}\u{11B2}"),
    ("\u{BC90}", "\u{BC90}", "\u{1107}\u{1165}\u{11B3}", "\u{BC90}", "\u{1107}\u{1165}\u{11B3}"),
    ("\u{BC91}", "\u{BC91}", "\u{1107}\u{1165}\u{11B4}", "\u{BC91}", "\u{1107}\u{1165}\u{11B4}"),
    ("\u{BC92}", "\u{BC92}", "\u{1107}\u{1165}\u{11B5}", "\u{BC92}", "\u{1107}\u{1165}\u{11B5}"),
    ("\u{BC93}", "\u{BC93}", "\u{1107}\u{1165}\u{11B6}", "\u{BC93}", "\u{1107}\u{1165}\u{11B6}"),
    ("\u{BC94}", "\u{BC94}", "\u{1107}\u{1165}\u{11B7}", "\u{BC94}", "\u{1107}\u{1165}\u{11B7}"),
    ("\u{BC95}", "\u{BC95}", "\u{1107}\u{1165}\u{11B8}", "\u{BC95}", "\u{1107}\u{1165}\u{11B8}"),
    ("\u{BC96}", "\u{BC96}", "\u{1107}\u{1165}\u{11B9}", "\u{BC96}", "\u{1107}\u{1165}\u{11B9}"),
    ("\u{BC97}", "\u{BC97}", "\u{1107}\u{1165}\u{11BA}", "\u{BC97}", "\u{1107}\u{1165}\u{11BA}"),
    ("\u{BC98}", "\u{BC98}", "\u{1107}\u{1165}\u{11BB}", "\u{BC98}", "\u{1107}\u{1165}\u{11BB}"),
    ("\u{BC99}", "\u{BC99}", "\u{1107}\u{1165}\u{11BC}", "\u{BC99}", "\u{1107}\u{1165}\u{11BC}"),
    ("\u{BC9A}", "\u{BC9A}", "\u{1107}\u{1165}\u{11BD}", "\u{BC9A}", "\u{1107}\u{1165}\u{11BD}"),
    ("\u{BC9B}", "\u{BC9B}", "\u{1107}\u{1165}\u{11BE}", "\u{BC9B}", "\u{1107}\u{1165}\u{11BE}"),
    ("\u{BC9C}", "\u{BC9C}", "\u{1107}\u{1165}\u{11BF}", "\u{BC9C}", "\u{1107}\u{1165}\u{11BF}"),
    ("\u{BC9D}", "\u{BC9D}", "\u{1107}\u{1165}\u{11C0}", "\u{BC9D}", "\u{1107}\u{1165}\u{11C0}"),
    ("\u{BC9E}", "\u{BC9E}", "\u{1107}\u{1165}\u{11C1}", "\u{BC9E}", "\u{1107}\u{1165}\u{11C1}"),
    ("\u{BC9F}", "\u{BC9F}", "\u{1107}\u{1165}\u{11C2}", "\u{BC9F}", "\u{1107}\u{1165}\u{11C2}"),
    ("\u{BCA0}", "\u{BCA0}", "\u{1107}\u{1166}", "\u{BCA0}", "\u{1107}\u{1166}"),
    ("\u{BCA1}", "\u{BCA1}", "\u{1107}\u{1166}\u{11A8}", "\u{BCA1}", "\u{1107}\u{1166}\u{11A8}"),
    ("\u{BCA2}", "\u{BCA2}", "\u{1107}\u{1166}\u{11A9}", "\u{BCA2}", "\u{1107}\u{1166}\u{11A9}"),
    ("\u{BCA3}", "\u{BCA3}", "\u{1107}\u{1166}\u{11AA}", "\u{BCA3}", "\u{1107}\u{1166}\u{11AA}"),
    ("\u{BCA4}", "\u{BCA4}", "\u{1107}\u{1166}\u{11AB}", "\u{BCA4}", "\u{1107}\u{1166}\u{11AB}"),
    ("\u{BCA5}", "\u{BCA5}", "\u{1107}\u{1166}\u{11AC}", "\u{BCA5}", "\u{1107}\u{1166}\u{11AC}"),
    ("\u{BCA6}", "\u{BCA6}", "\u{1107}\u{1166}\u{11AD}", "\u{BCA6}", "\u{1107}\u{1166}\u{11AD}"),
    ("\u{BCA7}", "\u{BCA7}", "\u{1107}\u{1166}\u{11AE}", "\u{BCA7}", "\u{1107}\u{1166}\u{11AE}"),
    ("\u{BCA8}", "\u{BCA8}", "\u{1107}\u{1166}\u{11AF}", "\u{BCA8}", "\u{1107}\u{1166}\u{11AF}"),
    ("\u{BCA9}", "\u{BCA9}", "\u{1107}\u{1166}\u{11B0}", "\u{BCA9}", "\u{1107}\u{1166}\u{11B0}"),
    ("\u{BCAA}", "\u{BCAA}", "\u{1107}\u{1166}\u{11B1}", "\u{BCAA}", "\u{1107}\u{1166}\u{11B1}"),
    ("\u{BCAB}", "\u{BCAB}", "\u{1107}\u{1166}\u{11B2}", "\u{BCAB}", "\u{1107}\u{1166}\u{11B2}"),
    ("\u{BCAC}", "\u{BCAC}", "\u{1107}\u{1166}\u{11B3}", "\u{BCAC}", "\u{1107}\u{1166}\u{11B3}"),
    ("\u{BCAD}", "\u{BCAD}", "\u{1107}\u{1166}\u{11B4}", "\u{BCAD}", "\u{1107}\u{1166}\u{11B4}"),
    ("\u{BCAE}", "\u{BCAE}", "\u{1107}\u{1166}\u{11B5}", "\u{BCAE}", "\u{1107}\u{1166}\u{11B5}"),
    ("\u{BCAF}", "\u{BCAF}", "\u{1107}\u{1166}\u{11B6}", "\u{BCAF}", "\u{1107}\u{1166}\u{11B6}"),
    ("\u{BCB0}", "\u{BCB0}", "\u{1107}\u{1166}\u{11B7}", "\u{BCB0}", "\u{1107}\u{1166}\u{11B7}"),
    ("\u{BCB1}", "\u{BCB1}", "\u{1107}\u{1166}\u{11B8}", "\u{BCB1}", "\u{1107}\u{1166}\u{11B8}"),
    ("\u{BCB2}", "\u{BCB2}", "\u{1107}\u{1166}\u{11B9}", "\u{BCB2}", "\u{1107}\u{1166}\u{11B9}"),
    ("\u{BCB3}", "\u{BCB3}", "\u{1107}\u{1166}\u{11BA}", "\u{BCB3}", "\u{1107}\u{1166}\u{11BA}"),
    ("\u{BCB4}", "\u{BCB4}", "\u{1107}\u{1166}\u{11BB}", "\u{BCB4}", "\u{1107}\u{1166}\u{11BB}"),
    ("\u{BCB5}", "\u{BCB5}", "\u{1107}\u{1166}\u{11BC}", "\u{BCB5}", "\u{1107}\u{1166}\u{11BC}"),
    ("\u{BCB6}", "\u{BCB6}", "\u{1107}\u{1166}\u{11BD}", "\u{BCB6}", "\u{1107}\u{1166}\u{11BD}"),
    ("\u{BCB7}", "\u{BCB7}", "\u{1107}\u{1166}\u{11BE}", "\u{BCB7}", "\u{1107}\u{1166}\u{11BE}"),
    ("\u{BCB8}", "\u{BCB8}", "\u{1107}\u{1166}\u{11BF}", "\u{BCB8}", "\u{1107}\u{1166}\u{11BF}"),
    ("\u{BCB9}", "\u{BCB9}", "\u{1107}\u{1166}\u{11C0}", "\u{BCB9}", "\u{1107}\u{1166}\u{11C0}"),
    ("\u{BCBA}", "\u{BCBA}", "\u{1107}\u{1166}\u{11C1}", "\u{BCBA}", "\u{1107}\u{1166}\u{11C1}"),
    ("\u{BCBB}", "\u{BCBB}", "\u{1107}\u{1166}\u{11C2}", "\u{BCBB}", "\u{1107}\u{1166}\u{11C2}"),
    ("\u{BCBC}", "\u{BCBC}", "\u{1107}\u{1167}", "\u{BCBC}", "\u{1107}\u{1167}"),
    ("\u{BCBD}", "\u{BCBD}", "\u{1107}\u{1167}\u{11A8}", "\u{BCBD}", "\u{1107}\u{1167}\u{11A8}"),
    ("\u{BCBE}", "\u{BCBE}", "\u{1107}\u{1167}\u{11A9}", "\u{BCBE}", "\u{1107}\u{1167}\u{11A9}"),
    ("\u{BCBF}", "\u{BCBF}", "\u{1107}\u{1167}\u{11AA}", "\u{BCBF}", "\u{1107}\u{1167}\u{11AA}"),
    ("\u{BCC0}", "\u{BCC0}", "\u{1107}\u{1167}\u{11AB}", "\u{BCC0}", "\u{1107}\u{1167}\u{11AB}"),
    ("\u{BCC1}", "\u{BCC1}", "\u{1107}\u{1167}\u{11AC}", "\u{BCC1}", "\u{1107}\u{1167}\u{11AC}"),
    ("\u{BCC2}", "\u{BCC2}", "\u{1107}\u{1167}\u{11AD}", "\u{BCC2}", "\u{1107}\u{1167}\u{11AD}"),
    ("\u{BCC3}", "\u{BCC3}", "\u{1107}\u{1167}\u{11AE}", "\u{BCC3}", "\u{1107}\u{1167}\u{11AE}"),
    ("\u{BCC4}", "\u{BCC4}", "\u{1107}\u{1167}\u{11AF}", "\u{BCC4}", "\u{1107}\u{1167}\u{11AF}"),
    ("\u{BCC5}", "\u{BCC5}", "\u{1107}\u{1167}\u{11B0}", "\u{BCC5}", "\u{1107}\u{1167}\u{11B0}"),
    ("\u{BCC6}", "\u{BCC6}", "\u{1107}\u{1167}\u{11B1}", "\u{BCC6}", "\u{1107}\u{1167}\u{11B1}"),
    ("\u{BCC7}", "\u{BCC7}", "\u{1107}\u{1167}\u{11B2}", "\u{BCC7}", "\u{1107}\u{1167}\u{11B2}"),
    ("\u{BCC8}", "\u{BCC8}", "\u{1107}\u{1167}\u{11B3}", "\u{BCC8}", "\u{1107}\u{1167}\u{11B3}"),
    ("\u{BCC9}", "\u{BCC9}", "\u{1107}\u{1167}\u{11B4}", "\u{BCC9}", "\u{1107}\u{1167}\u{11B4}"),
    ("\u{BCCA}", "\u{BCCA}", "\u{1107}\u{1167}\u{11B5}", "\u{BCCA}", "\u{1107}\u{1167}\u{11B5}"),
    ("\u{BCCB}", "\u{BCCB}", "\u{1107}\u{1167}\u{11B6}", "\u{BCCB}", "\u{1107}\u{1167}\u{11B6}"),
    ("\u{BCCC}", "\u{BCCC}", "\u{1107}\u{1167}\u{11B7}", "\u{BCCC}", "\u{1107}\u{1167}\u{11B7}"),
    ("\u{BCCD}", "\u{BCCD}", "\u{1107}\u{1167}\u{11B8}", "\u{BCCD}", "\u{1107}\u{1167}\u{11B8}"),
    ("\u{BCCE}", "\u{BCCE}", "\u{1107}\u{1167}\u{11B9}", "\u{BCCE}", "\u{1107}\u{1167}\u{11B9}"),
    ("\u{BCCF}", "\u{BCCF}", "\u{1107}\u{1167}\u{11BA}", "\u{BCCF}", "\u{1107}\u{1167}\u{11BA}"),
    ("\u{BCD0}", "\u{BCD0}", "\u{1107}\u{1167}\u{11BB}", "\u{BCD0}", "\u{1107}\u{1167}\u{11BB}"),
    ("\u{BCD1}", "\u{BCD1}", "\u{1107}\u{1167}\u{11BC}", "\u{BCD1}", "\u{1107}\u{1167}\u{11BC}"),
    ("\u{BCD2}", "\u{BCD2}", "\u{1107}\u{1167}\u{11BD}", "\u{BCD2}", "\u{1107}\u{1167}\u{11BD}"),
    ("\u{BCD3}", "\u{BCD3}", "\u{1107}\u{1167}\u{11BE}", "\u{BCD3}", "\u{1107}\u{1167}\u{11BE}"),
    ("\u{BCD4}", "\u{BCD4}", "\u{1107}\u{1167}\u{11BF}", "\u{BCD4}", "\u{1107}\u{1167}\u{11BF}"),
    ("\u{BCD5}", "\u{BCD5}", "\u{1107}\u{1167}\u{11C0}", "\u{BCD5}", "\u{1107}\u{1167}\u{11C0}"),
    ("\u{BCD6}", "\u{BCD6}", "\u{1107}\u{1167}\u{11C1}", "\u{BCD6}", "\u{1107}\u{1167}\u{11C1}"),
    ("\u{BCD7}", "\u{BCD7}", "\u{1107}\u{1167}\u{11C2}", "\u{BCD7}", "\u{1107}\u{1167}\u{11C2}"),
    ("\u{BCD8}", "\u{BCD8}", "\u{1107}\u{1168}", "\u{BCD8}", "\u{1107}\u{1168}"),
    ("\u{BCD9}", "\u{BCD9}", "\u{1107}\u{1168}\u{11A8}", "\u{BCD9}", "\u{1107}\u{1168}\u{11A8}"),
    ("\u{BCDA}", "\u{BCDA}", "\u{1107}\u{1168}\u{11A9}", "\u{BCDA}", "\u{1107}\u{1168}\u{11A9}"),
    ("\u{BCDB}", "\u{BCDB}", "\u{1107}\u{1168}\u{11AA}", "\u{BCDB}", "\u{1107}\u{1168}\u{11AA}"),
    ("\u{BCDC}", "\u{BCDC}", "\u{1107}\u{1168}\u{11AB}", "\u{BCDC}", "\u{1107}\u{1168}\u{11AB}"),
    ("\u{BCDD}", "\u{BCDD}", "\u{1107}\u{1168}\u{11AC}", "\u{BCDD}", "\u{1107}\u{1168}\u{11AC}"),
    ("\u{BCDE}", "\u{BCDE}", "\u{1107}\u{1168}\u{11AD}", "\u{BCDE}", "\u{1107}\u{1168}\u{11AD}"),
    ("\u{BCDF}", "\u{BCDF}", "\u{1107}\u{1168}\u{11AE}", "\u{BCDF}", "\u{1107}\u{1168}\u{11AE}"),
    ("\u{BCE0}", "\u{BCE0}", "\u{1107}\u{1168}\u{11AF}", "\u{BCE0}", "\u{1107}\u{1168}\u{11AF}"),
    ("\u{BCE1}", "\u{BCE1}", "\u{1107}\u{1168}\u{11B0}", "\u{BCE1}", "\u{1107}\u{1168}\u{11B0}"),
    ("\u{BCE2}", "\u{BCE2}", "\u{1107}\u{1168}\u{11B1}", "\u{BCE2}", "\u{1107}\u{1168}\u{11B1}"),
    ("\u{BCE3}", "\u{BCE3}", "\u{1107}\u{1168}\u{11B2}", "\u{BCE3}", "\u{1107}\u{1168}\u{11B2}"),
    ("\u{BCE4}", "\u{BCE4}", "\u{1107}\u{1168}\u{11B3}", "\u{BCE4}", "\u{1107}\u{1168}\u{11B3}"),
    ("\u{BCE5}", "\u{BCE5}", "\u{1107}\u{1168}\u{11B4}", "\u{BCE5}", "\u{1107}\u{1168}\u{11B4}"),
    ("\u{BCE6}", "\u{BCE6}", "\u{1107}\u{1168}\u{11B5}", "\u{BCE6}", "\u{1107}\u{1168}\u{11B5}"),
    ("\u{BCE7}", "\u{BCE7}", "\u{1107}\u{1168}\u{11B6}", "\u{BCE7}", "\u{1107}\u{1168}\u{11B6}"),
    ("\u{BCE8}", "\u{BCE8}", "\u{1107}\u{1168}\u{11B7}", "\u{BCE8}", "\u{1107}\u{1168}\u{11B7}"),
    ("\u{BCE9}", "\u{BCE9}", "\u{1107}\u{1168}\u{11B8}", "\u{BCE9}", "\u{1107}\u{1168}\u{11B8}"),
    ("\u{BCEA}", "\u{BCEA}", "\u{1107}\u{1168}\u{11B9}", "\u{BCEA}", "\u{1107}\u{1168}\u{11B9}"),
    ("\u{BCEB}", "\u{BCEB}", "\u{1107}\u{1168}\u{11BA}", "\u{BCEB}", "\u{1107}\u{1168}\u{11BA}"),
    ("\u{BCEC}", "\u{BCEC}", "\u{1107}\u{1168}\u{11BB}", "\u{BCEC}", "\u{1107}\u{1168}\u{11BB}"),
    ("\u{BCED}", "\u{BCED}", "\u{1107}\u{1168}\u{11BC}", "\u{BCED}", "\u{1107}\u{1168}\u{11BC}"),
    ("\u{BCEE}", "\u{BCEE}", "\u{1107}\u{1168}\u{11BD}", "\u{BCEE}", "\u{1107}\u{1168}\u{11BD}"),
    ("\u{BCEF}", "\u{BCEF}", "\u{1107}\u{1168}\u{11BE}", "\u{BCEF}", "\u{1107}\u{1168}\u{11BE}"),
    ("\u{BCF0}", "\u{BCF0}", "\u{1107}\u{1168}\u{11BF}", "\u{BCF0}", "\u{1107}\u{1168}\u{11BF}"),
    ("\u{BCF1}", "\u{BCF1}", "\u{1107}\u{1168}\u{11C0}", "\u{BCF1}", "\u{1107}\u{1168}\u{11C0}"),
    ("\u{BCF2}", "\u{BCF2}", "\u{1107}\u{1168}\u{11C1}", "\u{BCF2}", "\u{1107}\u{1168}\u{11C1}"),
    ("\u{BCF3}", "\u{BCF3}", "\u{1107}\u{1168}\u{11C2}", "\u{BCF3}", "\u{1107}\u{1168}\u{11C2}"),
    ("\u{BCF4}", "\u{BCF4}", "\u{1107}\u{1169}", "\u{BCF4}", "\u{1107}\u{1169}"),
    ("\u{BCF5}", "\u{BCF5}", "\u{1107}\u{1169}\u{11A8}", "\u{BCF5}", "\u{1107}\u{1169}\u{11A8}"),
    ("\u{BCF6}", "\u{BCF6}", "\u{1107}\u{1169}\u{11A9}", "\u{BCF6}", "\u{1107}\u{1169}\u{11A9}"),
    ("\u{BCF7}", "\u{BCF7}", "\u{1107}\u{1169}\u{11AA}", "\u{BCF7}", "\u{1107}\u{1169}\u{11AA}"),
    ("\u{BCF8}", "\u{BCF8}", "\u{1107}\u{1169}\u{11AB}", "\u{BCF8}", "\u{1107}\u{1169}\u{11AB}"),
    ("\u{BCF9}", "\u{BCF9}", "\u{1107}\u{1169}\u{11AC}", "\u{BCF9}", "\u{1107}\u{1169}\u{11AC}"),
    ("\u{BCFA}", "\u{BCFA}", "\u{1107}\u{1169}\u{11AD}", "\u{BCFA}", "\u{1107}\u{1169}\u{11AD}"),
    ("\u{BCFB}", "\u{BCFB}", "\u{1107}\u{1169}\u{11AE}", "\u{BCFB}", "\u{1107}\u{1169}\u{11AE}"),
    ("\u{BCFC}", "\u{BCFC}", "\u{1107}\u{1169}\u{11AF}", "\u{BCFC}", "\u{1107}\u{1169}\u{11AF}"),
    ("\u{BCFD}", "\u{BCFD}", "\u{1107}\u{1169}\u{11B0}", "\u{BCFD}", "\u{1107}\u{1169}\u{11B0}"),
    ("\u{BCFE}", "\u{BCFE}", "\u{1107}\u{1169}\u{11B1}", "\u{BCFE}", "\u{1107}\u{1169}\u{11B1}"),
    ("\u{BCFF}", "\u{BCFF}", "\u{1107}\u{1169}\u{11B2}", "\u{BCFF}", "\u{1107}\u{1169}\u{11B2}"),
    ("\u{BD00}", "\u{BD00}", "\u{1107}\u{1169}\u{11B3}", "\u{BD00}", "\u{1107}\u{1169}\u{11B3}"),
    ("\u{BD01}", "\u{BD01}", "\u{1107}\u{1169}\u{11B4}", "\u{BD01}", "\u{1107}\u{1169}\u{11B4}"),
    ("\u{BD02}", "\u{BD02}", "\u{1107}\u{1169}\u{11B5}", "\u{BD02}", "\u{1107}\u{1169}\u{11B5}"),
    ("\u{BD03}", "\u{BD03}", "\u{1107}\u{1169}\u{11B6}", "\u{BD03}", "\u{1107}\u{1169}\u{11B6}"),
    ("\u{BD04}", "\u{BD04}", "\u{1107}\u{1169}\u{11B7}", "\u{BD04}", "\u{1107}\u{1169}\u{11B7}"),
    ("\u{BD05}", "\u{BD05}", "\u{1107}\u{1169}\u{11B8}", "\u{BD05}", "\u{1107}\u{1169}\u{11B8}"),
    ("\u{BD06}", "\u{BD06}", "\u{1107}\u{1169}\u{11B9}", "\u{BD06}", "\u{1107}\u{1169}\u{11B9}"),
    ("\u{BD07}", "\u{BD07}", "\u{1107}\u{1169}\u{11BA}", "\u{BD07}", "\u{1107}\u{1169}\u{11BA}"),
    ("\u{BD08}", "\u{BD08}", "\u{1107}\u{1169}\u{11BB}", "\u{BD08}", "\u{1107}\u{1169}\u{11BB}"),
    ("\u{BD09}", "\u{BD09}", "\u{1107}\u{1169}\u{11BC}", "\u{BD09}", "\u{1107}\u{1169}\u{11BC}"),
    ("\u{BD0A}", "\u{BD0A}", "\u{1107}\u{1169}\u{11BD}", "\u{BD0A}", "\u{1107}\u{1169}\u{11BD}"),
    ("\u{BD0B}", "\u{BD0B}", "\u{1107}\u{1169}\u{11BE}", "\u{BD0B}", "\u{1107}\u{1169}\u{11BE}"),
    ("\u{BD0C}", "\u{BD0C}", "\u{1107}\u{1169}\u{11BF}", "\u{BD0C}", "\u{1107}\u{1169}\u{11BF}"),
    ("\u{BD0D}", "\u{BD0D}", "\u{1107}\u{1169}\u{11C0}", "\u{BD0D}", "\u{1107}\u{1169}\u{11C0}"),
    ("\u{BD0E}", "\u{BD0E}", "\u{1107}\u{1169}\u{11C1}", "\u{BD0E}", "\u{1107}\u{1169}\u{11C1}"),
    ("\u{BD0F}", "\u{BD0F}", "\u{1107}\u{1169}\u{11C2}", "\u{BD0F}", "\u{1107}\u{1169}\u{11C2}"),
    ("\u{BD10}", "\u{BD10}", "\u{1107}\u{116A}", "\u{BD10}", "\u{1107}\u{116A}"),
    ("\u{BD11}", "\u{BD11}", "\u{1107}\u{116A}\u{11A8}", "\u{BD11}", "\u{1107}\u{116A}\u{11A8}"),
    ("\u{BD12}", "\u{BD12}", "\u{1107}\u{116A}\u{11A9}", "\u{BD12}", "\u{1107}\u{116A}\u{11A9}"),
    ("\u{BD13}", "\u{BD13}", "\u{1107}\u{116A}\u{11AA}", "\u{BD13}", "\u{1107}\u{116A}\u{11AA}"),
    ("\u{BD14}", "\u{BD14}", "\u{1107}\u{116A}\u{11AB}", "\u{BD14}", "\u{1107}\u{116A}\u{11AB}"),
    ("\u{BD15}", "\u{BD15}", "\u{1107}\u{116A}\u{11AC}", "\u{BD15}", "\u{1107}\u{116A}\u{11AC}"),
    ("\u{BD16}", "\u{BD16}", "\u{1107}\u{116A}\u{11AD}", "\u{BD16}", "\u{1107}\u{116A}\u{11AD}"),
    ("\u{BD17}", "\u{BD17}", "\u{1107}\u{116A}\u{11AE}", "\u{BD17}", "\u{1107}\u{116A}\u{11AE}"),
    ("\u{BD18}", "\u{BD18}", "\u{1107}\u{116A}\u{11AF}", "\u{BD18}", "\u{1107}\u{116A}\u{11AF}"),
    ("\u{BD19}", "\u{BD19}", "\u{1107}\u{116A}\u{11B0}", "\u{BD19}", "\u{1107}\u{116A}\u{11B0}"),
    ("\u{BD1A}", "\u{BD1A}", "\u{1107}\u{116A}\u{11B1}", "\u{BD1A}", "\u{1107}\u{116A}\u{11B1}"),
    ("\u{BD1B}", "\u{BD1B}", "\u{1107}\u{116A}\u{11B2}", "\u{BD1B}", "\u{1107}\u{116A}\u{11B2}"),
    ("\u{BD1C}", "\u{BD1C}", "\u{1107}\u{116A}\u{11B3}", "\u{BD1C}", "\u{1107}\u{116A}\u{11B3}"),
    ("\u{BD1D}", "\u{BD1D}", "\u{1107}\u{116A}\u{11B4}", "\u{BD1D}", "\u{1107}\u{116A}\u{11B4}"),
    ("\u{BD1E}", "\u{BD1E}", "\u{1107}\u{116A}\u{11B5}", "\u{BD1E}", "\u{1107}\u{116A}\u{11B5}"),
    ("\u{BD1F}", "\u{BD1F}", "\u{1107}\u{116A}\u{11B6}", "\u{BD1F}", "\u{1107}\u{116A}\u{11B6}"),
    ("\u{BD20}", "\u{BD20}", "\u{1107}\u{116A}\u{11B7}", "\u{BD20}", "\u{1107}\u{116A}\u{11B7}"),
    ("\u{BD21}", "\u{BD21}", "\u{1107}\u{116A}\u{11B8}", "\u{BD21}", "\u{1107}\u{116A}\u{11B8}"),
    ("\u{BD22}", "\u{BD22}", "\u{1107}\u{116A}\u{11B9}", "\u{BD22}", "\u{1107}\u{116A}\u{11B9}"),
    ("\u{BD23}", "\u{BD23}", "\u{1107}\u{116A}\u{11BA}", "\u{BD23}", "\u{1107}\u{116A}\u{11BA}"),
    ("\u{BD24}", "\u{BD24}", "\u{1107}\u{116A}\u{11BB}", "\u{BD24}", "\u{1107}\u{116A}\u{11BB}"),
    ("\u{BD25}", "\u{BD25}", "\u{1107}\u{116A}\u{11BC}", "\u{BD25}", "\u{1107}\u{116A}\u{11BC}"),
    ("\u{BD26}", "\u{BD26}", "\u{1107}\u{116A}\u{11BD}", "\u{BD26}", "\u{1107}\u{116A}\u{11BD}"),
    ("\u{BD27}", "\u{BD27}", "\u{1107}\u{116A}\u{11BE}", "\u{BD27}", "\u{1107}\u{116A}\u{11BE}"),
    ("\u{BD28}", "\u{BD28}", "\u{1107}\u{116A}\u{11BF}", "\u{BD28}", "\u{1107}\u{116A}\u{11BF}"),
    ("\u{BD29}", "\u{BD29}", "\u{1107}\u{116A}\u{11C0}", "\u{BD29}", "\u{1107}\u{116A}\u{11C0}"),
    ("\u{BD2A}", "\u{BD2A}", "\u{1107}\u{116A}\u{11C1}", "\u{BD2A}", "\u{1107}\u{116A}\u{11C1}"),
    ("\u{BD2B}", "\u{BD2B}", "\u{1107}\u{116A}\u{11C2}", "\u{BD2B}", "\u{1107}\u{116A}\u{11C2}"),
    ("\u{BD2C}", "\u{BD2C}", "\u{1107}\u{116B}", "\u{BD2C}", "\u{1107}\u{116B}"),
    ("\u{BD2D}", "\u{BD2D}", "\u{1107}\u{116B}\u{11A8}", "\u{BD2D}", "\u{1107}\u{116B}\u{11A8}"),
    ("\u{BD2E}", "\u{BD2E}", "\u{1107}\u{116B}\u{11A9}", "\u{BD2E}", "\u{1107}\u{116B}\u{11A9}"),
    ("\u{BD2F}", "\u{BD2F}", "\u{1107}\u{116B}\u{11AA}", "\u{BD2F}", "\u{1107}\u{116B}\u{11AA}"),
    ("\u{BD30}", "\u{BD30}", "\u{1107}\u{116B}\u{11AB}", "\u{BD30}", "\u{1107}\u{116B}\u{11AB}"),
    ("\u{BD31}", "\u{BD31}", "\u{1107}\u{116B}\u{11AC}", "\u{BD31}", "\u{1107}\u{116B}\u{11AC}"),
    ("\u{BD32}", "\u{BD32}", "\u{1107}\u{116B}\u{11AD}", "\u{BD32}", "\u{1107}\u{116B}\u{11AD}"),
    ("\u{BD33}", "\u{BD33}", "\u{1107}\u{116B}\u{11AE}", "\u{BD33}", "\u{1107}\u{116B}\u{11AE}"),
    ("\u{BD34}", "\u{BD34}", "\u{1107}\u{116B}\u{11AF}", "\u{BD34}", "\u{1107}\u{116B}\u{11AF}"),
    ("\u{BD35}", "\u{BD35}", "\u{1107}\u{116B}\u{11B0}", "\u{BD35}", "\u{1107}\u{116B}\u{11B0}"),
    ("\u{BD36}", "\u{BD36}", "\u{1107}\u{116B}\u{11B1}", "\u{BD36}", "\u{1107}\u{116B}\u{11B1}"),
    ("\u{BD37}", "\u{BD37}", "\u{1107}\u{116B}\u{11B2}", "\u{BD37}", "\u{1107}\u{116B}\u{11B2}"),
    ("\u{BD38}", "\u{BD38}", "\u{1107}\u{116B}\u{11B3}", "\u{BD38}", "\u{1107}\u{116B}\u{11B3}"),
    ("\u{BD39}", "\u{BD39}", "\u{1107}\u{116B}\u{11B4}", "\u{BD39}", "\u{1107}\u{116B}\u{11B4}"),
    ("\u{BD3A}", "\u{BD3A}", "\u{1107}\u{116B}\u{11B5}", "\u{BD3A}", "\u{1107}\u{116B}\u{11B5}"),
    ("\u{BD3B}", "\u{BD3B}", "\u{1107}\u{116B}\u{11B6}", "\u{BD3B}", "\u{1107}\u{116B}\u{11B6}"),
    ("\u{BD3C}", "\u{BD3C}", "\u{1107}\u{116B}\u{11B7}", "\u{BD3C}", "\u{1107}\u{116B}\u{11B7}"),
    ("\u{BD3D}", "\u{BD3D}", "\u{1107}\u{116B}\u{11B8}", "\u{BD3D}", "\u{1107}\u{116B}\u{11B8}"),
    ("\u{BD3E}", "\u{BD3E}", "\u{1107}\u{116B}\u{11B9}", "\u{BD3E}", "\u{1107}\u{116B}\u{11B9}"),
    ("\u{BD3F}", "\u{BD3F}", "\u{1107}\u{116B}\u{11BA}", "\u{BD3F}", "\u{1107}\u{116B}\u{11BA}"),
    ("\u{BD40}", "\u{BD40}", "\u{1107}\u{116B}\u{11BB}", "\u{BD40}", "\u{1107}\u{116B}\u{11BB}"),
    ("\u{BD41}", "\u{BD41}", "\u{1107}\u{116B}\u{11BC}", "\u{BD41}", "\u{1107}\u{116B}\u{11BC}"),
    ("\u{BD42}", "\u{BD42}", "\u{1107}\u{116B}\u{11BD}", "\u{BD42}", "\u{1107}\u{116B}\u{11BD}"),
    ("\u{BD43}", "\u{BD43}", "\u{1107}\u{116B}\u{11BE}", "\u{BD43}", "\u{1107}\u{116B}\u{11BE}"),
    ("\u{BD44}", "\u{BD44}", "\u{1107}\u{116B}\u{11BF}", "\u{BD44}", "\u{1107}\u{116B}\u{11BF}"),
    ("\u{BD45}", "\u{BD45}", "\u{1107}\u{116B}\u{11C0}", "\u{BD45}", "\u{1107}\u{116B}\u{11C0}"),
    ("\u{BD46}", "\u{BD46}", "\u{1107}\u{116B}\u{11C1}", "\u{BD46}", "\u{1107}\u{116B}\u{11C1}"),
    ("\u{BD47}", "\u{BD47}", "\u{1107}\u{116B}\u{11C2}", "\u{BD47}", "\u{1107}\u{116B}\u{11C2}"),
    ("\u{BD48}", "\u{BD48}", "\u{1107}\u{116C}", "\u{BD48}", "\u{1107}\u{116C}"),
    ("\u{BD49}", "\u{BD49}", "\u{1107}\u{116C}\u{11A8}", "\u{BD49}", "\u{1107}\u{116C}\u{11A8}"),
    ("\u{BD4A}", "\u{BD4A}", "\u{1107}\u{116C}\u{11A9}", "\u{BD4A}", "\u{1107}\u{116C}\u{11A9}"),
    ("\u{BD4B}", "\u{BD4B}", "\u{1107}\u{116C}\u{11AA}", "\u{BD4B}", "\u{1107}\u{116C}\u{11AA}"),
    ("\u{BD4C}", "\u{BD4C}", "\u{1107}\u{116C}\u{11AB}", "\u{BD4C}", "\u{1107}\u{116C}\u{11AB}"),
    ("\u{BD4D}", "\u{BD4D}", "\u{1107}\u{116C}\u{11AC}", "\u{BD4D}", "\u{1107}\u{116C}\u{11AC}"),
    ("\u{BD4E}", "\u{BD4E}", "\u{1107}\u{116C}\u{11AD}", "\u{BD4E}", "\u{1107}\u{116C}\u{11AD}"),
    ("\u{BD4F}", "\u{BD4F}", "\u{1107}\u{116C}\u{11AE}", "\u{BD4F}", "\u{1107}\u{116C}\u{11AE}"),
    ("\u{BD50}", "\u{BD50}", "\u{1107}\u{116C}\u{11AF}", "\u{BD50}", "\u{1107}\u{116C}\u{11AF}"),
    ("\u{BD51}", "\u{BD51}", "\u{1107}\u{116C}\u{11B0}", "\u{BD51}", "\u{1107}\u{116C}\u{11B0}"),
    ("\u{BD52}", "\u{BD52}", "\u{1107}\u{116C}\u{11B1}", "\u{BD52}", "\u{1107}\u{116C}\u{11B1}"),
    ("\u{BD53}", "\u{BD53}", "\u{1107}\u{116C}\u{11B2}", "\u{BD53}", "\u{1107}\u{116C}\u{11B2}"),
    ("\u{BD54}", "\u{BD54}", "\u{1107}\u{116C}\u{11B3}", "\u{BD54}", "\u{1107}\u{116C}\u{11B3}"),
    ("\u{BD55}", "\u{BD55}", "\u{1107}\u{116C}\u{11B4}", "\u{BD55}", "\u{1107}\u{116C}\u{11B4}"),
    ("\u{BD56}", "\u{BD56}", "\u{1107}\u{116C}\u{11B5}", "\u{BD56}", "\u{1107}\u{116C}\u{11B5}"),
    ("\u{BD57}", "\u{BD57}", "\u{1107}\u{116C}\u{11B6}", "\u{BD57}", "\u{1107}\u{116C}\u{11B6}"),
    ("\u{BD58}", "\u{BD58}", "\u{1107}\u{116C}\u{11B7}", "\u{BD58}", "\u{1107}\u{116C}\u{11B7}"),
    ("\u{BD59}", "\u{BD59}", "\u{1107}\u{116C}\u{11B8}", "\u{BD59}", "\u{1107}\u{116C}\u{11B8}"),
    ("\u{BD5A}", "\u{BD5A}", "\u{1107}\u{116C}\u{11B9}", "\u{BD5A}", "\u{1107}\u{116C}\u{11B9}"),
    ("\u{BD5B}", "\u{BD5B}", "\u{1107}\u{116C}\u{11BA}", "\u{BD5B}", "\u{1107}\u{116C}\u{11BA}"),
    ("\u{BD5C}", "\u{BD5C}", "\u{1107}\u{116C}\u{11BB}", "\u{BD5C}", "\u{1107}\u{116C}\u{11BB}"),
    ("\u{BD5D}", "\u{BD5D}", "\u{1107}\u{116C}\u{11BC}", "\u{BD5D}", "\u{1107}\u{116C}\u{11BC}"),
    ("\u{BD5E}", "\u{BD5E}", "\u{1107}\u{116C}\u{11BD}", "\u{BD5E}", "\u{1107}\u{116C}\u{11BD}"),
    ("\u{BD5F}", "\u{BD5F}", "\u{1107}\u{116C}\u{11BE}", "\u{BD5F}", "\u{1107}\u{116C}\u{11BE}"),
    ("\u{BD60}", "\u{BD60}", "\u{1107}\u{116C}\u{11BF}", "\u{BD60}", "\u{1107}\u{116C}\u{11BF}"),
    ("\u{BD61}", "\u{BD61}", "\u{1107}\u{116C}\u{11C0}", "\u{BD61}", "\u{1107}\u{116C}\u{11C0}"),
    ("\u{BD62}", "\u{BD62}", "\u{1107}\u{116C}\u{11C1}", "\u{BD62}", "\u{1107}\u{116C}\u{11C1}"),
    ("\u{BD63}", "\u{BD63}", "\u{1107}\u{116C}\u{11C2}", "\u{BD63}", "\u{1107}\u{116C}\u{11C2}"),
    ("\u{BD64}", "\u{BD64}", "\u{1107}\u{116D}", "\u{BD64}", "\u{1107}\u{116D}"),
    ("\u{BD65}", "\u{BD65}", "\u{1107}\u{116D}\u{11A8}", "\u{BD65}", "\u{1107}\u{116D}\u{11A8}"),
    ("\u{BD66}", "\u{BD66}", "\u{1107}\u{116D}\u{11A9}", "\u{BD66}", "\u{1107}\u{116D}\u{11A9}"),
    ("\u{BD67}", "\u{BD67}", "\u{1107}\u{116D}\u{11AA}", "\u{BD67}", "\u{1107}\u{116D}\u{11AA}"),
    ("\u{BD68}", "\u{BD68}", "\u{1107}\u{116D}\u{11AB}", "\u{BD68}", "\u{1107}\u{116D}\u{11AB}"),
    ("\u{BD69}", "\u{BD69}", "\u{1107}\u{116D}\u{11AC}", "\u{BD69}", "\u{1107}\u{116D}\u{11AC}"),
    ("\u{BD6A}", "\u{BD6A}", "\u{1107}\u{116D}\u{11AD}", "\u{BD6A}", "\u{1107}\u{116D}\u{11AD}"),
    ("\u{BD6B}", "\u{BD6B}", "\u{1107}\u{116D}\u{11AE}", "\u{BD6B}", "\u{1107}\u{116D}\u{11AE}"),
    ("\u{BD6C}", "\u{BD6C}", "\u{1107}\u{116D}\u{11AF}", "\u{BD6C}", "\u{1107}\u{116D}\u{11AF}"),
    ("\u{BD6D}", "\u{BD6D}", "\u{1107}\u{116D}\u{11B0}", "\u{BD6D}", "\u{1107}\u{116D}\u{11B0}"),
    ("\u{BD6E}", "\u{BD6E}", "\u{1107}\u{116D}\u{11B1}", "\u{BD6E}", "\u{1107}\u{116D}\u{11B1}"),
    ("\u{BD6F}", "\u{BD6F}", "\u{1107}\u{116D}\u{11B2}", "\u{BD6F}", "\u{1107}\u{116D}\u{11B2}"),
    ("\u{BD70}", "\u{BD70}", "\u{1107}\u{116D}\u{11B3}", "\u{BD70}", "\u{1107}\u{116D}\u{11B3}"),
    ("\u{BD71}", "\u{BD71}", "\u{1107}\u{116D}\u{11B4}", "\u{BD71}", "\u{1107}\u{116D}\u{11B4}"),
    ("\u{BD72}", "\u{BD72}", "\u{1107}\u{116D}\u{11B5}", "\u{BD72}", "\u{1107}\u{116D}\u{11B5}"),
    ("\u{BD73}", "\u{BD73}", "\u{1107}\u{116D}\u{11B6}", "\u{BD73}", "\u{1107}\u{116D}\u{11B6}"),
    ("\u{BD74}", "\u{BD74}", "\u{1107}\u{116D}\u{11B7}", "\u{BD74}", "\u{1107}\u{116D}\u{11B7}"),
    ("\u{BD75}", "\u{BD75}", "\u{1107}\u{116D}\u{11B8}", "\u{BD75}", "\u{1107}\u{116D}\u{11B8}"),
    ("\u{BD76}", "\u{BD76}", "\u{1107}\u{116D}\u{11B9}", "\u{BD76}", "\u{1107}\u{116D}\u{11B9}"),
    ("\u{BD77}", "\u{BD77}", "\u{1107}\u{116D}\u{11BA}", "\u{BD77}", "\u{1107}\u{116D}\u{11BA}"),
    ("\u{BD78}", "\u{BD78}", "\u{1107}\u{116D}\u{11BB}", "\u{BD78}", "\u{1107}\u{116D}\u{11BB}"),
    ("\u{BD79}", "\u{BD79}", "\u{1107}\u{116D}\u{11BC}", "\u{BD79}", "\u{1107}\u{116D}\u{11BC}"),
    ("\u{BD7A}", "\u{BD7A}", "\u{1107}\u{116D}\u{11BD}", "\u{BD7A}", "\u{1107}\u{116D}\u{11BD}"),
    ("\u{BD7B}", "\u{BD7B}", "\u{1107}\u{116D}\u{11BE}", "\u{BD7B}", "\u{1107}\u{116D}\u{11BE}"),
    ("\u{BD7C}", "\u{BD7C}", "\u{1107}\u{116D}\u{11BF}", "\u{BD7C}", "\u{1107}\u{116D}\u{11BF}"),
    ("\u{BD7D}", "\u{BD7D}", "\u{1107}\u{116D}\u{11C0}", "\u{BD7D}", "\u{1107}\u{116D}\u{11C0}"),
    ("\u{BD7E}", "\u{BD7E}", "\u{1107}\u{116D}\u{11C1}", "\u{BD7E}", "\u{1107}\u{116D}\u{11C1}"),
    ("\u{BD7F}", "\u{BD7F}", "\u{1107}\u{116D}\u{11C2}", "\u{BD7F}", "\u{1107}\u{116D}\u{11C2}"),
    ("\u{BD80}", "\u{BD80}", "\u{1107}\u{116E}", "\u{BD80}", "\u{1107}\u{116E}"),
    ("\u{BD81}", "\u{BD81}", "\u{1107}\u{116E}\u{11A8}", "\u{BD81}", "\u{1107}\u{116E}\u{11A8}"),
    ("\u{BD82}", "\u{BD82}", "\u{1107}\u{116E}\u{11A9}", "\u{BD82}", "\u{1107}\u{116E}\u{11A9}"),
    ("\u{BD83}", "\u{BD83}", "\u{1107}\u{116E}\u{11AA}", "\u{BD83}", "\u{1107}\u{116E}\u{11AA}"),
    ("\u{BD84}", "\u{BD84}", "\u{1107}\u{116E}\u{11AB}", "\u{BD84}", "\u{1107}\u{116E}\u{11AB}"),
    ("\u{BD85}", "\u{BD85}", "\u{1107}\u{116E}\u{11AC}", "\u{BD85}", "\u{1107}\u{116E}\u{11AC}"),
    ("\u{BD86}", "\u{BD86}", "\u{1107}\u{116E}\u{11AD}", "\u{BD86}", "\u{1107}\u{116E}\u{11AD}"),
    ("\u{BD87}", "\u{BD87}", "\u{1107}\u{116E}\u{11AE}", "\u{BD87}", "\u{1107}\u{116E}\u{11AE}"),
    ("\u{BD88}", "\u{BD88}", "\u{1107}\u{116E}\u{11AF}", "\u{BD88}", "\u{1107}\u{116E}\u{11AF}"),
    ("\u{BD89}", "\u{BD89}", "\u{1107}\u{116E}\u{11B0}", "\u{BD89}", "\u{1107}\u{116E}\u{11B0}"),
    ("\u{BD8A}", "\u{BD8A}", "\u{1107}\u{116E}\u{11B1}", "\u{BD8A}", "\u{1107}\u{116E}\u{11B1}"),
    ("\u{BD8B}", "\u{BD8B}", "\u{1107}\u{116E}\u{11B2}", "\u{BD8B}", "\u{1107}\u{116E}\u{11B2}"),
    ("\u{BD8C}", "\u{BD8C}", "\u{1107}\u{116E}\u{11B3}", "\u{BD8C}", "\u{1107}\u{116E}\u{11B3}"),
    ("\u{BD8D}", "\u{BD8D}", "\u{1107}\u{116E}\u{11B4}", "\u{BD8D}", "\u{1107}\u{116E}\u{11B4}"),
    ("\u{BD8E}", "\u{BD8E}", "\u{1107}\u{116E}\u{11B5}", "\u{BD8E}", "\u{1107}\u{116E}\u{11B5}"),
    ("\u{BD8F}", "\u{BD8F}", "\u{1107}\u{116E}\u{11B6}", "\u{BD8F}", "\u{1107}\u{116E}\u{11B6}"),
    ("\u{BD90}", "\u{BD90}", "\u{1107}\u{116E}\u{11B7}", "\u{BD90}", "\u{1107}\u{116E}\u{11B7}"),
    ("\u{BD91}", "\u{BD91}", "\u{1107}\u{116E}\u{11B8}", "\u{BD91}", "\u{1107}\u{116E}\u{11B8}"),
    ("\u{BD92}", "\u{BD92}", "\u{1107}\u{116E}\u{11B9}", "\u{BD92}", "\u{1107}\u{116E}\u{11B9}"),
    ("\u{BD93}", "\u{BD93}", "\u{1107}\u{116E}\u{11BA}", "\u{BD93}", "\u{1107}\u{116E}\u{11BA}"),
    ("\u{BD94}", "\u{BD94}", "\u{1107}\u{116E}\u{11BB}", "\u{BD94}", "\u{1107}\u{116E}\u{11BB}"),
    ("\u{BD95}", "\u{BD95}", "\u{1107}\u{116E}\u{11BC}", "\u{BD95}", "\u{1107}\u{116E}\u{11BC}"),
    ("\u{BD96}", "\u{BD96}", "\u{1107}\u{116E}\u{11BD}", "\u{BD96}", "\u{1107}\u{116E}\u{11BD}"),
    ("\u{BD97}", "\u{BD97}", "\u{1107}\u{116E}\u{11BE}", "\u{BD97}", "\u{1107}\u{116E}\u{11BE}"),
    ("\u{BD98}", "\u{BD98}", "\u{1107}\u{116E}\u{11BF}", "\u{BD98}", "\u{1107}\u{116E}\u{11BF}"),
    ("\u{BD99}", "\u{BD99}", "\u{1107}\u{116E}\u{11C0}", "\u{BD99}", "\u{1107}\u{116E}\u{11C0}"),
    ("\u{BD9A}", "\u{BD9A}", "\u{1107}\u{116E}\u{11C1}", "\u{BD9A}", "\u{1107}\u{116E}\u{11C1}"),
    ("\u{BD9B}", "\u{BD9B}", "\u{1107}\u{116E}\u{11C2}", "\u{BD9B}", "\u{1107}\u{116E}\u{11C2}"),
    ("\u{BD9C}", "\u{BD9C}", "\u{1107}\u{116F}", "\u{BD9C}", "\u{1107}\u{116F}"),
    ("\u{BD9D}", "\u{BD9D}", "\u{1107}\u{116F}\u{11A8}", "\u{BD9D}", "\u{1107}\u{116F}\u{11A8}"),
    ("\u{BD9E}", "\u{BD9E}", "\u{1107}\u{116F}\u{11A9}", "\u{BD9E}", "\u{1107}\u{116F}\u{11A9}"),
    ("\u{BD9F}", "\u{BD9F}", "\u{1107}\u{116F}\u{11AA}", "\u{BD9F}", "\u{1107}\u{116F}\u{11AA}"),
    ("\u{BDA0}", "\u{BDA0}", "\u{1107}\u{116F}\u{11AB}", "\u{BDA0}", "\u{1107}\u{116F}\u{11AB}"),
    ("\u{BDA1}", "\u{BDA1}", "\u{1107}\u{116F}\u{11AC}", "\u{BDA1}", "\u{1107}\u{116F}\u{11AC}"),
    ("\u{BDA2}", "\u{BDA2}", "\u{1107}\u{116F}\u{11AD}", "\u{BDA2}", "\u{1107}\u{116F}\u{11AD}"),
    ("\u{BDA3}", "\u{BDA3}", "\u{1107}\u{116F}\u{11AE}", "\u{BDA3}", "\u{1107}\u{116F}\u{11AE}"),
    ("\u{BDA4}", "\u{BDA4}", "\u{1107}\u{116F}\u{11AF}", "\u{BDA4}", "\u{1107}\u{116F}\u{11AF}"),
    ("\u{BDA5}", "\u{BDA5}", "\u{1107}\u{116F}\u{11B0}", "\u{BDA5}", "\u{1107}\u{116F}\u{11B0}"),
    ("\u{BDA6}", "\u{BDA6}", "\u{1107}\u{116F}\u{11B1}", "\u{BDA6}", "\u{1107}\u{116F}\u{11B1}"),
    ("\u{BDA7}", "\u{BDA7}", "\u{1107}\u{116F}\u{11B2}", "\u{BDA7}", "\u{1107}\u{116F}\u{11B2}"),
    ("\u{BDA8}", "\u{BDA8}", "\u{1107}\u{116F}\u{11B3}", "\u{BDA8}", "\u{1107}\u{116F}\u{11B3}"),
    ("\u{BDA9}", "\u{BDA9}", "\u{1107}\u{116F}\u{11B4}", "\u{BDA9}", "\u{1107}\u{116F}\u{11B4}"),
    ("\u{BDAA}", "\u{BDAA}", "\u{1107}\u{116F}\u{11B5}", "\u{BDAA}", "\u{1107}\u{116F}\u{11B5}"),
    ("\u{BDAB}", "\u{BDAB}", "\u{1107}\u{116F}\u{11B6}", "\u{BDAB}", "\u{1107}\u{116F}\u{11B6}"),
    ("\u{BDAC}", "\u{BDAC}", "\u{1107}\u{116F}\u{11B7}", "\u{BDAC}", "\u{1107}\u{116F}\u{11B7}"),
    ("\u{BDAD}", "\u{BDAD}", "\u{1107}\u{116F}\u{11B8}", "\u{BDAD}", "\u{1107}\u{116F}\u{11B8}"),
    ("\u{BDAE}", "\u{BDAE}", "\u{1107}\u{116F}\u{11B9}", "\u{BDAE}", "\u{1107}\u{116F}\u{11B9}"),
    ("\u{BDAF}", "\u{BDAF}", "\u{1107}\u{116F}\u{11BA}", "\u{BDAF}", "\u{1107}\u{116F}\u{11BA}"),
    ("\u{BDB0}", "\u{BDB0}", "\u{1107}\u{116F}\u{11BB}", "\u{BDB0}", "\u{1107}\u{116F}\u{11BB}"),
    ("\u{BDB1}", "\u{BDB1}", "\u{1107}\u{116F}\u{11BC}", "\u{BDB1}", "\u{1107}\u{116F}\u{11BC}"),
    ("\u{BDB2}", "\u{BDB2}", "\u{1107}\u{116F}\u{11BD}", "\u{BDB2}", "\u{1107}\u{116F}\u{11BD}"),
    ("\u{BDB3}", "\u{BDB3}", "\u{1107}\u{116F}\u{11BE}", "\u{BDB3}", "\u{1107}\u{116F}\u{11BE}"),
    ("\u{BDB4}", "\u{BDB4}", "\u{1107}\u{116F}\u{11BF}", "\u{BDB4}", "\u{1107}\u{116F}\u{11BF}"),
    ("\u{BDB5}", "\u{BDB5}", "\u{1107}\u{116F}\u{11C0}", "\u{BDB5}", "\u{1107}\u{116F}\u{11C0}"),
    ("\u{BDB6}", "\u{BDB6}", "\u{1107}\u{116F}\u{11C1}", "\u{BDB6}", "\u{1107}\u{116F}\u{11C1}"),
    ("\u{BDB7}", "\u{BDB7}", "\u{1107}\u{116F}\u{11C2}", "\u{BDB7}", "\u{1107}\u{116F}\u{11C2}"),
    ("\u{BDB8}", "\u{BDB8}", "\u{1107}\u{1170}", "\u{BDB8}", "\u{1107}\u{1170}"),
    ("\u{BDB9}", "\u{BDB9}", "\u{1107}\u{1170}\u{11A8}", "\u{BDB9}", "\u{1107}\u{1170}\u{11A8}"),
    ("\u{BDBA}", "\u{BDBA}", "\u{1107}\u{1170}\u{11A9}", "\u{BDBA}", "\u{1107}\u{1170}\u{11A9}"),
    ("\u{BDBB}", "\u{BDBB}", "\u{1107}\u{1170}\u{11AA}", "\u{BDBB}", "\u{1107}\u{1170}\u{11AA}"),
    ("\u{BDBC}", "\u{BDBC}", "\u{1107}\u{1170}\u{11AB}", "\u{BDBC}", "\u{1107}\u{1170}\u{11AB}"),
    ("\u{BDBD}", "\u{BDBD}", "\u{1107}\u{1170}\u{11AC}", "\u{BDBD}", "\u{1107}\u{1170}\u{11AC}"),
    ("\u{BDBE}", "\u{BDBE}", "\u{1107}\u{1170}\u{11AD}", "\u{BDBE}", "\u{1107}\u{1170}\u{11AD}"),
    ("\u{BDBF}", "\u{BDBF}", "\u{1107}\u{1170}\u{11AE}", "\u{BDBF}", "\u{1107}\u{1170}\u{11AE}"),
    ("\u{BDC0}", "\u{BDC0}", "\u{1107}\u{1170}\u{11AF}", "\u{BDC0}", "\u{1107}\u{1170}\u{11AF}"),
    ("\u{BDC1}", "\u{BDC1}", "\u{1107}\u{1170}\u{11B0}", "\u{BDC1}", "\u{1107}\u{1170}\u{11B0}"),
    ("\u{BDC2}", "\u{BDC2}", "\u{1107}\u{1170}\u{11B1}", "\u{BDC2}", "\u{1107}\u{1170}\u{11B1}"),
    ("\u{BDC3}", "\u{BDC3}", "\u{1107}\u{1170}\u{11B2}", "\u{BDC3}", "\u{1107}\u{1170}\u{11B2}"),
    ("\u{BDC4}", "\u{BDC4}", "\u{1107}\u{1170}\u{11B3}", "\u{BDC4}", "\u{1107}\u{1170}\u{11B3}"),
    ("\u{BDC5}", "\u{BDC5}", "\u{1107}\u{1170}\u{11B4}", "\u{BDC5}", "\u{1107}\u{1170}\u{11B4}"),
    ("\u{BDC6}", "\u{BDC6}", "\u{1107}\u{1170}\u{11B5}", "\u{BDC6}", "\u{1107}\u{1170}\u{11B5}"),
    ("\u{BDC7}", "\u{BDC7}", "\u{1107}\u{1170}\u{11B6}", "\u{BDC7}", "\u{1107}\u{1170}\u{11B6}"),
    ("\u{BDC8}", "\u{BDC8}", "\u{1107}\u{1170}\u{11B7}", "\u{BDC8}", "\u{1107}\u{1170}\u{11B7}"),
    ("\u{BDC9}", "\u{BDC9}", "\u{1107}\u{1170}\u{11B8}", "\u{BDC9}", "\u{1107}\u{1170}\u{11B8}"),
    ("\u{BDCA}", "\u{BDCA}", "\u{1107}\u{1170}\u{11B9}", "\u{BDCA}", "\u{1107}\u{1170}\u{11B9}"),
    ("\u{BDCB}", "\u{BDCB}", "\u{1107}\u{1170}\u{11BA}", "\u{BDCB}", "\u{1107}\u{1170}\u{11BA}"),
    ("\u{BDCC}", "\u{BDCC}", "\u{1107}\u{1170}\u{11BB}", "\u{BDCC}", "\u{1107}\u{1170}\u{11BB}"),
    ("\u{BDCD}", "\u{BDCD}", "\u{1107}\u{1170}\u{11BC}", "\u{BDCD}", "\u{1107}\u{1170}\u{11BC}"),
    ("\u{BDCE}", "\u{BDCE}", "\u{1107}\u{1170}\u{11BD}", "\u{BDCE}", "\u{1107}\u{1170}\u{11BD}"),
    ("\u{BDCF}", "\u{BDCF}", "\u{1107}\u{1170}\u{11BE}", "\u{BDCF}", "\u{1107}\u{1170}\u{11BE}"),
    ("\u{BDD0}", "\u{BDD0}", "\u{1107}\u{1170}\u{11BF}", "\u{BDD0}", "\u{1107}\u{1170}\u{11BF}"),
    ("\u{BDD1}", "\u{BDD1}", "\u{1107}\u{1170}\u{11C0}", "\u{BDD1}", "\u{1107}\u{1170}\u{11C0}"),
    ("\u{BDD2}", "\u{BDD2}", "\u{1107}\u{1170}\u{11C1}", "\u{BDD2}", "\u{1107}\u{1170}\u{11C1}"),
    ("\u{BDD3}", "\u{BDD3}", "\u{1107}\u{1170}\u{11C2}", "\u{BDD3}", "\u{1107}\u{1170}\u{11C2}"),
    ("\u{BDD4}", "\u{BDD4}", "\u{1107}\u{1171}", "\u{BDD4}", "\u{1107}\u{1171}"),
    ("\u{BDD5}", "\u{BDD5}", "\u{1107}\u{1171}\u{11A8}", "\u{BDD5}", "\u{1107}\u{1171}\u{11A8}"),
    ("\u{BDD6}", "\u{BDD6}", "\u{1107}\u{1171}\u{11A9}", "\u{BDD6}", "\u{1107}\u{1171}\u{11A9}"),
    ("\u{BDD7}", "\u{BDD7}", "\u{1107}\u{1171}\u{11AA}", "\u{BDD7}", "\u{1107}\u{1171}\u{11AA}"),
    ("\u{BDD8}", "\u{BDD8}", "\u{1107}\u{1171}\u{11AB}", "\u{BDD8}", "\u{1107}\u{1171}\u{11AB}"),
    ("\u{BDD9}", "\u{BDD9}", "\u{1107}\u{1171}\u{11AC}", "\u{BDD9}", "\u{1107}\u{1171}\u{11AC}"),
    ("\u{BDDA}", "\u{BDDA}", "\u{1107}\u{1171}\u{11AD}", "\u{BDDA}", "\u{1107}\u{1171}\u{11AD}"),
    ("\u{BDDB}", "\u{BDDB}", "\u{1107}\u{1171}\u{11AE}", "\u{BDDB}", "\u{1107}\u{1171}\u{11AE}"),
    ("\u{BDDC}", "\u{BDDC}", "\u{1107}\u{1171}\u{11AF}", "\u{BDDC}", "\u{1107}\u{1171}\u{11AF}"),
    ("\u{BDDD}", "\u{BDDD}", "\u{1107}\u{1171}\u{11B0}", "\u{BDDD}", "\u{1107}\u{1171}\u{11B0}"),
    ("\u{BDDE}", "\u{BDDE}", "\u{1107}\u{1171}\u{11B1}", "\u{BDDE}", "\u{1107}\u{1171}\u{11B1}"),
    ("\u{BDDF}", "\u{BDDF}", "\u{1107}\u{1171}\u{11B2}", "\u{BDDF}", "\u{1107}\u{1171}\u{11B2}"),
    ("\u{BDE0}", "\u{BDE0}", "\u{1107}\u{1171}\u{11B3}", "\u{BDE0}", "\u{1107}\u{1171}\u{11B3}"),
    ("\u{BDE1}", "\u{BDE1}", "\u{1107}\u{1171}\u{11B4}", "\u{BDE1}", "\u{1107}\u{1171}\u{11B4}"),
    ("\u{BDE2}", "\u{BDE2}", "\u{1107}\u{1171}\u{11B5}", "\u{BDE2}", "\u{1107}\u{1171}\u{11B5}"),
    ("\u{BDE3}", "\u{BDE3}", "\u{1107}\u{1171}\u{11B6}", "\u{BDE3}", "\u{1107}\u{1171}\u{11B6}"),
    ("\u{BDE4}", "\u{BDE4}", "\u{1107}\u{1171}\u{11B7}", "\u{BDE4}", "\u{1107}\u{1171}\u{11B7}"),
    ("\u{BDE5}", "\u{BDE5}", "\u{1107}\u{1171}\u{11B8}", "\u{BDE5}", "\u{1107}\u{1171}\u{11B8}"),
    ("\u{BDE6}", "\u{BDE6}", "\u{1107}\u{1171}\u{11B9}", "\u{BDE6}", "\u{1107}\u{1171}\u{11B9}"),
    ("\u{BDE7}", "\u{BDE7}", "\u{1107}\u{1171}\u{11BA}", "\u{BDE7}", "\u{1107}\u{1171}\u{11BA}"),
    ("\u{BDE8}", "\u{BDE8}", "\u{1107}\u{1171}\u{11BB}", "\u{BDE8}", "\u{1107}\u{1171}\u{11BB}"),
    ("\u{BDE9}", "\u{BDE9}", "\u{1107}\u{1171}\u{11BC}", "\u{BDE9}", "\u{1107}\u{1171}\u{11BC}"),
    ("\u{BDEA}", "\u{BDEA}", "\u{1107}\u{1171}\u{11BD}", "\u{BDEA}", "\u{1107}\u{1171}\u{11BD}"),
    ("\u{BDEB}", "\u{BDEB}", "\u{1107}\u{1171}\u{11BE}", "\u{BDEB}", "\u{1107}\u{1171}\u{11BE}"),
    ("\u{BDEC}", "\u{BDEC}", "\u{1107}\u{1171}\u{11BF}", "\u{BDEC}", "\u{1107}\u{1171}\u{11BF}"),
    ("\u{BDED}", "\u{BDED}", "\u{1107}\u{1171}\u{11C0}", "\u{BDED}", "\u{1107}\u{1171}\u{11C0}"),
    ("\u{BDEE}", "\u{BDEE}", "\u{1107}\u{1171}\u{11C1}", "\u{BDEE}", "\u{1107}\u{1171}\u{11C1}"),
    ("\u{BDEF}", "\u{BDEF}", "\u{1107}\u{1171}\u{11C2}", "\u{BDEF}", "\u{1107}\u{1171}\u{11C2}"),
    ("\u{BDF0}", "\u{BDF0}", "\u{1107}\u{1172}", "\u{BDF0}", "\u{1107}\u{1172}"),
    ("\u{BDF1}", "\u{BDF1}", "\u{1107}\u{1172}\u{11A8}", "\u{BDF1}", "\u{1107}\u{1172}\u{11A8}"),
    ("\u{BDF2}", "\u{BDF2}", "\u{1107}\u{1172}\u{11A9}", "\u{BDF2}", "\u{1107}\u{1172}\u{11A9}"),
    ("\u{BDF3}", "\u{BDF3}", "\u{1107}\u{1172}\u{11AA}", "\u{BDF3}", "\u{1107}\u{1172}\u{11AA}"),
    ("\u{BDF4}", "\u{BDF4}", "\u{1107}\u{1172}\u{11AB}", "\u{BDF4}", "\u{1107}\u{1172}\u{11AB}"),
    ("\u{BDF5}", "\u{BDF5}", "\u{1107}\u{1172}\u{11AC}", "\u{BDF5}", "\u{1107}\u{1172}\u{11AC}"),
    ("\u{BDF6}", "\u{BDF6}", "\u{1107}\u{1172}\u{11AD}", "\u{BDF6}", "\u{1107}\u{1172}\u{11AD}"),
    ("\u{BDF7}", "\u{BDF7}", "\u{1107}\u{1172}\u{11AE}", "\u{BDF7}", "\u{1107}\u{1172}\u{11AE}"),
    ("\u{BDF8}", "\u{BDF8}", "\u{1107}\u{1172}\u{11AF}", "\u{BDF8}", "\u{1107}\u{1172}\u{11AF}"),
    ("\u{BDF9}", "\u{BDF9}", "\u{1107}\u{1172}\u{11B0}", "\u{BDF9}", "\u{1107}\u{1172}\u{11B0}"),
    ("\u{BDFA}", "\u{BDFA}", "\u{1107}\u{1172}\u{11B1}", "\u{BDFA}", "\u{1107}\u{1172}\u{11B1}"),
    ("\u{BDFB}", "\u{BDFB}", "\u{1107}\u{1172}\u{11B2}", "\u{BDFB}", "\u{1107}\u{1172}\u{11B2}"),
    ("\u{BDFC}", "\u{BDFC}", "\u{1107}\u{1172}\u{11B3}", "\u{BDFC}", "\u{1107}\u{1172}\u{11B3}"),
    ("\u{BDFD}", "\u{BDFD}", "\u{1107}\u{1172}\u{11B4}", "\u{BDFD}", "\u{1107}\u{1172}\u{11B4}"),
    ("\u{BDFE}", "\u{BDFE}", "\u{1107}\u{1172}\u{11B5}", "\u{BDFE}", "\u{1107}\u{1172}\u{11B5}"),
    ("\u{BDFF}", "\u{BDFF}", "\u{1107}\u{1172}\u{11B6}", "\u{BDFF}", "\u{1107}\u{1172}\u{11B6}"),
    ("\u{BE00}", "\u{BE00}", "\u{1107}\u{1172}\u{11B7}", "\u{BE00}", "\u{1107}\u{1172}\u{11B7}"),
    ("\u{BE01}", "\u{BE01}", "\u{1107}\u{1172}\u{11B8}", "\u{BE01}", "\u{1107}\u{1172}\u{11B8}"),
    ("\u{BE02}", "\u{BE02}", "\u{1107}\u{1172}\u{11B9}", "\u{BE02}", "\u{1107}\u{1172}\u{11B9}"),
    ("\u{BE03}", "\u{BE03}", "\u{1107}\u{1172}\u{11BA}", "\u{BE03}", "\u{1107}\u{1172}\u{11BA}"),
    ("\u{BE04}", "\u{BE04}", "\u{1107}\u{1172}\u{11BB}", "\u{BE04}", "\u{1107}\u{1172}\u{11BB}"),
    ("\u{BE05}", "\u{BE05}", "\u{1107}\u{1172}\u{11BC}", "\u{BE05}", "\u{1107}\u{1172}\u{11BC}"),
    ("\u{BE06}", "\u{BE06}", "\u{1107}\u{1172}\u{11BD}", "\u{BE06}", "\u{1107}\u{1172}\u{11BD}"),
    ("\u{BE07}", "\u{BE07}", "\u{1107}\u{1172}\u{11BE}", "\u{BE07}", "\u{1107}\u{1172}\u{11BE}"),
    ("\u{BE08}", "\u{BE08}", "\u{1107}\u{1172}\u{11BF}", "\u{BE08}", "\u{1107}\u{1172}\u{11BF}"),
    ("\u{BE09}", "\u{BE09}", "\u{1107}\u{1172}\u{11C0}", "\u{BE09}", "\u{1107}\u{1172}\u{11C0}"),
    ("\u{BE0A}", "\u{BE0A}", "\u{1107}\u{1172}\u{11C1}", "\u{BE0A}", "\u{1107}\u{1172}\u{11C1}"),
    ("\u{BE0B}", "\u{BE0B}", "\u{1107}\u{1172}\u{11C2}", "\u{BE0B}", "\u{1107}\u{1172}\u{11C2}"),
    ("\u{BE0C}", "\u{BE0C}", "\u{1107}\u{1173}", "\u{BE0C}", "\u{1107}\u{1173}"),
    ("\u{BE0D}", "\u{BE0D}", "\u{1107}\u{1173}\u{11A8}", "\u{BE0D}", "\u{1107}\u{1173}\u{11A8}"),
    ("\u{BE0E}", "\u{BE0E}", "\u{1107}\u{1173}\u{11A9}", "\u{BE0E}", "\u{1107}\u{1173}\u{11A9}"),
    ("\u{BE0F}", "\u{BE0F}", "\u{1107}\u{1173}\u{11AA}", "\u{BE0F}", "\u{1107}\u{1173}\u{11AA}"),
    ("\u{BE10}", "\u{BE10}", "\u{1107}\u{1173}\u{11AB}", "\u{BE10}", "\u{1107}\u{1173}\u{11AB}"),
    ("\u{BE11}", "\u{BE11}", "\u{1107}\u{1173}\u{11AC}", "\u{BE11}", "\u{1107}\u{1173}\u{11AC}"),
    ("\u{BE12}", "\u{BE12}", "\u{1107}\u{1173}\u{11AD}", "\u{BE12}", "\u{1107}\u{1173}\u{11AD}"),
    ("\u{BE13}", "\u{BE13}", "\u{1107}\u{1173}\u{11AE}", "\u{BE13}", "\u{1107}\u{1173}\u{11AE}"),
    ("\u{BE14}", "\u{BE14}", "\u{1107}\u{1173}\u{11AF}", "\u{BE14}", "\u{1107}\u{1173}\u{11AF}"),
    ("\u{BE15}", "\u{BE15}", "\u{1107}\u{1173}\u{11B0}", "\u{BE15}", "\u{1107}\u{1173}\u{11B0}"),
    ("\u{BE16}", "\u{BE16}", "\u{1107}\u{1173}\u{11B1}", "\u{BE16}", "\u{1107}\u{1173}\u{11B1}"),
    ("\u{BE17}", "\u{BE17}", "\u{1107}\u{1173}\u{11B2}", "\u{BE17}", "\u{1107}\u{1173}\u{11B2}"),
    ("\u{BE18}", "\u{BE18}", "\u{1107}\u{1173}\u{11B3}", "\u{BE18}", "\u{1107}\u{1173}\u{11B3}"),
    ("\u{BE19}", "\u{BE19}", "\u{1107}\u{1173}\u{11B4}", "\u{BE19}", "\u{1107}\u{1173}\u{11B4}"),
    ("\u{BE1A}", "\u{BE1A}", "\u{1107}\u{1173}\u{11B5}", "\u{BE1A}", "\u{1107}\u{1173}\u{11B5}"),
    ("\u{BE1B}", "\u{BE1B}", "\u{1107}\u{1173}\u{11B6}", "\u{BE1B}", "\u{1107}\u{1173}\u{11B6}"),
    ("\u{BE1C}", "\u{BE1C}", "\u{1107}\u{1173}\u{11B7}", "\u{BE1C}", "\u{1107}\u{1173}\u{11B7}"),
    ("\u{BE1D}", "\u{BE1D}", "\u{1107}\u{1173}\u{11B8}", "\u{BE1D}", "\u{1107}\u{1173}\u{11B8}"),
    ("\u{BE1E}", "\u{BE1E}", "\u{1107}\u{1173}\u{11B9}", "\u{BE1E}", "\u{1107}\u{1173}\u{11B9}"),
    ("\u{BE1F}", "\u{BE1F}", "\u{1107}\u{1173}\u{11BA}", "\u{BE1F}", "\u{1107}\u{1173}\u{11BA}"),
    ("\u{BE20}", "\u{BE20}", "\u{1107}\u{1173}\u{11BB}", "\u{BE20}", "\u{1107}\u{1173}\u{11BB}"),
    ("\u{BE21}", "\u{BE21}", "\u{1107}\u{1173}\u{11BC}", "\u{BE21}", "\u{1107}\u{1173}\u{11BC}"),
    ("\u{BE22}", "\u{BE22}", "\u{1107}\u{1173}\u{11BD}", "\u{BE22}", "\u{1107}\u{1173}\u{11BD}"),
    ("\u{BE23}", "\u{BE23}", "\u{1107}\u{1173}\u{11BE}", "\u{BE23}", "\u{1107}\u{1173}\u{11BE}"),
    ("\u{BE24}", "\u{BE24}", "\u{1107}\u{1173}\u{11BF}", "\u{BE24}", "\u{1107}\u{1173}\u{11BF}"),
    ("\u{BE25}", "\u{BE25}", "\u{1107}\u{1173}\u{11C0}", "\u{BE25}", "\u{1107}\u{1173}\u{11C0}"),
    ("\u{BE26}", "\u{BE26}", "\u{1107}\u{1173}\u{11C1}", "\u{BE26}", "\u{1107}\u{1173}\u{11C1}"),
    ("\u{BE27}", "\u{BE27}", "\u{1107}\u{1173}\u{11C2}", "\u{BE27}", "\u{1107}\u{1173}\u{11C2}"),
    ("\u{BE28}", "\u{BE28}", "\u{1107}\u{1174}", "\u{BE28}", "\u{1107}\u{1174}"),
    ("\u{BE29}", "\u{BE29}", "\u{1107}\u{1174}\u{11A8}", "\u{BE29}", "\u{1107}\u{1174}\u{11A8}"),
    ("\u{BE2A}", "\u{BE2A}", "\u{1107}\u{1174}\u{11A9}", "\u{BE2A}", "\u{1107}\u{1174}\u{11A9}"),
    ("\u{BE2B}", "\u{BE2B}", "\u{1107}\u{1174}\u{11AA}", "\u{BE2B}", "\u{1107}\u{1174}\u{11AA}"),
    ("\u{BE2C}", "\u{BE2C}", "\u{1107}\u{1174}\u{11AB}", "\u{BE2C}", "\u{1107}\u{1174}\u{11AB}"),
    ("\u{BE2D}", "\u{BE2D}", "\u{1107}\u{1174}\u{11AC}", "\u{BE2D}", "\u{1107}\u{1174}\u{11AC}"),
    ("\u{BE2E}", "\u{BE2E}", "\u{1107}\u{1174}\u{11AD}", "\u{BE2E}", "\u{1107}\u{1174}\u{11AD}"),
    ("\u{BE2F}", "\u{BE2F}", "\u{1107}\u{1174}\u{11AE}", "\u{BE2F}", "\u{1107}\u{1174}\u{11AE}"),
    ("\u{BE30}", "\u{BE30}", "\u{1107}\u{1174}\u{11AF}", "\u{BE30}", "\u{1107}\u{1174}\u{11AF}"),
    ("\u{BE31}", "\u{BE31}", "\u{1107}\u{1174}\u{11B0}", "\u{BE31}", "\u{1107}\u{1174}\u{11B0}"),
    ("\u{BE32}", "\u{BE32}", "\u{1107}\u{1174}\u{11B1}", "\u{BE32}", "\u{1107}\u{1174}\u{11B1}"),
    ("\u{BE33}", "\u{BE33}", "\u{1107}\u{1174}\u{11B2}", "\u{BE33}", "\u{1107}\u{1174}\u{11B2}"),
    ("\u{BE34}", "\u{BE34}", "\u{1107}\u{1174}\u{11B3}", "\u{BE34}", "\u{1107}\u{1174}\u{11B3}"),
    ("\u{BE35}", "\u{BE35}", "\u{1107}\u{1174}\u{11B4}", "\u{BE35}", "\u{1107}\u{1174}\u{11B4}"),
    ("\u{BE36}", "\u{BE36}", "\u{1107}\u{1174}\u{11B5}", "\u{BE36}", "\u{1107}\u{1174}\u{11B5}"),
    ("\u{BE37}", "\u{BE37}", "\u{1107}\u{1174}\u{11B6}", "\u{BE37}", "\u{1107}\u{1174}\u{11B6}"),
    ("\u{BE38}", "\u{BE38}", "\u{1107}\u{1174}\u{11B7}", "\u{BE38}", "\u{1107}\u{1174}\u{11B7}"),
    ("\u{BE39}", "\u{BE39}", "\u{1107}\u{1174}\u{11B8}", "\u{BE39}", "\u{1107}\u{1174}\u{11B8}"),
    ("\u{BE3A}", "\u{BE3A}", "\u{1107}\u{1174}\u{11B9}", "\u{BE3A}", "\u{1107}\u{1174}\u{11B9}"),
    ("\u{BE3B}", "\u{BE3B}", "\u{1107}\u{1174}\u{11BA}", "\u{BE3B}", "\u{1107}\u{1174}\u{11BA}"),
    ("\u{BE3C}", "\u{BE3C}", "\u{1107}\u{1174}\u{11BB}", "\u{BE3C}", "\u{1107}\u{1174}\u{11BB}"),
    ("\u{BE3D}", "\u{BE3D}", "\u{1107}\u{1174}\u{11BC}", "\u{BE3D}", "\u{1107}\u{1174}\u{11BC}"),
    ("\u{BE3E}", "\u{BE3E}", "\u{1107}\u{1174}\u{11BD}", "\u{BE3E}", "\u{1107}\u{1174}\u{11BD}"),
    ("\u{BE3F}", "\u{BE3F}", "\u{1107}\u{1174}\u{11BE}", "\u{BE3F}", "\u{1107}\u{1174}\u{11BE}"),
    ("\u{BE40}", "\u{BE40}", "\u{1107}\u{1174}\u{11BF}", "\u{BE40}", "\u{1107}\u{1174}\u{11BF}"),
    ("\u{BE41}", "\u{BE41}", "\u{1107}\u{1174}\u{11C0}", "\u{BE41}", "\u{1107}\u{1174}\u{11C0}"),
    ("\u{BE42}", "\u{BE42}", "\u{1107}\u{1174}\u{11C1}", "\u{BE42}", "\u{1107}\u{1174}\u{11C1}"),
    ("\u{BE43}", "\u{BE43}", "\u{1107}\u{1174}\u{11C2}", "\u{BE43}", "\u{1107}\u{1174}\u{11C2}"),
    ("\u{BE44}", "\u{BE44}", "\u{1107}\u{1175}", "\u{BE44}", "\u{1107}\u{1175}"),
    ("\u{BE45}", "\u{BE45}", "\u{1107}\u{1175}\u{11A8}", "\u{BE45}", "\u{1107}\u{1175}\u{11A8}"),
    ("\u{BE46}", "\u{BE46}", "\u{1107}\u{1175}\u{11A9}", "\u{BE46}", "\u{1107}\u{1175}\u{11A9}"),
    ("\u{BE47}", "\u{BE47}", "\u{1107}\u{1175}\u{11AA}", "\u{BE47}", "\u{1107}\u{1175}\u{11AA}"),
    ("\u{BE48}", "\u{BE48}", "\u{1107}\u{1175}\u{11AB}", "\u{BE48}", "\u{1107}\u{1175}\u{11AB}"),
    ("\u{BE49}", "\u{BE49}", "\u{1107}\u{1175}\u{11AC}", "\u{BE49}", "\u{1107}\u{1175}\u{11AC}"),
    ("\u{BE4A}", "\u{BE4A}", "\u{1107}\u{1175}\u{11AD}", "\u{BE4A}", "\u{1107}\u{1175}\u{11AD}"),
    ("\u{BE4B}", "\u{BE4B}", "\u{1107}\u{1175}\u{11AE}", "\u{BE4B}", "\u{1107}\u{1175}\u{11AE}"),
    ("\u{BE4C}", "\u{BE4C}", "\u{1107}\u{1175}\u{11AF}", "\u{BE4C}", "\u{1107}\u{1175}\u{11AF}"),
    ("\u{BE4D}", "\u{BE4D}", "\u{1107}\u{1175}\u{11B0}", "\u{BE4D}", "\u{1107}\u{1175}\u{11B0}"),
    ("\u{BE4E}", "\u{BE4E}", "\u{1107}\u{1175}\u{11B1}", "\u{BE4E}", "\u{1107}\u{1175}\u{11B1}"),
    ("\u{BE4F}", "\u{BE4F}", "\u{1107}\u{1175}\u{11B2}", "\u{BE4F}", "\u{1107}\u{1175}\u{11B2}"),
    ("\u{BE50}", "\u{BE50}", "\u{1107}\u{1175}\u{11B3}", "\u{BE50}", "\u{1107}\u{1175}\u{11B3}"),
    ("\u{BE51}", "\u{BE51}", "\u{1107}\u{1175}\u{11B4}", "\u{BE51}", "\u{1107}\u{1175}\u{11B4}"),
    ("\u{BE52}", "\u{BE52}", "\u{1107}\u{1175}\u{11B5}", "\u{BE52}", "\u{1107}\u{1175}\u{11B5}"),
    ("\u{BE53}", "\u{BE53}", "\u{1107}\u{1175}\u{11B6}", "\u{BE53}", "\u{1107}\u{1175}\u{11B6}"),
    ("\u{BE54}", "\u{BE54}", "\u{1107}\u{1175}\u{11B7}", "\u{BE54}", "\u{1107}\u{1175}\u{11B7}"),
    ("\u{BE55}", "\u{BE55}", "\u{1107}\u{1175}\u{11B8}", "\u{BE55}", "\u{1107}\u{1175}\u{11B8}"),
    ("\u{BE56}", "\u{BE56}", "\u{1107}\u{1175}\u{11B9}", "\u{BE56}", "\u{1107}\u{1175}\u{11B9}"),
    ("\u{BE57}", "\u{BE57}", "\u{1107}\u{1175}\u{11BA}", "\u{BE57}", "\u{1107}\u{1175}\u{11BA}"),
    ("\u{BE58}", "\u{BE58}", "\u{1107}\u{1175}\u{11BB}", "\u{BE58}", "\u{1107}\u{1175}\u{11BB}"),
    ("\u{BE59}", "\u{BE59}", "\u{1107}\u{1175}\u{11BC}", "\u{BE59}", "\u{1107}\u{1175}\u{11BC}"),
    ("\u{BE5A}", "\u{BE5A}", "\u{1107}\u{1175}\u{11BD}", "\u{BE5A}", "\u{1107}\u{1175}\u{11BD}"),
    ("\u{BE5B}", "\u{BE5B}", "\u{1107}\u{1175}\u{11BE}", "\u{BE5B}", "\u{1107}\u{1175}\u{11BE}"),
    ("\u{BE5C}", "\u{BE5C}", "\u{1107}\u{1175}\u{11BF}", "\u{BE5C}", "\u{1107}\u{1175}\u{11BF}"),
    ("\u{BE5D}", "\u{BE5D}", "\u{1107}\u{1175}\u{11C0}", "\u{BE5D}", "\u{1107}\u{1175}\u{11C0}"),
    ("\u{BE5E}", "\u{BE5E}", "\u{1107}\u{1175}\u{11C1}", "\u{BE5E}", "\u{1107}\u{1175}\u{11C1}"),
    ("\u{BE5F}", "\u{BE5F}", "\u{1107}\u{1175}\u{11C2}", "\u{BE5F}", "\u{1107}\u{1175}\u{11C2}"),
    ("\u{BE60}", "\u{BE60}", "\u{1108}\u{1161}", "\u{BE60}", "\u{1108}\u{1161}"),
    ("\u{BE61}", "\u{BE61}", "\u{1108}\u{1161}\u{11A8}", "\u{BE61}", "\u{1108}\u{1161}\u{11A8}"),
    ("\u{BE62}", "\u{BE62}", "\u{1108}\u{1161}\u{11A9}", "\u{BE62}", "\u{1108}\u{1161}\u{11A9}"),
    ("\u{BE63}", "\u{BE63}", "\u{1108}\u{1161}\u{11AA}", "\u{BE63}", "\u{1108}\u{1161}\u{11AA}"),
    ("\u{BE64}", "\u{BE64}", "\u{1108}\u{1161}\u{11AB}", "\u{BE64}", "\u{1108}\u{1161}\u{11AB}"),
    ("\u{BE65}", "\u{BE65}", "\u{1108}\u{1161}\u{11AC}", "\u{BE65}", "\u{1108}\u{1161}\u{11AC}"),
    ("\u{BE66}", "\u{BE66}", "\u{1108}\u{1161}\u{11AD}", "\u{BE66}", "\u{1108}\u{1161}\u{11AD}"),
    ("\u{BE67}", "\u{BE67}", "\u{1108}\u{1161}\u{11AE}", "\u{BE67}", "\u{1108}\u{1161}\u{11AE}"),
    ("\u{BE68}", "\u{BE68}", "\u{1108}\u{1161}\u{11AF}", "\u{BE68}", "\u{1108}\u{1161}\u{11AF}"),
    ("\u{BE69}", "\u{BE69}", "\u{1108}\u{1161}\u{11B0}", "\u{BE69}", "\u{1108}\u{1161}\u{11B0}"),
    ("\u{BE6A}", "\u{BE6A}", "\u{1108}\u{1161}\u{11B1}", "\u{BE6A}", "\u{1108}\u{1161}\u{11B1}"),
    ("\u{BE6B}", "\u{BE6B}", "\u{1108}\u{1161}\u{11B2}", "\u{BE6B}", "\u{1108}\u{1161}\u{11B2}"),
    ("\u{BE6C}", "\u{BE6C}", "\u{1108}\u{1161}\u{11B3}", "\u{BE6C}", "\u{1108}\u{1161}\u{11B3}"),
    ("\u{BE6D}", "\u{BE6D}", "\u{1108}\u{1161}\u{11B4}", "\u{BE6D}", "\u{1108}\u{1161}\u{11B4}"),
    ("\u{BE6E}", "\u{BE6E}", "\u{1108}\u{1161}\u{11B5}", "\u{BE6E}", "\u{1108}\u{1161}\u{11B5}"),
    ("\u{BE6F}", "\u{BE6F}", "\u{1108}\u{1161}\u{11B6}", "\u{BE6F}", "\u{1108}\u{1161}\u{11B6}"),
    ("\u{BE70}", "\u{BE70}", "\u{1108}\u{1161}\u{11B7}", "\u{BE70}", "\u{1108}\u{1161}\u{11B7}"),
    ("\u{BE71}", "\u{BE71}", "\u{1108}\u{1161}\u{11B8}", "\u{BE71}", "\u{1108}\u{1161}\u{11B8}"),
    ("\u{BE72}", "\u{BE72}", "\u{1108}\u{1161}\u{11B9}", "\u{BE72}", "\u{1108}\u{1161}\u{11B9}"),
    ("\u{BE73}", "\u{BE73}", "\u{1108}\u{1161}\u{11BA}", "\u{BE73}", "\u{1108}\u{1161}\u{11BA}"),
    ("\u{BE74}", "\u{BE74}", "\u{1108}\u{1161}\u{11BB}", "\u{BE74}", "\u{1108}\u{1161}\u{11BB}"),
    ("\u{BE75}", "\u{BE75}", "\u{1108}\u{1161}\u{11BC}", "\u{BE75}", "\u{1108}\u{1161}\u{11BC}"),
    ("\u{BE76}", "\u{BE76}", "\u{1108}\u{1161}\u{11BD}", "\u{BE76}", "\u{1108}\u{1161}\u{11BD}"),
    ("\u{BE77}", "\u{BE77}", "\u{1108}\u{1161}\u{11BE}", "\u{BE77}", "\u{1108}\u{1161}\u{11BE}"),
    ("\u{BE78}", "\u{BE78}", "\u{1108}\u{1161}\u{11BF}", "\u{BE78}", "\u{1108}\u{1161}\u{11BF}"),
    ("\u{BE79}", "\u{BE79}", "\u{1108}\u{1161}\u{11C0}", "\u{BE79}", "\u{1108}\u{1161}\u{11C0}"),
    ("\u{BE7A}", "\u{BE7A}", "\u{1108}\u{1161}\u{11C1}", "\u{BE7A}", "\u{1108}\u{1161}\u{11C1}"),
    ("\u{BE7B}", "\u{BE7B}", "\u{1108}\u{1161}\u{11C2}", "\u{BE7B}", "\u{1108}\u{1161}\u{11C2}"),
    ("\u{BE7C}", "\u{BE7C}", "\u{1108}\u{1162}", "\u{BE7C}", "\u{1108}\u{1162}"),
    ("\u{BE7D}", "\u{BE7D}", "\u{1108}\u{1162}\u{11A8}", "\u{BE7D}", "\u{1108}\u{1162}\u{11A8}"),
    ("\u{BE7E}", "\u{BE7E}", "\u{1108}\u{1162}\u{11A9}", "\u{BE7E}", "\u{1108}\u{1162}\u{11A9}"),
    ("\u{BE7F}", "\u{BE7F}", "\u{1108}\u{1162}\u{11AA}", "\u{BE7F}", "\u{1108}\u{1162}\u{11AA}"),
    ("\u{BE80}", "\u{BE80}", "\u{1108}\u{1162}\u{11AB}", "\u{BE80}", "\u{1108}\u{1162}\u{11AB}"),
    ("\u{BE81}", "\u{BE81}", "\u{1108}\u{1162}\u{11AC}", "\u{BE81}", "\u{1108}\u{1162}\u{11AC}"),
    ("\u{BE82}", "\u{BE82}", "\u{1108}\u{1162}\u{11AD}", "\u{BE82}", "\u{1108}\u{1162}\u{11AD}"),
    ("\u{BE83}", "\u{BE83}", "\u{1108}\u{1162}\u{11AE}", "\u{BE83}", "\u{1108}\u{1162}\u{11AE}"),
    ("\u{BE84}", "\u{BE84}", "\u{1108}\u{1162}\u{11AF}", "\u{BE84}", "\u{1108}\u{1162}\u{11AF}"),
    ("\u{BE85}", "\u{BE85}", "\u{1108}\u{1162}\u{11B0}", "\u{BE85}", "\u{1108}\u{1162}\u{11B0}"),
    ("\u{BE86}", "\u{BE86}", "\u{1108}\u{1162}\u{11B1}", "\u{BE86}", "\u{1108}\u{1162}\u{11B1}"),
    ("\u{BE87}", "\u{BE87}", "\u{1108}\u{1162}\u{11B2}", "\u{BE87}", "\u{1108}\u{1162}\u{11B2}"),
    ("\u{BE88}", "\u{BE88}", "\u{1108}\u{1162}\u{11B3}", "\u{BE88}", "\u{1108}\u{1162}\u{11B3}"),
    ("\u{BE89}", "\u{BE89}", "\u{1108}\u{1162}\u{11B4}", "\u{BE89}", "\u{1108}\u{1162}\u{11B4}"),
    ("\u{BE8A}", "\u{BE8A}", "\u{1108}\u{1162}\u{11B5}", "\u{BE8A}", "\u{1108}\u{1162}\u{11B5}"),
    ("\u{BE8B}", "\u{BE8B}", "\u{1108}\u{1162}\u{11B6}", "\u{BE8B}", "\u{1108}\u{1162}\u{11B6}"),
    ("\u{BE8C}", "\u{BE8C}", "\u{1108}\u{1162}\u{11B7}", "\u{BE8C}", "\u{1108}\u{1162}\u{11B7}"),
    ("\u{BE8D}", "\u{BE8D}", "\u{1108}\u{1162}\u{11B8}", "\u{BE8D}", "\u{1108}\u{1162}\u{11B8}"),
    ("\u{BE8E}", "\u{BE8E}", "\u{1108}\u{1162}\u{11B9}", "\u{BE8E}", "\u{1108}\u{1162}\u{11B9}"),
    ("\u{BE8F}", "\u{BE8F}", "\u{1108}\u{1162}\u{11BA}", "\u{BE8F}", "\u{1108}\u{1162}\u{11BA}"),
    ("\u{BE90}", "\u{BE90}", "\u{1108}\u{1162}\u{11BB}", "\u{BE90}", "\u{1108}\u{1162}\u{11BB}"),
    ("\u{BE91}", "\u{BE91}", "\u{1108}\u{1162}\u{11BC}", "\u{BE91}", "\u{1108}\u{1162}\u{11BC}"),
    ("\u{BE92}", "\u{BE92}", "\u{1108}\u{1162}\u{11BD}", "\u{BE92}", "\u{1108}\u{1162}\u{11BD}"),
    ("\u{BE93}", "\u{BE93}", "\u{1108}\u{1162}\u{11BE}", "\u{BE93}", "\u{1108}\u{1162}\u{11BE}"),
    ("\u{BE94}", "\u{BE94}", "\u{1108}\u{1162}\u{11BF}", "\u{BE94}", "\u{1108}\u{1162}\u{11BF}"),
    ("\u{BE95}", "\u{BE95}", "\u{1108}\u{1162}\u{11C0}", "\u{BE95}", "\u{1108}\u{1162}\u{11C0}"),
    ("\u{BE96}", "\u{BE96}", "\u{1108}\u{1162}\u{11C1}", "\u{BE96}", "\u{1108}\u{1162}\u{11C1}"),
    ("\u{BE97}", "\u{BE97}", "\u{1108}\u{1162}\u{11C2}", "\u{BE97}", "\u{1108}\u{1162}\u{11C2}"),
    ("\u{BE98}", "\u{BE98}", "\u{1108}\u{1163}", "\u{BE98}", "\u{1108}\u{1163}"),
    ("\u{BE99}", "\u{BE99}", "\u{1108}\u{1163}\u{11A8}", "\u{BE99}", "\u{1108}\u{1163}\u{11A8}"),
    ("\u{BE9A}", "\u{BE9A}", "\u{1108}\u{1163}\u{11A9}", "\u{BE9A}", "\u{1108}\u{1163}\u{11A9}"),
    ("\u{BE9B}", "\u{BE9B}", "\u{1108}\u{1163}\u{11AA}", "\u{BE9B}", "\u{1108}\u{1163}\u{11AA}"),
    ("\u{BE9C}", "\u{BE9C}", "\u{1108}\u{1163}\u{11AB}", "\u{BE9C}", "\u{1108}\u{1163}\u{11AB}"),
    ("\u{BE9D}", "\u{BE9D}", "\u{1108}\u{1163}\u{11AC}", "\u{BE9D}", "\u{1108}\u{1163}\u{11AC}"),
    ("\u{BE9E}", "\u{BE9E}", "\u{1108}\u{1163}\u{11AD}", "\u{BE9E}", "\u{1108}\u{1163}\u{11AD}"),
    ("\u{BE9F}", "\u{BE9F}", "\u{1108}\u{1163}\u{11AE}", "\u{BE9F}", "\u{1108}\u{1163}\u{11AE}"),
    ("\u{BEA0}", "\u{BEA0}", "\u{1108}\u{1163}\u{11AF}", "\u{BEA0}", "\u{1108}\u{1163}\u{11AF}"),
    ("\u{BEA1}", "\u{BEA1}", "\u{1108}\u{1163}\u{11B0}", "\u{BEA1}", "\u{1108}\u{1163}\u{11B0}"),
    ("\u{BEA2}", "\u{BEA2}", "\u{1108}\u{1163}\u{11B1}", "\u{BEA2}", "\u{1108}\u{1163}\u{11B1}"),
    ("\u{BEA3}", "\u{BEA3}", "\u{1108}\u{1163}\u{11B2}", "\u{BEA3}", "\u{1108}\u{1163}\u{11B2}"),
    ("\u{BEA4}", "\u{BEA4}", "\u{1108}\u{1163}\u{11B3}", "\u{BEA4}", "\u{1108}\u{1163}\u{11B3}"),
    ("\u{BEA5}", "\u{BEA5}", "\u{1108}\u{1163}\u{11B4}", "\u{BEA5}", "\u{1108}\u{1163}\u{11B4}"),
    ("\u{BEA6}", "\u{BEA6}", "\u{1108}\u{1163}\u{11B5}", "\u{BEA6}", "\u{1108}\u{1163}\u{11B5}"),
    ("\u{BEA7}", "\u{BEA7}", "\u{1108}\u{1163}\u{11B6}", "\u{BEA7}", "\u{1108}\u{1163}\u{11B6}"),
    ("\u{BEA8}", "\u{BEA8}", "\u{1108}\u{1163}\u{11B7}", "\u{BEA8}", "\u{1108}\u{1163}\u{11B7}"),
    ("\u{BEA9}", "\u{BEA9}", "\u{1108}\u{1163}\u{11B8}", "\u{BEA9}", "\u{1108}\u{1163}\u{11B8}"),
    ("\u{BEAA}", "\u{BEAA}", "\u{1108}\u{1163}\u{11B9}", "\u{BEAA}", "\u{1108}\u{1163}\u{11B9}"),
    ("\u{BEAB}", "\u{BEAB}", "\u{1108}\u{1163}\u{11BA}", "\u{BEAB}", "\u{1108}\u{1163}\u{11BA}"),
    ("\u{BEAC}", "\u{BEAC}", "\u{1108}\u{1163}\u{11BB}", "\u{BEAC}", "\u{1108}\u{1163}\u{11BB}"),
    ("\u{BEAD}", "\u{BEAD}", "\u{1108}\u{1163}\u{11BC}", "\u{BEAD}", "\u{1108}\u{1163}\u{11BC}"),
    ("\u{BEAE}", "\u{BEAE}", "\u{1108}\u{1163}\u{11BD}", "\u{BEAE}", "\u{1108}\u{1163}\u{11BD}"),
    ("\u{BEAF}", "\u{BEAF}", "\u{1108}\u{1163}\u{11BE}", "\u{BEAF}", "\u{1108}\u{1163}\u{11BE}"),
    ("\u{BEB0}", "\u{BEB0}", "\u{1108}\u{1163}\u{11BF}", "\u{BEB0}", "\u{1108}\u{1163}\u{11BF}"),
    ("\u{BEB1}", "\u{BEB1}", "\u{1108}\u{1163}\u{11C0}", "\u{BEB1}", "\u{1108}\u{1163}\u{11C0}"),
    ("\u{BEB2}", "\u{BEB2}", "\u{1108}\u{1163}\u{11C1}", "\u{BEB2}", "\u{1108}\u{1163}\u{11C1}"),
    ("\u{BEB3}", "\u{BEB3}", "\u{1108}\u{1163}\u{11C2}", "\u{BEB3}", "\u{1108}\u{1163}\u{11C2}"),
    ("\u{BEB4}", "\u{BEB4}", "\u{1108}\u{1164}", "\u{BEB4}", "\u{1108}\u{1164}"),
    ("\u{BEB5}", "\u{BEB5}", "\u{1108}\u{1164}\u{11A8}", "\u{BEB5}", "\u{1108}\u{1164}\u{11A8}"),
    ("\u{BEB6}", "\u{BEB6}", "\u{1108}\u{1164}\u{11A9}", "\u{BEB6}", "\u{1108}\u{1164}\u{11A9}"),
    ("\u{BEB7}", "\u{BEB7}", "\u{1108}\u{1164}\u{11AA}", "\u{BEB7}", "\u{1108}\u{1164}\u{11AA}"),
    ("\u{BEB8}", "\u{BEB8}", "\u{1108}\u{1164}\u{11AB}", "\u{BEB8}", "\u{1108}\u{1164}\u{11AB}"),
    ("\u{BEB9}", "\u{BEB9}", "\u{1108}\u{1164}\u{11AC}", "\u{BEB9}", "\u{1108}\u{1164}\u{11AC}"),
    ("\u{BEBA}", "\u{BEBA}", "\u{1108}\u{1164}\u{11AD}", "\u{BEBA}", "\u{1108}\u{1164}\u{11AD}"),
    ("\u{BEBB}", "\u{BEBB}", "\u{1108}\u{1164}\u{11AE}", "\u{BEBB}", "\u{1108}\u{1164}\u{11AE}"),
    ("\u{BEBC}", "\u{BEBC}", "\u{1108}\u{1164}\u{11AF}", "\u{BEBC}", "\u{1108}\u{1164}\u{11AF}"),
    ("\u{BEBD}", "\u{BEBD}", "\u{1108}\u{1164}\u{11B0}", "\u{BEBD}", "\u{1108}\u{1164}\u{11B0}"),
    ("\u{BEBE}", "\u{BEBE}", "\u{1108}\u{1164}\u{11B1}", "\u{BEBE}", "\u{1108}\u{1164}\u{11B1}"),
    ("\u{BEBF}", "\u{BEBF}", "\u{1108}\u{1164}\u{11B2}", "\u{BEBF}", "\u{1108}\u{1164}\u{11B2}"),
    ("\u{BEC0}", "\u{BEC0}", "\u{1108}\u{1164}\u{11B3}", "\u{BEC0}", "\u{1108}\u{1164}\u{11B3}"),
    ("\u{BEC1}", "\u{BEC1}", "\u{1108}\u{1164}\u{11B4}", "\u{BEC1}", "\u{1108}\u{1164}\u{11B4}"),
    ("\u{BEC2}", "\u{BEC2}", "\u{1108}\u{1164}\u{11B5}", "\u{BEC2}", "\u{1108}\u{1164}\u{11B5}"),
    ("\u{BEC3}", "\u{BEC3}", "\u{1108}\u{1164}\u{11B6}", "\u{BEC3}", "\u{1108}\u{1164}\u{11B6}"),
    ("\u{BEC4}", "\u{BEC4}", "\u{1108}\u{1164}\u{11B7}", "\u{BEC4}", "\u{1108}\u{1164}\u{11B7}"),
    ("\u{BEC5}", "\u{BEC5}", "\u{1108}\u{1164}\u{11B8}", "\u{BEC5}", "\u{1108}\u{1164}\u{11B8}"),
    ("\u{BEC6}", "\u{BEC6}", "\u{1108}\u{1164}\u{11B9}", "\u{BEC6}", "\u{1108}\u{1164}\u{11B9}"),
    ("\u{BEC7}", "\u{BEC7}", "\u{1108}\u{1164}\u{11BA}", "\u{BEC7}", "\u{1108}\u{1164}\u{11BA}"),
    ("\u{BEC8}", "\u{BEC8}", "\u{1108}\u{1164}\u{11BB}", "\u{BEC8}", "\u{1108}\u{1164}\u{11BB}"),
    ("\u{BEC9}", "\u{BEC9}", "\u{1108}\u{1164}\u{11BC}", "\u{BEC9}", "\u{1108}\u{1164}\u{11BC}"),
    ("\u{BECA}", "\u{BECA}", "\u{1108}\u{1164}\u{11BD}", "\u{BECA}", "\u{1108}\u{1164}\u{11BD}"),
    ("\u{BECB}", "\u{BECB}", "\u{1108}\u{1164}\u{11BE}", "\u{BECB}", "\u{1108}\u{1164}\u{11BE}"),
    ("\u{BECC}", "\u{BECC}", "\u{1108}\u{1164}\u{11BF}", "\u{BECC}", "\u{1108}\u{1164}\u{11BF}"),
    ("\u{BECD}", "\u{BECD}", "\u{1108}\u{1164}\u{11C0}", "\u{BECD}", "\u{1108}\u{1164}\u{11C0}"),
    ("\u{BECE}", "\u{BECE}", "\u{1108}\u{1164}\u{11C1}", "\u{BECE}", "\u{1108}\u{1164}\u{11C1}"),
    ("\u{BECF}", "\u{BECF}", "\u{1108}\u{1164}\u{11C2}", "\u{BECF}", "\u{1108}\u{1164}\u{11C2}"),
    ("\u{BED0}", "\u{BED0}", "\u{1108}\u{1165}", "\u{BED0}", "\u{1108}\u{1165}"),
    ("\u{BED1}", "\u{BED1}", "\u{1108}\u{1165}\u{11A8}", "\u{BED1}", "\u{1108}\u{1165}\u{11A8}"),
    ("\u{BED2}", "\u{BED2}", "\u{1108}\u{1165}\u{11A9}", "\u{BED2}", "\u{1108}\u{1165}\u{11A9}"),
    ("\u{BED3}", "\u{BED3}", "\u{1108}\u{1165}\u{11AA}", "\u{BED3}", "\u{1108}\u{1165}\u{11AA}"),
    ("\u{BED4}", "\u{BED4}", "\u{1108}\u{1165}\u{11AB}", "\u{BED4}", "\u{1108}\u{1165}\u{11AB}"),
    ("\u{BED5}", "\u{BED5}", "\u{1108}\u{1165}\u{11AC}", "\u{BED5}", "\u{1108}\u{1165}\u{11AC}"),
    ("\u{BED6}", "\u{BED6}", "\u{1108}\u{1165}\u{11AD}", "\u{BED6}", "\u{1108}\u{1165}\u{11AD}"),
    ("\u{BED7}", "\u{BED7}", "\u{1108}\u{1165}\u{11AE}", "\u{BED7}", "\u{1108}\u{1165}\u{11AE}"),
    ("\u{BED8}", "\u{BED8}", "\u{1108}\u{1165}\u{11AF}", "\u{BED8}", "\u{1108}\u{1165}\u{11AF}"),
    ("\u{BED9}", "\u{BED9}", "\u{1108}\u{1165}\u{11B0}", "\u{BED9}", "\u{1108}\u{1165}\u{11B0}"),
    ("\u{BEDA}", "\u{BEDA}", "\u{1108}\u{1165}\u{11B1}", "\u{BEDA}", "\u{1108}\u{1165}\u{11B1}"),
    ("\u{BEDB}", "\u{BEDB}", "\u{1108}\u{1165}\u{11B2}", "\u{BEDB}", "\u{1108}\u{1165}\u{11B2}"),
    ("\u{BEDC}", "\u{BEDC}", "\u{1108}\u{1165}\u{11B3}", "\u{BEDC}", "\u{1108}\u{1165}\u{11B3}"),
    ("\u{BEDD}", "\u{BEDD}", "\u{1108}\u{1165}\u{11B4}", "\u{BEDD}", "\u{1108}\u{1165}\u{11B4}"),
    ("\u{BEDE}", "\u{BEDE}", "\u{1108}\u{1165}\u{11B5}", "\u{BEDE}", "\u{1108}\u{1165}\u{11B5}"),
    ("\u{BEDF}", "\u{BEDF}", "\u{1108}\u{1165}\u{11B6}", "\u{BEDF}", "\u{1108}\u{1165}\u{11B6}"),
    ("\u{BEE0}", "\u{BEE0}", "\u{1108}\u{1165}\u{11B7}", "\u{BEE0}", "\u{1108}\u{1165}\u{11B7}"),
    ("\u{BEE1}", "\u{BEE1}", "\u{1108}\u{1165}\u{11B8}", "\u{BEE1}", "\u{1108}\u{1165}\u{11B8}"),
    ("\u{BEE2}", "\u{BEE2}", "\u{1108}\u{1165}\u{11B9}", "\u{BEE2}", "\u{1108}\u{1165}\u{11B9}"),
    ("\u{BEE3}", "\u{BEE3}", "\u{1108}\u{1165}\u{11BA}", "\u{BEE3}", "\u{1108}\u{1165}\u{11BA}"),
    ("\u{BEE4}", "\u{BEE4}", "\u{1108}\u{1165}\u{11BB}", "\u{BEE4}", "\u{1108}\u{1165}\u{11BB}"),
    ("\u{BEE5}", "\u{BEE5}", "\u{1108}\u{1165}\u{11BC}", "\u{BEE5}", "\u{1108}\u{1165}\u{11BC}"),
    ("\u{BEE6}", "\u{BEE6}", "\u{1108}\u{1165}\u{11BD}", "\u{BEE6}", "\u{1108}\u{1165}\u{11BD}"),
    ("\u{BEE7}", "\u{BEE7}", "\u{1108}\u{1165}\u{11BE}", "\u{BEE7}", "\u{1108}\u{1165}\u{11BE}"),
    ("\u{BEE8}", "\u{BEE8}", "\u{1108}\u{1165}\u{11BF}", "\u{BEE8}", "\u{1108}\u{1165}\u{11BF}"),
    ("\u{BEE9}", "\u{BEE9}", "\u{1108}\u{1165}\u{11C0}", "\u{BEE9}", "\u{1108}\u{1165}\u{11C0}"),
    ("\u{BEEA}", "\u{BEEA}", "\u{1108}\u{1165}\u{11C1}", "\u{BEEA}", "\u{1108}\u{1165}\u{11C1}"),
    ("\u{BEEB}", "\u{BEEB}", "\u{1108}\u{1165}\u{11C2}", "\u{BEEB}", "\u{1108}\u{1165}\u{11C2}"),
    ("\u{BEEC}", "\u{BEEC}", "\u{1108}\u{1166}", "\u{BEEC}", "\u{1108}\u{1166}"),
    ("\u{BEED}", "\u{BEED}", "\u{1108}\u{1166}\u{11A8}", "\u{BEED}", "\u{1108}\u{1166}\u{11A8}"),
    ("\u{BEEE}", "\u{BEEE}", "\u{1108}\u{1166}\u{11A9}", "\u{BEEE}", "\u{1108}\u{1166}\u{11A9}"),
    ("\u{BEEF}", "\u{BEEF}", "\u{1108}\u{1166}\u{11AA}", "\u{BEEF}", "\u{1108}\u{1166}\u{11AA}"),
    ("\u{BEF0}", "\u{BEF0}", "\u{1108}\u{1166}\u{11AB}", "\u{BEF0}", "\u{1108}\u{1166}\u{11AB}"),
    ("\u{BEF1}", "\u{BEF1}", "\u{1108}\u{1166}\u{11AC}", "\u{BEF1}", "\u{1108}\u{1166}\u{11AC}"),
    ("\u{BEF2}", "\u{BEF2}", "\u{1108}\u{1166}\u{11AD}", "\u{BEF2}", "\u{1108}\u{1166}\u{11AD}"),
    ("\u{BEF3}", "\u{BEF3}", "\u{1108}\u{1166}\u{11AE}", "\u{BEF3}", "\u{1108}\u{1166}\u{11AE}"),
    ("\u{BEF4}", "\u{BEF4}", "\u{1108}\u{1166}\u{11AF}", "\u{BEF4}", "\u{1108}\u{1166}\u{11AF}"),
    ("\u{BEF5}", "\u{BEF5}", "\u{1108}\u{1166}\u{11B0}", "\u{BEF5}", "\u{1108}\u{1166}\u{11B0}"),
    ("\u{BEF6}", "\u{BEF6}", "\u{1108}\u{1166}\u{11B1}", "\u{BEF6}", "\u{1108}\u{1166}\u{11B1}"),
    ("\u{BEF7}", "\u{BEF7}", "\u{1108}\u{1166}\u{11B2}", "\u{BEF7}", "\u{1108}\u{1166}\u{11B2}"),
    ("\u{BEF8}", "\u{BEF8}", "\u{1108}\u{1166}\u{11B3}", "\u{BEF8}", "\u{1108}\u{1166}\u{11B3}"),
    ("\u{BEF9}", "\u{BEF9}", "\u{1108}\u{1166}\u{11B4}", "\u{BEF9}", "\u{1108}\u{1166}\u{11B4}"),
    ("\u{BEFA}", "\u{BEFA}", "\u{1108}\u{1166}\u{11B5}", "\u{BEFA}", "\u{1108}\u{1166}\u{11B5}"),
    ("\u{BEFB}", "\u{BEFB}", "\u{1108}\u{1166}\u{11B6}", "\u{BEFB}", "\u{1108}\u{1166}\u{11B6}"),
    ("\u{BEFC}", "\u{BEFC}", "\u{1108}\u{1166}\u{11B7}", "\u{BEFC}", "\u{1108}\u{1166}\u{11B7}"),
    ("\u{BEFD}", "\u{BEFD}", "\u{1108}\u{1166}\u{11B8}", "\u{BEFD}", "\u{1108}\u{1166}\u{11B8}"),
    ("\u{BEFE}", "\u{BEFE}", "\u{1108}\u{1166}\u{11B9}", "\u{BEFE}", "\u{1108}\u{1166}\u{11B9}"),
    ("\u{BEFF}", "\u{BEFF}", "\u{1108}\u{1166}\u{11BA}", "\u{BEFF}", "\u{1108}\u{1166}\u{11BA}"),
    ("\u{BF00}", "\u{BF00}", "\u{1108}\u{1166}\u{11BB}", "\u{BF00}", "\u{1108}\u{1166}\u{11BB}"),
    ("\u{BF01}", "\u{BF01}", "\u{1108}\u{1166}\u{11BC}", "\u{BF01}", "\u{1108}\u{1166}\u{11BC}"),
    ("\u{BF02}", "\u{BF02}", "\u{1108}\u{1166}\u{11BD}", "\u{BF02}", "\u{1108}\u{1166}\u{11BD}"),
    ("\u{BF03}", "\u{BF03}", "\u{1108}\u{1166}\u{11BE}", "\u{BF03}", "\u{1108}\u{1166}\u{11BE}"),
    ("\u{BF04}", "\u{BF04}", "\u{1108}\u{1166}\u{11BF}", "\u{BF04}", "\u{1108}\u{1166}\u{11BF}"),
    ("\u{BF05}", "\u{BF05}", "\u{1108}\u{1166}\u{11C0}", "\u{BF05}", "\u{1108}\u{1166}\u{11C0}"),
    ("\u{BF06}", "\u{BF06}", "\u{1108}\u{1166}\u{11C1}", "\u{BF06}", "\u{1108}\u{1166}\u{11C1}"),
    ("\u{BF07}", "\u{BF07}", "\u{1108}\u{1166}\u{11C2}", "\u{BF07}", "\u{1108}\u{1166}\u{11C2}"),
    ("\u{BF08}", "\u{BF08}", "\u{1108}\u{1167}", "\u{BF08}", "\u{1108}\u{1167}"),
    ("\u{BF09}", "\u{BF09}", "\u{1108}\u{1167}\u{11A8}", "\u{BF09}", "\u{1108}\u{1167}\u{11A8}"),
    ("\u{BF0A}", "\u{BF0A}", "\u{1108}\u{1167}\u{11A9}", "\u{BF0A}", "\u{1108}\u{1167}\u{11A9}"),
    ("\u{BF0B}", "\u{BF0B}", "\u{1108}\u{1167}\u{11AA}", "\u{BF0B}", "\u{1108}\u{1167}\u{11AA}"),
    ("\u{BF0C}", "\u{BF0C}", "\u{1108}\u{1167}\u{11AB}", "\u{BF0C}", "\u{1108}\u{1167}\u{11AB}"),
    ("\u{BF0D}", "\u{BF0D}", "\u{1108}\u{1167}\u{11AC}", "\u{BF0D}", "\u{1108}\u{1167}\u{11AC}"),
    ("\u{BF0E}", "\u{BF0E}", "\u{1108}\u{1167}\u{11AD}", "\u{BF0E}", "\u{1108}\u{1167}\u{11AD}"),
    ("\u{BF0F}", "\u{BF0F}", "\u{1108}\u{1167}\u{11AE}", "\u{BF0F}", "\u{1108}\u{1167}\u{11AE}"),
    ("\u{BF10}", "\u{BF10}", "\u{1108}\u{1167}\u{11AF}", "\u{BF10}", "\u{1108}\u{1167}\u{11AF}"),
    ("\u{BF11}", "\u{BF11}", "\u{1108}\u{1167}\u{11B0}", "\u{BF11}", "\u{1108}\u{1167}\u{11B0}"),
    ("\u{BF12}", "\u{BF12}", "\u{1108}\u{1167}\u{11B1}", "\u{BF12}", "\u{1108}\u{1167}\u{11B1}"),
    ("\u{BF13}", "\u{BF13}", "\u{1108}\u{1167}\u{11B2}", "\u{BF13}", "\u{1108}\u{1167}\u{11B2}"),
    ("\u{BF14}", "\u{BF14}", "\u{1108}\u{1167}\u{11B3}", "\u{BF14}", "\u{1108}\u{1167}\u{11B3}"),
    ("\u{BF15}", "\u{BF15}", "\u{1108}\u{1167}\u{11B4}", "\u{BF15}", "\u{1108}\u{1167}\u{11B4}"),
    ("\u{BF16}", "\u{BF16}", "\u{1108}\u{1167}\u{11B5}", "\u{BF16}", "\u{1108}\u{1167}\u{11B5}"),
    ("\u{BF17}", "\u{BF17}", "\u{1108}\u{1167}\u{11B6}", "\u{BF17}", "\u{1108}\u{1167}\u{11B6}"),
    ("\u{BF18}", "\u{BF18}", "\u{1108}\u{1167}\u{11B7}", "\u{BF18}", "\u{1108}\u{1167}\u{11B7}"),
    ("\u{BF19}", "\u{BF19}", "\u{1108}\u{1167}\u{11B8}", "\u{BF19}", "\u{1108}\u{1167}\u{11B8}"),
    ("\u{BF1A}", "\u{BF1A}", "\u{1108}\u{1167}\u{11B9}", "\u{BF1A}", "\u{1108}\u{1167}\u{11B9}"),
    ("\u{BF1B}", "\u{BF1B}", "\u{1108}\u{1167}\u{11BA}", "\u{BF1B}", "\u{1108}\u{1167}\u{11BA}"),
    ("\u{BF1C}", "\u{BF1C}", "\u{1108}\u{1167}\u{11BB}", "\u{BF1C}", "\u{1108}\u{1167}\u{11BB}"),
    ("\u{BF1D}", "\u{BF1D}", "\u{1108}\u{1167}\u{11BC}", "\u{BF1D}", "\u{1108}\u{1167}\u{11BC}"),
    ("\u{BF1E}", "\u{BF1E}", "\u{1108}\u{1167}\u{11BD}", "\u{BF1E}", "\u{1108}\u{1167}\u{11BD}"),
    ("\u{BF1F}", "\u{BF1F}", "\u{1108}\u{1167}\u{11BE}", "\u{BF1F}", "\u{1108}\u{1167}\u{11BE}"),
    ("\u{BF20}", "\u{BF20}", "\u{1108}\u{1167}\u{11BF}", "\u{BF20}", "\u{1108}\u{1167}\u{11BF}"),
    ("\u{BF21}", "\u{BF21}", "\u{1108}\u{1167}\u{11C0}", "\u{BF21}", "\u{1108}\u{1167}\u{11C0}"),
    ("\u{BF22}", "\u{BF22}", "\u{1108}\u{1167}\u{11C1}", "\u{BF22}", "\u{1108}\u{1167}\u{11C1}"),
    ("\u{BF23}", "\u{BF23}", "\u{1108}\u{1167}\u{11C2}", "\u{BF23}", "\u{1108}\u{1167}\u{11C2}"),
    ("\u{BF24}", "\u{BF24}", "\u{1108}\u{1168}", "\u{BF24}", "\u{1108}\u{1168}"),
    ("\u{BF25}", "\u{BF25}", "\u{1108}\u{1168}\u{11A8}", "\u{BF25}", "\u{1108}\u{1168}\u{11A8}"),
    ("\u{BF26}", "\u{BF26}", "\u{1108}\u{1168}\u{11A9}", "\u{BF26}", "\u{1108}\u{1168}\u{11A9}"),
    ("\u{BF27}", "\u{BF27}", "\u{1108}\u{1168}\u{11AA}", "\u{BF27}", "\u{1108}\u{1168}\u{11AA}"),
    ("\u{BF28}", "\u{BF28}", "\u{1108}\u{1168}\u{11AB}", "\u{BF28}", "\u{1108}\u{1168}\u{11AB}"),
    ("\u{BF29}", "\u{BF29}", "\u{1108}\u{1168}\u{11AC}", "\u{BF29}", "\u{1108}\u{1168}\u{11AC}"),
    ("\u{BF2A}", "\u{BF2A}", "\u{1108}\u{1168}\u{11AD}", "\u{BF2A}", "\u{1108}\u{1168}\u{11AD}"),
    ("\u{BF2B}", "\u{BF2B}", "\u{1108}\u{1168}\u{11AE}", "\u{BF2B}", "\u{1108}\u{1168}\u{11AE}"),
    ("\u{BF2C}", "\u{BF2C}", "\u{1108}\u{1168}\u{11AF}", "\u{BF2C}", "\u{1108}\u{1168}\u{11AF}"),
    ("\u{BF2D}", "\u{BF2D}", "\u{1108}\u{1168}\u{11B0}", "\u{BF2D}", "\u{1108}\u{1168}\u{11B0}"),
    ("\u{BF2E}", "\u{BF2E}", "\u{1108}\u{1168}\u{11B1}", "\u{BF2E}", "\u{1108}\u{1168}\u{11B1}"),
    ("\u{BF2F}", "\u{BF2F}", "\u{1108}\u{1168}\u{11B2}", "\u{BF2F}", "\u{1108}\u{1168}\u{11B2}"),
    ("\u{BF30}", "\u{BF30}", "\u{1108}\u{1168}\u{11B3}", "\u{BF30}", "\u{1108}\u{1168}\u{11B3}"),
    ("\u{BF31}", "\u{BF31}", "\u{1108}\u{1168}\u{11B4}", "\u{BF31}", "\u{1108}\u{1168}\u{11B4}"),
    ("\u{BF32}", "\u{BF32}", "\u{1108}\u{1168}\u{11B5}", "\u{BF32}", "\u{1108}\u{1168}\u{11B5}"),
    ("\u{BF33}", "\u{BF33}", "\u{1108}\u{1168}\u{11B6}", "\u{BF33}", "\u{1108}\u{1168}\u{11B6}"),
    ("\u{BF34}", "\u{BF34}", "\u{1108}\u{1168}\u{11B7}", "\u{BF34}", "\u{1108}\u{1168}\u{11B7}"),
    ("\u{BF35}", "\u{BF35}", "\u{1108}\u{1168}\u{11B8}", "\u{BF35}", "\u{1108}\u{1168}\u{11B8}"),
    ("\u{BF36}", "\u{BF36}", "\u{1108}\u{1168}\u{11B9}", "\u{BF36}", "\u{1108}\u{1168}\u{11B9}"),
    ("\u{BF37}", "\u{BF37}", "\u{1108}\u{1168}\u{11BA}", "\u{BF37}", "\u{1108}\u{1168}\u{11BA}"),
    ("\u{BF38}", "\u{BF38}", "\u{1108}\u{1168}\u{11BB}", "\u{BF38}", "\u{1108}\u{1168}\u{11BB}"),
    ("\u{BF39}", "\u{BF39}", "\u{1108}\u{1168}\u{11BC}", "\u{BF39}", "\u{1108}\u{1168}\u{11BC}"),
    ("\u{BF3A}", "\u{BF3A}", "\u{1108}\u{1168}\u{11BD}", "\u{BF3A}", "\u{1108}\u{1168}\u{11BD}"),
    ("\u{BF3B}", "\u{BF3B}", "\u{1108}\u{1168}\u{11BE}", "\u{BF3B}", "\u{1108}\u{1168}\u{11BE}"),
    ("\u{BF3C}", "\u{BF3C}", "\u{1108}\u{1168}\u{11BF}", "\u{BF3C}", "\u{1108}\u{1168}\u{11BF}"),
    ("\u{BF3D}", "\u{BF3D}", "\u{1108}\u{1168}\u{11C0}", "\u{BF3D}", "\u{1108}\u{1168}\u{11C0}"),
    ("\u{BF3E}", "\u{BF3E}", "\u{1108}\u{1168}\u{11C1}", "\u{BF3E}", "\u{1108}\u{1168}\u{11C1}"),
    ("\u{BF3F}", "\u{BF3F}", "\u{1108}\u{1168}\u{11C2}", "\u{BF3F}", "\u{1108}\u{1168}\u{11C2}"),
    ("\u{BF40}", "\u{BF40}", "\u{1108}\u{1169}", "\u{BF40}", "\u{1108}\u{1169}"),
    ("\u{BF41}", "\u{BF41}", "\u{1108}\u{1169}\u{11A8}", "\u{BF41}", "\u{1108}\u{1169}\u{11A8}"),
    ("\u{BF42}", "\u{BF42}", "\u{1108}\u{1169}\u{11A9}", "\u{BF42}", "\u{1108}\u{1169}\u{11A9}"),
    ("\u{BF43}", "\u{BF43}", "\u{1108}\u{1169}\u{11AA}", "\u{BF43}", "\u{1108}\u{1169}\u{11AA}"),
    ("\u{BF44}", "\u{BF44}", "\u{1108}\u{1169}\u{11AB}", "\u{BF44}", "\u{1108}\u{1169}\u{11AB}"),
    ("\u{BF45}", "\u{BF45}", "\u{1108}\u{1169}\u{11AC}", "\u{BF45}", "\u{1108}\u{1169}\u{11AC}"),
    ("\u{BF46}", "\u{BF46}", "\u{1108}\u{1169}\u{11AD}", "\u{BF46}", "\u{1108}\u{1169}\u{11AD}"),
    ("\u{BF47}", "\u{BF47}", "\u{1108}\u{1169}\u{11AE}", "\u{BF47}", "\u{1108}\u{1169}\u{11AE}"),
    ("\u{BF48}", "\u{BF48}", "\u{1108}\u{1169}\u{11AF}", "\u{BF48}", "\u{1108}\u{1169}\u{11AF}"),
    ("\u{BF49}", "\u{BF49}", "\u{1108}\u{1169}\u{11B0}", "\u{BF49}", "\u{1108}\u{1169}\u{11B0}"),
    ("\u{BF4A}", "\u{BF4A}", "\u{1108}\u{1169}\u{11B1}", "\u{BF4A}", "\u{1108}\u{1169}\u{11B1}"),
    ("\u{BF4B}", "\u{BF4B}", "\u{1108}\u{1169}\u{11B2}", "\u{BF4B}", "\u{1108}\u{1169}\u{11B2}"),
    ("\u{BF4C}", "\u{BF4C}", "\u{1108}\u{1169}\u{11B3}", "\u{BF4C}", "\u{1108}\u{1169}\u{11B3}"),
    ("\u{BF4D}", "\u{BF4D}", "\u{1108}\u{1169}\u{11B4}", "\u{BF4D}", "\u{1108}\u{1169}\u{11B4}"),
    ("\u{BF4E}", "\u{BF4E}", "\u{1108}\u{1169}\u{11B5}", "\u{BF4E}", "\u{1108}\u{1169}\u{11B5}"),
    ("\u{BF4F}", "\u{BF4F}", "\u{1108}\u{1169}\u{11B6}", "\u{BF4F}", "\u{1108}\u{1169}\u{11B6}"),
    ("\u{BF50}", "\u{BF50}", "\u{1108}\u{1169}\u{11B7}", "\u{BF50}", "\u{1108}\u{1169}\u{11B7}"),
    ("\u{BF51}", "\u{BF51}", "\u{1108}\u{1169}\u{11B8}", "\u{BF51}", "\u{1108}\u{1169}\u{11B8}"),
    ("\u{BF52}", "\u{BF52}", "\u{1108}\u{1169}\u{11B9}", "\u{BF52}", "\u{1108}\u{1169}\u{11B9}"),
    ("\u{BF53}", "\u{BF53}", "\u{1108}\u{1169}\u{11BA}", "\u{BF53}", "\u{1108}\u{1169}\u{11BA}"),
    ("\u{BF54}", "\u{BF54}", "\u{1108}\u{1169}\u{11BB}", "\u{BF54}", "\u{1108}\u{1169}\u{11BB}"),
    ("\u{BF55}", "\u{BF55}", "\u{1108}\u{1169}\u{11BC}", "\u{BF55}", "\u{1108}\u{1169}\u{11BC}"),
    ("\u{BF56}", "\u{BF56}", "\u{1108}\u{1169}\u{11BD}", "\u{BF56}", "\u{1108}\u{1169}\u{11BD}"),
    ("\u{BF57}", "\u{BF57}", "\u{1108}\u{1169}\u{11BE}", "\u{BF57}", "\u{1108}\u{1169}\u{11BE}"),
    ("\u{BF58}", "\u{BF58}", "\u{1108}\u{1169}\u{11BF}", "\u{BF58}", "\u{1108}\u{1169}\u{11BF}"),
    ("\u{BF59}", "\u{BF59}", "\u{1108}\u{1169}\u{11C0}", "\u{BF59}", "\u{1108}\u{1169}\u{11C0}"),
    ("\u{BF5A}", "\u{BF5A}", "\u{1108}\u{1169}\u{11C1}", "\u{BF5A}", "\u{1108}\u{1169}\u{11C1}"),
    ("\u{BF5B}", "\u{BF5B}", "\u{1108}\u{1169}\u{11C2}", "\u{BF5B}", "\u{1108}\u{1169}\u{11C2}"),
    ("\u{BF5C}", "\u{BF5C}", "\u{1108}\u{116A}", "\u{BF5C}", "\u{1108}\u{116A}"),
    ("\u{BF5D}", "\u{BF5D}", "\u{1108}\u{116A}\u{11A8}", "\u{BF5D}", "\u{1108}\u{116A}\u{11A8}"),
    ("\u{BF5E}", "\u{BF5E}", "\u{1108}\u{116A}\u{11A9}", "\u{BF5E}", "\u{1108}\u{116A}\u{11A9}"),
    ("\u{BF5F}", "\u{BF5F}", "\u{1108}\u{116A}\u{11AA}", "\u{BF5F}", "\u{1108}\u{116A}\u{11AA}"),
    ("\u{BF60}", "\u{BF60}", "\u{1108}\u{116A}\u{11AB}", "\u{BF60}", "\u{1108}\u{116A}\u{11AB}"),
    ("\u{BF61}", "\u{BF61}", "\u{1108}\u{116A}\u{11AC}", "\u{BF61}", "\u{1108}\u{116A}\u{11AC}"),
    ("\u{BF62}", "\u{BF62}", "\u{1108}\u{116A}\u{11AD}", "\u{BF62}", "\u{1108}\u{116A}\u{11AD}"),
    ("\u{BF63}", "\u{BF63}", "\u{1108}\u{116A}\u{11AE}", "\u{BF63}", "\u{1108}\u{116A}\u{11AE}"),
    ("\u{BF64}", "\u{BF64}", "\u{1108}\u{116A}\u{11AF}", "\u{BF64}", "\u{1108}\u{116A}\u{11AF}"),
    ("\u{BF65}", "\u{BF65}", "\u{1108}\u{116A}\u{11B0}", "\u{BF65}", "\u{1108}\u{116A}\u{11B0}"),
    ("\u{BF66}", "\u{BF66}", "\u{1108}\u{116A}\u{11B1}", "\u{BF66}", "\u{1108}\u{116A}\u{11B1}"),
    ("\u{BF67}", "\u{BF67}", "\u{1108}\u{116A}\u{11B2}", "\u{BF67}", "\u{1108}\u{116A}\u{11B2}"),
    ("\u{BF68}", "\u{BF68}", "\u{1108}\u{116A}\u{11B3}", "\u{BF68}", "\u{1108}\u{116A}\u{11B3}"),
    ("\u{BF69}", "\u{BF69}", "\u{1108}\u{116A}\u{11B4}", "\u{BF69}", "\u{1108}\u{116A}\u{11B4}"),
    ("\u{BF6A}", "\u{BF6A}", "\u{1108}\u{116A}\u{11B5}", "\u{BF6A}", "\u{1108}\u{116A}\u{11B5}"),
    ("\u{BF6B}", "\u{BF6B}", "\u{1108}\u{116A}\u{11B6}", "\u{BF6B}", "\u{1108}\u{116A}\u{11B6}"),
    ("\u{BF6C}", "\u{BF6C}", "\u{1108}\u{116A}\u{11B7}", "\u{BF6C}", "\u{1108}\u{116A}\u{11B7}"),
    ("\u{BF6D}", "\u{BF6D}", "\u{1108}\u{116A}\u{11B8}", "\u{BF6D}", "\u{1108}\u{116A}\u{11B8}"),
    ("\u{BF6E}", "\u{BF6E}", "\u{1108}\u{116A}\u{11B9}", "\u{BF6E}", "\u{1108}\u{116A}\u{11B9}"),
    ("\u{BF6F}", "\u{BF6F}", "\u{1108}\u{116A}\u{11BA}", "\u{BF6F}", "\u{1108}\u{116A}\u{11BA}"),
    ("\u{BF70}", "\u{BF70}", "\u{1108}\u{116A}\u{11BB}", "\u{BF70}", "\u{1108}\u{116A}\u{11BB}"),
    ("\u{BF71}", "\u{BF71}", "\u{1108}\u{116A}\u{11BC}", "\u{BF71}", "\u{1108}\u{116A}\u{11BC}"),
    ("\u{BF72}", "\u{BF72}", "\u{1108}\u{116A}\u{11BD}", "\u{BF72}", "\u{1108}\u{116A}\u{11BD}"),
    ("\u{BF73}", "\u{BF73}", "\u{1108}\u{116A}\u{11BE}", "\u{BF73}", "\u{1108}\u{116A}\u{11BE}"),
    ("\u{BF74}", "\u{BF74}", "\u{1108}\u{116A}\u{11BF}", "\u{BF74}", "\u{1108}\u{116A}\u{11BF}"),
    ("\u{BF75}", "\u{BF75}", "\u{1108}\u{116A}\u{11C0}", "\u{BF75}", "\u{1108}\u{116A}\u{11C0}"),
    ("\u{BF76}", "\u{BF76}", "\u{1108}\u{116A}\u{11C1}", "\u{BF76}", "\u{1108}\u{116A}\u{11C1}"),
    ("\u{BF77}", "\u{BF77}", "\u{1108}\u{116A}\u{11C2}", "\u{BF77}", "\u{1108}\u{116A}\u{11C2}"),
    ("\u{BF78}", "\u{BF78}", "\u{1108}\u{116B}", "\u{BF78}", "\u{1108}\u{116B}"),
    ("\u{BF79}", "\u{BF79}", "\u{1108}\u{116B}\u{11A8}", "\u{BF79}", "\u{1108}\u{116B}\u{11A8}"),
    ("\u{BF7A}", "\u{BF7A}", "\u{1108}\u{116B}\u{11A9}", "\u{BF7A}", "\u{1108}\u{116B}\u{11A9}"),
    ("\u{BF7B}", "\u{BF7B}", "\u{1108}\u{116B}\u{11AA}", "\u{BF7B}", "\u{1108}\u{116B}\u{11AA}"),
    ("\u{BF7C}", "\u{BF7C}", "\u{1108}\u{116B}\u{11AB}", "\u{BF7C}", "\u{1108}\u{116B}\u{11AB}"),
    ("\u{BF7D}", "\u{BF7D}", "\u{1108}\u{116B}\u{11AC}", "\u{BF7D}", "\u{1108}\u{116B}\u{11AC}"),
    ("\u{BF7E}", "\u{BF7E}", "\u{1108}\u{116B}\u{11AD}", "\u{BF7E}", "\u{1108}\u{116B}\u{11AD}"),
    ("\u{BF7F}", "\u{BF7F}", "\u{1108}\u{116B}\u{11AE}", "\u{BF7F}", "\u{1108}\u{116B}\u{11AE}"),
    ("\u{BF80}", "\u{BF80}", "\u{1108}\u{116B}\u{11AF}", "\u{BF80}", "\u{1108}\u{116B}\u{11AF}"),
    ("\u{BF81}", "\u{BF81}", "\u{1108}\u{116B}\u{11B0}", "\u{BF81}", "\u{1108}\u{116B}\u{11B0}"),
    ("\u{BF82}", "\u{BF82}", "\u{1108}\u{116B}\u{11B1}", "\u{BF82}", "\u{1108}\u{116B}\u{11B1}"),
    ("\u{BF83}", "\u{BF83}", "\u{1108}\u{116B}\u{11B2}", "\u{BF83}", "\u{1108}\u{116B}\u{11B2}"),
    ("\u{BF84}", "\u{BF84}", "\u{1108}\u{116B}\u{11B3}", "\u{BF84}", "\u{1108}\u{116B}\u{11B3}"),
    ("\u{BF85}", "\u{BF85}", "\u{1108}\u{116B}\u{11B4}", "\u{BF85}", "\u{1108}\u{116B}\u{11B4}"),
    ("\u{BF86}", "\u{BF86}", "\u{1108}\u{116B}\u{11B5}", "\u{BF86}", "\u{1108}\u{116B}\u{11B5}"),
    ("\u{BF87}", "\u{BF87}", "\u{1108}\u{116B}\u{11B6}", "\u{BF87}", "\u{1108}\u{116B}\u{11B6}"),
    ("\u{BF88}", "\u{BF88}", "\u{1108}\u{116B}\u{11B7}", "\u{BF88}", "\u{1108}\u{116B}\u{11B7}"),
    ("\u{BF89}", "\u{BF89}", "\u{1108}\u{116B}\u{11B8}", "\u{BF89}", "\u{1108}\u{116B}\u{11B8}"),
    ("\u{BF8A}", "\u{BF8A}", "\u{1108}\u{116B}\u{11B9}", "\u{BF8A}", "\u{1108}\u{116B}\u{11B9}"),
    ("\u{BF8B}", "\u{BF8B}", "\u{1108}\u{116B}\u{11BA}", "\u{BF8B}", "\u{1108}\u{116B}\u{11BA}"),
    ("\u{BF8C}", "\u{BF8C}", "\u{1108}\u{116B}\u{11BB}", "\u{BF8C}", "\u{1108}\u{116B}\u{11BB}"),
    ("\u{BF8D}", "\u{BF8D}", "\u{1108}\u{116B}\u{11BC}", "\u{BF8D}", "\u{1108}\u{116B}\u{11BC}"),
    ("\u{BF8E}", "\u{BF8E}", "\u{1108}\u{116B}\u{11BD}", "\u{BF8E}", "\u{1108}\u{116B}\u{11BD}"),
    ("\u{BF8F}", "\u{BF8F}", "\u{1108}\u{116B}\u{11BE}", "\u{BF8F}", "\u{1108}\u{116B}\u{11BE}"),
    ("\u{BF90}", "\u{BF90}", "\u{1108}\u{116B}\u{11BF}", "\u{BF90}", "\u{1108}\u{116B}\u{11BF}"),
    ("\u{BF91}", "\u{BF91}", "\u{1108}\u{116B}\u{11C0}", "\u{BF91}", "\u{1108}\u{116B}\u{11C0}"),
    ("\u{BF92}", "\u{BF92}", "\u{1108}\u{116B}\u{11C1}", "\u{BF92}", "\u{1108}\u{116B}\u{11C1}"),
    ("\u{BF93}", "\u{BF93}", "\u{1108}\u{116B}\u{11C2}", "\u{BF93}", "\u{1108}\u{116B}\u{11C2}"),
    ("\u{BF94}", "\u{BF94}", "\u{1108}\u{116C}", "\u{BF94}", "\u{1108}\u{116C}"),
    ("\u{BF95}", "\u{BF95}", "\u{1108}\u{116C}\u{11A8}", "\u{BF95}", "\u{1108}\u{116C}\u{11A8}"),
    ("\u{BF96}", "\u{BF96}", "\u{1108}\u{116C}\u{11A9}", "\u{BF96}", "\u{1108}\u{116C}\u{11A9}"),
    ("\u{BF97}", "\u{BF97}", "\u{1108}\u{116C}\u{11AA}", "\u{BF97}", "\u{1108}\u{116C}\u{11AA}"),
    ("\u{BF98}", "\u{BF98}", "\u{1108}\u{116C}\u{11AB}", "\u{BF98}", "\u{1108}\u{116C}\u{11AB}"),
    ("\u{BF99}", "\u{BF99}", "\u{1108}\u{116C}\u{11AC}", "\u{BF99}", "\u{1108}\u{116C}\u{11AC}"),
    ("\u{BF9A}", "\u{BF9A}", "\u{1108}\u{116C}\u{11AD}", "\u{BF9A}", "\u{1108}\u{116C}\u{11AD}"),
    ("\u{BF9B}", "\u{BF9B}", "\u{1108}\u{116C}\u{11AE}", "\u{BF9B}", "\u{1108}\u{116C}\u{11AE}"),
    ("\u{BF9C}", "\u{BF9C}", "\u{1108}\u{116C}\u{11AF}", "\u{BF9C}", "\u{1108}\u{116C}\u{11AF}"),
    ("\u{BF9D}", "\u{BF9D}", "\u{1108}\u{116C}\u{11B0}", "\u{BF9D}", "\u{1108}\u{116C}\u{11B0}"),
    ("\u{BF9E}", "\u{BF9E}", "\u{1108}\u{116C}\u{11B1}", "\u{BF9E}", "\u{1108}\u{116C}\u{11B1}"),
    ("\u{BF9F}", "\u{BF9F}", "\u{1108}\u{116C}\u{11B2}", "\u{BF9F}", "\u{1108}\u{116C}\u{11B2}"),
    ("\u{BFA0}", "\u{BFA0}", "\u{1108}\u{116C}\u{11B3}", "\u{BFA0}", "\u{1108}\u{116C}\u{11B3}"),
    ("\u{BFA1}", "\u{BFA1}", "\u{1108}\u{116C}\u{11B4}", "\u{BFA1}", "\u{1108}\u{116C}\u{11B4}"),
    ("\u{BFA2}", "\u{BFA2}", "\u{1108}\u{116C}\u{11B5}", "\u{BFA2}", "\u{1108}\u{116C}\u{11B5}"),
    ("\u{BFA3}", "\u{BFA3}", "\u{1108}\u{116C}\u{11B6}", "\u{BFA3}", "\u{1108}\u{116C}\u{11B6}"),
    ("\u{BFA4}", "\u{BFA4}", "\u{1108}\u{116C}\u{11B7}", "\u{BFA4}", "\u{1108}\u{116C}\u{11B7}"),
    ("\u{BFA5}", "\u{BFA5}", "\u{1108}\u{116C}\u{11B8}", "\u{BFA5}", "\u{1108}\u{116C}\u{11B8}"),
    ("\u{BFA6}", "\u{BFA6}", "\u{1108}\u{116C}\u{11B9}", "\u{BFA6}", "\u{1108}\u{116C}\u{11B9}"),
    ("\u{BFA7}", "\u{BFA7}", "\u{1108}\u{116C}\u{11BA}", "\u{BFA7}", "\u{1108}\u{116C}\u{11BA}"),
    ("\u{BFA8}", "\u{BFA8}", "\u{1108}\u{116C}\u{11BB}", "\u{BFA8}", "\u{1108}\u{116C}\u{11BB}"),
    ("\u{BFA9}", "\u{BFA9}", "\u{1108}\u{116C}\u{11BC}", "\u{BFA9}", "\u{1108}\u{116C}\u{11BC}"),
    ("\u{BFAA}", "\u{BFAA}", "\u{1108}\u{116C}\u{11BD}", "\u{BFAA}", "\u{1108}\u{116C}\u{11BD}"),
    ("\u{BFAB}", "\u{BFAB}", "\u{1108}\u{116C}\u{11BE}", "\u{BFAB}", "\u{1108}\u{116C}\u{11BE}"),
    ("\u{BFAC}", "\u{BFAC}", "\u{1108}\u{116C}\u{11BF}", "\u{BFAC}", "\u{1108}\u{116C}\u{11BF}"),
    ("\u{BFAD}", "\u{BFAD}", "\u{1108}\u{116C}\u{11C0}", "\u{BFAD}", "\u{1108}\u{116C}\u{11C0}"),
    ("\u{BFAE}", "\u{BFAE}", "\u{1108}\u{116C}\u{11C1}", "\u{BFAE}", "\u{1108}\u{116C}\u{11C1}"),
    ("\u{BFAF}", "\u{BFAF}", "\u{1108}\u{116C}\u{11C2}", "\u{BFAF}", "\u{1108}\u{116C}\u{11C2}"),
    ("\u{BFB0}", "\u{BFB0}", "\u{1108}\u{116D}", "\u{BFB0}", "\u{1108}\u{116D}"),
    ("\u{BFB1}", "\u{BFB1}", "\u{1108}\u{116D}\u{11A8}", "\u{BFB1}", "\u{1108}\u{116D}\u{11A8}"),
    ("\u{BFB2}", "\u{BFB2}", "\u{1108}\u{116D}\u{11A9}", "\u{BFB2}", "\u{1108}\u{116D}\u{11A9}"),
    ("\u{BFB3}", "\u{BFB3}", "\u{1108}\u{116D}\u{11AA}", "\u{BFB3}", "\u{1108}\u{116D}\u{11AA}"),
    ("\u{BFB4}", "\u{BFB4}", "\u{1108}\u{116D}\u{11AB}", "\u{BFB4}", "\u{1108}\u{116D}\u{11AB}"),
    ("\u{BFB5}", "\u{BFB5}", "\u{1108}\u{116D}\u{11AC}", "\u{BFB5}", "\u{1108}\u{116D}\u{11AC}"),
    ("\u{BFB6}", "\u{BFB6}", "\u{1108}\u{116D}\u{11AD}", "\u{BFB6}", "\u{1108}\u{116D}\u{11AD}"),
    ("\u{BFB7}", "\u{BFB7}", "\u{1108}\u{116D}\u{11AE}", "\u{BFB7}", "\u{1108}\u{116D}\u{11AE}"),
    ("\u{BFB8}", "\u{BFB8}", "\u{1108}\u{116D}\u{11AF}", "\u{BFB8}", "\u{1108}\u{116D}\u{11AF}"),
    ("\u{BFB9}", "\u{BFB9}", "\u{1108}\u{116D}\u{11B0}", "\u{BFB9}", "\u{1108}\u{116D}\u{11B0}"),
    ("\u{BFBA}", "\u{BFBA}", "\u{1108}\u{116D}\u{11B1}", "\u{BFBA}", "\u{1108}\u{116D}\u{11B1}"),
    ("\u{BFBB}", "\u{BFBB}", "\u{1108}\u{116D}\u{11B2}", "\u{BFBB}", "\u{1108}\u{116D}\u{11B2}"),
    ("\u{BFBC}", "\u{BFBC}", "\u{1108}\u{116D}\u{11B3}", "\u{BFBC}", "\u{1108}\u{116D}\u{11B3}"),
    ("\u{BFBD}", "\u{BFBD}", "\u{1108}\u{116D}\u{11B4}", "\u{BFBD}", "\u{1108}\u{116D}\u{11B4}"),
    ("\u{BFBE}", "\u{BFBE}", "\u{1108}\u{116D}\u{11B5}", "\u{BFBE}", "\u{1108}\u{116D}\u{11B5}"),
    ("\u{BFBF}", "\u{BFBF}", "\u{1108}\u{116D}\u{11B6}", "\u{BFBF}", "\u{1108}\u{116D}\u{11B6}"),
    ("\u{BFC0}", "\u{BFC0}", "\u{1108}\u{116D}\u{11B7}", "\u{BFC0}", "\u{1108}\u{116D}\u{11B7}"),
    ("\u{BFC1}", "\u{BFC1}", "\u{1108}\u{116D}\u{11B8}", "\u{BFC1}", "\u{1108}\u{116D}\u{11B8}"),
    ("\u{BFC2}", "\u{BFC2}", "\u{1108}\u{116D}\u{11B9}", "\u{BFC2}", "\u{1108}\u{116D}\u{11B9}"),
    ("\u{BFC3}", "\u{BFC3}", "\u{1108}\u{116D}\u{11BA}", "\u{BFC3}", "\u{1108}\u{116D}\u{11BA}"),
    ("\u{BFC4}", "\u{BFC4}", "\u{1108}\u{116D}\u{11BB}", "\u{BFC4}", "\u{1108}\u{116D}\u{11BB}"),
    ("\u{BFC5}", "\u{BFC5}", "\u{1108}\u{116D}\u{11BC}", "\u{BFC5}", "\u{1108}\u{116D}\u{11BC}"),
    ("\u{BFC6}", "\u{BFC6}", "\u{1108}\u{116D}\u{11BD}", "\u{BFC6}", "\u{1108}\u{116D}\u{11BD}"),
    ("\u{BFC7}", "\u{BFC7}", "\u{1108}\u{116D}\u{11BE}", "\u{BFC7}", "\u{1108}\u{116D}\u{11BE}"),
    ("\u{BFC8}", "\u{BFC8}", "\u{1108}\u{116D}\u{11BF}", "\u{BFC8}", "\u{1108}\u{116D}\u{11BF}"),
    ("\u{BFC9}", "\u{BFC9}", "\u{1108}\u{116D}\u{11C0}", "\u{BFC9}", "\u{1108}\u{116D}\u{11C0}"),
    ("\u{BFCA}", "\u{BFCA}", "\u{1108}\u{116D}\u{11C1}", "\u{BFCA}", "\u{1108}\u{116D}\u{11C1}"),
    ("\u{BFCB}", "\u{BFCB}", "\u{1108}\u{116D}\u{11C2}", "\u{BFCB}", "\u{1108}\u{116D}\u{11C2}"),
    ("\u{BFCC}", "\u{BFCC}", "\u{1108}\u{116E}", "\u{BFCC}", "\u{1108}\u{116E}"),
    ("\u{BFCD}", "\u{BFCD}", "\u{1108}\u{116E}\u{11A8}", "\u{BFCD}", "\u{1108}\u{116E}\u{11A8}"),
    ("\u{BFCE}", "\u{BFCE}", "\u{1108}\u{116E}\u{11A9}", "\u{BFCE}", "\u{1108}\u{116E}\u{11A9}"),
    ("\u{BFCF}", "\u{BFCF}", "\u{1108}\u{116E}\u{11AA}", "\u{BFCF}", "\u{1108}\u{116E}\u{11AA}"),
    ("\u{BFD0}", "\u{BFD0}", "\u{1108}\u{116E}\u{11AB}", "\u{BFD0}", "\u{1108}\u{116E}\u{11AB}"),
    ("\u{BFD1}", "\u{BFD1}", "\u{1108}\u{116E}\u{11AC}", "\u{BFD1}", "\u{1108}\u{116E}\u{11AC}"),
    ("\u{BFD2}", "\u{BFD2}", "\u{1108}\u{116E}\u{11AD}", "\u{BFD2}", "\u{1108}\u{116E}\u{11AD}"),
    ("\u{BFD3}", "\u{BFD3}", "\u{1108}\u{116E}\u{11AE}", "\u{BFD3}", "\u{1108}\u{116E}\u{11AE}"),
    ("\u{BFD4}", "\u{BFD4}", "\u{1108}\u{116E}\u{11AF}", "\u{BFD4}", "\u{1108}\u{116E}\u{11AF}"),
    ("\u{BFD5}", "\u{BFD5}", "\u{1108}\u{116E}\u{11B0}", "\u{BFD5}", "\u{1108}\u{116E}\u{11B0}"),
    ("\u{BFD6}", "\u{BFD6}", "\u{1108}\u{116E}\u{11B1}", "\u{BFD6}", "\u{1108}\u{116E}\u{11B1}"),
    ("\u{BFD7}", "\u{BFD7}", "\u{1108}\u{116E}\u{11B2}", "\u{BFD7}", "\u{1108}\u{116E}\u{11B2}"),
    ("\u{BFD8}", "\u{BFD8}", "\u{1108}\u{116E}\u{11B3}", "\u{BFD8}", "\u{1108}\u{116E}\u{11B3}"),
    ("\u{BFD9}", "\u{BFD9}", "\u{1108}\u{116E}\u{11B4}", "\u{BFD9}", "\u{1108}\u{116E}\u{11B4}"),
    ("\u{BFDA}", "\u{BFDA}", "\u{1108}\u{116E}\u{11B5}", "\u{BFDA}", "\u{1108}\u{116E}\u{11B5}"),
    ("\u{BFDB}", "\u{BFDB}", "\u{1108}\u{116E}\u{11B6}", "\u{BFDB}", "\u{1108}\u{116E}\u{11B6}"),
    ("\u{BFDC}", "\u{BFDC}", "\u{1108}\u{116E}\u{11B7}", "\u{BFDC}", "\u{1108}\u{116E}\u{11B7}"),
    ("\u{BFDD}", "\u{BFDD}", "\u{1108}\u{116E}\u{11B8}", "\u{BFDD}", "\u{1108}\u{116E}\u{11B8}"),
    ("\u{BFDE}", "\u{BFDE}", "\u{1108}\u{116E}\u{11B9}", "\u{BFDE}", "\u{1108}\u{116E}\u{11B9}"),
    ("\u{BFDF}", "\u{BFDF}", "\u{1108}\u{116E}\u{11BA}", "\u{BFDF}", "\u{1108}\u{116E}\u{11BA}"),
    ("\u{BFE0}", "\u{BFE0}", "\u{1108}\u{116E}\u{11BB}", "\u{BFE0}", "\u{1108}\u{116E}\u{11BB}"),
    ("\u{BFE1}", "\u{BFE1}", "\u{1108}\u{116E}\u{11BC}", "\u{BFE1}", "\u{1108}\u{116E}\u{11BC}"),
    ("\u{BFE2}", "\u{BFE2}", "\u{1108}\u{116E}\u{11BD}", "\u{BFE2}", "\u{1108}\u{116E}\u{11BD}"),
    ("\u{BFE3}", "\u{BFE3}", "\u{1108}\u{116E}\u{11BE}", "\u{BFE3}", "\u{1108}\u{116E}\u{11BE}"),
    ("\u{BFE4}", "\u{BFE4}", "\u{1108}\u{116E}\u{11BF}", "\u{BFE4}", "\u{1108}\u{116E}\u{11BF}"),
    ("\u{BFE5}", "\u{BFE5}", "\u{1108}\u{116E}\u{11C0}", "\u{BFE5}", "\u{1108}\u{116E}\u{11C0}"),
    ("\u{BFE6}", "\u{BFE6}", "\u{1108}\u{116E}\u{11C1}", "\u{BFE6}", "\u{1108}\u{116E}\u{11C1}"),
    ("\u{BFE7}", "\u{BFE7}", "\u{1108}\u{116E}\u{11C2}", "\u{BFE7}", "\u{1108}\u{116E}\u{11C2}"),
    ("\u{BFE8}", "\u{BFE8}", "\u{1108}\u{116F}", "\u{BFE8}", "\u{1108}\u{116F}"),
    ("\u{BFE9}", "\u{BFE9}", "\u{1108}\u{116F}\u{11A8}", "\u{BFE9}", "\u{1108}\u{116F}\u{11A8}"),
    ("\u{BFEA}", "\u{BFEA}", "\u{1108}\u{116F}\u{11A9}", "\u{BFEA}", "\u{1108}\u{116F}\u{11A9}"),
    ("\u{BFEB}", "\u{BFEB}", "\u{1108}\u{116F}\u{11AA}", "\u{BFEB}", "\u{1108}\u{116F}\u{11AA}"),
    ("\u{BFEC}", "\u{BFEC}", "\u{1108}\u{116F}\u{11AB}", "\u{BFEC}", "\u{1108}\u{116F}\u{11AB}"),
    ("\u{BFED}", "\u{BFED}", "\u{1108}\u{116F}\u{11AC}", "\u{BFED}", "\u{1108}\u{116F}\u{11AC}"),
    ("\u{BFEE}", "\u{BFEE}", "\u{1108}\u{116F}\u{11AD}", "\u{BFEE}", "\u{1108}\u{116F}\u{11AD}"),
    ("\u{BFEF}", "\u{BFEF}", "\u{1108}\u{116F}\u{11AE}", "\u{BFEF}", "\u{1108}\u{116F}\u{11AE}"),
    ("\u{BFF0}", "\u{BFF0}", "\u{1108}\u{116F}\u{11AF}", "\u{BFF0}", "\u{1108}\u{116F}\u{11AF}"),
    ("\u{BFF1}", "\u{BFF1}", "\u{1108}\u{116F}\u{11B0}", "\u{BFF1}", "\u{1108}\u{116F}\u{11B0}"),
    ("\u{BFF2}", "\u{BFF2}", "\u{1108}\u{116F}\u{11B1}", "\u{BFF2}", "\u{1108}\u{116F}\u{11B1}"),
    ("\u{BFF3}", "\u{BFF3}", "\u{1108}\u{116F}\u{11B2}", "\u{BFF3}", "\u{1108}\u{116F}\u{11B2}"),
    ("\u{BFF4}", "\u{BFF4}", "\u{1108}\u{116F}\u{11B3}", "\u{BFF4}", "\u{1108}\u{116F}\u{11B3}"),
    ("\u{BFF5}", "\u{BFF5}", "\u{1108}\u{116F}\u{11B4}", "\u{BFF5}", "\u{1108}\u{116F}\u{11B4}"),
    ("\u{BFF6}", "\u{BFF6}", "\u{1108}\u{116F}\u{11B5}", "\u{BFF6}", "\u{1108}\u{116F}\u{11B5}"),
    ("\u{BFF7}", "\u{BFF7}", "\u{1108}\u{116F}\u{11B6}", "\u{BFF7}", "\u{1108}\u{116F}\u{11B6}"),
    ("\u{BFF8}", "\u{BFF8}", "\u{1108}\u{116F}\u{11B7}", "\u{BFF8}", "\u{1108}\u{116F}\u{11B7}"),
    ("\u{BFF9}", "\u{BFF9}", "\u{1108}\u{116F}\u{11B8}", "\u{BFF9}", "\u{1108}\u{116F}\u{11B8}"),
    ("\u{BFFA}", "\u{BFFA}", "\u{1108}\u{116F}\u{11B9}", "\u{BFFA}", "\u{1108}\u{116F}\u{11B9}"),
    ("\u{BFFB}", "\u{BFFB}", "\u{1108}\u{116F}\u{11BA}", "\u{BFFB}", "\u{1108}\u{116F}\u{11BA}"),
    ("\u{BFFC}", "\u{BFFC}", "\u{1108}\u{116F}\u{11BB}", "\u{BFFC}", "\u{1108}\u{116F}\u{11BB}"),
    ("\u{BFFD}", "\u{BFFD}", "\u{1108}\u{116F}\u{11BC}", "\u{BFFD}", "\u{1108}\u{116F}\u{11BC}"),
    ("\u{BFFE}", "\u{BFFE}", "\u{1108}\u{116F}\u{11BD}", "\u{BFFE}", "\u{1108}\u{116F}\u{11BD}"),
    ("\u{BFFF}", "\u{BFFF}", "\u{1108}\u{116F}\u{11BE}", "\u{BFFF}", "\u{1108}\u{116F}\u{11BE}"),
    ("\u{C000}", "\u{C000}", "\u{1108}\u{116F}\u{11BF}", "\u{C000}", "\u{1108}\u{116F}\u{11BF}"),
    ("\u{C001}", "\u{C001}", "\u{1108}\u{116F}\u{11C0}", "\u{C001}", "\u{1108}\u{116F}\u{11C0}"),
    ("\u{C002}", "\u{C002}", "\u{1108}\u{116F}\u{11C1}", "\u{C002}", "\u{1108}\u{116F}\u{11C1}"),
    ("\u{C003}", "\u{C003}", "\u{1108}\u{116F}\u{11C2}", "\u{C003}", "\u{1108}\u{116F}\u{11C2}"),
    ("\u{C004}", "\u{C004}", "\u{1108}\u{1170}", "\u{C004}", "\u{1108}\u{1170}"),
    ("\u{C005}", "\u{C005}", "\u{1108}\u{1170}\u{11A8}", "\u{C005}", "\u{1108}\u{1170}\u{11A8}"),
    ("\u{C006}", "\u{C006}", "\u{1108}\u{1170}\u{11A9}", "\u{C006}", "\u{1108}\u{1170}\u{11A9}"),
    ("\u{C007}", "\u{C007}", "\u{1108}\u{1170}\u{11AA}", "\u{C007}", "\u{1108}\u{1170}\u{11AA}"),
    ("\u{C008}", "\u{C008}", "\u{1108}\u{1170}\u{11AB}", "\u{C008}", "\u{1108}\u{1170}\u{11AB}"),
    ("\u{C009}", "\u{C009}", "\u{1108}\u{1170}\u{11AC}", "\u{C009}", "\u{1108}\u{1170}\u{11AC}"),
    ("\u{C00A}", "\u{C00A}", "\u{1108}\u{1170}\u{11AD}", "\u{C00A}", "\u{1108}\u{1170}\u{11AD}"),
    ("\u{C00B}", "\u{C00B}", "\u{1108}\u{1170}\u{11AE}", "\u{C00B}", "\u{1108}\u{1170}\u{11AE}"),
    ("\u{C00C}", "\u{C00C}", "\u{1108}\u{1170}\u{11AF}", "\u{C00C}", "\u{1108}\u{1170}\u{11AF}"),
    ("\u{C00D}", "\u{C00D}", "\u{1108}\u{1170}\u{11B0}", "\u{C00D}", "\u{1108}\u{1170}\u{11B0}"),
    ("\u{C00E}", "\u{C00E}", "\u{1108}\u{1170}\u{11B1}", "\u{C00E}", "\u{1108}\u{1170}\u{11B1}"),
    ("\u{C00F}", "\u{C00F}", "\u{1108}\u{1170}\u{11B2}", "\u{C00F}", "\u{1108}\u{1170}\u{11B2}"),
    ("\u{C010}", "\u{C010}", "\u{1108}\u{1170}\u{11B3}", "\u{C010}", "\u{1108}\u{1170}\u{11B3}"),
    ("\u{C011}", "\u{C011}", "\u{1108}\u{1170}\u{11B4}", "\u{C011}", "\u{1108}\u{1170}\u{11B4}"),
    ("\u{C012}", "\u{C012}", "\u{1108}\u{1170}\u{11B5}", "\u{C012}", "\u{1108}\u{1170}\u{11B5}"),
    ("\u{C013}", "\u{C013}", "\u{1108}\u{1170}\u{11B6}", "\u{C013}", "\u{1108}\u{1170}\u{11B6}"),
    ("\u{C014}", "\u{C014}", "\u{1108}\u{1170}\u{11B7}", "\u{C014}", "\u{1108}\u{1170}\u{11B7}"),
    ("\u{C015}", "\u{C015}", "\u{1108}\u{1170}\u{11B8}", "\u{C015}", "\u{1108}\u{1170}\u{11B8}"),
    ("\u{C016}", "\u{C016}", "\u{1108}\u{1170}\u{11B9}", "\u{C016}", "\u{1108}\u{1170}\u{11B9}"),
    ("\u{C017}", "\u{C017}", "\u{1108}\u{1170}\u{11BA}", "\u{C017}", "\u{1108}\u{1170}\u{11BA}"),
    ("\u{C018}", "\u{C018}", "\u{1108}\u{1170}\u{11BB}", "\u{C018}", "\u{1108}\u{1170}\u{11BB}"),
    ("\u{C019}", "\u{C019}", "\u{1108}\u{1170}\u{11BC}", "\u{C019}", "\u{1108}\u{1170}\u{11BC}"),
    ("\u{C01A}", "\u{C01A}", "\u{1108}\u{1170}\u{11BD}", "\u{C01A}", "\u{1108}\u{1170}\u{11BD}"),
    ("\u{C01B}", "\u{C01B}", "\u{1108}\u{1170}\u{11BE}", "\u{C01B}", "\u{1108}\u{1170}\u{11BE}"),
    ("\u{C01C}", "\u{C01C}", "\u{1108}\u{1170}\u{11BF}", "\u{C01C}", "\u{1108}\u{1170}\u{11BF}"),
    ("\u{C01D}", "\u{C01D}", "\u{1108}\u{1170}\u{11C0}", "\u{C01D}", "\u{1108}\u{1170}\u{11C0}"),
    ("\u{C01E}", "\u{C01E}", "\u{1108}\u{1170}\u{11C1}", "\u{C01E}", "\u{1108}\u{1170}\u{11C1}"),
    ("\u{C01F}", "\u{C01F}", "\u{1108}\u{1170}\u{11C2}", "\u{C01F}", "\u{1108}\u{1170}\u{11C2}"),
    ("\u{C020}", "\u{C020}", "\u{1108}\u{1171}", "\u{C020}", "\u{1108}\u{1171}"),
    ("\u{C021}", "\u{C021}", "\u{1108}\u{1171}\u{11A8}", "\u{C021}", "\u{1108}\u{1171}\u{11A8}"),
    ("\u{C022}", "\u{C022}", "\u{1108}\u{1171}\u{11A9}", "\u{C022}", "\u{1108}\u{1171}\u{11A9}"),
    ("\u{C023}", "\u{C023}", "\u{1108}\u{1171}\u{11AA}", "\u{C023}", "\u{1108}\u{1171}\u{11AA}"),
    ("\u{C024}", "\u{C024}", "\u{1108}\u{1171}\u{11AB}", "\u{C024}", "\u{1108}\u{1171}\u{11AB}"),
    ("\u{C025}", "\u{C025}", "\u{1108}\u{1171}\u{11AC}", "\u{C025}", "\u{1108}\u{1171}\u{11AC}"),
    ("\u{C026}", "\u{C026}", "\u{1108}\u{1171}\u{11AD}", "\u{C026}", "\u{1108}\u{1171}\u{11AD}"),
    ("\u{C027}", "\u{C027}", "\u{1108}\u{1171}\u{11AE}", "\u{C027}", "\u{1108}\u{1171}\u{11AE}"),
    ("\u{C028}", "\u{C028}", "\u{1108}\u{1171}\u{11AF}", "\u{C028}", "\u{1108}\u{1171}\u{11AF}"),
    ("\u{C029}", "\u{C029}", "\u{1108}\u{1171}\u{11B0}", "\u{C029}", "\u{1108}\u{1171}\u{11B0}"),
    ("\u{C02A}", "\u{C02A}", "\u{1108}\u{1171}\u{11B1}", "\u{C02A}", "\u{1108}\u{1171}\u{11B1}"),
    ("\u{C02B}", "\u{C02B}", "\u{1108}\u{1171}\u{11B2}", "\u{C02B}", "\u{1108}\u{1171}\u{11B2}"),
    ("\u{C02C}", "\u{C02C}", "\u{1108}\u{1171}\u{11B3}", "\u{C02C}", "\u{1108}\u{1171}\u{11B3}"),
    ("\u{C02D}", "\u{C02D}", "\u{1108}\u{1171}\u{11B4}", "\u{C02D}", "\u{1108}\u{1171}\u{11B4}"),
    ("\u{C02E}", "\u{C02E}", "\u{1108}\u{1171}\u{11B5}", "\u{C02E}", "\u{1108}\u{1171}\u{11B5}"),
    ("\u{C02F}", "\u{C02F}", "\u{1108}\u{1171}\u{11B6}", "\u{C02F}", "\u{1108}\u{1171}\u{11B6}"),
    ("\u{C030}", "\u{C030}", "\u{1108}\u{1171}\u{11B7}", "\u{C030}", "\u{1108}\u{1171}\u{11B7}"),
    ("\u{C031}", "\u{C031}", "\u{1108}\u{1171}\u{11B8}", "\u{C031}", "\u{1108}\u{1171}\u{11B8}"),
    ("\u{C032}", "\u{C032}", "\u{1108}\u{1171}\u{11B9}", "\u{C032}", "\u{1108}\u{1171}\u{11B9}"),
    ("\u{C033}", "\u{C033}", "\u{1108}\u{1171}\u{11BA}", "\u{C033}", "\u{1108}\u{1171}\u{11BA}"),
    ("\u{C034}", "\u{C034}", "\u{1108}\u{1171}\u{11BB}", "\u{C034}", "\u{1108}\u{1171}\u{11BB}"),
    ("\u{C035}", "\u{C035}", "\u{1108}\u{1171}\u{11BC}", "\u{C035}", "\u{1108}\u{1171}\u{11BC}"),
    ("\u{C036}", "\u{C036}", "\u{1108}\u{1171}\u{11BD}", "\u{C036}", "\u{1108}\u{1171}\u{11BD}"),
    ("\u{C037}", "\u{C037}", "\u{1108}\u{1171}\u{11BE}", "\u{C037}", "\u{1108}\u{1171}\u{11BE}"),
    ("\u{C038}", "\u{C038}", "\u{1108}\u{1171}\u{11BF}", "\u{C038}", "\u{1108}\u{1171}\u{11BF}"),
    ("\u{C039}", "\u{C039}", "\u{1108}\u{1171}\u{11C0}", "\u{C039}", "\u{1108}\u{1171}\u{11C0}"),
    ("\u{C03A}", "\u{C03A}", "\u{1108}\u{1171}\u{11C1}", "\u{C03A}", "\u{1108}\u{1171}\u{11C1}"),
    ("\u{C03B}", "\u{C03B}", "\u{1108}\u{1171}\u{11C2}", "\u{C03B}", "\u{1108}\u{1171}\u{11C2}"),
    ("\u{C03C}", "\u{C03C}", "\u{1108}\u{1172}", "\u{C03C}", "\u{1108}\u{1172}"),
    ("\u{C03D}", "\u{C03D}", "\u{1108}\u{1172}\u{11A8}", "\u{C03D}", "\u{1108}\u{1172}\u{11A8}"),
    ("\u{C03E}", "\u{C03E}", "\u{1108}\u{1172}\u{11A9}", "\u{C03E}", "\u{1108}\u{1172}\u{11A9}"),
    ("\u{C03F}", "\u{C03F}", "\u{1108}\u{1172}\u{11AA}", "\u{C03F}", "\u{1108}\u{1172}\u{11AA}"),
    ("\u{C040}", "\u{C040}", "\u{1108}\u{1172}\u{11AB}", "\u{C040}", "\u{1108}\u{1172}\u{11AB}"),
    ("\u{C041}", "\u{C041}", "\u{1108}\u{1172}\u{11AC}", "\u{C041}", "\u{1108}\u{1172}\u{11AC}"),
    ("\u{C042}", "\u{C042}", "\u{1108}\u{1172}\u{11AD}", "\u{C042}", "\u{1108}\u{1172}\u{11AD}"),
    ("\u{C043}", "\u{C043}", "\u{1108}\u{1172}\u{11AE}", "\u{C043}", "\u{1108}\u{1172}\u{11AE}"),
    ("\u{C044}", "\u{C044}", "\u{1108}\u{1172}\u{11AF}", "\u{C044}", "\u{1108}\u{1172}\u{11AF}"),
    ("\u{C045}", "\u{C045}", "\u{1108}\u{1172}\u{11B0}", "\u{C045}", "\u{1108}\u{1172}\u{11B0}"),
    ("\u{C046}", "\u{C046}", "\u{1108}\u{1172}\u{11B1}", "\u{C046}", "\u{1108}\u{1172}\u{11B1}"),
    ("\u{C047}", "\u{C047}", "\u{1108}\u{1172}\u{11B2}", "\u{C047}", "\u{1108}\u{1172}\u{11B2}"),
    ("\u{C048}", "\u{C048}", "\u{1108}\u{1172}\u{11B3}", "\u{C048}", "\u{1108}\u{1172}\u{11B3}"),
    ("\u{C049}", "\u{C049}", "\u{1108}\u{1172}\u{11B4}", "\u{C049}", "\u{1108}\u{1172}\u{11B4}"),
    ("\u{C04A}", "\u{C04A}", "\u{1108}\u{1172}\u{11B5}", "\u{C04A}", "\u{1108}\u{1172}\u{11B5}"),
    ("\u{C04B}", "\u{C04B}", "\u{1108}\u{1172}\u{11B6}", "\u{C04B}", "\u{1108}\u{1172}\u{11B6}"),
    ("\u{C04C}", "\u{C04C}", "\u{1108}\u{1172}\u{11B7}", "\u{C04C}", "\u{1108}\u{1172}\u{11B7}"),
    ("\u{C04D}", "\u{C04D}", "\u{1108}\u{1172}\u{11B8}", "\u{C04D}", "\u{1108}\u{1172}\u{11B8}"),
    ("\u{C04E}", "\u{C04E}", "\u{1108}\u{1172}\u{11B9}", "\u{C04E}", "\u{1108}\u{1172}\u{11B9}"),
    ("\u{C04F}", "\u{C04F}", "\u{1108}\u{1172}\u{11BA}", "\u{C04F}", "\u{1108}\u{1172}\u{11BA}"),
    ("\u{C050}", "\u{C050}", "\u{1108}\u{1172}\u{11BB}", "\u{C050}", "\u{1108}\u{1172}\u{11BB}"),
    ("\u{C051}", "\u{C051}", "\u{1108}\u{1172}\u{11BC}", "\u{C051}", "\u{1108}\u{1172}\u{11BC}"),
    ("\u{C052}", "\u{C052}", "\u{1108}\u{1172}\u{11BD}", "\u{C052}", "\u{1108}\u{1172}\u{11BD}"),
    ("\u{C053}", "\u{C053}", "\u{1108}\u{1172}\u{11BE}", "\u{C053}", "\u{1108}\u{1172}\u{11BE}"),
    ("\u{C054}", "\u{C054}", "\u{1108}\u{1172}\u{11BF}", "\u{C054}", "\u{1108}\u{1172}\u{11BF}"),
    ("\u{C055}", "\u{C055}", "\u{1108}\u{1172}\u{11C0}", "\u{C055}", "\u{1108}\u{1172}\u{11C0}"),
    ("\u{C056}", "\u{C056}", "\u{1108}\u{1172}\u{11C1}", "\u{C056}", "\u{1108}\u{1172}\u{11C1}"),
    ("\u{C057}", "\u{C057}", "\u{1108}\u{1172}\u{11C2}", "\u{C057}", "\u{1108}\u{1172}\u{11C2}"),
    ("\u{C058}", "\u{C058}", "\u{1108}\u{1173}", "\u{C058}", "\u{1108}\u{1173}"),
    ("\u{C059}", "\u{C059}", "\u{1108}\u{1173}\u{11A8}", "\u{C059}", "\u{1108}\u{1173}\u{11A8}"),
    ("\u{C05A}", "\u{C05A}", "\u{1108}\u{1173}\u{11A9}", "\u{C05A}", "\u{1108}\u{1173}\u{11A9}"),
    ("\u{C05B}", "\u{C05B}", "\u{1108}\u{1173}\u{11AA}", "\u{C05B}", "\u{1108}\u{1173}\u{11AA}"),
    ("\u{C05C}", "\u{C05C}", "\u{1108}\u{1173}\u{11AB}", "\u{C05C}", "\u{1108}\u{1173}\u{11AB}"),
    ("\u{C05D}", "\u{C05D}", "\u{1108}\u{1173}\u{11AC}", "\u{C05D}", "\u{1108}\u{1173}\u{11AC}"),
    ("\u{C05E}", "\u{C05E}", "\u{1108}\u{1173}\u{11AD}", "\u{C05E}", "\u{1108}\u{1173}\u{11AD}"),
    ("\u{C05F}", "\u{C05F}", "\u{1108}\u{1173}\u{11AE}", "\u{C05F}", "\u{1108}\u{1173}\u{11AE}"),
    ("\u{C060}", "\u{C060}", "\u{1108}\u{1173}\u{11AF}", "\u{C060}", "\u{1108}\u{1173}\u{11AF}"),
    ("\u{C061}", "\u{C061}", "\u{1108}\u{1173}\u{11B0}", "\u{C061}", "\u{1108}\u{1173}\u{11B0}"),
    ("\u{C062}", "\u{C062}", "\u{1108}\u{1173}\u{11B1}", "\u{C062}", "\u{1108}\u{1173}\u{11B1}"),
    ("\u{C063}", "\u{C063}", "\u{1108}\u{1173}\u{11B2}", "\u{C063}", "\u{1108}\u{1173}\u{11B2}"),
    ("\u{C064}", "\u{C064}", "\u{1108}\u{1173}\u{11B3}", "\u{C064}", "\u{1108}\u{1173}\u{11B3}"),
    ("\u{C065}", "\u{C065}", "\u{1108}\u{1173}\u{11B4}", "\u{C065}", "\u{1108}\u{1173}\u{11B4}"),
    ("\u{C066}", "\u{C066}", "\u{1108}\u{1173}\u{11B5}", "\u{C066}", "\u{1108}\u{1173}\u{11B5}"),
    ("\u{C067}", "\u{C067}", "\u{1108}\u{1173}\u{11B6}", "\u{C067}", "\u{1108}\u{1173}\u{11B6}"),
    ("\u{C068}", "\u{C068}", "\u{1108}\u{1173}\u{11B7}", "\u{C068}", "\u{1108}\u{1173}\u{11B7}"),
    ("\u{C069}", "\u{C069}", "\u{1108}\u{1173}\u{11B8}", "\u{C069}", "\u{1108}\u{1173}\u{11B8}"),
    ("\u{C06A}", "\u{C06A}", "\u{1108}\u{1173}\u{11B9}", "\u{C06A}", "\u{1108}\u{1173}\u{11B9}"),
    ("\u{C06B}", "\u{C06B}", "\u{1108}\u{1173}\u{11BA}", "\u{C06B}", "\u{1108}\u{1173}\u{11BA}"),
    ("\u{C06C}", "\u{C06C}", "\u{1108}\u{1173}\u{11BB}", "\u{C06C}", "\u{1108}\u{1173}\u{11BB}"),
    ("\u{C06D}", "\u{C06D}", "\u{1108}\u{1173}\u{11BC}", "\u{C06D}", "\u{1108}\u{1173}\u{11BC}"),
    ("\u{C06E}", "\u{C06E}", "\u{1108}\u{1173}\u{11BD}", "\u{C06E}", "\u{1108}\u{1173}\u{11BD}"),
    ("\u{C06F}", "\u{C06F}", "\u{1108}\u{1173}\u{11BE}", "\u{C06F}", "\u{1108}\u{1173}\u{11BE}"),
    ("\u{C070}", "\u{C070}", "\u{1108}\u{1173}\u{11BF}", "\u{C070}", "\u{1108}\u{1173}\u{11BF}"),
    ("\u{C071}", "\u{C071}", "\u{1108}\u{1173}\u{11C0}", "\u{C071}", "\u{1108}\u{1173}\u{11C0}"),
    ("\u{C072}", "\u{C072}", "\u{1108}\u{1173}\u{11C1}", "\u{C072}", "\u{1108}\u{1173}\u{11C1}"),
    ("\u{C073}", "\u{C073}", "\u{1108}\u{1173}\u{11C2}", "\u{C073}", "\u{1108}\u{1173}\u{11C2}"),
    ("\u{C074}", "\u{C074}", "\u{1108}\u{1174}", "\u{C074}", "\u{1108}\u{1174}"),
    ("\u{C075}", "\u{C075}", "\u{1108}\u{1174}\u{11A8}", "\u{C075}", "\u{1108}\u{1174}\u{11A8}"),
    ("\u{C076}", "\u{C076}", "\u{1108}\u{1174}\u{11A9}", "\u{C076}", "\u{1108}\u{1174}\u{11A9}"),
    ("\u{C077}", "\u{C077}", "\u{1108}\u{1174}\u{11AA}", "\u{C077}", "\u{1108}\u{1174}\u{11AA}"),
    ("\u{C078}", "\u{C078}", "\u{1108}\u{1174}\u{11AB}", "\u{C078}", "\u{1108}\u{1174}\u{11AB}"),
    ("\u{C079}", "\u{C079}", "\u{1108}\u{1174}\u{11AC}", "\u{C079}", "\u{1108}\u{1174}\u{11AC}"),
    ("\u{C07A}", "\u{C07A}", "\u{1108}\u{1174}\u{11AD}", "\u{C07A}", "\u{1108}\u{1174}\u{11AD}"),
    ("\u{C07B}", "\u{C07B}", "\u{1108}\u{1174}\u{11AE}", "\u{C07B}", "\u{1108}\u{1174}\u{11AE}"),
    ("\u{C07C}", "\u{C07C}", "\u{1108}\u{1174}\u{11AF}", "\u{C07C}", "\u{1108}\u{1174}\u{11AF}"),
    ("\u{C07D}", "\u{C07D}", "\u{1108}\u{1174}\u{11B0}", "\u{C07D}", "\u{1108}\u{1174}\u{11B0}"),
    ("\u{C07E}", "\u{C07E}", "\u{1108}\u{1174}\u{11B1}", "\u{C07E}", "\u{1108}\u{1174}\u{11B1}"),
    ("\u{C07F}", "\u{C07F}", "\u{1108}\u{1174}\u{11B2}", "\u{C07F}", "\u{1108}\u{1174}\u{11B2}"),
    ("\u{C080}", "\u{C080}", "\u{1108}\u{1174}\u{11B3}", "\u{C080}", "\u{1108}\u{1174}\u{11B3}"),
    ("\u{C081}", "\u{C081}", "\u{1108}\u{1174}\u{11B4}", "\u{C081}", "\u{1108}\u{1174}\u{11B4}"),
    ("\u{C082}", "\u{C082}", "\u{1108}\u{1174}\u{11B5}", "\u{C082}", "\u{1108}\u{1174}\u{11B5}"),
    ("\u{C083}", "\u{C083}", "\u{1108}\u{1174}\u{11B6}", "\u{C083}", "\u{1108}\u{1174}\u{11B6}"),
    ("\u{C084}", "\u{C084}", "\u{1108}\u{1174}\u{11B7}", "\u{C084}", "\u{1108}\u{1174}\u{11B7}"),
    ("\u{C085}", "\u{C085}", "\u{1108}\u{1174}\u{11B8}", "\u{C085}", "\u{1108}\u{1174}\u{11B8}"),
    ("\u{C086}", "\u{C086}", "\u{1108}\u{1174}\u{11B9}", "\u{C086}", "\u{1108}\u{1174}\u{11B9}"),
    ("\u{C087}", "\u{C087}", "\u{1108}\u{1174}\u{11BA}", "\u{C087}", "\u{1108}\u{1174}\u{11BA}"),
    ("\u{C088}", "\u{C088}", "\u{1108}\u{1174}\u{11BB}", "\u{C088}", "\u{1108}\u{1174}\u{11BB}"),
    ("\u{C089}", "\u{C089}", "\u{1108}\u{1174}\u{11BC}", "\u{C089}", "\u{1108}\u{1174}\u{11BC}"),
    ("\u{C08A}", "\u{C08A}", "\u{1108}\u{1174}\u{11BD}", "\u{C08A}", "\u{1108}\u{1174}\u{11BD}"),
    ("\u{C08B}", "\u{C08B}", "\u{1108}\u{1174}\u{11BE}", "\u{C08B}", "\u{1108}\u{1174}\u{11BE}"),
    ("\u{C08C}", "\u{C08C}", "\u{1108}\u{1174}\u{11BF}", "\u{C08C}", "\u{1108}\u{1174}\u{11BF}"),
    ("\u{C08D}", "\u{C08D}", "\u{1108}\u{1174}\u{11C0}", "\u{C08D}", "\u{1108}\u{1174}\u{11C0}"),
    ("\u{C08E}", "\u{C08E}", "\u{1108}\u{1174}\u{11C1}", "\u{C08E}", "\u{1108}\u{1174}\u{11C1}"),
    ("\u{C08F}", "\u{C08F}", "\u{1108}\u{1174}\u{11C2}", "\u{C08F}", "\u{1108}\u{1174}\u{11C2}"),
    ("\u{C090}", "\u{C090}", "\u{1108}\u{1175}", "\u{C090}", "\u{1108}\u{1175}"),
    ("\u{C091}", "\u{C091}", "\u{1108}\u{1175}\u{11A8}", "\u{C091}", "\u{1108}\u{1175}\u{11A8}"),
    ("\u{C092}", "\u{C092}", "\u{1108}\u{1175}\u{11A9}", "\u{C092}", "\u{1108}\u{1175}\u{11A9}"),
    ("\u{C093}", "\u{C093}", "\u{1108}\u{1175}\u{11AA}", "\u{C093}", "\u{1108}\u{1175}\u{11AA}"),
    ("\u{C094}", "\u{C094}", "\u{1108}\u{1175}\u{11AB}", "\u{C094}", "\u{1108}\u{1175}\u{11AB}"),
    ("\u{C095}", "\u{C095}", "\u{1108}\u{1175}\u{11AC}", "\u{C095}", "\u{1108}\u{1175}\u{11AC}"),
    ("\u{C096}", "\u{C096}", "\u{1108}\u{1175}\u{11AD}", "\u{C096}", "\u{1108}\u{1175}\u{11AD}"),
    ("\u{C097}", "\u{C097}", "\u{1108}\u{1175}\u{11AE}", "\u{C097}", "\u{1108}\u{1175}\u{11AE}"),
    ("\u{C098}", "\u{C098}", "\u{1108}\u{1175}\u{11AF}", "\u{C098}", "\u{1108}\u{1175}\u{11AF}"),
    ("\u{C099}", "\u{C099}", "\u{1108}\u{1175}\u{11B0}", "\u{C099}", "\u{1108}\u{1175}\u{11B0}"),
    ("\u{C09A}", "\u{C09A}", "\u{1108}\u{1175}\u{11B1}", "\u{C09A}", "\u{1108}\u{1175}\u{11B1}"),
    ("\u{C09B}", "\u{C09B}", "\u{1108}\u{1175}\u{11B2}", "\u{C09B}", "\u{1108}\u{1175}\u{11B2}"),
    ("\u{C09C}", "\u{C09C}", "\u{1108}\u{1175}\u{11B3}", "\u{C09C}", "\u{1108}\u{1175}\u{11B3}"),
    ("\u{C09D}", "\u{C09D}", "\u{1108}\u{1175}\u{11B4}", "\u{C09D}", "\u{1108}\u{1175}\u{11B4}"),
    ("\u{C09E}", "\u{C09E}", "\u{1108}\u{1175}\u{11B5}", "\u{C09E}", "\u{1108}\u{1175}\u{11B5}"),
    ("\u{C09F}", "\u{C09F}", "\u{1108}\u{1175}\u{11B6}", "\u{C09F}", "\u{1108}\u{1175}\u{11B6}"),
    ("\u{C0A0}", "\u{C0A0}", "\u{1108}\u{1175}\u{11B7}", "\u{C0A0}", "\u{1108}\u{1175}\u{11B7}"),
    ("\u{C0A1}", "\u{C0A1}", "\u{1108}\u{1175}\u{11B8}", "\u{C0A1}", "\u{1108}\u{1175}\u{11B8}"),
    ("\u{C0A2}", "\u{C0A2}", "\u{1108}\u{1175}\u{11B9}", "\u{C0A2}", "\u{1108}\u{1175}\u{11B9}"),
    ("\u{C0A3}", "\u{C0A3}", "\u{1108}\u{1175}\u{11BA}", "\u{C0A3}", "\u{1108}\u{1175}\u{11BA}"),
    ("\u{C0A4}", "\u{C0A4}", "\u{1108}\u{1175}\u{11BB}", "\u{C0A4}", "\u{1108}\u{1175}\u{11BB}"),
    ("\u{C0A5}", "\u{C0A5}", "\u{1108}\u{1175}\u{11BC}", "\u{C0A5}", "\u{1108}\u{1175}\u{11BC}"),
    ("\u{C0A6}", "\u{C0A6}", "\u{1108}\u{1175}\u{11BD}", "\u{C0A6}", "\u{1108}\u{1175}\u{11BD}"),
    ("\u{C0A7}", "\u{C0A7}", "\u{1108}\u{1175}\u{11BE}", "\u{C0A7}", "\u{1108}\u{1175}\u{11BE}"),
    ("\u{C0A8}", "\u{C0A8}", "\u{1108}\u{1175}\u{11BF}", "\u{C0A8}", "\u{1108}\u{1175}\u{11BF}"),
    ("\u{C0A9}", "\u{C0A9}", "\u{1108}\u{1175}\u{11C0}", "\u{C0A9}", "\u{1108}\u{1175}\u{11C0}"),
    ("\u{C0AA}", "\u{C0AA}", "\u{1108}\u{1175}\u{11C1}", "\u{C0AA}", "\u{1108}\u{1175}\u{11C1}"),
    ("\u{C0AB}", "\u{C0AB}", "\u{1108}\u{1175}\u{11C2}", "\u{C0AB}", "\u{1108}\u{1175}\u{11C2}"),
    ("\u{C0AC}", "\u{C0AC}", "\u{1109}\u{1161}", "\u{C0AC}", "\u{1109}\u{1161}"),
    ("\u{C0AD}", "\u{C0AD}", "\u{1109}\u{1161}\u{11A8}", "\u{C0AD}", "\u{1109}\u{1161}\u{11A8}"),
    ("\u{C0AE}", "\u{C0AE}", "\u{1109}\u{1161}\u{11A9}", "\u{C0AE}", "\u{1109}\u{1161}\u{11A9}"),
    ("\u{C0AF}", "\u{C0AF}", "\u{1109}\u{1161}\u{11AA}", "\u{C0AF}", "\u{1109}\u{1161}\u{11AA}"),
    ("\u{C0B0}", "\u{C0B0}", "\u{1109}\u{1161}\u{11AB}", "\u{C0B0}", "\u{1109}\u{1161}\u{11AB}"),
    ("\u{C0B1}", "\u{C0B1}", "\u{1109}\u{1161}\u{11AC}", "\u{C0B1}", "\u{1109}\u{1161}\u{11AC}"),
    ("\u{C0B2}", "\u{C0B2}", "\u{1109}\u{1161}\u{11AD}", "\u{C0B2}", "\u{1109}\u{1161}\u{11AD}"),
    ("\u{C0B3}", "\u{C0B3}", "\u{1109}\u{1161}\u{11AE}", "\u{C0B3}", "\u{1109}\u{1161}\u{11AE}"),
    ("\u{C0B4}", "\u{C0B4}", "\u{1109}\u{1161}\u{11AF}", "\u{C0B4}", "\u{1109}\u{1161}\u{11AF}"),
    ("\u{C0B5}", "\u{C0B5}", "\u{1109}\u{1161}\u{11B0}", "\u{C0B5}", "\u{1109}\u{1161}\u{11B0}"),
    ("\u{C0B6}", "\u{C0B6}", "\u{1109}\u{1161}\u{11B1}", "\u{C0B6}", "\u{1109}\u{1161}\u{11B1}"),
    ("\u{C0B7}", "\u{C0B7}", "\u{1109}\u{1161}\u{11B2}", "\u{C0B7}", "\u{1109}\u{1161}\u{11B2}"),
    ("\u{C0B8}", "\u{C0B8}", "\u{1109}\u{1161}\u{11B3}", "\u{C0B8}", "\u{1109}\u{1161}\u{11B3}"),
    ("\u{C0B9}", "\u{C0B9}", "\u{1109}\u{1161}\u{11B4}", "\u{C0B9}", "\u{1109}\u{1161}\u{11B4}"),
    ("\u{C0BA}", "\u{C0BA}", "\u{1109}\u{1161}\u{11B5}", "\u{C0BA}", "\u{1109}\u{1161}\u{11B5}"),
    ("\u{C0BB}", "\u{C0BB}", "\u{1109}\u{1161}\u{11B6}", "\u{C0BB}", "\u{1109}\u{1161}\u{11B6}"),
    ("\u{C0BC}", "\u{C0BC}", "\u{1109}\u{1161}\u{11B7}", "\u{C0BC}", "\u{1109}\u{1161}\u{11B7}"),
    ("\u{C0BD}", "\u{C0BD}", "\u{1109}\u{1161}\u{11B8}", "\u{C0BD}", "\u{1109}\u{1161}\u{11B8}"),
    ("\u{C0BE}", "\u{C0BE}", "\u{1109}\u{1161}\u{11B9}", "\u{C0BE}", "\u{1109}\u{1161}\u{11B9}"),
    ("\u{C0BF}", "\u{C0BF}", "\u{1109}\u{1161}\u{11BA}", "\u{C0BF}", "\u{1109}\u{1161}\u{11BA}"),
    ("\u{C0C0}", "\u{C0C0}", "\u{1109}\u{1161}\u{11BB}", "\u{C0C0}", "\u{1109}\u{1161}\u{11BB}"),
    ("\u{C0C1}", "\u{C0C1}", "\u{1109}\u{1161}\u{11BC}", "\u{C0C1}", "\u{1109}\u{1161}\u{11BC}"),
    ("\u{C0C2}", "\u{C0C2}", "\u{1109}\u{1161}\u{11BD}", "\u{C0C2}", "\u{1109}\u{1161}\u{11BD}"),
    ("\u{C0C3}", "\u{C0C3}", "\u{1109}\u{1161}\u{11BE}", "\u{C0C3}", "\u{1109}\u{1161}\u{11BE}"),
    ("\u{C0C4}", "\u{C0C4}", "\u{1109}\u{1161}\u{11BF}", "\u{C0C4}", "\u{1109}\u{1161}\u{11BF}"),
    ("\u{C0C5}", "\u{C0C5}", "\u{1109}\u{1161}\u{11C0}", "\u{C0C5}", "\u{1109}\u{1161}\u{11C0}"),
    ("\u{C0C6}", "\u{C0C6}", "\u{1109}\u{1161}\u{11C1}", "\u{C0C6}", "\u{1109}\u{1161}\u{11C1}"),
    ("\u{C0C7}", "\u{C0C7}", "\u{1109}\u{1161}\u{11C2}", "\u{C0C7}", "\u{1109}\u{1161}\u{11C2}"),
    ("\u{C0C8}", "\u{C0C8}", "\u{1109}\u{1162}", "\u{C0C8}", "\u{1109}\u{1162}"),
    ("\u{C0C9}", "\u{C0C9}", "\u{1109}\u{1162}\u{11A8}", "\u{C0C9}", "\u{1109}\u{1162}\u{11A8}"),
    ("\u{C0CA}", "\u{C0CA}", "\u{1109}\u{1162}\u{11A9}", "\u{C0CA}", "\u{1109}\u{1162}\u{11A9}"),
    ("\u{C0CB}", "\u{C0CB}", "\u{1109}\u{1162}\u{11AA}", "\u{C0CB}", "\u{1109}\u{1162}\u{11AA}"),
    ("\u{C0CC}", "\u{C0CC}", "\u{1109}\u{1162}\u{11AB}", "\u{C0CC}", "\u{1109}\u{1162}\u{11AB}"),
    ("\u{C0CD}", "\u{C0CD}", "\u{1109}\u{1162}\u{11AC}", "\u{C0CD}", "\u{1109}\u{1162}\u{11AC}"),
    ("\u{C0CE}", "\u{C0CE}", "\u{1109}\u{1162}\u{11AD}", "\u{C0CE}", "\u{1109}\u{1162}\u{11AD}"),
    ("\u{C0CF}", "\u{C0CF}", "\u{1109}\u{1162}\u{11AE}", "\u{C0CF}", "\u{1109}\u{1162}\u{11AE}"),
    ("\u{C0D0}", "\u{C0D0}", "\u{1109}\u{1162}\u{11AF}", "\u{C0D0}", "\u{1109}\u{1162}\u{11AF}"),
    ("\u{C0D1}", "\u{C0D1}", "\u{1109}\u{1162}\u{11B0}", "\u{C0D1}", "\u{1109}\u{1162}\u{11B0}"),
    ("\u{C0D2}", "\u{C0D2}", "\u{1109}\u{1162}\u{11B1}", "\u{C0D2}", "\u{1109}\u{1162}\u{11B1}"),
    ("\u{C0D3}", "\u{C0D3}", "\u{1109}\u{1162}\u{11B2}", "\u{C0D3}", "\u{1109}\u{1162}\u{11B2}"),
    ("\u{C0D4}", "\u{C0D4}", "\u{1109}\u{1162}\u{11B3}", "\u{C0D4}", "\u{1109}\u{1162}\u{11B3}"),
    ("\u{C0D5}", "\u{C0D5}", "\u{1109}\u{1162}\u{11B4}", "\u{C0D5}", "\u{1109}\u{1162}\u{11B4}"),
    ("\u{C0D6}", "\u{C0D6}", "\u{1109}\u{1162}\u{11B5}", "\u{C0D6}", "\u{1109}\u{1162}\u{11B5}"),
    ("\u{C0D7}", "\u{C0D7}", "\u{1109}\u{1162}\u{11B6}", "\u{C0D7}", "\u{1109}\u{1162}\u{11B6}"),
    ("\u{C0D8}", "\u{C0D8}", "\u{1109}\u{1162}\u{11B7}", "\u{C0D8}", "\u{1109}\u{1162}\u{11B7}"),
    ("\u{C0D9}", "\u{C0D9}", "\u{1109}\u{1162}\u{11B8}", "\u{C0D9}", "\u{1109}\u{1162}\u{11B8}"),
    ("\u{C0DA}", "\u{C0DA}", "\u{1109}\u{1162}\u{11B9}", "\u{C0DA}", "\u{1109}\u{1162}\u{11B9}"),
    ("\u{C0DB}", "\u{C0DB}", "\u{1109}\u{1162}\u{11BA}", "\u{C0DB}", "\u{1109}\u{1162}\u{11BA}"),
    ("\u{C0DC}", "\u{C0DC}", "\u{1109}\u{1162}\u{11BB}", "\u{C0DC}", "\u{1109}\u{1162}\u{11BB}"),
    ("\u{C0DD}", "\u{C0DD}", "\u{1109}\u{1162}\u{11BC}", "\u{C0DD}", "\u{1109}\u{1162}\u{11BC}"),
    ("\u{C0DE}", "\u{C0DE}", "\u{1109}\u{1162}\u{11BD}", "\u{C0DE}", "\u{1109}\u{1162}\u{11BD}"),
    ("\u{C0DF}", "\u{C0DF}", "\u{1109}\u{1162}\u{11BE}", "\u{C0DF}", "\u{1109}\u{1162}\u{11BE}"),
    ("\u{C0E0}", "\u{C0E0}", "\u{1109}\u{1162}\u{11BF}", "\u{C0E0}", "\u{1109}\u{1162}\u{11BF}"),
    ("\u{C0E1}", "\u{C0E1}", "\u{1109}\u{1162}\u{11C0}", "\u{C0E1}", "\u{1109}\u{1162}\u{11C0}"),
    ("\u{C0E2}", "\u{C0E2}", "\u{1109}\u{1162}\u{11C1}", "\u{C0E2}", "\u{1109}\u{1162}\u{11C1}"),
    ("\u{C0E3}", "\u{C0E3}", "\u{1109}\u{1162}\u{11C2}", "\u{C0E3}", "\u{1109}\u{1162}\u{11C2}"),
    ("\u{C0E4}", "\u{C0E4}", "\u{1109}\u{1163}", "\u{C0E4}", "\u{1109}\u{1163}"),
    ("\u{C0E5}", "\u{C0E5}", "\u{1109}\u{1163}\u{11A8}", "\u{C0E5}", "\u{1109}\u{1163}\u{11A8}"),
    ("\u{C0E6}", "\u{C0E6}", "\u{1109}\u{1163}\u{11A9}", "\u{C0E6}", "\u{1109}\u{1163}\u{11A9}"),
    ("\u{C0E7}", "\u{C0E7}", "\u{1109}\u{1163}\u{11AA}", "\u{C0E7}", "\u{1109}\u{1163}\u{11AA}"),
    ("\u{C0E8}", "\u{C0E8}", "\u{1109}\u{1163}\u{11AB}", "\u{C0E8}", "\u{1109}\u{1163}\u{11AB}"),
    ("\u{C0E9}", "\u{C0E9}", "\u{1109}\u{1163}\u{11AC}", "\u{C0E9}", "\u{1109}\u{1163}\u{11AC}"),
    ("\u{C0EA}", "\u{C0EA}", "\u{1109}\u{1163}\u{11AD}", "\u{C0EA}", "\u{1109}\u{1163}\u{11AD}"),
    ("\u{C0EB}", "\u{C0EB}", "\u{1109}\u{1163}\u{11AE}", "\u{C0EB}", "\u{1109}\u{1163}\u{11AE}"),
    ("\u{C0EC}", "\u{C0EC}", "\u{1109}\u{1163}\u{11AF}", "\u{C0EC}", "\u{1109}\u{1163}\u{11AF}"),
    ("\u{C0ED}", "\u{C0ED}", "\u{1109}\u{1163}\u{11B0}", "\u{C0ED}", "\u{1109}\u{1163}\u{11B0}"),
    ("\u{C0EE}", "\u{C0EE}", "\u{1109}\u{1163}\u{11B1}", "\u{C0EE}", "\u{1109}\u{1163}\u{11B1}"),
    ("\u{C0EF}", "\u{C0EF}", "\u{1109}\u{1163}\u{11B2}", "\u{C0EF}", "\u{1109}\u{1163}\u{11B2}"),
    ("\u{C0F0}", "\u{C0F0}", "\u{1109}\u{1163}\u{11B3}", "\u{C0F0}", "\u{1109}\u{1163}\u{11B3}"),
    ("\u{C0F1}", "\u{C0F1}", "\u{1109}\u{1163}\u{11B4}", "\u{C0F1}", "\u{1109}\u{1163}\u{11B4}"),
    ("\u{C0F2}", "\u{C0F2}", "\u{1109}\u{1163}\u{11B5}", "\u{C0F2}", "\u{1109}\u{1163}\u{11B5}"),
    ("\u{C0F3}", "\u{C0F3}", "\u{1109}\u{1163}\u{11B6}", "\u{C0F3}", "\u{1109}\u{1163}\u{11B6}"),
    ("\u{C0F4}", "\u{C0F4}", "\u{1109}\u{1163}\u{11B7}", "\u{C0F4}", "\u{1109}\u{1163}\u{11B7}"),
    ("\u{C0F5}", "\u{C0F5}", "\u{1109}\u{1163}\u{11B8}", "\u{C0F5}", "\u{1109}\u{1163}\u{11B8}"),
    ("\u{C0F6}", "\u{C0F6}", "\u{1109}\u{1163}\u{11B9}", "\u{C0F6}", "\u{1109}\u{1163}\u{11B9}"),
    ("\u{C0F7}", "\u{C0F7}", "\u{1109}\u{1163}\u{11BA}", "\u{C0F7}", "\u{1109}\u{1163}\u{11BA}"),
    ("\u{C0F8}", "\u{C0F8}", "\u{1109}\u{1163}\u{11BB}", "\u{C0F8}", "\u{1109}\u{1163}\u{11BB}"),
    ("\u{C0F9}", "\u{C0F9}", "\u{1109}\u{1163}\u{11BC}", "\u{C0F9}", "\u{1109}\u{1163}\u{11BC}"),
    ("\u{C0FA}", "\u{C0FA}", "\u{1109}\u{1163}\u{11BD}", "\u{C0FA}", "\u{1109}\u{1163}\u{11BD}"),
    ("\u{C0FB}", "\u{C0FB}", "\u{1109}\u{1163}\u{11BE}", "\u{C0FB}", "\u{1109}\u{1163}\u{11BE}"),
    ("\u{C0FC}", "\u{C0FC}", "\u{1109}\u{1163}\u{11BF}", "\u{C0FC}", "\u{1109}\u{1163}\u{11BF}"),
    ("\u{C0FD}", "\u{C0FD}", "\u{1109}\u{1163}\u{11C0}", "\u{C0FD}", "\u{1109}\u{1163}\u{11C0}"),
    ("\u{C0FE}", "\u{C0FE}", "\u{1109}\u{1163}\u{11C1}", "\u{C0FE}", "\u{1109}\u{1163}\u{11C1}"),
    ("\u{C0FF}", "\u{C0FF}", "\u{1109}\u{1163}\u{11C2}", "\u{C0FF}", "\u{1109}\u{1163}\u{11C2}"),
    ("\u{C100}", "\u{C100}", "\u{1109}\u{1164}", "\u{C100}", "\u{1109}\u{1164}"),
    ("\u{C101}", "\u{C101}", "\u{1109}\u{1164}\u{11A8}", "\u{C101}", "\u{1109}\u{1164}\u{11A8}"),
    ("\u{C102}", "\u{C102}", "\u{1109}\u{1164}\u{11A9}", "\u{C102}", "\u{1109}\u{1164}\u{11A9}"),
    ("\u{C103}", "\u{C103}", "\u{1109}\u{1164}\u{11AA}", "\u{C103}", "\u{1109}\u{1164}\u{11AA}"),
    ("\u{C104}", "\u{C104}", "\u{1109}\u{1164}\u{11AB}", "\u{C104}", "\u{1109}\u{1164}\u{11AB}"),
    ("\u{C105}", "\u{C105}", "\u{1109}\u{1164}\u{11AC}", "\u{C105}", "\u{1109}\u{1164}\u{11AC}"),
    ("\u{C106}", "\u{C106}", "\u{1109}\u{1164}\u{11AD}", "\u{C106}", "\u{1109}\u{1164}\u{11AD}"),
    ("\u{C107}", "\u{C107}", "\u{1109}\u{1164}\u{11AE}", "\u{C107}", "\u{1109}\u{1164}\u{11AE}"),
    ("\u{C108}", "\u{C108}", "\u{1109}\u{1164}\u{11AF}", "\u{C108}", "\u{1109}\u{1164}\u{11AF}"),
    ("\u{C109}", "\u{C109}", "\u{1109}\u{1164}\u{11B0}", "\u{C109}", "\u{1109}\u{1164}\u{11B0}"),
    ("\u{C10A}", "\u{C10A}", "\u{1109}\u{1164}\u{11B1}", "\u{C10A}", "\u{1109}\u{1164}\u{11B1}"),
    ("\u{C10B}", "\u{C10B}", "\u{1109}\u{1164}\u{11B2}", "\u{C10B}", "\u{1109}\u{1164}\u{11B2}"),
    ("\u{C10C}", "\u{C10C}", "\u{1109}\u{1164}\u{11B3}", "\u{C10C}", "\u{1109}\u{1164}\u{11B3}"),
    ("\u{C10D}", "\u{C10D}", "\u{1109}\u{1164}\u{11B4}", "\u{C10D}", "\u{1109}\u{1164}\u{11B4}"),
    ("\u{C10E}", "\u{C10E}", "\u{1109}\u{1164}\u{11B5}", "\u{C10E}", "\u{1109}\u{1164}\u{11B5}"),
    ("\u{C10F}", "\u{C10F}", "\u{1109}\u{1164}\u{11B6}", "\u{C10F}", "\u{1109}\u{1164}\u{11B6}"),
    ("\u{C110}", "\u{C110}", "\u{1109}\u{1164}\u{11B7}", "\u{C110}", "\u{1109}\u{1164}\u{11B7}"),
    ("\u{C111}", "\u{C111}", "\u{1109}\u{1164}\u{11B8}", "\u{C111}", "\u{1109}\u{1164}\u{11B8}"),
    ("\u{C112}", "\u{C112}", "\u{1109}\u{1164}\u{11B9}", "\u{C112}", "\u{1109}\u{1164}\u{11B9}"),
    ("\u{C113}", "\u{C113}", "\u{1109}\u{1164}\u{11BA}", "\u{C113}", "\u{1109}\u{1164}\u{11BA}"),
    ("\u{C114}", "\u{C114}", "\u{1109}\u{1164}\u{11BB}", "\u{C114}", "\u{1109}\u{1164}\u{11BB}"),
    ("\u{C115}", "\u{C115}", "\u{1109}\u{1164}\u{11BC}", "\u{C115}", "\u{1109}\u{1164}\u{11BC}"),
    ("\u{C116}", "\u{C116}", "\u{1109}\u{1164}\u{11BD}", "\u{C116}", "\u{1109}\u{1164}\u{11BD}"),
    ("\u{C117}", "\u{C117}", "\u{1109}\u{1164}\u{11BE}", "\u{C117}", "\u{1109}\u{1164}\u{11BE}"),
    ("\u{C118}", "\u{C118}", "\u{1109}\u{1164}\u{11BF}", "\u{C118}", "\u{1109}\u{1164}\u{11BF}"),
    ("\u{C119}", "\u{C119}", "\u{1109}\u{1164}\u{11C0}", "\u{C119}", "\u{1109}\u{1164}\u{11C0}"),
    ("\u{C11A}", "\u{C11A}", "\u{1109}\u{1164}\u{11C1}", "\u{C11A}", "\u{1109}\u{1164}\u{11C1}"),
    ("\u{C11B}", "\u{C11B}", "\u{1109}\u{1164}\u{11C2}", "\u{C11B}", "\u{1109}\u{1164}\u{11C2}"),
    ("\u{C11C}", "\u{C11C}", "\u{1109}\u{1165}", "\u{C11C}", "\u{1109}\u{1165}"),
    ("\u{C11D}", "\u{C11D}", "\u{1109}\u{1165}\u{11A8}", "\u{C11D}", "\u{1109}\u{1165}\u{11A8}"),
    ("\u{C11E}", "\u{C11E}", "\u{1109}\u{1165}\u{11A9}", "\u{C11E}", "\u{1109}\u{1165}\u{11A9}"),
    ("\u{C11F}", "\u{C11F}", "\u{1109}\u{1165}\u{11AA}", "\u{C11F}", "\u{1109}\u{1165}\u{11AA}"),
    ("\u{C120}", "\u{C120}", "\u{1109}\u{1165}\u{11AB}", "\u{C120}", "\u{1109}\u{1165}\u{11AB}"),
    ("\u{C121}", "\u{C121}", "\u{1109}\u{1165}\u{11AC}", "\u{C121}", "\u{1109}\u{1165}\u{11AC}"),
    ("\u{C122}", "\u{C122}", "\u{1109}\u{1165}\u{11AD}", "\u{C122}", "\u{1109}\u{1165}\u{11AD}"),
    ("\u{C123}", "\u{C123}", "\u{1109}\u{1165}\u{11AE}", "\u{C123}", "\u{1109}\u{1165}\u{11AE}"),
    ("\u{C124}", "\u{C124}", "\u{1109}\u{1165}\u{11AF}", "\u{C124}", "\u{1109}\u{1165}\u{11AF}"),
    ("\u{C125}", "\u{C125}", "\u{1109}\u{1165}\u{11B0}", "\u{C125}", "\u{1109}\u{1165}\u{11B0}"),
    ("\u{C126}", "\u{C126}", "\u{1109}\u{1165}\u{11B1}", "\u{C126}", "\u{1109}\u{1165}\u{11B1}"),
    ("\u{C127}", "\u{C127}", "\u{1109}\u{1165}\u{11B2}", "\u{C127}", "\u{1109}\u{1165}\u{11B2}"),
    ("\u{C128}", "\u{C128}", "\u{1109}\u{1165}\u{11B3}", "\u{C128}", "\u{1109}\u{1165}\u{11B3}"),
    ("\u{C129}", "\u{C129}", "\u{1109}\u{1165}\u{11B4}", "\u{C129}", "\u{1109}\u{1165}\u{11B4}"),
    ("\u{C12A}", "\u{C12A}", "\u{1109}\u{1165}\u{11B5}", "\u{C12A}", "\u{1109}\u{1165}\u{11B5}"),
    ("\u{C12B}", "\u{C12B}", "\u{1109}\u{1165}\u{11B6}", "\u{C12B}", "\u{1109}\u{1165}\u{11B6}"),
    ("\u{C12C}", "\u{C12C}", "\u{1109}\u{1165}\u{11B7}", "\u{C12C}", "\u{1109}\u{1165}\u{11B7}"),
    ("\u{C12D}", "\u{C12D}", "\u{1109}\u{1165}\u{11B8}", "\u{C12D}", "\u{1109}\u{1165}\u{11B8}"),
    ("\u{C12E}", "\u{C12E}", "\u{1109}\u{1165}\u{11B9}", "\u{C12E}", "\u{1109}\u{1165}\u{11B9}"),
    ("\u{C12F}", "\u{C12F}", "\u{1109}\u{1165}\u{11BA}", "\u{C12F}", "\u{1109}\u{1165}\u{11BA}"),
    ("\u{C130}", "\u{C130}", "\u{1109}\u{1165}\u{11BB}", "\u{C130}", "\u{1109}\u{1165}\u{11BB}"),
    ("\u{C131}", "\u{C131}", "\u{1109}\u{1165}\u{11BC}", "\u{C131}", "\u{1109}\u{1165}\u{11BC}"),
    ("\u{C132}", "\u{C132}", "\u{1109}\u{1165}\u{11BD}", "\u{C132}", "\u{1109}\u{1165}\u{11BD}"),
    ("\u{C133}", "\u{C133}", "\u{1109}\u{1165}\u{11BE}", "\u{C133}", "\u{1109}\u{1165}\u{11BE}"),
    ("\u{C134}", "\u{C134}", "\u{1109}\u{1165}\u{11BF}", "\u{C134}", "\u{1109}\u{1165}\u{11BF}"),
    ("\u{C135}", "\u{C135}", "\u{1109}\u{1165}\u{11C0}", "\u{C135}", "\u{1109}\u{1165}\u{11C0}"),
    ("\u{C136}", "\u{C136}", "\u{1109}\u{1165}\u{11C1}", "\u{C136}", "\u{1109}\u{1165}\u{11C1}"),
    ("\u{C137}", "\u{C137}", "\u{1109}\u{1165}\u{11C2}", "\u{C137}", "\u{1109}\u{1165}\u{11C2}"),
    ("\u{C138}", "\u{C138}", "\u{1109}\u{1166}", "\u{C138}", "\u{1109}\u{1166}"),
    ("\u{C139}", "\u{C139}", "\u{1109}\u{1166}\u{11A8}", "\u{C139}", "\u{1109}\u{1166}\u{11A8}"),
    ("\u{C13A}", "\u{C13A}", "\u{1109}\u{1166}\u{11A9}", "\u{C13A}", "\u{1109}\u{1166}\u{11A9}"),
    ("\u{C13B}", "\u{C13B}", "\u{1109}\u{1166}\u{11AA}", "\u{C13B}", "\u{1109}\u{1166}\u{11AA}"),
    ("\u{C13C}", "\u{C13C}", "\u{1109}\u{1166}\u{11AB}", "\u{C13C}", "\u{1109}\u{1166}\u{11AB}"),
    ("\u{C13D}", "\u{C13D}", "\u{1109}\u{1166}\u{11AC}", "\u{C13D}", "\u{1109}\u{1166}\u{11AC}"),
    ("\u{C13E}", "\u{C13E}", "\u{1109}\u{1166}\u{11AD}", "\u{C13E}", "\u{1109}\u{1166}\u{11AD}"),
    ("\u{C13F}", "\u{C13F}", "\u{1109}\u{1166}\u{11AE}", "\u{C13F}", "\u{1109}\u{1166}\u{11AE}"),
    ("\u{C140}", "\u{C140}", "\u{1109}\u{1166}\u{11AF}", "\u{C140}", "\u{1109}\u{1166}\u{11AF}"),
    ("\u{C141}", "\u{C141}", "\u{1109}\u{1166}\u{11B0}", "\u{C141}", "\u{1109}\u{1166}\u{11B0}"),
    ("\u{C142}", "\u{C142}", "\u{1109}\u{1166}\u{11B1}", "\u{C142}", "\u{1109}\u{1166}\u{11B1}"),
    ("\u{C143}", "\u{C143}", "\u{1109}\u{1166}\u{11B2}", "\u{C143}", "\u{1109}\u{1166}\u{11B2}"),
    ("\u{C144}", "\u{C144}", "\u{1109}\u{1166}\u{11B3}", "\u{C144}", "\u{1109}\u{1166}\u{11B3}"),
    ("\u{C145}", "\u{C145}", "\u{1109}\u{1166}\u{11B4}", "\u{C145}", "\u{1109}\u{1166}\u{11B4}"),
    ("\u{C146}", "\u{C146}", "\u{1109}\u{1166}\u{11B5}", "\u{C146}", "\u{1109}\u{1166}\u{11B5}"),
    ("\u{C147}", "\u{C147}", "\u{1109}\u{1166}\u{11B6}", "\u{C147}", "\u{1109}\u{1166}\u{11B6}"),
    ("\u{C148}", "\u{C148}", "\u{1109}\u{1166}\u{11B7}", "\u{C148}", "\u{1109}\u{1166}\u{11B7}"),
    ("\u{C149}", "\u{C149}", "\u{1109}\u{1166}\u{11B8}", "\u{C149}", "\u{1109}\u{1166}\u{11B8}"),
    ("\u{C14A}", "\u{C14A}", "\u{1109}\u{1166}\u{11B9}", "\u{C14A}", "\u{1109}\u{1166}\u{11B9}"),
    ("\u{C14B}", "\u{C14B}", "\u{1109}\u{1166}\u{11BA}", "\u{C14B}", "\u{1109}\u{1166}\u{11BA}"),
    ("\u{C14C}", "\u{C14C}", "\u{1109}\u{1166}\u{11BB}", "\u{C14C}", "\u{1109}\u{1166}\u{11BB}"),
    ("\u{C14D}", "\u{C14D}", "\u{1109}\u{1166}\u{11BC}", "\u{C14D}", "\u{1109}\u{1166}\u{11BC}"),
    ("\u{C14E}", "\u{C14E}", "\u{1109}\u{1166}\u{11BD}", "\u{C14E}", "\u{1109}\u{1166}\u{11BD}"),
    ("\u{C14F}", "\u{C14F}", "\u{1109}\u{1166}\u{11BE}", "\u{C14F}", "\u{1109}\u{1166}\u{11BE}"),
    ("\u{C150}", "\u{C150}", "\u{1109}\u{1166}\u{11BF}", "\u{C150}", "\u{1109}\u{1166}\u{11BF}"),
    ("\u{C151}", "\u{C151}", "\u{1109}\u{1166}\u{11C0}", "\u{C151}", "\u{1109}\u{1166}\u{11C0}"),
    ("\u{C152}", "\u{C152}", "\u{1109}\u{1166}\u{11C1}", "\u{C152}", "\u{1109}\u{1166}\u{11C1}"),
    ("\u{C153}", "\u{C153}", "\u{1109}\u{1166}\u{11C2}", "\u{C153}", "\u{1109}\u{1166}\u{11C2}"),
    ("\u{C154}", "\u{C154}", "\u{1109}\u{1167}", "\u{C154}", "\u{1109}\u{1167}"),
    ("\u{C155}", "\u{C155}", "\u{1109}\u{1167}\u{11A8}", "\u{C155}", "\u{1109}\u{1167}\u{11A8}"),
    ("\u{C156}", "\u{C156}", "\u{1109}\u{1167}\u{11A9}", "\u{C156}", "\u{1109}\u{1167}\u{11A9}"),
    ("\u{C157}", "\u{C157}", "\u{1109}\u{1167}\u{11AA}", "\u{C157}", "\u{1109}\u{1167}\u{11AA}"),
    ("\u{C158}", "\u{C158}", "\u{1109}\u{1167}\u{11AB}", "\u{C158}", "\u{1109}\u{1167}\u{11AB}"),
    ("\u{C159}", "\u{C159}", "\u{1109}\u{1167}\u{11AC}", "\u{C159}", "\u{1109}\u{1167}\u{11AC}"),
    ("\u{C15A}", "\u{C15A}", "\u{1109}\u{1167}\u{11AD}", "\u{C15A}", "\u{1109}\u{1167}\u{11AD}"),
    ("\u{C15B}", "\u{C15B}", "\u{1109}\u{1167}\u{11AE}", "\u{C15B}", "\u{1109}\u{1167}\u{11AE}"),
    ("\u{C15C}", "\u{C15C}", "\u{1109}\u{1167}\u{11AF}", "\u{C15C}", "\u{1109}\u{1167}\u{11AF}"),
    ("\u{C15D}", "\u{C15D}", "\u{1109}\u{1167}\u{11B0}", "\u{C15D}", "\u{1109}\u{1167}\u{11B0}"),
    ("\u{C15E}", "\u{C15E}", "\u{1109}\u{1167}\u{11B1}", "\u{C15E}", "\u{1109}\u{1167}\u{11B1}"),
    ("\u{C15F}", "\u{C15F}", "\u{1109}\u{1167}\u{11B2}", "\u{C15F}", "\u{1109}\u{1167}\u{11B2}"),
    ("\u{C160}", "\u{C160}", "\u{1109}\u{1167}\u{11B3}", "\u{C160}", "\u{1109}\u{1167}\u{11B3}"),
    ("\u{C161}", "\u{C161}", "\u{1109}\u{1167}\u{11B4}", "\u{C161}", "\u{1109}\u{1167}\u{11B4}"),
    ("\u{C162}", "\u{C162}", "\u{1109}\u{1167}\u{11B5}", "\u{C162}", "\u{1109}\u{1167}\u{11B5}"),
    ("\u{C163}", "\u{C163}", "\u{1109}\u{1167}\u{11B6}", "\u{C163}", "\u{1109}\u{1167}\u{11B6}"),
    ("\u{C164}", "\u{C164}", "\u{1109}\u{1167}\u{11B7}", "\u{C164}", "\u{1109}\u{1167}\u{11B7}"),
    ("\u{C165}", "\u{C165}", "\u{1109}\u{1167}\u{11B8}", "\u{C165}", "\u{1109}\u{1167}\u{11B8}"),
    ("\u{C166}", "\u{C166}", "\u{1109}\u{1167}\u{11B9}", "\u{C166}", "\u{1109}\u{1167}\u{11B9}"),
    ("\u{C167}", "\u{C167}", "\u{1109}\u{1167}\u{11BA}", "\u{C167}", "\u{1109}\u{1167}\u{11BA}"),
    ("\u{C168}", "\u{C168}", "\u{1109}\u{1167}\u{11BB}", "\u{C168}", "\u{1109}\u{1167}\u{11BB}"),
    ("\u{C169}", "\u{C169}", "\u{1109}\u{1167}\u{11BC}", "\u{C169}", "\u{1109}\u{1167}\u{11BC}"),
    ("\u{C16A}", "\u{C16A}", "\u{1109}\u{1167}\u{11BD}", "\u{C16A}", "\u{1109}\u{1167}\u{11BD}"),
    ("\u{C16B}", "\u{C16B}", "\u{1109}\u{1167}\u{11BE}", "\u{C16B}", "\u{1109}\u{1167}\u{11BE}"),
    ("\u{C16C}", "\u{C16C}", "\u{1109}\u{1167}\u{11BF}", "\u{C16C}", "\u{1109}\u{1167}\u{11BF}"),
    ("\u{C16D}", "\u{C16D}", "\u{1109}\u{1167}\u{11C0}", "\u{C16D}", "\u{1109}\u{1167}\u{11C0}"),
    ("\u{C16E}", "\u{C16E}", "\u{1109}\u{1167}\u{11C1}", "\u{C16E}", "\u{1109}\u{1167}\u{11C1}"),
    ("\u{C16F}", "\u{C16F}", "\u{1109}\u{1167}\u{11C2}", "\u{C16F}", "\u{1109}\u{1167}\u{11C2}"),
    ("\u{C170}", "\u{C170}", "\u{1109}\u{1168}", "\u{C170}", "\u{1109}\u{1168}"),
    ("\u{C171}", "\u{C171}", "\u{1109}\u{1168}\u{11A8}", "\u{C171}", "\u{1109}\u{1168}\u{11A8}"),
    ("\u{C172}", "\u{C172}", "\u{1109}\u{1168}\u{11A9}", "\u{C172}", "\u{1109}\u{1168}\u{11A9}"),
    ("\u{C173}", "\u{C173}", "\u{1109}\u{1168}\u{11AA}", "\u{C173}", "\u{1109}\u{1168}\u{11AA}"),
    ("\u{C174}", "\u{C174}", "\u{1109}\u{1168}\u{11AB}", "\u{C174}", "\u{1109}\u{1168}\u{11AB}"),
    ("\u{C175}", "\u{C175}", "\u{1109}\u{1168}\u{11AC}", "\u{C175}", "\u{1109}\u{1168}\u{11AC}"),
    ("\u{C176}", "\u{C176}", "\u{1109}\u{1168}\u{11AD}", "\u{C176}", "\u{1109}\u{1168}\u{11AD}"),
    ("\u{C177}", "\u{C177}", "\u{1109}\u{1168}\u{11AE}", "\u{C177}", "\u{1109}\u{1168}\u{11AE}"),
    ("\u{C178}", "\u{C178}", "\u{1109}\u{1168}\u{11AF}", "\u{C178}", "\u{1109}\u{1168}\u{11AF}"),
    ("\u{C179}", "\u{C179}", "\u{1109}\u{1168}\u{11B0}", "\u{C179}", "\u{1109}\u{1168}\u{11B0}"),
    ("\u{C17A}", "\u{C17A}", "\u{1109}\u{1168}\u{11B1}", "\u{C17A}", "\u{1109}\u{1168}\u{11B1}"),
    ("\u{C17B}", "\u{C17B}", "\u{1109}\u{1168}\u{11B2}", "\u{C17B}", "\u{1109}\u{1168}\u{11B2}"),
    ("\u{C17C}", "\u{C17C}", "\u{1109}\u{1168}\u{11B3}", "\u{C17C}", "\u{1109}\u{1168}\u{11B3}"),
    ("\u{C17D}", "\u{C17D}", "\u{1109}\u{1168}\u{11B4}", "\u{C17D}", "\u{1109}\u{1168}\u{11B4}"),
    ("\u{C17E}", "\u{C17E}", "\u{1109}\u{1168}\u{11B5}", "\u{C17E}", "\u{1109}\u{1168}\u{11B5}"),
    ("\u{C17F}", "\u{C17F}", "\u{1109}\u{1168}\u{11B6}", "\u{C17F}", "\u{1109}\u{1168}\u{11B6}"),
    ("\u{C180}", "\u{C180}", "\u{1109}\u{1168}\u{11B7}", "\u{C180}", "\u{1109}\u{1168}\u{11B7}"),
    ("\u{C181}", "\u{C181}", "\u{1109}\u{1168}\u{11B8}", "\u{C181}", "\u{1109}\u{1168}\u{11B8}"),
    ("\u{C182}", "\u{C182}", "\u{1109}\u{1168}\u{11B9}", "\u{C182}", "\u{1109}\u{1168}\u{11B9}"),
    ("\u{C183}", "\u{C183}", "\u{1109}\u{1168}\u{11BA}", "\u{C183}", "\u{1109}\u{1168}\u{11BA}"),
    ("\u{C184}", "\u{C184}", "\u{1109}\u{1168}\u{11BB}", "\u{C184}", "\u{1109}\u{1168}\u{11BB}"),
    ("\u{C185}", "\u{C185}", "\u{1109}\u{1168}\u{11BC}", "\u{C185}", "\u{1109}\u{1168}\u{11BC}"),
    ("\u{C186}", "\u{C186}", "\u{1109}\u{1168}\u{11BD}", "\u{C186}", "\u{1109}\u{1168}\u{11BD}"),
    ("\u{C187}", "\u{C187}", "\u{1109}\u{1168}\u{11BE}", "\u{C187}", "\u{1109}\u{1168}\u{11BE}"),
    ("\u{C188}", "\u{C188}", "\u{1109}\u{1168}\u{11BF}", "\u{C188}", "\u{1109}\u{1168}\u{11BF}"),
    ("\u{C189}", "\u{C189}", "\u{1109}\u{1168}\u{11C0}", "\u{C189}", "\u{1109}\u{1168}\u{11C0}"),
    ("\u{C18A}", "\u{C18A}", "\u{1109}\u{1168}\u{11C1}", "\u{C18A}", "\u{1109}\u{1168}\u{11C1}"),
    ("\u{C18B}", "\u{C18B}", "\u{1109}\u{1168}\u{11C2}", "\u{C18B}", "\u{1109}\u{1168}\u{11C2}"),
    ("\u{C18C}", "\u{C18C}", "\u{1109}\u{1169}", "\u{C18C}", "\u{1109}\u{1169}"),
    ("\u{C18D}", "\u{C18D}", "\u{1109}\u{1169}\u{11A8}", "\u{C18D}", "\u{1109}\u{1169}\u{11A8}"),
    ("\u{C18E}", "\u{C18E}", "\u{1109}\u{1169}\u{11A9}", "\u{C18E}", "\u{1109}\u{1169}\u{11A9}"),
    ("\u{C18F}", "\u{C18F}", "\u{1109}\u{1169}\u{11AA}", "\u{C18F}", "\u{1109}\u{1169}\u{11AA}"),
    ("\u{C190}", "\u{C190}", "\u{1109}\u{1169}\u{11AB}", "\u{C190}", "\u{1109}\u{1169}\u{11AB}"),
    ("\u{C191}", "\u{C191}", "\u{1109}\u{1169}\u{11AC}", "\u{C191}", "\u{1109}\u{1169}\u{11AC}"),
    ("\u{C192}", "\u{C192}", "\u{1109}\u{1169}\u{11AD}", "\u{C192}", "\u{1109}\u{1169}\u{11AD}"),
    ("\u{C193}", "\u{C193}", "\u{1109}\u{1169}\u{11AE}", "\u{C193}", "\u{1109}\u{1169}\u{11AE}"),
    ("\u{C194}", "\u{C194}", "\u{1109}\u{1169}\u{11AF}", "\u{C194}", "\u{1109}\u{1169}\u{11AF}"),
    ("\u{C195}", "\u{C195}", "\u{1109}\u{1169}\u{11B0}", "\u{C195}", "\u{1109}\u{1169}\u{11B0}"),
    ("\u{C196}", "\u{C196}", "\u{1109}\u{1169}\u{11B1}", "\u{C196}", "\u{1109}\u{1169}\u{11B1}"),
    ("\u{C197}", "\u{C197}", "\u{1109}\u{1169}\u{11B2}", "\u{C197}", "\u{1109}\u{1169}\u{11B2}"),
    ("\u{C198}", "\u{C198}", "\u{1109}\u{1169}\u{11B3}", "\u{C198}", "\u{1109}\u{1169}\u{11B3}"),
    ("\u{C199}", "\u{C199}", "\u{1109}\u{1169}\u{11B4}", "\u{C199}", "\u{1109}\u{1169}\u{11B4}"),
    ("\u{C19A}", "\u{C19A}", "\u{1109}\u{1169}\u{11B5}", "\u{C19A}", "\u{1109}\u{1169}\u{11B5}"),
    ("\u{C19B}", "\u{C19B}", "\u{1109}\u{1169}\u{11B6}", "\u{C19B}", "\u{1109}\u{1169}\u{11B6}"),
    ("\u{C19C}", "\u{C19C}", "\u{1109}\u{1169}\u{11B7}", "\u{C19C}", "\u{1109}\u{1169}\u{11B7}"),
    ("\u{C19D}", "\u{C19D}", "\u{1109}\u{1169}\u{11B8}", "\u{C19D}", "\u{1109}\u{1169}\u{11B8}"),
    ("\u{C19E}", "\u{C19E}", "\u{1109}\u{1169}\u{11B9}", "\u{C19E}", "\u{1109}\u{1169}\u{11B9}"),
    ("\u{C19F}", "\u{C19F}", "\u{1109}\u{1169}\u{11BA}", "\u{C19F}", "\u{1109}\u{1169}\u{11BA}"),
    ("\u{C1A0}", "\u{C1A0}", "\u{1109}\u{1169}\u{11BB}", "\u{C1A0}", "\u{1109}\u{1169}\u{11BB}"),
    ("\u{C1A1}", "\u{C1A1}", "\u{1109}\u{1169}\u{11BC}", "\u{C1A1}", "\u{1109}\u{1169}\u{11BC}"),
    ("\u{C1A2}", "\u{C1A2}", "\u{1109}\u{1169}\u{11BD}", "\u{C1A2}", "\u{1109}\u{1169}\u{11BD}"),
    ("\u{C1A3}", "\u{C1A3}", "\u{1109}\u{1169}\u{11BE}", "\u{C1A3}", "\u{1109}\u{1169}\u{11BE}"),
    ("\u{C1A4}", "\u{C1A4}", "\u{1109}\u{1169}\u{11BF}", "\u{C1A4}", "\u{1109}\u{1169}\u{11BF}"),
    ("\u{C1A5}", "\u{C1A5}", "\u{1109}\u{1169}\u{11C0}", "\u{C1A5}", "\u{1109}\u{1169}\u{11C0}"),
    ("\u{C1A6}", "\u{C1A6}", "\u{1109}\u{1169}\u{11C1}", "\u{C1A6}", "\u{1109}\u{1169}\u{11C1}"),
    ("\u{C1A7}", "\u{C1A7}", "\u{1109}\u{1169}\u{11C2}", "\u{C1A7}", "\u{1109}\u{1169}\u{11C2}"),
    ("\u{C1A8}", "\u{C1A8}", "\u{1109}\u{116A}", "\u{C1A8}", "\u{1109}\u{116A}"),
    ("\u{C1A9}", "\u{C1A9}", "\u{1109}\u{116A}\u{11A8}", "\u{C1A9}", "\u{1109}\u{116A}\u{11A8}"),
    ("\u{C1AA}", "\u{C1AA}", "\u{1109}\u{116A}\u{11A9}", "\u{C1AA}", "\u{1109}\u{116A}\u{11A9}"),
    ("\u{C1AB}", "\u{C1AB}", "\u{1109}\u{116A}\u{11AA}", "\u{C1AB}", "\u{1109}\u{116A}\u{11AA}"),
    ("\u{C1AC}", "\u{C1AC}", "\u{1109}\u{116A}\u{11AB}", "\u{C1AC}", "\u{1109}\u{116A}\u{11AB}"),
    ("\u{C1AD}", "\u{C1AD}", "\u{1109}\u{116A}\u{11AC}", "\u{C1AD}", "\u{1109}\u{116A}\u{11AC}"),
    ("\u{C1AE}", "\u{C1AE}", "\u{1109}\u{116A}\u{11AD}", "\u{C1AE}", "\u{1109}\u{116A}\u{11AD}"),
    ("\u{C1AF}", "\u{C1AF}", "\u{1109}\u{116A}\u{11AE}", "\u{C1AF}", "\u{1109}\u{116A}\u{11AE}"),
    ("\u{C1B0}", "\u{C1B0}", "\u{1109}\u{116A}\u{11AF}", "\u{C1B0}", "\u{1109}\u{116A}\u{11AF}"),
    ("\u{C1B1}", "\u{C1B1}", "\u{1109}\u{116A}\u{11B0}", "\u{C1B1}", "\u{1109}\u{116A}\u{11B0}"),
    ("\u{C1B2}", "\u{C1B2}", "\u{1109}\u{116A}\u{11B1}", "\u{C1B2}", "\u{1109}\u{116A}\u{11B1}"),
    ("\u{C1B3}", "\u{C1B3}", "\u{1109}\u{116A}\u{11B2}", "\u{C1B3}", "\u{1109}\u{116A}\u{11B2}"),
    ("\u{C1B4}", "\u{C1B4}", "\u{1109}\u{116A}\u{11B3}", "\u{C1B4}", "\u{1109}\u{116A}\u{11B3}"),
    ("\u{C1B5}", "\u{C1B5}", "\u{1109}\u{116A}\u{11B4}", "\u{C1B5}", "\u{1109}\u{116A}\u{11B4}"),
    ("\u{C1B6}", "\u{C1B6}", "\u{1109}\u{116A}\u{11B5}", "\u{C1B6}", "\u{1109}\u{116A}\u{11B5}"),
    ("\u{C1B7}", "\u{C1B7}", "\u{1109}\u{116A}\u{11B6}", "\u{C1B7}", "\u{1109}\u{116A}\u{11B6}"),
    ("\u{C1B8}", "\u{C1B8}", "\u{1109}\u{116A}\u{11B7}", "\u{C1B8}", "\u{1109}\u{116A}\u{11B7}"),
    ("\u{C1B9}", "\u{C1B9}", "\u{1109}\u{116A}\u{11B8}", "\u{C1B9}", "\u{1109}\u{116A}\u{11B8}"),
    ("\u{C1BA}", "\u{C1BA}", "\u{1109}\u{116A}\u{11B9}", "\u{C1BA}", "\u{1109}\u{116A}\u{11B9}"),
    ("\u{C1BB}", "\u{C1BB}", "\u{1109}\u{116A}\u{11BA}", "\u{C1BB}", "\u{1109}\u{116A}\u{11BA}"),
    ("\u{C1BC}", "\u{C1BC}", "\u{1109}\u{116A}\u{11BB}", "\u{C1BC}", "\u{1109}\u{116A}\u{11BB}"),
    ("\u{C1BD}", "\u{C1BD}", "\u{1109}\u{116A}\u{11BC}", "\u{C1BD}", "\u{1109}\u{116A}\u{11BC}"),
    ("\u{C1BE}", "\u{C1BE}", "\u{1109}\u{116A}\u{11BD}", "\u{C1BE}", "\u{1109}\u{116A}\u{11BD}"),
    ("\u{C1BF}", "\u{C1BF}", "\u{1109}\u{116A}\u{11BE}", "\u{C1BF}", "\u{1109}\u{116A}\u{11BE}"),
    ("\u{C1C0}", "\u{C1C0}", "\u{1109}\u{116A}\u{11BF}", "\u{C1C0}", "\u{1109}\u{116A}\u{11BF}"),
    ("\u{C1C1}", "\u{C1C1}", "\u{1109}\u{116A}\u{11C0}", "\u{C1C1}", "\u{1109}\u{116A}\u{11C0}"),
    ("\u{C1C2}", "\u{C1C2}", "\u{1109}\u{116A}\u{11C1}", "\u{C1C2}", "\u{1109}\u{116A}\u{11C1}"),
    ("\u{C1C3}", "\u{C1C3}", "\u{1109}\u{116A}\u{11C2}", "\u{C1C3}", "\u{1109}\u{116A}\u{11C2}"),
    ("\u{C1C4}", "\u{C1C4}", "\u{1109}\u{116B}", "\u{C1C4}", "\u{1109}\u{116B}"),
    ("\u{C1C5}", "\u{C1C5}", "\u{1109}\u{116B}\u{11A8}", "\u{C1C5}", "\u{1109}\u{116B}\u{11A8}"),
    ("\u{C1C6}", "\u{C1C6}", "\u{1109}\u{116B}\u{11A9}", "\u{C1C6}", "\u{1109}\u{116B}\u{11A9}"),
    ("\u{C1C7}", "\u{C1C7}", "\u{1109}\u{116B}\u{11AA}", "\u{C1C7}", "\u{1109}\u{116B}\u{11AA}"),
    ("\u{C1C8}", "\u{C1C8}", "\u{1109}\u{116B}\u{11AB}", "\u{C1C8}", "\u{1109}\u{116B}\u{11AB}"),
    ("\u{C1C9}", "\u{C1C9}", "\u{1109}\u{116B}\u{11AC}", "\u{C1C9}", "\u{1109}\u{116B}\u{11AC}"),
    ("\u{C1CA}", "\u{C1CA}", "\u{1109}\u{116B}\u{11AD}", "\u{C1CA}", "\u{1109}\u{116B}\u{11AD}"),
    ("\u{C1CB}", "\u{C1CB}", "\u{1109}\u{116B}\u{11AE}", "\u{C1CB}", "\u{1109}\u{116B}\u{11AE}"),
    ("\u{C1CC}", "\u{C1CC}", "\u{1109}\u{116B}\u{11AF}", "\u{C1CC}", "\u{1109}\u{116B}\u{11AF}"),
    ("\u{C1CD}", "\u{C1CD}", "\u{1109}\u{116B}\u{11B0}", "\u{C1CD}", "\u{1109}\u{116B}\u{11B0}"),
    ("\u{C1CE}", "\u{C1CE}", "\u{1109}\u{116B}\u{11B1}", "\u{C1CE}", "\u{1109}\u{116B}\u{11B1}"),
    ("\u{C1CF}", "\u{C1CF}", "\u{1109}\u{116B}\u{11B2}", "\u{C1CF}", "\u{1109}\u{116B}\u{11B2}"),
    ("\u{C1D0}", "\u{C1D0}", "\u{1109}\u{116B}\u{11B3}", "\u{C1D0}", "\u{1109}\u{116B}\u{11B3}"),
    ("\u{C1D1}", "\u{C1D1}", "\u{1109}\u{116B}\u{11B4}", "\u{C1D1}", "\u{1109}\u{116B}\u{11B4}"),
    ("\u{C1D2}", "\u{C1D2}", "\u{1109}\u{116B}\u{11B5}", "\u{C1D2}", "\u{1109}\u{116B}\u{11B5}"),
    ("\u{C1D3}", "\u{C1D3}", "\u{1109}\u{116B}\u{11B6}", "\u{C1D3}", "\u{1109}\u{116B}\u{11B6}"),
    ("\u{C1D4}", "\u{C1D4}", "\u{1109}\u{116B}\u{11B7}", "\u{C1D4}", "\u{1109}\u{116B}\u{11B7}"),
    ("\u{C1D5}", "\u{C1D5}", "\u{1109}\u{116B}\u{11B8}", "\u{C1D5}", "\u{1109}\u{116B}\u{11B8}"),
    ("\u{C1D6}", "\u{C1D6}", "\u{1109}\u{116B}\u{11B9}", "\u{C1D6}", "\u{1109}\u{116B}\u{11B9}"),
    ("\u{C1D7}", "\u{C1D7}", "\u{1109}\u{116B}\u{11BA}", "\u{C1D7}", "\u{1109}\u{116B}\u{11BA}"),
    ("\u{C1D8}", "\u{C1D8}", "\u{1109}\u{116B}\u{11BB}", "\u{C1D8}", "\u{1109}\u{116B}\u{11BB}"),
    ("\u{C1D9}", "\u{C1D9}", "\u{1109}\u{116B}\u{11BC}", "\u{C1D9}", "\u{1109}\u{116B}\u{11BC}"),
    ("\u{C1DA}", "\u{C1DA}", "\u{1109}\u{116B}\u{11BD}", "\u{C1DA}", "\u{1109}\u{116B}\u{11BD}"),
    ("\u{C1DB}", "\u{C1DB}", "\u{1109}\u{116B}\u{11BE}", "\u{C1DB}", "\u{1109}\u{116B}\u{11BE}"),
    ("\u{C1DC}", "\u{C1DC}", "\u{1109}\u{116B}\u{11BF}", "\u{C1DC}", "\u{1109}\u{116B}\u{11BF}"),
    ("\u{C1DD}", "\u{C1DD}", "\u{1109}\u{116B}\u{11C0}", "\u{C1DD}", "\u{1109}\u{116B}\u{11C0}"),
    ("\u{C1DE}", "\u{C1DE}", "\u{1109}\u{116B}\u{11C1}", "\u{C1DE}", "\u{1109}\u{116B}\u{11C1}"),
    ("\u{C1DF}", "\u{C1DF}", "\u{1109}\u{116B}\u{11C2}", "\u{C1DF}", "\u{1109}\u{116B}\u{11C2}"),
    ("\u{C1E0}", "\u{C1E0}", "\u{1109}\u{116C}", "\u{C1E0}", "\u{1109}\u{116C}"),
    ("\u{C1E1}", "\u{C1E1}", "\u{1109}\u{116C}\u{11A8}", "\u{C1E1}", "\u{1109}\u{116C}\u{11A8}"),
    ("\u{C1E2}", "\u{C1E2}", "\u{1109}\u{116C}\u{11A9}", "\u{C1E2}", "\u{1109}\u{116C}\u{11A9}"),
    ("\u{C1E3}", "\u{C1E3}", "\u{1109}\u{116C}\u{11AA}", "\u{C1E3}", "\u{1109}\u{116C}\u{11AA}"),
    ("\u{C1E4}", "\u{C1E4}", "\u{1109}\u{116C}\u{11AB}", "\u{C1E4}", "\u{1109}\u{116C}\u{11AB}"),
    ("\u{C1E5}", "\u{C1E5}", "\u{1109}\u{116C}\u{11AC}", "\u{C1E5}", "\u{1109}\u{116C}\u{11AC}"),
    ("\u{C1E6}", "\u{C1E6}", "\u{1109}\u{116C}\u{11AD}", "\u{C1E6}", "\u{1109}\u{116C}\u{11AD}"),
    ("\u{C1E7}", "\u{C1E7}", "\u{1109}\u{116C}\u{11AE}", "\u{C1E7}", "\u{1109}\u{116C}\u{11AE}"),
    ("\u{C1E8}", "\u{C1E8}", "\u{1109}\u{116C}\u{11AF}", "\u{C1E8}", "\u{1109}\u{116C}\u{11AF}"),
    ("\u{C1E9}", "\u{C1E9}", "\u{1109}\u{116C}\u{11B0}", "\u{C1E9}", "\u{1109}\u{116C}\u{11B0}"),
    ("\u{C1EA}", "\u{C1EA}", "\u{1109}\u{116C}\u{11B1}", "\u{C1EA}", "\u{1109}\u{116C}\u{11B1}"),
    ("\u{C1EB}", "\u{C1EB}", "\u{1109}\u{116C}\u{11B2}", "\u{C1EB}", "\u{1109}\u{116C}\u{11B2}"),
    ("\u{C1EC}", "\u{C1EC}", "\u{1109}\u{116C}\u{11B3}", "\u{C1EC}", "\u{1109}\u{116C}\u{11B3}"),
    ("\u{C1ED}", "\u{C1ED}", "\u{1109}\u{116C}\u{11B4}", "\u{C1ED}", "\u{1109}\u{116C}\u{11B4}"),
    ("\u{C1EE}", "\u{C1EE}", "\u{1109}\u{116C}\u{11B5}", "\u{C1EE}", "\u{1109}\u{116C}\u{11B5}"),
    ("\u{C1EF}", "\u{C1EF}", "\u{1109}\u{116C}\u{11B6}", "\u{C1EF}", "\u{1109}\u{116C}\u{11B6}"),
    ("\u{C1F0}", "\u{C1F0}", "\u{1109}\u{116C}\u{11B7}", "\u{C1F0}", "\u{1109}\u{116C}\u{11B7}"),
    ("\u{C1F1}", "\u{C1F1}", "\u{1109}\u{116C}\u{11B8}", "\u{C1F1}", "\u{1109}\u{116C}\u{11B8}"),
    ("\u{C1F2}", "\u{C1F2}", "\u{1109}\u{116C}\u{11B9}", "\u{C1F2}", "\u{1109}\u{116C}\u{11B9}"),
    ("\u{C1F3}", "\u{C1F3}", "\u{1109}\u{116C}\u{11BA}", "\u{C1F3}", "\u{1109}\u{116C}\u{11BA}"),
    ("\u{C1F4}", "\u{C1F4}", "\u{1109}\u{116C}\u{11BB}", "\u{C1F4}", "\u{1109}\u{116C}\u{11BB}"),
    ("\u{C1F5}", "\u{C1F5}", "\u{1109}\u{116C}\u{11BC}", "\u{C1F5}", "\u{1109}\u{116C}\u{11BC}"),
    ("\u{C1F6}", "\u{C1F6}", "\u{1109}\u{116C}\u{11BD}", "\u{C1F6}", "\u{1109}\u{116C}\u{11BD}"),
    ("\u{C1F7}", "\u{C1F7}", "\u{1109}\u{116C}\u{11BE}", "\u{C1F7}", "\u{1109}\u{116C}\u{11BE}"),
    ("\u{C1F8}", "\u{C1F8}", "\u{1109}\u{116C}\u{11BF}", "\u{C1F8}", "\u{1109}\u{116C}\u{11BF}"),
    ("\u{C1F9}", "\u{C1F9}", "\u{1109}\u{116C}\u{11C0}", "\u{C1F9}", "\u{1109}\u{116C}\u{11C0}"),
    ("\u{C1FA}", "\u{C1FA}", "\u{1109}\u{116C}\u{11C1}", "\u{C1FA}", "\u{1109}\u{116C}\u{11C1}"),
    ("\u{C1FB}", "\u{C1FB}", "\u{1109}\u{116C}\u{11C2}", "\u{C1FB}", "\u{1109}\u{116C}\u{11C2}"),
    ("\u{C1FC}", "\u{C1FC}", "\u{1109}\u{116D}", "\u{C1FC}", "\u{1109}\u{116D}"),
    ("\u{C1FD}", "\u{C1FD}", "\u{1109}\u{116D}\u{11A8}", "\u{C1FD}", "\u{1109}\u{116D}\u{11A8}"),
    ("\u{C1FE}", "\u{C1FE}", "\u{1109}\u{116D}\u{11A9}", "\u{C1FE}", "\u{1109}\u{116D}\u{11A9}"),
    ("\u{C1FF}", "\u{C1FF}", "\u{1109}\u{116D}\u{11AA}", "\u{C1FF}", "\u{1109}\u{116D}\u{11AA}"),
    ("\u{C200}", "\u{C200}", "\u{1109}\u{116D}\u{11AB}", "\u{C200}", "\u{1109}\u{116D}\u{11AB}"),
    ("\u{C201}", "\u{C201}", "\u{1109}\u{116D}\u{11AC}", "\u{C201}", "\u{1109}\u{116D}\u{11AC}"),
    ("\u{C202}", "\u{C202}", "\u{1109}\u{116D}\u{11AD}", "\u{C202}", "\u{1109}\u{116D}\u{11AD}"),
    ("\u{C203}", "\u{C203}", "\u{1109}\u{116D}\u{11AE}", "\u{C203}", "\u{1109}\u{116D}\u{11AE}"),
    ("\u{C204}", "\u{C204}", "\u{1109}\u{116D}\u{11AF}", "\u{C204}", "\u{1109}\u{116D}\u{11AF}"),
    ("\u{C205}", "\u{C205}", "\u{1109}\u{116D}\u{11B0}", "\u{C205}", "\u{1109}\u{116D}\u{11B0}"),
    ("\u{C206}", "\u{C206}", "\u{1109}\u{116D}\u{11B1}", "\u{C206}", "\u{1109}\u{116D}\u{11B1}"),
    ("\u{C207}", "\u{C207}", "\u{1109}\u{116D}\u{11B2}", "\u{C207}", "\u{1109}\u{116D}\u{11B2}"),
    ("\u{C208}", "\u{C208}", "\u{1109}\u{116D}\u{11B3}", "\u{C208}", "\u{1109}\u{116D}\u{11B3}"),
    ("\u{C209}", "\u{C209}", "\u{1109}\u{116D}\u{11B4}", "\u{C209}", "\u{1109}\u{116D}\u{11B4}"),
    ("\u{C20A}", "\u{C20A}", "\u{1109}\u{116D}\u{11B5}", "\u{C20A}", "\u{1109}\u{116D}\u{11B5}"),
    ("\u{C20B}", "\u{C20B}", "\u{1109}\u{116D}\u{11B6}", "\u{C20B}", "\u{1109}\u{116D}\u{11B6}"),
    ("\u{C20C}", "\u{C20C}", "\u{1109}\u{116D}\u{11B7}", "\u{C20C}", "\u{1109}\u{116D}\u{11B7}"),
    ("\u{C20D}", "\u{C20D}", "\u{1109}\u{116D}\u{11B8}", "\u{C20D}", "\u{1109}\u{116D}\u{11B8}"),
    ("\u{C20E}", "\u{C20E}", "\u{1109}\u{116D}\u{11B9}", "\u{C20E}", "\u{1109}\u{116D}\u{11B9}"),
    ("\u{C20F}", "\u{C20F}", "\u{1109}\u{116D}\u{11BA}", "\u{C20F}", "\u{1109}\u{116D}\u{11BA}"),
    ("\u{C210}", "\u{C210}", "\u{1109}\u{116D}\u{11BB}", "\u{C210}", "\u{1109}\u{116D}\u{11BB}"),
    ("\u{C211}", "\u{C211}", "\u{1109}\u{116D}\u{11BC}", "\u{C211}", "\u{1109}\u{116D}\u{11BC}"),
    ("\u{C212}", "\u{C212}", "\u{1109}\u{116D}\u{11BD}", "\u{C212}", "\u{1109}\u{116D}\u{11BD}"),
    ("\u{C213}", "\u{C213}", "\u{1109}\u{116D}\u{11BE}", "\u{C213}", "\u{1109}\u{116D}\u{11BE}"),
    ("\u{C214}", "\u{C214}", "\u{1109}\u{116D}\u{11BF}", "\u{C214}", "\u{1109}\u{116D}\u{11BF}"),
    ("\u{C215}", "\u{C215}", "\u{1109}\u{116D}\u{11C0}", "\u{C215}", "\u{1109}\u{116D}\u{11C0}"),
    ("\u{C216}", "\u{C216}", "\u{1109}\u{116D}\u{11C1}", "\u{C216}", "\u{1109}\u{116D}\u{11C1}"),
    ("\u{C217}", "\u{C217}", "\u{1109}\u{116D}\u{11C2}", "\u{C217}", "\u{1109}\u{116D}\u{11C2}"),
    ("\u{C218}", "\u{C218}", "\u{1109}\u{116E}", "\u{C218}", "\u{1109}\u{116E}"),
    ("\u{C219}", "\u{C219}", "\u{1109}\u{116E}\u{11A8}", "\u{C219}", "\u{1109}\u{116E}\u{11A8}"),
    ("\u{C21A}", "\u{C21A}", "\u{1109}\u{116E}\u{11A9}", "\u{C21A}", "\u{1109}\u{116E}\u{11A9}"),
    ("\u{C21B}", "\u{C21B}", "\u{1109}\u{116E}\u{11AA}", "\u{C21B}", "\u{1109}\u{116E}\u{11AA}"),
    ("\u{C21C}", "\u{C21C}", "\u{1109}\u{116E}\u{11AB}", "\u{C21C}", "\u{1109}\u{116E}\u{11AB}"),
    ("\u{C21D}", "\u{C21D}", "\u{1109}\u{116E}\u{11AC}", "\u{C21D}", "\u{1109}\u{116E}\u{11AC}"),
    ("\u{C21E}", "\u{C21E}", "\u{1109}\u{116E}\u{11AD}", "\u{C21E}", "\u{1109}\u{116E}\u{11AD}"),
    ("\u{C21F}", "\u{C21F}", "\u{1109}\u{116E}\u{11AE}", "\u{C21F}", "\u{1109}\u{116E}\u{11AE}"),
    ("\u{C220}", "\u{C220}", "\u{1109}\u{116E}\u{11AF}", "\u{C220}", "\u{1109}\u{116E}\u{11AF}"),
    ("\u{C221}", "\u{C221}", "\u{1109}\u{116E}\u{11B0}", "\u{C221}", "\u{1109}\u{116E}\u{11B0}"),
    ("\u{C222}", "\u{C222}", "\u{1109}\u{116E}\u{11B1}", "\u{C222}", "\u{1109}\u{116E}\u{11B1}"),
    ("\u{C223}", "\u{C223}", "\u{1109}\u{116E}\u{11B2}", "\u{C223}", "\u{1109}\u{116E}\u{11B2}"),
    ("\u{C224}", "\u{C224}", "\u{1109}\u{116E}\u{11B3}", "\u{C224}", "\u{1109}\u{116E}\u{11B3}"),
    ("\u{C225}", "\u{C225}", "\u{1109}\u{116E}\u{11B4}", "\u{C225}", "\u{1109}\u{116E}\u{11B4}"),
    ("\u{C226}", "\u{C226}", "\u{1109}\u{116E}\u{11B5}", "\u{C226}", "\u{1109}\u{116E}\u{11B5}"),
    ("\u{C227}", "\u{C227}", "\u{1109}\u{116E}\u{11B6}", "\u{C227}", "\u{1109}\u{116E}\u{11B6}"),
    ("\u{C228}", "\u{C228}", "\u{1109}\u{116E}\u{11B7}", "\u{C228}", "\u{1109}\u{116E}\u{11B7}"),
    ("\u{C229}", "\u{C229}", "\u{1109}\u{116E}\u{11B8}", "\u{C229}", "\u{1109}\u{116E}\u{11B8}"),
    ("\u{C22A}", "\u{C22A}", "\u{1109}\u{116E}\u{11B9}", "\u{C22A}", "\u{1109}\u{116E}\u{11B9}"),
    ("\u{C22B}", "\u{C22B}", "\u{1109}\u{116E}\u{11BA}", "\u{C22B}", "\u{1109}\u{116E}\u{11BA}"),
    ("\u{C22C}", "\u{C22C}", "\u{1109}\u{116E}\u{11BB}", "\u{C22C}", "\u{1109}\u{116E}\u{11BB}"),
    ("\u{C22D}", "\u{C22D}", "\u{1109}\u{116E}\u{11BC}", "\u{C22D}", "\u{1109}\u{116E}\u{11BC}"),
    ("\u{C22E}", "\u{C22E}", "\u{1109}\u{116E}\u{11BD}", "\u{C22E}", "\u{1109}\u{116E}\u{11BD}"),
    ("\u{C22F}", "\u{C22F}", "\u{1109}\u{116E}\u{11BE}", "\u{C22F}", "\u{1109}\u{116E}\u{11BE}"),
    ("\u{C230}", "\u{C230}", "\u{1109}\u{116E}\u{11BF}", "\u{C230}", "\u{1109}\u{116E}\u{11BF}"),
    ("\u{C231}", "\u{C231}", "\u{1109}\u{116E}\u{11C0}", "\u{C231}", "\u{1109}\u{116E}\u{11C0}"),
    ("\u{C232}", "\u{C232}", "\u{1109}\u{116E}\u{11C1}", "\u{C232}", "\u{1109}\u{116E}\u{11C1}"),
    ("\u{C233}", "\u{C233}", "\u{1109}\u{116E}\u{11C2}", "\u{C233}", "\u{1109}\u{116E}\u{11C2}"),
    ("\u{C234}", "\u{C234}", "\u{1109}\u{116F}", "\u{C234}", "\u{1109}\u{116F}"),
    ("\u{C235}", "\u{C235}", "\u{1109}\u{116F}\u{11A8}", "\u{C235}", "\u{1109}\u{116F}\u{11A8}"),
    ("\u{C236}", "\u{C236}", "\u{1109}\u{116F}\u{11A9}", "\u{C236}", "\u{1109}\u{116F}\u{11A9}"),
    ("\u{C237}", "\u{C237}", "\u{1109}\u{116F}\u{11AA}", "\u{C237}", "\u{1109}\u{116F}\u{11AA}"),
    ("\u{C238}", "\u{C238}", "\u{1109}\u{116F}\u{11AB}", "\u{C238}", "\u{1109}\u{116F}\u{11AB}"),
    ("\u{C239}", "\u{C239}", "\u{1109}\u{116F}\u{11AC}", "\u{C239}", "\u{1109}\u{116F}\u{11AC}"),
    ("\u{C23A}", "\u{C23A}", "\u{1109}\u{116F}\u{11AD}", "\u{C23A}", "\u{1109}\u{116F}\u{11AD}"),
    ("\u{C23B}", "\u{C23B}", "\u{1109}\u{116F}\u{11AE}", "\u{C23B}", "\u{1109}\u{116F}\u{11AE}"),
    ("\u{C23C}", "\u{C23C}", "\u{1109}\u{116F}\u{11AF}", "\u{C23C}", "\u{1109}\u{116F}\u{11AF}"),
    ("\u{C23D}", "\u{C23D}", "\u{1109}\u{116F}\u{11B0}", "\u{C23D}", "\u{1109}\u{116F}\u{11B0}"),
    ("\u{C23E}", "\u{C23E}", "\u{1109}\u{116F}\u{11B1}", "\u{C23E}", "\u{1109}\u{116F}\u{11B1}"),
    ("\u{C23F}", "\u{C23F}", "\u{1109}\u{116F}\u{11B2}", "\u{C23F}", "\u{1109}\u{116F}\u{11B2}"),
    ("\u{C240}", "\u{C240}", "\u{1109}\u{116F}\u{11B3}", "\u{C240}", "\u{1109}\u{116F}\u{11B3}"),
    ("\u{C241}", "\u{C241}", "\u{1109}\u{116F}\u{11B4}", "\u{C241}", "\u{1109}\u{116F}\u{11B4}"),
    ("\u{C242}", "\u{C242}", "\u{1109}\u{116F}\u{11B5}", "\u{C242}", "\u{1109}\u{116F}\u{11B5}"),
    ("\u{C243}", "\u{C243}", "\u{1109}\u{116F}\u{11B6}", "\u{C243}", "\u{1109}\u{116F}\u{11B6}"),
    ("\u{C244}", "\u{C244}", "\u{1109}\u{116F}\u{11B7}", "\u{C244}", "\u{1109}\u{116F}\u{11B7}"),
    ("\u{C245}", "\u{C245}", "\u{1109}\u{116F}\u{11B8}", "\u{C245}", "\u{1109}\u{116F}\u{11B8}"),
    ("\u{C246}", "\u{C246}", "\u{1109}\u{116F}\u{11B9}", "\u{C246}", "\u{1109}\u{116F}\u{11B9}"),
    ("\u{C247}", "\u{C247}", "\u{1109}\u{116F}\u{11BA}", "\u{C247}", "\u{1109}\u{116F}\u{11BA}"),
    ("\u{C248}", "\u{C248}", "\u{1109}\u{116F}\u{11BB}", "\u{C248}", "\u{1109}\u{116F}\u{11BB}"),
    ("\u{C249}", "\u{C249}", "\u{1109}\u{116F}\u{11BC}", "\u{C249}", "\u{1109}\u{116F}\u{11BC}"),
    ("\u{C24A}", "\u{C24A}", "\u{1109}\u{116F}\u{11BD}", "\u{C24A}", "\u{1109}\u{116F}\u{11BD}"),
    ("\u{C24B}", "\u{C24B}", "\u{1109}\u{116F}\u{11BE}", "\u{C24B}", "\u{1109}\u{116F}\u{11BE}"),
    ("\u{C24C}", "\u{C24C}", "\u{1109}\u{116F}\u{11BF}", "\u{C24C}", "\u{1109}\u{116F}\u{11BF}"),
    ("\u{C24D}", "\u{C24D}", "\u{1109}\u{116F}\u{11C0}", "\u{C24D}", "\u{1109}\u{116F}\u{11C0}"),
    ("\u{C24E}", "\u{C24E}", "\u{1109}\u{116F}\u{11C1}", "\u{C24E}", "\u{1109}\u{116F}\u{11C1}"),
    ("\u{C24F}", "\u{C24F}", "\u{1109}\u{116F}\u{11C2}", "\u{C24F}", "\u{1109}\u{116F}\u{11C2}"),
    ("\u{C250}", "\u{C250}", "\u{1109}\u{1170}", "\u{C250}", "\u{1109}\u{1170}"),
    ("\u{C251}", "\u{C251}", "\u{1109}\u{1170}\u{11A8}", "\u{C251}", "\u{1109}\u{1170}\u{11A8}"),
    ("\u{C252}", "\u{C252}", "\u{1109}\u{1170}\u{11A9}", "\u{C252}", "\u{1109}\u{1170}\u{11A9}"),
    ("\u{C253}", "\u{C253}", "\u{1109}\u{1170}\u{11AA}", "\u{C253}", "\u{1109}\u{1170}\u{11AA}"),
    ("\u{C254}", "\u{C254}", "\u{1109}\u{1170}\u{11AB}", "\u{C254}", "\u{1109}\u{1170}\u{11AB}"),
    ("\u{C255}", "\u{C255}", "\u{1109}\u{1170}\u{11AC}", "\u{C255}", "\u{1109}\u{1170}\u{11AC}"),
    ("\u{C256}", "\u{C256}", "\u{1109}\u{1170}\u{11AD}", "\u{C256}", "\u{1109}\u{1170}\u{11AD}"),
    ("\u{C257}", "\u{C257}", "\u{1109}\u{1170}\u{11AE}", "\u{C257}", "\u{1109}\u{1170}\u{11AE}"),
    ("\u{C258}", "\u{C258}", "\u{1109}\u{1170}\u{11AF}", "\u{C258}", "\u{1109}\u{1170}\u{11AF}"),
    ("\u{C259}", "\u{C259}", "\u{1109}\u{1170}\u{11B0}", "\u{C259}", "\u{1109}\u{1170}\u{11B0}"),
    ("\u{C25A}", "\u{C25A}", "\u{1109}\u{1170}\u{11B1}", "\u{C25A}", "\u{1109}\u{1170}\u{11B1}"),
    ("\u{C25B}", "\u{C25B}", "\u{1109}\u{1170}\u{11B2}", "\u{C25B}", "\u{1109}\u{1170}\u{11B2}"),
    ("\u{C25C}", "\u{C25C}", "\u{1109}\u{1170}\u{11B3}", "\u{C25C}", "\u{1109}\u{1170}\u{11B3}"),
    ("\u{C25D}", "\u{C25D}", "\u{1109}\u{1170}\u{11B4}", "\u{C25D}", "\u{1109}\u{1170}\u{11B4}"),
    ("\u{C25E}", "\u{C25E}", "\u{1109}\u{1170}\u{11B5}", "\u{C25E}", "\u{1109}\u{1170}\u{11B5}"),
    ("\u{C25F}", "\u{C25F}", "\u{1109}\u{1170}\u{11B6}", "\u{C25F}", "\u{1109}\u{1170}\u{11B6}"),
    ("\u{C260}", "\u{C260}", "\u{1109}\u{1170}\u{11B7}", "\u{C260}", "\u{1109}\u{1170}\u{11B7}"),
    ("\u{C261}", "\u{C261}", "\u{1109}\u{1170}\u{11B8}", "\u{C261}", "\u{1109}\u{1170}\u{11B8}"),
    ("\u{C262}", "\u{C262}", "\u{1109}\u{1170}\u{11B9}", "\u{C262}", "\u{1109}\u{1170}\u{11B9}"),
    ("\u{C263}", "\u{C263}", "\u{1109}\u{1170}\u{11BA}", "\u{C263}", "\u{1109}\u{1170}\u{11BA}"),
    ("\u{C264}", "\u{C264}", "\u{1109}\u{1170}\u{11BB}", "\u{C264}", "\u{1109}\u{1170}\u{11BB}"),
    ("\u{C265}", "\u{C265}", "\u{1109}\u{1170}\u{11BC}", "\u{C265}", "\u{1109}\u{1170}\u{11BC}"),
    ("\u{C266}", "\u{C266}", "\u{1109}\u{1170}\u{11BD}", "\u{C266}", "\u{1109}\u{1170}\u{11BD}"),
    ("\u{C267}", "\u{C267}", "\u{1109}\u{1170}\u{11BE}", "\u{C267}", "\u{1109}\u{1170}\u{11BE}"),
    ("\u{C268}", "\u{C268}", "\u{1109}\u{1170}\u{11BF}", "\u{C268}", "\u{1109}\u{1170}\u{11BF}"),
    ("\u{C269}", "\u{C269}", "\u{1109}\u{1170}\u{11C0}", "\u{C269}", "\u{1109}\u{1170}\u{11C0}"),
    ("\u{C26A}", "\u{C26A}", "\u{1109}\u{1170}\u{11C1}", "\u{C26A}", "\u{1109}\u{1170}\u{11C1}"),
    ("\u{C26B}", "\u{C26B}", "\u{1109}\u{1170}\u{11C2}", "\u{C26B}", "\u{1109}\u{1170}\u{11C2}"),
    ("\u{C26C}", "\u{C26C}", "\u{1109}\u{1171}", "\u{C26C}", "\u{1109}\u{1171}"),
    ("\u{C26D}", "\u{C26D}", "\u{1109}\u{1171}\u{11A8}", "\u{C26D}", "\u{1109}\u{1171}\u{11A8}"),
    ("\u{C26E}", "\u{C26E}", "\u{1109}\u{1171}\u{11A9}", "\u{C26E}", "\u{1109}\u{1171}\u{11A9}"),
    ("\u{C26F}", "\u{C26F}", "\u{1109}\u{1171}\u{11AA}", "\u{C26F}", "\u{1109}\u{1171}\u{11AA}"),
    ("\u{C270}", "\u{C270}", "\u{1109}\u{1171}\u{11AB}", "\u{C270}", "\u{1109}\u{1171}\u{11AB}"),
    ("\u{C271}", "\u{C271}", "\u{1109}\u{1171}\u{11AC}", "\u{C271}", "\u{1109}\u{1171}\u{11AC}"),
    ("\u{C272}", "\u{C272}", "\u{1109}\u{1171}\u{11AD}", "\u{C272}", "\u{1109}\u{1171}\u{11AD}"),
    ("\u{C273}", "\u{C273}", "\u{1109}\u{1171}\u{11AE}", "\u{C273}", "\u{1109}\u{1171}\u{11AE}"),
    ("\u{C274}", "\u{C274}", "\u{1109}\u{1171}\u{11AF}", "\u{C274}", "\u{1109}\u{1171}\u{11AF}"),
    ("\u{C275}", "\u{C275}", "\u{1109}\u{1171}\u{11B0}", "\u{C275}", "\u{1109}\u{1171}\u{11B0}"),
    ("\u{C276}", "\u{C276}", "\u{1109}\u{1171}\u{11B1}", "\u{C276}", "\u{1109}\u{1171}\u{11B1}"),
    ("\u{C277}", "\u{C277}", "\u{1109}\u{1171}\u{11B2}", "\u{C277}", "\u{1109}\u{1171}\u{11B2}"),
    ("\u{C278}", "\u{C278}", "\u{1109}\u{1171}\u{11B3}", "\u{C278}", "\u{1109}\u{1171}\u{11B3}"),
    ("\u{C279}", "\u{C279}", "\u{1109}\u{1171}\u{11B4}", "\u{C279}", "\u{1109}\u{1171}\u{11B4}"),
    ("\u{C27A}", "\u{C27A}", "\u{1109}\u{1171}\u{11B5}", "\u{C27A}", "\u{1109}\u{1171}\u{11B5}"),
    ("\u{C27B}", "\u{C27B}", "\u{1109}\u{1171}\u{11B6}", "\u{C27B}", "\u{1109}\u{1171}\u{11B6}"),
    ("\u{C27C}", "\u{C27C}", "\u{1109}\u{1171}\u{11B7}", "\u{C27C}", "\u{1109}\u{1171}\u{11B7}"),
    ("\u{C27D}", "\u{C27D}", "\u{1109}\u{1171}\u{11B8}", "\u{C27D}", "\u{1109}\u{1171}\u{11B8}"),
    ("\u{C27E}", "\u{C27E}", "\u{1109}\u{1171}\u{11B9}", "\u{C27E}", "\u{1109}\u{1171}\u{11B9}"),
    ("\u{C27F}", "\u{C27F}", "\u{1109}\u{1171}\u{11BA}", "\u{C27F}", "\u{1109}\u{1171}\u{11BA}"),
    ("\u{C280}", "\u{C280}", "\u{1109}\u{1171}\u{11BB}", "\u{C280}", "\u{1109}\u{1171}\u{11BB}"),
    ("\u{C281}", "\u{C281}", "\u{1109}\u{1171}\u{11BC}", "\u{C281}", "\u{1109}\u{1171}\u{11BC}"),
    ("\u{C282}", "\u{C282}", "\u{1109}\u{1171}\u{11BD}", "\u{C282}", "\u{1109}\u{1171}\u{11BD}"),
    ("\u{C283}", "\u{C283}", "\u{1109}\u{1171}\u{11BE}", "\u{C283}", "\u{1109}\u{1171}\u{11BE}"),
    ("\u{C284}", "\u{C284}", "\u{1109}\u{1171}\u{11BF}", "\u{C284}", "\u{1109}\u{1171}\u{11BF}"),
    ("\u{C285}", "\u{C285}", "\u{1109}\u{1171}\u{11C0}", "\u{C285}", "\u{1109}\u{1171}\u{11C0}"),
    ("\u{C286}", "\u{C286}", "\u{1109}\u{1171}\u{11C1}", "\u{C286}", "\u{1109}\u{1171}\u{11C1}"),
    ("\u{C287}", "\u{C287}", "\u{1109}\u{1171}\u{11C2}", "\u{C287}", "\u{1109}\u{1171}\u{11C2}"),
    ("\u{C288}", "\u{C288}", "\u{1109}\u{1172}", "\u{C288}", "\u{1109}\u{1172}"),
    ("\u{C289}", "\u{C289}", "\u{1109}\u{1172}\u{11A8}", "\u{C289}", "\u{1109}\u{1172}\u{11A8}"),
    ("\u{C28A}", "\u{C28A}", "\u{1109}\u{1172}\u{11A9}", "\u{C28A}", "\u{1109}\u{1172}\u{11A9}"),
    ("\u{C28B}", "\u{C28B}", "\u{1109}\u{1172}\u{11AA}", "\u{C28B}", "\u{1109}\u{1172}\u{11AA}"),
    ("\u{C28C}", "\u{C28C}", "\u{1109}\u{1172}\u{11AB}", "\u{C28C}", "\u{1109}\u{1172}\u{11AB}"),
    ("\u{C28D}", "\u{C28D}", "\u{1109}\u{1172}\u{11AC}", "\u{C28D}", "\u{1109}\u{1172}\u{11AC}"),
    ("\u{C28E}", "\u{C28E}", "\u{1109}\u{1172}\u{11AD}", "\u{C28E}", "\u{1109}\u{1172}\u{11AD}"),
    ("\u{C28F}", "\u{C28F}", "\u{1109}\u{1172}\u{11AE}", "\u{C28F}", "\u{1109}\u{1172}\u{11AE}"),
    ("\u{C290}", "\u{C290}", "\u{1109}\u{1172}\u{11AF}", "\u{C290}", "\u{1109}\u{1172}\u{11AF}"),
    ("\u{C291}", "\u{C291}", "\u{1109}\u{1172}\u{11B0}", "\u{C291}", "\u{1109}\u{1172}\u{11B0}"),
    ("\u{C292}", "\u{C292}", "\u{1109}\u{1172}\u{11B1}", "\u{C292}", "\u{1109}\u{1172}\u{11B1}"),
    ("\u{C293}", "\u{C293}", "\u{1109}\u{1172}\u{11B2}", "\u{C293}", "\u{1109}\u{1172}\u{11B2}"),
    ("\u{C294}", "\u{C294}", "\u{1109}\u{1172}\u{11B3}", "\u{C294}", "\u{1109}\u{1172}\u{11B3}"),
    ("\u{C295}", "\u{C295}", "\u{1109}\u{1172}\u{11B4}", "\u{C295}", "\u{1109}\u{1172}\u{11B4}"),
    ("\u{C296}", "\u{C296}", "\u{1109}\u{1172}\u{11B5}", "\u{C296}", "\u{1109}\u{1172}\u{11B5}"),
    ("\u{C297}", "\u{C297}", "\u{1109}\u{1172}\u{11B6}", "\u{C297}", "\u{1109}\u{1172}\u{11B6}"),
    ("\u{C298}", "\u{C298}", "\u{1109}\u{1172}\u{11B7}", "\u{C298}", "\u{1109}\u{1172}\u{11B7}"),
    ("\u{C299}", "\u{C299}", "\u{1109}\u{1172}\u{11B8}", "\u{C299}", "\u{1109}\u{1172}\u{11B8}"),
    ("\u{C29A}", "\u{C29A}", "\u{1109}\u{1172}\u{11B9}", "\u{C29A}", "\u{1109}\u{1172}\u{11B9}"),
    ("\u{C29B}", "\u{C29B}", "\u{1109}\u{1172}\u{11BA}", "\u{C29B}", "\u{1109}\u{1172}\u{11BA}"),
    ("\u{C29C}", "\u{C29C}", "\u{1109}\u{1172}\u{11BB}", "\u{C29C}", "\u{1109}\u{1172}\u{11BB}"),
    ("\u{C29D}", "\u{C29D}", "\u{1109}\u{1172}\u{11BC}", "\u{C29D}", "\u{1109}\u{1172}\u{11BC}"),
    ("\u{C29E}", "\u{C29E}", "\u{1109}\u{1172}\u{11BD}", "\u{C29E}", "\u{1109}\u{1172}\u{11BD}"),
    ("\u{C29F}", "\u{C29F}", "\u{1109}\u{1172}\u{11BE}", "\u{C29F}", "\u{1109}\u{1172}\u{11BE}"),
    ("\u{C2A0}", "\u{C2A0}", "\u{1109}\u{1172}\u{11BF}", "\u{C2A0}", "\u{1109}\u{1172}\u{11BF}"),
    ("\u{C2A1}", "\u{C2A1}", "\u{1109}\u{1172}\u{11C0}", "\u{C2A1}", "\u{1109}\u{1172}\u{11C0}"),
    ("\u{C2A2}", "\u{C2A2}", "\u{1109}\u{1172}\u{11C1}", "\u{C2A2}", "\u{1109}\u{1172}\u{11C1}"),
    ("\u{C2A3}", "\u{C2A3}", "\u{1109}\u{1172}\u{11C2}", "\u{C2A3}", "\u{1109}\u{1172}\u{11C2}"),
    ("\u{C2A4}", "\u{C2A4}", "\u{1109}\u{1173}", "\u{C2A4}", "\u{1109}\u{1173}"),
    ("\u{C2A5}", "\u{C2A5}", "\u{1109}\u{1173}\u{11A8}", "\u{C2A5}", "\u{1109}\u{1173}\u{11A8}"),
    ("\u{C2A6}", "\u{C2A6}", "\u{1109}\u{1173}\u{11A9}", "\u{C2A6}", "\u{1109}\u{1173}\u{11A9}"),
    ("\u{C2A7}", "\u{C2A7}", "\u{1109}\u{1173}\u{11AA}", "\u{C2A7}", "\u{1109}\u{1173}\u{11AA}"),
    ("\u{C2A8}", "\u{C2A8}", "\u{1109}\u{1173}\u{11AB}", "\u{C2A8}", "\u{1109}\u{1173}\u{11AB}"),
    ("\u{C2A9}", "\u{C2A9}", "\u{1109}\u{1173}\u{11AC}", "\u{C2A9}", "\u{1109}\u{1173}\u{11AC}"),
    ("\u{C2AA}", "\u{C2AA}", "\u{1109}\u{1173}\u{11AD}", "\u{C2AA}", "\u{1109}\u{1173}\u{11AD}"),
    ("\u{C2AB}", "\u{C2AB}", "\u{1109}\u{1173}\u{11AE}", "\u{C2AB}", "\u{1109}\u{1173}\u{11AE}"),
    ("\u{C2AC}", "\u{C2AC}", "\u{1109}\u{1173}\u{11AF}", "\u{C2AC}", "\u{1109}\u{1173}\u{11AF}"),
    ("\u{C2AD}", "\u{C2AD}", "\u{1109}\u{1173}\u{11B0}", "\u{C2AD}", "\u{1109}\u{1173}\u{11B0}"),
    ("\u{C2AE}", "\u{C2AE}", "\u{1109}\u{1173}\u{11B1}", "\u{C2AE}", "\u{1109}\u{1173}\u{11B1}"),
    ("\u{C2AF}", "\u{C2AF}", "\u{1109}\u{1173}\u{11B2}", "\u{C2AF}", "\u{1109}\u{1173}\u{11B2}"),
    ("\u{C2B0}", "\u{C2B0}", "\u{1109}\u{1173}\u{11B3}", "\u{C2B0}", "\u{1109}\u{1173}\u{11B3}"),
    ("\u{C2B1}", "\u{C2B1}", "\u{1109}\u{1173}\u{11B4}", "\u{C2B1}", "\u{1109}\u{1173}\u{11B4}"),
    ("\u{C2B2}", "\u{C2B2}", "\u{1109}\u{1173}\u{11B5}", "\u{C2B2}", "\u{1109}\u{1173}\u{11B5}"),
    ("\u{C2B3}", "\u{C2B3}", "\u{1109}\u{1173}\u{11B6}", "\u{C2B3}", "\u{1109}\u{1173}\u{11B6}"),
    ("\u{C2B4}", "\u{C2B4}", "\u{1109}\u{1173}\u{11B7}", "\u{C2B4}", "\u{1109}\u{1173}\u{11B7}"),
    ("\u{C2B5}", "\u{C2B5}", "\u{1109}\u{1173}\u{11B8}", "\u{C2B5}", "\u{1109}\u{1173}\u{11B8}"),
    ("\u{C2B6}", "\u{C2B6}", "\u{1109}\u{1173}\u{11B9}", "\u{C2B6}", "\u{1109}\u{1173}\u{11B9}"),
    ("\u{C2B7}", "\u{C2B7}", "\u{1109}\u{1173}\u{11BA}", "\u{C2B7}", "\u{1109}\u{1173}\u{11BA}"),
    ("\u{C2B8}", "\u{C2B8}", "\u{1109}\u{1173}\u{11BB}", "\u{C2B8}", "\u{1109}\u{1173}\u{11BB}"),
    ("\u{C2B9}", "\u{C2B9}", "\u{1109}\u{1173}\u{11BC}", "\u{C2B9}", "\u{1109}\u{1173}\u{11BC}"),
    ("\u{C2BA}", "\u{C2BA}", "\u{1109}\u{1173}\u{11BD}", "\u{C2BA}", "\u{1109}\u{1173}\u{11BD}"),
    ("\u{C2BB}", "\u{C2BB}", "\u{1109}\u{1173}\u{11BE}", "\u{C2BB}", "\u{1109}\u{1173}\u{11BE}"),
    ("\u{C2BC}", "\u{C2BC}", "\u{1109}\u{1173}\u{11BF}", "\u{C2BC}", "\u{1109}\u{1173}\u{11BF}"),
    ("\u{C2BD}", "\u{C2BD}", "\u{1109}\u{1173}\u{11C0}", "\u{C2BD}", "\u{1109}\u{1173}\u{11C0}"),
    ("\u{C2BE}", "\u{C2BE}", "\u{1109}\u{1173}\u{11C1}", "\u{C2BE}", "\u{1109}\u{1173}\u{11C1}"),
    ("\u{C2BF}", "\u{C2BF}", "\u{1109}\u{1173}\u{11C2}", "\u{C2BF}", "\u{1109}\u{1173}\u{11C2}"),
    ("\u{C2C0}", "\u{C2C0}", "\u{1109}\u{1174}", "\u{C2C0}", "\u{1109}\u{1174}"),
    ("\u{C2C1}", "\u{C2C1}", "\u{1109}\u{1174}\u{11A8}", "\u{C2C1}", "\u{1109}\u{1174}\u{11A8}"),
    ("\u{C2C2}", "\u{C2C2}", "\u{1109}\u{1174}\u{11A9}", "\u{C2C2}", "\u{1109}\u{1174}\u{11A9}"),
    ("\u{C2C3}", "\u{C2C3}", "\u{1109}\u{1174}\u{11AA}", "\u{C2C3}", "\u{1109}\u{1174}\u{11AA}"),
    ("\u{C2C4}", "\u{C2C4}", "\u{1109}\u{1174}\u{11AB}", "\u{C2C4}", "\u{1109}\u{1174}\u{11AB}"),
    ("\u{C2C5}", "\u{C2C5}", "\u{1109}\u{1174}\u{11AC}", "\u{C2C5}", "\u{1109}\u{1174}\u{11AC}"),
    ("\u{C2C6}", "\u{C2C6}", "\u{1109}\u{1174}\u{11AD}", "\u{C2C6}", "\u{1109}\u{1174}\u{11AD}"),
    ("\u{C2C7}", "\u{C2C7}", "\u{1109}\u{1174}\u{11AE}", "\u{C2C7}", "\u{1109}\u{1174}\u{11AE}"),
    ("\u{C2C8}", "\u{C2C8}", "\u{1109}\u{1174}\u{11AF}", "\u{C2C8}", "\u{1109}\u{1174}\u{11AF}"),
    ("\u{C2C9}", "\u{C2C9}", "\u{1109}\u{1174}\u{11B0}", "\u{C2C9}", "\u{1109}\u{1174}\u{11B0}"),
    ("\u{C2CA}", "\u{C2CA}", "\u{1109}\u{1174}\u{11B1}", "\u{C2CA}", "\u{1109}\u{1174}\u{11B1}"),
    ("\u{C2CB}", "\u{C2CB}", "\u{1109}\u{1174}\u{11B2}", "\u{C2CB}", "\u{1109}\u{1174}\u{11B2}"),
    ("\u{C2CC}", "\u{C2CC}", "\u{1109}\u{1174}\u{11B3}", "\u{C2CC}", "\u{1109}\u{1174}\u{11B3}"),
    ("\u{C2CD}", "\u{C2CD}", "\u{1109}\u{1174}\u{11B4}", "\u{C2CD}", "\u{1109}\u{1174}\u{11B4}"),
    ("\u{C2CE}", "\u{C2CE}", "\u{1109}\u{1174}\u{11B5}", "\u{C2CE}", "\u{1109}\u{1174}\u{11B5}"),
    ("\u{C2CF}", "\u{C2CF}", "\u{1109}\u{1174}\u{11B6}", "\u{C2CF}", "\u{1109}\u{1174}\u{11B6}"),
    ("\u{C2D0}", "\u{C2D0}", "\u{1109}\u{1174}\u{11B7}", "\u{C2D0}", "\u{1109}\u{1174}\u{11B7}"),
    ("\u{C2D1}", "\u{C2D1}", "\u{1109}\u{1174}\u{11B8}", "\u{C2D1}", "\u{1109}\u{1174}\u{11B8}"),
    ("\u{C2D2}", "\u{C2D2}", "\u{1109}\u{1174}\u{11B9}", "\u{C2D2}", "\u{1109}\u{1174}\u{11B9}"),
    ("\u{C2D3}", "\u{C2D3}", "\u{1109}\u{1174}\u{11BA}", "\u{C2D3}", "\u{1109}\u{1174}\u{11BA}"),
    ("\u{C2D4}", "\u{C2D4}", "\u{1109}\u{1174}\u{11BB}", "\u{C2D4}", "\u{1109}\u{1174}\u{11BB}"),
    ("\u{C2D5}", "\u{C2D5}", "\u{1109}\u{1174}\u{11BC}", "\u{C2D5}", "\u{1109}\u{1174}\u{11BC}"),
    ("\u{C2D6}", "\u{C2D6}", "\u{1109}\u{1174}\u{11BD}", "\u{C2D6}", "\u{1109}\u{1174}\u{11BD}"),
    ("\u{C2D7}", "\u{C2D7}", "\u{1109}\u{1174}\u{11BE}", "\u{C2D7}", "\u{1109}\u{1174}\u{11BE}"),
    ("\u{C2D8}", "\u{C2D8}", "\u{1109}\u{1174}\u{11BF}", "\u{C2D8}", "\u{1109}\u{1174}\u{11BF}"),
    ("\u{C2D9}", "\u{C2D9}", "\u{1109}\u{1174}\u{11C0}", "\u{C2D9}", "\u{1109}\u{1174}\u{11C0}"),
    ("\u{C2DA}", "\u{C2DA}", "\u{1109}\u{1174}\u{11C1}", "\u{C2DA}", "\u{1109}\u{1174}\u{11C1}"),
    ("\u{C2DB}", "\u{C2DB}", "\u{1109}\u{1174}\u{11C2}", "\u{C2DB}", "\u{1109}\u{1174}\u{11C2}"),
    ("\u{C2DC}", "\u{C2DC}", "\u{1109}\u{1175}", "\u{C2DC}", "\u{1109}\u{1175}"),
    ("\u{C2DD}", "\u{C2DD}", "\u{1109}\u{1175}\u{11A8}", "\u{C2DD}", "\u{1109}\u{1175}\u{11A8}"),
    ("\u{C2DE}", "\u{C2DE}", "\u{1109}\u{1175}\u{11A9}", "\u{C2DE}", "\u{1109}\u{1175}\u{11A9}"),
    ("\u{C2DF}", "\u{C2DF}", "\u{1109}\u{1175}\u{11AA}", "\u{C2DF}", "\u{1109}\u{1175}\u{11AA}"),
    ("\u{C2E0}", "\u{C2E0}", "\u{1109}\u{1175}\u{11AB}", "\u{C2E0}", "\u{1109}\u{1175}\u{11AB}"),
    ("\u{C2E1}", "\u{C2E1}", "\u{1109}\u{1175}\u{11AC}", "\u{C2E1}", "\u{1109}\u{1175}\u{11AC}"),
    ("\u{C2E2}", "\u{C2E2}", "\u{1109}\u{1175}\u{11AD}", "\u{C2E2}", "\u{1109}\u{1175}\u{11AD}"),
    ("\u{C2E3}", "\u{C2E3}", "\u{1109}\u{1175}\u{11AE}", "\u{C2E3}", "\u{1109}\u{1175}\u{11AE}"),
    ("\u{C2E4}", "\u{C2E4}", "\u{1109}\u{1175}\u{11AF}", "\u{C2E4}", "\u{1109}\u{1175}\u{11AF}"),
    ("\u{C2E5}", "\u{C2E5}", "\u{1109}\u{1175}\u{11B0}", "\u{C2E5}", "\u{1109}\u{1175}\u{11B0}"),
    ("\u{C2E6}", "\u{C2E6}", "\u{1109}\u{1175}\u{11B1}", "\u{C2E6}", "\u{1109}\u{1175}\u{11B1}"),
    ("\u{C2E7}", "\u{C2E7}", "\u{1109}\u{1175}\u{11B2}", "\u{C2E7}", "\u{1109}\u{1175}\u{11B2}"),
    ("\u{C2E8}", "\u{C2E8}", "\u{1109}\u{1175}\u{11B3}", "\u{C2E8}", "\u{1109}\u{1175}\u{11B3}"),
    ("\u{C2E9}", "\u{C2E9}", "\u{1109}\u{1175}\u{11B4}", "\u{C2E9}", "\u{1109}\u{1175}\u{11B4}"),
    ("\u{C2EA}", "\u{C2EA}", "\u{1109}\u{1175}\u{11B5}", "\u{C2EA}", "\u{1109}\u{1175}\u{11B5}"),
    ("\u{C2EB}", "\u{C2EB}", "\u{1109}\u{1175}\u{11B6}", "\u{C2EB}", "\u{1109}\u{1175}\u{11B6}"),
    ("\u{C2EC}", "\u{C2EC}", "\u{1109}\u{1175}\u{11B7}", "\u{C2EC}", "\u{1109}\u{1175}\u{11B7}"),
    ("\u{C2ED}", "\u{C2ED}", "\u{1109}\u{1175}\u{11B8}", "\u{C2ED}", "\u{1109}\u{1175}\u{11B8}"),
    ("\u{C2EE}", "\u{C2EE}", "\u{1109}\u{1175}\u{11B9}", "\u{C2EE}", "\u{1109}\u{1175}\u{11B9}"),
    ("\u{C2EF}", "\u{C2EF}", "\u{1109}\u{1175}\u{11BA}", "\u{C2EF}", "\u{1109}\u{1175}\u{11BA}"),
    ("\u{C2F0}", "\u{C2F0}", "\u{1109}\u{1175}\u{11BB}", "\u{C2F0}", "\u{1109}\u{1175}\u{11BB}"),
    ("\u{C2F1}", "\u{C2F1}", "\u{1109}\u{1175}\u{11BC}", "\u{C2F1}", "\u{1109}\u{1175}\u{11BC}"),
    ("\u{C2F2}", "\u{C2F2}", "\u{1109}\u{1175}\u{11BD}", "\u{C2F2}", "\u{1109}\u{1175}\u{11BD}"),
    ("\u{C2F3}", "\u{C2F3}", "\u{1109}\u{1175}\u{11BE}", "\u{C2F3}", "\u{1109}\u{1175}\u{11BE}"),
    ("\u{C2F4}", "\u{C2F4}", "\u{1109}\u{1175}\u{11BF}", "\u{C2F4}", "\u{1109}\u{1175}\u{11BF}"),
    ("\u{C2F5}", "\u{C2F5}", "\u{1109}\u{1175}\u{11C0}", "\u{C2F5}", "\u{1109}\u{1175}\u{11C0}"),
    ("\u{C2F6}", "\u{C2F6}", "\u{1109}\u{1175}\u{11C1}", "\u{C2F6}", "\u{1109}\u{1175}\u{11C1}"),
    ("\u{C2F7}", "\u{C2F7}", "\u{1109}\u{1175}\u{11C2}", "\u{C2F7}", "\u{1109}\u{1175}\u{11C2}"),
    ("\u{C2F8}", "\u{C2F8}", "\u{110A}\u{1161}", "\u{C2F8}", "\u{110A}\u{1161}"),
    ("\u{C2F9}", "\u{C2F9}", "\u{110A}\u{1161}\u{11A8}", "\u{C2F9}", "\u{110A}\u{1161}\u{11A8}"),
    ("\u{C2FA}", "\u{C2FA}", "\u{110A}\u{1161}\u{11A9}", "\u{C2FA}", "\u{110A}\u{1161}\u{11A9}"),
    ("\u{C2FB}", "\u{C2FB}", "\u{110A}\u{1161}\u{11AA}", "\u{C2FB}", "\u{110A}\u{1161}\u{11AA}"),
    ("\u{C2FC}", "\u{C2FC}", "\u{110A}\u{1161}\u{11AB}", "\u{C2FC}", "\u{110A}\u{1161}\u{11AB}"),
    ("\u{C2FD}", "\u{C2FD}", "\u{110A}\u{1161}\u{11AC}", "\u{C2FD}", "\u{110A}\u{1161}\u{11AC}"),
    ("\u{C2FE}", "\u{C2FE}", "\u{110A}\u{1161}\u{11AD}", "\u{C2FE}", "\u{110A}\u{1161}\u{11AD}"),
    ("\u{C2FF}", "\u{C2FF}", "\u{110A}\u{1161}\u{11AE}", "\u{C2FF}", "\u{110A}\u{1161}\u{11AE}"),
    ("\u{C300}", "\u{C300}", "\u{110A}\u{1161}\u{11AF}", "\u{C300}", "\u{110A}\u{1161}\u{11AF}"),
    ("\u{C301}", "\u{C301}", "\u{110A}\u{1161}\u{11B0}", "\u{C301}", "\u{110A}\u{1161}\u{11B0}"),
    ("\u{C302}", "\u{C302}", "\u{110A}\u{1161}\u{11B1}", "\u{C302}", "\u{110A}\u{1161}\u{11B1}"),
    ("\u{C303}", "\u{C303}", "\u{110A}\u{1161}\u{11B2}", "\u{C303}", "\u{110A}\u{1161}\u{11B2}"),
    ("\u{C304}", "\u{C304}", "\u{110A}\u{1161}\u{11B3}", "\u{C304}", "\u{110A}\u{1161}\u{11B3}"),
    ("\u{C305}", "\u{C305}", "\u{110A}\u{1161}\u{11B4}", "\u{C305}", "\u{110A}\u{1161}\u{11B4}"),
    ("\u{C306}", "\u{C306}", "\u{110A}\u{1161}\u{11B5}", "\u{C306}", "\u{110A}\u{1161}\u{11B5}"),
    ("\u{C307}", "\u{C307}", "\u{110A}\u{1161}\u{11B6}", "\u{C307}", "\u{110A}\u{1161}\u{11B6}"),
    ("\u{C308}", "\u{C308}", "\u{110A}\u{1161}\u{11B7}", "\u{C308}", "\u{110A}\u{1161}\u{11B7}"),
    ("\u{C309}", "\u{C309}", "\u{110A}\u{1161}\u{11B8}", "\u{C309}", "\u{110A}\u{1161}\u{11B8}"),
    ("\u{C30A}", "\u{C30A}", "\u{110A}\u{1161}\u{11B9}", "\u{C30A}", "\u{110A}\u{1161}\u{11B9}"),
    ("\u{C30B}", "\u{C30B}", "\u{110A}\u{1161}\u{11BA}", "\u{C30B}", "\u{110A}\u{1161}\u{11BA}"),
    ("\u{C30C}", "\u{C30C}", "\u{110A}\u{1161}\u{11BB}", "\u{C30C}", "\u{110A}\u{1161}\u{11BB}"),
    ("\u{C30D}", "\u{C30D}", "\u{110A}\u{1161}\u{11BC}", "\u{C30D}", "\u{110A}\u{1161}\u{11BC}"),
    ("\u{C30E}", "\u{C30E}", "\u{110A}\u{1161}\u{11BD}", "\u{C30E}", "\u{110A}\u{1161}\u{11BD}"),
    ("\u{C30F}", "\u{C30F}", "\u{110A}\u{1161}\u{11BE}", "\u{C30F}", "\u{110A}\u{1161}\u{11BE}"),
    ("\u{C310}", "\u{C310}", "\u{110A}\u{1161}\u{11BF}", "\u{C310}", "\u{110A}\u{1161}\u{11BF}"),
    ("\u{C311}", "\u{C311}", "\u{110A}\u{1161}\u{11C0}", "\u{C311}", "\u{110A}\u{1161}\u{11C0}"),
    ("\u{C312}", "\u{C312}", "\u{110A}\u{1161}\u{11C1}", "\u{C312}", "\u{110A}\u{1161}\u{11C1}"),
    ("\u{C313}", "\u{C313}", "\u{110A}\u{1161}\u{11C2}", "\u{C313}", "\u{110A}\u{1161}\u{11C2}"),
    ("\u{C314}", "\u{C314}", "\u{110A}\u{1162}", "\u{C314}", "\u{110A}\u{1162}"),
    ("\u{C315}", "\u{C315}", "\u{110A}\u{1162}\u{11A8}", "\u{C315}", "\u{110A}\u{1162}\u{11A8}"),
    ("\u{C316}", "\u{C316}", "\u{110A}\u{1162}\u{11A9}", "\u{C316}", "\u{110A}\u{1162}\u{11A9}"),
    ("\u{C317}", "\u{C317}", "\u{110A}\u{1162}\u{11AA}", "\u{C317}", "\u{110A}\u{1162}\u{11AA}"),
    ("\u{C318}", "\u{C318}", "\u{110A}\u{1162}\u{11AB}", "\u{C318}", "\u{110A}\u{1162}\u{11AB}"),
    ("\u{C319}", "\u{C319}", "\u{110A}\u{1162}\u{11AC}", "\u{C319}", "\u{110A}\u{1162}\u{11AC}"),
    ("\u{C31A}", "\u{C31A}", "\u{110A}\u{1162}\u{11AD}", "\u{C31A}", "\u{110A}\u{1162}\u{11AD}"),
    ("\u{C31B}", "\u{C31B}", "\u{110A}\u{1162}\u{11AE}", "\u{C31B}", "\u{110A}\u{1162}\u{11AE}"),
    ("\u{C31C}", "\u{C31C}", "\u{110A}\u{1162}\u{11AF}", "\u{C31C}", "\u{110A}\u{1162}\u{11AF}"),
    ("\u{C31D}", "\u{C31D}", "\u{110A}\u{1162}\u{11B0}", "\u{C31D}", "\u{110A}\u{1162}\u{11B0}"),
    ("\u{C31E}", "\u{C31E}", "\u{110A}\u{1162}\u{11B1}", "\u{C31E}", "\u{110A}\u{1162}\u{11B1}"),
    ("\u{C31F}", "\u{C31F}", "\u{110A}\u{1162}\u{11B2}", "\u{C31F}", "\u{110A}\u{1162}\u{11B2}"),
    ("\u{C320}", "\u{C320}", "\u{110A}\u{1162}\u{11B3}", "\u{C320}", "\u{110A}\u{1162}\u{11B3}"),
    ("\u{C321}", "\u{C321}", "\u{110A}\u{1162}\u{11B4}", "\u{C321}", "\u{110A}\u{1162}\u{11B4}"),
    ("\u{C322}", "\u{C322}", "\u{110A}\u{1162}\u{11B5}", "\u{C322}", "\u{110A}\u{1162}\u{11B5}"),
    ("\u{C323}", "\u{C323}", "\u{110A}\u{1162}\u{11B6}", "\u{C323}", "\u{110A}\u{1162}\u{11B6}"),
    ("\u{C324}", "\u{C324}", "\u{110A}\u{1162}\u{11B7}", "\u{C324}", "\u{110A}\u{1162}\u{11B7}"),
    ("\u{C325}", "\u{C325}", "\u{110A}\u{1162}\u{11B8}", "\u{C325}", "\u{110A}\u{1162}\u{11B8}"),
    ("\u{C326}", "\u{C326}", "\u{110A}\u{1162}\u{11B9}", "\u{C326}", "\u{110A}\u{1162}\u{11B9}"),
    ("\u{C327}", "\u{C327}", "\u{110A}\u{1162}\u{11BA}", "\u{C327}", "\u{110A}\u{1162}\u{11BA}"),
    ("\u{C328}", "\u{C328}", "\u{110A}\u{1162}\u{11BB}", "\u{C328}", "\u{110A}\u{1162}\u{11BB}"),
    ("\u{C329}", "\u{C329}", "\u{110A}\u{1162}\u{11BC}", "\u{C329}", "\u{110A}\u{1162}\u{11BC}"),
    ("\u{C32A}", "\u{C32A}", "\u{110A}\u{1162}\u{11BD}", "\u{C32A}", "\u{110A}\u{1162}\u{11BD}"),
    ("\u{C32B}", "\u{C32B}", "\u{110A}\u{1162}\u{11BE}", "\u{C32B}", "\u{110A}\u{1162}\u{11BE}"),
    ("\u{C32C}", "\u{C32C}", "\u{110A}\u{1162}\u{11BF}", "\u{C32C}", "\u{110A}\u{1162}\u{11BF}"),
    ("\u{C32D}", "\u{C32D}", "\u{110A}\u{1162}\u{11C0}", "\u{C32D}", "\u{110A}\u{1162}\u{11C0}"),
    ("\u{C32E}", "\u{C32E}", "\u{110A}\u{1162}\u{11C1}", "\u{C32E}", "\u{110A}\u{1162}\u{11C1}"),
    ("\u{C32F}", "\u{C32F}", "\u{110A}\u{1162}\u{11C2}", "\u{C32F}", "\u{110A}\u{1162}\u{11C2}"),
    ("\u{C330}", "\u{C330}", "\u{110A}\u{1163}", "\u{C330}", "\u{110A}\u{1163}"),
    ("\u{C331}", "\u{C331}", "\u{110A}\u{1163}\u{11A8}", "\u{C331}", "\u{110A}\u{1163}\u{11A8}"),
    ("\u{C332}", "\u{C332}", "\u{110A}\u{1163}\u{11A9}", "\u{C332}", "\u{110A}\u{1163}\u{11A9}"),
    ("\u{C333}", "\u{C333}", "\u{110A}\u{1163}\u{11AA}", "\u{C333}", "\u{110A}\u{1163}\u{11AA}"),
    ("\u{C334}", "\u{C334}", "\u{110A}\u{1163}\u{11AB}", "\u{C334}", "\u{110A}\u{1163}\u{11AB}"),
    ("\u{C335}", "\u{C335}", "\u{110A}\u{1163}\u{11AC}", "\u{C335}", "\u{110A}\u{1163}\u{11AC}"),
    ("\u{C336}", "\u{C336}", "\u{110A}\u{1163}\u{11AD}", "\u{C336}", "\u{110A}\u{1163}\u{11AD}"),
    ("\u{C337}", "\u{C337}", "\u{110A}\u{1163}\u{11AE}", "\u{C337}", "\u{110A}\u{1163}\u{11AE}"),
    ("\u{C338}", "\u{C338}", "\u{110A}\u{1163}\u{11AF}", "\u{C338}", "\u{110A}\u{1163}\u{11AF}"),
    ("\u{C339}", "\u{C339}", "\u{110A}\u{1163}\u{11B0}", "\u{C339}", "\u{110A}\u{1163}\u{11B0}"),
    ("\u{C33A}", "\u{C33A}", "\u{110A}\u{1163}\u{11B1}", "\u{C33A}", "\u{110A}\u{1163}\u{11B1}"),
    ("\u{C33B}", "\u{C33B}", "\u{110A}\u{1163}\u{11B2}", "\u{C33B}", "\u{110A}\u{1163}\u{11B2}"),
    ("\u{C33C}", "\u{C33C}", "\u{110A}\u{1163}\u{11B3}", "\u{C33C}", "\u{110A}\u{1163}\u{11B3}"),
    ("\u{C33D}", "\u{C33D}", "\u{110A}\u{1163}\u{11B4}", "\u{C33D}", "\u{110A}\u{1163}\u{11B4}"),
    ("\u{C33E}", "\u{C33E}", "\u{110A}\u{1163}\u{11B5}", "\u{C33E}", "\u{110A}\u{1163}\u{11B5}"),
    ("\u{C33F}", "\u{C33F}", "\u{110A}\u{1163}\u{11B6}", "\u{C33F}", "\u{110A}\u{1163}\u{11B6}"),
    ("\u{C340}", "\u{C340}", "\u{110A}\u{1163}\u{11B7}", "\u{C340}", "\u{110A}\u{1163}\u{11B7}"),
    ("\u{C341}", "\u{C341}", "\u{110A}\u{1163}\u{11B8}", "\u{C341}", "\u{110A}\u{1163}\u{11B8}"),
    ("\u{C342}", "\u{C342}", "\u{110A}\u{1163}\u{11B9}", "\u{C342}", "\u{110A}\u{1163}\u{11B9}"),
    ("\u{C343}", "\u{C343}", "\u{110A}\u{1163}\u{11BA}", "\u{C343}", "\u{110A}\u{1163}\u{11BA}"),
    ("\u{C344}", "\u{C344}", "\u{110A}\u{1163}\u{11BB}", "\u{C344}", "\u{110A}\u{1163}\u{11BB}"),
    ("\u{C345}", "\u{C345}", "\u{110A}\u{1163}\u{11BC}", "\u{C345}", "\u{110A}\u{1163}\u{11BC}"),
    ("\u{C346}", "\u{C346}", "\u{110A}\u{1163}\u{11BD}", "\u{C346}", "\u{110A}\u{1163}\u{11BD}"),
    ("\u{C347}", "\u{C347}", "\u{110A}\u{1163}\u{11BE}", "\u{C347}", "\u{110A}\u{1163}\u{11BE}"),
    ("\u{C348}", "\u{C348}", "\u{110A}\u{1163}\u{11BF}", "\u{C348}", "\u{110A}\u{1163}\u{11BF}"),
    ("\u{C349}", "\u{C349}", "\u{110A}\u{1163}\u{11C0}", "\u{C349}", "\u{110A}\u{1163}\u{11C0}"),
    ("\u{C34A}", "\u{C34A}", "\u{110A}\u{1163}\u{11C1}", "\u{C34A}", "\u{110A}\u{1163}\u{11C1}"),
    ("\u{C34B}", "\u{C34B}", "\u{110A}\u{1163}\u{11C2}", "\u{C34B}", "\u{110A}\u{1163}\u{11C2}"),
    ("\u{C34C}", "\u{C34C}", "\u{110A}\u{1164}", "\u{C34C}", "\u{110A}\u{1164}"),
    ("\u{C34D}", "\u{C34D}", "\u{110A}\u{1164}\u{11A8}", "\u{C34D}", "\u{110A}\u{1164}\u{11A8}"),
    ("\u{C34E}", "\u{C34E}", "\u{110A}\u{1164}\u{11A9}", "\u{C34E}", "\u{110A}\u{1164}\u{11A9}"),
    ("\u{C34F}", "\u{C34F}", "\u{110A}\u{1164}\u{11AA}", "\u{C34F}", "\u{110A}\u{1164}\u{11AA}"),
    ("\u{C350}", "\u{C350}", "\u{110A}\u{1164}\u{11AB}", "\u{C350}", "\u{110A}\u{1164}\u{11AB}"),
    ("\u{C351}", "\u{C351}", "\u{110A}\u{1164}\u{11AC}", "\u{C351}", "\u{110A}\u{1164}\u{11AC}"),
    ("\u{C352}", "\u{C352}", "\u{110A}\u{1164}\u{11AD}", "\u{C352}", "\u{110A}\u{1164}\u{11AD}"),
    ("\u{C353}", "\u{C353}", "\u{110A}\u{1164}\u{11AE}", "\u{C353}", "\u{110A}\u{1164}\u{11AE}"),
    ("\u{C354}", "\u{C354}", "\u{110A}\u{1164}\u{11AF}", "\u{C354}", "\u{110A}\u{1164}\u{11AF}"),
    ("\u{C355}", "\u{C355}", "\u{110A}\u{1164}\u{11B0}", "\u{C355}", "\u{110A}\u{1164}\u{11B0}"),
    ("\u{C356}", "\u{C356}", "\u{110A}\u{1164}\u{11B1}", "\u{C356}", "\u{110A}\u{1164}\u{11B1}"),
    ("\u{C357}", "\u{C357}", "\u{110A}\u{1164}\u{11B2}", "\u{C357}", "\u{110A}\u{1164}\u{11B2}"),
    ("\u{C358}", "\u{C358}", "\u{110A}\u{1164}\u{11B3}", "\u{C358}", "\u{110A}\u{1164}\u{11B3}"),
    ("\u{C359}", "\u{C359}", "\u{110A}\u{1164}\u{11B4}", "\u{C359}", "\u{110A}\u{1164}\u{11B4}"),
    ("\u{C35A}", "\u{C35A}", "\u{110A}\u{1164}\u{11B5}", "\u{C35A}", "\u{110A}\u{1164}\u{11B5}"),
    ("\u{C35B}", "\u{C35B}", "\u{110A}\u{1164}\u{11B6}", "\u{C35B}", "\u{110A}\u{1164}\u{11B6}"),
    ("\u{C35C}", "\u{C35C}", "\u{110A}\u{1164}\u{11B7}", "\u{C35C}", "\u{110A}\u{1164}\u{11B7}"),
    ("\u{C35D}", "\u{C35D}", "\u{110A}\u{1164}\u{11B8}", "\u{C35D}", "\u{110A}\u{1164}\u{11B8}"),
    ("\u{C35E}", "\u{C35E}", "\u{110A}\u{1164}\u{11B9}", "\u{C35E}", "\u{110A}\u{1164}\u{11B9}"),
    ("\u{C35F}", "\u{C35F}", "\u{110A}\u{1164}\u{11BA}", "\u{C35F}", "\u{110A}\u{1164}\u{11BA}"),
    ("\u{C360}", "\u{C360}", "\u{110A}\u{1164}\u{11BB}", "\u{C360}", "\u{110A}\u{1164}\u{11BB}"),
    ("\u{C361}", "\u{C361}", "\u{110A}\u{1164}\u{11BC}", "\u{C361}", "\u{110A}\u{1164}\u{11BC}"),
    ("\u{C362}", "\u{C362}", "\u{110A}\u{1164}\u{11BD}", "\u{C362}", "\u{110A}\u{1164}\u{11BD}"),
    ("\u{C363}", "\u{C363}", "\u{110A}\u{1164}\u{11BE}", "\u{C363}", "\u{110A}\u{1164}\u{11BE}"),
    ("\u{C364}", "\u{C364}", "\u{110A}\u{1164}\u{11BF}", "\u{C364}", "\u{110A}\u{1164}\u{11BF}"),
    ("\u{C365}", "\u{C365}", "\u{110A}\u{1164}\u{11C0}", "\u{C365}", "\u{110A}\u{1164}\u{11C0}"),
    ("\u{C366}", "\u{C366}", "\u{110A}\u{1164}\u{11C1}", "\u{C366}", "\u{110A}\u{1164}\u{11C1}"),
    ("\u{C367}", "\u{C367}", "\u{110A}\u{1164}\u{11C2}", "\u{C367}", "\u{110A}\u{1164}\u{11C2}"),
    ("\u{C368}", "\u{C368}", "\u{110A}\u{1165}", "\u{C368}", "\u{110A}\u{1165}"),
    ("\u{C369}", "\u{C369}", "\u{110A}\u{1165}\u{11A8}", "\u{C369}", "\u{110A}\u{1165}\u{11A8}"),
    ("\u{C36A}", "\u{C36A}", "\u{110A}\u{1165}\u{11A9}", "\u{C36A}", "\u{110A}\u{1165}\u{11A9}"),
    ("\u{C36B}", "\u{C36B}", "\u{110A}\u{1165}\u{11AA}", "\u{C36B}", "\u{110A}\u{1165}\u{11AA}"),
    ("\u{C36C}", "\u{C36C}", "\u{110A}\u{1165}\u{11AB}", "\u{C36C}", "\u{110A}\u{1165}\u{11AB}"),
    ("\u{C36D}", "\u{C36D}", "\u{110A}\u{1165}\u{11AC}", "\u{C36D}", "\u{110A}\u{1165}\u{11AC}"),
    ("\u{C36E}", "\u{C36E}", "\u{110A}\u{1165}\u{11AD}", "\u{C36E}", "\u{110A}\u{1165}\u{11AD}"),
    ("\u{C36F}", "\u{C36F}", "\u{110A}\u{1165}\u{11AE}", "\u{C36F}", "\u{110A}\u{1165}\u{11AE}"),
    ("\u{C370}", "\u{C370}", "\u{110A}\u{1165}\u{11AF}", "\u{C370}", "\u{110A}\u{1165}\u{11AF}"),
    ("\u{C371}", "\u{C371}", "\u{110A}\u{1165}\u{11B0}", "\u{C371}", "\u{110A}\u{1165}\u{11B0}"),
    ("\u{C372}", "\u{C372}", "\u{110A}\u{1165}\u{11B1}", "\u{C372}", "\u{110A}\u{1165}\u{11B1}"),
    ("\u{C373}", "\u{C373}", "\u{110A}\u{1165}\u{11B2}", "\u{C373}", "\u{110A}\u{1165}\u{11B2}"),
    ("\u{C374}", "\u{C374}", "\u{110A}\u{1165}\u{11B3}", "\u{C374}", "\u{110A}\u{1165}\u{11B3}"),
    ("\u{C375}", "\u{C375}", "\u{110A}\u{1165}\u{11B4}", "\u{C375}", "\u{110A}\u{1165}\u{11B4}"),
    ("\u{C376}", "\u{C376}", "\u{110A}\u{1165}\u{11B5}", "\u{C376}", "\u{110A}\u{1165}\u{11B5}"),
    ("\u{C377}", "\u{C377}", "\u{110A}\u{1165}\u{11B6}", "\u{C377}", "\u{110A}\u{1165}\u{11B6}"),
    ("\u{C378}", "\u{C378}", "\u{110A}\u{1165}\u{11B7}", "\u{C378}", "\u{110A}\u{1165}\u{11B7}"),
    ("\u{C379}", "\u{C379}", "\u{110A}\u{1165}\u{11B8}", "\u{C379}", "\u{110A}\u{1165}\u{11B8}"),
    ("\u{C37A}", "\u{C37A}", "\u{110A}\u{1165}\u{11B9}", "\u{C37A}", "\u{110A}\u{1165}\u{11B9}"),
    ("\u{C37B}", "\u{C37B}", "\u{110A}\u{1165}\u{11BA}", "\u{C37B}", "\u{110A}\u{1165}\u{11BA}"),
    ("\u{C37C}", "\u{C37C}", "\u{110A}\u{1165}\u{11BB}", "\u{C37C}", "\u{110A}\u{1165}\u{11BB}"),
    ("\u{C37D}", "\u{C37D}", "\u{110A}\u{1165}\u{11BC}", "\u{C37D}", "\u{110A}\u{1165}\u{11BC}"),
    ("\u{C37E}", "\u{C37E}", "\u{110A}\u{1165}\u{11BD}", "\u{C37E}", "\u{110A}\u{1165}\u{11BD}"),
    ("\u{C37F}", "\u{C37F}", "\u{110A}\u{1165}\u{11BE}", "\u{C37F}", "\u{110A}\u{1165}\u{11BE}"),
    ("\u{C380}", "\u{C380}", "\u{110A}\u{1165}\u{11BF}", "\u{C380}", "\u{110A}\u{1165}\u{11BF}"),
    ("\u{C381}", "\u{C381}", "\u{110A}\u{1165}\u{11C0}", "\u{C381}", "\u{110A}\u{1165}\u{11C0}"),
    ("\u{C382}", "\u{C382}", "\u{110A}\u{1165}\u{11C1}", "\u{C382}", "\u{110A}\u{1165}\u{11C1}"),
    ("\u{C383}", "\u{C383}", "\u{110A}\u{1165}\u{11C2}", "\u{C383}", "\u{110A}\u{1165}\u{11C2}"),
    ("\u{C384}", "\u{C384}", "\u{110A}\u{1166}", "\u{C384}", "\u{110A}\u{1166}"),
    ("\u{C385}", "\u{C385}", "\u{110A}\u{1166}\u{11A8}", "\u{C385}", "\u{110A}\u{1166}\u{11A8}"),
    ("\u{C386}", "\u{C386}", "\u{110A}\u{1166}\u{11A9}", "\u{C386}", "\u{110A}\u{1166}\u{11A9}"),
    ("\u{C387}", "\u{C387}", "\u{110A}\u{1166}\u{11AA}", "\u{C387}", "\u{110A}\u{1166}\u{11AA}"),
    ("\u{C388}", "\u{C388}", "\u{110A}\u{1166}\u{11AB}", "\u{C388}", "\u{110A}\u{1166}\u{11AB}"),
    ("\u{C389}", "\u{C389}", "\u{110A}\u{1166}\u{11AC}", "\u{C389}", "\u{110A}\u{1166}\u{11AC}"),
    ("\u{C38A}", "\u{C38A}", "\u{110A}\u{1166}\u{11AD}", "\u{C38A}", "\u{110A}\u{1166}\u{11AD}"),
    ("\u{C38B}", "\u{C38B}", "\u{110A}\u{1166}\u{11AE}", "\u{C38B}", "\u{110A}\u{1166}\u{11AE}"),
    ("\u{C38C}", "\u{C38C}", "\u{110A}\u{1166}\u{11AF}", "\u{C38C}", "\u{110A}\u{1166}\u{11AF}"),
    ("\u{C38D}", "\u{C38D}", "\u{110A}\u{1166}\u{11B0}", "\u{C38D}", "\u{110A}\u{1166}\u{11B0}"),
    ("\u{C38E}", "\u{C38E}", "\u{110A}\u{1166}\u{11B1}", "\u{C38E}", "\u{110A}\u{1166}\u{11B1}"),
    ("\u{C38F}", "\u{C38F}", "\u{110A}\u{1166}\u{11B2}", "\u{C38F}", "\u{110A}\u{1166}\u{11B2}"),
    ("\u{C390}", "\u{C390}", "\u{110A}\u{1166}\u{11B3}", "\u{C390}", "\u{110A}\u{1166}\u{11B3}"),
    ("\u{C391}", "\u{C391}", "\u{110A}\u{1166}\u{11B4}", "\u{C391}", "\u{110A}\u{1166}\u{11B4}"),
    ("\u{C392}", "\u{C392}", "\u{110A}\u{1166}\u{11B5}", "\u{C392}", "\u{110A}\u{1166}\u{11B5}"),
    ("\u{C393}", "\u{C393}", "\u{110A}\u{1166}\u{11B6}", "\u{C393}", "\u{110A}\u{1166}\u{11B6}"),
    ("\u{C394}", "\u{C394}", "\u{110A}\u{1166}\u{11B7}", "\u{C394}", "\u{110A}\u{1166}\u{11B7}"),
    ("\u{C395}", "\u{C395}", "\u{110A}\u{1166}\u{11B8}", "\u{C395}", "\u{110A}\u{1166}\u{11B8}"),
    ("\u{C396}", "\u{C396}", "\u{110A}\u{1166}\u{11B9}", "\u{C396}", "\u{110A}\u{1166}\u{11B9}"),
    ("\u{C397}", "\u{C397}", "\u{110A}\u{1166}\u{11BA}", "\u{C397}", "\u{110A}\u{1166}\u{11BA}"),
    ("\u{C398}", "\u{C398}", "\u{110A}\u{1166}\u{11BB}", "\u{C398}", "\u{110A}\u{1166}\u{11BB}"),
    ("\u{C399}", "\u{C399}", "\u{110A}\u{1166}\u{11BC}", "\u{C399}", "\u{110A}\u{1166}\u{11BC}"),
    ("\u{C39A}", "\u{C39A}", "\u{110A}\u{1166}\u{11BD}", "\u{C39A}", "\u{110A}\u{1166}\u{11BD}"),
    ("\u{C39B}", "\u{C39B}", "\u{110A}\u{1166}\u{11BE}", "\u{C39B}", "\u{110A}\u{1166}\u{11BE}"),
    ("\u{C39C}", "\u{C39C}", "\u{110A}\u{1166}\u{11BF}", "\u{C39C}", "\u{110A}\u{1166}\u{11BF}"),
    ("\u{C39D}", "\u{C39D}", "\u{110A}\u{1166}\u{11C0}", "\u{C39D}", "\u{110A}\u{1166}\u{11C0}"),
    ("\u{C39E}", "\u{C39E}", "\u{110A}\u{1166}\u{11C1}", "\u{C39E}", "\u{110A}\u{1166}\u{11C1}"),
    ("\u{C39F}", "\u{C39F}", "\u{110A}\u{1166}\u{11C2}", "\u{C39F}", "\u{110A}\u{1166}\u{11C2}"),
    ("\u{C3A0}", "\u{C3A0}", "\u{110A}\u{1167}", "\u{C3A0}", "\u{110A}\u{1167}"),
    ("\u{C3A1}", "\u{C3A1}", "\u{110A}\u{1167}\u{11A8}", "\u{C3A1}", "\u{110A}\u{1167}\u{11A8}"),
    ("\u{C3A2}", "\u{C3A2}", "\u{110A}\u{1167}\u{11A9}", "\u{C3A2}", "\u{110A}\u{1167}\u{11A9}"),
    ("\u{C3A3}", "\u{C3A3}", "\u{110A}\u{1167}\u{11AA}", "\u{C3A3}", "\u{110A}\u{1167}\u{11AA}"),
    ("\u{C3A4}", "\u{C3A4}", "\u{110A}\u{1167}\u{11AB}", "\u{C3A4}", "\u{110A}\u{1167}\u{11AB}"),
    ("\u{C3A5}", "\u{C3A5}", "\u{110A}\u{1167}\u{11AC}", "\u{C3A5}", "\u{110A}\u{1167}\u{11AC}"),
    ("\u{C3A6}", "\u{C3A6}", "\u{110A}\u{1167}\u{11AD}", "\u{C3A6}", "\u{110A}\u{1167}\u{11AD}"),
    ("\u{C3A7}", "\u{C3A7}", "\u{110A}\u{1167}\u{11AE}", "\u{C3A7}", "\u{110A}\u{1167}\u{11AE}"),
    ("\u{C3A8}", "\u{C3A8}", "\u{110A}\u{1167}\u{11AF}", "\u{C3A8}", "\u{110A}\u{1167}\u{11AF}"),
    ("\u{C3A9}", "\u{C3A9}", "\u{110A}\u{1167}\u{11B0}", "\u{C3A9}", "\u{110A}\u{1167}\u{11B0}"),
    ("\u{C3AA}", "\u{C3AA}", "\u{110A}\u{1167}\u{11B1}", "\u{C3AA}", "\u{110A}\u{1167}\u{11B1}"),
    ("\u{C3AB}", "\u{C3AB}", "\u{110A}\u{1167}\u{11B2}", "\u{C3AB}", "\u{110A}\u{1167}\u{11B2}"),
    ("\u{C3AC}", "\u{C3AC}", "\u{110A}\u{1167}\u{11B3}", "\u{C3AC}", "\u{110A}\u{1167}\u{11B3}"),
    ("\u{C3AD}", "\u{C3AD}", "\u{110A}\u{1167}\u{11B4}", "\u{C3AD}", "\u{110A}\u{1167}\u{11B4}"),
    ("\u{C3AE}", "\u{C3AE}", "\u{110A}\u{1167}\u{11B5}", "\u{C3AE}", "\u{110A}\u{1167}\u{11B5}"),
    ("\u{C3AF}", "\u{C3AF}", "\u{110A}\u{1167}\u{11B6}", "\u{C3AF}", "\u{110A}\u{1167}\u{11B6}"),
    ("\u{C3B0}", "\u{C3B0}", "\u{110A}\u{1167}\u{11B7}", "\u{C3B0}", "\u{110A}\u{1167}\u{11B7}"),
    ("\u{C3B1}", "\u{C3B1}", "\u{110A}\u{1167}\u{11B8}", "\u{C3B1}", "\u{110A}\u{1167}\u{11B8}"),
    ("\u{C3B2}", "\u{C3B2}", "\u{110A}\u{1167}\u{11B9}", "\u{C3B2}", "\u{110A}\u{1167}\u{11B9}"),
    ("\u{C3B3}", "\u{C3B3}", "\u{110A}\u{1167}\u{11BA}", "\u{C3B3}", "\u{110A}\u{1167}\u{11BA}"),
    ("\u{C3B4}", "\u{C3B4}", "\u{110A}\u{1167}\u{11BB}", "\u{C3B4}", "\u{110A}\u{1167}\u{11BB}"),
    ("\u{C3B5}", "\u{C3B5}", "\u{110A}\u{1167}\u{11BC}", "\u{C3B5}", "\u{110A}\u{1167}\u{11BC}"),
    ("\u{C3B6}", "\u{C3B6}", "\u{110A}\u{1167}\u{11BD}", "\u{C3B6}", "\u{110A}\u{1167}\u{11BD}"),
    ("\u{C3B7}", "\u{C3B7}", "\u{110A}\u{1167}\u{11BE}", "\u{C3B7}", "\u{110A}\u{1167}\u{11BE}"),
    ("\u{C3B8}", "\u{C3B8}", "\u{110A}\u{1167}\u{11BF}", "\u{C3B8}", "\u{110A}\u{1167}\u{11BF}"),
    ("\u{C3B9}", "\u{C3B9}", "\u{110A}\u{1167}\u{11C0}", "\u{C3B9}", "\u{110A}\u{1167}\u{11C0}"),
    ("\u{C3BA}", "\u{C3BA}", "\u{110A}\u{1167}\u{11C1}", "\u{C3BA}", "\u{110A}\u{1167}\u{11C1}"),
    ("\u{C3BB}", "\u{C3BB}", "\u{110A}\u{1167}\u{11C2}", "\u{C3BB}", "\u{110A}\u{1167}\u{11C2}"),
    ("\u{C3BC}", "\u{C3BC}", "\u{110A}\u{1168}", "\u{C3BC}", "\u{110A}\u{1168}"),
    ("\u{C3BD}", "\u{C3BD}", "\u{110A}\u{1168}\u{11A8}", "\u{C3BD}", "\u{110A}\u{1168}\u{11A8}"),
    ("\u{C3BE}", "\u{C3BE}", "\u{110A}\u{1168}\u{11A9}", "\u{C3BE}", "\u{110A}\u{1168}\u{11A9}"),
    ("\u{C3BF}", "\u{C3BF}", "\u{110A}\u{1168}\u{11AA}", "\u{C3BF}", "\u{110A}\u{1168}\u{11AA}"),
    ("\u{C3C0}", "\u{C3C0}", "\u{110A}\u{1168}\u{11AB}", "\u{C3C0}", "\u{110A}\u{1168}\u{11AB}"),
    ("\u{C3C1}", "\u{C3C1}", "\u{110A}\u{1168}\u{11AC}", "\u{C3C1}", "\u{110A}\u{1168}\u{11AC}"),
    ("\u{C3C2}", "\u{C3C2}", "\u{110A}\u{1168}\u{11AD}", "\u{C3C2}", "\u{110A}\u{1168}\u{11AD}"),
    ("\u{C3C3}", "\u{C3C3}", "\u{110A}\u{1168}\u{11AE}", "\u{C3C3}", "\u{110A}\u{1168}\u{11AE}"),
    ("\u{C3C4}", "\u{C3C4}", "\u{110A}\u{1168}\u{11AF}", "\u{C3C4}", "\u{110A}\u{1168}\u{11AF}"),
    ("\u{C3C5}", "\u{C3C5}", "\u{110A}\u{1168}\u{11B0}", "\u{C3C5}", "\u{110A}\u{1168}\u{11B0}"),
    ("\u{C3C6}", "\u{C3C6}", "\u{110A}\u{1168}\u{11B1}", "\u{C3C6}", "\u{110A}\u{1168}\u{11B1}"),
    ("\u{C3C7}", "\u{C3C7}", "\u{110A}\u{1168}\u{11B2}", "\u{C3C7}", "\u{110A}\u{1168}\u{11B2}"),
    ("\u{C3C8}", "\u{C3C8}", "\u{110A}\u{1168}\u{11B3}", "\u{C3C8}", "\u{110A}\u{1168}\u{11B3}"),
    ("\u{C3C9}", "\u{C3C9}", "\u{110A}\u{1168}\u{11B4}", "\u{C3C9}", "\u{110A}\u{1168}\u{11B4}"),
    ("\u{C3CA}", "\u{C3CA}", "\u{110A}\u{1168}\u{11B5}", "\u{C3CA}", "\u{110A}\u{1168}\u{11B5}"),
    ("\u{C3CB}", "\u{C3CB}", "\u{110A}\u{1168}\u{11B6}", "\u{C3CB}", "\u{110A}\u{1168}\u{11B6}"),
    ("\u{C3CC}", "\u{C3CC}", "\u{110A}\u{1168}\u{11B7}", "\u{C3CC}", "\u{110A}\u{1168}\u{11B7}"),
    ("\u{C3CD}", "\u{C3CD}", "\u{110A}\u{1168}\u{11B8}", "\u{C3CD}", "\u{110A}\u{1168}\u{11B8}"),
    ("\u{C3CE}", "\u{C3CE}", "\u{110A}\u{1168}\u{11B9}", "\u{C3CE}", "\u{110A}\u{1168}\u{11B9}"),
    ("\u{C3CF}", "\u{C3CF}", "\u{110A}\u{1168}\u{11BA}", "\u{C3CF}", "\u{110A}\u{1168}\u{11BA}"),
    ("\u{C3D0}", "\u{C3D0}", "\u{110A}\u{1168}\u{11BB}", "\u{C3D0}", "\u{110A}\u{1168}\u{11BB}"),
    ("\u{C3D1}", "\u{C3D1}", "\u{110A}\u{1168}\u{11BC}", "\u{C3D1}", "\u{110A}\u{1168}\u{11BC}"),
    ("\u{C3D2}", "\u{C3D2}", "\u{110A}\u{1168}\u{11BD}", "\u{C3D2}", "\u{110A}\u{1168}\u{11BD}"),
    ("\u{C3D3}", "\u{C3D3}", "\u{110A}\u{1168}\u{11BE}", "\u{C3D3}", "\u{110A}\u{1168}\u{11BE}"),
    ("\u{C3D4}", "\u{C3D4}", "\u{110A}\u{1168}\u{11BF}", "\u{C3D4}", "\u{110A}\u{1168}\u{11BF}"),
    ("\u{C3D5}", "\u{C3D5}", "\u{110A}\u{1168}\u{11C0}", "\u{C3D5}", "\u{110A}\u{1168}\u{11C0}"),
    ("\u{C3D6}", "\u{C3D6}", "\u{110A}\u{1168}\u{11C1}", "\u{C3D6}", "\u{110A}\u{1168}\u{11C1}"),
    ("\u{C3D7}", "\u{C3D7}", "\u{110A}\u{1168}\u{11C2}", "\u{C3D7}", "\u{110A}\u{1168}\u{11C2}"),
    ("\u{C3D8}", "\u{C3D8}", "\u{110A}\u{1169}", "\u{C3D8}", "\u{110A}\u{1169}"),
    ("\u{C3D9}", "\u{C3D9}", "\u{110A}\u{1169}\u{11A8}", "\u{C3D9}", "\u{110A}\u{1169}\u{11A8}"),
    ("\u{C3DA}", "\u{C3DA}", "\u{110A}\u{1169}\u{11A9}", "\u{C3DA}", "\u{110A}\u{1169}\u{11A9}"),
    ("\u{C3DB}", "\u{C3DB}", "\u{110A}\u{1169}\u{11AA}", "\u{C3DB}", "\u{110A}\u{1169}\u{11AA}"),
    ("\u{C3DC}", "\u{C3DC}", "\u{110A}\u{1169}\u{11AB}", "\u{C3DC}", "\u{110A}\u{1169}\u{11AB}"),
    ("\u{C3DD}", "\u{C3DD}", "\u{110A}\u{1169}\u{11AC}", "\u{C3DD}", "\u{110A}\u{1169}\u{11AC}"),
    ("\u{C3DE}", "\u{C3DE}", "\u{110A}\u{1169}\u{11AD}", "\u{C3DE}", "\u{110A}\u{1169}\u{11AD}"),
    ("\u{C3DF}", "\u{C3DF}", "\u{110A}\u{1169}\u{11AE}", "\u{C3DF}", "\u{110A}\u{1169}\u{11AE}"),
    ("\u{C3E0}", "\u{C3E0}", "\u{110A}\u{1169}\u{11AF}", "\u{C3E0}", "\u{110A}\u{1169}\u{11AF}"),
    ("\u{C3E1}", "\u{C3E1}", "\u{110A}\u{1169}\u{11B0}", "\u{C3E1}", "\u{110A}\u{1169}\u{11B0}"),
    ("\u{C3E2}", "\u{C3E2}", "\u{110A}\u{1169}\u{11B1}", "\u{C3E2}", "\u{110A}\u{1169}\u{11B1}"),
    ("\u{C3E3}", "\u{C3E3}", "\u{110A}\u{1169}\u{11B2}", "\u{C3E3}", "\u{110A}\u{1169}\u{11B2}"),
    ("\u{C3E4}", "\u{C3E4}", "\u{110A}\u{1169}\u{11B3}", "\u{C3E4}", "\u{110A}\u{1169}\u{11B3}"),
    ("\u{C3E5}", "\u{C3E5}", "\u{110A}\u{1169}\u{11B4}", "\u{C3E5}", "\u{110A}\u{1169}\u{11B4}"),
    ("\u{C3E6}", "\u{C3E6}", "\u{110A}\u{1169}\u{11B5}", "\u{C3E6}", "\u{110A}\u{1169}\u{11B5}"),
    ("\u{C3E7}", "\u{C3E7}", "\u{110A}\u{1169}\u{11B6}", "\u{C3E7}", "\u{110A}\u{1169}\u{11B6}"),
    ("\u{C3E8}", "\u{C3E8}", "\u{110A}\u{1169}\u{11B7}", "\u{C3E8}", "\u{110A}\u{1169}\u{11B7}"),
    ("\u{C3E9}", "\u{C3E9}", "\u{110A}\u{1169}\u{11B8}", "\u{C3E9}", "\u{110A}\u{1169}\u{11B8}"),
    ("\u{C3EA}", "\u{C3EA}", "\u{110A}\u{1169}\u{11B9}", "\u{C3EA}", "\u{110A}\u{1169}\u{11B9}"),
    ("\u{C3EB}", "\u{C3EB}", "\u{110A}\u{1169}\u{11BA}", "\u{C3EB}", "\u{110A}\u{1169}\u{11BA}"),
    ("\u{C3EC}", "\u{C3EC}", "\u{110A}\u{1169}\u{11BB}", "\u{C3EC}", "\u{110A}\u{1169}\u{11BB}"),
    ("\u{C3ED}", "\u{C3ED}", "\u{110A}\u{1169}\u{11BC}", "\u{C3ED}", "\u{110A}\u{1169}\u{11BC}"),
    ("\u{C3EE}", "\u{C3EE}", "\u{110A}\u{1169}\u{11BD}", "\u{C3EE}", "\u{110A}\u{1169}\u{11BD}"),
    ("\u{C3EF}", "\u{C3EF}", "\u{110A}\u{1169}\u{11BE}", "\u{C3EF}", "\u{110A}\u{1169}\u{11BE}"),
    ("\u{C3F0}", "\u{C3F0}", "\u{110A}\u{1169}\u{11BF}", "\u{C3F0}", "\u{110A}\u{1169}\u{11BF}"),
    ("\u{C3F1}", "\u{C3F1}", "\u{110A}\u{1169}\u{11C0}", "\u{C3F1}", "\u{110A}\u{1169}\u{11C0}"),
    ("\u{C3F2}", "\u{C3F2}", "\u{110A}\u{1169}\u{11C1}", "\u{C3F2}", "\u{110A}\u{1169}\u{11C1}"),
    ("\u{C3F3}", "\u{C3F3}", "\u{110A}\u{1169}\u{11C2}", "\u{C3F3}", "\u{110A}\u{1169}\u{11C2}"),
    ("\u{C3F4}", "\u{C3F4}", "\u{110A}\u{116A}", "\u{C3F4}", "\u{110A}\u{116A}"),
    ("\u{C3F5}", "\u{C3F5}", "\u{110A}\u{116A}\u{11A8}", "\u{C3F5}", "\u{110A}\u{116A}\u{11A8}"),
    ("\u{C3F6}", "\u{C3F6}", "\u{110A}\u{116A}\u{11A9}", "\u{C3F6}", "\u{110A}\u{116A}\u{11A9}"),
    ("\u{C3F7}", "\u{C3F7}", "\u{110A}\u{116A}\u{11AA}", "\u{C3F7}", "\u{110A}\u{116A}\u{11AA}"),
    ("\u{C3F8}", "\u{C3F8}", "\u{110A}\u{116A}\u{11AB}", "\u{C3F8}", "\u{110A}\u{116A}\u{11AB}"),
    ("\u{C3F9}", "\u{C3F9}", "\u{110A}\u{116A}\u{11AC}", "\u{C3F9}", "\u{110A}\u{116A}\u{11AC}"),
    ("\u{C3FA}", "\u{C3FA}", "\u{110A}\u{116A}\u{11AD}", "\u{C3FA}", "\u{110A}\u{116A}\u{11AD}"),
    ("\u{C3FB}", "\u{C3FB}", "\u{110A}\u{116A}\u{11AE}", "\u{C3FB}", "\u{110A}\u{116A}\u{11AE}"),
    ("\u{C3FC}", "\u{C3FC}", "\u{110A}\u{116A}\u{11AF}", "\u{C3FC}", "\u{110A}\u{116A}\u{11AF}"),
    ("\u{C3FD}", "\u{C3FD}", "\u{110A}\u{116A}\u{11B0}", "\u{C3FD}", "\u{110A}\u{116A}\u{11B0}"),
    ("\u{C3FE}", "\u{C3FE}", "\u{110A}\u{116A}\u{11B1}", "\u{C3FE}", "\u{110A}\u{116A}\u{11B1}"),
    ("\u{C3FF}", "\u{C3FF}", "\u{110A}\u{116A}\u{11B2}", "\u{C3FF}", "\u{110A}\u{116A}\u{11B2}"),
    ("\u{C400}", "\u{C400}", "\u{110A}\u{116A}\u{11B3}", "\u{C400}", "\u{110A}\u{116A}\u{11B3}"),
    ("\u{C401}", "\u{C401}", "\u{110A}\u{116A}\u{11B4}", "\u{C401}", "\u{110A}\u{116A}\u{11B4}"),
    ("\u{C402}", "\u{C402}", "\u{110A}\u{116A}\u{11B5}", "\u{C402}", "\u{110A}\u{116A}\u{11B5}"),
    ("\u{C403}", "\u{C403}", "\u{110A}\u{116A}\u{11B6}", "\u{C403}", "\u{110A}\u{116A}\u{11B6}"),
    ("\u{C404}", "\u{C404}", "\u{110A}\u{116A}\u{11B7}", "\u{C404}", "\u{110A}\u{116A}\u{11B7}"),
    ("\u{C405}", "\u{C405}", "\u{110A}\u{116A}\u{11B8}", "\u{C405}", "\u{110A}\u{116A}\u{11B8}"),
    ("\u{C406}", "\u{C406}", "\u{110A}\u{116A}\u{11B9}", "\u{C406}", "\u{110A}\u{116A}\u{11B9}"),
    ("\u{C407}", "\u{C407}", "\u{110A}\u{116A}\u{11BA}", "\u{C407}", "\u{110A}\u{116A}\u{11BA}"),
    ("\u{C408}", "\u{C408}", "\u{110A}\u{116A}\u{11BB}", "\u{C408}", "\u{110A}\u{116A}\u{11BB}"),
    ("\u{C409}", "\u{C409}", "\u{110A}\u{116A}\u{11BC}", "\u{C409}", "\u{110A}\u{116A}\u{11BC}"),
    ("\u{C40A}", "\u{C40A}", "\u{110A}\u{116A}\u{11BD}", "\u{C40A}", "\u{110A}\u{116A}\u{11BD}"),
    ("\u{C40B}", "\u{C40B}", "\u{110A}\u{116A}\u{11BE}", "\u{C40B}", "\u{110A}\u{116A}\u{11BE}"),
    ("\u{C40C}", "\u{C40C}", "\u{110A}\u{116A}\u{11BF}", "\u{C40C}", "\u{110A}\u{116A}\u{11BF}"),
    ("\u{C40D}", "\u{C40D}", "\u{110A}\u{116A}\u{11C0}", "\u{C40D}", "\u{110A}\u{116A}\u{11C0}"),
    ("\u{C40E}", "\u{C40E}", "\u{110A}\u{116A}\u{11C1}", "\u{C40E}", "\u{110A}\u{116A}\u{11C1}"),
    ("\u{C40F}", "\u{C40F}", "\u{110A}\u{116A}\u{11C2}", "\u{C40F}", "\u{110A}\u{116A}\u{11C2}"),
    ("\u{C410}", "\u{C410}", "\u{110A}\u{116B}", "\u{C410}", "\u{110A}\u{116B}"),
    ("\u{C411}", "\u{C411}", "\u{110A}\u{116B}\u{11A8}", "\u{C411}", "\u{110A}\u{116B}\u{11A8}"),
    ("\u{C412}", "\u{C412}", "\u{110A}\u{116B}\u{11A9}", "\u{C412}", "\u{110A}\u{116B}\u{11A9}"),
    ("\u{C413}", "\u{C413}", "\u{110A}\u{116B}\u{11AA}", "\u{C413}", "\u{110A}\u{116B}\u{11AA}"),
    ("\u{C414}", "\u{C414}", "\u{110A}\u{116B}\u{11AB}", "\u{C414}", "\u{110A}\u{116B}\u{11AB}"),
    ("\u{C415}", "\u{C415}", "\u{110A}\u{116B}\u{11AC}", "\u{C415}", "\u{110A}\u{116B}\u{11AC}"),
    ("\u{C416}", "\u{C416}", "\u{110A}\u{116B}\u{11AD}", "\u{C416}", "\u{110A}\u{116B}\u{11AD}"),
    ("\u{C417}", "\u{C417}", "\u{110A}\u{116B}\u{11AE}", "\u{C417}", "\u{110A}\u{116B}\u{11AE}"),
    ("\u{C418}", "\u{C418}", "\u{110A}\u{116B}\u{11AF}", "\u{C418}", "\u{110A}\u{116B}\u{11AF}"),
    ("\u{C419}", "\u{C419}", "\u{110A}\u{116B}\u{11B0}", "\u{C419}", "\u{110A}\u{116B}\u{11B0}"),
    ("\u{C41A}", "\u{C41A}", "\u{110A}\u{116B}\u{11B1}", "\u{C41A}", "\u{110A}\u{116B}\u{11B1}"),
    ("\u{C41B}", "\u{C41B}", "\u{110A}\u{116B}\u{11B2}", "\u{C41B}", "\u{110A}\u{116B}\u{11B2}"),
    ("\u{C41C}", "\u{C41C}", "\u{110A}\u{116B}\u{11B3}", "\u{C41C}", "\u{110A}\u{116B}\u{11B3}"),
    ("\u{C41D}", "\u{C41D}", "\u{110A}\u{116B}\u{11B4}", "\u{C41D}", "\u{110A}\u{116B}\u{11B4}"),
    ("\u{C41E}", "\u{C41E}", "\u{110A}\u{116B}\u{11B5}", "\u{C41E}", "\u{110A}\u{116B}\u{11B5}"),
    ("\u{C41F}", "\u{C41F}", "\u{110A}\u{116B}\u{11B6}", "\u{C41F}", "\u{110A}\u{116B}\u{11B6}"),
    ("\u{C420}", "\u{C420}", "\u{110A}\u{116B}\u{11B7}", "\u{C420}", "\u{110A}\u{116B}\u{11B7}"),
    ("\u{C421}", "\u{C421}", "\u{110A}\u{116B}\u{11B8}", "\u{C421}", "\u{110A}\u{116B}\u{11B8}"),
    ("\u{C422}", "\u{C422}", "\u{110A}\u{116B}\u{11B9}", "\u{C422}", "\u{110A}\u{116B}\u{11B9}"),
    ("\u{C423}", "\u{C423}", "\u{110A}\u{116B}\u{11BA}", "\u{C423}", "\u{110A}\u{116B}\u{11BA}"),
    ("\u{C424}", "\u{C424}", "\u{110A}\u{116B}\u{11BB}", "\u{C424}", "\u{110A}\u{116B}\u{11BB}"),
    ("\u{C425}", "\u{C425}", "\u{110A}\u{116B}\u{11BC}", "\u{C425}", "\u{110A}\u{116B}\u{11BC}"),
    ("\u{C426}", "\u{C426}", "\u{110A}\u{116B}\u{11BD}", "\u{C426}", "\u{110A}\u{116B}\u{11BD}"),
    ("\u{C427}", "\u{C427}", "\u{110A}\u{116B}\u{11BE}", "\u{C427}", "\u{110A}\u{116B}\u{11BE}"),
    ("\u{C428}", "\u{C428}", "\u{110A}\u{116B}\u{11BF}", "\u{C428}", "\u{110A}\u{116B}\u{11BF}"),
    ("\u{C429}", "\u{C429}", "\u{110A}\u{116B}\u{11C0}", "\u{C429}", "\u{110A}\u{116B}\u{11C0}"),
    ("\u{C42A}", "\u{C42A}", "\u{110A}\u{116B}\u{11C1}", "\u{C42A}", "\u{110A}\u{116B}\u{11C1}"),
    ("\u{C42B}", "\u{C42B}", "\u{110A}\u{116B}\u{11C2}", "\u{C42B}", "\u{110A}\u{116B}\u{11C2}"),
    ("\u{C42C}", "\u{C42C}", "\u{110A}\u{116C}", "\u{C42C}", "\u{110A}\u{116C}"),
    ("\u{C42D}", "\u{C42D}", "\u{110A}\u{116C}\u{11A8}", "\u{C42D}", "\u{110A}\u{116C}\u{11A8}"),
    ("\u{C42E}", "\u{C42E}", "\u{110A}\u{116C}\u{11A9}", "\u{C42E}", "\u{110A}\u{116C}\u{11A9}"),
    ("\u{C42F}", "\u{C42F}", "\u{110A}\u{116C}\u{11AA}", "\u{C42F}", "\u{110A}\u{116C}\u{11AA}"),
    ("\u{C430}", "\u{C430}", "\u{110A}\u{116C}\u{11AB}", "\u{C430}", "\u{110A}\u{116C}\u{11AB}"),
    ("\u{C431}", "\u{C431}", "\u{110A}\u{116C}\u{11AC}", "\u{C431}", "\u{110A}\u{116C}\u{11AC}"),
    ("\u{C432}", "\u{C432}", "\u{110A}\u{116C}\u{11AD}", "\u{C432}", "\u{110A}\u{116C}\u{11AD}"),
    ("\u{C433}", "\u{C433}", "\u{110A}\u{116C}\u{11AE}", "\u{C433}", "\u{110A}\u{116C}\u{11AE}"),
    ("\u{C434}", "\u{C434}", "\u{110A}\u{116C}\u{11AF}", "\u{C434}", "\u{110A}\u{116C}\u{11AF}"),
    ("\u{C435}", "\u{C435}", "\u{110A}\u{116C}\u{11B0}", "\u{C435}", "\u{110A}\u{116C}\u{11B0}"),
    ("\u{C436}", "\u{C436}", "\u{110A}\u{116C}\u{11B1}", "\u{C436}", "\u{110A}\u{116C}\u{11B1}"),
    ("\u{C437}", "\u{C437}", "\u{110A}\u{116C}\u{11B2}", "\u{C437}", "\u{110A}\u{116C}\u{11B2}"),
    ("\u{C438}", "\u{C438}", "\u{110A}\u{116C}\u{11B3}", "\u{C438}", "\u{110A}\u{116C}\u{11B3}"),
    ("\u{C439}", "\u{C439}", "\u{110A}\u{116C}\u{11B4}", "\u{C439}", "\u{110A}\u{116C}\u{11B4}"),
    ("\u{C43A}", "\u{C43A}", "\u{110A}\u{116C}\u{11B5}", "\u{C43A}", "\u{110A}\u{116C}\u{11B5}"),
    ("\u{C43B}", "\u{C43B}", "\u{110A}\u{116C}\u{11B6}", "\u{C43B}", "\u{110A}\u{116C}\u{11B6}"),
    ("\u{C43C}", "\u{C43C}", "\u{110A}\u{116C}\u{11B7}", "\u{C43C}", "\u{110A}\u{116C}\u{11B7}"),
    ("\u{C43D}", "\u{C43D}", "\u{110A}\u{116C}\u{11B8}", "\u{C43D}", "\u{110A}\u{116C}\u{11B8}"),
    ("\u{C43E}", "\u{C43E}", "\u{110A}\u{116C}\u{11B9}", "\u{C43E}", "\u{110A}\u{116C}\u{11B9}"),
    ("\u{C43F}", "\u{C43F}", "\u{110A}\u{116C}\u{11BA}", "\u{C43F}", "\u{110A}\u{116C}\u{11BA}"),
    ("\u{C440}", "\u{C440}", "\u{110A}\u{116C}\u{11BB}", "\u{C440}", "\u{110A}\u{116C}\u{11BB}"),
    ("\u{C441}", "\u{C441}", "\u{110A}\u{116C}\u{11BC}", "\u{C441}", "\u{110A}\u{116C}\u{11BC}"),
    ("\u{C442}", "\u{C442}", "\u{110A}\u{116C}\u{11BD}", "\u{C442}", "\u{110A}\u{116C}\u{11BD}"),
    ("\u{C443}", "\u{C443}", "\u{110A}\u{116C}\u{11BE}", "\u{C443}", "\u{110A}\u{116C}\u{11BE}"),
    ("\u{C444}", "\u{C444}", "\u{110A}\u{116C}\u{11BF}", "\u{C444}", "\u{110A}\u{116C}\u{11BF}"),
    ("\u{C445}", "\u{C445}", "\u{110A}\u{116C}\u{11C0}", "\u{C445}", "\u{110A}\u{116C}\u{11C0}"),
    ("\u{C446}", "\u{C446}", "\u{110A}\u{116C}\u{11C1}", "\u{C446}", "\u{110A}\u{116C}\u{11C1}"),
    ("\u{C447}", "\u{C447}", "\u{110A}\u{116C}\u{11C2}", "\u{C447}", "\u{110A}\u{116C}\u{11C2}"),
    ("\u{C448}", "\u{C448}", "\u{110A}\u{116D}", "\u{C448}", "\u{110A}\u{116D}"),
    ("\u{C449}", "\u{C449}", "\u{110A}\u{116D}\u{11A8}", "\u{C449}", "\u{110A}\u{116D}\u{11A8}"),
    ("\u{C44A}", "\u{C44A}", "\u{110A}\u{116D}\u{11A9}", "\u{C44A}", "\u{110A}\u{116D}\u{11A9}"),
    ("\u{C44B}", "\u{C44B}", "\u{110A}\u{116D}\u{11AA}", "\u{C44B}", "\u{110A}\u{116D}\u{11AA}"),
    ("\u{C44C}", "\u{C44C}", "\u{110A}\u{116D}\u{11AB}", "\u{C44C}", "\u{110A}\u{116D}\u{11AB}"),
    ("\u{C44D}", "\u{C44D}", "\u{110A}\u{116D}\u{11AC}", "\u{C44D}", "\u{110A}\u{116D}\u{11AC}"),
    ("\u{C44E}", "\u{C44E}", "\u{110A}\u{116D}\u{11AD}", "\u{C44E}", "\u{110A}\u{116D}\u{11AD}"),
    ("\u{C44F}", "\u{C44F}", "\u{110A}\u{116D}\u{11AE}", "\u{C44F}", "\u{110A}\u{116D}\u{11AE}"),
    ("\u{C450}", "\u{C450}", "\u{110A}\u{116D}\u{11AF}", "\u{C450}", "\u{110A}\u{116D}\u{11AF}"),
    ("\u{C451}", "\u{C451}", "\u{110A}\u{116D}\u{11B0}", "\u{C451}", "\u{110A}\u{116D}\u{11B0}"),
    ("\u{C452}", "\u{C452}", "\u{110A}\u{116D}\u{11B1}", "\u{C452}", "\u{110A}\u{116D}\u{11B1}"),
    ("\u{C453}", "\u{C453}", "\u{110A}\u{116D}\u{11B2}", "\u{C453}", "\u{110A}\u{116D}\u{11B2}"),
    ("\u{C454}", "\u{C454}", "\u{110A}\u{116D}\u{11B3}", "\u{C454}", "\u{110A}\u{116D}\u{11B3}"),
    ("\u{C455}", "\u{C455}", "\u{110A}\u{116D}\u{11B4}", "\u{C455}", "\u{110A}\u{116D}\u{11B4}"),
    ("\u{C456}", "\u{C456}", "\u{110A}\u{116D}\u{11B5}", "\u{C456}", "\u{110A}\u{116D}\u{11B5}"),
    ("\u{C457}", "\u{C457}", "\u{110A}\u{116D}\u{11B6}", "\u{C457}", "\u{110A}\u{116D}\u{11B6}"),
    ("\u{C458}", "\u{C458}", "\u{110A}\u{116D}\u{11B7}", "\u{C458}", "\u{110A}\u{116D}\u{11B7}"),
    ("\u{C459}", "\u{C459}", "\u{110A}\u{116D}\u{11B8}", "\u{C459}", "\u{110A}\u{116D}\u{11B8}"),
    ("\u{C45A}", "\u{C45A}", "\u{110A}\u{116D}\u{11B9}", "\u{C45A}", "\u{110A}\u{116D}\u{11B9}"),
    ("\u{C45B}", "\u{C45B}", "\u{110A}\u{116D}\u{11BA}", "\u{C45B}", "\u{110A}\u{116D}\u{11BA}"),
    ("\u{C45C}", "\u{C45C}", "\u{110A}\u{116D}\u{11BB}", "\u{C45C}", "\u{110A}\u{116D}\u{11BB}"),
    ("\u{C45D}", "\u{C45D}", "\u{110A}\u{116D}\u{11BC}", "\u{C45D}", "\u{110A}\u{116D}\u{11BC}"),
    ("\u{C45E}", "\u{C45E}", "\u{110A}\u{116D}\u{11BD}", "\u{C45E}", "\u{110A}\u{116D}\u{11BD}"),
    ("\u{C45F}", "\u{C45F}", "\u{110A}\u{116D}\u{11BE}", "\u{C45F}", "\u{110A}\u{116D}\u{11BE}"),
    ("\u{C460}", "\u{C460}", "\u{110A}\u{116D}\u{11BF}", "\u{C460}", "\u{110A}\u{116D}\u{11BF}"),
    ("\u{C461}", "\u{C461}", "\u{110A}\u{116D}\u{11C0}", "\u{C461}", "\u{110A}\u{116D}\u{11C0}"),
    ("\u{C462}", "\u{C462}", "\u{110A}\u{116D}\u{11C1}", "\u{C462}", "\u{110A}\u{116D}\u{11C1}"),
    ("\u{C463}", "\u{C463}", "\u{110A}\u{116D}\u{11C2}", "\u{C463}", "\u{110A}\u{116D}\u{11C2}"),
    ("\u{C464}", "\u{C464}", "\u{110A}\u{116E}", "\u{C464}", "\u{110A}\u{116E}"),
    ("\u{C465}", "\u{C465}", "\u{110A}\u{116E}\u{11A8}", "\u{C465}", "\u{110A}\u{116E}\u{11A8}"),
    ("\u{C466}", "\u{C466}", "\u{110A}\u{116E}\u{11A9}", "\u{C466}", "\u{110A}\u{116E}\u{11A9}"),
    ("\u{C467}", "\u{C467}", "\u{110A}\u{116E}\u{11AA}", "\u{C467}", "\u{110A}\u{116E}\u{11AA}"),
    ("\u{C468}", "\u{C468}", "\u{110A}\u{116E}\u{11AB}", "\u{C468}", "\u{110A}\u{116E}\u{11AB}"),
    ("\u{C469}", "\u{C469}", "\u{110A}\u{116E}\u{11AC}", "\u{C469}", "\u{110A}\u{116E}\u{11AC}"),
    ("\u{C46A}", "\u{C46A}", "\u{110A}\u{116E}\u{11AD}", "\u{C46A}", "\u{110A}\u{116E}\u{11AD}"),
    ("\u{C46B}", "\u{C46B}", "\u{110A}\u{116E}\u{11AE}", "\u{C46B}", "\u{110A}\u{116E}\u{11AE}"),
    ("\u{C46C}", "\u{C46C}", "\u{110A}\u{116E}\u{11AF}", "\u{C46C}", "\u{110A}\u{116E}\u{11AF}"),
    ("\u{C46D}", "\u{C46D}", "\u{110A}\u{116E}\u{11B0}", "\u{C46D}", "\u{110A}\u{116E}\u{11B0}"),
    ("\u{C46E}", "\u{C46E}", "\u{110A}\u{116E}\u{11B1}", "\u{C46E}", "\u{110A}\u{116E}\u{11B1}"),
    ("\u{C46F}", "\u{C46F}", "\u{110A}\u{116E}\u{11B2}", "\u{C46F}", "\u{110A}\u{116E}\u{11B2}"),
    ("\u{C470}", "\u{C470}", "\u{110A}\u{116E}\u{11B3}", "\u{C470}", "\u{110A}\u{116E}\u{11B3}"),
    ("\u{C471}", "\u{C471}", "\u{110A}\u{116E}\u{11B4}", "\u{C471}", "\u{110A}\u{116E}\u{11B4}"),
    ("\u{C472}", "\u{C472}", "\u{110A}\u{116E}\u{11B5}", "\u{C472}", "\u{110A}\u{116E}\u{11B5}"),
    ("\u{C473}", "\u{C473}", "\u{110A}\u{116E}\u{11B6}", "\u{C473}", "\u{110A}\u{116E}\u{11B6}"),
    ("\u{C474}", "\u{C474}", "\u{110A}\u{116E}\u{11B7}", "\u{C474}", "\u{110A}\u{116E}\u{11B7}"),
    ("\u{C475}", "\u{C475}", "\u{110A}\u{116E}\u{11B8}", "\u{C475}", "\u{110A}\u{116E}\u{11B8}"),
    ("\u{C476}", "\u{C476}", "\u{110A}\u{116E}\u{11B9}", "\u{C476}", "\u{110A}\u{116E}\u{11B9}"),
    ("\u{C477}", "\u{C477}", "\u{110A}\u{116E}\u{11BA}", "\u{C477}", "\u{110A}\u{116E}\u{11BA}"),
    ("\u{C478}", "\u{C478}", "\u{110A}\u{116E}\u{11BB}", "\u{C478}", "\u{110A}\u{116E}\u{11BB}"),
    ("\u{C479}", "\u{C479}", "\u{110A}\u{116E}\u{11BC}", "\u{C479}", "\u{110A}\u{116E}\u{11BC}"),
    ("\u{C47A}", "\u{C47A}", "\u{110A}\u{116E}\u{11BD}", "\u{C47A}", "\u{110A}\u{116E}\u{11BD}"),
    ("\u{C47B}", "\u{C47B}", "\u{110A}\u{116E}\u{11BE}", "\u{C47B}", "\u{110A}\u{116E}\u{11BE}"),
    ("\u{C47C}", "\u{C47C}", "\u{110A}\u{116E}\u{11BF}", "\u{C47C}", "\u{110A}\u{116E}\u{11BF}"),
    ("\u{C47D}", "\u{C47D}", "\u{110A}\u{116E}\u{11C0}", "\u{C47D}", "\u{110A}\u{116E}\u{11C0}"),
    ("\u{C47E}", "\u{C47E}", "\u{110A}\u{116E}\u{11C1}", "\u{C47E}", "\u{110A}\u{116E}\u{11C1}"),
    ("\u{C47F}", "\u{C47F}", "\u{110A}\u{116E}\u{11C2}", "\u{C47F}", "\u{110A}\u{116E}\u{11C2}"),
    ("\u{C480}", "\u{C480}", "\u{110A}\u{116F}", "\u{C480}", "\u{110A}\u{116F}"),
    ("\u{C481}", "\u{C481}", "\u{110A}\u{116F}\u{11A8}", "\u{C481}", "\u{110A}\u{116F}\u{11A8}"),
    ("\u{C482}", "\u{C482}", "\u{110A}\u{116F}\u{11A9}", "\u{C482}", "\u{110A}\u{116F}\u{11A9}"),
    ("\u{C483}", "\u{C483}", "\u{110A}\u{116F}\u{11AA}", "\u{C483}", "\u{110A}\u{116F}\u{11AA}"),
    ("\u{C484}", "\u{C484}", "\u{110A}\u{116F}\u{11AB}", "\u{C484}", "\u{110A}\u{116F}\u{11AB}"),
    ("\u{C485}", "\u{C485}", "\u{110A}\u{116F}\u{11AC}", "\u{C485}", "\u{110A}\u{116F}\u{11AC}"),
    ("\u{C486}", "\u{C486}", "\u{110A}\u{116F}\u{11AD}", "\u{C486}", "\u{110A}\u{116F}\u{11AD}"),
    ("\u{C487}", "\u{C487}", "\u{110A}\u{116F}\u{11AE}", "\u{C487}", "\u{110A}\u{116F}\u{11AE}"),
    ("\u{C488}", "\u{C488}", "\u{110A}\u{116F}\u{11AF}", "\u{C488}", "\u{110A}\u{116F}\u{11AF}"),
    ("\u{C489}", "\u{C489}", "\u{110A}\u{116F}\u{11B0}", "\u{C489}", "\u{110A}\u{116F}\u{11B0}"),
    ("\u{C48A}", "\u{C48A}", "\u{110A}\u{116F}\u{11B1}", "\u{C48A}", "\u{110A}\u{116F}\u{11B1}"),
    ("\u{C48B}", "\u{C48B}", "\u{110A}\u{116F}\u{11B2}", "\u{C48B}", "\u{110A}\u{116F}\u{11B2}"),
    ("\u{C48C}", "\u{C48C}", "\u{110A}\u{116F}\u{11B3}", "\u{C48C}", "\u{110A}\u{116F}\u{11B3}"),
    ("\u{C48D}", "\u{C48D}", "\u{110A}\u{116F}\u{11B4}", "\u{C48D}", "\u{110A}\u{116F}\u{11B4}"),
    ("\u{C48E}", "\u{C48E}", "\u{110A}\u{116F}\u{11B5}", "\u{C48E}", "\u{110A}\u{116F}\u{11B5}"),
    ("\u{C48F}", "\u{C48F}", "\u{110A}\u{116F}\u{11B6}", "\u{C48F}", "\u{110A}\u{116F}\u{11B6}"),
    ("\u{C490}", "\u{C490}", "\u{110A}\u{116F}\u{11B7}", "\u{C490}", "\u{110A}\u{116F}\u{11B7}"),
    ("\u{C491}", "\u{C491}", "\u{110A}\u{116F}\u{11B8}", "\u{C491}", "\u{110A}\u{116F}\u{11B8}"),
    ("\u{C492}", "\u{C492}", "\u{110A}\u{116F}\u{11B9}", "\u{C492}", "\u{110A}\u{116F}\u{11B9}"),
    ("\u{C493}", "\u{C493}", "\u{110A}\u{116F}\u{11BA}", "\u{C493}", "\u{110A}\u{116F}\u{11BA}"),
    ("\u{C494}", "\u{C494}", "\u{110A}\u{116F}\u{11BB}", "\u{C494}", "\u{110A}\u{116F}\u{11BB}"),
    ("\u{C495}", "\u{C495}", "\u{110A}\u{116F}\u{11BC}", "\u{C495}", "\u{110A}\u{116F}\u{11BC}"),
    ("\u{C496}", "\u{C496}", "\u{110A}\u{116F}\u{11BD}", "\u{C496}", "\u{110A}\u{116F}\u{11BD}"),
    ("\u{C497}", "\u{C497}", "\u{110A}\u{116F}\u{11BE}", "\u{C497}", "\u{110A}\u{116F}\u{11BE}"),
    ("\u{C498}", "\u{C498}", "\u{110A}\u{116F}\u{11BF}", "\u{C498}", "\u{110A}\u{116F}\u{11BF}"),
    ("\u{C499}", "\u{C499}", "\u{110A}\u{116F}\u{11C0}", "\u{C499}", "\u{110A}\u{116F}\u{11C0}"),
    ("\u{C49A}", "\u{C49A}", "\u{110A}\u{116F}\u{11C1}", "\u{C49A}", "\u{110A}\u{116F}\u{11C1}"),
    ("\u{C49B}", "\u{C49B}", "\u{110A}\u{116F}\u{11C2}", "\u{C49B}", "\u{110A}\u{116F}\u{11C2}"),
    ("\u{C49C}", "\u{C49C}", "\u{110A}\u{1170}", "\u{C49C}", "\u{110A}\u{1170}"),
    ("\u{C49D}", "\u{C49D}", "\u{110A}\u{1170}\u{11A8}", "\u{C49D}", "\u{110A}\u{1170}\u{11A8}"),
    ("\u{C49E}", "\u{C49E}", "\u{110A}\u{1170}\u{11A9}", "\u{C49E}", "\u{110A}\u{1170}\u{11A9}"),
    ("\u{C49F}", "\u{C49F}", "\u{110A}\u{1170}\u{11AA}", "\u{C49F}", "\u{110A}\u{1170}\u{11AA}"),
    ("\u{C4A0}", "\u{C4A0}", "\u{110A}\u{1170}\u{11AB}", "\u{C4A0}", "\u{110A}\u{1170}\u{11AB}"),
    ("\u{C4A1}", "\u{C4A1}", "\u{110A}\u{1170}\u{11AC}", "\u{C4A1}", "\u{110A}\u{1170}\u{11AC}"),
    ("\u{C4A2}", "\u{C4A2}", "\u{110A}\u{1170}\u{11AD}", "\u{C4A2}", "\u{110A}\u{1170}\u{11AD}"),
    ("\u{C4A3}", "\u{C4A3}", "\u{110A}\u{1170}\u{11AE}", "\u{C4A3}", "\u{110A}\u{1170}\u{11AE}"),
    ("\u{C4A4}", "\u{C4A4}", "\u{110A}\u{1170}\u{11AF}", "\u{C4A4}", "\u{110A}\u{1170}\u{11AF}"),
    ("\u{C4A5}", "\u{C4A5}", "\u{110A}\u{1170}\u{11B0}", "\u{C4A5}", "\u{110A}\u{1170}\u{11B0}"),
    ("\u{C4A6}", "\u{C4A6}", "\u{110A}\u{1170}\u{11B1}", "\u{C4A6}", "\u{110A}\u{1170}\u{11B1}"),
    ("\u{C4A7}", "\u{C4A7}", "\u{110A}\u{1170}\u{11B2}", "\u{C4A7}", "\u{110A}\u{1170}\u{11B2}"),
    ("\u{C4A8}", "\u{C4A8}", "\u{110A}\u{1170}\u{11B3}", "\u{C4A8}", "\u{110A}\u{1170}\u{11B3}"),
    ("\u{C4A9}", "\u{C4A9}", "\u{110A}\u{1170}\u{11B4}", "\u{C4A9}", "\u{110A}\u{1170}\u{11B4}"),
    ("\u{C4AA}", "\u{C4AA}", "\u{110A}\u{1170}\u{11B5}", "\u{C4AA}", "\u{110A}\u{1170}\u{11B5}"),
    ("\u{C4AB}", "\u{C4AB}", "\u{110A}\u{1170}\u{11B6}", "\u{C4AB}", "\u{110A}\u{1170}\u{11B6}"),
    ("\u{C4AC}", "\u{C4AC}", "\u{110A}\u{1170}\u{11B7}", "\u{C4AC}", "\u{110A}\u{1170}\u{11B7}"),
    ("\u{C4AD}", "\u{C4AD}", "\u{110A}\u{1170}\u{11B8}", "\u{C4AD}", "\u{110A}\u{1170}\u{11B8}"),
    ("\u{C4AE}", "\u{C4AE}", "\u{110A}\u{1170}\u{11B9}", "\u{C4AE}", "\u{110A}\u{1170}\u{11B9}"),
    ("\u{C4AF}", "\u{C4AF}", "\u{110A}\u{1170}\u{11BA}", "\u{C4AF}", "\u{110A}\u{1170}\u{11BA}"),
    ("\u{C4B0}", "\u{C4B0}", "\u{110A}\u{1170}\u{11BB}", "\u{C4B0}", "\u{110A}\u{1170}\u{11BB}"),
    ("\u{C4B1}", "\u{C4B1}", "\u{110A}\u{1170}\u{11BC}", "\u{C4B1}", "\u{110A}\u{1170}\u{11BC}"),
    ("\u{C4B2}", "\u{C4B2}", "\u{110A}\u{1170}\u{11BD}", "\u{C4B2}", "\u{110A}\u{1170}\u{11BD}"),
    ("\u{C4B3}", "\u{C4B3}", "\u{110A}\u{1170}\u{11BE}", "\u{C4B3}", "\u{110A}\u{1170}\u{11BE}"),
    ("\u{C4B4}", "\u{C4B4}", "\u{110A}\u{1170}\u{11BF}", "\u{C4B4}", "\u{110A}\u{1170}\u{11BF}"),
    ("\u{C4B5}", "\u{C4B5}", "\u{110A}\u{1170}\u{11C0}", "\u{C4B5}", "\u{110A}\u{1170}\u{11C0}"),
    ("\u{C4B6}", "\u{C4B6}", "\u{110A}\u{1170}\u{11C1}", "\u{C4B6}", "\u{110A}\u{1170}\u{11C1}"),
    ("\u{C4B7}", "\u{C4B7}", "\u{110A}\u{1170}\u{11C2}", "\u{C4B7}", "\u{110A}\u{1170}\u{11C2}"),
    ("\u{C4B8}", "\u{C4B8}", "\u{110A}\u{1171}", "\u{C4B8}", "\u{110A}\u{1171}"),
    ("\u{C4B9}", "\u{C4B9}", "\u{110A}\u{1171}\u{11A8}", "\u{C4B9}", "\u{110A}\u{1171}\u{11A8}"),
    ("\u{C4BA}", "\u{C4BA}", "\u{110A}\u{1171}\u{11A9}", "\u{C4BA}", "\u{110A}\u{1171}\u{11A9}"),
    ("\u{C4BB}", "\u{C4BB}", "\u{110A}\u{1171}\u{11AA}", "\u{C4BB}", "\u{110A}\u{1171}\u{11AA}"),
    ("\u{C4BC}", "\u{C4BC}", "\u{110A}\u{1171}\u{11AB}", "\u{C4BC}", "\u{110A}\u{1171}\u{11AB}"),
    ("\u{C4BD}", "\u{C4BD}", "\u{110A}\u{1171}\u{11AC}", "\u{C4BD}", "\u{110A}\u{1171}\u{11AC}"),
    ("\u{C4BE}", "\u{C4BE}", "\u{110A}\u{1171}\u{11AD}", "\u{C4BE}", "\u{110A}\u{1171}\u{11AD}"),
    ("\u{C4BF}", "\u{C4BF}", "\u{110A}\u{1171}\u{11AE}", "\u{C4BF}", "\u{110A}\u{1171}\u{11AE}"),
    ("\u{C4C0}", "\u{C4C0}", "\u{110A}\u{1171}\u{11AF}", "\u{C4C0}", "\u{110A}\u{1171}\u{11AF}"),
    ("\u{C4C1}", "\u{C4C1}", "\u{110A}\u{1171}\u{11B0}", "\u{C4C1}", "\u{110A}\u{1171}\u{11B0}"),
    ("\u{C4C2}", "\u{C4C2}", "\u{110A}\u{1171}\u{11B1}", "\u{C4C2}", "\u{110A}\u{1171}\u{11B1}"),
    ("\u{C4C3}", "\u{C4C3}", "\u{110A}\u{1171}\u{11B2}", "\u{C4C3}", "\u{110A}\u{1171}\u{11B2}"),
    ("\u{C4C4}", "\u{C4C4}", "\u{110A}\u{1171}\u{11B3}", "\u{C4C4}", "\u{110A}\u{1171}\u{11B3}"),
    ("\u{C4C5}", "\u{C4C5}", "\u{110A}\u{1171}\u{11B4}", "\u{C4C5}", "\u{110A}\u{1171}\u{11B4}"),
    ("\u{C4C6}", "\u{C4C6}", "\u{110A}\u{1171}\u{11B5}", "\u{C4C6}", "\u{110A}\u{1171}\u{11B5}"),
    ("\u{C4C7}", "\u{C4C7}", "\u{110A}\u{1171}\u{11B6}", "\u{C4C7}", "\u{110A}\u{1171}\u{11B6}"),
    ("\u{C4C8}", "\u{C4C8}", "\u{110A}\u{1171}\u{11B7}", "\u{C4C8}", "\u{110A}\u{1171}\u{11B7}"),
    ("\u{C4C9}", "\u{C4C9}", "\u{110A}\u{1171}\u{11B8}", "\u{C4C9}", "\u{110A}\u{1171}\u{11B8}"),
    ("\u{C4CA}", "\u{C4CA}", "\u{110A}\u{1171}\u{11B9}", "\u{C4CA}", "\u{110A}\u{1171}\u{11B9}"),
    ("\u{C4CB}", "\u{C4CB}", "\u{110A}\u{1171}\u{11BA}", "\u{C4CB}", "\u{110A}\u{1171}\u{11BA}"),
    ("\u{C4CC}", "\u{C4CC}", "\u{110A}\u{1171}\u{11BB}", "\u{C4CC}", "\u{110A}\u{1171}\u{11BB}"),
    ("\u{C4CD}", "\u{C4CD}", "\u{110A}\u{1171}\u{11BC}", "\u{C4CD}", "\u{110A}\u{1171}\u{11BC}"),
    ("\u{C4CE}", "\u{C4CE}", "\u{110A}\u{1171}\u{11BD}", "\u{C4CE}", "\u{110A}\u{1171}\u{11BD}"),
    ("\u{C4CF}", "\u{C4CF}", "\u{110A}\u{1171}\u{11BE}", "\u{C4CF}", "\u{110A}\u{1171}\u{11BE}"),
    ("\u{C4D0}", "\u{C4D0}", "\u{110A}\u{1171}\u{11BF}", "\u{C4D0}", "\u{110A}\u{1171}\u{11BF}"),
    ("\u{C4D1}", "\u{C4D1}", "\u{110A}\u{1171}\u{11C0}", "\u{C4D1}", "\u{110A}\u{1171}\u{11C0}"),
    ("\u{C4D2}", "\u{C4D2}", "\u{110A}\u{1171}\u{11C1}", "\u{C4D2}", "\u{110A}\u{1171}\u{11C1}"),
    ("\u{C4D3}", "\u{C4D3}", "\u{110A}\u{1171}\u{11C2}", "\u{C4D3}", "\u{110A}\u{1171}\u{11C2}"),
    ("\u{C4D4}", "\u{C4D4}", "\u{110A}\u{1172}", "\u{C4D4}", "\u{110A}\u{1172}"),
    ("\u{C4D5}", "\u{C4D5}", "\u{110A}\u{1172}\u{11A8}", "\u{C4D5}", "\u{110A}\u{1172}\u{11A8}"),
    ("\u{C4D6}", "\u{C4D6}", "\u{110A}\u{1172}\u{11A9}", "\u{C4D6}", "\u{110A}\u{1172}\u{11A9}"),
    ("\u{C4D7}", "\u{C4D7}", "\u{110A}\u{1172}\u{11AA}", "\u{C4D7}", "\u{110A}\u{1172}\u{11AA}"),
    ("\u{C4D8}", "\u{C4D8}", "\u{110A}\u{1172}\u{11AB}", "\u{C4D8}", "\u{110A}\u{1172}\u{11AB}"),
    ("\u{C4D9}", "\u{C4D9}", "\u{110A}\u{1172}\u{11AC}", "\u{C4D9}", "\u{110A}\u{1172}\u{11AC}"),
    ("\u{C4DA}", "\u{C4DA}", "\u{110A}\u{1172}\u{11AD}", "\u{C4DA}", "\u{110A}\u{1172}\u{11AD}"),
    ("\u{C4DB}", "\u{C4DB}", "\u{110A}\u{1172}\u{11AE}", "\u{C4DB}", "\u{110A}\u{1172}\u{11AE}"),
    ("\u{C4DC}", "\u{C4DC}", "\u{110A}\u{1172}\u{11AF}", "\u{C4DC}", "\u{110A}\u{1172}\u{11AF}"),
    ("\u{C4DD}", "\u{C4DD}", "\u{110A}\u{1172}\u{11B0}", "\u{C4DD}", "\u{110A}\u{1172}\u{11B0}"),
    ("\u{C4DE}", "\u{C4DE}", "\u{110A}\u{1172}\u{11B1}", "\u{C4DE}", "\u{110A}\u{1172}\u{11B1}"),
    ("\u{C4DF}", "\u{C4DF}", "\u{110A}\u{1172}\u{11B2}", "\u{C4DF}", "\u{110A}\u{1172}\u{11B2}"),
    ("\u{C4E0}", "\u{C4E0}", "\u{110A}\u{1172}\u{11B3}", "\u{C4E0}", "\u{110A}\u{1172}\u{11B3}"),
    ("\u{C4E1}", "\u{C4E1}", "\u{110A}\u{1172}\u{11B4}", "\u{C4E1}", "\u{110A}\u{1172}\u{11B4}"),
    ("\u{C4E2}", "\u{C4E2}", "\u{110A}\u{1172}\u{11B5}", "\u{C4E2}", "\u{110A}\u{1172}\u{11B5}"),
    ("\u{C4E3}", "\u{C4E3}", "\u{110A}\u{1172}\u{11B6}", "\u{C4E3}", "\u{110A}\u{1172}\u{11B6}"),
    ("\u{C4E4}", "\u{C4E4}", "\u{110A}\u{1172}\u{11B7}", "\u{C4E4}", "\u{110A}\u{1172}\u{11B7}"),
    ("\u{C4E5}", "\u{C4E5}", "\u{110A}\u{1172}\u{11B8}", "\u{C4E5}", "\u{110A}\u{1172}\u{11B8}"),
    ("\u{C4E6}", "\u{C4E6}", "\u{110A}\u{1172}\u{11B9}", "\u{C4E6}", "\u{110A}\u{1172}\u{11B9}"),
    ("\u{C4E7}", "\u{C4E7}", "\u{110A}\u{1172}\u{11BA}", "\u{C4E7}", "\u{110A}\u{1172}\u{11BA}"),
    ("\u{C4E8}", "\u{C4E8}", "\u{110A}\u{1172}\u{11BB}", "\u{C4E8}", "\u{110A}\u{1172}\u{11BB}"),
    ("\u{C4E9}", "\u{C4E9}", "\u{110A}\u{1172}\u{11BC}", "\u{C4E9}", "\u{110A}\u{1172}\u{11BC}"),
    ("\u{C4EA}", "\u{C4EA}", "\u{110A}\u{1172}\u{11BD}", "\u{C4EA}", "\u{110A}\u{1172}\u{11BD}"),
    ("\u{C4EB}", "\u{C4EB}", "\u{110A}\u{1172}\u{11BE}", "\u{C4EB}", "\u{110A}\u{1172}\u{11BE}"),
    ("\u{C4EC}", "\u{C4EC}", "\u{110A}\u{1172}\u{11BF}", "\u{C4EC}", "\u{110A}\u{1172}\u{11BF}"),
    ("\u{C4ED}", "\u{C4ED}", "\u{110A}\u{1172}\u{11C0}", "\u{C4ED}", "\u{110A}\u{1172}\u{11C0}"),
    ("\u{C4EE}", "\u{C4EE}", "\u{110A}\u{1172}\u{11C1}", "\u{C4EE}", "\u{110A}\u{1172}\u{11C1}"),
    ("\u{C4EF}", "\u{C4EF}", "\u{110A}\u{1172}\u{11C2}", "\u{C4EF}", "\u{110A}\u{1172}\u{11C2}"),
    ("\u{C4F0}", "\u{C4F0}", "\u{110A}\u{1173}", "\u{C4F0}", "\u{110A}\u{1173}"),
    ("\u{C4F1}", "\u{C4F1}", "\u{110A}\u{1173}\u{11A8}", "\u{C4F1}", "\u{110A}\u{1173}\u{11A8}"),
    ("\u{C4F2}", "\u{C4F2}", "\u{110A}\u{1173}\u{11A9}", "\u{C4F2}", "\u{110A}\u{1173}\u{11A9}"),
    ("\u{C4F3}", "\u{C4F3}", "\u{110A}\u{1173}\u{11AA}", "\u{C4F3}", "\u{110A}\u{1173}\u{11AA}"),
    ("\u{C4F4}", "\u{C4F4}", "\u{110A}\u{1173}\u{11AB}", "\u{C4F4}", "\u{110A}\u{1173}\u{11AB}"),
    ("\u{C4F5}", "\u{C4F5}", "\u{110A}\u{1173}\u{11AC}", "\u{C4F5}", "\u{110A}\u{1173}\u{11AC}"),
    ("\u{C4F6}", "\u{C4F6}", "\u{110A}\u{1173}\u{11AD}", "\u{C4F6}", "\u{110A}\u{1173}\u{11AD}"),
    ("\u{C4F7}", "\u{C4F7}", "\u{110A}\u{1173}\u{11AE}", "\u{C4F7}", "\u{110A}\u{1173}\u{11AE}"),
    ("\u{C4F8}", "\u{C4F8}", "\u{110A}\u{1173}\u{11AF}", "\u{C4F8}", "\u{110A}\u{1173}\u{11AF}"),
    ("\u{C4F9}", "\u{C4F9}", "\u{110A}\u{1173}\u{11B0}", "\u{C4F9}", "\u{110A}\u{1173}\u{11B0}"),
    ("\u{C4FA}", "\u{C4FA}", "\u{110A}\u{1173}\u{11B1}", "\u{C4FA}", "\u{110A}\u{1173}\u{11B1}"),
    ("\u{C4FB}", "\u{C4FB}", "\u{110A}\u{1173}\u{11B2}", "\u{C4FB}", "\u{110A}\u{1173}\u{11B2}"),
    ("\u{C4FC}", "\u{C4FC}", "\u{110A}\u{1173}\u{11B3}", "\u{C4FC}", "\u{110A}\u{1173}\u{11B3}"),
    ("\u{C4FD}", "\u{C4FD}", "\u{110A}\u{1173}\u{11B4}", "\u{C4FD}", "\u{110A}\u{1173}\u{11B4}"),
    ("\u{C4FE}", "\u{C4FE}", "\u{110A}\u{1173}\u{11B5}", "\u{C4FE}", "\u{110A}\u{1173}\u{11B5}"),
    ("\u{C4FF}", "\u{C4FF}", "\u{110A}\u{1173}\u{11B6}", "\u{C4FF}", "\u{110A}\u{1173}\u{11B6}"),
    ("\u{C500}", "\u{C500}", "\u{110A}\u{1173}\u{11B7}", "\u{C500}", "\u{110A}\u{1173}\u{11B7}"),
    ("\u{C501}", "\u{C501}", "\u{110A}\u{1173}\u{11B8}", "\u{C501}", "\u{110A}\u{1173}\u{11B8}"),
    ("\u{C502}", "\u{C502}", "\u{110A}\u{1173}\u{11B9}", "\u{C502}", "\u{110A}\u{1173}\u{11B9}"),
    ("\u{C503}", "\u{C503}", "\u{110A}\u{1173}\u{11BA}", "\u{C503}", "\u{110A}\u{1173}\u{11BA}"),
    ("\u{C504}", "\u{C504}", "\u{110A}\u{1173}\u{11BB}", "\u{C504}", "\u{110A}\u{1173}\u{11BB}"),
    ("\u{C505}", "\u{C505}", "\u{110A}\u{1173}\u{11BC}", "\u{C505}", "\u{110A}\u{1173}\u{11BC}"),
    ("\u{C506}", "\u{C506}", "\u{110A}\u{1173}\u{11BD}", "\u{C506}", "\u{110A}\u{1173}\u{11BD}"),
    ("\u{C507}", "\u{C507}", "\u{110A}\u{1173}\u{11BE}", "\u{C507}", "\u{110A}\u{1173}\u{11BE}"),
    ("\u{C508}", "\u{C508}", "\u{110A}\u{1173}\u{11BF}", "\u{C508}", "\u{110A}\u{1173}\u{11BF}"),
    ("\u{C509}", "\u{C509}", "\u{110A}\u{1173}\u{11C0}", "\u{C509}", "\u{110A}\u{1173}\u{11C0}"),
    ("\u{C50A}", "\u{C50A}", "\u{110A}\u{1173}\u{11C1}", "\u{C50A}", "\u{110A}\u{1173}\u{11C1}"),
    ("\u{C50B}", "\u{C50B}", "\u{110A}\u{1173}\u{11C2}", "\u{C50B}", "\u{110A}\u{1173}\u{11C2}"),
    ("\u{C50C}", "\u{C50C}", "\u{110A}\u{1174}", "\u{C50C}", "\u{110A}\u{1174}"),
    ("\u{C50D}", "\u{C50D}", "\u{110A}\u{1174}\u{11A8}", "\u{C50D}", "\u{110A}\u{1174}\u{11A8}"),
    ("\u{C50E}", "\u{C50E}", "\u{110A}\u{1174}\u{11A9}", "\u{C50E}", "\u{110A}\u{1174}\u{11A9}"),
    ("\u{C50F}", "\u{C50F}", "\u{110A}\u{1174}\u{11AA}", "\u{C50F}", "\u{110A}\u{1174}\u{11AA}"),
    ("\u{C510}", "\u{C510}", "\u{110A}\u{1174}\u{11AB}", "\u{C510}", "\u{110A}\u{1174}\u{11AB}"),
    ("\u{C511}", "\u{C511}", "\u{110A}\u{1174}\u{11AC}", "\u{C511}", "\u{110A}\u{1174}\u{11AC}"),
    ("\u{C512}", "\u{C512}", "\u{110A}\u{1174}\u{11AD}", "\u{C512}", "\u{110A}\u{1174}\u{11AD}"),
    ("\u{C513}", "\u{C513}", "\u{110A}\u{1174}\u{11AE}", "\u{C513}", "\u{110A}\u{1174}\u{11AE}"),
    ("\u{C514}", "\u{C514}", "\u{110A}\u{1174}\u{11AF}", "\u{C514}", "\u{110A}\u{1174}\u{11AF}"),
    ("\u{C515}", "\u{C515}", "\u{110A}\u{1174}\u{11B0}", "\u{C515}", "\u{110A}\u{1174}\u{11B0}"),
    ("\u{C516}", "\u{C516}", "\u{110A}\u{1174}\u{11B1}", "\u{C516}", "\u{110A}\u{1174}\u{11B1}"),
    ("\u{C517}", "\u{C517}", "\u{110A}\u{1174}\u{11B2}", "\u{C517}", "\u{110A}\u{1174}\u{11B2}"),
    ("\u{C518}", "\u{C518}", "\u{110A}\u{1174}\u{11B3}", "\u{C518}", "\u{110A}\u{1174}\u{11B3}"),
    ("\u{C519}", "\u{C519}", "\u{110A}\u{1174}\u{11B4}", "\u{C519}", "\u{110A}\u{1174}\u{11B4}"),
    ("\u{C51A}", "\u{C51A}", "\u{110A}\u{1174}\u{11B5}", "\u{C51A}", "\u{110A}\u{1174}\u{11B5}"),
    ("\u{C51B}", "\u{C51B}", "\u{110A}\u{1174}\u{11B6}", "\u{C51B}", "\u{110A}\u{1174}\u{11B6}"),
    ("\u{C51C}", "\u{C51C}", "\u{110A}\u{1174}\u{11B7}", "\u{C51C}", "\u{110A}\u{1174}\u{11B7}"),
    ("\u{C51D}", "\u{C51D}", "\u{110A}\u{1174}\u{11B8}", "\u{C51D}", "\u{110A}\u{1174}\u{11B8}"),
    ("\u{C51E}", "\u{C51E}", "\u{110A}\u{1174}\u{11B9}", "\u{C51E}", "\u{110A}\u{1174}\u{11B9}"),
    ("\u{C51F}", "\u{C51F}", "\u{110A}\u{1174}\u{11BA}", "\u{C51F}", "\u{110A}\u{1174}\u{11BA}"),
    ("\u{C520}", "\u{C520}", "\u{110A}\u{1174}\u{11BB}", "\u{C520}", "\u{110A}\u{1174}\u{11BB}"),
    ("\u{C521}", "\u{C521}", "\u{110A}\u{1174}\u{11BC}", "\u{C521}", "\u{110A}\u{1174}\u{11BC}"),
    ("\u{C522}", "\u{C522}", "\u{110A}\u{1174}\u{11BD}", "\u{C522}", "\u{110A}\u{1174}\u{11BD}"),
    ("\u{C523}", "\u{C523}", "\u{110A}\u{1174}\u{11BE}", "\u{C523}", "\u{110A}\u{1174}\u{11BE}"),
    ("\u{C524}", "\u{C524}", "\u{110A}\u{1174}\u{11BF}", "\u{C524}", "\u{110A}\u{1174}\u{11BF}"),
    ("\u{C525}", "\u{C525}", "\u{110A}\u{1174}\u{11C0}", "\u{C525}", "\u{110A}\u{1174}\u{11C0}"),
    ("\u{C526}", "\u{C526}", "\u{110A}\u{1174}\u{11C1}", "\u{C526}", "\u{110A}\u{1174}\u{11C1}"),
    ("\u{C527}", "\u{C527}", "\u{110A}\u{1174}\u{11C2}", "\u{C527}", "\u{110A}\u{1174}\u{11C2}"),
    ("\u{C528}", "\u{C528}", "\u{110A}\u{1175}", "\u{C528}", "\u{110A}\u{1175}"),
    ("\u{C529}", "\u{C529}", "\u{110A}\u{1175}\u{11A8}", "\u{C529}", "\u{110A}\u{1175}\u{11A8}"),
    ("\u{C52A}", "\u{C52A}", "\u{110A}\u{1175}\u{11A9}", "\u{C52A}", "\u{110A}\u{1175}\u{11A9}"),
    ("\u{C52B}", "\u{C52B}", "\u{110A}\u{1175}\u{11AA}", "\u{C52B}", "\u{110A}\u{1175}\u{11AA}"),
    ("\u{C52C}", "\u{C52C}", "\u{110A}\u{1175}\u{11AB}", "\u{C52C}", "\u{110A}\u{1175}\u{11AB}"),
    ("\u{C52D}", "\u{C52D}", "\u{110A}\u{1175}\u{11AC}", "\u{C52D}", "\u{110A}\u{1175}\u{11AC}"),
    ("\u{C52E}", "\u{C52E}", "\u{110A}\u{1175}\u{11AD}", "\u{C52E}", "\u{110A}\u{1175}\u{11AD}"),
    ("\u{C52F}", "\u{C52F}", "\u{110A}\u{1175}\u{11AE}", "\u{C52F}", "\u{110A}\u{1175}\u{11AE}"),
    ("\u{C530}", "\u{C530}", "\u{110A}\u{1175}\u{11AF}", "\u{C530}", "\u{110A}\u{1175}\u{11AF}"),
    ("\u{C531}", "\u{C531}", "\u{110A}\u{1175}\u{11B0}", "\u{C531}", "\u{110A}\u{1175}\u{11B0}"),
    ("\u{C532}", "\u{C532}", "\u{110A}\u{1175}\u{11B1}", "\u{C532}", "\u{110A}\u{1175}\u{11B1}"),
    ("\u{C533}", "\u{C533}", "\u{110A}\u{1175}\u{11B2}", "\u{C533}", "\u{110A}\u{1175}\u{11B2}"),
    ("\u{C534}", "\u{C534}", "\u{110A}\u{1175}\u{11B3}", "\u{C534}", "\u{110A}\u{1175}\u{11B3}"),
    ("\u{C535}", "\u{C535}", "\u{110A}\u{1175}\u{11B4}", "\u{C535}", "\u{110A}\u{1175}\u{11B4}"),
    ("\u{C536}", "\u{C536}", "\u{110A}\u{1175}\u{11B5}", "\u{C536}", "\u{110A}\u{1175}\u{11B5}"),
    ("\u{C537}", "\u{C537}", "\u{110A}\u{1175}\u{11B6}", "\u{C537}", "\u{110A}\u{1175}\u{11B6}"),
    ("\u{C538}", "\u{C538}", "\u{110A}\u{1175}\u{11B7}", "\u{C538}", "\u{110A}\u{1175}\u{11B7}"),
    ("\u{C539}", "\u{C539}", "\u{110A}\u{1175}\u{11B8}", "\u{C539}", "\u{110A}\u{1175}\u{11B8}"),
    ("\u{C53A}", "\u{C53A}", "\u{110A}\u{1175}\u{11B9}", "\u{C53A}", "\u{110A}\u{1175}\u{11B9}"),
    ("\u{C53B}", "\u{C53B}", "\u{110A}\u{1175}\u{11BA}", "\u{C53B}", "\u{110A}\u{1175}\u{11BA}"),
    ("\u{C53C}", "\u{C53C}", "\u{110A}\u{1175}\u{11BB}", "\u{C53C}", "\u{110A}\u{1175}\u{11BB}"),
    ("\u{C53D}", "\u{C53D}", "\u{110A}\u{1175}\u{11BC}", "\u{C53D}", "\u{110A}\u{1175}\u{11BC}"),
    ("\u{C53E}", "\u{C53E}", "\u{110A}\u{1175}\u{11BD}", "\u{C53E}", "\u{110A}\u{1175}\u{11BD}"),
    ("\u{C53F}", "\u{C53F}", "\u{110A}\u{1175}\u{11BE}", "\u{C53F}", "\u{110A}\u{1175}\u{11BE}"),
    ("\u{C540}", "\u{C540}", "\u{110A}\u{1175}\u{11BF}", "\u{C540}", "\u{110A}\u{1175}\u{11BF}"),
    ("\u{C541}", "\u{C541}", "\u{110A}\u{1175}\u{11C0}", "\u{C541}", "\u{110A}\u{1175}\u{11C0}"),
    ("\u{C542}", "\u{C542}", "\u{110A}\u{1175}\u{11C1}", "\u{C542}", "\u{110A}\u{1175}\u{11C1}"),
    ("\u{C543}", "\u{C543}", "\u{110A}\u{1175}\u{11C2}", "\u{C543}", "\u{110A}\u{1175}\u{11C2}"),
    ("\u{C544}", "\u{C544}", "\u{110B}\u{1161}", "\u{C544}", "\u{110B}\u{1161}"),
    ("\u{C545}", "\u{C545}", "\u{110B}\u{1161}\u{11A8}", "\u{C545}", "\u{110B}\u{1161}\u{11A8}"),
    ("\u{C546}", "\u{C546}", "\u{110B}\u{1161}\u{11A9}", "\u{C546}", "\u{110B}\u{1161}\u{11A9}"),
    ("\u{C547}", "\u{C547}", "\u{110B}\u{1161}\u{11AA}", "\u{C547}", "\u{110B}\u{1161}\u{11AA}"),
    ("\u{C548}", "\u{C548}", "\u{110B}\u{1161}\u{11AB}", "\u{C548}", "\u{110B}\u{1161}\u{11AB}"),
    ("\u{C549}", "\u{C549}", "\u{110B}\u{1161}\u{11AC}", "\u{C549}", "\u{110B}\u{1161}\u{11AC}"),
    ("\u{C54A}", "\u{C54A}", "\u{110B}\u{1161}\u{11AD}", "\u{C54A}", "\u{110B}\u{1161}\u{11AD}"),
    ("\u{C54B}", "\u{C54B}", "\u{110B}\u{1161}\u{11AE}", "\u{C54B}", "\u{110B}\u{1161}\u{11AE}"),
    ("\u{C54C}", "\u{C54C}", "\u{110B}\u{1161}\u{11AF}", "\u{C54C}", "\u{110B}\u{1161}\u{11AF}"),
    ("\u{C54D}", "\u{C54D}", "\u{110B}\u{1161}\u{11B0}", "\u{C54D}", "\u{110B}\u{1161}\u{11B0}"),
    ("\u{C54E}", "\u{C54E}", "\u{110B}\u{1161}\u{11B1}", "\u{C54E}", "\u{110B}\u{1161}\u{11B1}"),
    ("\u{C54F}", "\u{C54F}", "\u{110B}\u{1161}\u{11B2}", "\u{C54F}", "\u{110B}\u{1161}\u{11B2}"),
    ("\u{C550}", "\u{C550}", "\u{110B}\u{1161}\u{11B3}", "\u{C550}", "\u{110B}\u{1161}\u{11B3}"),
    ("\u{C551}", "\u{C551}", "\u{110B}\u{1161}\u{11B4}", "\u{C551}", "\u{110B}\u{1161}\u{11B4}"),
    ("\u{C552}", "\u{C552}", "\u{110B}\u{1161}\u{11B5}", "\u{C552}", "\u{110B}\u{1161}\u{11B5}"),
    ("\u{C553}", "\u{C553}", "\u{110B}\u{1161}\u{11B6}", "\u{C553}", "\u{110B}\u{1161}\u{11B6}"),
    ("\u{C554}", "\u{C554}", "\u{110B}\u{1161}\u{11B7}", "\u{C554}", "\u{110B}\u{1161}\u{11B7}"),
    ("\u{C555}", "\u{C555}", "\u{110B}\u{1161}\u{11B8}", "\u{C555}", "\u{110B}\u{1161}\u{11B8}"),
    ("\u{C556}", "\u{C556}", "\u{110B}\u{1161}\u{11B9}", "\u{C556}", "\u{110B}\u{1161}\u{11B9}"),
    ("\u{C557}", "\u{C557}", "\u{110B}\u{1161}\u{11BA}", "\u{C557}", "\u{110B}\u{1161}\u{11BA}"),
    ("\u{C558}", "\u{C558}", "\u{110B}\u{1161}\u{11BB}", "\u{C558}", "\u{110B}\u{1161}\u{11BB}"),
    ("\u{C559}", "\u{C559}", "\u{110B}\u{1161}\u{11BC}", "\u{C559}", "\u{110B}\u{1161}\u{11BC}"),
    ("\u{C55A}", "\u{C55A}", "\u{110B}\u{1161}\u{11BD}", "\u{C55A}", "\u{110B}\u{1161}\u{11BD}"),
    ("\u{C55B}", "\u{C55B}", "\u{110B}\u{1161}\u{11BE}", "\u{C55B}", "\u{110B}\u{1161}\u{11BE}"),
    ("\u{C55C}", "\u{C55C}", "\u{110B}\u{1161}\u{11BF}", "\u{C55C}", "\u{110B}\u{1161}\u{11BF}"),
    ("\u{C55D}", "\u{C55D}", "\u{110B}\u{1161}\u{11C0}", "\u{C55D}", "\u{110B}\u{1161}\u{11C0}"),
    ("\u{C55E}", "\u{C55E}", "\u{110B}\u{1161}\u{11C1}", "\u{C55E}", "\u{110B}\u{1161}\u{11C1}"),
    ("\u{C55F}", "\u{C55F}", "\u{110B}\u{1161}\u{11C2}", "\u{C55F}", "\u{110B}\u{1161}\u{11C2}"),
    ("\u{C560}", "\u{C560}", "\u{110B}\u{1162}", "\u{C560}", "\u{110B}\u{1162}"),
    ("\u{C561}", "\u{C561}", "\u{110B}\u{1162}\u{11A8}", "\u{C561}", "\u{110B}\u{1162}\u{11A8}"),
    ("\u{C562}", "\u{C562}", "\u{110B}\u{1162}\u{11A9}", "\u{C562}", "\u{110B}\u{1162}\u{11A9}"),
    ("\u{C563}", "\u{C563}", "\u{110B}\u{1162}\u{11AA}", "\u{C563}", "\u{110B}\u{1162}\u{11AA}"),
    ("\u{C564}", "\u{C564}", "\u{110B}\u{1162}\u{11AB}", "\u{C564}", "\u{110B}\u{1162}\u{11AB}"),
    ("\u{C565}", "\u{C565}", "\u{110B}\u{1162}\u{11AC}", "\u{C565}", "\u{110B}\u{1162}\u{11AC}"),
    ("\u{C566}", "\u{C566}", "\u{110B}\u{1162}\u{11AD}", "\u{C566}", "\u{110B}\u{1162}\u{11AD}"),
    ("\u{C567}", "\u{C567}", "\u{110B}\u{1162}\u{11AE}", "\u{C567}", "\u{110B}\u{1162}\u{11AE}"),
    ("\u{C568}", "\u{C568}", "\u{110B}\u{1162}\u{11AF}", "\u{C568}", "\u{110B}\u{1162}\u{11AF}"),
    ("\u{C569}", "\u{C569}", "\u{110B}\u{1162}\u{11B0}", "\u{C569}", "\u{110B}\u{1162}\u{11B0}"),
    ("\u{C56A}", "\u{C56A}", "\u{110B}\u{1162}\u{11B1}", "\u{C56A}", "\u{110B}\u{1162}\u{11B1}"),
    ("\u{C56B}", "\u{C56B}", "\u{110B}\u{1162}\u{11B2}", "\u{C56B}", "\u{110B}\u{1162}\u{11B2}"),
    ("\u{C56C}", "\u{C56C}", "\u{110B}\u{1162}\u{11B3}", "\u{C56C}", "\u{110B}\u{1162}\u{11B3}"),
    ("\u{C56D}", "\u{C56D}", "\u{110B}\u{1162}\u{11B4}", "\u{C56D}", "\u{110B}\u{1162}\u{11B4}"),
    ("\u{C56E}", "\u{C56E}", "\u{110B}\u{1162}\u{11B5}", "\u{C56E}", "\u{110B}\u{1162}\u{11B5}"),
    ("\u{C56F}", "\u{C56F}", "\u{110B}\u{1162}\u{11B6}", "\u{C56F}", "\u{110B}\u{1162}\u{11B6}"),
    ("\u{C570}", "\u{C570}", "\u{110B}\u{1162}\u{11B7}", "\u{C570}", "\u{110B}\u{1162}\u{11B7}"),
    ("\u{C571}", "\u{C571}", "\u{110B}\u{1162}\u{11B8}", "\u{C571}", "\u{110B}\u{1162}\u{11B8}"),
    ("\u{C572}", "\u{C572}", "\u{110B}\u{1162}\u{11B9}", "\u{C572}", "\u{110B}\u{1162}\u{11B9}"),
    ("\u{C573}", "\u{C573}", "\u{110B}\u{1162}\u{11BA}", "\u{C573}", "\u{110B}\u{1162}\u{11BA}"),
    ("\u{C574}", "\u{C574}", "\u{110B}\u{1162}\u{11BB}", "\u{C574}", "\u{110B}\u{1162}\u{11BB}"),
    ("\u{C575}", "\u{C575}", "\u{110B}\u{1162}\u{11BC}", "\u{C575}", "\u{110B}\u{1162}\u{11BC}"),
    ("\u{C576}", "\u{C576}", "\u{110B}\u{1162}\u{11BD}", "\u{C576}", "\u{110B}\u{1162}\u{11BD}"),
    ("\u{C577}", "\u{C577}", "\u{110B}\u{1162}\u{11BE}", "\u{C577}", "\u{110B}\u{1162}\u{11BE}"),
    ("\u{C578}", "\u{C578}", "\u{110B}\u{1162}\u{11BF}", "\u{C578}", "\u{110B}\u{1162}\u{11BF}"),
    ("\u{C579}", "\u{C579}", "\u{110B}\u{1162}\u{11C0}", "\u{C579}", "\u{110B}\u{1162}\u{11C0}"),
    ("\u{C57A}", "\u{C57A}", "\u{110B}\u{1162}\u{11C1}", "\u{C57A}", "\u{110B}\u{1162}\u{11C1}"),
    ("\u{C57B}", "\u{C57B}", "\u{110B}\u{1162}\u{11C2}", "\u{C57B}", "\u{110B}\u{1162}\u{11C2}"),
    ("\u{C57C}", "\u{C57C}", "\u{110B}\u{1163}", "\u{C57C}", "\u{110B}\u{1163}"),
    ("\u{C57D}", "\u{C57D}", "\u{110B}\u{1163}\u{11A8}", "\u{C57D}", "\u{110B}\u{1163}\u{11A8}"),
    ("\u{C57E}", "\u{C57E}", "\u{110B}\u{1163}\u{11A9}", "\u{C57E}", "\u{110B}\u{1163}\u{11A9}"),
    ("\u{C57F}", "\u{C57F}", "\u{110B}\u{1163}\u{11AA}", "\u{C57F}", "\u{110B}\u{1163}\u{11AA}"),
    ("\u{C580}", "\u{C580}", "\u{110B}\u{1163}\u{11AB}", "\u{C580}", "\u{110B}\u{1163}\u{11AB}"),
    ("\u{C581}", "\u{C581}", "\u{110B}\u{1163}\u{11AC}", "\u{C581}", "\u{110B}\u{1163}\u{11AC}"),
    ("\u{C582}", "\u{C582}", "\u{110B}\u{1163}\u{11AD}", "\u{C582}", "\u{110B}\u{1163}\u{11AD}"),
    ("\u{C583}", "\u{C583}", "\u{110B}\u{1163}\u{11AE}", "\u{C583}", "\u{110B}\u{1163}\u{11AE}"),
    ("\u{C584}", "\u{C584}", "\u{110B}\u{1163}\u{11AF}", "\u{C584}", "\u{110B}\u{1163}\u{11AF}"),
    ("\u{C585}", "\u{C585}", "\u{110B}\u{1163}\u{11B0}", "\u{C585}", "\u{110B}\u{1163}\u{11B0}"),
    ("\u{C586}", "\u{C586}", "\u{110B}\u{1163}\u{11B1}", "\u{C586}", "\u{110B}\u{1163}\u{11B1}"),
    ("\u{C587}", "\u{C587}", "\u{110B}\u{1163}\u{11B2}", "\u{C587}", "\u{110B}\u{1163}\u{11B2}"),
    ("\u{C588}", "\u{C588}", "\u{110B}\u{1163}\u{11B3}", "\u{C588}", "\u{110B}\u{1163}\u{11B3}"),
    ("\u{C589}", "\u{C589}", "\u{110B}\u{1163}\u{11B4}", "\u{C589}", "\u{110B}\u{1163}\u{11B4}"),
    ("\u{C58A}", "\u{C58A}", "\u{110B}\u{1163}\u{11B5}", "\u{C58A}", "\u{110B}\u{1163}\u{11B5}"),
    ("\u{C58B}", "\u{C58B}", "\u{110B}\u{1163}\u{11B6}", "\u{C58B}", "\u{110B}\u{1163}\u{11B6}"),
    ("\u{C58C}", "\u{C58C}", "\u{110B}\u{1163}\u{11B7}", "\u{C58C}", "\u{110B}\u{1163}\u{11B7}"),
    ("\u{C58D}", "\u{C58D}", "\u{110B}\u{1163}\u{11B8}", "\u{C58D}", "\u{110B}\u{1163}\u{11B8}"),
    ("\u{C58E}", "\u{C58E}", "\u{110B}\u{1163}\u{11B9}", "\u{C58E}", "\u{110B}\u{1163}\u{11B9}"),
    ("\u{C58F}", "\u{C58F}", "\u{110B}\u{1163}\u{11BA}", "\u{C58F}", "\u{110B}\u{1163}\u{11BA}"),
    ("\u{C590}", "\u{C590}", "\u{110B}\u{1163}\u{11BB}", "\u{C590}", "\u{110B}\u{1163}\u{11BB}"),
    ("\u{C591}", "\u{C591}", "\u{110B}\u{1163}\u{11BC}", "\u{C591}", "\u{110B}\u{1163}\u{11BC}"),
    ("\u{C592}", "\u{C592}", "\u{110B}\u{1163}\u{11BD}", "\u{C592}", "\u{110B}\u{1163}\u{11BD}"),
    ("\u{C593}", "\u{C593}", "\u{110B}\u{1163}\u{11BE}", "\u{C593}", "\u{110B}\u{1163}\u{11BE}"),
    ("\u{C594}", "\u{C594}", "\u{110B}\u{1163}\u{11BF}", "\u{C594}", "\u{110B}\u{1163}\u{11BF}"),
    ("\u{C595}", "\u{C595}", "\u{110B}\u{1163}\u{11C0}", "\u{C595}", "\u{110B}\u{1163}\u{11C0}"),
    ("\u{C596}", "\u{C596}", "\u{110B}\u{1163}\u{11C1}", "\u{C596}", "\u{110B}\u{1163}\u{11C1}"),
    ("\u{C597}", "\u{C597}", "\u{110B}\u{1163}\u{11C2}", "\u{C597}", "\u{110B}\u{1163}\u{11C2}"),
    ("\u{C598}", "\u{C598}", "\u{110B}\u{1164}", "\u{C598}", "\u{110B}\u{1164}"),
    ("\u{C599}", "\u{C599}", "\u{110B}\u{1164}\u{11A8}", "\u{C599}", "\u{110B}\u{1164}\u{11A8}"),
    ("\u{C59A}", "\u{C59A}", "\u{110B}\u{1164}\u{11A9}", "\u{C59A}", "\u{110B}\u{1164}\u{11A9}"),
    ("\u{C59B}", "\u{C59B}", "\u{110B}\u{1164}\u{11AA}", "\u{C59B}", "\u{110B}\u{1164}\u{11AA}"),
    ("\u{C59C}", "\u{C59C}", "\u{110B}\u{1164}\u{11AB}", "\u{C59C}", "\u{110B}\u{1164}\u{11AB}"),
    ("\u{C59D}", "\u{C59D}", "\u{110B}\u{1164}\u{11AC}", "\u{C59D}", "\u{110B}\u{1164}\u{11AC}"),
    ("\u{C59E}", "\u{C59E}", "\u{110B}\u{1164}\u{11AD}", "\u{C59E}", "\u{110B}\u{1164}\u{11AD}"),
    ("\u{C59F}", "\u{C59F}", "\u{110B}\u{1164}\u{11AE}", "\u{C59F}", "\u{110B}\u{1164}\u{11AE}"),
    ("\u{C5A0}", "\u{C5A0}", "\u{110B}\u{1164}\u{11AF}", "\u{C5A0}", "\u{110B}\u{1164}\u{11AF}"),
    ("\u{C5A1}", "\u{C5A1}", "\u{110B}\u{1164}\u{11B0}", "\u{C5A1}", "\u{110B}\u{1164}\u{11B0}"),
    ("\u{C5A2}", "\u{C5A2}", "\u{110B}\u{1164}\u{11B1}", "\u{C5A2}", "\u{110B}\u{1164}\u{11B1}"),
    ("\u{C5A3}", "\u{C5A3}", "\u{110B}\u{1164}\u{11B2}", "\u{C5A3}", "\u{110B}\u{1164}\u{11B2}"),
    ("\u{C5A4}", "\u{C5A4}", "\u{110B}\u{1164}\u{11B3}", "\u{C5A4}", "\u{110B}\u{1164}\u{11B3}"),
    ("\u{C5A5}", "\u{C5A5}", "\u{110B}\u{1164}\u{11B4}", "\u{C5A5}", "\u{110B}\u{1164}\u{11B4}"),
    ("\u{C5A6}", "\u{C5A6}", "\u{110B}\u{1164}\u{11B5}", "\u{C5A6}", "\u{110B}\u{1164}\u{11B5}"),
    ("\u{C5A7}", "\u{C5A7}", "\u{110B}\u{1164}\u{11B6}", "\u{C5A7}", "\u{110B}\u{1164}\u{11B6}"),
    ("\u{C5A8}", "\u{C5A8}", "\u{110B}\u{1164}\u{11B7}", "\u{C5A8}", "\u{110B}\u{1164}\u{11B7}"),
    ("\u{C5A9}", "\u{C5A9}", "\u{110B}\u{1164}\u{11B8}", "\u{C5A9}", "\u{110B}\u{1164}\u{11B8}"),
    ("\u{C5AA}", "\u{C5AA}", "\u{110B}\u{1164}\u{11B9}", "\u{C5AA}", "\u{110B}\u{1164}\u{11B9}"),
    ("\u{C5AB}", "\u{C5AB}", "\u{110B}\u{1164}\u{11BA}", "\u{C5AB}", "\u{110B}\u{1164}\u{11BA}"),
    ("\u{C5AC}", "\u{C5AC}", "\u{110B}\u{1164}\u{11BB}", "\u{C5AC}", "\u{110B}\u{1164}\u{11BB}"),
    ("\u{C5AD}", "\u{C5AD}", "\u{110B}\u{1164}\u{11BC}", "\u{C5AD}", "\u{110B}\u{1164}\u{11BC}"),
    ("\u{C5AE}", "\u{C5AE}", "\u{110B}\u{1164}\u{11BD}", "\u{C5AE}", "\u{110B}\u{1164}\u{11BD}"),
    ("\u{C5AF}", "\u{C5AF}", "\u{110B}\u{1164}\u{11BE}", "\u{C5AF}", "\u{110B}\u{1164}\u{11BE}"),
    ("\u{C5B0}", "\u{C5B0}", "\u{110B}\u{1164}\u{11BF}", "\u{C5B0}", "\u{110B}\u{1164}\u{11BF}"),
    ("\u{C5B1}", "\u{C5B1}", "\u{110B}\u{1164}\u{11C0}", "\u{C5B1}", "\u{110B}\u{1164}\u{11C0}"),
    ("\u{C5B2}", "\u{C5B2}", "\u{110B}\u{1164}\u{11C1}", "\u{C5B2}", "\u{110B}\u{1164}\u{11C1}"),
    ("\u{C5B3}", "\u{C5B3}", "\u{110B}\u{1164}\u{11C2}", "\u{C5B3}", "\u{110B}\u{1164}\u{11C2}"),
    ("\u{C5B4}", "\u{C5B4}", "\u{110B}\u{1165}", "\u{C5B4}", "\u{110B}\u{1165}"),
    ("\u{C5B5}", "\u{C5B5}", "\u{110B}\u{1165}\u{11A8}", "\u{C5B5}", "\u{110B}\u{1165}\u{11A8}"),
    ("\u{C5B6}", "\u{C5B6}", "\u{110B}\u{1165}\u{11A9}", "\u{C5B6}", "\u{110B}\u{1165}\u{11A9}"),
    ("\u{C5B7}", "\u{C5B7}", "\u{110B}\u{1165}\u{11AA}", "\u{C5B7}", "\u{110B}\u{1165}\u{11AA}"),
    ("\u{C5B8}", "\u{C5B8}", "\u{110B}\u{1165}\u{11AB}", "\u{C5B8}", "\u{110B}\u{1165}\u{11AB}"),
    ("\u{C5B9}", "\u{C5B9}", "\u{110B}\u{1165}\u{11AC}", "\u{C5B9}", "\u{110B}\u{1165}\u{11AC}"),
    ("\u{C5BA}", "\u{C5BA}", "\u{110B}\u{1165}\u{11AD}", "\u{C5BA}", "\u{110B}\u{1165}\u{11AD}"),
    ("\u{C5BB}", "\u{C5BB}", "\u{110B}\u{1165}\u{11AE}", "\u{C5BB}", "\u{110B}\u{1165}\u{11AE}"),
    ("\u{C5BC}", "\u{C5BC}", "\u{110B}\u{1165}\u{11AF}", "\u{C5BC}", "\u{110B}\u{1165}\u{11AF}"),
    ("\u{C5BD}", "\u{C5BD}", "\u{110B}\u{1165}\u{11B0}", "\u{C5BD}", "\u{110B}\u{1165}\u{11B0}"),
    ("\u{C5BE}", "\u{C5BE}", "\u{110B}\u{1165}\u{11B1}", "\u{C5BE}", "\u{110B}\u{1165}\u{11B1}"),
    ("\u{C5BF}", "\u{C5BF}", "\u{110B}\u{1165}\u{11B2}", "\u{C5BF}", "\u{110B}\u{1165}\u{11B2}"),
    ("\u{C5C0}", "\u{C5C0}", "\u{110B}\u{1165}\u{11B3}", "\u{C5C0}", "\u{110B}\u{1165}\u{11B3}"),
    ("\u{C5C1}", "\u{C5C1}", "\u{110B}\u{1165}\u{11B4}", "\u{C5C1}", "\u{110B}\u{1165}\u{11B4}"),
    ("\u{C5C2}", "\u{C5C2}", "\u{110B}\u{1165}\u{11B5}", "\u{C5C2}", "\u{110B}\u{1165}\u{11B5}"),
    ("\u{C5C3}", "\u{C5C3}", "\u{110B}\u{1165}\u{11B6}", "\u{C5C3}", "\u{110B}\u{1165}\u{11B6}"),
    ("\u{C5C4}", "\u{C5C4}", "\u{110B}\u{1165}\u{11B7}", "\u{C5C4}", "\u{110B}\u{1165}\u{11B7}"),
    ("\u{C5C5}", "\u{C5C5}", "\u{110B}\u{1165}\u{11B8}", "\u{C5C5}", "\u{110B}\u{1165}\u{11B8}"),
    ("\u{C5C6}", "\u{C5C6}", "\u{110B}\u{1165}\u{11B9}", "\u{C5C6}", "\u{110B}\u{1165}\u{11B9}"),
    ("\u{C5C7}", "\u{C5C7}", "\u{110B}\u{1165}\u{11BA}", "\u{C5C7}", "\u{110B}\u{1165}\u{11BA}"),
    ("\u{C5C8}", "\u{C5C8}", "\u{110B}\u{1165}\u{11BB}", "\u{C5C8}", "\u{110B}\u{1165}\u{11BB}"),
    ("\u{C5C9}", "\u{C5C9}", "\u{110B}\u{1165}\u{11BC}", "\u{C5C9}", "\u{110B}\u{1165}\u{11BC}"),
    ("\u{C5CA}", "\u{C5CA}", "\u{110B}\u{1165}\u{11BD}", "\u{C5CA}", "\u{110B}\u{1165}\u{11BD}"),
    ("\u{C5CB}", "\u{C5CB}", "\u{110B}\u{1165}\u{11BE}", "\u{C5CB}", "\u{110B}\u{1165}\u{11BE}"),
    ("\u{C5CC}", "\u{C5CC}", "\u{110B}\u{1165}\u{11BF}", "\u{C5CC}", "\u{110B}\u{1165}\u{11BF}"),
    ("\u{C5CD}", "\u{C5CD}", "\u{110B}\u{1165}\u{11C0}", "\u{C5CD}", "\u{110B}\u{1165}\u{11C0}"),
    ("\u{C5CE}", "\u{C5CE}", "\u{110B}\u{1165}\u{11C1}", "\u{C5CE}", "\u{110B}\u{1165}\u{11C1}"),
    ("\u{C5CF}", "\u{C5CF}", "\u{110B}\u{1165}\u{11C2}", "\u{C5CF}", "\u{110B}\u{1165}\u{11C2}"),
    ("\u{C5D0}", "\u{C5D0}", "\u{110B}\u{1166}", "\u{C5D0}", "\u{110B}\u{1166}"),
    ("\u{C5D1}", "\u{C5D1}", "\u{110B}\u{1166}\u{11A8}", "\u{C5D1}", "\u{110B}\u{1166}\u{11A8}"),
    ("\u{C5D2}", "\u{C5D2}", "\u{110B}\u{1166}\u{11A9}", "\u{C5D2}", "\u{110B}\u{1166}\u{11A9}"),
    ("\u{C5D3}", "\u{C5D3}", "\u{110B}\u{1166}\u{11AA}", "\u{C5D3}", "\u{110B}\u{1166}\u{11AA}"),
    ("\u{C5D4}", "\u{C5D4}", "\u{110B}\u{1166}\u{11AB}", "\u{C5D4}", "\u{110B}\u{1166}\u{11AB}"),
    ("\u{C5D5}", "\u{C5D5}", "\u{110B}\u{1166}\u{11AC}", "\u{C5D5}", "\u{110B}\u{1166}\u{11AC}"),
    ("\u{C5D6}", "\u{C5D6}", "\u{110B}\u{1166}\u{11AD}", "\u{C5D6}", "\u{110B}\u{1166}\u{11AD}"),
    ("\u{C5D7}", "\u{C5D7}", "\u{110B}\u{1166}\u{11AE}", "\u{C5D7}", "\u{110B}\u{1166}\u{11AE}"),
    ("\u{C5D8}", "\u{C5D8}", "\u{110B}\u{1166}\u{11AF}", "\u{C5D8}", "\u{110B}\u{1166}\u{11AF}"),
    ("\u{C5D9}", "\u{C5D9}", "\u{110B}\u{1166}\u{11B0}", "\u{C5D9}", "\u{110B}\u{1166}\u{11B0}"),
    ("\u{C5DA}", "\u{C5DA}", "\u{110B}\u{1166}\u{11B1}", "\u{C5DA}", "\u{110B}\u{1166}\u{11B1}"),
    ("\u{C5DB}", "\u{C5DB}", "\u{110B}\u{1166}\u{11B2}", "\u{C5DB}", "\u{110B}\u{1166}\u{11B2}"),
    ("\u{C5DC}", "\u{C5DC}", "\u{110B}\u{1166}\u{11B3}", "\u{C5DC}", "\u{110B}\u{1166}\u{11B3}"),
    ("\u{C5DD}", "\u{C5DD}", "\u{110B}\u{1166}\u{11B4}", "\u{C5DD}", "\u{110B}\u{1166}\u{11B4}"),
    ("\u{C5DE}", "\u{C5DE}", "\u{110B}\u{1166}\u{11B5}", "\u{C5DE}", "\u{110B}\u{1166}\u{11B5}"),
    ("\u{C5DF}", "\u{C5DF}", "\u{110B}\u{1166}\u{11B6}", "\u{C5DF}", "\u{110B}\u{1166}\u{11B6}"),
    ("\u{C5E0}", "\u{C5E0}", "\u{110B}\u{1166}\u{11B7}", "\u{C5E0}", "\u{110B}\u{1166}\u{11B7}"),
    ("\u{C5E1}", "\u{C5E1}", "\u{110B}\u{1166}\u{11B8}", "\u{C5E1}", "\u{110B}\u{1166}\u{11B8}"),
    ("\u{C5E2}", "\u{C5E2}", "\u{110B}\u{1166}\u{11B9}", "\u{C5E2}", "\u{110B}\u{1166}\u{11B9}"),
    ("\u{C5E3}", "\u{C5E3}", "\u{110B}\u{1166}\u{11BA}", "\u{C5E3}", "\u{110B}\u{1166}\u{11BA}"),
    ("\u{C5E4}", "\u{C5E4}", "\u{110B}\u{1166}\u{11BB}", "\u{C5E4}", "\u{110B}\u{1166}\u{11BB}"),
    ("\u{C5E5}", "\u{C5E5}", "\u{110B}\u{1166}\u{11BC}", "\u{C5E5}", "\u{110B}\u{1166}\u{11BC}"),
    ("\u{C5E6}", "\u{C5E6}", "\u{110B}\u{1166}\u{11BD}", "\u{C5E6}", "\u{110B}\u{1166}\u{11BD}"),
    ("\u{C5E7}", "\u{C5E7}", "\u{110B}\u{1166}\u{11BE}", "\u{C5E7}", "\u{110B}\u{1166}\u{11BE}"),
    ("\u{C5E8}", "\u{C5E8}", "\u{110B}\u{1166}\u{11BF}", "\u{C5E8}", "\u{110B}\u{1166}\u{11BF}"),
    ("\u{C5E9}", "\u{C5E9}", "\u{110B}\u{1166}\u{11C0}", "\u{C5E9}", "\u{110B}\u{1166}\u{11C0}"),
    ("\u{C5EA}", "\u{C5EA}", "\u{110B}\u{1166}\u{11C1}", "\u{C5EA}", "\u{110B}\u{1166}\u{11C1}"),
    ("\u{C5EB}", "\u{C5EB}", "\u{110B}\u{1166}\u{11C2}", "\u{C5EB}", "\u{110B}\u{1166}\u{11C2}"),
    ("\u{C5EC}", "\u{C5EC}", "\u{110B}\u{1167}", "\u{C5EC}", "\u{110B}\u{1167}"),
    ("\u{C5ED}", "\u{C5ED}", "\u{110B}\u{1167}\u{11A8}", "\u{C5ED}", "\u{110B}\u{1167}\u{11A8}"),
    ("\u{C5EE}", "\u{C5EE}", "\u{110B}\u{1167}\u{11A9}", "\u{C5EE}", "\u{110B}\u{1167}\u{11A9}"),
    ("\u{C5EF}", "\u{C5EF}", "\u{110B}\u{1167}\u{11AA}", "\u{C5EF}", "\u{110B}\u{1167}\u{11AA}"),
    ("\u{C5F0}", "\u{C5F0}", "\u{110B}\u{1167}\u{11AB}", "\u{C5F0}", "\u{110B}\u{1167}\u{11AB}"),
    ("\u{C5F1}", "\u{C5F1}", "\u{110B}\u{1167}\u{11AC}", "\u{C5F1}", "\u{110B}\u{1167}\u{11AC}"),
    ("\u{C5F2}", "\u{C5F2}", "\u{110B}\u{1167}\u{11AD}", "\u{C5F2}", "\u{110B}\u{1167}\u{11AD}"),
    ("\u{C5F3}", "\u{C5F3}", "\u{110B}\u{1167}\u{11AE}", "\u{C5F3}", "\u{110B}\u{1167}\u{11AE}"),
    ("\u{C5F4}", "\u{C5F4}", "\u{110B}\u{1167}\u{11AF}", "\u{C5F4}", "\u{110B}\u{1167}\u{11AF}"),
    ("\u{C5F5}", "\u{C5F5}", "\u{110B}\u{1167}\u{11B0}", "\u{C5F5}", "\u{110B}\u{1167}\u{11B0}"),
    ("\u{C5F6}", "\u{C5F6}", "\u{110B}\u{1167}\u{11B1}", "\u{C5F6}", "\u{110B}\u{1167}\u{11B1}"),
    ("\u{C5F7}", "\u{C5F7}", "\u{110B}\u{1167}\u{11B2}", "\u{C5F7}", "\u{110B}\u{1167}\u{11B2}"),
    ("\u{C5F8}", "\u{C5F8}", "\u{110B}\u{1167}\u{11B3}", "\u{C5F8}", "\u{110B}\u{1167}\u{11B3}"),
    ("\u{C5F9}", "\u{C5F9}", "\u{110B}\u{1167}\u{11B4}", "\u{C5F9}", "\u{110B}\u{1167}\u{11B4}"),
    ("\u{C5FA}", "\u{C5FA}", "\u{110B}\u{1167}\u{11B5}", "\u{C5FA}", "\u{110B}\u{1167}\u{11B5}"),
    ("\u{C5FB}", "\u{C5FB}", "\u{110B}\u{1167}\u{11B6}", "\u{C5FB}", "\u{110B}\u{1167}\u{11B6}"),
    ("\u{C5FC}", "\u{C5FC}", "\u{110B}\u{1167}\u{11B7}", "\u{C5FC}", "\u{110B}\u{1167}\u{11B7}"),
    ("\u{C5FD}", "\u{C5FD}", "\u{110B}\u{1167}\u{11B8}", "\u{C5FD}", "\u{110B}\u{1167}\u{11B8}"),
    ("\u{C5FE}", "\u{C5FE}", "\u{110B}\u{1167}\u{11B9}", "\u{C5FE}", "\u{110B}\u{1167}\u{11B9}"),
    ("\u{C5FF}", "\u{C5FF}", "\u{110B}\u{1167}\u{11BA}", "\u{C5FF}", "\u{110B}\u{1167}\u{11BA}"),
    ("\u{C600}", "\u{C600}", "\u{110B}\u{1167}\u{11BB}", "\u{C600}", "\u{110B}\u{1167}\u{11BB}"),
    ("\u{C601}", "\u{C601}", "\u{110B}\u{1167}\u{11BC}", "\u{C601}", "\u{110B}\u{1167}\u{11BC}"),
    ("\u{C602}", "\u{C602}", "\u{110B}\u{1167}\u{11BD}", "\u{C602}", "\u{110B}\u{1167}\u{11BD}"),
    ("\u{C603}", "\u{C603}", "\u{110B}\u{1167}\u{11BE}", "\u{C603}", "\u{110B}\u{1167}\u{11BE}"),
    ("\u{C604}", "\u{C604}", "\u{110B}\u{1167}\u{11BF}", "\u{C604}", "\u{110B}\u{1167}\u{11BF}"),
    ("\u{C605}", "\u{C605}", "\u{110B}\u{1167}\u{11C0}", "\u{C605}", "\u{110B}\u{1167}\u{11C0}"),
    ("\u{C606}", "\u{C606}", "\u{110B}\u{1167}\u{11C1}", "\u{C606}", "\u{110B}\u{1167}\u{11C1}"),
    ("\u{C607}", "\u{C607}", "\u{110B}\u{1167}\u{11C2}", "\u{C607}", "\u{110B}\u{1167}\u{11C2}"),
    ("\u{C608}", "\u{C608}", "\u{110B}\u{1168}", "\u{C608}", "\u{110B}\u{1168}"),
    ("\u{C609}", "\u{C609}", "\u{110B}\u{1168}\u{11A8}", "\u{C609}", "\u{110B}\u{1168}\u{11A8}"),
    ("\u{C60A}", "\u{C60A}", "\u{110B}\u{1168}\u{11A9}", "\u{C60A}", "\u{110B}\u{1168}\u{11A9}"),
    ("\u{C60B}", "\u{C60B}", "\u{110B}\u{1168}\u{11AA}", "\u{C60B}", "\u{110B}\u{1168}\u{11AA}"),
    ("\u{C60C}", "\u{C60C}", "\u{110B}\u{1168}\u{11AB}", "\u{C60C}", "\u{110B}\u{1168}\u{11AB}"),
    ("\u{C60D}", "\u{C60D}", "\u{110B}\u{1168}\u{11AC}", "\u{C60D}", "\u{110B}\u{1168}\u{11AC}"),
    ("\u{C60E}", "\u{C60E}", "\u{110B}\u{1168}\u{11AD}", "\u{C60E}", "\u{110B}\u{1168}\u{11AD}"),
    ("\u{C60F}", "\u{C60F}", "\u{110B}\u{1168}\u{11AE}", "\u{C60F}", "\u{110B}\u{1168}\u{11AE}"),
    ("\u{C610}", "\u{C610}", "\u{110B}\u{1168}\u{11AF}", "\u{C610}", "\u{110B}\u{1168}\u{11AF}"),
    ("\u{C611}", "\u{C611}", "\u{110B}\u{1168}\u{11B0}", "\u{C611}", "\u{110B}\u{1168}\u{11B0}"),
    ("\u{C612}", "\u{C612}", "\u{110B}\u{1168}\u{11B1}", "\u{C612}", "\u{110B}\u{1168}\u{11B1}"),
    ("\u{C613}", "\u{C613}", "\u{110B}\u{1168}\u{11B2}", "\u{C613}", "\u{110B}\u{1168}\u{11B2}"),
    ("\u{C614}", "\u{C614}", "\u{110B}\u{1168}\u{11B3}", "\u{C614}", "\u{110B}\u{1168}\u{11B3}"),
    ("\u{C615}", "\u{C615}", "\u{110B}\u{1168}\u{11B4}", "\u{C615}", "\u{110B}\u{1168}\u{11B4}"),
    ("\u{C616}", "\u{C616}", "\u{110B}\u{1168}\u{11B5}", "\u{C616}", "\u{110B}\u{1168}\u{11B5}"),
    ("\u{C617}", "\u{C617}", "\u{110B}\u{1168}\u{11B6}", "\u{C617}", "\u{110B}\u{1168}\u{11B6}"),
    ("\u{C618}", "\u{C618}", "\u{110B}\u{1168}\u{11B7}", "\u{C618}", "\u{110B}\u{1168}\u{11B7}"),
    ("\u{C619}", "\u{C619}", "\u{110B}\u{1168}\u{11B8}", "\u{C619}", "\u{110B}\u{1168}\u{11B8}"),
    ("\u{C61A}", "\u{C61A}", "\u{110B}\u{1168}\u{11B9}", "\u{C61A}", "\u{110B}\u{1168}\u{11B9}"),
    ("\u{C61B}", "\u{C61B}", "\u{110B}\u{1168}\u{11BA}", "\u{C61B}", "\u{110B}\u{1168}\u{11BA}"),
    ("\u{C61C}", "\u{C61C}", "\u{110B}\u{1168}\u{11BB}", "\u{C61C}", "\u{110B}\u{1168}\u{11BB}"),
    ("\u{C61D}", "\u{C61D}", "\u{110B}\u{1168}\u{11BC}", "\u{C61D}", "\u{110B}\u{1168}\u{11BC}"),
    ("\u{C61E}", "\u{C61E}", "\u{110B}\u{1168}\u{11BD}", "\u{C61E}", "\u{110B}\u{1168}\u{11BD}"),
    ("\u{C61F}", "\u{C61F}", "\u{110B}\u{1168}\u{11BE}", "\u{C61F}", "\u{110B}\u{1168}\u{11BE}"),
    ("\u{C620}", "\u{C620}", "\u{110B}\u{1168}\u{11BF}", "\u{C620}", "\u{110B}\u{1168}\u{11BF}"),
    ("\u{C621}", "\u{C621}", "\u{110B}\u{1168}\u{11C0}", "\u{C621}", "\u{110B}\u{1168}\u{11C0}"),
    ("\u{C622}", "\u{C622}", "\u{110B}\u{1168}\u{11C1}", "\u{C622}", "\u{110B}\u{1168}\u{11C1}"),
    ("\u{C623}", "\u{C623}", "\u{110B}\u{1168}\u{11C2}", "\u{C623}", "\u{110B}\u{1168}\u{11C2}"),
    ("\u{C624}", "\u{C624}", "\u{110B}\u{1169}", "\u{C624}", "\u{110B}\u{1169}"),
    ("\u{C625}", "\u{C625}", "\u{110B}\u{1169}\u{11A8}", "\u{C625}", "\u{110B}\u{1169}\u{11A8}"),
    ("\u{C626}", "\u{C626}", "\u{110B}\u{1169}\u{11A9}", "\u{C626}", "\u{110B}\u{1169}\u{11A9}"),
    ("\u{C627}", "\u{C627}", "\u{110B}\u{1169}\u{11AA}", "\u{C627}", "\u{110B}\u{1169}\u{11AA}"),
    ("\u{C628}", "\u{C628}", "\u{110B}\u{1169}\u{11AB}", "\u{C628}", "\u{110B}\u{1169}\u{11AB}"),
    ("\u{C629}", "\u{C629}", "\u{110B}\u{1169}\u{11AC}", "\u{C629}", "\u{110B}\u{1169}\u{11AC}"),
    ("\u{C62A}", "\u{C62A}", "\u{110B}\u{1169}\u{11AD}", "\u{C62A}", "\u{110B}\u{1169}\u{11AD}"),
    ("\u{C62B}", "\u{C62B}", "\u{110B}\u{1169}\u{11AE}", "\u{C62B}", "\u{110B}\u{1169}\u{11AE}"),
    ("\u{C62C}", "\u{C62C}", "\u{110B}\u{1169}\u{11AF}", "\u{C62C}", "\u{110B}\u{1169}\u{11AF}"),
    ("\u{C62D}", "\u{C62D}", "\u{110B}\u{1169}\u{11B0}", "\u{C62D}", "\u{110B}\u{1169}\u{11B0}"),
    ("\u{C62E}", "\u{C62E}", "\u{110B}\u{1169}\u{11B1}", "\u{C62E}", "\u{110B}\u{1169}\u{11B1}"),
    ("\u{C62F}", "\u{C62F}", "\u{110B}\u{1169}\u{11B2}", "\u{C62F}", "\u{110B}\u{1169}\u{11B2}"),
    ("\u{C630}", "\u{C630}", "\u{110B}\u{1169}\u{11B3}", "\u{C630}", "\u{110B}\u{1169}\u{11B3}"),
    ("\u{C631}", "\u{C631}", "\u{110B}\u{1169}\u{11B4}", "\u{C631}", "\u{110B}\u{1169}\u{11B4}"),
    ("\u{C632}", "\u{C632}", "\u{110B}\u{1169}\u{11B5}", "\u{C632}", "\u{110B}\u{1169}\u{11B5}"),
    ("\u{C633}", "\u{C633}", "\u{110B}\u{1169}\u{11B6}", "\u{C633}", "\u{110B}\u{1169}\u{11B6}"),
    ("\u{C634}", "\u{C634}", "\u{110B}\u{1169}\u{11B7}", "\u{C634}", "\u{110B}\u{1169}\u{11B7}"),
    ("\u{C635}", "\u{C635}", "\u{110B}\u{1169}\u{11B8}", "\u{C635}", "\u{110B}\u{1169}\u{11B8}"),
    ("\u{C636}", "\u{C636}", "\u{110B}\u{1169}\u{11B9}", "\u{C636}", "\u{110B}\u{1169}\u{11B9}"),
    ("\u{C637}", "\u{C637}", "\u{110B}\u{1169}\u{11BA}", "\u{C637}", "\u{110B}\u{1169}\u{11BA}"),
    ("\u{C638}", "\u{C638}", "\u{110B}\u{1169}\u{11BB}", "\u{C638}", "\u{110B}\u{1169}\u{11BB}"),
    ("\u{C639}", "\u{C639}", "\u{110B}\u{1169}\u{11BC}", "\u{C639}", "\u{110B}\u{1169}\u{11BC}"),
    ("\u{C63A}", "\u{C63A}", "\u{110B}\u{1169}\u{11BD}", "\u{C63A}", "\u{110B}\u{1169}\u{11BD}"),
    ("\u{C63B}", "\u{C63B}", "\u{110B}\u{1169}\u{11BE}", "\u{C63B}", "\u{110B}\u{1169}\u{11BE}"),
    ("\u{C63C}", "\u{C63C}", "\u{110B}\u{1169}\u{11BF}", "\u{C63C}", "\u{110B}\u{1169}\u{11BF}"),
    ("\u{C63D}", "\u{C63D}", "\u{110B}\u{1169}\u{11C0}", "\u{C63D}", "\u{110B}\u{1169}\u{11C0}"),
    ("\u{C63E}", "\u{C63E}", "\u{110B}\u{1169}\u{11C1}", "\u{C63E}", "\u{110B}\u{1169}\u{11C1}"),
    ("\u{C63F}", "\u{C63F}", "\u{110B}\u{1169}\u{11C2}", "\u{C63F}", "\u{110B}\u{1169}\u{11C2}"),
    ("\u{C640}", "\u{C640}", "\u{110B}\u{116A}", "\u{C640}", "\u{110B}\u{116A}"),
    ("\u{C641}", "\u{C641}", "\u{110B}\u{116A}\u{11A8}", "\u{C641}", "\u{110B}\u{116A}\u{11A8}"),
    ("\u{C642}", "\u{C642}", "\u{110B}\u{116A}\u{11A9}", "\u{C642}", "\u{110B}\u{116A}\u{11A9}"),
    ("\u{C643}", "\u{C643}", "\u{110B}\u{116A}\u{11AA}", "\u{C643}", "\u{110B}\u{116A}\u{11AA}"),
    ("\u{C644}", "\u{C644}", "\u{110B}\u{116A}\u{11AB}", "\u{C644}", "\u{110B}\u{116A}\u{11AB}"),
    ("\u{C645}", "\u{C645}", "\u{110B}\u{116A}\u{11AC}", "\u{C645}", "\u{110B}\u{116A}\u{11AC}"),
    ("\u{C646}", "\u{C646}", "\u{110B}\u{116A}\u{11AD}", "\u{C646}", "\u{110B}\u{116A}\u{11AD}"),
    ("\u{C647}", "\u{C647}", "\u{110B}\u{116A}\u{11AE}", "\u{C647}", "\u{110B}\u{116A}\u{11AE}"),
    ("\u{C648}", "\u{C648}", "\u{110B}\u{116A}\u{11AF}", "\u{C648}", "\u{110B}\u{116A}\u{11AF}"),
    ("\u{C649}", "\u{C649}", "\u{110B}\u{116A}\u{11B0}", "\u{C649}", "\u{110B}\u{116A}\u{11B0}"),
    ("\u{C64A}", "\u{C64A}", "\u{110B}\u{116A}\u{11B1}", "\u{C64A}", "\u{110B}\u{116A}\u{11B1}"),
    ("\u{C64B}", "\u{C64B}", "\u{110B}\u{116A}\u{11B2}", "\u{C64B}", "\u{110B}\u{116A}\u{11B2}"),
    ("\u{C64C}", "\u{C64C}", "\u{110B}\u{116A}\u{11B3}", "\u{C64C}", "\u{110B}\u{116A}\u{11B3}"),
    ("\u{C64D}", "\u{C64D}", "\u{110B}\u{116A}\u{11B4}", "\u{C64D}", "\u{110B}\u{116A}\u{11B4}"),
    ("\u{C64E}", "\u{C64E}", "\u{110B}\u{116A}\u{11B5}", "\u{C64E}", "\u{110B}\u{116A}\u{11B5}"),
    ("\u{C64F}", "\u{C64F}", "\u{110B}\u{116A}\u{11B6}", "\u{C64F}", "\u{110B}\u{116A}\u{11B6}"),
    ("\u{C650}", "\u{C650}", "\u{110B}\u{116A}\u{11B7}", "\u{C650}", "\u{110B}\u{116A}\u{11B7}"),
    ("\u{C651}", "\u{C651}", "\u{110B}\u{116A}\u{11B8}", "\u{C651}", "\u{110B}\u{116A}\u{11B8}"),
    ("\u{C652}", "\u{C652}", "\u{110B}\u{116A}\u{11B9}", "\u{C652}", "\u{110B}\u{116A}\u{11B9}"),
    ("\u{C653}", "\u{C653}", "\u{110B}\u{116A}\u{11BA}", "\u{C653}", "\u{110B}\u{116A}\u{11BA}"),
    ("\u{C654}", "\u{C654}", "\u{110B}\u{116A}\u{11BB}", "\u{C654}", "\u{110B}\u{116A}\u{11BB}"),
    ("\u{C655}", "\u{C655}", "\u{110B}\u{116A}\u{11BC}", "\u{C655}", "\u{110B}\u{116A}\u{11BC}"),
    ("\u{C656}", "\u{C656}", "\u{110B}\u{116A}\u{11BD}", "\u{C656}", "\u{110B}\u{116A}\u{11BD}"),
    ("\u{C657}", "\u{C657}", "\u{110B}\u{116A}\u{11BE}", "\u{C657}", "\u{110B}\u{116A}\u{11BE}"),
    ("\u{C658}", "\u{C658}", "\u{110B}\u{116A}\u{11BF}", "\u{C658}", "\u{110B}\u{116A}\u{11BF}"),
    ("\u{C659}", "\u{C659}", "\u{110B}\u{116A}\u{11C0}", "\u{C659}", "\u{110B}\u{116A}\u{11C0}"),
    ("\u{C65A}", "\u{C65A}", "\u{110B}\u{116A}\u{11C1}", "\u{C65A}", "\u{110B}\u{116A}\u{11C1}"),
    ("\u{C65B}", "\u{C65B}", "\u{110B}\u{116A}\u{11C2}", "\u{C65B}", "\u{110B}\u{116A}\u{11C2}"),
    ("\u{C65C}", "\u{C65C}", "\u{110B}\u{116B}", "\u{C65C}", "\u{110B}\u{116B}"),
    ("\u{C65D}", "\u{C65D}", "\u{110B}\u{116B}\u{11A8}", "\u{C65D}", "\u{110B}\u{116B}\u{11A8}"),
    ("\u{C65E}", "\u{C65E}", "\u{110B}\u{116B}\u{11A9}", "\u{C65E}", "\u{110B}\u{116B}\u{11A9}"),
    ("\u{C65F}", "\u{C65F}", "\u{110B}\u{116B}\u{11AA}", "\u{C65F}", "\u{110B}\u{116B}\u{11AA}"),
    ("\u{C660}", "\u{C660}", "\u{110B}\u{116B}\u{11AB}", "\u{C660}", "\u{110B}\u{116B}\u{11AB}"),
    ("\u{C661}", "\u{C661}", "\u{110B}\u{116B}\u{11AC}", "\u{C661}", "\u{110B}\u{116B}\u{11AC}"),
    ("\u{C662}", "\u{C662}", "\u{110B}\u{116B}\u{11AD}", "\u{C662}", "\u{110B}\u{116B}\u{11AD}"),
    ("\u{C663}", "\u{C663}", "\u{110B}\u{116B}\u{11AE}", "\u{C663}", "\u{110B}\u{116B}\u{11AE}"),
    ("\u{C664}", "\u{C664}", "\u{110B}\u{116B}\u{11AF}", "\u{C664}", "\u{110B}\u{116B}\u{11AF}"),
    ("\u{C665}", "\u{C665}", "\u{110B}\u{116B}\u{11B0}", "\u{C665}", "\u{110B}\u{116B}\u{11B0}"),
    ("\u{C666}", "\u{C666}", "\u{110B}\u{116B}\u{11B1}", "\u{C666}", "\u{110B}\u{116B}\u{11B1}"),
    ("\u{C667}", "\u{C667}", "\u{110B}\u{116B}\u{11B2}", "\u{C667}", "\u{110B}\u{116B}\u{11B2}"),
    ("\u{C668}", "\u{C668}", "\u{110B}\u{116B}\u{11B3}", "\u{C668}", "\u{110B}\u{116B}\u{11B3}"),
    ("\u{C669}", "\u{C669}", "\u{110B}\u{116B}\u{11B4}", "\u{C669}", "\u{110B}\u{116B}\u{11B4}"),
    ("\u{C66A}", "\u{C66A}", "\u{110B}\u{116B}\u{11B5}", "\u{C66A}", "\u{110B}\u{116B}\u{11B5}"),
    ("\u{C66B}", "\u{C66B}", "\u{110B}\u{116B}\u{11B6}", "\u{C66B}", "\u{110B}\u{116B}\u{11B6}"),
    ("\u{C66C}", "\u{C66C}", "\u{110B}\u{116B}\u{11B7}", "\u{C66C}", "\u{110B}\u{116B}\u{11B7}"),
    ("\u{C66D}", "\u{C66D}", "\u{110B}\u{116B}\u{11B8}", "\u{C66D}", "\u{110B}\u{116B}\u{11B8}"),
    ("\u{C66E}", "\u{C66E}", "\u{110B}\u{116B}\u{11B9}", "\u{C66E}", "\u{110B}\u{116B}\u{11B9}"),
    ("\u{C66F}", "\u{C66F}", "\u{110B}\u{116B}\u{11BA}", "\u{C66F}", "\u{110B}\u{116B}\u{11BA}"),
    ("\u{C670}", "\u{C670}", "\u{110B}\u{116B}\u{11BB}", "\u{C670}", "\u{110B}\u{116B}\u{11BB}"),
    ("\u{C671}", "\u{C671}", "\u{110B}\u{116B}\u{11BC}", "\u{C671}", "\u{110B}\u{116B}\u{11BC}"),
    ("\u{C672}", "\u{C672}", "\u{110B}\u{116B}\u{11BD}", "\u{C672}", "\u{110B}\u{116B}\u{11BD}"),
    ("\u{C673}", "\u{C673}", "\u{110B}\u{116B}\u{11BE}", "\u{C673}", "\u{110B}\u{116B}\u{11BE}"),
    ("\u{C674}", "\u{C674}", "\u{110B}\u{116B}\u{11BF}", "\u{C674}", "\u{110B}\u{116B}\u{11BF}"),
    ("\u{C675}", "\u{C675}", "\u{110B}\u{116B}\u{11C0}", "\u{C675}", "\u{110B}\u{116B}\u{11C0}"),
    ("\u{C676}", "\u{C676}", "\u{110B}\u{116B}\u{11C1}", "\u{C676}", "\u{110B}\u{116B}\u{11C1}"),
    ("\u{C677}", "\u{C677}", "\u{110B}\u{116B}\u{11C2}", "\u{C677}", "\u{110B}\u{116B}\u{11C2}"),
    ("\u{C678}", "\u{C678}", "\u{110B}\u{116C}", "\u{C678}", "\u{110B}\u{116C}"),
    ("\u{C679}", "\u{C679}", "\u{110B}\u{116C}\u{11A8}", "\u{C679}", "\u{110B}\u{116C}\u{11A8}"),
    ("\u{C67A}", "\u{C67A}", "\u{110B}\u{116C}\u{11A9}", "\u{C67A}", "\u{110B}\u{116C}\u{11A9}"),
    ("\u{C67B}", "\u{C67B}", "\u{110B}\u{116C}\u{11AA}", "\u{C67B}", "\u{110B}\u{116C}\u{11AA}"),
    ("\u{C67C}", "\u{C67C}", "\u{110B}\u{116C}\u{11AB}", "\u{C67C}", "\u{110B}\u{116C}\u{11AB}"),
    ("\u{C67D}", "\u{C67D}", "\u{110B}\u{116C}\u{11AC}", "\u{C67D}", "\u{110B}\u{116C}\u{11AC}"),
    ("\u{C67E}", "\u{C67E}", "\u{110B}\u{116C}\u{11AD}", "\u{C67E}", "\u{110B}\u{116C}\u{11AD}"),
    ("\u{C67F}", "\u{C67F}", "\u{110B}\u{116C}\u{11AE}", "\u{C67F}", "\u{110B}\u{116C}\u{11AE}"),
    ("\u{C680}", "\u{C680}", "\u{110B}\u{116C}\u{11AF}", "\u{C680}", "\u{110B}\u{116C}\u{11AF}"),
    ("\u{C681}", "\u{C681}", "\u{110B}\u{116C}\u{11B0}", "\u{C681}", "\u{110B}\u{116C}\u{11B0}"),
    ("\u{C682}", "\u{C682}", "\u{110B}\u{116C}\u{11B1}", "\u{C682}", "\u{110B}\u{116C}\u{11B1}"),
    ("\u{C683}", "\u{C683}", "\u{110B}\u{116C}\u{11B2}", "\u{C683}", "\u{110B}\u{116C}\u{11B2}"),
    ("\u{C684}", "\u{C684}", "\u{110B}\u{116C}\u{11B3}", "\u{C684}", "\u{110B}\u{116C}\u{11B3}"),
    ("\u{C685}", "\u{C685}", "\u{110B}\u{116C}\u{11B4}", "\u{C685}", "\u{110B}\u{116C}\u{11B4}"),
    ("\u{C686}", "\u{C686}", "\u{110B}\u{116C}\u{11B5}", "\u{C686}", "\u{110B}\u{116C}\u{11B5}"),
    ("\u{C687}", "\u{C687}", "\u{110B}\u{116C}\u{11B6}", "\u{C687}", "\u{110B}\u{116C}\u{11B6}"),
    ("\u{C688}", "\u{C688}", "\u{110B}\u{116C}\u{11B7}", "\u{C688}", "\u{110B}\u{116C}\u{11B7}"),
    ("\u{C689}", "\u{C689}", "\u{110B}\u{116C}\u{11B8}", "\u{C689}", "\u{110B}\u{116C}\u{11B8}"),
    ("\u{C68A}", "\u{C68A}", "\u{110B}\u{116C}\u{11B9}", "\u{C68A}", "\u{110B}\u{116C}\u{11B9}"),
    ("\u{C68B}", "\u{C68B}", "\u{110B}\u{116C}\u{11BA}", "\u{C68B}", "\u{110B}\u{116C}\u{11BA}"),
    ("\u{C68C}", "\u{C68C}", "\u{110B}\u{116C}\u{11BB}", "\u{C68C}", "\u{110B}\u{116C}\u{11BB}"),
    ("\u{C68D}", "\u{C68D}", "\u{110B}\u{116C}\u{11BC}", "\u{C68D}", "\u{110B}\u{116C}\u{11BC}"),
    ("\u{C68E}", "\u{C68E}", "\u{110B}\u{116C}\u{11BD}", "\u{C68E}", "\u{110B}\u{116C}\u{11BD}"),
    ("\u{C68F}", "\u{C68F}", "\u{110B}\u{116C}\u{11BE}", "\u{C68F}", "\u{110B}\u{116C}\u{11BE}"),
    ("\u{C690}", "\u{C690}", "\u{110B}\u{116C}\u{11BF}", "\u{C690}", "\u{110B}\u{116C}\u{11BF}"),
    ("\u{C691}", "\u{C691}", "\u{110B}\u{116C}\u{11C0}", "\u{C691}", "\u{110B}\u{116C}\u{11C0}"),
    ("\u{C692}", "\u{C692}", "\u{110B}\u{116C}\u{11C1}", "\u{C692}", "\u{110B}\u{116C}\u{11C1}"),
    ("\u{C693}", "\u{C693}", "\u{110B}\u{116C}\u{11C2}", "\u{C693}", "\u{110B}\u{116C}\u{11C2}"),
    ("\u{C694}", "\u{C694}", "\u{110B}\u{116D}", "\u{C694}", "\u{110B}\u{116D}"),
    ("\u{C695}", "\u{C695}", "\u{110B}\u{116D}\u{11A8}", "\u{C695}", "\u{110B}\u{116D}\u{11A8}"),
    ("\u{C696}", "\u{C696}", "\u{110B}\u{116D}\u{11A9}", "\u{C696}", "\u{110B}\u{116D}\u{11A9}"),
    ("\u{C697}", "\u{C697}", "\u{110B}\u{116D}\u{11AA}", "\u{C697}", "\u{110B}\u{116D}\u{11AA}"),
    ("\u{C698}", "\u{C698}", "\u{110B}\u{116D}\u{11AB}", "\u{C698}", "\u{110B}\u{116D}\u{11AB}"),
    ("\u{C699}", "\u{C699}", "\u{110B}\u{116D}\u{11AC}", "\u{C699}", "\u{110B}\u{116D}\u{11AC}"),
    ("\u{C69A}", "\u{C69A}", "\u{110B}\u{116D}\u{11AD}", "\u{C69A}", "\u{110B}\u{116D}\u{11AD}"),
    ("\u{C69B}", "\u{C69B}", "\u{110B}\u{116D}\u{11AE}", "\u{C69B}", "\u{110B}\u{116D}\u{11AE}"),
    ("\u{C69C}", "\u{C69C}", "\u{110B}\u{116D}\u{11AF}", "\u{C69C}", "\u{110B}\u{116D}\u{11AF}"),
    ("\u{C69D}", "\u{C69D}", "\u{110B}\u{116D}\u{11B0}", "\u{C69D}", "\u{110B}\u{116D}\u{11B0}"),
    ("\u{C69E}", "\u{C69E}", "\u{110B}\u{116D}\u{11B1}", "\u{C69E}", "\u{110B}\u{116D}\u{11B1}"),
    ("\u{C69F}", "\u{C69F}", "\u{110B}\u{116D}\u{11B2}", "\u{C69F}", "\u{110B}\u{116D}\u{11B2}"),
    ("\u{C6A0}", "\u{C6A0}", "\u{110B}\u{116D}\u{11B3}", "\u{C6A0}", "\u{110B}\u{116D}\u{11B3}"),
    ("\u{C6A1}", "\u{C6A1}", "\u{110B}\u{116D}\u{11B4}", "\u{C6A1}", "\u{110B}\u{116D}\u{11B4}"),
    ("\u{C6A2}", "\u{C6A2}", "\u{110B}\u{116D}\u{11B5}", "\u{C6A2}", "\u{110B}\u{116D}\u{11B5}"),
    ("\u{C6A3}", "\u{C6A3}", "\u{110B}\u{116D}\u{11B6}", "\u{C6A3}", "\u{110B}\u{116D}\u{11B6}"),
    ("\u{C6A4}", "\u{C6A4}", "\u{110B}\u{116D}\u{11B7}", "\u{C6A4}", "\u{110B}\u{116D}\u{11B7}"),
    ("\u{C6A5}", "\u{C6A5}", "\u{110B}\u{116D}\u{11B8}", "\u{C6A5}", "\u{110B}\u{116D}\u{11B8}"),
    ("\u{C6A6}", "\u{C6A6}", "\u{110B}\u{116D}\u{11B9}", "\u{C6A6}", "\u{110B}\u{116D}\u{11B9}"),
    ("\u{C6A7}", "\u{C6A7}", "\u{110B}\u{116D}\u{11BA}", "\u{C6A7}", "\u{110B}\u{116D}\u{11BA}"),
    ("\u{C6A8}", "\u{C6A8}", "\u{110B}\u{116D}\u{11BB}", "\u{C6A8}", "\u{110B}\u{116D}\u{11BB}"),
    ("\u{C6A9}", "\u{C6A9}", "\u{110B}\u{116D}\u{11BC}", "\u{C6A9}", "\u{110B}\u{116D}\u{11BC}"),
    ("\u{C6AA}", "\u{C6AA}", "\u{110B}\u{116D}\u{11BD}", "\u{C6AA}", "\u{110B}\u{116D}\u{11BD}"),
    ("\u{C6AB}", "\u{C6AB}", "\u{110B}\u{116D}\u{11BE}", "\u{C6AB}", "\u{110B}\u{116D}\u{11BE}"),
    ("\u{C6AC}", "\u{C6AC}", "\u{110B}\u{116D}\u{11BF}", "\u{C6AC}", "\u{110B}\u{116D}\u{11BF}"),
    ("\u{C6AD}", "\u{C6AD}", "\u{110B}\u{116D}\u{11C0}", "\u{C6AD}", "\u{110B}\u{116D}\u{11C0}"),
    ("\u{C6AE}", "\u{C6AE}", "\u{110B}\u{116D}\u{11C1}", "\u{C6AE}", "\u{110B}\u{116D}\u{11C1}"),
    ("\u{C6AF}", "\u{C6AF}", "\u{110B}\u{116D}\u{11C2}", "\u{C6AF}", "\u{110B}\u{116D}\u{11C2}"),
    ("\u{C6B0}", "\u{C6B0}", "\u{110B}\u{116E}", "\u{C6B0}", "\u{110B}\u{116E}"),
    ("\u{C6B1}", "\u{C6B1}", "\u{110B}\u{116E}\u{11A8}", "\u{C6B1}", "\u{110B}\u{116E}\u{11A8}"),
    ("\u{C6B2}", "\u{C6B2}", "\u{110B}\u{116E}\u{11A9}", "\u{C6B2}", "\u{110B}\u{116E}\u{11A9}"),
    ("\u{C6B3}", "\u{C6B3}", "\u{110B}\u{116E}\u{11AA}", "\u{C6B3}", "\u{110B}\u{116E}\u{11AA}"),
    ("\u{C6B4}", "\u{C6B4}", "\u{110B}\u{116E}\u{11AB}", "\u{C6B4}", "\u{110B}\u{116E}\u{11AB}"),
    ("\u{C6B5}", "\u{C6B5}", "\u{110B}\u{116E}\u{11AC}", "\u{C6B5}", "\u{110B}\u{116E}\u{11AC}"),
    ("\u{C6B6}", "\u{C6B6}", "\u{110B}\u{116E}\u{11AD}", "\u{C6B6}", "\u{110B}\u{116E}\u{11AD}"),
    ("\u{C6B7}", "\u{C6B7}", "\u{110B}\u{116E}\u{11AE}", "\u{C6B7}", "\u{110B}\u{116E}\u{11AE}"),
    ("\u{C6B8}", "\u{C6B8}", "\u{110B}\u{116E}\u{11AF}", "\u{C6B8}", "\u{110B}\u{116E}\u{11AF}"),
    ("\u{C6B9}", "\u{C6B9}", "\u{110B}\u{116E}\u{11B0}", "\u{C6B9}", "\u{110B}\u{116E}\u{11B0}"),
    ("\u{C6BA}", "\u{C6BA}", "\u{110B}\u{116E}\u{11B1}", "\u{C6BA}", "\u{110B}\u{116E}\u{11B1}"),
    ("\u{C6BB}", "\u{C6BB}", "\u{110B}\u{116E}\u{11B2}", "\u{C6BB}", "\u{110B}\u{116E}\u{11B2}"),
    ("\u{C6BC}", "\u{C6BC}", "\u{110B}\u{116E}\u{11B3}", "\u{C6BC}", "\u{110B}\u{116E}\u{11B3}"),
    ("\u{C6BD}", "\u{C6BD}", "\u{110B}\u{116E}\u{11B4}", "\u{C6BD}", "\u{110B}\u{116E}\u{11B4}"),
    ("\u{C6BE}", "\u{C6BE}", "\u{110B}\u{116E}\u{11B5}", "\u{C6BE}", "\u{110B}\u{116E}\u{11B5}"),
    ("\u{C6BF}", "\u{C6BF}", "\u{110B}\u{116E}\u{11B6}", "\u{C6BF}", "\u{110B}\u{116E}\u{11B6}"),
    ("\u{C6C0}", "\u{C6C0}", "\u{110B}\u{116E}\u{11B7}", "\u{C6C0}", "\u{110B}\u{116E}\u{11B7}"),
    ("\u{C6C1}", "\u{C6C1}", "\u{110B}\u{116E}\u{11B8}", "\u{C6C1}", "\u{110B}\u{116E}\u{11B8}"),
    ("\u{C6C2}", "\u{C6C2}", "\u{110B}\u{116E}\u{11B9}", "\u{C6C2}", "\u{110B}\u{116E}\u{11B9}"),
    ("\u{C6C3}", "\u{C6C3}", "\u{110B}\u{116E}\u{11BA}", "\u{C6C3}", "\u{110B}\u{116E}\u{11BA}"),
    ("\u{C6C4}", "\u{C6C4}", "\u{110B}\u{116E}\u{11BB}", "\u{C6C4}", "\u{110B}\u{116E}\u{11BB}"),
    ("\u{C6C5}", "\u{C6C5}", "\u{110B}\u{116E}\u{11BC}", "\u{C6C5}", "\u{110B}\u{116E}\u{11BC}"),
    ("\u{C6C6}", "\u{C6C6}", "\u{110B}\u{116E}\u{11BD}", "\u{C6C6}", "\u{110B}\u{116E}\u{11BD}"),
    ("\u{C6C7}", "\u{C6C7}", "\u{110B}\u{116E}\u{11BE}", "\u{C6C7}", "\u{110B}\u{116E}\u{11BE}"),
    ("\u{C6C8}", "\u{C6C8}", "\u{110B}\u{116E}\u{11BF}", "\u{C6C8}", "\u{110B}\u{116E}\u{11BF}"),
    ("\u{C6C9}", "\u{C6C9}", "\u{110B}\u{116E}\u{11C0}", "\u{C6C9}", "\u{110B}\u{116E}\u{11C0}"),
    ("\u{C6CA}", "\u{C6CA}", "\u{110B}\u{116E}\u{11C1}", "\u{C6CA}", "\u{110B}\u{116E}\u{11C1}"),
    ("\u{C6CB}", "\u{C6CB}", "\u{110B}\u{116E}\u{11C2}", "\u{C6CB}", "\u{110B}\u{116E}\u{11C2}"),
    ("\u{C6CC}", "\u{C6CC}", "\u{110B}\u{116F}", "\u{C6CC}", "\u{110B}\u{116F}"),
    ("\u{C6CD}", "\u{C6CD}", "\u{110B}\u{116F}\u{11A8}", "\u{C6CD}", "\u{110B}\u{116F}\u{11A8}"),
    ("\u{C6CE}", "\u{C6CE}", "\u{110B}\u{116F}\u{11A9}", "\u{C6CE}", "\u{110B}\u{116F}\u{11A9}"),
    ("\u{C6CF}", "\u{C6CF}", "\u{110B}\u{116F}\u{11AA}", "\u{C6CF}", "\u{110B}\u{116F}\u{11AA}"),
    ("\u{C6D0}", "\u{C6D0}", "\u{110B}\u{116F}\u{11AB}", "\u{C6D0}", "\u{110B}\u{116F}\u{11AB}"),
    ("\u{C6D1}", "\u{C6D1}", "\u{110B}\u{116F}\u{11AC}", "\u{C6D1}", "\u{110B}\u{116F}\u{11AC}"),
    ("\u{C6D2}", "\u{C6D2}", "\u{110B}\u{116F}\u{11AD}", "\u{C6D2}", "\u{110B}\u{116F}\u{11AD}"),
    ("\u{C6D3}", "\u{C6D3}", "\u{110B}\u{116F}\u{11AE}", "\u{C6D3}", "\u{110B}\u{116F}\u{11AE}"),
    ("\u{C6D4}", "\u{C6D4}", "\u{110B}\u{116F}\u{11AF}", "\u{C6D4}", "\u{110B}\u{116F}\u{11AF}"),
    ("\u{C6D5}", "\u{C6D5}", "\u{110B}\u{116F}\u{11B0}", "\u{C6D5}", "\u{110B}\u{116F}\u{11B0}"),
    ("\u{C6D6}", "\u{C6D6}", "\u{110B}\u{116F}\u{11B1}", "\u{C6D6}", "\u{110B}\u{116F}\u{11B1}"),
    ("\u{C6D7}", "\u{C6D7}", "\u{110B}\u{116F}\u{11B2}", "\u{C6D7}", "\u{110B}\u{116F}\u{11B2}"),
    ("\u{C6D8}", "\u{C6D8}", "\u{110B}\u{116F}\u{11B3}", "\u{C6D8}", "\u{110B}\u{116F}\u{11B3}"),
    ("\u{C6D9}", "\u{C6D9}", "\u{110B}\u{116F}\u{11B4}", "\u{C6D9}", "\u{110B}\u{116F}\u{11B4}"),
    ("\u{C6DA}", "\u{C6DA}", "\u{110B}\u{116F}\u{11B5}", "\u{C6DA}", "\u{110B}\u{116F}\u{11B5}"),
    ("\u{C6DB}", "\u{C6DB}", "\u{110B}\u{116F}\u{11B6}", "\u{C6DB}", "\u{110B}\u{116F}\u{11B6}"),
    ("\u{C6DC}", "\u{C6DC}", "\u{110B}\u{116F}\u{11B7}", "\u{C6DC}", "\u{110B}\u{116F}\u{11B7}"),
    ("\u{C6DD}", "\u{C6DD}", "\u{110B}\u{116F}\u{11B8}", "\u{C6DD}", "\u{110B}\u{116F}\u{11B8}"),
    ("\u{C6DE}", "\u{C6DE}", "\u{110B}\u{116F}\u{11B9}", "\u{C6DE}", "\u{110B}\u{116F}\u{11B9}"),
    ("\u{C6DF}", "\u{C6DF}", "\u{110B}\u{116F}\u{11BA}", "\u{C6DF}", "\u{110B}\u{116F}\u{11BA}"),
    ("\u{C6E0}", "\u{C6E0}", "\u{110B}\u{116F}\u{11BB}", "\u{C6E0}", "\u{110B}\u{116F}\u{11BB}"),
    ("\u{C6E1}", "\u{C6E1}", "\u{110B}\u{116F}\u{11BC}", "\u{C6E1}", "\u{110B}\u{116F}\u{11BC}"),
    ("\u{C6E2}", "\u{C6E2}", "\u{110B}\u{116F}\u{11BD}", "\u{C6E2}", "\u{110B}\u{116F}\u{11BD}"),
    ("\u{C6E3}", "\u{C6E3}", "\u{110B}\u{116F}\u{11BE}", "\u{C6E3}", "\u{110B}\u{116F}\u{11BE}"),
    ("\u{C6E4}", "\u{C6E4}", "\u{110B}\u{116F}\u{11BF}", "\u{C6E4}", "\u{110B}\u{116F}\u{11BF}"),
    ("\u{C6E5}", "\u{C6E5}", "\u{110B}\u{116F}\u{11C0}", "\u{C6E5}", "\u{110B}\u{116F}\u{11C0}"),
    ("\u{C6E6}", "\u{C6E6}", "\u{110B}\u{116F}\u{11C1}", "\u{C6E6}", "\u{110B}\u{116F}\u{11C1}"),
    ("\u{C6E7}", "\u{C6E7}", "\u{110B}\u{116F}\u{11C2}", "\u{C6E7}", "\u{110B}\u{116F}\u{11C2}"),
    ("\u{C6E8}", "\u{C6E8}", "\u{110B}\u{1170}", "\u{C6E8}", "\u{110B}\u{1170}"),
    ("\u{C6E9}", "\u{C6E9}", "\u{110B}\u{1170}\u{11A8}", "\u{C6E9}", "\u{110B}\u{1170}\u{11A8}"),
    ("\u{C6EA}", "\u{C6EA}", "\u{110B}\u{1170}\u{11A9}", "\u{C6EA}", "\u{110B}\u{1170}\u{11A9}"),
    ("\u{C6EB}", "\u{C6EB}", "\u{110B}\u{1170}\u{11AA}", "\u{C6EB}", "\u{110B}\u{1170}\u{11AA}"),
    ("\u{C6EC}", "\u{C6EC}", "\u{110B}\u{1170}\u{11AB}", "\u{C6EC}", "\u{110B}\u{1170}\u{11AB}"),
    ("\u{C6ED}", "\u{C6ED}", "\u{110B}\u{1170}\u{11AC}", "\u{C6ED}", "\u{110B}\u{1170}\u{11AC}"),
    ("\u{C6EE}", "\u{C6EE}", "\u{110B}\u{1170}\u{11AD}", "\u{C6EE}", "\u{110B}\u{1170}\u{11AD}"),
    ("\u{C6EF}", "\u{C6EF}", "\u{110B}\u{1170}\u{11AE}", "\u{C6EF}", "\u{110B}\u{1170}\u{11AE}"),
    ("\u{C6F0}", "\u{C6F0}", "\u{110B}\u{1170}\u{11AF}", "\u{C6F0}", "\u{110B}\u{1170}\u{11AF}"),
    ("\u{C6F1}", "\u{C6F1}", "\u{110B}\u{1170}\u{11B0}", "\u{C6F1}", "\u{110B}\u{1170}\u{11B0}"),
    ("\u{C6F2}", "\u{C6F2}", "\u{110B}\u{1170}\u{11B1}", "\u{C6F2}", "\u{110B}\u{1170}\u{11B1}"),
    ("\u{C6F3}", "\u{C6F3}", "\u{110B}\u{1170}\u{11B2}", "\u{C6F3}", "\u{110B}\u{1170}\u{11B2}"),
    ("\u{C6F4}", "\u{C6F4}", "\u{110B}\u{1170}\u{11B3}", "\u{C6F4}", "\u{110B}\u{1170}\u{11B3}"),
    ("\u{C6F5}", "\u{C6F5}", "\u{110B}\u{1170}\u{11B4}", "\u{C6F5}", "\u{110B}\u{1170}\u{11B4}"),
    ("\u{C6F6}", "\u{C6F6}", "\u{110B}\u{1170}\u{11B5}", "\u{C6F6}", "\u{110B}\u{1170}\u{11B5}"),
    ("\u{C6F7}", "\u{C6F7}", "\u{110B}\u{1170}\u{11B6}", "\u{C6F7}", "\u{110B}\u{1170}\u{11B6}"),
    ("\u{C6F8}", "\u{C6F8}", "\u{110B}\u{1170}\u{11B7}", "\u{C6F8}", "\u{110B}\u{1170}\u{11B7}"),
    ("\u{C6F9}", "\u{C6F9}", "\u{110B}\u{1170}\u{11B8}", "\u{C6F9}", "\u{110B}\u{1170}\u{11B8}"),
    ("\u{C6FA}", "\u{C6FA}", "\u{110B}\u{1170}\u{11B9}", "\u{C6FA}", "\u{110B}\u{1170}\u{11B9}"),
    ("\u{C6FB}", "\u{C6FB}", "\u{110B}\u{1170}\u{11BA}", "\u{C6FB}", "\u{110B}\u{1170}\u{11BA}"),
    ("\u{C6FC}", "\u{C6FC}", "\u{110B}\u{1170}\u{11BB}", "\u{C6FC}", "\u{110B}\u{1170}\u{11BB}"),
    ("\u{C6FD}", "\u{C6FD}", "\u{110B}\u{1170}\u{11BC}", "\u{C6FD}", "\u{110B}\u{1170}\u{11BC}"),
    ("\u{C6FE}", "\u{C6FE}", "\u{110B}\u{1170}\u{11BD}", "\u{C6FE}", "\u{110B}\u{1170}\u{11BD}"),
    ("\u{C6FF}", "\u{C6FF}", "\u{110B}\u{1170}\u{11BE}", "\u{C6FF}", "\u{110B}\u{1170}\u{11BE}"),
    ("\u{C700}", "\u{C700}", "\u{110B}\u{1170}\u{11BF}", "\u{C700}", "\u{110B}\u{1170}\u{11BF}"),
    ("\u{C701}", "\u{C701}", "\u{110B}\u{1170}\u{11C0}", "\u{C701}", "\u{110B}\u{1170}\u{11C0}"),
    ("\u{C702}", "\u{C702}", "\u{110B}\u{1170}\u{11C1}", "\u{C702}", "\u{110B}\u{1170}\u{11C1}"),
    ("\u{C703}", "\u{C703}", "\u{110B}\u{1170}\u{11C2}", "\u{C703}", "\u{110B}\u{1170}\u{11C2}"),
    ("\u{C704}", "\u{C704}", "\u{110B}\u{1171}", "\u{C704}", "\u{110B}\u{1171}"),
    ("\u{C705}", "\u{C705}", "\u{110B}\u{1171}\u{11A8}", "\u{C705}", "\u{110B}\u{1171}\u{11A8}"),
    ("\u{C706}", "\u{C706}", "\u{110B}\u{1171}\u{11A9}", "\u{C706}", "\u{110B}\u{1171}\u{11A9}"),
    ("\u{C707}", "\u{C707}", "\u{110B}\u{1171}\u{11AA}", "\u{C707}", "\u{110B}\u{1171}\u{11AA}"),
    ("\u{C708}", "\u{C708}", "\u{110B}\u{1171}\u{11AB}", "\u{C708}", "\u{110B}\u{1171}\u{11AB}"),
    ("\u{C709}", "\u{C709}", "\u{110B}\u{1171}\u{11AC}", "\u{C709}", "\u{110B}\u{1171}\u{11AC}"),
    ("\u{C70A}", "\u{C70A}", "\u{110B}\u{1171}\u{11AD}", "\u{C70A}", "\u{110B}\u{1171}\u{11AD}"),
    ("\u{C70B}", "\u{C70B}", "\u{110B}\u{1171}\u{11AE}", "\u{C70B}", "\u{110B}\u{1171}\u{11AE}"),
    ("\u{C70C}", "\u{C70C}", "\u{110B}\u{1171}\u{11AF}", "\u{C70C}", "\u{110B}\u{1171}\u{11AF}"),
    ("\u{C70D}", "\u{C70D}", "\u{110B}\u{1171}\u{11B0}", "\u{C70D}", "\u{110B}\u{1171}\u{11B0}"),
    ("\u{C70E}", "\u{C70E}", "\u{110B}\u{1171}\u{11B1}", "\u{C70E}", "\u{110B}\u{1171}\u{11B1}"),
    ("\u{C70F}", "\u{C70F}", "\u{110B}\u{1171}\u{11B2}", "\u{C70F}", "\u{110B}\u{1171}\u{11B2}"),
    ("\u{C710}", "\u{C710}", "\u{110B}\u{1171}\u{11B3}", "\u{C710}", "\u{110B}\u{1171}\u{11B3}"),
    ("\u{C711}", "\u{C711}", "\u{110B}\u{1171}\u{11B4}", "\u{C711}", "\u{110B}\u{1171}\u{11B4}"),
    ("\u{C712}", "\u{C712}", "\u{110B}\u{1171}\u{11B5}", "\u{C712}", "\u{110B}\u{1171}\u{11B5}"),
    ("\u{C713}", "\u{C713}", "\u{110B}\u{1171}\u{11B6}", "\u{C713}", "\u{110B}\u{1171}\u{11B6}"),
    ("\u{C714}", "\u{C714}", "\u{110B}\u{1171}\u{11B7}", "\u{C714}", "\u{110B}\u{1171}\u{11B7}"),
    ("\u{C715}", "\u{C715}", "\u{110B}\u{1171}\u{11B8}", "\u{C715}", "\u{110B}\u{1171}\u{11B8}"),
    ("\u{C716}", "\u{C716}", "\u{110B}\u{1171}\u{11B9}", "\u{C716}", "\u{110B}\u{1171}\u{11B9}"),
    ("\u{C717}", "\u{C717}", "\u{110B}\u{1171}\u{11BA}", "\u{C717}", "\u{110B}\u{1171}\u{11BA}"),
    ("\u{C718}", "\u{C718}", "\u{110B}\u{1171}\u{11BB}", "\u{C718}", "\u{110B}\u{1171}\u{11BB}"),
    ("\u{C719}", "\u{C719}", "\u{110B}\u{1171}\u{11BC}", "\u{C719}", "\u{110B}\u{1171}\u{11BC}"),
    ("\u{C71A}", "\u{C71A}", "\u{110B}\u{1171}\u{11BD}", "\u{C71A}", "\u{110B}\u{1171}\u{11BD}"),
    ("\u{C71B}", "\u{C71B}", "\u{110B}\u{1171}\u{11BE}", "\u{C71B}", "\u{110B}\u{1171}\u{11BE}"),
    ("\u{C71C}", "\u{C71C}", "\u{110B}\u{1171}\u{11BF}", "\u{C71C}", "\u{110B}\u{1171}\u{11BF}"),
    ("\u{C71D}", "\u{C71D}", "\u{110B}\u{1171}\u{11C0}", "\u{C71D}", "\u{110B}\u{1171}\u{11C0}"),
    ("\u{C71E}", "\u{C71E}", "\u{110B}\u{1171}\u{11C1}", "\u{C71E}", "\u{110B}\u{1171}\u{11C1}"),
    ("\u{C71F}", "\u{C71F}", "\u{110B}\u{1171}\u{11C2}", "\u{C71F}", "\u{110B}\u{1171}\u{11C2}"),
    ("\u{C720}", "\u{C720}", "\u{110B}\u{1172}", "\u{C720}", "\u{110B}\u{1172}"),
    ("\u{C721}", "\u{C721}", "\u{110B}\u{1172}\u{11A8}", "\u{C721}", "\u{110B}\u{1172}\u{11A8}"),
    ("\u{C722}", "\u{C722}", "\u{110B}\u{1172}\u{11A9}", "\u{C722}", "\u{110B}\u{1172}\u{11A9}"),
    ("\u{C723}", "\u{C723}", "\u{110B}\u{1172}\u{11AA}", "\u{C723}", "\u{110B}\u{1172}\u{11AA}"),
    ("\u{C724}", "\u{C724}", "\u{110B}\u{1172}\u{11AB}", "\u{C724}", "\u{110B}\u{1172}\u{11AB}"),
    ("\u{C725}", "\u{C725}", "\u{110B}\u{1172}\u{11AC}", "\u{C725}", "\u{110B}\u{1172}\u{11AC}"),
    ("\u{C726}", "\u{C726}", "\u{110B}\u{1172}\u{11AD}", "\u{C726}", "\u{110B}\u{1172}\u{11AD}"),
    ("\u{C727}", "\u{C727}", "\u{110B}\u{1172}\u{11AE}", "\u{C727}", "\u{110B}\u{1172}\u{11AE}"),
    ("\u{C728}", "\u{C728}", "\u{110B}\u{1172}\u{11AF}", "\u{C728}", "\u{110B}\u{1172}\u{11AF}"),
    ("\u{C729}", "\u{C729}", "\u{110B}\u{1172}\u{11B0}", "\u{C729}", "\u{110B}\u{1172}\u{11B0}"),
    ("\u{C72A}", "\u{C72A}", "\u{110B}\u{1172}\u{11B1}", "\u{C72A}", "\u{110B}\u{1172}\u{11B1}"),
    ("\u{C72B}", "\u{C72B}", "\u{110B}\u{1172}\u{11B2}", "\u{C72B}", "\u{110B}\u{1172}\u{11B2}"),
    ("\u{C72C}", "\u{C72C}", "\u{110B}\u{1172}\u{11B3}", "\u{C72C}", "\u{110B}\u{1172}\u{11B3}"),
    ("\u{C72D}", "\u{C72D}", "\u{110B}\u{1172}\u{11B4}", "\u{C72D}", "\u{110B}\u{1172}\u{11B4}"),
    ("\u{C72E}", "\u{C72E}", "\u{110B}\u{1172}\u{11B5}", "\u{C72E}", "\u{110B}\u{1172}\u{11B5}"),
    ("\u{C72F}", "\u{C72F}", "\u{110B}\u{1172}\u{11B6}", "\u{C72F}", "\u{110B}\u{1172}\u{11B6}"),
    ("\u{C730}", "\u{C730}", "\u{110B}\u{1172}\u{11B7}", "\u{C730}", "\u{110B}\u{1172}\u{11B7}"),
    ("\u{C731}", "\u{C731}", "\u{110B}\u{1172}\u{11B8}", "\u{C731}", "\u{110B}\u{1172}\u{11B8}"),
    ("\u{C732}", "\u{C732}", "\u{110B}\u{1172}\u{11B9}", "\u{C732}", "\u{110B}\u{1172}\u{11B9}"),
    ("\u{C733}", "\u{C733}", "\u{110B}\u{1172}\u{11BA}", "\u{C733}", "\u{110B}\u{1172}\u{11BA}"),
    ("\u{C734}", "\u{C734}", "\u{110B}\u{1172}\u{11BB}", "\u{C734}", "\u{110B}\u{1172}\u{11BB}"),
    ("\u{C735}", "\u{C735}", "\u{110B}\u{1172}\u{11BC}", "\u{C735}", "\u{110B}\u{1172}\u{11BC}"),
    ("\u{C736}", "\u{C736}", "\u{110B}\u{1172}\u{11BD}", "\u{C736}", "\u{110B}\u{1172}\u{11BD}"),
    ("\u{C737}", "\u{C737}", "\u{110B}\u{1172}\u{11BE}", "\u{C737}", "\u{110B}\u{1172}\u{11BE}"),
    ("\u{C738}", "\u{C738}", "\u{110B}\u{1172}\u{11BF}", "\u{C738}", "\u{110B}\u{1172}\u{11BF}"),
    ("\u{C739}", "\u{C739}", "\u{110B}\u{1172}\u{11C0}", "\u{C739}", "\u{110B}\u{1172}\u{11C0}"),
    ("\u{C73A}", "\u{C73A}", "\u{110B}\u{1172}\u{11C1}", "\u{C73A}", "\u{110B}\u{1172}\u{11C1}"),
    ("\u{C73B}", "\u{C73B}", "\u{110B}\u{1172}\u{11C2}", "\u{C73B}", "\u{110B}\u{1172}\u{11C2}"),
    ("\u{C73C}", "\u{C73C}", "\u{110B}\u{1173}", "\u{C73C}", "\u{110B}\u{1173}"),
    ("\u{C73D}", "\u{C73D}", "\u{110B}\u{1173}\u{11A8}", "\u{C73D}", "\u{110B}\u{1173}\u{11A8}"),
    ("\u{C73E}", "\u{C73E}", "\u{110B}\u{1173}\u{11A9}", "\u{C73E}", "\u{110B}\u{1173}\u{11A9}"),
    ("\u{C73F}", "\u{C73F}", "\u{110B}\u{1173}\u{11AA}", "\u{C73F}", "\u{110B}\u{1173}\u{11AA}"),
    ("\u{C740}", "\u{C740}", "\u{110B}\u{1173}\u{11AB}", "\u{C740}", "\u{110B}\u{1173}\u{11AB}"),
    ("\u{C741}", "\u{C741}", "\u{110B}\u{1173}\u{11AC}", "\u{C741}", "\u{110B}\u{1173}\u{11AC}"),
    ("\u{C742}", "\u{C742}", "\u{110B}\u{1173}\u{11AD}", "\u{C742}", "\u{110B}\u{1173}\u{11AD}"),
    ("\u{C743}", "\u{C743}", "\u{110B}\u{1173}\u{11AE}", "\u{C743}", "\u{110B}\u{1173}\u{11AE}"),
    ("\u{C744}", "\u{C744}", "\u{110B}\u{1173}\u{11AF}", "\u{C744}", "\u{110B}\u{1173}\u{11AF}"),
    ("\u{C745}", "\u{C745}", "\u{110B}\u{1173}\u{11B0}", "\u{C745}", "\u{110B}\u{1173}\u{11B0}"),
    ("\u{C746}", "\u{C746}", "\u{110B}\u{1173}\u{11B1}", "\u{C746}", "\u{110B}\u{1173}\u{11B1}"),
    ("\u{C747}", "\u{C747}", "\u{110B}\u{1173}\u{11B2}", "\u{C747}", "\u{110B}\u{1173}\u{11B2}"),
    ("\u{C748}", "\u{C748}", "\u{110B}\u{1173}\u{11B3}", "\u{C748}", "\u{110B}\u{1173}\u{11B3}"),
    ("\u{C749}", "\u{C749}", "\u{110B}\u{1173}\u{11B4}", "\u{C749}", "\u{110B}\u{1173}\u{11B4}"),
    ("\u{C74A}", "\u{C74A}", "\u{110B}\u{1173}\u{11B5}", "\u{C74A}", "\u{110B}\u{1173}\u{11B5}"),
    ("\u{C74B}", "\u{C74B}", "\u{110B}\u{1173}\u{11B6}", "\u{C74B}", "\u{110B}\u{1173}\u{11B6}"),
    ("\u{C74C}", "\u{C74C}", "\u{110B}\u{1173}\u{11B7}", "\u{C74C}", "\u{110B}\u{1173}\u{11B7}"),
    ("\u{C74D}", "\u{C74D}", "\u{110B}\u{1173}\u{11B8}", "\u{C74D}", "\u{110B}\u{1173}\u{11B8}"),
    ("\u{C74E}", "\u{C74E}", "\u{110B}\u{1173}\u{11B9}", "\u{C74E}", "\u{110B}\u{1173}\u{11B9}"),
    ("\u{C74F}", "\u{C74F}", "\u{110B}\u{1173}\u{11BA}", "\u{C74F}", "\u{110B}\u{1173}\u{11BA}"),
    ("\u{C750}", "\u{C750}", "\u{110B}\u{1173}\u{11BB}", "\u{C750}", "\u{110B}\u{1173}\u{11BB}"),
    ("\u{C751}", "\u{C751}", "\u{110B}\u{1173}\u{11BC}", "\u{C751}", "\u{110B}\u{1173}\u{11BC}"),
    ("\u{C752}", "\u{C752}", "\u{110B}\u{1173}\u{11BD}", "\u{C752}", "\u{110B}\u{1173}\u{11BD}"),
    ("\u{C753}", "\u{C753}", "\u{110B}\u{1173}\u{11BE}", "\u{C753}", "\u{110B}\u{1173}\u{11BE}"),
    ("\u{C754}", "\u{C754}", "\u{110B}\u{1173}\u{11BF}", "\u{C754}", "\u{110B}\u{1173}\u{11BF}"),
    ("\u{C755}", "\u{C755}", "\u{110B}\u{1173}\u{11C0}", "\u{C755}", "\u{110B}\u{1173}\u{11C0}"),
    ("\u{C756}", "\u{C756}", "\u{110B}\u{1173}\u{11C1}", "\u{C756}", "\u{110B}\u{1173}\u{11C1}"),
    ("\u{C757}", "\u{C757}", "\u{110B}\u{1173}\u{11C2}", "\u{C757}", "\u{110B}\u{1173}\u{11C2}"),
    ("\u{C758}", "\u{C758}", "\u{110B}\u{1174}", "\u{C758}", "\u{110B}\u{1174}"),
    ("\u{C759}", "\u{C759}", "\u{110B}\u{1174}\u{11A8}", "\u{C759}", "\u{110B}\u{1174}\u{11A8}"),
    ("\u{C75A}", "\u{C75A}", "\u{110B}\u{1174}\u{11A9}", "\u{C75A}", "\u{110B}\u{1174}\u{11A9}"),
    ("\u{C75B}", "\u{C75B}", "\u{110B}\u{1174}\u{11AA}", "\u{C75B}", "\u{110B}\u{1174}\u{11AA}"),
    ("\u{C75C}", "\u{C75C}", "\u{110B}\u{1174}\u{11AB}", "\u{C75C}", "\u{110B}\u{1174}\u{11AB}"),
    ("\u{C75D}", "\u{C75D}", "\u{110B}\u{1174}\u{11AC}", "\u{C75D}", "\u{110B}\u{1174}\u{11AC}"),
    ("\u{C75E}", "\u{C75E}", "\u{110B}\u{1174}\u{11AD}", "\u{C75E}", "\u{110B}\u{1174}\u{11AD}"),
    ("\u{C75F}", "\u{C75F}", "\u{110B}\u{1174}\u{11AE}", "\u{C75F}", "\u{110B}\u{1174}\u{11AE}"),
    ("\u{C760}", "\u{C760}", "\u{110B}\u{1174}\u{11AF}", "\u{C760}", "\u{110B}\u{1174}\u{11AF}"),
    ("\u{C761}", "\u{C761}", "\u{110B}\u{1174}\u{11B0}", "\u{C761}", "\u{110B}\u{1174}\u{11B0}"),
    ("\u{C762}", "\u{C762}", "\u{110B}\u{1174}\u{11B1}", "\u{C762}", "\u{110B}\u{1174}\u{11B1}"),
    ("\u{C763}", "\u{C763}", "\u{110B}\u{1174}\u{11B2}", "\u{C763}", "\u{110B}\u{1174}\u{11B2}"),
    ("\u{C764}", "\u{C764}", "\u{110B}\u{1174}\u{11B3}", "\u{C764}", "\u{110B}\u{1174}\u{11B3}"),
    ("\u{C765}", "\u{C765}", "\u{110B}\u{1174}\u{11B4}", "\u{C765}", "\u{110B}\u{1174}\u{11B4}"),
    ("\u{C766}", "\u{C766}", "\u{110B}\u{1174}\u{11B5}", "\u{C766}", "\u{110B}\u{1174}\u{11B5}"),
    ("\u{C767}", "\u{C767}", "\u{110B}\u{1174}\u{11B6}", "\u{C767}", "\u{110B}\u{1174}\u{11B6}"),
    ("\u{C768}", "\u{C768}", "\u{110B}\u{1174}\u{11B7}", "\u{C768}", "\u{110B}\u{1174}\u{11B7}"),
    ("\u{C769}", "\u{C769}", "\u{110B}\u{1174}\u{11B8}", "\u{C769}", "\u{110B}\u{1174}\u{11B8}"),
    ("\u{C76A}", "\u{C76A}", "\u{110B}\u{1174}\u{11B9}", "\u{C76A}", "\u{110B}\u{1174}\u{11B9}"),
    ("\u{C76B}", "\u{C76B}", "\u{110B}\u{1174}\u{11BA}", "\u{C76B}", "\u{110B}\u{1174}\u{11BA}"),
    ("\u{C76C}", "\u{C76C}", "\u{110B}\u{1174}\u{11BB}", "\u{C76C}", "\u{110B}\u{1174}\u{11BB}"),
    ("\u{C76D}", "\u{C76D}", "\u{110B}\u{1174}\u{11BC}", "\u{C76D}", "\u{110B}\u{1174}\u{11BC}"),
    ("\u{C76E}", "\u{C76E}", "\u{110B}\u{1174}\u{11BD}", "\u{C76E}", "\u{110B}\u{1174}\u{11BD}"),
    ("\u{C76F}", "\u{C76F}", "\u{110B}\u{1174}\u{11BE}", "\u{C76F}", "\u{110B}\u{1174}\u{11BE}"),
    ("\u{C770}", "\u{C770}", "\u{110B}\u{1174}\u{11BF}", "\u{C770}", "\u{110B}\u{1174}\u{11BF}"),
    ("\u{C771}", "\u{C771}", "\u{110B}\u{1174}\u{11C0}", "\u{C771}", "\u{110B}\u{1174}\u{11C0}"),
    ("\u{C772}", "\u{C772}", "\u{110B}\u{1174}\u{11C1}", "\u{C772}", "\u{110B}\u{1174}\u{11C1}"),
    ("\u{C773}", "\u{C773}", "\u{110B}\u{1174}\u{11C2}", "\u{C773}", "\u{110B}\u{1174}\u{11C2}"),
    ("\u{C774}", "\u{C774}", "\u{110B}\u{1175}", "\u{C774}", "\u{110B}\u{1175}"),
    ("\u{C775}", "\u{C775}", "\u{110B}\u{1175}\u{11A8}", "\u{C775}", "\u{110B}\u{1175}\u{11A8}"),
    ("\u{C776}", "\u{C776}", "\u{110B}\u{1175}\u{11A9}", "\u{C776}", "\u{110B}\u{1175}\u{11A9}"),
    ("\u{C777}", "\u{C777}", "\u{110B}\u{1175}\u{11AA}", "\u{C777}", "\u{110B}\u{1175}\u{11AA}"),
    ("\u{C778}", "\u{C778}", "\u{110B}\u{1175}\u{11AB}", "\u{C778}", "\u{110B}\u{1175}\u{11AB}"),
    ("\u{C779}", "\u{C779}", "\u{110B}\u{1175}\u{11AC}", "\u{C779}", "\u{110B}\u{1175}\u{11AC}"),
    ("\u{C77A}", "\u{C77A}", "\u{110B}\u{1175}\u{11AD}", "\u{C77A}", "\u{110B}\u{1175}\u{11AD}"),
    ("\u{C77B}", "\u{C77B}", "\u{110B}\u{1175}\u{11AE}", "\u{C77B}", "\u{110B}\u{1175}\u{11AE}"),
    ("\u{C77C}", "\u{C77C}", "\u{110B}\u{1175}\u{11AF}", "\u{C77C}", "\u{110B}\u{1175}\u{11AF}"),
    ("\u{C77D}", "\u{C77D}", "\u{110B}\u{1175}\u{11B0}", "\u{C77D}", "\u{110B}\u{1175}\u{11B0}"),
    ("\u{C77E}", "\u{C77E}", "\u{110B}\u{1175}\u{11B1}", "\u{C77E}", "\u{110B}\u{1175}\u{11B1}"),
    ("\u{C77F}", "\u{C77F}", "\u{110B}\u{1175}\u{11B2}", "\u{C77F}", "\u{110B}\u{1175}\u{11B2}"),
    ("\u{C780}", "\u{C780}", "\u{110B}\u{1175}\u{11B3}", "\u{C780}", "\u{110B}\u{1175}\u{11B3}"),
    ("\u{C781}", "\u{C781}", "\u{110B}\u{1175}\u{11B4}", "\u{C781}", "\u{110B}\u{1175}\u{11B4}"),
    ("\u{C782}", "\u{C782}", "\u{110B}\u{1175}\u{11B5}", "\u{C782}", "\u{110B}\u{1175}\u{11B5}"),
    ("\u{C783}", "\u{C783}", "\u{110B}\u{1175}\u{11B6}", "\u{C783}", "\u{110B}\u{1175}\u{11B6}"),
    ("\u{C784}", "\u{C784}", "\u{110B}\u{1175}\u{11B7}", "\u{C784}", "\u{110B}\u{1175}\u{11B7}"),
    ("\u{C785}", "\u{C785}", "\u{110B}\u{1175}\u{11B8}", "\u{C785}", "\u{110B}\u{1175}\u{11B8}"),
    ("\u{C786}", "\u{C786}", "\u{110B}\u{1175}\u{11B9}", "\u{C786}", "\u{110B}\u{1175}\u{11B9}"),
    ("\u{C787}", "\u{C787}", "\u{110B}\u{1175}\u{11BA}", "\u{C787}", "\u{110B}\u{1175}\u{11BA}"),
    ("\u{C788}", "\u{C788}", "\u{110B}\u{1175}\u{11BB}", "\u{C788}", "\u{110B}\u{1175}\u{11BB}"),
    ("\u{C789}", "\u{C789}", "\u{110B}\u{1175}\u{11BC}", "\u{C789}", "\u{110B}\u{1175}\u{11BC}"),
    ("\u{C78A}", "\u{C78A}", "\u{110B}\u{1175}\u{11BD}", "\u{C78A}", "\u{110B}\u{1175}\u{11BD}"),
    ("\u{C78B}", "\u{C78B}", "\u{110B}\u{1175}\u{11BE}", "\u{C78B}", "\u{110B}\u{1175}\u{11BE}"),
    ("\u{C78C}", "\u{C78C}", "\u{110B}\u{1175}\u{11BF}", "\u{C78C}", "\u{110B}\u{1175}\u{11BF}"),
    ("\u{C78D}", "\u{C78D}", "\u{110B}\u{1175}\u{11C0}", "\u{C78D}", "\u{110B}\u{1175}\u{11C0}"),
    ("\u{C78E}", "\u{C78E}", "\u{110B}\u{1175}\u{11C1}", "\u{C78E}", "\u{110B}\u{1175}\u{11C1}"),
    ("\u{C78F}", "\u{C78F}", "\u{110B}\u{1175}\u{11C2}", "\u{C78F}", "\u{110B}\u{1175}\u{11C2}"),
    ("\u{C790}", "\u{C790}", "\u{110C}\u{1161}", "\u{C790}", "\u{110C}\u{1161}"),
    ("\u{C791}", "\u{C791}", "\u{110C}\u{1161}\u{11A8}", "\u{C791}", "\u{110C}\u{1161}\u{11A8}"),
    ("\u{C792}", "\u{C792}", "\u{110C}\u{1161}\u{11A9}", "\u{C792}", "\u{110C}\u{1161}\u{11A9}"),
    ("\u{C793}", "\u{C793}", "\u{110C}\u{1161}\u{11AA}", "\u{C793}", "\u{110C}\u{1161}\u{11AA}"),
    ("\u{C794}", "\u{C794}", "\u{110C}\u{1161}\u{11AB}", "\u{C794}", "\u{110C}\u{1161}\u{11AB}"),
    ("\u{C795}", "\u{C795}", "\u{110C}\u{1161}\u{11AC}", "\u{C795}", "\u{110C}\u{1161}\u{11AC}"),
    ("\u{C796}", "\u{C796}", "\u{110C}\u{1161}\u{11AD}", "\u{C796}", "\u{110C}\u{1161}\u{11AD}"),
    ("\u{C797}", "\u{C797}", "\u{110C}\u{1161}\u{11AE}", "\u{C797}", "\u{110C}\u{1161}\u{11AE}"),
    ("\u{C798}", "\u{C798}", "\u{110C}\u{1161}\u{11AF}", "\u{C798}", "\u{110C}\u{1161}\u{11AF}"),
    ("\u{C799}", "\u{C799}", "\u{110C}\u{1161}\u{11B0}", "\u{C799}", "\u{110C}\u{1161}\u{11B0}"),
    ("\u{C79A}", "\u{C79A}", "\u{110C}\u{1161}\u{11B1}", "\u{C79A}", "\u{110C}\u{1161}\u{11B1}"),
    ("\u{C79B}", "\u{C79B}", "\u{110C}\u{1161}\u{11B2}", "\u{C79B}", "\u{110C}\u{1161}\u{11B2}"),
    ("\u{C79C}", "\u{C79C}", "\u{110C}\u{1161}\u{11B3}", "\u{C79C}", "\u{110C}\u{1161}\u{11B3}"),
    ("\u{C79D}", "\u{C79D}", "\u{110C}\u{1161}\u{11B4}", "\u{C79D}", "\u{110C}\u{1161}\u{11B4}"),
    ("\u{C79E}", "\u{C79E}", "\u{110C}\u{1161}\u{11B5}", "\u{C79E}", "\u{110C}\u{1161}\u{11B5}"),
    ("\u{C79F}", "\u{C79F}", "\u{110C}\u{1161}\u{11B6}", "\u{C79F}", "\u{110C}\u{1161}\u{11B6}"),
    ("\u{C7A0}", "\u{C7A0}", "\u{110C}\u{1161}\u{11B7}", "\u{C7A0}", "\u{110C}\u{1161}\u{11B7}"),
    ("\u{C7A1}", "\u{C7A1}", "\u{110C}\u{1161}\u{11B8}", "\u{C7A1}", "\u{110C}\u{1161}\u{11B8}"),
    ("\u{C7A2}", "\u{C7A2}", "\u{110C}\u{1161}\u{11B9}", "\u{C7A2}", "\u{110C}\u{1161}\u{11B9}"),
    ("\u{C7A3}", "\u{C7A3}", "\u{110C}\u{1161}\u{11BA}", "\u{C7A3}", "\u{110C}\u{1161}\u{11BA}"),
    ("\u{C7A4}", "\u{C7A4}", "\u{110C}\u{1161}\u{11BB}", "\u{C7A4}", "\u{110C}\u{1161}\u{11BB}"),
    ("\u{C7A5}", "\u{C7A5}", "\u{110C}\u{1161}\u{11BC}", "\u{C7A5}", "\u{110C}\u{1161}\u{11BC}"),
    ("\u{C7A6}", "\u{C7A6}", "\u{110C}\u{1161}\u{11BD}", "\u{C7A6}", "\u{110C}\u{1161}\u{11BD}"),
    ("\u{C7A7}", "\u{C7A7}", "\u{110C}\u{1161}\u{11BE}", "\u{C7A7}", "\u{110C}\u{1161}\u{11BE}"),
    ("\u{C7A8}", "\u{C7A8}", "\u{110C}\u{1161}\u{11BF}", "\u{C7A8}", "\u{110C}\u{1161}\u{11BF}"),
    ("\u{C7A9}", "\u{C7A9}", "\u{110C}\u{1161}\u{11C0}", "\u{C7A9}", "\u{110C}\u{1161}\u{11C0}"),
    ("\u{C7AA}", "\u{C7AA}", "\u{110C}\u{1161}\u{11C1}", "\u{C7AA}", "\u{110C}\u{1161}\u{11C1}"),
    ("\u{C7AB}", "\u{C7AB}", "\u{110C}\u{1161}\u{11C2}", "\u{C7AB}", "\u{110C}\u{1161}\u{11C2}"),
    ("\u{C7AC}", "\u{C7AC}", "\u{110C}\u{1162}", "\u{C7AC}", "\u{110C}\u{1162}"),
    ("\u{C7AD}", "\u{C7AD}", "\u{110C}\u{1162}\u{11A8}", "\u{C7AD}", "\u{110C}\u{1162}\u{11A8}"),
    ("\u{C7AE}", "\u{C7AE}", "\u{110C}\u{1162}\u{11A9}", "\u{C7AE}", "\u{110C}\u{1162}\u{11A9}"),
    ("\u{C7AF}", "\u{C7AF}", "\u{110C}\u{1162}\u{11AA}", "\u{C7AF}", "\u{110C}\u{1162}\u{11AA}"),
    ("\u{C7B0}", "\u{C7B0}", "\u{110C}\u{1162}\u{11AB}", "\u{C7B0}", "\u{110C}\u{1162}\u{11AB}"),
    ("\u{C7B1}", "\u{C7B1}", "\u{110C}\u{1162}\u{11AC}", "\u{C7B1}", "\u{110C}\u{1162}\u{11AC}"),
    ("\u{C7B2}", "\u{C7B2}", "\u{110C}\u{1162}\u{11AD}", "\u{C7B2}", "\u{110C}\u{1162}\u{11AD}"),
    ("\u{C7B3}", "\u{C7B3}", "\u{110C}\u{1162}\u{11AE}", "\u{C7B3}", "\u{110C}\u{1162}\u{11AE}"),
    ("\u{C7B4}", "\u{C7B4}", "\u{110C}\u{1162}\u{11AF}", "\u{C7B4}", "\u{110C}\u{1162}\u{11AF}"),
    ("\u{C7B5}", "\u{C7B5}", "\u{110C}\u{1162}\u{11B0}", "\u{C7B5}", "\u{110C}\u{1162}\u{11B0}"),
    ("\u{C7B6}", "\u{C7B6}", "\u{110C}\u{1162}\u{11B1}", "\u{C7B6}", "\u{110C}\u{1162}\u{11B1}"),
    ("\u{C7B7}", "\u{C7B7}", "\u{110C}\u{1162}\u{11B2}", "\u{C7B7}", "\u{110C}\u{1162}\u{11B2}"),
    ("\u{C7B8}", "\u{C7B8}", "\u{110C}\u{1162}\u{11B3}", "\u{C7B8}", "\u{110C}\u{1162}\u{11B3}"),
    ("\u{C7B9}", "\u{C7B9}", "\u{110C}\u{1162}\u{11B4}", "\u{C7B9}", "\u{110C}\u{1162}\u{11B4}"),
    ("\u{C7BA}", "\u{C7BA}", "\u{110C}\u{1162}\u{11B5}", "\u{C7BA}", "\u{110C}\u{1162}\u{11B5}"),
    ("\u{C7BB}", "\u{C7BB}", "\u{110C}\u{1162}\u{11B6}", "\u{C7BB}", "\u{110C}\u{1162}\u{11B6}"),
    ("\u{C7BC}", "\u{C7BC}", "\u{110C}\u{1162}\u{11B7}", "\u{C7BC}", "\u{110C}\u{1162}\u{11B7}"),
    ("\u{C7BD}", "\u{C7BD}", "\u{110C}\u{1162}\u{11B8}", "\u{C7BD}", "\u{110C}\u{1162}\u{11B8}"),
    ("\u{C7BE}", "\u{C7BE}", "\u{110C}\u{1162}\u{11B9}", "\u{C7BE}", "\u{110C}\u{1162}\u{11B9}"),
    ("\u{C7BF}", "\u{C7BF}", "\u{110C}\u{1162}\u{11BA}", "\u{C7BF}", "\u{110C}\u{1162}\u{11BA}"),
    ("\u{C7C0}", "\u{C7C0}", "\u{110C}\u{1162}\u{11BB}", "\u{C7C0}", "\u{110C}\u{1162}\u{11BB}"),
    ("\u{C7C1}", "\u{C7C1}", "\u{110C}\u{1162}\u{11BC}", "\u{C7C1}", "\u{110C}\u{1162}\u{11BC}"),
    ("\u{C7C2}", "\u{C7C2}", "\u{110C}\u{1162}\u{11BD}", "\u{C7C2}", "\u{110C}\u{1162}\u{11BD}"),
    ("\u{C7C3}", "\u{C7C3}", "\u{110C}\u{1162}\u{11BE}", "\u{C7C3}", "\u{110C}\u{1162}\u{11BE}"),
    ("\u{C7C4}", "\u{C7C4}", "\u{110C}\u{1162}\u{11BF}", "\u{C7C4}", "\u{110C}\u{1162}\u{11BF}"),
    ("\u{C7C5}", "\u{C7C5}", "\u{110C}\u{1162}\u{11C0}", "\u{C7C5}", "\u{110C}\u{1162}\u{11C0}"),
    ("\u{C7C6}", "\u{C7C6}", "\u{110C}\u{1162}\u{11C1}", "\u{C7C6}", "\u{110C}\u{1162}\u{11C1}"),
    ("\u{C7C7}", "\u{C7C7}", "\u{110C}\u{1162}\u{11C2}", "\u{C7C7}", "\u{110C}\u{1162}\u{11C2}"),
    ("\u{C7C8}", "\u{C7C8}", "\u{110C}\u{1163}", "\u{C7C8}", "\u{110C}\u{1163}"),
    ("\u{C7C9}", "\u{C7C9}", "\u{110C}\u{1163}\u{11A8}", "\u{C7C9}", "\u{110C}\u{1163}\u{11A8}"),
    ("\u{C7CA}", "\u{C7CA}", "\u{110C}\u{1163}\u{11A9}", "\u{C7CA}", "\u{110C}\u{1163}\u{11A9}"),
    ("\u{C7CB}", "\u{C7CB}", "\u{110C}\u{1163}\u{11AA}", "\u{C7CB}", "\u{110C}\u{1163}\u{11AA}"),
    ("\u{C7CC}", "\u{C7CC}", "\u{110C}\u{1163}\u{11AB}", "\u{C7CC}", "\u{110C}\u{1163}\u{11AB}"),
    ("\u{C7CD}", "\u{C7CD}", "\u{110C}\u{1163}\u{11AC}", "\u{C7CD}", "\u{110C}\u{1163}\u{11AC}"),
    ("\u{C7CE}", "\u{C7CE}", "\u{110C}\u{1163}\u{11AD}", "\u{C7CE}", "\u{110C}\u{1163}\u{11AD}"),
    ("\u{C7CF}", "\u{C7CF}", "\u{110C}\u{1163}\u{11AE}", "\u{C7CF}", "\u{110C}\u{1163}\u{11AE}"),
    ("\u{C7D0}", "\u{C7D0}", "\u{110C}\u{1163}\u{11AF}", "\u{C7D0}", "\u{110C}\u{1163}\u{11AF}"),
    ("\u{C7D1}", "\u{C7D1}", "\u{110C}\u{1163}\u{11B0}", "\u{C7D1}", "\u{110C}\u{1163}\u{11B0}"),
    ("\u{C7D2}", "\u{C7D2}", "\u{110C}\u{1163}\u{11B1}", "\u{C7D2}", "\u{110C}\u{1163}\u{11B1}"),
    ("\u{C7D3}", "\u{C7D3}", "\u{110C}\u{1163}\u{11B2}", "\u{C7D3}", "\u{110C}\u{1163}\u{11B2}"),
    ("\u{C7D4}", "\u{C7D4}", "\u{110C}\u{1163}\u{11B3}", "\u{C7D4}", "\u{110C}\u{1163}\u{11B3}"),
    ("\u{C7D5}", "\u{C7D5}", "\u{110C}\u{1163}\u{11B4}", "\u{C7D5}", "\u{110C}\u{1163}\u{11B4}"),
    ("\u{C7D6}", "\u{C7D6}", "\u{110C}\u{1163}\u{11B5}", "\u{C7D6}", "\u{110C}\u{1163}\u{11B5}"),
    ("\u{C7D7}", "\u{C7D7}", "\u{110C}\u{1163}\u{11B6}", "\u{C7D7}", "\u{110C}\u{1163}\u{11B6}"),
    ("\u{C7D8}", "\u{C7D8}", "\u{110C}\u{1163}\u{11B7}", "\u{C7D8}", "\u{110C}\u{1163}\u{11B7}"),
    ("\u{C7D9}", "\u{C7D9}", "\u{110C}\u{1163}\u{11B8}", "\u{C7D9}", "\u{110C}\u{1163}\u{11B8}"),
    ("\u{C7DA}", "\u{C7DA}", "\u{110C}\u{1163}\u{11B9}", "\u{C7DA}", "\u{110C}\u{1163}\u{11B9}"),
    ("\u{C7DB}", "\u{C7DB}", "\u{110C}\u{1163}\u{11BA}", "\u{C7DB}", "\u{110C}\u{1163}\u{11BA}"),
    ("\u{C7DC}", "\u{C7DC}", "\u{110C}\u{1163}\u{11BB}", "\u{C7DC}", "\u{110C}\u{1163}\u{11BB}"),
    ("\u{C7DD}", "\u{C7DD}", "\u{110C}\u{1163}\u{11BC}", "\u{C7DD}", "\u{110C}\u{1163}\u{11BC}"),
    ("\u{C7DE}", "\u{C7DE}", "\u{110C}\u{1163}\u{11BD}", "\u{C7DE}", "\u{110C}\u{1163}\u{11BD}"),
    ("\u{C7DF}", "\u{C7DF}", "\u{110C}\u{1163}\u{11BE}", "\u{C7DF}", "\u{110C}\u{1163}\u{11BE}"),
    ("\u{C7E0}", "\u{C7E0}", "\u{110C}\u{1163}\u{11BF}", "\u{C7E0}", "\u{110C}\u{1163}\u{11BF}"),
    ("\u{C7E1}", "\u{C7E1}", "\u{110C}\u{1163}\u{11C0}", "\u{C7E1}", "\u{110C}\u{1163}\u{11C0}"),
    ("\u{C7E2}", "\u{C7E2}", "\u{110C}\u{1163}\u{11C1}", "\u{C7E2}", "\u{110C}\u{1163}\u{11C1}"),
    ("\u{C7E3}", "\u{C7E3}", "\u{110C}\u{1163}\u{11C2}", "\u{C7E3}", "\u{110C}\u{1163}\u{11C2}"),
    ("\u{C7E4}", "\u{C7E4}", "\u{110C}\u{1164}", "\u{C7E4}", "\u{110C}\u{1164}"),
    ("\u{C7E5}", "\u{C7E5}", "\u{110C}\u{1164}\u{11A8}", "\u{C7E5}", "\u{110C}\u{1164}\u{11A8}"),
    ("\u{C7E6}", "\u{C7E6}", "\u{110C}\u{1164}\u{11A9}", "\u{C7E6}", "\u{110C}\u{1164}\u{11A9}"),
    ("\u{C7E7}", "\u{C7E7}", "\u{110C}\u{1164}\u{11AA}", "\u{C7E7}", "\u{110C}\u{1164}\u{11AA}"),
    ("\u{C7E8}", "\u{C7E8}", "\u{110C}\u{1164}\u{11AB}", "\u{C7E8}", "\u{110C}\u{1164}\u{11AB}"),
    ("\u{C7E9}", "\u{C7E9}", "\u{110C}\u{1164}\u{11AC}", "\u{C7E9}", "\u{110C}\u{1164}\u{11AC}"),
    ("\u{C7EA}", "\u{C7EA}", "\u{110C}\u{1164}\u{11AD}", "\u{C7EA}", "\u{110C}\u{1164}\u{11AD}"),
    ("\u{C7EB}", "\u{C7EB}", "\u{110C}\u{1164}\u{11AE}", "\u{C7EB}", "\u{110C}\u{1164}\u{11AE}"),
    ("\u{C7EC}", "\u{C7EC}", "\u{110C}\u{1164}\u{11AF}", "\u{C7EC}", "\u{110C}\u{1164}\u{11AF}"),
    ("\u{C7ED}", "\u{C7ED}", "\u{110C}\u{1164}\u{11B0}", "\u{C7ED}", "\u{110C}\u{1164}\u{11B0}"),
    ("\u{C7EE}", "\u{C7EE}", "\u{110C}\u{1164}\u{11B1}", "\u{C7EE}", "\u{110C}\u{1164}\u{11B1}"),
    ("\u{C7EF}", "\u{C7EF}", "\u{110C}\u{1164}\u{11B2}", "\u{C7EF}", "\u{110C}\u{1164}\u{11B2}"),
    ("\u{C7F0}", "\u{C7F0}", "\u{110C}\u{1164}\u{11B3}", "\u{C7F0}", "\u{110C}\u{1164}\u{11B3}"),
    ("\u{C7F1}", "\u{C7F1}", "\u{110C}\u{1164}\u{11B4}", "\u{C7F1}", "\u{110C}\u{1164}\u{11B4}"),
    ("\u{C7F2}", "\u{C7F2}", "\u{110C}\u{1164}\u{11B5}", "\u{C7F2}", "\u{110C}\u{1164}\u{11B5}"),
    ("\u{C7F3}", "\u{C7F3}", "\u{110C}\u{1164}\u{11B6}", "\u{C7F3}", "\u{110C}\u{1164}\u{11B6}"),
    ("\u{C7F4}", "\u{C7F4}", "\u{110C}\u{1164}\u{11B7}", "\u{C7F4}", "\u{110C}\u{1164}\u{11B7}"),
    ("\u{C7F5}", "\u{C7F5}", "\u{110C}\u{1164}\u{11B8}", "\u{C7F5}", "\u{110C}\u{1164}\u{11B8}"),
    ("\u{C7F6}", "\u{C7F6}", "\u{110C}\u{1164}\u{11B9}", "\u{C7F6}", "\u{110C}\u{1164}\u{11B9}"),
    ("\u{C7F7}", "\u{C7F7}", "\u{110C}\u{1164}\u{11BA}", "\u{C7F7}", "\u{110C}\u{1164}\u{11BA}"),
    ("\u{C7F8}", "\u{C7F8}", "\u{110C}\u{1164}\u{11BB}", "\u{C7F8}", "\u{110C}\u{1164}\u{11BB}"),
    ("\u{C7F9}", "\u{C7F9}", "\u{110C}\u{1164}\u{11BC}", "\u{C7F9}", "\u{110C}\u{1164}\u{11BC}"),
    ("\u{C7FA}", "\u{C7FA}", "\u{110C}\u{1164}\u{11BD}", "\u{C7FA}", "\u{110C}\u{1164}\u{11BD}"),
    ("\u{C7FB}", "\u{C7FB}", "\u{110C}\u{1164}\u{11BE}", "\u{C7FB}", "\u{110C}\u{1164}\u{11BE}"),
    ("\u{C7FC}", "\u{C7FC}", "\u{110C}\u{1164}\u{11BF}", "\u{C7FC}", "\u{110C}\u{1164}\u{11BF}"),
    ("\u{C7FD}", "\u{C7FD}", "\u{110C}\u{1164}\u{11C0}", "\u{C7FD}", "\u{110C}\u{1164}\u{11C0}"),
    ("\u{C7FE}", "\u{C7FE}", "\u{110C}\u{1164}\u{11C1}", "\u{C7FE}", "\u{110C}\u{1164}\u{11C1}"),
    ("\u{C7FF}", "\u{C7FF}", "\u{110C}\u{1164}\u{11C2}", "\u{C7FF}", "\u{110C}\u{1164}\u{11C2}"),
    ("\u{C800}", "\u{C800}", "\u{110C}\u{1165}", "\u{C800}", "\u{110C}\u{1165}"),
    ("\u{C801}", "\u{C801}", "\u{110C}\u{1165}\u{11A8}", "\u{C801}", "\u{110C}\u{1165}\u{11A8}"),
    ("\u{C802}", "\u{C802}", "\u{110C}\u{1165}\u{11A9}", "\u{C802}", "\u{110C}\u{1165}\u{11A9}"),
    ("\u{C803}", "\u{C803}", "\u{110C}\u{1165}\u{11AA}", "\u{C803}", "\u{110C}\u{1165}\u{11AA}"),
    ("\u{C804}", "\u{C804}", "\u{110C}\u{1165}\u{11AB}", "\u{C804}", "\u{110C}\u{1165}\u{11AB}"),
    ("\u{C805}", "\u{C805}", "\u{110C}\u{1165}\u{11AC}", "\u{C805}", "\u{110C}\u{1165}\u{11AC}"),
    ("\u{C806}", "\u{C806}", "\u{110C}\u{1165}\u{11AD}", "\u{C806}", "\u{110C}\u{1165}\u{11AD}"),
    ("\u{C807}", "\u{C807}", "\u{110C}\u{1165}\u{11AE}", "\u{C807}", "\u{110C}\u{1165}\u{11AE}"),
    ("\u{C808}", "\u{C808}", "\u{110C}\u{1165}\u{11AF}", "\u{C808}", "\u{110C}\u{1165}\u{11AF}"),
    ("\u{C809}", "\u{C809}", "\u{110C}\u{1165}\u{11B0}", "\u{C809}", "\u{110C}\u{1165}\u{11B0}"),
    ("\u{C80A}", "\u{C80A}", "\u{110C}\u{1165}\u{11B1}", "\u{C80A}", "\u{110C}\u{1165}\u{11B1}"),
    ("\u{C80B}", "\u{C80B}", "\u{110C}\u{1165}\u{11B2}", "\u{C80B}", "\u{110C}\u{1165}\u{11B2}"),
    ("\u{C80C}", "\u{C80C}", "\u{110C}\u{1165}\u{11B3}", "\u{C80C}", "\u{110C}\u{1165}\u{11B3}"),
    ("\u{C80D}", "\u{C80D}", "\u{110C}\u{1165}\u{11B4}", "\u{C80D}", "\u{110C}\u{1165}\u{11B4}"),
    ("\u{C80E}", "\u{C80E}", "\u{110C}\u{1165}\u{11B5}", "\u{C80E}", "\u{110C}\u{1165}\u{11B5}"),
    ("\u{C80F}", "\u{C80F}", "\u{110C}\u{1165}\u{11B6}", "\u{C80F}", "\u{110C}\u{1165}\u{11B6}"),
    ("\u{C810}", "\u{C810}", "\u{110C}\u{1165}\u{11B7}", "\u{C810}", "\u{110C}\u{1165}\u{11B7}"),
    ("\u{C811}", "\u{C811}", "\u{110C}\u{1165}\u{11B8}", "\u{C811}", "\u{110C}\u{1165}\u{11B8}"),
    ("\u{C812}", "\u{C812}", "\u{110C}\u{1165}\u{11B9}", "\u{C812}", "\u{110C}\u{1165}\u{11B9}"),
    ("\u{C813}", "\u{C813}", "\u{110C}\u{1165}\u{11BA}", "\u{C813}", "\u{110C}\u{1165}\u{11BA}"),
    ("\u{C814}", "\u{C814}", "\u{110C}\u{1165}\u{11BB}", "\u{C814}", "\u{110C}\u{1165}\u{11BB}"),
    ("\u{C815}", "\u{C815}", "\u{110C}\u{1165}\u{11BC}", "\u{C815}", "\u{110C}\u{1165}\u{11BC}"),
    ("\u{C816}", "\u{C816}", "\u{110C}\u{1165}\u{11BD}", "\u{C816}", "\u{110C}\u{1165}\u{11BD}"),
    ("\u{C817}", "\u{C817}", "\u{110C}\u{1165}\u{11BE}", "\u{C817}", "\u{110C}\u{1165}\u{11BE}"),
    ("\u{C818}", "\u{C818}", "\u{110C}\u{1165}\u{11BF}", "\u{C818}", "\u{110C}\u{1165}\u{11BF}"),
    ("\u{C819}", "\u{C819}", "\u{110C}\u{1165}\u{11C0}", "\u{C819}", "\u{110C}\u{1165}\u{11C0}"),
    ("\u{C81A}", "\u{C81A}", "\u{110C}\u{1165}\u{11C1}", "\u{C81A}", "\u{110C}\u{1165}\u{11C1}"),
    ("\u{C81B}", "\u{C81B}", "\u{110C}\u{1165}\u{11C2}", "\u{C81B}", "\u{110C}\u{1165}\u{11C2}"),
    ("\u{C81C}", "\u{C81C}", "\u{110C}\u{1166}", "\u{C81C}", "\u{110C}\u{1166}"),
    ("\u{C81D}", "\u{C81D}", "\u{110C}\u{1166}\u{11A8}", "\u{C81D}", "\u{110C}\u{1166}\u{11A8}"),
    ("\u{C81E}", "\u{C81E}", "\u{110C}\u{1166}\u{11A9}", "\u{C81E}", "\u{110C}\u{1166}\u{11A9}"),
    ("\u{C81F}", "\u{C81F}", "\u{110C}\u{1166}\u{11AA}", "\u{C81F}", "\u{110C}\u{1166}\u{11AA}"),
    ("\u{C820}", "\u{C820}", "\u{110C}\u{1166}\u{11AB}", "\u{C820}", "\u{110C}\u{1166}\u{11AB}"),
    ("\u{C821}", "\u{C821}", "\u{110C}\u{1166}\u{11AC}", "\u{C821}", "\u{110C}\u{1166}\u{11AC}"),
    ("\u{C822}", "\u{C822}", "\u{110C}\u{1166}\u{11AD}", "\u{C822}", "\u{110C}\u{1166}\u{11AD}"),
    ("\u{C823}", "\u{C823}", "\u{110C}\u{1166}\u{11AE}", "\u{C823}", "\u{110C}\u{1166}\u{11AE}"),
    ("\u{C824}", "\u{C824}", "\u{110C}\u{1166}\u{11AF}", "\u{C824}", "\u{110C}\u{1166}\u{11AF}"),
    ("\u{C825}", "\u{C825}", "\u{110C}\u{1166}\u{11B0}", "\u{C825}", "\u{110C}\u{1166}\u{11B0}"),
    ("\u{C826}", "\u{C826}", "\u{110C}\u{1166}\u{11B1}", "\u{C826}", "\u{110C}\u{1166}\u{11B1}"),
    ("\u{C827}", "\u{C827}", "\u{110C}\u{1166}\u{11B2}", "\u{C827}", "\u{110C}\u{1166}\u{11B2}"),
    ("\u{C828}", "\u{C828}", "\u{110C}\u{1166}\u{11B3}", "\u{C828}", "\u{110C}\u{1166}\u{11B3}"),
    ("\u{C829}", "\u{C829}", "\u{110C}\u{1166}\u{11B4}", "\u{C829}", "\u{110C}\u{1166}\u{11B4}"),
    ("\u{C82A}", "\u{C82A}", "\u{110C}\u{1166}\u{11B5}", "\u{C82A}", "\u{110C}\u{1166}\u{11B5}"),
    ("\u{C82B}", "\u{C82B}", "\u{110C}\u{1166}\u{11B6}", "\u{C82B}", "\u{110C}\u{1166}\u{11B6}"),
    ("\u{C82C}", "\u{C82C}", "\u{110C}\u{1166}\u{11B7}", "\u{C82C}", "\u{110C}\u{1166}\u{11B7}"),
    ("\u{C82D}", "\u{C82D}", "\u{110C}\u{1166}\u{11B8}", "\u{C82D}", "\u{110C}\u{1166}\u{11B8}"),
    ("\u{C82E}", "\u{C82E}", "\u{110C}\u{1166}\u{11B9}", "\u{C82E}", "\u{110C}\u{1166}\u{11B9}"),
    ("\u{C82F}", "\u{C82F}", "\u{110C}\u{1166}\u{11BA}", "\u{C82F}", "\u{110C}\u{1166}\u{11BA}"),
    ("\u{C830}", "\u{C830}", "\u{110C}\u{1166}\u{11BB}", "\u{C830}", "\u{110C}\u{1166}\u{11BB}"),
    ("\u{C831}", "\u{C831}", "\u{110C}\u{1166}\u{11BC}", "\u{C831}", "\u{110C}\u{1166}\u{11BC}"),
    ("\u{C832}", "\u{C832}", "\u{110C}\u{1166}\u{11BD}", "\u{C832}", "\u{110C}\u{1166}\u{11BD}"),
    ("\u{C833}", "\u{C833}", "\u{110C}\u{1166}\u{11BE}", "\u{C833}", "\u{110C}\u{1166}\u{11BE}"),
    ("\u{C834}", "\u{C834}", "\u{110C}\u{1166}\u{11BF}", "\u{C834}", "\u{110C}\u{1166}\u{11BF}"),
    ("\u{C835}", "\u{C835}", "\u{110C}\u{1166}\u{11C0}", "\u{C835}", "\u{110C}\u{1166}\u{11C0}"),
    ("\u{C836}", "\u{C836}", "\u{110C}\u{1166}\u{11C1}", "\u{C836}", "\u{110C}\u{1166}\u{11C1}"),
    ("\u{C837}", "\u{C837}", "\u{110C}\u{1166}\u{11C2}", "\u{C837}", "\u{110C}\u{1166}\u{11C2}"),
    ("\u{C838}", "\u{C838}", "\u{110C}\u{1167}", "\u{C838}", "\u{110C}\u{1167}"),
    ("\u{C839}", "\u{C839}", "\u{110C}\u{1167}\u{11A8}", "\u{C839}", "\u{110C}\u{1167}\u{11A8}"),
    ("\u{C83A}", "\u{C83A}", "\u{110C}\u{1167}\u{11A9}", "\u{C83A}", "\u{110C}\u{1167}\u{11A9}"),
    ("\u{C83B}", "\u{C83B}", "\u{110C}\u{1167}\u{11AA}", "\u{C83B}", "\u{110C}\u{1167}\u{11AA}"),
    ("\u{C83C}", "\u{C83C}", "\u{110C}\u{1167}\u{11AB}", "\u{C83C}", "\u{110C}\u{1167}\u{11AB}"),
    ("\u{C83D}", "\u{C83D}", "\u{110C}\u{1167}\u{11AC}", "\u{C83D}", "\u{110C}\u{1167}\u{11AC}"),
    ("\u{C83E}", "\u{C83E}", "\u{110C}\u{1167}\u{11AD}", "\u{C83E}", "\u{110C}\u{1167}\u{11AD}"),
    ("\u{C83F}", "\u{C83F}", "\u{110C}\u{1167}\u{11AE}", "\u{C83F}", "\u{110C}\u{1167}\u{11AE}"),
    ("\u{C840}", "\u{C840}", "\u{110C}\u{1167}\u{11AF}", "\u{C840}", "\u{110C}\u{1167}\u{11AF}"),
    ("\u{C841}", "\u{C841}", "\u{110C}\u{1167}\u{11B0}", "\u{C841}", "\u{110C}\u{1167}\u{11B0}"),
    ("\u{C842}", "\u{C842}", "\u{110C}\u{1167}\u{11B1}", "\u{C842}", "\u{110C}\u{1167}\u{11B1}"),
    ("\u{C843}", "\u{C843}", "\u{110C}\u{1167}\u{11B2}", "\u{C843}", "\u{110C}\u{1167}\u{11B2}"),
    ("\u{C844}", "\u{C844}", "\u{110C}\u{1167}\u{11B3}", "\u{C844}", "\u{110C}\u{1167}\u{11B3}"),
    ("\u{C845}", "\u{C845}", "\u{110C}\u{1167}\u{11B4}", "\u{C845}", "\u{110C}\u{1167}\u{11B4}"),
    ("\u{C846}", "\u{C846}", "\u{110C}\u{1167}\u{11B5}", "\u{C846}", "\u{110C}\u{1167}\u{11B5}"),
    ("\u{C847}", "\u{C847}", "\u{110C}\u{1167}\u{11B6}", "\u{C847}", "\u{110C}\u{1167}\u{11B6}"),
    ("\u{C848}", "\u{C848}", "\u{110C}\u{1167}\u{11B7}", "\u{C848}", "\u{110C}\u{1167}\u{11B7}"),
    ("\u{C849}", "\u{C849}", "\u{110C}\u{1167}\u{11B8}", "\u{C849}", "\u{110C}\u{1167}\u{11B8}"),
    ("\u{C84A}", "\u{C84A}", "\u{110C}\u{1167}\u{11B9}", "\u{C84A}", "\u{110C}\u{1167}\u{11B9}"),
    ("\u{C84B}", "\u{C84B}", "\u{110C}\u{1167}\u{11BA}", "\u{C84B}", "\u{110C}\u{1167}\u{11BA}"),
    ("\u{C84C}", "\u{C84C}", "\u{110C}\u{1167}\u{11BB}", "\u{C84C}", "\u{110C}\u{1167}\u{11BB}"),
    ("\u{C84D}", "\u{C84D}", "\u{110C}\u{1167}\u{11BC}", "\u{C84D}", "\u{110C}\u{1167}\u{11BC}"),
    ("\u{C84E}", "\u{C84E}", "\u{110C}\u{1167}\u{11BD}", "\u{C84E}", "\u{110C}\u{1167}\u{11BD}"),
    ("\u{C84F}", "\u{C84F}", "\u{110C}\u{1167}\u{11BE}", "\u{C84F}", "\u{110C}\u{1167}\u{11BE}"),
    ("\u{C850}", "\u{C850}", "\u{110C}\u{1167}\u{11BF}", "\u{C850}", "\u{110C}\u{1167}\u{11BF}"),
    ("\u{C851}", "\u{C851}", "\u{110C}\u{1167}\u{11C0}", "\u{C851}", "\u{110C}\u{1167}\u{11C0}"),
    ("\u{C852}", "\u{C852}", "\u{110C}\u{1167}\u{11C1}", "\u{C852}", "\u{110C}\u{1167}\u{11C1}"),
    ("\u{C853}", "\u{C853}", "\u{110C}\u{1167}\u{11C2}", "\u{C853}", "\u{110C}\u{1167}\u{11C2}"),
    ("\u{C854}", "\u{C854}", "\u{110C}\u{1168}", "\u{C854}", "\u{110C}\u{1168}"),
    ("\u{C855}", "\u{C855}", "\u{110C}\u{1168}\u{11A8}", "\u{C855}", "\u{110C}\u{1168}\u{11A8}"),
    ("\u{C856}", "\u{C856}", "\u{110C}\u{1168}\u{11A9}", "\u{C856}", "\u{110C}\u{1168}\u{11A9}"),
    ("\u{C857}", "\u{C857}", "\u{110C}\u{1168}\u{11AA}", "\u{C857}", "\u{110C}\u{1168}\u{11AA}"),
    ("\u{C858}", "\u{C858}", "\u{110C}\u{1168}\u{11AB}", "\u{C858}", "\u{110C}\u{1168}\u{11AB}"),
    ("\u{C859}", "\u{C859}", "\u{110C}\u{1168}\u{11AC}", "\u{C859}", "\u{110C}\u{1168}\u{11AC}"),
    ("\u{C85A}", "\u{C85A}", "\u{110C}\u{1168}\u{11AD}", "\u{C85A}", "\u{110C}\u{1168}\u{11AD}"),
    ("\u{C85B}", "\u{C85B}", "\u{110C}\u{1168}\u{11AE}", "\u{C85B}", "\u{110C}\u{1168}\u{11AE}"),
    ("\u{C85C}", "\u{C85C}", "\u{110C}\u{1168}\u{11AF}", "\u{C85C}", "\u{110C}\u{1168}\u{11AF}"),
    ("\u{C85D}", "\u{C85D}", "\u{110C}\u{1168}\u{11B0}", "\u{C85D}", "\u{110C}\u{1168}\u{11B0}"),
    ("\u{C85E}", "\u{C85E}", "\u{110C}\u{1168}\u{11B1}", "\u{C85E}", "\u{110C}\u{1168}\u{11B1}"),
    ("\u{C85F}", "\u{C85F}", "\u{110C}\u{1168}\u{11B2}", "\u{C85F}", "\u{110C}\u{1168}\u{11B2}"),
    ("\u{C860}", "\u{C860}", "\u{110C}\u{1168}\u{11B3}", "\u{C860}", "\u{110C}\u{1168}\u{11B3}"),
    ("\u{C861}", "\u{C861}", "\u{110C}\u{1168}\u{11B4}", "\u{C861}", "\u{110C}\u{1168}\u{11B4}"),
    ("\u{C862}", "\u{C862}", "\u{110C}\u{1168}\u{11B5}", "\u{C862}", "\u{110C}\u{1168}\u{11B5}"),
    ("\u{C863}", "\u{C863}", "\u{110C}\u{1168}\u{11B6}", "\u{C863}", "\u{110C}\u{1168}\u{11B6}"),
    ("\u{C864}", "\u{C864}", "\u{110C}\u{1168}\u{11B7}", "\u{C864}", "\u{110C}\u{1168}\u{11B7}"),
    ("\u{C865}", "\u{C865}", "\u{110C}\u{1168}\u{11B8}", "\u{C865}", "\u{110C}\u{1168}\u{11B8}"),
    ("\u{C866}", "\u{C866}", "\u{110C}\u{1168}\u{11B9}", "\u{C866}", "\u{110C}\u{1168}\u{11B9}"),
    ("\u{C867}", "\u{C867}", "\u{110C}\u{1168}\u{11BA}", "\u{C867}", "\u{110C}\u{1168}\u{11BA}"),
    ("\u{C868}", "\u{C868}", "\u{110C}\u{1168}\u{11BB}", "\u{C868}", "\u{110C}\u{1168}\u{11BB}"),
    ("\u{C869}", "\u{C869}", "\u{110C}\u{1168}\u{11BC}", "\u{C869}", "\u{110C}\u{1168}\u{11BC}"),
    ("\u{C86A}", "\u{C86A}", "\u{110C}\u{1168}\u{11BD}", "\u{C86A}", "\u{110C}\u{1168}\u{11BD}"),
    ("\u{C86B}", "\u{C86B}", "\u{110C}\u{1168}\u{11BE}", "\u{C86B}", "\u{110C}\u{1168}\u{11BE}"),
    ("\u{C86C}", "\u{C86C}", "\u{110C}\u{1168}\u{11BF}", "\u{C86C}", "\u{110C}\u{1168}\u{11BF}"),
    ("\u{C86D}", "\u{C86D}", "\u{110C}\u{1168}\u{11C0}", "\u{C86D}", "\u{110C}\u{1168}\u{11C0}"),
    ("\u{C86E}", "\u{C86E}", "\u{110C}\u{1168}\u{11C1}", "\u{C86E}", "\u{110C}\u{1168}\u{11C1}"),
    ("\u{C86F}", "\u{C86F}", "\u{110C}\u{1168}\u{11C2}", "\u{C86F}", "\u{110C}\u{1168}\u{11C2}"),
    ("\u{C870}", "\u{C870}", "\u{110C}\u{1169}", "\u{C870}", "\u{110C}\u{1169}"),
    ("\u{C871}", "\u{C871}", "\u{110C}\u{1169}\u{11A8}", "\u{C871}", "\u{110C}\u{1169}\u{11A8}"),
    ("\u{C872}", "\u{C872}", "\u{110C}\u{1169}\u{11A9}", "\u{C872}", "\u{110C}\u{1169}\u{11A9}"),
    ("\u{C873}", "\u{C873}", "\u{110C}\u{1169}\u{11AA}", "\u{C873}", "\u{110C}\u{1169}\u{11AA}"),
    ("\u{C874}", "\u{C874}", "\u{110C}\u{1169}\u{11AB}", "\u{C874}", "\u{110C}\u{1169}\u{11AB}"),
    ("\u{C875}", "\u{C875}", "\u{110C}\u{1169}\u{11AC}", "\u{C875}", "\u{110C}\u{1169}\u{11AC}"),
    ("\u{C876}", "\u{C876}", "\u{110C}\u{1169}\u{11AD}", "\u{C876}", "\u{110C}\u{1169}\u{11AD}"),
    ("\u{C877}", "\u{C877}", "\u{110C}\u{1169}\u{11AE}", "\u{C877}", "\u{110C}\u{1169}\u{11AE}"),
    ("\u{C878}", "\u{C878}", "\u{110C}\u{1169}\u{11AF}", "\u{C878}", "\u{110C}\u{1169}\u{11AF}"),
    ("\u{C879}", "\u{C879}", "\u{110C}\u{1169}\u{11B0}", "\u{C879}", "\u{110C}\u{1169}\u{11B0}"),
    ("\u{C87A}", "\u{C87A}", "\u{110C}\u{1169}\u{11B1}", "\u{C87A}", "\u{110C}\u{1169}\u{11B1}"),
    ("\u{C87B}", "\u{C87B}", "\u{110C}\u{1169}\u{11B2}", "\u{C87B}", "\u{110C}\u{1169}\u{11B2}"),
    ("\u{C87C}", "\u{C87C}", "\u{110C}\u{1169}\u{11B3}", "\u{C87C}", "\u{110C}\u{1169}\u{11B3}"),
    ("\u{C87D}", "\u{C87D}", "\u{110C}\u{1169}\u{11B4}", "\u{C87D}", "\u{110C}\u{1169}\u{11B4}"),
    ("\u{C87E}", "\u{C87E}", "\u{110C}\u{1169}\u{11B5}", "\u{C87E}", "\u{110C}\u{1169}\u{11B5}"),
    ("\u{C87F}", "\u{C87F}", "\u{110C}\u{1169}\u{11B6}", "\u{C87F}", "\u{110C}\u{1169}\u{11B6}"),
    ("\u{C880}", "\u{C880}", "\u{110C}\u{1169}\u{11B7}", "\u{C880}", "\u{110C}\u{1169}\u{11B7}"),
    ("\u{C881}", "\u{C881}", "\u{110C}\u{1169}\u{11B8}", "\u{C881}", "\u{110C}\u{1169}\u{11B8}"),
    ("\u{C882}", "\u{C882}", "\u{110C}\u{1169}\u{11B9}", "\u{C882}", "\u{110C}\u{1169}\u{11B9}"),
    ("\u{C883}", "\u{C883}", "\u{110C}\u{1169}\u{11BA}", "\u{C883}", "\u{110C}\u{1169}\u{11BA}"),
    ("\u{C884}", "\u{C884}", "\u{110C}\u{1169}\u{11BB}", "\u{C884}", "\u{110C}\u{1169}\u{11BB}"),
    ("\u{C885}", "\u{C885}", "\u{110C}\u{1169}\u{11BC}", "\u{C885}", "\u{110C}\u{1169}\u{11BC}"),
    ("\u{C886}", "\u{C886}", "\u{110C}\u{1169}\u{11BD}", "\u{C886}", "\u{110C}\u{1169}\u{11BD}"),
    ("\u{C887}", "\u{C887}", "\u{110C}\u{1169}\u{11BE}", "\u{C887}", "\u{110C}\u{1169}\u{11BE}"),
    ("\u{C888}", "\u{C888}", "\u{110C}\u{1169}\u{11BF}", "\u{C888}", "\u{110C}\u{1169}\u{11BF}"),
    ("\u{C889}", "\u{C889}", "\u{110C}\u{1169}\u{11C0}", "\u{C889}", "\u{110C}\u{1169}\u{11C0}"),
    ("\u{C88A}", "\u{C88A}", "\u{110C}\u{1169}\u{11C1}", "\u{C88A}", "\u{110C}\u{1169}\u{11C1}"),
    ("\u{C88B}", "\u{C88B}", "\u{110C}\u{1169}\u{11C2}", "\u{C88B}", "\u{110C}\u{1169}\u{11C2}"),
    ("\u{C88C}", "\u{C88C}", "\u{110C}\u{116A}", "\u{C88C}", "\u{110C}\u{116A}"),
    ("\u{C88D}", "\u{C88D}", "\u{110C}\u{116A}\u{11A8}", "\u{C88D}", "\u{110C}\u{116A}\u{11A8}"),
    ("\u{C88E}", "\u{C88E}", "\u{110C}\u{116A}\u{11A9}", "\u{C88E}", "\u{110C}\u{116A}\u{11A9}"),
    ("\u{C88F}", "\u{C88F}", "\u{110C}\u{116A}\u{11AA}", "\u{C88F}", "\u{110C}\u{116A}\u{11AA}"),
    ("\u{C890}", "\u{C890}", "\u{110C}\u{116A}\u{11AB}", "\u{C890}", "\u{110C}\u{116A}\u{11AB}"),
    ("\u{C891}", "\u{C891}", "\u{110C}\u{116A}\u{11AC}", "\u{C891}", "\u{110C}\u{116A}\u{11AC}"),
    ("\u{C892}", "\u{C892}", "\u{110C}\u{116A}\u{11AD}", "\u{C892}", "\u{110C}\u{116A}\u{11AD}"),
    ("\u{C893}", "\u{C893}", "\u{110C}\u{116A}\u{11AE}", "\u{C893}", "\u{110C}\u{116A}\u{11AE}"),
    ("\u{C894}", "\u{C894}", "\u{110C}\u{116A}\u{11AF}", "\u{C894}", "\u{110C}\u{116A}\u{11AF}"),
    ("\u{C895}", "\u{C895}", "\u{110C}\u{116A}\u{11B0}", "\u{C895}", "\u{110C}\u{116A}\u{11B0}"),
    ("\u{C896}", "\u{C896}", "\u{110C}\u{116A}\u{11B1}", "\u{C896}", "\u{110C}\u{116A}\u{11B1}"),
    ("\u{C897}", "\u{C897}", "\u{110C}\u{116A}\u{11B2}", "\u{C897}", "\u{110C}\u{116A}\u{11B2}"),
    ("\u{C898}", "\u{C898}", "\u{110C}\u{116A}\u{11B3}", "\u{C898}", "\u{110C}\u{116A}\u{11B3}"),
    ("\u{C899}", "\u{C899}", "\u{110C}\u{116A}\u{11B4}", "\u{C899}", "\u{110C}\u{116A}\u{11B4}"),
    ("\u{C89A}", "\u{C89A}", "\u{110C}\u{116A}\u{11B5}", "\u{C89A}", "\u{110C}\u{116A}\u{11B5}"),
    ("\u{C89B}", "\u{C89B}", "\u{110C}\u{116A}\u{11B6}", "\u{C89B}", "\u{110C}\u{116A}\u{11B6}"),
    ("\u{C89C}", "\u{C89C}", "\u{110C}\u{116A}\u{11B7}", "\u{C89C}", "\u{110C}\u{116A}\u{11B7}"),
    ("\u{C89D}", "\u{C89D}", "\u{110C}\u{116A}\u{11B8}", "\u{C89D}", "\u{110C}\u{116A}\u{11B8}"),
    ("\u{C89E}", "\u{C89E}", "\u{110C}\u{116A}\u{11B9}", "\u{C89E}", "\u{110C}\u{116A}\u{11B9}"),
    ("\u{C89F}", "\u{C89F}", "\u{110C}\u{116A}\u{11BA}", "\u{C89F}", "\u{110C}\u{116A}\u{11BA}"),
    ("\u{C8A0}", "\u{C8A0}", "\u{110C}\u{116A}\u{11BB}", "\u{C8A0}", "\u{110C}\u{116A}\u{11BB}"),
    ("\u{C8A1}", "\u{C8A1}", "\u{110C}\u{116A}\u{11BC}", "\u{C8A1}", "\u{110C}\u{116A}\u{11BC}"),
    ("\u{C8A2}", "\u{C8A2}", "\u{110C}\u{116A}\u{11BD}", "\u{C8A2}", "\u{110C}\u{116A}\u{11BD}"),
    ("\u{C8A3}", "\u{C8A3}", "\u{110C}\u{116A}\u{11BE}", "\u{C8A3}", "\u{110C}\u{116A}\u{11BE}"),
    ("\u{C8A4}", "\u{C8A4}", "\u{110C}\u{116A}\u{11BF}", "\u{C8A4}", "\u{110C}\u{116A}\u{11BF}"),
    ("\u{C8A5}", "\u{C8A5}", "\u{110C}\u{116A}\u{11C0}", "\u{C8A5}", "\u{110C}\u{116A}\u{11C0}"),
    ("\u{C8A6}", "\u{C8A6}", "\u{110C}\u{116A}\u{11C1}", "\u{C8A6}", "\u{110C}\u{116A}\u{11C1}"),
    ("\u{C8A7}", "\u{C8A7}", "\u{110C}\u{116A}\u{11C2}", "\u{C8A7}", "\u{110C}\u{116A}\u{11C2}"),
    ("\u{C8A8}", "\u{C8A8}", "\u{110C}\u{116B}", "\u{C8A8}", "\u{110C}\u{116B}"),
    ("\u{C8A9}", "\u{C8A9}", "\u{110C}\u{116B}\u{11A8}", "\u{C8A9}", "\u{110C}\u{116B}\u{11A8}"),
    ("\u{C8AA}", "\u{C8AA}", "\u{110C}\u{116B}\u{11A9}", "\u{C8AA}", "\u{110C}\u{116B}\u{11A9}"),
    ("\u{C8AB}", "\u{C8AB}", "\u{110C}\u{116B}\u{11AA}", "\u{C8AB}", "\u{110C}\u{116B}\u{11AA}"),
    ("\u{C8AC}", "\u{C8AC}", "\u{110C}\u{116B}\u{11AB}", "\u{C8AC}", "\u{110C}\u{116B}\u{11AB}"),
    ("\u{C8AD}", "\u{C8AD}", "\u{110C}\u{116B}\u{11AC}", "\u{C8AD}", "\u{110C}\u{116B}\u{11AC}"),
    ("\u{C8AE}", "\u{C8AE}", "\u{110C}\u{116B}\u{11AD}", "\u{C8AE}", "\u{110C}\u{116B}\u{11AD}"),
    ("\u{C8AF}", "\u{C8AF}", "\u{110C}\u{116B}\u{11AE}", "\u{C8AF}", "\u{110C}\u{116B}\u{11AE}"),
    ("\u{C8B0}", "\u{C8B0}", "\u{110C}\u{116B}\u{11AF}", "\u{C8B0}", "\u{110C}\u{116B}\u{11AF}"),
    ("\u{C8B1}", "\u{C8B1}", "\u{110C}\u{116B}\u{11B0}", "\u{C8B1}", "\u{110C}\u{116B}\u{11B0}"),
    ("\u{C8B2}", "\u{C8B2}", "\u{110C}\u{116B}\u{11B1}", "\u{C8B2}", "\u{110C}\u{116B}\u{11B1}"),
    ("\u{C8B3}", "\u{C8B3}", "\u{110C}\u{116B}\u{11B2}", "\u{C8B3}", "\u{110C}\u{116B}\u{11B2}"),
    ("\u{C8B4}", "\u{C8B4}", "\u{110C}\u{116B}\u{11B3}", "\u{C8B4}", "\u{110C}\u{116B}\u{11B3}"),
    ("\u{C8B5}", "\u{C8B5}", "\u{110C}\u{116B}\u{11B4}", "\u{C8B5}", "\u{110C}\u{116B}\u{11B4}"),
    ("\u{C8B6}", "\u{C8B6}", "\u{110C}\u{116B}\u{11B5}", "\u{C8B6}", "\u{110C}\u{116B}\u{11B5}"),
    ("\u{C8B7}", "\u{C8B7}", "\u{110C}\u{116B}\u{11B6}", "\u{C8B7}", "\u{110C}\u{116B}\u{11B6}"),
    ("\u{C8B8}", "\u{C8B8}", "\u{110C}\u{116B}\u{11B7}", "\u{C8B8}", "\u{110C}\u{116B}\u{11B7}"),
    ("\u{C8B9}", "\u{C8B9}", "\u{110C}\u{116B}\u{11B8}", "\u{C8B9}", "\u{110C}\u{116B}\u{11B8}"),
    ("\u{C8BA}", "\u{C8BA}", "\u{110C}\u{116B}\u{11B9}", "\u{C8BA}", "\u{110C}\u{116B}\u{11B9}"),
    ("\u{C8BB}", "\u{C8BB}", "\u{110C}\u{116B}\u{11BA}", "\u{C8BB}", "\u{110C}\u{116B}\u{11BA}"),
    ("\u{C8BC}", "\u{C8BC}", "\u{110C}\u{116B}\u{11BB}", "\u{C8BC}", "\u{110C}\u{116B}\u{11BB}"),
    ("\u{C8BD}", "\u{C8BD}", "\u{110C}\u{116B}\u{11BC}", "\u{C8BD}", "\u{110C}\u{116B}\u{11BC}"),
    ("\u{C8BE}", "\u{C8BE}", "\u{110C}\u{116B}\u{11BD}", "\u{C8BE}", "\u{110C}\u{116B}\u{11BD}"),
    ("\u{C8BF}", "\u{C8BF}", "\u{110C}\u{116B}\u{11BE}", "\u{C8BF}", "\u{110C}\u{116B}\u{11BE}"),
    ("\u{C8C0}", "\u{C8C0}", "\u{110C}\u{116B}\u{11BF}", "\u{C8C0}", "\u{110C}\u{116B}\u{11BF}"),
    ("\u{C8C1}", "\u{C8C1}", "\u{110C}\u{116B}\u{11C0}", "\u{C8C1}", "\u{110C}\u{116B}\u{11C0}"),
    ("\u{C8C2}", "\u{C8C2}", "\u{110C}\u{116B}\u{11C1}", "\u{C8C2}", "\u{110C}\u{116B}\u{11C1}"),
    ("\u{C8C3}", "\u{C8C3}", "\u{110C}\u{116B}\u{11C2}", "\u{C8C3}", "\u{110C}\u{116B}\u{11C2}"),
    ("\u{C8C4}", "\u{C8C4}", "\u{110C}\u{116C}", "\u{C8C4}", "\u{110C}\u{116C}"),
    ("\u{C8C5}", "\u{C8C5}", "\u{110C}\u{116C}\u{11A8}", "\u{C8C5}", "\u{110C}\u{116C}\u{11A8}"),
    ("\u{C8C6}", "\u{C8C6}", "\u{110C}\u{116C}\u{11A9}", "\u{C8C6}", "\u{110C}\u{116C}\u{11A9}"),
    ("\u{C8C7}", "\u{C8C7}", "\u{110C}\u{116C}\u{11AA}", "\u{C8C7}", "\u{110C}\u{116C}\u{11AA}"),
    ("\u{C8C8}", "\u{C8C8}", "\u{110C}\u{116C}\u{11AB}", "\u{C8C8}", "\u{110C}\u{116C}\u{11AB}"),
    ("\u{C8C9}", "\u{C8C9}", "\u{110C}\u{116C}\u{11AC}", "\u{C8C9}", "\u{110C}\u{116C}\u{11AC}"),
    ("\u{C8CA}", "\u{C8CA}", "\u{110C}\u{116C}\u{11AD}", "\u{C8CA}", "\u{110C}\u{116C}\u{11AD}"),
    ("\u{C8CB}", "\u{C8CB}", "\u{110C}\u{116C}\u{11AE}", "\u{C8CB}", "\u{110C}\u{116C}\u{11AE}"),
    ("\u{C8CC}", "\u{C8CC}", "\u{110C}\u{116C}\u{11AF}", "\u{C8CC}", "\u{110C}\u{116C}\u{11AF}"),
    ("\u{C8CD}", "\u{C8CD}", "\u{110C}\u{116C}\u{11B0}", "\u{C8CD}", "\u{110C}\u{116C}\u{11B0}"),
    ("\u{C8CE}", "\u{C8CE}", "\u{110C}\u{116C}\u{11B1}", "\u{C8CE}", "\u{110C}\u{116C}\u{11B1}"),
    ("\u{C8CF}", "\u{C8CF}", "\u{110C}\u{116C}\u{11B2}", "\u{C8CF}", "\u{110C}\u{116C}\u{11B2}"),
    ("\u{C8D0}", "\u{C8D0}", "\u{110C}\u{116C}\u{11B3}", "\u{C8D0}", "\u{110C}\u{116C}\u{11B3}"),
    ("\u{C8D1}", "\u{C8D1}", "\u{110C}\u{116C}\u{11B4}", "\u{C8D1}", "\u{110C}\u{116C}\u{11B4}"),
    ("\u{C8D2}", "\u{C8D2}", "\u{110C}\u{116C}\u{11B5}", "\u{C8D2}", "\u{110C}\u{116C}\u{11B5}"),
    ("\u{C8D3}", "\u{C8D3}", "\u{110C}\u{116C}\u{11B6}", "\u{C8D3}", "\u{110C}\u{116C}\u{11B6}"),
    ("\u{C8D4}", "\u{C8D4}", "\u{110C}\u{116C}\u{11B7}", "\u{C8D4}", "\u{110C}\u{116C}\u{11B7}"),
    ("\u{C8D5}", "\u{C8D5}", "\u{110C}\u{116C}\u{11B8}", "\u{C8D5}", "\u{110C}\u{116C}\u{11B8}"),
    ("\u{C8D6}", "\u{C8D6}", "\u{110C}\u{116C}\u{11B9}", "\u{C8D6}", "\u{110C}\u{116C}\u{11B9}"),
    ("\u{C8D7}", "\u{C8D7}", "\u{110C}\u{116C}\u{11BA}", "\u{C8D7}", "\u{110C}\u{116C}\u{11BA}"),
    ("\u{C8D8}", "\u{C8D8}", "\u{110C}\u{116C}\u{11BB}", "\u{C8D8}", "\u{110C}\u{116C}\u{11BB}"),
    ("\u{C8D9}", "\u{C8D9}", "\u{110C}\u{116C}\u{11BC}", "\u{C8D9}", "\u{110C}\u{116C}\u{11BC}"),
    ("\u{C8DA}", "\u{C8DA}", "\u{110C}\u{116C}\u{11BD}", "\u{C8DA}", "\u{110C}\u{116C}\u{11BD}"),
    ("\u{C8DB}", "\u{C8DB}", "\u{110C}\u{116C}\u{11BE}", "\u{C8DB}", "\u{110C}\u{116C}\u{11BE}"),
    ("\u{C8DC}", "\u{C8DC}", "\u{110C}\u{116C}\u{11BF}", "\u{C8DC}", "\u{110C}\u{116C}\u{11BF}"),
    ("\u{C8DD}", "\u{C8DD}", "\u{110C}\u{116C}\u{11C0}", "\u{C8DD}", "\u{110C}\u{116C}\u{11C0}"),
    ("\u{C8DE}", "\u{C8DE}", "\u{110C}\u{116C}\u{11C1}", "\u{C8DE}", "\u{110C}\u{116C}\u{11C1}"),
    ("\u{C8DF}", "\u{C8DF}", "\u{110C}\u{116C}\u{11C2}", "\u{C8DF}", "\u{110C}\u{116C}\u{11C2}"),
    ("\u{C8E0}", "\u{C8E0}", "\u{110C}\u{116D}", "\u{C8E0}", "\u{110C}\u{116D}"),
    ("\u{C8E1}", "\u{C8E1}", "\u{110C}\u{116D}\u{11A8}", "\u{C8E1}", "\u{110C}\u{116D}\u{11A8}"),
    ("\u{C8E2}", "\u{C8E2}", "\u{110C}\u{116D}\u{11A9}", "\u{C8E2}", "\u{110C}\u{116D}\u{11A9}"),
    ("\u{C8E3}", "\u{C8E3}", "\u{110C}\u{116D}\u{11AA}", "\u{C8E3}", "\u{110C}\u{116D}\u{11AA}"),
    ("\u{C8E4}", "\u{C8E4}", "\u{110C}\u{116D}\u{11AB}", "\u{C8E4}", "\u{110C}\u{116D}\u{11AB}"),
    ("\u{C8E5}", "\u{C8E5}", "\u{110C}\u{116D}\u{11AC}", "\u{C8E5}", "\u{110C}\u{116D}\u{11AC}"),
    ("\u{C8E6}", "\u{C8E6}", "\u{110C}\u{116D}\u{11AD}", "\u{C8E6}", "\u{110C}\u{116D}\u{11AD}"),
    ("\u{C8E7}", "\u{C8E7}", "\u{110C}\u{116D}\u{11AE}", "\u{C8E7}", "\u{110C}\u{116D}\u{11AE}"),
    ("\u{C8E8}", "\u{C8E8}", "\u{110C}\u{116D}\u{11AF}", "\u{C8E8}", "\u{110C}\u{116D}\u{11AF}"),
    ("\u{C8E9}", "\u{C8E9}", "\u{110C}\u{116D}\u{11B0}", "\u{C8E9}", "\u{110C}\u{116D}\u{11B0}"),
    ("\u{C8EA}", "\u{C8EA}", "\u{110C}\u{116D}\u{11B1}", "\u{C8EA}", "\u{110C}\u{116D}\u{11B1}"),
    ("\u{C8EB}", "\u{C8EB}", "\u{110C}\u{116D}\u{11B2}", "\u{C8EB}", "\u{110C}\u{116D}\u{11B2}"),
    ("\u{C8EC}", "\u{C8EC}", "\u{110C}\u{116D}\u{11B3}", "\u{C8EC}", "\u{110C}\u{116D}\u{11B3}"),
    ("\u{C8ED}", "\u{C8ED}", "\u{110C}\u{116D}\u{11B4}", "\u{C8ED}", "\u{110C}\u{116D}\u{11B4}"),
    ("\u{C8EE}", "\u{C8EE}", "\u{110C}\u{116D}\u{11B5}", "\u{C8EE}", "\u{110C}\u{116D}\u{11B5}"),
    ("\u{C8EF}", "\u{C8EF}", "\u{110C}\u{116D}\u{11B6}", "\u{C8EF}", "\u{110C}\u{116D}\u{11B6}"),
    ("\u{C8F0}", "\u{C8F0}", "\u{110C}\u{116D}\u{11B7}", "\u{C8F0}", "\u{110C}\u{116D}\u{11B7}"),
    ("\u{C8F1}", "\u{C8F1}", "\u{110C}\u{116D}\u{11B8}", "\u{C8F1}", "\u{110C}\u{116D}\u{11B8}"),
    ("\u{C8F2}", "\u{C8F2}", "\u{110C}\u{116D}\u{11B9}", "\u{C8F2}", "\u{110C}\u{116D}\u{11B9}"),
    ("\u{C8F3}", "\u{C8F3}", "\u{110C}\u{116D}\u{11BA}", "\u{C8F3}", "\u{110C}\u{116D}\u{11BA}"),
    ("\u{C8F4}", "\u{C8F4}", "\u{110C}\u{116D}\u{11BB}", "\u{C8F4}", "\u{110C}\u{116D}\u{11BB}"),
    ("\u{C8F5}", "\u{C8F5}", "\u{110C}\u{116D}\u{11BC}", "\u{C8F5}", "\u{110C}\u{116D}\u{11BC}"),
    ("\u{C8F6}", "\u{C8F6}", "\u{110C}\u{116D}\u{11BD}", "\u{C8F6}", "\u{110C}\u{116D}\u{11BD}"),
    ("\u{C8F7}", "\u{C8F7}", "\u{110C}\u{116D}\u{11BE}", "\u{C8F7}", "\u{110C}\u{116D}\u{11BE}"),
    ("\u{C8F8}", "\u{C8F8}", "\u{110C}\u{116D}\u{11BF}", "\u{C8F8}", "\u{110C}\u{116D}\u{11BF}"),
    ("\u{C8F9}", "\u{C8F9}", "\u{110C}\u{116D}\u{11C0}", "\u{C8F9}", "\u{110C}\u{116D}\u{11C0}"),
    ("\u{C8FA}", "\u{C8FA}", "\u{110C}\u{116D}\u{11C1}", "\u{C8FA}", "\u{110C}\u{116D}\u{11C1}"),
    ("\u{C8FB}", "\u{C8FB}", "\u{110C}\u{116D}\u{11C2}", "\u{C8FB}", "\u{110C}\u{116D}\u{11C2}"),
    ("\u{C8FC}", "\u{C8FC}", "\u{110C}\u{116E}", "\u{C8FC}", "\u{110C}\u{116E}"),
    ("\u{C8FD}", "\u{C8FD}", "\u{110C}\u{116E}\u{11A8}", "\u{C8FD}", "\u{110C}\u{116E}\u{11A8}"),
    ("\u{C8FE}", "\u{C8FE}", "\u{110C}\u{116E}\u{11A9}", "\u{C8FE}", "\u{110C}\u{116E}\u{11A9}"),
    ("\u{C8FF}", "\u{C8FF}", "\u{110C}\u{116E}\u{11AA}", "\u{C8FF}", "\u{110C}\u{116E}\u{11AA}"),
    ("\u{C900}", "\u{C900}", "\u{110C}\u{116E}\u{11AB}", "\u{C900}", "\u{110C}\u{116E}\u{11AB}"),
    ("\u{C901}", "\u{C901}", "\u{110C}\u{116E}\u{11AC}", "\u{C901}", "\u{110C}\u{116E}\u{11AC}"),
    ("\u{C902}", "\u{C902}", "\u{110C}\u{116E}\u{11AD}", "\u{C902}", "\u{110C}\u{116E}\u{11AD}"),
    ("\u{C903}", "\u{C903}", "\u{110C}\u{116E}\u{11AE}", "\u{C903}", "\u{110C}\u{116E}\u{11AE}"),
    ("\u{C904}", "\u{C904}", "\u{110C}\u{116E}\u{11AF}", "\u{C904}", "\u{110C}\u{116E}\u{11AF}"),
    ("\u{C905}", "\u{C905}", "\u{110C}\u{116E}\u{11B0}", "\u{C905}", "\u{110C}\u{116E}\u{11B0}"),
    ("\u{C906}", "\u{C906}", "\u{110C}\u{116E}\u{11B1}", "\u{C906}", "\u{110C}\u{116E}\u{11B1}"),
    ("\u{C907}", "\u{C907}", "\u{110C}\u{116E}\u{11B2}", "\u{C907}", "\u{110C}\u{116E}\u{11B2}"),
    ("\u{C908}", "\u{C908}", "\u{110C}\u{116E}\u{11B3}", "\u{C908}", "\u{110C}\u{116E}\u{11B3}"),
    ("\u{C909}", "\u{C909}", "\u{110C}\u{116E}\u{11B4}", "\u{C909}", "\u{110C}\u{116E}\u{11B4}"),
    ("\u{C90A}", "\u{C90A}", "\u{110C}\u{116E}\u{11B5}", "\u{C90A}", "\u{110C}\u{116E}\u{11B5}"),
    ("\u{C90B}", "\u{C90B}", "\u{110C}\u{116E}\u{11B6}", "\u{C90B}", "\u{110C}\u{116E}\u{11B6}"),
    ("\u{C90C}", "\u{C90C}", "\u{110C}\u{116E}\u{11B7}", "\u{C90C}", "\u{110C}\u{116E}\u{11B7}"),
    ("\u{C90D}", "\u{C90D}", "\u{110C}\u{116E}\u{11B8}", "\u{C90D}", "\u{110C}\u{116E}\u{11B8}"),
    ("\u{C90E}", "\u{C90E}", "\u{110C}\u{116E}\u{11B9}", "\u{C90E}", "\u{110C}\u{116E}\u{11B9}"),
    ("\u{C90F}", "\u{C90F}", "\u{110C}\u{116E}\u{11BA}", "\u{C90F}", "\u{110C}\u{116E}\u{11BA}"),
    ("\u{C910}", "\u{C910}", "\u{110C}\u{116E}\u{11BB}", "\u{C910}", "\u{110C}\u{116E}\u{11BB}"),
    ("\u{C911}", "\u{C911}", "\u{110C}\u{116E}\u{11BC}", "\u{C911}", "\u{110C}\u{116E}\u{11BC}"),
    ("\u{C912}", "\u{C912}", "\u{110C}\u{116E}\u{11BD}", "\u{C912}", "\u{110C}\u{116E}\u{11BD}"),
    ("\u{C913}", "\u{C913}", "\u{110C}\u{116E}\u{11BE}", "\u{C913}", "\u{110C}\u{116E}\u{11BE}"),
    ("\u{C914}", "\u{C914}", "\u{110C}\u{116E}\u{11BF}", "\u{C914}", "\u{110C}\u{116E}\u{11BF}"),
    ("\u{C915}", "\u{C915}", "\u{110C}\u{116E}\u{11C0}", "\u{C915}", "\u{110C}\u{116E}\u{11C0}"),
    ("\u{C916}", "\u{C916}", "\u{110C}\u{116E}\u{11C1}", "\u{C916}", "\u{110C}\u{116E}\u{11C1}"),
    ("\u{C917}", "\u{C917}", "\u{110C}\u{116E}\u{11C2}", "\u{C917}", "\u{110C}\u{116E}\u{11C2}"),
    ("\u{C918}", "\u{C918}", "\u{110C}\u{116F}", "\u{C918}", "\u{110C}\u{116F}"),
    ("\u{C919}", "\u{C919}", "\u{110C}\u{116F}\u{11A8}", "\u{C919}", "\u{110C}\u{116F}\u{11A8}"),
    ("\u{C91A}", "\u{C91A}", "\u{110C}\u{116F}\u{11A9}", "\u{C91A}", "\u{110C}\u{116F}\u{11A9}"),
    ("\u{C91B}", "\u{C91B}", "\u{110C}\u{116F}\u{11AA}", "\u{C91B}", "\u{110C}\u{116F}\u{11AA}"),
    ("\u{C91C}", "\u{C91C}", "\u{110C}\u{116F}\u{11AB}", "\u{C91C}", "\u{110C}\u{116F}\u{11AB}"),
    ("\u{C91D}", "\u{C91D}", "\u{110C}\u{116F}\u{11AC}", "\u{C91D}", "\u{110C}\u{116F}\u{11AC}"),
    ("\u{C91E}", "\u{C91E}", "\u{110C}\u{116F}\u{11AD}", "\u{C91E}", "\u{110C}\u{116F}\u{11AD}"),
    ("\u{C91F}", "\u{C91F}", "\u{110C}\u{116F}\u{11AE}", "\u{C91F}", "\u{110C}\u{116F}\u{11AE}"),
    ("\u{C920}", "\u{C920}", "\u{110C}\u{116F}\u{11AF}", "\u{C920}", "\u{110C}\u{116F}\u{11AF}"),
    ("\u{C921}", "\u{C921}", "\u{110C}\u{116F}\u{11B0}", "\u{C921}", "\u{110C}\u{116F}\u{11B0}"),
    ("\u{C922}", "\u{C922}", "\u{110C}\u{116F}\u{11B1}", "\u{C922}", "\u{110C}\u{116F}\u{11B1}"),
    ("\u{C923}", "\u{C923}", "\u{110C}\u{116F}\u{11B2}", "\u{C923}", "\u{110C}\u{116F}\u{11B2}"),
    ("\u{C924}", "\u{C924}", "\u{110C}\u{116F}\u{11B3}", "\u{C924}", "\u{110C}\u{116F}\u{11B3}"),
    ("\u{C925}", "\u{C925}", "\u{110C}\u{116F}\u{11B4}", "\u{C925}", "\u{110C}\u{116F}\u{11B4}"),
    ("\u{C926}", "\u{C926}", "\u{110C}\u{116F}\u{11B5}", "\u{C926}", "\u{110C}\u{116F}\u{11B5}"),
    ("\u{C927}", "\u{C927}", "\u{110C}\u{116F}\u{11B6}", "\u{C927}", "\u{110C}\u{116F}\u{11B6}"),
    ("\u{C928}", "\u{C928}", "\u{110C}\u{116F}\u{11B7}", "\u{C928}", "\u{110C}\u{116F}\u{11B7}"),
    ("\u{C929}", "\u{C929}", "\u{110C}\u{116F}\u{11B8}", "\u{C929}", "\u{110C}\u{116F}\u{11B8}"),
    ("\u{C92A}", "\u{C92A}", "\u{110C}\u{116F}\u{11B9}", "\u{C92A}", "\u{110C}\u{116F}\u{11B9}"),
    ("\u{C92B}", "\u{C92B}", "\u{110C}\u{116F}\u{11BA}", "\u{C92B}", "\u{110C}\u{116F}\u{11BA}"),
    ("\u{C92C}", "\u{C92C}", "\u{110C}\u{116F}\u{11BB}", "\u{C92C}", "\u{110C}\u{116F}\u{11BB}"),
    ("\u{C92D}", "\u{C92D}", "\u{110C}\u{116F}\u{11BC}", "\u{C92D}", "\u{110C}\u{116F}\u{11BC}"),
    ("\u{C92E}", "\u{C92E}", "\u{110C}\u{116F}\u{11BD}", "\u{C92E}", "\u{110C}\u{116F}\u{11BD}"),
    ("\u{C92F}", "\u{C92F}", "\u{110C}\u{116F}\u{11BE}", "\u{C92F}", "\u{110C}\u{116F}\u{11BE}"),
    ("\u{C930}", "\u{C930}", "\u{110C}\u{116F}\u{11BF}", "\u{C930}", "\u{110C}\u{116F}\u{11BF}"),
    ("\u{C931}", "\u{C931}", "\u{110C}\u{116F}\u{11C0}", "\u{C931}", "\u{110C}\u{116F}\u{11C0}"),
    ("\u{C932}", "\u{C932}", "\u{110C}\u{116F}\u{11C1}", "\u{C932}", "\u{110C}\u{116F}\u{11C1}"),
    ("\u{C933}", "\u{C933}", "\u{110C}\u{116F}\u{11C2}", "\u{C933}", "\u{110C}\u{116F}\u{11C2}"),
    ("\u{C934}", "\u{C934}", "\u{110C}\u{1170}", "\u{C934}", "\u{110C}\u{1170}"),
    ("\u{C935}", "\u{C935}", "\u{110C}\u{1170}\u{11A8}", "\u{C935}", "\u{110C}\u{1170}\u{11A8}"),
    ("\u{C936}", "\u{C936}", "\u{110C}\u{1170}\u{11A9}", "\u{C936}", "\u{110C}\u{1170}\u{11A9}"),
    ("\u{C937}", "\u{C937}", "\u{110C}\u{1170}\u{11AA}", "\u{C937}", "\u{110C}\u{1170}\u{11AA}"),
    ("\u{C938}", "\u{C938}", "\u{110C}\u{1170}\u{11AB}", "\u{C938}", "\u{110C}\u{1170}\u{11AB}"),
    ("\u{C939}", "\u{C939}", "\u{110C}\u{1170}\u{11AC}", "\u{C939}", "\u{110C}\u{1170}\u{11AC}"),
    ("\u{C93A}", "\u{C93A}", "\u{110C}\u{1170}\u{11AD}", "\u{C93A}", "\u{110C}\u{1170}\u{11AD}"),
    ("\u{C93B}", "\u{C93B}", "\u{110C}\u{1170}\u{11AE}", "\u{C93B}", "\u{110C}\u{1170}\u{11AE}"),
    ("\u{C93C}", "\u{C93C}", "\u{110C}\u{1170}\u{11AF}", "\u{C93C}", "\u{110C}\u{1170}\u{11AF}"),
    ("\u{C93D}", "\u{C93D}", "\u{110C}\u{1170}\u{11B0}", "\u{C93D}", "\u{110C}\u{1170}\u{11B0}"),
    ("\u{C93E}", "\u{C93E}", "\u{110C}\u{1170}\u{11B1}", "\u{C93E}", "\u{110C}\u{1170}\u{11B1}"),
    ("\u{C93F}", "\u{C93F}", "\u{110C}\u{1170}\u{11B2}", "\u{C93F}", "\u{110C}\u{1170}\u{11B2}"),
    ("\u{C940}", "\u{C940}", "\u{110C}\u{1170}\u{11B3}", "\u{C940}", "\u{110C}\u{1170}\u{11B3}"),
    ("\u{C941}", "\u{C941}", "\u{110C}\u{1170}\u{11B4}", "\u{C941}", "\u{110C}\u{1170}\u{11B4}"),
    ("\u{C942}", "\u{C942}", "\u{110C}\u{1170}\u{11B5}", "\u{C942}", "\u{110C}\u{1170}\u{11B5}"),
    ("\u{C943}", "\u{C943}", "\u{110C}\u{1170}\u{11B6}", "\u{C943}", "\u{110C}\u{1170}\u{11B6}"),
    ("\u{C944}", "\u{C944}", "\u{110C}\u{1170}\u{11B7}", "\u{C944}", "\u{110C}\u{1170}\u{11B7}"),
    ("\u{C945}", "\u{C945}", "\u{110C}\u{1170}\u{11B8}", "\u{C945}", "\u{110C}\u{1170}\u{11B8}"),
    ("\u{C946}", "\u{C946}", "\u{110C}\u{1170}\u{11B9}", "\u{C946}", "\u{110C}\u{1170}\u{11B9}"),
    ("\u{C947}", "\u{C947}", "\u{110C}\u{1170}\u{11BA}", "\u{C947}", "\u{110C}\u{1170}\u{11BA}"),
    ("\u{C948}", "\u{C948}", "\u{110C}\u{1170}\u{11BB}", "\u{C948}", "\u{110C}\u{1170}\u{11BB}"),
    ("\u{C949}", "\u{C949}", "\u{110C}\u{1170}\u{11BC}", "\u{C949}", "\u{110C}\u{1170}\u{11BC}"),
    ("\u{C94A}", "\u{C94A}", "\u{110C}\u{1170}\u{11BD}", "\u{C94A}", "\u{110C}\u{1170}\u{11BD}"),
    ("\u{C94B}", "\u{C94B}", "\u{110C}\u{1170}\u{11BE}", "\u{C94B}", "\u{110C}\u{1170}\u{11BE}"),
    ("\u{C94C}", "\u{C94C}", "\u{110C}\u{1170}\u{11BF}", "\u{C94C}", "\u{110C}\u{1170}\u{11BF}"),
    ("\u{C94D}", "\u{C94D}", "\u{110C}\u{1170}\u{11C0}", "\u{C94D}", "\u{110C}\u{1170}\u{11C0}"),
    ("\u{C94E}", "\u{C94E}", "\u{110C}\u{1170}\u{11C1}", "\u{C94E}", "\u{110C}\u{1170}\u{11C1}"),
    ("\u{C94F}", "\u{C94F}", "\u{110C}\u{1170}\u{11C2}", "\u{C94F}", "\u{110C}\u{1170}\u{11C2}"),
    ("\u{C950}", "\u{C950}", "\u{110C}\u{1171}", "\u{C950}", "\u{110C}\u{1171}"),
    ("\u{C951}", "\u{C951}", "\u{110C}\u{1171}\u{11A8}", "\u{C951}", "\u{110C}\u{1171}\u{11A8}"),
    ("\u{C952}", "\u{C952}", "\u{110C}\u{1171}\u{11A9}", "\u{C952}", "\u{110C}\u{1171}\u{11A9}"),
    ("\u{C953}", "\u{C953}", "\u{110C}\u{1171}\u{11AA}", "\u{C953}", "\u{110C}\u{1171}\u{11AA}"),
    ("\u{C954}", "\u{C954}", "\u{110C}\u{1171}\u{11AB}", "\u{C954}", "\u{110C}\u{1171}\u{11AB}"),
    ("\u{C955}", "\u{C955}", "\u{110C}\u{1171}\u{11AC}", "\u{C955}", "\u{110C}\u{1171}\u{11AC}"),
    ("\u{C956}", "\u{C956}", "\u{110C}\u{1171}\u{11AD}", "\u{C956}", "\u{110C}\u{1171}\u{11AD}"),
    ("\u{C957}", "\u{C957}", "\u{110C}\u{1171}\u{11AE}", "\u{C957}", "\u{110C}\u{1171}\u{11AE}"),
    ("\u{C958}", "\u{C958}", "\u{110C}\u{1171}\u{11AF}", "\u{C958}", "\u{110C}\u{1171}\u{11AF}"),
    ("\u{C959}", "\u{C959}", "\u{110C}\u{1171}\u{11B0}", "\u{C959}", "\u{110C}\u{1171}\u{11B0}"),
    ("\u{C95A}", "\u{C95A}", "\u{110C}\u{1171}\u{11B1}", "\u{C95A}", "\u{110C}\u{1171}\u{11B1}"),
    ("\u{C95B}", "\u{C95B}", "\u{110C}\u{1171}\u{11B2}", "\u{C95B}", "\u{110C}\u{1171}\u{11B2}"),
    ("\u{C95C}", "\u{C95C}", "\u{110C}\u{1171}\u{11B3}", "\u{C95C}", "\u{110C}\u{1171}\u{11B3}"),
    ("\u{C95D}", "\u{C95D}", "\u{110C}\u{1171}\u{11B4}", "\u{C95D}", "\u{110C}\u{1171}\u{11B4}"),
    ("\u{C95E}", "\u{C95E}", "\u{110C}\u{1171}\u{11B5}", "\u{C95E}", "\u{110C}\u{1171}\u{11B5}"),
    ("\u{C95F}", "\u{C95F}", "\u{110C}\u{1171}\u{11B6}", "\u{C95F}", "\u{110C}\u{1171}\u{11B6}"),
    ("\u{C960}", "\u{C960}", "\u{110C}\u{1171}\u{11B7}", "\u{C960}", "\u{110C}\u{1171}\u{11B7}"),
    ("\u{C961}", "\u{C961}", "\u{110C}\u{1171}\u{11B8}", "\u{C961}", "\u{110C}\u{1171}\u{11B8}"),
    ("\u{C962}", "\u{C962}", "\u{110C}\u{1171}\u{11B9}", "\u{C962}", "\u{110C}\u{1171}\u{11B9}"),
    ("\u{C963}", "\u{C963}", "\u{110C}\u{1171}\u{11BA}", "\u{C963}", "\u{110C}\u{1171}\u{11BA}"),
    ("\u{C964}", "\u{C964}", "\u{110C}\u{1171}\u{11BB}", "\u{C964}", "\u{110C}\u{1171}\u{11BB}"),
    ("\u{C965}", "\u{C965}", "\u{110C}\u{1171}\u{11BC}", "\u{C965}", "\u{110C}\u{1171}\u{11BC}"),
    ("\u{C966}", "\u{C966}", "\u{110C}\u{1171}\u{11BD}", "\u{C966}", "\u{110C}\u{1171}\u{11BD}"),
    ("\u{C967}", "\u{C967}", "\u{110C}\u{1171}\u{11BE}", "\u{C967}", "\u{110C}\u{1171}\u{11BE}"),
    ("\u{C968}", "\u{C968}", "\u{110C}\u{1171}\u{11BF}", "\u{C968}", "\u{110C}\u{1171}\u{11BF}"),
    ("\u{C969}", "\u{C969}", "\u{110C}\u{1171}\u{11C0}", "\u{C969}", "\u{110C}\u{1171}\u{11C0}"),
    ("\u{C96A}", "\u{C96A}", "\u{110C}\u{1171}\u{11C1}", "\u{C96A}", "\u{110C}\u{1171}\u{11C1}"),
    ("\u{C96B}", "\u{C96B}", "\u{110C}\u{1171}\u{11C2}", "\u{C96B}", "\u{110C}\u{1171}\u{11C2}"),
    ("\u{C96C}", "\u{C96C}", "\u{110C}\u{1172}", "\u{C96C}", "\u{110C}\u{1172}"),
    ("\u{C96D}", "\u{C96D}", "\u{110C}\u{1172}\u{11A8}", "\u{C96D}", "\u{110C}\u{1172}\u{11A8}"),
    ("\u{C96E}", "\u{C96E}", "\u{110C}\u{1172}\u{11A9}", "\u{C96E}", "\u{110C}\u{1172}\u{11A9}"),
    ("\u{C96F}", "\u{C96F}", "\u{110C}\u{1172}\u{11AA}", "\u{C96F}", "\u{110C}\u{1172}\u{11AA}"),
    ("\u{C970}", "\u{C970}", "\u{110C}\u{1172}\u{11AB}", "\u{C970}", "\u{110C}\u{1172}\u{11AB}"),
    ("\u{C971}", "\u{C971}", "\u{110C}\u{1172}\u{11AC}", "\u{C971}", "\u{110C}\u{1172}\u{11AC}"),
    ("\u{C972}", "\u{C972}", "\u{110C}\u{1172}\u{11AD}", "\u{C972}", "\u{110C}\u{1172}\u{11AD}"),
    ("\u{C973}", "\u{C973}", "\u{110C}\u{1172}\u{11AE}", "\u{C973}", "\u{110C}\u{1172}\u{11AE}"),
    ("\u{C974}", "\u{C974}", "\u{110C}\u{1172}\u{11AF}", "\u{C974}", "\u{110C}\u{1172}\u{11AF}"),
    ("\u{C975}", "\u{C975}", "\u{110C}\u{1172}\u{11B0}", "\u{C975}", "\u{110C}\u{1172}\u{11B0}"),
    ("\u{C976}", "\u{C976}", "\u{110C}\u{1172}\u{11B1}", "\u{C976}", "\u{110C}\u{1172}\u{11B1}"),
    ("\u{C977}", "\u{C977}", "\u{110C}\u{1172}\u{11B2}", "\u{C977}", "\u{110C}\u{1172}\u{11B2}"),
    ("\u{C978}", "\u{C978}", "\u{110C}\u{1172}\u{11B3}", "\u{C978}", "\u{110C}\u{1172}\u{11B3}"),
    ("\u{C979}", "\u{C979}", "\u{110C}\u{1172}\u{11B4}", "\u{C979}", "\u{110C}\u{1172}\u{11B4}"),
    ("\u{C97A}", "\u{C97A}", "\u{110C}\u{1172}\u{11B5}", "\u{C97A}", "\u{110C}\u{1172}\u{11B5}"),
    ("\u{C97B}", "\u{C97B}", "\u{110C}\u{1172}\u{11B6}", "\u{C97B}", "\u{110C}\u{1172}\u{11B6}"),
    ("\u{C97C}", "\u{C97C}", "\u{110C}\u{1172}\u{11B7}", "\u{C97C}", "\u{110C}\u{1172}\u{11B7}"),
    ("\u{C97D}", "\u{C97D}", "\u{110C}\u{1172}\u{11B8}", "\u{C97D}", "\u{110C}\u{1172}\u{11B8}"),
    ("\u{C97E}", "\u{C97E}", "\u{110C}\u{1172}\u{11B9}", "\u{C97E}", "\u{110C}\u{1172}\u{11B9}"),
    ("\u{C97F}", "\u{C97F}", "\u{110C}\u{1172}\u{11BA}", "\u{C97F}", "\u{110C}\u{1172}\u{11BA}"),
    ("\u{C980}", "\u{C980}", "\u{110C}\u{1172}\u{11BB}", "\u{C980}", "\u{110C}\u{1172}\u{11BB}"),
    ("\u{C981}", "\u{C981}", "\u{110C}\u{1172}\u{11BC}", "\u{C981}", "\u{110C}\u{1172}\u{11BC}"),
    ("\u{C982}", "\u{C982}", "\u{110C}\u{1172}\u{11BD}", "\u{C982}", "\u{110C}\u{1172}\u{11BD}"),
    ("\u{C983}", "\u{C983}", "\u{110C}\u{1172}\u{11BE}", "\u{C983}", "\u{110C}\u{1172}\u{11BE}"),
    ("\u{C984}", "\u{C984}", "\u{110C}\u{1172}\u{11BF}", "\u{C984}", "\u{110C}\u{1172}\u{11BF}"),
    ("\u{C985}", "\u{C985}", "\u{110C}\u{1172}\u{11C0}", "\u{C985}", "\u{110C}\u{1172}\u{11C0}"),
    ("\u{C986}", "\u{C986}", "\u{110C}\u{1172}\u{11C1}", "\u{C986}", "\u{110C}\u{1172}\u{11C1}"),
    ("\u{C987}", "\u{C987}", "\u{110C}\u{1172}\u{11C2}", "\u{C987}", "\u{110C}\u{1172}\u{11C2}"),
    ("\u{C988}", "\u{C988}", "\u{110C}\u{1173}", "\u{C988}", "\u{110C}\u{1173}"),
    ("\u{C989}", "\u{C989}", "\u{110C}\u{1173}\u{11A8}", "\u{C989}", "\u{110C}\u{1173}\u{11A8}"),
    ("\u{C98A}", "\u{C98A}", "\u{110C}\u{1173}\u{11A9}", "\u{C98A}", "\u{110C}\u{1173}\u{11A9}"),
    ("\u{C98B}", "\u{C98B}", "\u{110C}\u{1173}\u{11AA}", "\u{C98B}", "\u{110C}\u{1173}\u{11AA}"),
    ("\u{C98C}", "\u{C98C}", "\u{110C}\u{1173}\u{11AB}", "\u{C98C}", "\u{110C}\u{1173}\u{11AB}"),
    ("\u{C98D}", "\u{C98D}", "\u{110C}\u{1173}\u{11AC}", "\u{C98D}", "\u{110C}\u{1173}\u{11AC}"),
    ("\u{C98E}", "\u{C98E}", "\u{110C}\u{1173}\u{11AD}", "\u{C98E}", "\u{110C}\u{1173}\u{11AD}"),
    ("\u{C98F}", "\u{C98F}", "\u{110C}\u{1173}\u{11AE}", "\u{C98F}", "\u{110C}\u{1173}\u{11AE}"),
    ("\u{C990}", "\u{C990}", "\u{110C}\u{1173}\u{11AF}", "\u{C990}", "\u{110C}\u{1173}\u{11AF}"),
    ("\u{C991}", "\u{C991}", "\u{110C}\u{1173}\u{11B0}", "\u{C991}", "\u{110C}\u{1173}\u{11B0}"),
    ("\u{C992}", "\u{C992}", "\u{110C}\u{1173}\u{11B1}", "\u{C992}", "\u{110C}\u{1173}\u{11B1}"),
    ("\u{C993}", "\u{C993}", "\u{110C}\u{1173}\u{11B2}", "\u{C993}", "\u{110C}\u{1173}\u{11B2}"),
    ("\u{C994}", "\u{C994}", "\u{110C}\u{1173}\u{11B3}", "\u{C994}", "\u{110C}\u{1173}\u{11B3}"),
    ("\u{C995}", "\u{C995}", "\u{110C}\u{1173}\u{11B4}", "\u{C995}", "\u{110C}\u{1173}\u{11B4}"),
    ("\u{C996}", "\u{C996}", "\u{110C}\u{1173}\u{11B5}", "\u{C996}", "\u{110C}\u{1173}\u{11B5}"),
    ("\u{C997}", "\u{C997}", "\u{110C}\u{1173}\u{11B6}", "\u{C997}", "\u{110C}\u{1173}\u{11B6}"),
    ("\u{C998}", "\u{C998}", "\u{110C}\u{1173}\u{11B7}", "\u{C998}", "\u{110C}\u{1173}\u{11B7}"),
    ("\u{C999}", "\u{C999}", "\u{110C}\u{1173}\u{11B8}", "\u{C999}", "\u{110C}\u{1173}\u{11B8}"),
    ("\u{C99A}", "\u{C99A}", "\u{110C}\u{1173}\u{11B9}", "\u{C99A}", "\u{110C}\u{1173}\u{11B9}"),
    ("\u{C99B}", "\u{C99B}", "\u{110C}\u{1173}\u{11BA}", "\u{C99B}", "\u{110C}\u{1173}\u{11BA}"),
    ("\u{C99C}", "\u{C99C}", "\u{110C}\u{1173}\u{11BB}", "\u{C99C}", "\u{110C}\u{1173}\u{11BB}"),
    ("\u{C99D}", "\u{C99D}", "\u{110C}\u{1173}\u{11BC}", "\u{C99D}", "\u{110C}\u{1173}\u{11BC}"),
    ("\u{C99E}", "\u{C99E}", "\u{110C}\u{1173}\u{11BD}", "\u{C99E}", "\u{110C}\u{1173}\u{11BD}"),
    ("\u{C99F}", "\u{C99F}", "\u{110C}\u{1173}\u{11BE}", "\u{C99F}", "\u{110C}\u{1173}\u{11BE}"),
    ("\u{C9A0}", "\u{C9A0}", "\u{110C}\u{1173}\u{11BF}", "\u{C9A0}", "\u{110C}\u{1173}\u{11BF}"),
    ("\u{C9A1}", "\u{C9A1}", "\u{110C}\u{1173}\u{11C0}", "\u{C9A1}", "\u{110C}\u{1173}\u{11C0}"),
    ("\u{C9A2}", "\u{C9A2}", "\u{110C}\u{1173}\u{11C1}", "\u{C9A2}", "\u{110C}\u{1173}\u{11C1}"),
    ("\u{C9A3}", "\u{C9A3}", "\u{110C}\u{1173}\u{11C2}", "\u{C9A3}", "\u{110C}\u{1173}\u{11C2}"),
    ("\u{C9A4}", "\u{C9A4}", "\u{110C}\u{1174}", "\u{C9A4}", "\u{110C}\u{1174}"),
    ("\u{C9A5}", "\u{C9A5}", "\u{110C}\u{1174}\u{11A8}", "\u{C9A5}", "\u{110C}\u{1174}\u{11A8}"),
    ("\u{C9A6}", "\u{C9A6}", "\u{110C}\u{1174}\u{11A9}", "\u{C9A6}", "\u{110C}\u{1174}\u{11A9}"),
    ("\u{C9A7}", "\u{C9A7}", "\u{110C}\u{1174}\u{11AA}", "\u{C9A7}", "\u{110C}\u{1174}\u{11AA}"),
    ("\u{C9A8}", "\u{C9A8}", "\u{110C}\u{1174}\u{11AB}", "\u{C9A8}", "\u{110C}\u{1174}\u{11AB}"),
    ("\u{C9A9}", "\u{C9A9}", "\u{110C}\u{1174}\u{11AC}", "\u{C9A9}", "\u{110C}\u{1174}\u{11AC}"),
    ("\u{C9AA}", "\u{C9AA}", "\u{110C}\u{1174}\u{11AD}", "\u{C9AA}", "\u{110C}\u{1174}\u{11AD}"),
    ("\u{C9AB}", "\u{C9AB}", "\u{110C}\u{1174}\u{11AE}", "\u{C9AB}", "\u{110C}\u{1174}\u{11AE}"),
    ("\u{C9AC}", "\u{C9AC}", "\u{110C}\u{1174}\u{11AF}", "\u{C9AC}", "\u{110C}\u{1174}\u{11AF}"),
    ("\u{C9AD}", "\u{C9AD}", "\u{110C}\u{1174}\u{11B0}", "\u{C9AD}", "\u{110C}\u{1174}\u{11B0}"),
    ("\u{C9AE}", "\u{C9AE}", "\u{110C}\u{1174}\u{11B1}", "\u{C9AE}", "\u{110C}\u{1174}\u{11B1}"),
    ("\u{C9AF}", "\u{C9AF}", "\u{110C}\u{1174}\u{11B2}", "\u{C9AF}", "\u{110C}\u{1174}\u{11B2}"),
    ("\u{C9B0}", "\u{C9B0}", "\u{110C}\u{1174}\u{11B3}", "\u{C9B0}", "\u{110C}\u{1174}\u{11B3}"),
    ("\u{C9B1}", "\u{C9B1}", "\u{110C}\u{1174}\u{11B4}", "\u{C9B1}", "\u{110C}\u{1174}\u{11B4}"),
    ("\u{C9B2}", "\u{C9B2}", "\u{110C}\u{1174}\u{11B5}", "\u{C9B2}", "\u{110C}\u{1174}\u{11B5}"),
    ("\u{C9B3}", "\u{C9B3}", "\u{110C}\u{1174}\u{11B6}", "\u{C9B3}", "\u{110C}\u{1174}\u{11B6}"),
    ("\u{C9B4}", "\u{C9B4}", "\u{110C}\u{1174}\u{11B7}", "\u{C9B4}", "\u{110C}\u{1174}\u{11B7}"),
    ("\u{C9B5}", "\u{C9B5}", "\u{110C}\u{1174}\u{11B8}", "\u{C9B5}", "\u{110C}\u{1174}\u{11B8}"),
    ("\u{C9B6}", "\u{C9B6}", "\u{110C}\u{1174}\u{11B9}", "\u{C9B6}", "\u{110C}\u{1174}\u{11B9}"),
    ("\u{C9B7}", "\u{C9B7}", "\u{110C}\u{1174}\u{11BA}", "\u{C9B7}", "\u{110C}\u{1174}\u{11BA}"),
    ("\u{C9B8}", "\u{C9B8}", "\u{110C}\u{1174}\u{11BB}", "\u{C9B8}", "\u{110C}\u{1174}\u{11BB}"),
    ("\u{C9B9}", "\u{C9B9}", "\u{110C}\u{1174}\u{11BC}", "\u{C9B9}", "\u{110C}\u{1174}\u{11BC}"),
    ("\u{C9BA}", "\u{C9BA}", "\u{110C}\u{1174}\u{11BD}", "\u{C9BA}", "\u{110C}\u{1174}\u{11BD}"),
    ("\u{C9BB}", "\u{C9BB}", "\u{110C}\u{1174}\u{11BE}", "\u{C9BB}", "\u{110C}\u{1174}\u{11BE}"),
    ("\u{C9BC}", "\u{C9BC}", "\u{110C}\u{1174}\u{11BF}", "\u{C9BC}", "\u{110C}\u{1174}\u{11BF}"),
    ("\u{C9BD}", "\u{C9BD}", "\u{110C}\u{1174}\u{11C0}", "\u{C9BD}", "\u{110C}\u{1174}\u{11C0}"),
    ("\u{C9BE}", "\u{C9BE}", "\u{110C}\u{1174}\u{11C1}", "\u{C9BE}", "\u{110C}\u{1174}\u{11C1}"),
    ("\u{C9BF}", "\u{C9BF}", "\u{110C}\u{1174}\u{11C2}", "\u{C9BF}", "\u{110C}\u{1174}\u{11C2}"),
    ("\u{C9C0}", "\u{C9C0}", "\u{110C}\u{1175}", "\u{C9C0}", "\u{110C}\u{1175}"),
    ("\u{C9C1}", "\u{C9C1}", "\u{110C}\u{1175}\u{11A8}", "\u{C9C1}", "\u{110C}\u{1175}\u{11A8}"),
    ("\u{C9C2}", "\u{C9C2}", "\u{110C}\u{1175}\u{11A9}", "\u{C9C2}", "\u{110C}\u{1175}\u{11A9}"),
    ("\u{C9C3}", "\u{C9C3}", "\u{110C}\u{1175}\u{11AA}", "\u{C9C3}", "\u{110C}\u{1175}\u{11AA}"),
    ("\u{C9C4}", "\u{C9C4}", "\u{110C}\u{1175}\u{11AB}", "\u{C9C4}", "\u{110C}\u{1175}\u{11AB}"),
    ("\u{C9C5}", "\u{C9C5}", "\u{110C}\u{1175}\u{11AC}", "\u{C9C5}", "\u{110C}\u{1175}\u{11AC}"),
    ("\u{C9C6}", "\u{C9C6}", "\u{110C}\u{1175}\u{11AD}", "\u{C9C6}", "\u{110C}\u{1175}\u{11AD}"),
    ("\u{C9C7}", "\u{C9C7}", "\u{110C}\u{1175}\u{11AE}", "\u{C9C7}", "\u{110C}\u{1175}\u{11AE}"),
    ("\u{C9C8}", "\u{C9C8}", "\u{110C}\u{1175}\u{11AF}", "\u{C9C8}", "\u{110C}\u{1175}\u{11AF}"),
    ("\u{C9C9}", "\u{C9C9}", "\u{110C}\u{1175}\u{11B0}", "\u{C9C9}", "\u{110C}\u{1175}\u{11B0}"),
    ("\u{C9CA}", "\u{C9CA}", "\u{110C}\u{1175}\u{11B1}", "\u{C9CA}", "\u{110C}\u{1175}\u{11B1}"),
    ("\u{C9CB}", "\u{C9CB}", "\u{110C}\u{1175}\u{11B2}", "\u{C9CB}", "\u{110C}\u{1175}\u{11B2}"),
    ("\u{C9CC}", "\u{C9CC}", "\u{110C}\u{1175}\u{11B3}", "\u{C9CC}", "\u{110C}\u{1175}\u{11B3}"),
    ("\u{C9CD}", "\u{C9CD}", "\u{110C}\u{1175}\u{11B4}", "\u{C9CD}", "\u{110C}\u{1175}\u{11B4}"),
    ("\u{C9CE}", "\u{C9CE}", "\u{110C}\u{1175}\u{11B5}", "\u{C9CE}", "\u{110C}\u{1175}\u{11B5}"),
    ("\u{C9CF}", "\u{C9CF}", "\u{110C}\u{1175}\u{11B6}", "\u{C9CF}", "\u{110C}\u{1175}\u{11B6}"),
    ("\u{C9D0}", "\u{C9D0}", "\u{110C}\u{1175}\u{11B7}", "\u{C9D0}", "\u{110C}\u{1175}\u{11B7}"),
    ("\u{C9D1}", "\u{C9D1}", "\u{110C}\u{1175}\u{11B8}", "\u{C9D1}", "\u{110C}\u{1175}\u{11B8}"),
    ("\u{C9D2}", "\u{C9D2}", "\u{110C}\u{1175}\u{11B9}", "\u{C9D2}", "\u{110C}\u{1175}\u{11B9}"),
    ("\u{C9D3}", "\u{C9D3}", "\u{110C}\u{1175}\u{11BA}", "\u{C9D3}", "\u{110C}\u{1175}\u{11BA}"),
    ("\u{C9D4}", "\u{C9D4}", "\u{110C}\u{1175}\u{11BB}", "\u{C9D4}", "\u{110C}\u{1175}\u{11BB}"),
    ("\u{C9D5}", "\u{C9D5}", "\u{110C}\u{1175}\u{11BC}", "\u{C9D5}", "\u{110C}\u{1175}\u{11BC}"),
    ("\u{C9D6}", "\u{C9D6}", "\u{110C}\u{1175}\u{11BD}", "\u{C9D6}", "\u{110C}\u{1175}\u{11BD}"),
    ("\u{C9D7}", "\u{C9D7}", "\u{110C}\u{1175}\u{11BE}", "\u{C9D7}", "\u{110C}\u{1175}\u{11BE}"),
    ("\u{C9D8}", "\u{C9D8}", "\u{110C}\u{1175}\u{11BF}", "\u{C9D8}", "\u{110C}\u{1175}\u{11BF}"),
    ("\u{C9D9}", "\u{C9D9}", "\u{110C}\u{1175}\u{11C0}", "\u{C9D9}", "\u{110C}\u{1175}\u{11C0}"),
    ("\u{C9DA}", "\u{C9DA}", "\u{110C}\u{1175}\u{11C1}", "\u{C9DA}", "\u{110C}\u{1175}\u{11C1}"),
    ("\u{C9DB}", "\u{C9DB}", "\u{110C}\u{1175}\u{11C2}", "\u{C9DB}", "\u{110C}\u{1175}\u{11C2}"),
    ("\u{C9DC}", "\u{C9DC}", "\u{110D}\u{1161}", "\u{C9DC}", "\u{110D}\u{1161}"),
    ("\u{C9DD}", "\u{C9DD}", "\u{110D}\u{1161}\u{11A8}", "\u{C9DD}", "\u{110D}\u{1161}\u{11A8}"),
    ("\u{C9DE}", "\u{C9DE}", "\u{110D}\u{1161}\u{11A9}", "\u{C9DE}", "\u{110D}\u{1161}\u{11A9}"),
    ("\u{C9DF}", "\u{C9DF}", "\u{110D}\u{1161}\u{11AA}", "\u{C9DF}", "\u{110D}\u{1161}\u{11AA}"),
    ("\u{C9E0}", "\u{C9E0}", "\u{110D}\u{1161}\u{11AB}", "\u{C9E0}", "\u{110D}\u{1161}\u{11AB}"),
    ("\u{C9E1}", "\u{C9E1}", "\u{110D}\u{1161}\u{11AC}", "\u{C9E1}", "\u{110D}\u{1161}\u{11AC}"),
    ("\u{C9E2}", "\u{C9E2}", "\u{110D}\u{1161}\u{11AD}", "\u{C9E2}", "\u{110D}\u{1161}\u{11AD}"),
    ("\u{C9E3}", "\u{C9E3}", "\u{110D}\u{1161}\u{11AE}", "\u{C9E3}", "\u{110D}\u{1161}\u{11AE}"),
    ("\u{C9E4}", "\u{C9E4}", "\u{110D}\u{1161}\u{11AF}", "\u{C9E4}", "\u{110D}\u{1161}\u{11AF}"),
    ("\u{C9E5}", "\u{C9E5}", "\u{110D}\u{1161}\u{11B0}", "\u{C9E5}", "\u{110D}\u{1161}\u{11B0}"),
    ("\u{C9E6}", "\u{C9E6}", "\u{110D}\u{1161}\u{11B1}", "\u{C9E6}", "\u{110D}\u{1161}\u{11B1}"),
    ("\u{C9E7}", "\u{C9E7}", "\u{110D}\u{1161}\u{11B2}", "\u{C9E7}", "\u{110D}\u{1161}\u{11B2}"),
    ("\u{C9E8}", "\u{C9E8}", "\u{110D}\u{1161}\u{11B3}", "\u{C9E8}", "\u{110D}\u{1161}\u{11B3}"),
    ("\u{C9E9}", "\u{C9E9}", "\u{110D}\u{1161}\u{11B4}", "\u{C9E9}", "\u{110D}\u{1161}\u{11B4}"),
    ("\u{C9EA}", "\u{C9EA}", "\u{110D}\u{1161}\u{11B5}", "\u{C9EA}", "\u{110D}\u{1161}\u{11B5}"),
    ("\u{C9EB}", "\u{C9EB}", "\u{110D}\u{1161}\u{11B6}", "\u{C9EB}", "\u{110D}\u{1161}\u{11B6}"),
    ("\u{C9EC}", "\u{C9EC}", "\u{110D}\u{1161}\u{11B7}", "\u{C9EC}", "\u{110D}\u{1161}\u{11B7}"),
    ("\u{C9ED}", "\u{C9ED}", "\u{110D}\u{1161}\u{11B8}", "\u{C9ED}", "\u{110D}\u{1161}\u{11B8}"),
    ("\u{C9EE}", "\u{C9EE}", "\u{110D}\u{1161}\u{11B9}", "\u{C9EE}", "\u{110D}\u{1161}\u{11B9}"),
    ("\u{C9EF}", "\u{C9EF}", "\u{110D}\u{1161}\u{11BA}", "\u{C9EF}", "\u{110D}\u{1161}\u{11BA}"),
    ("\u{C9F0}", "\u{C9F0}", "\u{110D}\u{1161}\u{11BB}", "\u{C9F0}", "\u{110D}\u{1161}\u{11BB}"),
    ("\u{C9F1}", "\u{C9F1}", "\u{110D}\u{1161}\u{11BC}", "\u{C9F1}", "\u{110D}\u{1161}\u{11BC}"),
    ("\u{C9F2}", "\u{C9F2}", "\u{110D}\u{1161}\u{11BD}", "\u{C9F2}", "\u{110D}\u{1161}\u{11BD}"),
    ("\u{C9F3}", "\u{C9F3}", "\u{110D}\u{1161}\u{11BE}", "\u{C9F3}", "\u{110D}\u{1161}\u{11BE}"),
    ("\u{C9F4}", "\u{C9F4}", "\u{110D}\u{1161}\u{11BF}", "\u{C9F4}", "\u{110D}\u{1161}\u{11BF}"),
    ("\u{C9F5}", "\u{C9F5}", "\u{110D}\u{1161}\u{11C0}", "\u{C9F5}", "\u{110D}\u{1161}\u{11C0}"),
    ("\u{C9F6}", "\u{C9F6}", "\u{110D}\u{1161}\u{11C1}", "\u{C9F6}", "\u{110D}\u{1161}\u{11C1}"),
    ("\u{C9F7}", "\u{C9F7}", "\u{110D}\u{1161}\u{11C2}", "\u{C9F7}", "\u{110D}\u{1161}\u{11C2}"),
    ("\u{C9F8}", "\u{C9F8}", "\u{110D}\u{1162}", "\u{C9F8}", "\u{110D}\u{1162}"),
    ("\u{C9F9}", "\u{C9F9}", "\u{110D}\u{1162}\u{11A8}", "\u{C9F9}", "\u{110D}\u{1162}\u{11A8}"),
    ("\u{C9FA}", "\u{C9FA}", "\u{110D}\u{1162}\u{11A9}", "\u{C9FA}", "\u{110D}\u{1162}\u{11A9}"),
    ("\u{C9FB}", "\u{C9FB}", "\u{110D}\u{1162}\u{11AA}", "\u{C9FB}", "\u{110D}\u{1162}\u{11AA}"),
    ("\u{C9FC}", "\u{C9FC}", "\u{110D}\u{1162}\u{11AB}", "\u{C9FC}", "\u{110D}\u{1162}\u{11AB}"),
    ("\u{C9FD}", "\u{C9FD}", "\u{110D}\u{1162}\u{11AC}", "\u{C9FD}", "\u{110D}\u{1162}\u{11AC}"),
    ("\u{C9FE}", "\u{C9FE}", "\u{110D}\u{1162}\u{11AD}", "\u{C9FE}", "\u{110D}\u{1162}\u{11AD}"),
    ("\u{C9FF}", "\u{C9FF}", "\u{110D}\u{1162}\u{11AE}", "\u{C9FF}", "\u{110D}\u{1162}\u{11AE}"),
    ("\u{CA00}", "\u{CA00}", "\u{110D}\u{1162}\u{11AF}", "\u{CA00}", "\u{110D}\u{1162}\u{11AF}"),
    ("\u{CA01}", "\u{CA01}", "\u{110D}\u{1162}\u{11B0}", "\u{CA01}", "\u{110D}\u{1162}\u{11B0}"),
    ("\u{CA02}", "\u{CA02}", "\u{110D}\u{1162}\u{11B1}", "\u{CA02}", "\u{110D}\u{1162}\u{11B1}"),
    ("\u{CA03}", "\u{CA03}", "\u{110D}\u{1162}\u{11B2}", "\u{CA03}", "\u{110D}\u{1162}\u{11B2}"),
    ("\u{CA04}", "\u{CA04}", "\u{110D}\u{1162}\u{11B3}", "\u{CA04}", "\u{110D}\u{1162}\u{11B3}"),
    ("\u{CA05}", "\u{CA05}", "\u{110D}\u{1162}\u{11B4}", "\u{CA05}", "\u{110D}\u{1162}\u{11B4}"),
    ("\u{CA06}", "\u{CA06}", "\u{110D}\u{1162}\u{11B5}", "\u{CA06}", "\u{110D}\u{1162}\u{11B5}"),
    ("\u{CA07}", "\u{CA07}", "\u{110D}\u{1162}\u{11B6}", "\u{CA07}", "\u{110D}\u{1162}\u{11B6}"),
    ("\u{CA08}", "\u{CA08}", "\u{110D}\u{1162}\u{11B7}", "\u{CA08}", "\u{110D}\u{1162}\u{11B7}"),
    ("\u{CA09}", "\u{CA09}", "\u{110D}\u{1162}\u{11B8}", "\u{CA09}", "\u{110D}\u{1162}\u{11B8}"),
    ("\u{CA0A}", "\u{CA0A}", "\u{110D}\u{1162}\u{11B9}", "\u{CA0A}", "\u{110D}\u{1162}\u{11B9}"),
    ("\u{CA0B}", "\u{CA0B}", "\u{110D}\u{1162}\u{11BA}", "\u{CA0B}", "\u{110D}\u{1162}\u{11BA}"),
    ("\u{CA0C}", "\u{CA0C}", "\u{110D}\u{1162}\u{11BB}", "\u{CA0C}", "\u{110D}\u{1162}\u{11BB}"),
    ("\u{CA0D}", "\u{CA0D}", "\u{110D}\u{1162}\u{11BC}", "\u{CA0D}", "\u{110D}\u{1162}\u{11BC}"),
    ("\u{CA0E}", "\u{CA0E}", "\u{110D}\u{1162}\u{11BD}", "\u{CA0E}", "\u{110D}\u{1162}\u{11BD}"),
    ("\u{CA0F}", "\u{CA0F}", "\u{110D}\u{1162}\u{11BE}", "\u{CA0F}", "\u{110D}\u{1162}\u{11BE}"),
    ("\u{CA10}", "\u{CA10}", "\u{110D}\u{1162}\u{11BF}", "\u{CA10}", "\u{110D}\u{1162}\u{11BF}"),
    ("\u{CA11}", "\u{CA11}", "\u{110D}\u{1162}\u{11C0}", "\u{CA11}", "\u{110D}\u{1162}\u{11C0}"),
    ("\u{CA12}", "\u{CA12}", "\u{110D}\u{1162}\u{11C1}", "\u{CA12}", "\u{110D}\u{1162}\u{11C1}"),
    ("\u{CA13}", "\u{CA13}", "\u{110D}\u{1162}\u{11C2}", "\u{CA13}", "\u{110D}\u{1162}\u{11C2}"),
    ("\u{CA14}", "\u{CA14}", "\u{110D}\u{1163}", "\u{CA14}", "\u{110D}\u{1163}"),
    ("\u{CA15}", "\u{CA15}", "\u{110D}\u{1163}\u{11A8}", "\u{CA15}", "\u{110D}\u{1163}\u{11A8}"),
    ("\u{CA16}", "\u{CA16}", "\u{110D}\u{1163}\u{11A9}", "\u{CA16}", "\u{110D}\u{1163}\u{11A9}"),
    ("\u{CA17}", "\u{CA17}", "\u{110D}\u{1163}\u{11AA}", "\u{CA17}", "\u{110D}\u{1163}\u{11AA}"),
    ("\u{CA18}", "\u{CA18}", "\u{110D}\u{1163}\u{11AB}", "\u{CA18}", "\u{110D}\u{1163}\u{11AB}"),
    ("\u{CA19}", "\u{CA19}", "\u{110D}\u{1163}\u{11AC}", "\u{CA19}", "\u{110D}\u{1163}\u{11AC}"),
    ("\u{CA1A}", "\u{CA1A}", "\u{110D}\u{1163}\u{11AD}", "\u{CA1A}", "\u{110D}\u{1163}\u{11AD}"),
    ("\u{CA1B}", "\u{CA1B}", "\u{110D}\u{1163}\u{11AE}", "\u{CA1B}", "\u{110D}\u{1163}\u{11AE}"),
    ("\u{CA1C}", "\u{CA1C}", "\u{110D}\u{1163}\u{11AF}", "\u{CA1C}", "\u{110D}\u{1163}\u{11AF}"),
    ("\u{CA1D}", "\u{CA1D}", "\u{110D}\u{1163}\u{11B0}", "\u{CA1D}", "\u{110D}\u{1163}\u{11B0}"),
    ("\u{CA1E}", "\u{CA1E}", "\u{110D}\u{1163}\u{11B1}", "\u{CA1E}", "\u{110D}\u{1163}\u{11B1}"),
    ("\u{CA1F}", "\u{CA1F}", "\u{110D}\u{1163}\u{11B2}", "\u{CA1F}", "\u{110D}\u{1163}\u{11B2}"),
    ("\u{CA20}", "\u{CA20}", "\u{110D}\u{1163}\u{11B3}", "\u{CA20}", "\u{110D}\u{1163}\u{11B3}"),
    ("\u{CA21}", "\u{CA21}", "\u{110D}\u{1163}\u{11B4}", "\u{CA21}", "\u{110D}\u{1163}\u{11B4}"),
    ("\u{CA22}", "\u{CA22}", "\u{110D}\u{1163}\u{11B5}", "\u{CA22}", "\u{110D}\u{1163}\u{11B5}"),
    ("\u{CA23}", "\u{CA23}", "\u{110D}\u{1163}\u{11B6}", "\u{CA23}", "\u{110D}\u{1163}\u{11B6}"),
    ("\u{CA24}", "\u{CA24}", "\u{110D}\u{1163}\u{11B7}", "\u{CA24}", "\u{110D}\u{1163}\u{11B7}"),
    ("\u{CA25}", "\u{CA25}", "\u{110D}\u{1163}\u{11B8}", "\u{CA25}", "\u{110D}\u{1163}\u{11B8}"),
    ("\u{CA26}", "\u{CA26}", "\u{110D}\u{1163}\u{11B9}", "\u{CA26}", "\u{110D}\u{1163}\u{11B9}"),
    ("\u{CA27}", "\u{CA27}", "\u{110D}\u{1163}\u{11BA}", "\u{CA27}", "\u{110D}\u{1163}\u{11BA}"),
    ("\u{CA28}", "\u{CA28}", "\u{110D}\u{1163}\u{11BB}", "\u{CA28}", "\u{110D}\u{1163}\u{11BB}"),
    ("\u{CA29}", "\u{CA29}", "\u{110D}\u{1163}\u{11BC}", "\u{CA29}", "\u{110D}\u{1163}\u{11BC}"),
    ("\u{CA2A}", "\u{CA2A}", "\u{110D}\u{1163}\u{11BD}", "\u{CA2A}", "\u{110D}\u{1163}\u{11BD}"),
    ("\u{CA2B}", "\u{CA2B}", "\u{110D}\u{1163}\u{11BE}", "\u{CA2B}", "\u{110D}\u{1163}\u{11BE}"),
    ("\u{CA2C}", "\u{CA2C}", "\u{110D}\u{1163}\u{11BF}", "\u{CA2C}", "\u{110D}\u{1163}\u{11BF}"),
    ("\u{CA2D}", "\u{CA2D}", "\u{110D}\u{1163}\u{11C0}", "\u{CA2D}", "\u{110D}\u{1163}\u{11C0}"),
    ("\u{CA2E}", "\u{CA2E}", "\u{110D}\u{1163}\u{11C1}", "\u{CA2E}", "\u{110D}\u{1163}\u{11C1}"),
    ("\u{CA2F}", "\u{CA2F}", "\u{110D}\u{1163}\u{11C2}", "\u{CA2F}", "\u{110D}\u{1163}\u{11C2}"),
    ("\u{CA30}", "\u{CA30}", "\u{110D}\u{1164}", "\u{CA30}", "\u{110D}\u{1164}"),
    ("\u{CA31}", "\u{CA31}", "\u{110D}\u{1164}\u{11A8}", "\u{CA31}", "\u{110D}\u{1164}\u{11A8}"),
    ("\u{CA32}", "\u{CA32}", "\u{110D}\u{1164}\u{11A9}", "\u{CA32}", "\u{110D}\u{1164}\u{11A9}"),
    ("\u{CA33}", "\u{CA33}", "\u{110D}\u{1164}\u{11AA}", "\u{CA33}", "\u{110D}\u{1164}\u{11AA}"),
    ("\u{CA34}", "\u{CA34}", "\u{110D}\u{1164}\u{11AB}", "\u{CA34}", "\u{110D}\u{1164}\u{11AB}"),
    ("\u{CA35}", "\u{CA35}", "\u{110D}\u{1164}\u{11AC}", "\u{CA35}", "\u{110D}\u{1164}\u{11AC}"),
    ("\u{CA36}", "\u{CA36}", "\u{110D}\u{1164}\u{11AD}", "\u{CA36}", "\u{110D}\u{1164}\u{11AD}"),
    ("\u{CA37}", "\u{CA37}", "\u{110D}\u{1164}\u{11AE}", "\u{CA37}", "\u{110D}\u{1164}\u{11AE}"),
    ("\u{CA38}", "\u{CA38}", "\u{110D}\u{1164}\u{11AF}", "\u{CA38}", "\u{110D}\u{1164}\u{11AF}"),
    ("\u{CA39}", "\u{CA39}", "\u{110D}\u{1164}\u{11B0}", "\u{CA39}", "\u{110D}\u{1164}\u{11B0}"),
    ("\u{CA3A}", "\u{CA3A}", "\u{110D}\u{1164}\u{11B1}", "\u{CA3A}", "\u{110D}\u{1164}\u{11B1}"),
    ("\u{CA3B}", "\u{CA3B}", "\u{110D}\u{1164}\u{11B2}", "\u{CA3B}", "\u{110D}\u{1164}\u{11B2}"),
    ("\u{CA3C}", "\u{CA3C}", "\u{110D}\u{1164}\u{11B3}", "\u{CA3C}", "\u{110D}\u{1164}\u{11B3}"),
    ("\u{CA3D}", "\u{CA3D}", "\u{110D}\u{1164}\u{11B4}", "\u{CA3D}", "\u{110D}\u{1164}\u{11B4}"),
    ("\u{CA3E}", "\u{CA3E}", "\u{110D}\u{1164}\u{11B5}", "\u{CA3E}", "\u{110D}\u{1164}\u{11B5}"),
    ("\u{CA3F}", "\u{CA3F}", "\u{110D}\u{1164}\u{11B6}", "\u{CA3F}", "\u{110D}\u{1164}\u{11B6}"),
    ("\u{CA40}", "\u{CA40}", "\u{110D}\u{1164}\u{11B7}", "\u{CA40}", "\u{110D}\u{1164}\u{11B7}"),
    ("\u{CA41}", "\u{CA41}", "\u{110D}\u{1164}\u{11B8}", "\u{CA41}", "\u{110D}\u{1164}\u{11B8}"),
    ("\u{CA42}", "\u{CA42}", "\u{110D}\u{1164}\u{11B9}", "\u{CA42}", "\u{110D}\u{1164}\u{11B9}"),
    ("\u{CA43}", "\u{CA43}", "\u{110D}\u{1164}\u{11BA}", "\u{CA43}", "\u{110D}\u{1164}\u{11BA}"),
    ("\u{CA44}", "\u{CA44}", "\u{110D}\u{1164}\u{11BB}", "\u{CA44}", "\u{110D}\u{1164}\u{11BB}"),
    ("\u{CA45}", "\u{CA45}", "\u{110D}\u{1164}\u{11BC}", "\u{CA45}", "\u{110D}\u{1164}\u{11BC}"),
    ("\u{CA46}", "\u{CA46}", "\u{110D}\u{1164}\u{11BD}", "\u{CA46}", "\u{110D}\u{1164}\u{11BD}"),
    ("\u{CA47}", "\u{CA47}", "\u{110D}\u{1164}\u{11BE}", "\u{CA47}", "\u{110D}\u{1164}\u{11BE}"),
    ("\u{CA48}", "\u{CA48}", "\u{110D}\u{1164}\u{11BF}", "\u{CA48}", "\u{110D}\u{1164}\u{11BF}"),
    ("\u{CA49}", "\u{CA49}", "\u{110D}\u{1164}\u{11C0}", "\u{CA49}", "\u{110D}\u{1164}\u{11C0}"),
    ("\u{CA4A}", "\u{CA4A}", "\u{110D}\u{1164}\u{11C1}", "\u{CA4A}", "\u{110D}\u{1164}\u{11C1}"),
    ("\u{CA4B}", "\u{CA4B}", "\u{110D}\u{1164}\u{11C2}", "\u{CA4B}", "\u{110D}\u{1164}\u{11C2}"),
    ("\u{CA4C}", "\u{CA4C}", "\u{110D}\u{1165}", "\u{CA4C}", "\u{110D}\u{1165}"),
    ("\u{CA4D}", "\u{CA4D}", "\u{110D}\u{1165}\u{11A8}", "\u{CA4D}", "\u{110D}\u{1165}\u{11A8}"),
    ("\u{CA4E}", "\u{CA4E}", "\u{110D}\u{1165}\u{11A9}", "\u{CA4E}", "\u{110D}\u{1165}\u{11A9}"),
    ("\u{CA4F}", "\u{CA4F}", "\u{110D}\u{1165}\u{11AA}", "\u{CA4F}", "\u{110D}\u{1165}\u{11AA}"),
    ("\u{CA50}", "\u{CA50}", "\u{110D}\u{1165}\u{11AB}", "\u{CA50}", "\u{110D}\u{1165}\u{11AB}"),
    ("\u{CA51}", "\u{CA51}", "\u{110D}\u{1165}\u{11AC}", "\u{CA51}", "\u{110D}\u{1165}\u{11AC}"),
    ("\u{CA52}", "\u{CA52}", "\u{110D}\u{1165}\u{11AD}", "\u{CA52}", "\u{110D}\u{1165}\u{11AD}"),
    ("\u{CA53}", "\u{CA53}", "\u{110D}\u{1165}\u{11AE}", "\u{CA53}", "\u{110D}\u{1165}\u{11AE}"),
    ("\u{CA54}", "\u{CA54}", "\u{110D}\u{1165}\u{11AF}", "\u{CA54}", "\u{110D}\u{1165}\u{11AF}"),
    ("\u{CA55}", "\u{CA55}", "\u{110D}\u{1165}\u{11B0}", "\u{CA55}", "\u{110D}\u{1165}\u{11B0}"),
    ("\u{CA56}", "\u{CA56}", "\u{110D}\u{1165}\u{11B1}", "\u{CA56}", "\u{110D}\u{1165}\u{11B1}"),
    ("\u{CA57}", "\u{CA57}", "\u{110D}\u{1165}\u{11B2}", "\u{CA57}", "\u{110D}\u{1165}\u{11B2}"),
    ("\u{CA58}", "\u{CA58}", "\u{110D}\u{1165}\u{11B3}", "\u{CA58}", "\u{110D}\u{1165}\u{11B3}"),
    ("\u{CA59}", "\u{CA59}", "\u{110D}\u{1165}\u{11B4}", "\u{CA59}", "\u{110D}\u{1165}\u{11B4}"),
    ("\u{CA5A}", "\u{CA5A}", "\u{110D}\u{1165}\u{11B5}", "\u{CA5A}", "\u{110D}\u{1165}\u{11B5}"),
    ("\u{CA5B}", "\u{CA5B}", "\u{110D}\u{1165}\u{11B6}", "\u{CA5B}", "\u{110D}\u{1165}\u{11B6}"),
    ("\u{CA5C}", "\u{CA5C}", "\u{110D}\u{1165}\u{11B7}", "\u{CA5C}", "\u{110D}\u{1165}\u{11B7}"),
    ("\u{CA5D}", "\u{CA5D}", "\u{110D}\u{1165}\u{11B8}", "\u{CA5D}", "\u{110D}\u{1165}\u{11B8}"),
    ("\u{CA5E}", "\u{CA5E}", "\u{110D}\u{1165}\u{11B9}", "\u{CA5E}", "\u{110D}\u{1165}\u{11B9}"),
    ("\u{CA5F}", "\u{CA5F}", "\u{110D}\u{1165}\u{11BA}", "\u{CA5F}", "\u{110D}\u{1165}\u{11BA}"),
    ("\u{CA60}", "\u{CA60}", "\u{110D}\u{1165}\u{11BB}", "\u{CA60}", "\u{110D}\u{1165}\u{11BB}"),
    ("\u{CA61}", "\u{CA61}", "\u{110D}\u{1165}\u{11BC}", "\u{CA61}", "\u{110D}\u{1165}\u{11BC}"),
    ("\u{CA62}", "\u{CA62}", "\u{110D}\u{1165}\u{11BD}", "\u{CA62}", "\u{110D}\u{1165}\u{11BD}"),
    ("\u{CA63}", "\u{CA63}", "\u{110D}\u{1165}\u{11BE}", "\u{CA63}", "\u{110D}\u{1165}\u{11BE}"),
    ("\u{CA64}", "\u{CA64}", "\u{110D}\u{1165}\u{11BF}", "\u{CA64}", "\u{110D}\u{1165}\u{11BF}"),
    ("\u{CA65}", "\u{CA65}", "\u{110D}\u{1165}\u{11C0}", "\u{CA65}", "\u{110D}\u{1165}\u{11C0}"),
    ("\u{CA66}", "\u{CA66}", "\u{110D}\u{1165}\u{11C1}", "\u{CA66}", "\u{110D}\u{1165}\u{11C1}"),
    ("\u{CA67}", "\u{CA67}", "\u{110D}\u{1165}\u{11C2}", "\u{CA67}", "\u{110D}\u{1165}\u{11C2}"),
    ("\u{CA68}", "\u{CA68}", "\u{110D}\u{1166}", "\u{CA68}", "\u{110D}\u{1166}"),
    ("\u{CA69}", "\u{CA69}", "\u{110D}\u{1166}\u{11A8}", "\u{CA69}", "\u{110D}\u{1166}\u{11A8}"),
    ("\u{CA6A}", "\u{CA6A}", "\u{110D}\u{1166}\u{11A9}", "\u{CA6A}", "\u{110D}\u{1166}\u{11A9}"),
    ("\u{CA6B}", "\u{CA6B}", "\u{110D}\u{1166}\u{11AA}", "\u{CA6B}", "\u{110D}\u{1166}\u{11AA}"),
    ("\u{CA6C}", "\u{CA6C}", "\u{110D}\u{1166}\u{11AB}", "\u{CA6C}", "\u{110D}\u{1166}\u{11AB}"),
    ("\u{CA6D}", "\u{CA6D}", "\u{110D}\u{1166}\u{11AC}", "\u{CA6D}", "\u{110D}\u{1166}\u{11AC}"),
    ("\u{CA6E}", "\u{CA6E}", "\u{110D}\u{1166}\u{11AD}", "\u{CA6E}", "\u{110D}\u{1166}\u{11AD}"),
    ("\u{CA6F}", "\u{CA6F}", "\u{110D}\u{1166}\u{11AE}", "\u{CA6F}", "\u{110D}\u{1166}\u{11AE}"),
    ("\u{CA70}", "\u{CA70}", "\u{110D}\u{1166}\u{11AF}", "\u{CA70}", "\u{110D}\u{1166}\u{11AF}"),
    ("\u{CA71}", "\u{CA71}", "\u{110D}\u{1166}\u{11B0}", "\u{CA71}", "\u{110D}\u{1166}\u{11B0}"),
    ("\u{CA72}", "\u{CA72}", "\u{110D}\u{1166}\u{11B1}", "\u{CA72}", "\u{110D}\u{1166}\u{11B1}"),
    ("\u{CA73}", "\u{CA73}", "\u{110D}\u{1166}\u{11B2}", "\u{CA73}", "\u{110D}\u{1166}\u{11B2}"),
    ("\u{CA74}", "\u{CA74}", "\u{110D}\u{1166}\u{11B3}", "\u{CA74}", "\u{110D}\u{1166}\u{11B3}"),
    ("\u{CA75}", "\u{CA75}", "\u{110D}\u{1166}\u{11B4}", "\u{CA75}", "\u{110D}\u{1166}\u{11B4}"),
    ("\u{CA76}", "\u{CA76}", "\u{110D}\u{1166}\u{11B5}", "\u{CA76}", "\u{110D}\u{1166}\u{11B5}"),
    ("\u{CA77}", "\u{CA77}", "\u{110D}\u{1166}\u{11B6}", "\u{CA77}", "\u{110D}\u{1166}\u{11B6}"),
    ("\u{CA78}", "\u{CA78}", "\u{110D}\u{1166}\u{11B7}", "\u{CA78}", "\u{110D}\u{1166}\u{11B7}"),
    ("\u{CA79}", "\u{CA79}", "\u{110D}\u{1166}\u{11B8}", "\u{CA79}", "\u{110D}\u{1166}\u{11B8}"),
    ("\u{CA7A}", "\u{CA7A}", "\u{110D}\u{1166}\u{11B9}", "\u{CA7A}", "\u{110D}\u{1166}\u{11B9}"),
    ("\u{CA7B}", "\u{CA7B}", "\u{110D}\u{1166}\u{11BA}", "\u{CA7B}", "\u{110D}\u{1166}\u{11BA}"),
    ("\u{CA7C}", "\u{CA7C}", "\u{110D}\u{1166}\u{11BB}", "\u{CA7C}", "\u{110D}\u{1166}\u{11BB}"),
    ("\u{CA7D}", "\u{CA7D}", "\u{110D}\u{1166}\u{11BC}", "\u{CA7D}", "\u{110D}\u{1166}\u{11BC}"),
    ("\u{CA7E}", "\u{CA7E}", "\u{110D}\u{1166}\u{11BD}", "\u{CA7E}", "\u{110D}\u{1166}\u{11BD}"),
    ("\u{CA7F}", "\u{CA7F}", "\u{110D}\u{1166}\u{11BE}", "\u{CA7F}", "\u{110D}\u{1166}\u{11BE}"),
    ("\u{CA80}", "\u{CA80}", "\u{110D}\u{1166}\u{11BF}", "\u{CA80}", "\u{110D}\u{1166}\u{11BF}"),
    ("\u{CA81}", "\u{CA81}", "\u{110D}\u{1166}\u{11C0}", "\u{CA81}", "\u{110D}\u{1166}\u{11C0}"),
    ("\u{CA82}", "\u{CA82}", "\u{110D}\u{1166}\u{11C1}", "\u{CA82}", "\u{110D}\u{1166}\u{11C1}"),
    ("\u{CA83}", "\u{CA83}", "\u{110D}\u{1166}\u{11C2}", "\u{CA83}", "\u{110D}\u{1166}\u{11C2}"),
    ("\u{CA84}", "\u{CA84}", "\u{110D}\u{1167}", "\u{CA84}", "\u{110D}\u{1167}"),
    ("\u{CA85}", "\u{CA85}", "\u{110D}\u{1167}\u{11A8}", "\u{CA85}", "\u{110D}\u{1167}\u{11A8}"),
    ("\u{CA86}", "\u{CA86}", "\u{110D}\u{1167}\u{11A9}", "\u{CA86}", "\u{110D}\u{1167}\u{11A9}"),
    ("\u{CA87}", "\u{CA87}", "\u{110D}\u{1167}\u{11AA}", "\u{CA87}", "\u{110D}\u{1167}\u{11AA}"),
    ("\u{CA88}", "\u{CA88}", "\u{110D}\u{1167}\u{11AB}", "\u{CA88}", "\u{110D}\u{1167}\u{11AB}"),
    ("\u{CA89}", "\u{CA89}", "\u{110D}\u{1167}\u{11AC}", "\u{CA89}", "\u{110D}\u{1167}\u{11AC}"),
    ("\u{CA8A}", "\u{CA8A}", "\u{110D}\u{1167}\u{11AD}", "\u{CA8A}", "\u{110D}\u{1167}\u{11AD}"),
    ("\u{CA8B}", "\u{CA8B}", "\u{110D}\u{1167}\u{11AE}", "\u{CA8B}", "\u{110D}\u{1167}\u{11AE}"),
    ("\u{CA8C}", "\u{CA8C}", "\u{110D}\u{1167}\u{11AF}", "\u{CA8C}", "\u{110D}\u{1167}\u{11AF}"),
    ("\u{CA8D}", "\u{CA8D}", "\u{110D}\u{1167}\u{11B0}", "\u{CA8D}", "\u{110D}\u{1167}\u{11B0}"),
    ("\u{CA8E}", "\u{CA8E}", "\u{110D}\u{1167}\u{11B1}", "\u{CA8E}", "\u{110D}\u{1167}\u{11B1}"),
    ("\u{CA8F}", "\u{CA8F}", "\u{110D}\u{1167}\u{11B2}", "\u{CA8F}", "\u{110D}\u{1167}\u{11B2}"),
    ("\u{CA90}", "\u{CA90}", "\u{110D}\u{1167}\u{11B3}", "\u{CA90}", "\u{110D}\u{1167}\u{11B3}"),
    ("\u{CA91}", "\u{CA91}", "\u{110D}\u{1167}\u{11B4}", "\u{CA91}", "\u{110D}\u{1167}\u{11B4}"),
    ("\u{CA92}", "\u{CA92}", "\u{110D}\u{1167}\u{11B5}", "\u{CA92}", "\u{110D}\u{1167}\u{11B5}"),
    ("\u{CA93}", "\u{CA93}", "\u{110D}\u{1167}\u{11B6}", "\u{CA93}", "\u{110D}\u{1167}\u{11B6}"),
    ("\u{CA94}", "\u{CA94}", "\u{110D}\u{1167}\u{11B7}", "\u{CA94}", "\u{110D}\u{1167}\u{11B7}"),
    ("\u{CA95}", "\u{CA95}", "\u{110D}\u{1167}\u{11B8}", "\u{CA95}", "\u{110D}\u{1167}\u{11B8}"),
    ("\u{CA96}", "\u{CA96}", "\u{110D}\u{1167}\u{11B9}", "\u{CA96}", "\u{110D}\u{1167}\u{11B9}"),
    ("\u{CA97}", "\u{CA97}", "\u{110D}\u{1167}\u{11BA}", "\u{CA97}", "\u{110D}\u{1167}\u{11BA}"),
    ("\u{CA98}", "\u{CA98}", "\u{110D}\u{1167}\u{11BB}", "\u{CA98}", "\u{110D}\u{1167}\u{11BB}"),
    ("\u{CA99}", "\u{CA99}", "\u{110D}\u{1167}\u{11BC}", "\u{CA99}", "\u{110D}\u{1167}\u{11BC}"),
    ("\u{CA9A}", "\u{CA9A}", "\u{110D}\u{1167}\u{11BD}", "\u{CA9A}", "\u{110D}\u{1167}\u{11BD}"),
    ("\u{CA9B}", "\u{CA9B}", "\u{110D}\u{1167}\u{11BE}", "\u{CA9B}", "\u{110D}\u{1167}\u{11BE}"),
    ("\u{CA9C}", "\u{CA9C}", "\u{110D}\u{1167}\u{11BF}", "\u{CA9C}", "\u{110D}\u{1167}\u{11BF}"),
    ("\u{CA9D}", "\u{CA9D}", "\u{110D}\u{1167}\u{11C0}", "\u{CA9D}", "\u{110D}\u{1167}\u{11C0}"),
    ("\u{CA9E}", "\u{CA9E}", "\u{110D}\u{1167}\u{11C1}", "\u{CA9E}", "\u{110D}\u{1167}\u{11C1}"),
    ("\u{CA9F}", "\u{CA9F}", "\u{110D}\u{1167}\u{11C2}", "\u{CA9F}", "\u{110D}\u{1167}\u{11C2}"),
    ("\u{CAA0}", "\u{CAA0}", "\u{110D}\u{1168}", "\u{CAA0}", "\u{110D}\u{1168}"),
    ("\u{CAA1}", "\u{CAA1}", "\u{110D}\u{1168}\u{11A8}", "\u{CAA1}", "\u{110D}\u{1168}\u{11A8}"),
    ("\u{CAA2}", "\u{CAA2}", "\u{110D}\u{1168}\u{11A9}", "\u{CAA2}", "\u{110D}\u{1168}\u{11A9}"),
    ("\u{CAA3}", "\u{CAA3}", "\u{110D}\u{1168}\u{11AA}", "\u{CAA3}", "\u{110D}\u{1168}\u{11AA}"),
    ("\u{CAA4}", "\u{CAA4}", "\u{110D}\u{1168}\u{11AB}", "\u{CAA4}", "\u{110D}\u{1168}\u{11AB}"),
    ("\u{CAA5}", "\u{CAA5}", "\u{110D}\u{1168}\u{11AC}", "\u{CAA5}", "\u{110D}\u{1168}\u{11AC}"),
    ("\u{CAA6}", "\u{CAA6}", "\u{110D}\u{1168}\u{11AD}", "\u{CAA6}", "\u{110D}\u{1168}\u{11AD}"),
    ("\u{CAA7}", "\u{CAA7}", "\u{110D}\u{1168}\u{11AE}", "\u{CAA7}", "\u{110D}\u{1168}\u{11AE}"),
    ("\u{CAA8}", "\u{CAA8}", "\u{110D}\u{1168}\u{11AF}", "\u{CAA8}", "\u{110D}\u{1168}\u{11AF}"),
    ("\u{CAA9}", "\u{CAA9}", "\u{110D}\u{1168}\u{11B0}", "\u{CAA9}", "\u{110D}\u{1168}\u{11B0}"),
    ("\u{CAAA}", "\u{CAAA}", "\u{110D}\u{1168}\u{11B1}", "\u{CAAA}", "\u{110D}\u{1168}\u{11B1}"),
    ("\u{CAAB}", "\u{CAAB}", "\u{110D}\u{1168}\u{11B2}", "\u{CAAB}", "\u{110D}\u{1168}\u{11B2}"),
    ("\u{CAAC}", "\u{CAAC}", "\u{110D}\u{1168}\u{11B3}", "\u{CAAC}", "\u{110D}\u{1168}\u{11B3}"),
    ("\u{CAAD}", "\u{CAAD}", "\u{110D}\u{1168}\u{11B4}", "\u{CAAD}", "\u{110D}\u{1168}\u{11B4}"),
    ("\u{CAAE}", "\u{CAAE}", "\u{110D}\u{1168}\u{11B5}", "\u{CAAE}", "\u{110D}\u{1168}\u{11B5}"),
    ("\u{CAAF}", "\u{CAAF}", "\u{110D}\u{1168}\u{11B6}", "\u{CAAF}", "\u{110D}\u{1168}\u{11B6}"),
    ("\u{CAB0}", "\u{CAB0}", "\u{110D}\u{1168}\u{11B7}", "\u{CAB0}", "\u{110D}\u{1168}\u{11B7}"),
    ("\u{CAB1}", "\u{CAB1}", "\u{110D}\u{1168}\u{11B8}", "\u{CAB1}", "\u{110D}\u{1168}\u{11B8}"),
    ("\u{CAB2}", "\u{CAB2}", "\u{110D}\u{1168}\u{11B9}", "\u{CAB2}", "\u{110D}\u{1168}\u{11B9}"),
    ("\u{CAB3}", "\u{CAB3}", "\u{110D}\u{1168}\u{11BA}", "\u{CAB3}", "\u{110D}\u{1168}\u{11BA}"),
    ("\u{CAB4}", "\u{CAB4}", "\u{110D}\u{1168}\u{11BB}", "\u{CAB4}", "\u{110D}\u{1168}\u{11BB}"),
    ("\u{CAB5}", "\u{CAB5}", "\u{110D}\u{1168}\u{11BC}", "\u{CAB5}", "\u{110D}\u{1168}\u{11BC}"),
    ("\u{CAB6}", "\u{CAB6}", "\u{110D}\u{1168}\u{11BD}", "\u{CAB6}", "\u{110D}\u{1168}\u{11BD}"),
    ("\u{CAB7}", "\u{CAB7}", "\u{110D}\u{1168}\u{11BE}", "\u{CAB7}", "\u{110D}\u{1168}\u{11BE}"),
    ("\u{CAB8}", "\u{CAB8}", "\u{110D}\u{1168}\u{11BF}", "\u{CAB8}", "\u{110D}\u{1168}\u{11BF}"),
    ("\u{CAB9}", "\u{CAB9}", "\u{110D}\u{1168}\u{11C0}", "\u{CAB9}", "\u{110D}\u{1168}\u{11C0}"),
    ("\u{CABA}", "\u{CABA}", "\u{110D}\u{1168}\u{11C1}", "\u{CABA}", "\u{110D}\u{1168}\u{11C1}"),
    ("\u{CABB}", "\u{CABB}", "\u{110D}\u{1168}\u{11C2}", "\u{CABB}", "\u{110D}\u{1168}\u{11C2}"),
    ("\u{CABC}", "\u{CABC}", "\u{110D}\u{1169}", "\u{CABC}", "\u{110D}\u{1169}"),
    ("\u{CABD}", "\u{CABD}", "\u{110D}\u{1169}\u{11A8}", "\u{CABD}", "\u{110D}\u{1169}\u{11A8}"),
    ("\u{CABE}", "\u{CABE}", "\u{110D}\u{1169}\u{11A9}", "\u{CABE}", "\u{110D}\u{1169}\u{11A9}"),
    ("\u{CABF}", "\u{CABF}", "\u{110D}\u{1169}\u{11AA}", "\u{CABF}", "\u{110D}\u{1169}\u{11AA}"),
    ("\u{CAC0}", "\u{CAC0}", "\u{110D}\u{1169}\u{11AB}", "\u{CAC0}", "\u{110D}\u{1169}\u{11AB}"),
    ("\u{CAC1}", "\u{CAC1}", "\u{110D}\u{1169}\u{11AC}", "\u{CAC1}", "\u{110D}\u{1169}\u{11AC}"),
    ("\u{CAC2}", "\u{CAC2}", "\u{110D}\u{1169}\u{11AD}", "\u{CAC2}", "\u{110D}\u{1169}\u{11AD}"),
    ("\u{CAC3}", "\u{CAC3}", "\u{110D}\u{1169}\u{11AE}", "\u{CAC3}", "\u{110D}\u{1169}\u{11AE}"),
    ("\u{CAC4}", "\u{CAC4}", "\u{110D}\u{1169}\u{11AF}", "\u{CAC4}", "\u{110D}\u{1169}\u{11AF}"),
    ("\u{CAC5}", "\u{CAC5}", "\u{110D}\u{1169}\u{11B0}", "\u{CAC5}", "\u{110D}\u{1169}\u{11B0}"),
    ("\u{CAC6}", "\u{CAC6}", "\u{110D}\u{1169}\u{11B1}", "\u{CAC6}", "\u{110D}\u{1169}\u{11B1}"),
    ("\u{CAC7}", "\u{CAC7}", "\u{110D}\u{1169}\u{11B2}", "\u{CAC7}", "\u{110D}\u{1169}\u{11B2}"),
    ("\u{CAC8}", "\u{CAC8}", "\u{110D}\u{1169}\u{11B3}", "\u{CAC8}", "\u{110D}\u{1169}\u{11B3}"),
    ("\u{CAC9}", "\u{CAC9}", "\u{110D}\u{1169}\u{11B4}", "\u{CAC9}", "\u{110D}\u{1169}\u{11B4}"),
    ("\u{CACA}", "\u{CACA}", "\u{110D}\u{1169}\u{11B5}", "\u{CACA}", "\u{110D}\u{1169}\u{11B5}"),
    ("\u{CACB}", "\u{CACB}", "\u{110D}\u{1169}\u{11B6}", "\u{CACB}", "\u{110D}\u{1169}\u{11B6}"),
    ("\u{CACC}", "\u{CACC}", "\u{110D}\u{1169}\u{11B7}", "\u{CACC}", "\u{110D}\u{1169}\u{11B7}"),
    ("\u{CACD}", "\u{CACD}", "\u{110D}\u{1169}\u{11B8}", "\u{CACD}", "\u{110D}\u{1169}\u{11B8}"),
    ("\u{CACE}", "\u{CACE}", "\u{110D}\u{1169}\u{11B9}", "\u{CACE}", "\u{110D}\u{1169}\u{11B9}"),
    ("\u{CACF}", "\u{CACF}", "\u{110D}\u{1169}\u{11BA}", "\u{CACF}", "\u{110D}\u{1169}\u{11BA}"),
    ("\u{CAD0}", "\u{CAD0}", "\u{110D}\u{1169}\u{11BB}", "\u{CAD0}", "\u{110D}\u{1169}\u{11BB}"),
    ("\u{CAD1}", "\u{CAD1}", "\u{110D}\u{1169}\u{11BC}", "\u{CAD1}", "\u{110D}\u{1169}\u{11BC}"),
    ("\u{CAD2}", "\u{CAD2}", "\u{110D}\u{1169}\u{11BD}", "\u{CAD2}", "\u{110D}\u{1169}\u{11BD}"),
    ("\u{CAD3}", "\u{CAD3}", "\u{110D}\u{1169}\u{11BE}", "\u{CAD3}", "\u{110D}\u{1169}\u{11BE}"),
    ("\u{CAD4}", "\u{CAD4}", "\u{110D}\u{1169}\u{11BF}", "\u{CAD4}", "\u{110D}\u{1169}\u{11BF}"),
    ("\u{CAD5}", "\u{CAD5}", "\u{110D}\u{1169}\u{11C0}", "\u{CAD5}", "\u{110D}\u{1169}\u{11C0}"),
    ("\u{CAD6}", "\u{CAD6}", "\u{110D}\u{1169}\u{11C1}", "\u{CAD6}", "\u{110D}\u{1169}\u{11C1}"),
    ("\u{CAD7}", "\u{CAD7}", "\u{110D}\u{1169}\u{11C2}", "\u{CAD7}", "\u{110D}\u{1169}\u{11C2}"),
    ("\u{CAD8}", "\u{CAD8}", "\u{110D}\u{116A}", "\u{CAD8}", "\u{110D}\u{116A}"),
    ("\u{CAD9}", "\u{CAD9}", "\u{110D}\u{116A}\u{11A8}", "\u{CAD9}", "\u{110D}\u{116A}\u{11A8}"),
    ("\u{CADA}", "\u{CADA}", "\u{110D}\u{116A}\u{11A9}", "\u{CADA}", "\u{110D}\u{116A}\u{11A9}"),
    ("\u{CADB}", "\u{CADB}", "\u{110D}\u{116A}\u{11AA}", "\u{CADB}", "\u{110D}\u{116A}\u{11AA}"),
    ("\u{CADC}", "\u{CADC}", "\u{110D}\u{116A}\u{11AB}", "\u{CADC}", "\u{110D}\u{116A}\u{11AB}"),
    ("\u{CADD}", "\u{CADD}", "\u{110D}\u{116A}\u{11AC}", "\u{CADD}", "\u{110D}\u{116A}\u{11AC}"),
    ("\u{CADE}", "\u{CADE}", "\u{110D}\u{116A}\u{11AD}", "\u{CADE}", "\u{110D}\u{116A}\u{11AD}"),
    ("\u{CADF}", "\u{CADF}", "\u{110D}\u{116A}\u{11AE}", "\u{CADF}", "\u{110D}\u{116A}\u{11AE}"),
    ("\u{CAE0}", "\u{CAE0}", "\u{110D}\u{116A}\u{11AF}", "\u{CAE0}", "\u{110D}\u{116A}\u{11AF}"),
    ("\u{CAE1}", "\u{CAE1}", "\u{110D}\u{116A}\u{11B0}", "\u{CAE1}", "\u{110D}\u{116A}\u{11B0}"),
    ("\u{CAE2}", "\u{CAE2}", "\u{110D}\u{116A}\u{11B1}", "\u{CAE2}", "\u{110D}\u{116A}\u{11B1}"),
    ("\u{CAE3}", "\u{CAE3}", "\u{110D}\u{116A}\u{11B2}", "\u{CAE3}", "\u{110D}\u{116A}\u{11B2}"),
    ("\u{CAE4}", "\u{CAE4}", "\u{110D}\u{116A}\u{11B3}", "\u{CAE4}", "\u{110D}\u{116A}\u{11B3}"),
    ("\u{CAE5}", "\u{CAE5}", "\u{110D}\u{116A}\u{11B4}", "\u{CAE5}", "\u{110D}\u{116A}\u{11B4}"),
    ("\u{CAE6}", "\u{CAE6}", "\u{110D}\u{116A}\u{11B5}", "\u{CAE6}", "\u{110D}\u{116A}\u{11B5}"),
    ("\u{CAE7}", "\u{CAE7}", "\u{110D}\u{116A}\u{11B6}", "\u{CAE7}", "\u{110D}\u{116A}\u{11B6}"),
    ("\u{CAE8}", "\u{CAE8}", "\u{110D}\u{116A}\u{11B7}", "\u{CAE8}", "\u{110D}\u{116A}\u{11B7}"),
    ("\u{CAE9}", "\u{CAE9}", "\u{110D}\u{116A}\u{11B8}", "\u{CAE9}", "\u{110D}\u{116A}\u{11B8}"),
    ("\u{CAEA}", "\u{CAEA}", "\u{110D}\u{116A}\u{11B9}", "\u{CAEA}", "\u{110D}\u{116A}\u{11B9}"),
    ("\u{CAEB}", "\u{CAEB}", "\u{110D}\u{116A}\u{11BA}", "\u{CAEB}", "\u{110D}\u{116A}\u{11BA}"),
    ("\u{CAEC}", "\u{CAEC}", "\u{110D}\u{116A}\u{11BB}", "\u{CAEC}", "\u{110D}\u{116A}\u{11BB}"),
    ("\u{CAED}", "\u{CAED}", "\u{110D}\u{116A}\u{11BC}", "\u{CAED}", "\u{110D}\u{116A}\u{11BC}"),
    ("\u{CAEE}", "\u{CAEE}", "\u{110D}\u{116A}\u{11BD}", "\u{CAEE}", "\u{110D}\u{116A}\u{11BD}"),
    ("\u{CAEF}", "\u{CAEF}", "\u{110D}\u{116A}\u{11BE}", "\u{CAEF}", "\u{110D}\u{116A}\u{11BE}"),
    ("\u{CAF0}", "\u{CAF0}", "\u{110D}\u{116A}\u{11BF}", "\u{CAF0}", "\u{110D}\u{116A}\u{11BF}"),
    ("\u{CAF1}", "\u{CAF1}", "\u{110D}\u{116A}\u{11C0}", "\u{CAF1}", "\u{110D}\u{116A}\u{11C0}"),
    ("\u{CAF2}", "\u{CAF2}", "\u{110D}\u{116A}\u{11C1}", "\u{CAF2}", "\u{110D}\u{116A}\u{11C1}"),
    ("\u{CAF3}", "\u{CAF3}", "\u{110D}\u{116A}\u{11C2}", "\u{CAF3}", "\u{110D}\u{116A}\u{11C2}"),
    ("\u{CAF4}", "\u{CAF4}", "\u{110D}\u{116B}", "\u{CAF4}", "\u{110D}\u{116B}"),
    ("\u{CAF5}", "\u{CAF5}", "\u{110D}\u{116B}\u{11A8}", "\u{CAF5}", "\u{110D}\u{116B}\u{11A8}"),
    ("\u{CAF6}", "\u{CAF6}", "\u{110D}\u{116B}\u{11A9}", "\u{CAF6}", "\u{110D}\u{116B}\u{11A9}"),
    ("\u{CAF7}", "\u{CAF7}", "\u{110D}\u{116B}\u{11AA}", "\u{CAF7}", "\u{110D}\u{116B}\u{11AA}"),
    ("\u{CAF8}", "\u{CAF8}", "\u{110D}\u{116B}\u{11AB}", "\u{CAF8}", "\u{110D}\u{116B}\u{11AB}"),
    ("\u{CAF9}", "\u{CAF9}", "\u{110D}\u{116B}\u{11AC}", "\u{CAF9}", "\u{110D}\u{116B}\u{11AC}"),
    ("\u{CAFA}", "\u{CAFA}", "\u{110D}\u{116B}\u{11AD}", "\u{CAFA}", "\u{110D}\u{116B}\u{11AD}"),
    ("\u{CAFB}", "\u{CAFB}", "\u{110D}\u{116B}\u{11AE}", "\u{CAFB}", "\u{110D}\u{116B}\u{11AE}"),
    ("\u{CAFC}", "\u{CAFC}", "\u{110D}\u{116B}\u{11AF}", "\u{CAFC}", "\u{110D}\u{116B}\u{11AF}"),
    ("\u{CAFD}", "\u{CAFD}", "\u{110D}\u{116B}\u{11B0}", "\u{CAFD}", "\u{110D}\u{116B}\u{11B0}"),
    ("\u{CAFE}", "\u{CAFE}", "\u{110D}\u{116B}\u{11B1}", "\u{CAFE}", "\u{110D}\u{116B}\u{11B1}"),
    ("\u{CAFF}", "\u{CAFF}", "\u{110D}\u{116B}\u{11B2}", "\u{CAFF}", "\u{110D}\u{116B}\u{11B2}"),
    ("\u{CB00}", "\u{CB00}", "\u{110D}\u{116B}\u{11B3}", "\u{CB00}", "\u{110D}\u{116B}\u{11B3}"),
    ("\u{CB01}", "\u{CB01}", "\u{110D}\u{116B}\u{11B4}", "\u{CB01}", "\u{110D}\u{116B}\u{11B4}"),
    ("\u{CB02}", "\u{CB02}", "\u{110D}\u{116B}\u{11B5}", "\u{CB02}", "\u{110D}\u{116B}\u{11B5}"),
    ("\u{CB03}", "\u{CB03}", "\u{110D}\u{116B}\u{11B6}", "\u{CB03}", "\u{110D}\u{116B}\u{11B6}"),
    ("\u{CB04}", "\u{CB04}", "\u{110D}\u{116B}\u{11B7}", "\u{CB04}", "\u{110D}\u{116B}\u{11B7}"),
    ("\u{CB05}", "\u{CB05}", "\u{110D}\u{116B}\u{11B8}", "\u{CB05}", "\u{110D}\u{116B}\u{11B8}"),
    ("\u{CB06}", "\u{CB06}", "\u{110D}\u{116B}\u{11B9}", "\u{CB06}", "\u{110D}\u{116B}\u{11B9}"),
    ("\u{CB07}", "\u{CB07}", "\u{110D}\u{116B}\u{11BA}", "\u{CB07}", "\u{110D}\u{116B}\u{11BA}"),
    ("\u{CB08}", "\u{CB08}", "\u{110D}\u{116B}\u{11BB}", "\u{CB08}", "\u{110D}\u{116B}\u{11BB}"),
    ("\u{CB09}", "\u{CB09}", "\u{110D}\u{116B}\u{11BC}", "\u{CB09}", "\u{110D}\u{116B}\u{11BC}"),
    ("\u{CB0A}", "\u{CB0A}", "\u{110D}\u{116B}\u{11BD}", "\u{CB0A}", "\u{110D}\u{116B}\u{11BD}"),
    ("\u{CB0B}", "\u{CB0B}", "\u{110D}\u{116B}\u{11BE}", "\u{CB0B}", "\u{110D}\u{116B}\u{11BE}"),
    ("\u{CB0C}", "\u{CB0C}", "\u{110D}\u{116B}\u{11BF}", "\u{CB0C}", "\u{110D}\u{116B}\u{11BF}"),
    ("\u{CB0D}", "\u{CB0D}", "\u{110D}\u{116B}\u{11C0}", "\u{CB0D}", "\u{110D}\u{116B}\u{11C0}"),
    ("\u{CB0E}", "\u{CB0E}", "\u{110D}\u{116B}\u{11C1}", "\u{CB0E}", "\u{110D}\u{116B}\u{11C1}"),
    ("\u{CB0F}", "\u{CB0F}", "\u{110D}\u{116B}\u{11C2}", "\u{CB0F}", "\u{110D}\u{116B}\u{11C2}"),
    ("\u{CB10}", "\u{CB10}", "\u{110D}\u{116C}", "\u{CB10}", "\u{110D}\u{116C}"),
    ("\u{CB11}", "\u{CB11}", "\u{110D}\u{116C}\u{11A8}", "\u{CB11}", "\u{110D}\u{116C}\u{11A8}"),
    ("\u{CB12}", "\u{CB12}", "\u{110D}\u{116C}\u{11A9}", "\u{CB12}", "\u{110D}\u{116C}\u{11A9}"),
    ("\u{CB13}", "\u{CB13}", "\u{110D}\u{116C}\u{11AA}", "\u{CB13}", "\u{110D}\u{116C}\u{11AA}"),
    ("\u{CB14}", "\u{CB14}", "\u{110D}\u{116C}\u{11AB}", "\u{CB14}", "\u{110D}\u{116C}\u{11AB}"),
    ("\u{CB15}", "\u{CB15}", "\u{110D}\u{116C}\u{11AC}", "\u{CB15}", "\u{110D}\u{116C}\u{11AC}"),
    ("\u{CB16}", "\u{CB16}", "\u{110D}\u{116C}\u{11AD}", "\u{CB16}", "\u{110D}\u{116C}\u{11AD}"),
    ("\u{CB17}", "\u{CB17}", "\u{110D}\u{116C}\u{11AE}", "\u{CB17}", "\u{110D}\u{116C}\u{11AE}"),
    ("\u{CB18}", "\u{CB18}", "\u{110D}\u{116C}\u{11AF}", "\u{CB18}", "\u{110D}\u{116C}\u{11AF}"),
    ("\u{CB19}", "\u{CB19}", "\u{110D}\u{116C}\u{11B0}", "\u{CB19}", "\u{110D}\u{116C}\u{11B0}"),
    ("\u{CB1A}", "\u{CB1A}", "\u{110D}\u{116C}\u{11B1}", "\u{CB1A}", "\u{110D}\u{116C}\u{11B1}"),
    ("\u{CB1B}", "\u{CB1B}", "\u{110D}\u{116C}\u{11B2}", "\u{CB1B}", "\u{110D}\u{116C}\u{11B2}"),
    ("\u{CB1C}", "\u{CB1C}", "\u{110D}\u{116C}\u{11B3}", "\u{CB1C}", "\u{110D}\u{116C}\u{11B3}"),
    ("\u{CB1D}", "\u{CB1D}", "\u{110D}\u{116C}\u{11B4}", "\u{CB1D}", "\u{110D}\u{116C}\u{11B4}"),
    ("\u{CB1E}", "\u{CB1E}", "\u{110D}\u{116C}\u{11B5}", "\u{CB1E}", "\u{110D}\u{116C}\u{11B5}"),
    ("\u{CB1F}", "\u{CB1F}", "\u{110D}\u{116C}\u{11B6}", "\u{CB1F}", "\u{110D}\u{116C}\u{11B6}"),
    ("\u{CB20}", "\u{CB20}", "\u{110D}\u{116C}\u{11B7}", "\u{CB20}", "\u{110D}\u{116C}\u{11B7}"),
    ("\u{CB21}", "\u{CB21}", "\u{110D}\u{116C}\u{11B8}", "\u{CB21}", "\u{110D}\u{116C}\u{11B8}"),
    ("\u{CB22}", "\u{CB22}", "\u{110D}\u{116C}\u{11B9}", "\u{CB22}", "\u{110D}\u{116C}\u{11B9}"),
    ("\u{CB23}", "\u{CB23}", "\u{110D}\u{116C}\u{11BA}", "\u{CB23}", "\u{110D}\u{116C}\u{11BA}"),
    ("\u{CB24}", "\u{CB24}", "\u{110D}\u{116C}\u{11BB}", "\u{CB24}", "\u{110D}\u{116C}\u{11BB}"),
    ("\u{CB25}", "\u{CB25}", "\u{110D}\u{116C}\u{11BC}", "\u{CB25}", "\u{110D}\u{116C}\u{11BC}"),
    ("\u{CB26}", "\u{CB26}", "\u{110D}\u{116C}\u{11BD}", "\u{CB26}", "\u{110D}\u{116C}\u{11BD}"),
    ("\u{CB27}", "\u{CB27}", "\u{110D}\u{116C}\u{11BE}", "\u{CB27}", "\u{110D}\u{116C}\u{11BE}"),
    ("\u{CB28}", "\u{CB28}", "\u{110D}\u{116C}\u{11BF}", "\u{CB28}", "\u{110D}\u{116C}\u{11BF}"),
    ("\u{CB29}", "\u{CB29}", "\u{110D}\u{116C}\u{11C0}", "\u{CB29}", "\u{110D}\u{116C}\u{11C0}"),
    ("\u{CB2A}", "\u{CB2A}", "\u{110D}\u{116C}\u{11C1}", "\u{CB2A}", "\u{110D}\u{116C}\u{11C1}"),
    ("\u{CB2B}", "\u{CB2B}", "\u{110D}\u{116C}\u{11C2}", "\u{CB2B}", "\u{110D}\u{116C}\u{11C2}"),
    ("\u{CB2C}", "\u{CB2C}", "\u{110D}\u{116D}", "\u{CB2C}", "\u{110D}\u{116D}"),
    ("\u{CB2D}", "\u{CB2D}", "\u{110D}\u{116D}\u{11A8}", "\u{CB2D}", "\u{110D}\u{116D}\u{11A8}"),
    ("\u{CB2E}", "\u{CB2E}", "\u{110D}\u{116D}\u{11A9}", "\u{CB2E}", "\u{110D}\u{116D}\u{11A9}"),
    ("\u{CB2F}", "\u{CB2F}", "\u{110D}\u{116D}\u{11AA}", "\u{CB2F}", "\u{110D}\u{116D}\u{11AA}"),
    ("\u{CB30}", "\u{CB30}", "\u{110D}\u{116D}\u{11AB}", "\u{CB30}", "\u{110D}\u{116D}\u{11AB}"),
    ("\u{CB31}", "\u{CB31}", "\u{110D}\u{116D}\u{11AC}", "\u{CB31}", "\u{110D}\u{116D}\u{11AC}"),
    ("\u{CB32}", "\u{CB32}", "\u{110D}\u{116D}\u{11AD}", "\u{CB32}", "\u{110D}\u{116D}\u{11AD}"),
    ("\u{CB33}", "\u{CB33}", "\u{110D}\u{116D}\u{11AE}", "\u{CB33}", "\u{110D}\u{116D}\u{11AE}"),
    ("\u{CB34}", "\u{CB34}", "\u{110D}\u{116D}\u{11AF}", "\u{CB34}", "\u{110D}\u{116D}\u{11AF}"),
    ("\u{CB35}", "\u{CB35}", "\u{110D}\u{116D}\u{11B0}", "\u{CB35}", "\u{110D}\u{116D}\u{11B0}"),
    ("\u{CB36}", "\u{CB36}", "\u{110D}\u{116D}\u{11B1}", "\u{CB36}", "\u{110D}\u{116D}\u{11B1}"),
    ("\u{CB37}", "\u{CB37}", "\u{110D}\u{116D}\u{11B2}", "\u{CB37}", "\u{110D}\u{116D}\u{11B2}"),
    ("\u{CB38}", "\u{CB38}", "\u{110D}\u{116D}\u{11B3}", "\u{CB38}", "\u{110D}\u{116D}\u{11B3}"),
    ("\u{CB39}", "\u{CB39}", "\u{110D}\u{116D}\u{11B4}", "\u{CB39}", "\u{110D}\u{116D}\u{11B4}"),
    ("\u{CB3A}", "\u{CB3A}", "\u{110D}\u{116D}\u{11B5}", "\u{CB3A}", "\u{110D}\u{116D}\u{11B5}"),
    ("\u{CB3B}", "\u{CB3B}", "\u{110D}\u{116D}\u{11B6}", "\u{CB3B}", "\u{110D}\u{116D}\u{11B6}"),
    ("\u{CB3C}", "\u{CB3C}", "\u{110D}\u{116D}\u{11B7}", "\u{CB3C}", "\u{110D}\u{116D}\u{11B7}"),
    ("\u{CB3D}", "\u{CB3D}", "\u{110D}\u{116D}\u{11B8}", "\u{CB3D}", "\u{110D}\u{116D}\u{11B8}"),
    ("\u{CB3E}", "\u{CB3E}", "\u{110D}\u{116D}\u{11B9}", "\u{CB3E}", "\u{110D}\u{116D}\u{11B9}"),
    ("\u{CB3F}", "\u{CB3F}", "\u{110D}\u{116D}\u{11BA}", "\u{CB3F}", "\u{110D}\u{116D}\u{11BA}"),
    ("\u{CB40}", "\u{CB40}", "\u{110D}\u{116D}\u{11BB}", "\u{CB40}", "\u{110D}\u{116D}\u{11BB}"),
    ("\u{CB41}", "\u{CB41}", "\u{110D}\u{116D}\u{11BC}", "\u{CB41}", "\u{110D}\u{116D}\u{11BC}"),
    ("\u{CB42}", "\u{CB42}", "\u{110D}\u{116D}\u{11BD}", "\u{CB42}", "\u{110D}\u{116D}\u{11BD}"),
    ("\u{CB43}", "\u{CB43}", "\u{110D}\u{116D}\u{11BE}", "\u{CB43}", "\u{110D}\u{116D}\u{11BE}"),
    ("\u{CB44}", "\u{CB44}", "\u{110D}\u{116D}\u{11BF}", "\u{CB44}", "\u{110D}\u{116D}\u{11BF}"),
    ("\u{CB45}", "\u{CB45}", "\u{110D}\u{116D}\u{11C0}", "\u{CB45}", "\u{110D}\u{116D}\u{11C0}"),
    ("\u{CB46}", "\u{CB46}", "\u{110D}\u{116D}\u{11C1}", "\u{CB46}", "\u{110D}\u{116D}\u{11C1}"),
    ("\u{CB47}", "\u{CB47}", "\u{110D}\u{116D}\u{11C2}", "\u{CB47}", "\u{110D}\u{116D}\u{11C2}"),
    ("\u{CB48}", "\u{CB48}", "\u{110D}\u{116E}", "\u{CB48}", "\u{110D}\u{116E}"),
    ("\u{CB49}", "\u{CB49}", "\u{110D}\u{116E}\u{11A8}", "\u{CB49}", "\u{110D}\u{116E}\u{11A8}"),
    ("\u{CB4A}", "\u{CB4A}", "\u{110D}\u{116E}\u{11A9}", "\u{CB4A}", "\u{110D}\u{116E}\u{11A9}"),
    ("\u{CB4B}", "\u{CB4B}", "\u{110D}\u{116E}\u{11AA}", "\u{CB4B}", "\u{110D}\u{116E}\u{11AA}"),
    ("\u{CB4C}", "\u{CB4C}", "\u{110D}\u{116E}\u{11AB}", "\u{CB4C}", "\u{110D}\u{116E}\u{11AB}"),
    ("\u{CB4D}", "\u{CB4D}", "\u{110D}\u{116E}\u{11AC}", "\u{CB4D}", "\u{110D}\u{116E}\u{11AC}"),
    ("\u{CB4E}", "\u{CB4E}", "\u{110D}\u{116E}\u{11AD}", "\u{CB4E}", "\u{110D}\u{116E}\u{11AD}"),
    ("\u{CB4F}", "\u{CB4F}", "\u{110D}\u{116E}\u{11AE}", "\u{CB4F}", "\u{110D}\u{116E}\u{11AE}"),
    ("\u{CB50}", "\u{CB50}", "\u{110D}\u{116E}\u{11AF}", "\u{CB50}", "\u{110D}\u{116E}\u{11AF}"),
    ("\u{CB51}", "\u{CB51}", "\u{110D}\u{116E}\u{11B0}", "\u{CB51}", "\u{110D}\u{116E}\u{11B0}"),
    ("\u{CB52}", "\u{CB52}", "\u{110D}\u{116E}\u{11B1}", "\u{CB52}", "\u{110D}\u{116E}\u{11B1}"),
    ("\u{CB53}", "\u{CB53}", "\u{110D}\u{116E}\u{11B2}", "\u{CB53}", "\u{110D}\u{116E}\u{11B2}"),
    ("\u{CB54}", "\u{CB54}", "\u{110D}\u{116E}\u{11B3}", "\u{CB54}", "\u{110D}\u{116E}\u{11B3}"),
    ("\u{CB55}", "\u{CB55}", "\u{110D}\u{116E}\u{11B4}", "\u{CB55}", "\u{110D}\u{116E}\u{11B4}"),
    ("\u{CB56}", "\u{CB56}", "\u{110D}\u{116E}\u{11B5}", "\u{CB56}", "\u{110D}\u{116E}\u{11B5}"),
    ("\u{CB57}", "\u{CB57}", "\u{110D}\u{116E}\u{11B6}", "\u{CB57}", "\u{110D}\u{116E}\u{11B6}"),
    ("\u{CB58}", "\u{CB58}", "\u{110D}\u{116E}\u{11B7}", "\u{CB58}", "\u{110D}\u{116E}\u{11B7}"),
    ("\u{CB59}", "\u{CB59}", "\u{110D}\u{116E}\u{11B8}", "\u{CB59}", "\u{110D}\u{116E}\u{11B8}"),
    ("\u{CB5A}", "\u{CB5A}", "\u{110D}\u{116E}\u{11B9}", "\u{CB5A}", "\u{110D}\u{116E}\u{11B9}"),
    ("\u{CB5B}", "\u{CB5B}", "\u{110D}\u{116E}\u{11BA}", "\u{CB5B}", "\u{110D}\u{116E}\u{11BA}"),
    ("\u{CB5C}", "\u{CB5C}", "\u{110D}\u{116E}\u{11BB}", "\u{CB5C}", "\u{110D}\u{116E}\u{11BB}"),
    ("\u{CB5D}", "\u{CB5D}", "\u{110D}\u{116E}\u{11BC}", "\u{CB5D}", "\u{110D}\u{116E}\u{11BC}"),
    ("\u{CB5E}", "\u{CB5E}", "\u{110D}\u{116E}\u{11BD}", "\u{CB5E}", "\u{110D}\u{116E}\u{11BD}"),
    ("\u{CB5F}", "\u{CB5F}", "\u{110D}\u{116E}\u{11BE}", "\u{CB5F}", "\u{110D}\u{116E}\u{11BE}"),
    ("\u{CB60}", "\u{CB60}", "\u{110D}\u{116E}\u{11BF}", "\u{CB60}", "\u{110D}\u{116E}\u{11BF}"),
    ("\u{CB61}", "\u{CB61}", "\u{110D}\u{116E}\u{11C0}", "\u{CB61}", "\u{110D}\u{116E}\u{11C0}"),
    ("\u{CB62}", "\u{CB62}", "\u{110D}\u{116E}\u{11C1}", "\u{CB62}", "\u{110D}\u{116E}\u{11C1}"),
    ("\u{CB63}", "\u{CB63}", "\u{110D}\u{116E}\u{11C2}", "\u{CB63}", "\u{110D}\u{116E}\u{11C2}"),
    ("\u{CB64}", "\u{CB64}", "\u{110D}\u{116F}", "\u{CB64}", "\u{110D}\u{116F}"),
    ("\u{CB65}", "\u{CB65}", "\u{110D}\u{116F}\u{11A8}", "\u{CB65}", "\u{110D}\u{116F}\u{11A8}"),
    ("\u{CB66}", "\u{CB66}", "\u{110D}\u{116F}\u{11A9}", "\u{CB66}", "\u{110D}\u{116F}\u{11A9}"),
    ("\u{CB67}", "\u{CB67}", "\u{110D}\u{116F}\u{11AA}", "\u{CB67}", "\u{110D}\u{116F}\u{11AA}"),
    ("\u{CB68}", "\u{CB68}", "\u{110D}\u{116F}\u{11AB}", "\u{CB68}", "\u{110D}\u{116F}\u{11AB}"),
    ("\u{CB69}", "\u{CB69}", "\u{110D}\u{116F}\u{11AC}", "\u{CB69}", "\u{110D}\u{116F}\u{11AC}"),
    ("\u{CB6A}", "\u{CB6A}", "\u{110D}\u{116F}\u{11AD}", "\u{CB6A}", "\u{110D}\u{116F}\u{11AD}"),
    ("\u{CB6B}", "\u{CB6B}", "\u{110D}\u{116F}\u{11AE}", "\u{CB6B}", "\u{110D}\u{116F}\u{11AE}"),
    ("\u{CB6C}", "\u{CB6C}", "\u{110D}\u{116F}\u{11AF}", "\u{CB6C}", "\u{110D}\u{116F}\u{11AF}"),
    ("\u{CB6D}", "\u{CB6D}", "\u{110D}\u{116F}\u{11B0}", "\u{CB6D}", "\u{110D}\u{116F}\u{11B0}"),
    ("\u{CB6E}", "\u{CB6E}", "\u{110D}\u{116F}\u{11B1}", "\u{CB6E}", "\u{110D}\u{116F}\u{11B1}"),
    ("\u{CB6F}", "\u{CB6F}", "\u{110D}\u{116F}\u{11B2}", "\u{CB6F}", "\u{110D}\u{116F}\u{11B2}"),
    ("\u{CB70}", "\u{CB70}", "\u{110D}\u{116F}\u{11B3}", "\u{CB70}", "\u{110D}\u{116F}\u{11B3}"),
    ("\u{CB71}", "\u{CB71}", "\u{110D}\u{116F}\u{11B4}", "\u{CB71}", "\u{110D}\u{116F}\u{11B4}"),
    ("\u{CB72}", "\u{CB72}", "\u{110D}\u{116F}\u{11B5}", "\u{CB72}", "\u{110D}\u{116F}\u{11B5}"),
    ("\u{CB73}", "\u{CB73}", "\u{110D}\u{116F}\u{11B6}", "\u{CB73}", "\u{110D}\u{116F}\u{11B6}"),
    ("\u{CB74}", "\u{CB74}", "\u{110D}\u{116F}\u{11B7}", "\u{CB74}", "\u{110D}\u{116F}\u{11B7}"),
    ("\u{CB75}", "\u{CB75}", "\u{110D}\u{116F}\u{11B8}", "\u{CB75}", "\u{110D}\u{116F}\u{11B8}"),
    ("\u{CB76}", "\u{CB76}", "\u{110D}\u{116F}\u{11B9}", "\u{CB76}", "\u{110D}\u{116F}\u{11B9}"),
    ("\u{CB77}", "\u{CB77}", "\u{110D}\u{116F}\u{11BA}", "\u{CB77}", "\u{110D}\u{116F}\u{11BA}"),
    ("\u{CB78}", "\u{CB78}", "\u{110D}\u{116F}\u{11BB}", "\u{CB78}", "\u{110D}\u{116F}\u{11BB}"),
    ("\u{CB79}", "\u{CB79}", "\u{110D}\u{116F}\u{11BC}", "\u{CB79}", "\u{110D}\u{116F}\u{11BC}"),
    ("\u{CB7A}", "\u{CB7A}", "\u{110D}\u{116F}\u{11BD}", "\u{CB7A}", "\u{110D}\u{116F}\u{11BD}"),
    ("\u{CB7B}", "\u{CB7B}", "\u{110D}\u{116F}\u{11BE}", "\u{CB7B}", "\u{110D}\u{116F}\u{11BE}"),
    ("\u{CB7C}", "\u{CB7C}", "\u{110D}\u{116F}\u{11BF}", "\u{CB7C}", "\u{110D}\u{116F}\u{11BF}"),
    ("\u{CB7D}", "\u{CB7D}", "\u{110D}\u{116F}\u{11C0}", "\u{CB7D}", "\u{110D}\u{116F}\u{11C0}"),
    ("\u{CB7E}", "\u{CB7E}", "\u{110D}\u{116F}\u{11C1}", "\u{CB7E}", "\u{110D}\u{116F}\u{11C1}"),
    ("\u{CB7F}", "\u{CB7F}", "\u{110D}\u{116F}\u{11C2}", "\u{CB7F}", "\u{110D}\u{116F}\u{11C2}"),
    ("\u{CB80}", "\u{CB80}", "\u{110D}\u{1170}", "\u{CB80}", "\u{110D}\u{1170}"),
    ("\u{CB81}", "\u{CB81}", "\u{110D}\u{1170}\u{11A8}", "\u{CB81}", "\u{110D}\u{1170}\u{11A8}"),
    ("\u{CB82}", "\u{CB82}", "\u{110D}\u{1170}\u{11A9}", "\u{CB82}", "\u{110D}\u{1170}\u{11A9}"),
    ("\u{CB83}", "\u{CB83}", "\u{110D}\u{1170}\u{11AA}", "\u{CB83}", "\u{110D}\u{1170}\u{11AA}"),
    ("\u{CB84}", "\u{CB84}", "\u{110D}\u{1170}\u{11AB}", "\u{CB84}", "\u{110D}\u{1170}\u{11AB}"),
    ("\u{CB85}", "\u{CB85}", "\u{110D}\u{1170}\u{11AC}", "\u{CB85}", "\u{110D}\u{1170}\u{11AC}"),
    ("\u{CB86}", "\u{CB86}", "\u{110D}\u{1170}\u{11AD}", "\u{CB86}", "\u{110D}\u{1170}\u{11AD}"),
    ("\u{CB87}", "\u{CB87}", "\u{110D}\u{1170}\u{11AE}", "\u{CB87}", "\u{110D}\u{1170}\u{11AE}"),
    ("\u{CB88}", "\u{CB88}", "\u{110D}\u{1170}\u{11AF}", "\u{CB88}", "\u{110D}\u{1170}\u{11AF}"),
    ("\u{CB89}", "\u{CB89}", "\u{110D}\u{1170}\u{11B0}", "\u{CB89}", "\u{110D}\u{1170}\u{11B0}"),
    ("\u{CB8A}", "\u{CB8A}", "\u{110D}\u{1170}\u{11B1}", "\u{CB8A}", "\u{110D}\u{1170}\u{11B1}"),
    ("\u{CB8B}", "\u{CB8B}", "\u{110D}\u{1170}\u{11B2}", "\u{CB8B}", "\u{110D}\u{1170}\u{11B2}"),
    ("\u{CB8C}", "\u{CB8C}", "\u{110D}\u{1170}\u{11B3}", "\u{CB8C}", "\u{110D}\u{1170}\u{11B3}"),
    ("\u{CB8D}", "\u{CB8D}", "\u{110D}\u{1170}\u{11B4}", "\u{CB8D}", "\u{110D}\u{1170}\u{11B4}"),
    ("\u{CB8E}", "\u{CB8E}", "\u{110D}\u{1170}\u{11B5}", "\u{CB8E}", "\u{110D}\u{1170}\u{11B5}"),
    ("\u{CB8F}", "\u{CB8F}", "\u{110D}\u{1170}\u{11B6}", "\u{CB8F}", "\u{110D}\u{1170}\u{11B6}"),
    ("\u{CB90}", "\u{CB90}", "\u{110D}\u{1170}\u{11B7}", "\u{CB90}", "\u{110D}\u{1170}\u{11B7}"),
    ("\u{CB91}", "\u{CB91}", "\u{110D}\u{1170}\u{11B8}", "\u{CB91}", "\u{110D}\u{1170}\u{11B8}"),
    ("\u{CB92}", "\u{CB92}", "\u{110D}\u{1170}\u{11B9}", "\u{CB92}", "\u{110D}\u{1170}\u{11B9}"),
    ("\u{CB93}", "\u{CB93}", "\u{110D}\u{1170}\u{11BA}", "\u{CB93}", "\u{110D}\u{1170}\u{11BA}"),
    ("\u{CB94}", "\u{CB94}", "\u{110D}\u{1170}\u{11BB}", "\u{CB94}", "\u{110D}\u{1170}\u{11BB}"),
    ("\u{CB95}", "\u{CB95}", "\u{110D}\u{1170}\u{11BC}", "\u{CB95}", "\u{110D}\u{1170}\u{11BC}"),
    ("\u{CB96}", "\u{CB96}", "\u{110D}\u{1170}\u{11BD}", "\u{CB96}", "\u{110D}\u{1170}\u{11BD}"),
    ("\u{CB97}", "\u{CB97}", "\u{110D}\u{1170}\u{11BE}", "\u{CB97}", "\u{110D}\u{1170}\u{11BE}"),
    ("\u{CB98}", "\u{CB98}", "\u{110D}\u{1170}\u{11BF}", "\u{CB98}", "\u{110D}\u{1170}\u{11BF}"),
    ("\u{CB99}", "\u{CB99}", "\u{110D}\u{1170}\u{11C0}", "\u{CB99}", "\u{110D}\u{1170}\u{11C0}"),
    ("\u{CB9A}", "\u{CB9A}", "\u{110D}\u{1170}\u{11C1}", "\u{CB9A}", "\u{110D}\u{1170}\u{11C1}"),
    ("\u{CB9B}", "\u{CB9B}", "\u{110D}\u{1170}\u{11C2}", "\u{CB9B}", "\u{110D}\u{1170}\u{11C2}"),
    ("\u{CB9C}", "\u{CB9C}", "\u{110D}\u{1171}", "\u{CB9C}", "\u{110D}\u{1171}"),
    ("\u{CB9D}", "\u{CB9D}", "\u{110D}\u{1171}\u{11A8}", "\u{CB9D}", "\u{110D}\u{1171}\u{11A8}"),
    ("\u{CB9E}", "\u{CB9E}", "\u{110D}\u{1171}\u{11A9}", "\u{CB9E}", "\u{110D}\u{1171}\u{11A9}"),
    ("\u{CB9F}", "\u{CB9F}", "\u{110D}\u{1171}\u{11AA}", "\u{CB9F}", "\u{110D}\u{1171}\u{11AA}"),
    ("\u{CBA0}", "\u{CBA0}", "\u{110D}\u{1171}\u{11AB}", "\u{CBA0}", "\u{110D}\u{1171}\u{11AB}"),
    ("\u{CBA1}", "\u{CBA1}", "\u{110D}\u{1171}\u{11AC}", "\u{CBA1}", "\u{110D}\u{1171}\u{11AC}"),
    ("\u{CBA2}", "\u{CBA2}", "\u{110D}\u{1171}\u{11AD}", "\u{CBA2}", "\u{110D}\u{1171}\u{11AD}"),
    ("\u{CBA3}", "\u{CBA3}", "\u{110D}\u{1171}\u{11AE}", "\u{CBA3}", "\u{110D}\u{1171}\u{11AE}"),
    ("\u{CBA4}", "\u{CBA4}", "\u{110D}\u{1171}\u{11AF}", "\u{CBA4}", "\u{110D}\u{1171}\u{11AF}"),
    ("\u{CBA5}", "\u{CBA5}", "\u{110D}\u{1171}\u{11B0}", "\u{CBA5}", "\u{110D}\u{1171}\u{11B0}"),
    ("\u{CBA6}", "\u{CBA6}", "\u{110D}\u{1171}\u{11B1}", "\u{CBA6}", "\u{110D}\u{1171}\u{11B1}"),
    ("\u{CBA7}", "\u{CBA7}", "\u{110D}\u{1171}\u{11B2}", "\u{CBA7}", "\u{110D}\u{1171}\u{11B2}"),
    ("\u{CBA8}", "\u{CBA8}", "\u{110D}\u{1171}\u{11B3}", "\u{CBA8}", "\u{110D}\u{1171}\u{11B3}"),
    ("\u{CBA9}", "\u{CBA9}", "\u{110D}\u{1171}\u{11B4}", "\u{CBA9}", "\u{110D}\u{1171}\u{11B4}"),
    ("\u{CBAA}", "\u{CBAA}", "\u{110D}\u{1171}\u{11B5}", "\u{CBAA}", "\u{110D}\u{1171}\u{11B5}"),
    ("\u{CBAB}", "\u{CBAB}", "\u{110D}\u{1171}\u{11B6}", "\u{CBAB}", "\u{110D}\u{1171}\u{11B6}"),
    ("\u{CBAC}", "\u{CBAC}", "\u{110D}\u{1171}\u{11B7}", "\u{CBAC}", "\u{110D}\u{1171}\u{11B7}"),
    ("\u{CBAD}", "\u{CBAD}", "\u{110D}\u{1171}\u{11B8}", "\u{CBAD}", "\u{110D}\u{1171}\u{11B8}"),
    ("\u{CBAE}", "\u{CBAE}", "\u{110D}\u{1171}\u{11B9}", "\u{CBAE}", "\u{110D}\u{1171}\u{11B9}"),
    ("\u{CBAF}", "\u{CBAF}", "\u{110D}\u{1171}\u{11BA}", "\u{CBAF}", "\u{110D}\u{1171}\u{11BA}"),
    ("\u{CBB0}", "\u{CBB0}", "\u{110D}\u{1171}\u{11BB}", "\u{CBB0}", "\u{110D}\u{1171}\u{11BB}"),
    ("\u{CBB1}", "\u{CBB1}", "\u{110D}\u{1171}\u{11BC}", "\u{CBB1}", "\u{110D}\u{1171}\u{11BC}"),
    ("\u{CBB2}", "\u{CBB2}", "\u{110D}\u{1171}\u{11BD}", "\u{CBB2}", "\u{110D}\u{1171}\u{11BD}"),
    ("\u{CBB3}", "\u{CBB3}", "\u{110D}\u{1171}\u{11BE}", "\u{CBB3}", "\u{110D}\u{1171}\u{11BE}"),
    ("\u{CBB4}", "\u{CBB4}", "\u{110D}\u{1171}\u{11BF}", "\u{CBB4}", "\u{110D}\u{1171}\u{11BF}"),
    ("\u{CBB5}", "\u{CBB5}", "\u{110D}\u{1171}\u{11C0}", "\u{CBB5}", "\u{110D}\u{1171}\u{11C0}"),
    ("\u{CBB6}", "\u{CBB6}", "\u{110D}\u{1171}\u{11C1}", "\u{CBB6}", "\u{110D}\u{1171}\u{11C1}"),
    ("\u{CBB7}", "\u{CBB7}", "\u{110D}\u{1171}\u{11C2}", "\u{CBB7}", "\u{110D}\u{1171}\u{11C2}"),
    ("\u{CBB8}", "\u{CBB8}", "\u{110D}\u{1172}", "\u{CBB8}", "\u{110D}\u{1172}"),
    ("\u{CBB9}", "\u{CBB9}", "\u{110D}\u{1172}\u{11A8}", "\u{CBB9}", "\u{110D}\u{1172}\u{11A8}"),
    ("\u{CBBA}", "\u{CBBA}", "\u{110D}\u{1172}\u{11A9}", "\u{CBBA}", "\u{110D}\u{1172}\u{11A9}"),
    ("\u{CBBB}", "\u{CBBB}", "\u{110D}\u{1172}\u{11AA}", "\u{CBBB}", "\u{110D}\u{1172}\u{11AA}"),
    ("\u{CBBC}", "\u{CBBC}", "\u{110D}\u{1172}\u{11AB}", "\u{CBBC}", "\u{110D}\u{1172}\u{11AB}"),
    ("\u{CBBD}", "\u{CBBD}", "\u{110D}\u{1172}\u{11AC}", "\u{CBBD}", "\u{110D}\u{1172}\u{11AC}"),
    ("\u{CBBE}", "\u{CBBE}", "\u{110D}\u{1172}\u{11AD}", "\u{CBBE}", "\u{110D}\u{1172}\u{11AD}"),
    ("\u{CBBF}", "\u{CBBF}", "\u{110D}\u{1172}\u{11AE}", "\u{CBBF}", "\u{110D}\u{1172}\u{11AE}"),
    ("\u{CBC0}", "\u{CBC0}", "\u{110D}\u{1172}\u{11AF}", "\u{CBC0}", "\u{110D}\u{1172}\u{11AF}"),
    ("\u{CBC1}", "\u{CBC1}", "\u{110D}\u{1172}\u{11B0}", "\u{CBC1}", "\u{110D}\u{1172}\u{11B0}"),
    ("\u{CBC2}", "\u{CBC2}", "\u{110D}\u{1172}\u{11B1}", "\u{CBC2}", "\u{110D}\u{1172}\u{11B1}"),
    ("\u{CBC3}", "\u{CBC3}", "\u{110D}\u{1172}\u{11B2}", "\u{CBC3}", "\u{110D}\u{1172}\u{11B2}"),
    ("\u{CBC4}", "\u{CBC4}", "\u{110D}\u{1172}\u{11B3}", "\u{CBC4}", "\u{110D}\u{1172}\u{11B3}"),
    ("\u{CBC5}", "\u{CBC5}", "\u{110D}\u{1172}\u{11B4}", "\u{CBC5}", "\u{110D}\u{1172}\u{11B4}"),
    ("\u{CBC6}", "\u{CBC6}", "\u{110D}\u{1172}\u{11B5}", "\u{CBC6}", "\u{110D}\u{1172}\u{11B5}"),
    ("\u{CBC7}", "\u{CBC7}", "\u{110D}\u{1172}\u{11B6}", "\u{CBC7}", "\u{110D}\u{1172}\u{11B6}"),
    ("\u{CBC8}", "\u{CBC8}", "\u{110D}\u{1172}\u{11B7}", "\u{CBC8}", "\u{110D}\u{1172}\u{11B7}"),
    ("\u{CBC9}", "\u{CBC9}", "\u{110D}\u{1172}\u{11B8}", "\u{CBC9}", "\u{110D}\u{1172}\u{11B8}"),
    ("\u{CBCA}", "\u{CBCA}", "\u{110D}\u{1172}\u{11B9}", "\u{CBCA}", "\u{110D}\u{1172}\u{11B9}"),
    ("\u{CBCB}", "\u{CBCB}", "\u{110D}\u{1172}\u{11BA}", "\u{CBCB}", "\u{110D}\u{1172}\u{11BA}"),
    ("\u{CBCC}", "\u{CBCC}", "\u{110D}\u{1172}\u{11BB}", "\u{CBCC}", "\u{110D}\u{1172}\u{11BB}"),
    ("\u{CBCD}", "\u{CBCD}", "\u{110D}\u{1172}\u{11BC}", "\u{CBCD}", "\u{110D}\u{1172}\u{11BC}"),
    ("\u{CBCE}", "\u{CBCE}", "\u{110D}\u{1172}\u{11BD}", "\u{CBCE}", "\u{110D}\u{1172}\u{11BD}"),
    ("\u{CBCF}", "\u{CBCF}", "\u{110D}\u{1172}\u{11BE}", "\u{CBCF}", "\u{110D}\u{1172}\u{11BE}"),
    ("\u{CBD0}", "\u{CBD0}", "\u{110D}\u{1172}\u{11BF}", "\u{CBD0}", "\u{110D}\u{1172}\u{11BF}"),
    ("\u{CBD1}", "\u{CBD1}", "\u{110D}\u{1172}\u{11C0}", "\u{CBD1}", "\u{110D}\u{1172}\u{11C0}"),
    ("\u{CBD2}", "\u{CBD2}", "\u{110D}\u{1172}\u{11C1}", "\u{CBD2}", "\u{110D}\u{1172}\u{11C1}"),
    ("\u{CBD3}", "\u{CBD3}", "\u{110D}\u{1172}\u{11C2}", "\u{CBD3}", "\u{110D}\u{1172}\u{11C2}"),
    ("\u{CBD4}", "\u{CBD4}", "\u{110D}\u{1173}", "\u{CBD4}", "\u{110D}\u{1173}"),
    ("\u{CBD5}", "\u{CBD5}", "\u{110D}\u{1173}\u{11A8}", "\u{CBD5}", "\u{110D}\u{1173}\u{11A8}"),
    ("\u{CBD6}", "\u{CBD6}", "\u{110D}\u{1173}\u{11A9}", "\u{CBD6}", "\u{110D}\u{1173}\u{11A9}"),
    ("\u{CBD7}", "\u{CBD7}", "\u{110D}\u{1173}\u{11AA}", "\u{CBD7}", "\u{110D}\u{1173}\u{11AA}"),
    ("\u{CBD8}", "\u{CBD8}", "\u{110D}\u{1173}\u{11AB}", "\u{CBD8}", "\u{110D}\u{1173}\u{11AB}"),
    ("\u{CBD9}", "\u{CBD9}", "\u{110D}\u{1173}\u{11AC}", "\u{CBD9}", "\u{110D}\u{1173}\u{11AC}"),
    ("\u{CBDA}", "\u{CBDA}", "\u{110D}\u{1173}\u{11AD}", "\u{CBDA}", "\u{110D}\u{1173}\u{11AD}"),
    ("\u{CBDB}", "\u{CBDB}", "\u{110D}\u{1173}\u{11AE}", "\u{CBDB}", "\u{110D}\u{1173}\u{11AE}"),
    ("\u{CBDC}", "\u{CBDC}", "\u{110D}\u{1173}\u{11AF}", "\u{CBDC}", "\u{110D}\u{1173}\u{11AF}"),
    ("\u{CBDD}", "\u{CBDD}", "\u{110D}\u{1173}\u{11B0}", "\u{CBDD}", "\u{110D}\u{1173}\u{11B0}"),
    ("\u{CBDE}", "\u{CBDE}", "\u{110D}\u{1173}\u{11B1}", "\u{CBDE}", "\u{110D}\u{1173}\u{11B1}"),
    ("\u{CBDF}", "\u{CBDF}", "\u{110D}\u{1173}\u{11B2}", "\u{CBDF}", "\u{110D}\u{1173}\u{11B2}"),
    ("\u{CBE0}", "\u{CBE0}", "\u{110D}\u{1173}\u{11B3}", "\u{CBE0}", "\u{110D}\u{1173}\u{11B3}"),
    ("\u{CBE1}", "\u{CBE1}", "\u{110D}\u{1173}\u{11B4}", "\u{CBE1}", "\u{110D}\u{1173}\u{11B4}"),
    ("\u{CBE2}", "\u{CBE2}", "\u{110D}\u{1173}\u{11B5}", "\u{CBE2}", "\u{110D}\u{1173}\u{11B5}"),
    ("\u{CBE3}", "\u{CBE3}", "\u{110D}\u{1173}\u{11B6}", "\u{CBE3}", "\u{110D}\u{1173}\u{11B6}"),
    ("\u{CBE4}", "\u{CBE4}", "\u{110D}\u{1173}\u{11B7}", "\u{CBE4}", "\u{110D}\u{1173}\u{11B7}"),
    ("\u{CBE5}", "\u{CBE5}", "\u{110D}\u{1173}\u{11B8}", "\u{CBE5}", "\u{110D}\u{1173}\u{11B8}"),
    ("\u{CBE6}", "\u{CBE6}", "\u{110D}\u{1173}\u{11B9}", "\u{CBE6}", "\u{110D}\u{1173}\u{11B9}"),
    ("\u{CBE7}", "\u{CBE7}", "\u{110D}\u{1173}\u{11BA}", "\u{CBE7}", "\u{110D}\u{1173}\u{11BA}"),
    ("\u{CBE8}", "\u{CBE8}", "\u{110D}\u{1173}\u{11BB}", "\u{CBE8}", "\u{110D}\u{1173}\u{11BB}"),
    ("\u{CBE9}", "\u{CBE9}", "\u{110D}\u{1173}\u{11BC}", "\u{CBE9}", "\u{110D}\u{1173}\u{11BC}"),
    ("\u{CBEA}", "\u{CBEA}", "\u{110D}\u{1173}\u{11BD}", "\u{CBEA}", "\u{110D}\u{1173}\u{11BD}"),
    ("\u{CBEB}", "\u{CBEB}", "\u{110D}\u{1173}\u{11BE}", "\u{CBEB}", "\u{110D}\u{1173}\u{11BE}"),
    ("\u{CBEC}", "\u{CBEC}", "\u{110D}\u{1173}\u{11BF}", "\u{CBEC}", "\u{110D}\u{1173}\u{11BF}"),
    ("\u{CBED}", "\u{CBED}", "\u{110D}\u{1173}\u{11C0}", "\u{CBED}", "\u{110D}\u{1173}\u{11C0}"),
    ("\u{CBEE}", "\u{CBEE}", "\u{110D}\u{1173}\u{11C1}", "\u{CBEE}", "\u{110D}\u{1173}\u{11C1}"),
    ("\u{CBEF}", "\u{CBEF}", "\u{110D}\u{1173}\u{11C2}", "\u{CBEF}", "\u{110D}\u{1173}\u{11C2}"),
    ("\u{CBF0}", "\u{CBF0}", "\u{110D}\u{1174}", "\u{CBF0}", "\u{110D}\u{1174}"),
    ("\u{CBF1}", "\u{CBF1}", "\u{110D}\u{1174}\u{11A8}", "\u{CBF1}", "\u{110D}\u{1174}\u{11A8}"),
    ("\u{CBF2}", "\u{CBF2}", "\u{110D}\u{1174}\u{11A9}", "\u{CBF2}", "\u{110D}\u{1174}\u{11A9}"),
    ("\u{CBF3}", "\u{CBF3}", "\u{110D}\u{1174}\u{11AA}", "\u{CBF3}", "\u{110D}\u{1174}\u{11AA}"),
    ("\u{CBF4}", "\u{CBF4}", "\u{110D}\u{1174}\u{11AB}", "\u{CBF4}", "\u{110D}\u{1174}\u{11AB}"),
    ("\u{CBF5}", "\u{CBF5}", "\u{110D}\u{1174}\u{11AC}", "\u{CBF5}", "\u{110D}\u{1174}\u{11AC}"),
    ("\u{CBF6}", "\u{CBF6}", "\u{110D}\u{1174}\u{11AD}", "\u{CBF6}", "\u{110D}\u{1174}\u{11AD}"),
    ("\u{CBF7}", "\u{CBF7}", "\u{110D}\u{1174}\u{11AE}", "\u{CBF7}", "\u{110D}\u{1174}\u{11AE}"),
    ("\u{CBF8}", "\u{CBF8}", "\u{110D}\u{1174}\u{11AF}", "\u{CBF8}", "\u{110D}\u{1174}\u{11AF}"),
    ("\u{CBF9}", "\u{CBF9}", "\u{110D}\u{1174}\u{11B0}", "\u{CBF9}", "\u{110D}\u{1174}\u{11B0}"),
    ("\u{CBFA}", "\u{CBFA}", "\u{110D}\u{1174}\u{11B1}", "\u{CBFA}", "\u{110D}\u{1174}\u{11B1}"),
    ("\u{CBFB}", "\u{CBFB}", "\u{110D}\u{1174}\u{11B2}", "\u{CBFB}", "\u{110D}\u{1174}\u{11B2}"),
    ("\u{CBFC}", "\u{CBFC}", "\u{110D}\u{1174}\u{11B3}", "\u{CBFC}", "\u{110D}\u{1174}\u{11B3}"),
    ("\u{CBFD}", "\u{CBFD}", "\u{110D}\u{1174}\u{11B4}", "\u{CBFD}", "\u{110D}\u{1174}\u{11B4}"),
    ("\u{CBFE}", "\u{CBFE}", "\u{110D}\u{1174}\u{11B5}", "\u{CBFE}", "\u{110D}\u{1174}\u{11B5}"),
    ("\u{CBFF}", "\u{CBFF}", "\u{110D}\u{1174}\u{11B6}", "\u{CBFF}", "\u{110D}\u{1174}\u{11B6}"),
    ("\u{CC00}", "\u{CC00}", "\u{110D}\u{1174}\u{11B7}", "\u{CC00}", "\u{110D}\u{1174}\u{11B7}"),
    ("\u{CC01}", "\u{CC01}", "\u{110D}\u{1174}\u{11B8}", "\u{CC01}", "\u{110D}\u{1174}\u{11B8}"),
    ("\u{CC02}", "\u{CC02}", "\u{110D}\u{1174}\u{11B9}", "\u{CC02}", "\u{110D}\u{1174}\u{11B9}"),
    ("\u{CC03}", "\u{CC03}", "\u{110D}\u{1174}\u{11BA}", "\u{CC03}", "\u{110D}\u{1174}\u{11BA}"),
    ("\u{CC04}", "\u{CC04}", "\u{110D}\u{1174}\u{11BB}", "\u{CC04}", "\u{110D}\u{1174}\u{11BB}"),
    ("\u{CC05}", "\u{CC05}", "\u{110D}\u{1174}\u{11BC}", "\u{CC05}", "\u{110D}\u{1174}\u{11BC}"),
    ("\u{CC06}", "\u{CC06}", "\u{110D}\u{1174}\u{11BD}", "\u{CC06}", "\u{110D}\u{1174}\u{11BD}"),
    ("\u{CC07}", "\u{CC07}", "\u{110D}\u{1174}\u{11BE}", "\u{CC07}", "\u{110D}\u{1174}\u{11BE}"),
    ("\u{CC08}", "\u{CC08}", "\u{110D}\u{1174}\u{11BF}", "\u{CC08}", "\u{110D}\u{1174}\u{11BF}"),
    ("\u{CC09}", "\u{CC09}", "\u{110D}\u{1174}\u{11C0}", "\u{CC09}", "\u{110D}\u{1174}\u{11C0}"),
    ("\u{CC0A}", "\u{CC0A}", "\u{110D}\u{1174}\u{11C1}", "\u{CC0A}", "\u{110D}\u{1174}\u{11C1}"),
    ("\u{CC0B}", "\u{CC0B}", "\u{110D}\u{1174}\u{11C2}", "\u{CC0B}", "\u{110D}\u{1174}\u{11C2}"),
    ("\u{CC0C}", "\u{CC0C}", "\u{110D}\u{1175}", "\u{CC0C}", "\u{110D}\u{1175}"),
    ("\u{CC0D}", "\u{CC0D}", "\u{110D}\u{1175}\u{11A8}", "\u{CC0D}", "\u{110D}\u{1175}\u{11A8}"),
    ("\u{CC0E}", "\u{CC0E}", "\u{110D}\u{1175}\u{11A9}", "\u{CC0E}", "\u{110D}\u{1175}\u{11A9}"),
    ("\u{CC0F}", "\u{CC0F}", "\u{110D}\u{1175}\u{11AA}", "\u{CC0F}", "\u{110D}\u{1175}\u{11AA}"),
    ("\u{CC10}", "\u{CC10}", "\u{110D}\u{1175}\u{11AB}", "\u{CC10}", "\u{110D}\u{1175}\u{11AB}"),
    ("\u{CC11}", "\u{CC11}", "\u{110D}\u{1175}\u{11AC}", "\u{CC11}", "\u{110D}\u{1175}\u{11AC}"),
    ("\u{CC12}", "\u{CC12}", "\u{110D}\u{1175}\u{11AD}", "\u{CC12}", "\u{110D}\u{1175}\u{11AD}"),
    ("\u{CC13}", "\u{CC13}", "\u{110D}\u{1175}\u{11AE}", "\u{CC13}", "\u{110D}\u{1175}\u{11AE}"),
    ("\u{CC14}", "\u{CC14}", "\u{110D}\u{1175}\u{11AF}", "\u{CC14}", "\u{110D}\u{1175}\u{11AF}"),
    ("\u{CC15}", "\u{CC15}", "\u{110D}\u{1175}\u{11B0}", "\u{CC15}", "\u{110D}\u{1175}\u{11B0}"),
    ("\u{CC16}", "\u{CC16}", "\u{110D}\u{1175}\u{11B1}", "\u{CC16}", "\u{110D}\u{1175}\u{11B1}"),
    ("\u{CC17}", "\u{CC17}", "\u{110D}\u{1175}\u{11B2}", "\u{CC17}", "\u{110D}\u{1175}\u{11B2}"),
    ("\u{CC18}", "\u{CC18}", "\u{110D}\u{1175}\u{11B3}", "\u{CC18}", "\u{110D}\u{1175}\u{11B3}"),
    ("\u{CC19}", "\u{CC19}", "\u{110D}\u{1175}\u{11B4}", "\u{CC19}", "\u{110D}\u{1175}\u{11B4}"),
    ("\u{CC1A}", "\u{CC1A}", "\u{110D}\u{1175}\u{11B5}", "\u{CC1A}", "\u{110D}\u{1175}\u{11B5}"),
    ("\u{CC1B}", "\u{CC1B}", "\u{110D}\u{1175}\u{11B6}", "\u{CC1B}", "\u{110D}\u{1175}\u{11B6}"),
    ("\u{CC1C}", "\u{CC1C}", "\u{110D}\u{1175}\u{11B7}", "\u{CC1C}", "\u{110D}\u{1175}\u{11B7}"),
    ("\u{CC1D}", "\u{CC1D}", "\u{110D}\u{1175}\u{11B8}", "\u{CC1D}", "\u{110D}\u{1175}\u{11B8}"),
    ("\u{CC1E}", "\u{CC1E}", "\u{110D}\u{1175}\u{11B9}", "\u{CC1E}", "\u{110D}\u{1175}\u{11B9}"),
    ("\u{CC1F}", "\u{CC1F}", "\u{110D}\u{1175}\u{11BA}", "\u{CC1F}", "\u{110D}\u{1175}\u{11BA}"),
    ("\u{CC20}", "\u{CC20}", "\u{110D}\u{1175}\u{11BB}", "\u{CC20}", "\u{110D}\u{1175}\u{11BB}"),
    ("\u{CC21}", "\u{CC21}", "\u{110D}\u{1175}\u{11BC}", "\u{CC21}", "\u{110D}\u{1175}\u{11BC}"),
    ("\u{CC22}", "\u{CC22}", "\u{110D}\u{1175}\u{11BD}", "\u{CC22}", "\u{110D}\u{1175}\u{11BD}"),
    ("\u{CC23}", "\u{CC23}", "\u{110D}\u{1175}\u{11BE}", "\u{CC23}", "\u{110D}\u{1175}\u{11BE}"),
    ("\u{CC24}", "\u{CC24}", "\u{110D}\u{1175}\u{11BF}", "\u{CC24}", "\u{110D}\u{1175}\u{11BF}"),
    ("\u{CC25}", "\u{CC25}", "\u{110D}\u{1175}\u{11C0}", "\u{CC25}", "\u{110D}\u{1175}\u{11C0}"),
    ("\u{CC26}", "\u{CC26}", "\u{110D}\u{1175}\u{11C1}", "\u{CC26}", "\u{110D}\u{1175}\u{11C1}"),
    ("\u{CC27}", "\u{CC27}", "\u{110D}\u{1175}\u{11C2}", "\u{CC27}", "\u{110D}\u{1175}\u{11C2}"),
    ("\u{CC28}", "\u{CC28}", "\u{110E}\u{1161}", "\u{CC28}", "\u{110E}\u{1161}"),
    ("\u{CC29}", "\u{CC29}", "\u{110E}\u{1161}\u{11A8}", "\u{CC29}", "\u{110E}\u{1161}\u{11A8}"),
    ("\u{CC2A}", "\u{CC2A}", "\u{110E}\u{1161}\u{11A9}", "\u{CC2A}", "\u{110E}\u{1161}\u{11A9}"),
    ("\u{CC2B}", "\u{CC2B}", "\u{110E}\u{1161}\u{11AA}", "\u{CC2B}", "\u{110E}\u{1161}\u{11AA}"),
    ("\u{CC2C}", "\u{CC2C}", "\u{110E}\u{1161}\u{11AB}", "\u{CC2C}", "\u{110E}\u{1161}\u{11AB}"),
    ("\u{CC2D}", "\u{CC2D}", "\u{110E}\u{1161}\u{11AC}", "\u{CC2D}", "\u{110E}\u{1161}\u{11AC}"),
    ("\u{CC2E}", "\u{CC2E}", "\u{110E}\u{1161}\u{11AD}", "\u{CC2E}", "\u{110E}\u{1161}\u{11AD}"),
    ("\u{CC2F}", "\u{CC2F}", "\u{110E}\u{1161}\u{11AE}", "\u{CC2F}", "\u{110E}\u{1161}\u{11AE}"),
    ("\u{CC30}", "\u{CC30}", "\u{110E}\u{1161}\u{11AF}", "\u{CC30}", "\u{110E}\u{1161}\u{11AF}"),
    ("\u{CC31}", "\u{CC31}", "\u{110E}\u{1161}\u{11B0}", "\u{CC31}", "\u{110E}\u{1161}\u{11B0}"),
    ("\u{CC32}", "\u{CC32}", "\u{110E}\u{1161}\u{11B1}", "\u{CC32}", "\u{110E}\u{1161}\u{11B1}"),
    ("\u{CC33}", "\u{CC33}", "\u{110E}\u{1161}\u{11B2}", "\u{CC33}", "\u{110E}\u{1161}\u{11B2}"),
    ("\u{CC34}", "\u{CC34}", "\u{110E}\u{1161}\u{11B3}", "\u{CC34}", "\u{110E}\u{1161}\u{11B3}"),
    ("\u{CC35}", "\u{CC35}", "\u{110E}\u{1161}\u{11B4}", "\u{CC35}", "\u{110E}\u{1161}\u{11B4}"),
    ("\u{CC36}", "\u{CC36}", "\u{110E}\u{1161}\u{11B5}", "\u{CC36}", "\u{110E}\u{1161}\u{11B5}"),
    ("\u{CC37}", "\u{CC37}", "\u{110E}\u{1161}\u{11B6}", "\u{CC37}", "\u{110E}\u{1161}\u{11B6}"),
    ("\u{CC38}", "\u{CC38}", "\u{110E}\u{1161}\u{11B7}", "\u{CC38}", "\u{110E}\u{1161}\u{11B7}"),
    ("\u{CC39}", "\u{CC39}", "\u{110E}\u{1161}\u{11B8}", "\u{CC39}", "\u{110E}\u{1161}\u{11B8}"),
    ("\u{CC3A}", "\u{CC3A}", "\u{110E}\u{1161}\u{11B9}", "\u{CC3A}", "\u{110E}\u{1161}\u{11B9}"),
    ("\u{CC3B}", "\u{CC3B}", "\u{110E}\u{1161}\u{11BA}", "\u{CC3B}", "\u{110E}\u{1161}\u{11BA}"),
    ("\u{CC3C}", "\u{CC3C}", "\u{110E}\u{1161}\u{11BB}", "\u{CC3C}", "\u{110E}\u{1161}\u{11BB}"),
    ("\u{CC3D}", "\u{CC3D}", "\u{110E}\u{1161}\u{11BC}", "\u{CC3D}", "\u{110E}\u{1161}\u{11BC}"),
    ("\u{CC3E}", "\u{CC3E}", "\u{110E}\u{1161}\u{11BD}", "\u{CC3E}", "\u{110E}\u{1161}\u{11BD}"),
    ("\u{CC3F}", "\u{CC3F}", "\u{110E}\u{1161}\u{11BE}", "\u{CC3F}", "\u{110E}\u{1161}\u{11BE}"),
    ("\u{CC40}", "\u{CC40}", "\u{110E}\u{1161}\u{11BF}", "\u{CC40}", "\u{110E}\u{1161}\u{11BF}"),
    ("\u{CC41}", "\u{