use crate::unicode::props::Dt;
use crate::collections::TwoStageTable;

const STAGE_1: [u8; 4352] = [
    0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14,
    15, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 16, 7, 17, 18, 19,
    20, 21, 22, 23, 24, 7, 7, 7, 7, 7, 25, 7, 26, 27, 28, 29,
    30, 31, 32, 33, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 34, 35, 7, 7, 7, 36, 37, 37, 37, 37,
    37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
    37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37,
    37, 37, 37, 37, 37, 37, 37, 38, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 37, 39, 40, 41, 42, 43, 44,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    45, 46, 7, 47, 48, 49, 7, 7, 7, 50, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 51, 7, 7, 52, 53, 54, 55, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 56, 7,
    7, 57, 58, 7, 7, 7, 7, 7, 7, 7, 7, 59, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 37, 37, 60, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
];

const STAGE_2: &[&[Dt]] = &[
    &[
        // Block 0
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Nb, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Com, Dt::None, Dt::Sup, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com,
        Dt::None, Dt::None, Dt::Sup, Dt::Sup, Dt::Com, Dt::Com, Dt::None, Dt::None,
        Dt::Com, Dt::Sup, Dt::Sup, Dt::None, Dt::Fra, Dt::Fra, Dt::Fra, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can,
    ],
    &[
        // Block 1
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::None, Dt::Com, Dt::Com, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Com,
        Dt::Com, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Com, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can,
        Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Com, Dt::Com, Dt::Com, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
    ],
    &[
        // Block 2
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::None, Dt::None,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 3
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::Com, Dt::Com, Dt::Com, Dt::Can, Dt::Can, Dt::Com, Dt::Com, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Com, Dt::Com, Dt::Com, Dt::None, Dt::Com, Dt::Com, Dt::None, Dt::None,
        Dt::None, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 4
        Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 5
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 6
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 7
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 8
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 9
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 10
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 11
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can,
        Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 12
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 13
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 14
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Nb, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::Com,
        Dt::Can, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 15
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Sup, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 16
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 17
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Sup, Dt::Sup, Dt::Sup, Dt::None,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::None, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::None, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub,
        Dt::Sub, Dt::Sub, Dt::Sub, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Sup, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 18
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Com, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 19
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Com, Dt::Can, Dt::Com,
        Dt::Com, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Com, Dt::None,
    ],
    &[
        // Block 20
        Dt::Can, Dt::Can, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Nb,
        Dt::Com, Dt::Com, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Nb, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::Com, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Nb,
        Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::None, Dt::Com, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::None, Dt::Com, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com,
        Dt::Com, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Sup, Dt::Sup, Dt::None, Dt::None, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub,
        Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::None,
        Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub,
        Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::Sub, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 21
        Dt::Com, Dt::Com, Dt::Font, Dt::Com, Dt::None, Dt::Com, Dt::Com, Dt::Com,
        Dt::None, Dt::Com, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Com, Dt::None,
        Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::None,
        Dt::Sup, Dt::Com, Dt::Sup, Dt::None, Dt::Font, Dt::None, Dt::Can, Dt::None,
        Dt::Font, Dt::None, Dt::Can, Dt::Can, Dt::Font, Dt::Font, Dt::None, Dt::Font,
        Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Font, Dt::None, Dt::Com, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra,
        Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra, Dt::Fra,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Fra, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 22
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::None, Dt::Com,
        Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 23
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 24
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 25
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::Com, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 26
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Sub, Dt::Sup, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 27
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Sup,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 28
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 29
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 30
        Dt::Wide, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Com, Dt::None,
        Dt::Com, Dt::Com, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can,
        Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::None, Dt::Can, Dt::Vert,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can,
        Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can,
        Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Vert,
    ],
    &[
        // Block 31
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::None,
        Dt::None, Dt::None, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 32
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::None,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Sqr, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::None,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc,
        Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Sqr,
    ],
    &[
        // Block 33
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Sqr,
    ],
    &[
        // Block 34
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Sup, Dt::Sup, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 35
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Sup, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Sup, Dt::Sup, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 36
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::Sup, Dt::Sup, Dt::Sup, Dt::Sup,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Sup, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 37
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
    ],
    &[
        // Block 38
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 39
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 40
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Com,
        Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin,
        Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin,
        Dt::Iso, Dt::Fin, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso,
        Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Iso, Dt::Fin,
        Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med,
        Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin,
        Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin,
        Dt::Init, Dt::Iso, Dt::Fin, Dt::Init, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med,
    ],
    &[
        // Block 41
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Med,
        Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med,
        Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med,
        Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
    ],
    &[
        // Block 42
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Init, Dt::Init, Dt::Init,
        Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Med, Dt::Med, Dt::Med, Dt::Med,
        Dt::Med, Dt::Med, Dt::Med, Dt::Med, Dt::Fin, Dt::Iso, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Init, Dt::Fin, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::Fin, Dt::Init, Dt::Fin, Dt::Fin, Dt::Init, Dt::Init, Dt::Fin, Dt::Fin,
        Dt::Init, Dt::Init, Dt::Fin, Dt::Init, Dt::Fin, Dt::Init, Dt::Fin, Dt::Fin,
        Dt::Init, Dt::Fin, Dt::Fin, Dt::Init, Dt::Fin, Dt::Init, Dt::Fin, Dt::Fin,
        Dt::Init, Dt::Fin, Dt::Init, Dt::Init, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Init,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Init, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Init, Dt::Fin, Dt::Fin, Dt::Init, Dt::Fin,
        Dt::Init, Dt::Init, Dt::Init, Dt::Fin, Dt::Init, Dt::Init, Dt::Init, Dt::Init,
        Dt::None, Dt::None, Dt::Init, Dt::Init, Dt::Init, Dt::Init, Dt::Fin, Dt::Fin,
        Dt::Init, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Init, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Init, Dt::Init, Dt::Fin, Dt::Fin,
        Dt::Init, Dt::Fin, Dt::Init, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin, Dt::Fin,
        Dt::Fin, Dt::Fin, Dt::Fin, Dt::Init, Dt::Init, Dt::Init, Dt::Fin, Dt::Fin,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso,
        Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::Iso, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 43
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert,
        Dt::Vert, Dt::Vert, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert,
        Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert,
        Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::Vert, Dt::None, Dt::None, Dt::Vert,
        Dt::Vert, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Sml, Dt::Sml, Dt::Sml, Dt::None, Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml,
        Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml,
        Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::None,
        Dt::Sml, Dt::Sml, Dt::Sml, Dt::Sml, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Iso, Dt::Med, Dt::Iso, Dt::None, Dt::Iso, Dt::None, Dt::Iso, Dt::Med,
        Dt::Iso, Dt::Med, Dt::Iso, Dt::Med, Dt::Iso, Dt::Med, Dt::Iso, Dt::Med,
        Dt::Iso, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso,
        Dt::Fin, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Iso,
        Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso,
        Dt::Fin, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Init,
        Dt::Med, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Iso,
        Dt::Fin, Dt::Iso, Dt::Fin, Dt::Init, Dt::Med, Dt::Iso, Dt::Fin, Dt::Iso,
        Dt::Fin, Dt::Iso, Dt::Fin, Dt::Iso, Dt::Fin, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 44
        Dt::None, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide,
        Dt::Wide, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::None,
        Dt::None, Dt::None, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::None, Dt::None, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::None, Dt::None, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar,
        Dt::None, Dt::None, Dt::Nar, Dt::Nar, Dt::Nar, Dt::None, Dt::None, Dt::None,
        Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::Wide, Dt::None,
        Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::Nar, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 45
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 46
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 47
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 48
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::Can, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 49
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 50
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 51
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 52
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font,
        Dt::None, Dt::None, Dt::Font, Dt::None, Dt::None, Dt::Font, Dt::Font, Dt::None,
        Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
    ],
    &[
        // Block 53
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::None, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::None,
        Dt::None, Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
    ],
    &[
        // Block 54
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::None,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
    ],
    &[
        // Block 55
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::None, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
    ],
    &[
        // Block 56
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::None, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::None, Dt::None, Dt::Font,
        Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::None, Dt::Font, Dt::None, Dt::Font, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Font, Dt::None, Dt::None, Dt::None, Dt::None, Dt::Font,
        Dt::None, Dt::Font, Dt::None, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font,
        Dt::None, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::None, Dt::None, Dt::Font,
        Dt::None, Dt::Font, Dt::None, Dt::Font, Dt::None, Dt::Font, Dt::None, Dt::Font,
        Dt::None, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::None, Dt::None, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::None,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::None, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 57
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::Com, Dt::Com, Dt::Enc, Dt::Enc, Dt::Enc, Dt::Enc, Dt::None,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::Sup, Dt::Sup, Dt::Sup, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Sqr, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 58
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr,
        Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::Sqr, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com, Dt::Com,
        Dt::Com, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Enc, Dt::Enc, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 59
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font, Dt::Font,
        Dt::Font, Dt::Font, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
    &[
        // Block 60
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can,
        Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::Can, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
        Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None, Dt::None,
    ],
];

pub(crate) fn dt(cp: u32) -> Dt {
    let tst: TwoStageTable<Dt, u8> = TwoStageTable::new(&STAGE_1, STAGE_2, 256);
    tst.at(cp)
}
