use std::fs;
use chrono::{Datelike, Timelike, Local};

fn main() { 
    println!("cargo:rerun-if-changed=build.rs");
    let months = ["January","February","March","April","May","June","July","August","September","October","November","December"];
    let date = Local::now().date();
    let month = months[date.month() as usize - 1];
    let day = date.day();
    let year = date.year();

    let date_str = format!("{} {} {}",day, month, year);

    let time = Local::now().time();
    let hour = time.hour();
    let minute = time.minute();
    let second = time.second(); 

    let time_str = format!("{:02}:{:02}:{:02}",hour,minute,second);

    let servermancli_manpage = format!(".\\\" Manpage for servermancli (part of Minecraft Server Manager).
.\\\" Created on {} {}, {} at {}

.TH servermancli 1 \"{}\" \"{}\" \"servermancli man page\"
.SH NAME
servermancli \\- Command line interface for Minecraft Server Manager
.SH SYNOPSIS
servermancli setup
.br
servermancli setup-forge
.br
servermancli launch <name>
.br
servermancli restart <name>
.br
servermancli console <name>
.br
servermancli remove <name>
.br
servermancli config <name> [option] [key] [new value]
.br
servermancli servers
.br
servermancli version

.SH DESCRIPTION
Manage your Minecraft servers easily from the command line

.SH OPTIONS
setup: set up a new vanilla Minecraft server
.br
setup-forge: set up a new server with Minecraft Forge installed
.br
launch <name>: Launch a specified server
.br
restart <name>: Restart a specified server
.br
console <name>: Show the console of a specified server
.br
remove <name>: Deletes a specified server. Please use this carefully because it cannot be undone!
.br
config <name> [option] [key] [new value]: Get or set the configuration (server.properties) of a specified server
.br
Minecraft server config options:
.br
    <name> set <key name> <new value>: sets a config key to a new value
.br
    <name> get <key name>: get a config key value
.br
    keys: list all config keys
.br

.br
servers: List all know Minecraft servers
.br
version: Show this program's version

.SH EXAMPLES
Create a new vanilla server: servermancli setup
.br
Create a new Minecraft forge server: servermancli setup-forge

.SH SEE ALSO
servermand(1)
.br
serverman(1)

.SH AUTHOR
Noah Jelen (noahtjelen@gmail.com)", month, day, year, time_str, date_str, env!("CARGO_PKG_VERSION"));

    let servermand_manpage = format!(".\\\" Manpage for servermand (part of serverman).
.\\\" Created on {} {}, {} at {}
.TH servermand 1 \"{}\" \"{}\" \"servermand man page\"
.SH NAME
servermand \\- Background process for Minecraft Server Manager
.SH DESCRIPTION
This is the main process for the Minecraft Server Manager program. This process must be started for the program to be usable!

.SH EXAMPLES
start from systemd: systemctl start --user servermand
.br
start upon first login using systemd: systemctl enable --user servermand
.br
start manually (as background process): servermand &

.SH SEE ALSO
servermancli(1)
.br
serverman(1)

.SH AUTHOR
Noah Jelen (noahtjelen@gmail.com)", month, day, year, time_str, date_str, env!("CARGO_PKG_VERSION"));

let serverman_manpage = format!(".\\\" Manpage for serverman (part of serverman).
.\\\" Created on {} {}, {} at {}
.TH serverman 1 \"{}\" \"{}\" \"serverman man page\"
.SH NAME
serverman \\- Minecraft Server Manager
.SH DESCRIPTION
This is the text interface for the Minecraft Server Manager. It can be used to view server consoles, crash reports, and start/stop servers.

.SH SEE ALSO
servermancli(1)
.br
serverman(1)

.SH AUTHOR
Noah Jelen (noahtjelen@gmail.com)", month, day, year, time_str, date_str, env!("CARGO_PKG_VERSION"));

    let aur_pkgbuild = format!("# Maintainer: Noah Jelen <noahtjelen@gmail.com>
# Generated by cargo on {} {}, {} at {}
pkgname=serverman
pkgver={}
pkgrel=1
pkgdesc=\"Minecraft Server Management program\"
arch=(\'i686' 'x86_64\')
url=\"https://gitlab.com/NoahJelen/serverman\"
license=(\'GPL\')
depends=(\'ncurses\' \'gcc-libs\' \'glibc\')
makedepends=(\'cargo\' \'gzip\')
source=(\"https://gitlab.com/NoahJelen/serverman/-/archive/$pkgver/serverman-$pkgver.zip\")
md5sums=(\'SKIP\')

build() {{
    cd \"serverman-$pkgver\"
    cargo build --release
    cd target/release
    ln -sf servermand serverman
    ln -sf servermand servermancli
}}

package() {{
    cd \"serverman-$pkgver\"
    mkdir -p \"$pkgdir/usr/share/man/man1/\"
    mkdir -p \"$pkgdir/usr/lib/systemd/user\"
    install -Dt \"$pkgdir/usr/bin\" -m755 target/release/serverman
    install -Dt \"$pkgdir/usr/bin\" -m755 target/release/servermancli
    install -Dt \"$pkgdir/usr/bin\" -m755 target/release/servermand
    install -Dt \"$pkgdir/usr/share/man/man1\" man/servermancli.1
    install -Dt \"$pkgdir/usr/share/man/man1\" man/servermand.1
    install -Dt \"$pkgdir/usr/share/man/man1\" man/serverman.1
    install -Dt \"$pkgdir/usr/lib/systemd/user\" servermand.service
    gzip \"$pkgdir/usr/share/man/man1/servermand.1\"
    gzip \"$pkgdir/usr/share/man/man1/serverman.1\"
    gzip \"$pkgdir/usr/share/man/man1/servermancli.1\"
}}", month, day, year, time_str, env!("CARGO_PKG_VERSION"));

    fs::remove_file("aur/PKGBUILD").unwrap_or(());
    fs::remove_file("man/servermancli.1").unwrap_or(());
    fs::remove_file("man/servermand.1").unwrap_or(());
    fs::remove_file("man/serverman.1").unwrap_or(());
    fs::remove_dir("man/").unwrap_or(());
    
    fs::write("aur/PKGBUILD", aur_pkgbuild).unwrap_or(());
    fs::create_dir("man/").unwrap_or(());
    fs::write("man/servermancli.1", servermancli_manpage).unwrap();
    fs::write("man/servermand.1", servermand_manpage).unwrap();
    fs::write("man/serverman.1", serverman_manpage).unwrap();
}