![Bycicle](https://external-content.duckduckgo.com/iu/?u=https%3A%2F%2Ficonsplace.com%2Fwp-content%2Fuploads%2F_icons%2F000000%2F256%2Fpng%2Fbicycle-icon-256.png&f=1&nofb=1)
# Introduction 
"Backend framework" for creating controller-based backend.

# Implemented features
- mongo driver wrapper
- thread-pool based multithreading request handling
- support of get, post, put, update, delete method of rest on controllers

# Not implemented features
- middleware processing
- a lot of other
- properly working request parsing

# Usage
For now `server` struct from lib can be use only in static context like this:
```
lazy_static! {
    static ref SERVER: ApiServer = ApiServer::new(
        ApiSettings::new("127.0.0.1", "4444", 2048),
        vec![Box::new(UserController::new(
            "mongodb://localhost:27017",
            "mydb",
            "users",
        ))]
    );
}

fn main() {
    SERVER.start();
}
```