//! # mio-serial - Serial port I/O for mio
//!
//! This crate provides a serial port implementation compatable with mio.
//!
//! **Windows support is present but largely untested by the author**
//!
//! ## Links
//!   - repo:  <https://github.com/berkowski/mio-serial>
//!   - docs:  <https://docs.rs/mio-serial>
#![deny(missing_docs)]
#![warn(rust_2018_idioms)]

#[cfg(feature = "tokio")]
extern crate tokio_crate as tokio;

// Enums, Structs, and Traits from the serialport crate
pub use serialport::{
    ClearBuffer, DataBits, Error, ErrorKind, FlowControl, Parity, SerialPort, SerialPortInfo,
    StopBits,
};

// Re-export port-enumerating utility function.
pub use serialport::available_ports;

#[cfg(unix)]
pub mod unix;

#[cfg(windows)]
pub mod windows;

#[cfg(unix)]
pub use unix::Serial;

#[cfg(all(unix, feature = "tokio"))]
pub use unix::tokio::AsyncSerial;

#[cfg(windows)]
pub use windows::Serial;

/// A type for results generated by interacting with serial ports.
pub type Result<T> = serialport::Result<T>;
