// This file is Copyright its original authors, visible in version control
// history.
//
// This file is licensed under the Apache License, Version 2.0 <LICENSE-APACHE
// or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// You may not use this file except in accordance with one or both of these
// licenses.

//! serde-bolt - a Bitcoin Lightning serializer / deserializer for BOLT style messages

#![cfg_attr(all(not(feature = "std"), not(test)), no_std)]
#![deny(missing_docs)]
#![deny(unsafe_code)]

extern crate alloc;

/// Deserialize
pub mod de;
/// Errors
pub mod error;
/// Serialize
pub mod ser;
/// Utility types used for both directions
pub mod types;

pub use crate::de::{from_vec, Deserializer};
pub use crate::error::{Error, Result};
pub use crate::ser::{to_writer, to_vec, Serializer};
