use serde::Deserialize;

use serde_json::from_str;

use serde_util::MayBe;

#[test]
fn test_is_t() {
    let json = "256";
    assert!(from_str::<MayBe<f64>>(json).unwrap().is());
}

#[test]
fn test_is_not_t() {
    let json = "{}";
    assert!(from_str::<MayBe<f64>>(json).unwrap().is_not());
}

#[test]
fn test_is_missing() {
    #[derive(Deserialize)]
    struct Foo {
        #[serde(rename = "bar")]
        _bar: MayBe<f64>,
    }
    let json = "{}";
    assert!(from_str::<Foo>(json).is_err());
}

#[test]
fn test_t_in_struct() {
    #[derive(Deserialize)]
    struct Foo {
        bar: MayBe<f64>,
    }
    let json = "{\"bar\": 123}";
    assert!(from_str::<Foo>(json).unwrap().bar.is());
}


#[test]
fn test_not_t_in_struct() {
    #[derive(Deserialize)]
    struct Foo {
        bar: MayBe<f64>,
    }
    let json = "{\"bar\": []}";
    assert!(from_str::<Foo>(json).unwrap().bar.is_not());
}
