use indexmap::IndexMap;

enum Value {
    None,

    Bool(bool),
    I8(i8),
    I16(i16),
    I32(i32),
    I64(i64),
    I128(i128),
    U8(u8),
    U16(u16),
    U32(u32),
    U64(u64),
    U128(u128),
    F32(f32),
    F64(f64),
    Char(char),

    String(String),
    Bytes(Vec<u8>),

    Seq(Vec<Value>),
    Map(IndexMap<String, Value>),
}
