# Change Log
All notable changes to this project will be documented in this file.
 
The format is based on [Keep a Changelog](http://keepachangelog.com/)

## [1.1.0] - 2022-03-28

### Added
- It is now possible to pass the `--skip-trello` flag (or `-s` in short) to generate a report that does not include Trello cards. 
Previously, setting a Trello API key and a server token would always include the Trello report; the new flag overrides this behaviour.

### Fixed
- The tool no longer breaks when the GitHub search response includes pull requests with assignees.
- If Trello authentication fails (e.g. expired server token), the program no longer terminates prematurely. Instead, an error message is displayed and the final report will not include Trello cards.

## [1.0.2] - 2022-03-20

### Fixed
- The tool no longer breaks when the GitHub search response includes issues.
 
 ## [1.0.1] - 2022-03-16

### Changed
- The name of the HTML file generated by the tool now includes the date on which it was created.

### Fixed
- The tool no longer breaks when GitHub milestones exist in a search result.
- The title of the HTML file no longer includes an incorrect `([object])` string.

## [1.0.0] - 2022-02-23

### Added
- 🎉 The tool now supports Trello integration. In order to make requests to the Trello API, authentication credentials can now be set with the `--trello-key` and `--trello-token` flags. The parameters are optional, and if neither is set, the tool will only generate a report containing GitHub pull requests. 
- To support Trello, new structs have been added to the `models` crate.
 
### Changed
- Credentials are now stored on disk with section nesting (`[GitHub]` for the GitHub personal access token, and `[Trello]` for the Trello API key and server token). In the previous version of the CLI, no hierarchy was defined and the GitHub auth token was stored in the general section. This means that you will have to re-authenticate with `--auth-token` when upgrading to v1.0.0.
- All CLI flags that require the user's input have now been changed from type `String` to `Option<String>` to allow the tool to run even when Trello credentials are not set.
- The Handlebars template now includes a section for Trello boards, which is conditionally rendered.


## [0.1.1] - 2022-02-16
 
### Added
- The tool now outputs descriptive status updates when running.
- The `GuardianPullRequests` enum now implements the `Display` trait.
 
### Changed
- In order to decrease the likelihood of hitting GitHub's secondary rate limit, the logic has been changed so that polling stops once the number of fetched items matches the number of the total items in the response. 
- The `Args` struct now lives in its own module (`cli.rs`).
- The `body` field in the `GithubSearchResponseItem` struct has been changed from a `String` type to an `Option<String>` type to account for empty PR descriptions.

### Fixed
- The new `body` type (`Option<String>`) means that execution no longer halts when encountering a pull request with an empty body.