// [Comprehensive list](https://www.w3schools.com/tags/ref_attributes.asp)
// [Aria attributes](https://www.w3.org/TR/html52/dom.html#state-and-property-attributes)

make_attrs! {
    // Missing data-*
    Accept => "accept", AcceptCharset => "accept-charset", AccessKey => "accesskey", Action => "action",
    Alt => "alt", Async => "async", AutoComplete => "autocomplete", AutoFocus => "autofocus",
    AutoPlay => "autoplay", Charset => "charset", Checked => "checked", Cite => "cite", Class => "class",
    Color => "color", Cols => "cols", ColSpan => "colspan", Content => "content", ContentEditable => "contenteditable",
    Controls => "controls", Coords => "coords", Data => "data", DateTime => "datetime", Default => "default",
    Defer => "defer", Dir => "dir", DirName => "dirname", Disabled => "disabled", Download => "download",
    Draggable => "draggable", DropZone => "dropzone", EncType => "enctype", For => "for", Form => "form",
    FormAction => "formaction", Headers => "headers", Height => "height", Hidden => "hidden", High => "high",
    Href => "href", HrefLang => "hreflang", HttpEquiv => "http-equiv", Id => "id", IsMap => "ismap",
    Kind => "kind", Label => "label", Lang => "lang", List => "list", Loop => "loop", Low => "low",
    Max => "max", MaxLength => "maxlength", Media => "media", Method => "method", Min => "min", MinLength => "minlength",
    Multiple => "multiple", Muted => "muted", Name => "name", NoValidate => "novalidate", OnAbort => "onabort",
    OnAfterPrint => "onafterprint", OnBeforePrint => "onbeforeprint", OnBeforeUnload => "onbeforeunload",
    OnBlur => "onblur", OnCanPlay => "oncanplay", OnCanPlayThrough => "oncanplaythrough", OnChange => "onchange",
    OnClick => "onclick", OnContextMenu => "oncontextmenu", OnCopy => "oncopy", OnCueChange => "oncuechange",
    OnCut => "oncut", OnDblClick => "ondblclick", OnDrag => "ondrag", OnDragEnd => "ondragend",
    OnDragEnter => "ondragenter", OnDragLeave => "ondragleave", OnDragOver => "ondragover",
    OnDragStart => "ondragstart", OnDrop => "ondrop", OnDurationChange => "ondurationchange",
    OnEmptied => "onemptied", OnEnded => "onended", OnError => "onerror", OnFocus => "onfocus",
    OnHashChange => "onhashchange", OnInput => "oninput", OnInvalid => "oninvalid", OnKeyDown => "onkeydown",
    OnKeyPress => "onkeypress", OnKeyUp => "onkeyup", OnLoad => "onload", OnLoadedData => "onloadeddata",
    OnLoadedMetaData => "onloadedmetadata", OnLoadStart => "onloadstart", OnMouseDown => "onmousedown",
    OnMouseMove => "onmousemove", OnMouseOut => "onmouseout", OnMouseOver => "onmouseover", OnMouseUp => "onmouseup",
    OnMouseWheel => "onmousewheel", OnOffline => "onoffline", OnOnline => "ononline", OnPageHide => "onpagehide",
    OnPageShow => "onpageshow", OnPaste => "onpaste", OnPause => "onpause", OnPlay => "onplay",
    OnPlaying => "onplaying", OnPopState => "onpopstate", OnProgress => "onprogress", OnRateChange => "onratechange",
    OnRest => "onreset", OnResize => "onresize", OnScroll => "onscroll", OnSearch => "onsearch",
    OnSeeked => "onseeked", OnSeeking => "onseeking", OnSelect => "onselect", OnStalled => "onstalled",
    OnStorage => "onstorage", OnSubmit => "onsubmit", OnSuspend => "onsuspend", OnTimeUpdate => "ontimeupdate",
    OnToggle => "ontoggle", OnUnload => "onunload", OnVolumeChange => "onvolumechange", OnWaiting => "onwaiting",
    OnWheel => "onwheel", Open => "open", Optimum => "optimum", Pattern => "pattern", Placeholder => "placeholder",
    Poster => "poster", Preload => "preload", ReadOnly => "readonly", Rel => "rel", Required => "required",
    Role => "role", Reversed => "reversed", Rows => "rows", RowSpan => "rowspan", Sandbox => "sandbox", Scope => "scope",
    Selected => "selected", Shape => "shape", Size => "size", Span => "span", SpellCheck => "spellcheck",
    Src => "src", SrcDoc => "srcdoc", SrcLang => "srclang", SrcSet => "srcset", Start => "start",
    Step => "step", Style => "style", TabIndex => "tabindex", Target => "target", Title => "title",
    Translate => "translate", Type => "type", UseMap => "usemap", Value => "value", Width => "width",
    Wrap => "wrap",

    // SVG
    // https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute
    AccentHeight => "accent-height", Accumulate => "accumulate", Additive => "additive",
    AlignmentBaseline => "alignment-baseline", AllowReorder => "allowReorder", Amplitude => "amplitude",
    ArabicForm => "arabic-form", Ascent => "ascent", AttributeName => "attributeName", AttributeType => "attributeType",
    AutoReverse => "autoReverse", Azimuth => "azimumth", BaseFrequency => "baseFrequency", BaselineShift => "baseline-shift",
    BaseProfile => "baseProfile", Bbox => "bbox", Begin => "begin", Bias => "bias", By => "by",
    CalcMode => "calcMode", CapHeight => "cap-height", Clip => "clip",
    ClipPathUnits => "clipPathUnits", ClipPath => "clip-path", ClipRule => "clip-rule",
    ColorInterpolation => "color-interpolation", ColorInterpolationFilters => "color-interpolation-filters",
    ColorProfile => "color-profile", ColorRendering => "color-rendering", ContentScriptType => "contentScriptType",
    ContentStyleType => "contentStyleType", Cursor => "cursor", Cx => "cx",
    Cy => "cy", Decelerate => "decelerate",
    Descent => "descent", DiffuseConstant => "diffuseConstant", Direction => "direction",
    Display => "display", Divisor => "divisor", DominantBaseline => "dominant-baseline",
    Dur => "dur", Dx => "dx", Dy => "dy",
    EdgeMode => "edgeMode", Elevation => "elevation", EnableBackground => "enable-background",
    End => "end", Exponent => "exponent", ExternalResourcesRequired => "externalResourcesRequired",
    FillOpacity => "fill-opacity", FillRule => "fill-rule",
    Filter => "filter", FilterRes => "filterRes", FilterUnits => "filterUnits",
    FloodColor => "flood-color", FloodOpacity => "flood-opacity", FontFamily => "font-family",
    FontSize => "font-size", FontSizeAdjust => "font-size-adjust", FontStretch => "font-stretch",
    FontStyle => "font-style", FontVariant => "font-variant", FontWeight => "font-weight",
    Format => "format", From => "from", Fr => "fr",
    Fx => "fx", Fy => "fy", G1 => "g1",
    G2 => "g2", GlyphName => "glyph-name", GlyphOrientationHorizontal => "glyph-orientation-horizontal",
    GlyphOrientationVertical => "glyph-orientation-vertical", GlyphRef => "glyphRef", GradientTransform => "gradientTransform",
    GradientUnits => "gradientUnits", Hanging => "hanging",
    HorizAdvX => "horiz-adv-x",
    HorizOriginX => "horiz-origin-x", Ideographic => "ideographic",
    ImageRendering => "image-rendering", In => "in", In2 => "in2",
    Intercept => "intercept", K => "k", K1 => "k1",
    K2 => "k2", K3 => "k3", K4 => "k4",
    KernelMatrix => "kernelMatrix", KernelUnitLength => "kernelUnitLength", Kerning => "kerning",
    KeyPoints => "keyPoints", KeySplines => "keySplines", KeyTimes => "keyTimes",
    LengthAdjust => "lengthAdjust", LetterSpacing => "letter-spacing",
    LightingColor => "lighting-color", LimitingConeAngle => "limitingConeAngle", Local => "local",
    MarkerEnd => "marker-end", MarkerMid => "marker-mid", MarkerStart => "marker-start",
    MarkerHeight => "markerHeight", MarkerUnits => "markerUnits", MarkerWidth => "markerWidth",
    Mask => "mask", MaskContentUnits => "maskContentUnits", MaskUnits => "maskUnits",
    Mathematical => "mathematical",
    Mode => "mode",
    NumOctaves => "numOctaves", Offset => "offset",
    Opacity => "opacity", Operator => "operator", Order => "order",
    Orient => "orient", Orientation => "orientation", Origin => "origin",
    Overflow => "overflow", OverlinePosition => "overline-position", OverlineThickness => "overline-thickness",
    Panose1 => "panose-1", PaintOrder => "paint-order",
    PathLength => "pathLength", PatternContentUnits => "patternContentUnits", PatternTransform => "patternTransform",
    PatternUnits => "patternUnits", Ping => "ping", PointerEvents => "pointer-events",
    Points => "points", PointsAtX => "pointsAtX", PointsAtY => "pointsAtY",
    PointsAtZ => "pointsAtZ", PreserveAlpha => "preserveAlpha", PreserveAspectRatio => "preserveAspectRatio",
    PrimitiveUnits => "primitiveUnits", R => "r", Radius => "radius",
    ReferrerPolicy => "referrerPolicy", RefX => "refX", RefY => "refY",
    RenderingIntent => "rendering-intent", RepeatCount => "repeatCount",
    RepeatDur => "repeatDur", RequiredExtensions => "requiredExtensions", RequiredFeatures => "requiredFeatures",
    Restart => "restart", Result => "result", Rotate => "rotate",
    Rx => "rx", Ry => "ry", Scale => "scale",
    Seed => "seed", ShapeRendering => "shape-rendering", Slope => "slope",
    Spacing => "spacing", SpecularConstant => "specularConstant", SpecularExponent => "specularExponent",
    Speed => "speed", SpreadMethod => "spreadMethod", StartOffset => "startOffset",
    StdDeviation => "stdDeviation", Stemh => "stemh", Stemv => "stemv",
    StitchTiles => "stitchTiles", StopColor => "stop-color", StopOpacity => "stop-opacity",
    StrikethroughPosition => "strikethrough-position", StrikethroughThickness => "strikethrough-thickness", String => "string",
    Stroke => "stroke", StrokeDashArray => "stroke-dasharray", StrokeDashOffset => "stroke-dashoffset",
    StrokeLinecap => "stroke-linecap", StrokeLineJoin => "stroke-linejoin", StrokeMiterLimit => "stroke-miterlimit",
    StrokeOpacity => "stroke-opacity", StrokeWidth => "stroke-width",
    SurfaceScale => "surfaceScale", SystemLanguage => "systemLanguage",
    TableValues => "tableValues", TargetX => "targetX",
    TargetY => "targetY", TextAnchor => "text-anchor", TextDecoration => "text-decoration",
    TextRendering => "text-rendering", TextLength => "textLength", To => "to",
    Transform => "transform", U1 => "u1",
    U2 => "u2", UnderlinePosition => "underline-position", UnderlineThickness => "underline-thickness",
    Unicode => "unicode", UnicodeBidi => "unicode-bidi", UnicodeRange => "unicode-range",
    UnitsPerEm => "units-per-em", VAlphabetic => "v-alphabetic", VHanging => "v-hanging",
    VIdeographic => "v-ideographic", VMathematical => "v-mathematical", Values => "values",
    VectorEffect => "vector-effect", Version => "version", VertAdvY => "vert-adv-y",
    VertOriginX => "vert-origin-x", VertOriginY => "vert-origin-y",
    ViewTarget => "viewTarget", Visibility => "visibility",
    Widths => "widths", WordSpacing => "word-spacing", WritingMode => "writing-mode",
    X => "x", XHeight => "x-height", X1 => "x1",
    X2 => "x2", XchannelSelector => "xChannelSelector", XlinkActuate => "xlink:actuate",
    XlinkArcrole => "xlink:arcrole", XlinkHref => "xlink:href", XlinkRole => "xlink:role",
    XlinkShow => "xlink:show", XlinkTitle => "xlink:title", XlinkType => "xlink:type",
    XmlBase => "xml:base", XmlLang => "xml:lang", XmlSpace => "xml:space",
    Y => "y", Y1 => "y1", Y2 => "y2",
    YchannelSelector => "yChannelSelector", Z => "z", ZoomAndPan => "zoomAndPan",

    Path => "path", D => "d", Xmlns => "xmlns", ViewBox => "viewBox", Fill => "fill",

    AriaAtomic => "aria-atomic", AriaBusy => "aria-busy", AriaControls => "aria-controls",
    AriaCurrent => "aria-current", AriaDescribedBy => "aria-describedby", AriaDetails => "aria-details",
    AriaDisabled => "aria-disabled", AriaDropEffect => "aria-dropeffect", AriaErrorMessage => "aria-errormessage",
    AriaFlowto => "aria-flowto", AriaGrabbed => "aria-grabbed", AriaHasPopup => "aria-haspopup",
    AriaHidden => "aria-hidden", AriaInvalid => "aria-invalid", AriaKeyShortcuts => "aria-keyshortcuts",
    AriaLabel => "aria-label", AriaLabelledBy => "aria-labelledby", AriaLive => "aria-live",
    AriaOwns => "aria-owns", AriaRelevant => "aria-relevant", AriaRoleDescription => "aria-roledescription",

    AriaExpanded => "aria-expanded", AriaDialog => "aria-dialog", AriaPressed => "aria-pressed",
    AriaChecked => "aria-checked", AriaColSpan => "aria-colspan", AriaRowIndex => "aria-rowindex",
    AriaRowSpan => "aria-rowspan",

    AriaSort => "aria-sort", AriaReadonly => "aria-readonly", AriaRequired => "aria-required",
    AriaSelected => "aria-selected",

    AriaMultiSelectable => "aria-multiselectable", AriaActiveDescendant => "aria-activedescendant",
    AriaOrientation => "aria-orientation", AriaLevel => "aria-level", AriaPosinset => "aria-posinset",
    AriaSetsize => "aria-setsize",

    AriaValueMax => "aria-valuemax", AriaValueMin => "aria-valuemin", AriaValueNow => "aria-valuenow",
    AriaValueText => "aria-valuetext",

    AriaMultiLine => "aria-multiline", AriaPlaceholder => "aria-placeholder"

}
