use wasm_bindgen::JsCast;

// @TODO: General helper? Or `to_` rename to `as_` and add `into_` variants.
// Or delete all?

/// Convenience function used in event handling: Convert an event target
/// to an input element; eg so you can take its value.
pub fn to_input(target: &web_sys::EventTarget) -> &web_sys::HtmlInputElement {
    target
        .dyn_ref::<web_sys::HtmlInputElement>()
        .expect("Unable to cast as an input element")
}

/// See [`to_input`](fn.to_input.html)
pub fn to_textarea(target: &web_sys::EventTarget) -> &web_sys::HtmlTextAreaElement {
    target
        .dyn_ref::<web_sys::HtmlTextAreaElement>()
        .expect("Unable to cast as a textarea element")
}

/// See [`to_input`](fn.to_input.html)
pub fn to_select(target: &web_sys::EventTarget) -> &web_sys::HtmlSelectElement {
    target
        .dyn_ref::<web_sys::HtmlSelectElement>()
        .expect("Unable to cast as a select element")
}

/// See [`to_input`](fn.to_input.html)
pub fn to_html_el(target: &web_sys::EventTarget) -> &web_sys::HtmlElement {
    target
        .dyn_ref::<web_sys::HtmlElement>()
        .expect("Unable to cast as an HTML element")
}

/// Convert a `web_sys::Event` to a `web_sys::KeyboardEvent`. Useful for extracting
/// info like which key has been pressed, which is not available with normal Events.
pub fn to_keyboard_event(event: &web_sys::Event) -> &web_sys::KeyboardEvent {
    event
        .dyn_ref::<web_sys::KeyboardEvent>()
        .expect("Unable to cast as a keyboard event")
}

/// See `to_keyboard_event`
pub fn to_mouse_event(event: &web_sys::Event) -> &web_sys::MouseEvent {
    event
        .dyn_ref::<web_sys::MouseEvent>()
        .expect("Unable to cast as a mouse event")
}

/// See `to_keyboard_event`
pub fn to_touch_event(event: &web_sys::Event) -> &web_sys::TouchEvent {
    event
        .dyn_ref::<web_sys::TouchEvent>()
        .expect("Unable to cast as a touch event")
}

/// See `to_keyboard_event`
pub fn to_drag_event(event: &web_sys::Event) -> &web_sys::DragEvent {
    event
        .dyn_ref::<web_sys::DragEvent>()
        .expect("Unable to cast as a drag event")
}

/// See `to_keyboard_event`
pub fn to_wheel_event(event: &web_sys::Event) -> &web_sys::WheelEvent {
    event
        .dyn_ref::<web_sys::WheelEvent>()
        .expect("Unable to cast as a wheel event")
}
