/*****************************************************************************************************
 * Copyright (c) 2013, 2014, 2017, 2021 Pieter Wuille, Andrew Poelstra, Jonas Nick, Russell O'Connor *
 * Distributed under the MIT software license, see the accompanying                                  *
 * file COPYING or https://www.opensource.org/licenses/mit-license.php.                              *
 *****************************************************************************************************/

#ifndef SECP256K1_PRECOMPUTED_ECMULT_H
#define SECP256K1_PRECOMPUTED_ECMULT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "group.h"
#if defined(EXHAUSTIVE_TEST_ORDER)
#if EXHAUSTIVE_TEST_ORDER == 13
#        define WINDOW_G 4
#    elif EXHAUSTIVE_TEST_ORDER == 199
#        define WINDOW_G 8
#    else
#        error No known generator for the specified exhaustive test group order.
#    endif
static rustsecp256k1zkp_v0_6_0_ge_storage rustsecp256k1zkp_v0_6_0_pre_g[ECMULT_TABLE_SIZE(WINDOW_G)];
static rustsecp256k1zkp_v0_6_0_ge_storage rustsecp256k1zkp_v0_6_0_pre_g_128[ECMULT_TABLE_SIZE(WINDOW_G)];
#else /* !defined(EXHAUSTIVE_TEST_ORDER) */
#    define WINDOW_G ECMULT_WINDOW_SIZE
extern const rustsecp256k1zkp_v0_6_0_ge_storage rustsecp256k1zkp_v0_6_0_pre_g[ECMULT_TABLE_SIZE(WINDOW_G)];
extern const rustsecp256k1zkp_v0_6_0_ge_storage rustsecp256k1zkp_v0_6_0_pre_g_128[ECMULT_TABLE_SIZE(WINDOW_G)];
#endif /* defined(EXHAUSTIVE_TEST_ORDER) */

#ifdef __cplusplus
}
#endif

#endif /* SECP256K1_PRECOMPUTED_ECMULT_H */
