use crate::core::item::Item;
use crate::core::Script;

pub trait Codec<T> {
    fn encode(input: &[T]) -> &[u8];
    fn decode(encoded: &[u8]) -> &[T];
}

impl<Op, Val> Codec<Item<Op, Val>> for Script<Op, Val>
where
    Op: core::fmt::Debug + core::cmp::Eq,
    Val: core::fmt::Debug + core::cmp::PartialEq,
{
    fn encode(input: &[Item<Op, Val>]) -> &[u8] {
        let mut output = &mut [];
        for item in input {
            match item {
                Item::Operator(op) => output.append(op.encode()),
                Item::Value(val) => output.append(val.encode()),
            }
        }

        &output
    }

    fn decode(encoded: &[u8]) -> &[Item<Op, Val>] {
        unimplemented!()
    }
}
