// Autogenerated by Thrift Compiler (0.15.0)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

#![allow(unused_imports)]
#![allow(unused_extern_crates)]
#![allow(clippy::too_many_arguments, clippy::type_complexity, clippy::vec_box)]
#![cfg_attr(rustfmt, rustfmt_skip)]

use std::cell::RefCell;
use std::collections::{BTreeMap, BTreeSet};
use std::convert::{From, TryFrom};
use std::default::Default;
use std::error::Error;
use std::fmt;
use std::fmt::{Display, Formatter};
use std::rc::Rc;

use thrift::OrderedFloat;
use thrift::{ApplicationError, ApplicationErrorKind, ProtocolError, ProtocolErrorKind, TThriftClient};
use thrift::protocol::{TFieldIdentifier, TListIdentifier, TMapIdentifier, TMessageIdentifier, TMessageType, TInputProtocol, TOutputProtocol, TSetIdentifier, TStructIdentifier, TType};
use thrift::protocol::field_id;
use thrift::protocol::verify_expected_message_type;
use thrift::protocol::verify_expected_sequence_number;
use thrift::protocol::verify_expected_service_call;
use thrift::protocol::verify_required_field_exists;
use thrift::server::TProcessor;

use crate::fb303;

#[derive(Copy, Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct ResultCode(pub i32);

impl ResultCode {
  pub const OK: ResultCode = ResultCode(0);
  pub const TRY_LATER: ResultCode = ResultCode(1);
  pub const ENUM_VALUES: &'static [Self] = &[
    Self::OK,
    Self::TRY_LATER,
  ];
  #[allow(clippy::trivially_copy_pass_by_ref)]
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    o_prot.write_i32(self.0)
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<ResultCode> {
    let enum_value = i_prot.read_i32()?;
    Ok(ResultCode::from(enum_value))
  }
}

impl From<i32> for ResultCode {
  fn from(i: i32) -> Self {
    match i {
      0 => ResultCode::OK,
      1 => ResultCode::TRY_LATER,
      _ => ResultCode(i)
    }
  }
}

impl From<&i32> for ResultCode {
  fn from(i: &i32) -> Self {
    ResultCode::from(*i)
  }
}

impl From<ResultCode> for i32 {
  fn from(e: ResultCode) -> i32 {
    e.0
  }
}

impl From<&ResultCode> for i32 {
  fn from(e: &ResultCode) -> i32 {
    e.0
  }
}

//
// LogEntry
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct LogEntry {
  pub category: Option<String>,
  pub message: Option<String>,
}

impl LogEntry {
  pub fn new<F1, F2>(category: F1, message: F2) -> LogEntry where F1: Into<Option<String>>, F2: Into<Option<String>> {
    LogEntry {
      category: category.into(),
      message: message.into(),
    }
  }
  pub fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<LogEntry> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<String> = Some("".to_owned());
    let mut f_2: Option<String> = Some("".to_owned());
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let val = i_prot.read_string()?;
          f_1 = Some(val);
        },
        2 => {
          let val = i_prot.read_string()?;
          f_2 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = LogEntry {
      category: f_1,
      message: f_2,
    };
    Ok(ret)
  }
  pub fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("LogEntry");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.category {
      o_prot.write_field_begin(&TFieldIdentifier::new("category", TType::String, 1))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    if let Some(ref fld_var) = self.message {
      o_prot.write_field_begin(&TFieldIdentifier::new("message", TType::String, 2))?;
      o_prot.write_string(fld_var)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

impl Default for LogEntry {
  fn default() -> Self {
    LogEntry{
      category: Some("".to_owned()),
      message: Some("".to_owned()),
    }
  }
}

//
// scribe service client
//

pub trait TScribeSyncClient : fb303::TBaseServiceSyncClient {
  fn log(&mut self, messages: Vec<LogEntry>) -> thrift::Result<ResultCode>;
}

pub trait TScribeSyncClientMarker {}

pub struct ScribeSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  _i_prot: IP,
  _o_prot: OP,
  _sequence_number: i32,
}

impl <IP, OP> ScribeSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  pub fn new(input_protocol: IP, output_protocol: OP) -> ScribeSyncClient<IP, OP> {
    ScribeSyncClient { _i_prot: input_protocol, _o_prot: output_protocol, _sequence_number: 0 }
  }
}

impl <IP, OP> TThriftClient for ScribeSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {
  fn i_prot_mut(&mut self) -> &mut dyn TInputProtocol { &mut self._i_prot }
  fn o_prot_mut(&mut self) -> &mut dyn TOutputProtocol { &mut self._o_prot }
  fn sequence_number(&self) -> i32 { self._sequence_number }
  fn increment_sequence_number(&mut self) -> i32 { self._sequence_number += 1; self._sequence_number }
}

impl <IP, OP> TScribeSyncClientMarker for ScribeSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {}
impl <IP, OP> fb303::TBaseServiceSyncClientMarker for ScribeSyncClient<IP, OP> where IP: TInputProtocol, OP: TOutputProtocol {}

impl <C: TThriftClient + TScribeSyncClientMarker + fb303::TBaseServiceSyncClientMarker> TScribeSyncClient for C {
  fn log(&mut self, messages: Vec<LogEntry>) -> thrift::Result<ResultCode> {
    (
      {
        self.increment_sequence_number();
        let message_ident = TMessageIdentifier::new("Log", TMessageType::Call, self.sequence_number());
        let call_args = ScribeLogArgs { messages };
        self.o_prot_mut().write_message_begin(&message_ident)?;
        call_args.write_to_out_protocol(self.o_prot_mut())?;
        self.o_prot_mut().write_message_end()?;
        self.o_prot_mut().flush()
      }
    )?;
    {
      let message_ident = self.i_prot_mut().read_message_begin()?;
      verify_expected_sequence_number(self.sequence_number(), message_ident.sequence_number)?;
      verify_expected_service_call("Log", &message_ident.name)?;
      if message_ident.message_type == TMessageType::Exception {
        let remote_error = thrift::Error::read_application_error_from_in_protocol(self.i_prot_mut())?;
        self.i_prot_mut().read_message_end()?;
        return Err(thrift::Error::Application(remote_error))
      }
      verify_expected_message_type(TMessageType::Reply, message_ident.message_type)?;
      let result = ScribeLogResult::read_from_in_protocol(self.i_prot_mut())?;
      self.i_prot_mut().read_message_end()?;
      result.ok_or()
    }
  }
}

//
// scribe service processor
//

pub trait ScribeSyncHandler : fb303::BaseServiceSyncHandler {
  fn handle_log(&self, messages: Vec<LogEntry>) -> thrift::Result<ResultCode>;
}

pub struct ScribeSyncProcessor<H: ScribeSyncHandler> {
  handler: H,
}

impl <H: ScribeSyncHandler> ScribeSyncProcessor<H> {
  pub fn new(handler: H) -> ScribeSyncProcessor<H> {
    ScribeSyncProcessor {
      handler,
    }
  }
  fn process_log(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    TScribeProcessFunctions::process_log(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_status(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_status(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_name(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_name(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_version(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_version(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_status_details(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_status_details(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_counters(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_counters(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_regex_counters(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_regex_counters(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_selected_counters(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_selected_counters(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_counter(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_counter(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_exported_values(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_exported_values(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_selected_exported_values(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_selected_exported_values(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_regex_exported_values(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_regex_exported_values(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_exported_value(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_exported_value(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_set_option(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_set_option(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_option(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_option(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_get_options(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_get_options(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
  fn process_alive_since(&self, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    fb303::TBaseServiceProcessFunctions::process_alive_since(&self.handler, incoming_sequence_number, i_prot, o_prot)
  }
}

pub struct TScribeProcessFunctions;

impl TScribeProcessFunctions {
  pub fn process_log<H: ScribeSyncHandler>(handler: &H, incoming_sequence_number: i32, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let args = ScribeLogArgs::read_from_in_protocol(i_prot)?;
    match handler.handle_log(args.messages) {
      Ok(handler_return) => {
        let message_ident = TMessageIdentifier::new("Log", TMessageType::Reply, incoming_sequence_number);
        o_prot.write_message_begin(&message_ident)?;
        let ret = ScribeLogResult { result_value: Some(handler_return) };
        ret.write_to_out_protocol(o_prot)?;
        o_prot.write_message_end()?;
        o_prot.flush()
      },
      Err(e) => {
        match e {
          thrift::Error::Application(app_err) => {
            let message_ident = TMessageIdentifier::new("Log", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&app_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
          _ => {
            let ret_err = {
              ApplicationError::new(
                ApplicationErrorKind::Unknown,
                e.to_string()
              )
            };
            let message_ident = TMessageIdentifier::new("Log", TMessageType::Exception, incoming_sequence_number);
            o_prot.write_message_begin(&message_ident)?;
            thrift::Error::write_application_error_to_out_protocol(&ret_err, o_prot)?;
            o_prot.write_message_end()?;
            o_prot.flush()
          },
        }
      },
    }
  }
}

impl <H: ScribeSyncHandler> TProcessor for ScribeSyncProcessor<H> {
  fn process(&self, i_prot: &mut dyn TInputProtocol, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let message_ident = i_prot.read_message_begin()?;
    let res = match &*message_ident.name {
      "Log" => {
        self.process_log(message_ident.sequence_number, i_prot, o_prot)
      },
      "getStatus" => {
        self.process_get_status(message_ident.sequence_number, i_prot, o_prot)
      },
      "getName" => {
        self.process_get_name(message_ident.sequence_number, i_prot, o_prot)
      },
      "getVersion" => {
        self.process_get_version(message_ident.sequence_number, i_prot, o_prot)
      },
      "getStatusDetails" => {
        self.process_get_status_details(message_ident.sequence_number, i_prot, o_prot)
      },
      "getCounters" => {
        self.process_get_counters(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRegexCounters" => {
        self.process_get_regex_counters(message_ident.sequence_number, i_prot, o_prot)
      },
      "getSelectedCounters" => {
        self.process_get_selected_counters(message_ident.sequence_number, i_prot, o_prot)
      },
      "getCounter" => {
        self.process_get_counter(message_ident.sequence_number, i_prot, o_prot)
      },
      "getExportedValues" => {
        self.process_get_exported_values(message_ident.sequence_number, i_prot, o_prot)
      },
      "getSelectedExportedValues" => {
        self.process_get_selected_exported_values(message_ident.sequence_number, i_prot, o_prot)
      },
      "getRegexExportedValues" => {
        self.process_get_regex_exported_values(message_ident.sequence_number, i_prot, o_prot)
      },
      "getExportedValue" => {
        self.process_get_exported_value(message_ident.sequence_number, i_prot, o_prot)
      },
      "setOption" => {
        self.process_set_option(message_ident.sequence_number, i_prot, o_prot)
      },
      "getOption" => {
        self.process_get_option(message_ident.sequence_number, i_prot, o_prot)
      },
      "getOptions" => {
        self.process_get_options(message_ident.sequence_number, i_prot, o_prot)
      },
      "aliveSince" => {
        self.process_alive_since(message_ident.sequence_number, i_prot, o_prot)
      },
      method => {
        Err(
          thrift::Error::Application(
            ApplicationError::new(
              ApplicationErrorKind::UnknownMethod,
              format!("unknown method {}", method)
            )
          )
        )
      },
    };
    thrift::server::handle_process_result(&message_ident, res, o_prot)
  }
}

//
// ScribeLogArgs
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct ScribeLogArgs {
  messages: Vec<LogEntry>,
}

impl ScribeLogArgs {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<ScribeLogArgs> {
    i_prot.read_struct_begin()?;
    let mut f_1: Option<Vec<LogEntry>> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        1 => {
          let list_ident = i_prot.read_list_begin()?;
          let mut val: Vec<LogEntry> = Vec::with_capacity(list_ident.size as usize);
          for _ in 0..list_ident.size {
            let list_elem_0 = LogEntry::read_from_in_protocol(i_prot)?;
            val.push(list_elem_0);
          }
          i_prot.read_list_end()?;
          f_1 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    verify_required_field_exists("ScribeLogArgs.messages", &f_1)?;
    let ret = ScribeLogArgs {
      messages: f_1.expect("auto-generated code should have checked for presence of required fields"),
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("Log_args");
    o_prot.write_struct_begin(&struct_ident)?;
    o_prot.write_field_begin(&TFieldIdentifier::new("messages", TType::List, 1))?;
    o_prot.write_list_begin(&TListIdentifier::new(TType::Struct, self.messages.len() as i32))?;
    for e in &self.messages {
      e.write_to_out_protocol(o_prot)?;
    }
    o_prot.write_list_end()?;
    o_prot.write_field_end()?;
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
}

//
// ScribeLogResult
//

#[derive(Clone, Debug, Eq, Hash, Ord, PartialEq, PartialOrd)]
struct ScribeLogResult {
  result_value: Option<ResultCode>,
}

impl ScribeLogResult {
  fn read_from_in_protocol(i_prot: &mut dyn TInputProtocol) -> thrift::Result<ScribeLogResult> {
    i_prot.read_struct_begin()?;
    let mut f_0: Option<ResultCode> = None;
    loop {
      let field_ident = i_prot.read_field_begin()?;
      if field_ident.field_type == TType::Stop {
        break;
      }
      let field_id = field_id(&field_ident)?;
      match field_id {
        0 => {
          let val = ResultCode::read_from_in_protocol(i_prot)?;
          f_0 = Some(val);
        },
        _ => {
          i_prot.skip(field_ident.field_type)?;
        },
      };
      i_prot.read_field_end()?;
    }
    i_prot.read_struct_end()?;
    let ret = ScribeLogResult {
      result_value: f_0,
    };
    Ok(ret)
  }
  fn write_to_out_protocol(&self, o_prot: &mut dyn TOutputProtocol) -> thrift::Result<()> {
    let struct_ident = TStructIdentifier::new("ScribeLogResult");
    o_prot.write_struct_begin(&struct_ident)?;
    if let Some(ref fld_var) = self.result_value {
      o_prot.write_field_begin(&TFieldIdentifier::new("result_value", TType::I32, 0))?;
      fld_var.write_to_out_protocol(o_prot)?;
      o_prot.write_field_end()?
    }
    o_prot.write_field_stop()?;
    o_prot.write_struct_end()
  }
  fn ok_or(self) -> thrift::Result<ResultCode> {
    if self.result_value.is_some() {
      Ok(self.result_value.unwrap())
    } else {
      Err(
        thrift::Error::Application(
          ApplicationError::new(
            ApplicationErrorKind::MissingResult,
            "no result received for ScribeLog"
          )
        )
      )
    }
  }
}

