extern crate screenshots;

use screenshots::Display;
use std::time::Instant;

fn main() {
  let start = Instant::now();

  println!("displays():");
  let displays = Display::displays().unwrap();
  for display in displays {
    println!(
      "  Display:{} x: {} y: {} width: {} height: {} scale: {} rotation: {}",
      display.id(),
      display.x(),
      display.y(),
      display.width(),
      display.height(),
      display.scale(),
      display.rotation()
    );
  }

  println!("get_display_with_point(10.0, 10.0):");
  let display = Display::get_display_with_point(10.0, 10.0).unwrap();
  println!(
    "  Display:{} x: {} y: {} width: {} height: {} scale: {} rotation: {}",
    display.id(),
    display.x(),
    display.y(),
    display.width(),
    display.height(),
    display.scale(),
    display.rotation()
  );

  println!("运行耗时: {:?}", start.elapsed());
}
