// SPDX-License-Identifier: GPL-3.0-only

#ifndef UNITY_H
#define UNITY_H

#include <vector>

#include "outputs.h"

typedef void (*PFN_SetupUnityCallbacks)(void *func1, void *func2, void *func3, void *func4, void *func5, void *func6, void *func7, void *func8, void *func9, void *func10, void *func11);
typedef int (*PFN_LoadScreenSelectorWindow)(const void *module, const char *title, const char *icon, const char *pixbuf_path);

// Symbols exported by the plugin, to be called by us.
extern PFN_SetupUnityCallbacks SetupUnityCallbacks;
extern PFN_LoadScreenSelectorWindow LoadScreenSelectorWindow;

// Callbacks to be passed to the plugin.
int GetAxisDescription(int axis, char *control, char *primary, char *secondary);
char ConfigureAxis(int axis, int enabled);
std::vector<struct resolution>* GetResolutions(int display);
void GetSelectedResolution(int *width, int *height, bool *windowed);
void SetSelectedResolution(int width, int height, bool windowed);
std::vector<const char *>* GetQualityLevels();
int GetSelectedQualityLevel();
void SetSelectedQualityLevel(int quality);
std::vector<const char *>* GetDisplays();
int GetSelectedDisplay();
void SetSelectedDisplay(int display);

// Helpers to load the plugin.
int load_screen_selector();
int unload_screen_selector();

#endif // UNITY_H
