// SPDX-License-Identifier: GPL-3.0-only

#ifndef OUTPUTS_H
#define OUTPUTS_H

#include <cstddef>
#include <string>
#include <vector>

struct resolution {
	int width;
	int height;
};

struct output_info {
	struct wl_output *global;
	std::vector<struct resolution> resolutions;
	ssize_t default_resolution;
	std::string make;
	std::string model;
};

extern std::vector<std::unique_ptr<struct output_info>> outputs;

#endif // OUTPUTS_H
