// SPDX-License-Identifier: GPL-3.0-only

#include <cerrno>
#include <cstddef>
#include <cstdio>
#include <cstring>
#include <dlfcn.h>
#include <memory>
#include <string>
#include <vector>

#include <wayland-client.h>

#include "unity.h"
#include "outputs.h"
#include "wayland.h"

int main()
{
	int ret = load_screen_selector();
	if (ret)
		return 1;

	ret = populate_wayland_outputs();
	if (ret)
		return 2;

	// Now do what Unity would do to start the plugin.
	SetupUnityCallbacks((void*)GetAxisDescription, (void*)ConfigureAxis, (void*)GetResolutions, (void*)GetSelectedResolution, (void*)SetSelectedResolution, (void*)GetQualityLevels, (void*)GetSelectedQualityLevel, (void*)SetSelectedQualityLevel, (void*)GetDisplays, (void*)GetSelectedDisplay, (void*)SetSelectedDisplay);

	// TODO: figure out what the real Unity does with that.
	char module[512];
	ret = LoadScreenSelectorWindow(module, "My Game", "/usr/share/icons/hicolor/24x24/apps/firefox.png", "/home/linkmauve/dev/rust/screen-selector/gibbous.png");
	if (!ret) {
		fprintf(stderr, "LoadScreenSelectorWindow() returned %d\n", ret);
		return 3;
	}

	ret = unload_screen_selector();
	if (ret)
		return 4;
}
