// SPDX-License-Identifier: GPL-3.0-only

use crate::callbacks::*;

pub fn load_screen_selector_window(title: String, icon: String, pixbuf_path: String) -> i32 {
    println!(
        "LoadScreenSelectorWindow({:?}, {:?}, {:?})",
        title, icon, pixbuf_path
    );

    for (control, primary, secondary) in iter_axis_description() {
        println!(
            "Axis: control={:?} primary={:?} secondary={:?}",
            control, primary, secondary
        );
    }

    let displays = get_displays();
    for name in displays.iter() {
        println!("display: {:?}", name);
    }
    let selected_display = get_selected_display();
    println!("selected display: {}", selected_display);

    println!("resolutions:");
    for i in 0..displays.len() as u32 {
        for (width, height) in get_resolutions(i) {
            println!(" {}×{}", width, height);
        }
    }

    let (width, height, windowed) = get_selected_resolution();
    println!(
        "selected resolution: {}×{} windowed={}",
        width, height, windowed
    );

    for quality in get_quality_levels() {
        println!(" {}", quality);
    }
    let selected_quality_level = get_selected_quality_level();
    println!("quality={}", selected_quality_level);

    set_selected_display(selected_display);
    set_selected_resolution(width, height, windowed);
    set_selected_quality_level(selected_quality_level);
    1
}
