use criterion::{black_box, criterion_group, criterion_main, Criterion};


use scorpius::data_structure::stack::Stack;

fn criterion_benchmark(c: &mut Criterion) {
    let mut group = c.benchmark_group("Stack");
    let mut stack = Stack::new();
    group.bench_function("push", |b| {
        b.iter(|| {
            stack.push(black_box(1));
        });
    });

    group.bench_function("pop", |b| {
        b.iter(|| {
            stack.pop();
        });
    });
    group.finish();
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);