use crate::kinds::*;

/// Combines two primary colors in equal amounts to create a secondary color.
pub fn mix(c1: PrimaryColor, c2: PrimaryColor) -> Option<SecondaryColor> {
    let colors = vec![c1, c2];
    if colors.contains(&PrimaryColor::Red) && colors.contains(&PrimaryColor::Blue) {
        return Some(SecondaryColor::Purple);
    }
    if colors.contains(&PrimaryColor::Red) && colors.contains(&PrimaryColor::Yellow) {
        return Some(SecondaryColor::Orange);
    }
    if colors.contains(&PrimaryColor::Blue) && colors.contains(&PrimaryColor::Yellow) {
        return Some(SecondaryColor::Green);
    }
    // If none of these combinations presented, c1 and c2 are equal and cannot create a secondary color
    None
}
