use std::fmt::{Debug, Display};

#[derive(Clone)]
pub struct Entry<K, V> {
    key: K,
    value: V,
}

impl<K: Display, V: Display> Debug for Entry<K, V> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.write_str(&format!("<{}, {}>", self.key, self.value))
    }
}

impl<K: Clone, V: Clone> Entry<K, V> {
    pub fn new(key: K, value: V) -> Self {
        Entry { key, value }
    }

    pub fn key(&self) -> K {
        self.key.clone()
    }

    pub fn value(&self) -> V {
        self.value.clone()
    }

    pub fn set_value(&mut self, value: V) {
        self.value = value;
    }
}
