use super::Entry;

pub struct OrderedMap<K, V> {
    data: Vec<Entry<K, V>>,
}

impl<K: Clone + Ord, V: Clone> OrderedMap<K, V> {
    pub fn new() -> Self {
        Self { data: Vec::new() }
    }

    fn find(&self, key: K) -> Result<usize, usize> {
        self.data.binary_search_by_key(&key, |e| e.key())
    }

    pub fn get(&self, key: K) -> Option<V> {
        if let Ok(i) = self.find(key) {
            Some(self.data[i].value())
        } else {
            None
        }
    }

    pub fn insert(&mut self, key: K, value: V) -> Option<V> {
        match self.find(key.clone()) {
            Ok(i) => {
                let temp = self.data[i].value();
                self.data[i].set_value(value);
                Some(temp)
            }
            Err(i) => {
                self.data.insert(i, Entry::new(key, value));
                None
            }
        }
    }

    pub fn entries(&self) -> Vec<Entry<K, V>> {
        self.data.clone()
    }
}
