# schm

Here is an example of two strings colliding with eachother:
```rust
use std::{
    collections::hash_map::DefaultHasher,
    hash::{Hash, Hasher},
};

const DEFAULT_CAPACITY: u64 = 17;

fn hash_to_index<T: Hash>(key: T) -> u64 {
    let mut state = DefaultHasher::new();
    key.hash(&mut state);
    state.finish() % DEFAULT_CAPACITY
}

fn main() {
    let a = hash_to_index("orange"); //  Calculates to '8'
    let b = hash_to_index("blueberry"); //  Calculates to '8'

    assert_eq!(a, b)
}
```
Here, collision is completely handled due to separate chaining:
```rust
use schm::HashMap;

fn main() {
    let mut map = HashMap::new();

    map.insert("orange", "ORANGE");
    map.insert("blueberry", "BLUEBERRY");

    assert_eq!(map.get("orange"), Some("ORANGE"));
    assert_eq!(map.get("blueberry"), Some("BLUEBERRY"));
}
```
