mod tools;

pub use tools::*;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn get() {
        let map: HashMap<&str, &str> =
            vec![("4", "four"), ("69", "four-twenty"), ("2", "two")].into();
        assert_eq!(map.get("69").unwrap(), "four-twenty");
    }

    #[test]
    fn insert() {
        let map: HashMap<&str, &str> = vec![
            ("4", "four"),
            ("69", "sixty-nine"),
            ("2", "two"),
            ("69", "four-twenty"),
        ]
        .into();
        assert_eq!(map.get("69").unwrap(), "four-twenty");
    }

    #[test]
    fn entries() {
        let mut data = vec![
            ("4", "four"),
            ("69", "sixty-nine"),
            ("2", "two"),
            ("69", "four-twenty"),
        ];

        let map: HashMap<&str, &str> = data.clone().into();

        let mut result: Vec<(&str, &str)> = map
            .entries()
            .into_iter()
            .map(|e| (e.key(), e.value()))
            .collect();

        //  Remove the replaced value
        data.remove(1);

        data.sort();
        result.sort();

        assert_eq!(data, result)
    }
}
