use proc_macro::TokenStream;
use quote::quote;

pub fn from_string(mod_name: &str, content: &str) -> TokenStream {
    let mod_name = quote::format_ident!("{}", mod_name);

    println!("Parsing \n{}\n as JSON", content);

    let all_data: serde_json::Value = serde_json::from_str(content).unwrap();

    let schema = crate::schema::generate_schema(&all_data);

    let ret = quote! {
        mod #mod_name {
            use serde::{Deserialize,Serialize};
            #schema
        }
    };

    println!("**** load from_string result: {:?}", ret);
    println!("**** load from_string result: {}", ret.to_string());

    ret.into()
}

pub fn from_file(mod_name: &str, path: &str) -> TokenStream {
    let mod_name = quote::format_ident!("{}", mod_name);

    let all_data: serde_json::Value =
        serde_json::from_reader(std::io::BufReader::new(std::fs::File::open(path).unwrap()))
            .unwrap();

    let schema = crate::schema::generate_schema(&all_data);

    let ret = quote! {
        mod #mod_name {
            use serde::{Deserialize,Serialize};
            #schema
        }
    };

    println!("**** load from_file result: {:?}", ret);
    println!("**** load from_file result: {}", ret.to_string());

    ret.into()
}
