/*[License]
    - Author: Molese <molese@engineer.com> 2022

    Licensed under either of

    * Apache License, Version 2.0 (LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0)
    * MIT license (LICENSE-MIT or https://opensource.org/licenses/MIT)

    at your option.
*/

use {
    scatterbrainedsearch::{run, Config},
    std::{env, process},
};

macro_rules! die {
    ($($arg:tt)*) => (
        eprintln!("Fatal: {}!", $($arg)*);
    )
}

fn main() {
    let config: Config = Config::new(env::args()).unwrap_or_else(|err: &str| {
        die!(err);
        process::exit(0x0100);
    });

    if let Err(err) = run(config) {
        die!(err);
    }
}
