/*[License]
    - Author: Molese <molese@protonmail.com> 2022

    Licensed under either of

    * Apache License, Version 2.0 (LICENSE-APACHE or https://www.apache.org/licenses/LICENSE-2.0)
    * MIT license (LICENSE-MIT or https://opensource.org/licenses/MIT)

    at your option.
*/

use {
    scatterbrainedsearch::{run, Config},
    std::{env, process},
};

fn main() {
    /* `unwrap_or_else` for non-panic error handling. Using an anonymous function. */
    let config: Config = Config::new(env::args()).unwrap_or_else(|err: &str| {
        /* printing the error to the standard error instead of standard output */
        eprintln!("Fatal: {}!", err);
        process::exit(0x0100); /* To exit neatly without any other info spewed out */
    });

    /* `if let` is used to check if an `Err` type is actually returned. */
    if let Err(err) = run(config) {
        eprintln!("Fatal: {}!", err);
    }
}
