/*
MIT License

Copyright (c) 2022 Molese

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

use {
    sbs::{run, Config},
    std::{env, process},
};

fn main() {
    /* `unwrap_or_else` for non-panic error handling. Using an anonymous function. */
    let config: Config = Config::new(env::args()).unwrap_or_else(|err: &str| {
        /* printing the error to the standard error instead of standard output */
        eprintln!("Fatal: {}!", err);
        process::exit(0x0100); /* To exit neatly without any other info spewed out */
    });

    /* `if let` is used to check if an `Err` type is actually returned. */
    if let Err(err) = run(config) {
        eprintln!("Fatal: {}", err);
    }
}
