[Introduction](README.md)

# Tutorials

- [Quickstart](tutorials/quickstart.md)
- [Docker-compose](tutorials/docker-compose.md)
- [Installation](tutorials/installation.md)
- [Power consumption of a Kubernetes cluster with scaphandre, prometheus and grafana](tutorials/kubernetes.md)

# How-to guides

- [Propagate power consumption metrics from hypervisor to virtual machines (Qemu/KVM)](how-to_guides/propagate-metrics-hypervisor-to-vm_qemu-kvm.md)
- [Get process-level power consumption in my grafana dashboard](how-to_guides/get-process-level-power-in-grafana.md)
# Explanations

- [How scaphandre computes per process power consumption](explanations/how-scaph-computes-per-process-power-consumption.md)
- [Internal structure](explanations/internal-structure.md)
- [About containers](explanations/about-containers.md)

# References

## Exporters

- [JSON exporter](references/exporter-json.md)
- [Prometheus exporter](references/exporter-prometheus.md)
- [Qemu exporter](references/exporter-qemu.md)
- [Riemann exporter](references/exporter-riemann.md)
- [Stdout exporter](references/exporter-stdout.md)
- [Warp10 exporter](references/exporter-warp10.md)

## Sensors

- [PowercapRAPL sensor](references/sensor-powercap_rapl.md)

[Why this project ?](why.md)
[Compatibility](compatibility.md)
[Troubleshooting](troubleshooting.md)
[Contributing guide](contributing.md)
[External references you may be interested in](sources.md)
