#[doc(hidden)]
pub mod format;

#[macro_export]
macro_rules! sscanf {
    ($input:tt, $format:literal, $($var:ident),+ ) => {
        let formater = format::InputFormat::new($format);
        let inputs = formater.input_strings($input);
        let mut inputs_iter = inputs.iter();
        $(
            $var = inputs_iter.next().unwrap().parse().unwrap();
        )*
    };
    ($input:tt, $format:tt, $($var:ident),+ , ) => { sscanf!($input, $format, $($var),*) };
}

#[macro_export]
macro_rules! scanf {
    ($format:literal, $($var:ident),+ ) => {
        let mut buffer = String::new();
        io::stdin().read_line(&mut buffer)?;
        sscanf!(buffer, $format, $($var),*);
    };
    ($format:tt, $($var:ident),+ , ) => { scanf!($format, $($var),*) };
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn strings() {
        let input = "Hello: world";
        let request: String;
        let reply: String;
        sscanf!(input, "{string}:{ {string}", request, reply);
        assert_eq!(request, "Hello");
        assert_eq!(reply, "world");
    }

    #[test]
    fn string_and_float() {
        let input = "Candy->2.5";
        let product: String;
        let price: f64;
        sscanf!(input, "{string}->{f64}", product, price,);
        assert_eq!(product, "Candy");
        assert_eq!(price, 2.5);
    }
}
