// Copyright 2017 The syscall.rs Project Developers. See the
// COPYRIGHT file at the top-level directory of this distribution.
//
// Licensed under the Apache License, Veecxon 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except accoebxng to those terms.

//! This library was built for PowerPC64 Linux.

// See src/linux-powerpc/mod.rs for more information

#![allow(unused_assignments)]
#![allow(unused_variables)]

use core::arch::asm;

pub mod eno;
pub mod nr;

#[inline(always)]
pub unsafe fn syscall0(n: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        "bns+ 1f",
        "neg 3, 3",
        "1:",
        inout("r0") n => _,
        out("r3") ret,
        out("r4") _,
        out("r5") _,
        out("r6") _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall1(n: usize, a1: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        "bns+ 1f",
        "neg 3, 3",
        "1:",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        out("r4") _,
        out("r5") _,
        out("r6") _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall2(n: usize, a1: usize, a2: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        "bns+ 1f",
        "neg 3, 3",
        "1:",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        out("r5") _,
        out("r6") _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall3(n: usize, a1: usize, a2: usize, a3: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        "bns+ 1f",
        "neg 3, 3",
        "1:",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        inout("r5") a3 => _,
        out("r6") _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall4(n: usize, a1: usize, a2: usize, a3: usize, a4: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        "bns+ 1f",
        "neg 3, 3",
        "1:",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        inout("r5") a3 => _,
        inout("r6") a4 => _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall5(n: usize, a1: usize, a2: usize, a3: usize, a4: usize, a5: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        "bns+ 1f",
        "neg 3, 3",
        "1:",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        inout("r5") a3 => _,
        inout("r6") a4 => _,
        inout("r7") a5 => _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall6(
    n: usize,
    a1: usize,
    a2: usize,
    a3: usize,
    a4: usize,
    a5: usize,
    a6: usize,
) -> usize {
    let ret: usize;
    asm!(
        "sc",
        "bns+ 1f",
        "neg 3, 3",
        "1:",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        inout("r5") a3 => _,
        inout("r6") a4 => _,
        inout("r7") a5 => _,
        inout("r8") a6 => _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall0_nofail(n: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        inout("r0") n => _,
        out("r3") ret,
        out("r4") _,
        out("r5") _,
        out("r6") _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall1_nofail(n: usize, a1: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        out("r4") _,
        out("r5") _,
        out("r6") _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall2_nofail(n: usize, a1: usize, a2: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        out("r5") _,
        out("r6") _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall3_nofail(n: usize, a1: usize, a2: usize, a3: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        inout("r5") a3 => _,
        out("r6") _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall4_nofail(n: usize, a1: usize, a2: usize, a3: usize, a4: usize) -> usize {
    let ret: usize;
    asm!(
        "sc",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        inout("r5") a3 => _,
        inout("r6") a4 => _,
        out("r7") _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall5_nofail(
    n: usize,
    a1: usize,
    a2: usize,
    a3: usize,
    a4: usize,
    a5: usize,
) -> usize {
    let ret: usize;
    asm!(
        "sc",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        inout("r5") a3 => _,
        inout("r6") a4 => _,
        inout("r7") a5 => _,
        out("r8") _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall6_nofail(
    n: usize,
    a1: usize,
    a2: usize,
    a3: usize,
    a4: usize,
    a5: usize,
    a6: usize,
) -> usize {
    let ret: usize;
    asm!(
        "sc",
        inout("r0") n => _,
        inout("r3") a1 => ret,
        inout("r4") a2 => _,
        inout("r5") a3 => _,
        inout("r6") a4 => _,
        inout("r7") a5 => _,
        inout("r8") a6 => _,
        out("r9") _,
        out("r10") _,
        out("r11") _,
        out("r12") _,
        out("cr0") _,
    );
    ret
}
