use core::arch::asm;

#[inline(always)]
pub unsafe fn syscall0(n: usize) -> usize {
    let ret: usize;
    asm!(
        "mov {r7_tmp}, r7",
        "mov r7, {n}",
        "swi #0",
        "mov r7, {r7_tmp}",
        r7_tmp = out(reg) _,
        n = in(reg) n,
        lateout("r0") ret,
        lateout("lr") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall1(n: usize, a1: usize) -> usize {
    let ret: usize;
    asm!(
        "mov {r7_tmp}, r7",
        "mov r7, {n}",
        "swi #0",
        "mov r7, {r7_tmp}",
        r7_tmp = out(reg) _,
        n = in(reg) n,
        inlateout("r0") a1 => ret,
        lateout("lr") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall2(n: usize, a1: usize, a2: usize) -> usize {
    let ret: usize;
    asm!(
        "mov {r7_tmp}, r7",
        "mov r7, {n}",
        "swi #0",
        "mov r7, {r7_tmp}",
        r7_tmp = out(reg) _,
        n = in(reg) n,
        inlateout("r0") a1 => ret,
        in("r1") a2,
        lateout("lr") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall3(n: usize, a1: usize, a2: usize, a3: usize) -> usize {
    let ret: usize;
    asm!(
        "mov {r7_tmp}, r7",
        "mov r7, {n}",
        "swi #0",
        "mov r7, {r7_tmp}",
        r7_tmp = out(reg) _,
        n = in(reg) n,
        inlateout("r0") a1 => ret,
        in("r1") a2,
        in("r2") a3,
        lateout("lr") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall4(n: usize, a1: usize, a2: usize, a3: usize, a4: usize) -> usize {
    let ret: usize;
    asm!(
        "mov {r7_tmp}, r7",
        "mov r7, {n}",
        "swi #0",
        "mov r7, {r7_tmp}",
        r7_tmp = out(reg) _,
        n = in(reg) n,
        inlateout("r0") a1 => ret,
        in("r1") a2,
        in("r2") a3,
        in("r3") a4,
        lateout("lr") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall5(n: usize, a1: usize, a2: usize, a3: usize, a4: usize, a5: usize) -> usize {
    let ret: usize;
    asm!(
        "mov {r7_tmp}, r7",
        "mov r7, {n}",
        "swi #0",
        "mov r7, {r7_tmp}",
        r7_tmp = out(reg) _,
        n = in(reg) n,
        inlateout("r0") a1 => ret,
        in("r1") a2,
        in("r2") a3,
        in("r3") a4,
        in("r4") a5,
        lateout("lr") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall6(
    n: usize,
    a1: usize,
    a2: usize,
    a3: usize,
    a4: usize,
    a5: usize,
    a6: usize,
) -> usize {
    let ret: usize;
    asm!(
        "mov {r7_tmp}, r7",
        "mov r7, {n}",
        "swi #0",
        "mov r7, {r7_tmp}",
        r7_tmp = out(reg) _,
        n = in(reg) n,
        inlateout("r0") a1 => ret,
        in("r1") a2,
        in("r2") a3,
        in("r3") a4,
        in("r4") a5,
        in("r5") a6,
        lateout("lr") _,
    );
    ret
}

#[inline(always)]
pub unsafe fn syscall7(
    n: usize,
    a1: usize,
    a2: usize,
    a3: usize,
    a4: usize,
    a5: usize,
    a6: usize,
    a7: usize,
) -> usize {
    let ret: usize;
    asm!(
        "push {{r6}}",
        "mov r6, {a7}",
        "mov {r7_tmp}, r7",
        "mov r7, {n}",
        "swi #0",
        "mov r7, {r7_tmp}",
        "pop {{r6}}",
        a7 = in(reg) a7,
        r7_tmp = out(reg) _,
        n = in(reg) n,
        inlateout("r0") a1 => ret,
        in("r1") a2,
        in("r2") a3,
        in("r3") a4,
        in("r4") a5,
        in("r5") a6,
        lateout("lr") _,
    );
    ret
}

pub use syscall0 as syscall0_nofail;
pub use syscall1 as syscall1_nofail;
pub use syscall2 as syscall2_nofail;
pub use syscall3 as syscall3_nofail;
pub use syscall4 as syscall4_nofail;
pub use syscall5 as syscall5_nofail;
pub use syscall6 as syscall6_nofail;
pub use syscall7 as syscall7_nofail;
