/*
 * Bare metal API
 *
 * # Introduction  Bare metal as a service allows ordering a dedicated server on-demand like a cloud instance. Dedicated servers could be used for large workloads, big data, those requiring more security, ….  This is the `v1` documentation, the `v1alpha1` version is available [here](/en/products/baremetal/api/v1alpha1).  ## Technical Limitations  - Bare metal is only available in `fr-par-2` zone  - Installation is done by preseed (± 10min) (preseed: complete install from a virtual media)  - The list of OS is limited, you can install your own using the following tutorial: https://www.scaleway.com/en/docs/bare-metal-server-installation-kvm-over-ip/  ## Features  - Install (Server is installed by preseed (preseed: complete install from a virtual media), you must define at least one ssh key to install your server)  - Start/Stop/Reboot  - Rescue Reboot, a rescue image is an operating system image designed to help you diagnose and fix an OS experiencing failures. When your server boot on rescue, you can mount your disks and start diagnosing/fixing your image.  - BMC access: Baseboard Management Controller (BMC) allows you to remotely access the low-level parameters of your dedicated server. For instance, your KVM-IP management console could be accessed with it.  - Billed by minute (The billing start when the server is delivered and stop when the server is deleted)  - IPv6, all servers are available with an IPv6 /128  - ReverseIP, You can configure your reverse IP (IPv4 and IPv6), you must register the server IP in your DNS records before calling the endpoint  - Basic monitoring with ping status  - IP failovers are not available in api v1, use the api v1alpha1  ## FAQ  ### How can I get my ssh key id ?  You can find your `$SCW_SECRET_KEY` and your `SCW_DEFAULT_ORGANIZATION_ID` at the following page: https://console.scaleway.com/project/credentials
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScalewayRdbV1Instance {
    /// Creation date (Format ISO 8601)
    #[serde(rename = "created_at", skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    #[serde(rename = "volume", skip_serializing_if = "Option::is_none")]
    pub volume: Option<Box<crate::models::ScalewayRdbV1InstanceVolume>>,
    /// Region the instance is in
    #[serde(rename = "region", skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    /// UUID of the instance
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Name of the instance
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Organization ID the instance belongs to
    #[serde(rename = "organization_id", skip_serializing_if = "Option::is_none")]
    pub organization_id: Option<String>,
    /// Project ID the instance belongs to
    #[serde(rename = "project_id", skip_serializing_if = "Option::is_none")]
    pub project_id: Option<String>,
    /// Status of the instance
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<Status>,
    /// Database engine of the database (PostgreSQL, MySQL, ...)
    #[serde(rename = "engine", skip_serializing_if = "Option::is_none")]
    pub engine: Option<String>,
    #[serde(rename = "endpoint", skip_serializing_if = "Option::is_none")]
    pub endpoint: Option<Box<crate::models::ScalewayRdbV1InstanceEndpoint>>,
    /// List of tags applied to the instance
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// Advanced settings of the instance
    #[serde(rename = "settings", skip_serializing_if = "Option::is_none")]
    pub settings: Option<Vec<crate::models::ScalewayRdbV1InstanceSetting>>,
    #[serde(rename = "backup_schedule", skip_serializing_if = "Option::is_none")]
    pub backup_schedule: Option<Box<crate::models::ScalewayRdbV1InstanceBackupSchedule>>,
    /// Whether or not High-Availability is enabled
    #[serde(rename = "is_ha_cluster", skip_serializing_if = "Option::is_none")]
    pub is_ha_cluster: Option<bool>,
    /// Read replicas of the instance
    #[serde(rename = "read_replicas", skip_serializing_if = "Option::is_none")]
    pub read_replicas: Option<Vec<crate::models::ScalewayRdbV1Endpoint>>,
    /// Node type of the instance
    #[serde(rename = "node_type", skip_serializing_if = "Option::is_none")]
    pub node_type: Option<String>,
    /// List of engine settings to be set at database initialisation
    #[serde(rename = "init_settings", skip_serializing_if = "Option::is_none")]
    pub init_settings: Option<Vec<crate::models::ScalewayRdbV1InstanceSetting>>,
}

impl ScalewayRdbV1Instance {
    pub fn new() -> ScalewayRdbV1Instance {
        ScalewayRdbV1Instance {
            created_at: None,
            volume: None,
            region: None,
            id: None,
            name: None,
            organization_id: None,
            project_id: None,
            status: None,
            engine: None,
            endpoint: None,
            tags: None,
            settings: None,
            backup_schedule: None,
            is_ha_cluster: None,
            read_replicas: None,
            node_type: None,
            init_settings: None,
        }
    }
}

/// Status of the instance
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Status {
    #[serde(rename = "unknown")]
    Unknown,
    #[serde(rename = "ready")]
    Ready,
    #[serde(rename = "provisioning")]
    Provisioning,
    #[serde(rename = "configuring")]
    Configuring,
    #[serde(rename = "deleting")]
    Deleting,
    #[serde(rename = "error")]
    Error,
    #[serde(rename = "autohealing")]
    Autohealing,
    #[serde(rename = "locked")]
    Locked,
    #[serde(rename = "initializing")]
    Initializing,
    #[serde(rename = "disk_full")]
    DiskFull,
    #[serde(rename = "backuping")]
    Backuping,
    #[serde(rename = "snapshotting")]
    Snapshotting,
}
