/*
 * Bare metal API
 *
 * # Introduction  Bare metal as a service allows ordering a dedicated server on-demand like a cloud instance. Dedicated servers could be used for large workloads, big data, those requiring more security, ….  This is the `v1` documentation, the `v1alpha1` version is available [here](/en/products/baremetal/api/v1alpha1).  ## Technical Limitations  - Bare metal is only available in `fr-par-2` zone  - Installation is done by preseed (± 10min) (preseed: complete install from a virtual media)  - The list of OS is limited, you can install your own using the following tutorial: https://www.scaleway.com/en/docs/bare-metal-server-installation-kvm-over-ip/  ## Features  - Install (Server is installed by preseed (preseed: complete install from a virtual media), you must define at least one ssh key to install your server)  - Start/Stop/Reboot  - Rescue Reboot, a rescue image is an operating system image designed to help you diagnose and fix an OS experiencing failures. When your server boot on rescue, you can mount your disks and start diagnosing/fixing your image.  - BMC access: Baseboard Management Controller (BMC) allows you to remotely access the low-level parameters of your dedicated server. For instance, your KVM-IP management console could be accessed with it.  - Billed by minute (The billing start when the server is delivered and stop when the server is deleted)  - IPv6, all servers are available with an IPv6 /128  - ReverseIP, You can configure your reverse IP (IPv4 and IPv6), you must register the server IP in your DNS records before calling the endpoint  - Basic monitoring with ping status  - IP failovers are not available in api v1, use the api v1alpha1  ## FAQ  ### How can I get my ssh key id ?  You can find your `$SCW_SECRET_KEY` and your `SCW_DEFAULT_ORGANIZATION_ID` at the following page: https://console.scaleway.com/project/credentials
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

///
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum ScalewayDomainV2beta1RecordType {
    #[serde(rename = "unknown")]
    Unknown,
    #[serde(rename = "A")]
    A,
    #[serde(rename = "AAAA")]
    AAAA,
    #[serde(rename = "CNAME")]
    CNAME,
    #[serde(rename = "TXT")]
    TXT,
    #[serde(rename = "SRV")]
    SRV,
    #[serde(rename = "TLSA")]
    TLSA,
    #[serde(rename = "MX")]
    MX,
    #[serde(rename = "NS")]
    NS,
    #[serde(rename = "PTR")]
    PTR,
    #[serde(rename = "CAA")]
    CAA,
    #[serde(rename = "ALIAS")]
    ALIAS,
    #[serde(rename = "LOC")]
    LOC,
    #[serde(rename = "SSHFP")]
    SSHFP,
    #[serde(rename = "HINFO")]
    HINFO,
    #[serde(rename = "RP")]
    RP,
    #[serde(rename = "URI")]
    URI,
    #[serde(rename = "DS")]
    DS,
    #[serde(rename = "NAPTR")]
    NAPTR,
}

impl ToString for ScalewayDomainV2beta1RecordType {
    fn to_string(&self) -> String {
        match self {
            Self::Unknown => String::from("unknown"),
            Self::A => String::from("A"),
            Self::AAAA => String::from("AAAA"),
            Self::CNAME => String::from("CNAME"),
            Self::TXT => String::from("TXT"),
            Self::SRV => String::from("SRV"),
            Self::TLSA => String::from("TLSA"),
            Self::MX => String::from("MX"),
            Self::NS => String::from("NS"),
            Self::PTR => String::from("PTR"),
            Self::CAA => String::from("CAA"),
            Self::ALIAS => String::from("ALIAS"),
            Self::LOC => String::from("LOC"),
            Self::SSHFP => String::from("SSHFP"),
            Self::HINFO => String::from("HINFO"),
            Self::RP => String::from("RP"),
            Self::URI => String::from("URI"),
            Self::DS => String::from("DS"),
            Self::NAPTR => String::from("NAPTR"),
        }
    }
}
