/*
 * Bare metal API
 *
 * # Introduction  Bare metal as a service allows ordering a dedicated server on-demand like a cloud instance. Dedicated servers could be used for large workloads, big data, those requiring more security, ….  This is the `v1` documentation, the `v1alpha1` version is available [here](/en/products/baremetal/api/v1alpha1).  ## Technical Limitations  - Bare metal is only available in `fr-par-2` zone  - Installation is done by preseed (± 10min) (preseed: complete install from a virtual media)  - The list of OS is limited, you can install your own using the following tutorial: https://www.scaleway.com/en/docs/bare-metal-server-installation-kvm-over-ip/  ## Features  - Install (Server is installed by preseed (preseed: complete install from a virtual media), you must define at least one ssh key to install your server)  - Start/Stop/Reboot  - Rescue Reboot, a rescue image is an operating system image designed to help you diagnose and fix an OS experiencing failures. When your server boot on rescue, you can mount your disks and start diagnosing/fixing your image.  - BMC access: Baseboard Management Controller (BMC) allows you to remotely access the low-level parameters of your dedicated server. For instance, your KVM-IP management console could be accessed with it.  - Billed by minute (The billing start when the server is delivered and stop when the server is deleted)  - IPv6, all servers are available with an IPv6 /128  - ReverseIP, You can configure your reverse IP (IPv4 and IPv6), you must register the server IP in your DNS records before calling the endpoint  - Basic monitoring with ping status  - IP failovers are not available in api v1, use the api v1alpha1  ## FAQ  ### How can I get my ssh key id ?  You can find your `$SCW_SECRET_KEY` and your `SCW_DEFAULT_ORGANIZATION_ID` at the following page: https://console.scaleway.com/project/credentials
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScalewayBaremetalV1Server {
    /// ID of the server
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Organization ID the server is attached to
    #[serde(rename = "organization_id", skip_serializing_if = "Option::is_none")]
    pub organization_id: Option<String>,
    /// Project ID the server is attached to
    #[serde(rename = "project_id", skip_serializing_if = "Option::is_none")]
    pub project_id: Option<String>,
    /// Name of the server
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Description of the server
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// Date of last modification of the server
    #[serde(rename = "updated_at", skip_serializing_if = "Option::is_none")]
    pub updated_at: Option<String>,
    /// Date of creation of the server
    #[serde(rename = "created_at", skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    /// Status of the server
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<Status>,
    /// Offer ID of the server
    #[serde(rename = "offer_id", skip_serializing_if = "Option::is_none")]
    pub offer_id: Option<String>,
    /// Array of customs tags attached to the server
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// Array of IPs attached to the server
    #[serde(rename = "ips", skip_serializing_if = "Option::is_none")]
    pub ips: Option<Vec<crate::models::ScalewayBaremetalV1Ip>>,
    /// Domain of the server
    #[serde(rename = "domain", skip_serializing_if = "Option::is_none")]
    pub domain: Option<String>,
    /// Boot type of the server
    #[serde(rename = "boot_type", skip_serializing_if = "Option::is_none")]
    pub boot_type: Option<BootType>,
    /// The zone in which is the server
    #[serde(rename = "zone", skip_serializing_if = "Option::is_none")]
    pub zone: Option<String>,
    #[serde(rename = "install", skip_serializing_if = "Option::is_none")]
    pub install: Option<Box<crate::models::ScalewayBaremetalV1ServerInstall>>,
    /// Server status of ping
    #[serde(rename = "ping_status", skip_serializing_if = "Option::is_none")]
    pub ping_status: Option<PingStatus>,
}

impl ScalewayBaremetalV1Server {
    pub fn new() -> ScalewayBaremetalV1Server {
        ScalewayBaremetalV1Server {
            id: None,
            organization_id: None,
            project_id: None,
            name: None,
            description: None,
            updated_at: None,
            created_at: None,
            status: None,
            offer_id: None,
            tags: None,
            ips: None,
            domain: None,
            boot_type: None,
            zone: None,
            install: None,
            ping_status: None,
        }
    }
}

/// Status of the server
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Status {
    #[serde(rename = "unknown")]
    Unknown,
    #[serde(rename = "delivering")]
    Delivering,
    #[serde(rename = "ready")]
    Ready,
    #[serde(rename = "stopping")]
    Stopping,
    #[serde(rename = "stopped")]
    Stopped,
    #[serde(rename = "starting")]
    Starting,
    #[serde(rename = "error")]
    Error,
    #[serde(rename = "deleting")]
    Deleting,
    #[serde(rename = "locked")]
    Locked,
    #[serde(rename = "out_of_stock")]
    OutOfStock,
}
/// Boot type of the server
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum BootType {
    #[serde(rename = "unknown_boot_type")]
    UnknownBootType,
    #[serde(rename = "normal")]
    Normal,
    #[serde(rename = "rescue")]
    Rescue,
}
/// Server status of ping
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum PingStatus {
    #[serde(rename = "ping_status_unknown")]
    Unknown,
    #[serde(rename = "ping_status_up")]
    Up,
    #[serde(rename = "ping_status_down")]
    Down,
}
