/*
 * Bare metal API
 *
 * # Introduction  Bare metal as a service allows ordering a dedicated server on-demand like a cloud instance. Dedicated servers could be used for large workloads, big data, those requiring more security, ….  This is the `v1` documentation, the `v1alpha1` version is available [here](/en/products/baremetal/api/v1alpha1).  ## Technical Limitations  - Bare metal is only available in `fr-par-2` zone  - Installation is done by preseed (± 10min) (preseed: complete install from a virtual media)  - The list of OS is limited, you can install your own using the following tutorial: https://www.scaleway.com/en/docs/bare-metal-server-installation-kvm-over-ip/  ## Features  - Install (Server is installed by preseed (preseed: complete install from a virtual media), you must define at least one ssh key to install your server)  - Start/Stop/Reboot  - Rescue Reboot, a rescue image is an operating system image designed to help you diagnose and fix an OS experiencing failures. When your server boot on rescue, you can mount your disks and start diagnosing/fixing your image.  - BMC access: Baseboard Management Controller (BMC) allows you to remotely access the low-level parameters of your dedicated server. For instance, your KVM-IP management console could be accessed with it.  - Billed by minute (The billing start when the server is delivered and stop when the server is deleted)  - IPv6, all servers are available with an IPv6 /128  - ReverseIP, You can configure your reverse IP (IPv4 and IPv6), you must register the server IP in your DNS records before calling the endpoint  - Basic monitoring with ping status  - IP failovers are not available in api v1, use the api v1alpha1  ## FAQ  ### How can I get my ssh key id ?  You can find your `$SCW_SECRET_KEY` and your `SCW_DEFAULT_ORGANIZATION_ID` at the following page: https://console.scaleway.com/project/credentials
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScalewayBaremetalV1Offer {
    /// ID of the offer
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Name of the offer
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Stock level
    #[serde(rename = "stock", skip_serializing_if = "Option::is_none")]
    pub stock: Option<Stock>,
    /// Bandwidth available in bits/s with the offer
    #[serde(rename = "bandwidth", skip_serializing_if = "Option::is_none")]
    pub bandwidth: Option<f32>,
    /// Commercial range of the offer
    #[serde(rename = "commercial_range", skip_serializing_if = "Option::is_none")]
    pub commercial_range: Option<String>,
    #[serde(rename = "price_per_hour", skip_serializing_if = "Option::is_none")]
    pub price_per_hour: Option<Box<crate::models::ScalewayBaremetalV1OfferPricePerHour>>,
    #[serde(rename = "price_per_month", skip_serializing_if = "Option::is_none")]
    pub price_per_month: Option<Box<crate::models::ScalewayBaremetalV1OfferPricePerMonth>>,
    /// Disks specifications of the offer
    #[serde(rename = "disks", skip_serializing_if = "Option::is_none")]
    pub disks: Option<Vec<crate::models::ScalewayBaremetalV1Disk>>,
    /// True if the offer is currently available
    #[serde(rename = "enable", skip_serializing_if = "Option::is_none")]
    pub enable: Option<bool>,
    /// CPU specifications of the offer
    #[serde(rename = "cpus", skip_serializing_if = "Option::is_none")]
    pub cpus: Option<Vec<crate::models::ScalewayBaremetalV1Cpu>>,
    /// Memory specifications of the offer
    #[serde(rename = "memories", skip_serializing_if = "Option::is_none")]
    pub memories: Option<Vec<crate::models::ScalewayBaremetalV1Memory>>,
    /// Name of the quota associated to the offer
    #[serde(rename = "quota_name", skip_serializing_if = "Option::is_none")]
    pub quota_name: Option<String>,
    /// Persistent memory specifications of the offer
    #[serde(
        rename = "persistent_memories",
        skip_serializing_if = "Option::is_none"
    )]
    pub persistent_memories: Option<Vec<crate::models::ScalewayBaremetalV1PersistentMemory>>,
    /// Raid controller specifications of the offer
    #[serde(rename = "raid_controllers", skip_serializing_if = "Option::is_none")]
    pub raid_controllers: Option<Vec<crate::models::ScalewayBaremetalV1RaidController>>,
    /// Array of incompatible OS ids
    #[serde(
        rename = "incompatible_os_ids",
        skip_serializing_if = "Option::is_none"
    )]
    pub incompatible_os_ids: Option<Vec<String>>,
}

impl ScalewayBaremetalV1Offer {
    pub fn new() -> ScalewayBaremetalV1Offer {
        ScalewayBaremetalV1Offer {
            id: None,
            name: None,
            stock: None,
            bandwidth: None,
            commercial_range: None,
            price_per_hour: None,
            price_per_month: None,
            disks: None,
            enable: None,
            cpus: None,
            memories: None,
            quota_name: None,
            persistent_memories: None,
            raid_controllers: None,
            incompatible_os_ids: None,
        }
    }
}

/// Stock level
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Stock {
    #[serde(rename = "empty")]
    Empty,
    #[serde(rename = "low")]
    Low,
    #[serde(rename = "available")]
    Available,
}
