/*
 * Bare metal API
 *
 * # Introduction  Bare metal as a service allows ordering a dedicated server on-demand like a cloud instance. Dedicated servers could be used for large workloads, big data, those requiring more security, ….  This is the `v1` documentation, the `v1alpha1` version is available [here](/en/products/baremetal/api/v1alpha1).  ## Technical Limitations  - Bare metal is only available in `fr-par-2` zone  - Installation is done by preseed (± 10min) (preseed: complete install from a virtual media)  - The list of OS is limited, you can install your own using the following tutorial: https://www.scaleway.com/en/docs/bare-metal-server-installation-kvm-over-ip/  ## Features  - Install (Server is installed by preseed (preseed: complete install from a virtual media), you must define at least one ssh key to install your server)  - Start/Stop/Reboot  - Rescue Reboot, a rescue image is an operating system image designed to help you diagnose and fix an OS experiencing failures. When your server boot on rescue, you can mount your disks and start diagnosing/fixing your image.  - BMC access: Baseboard Management Controller (BMC) allows you to remotely access the low-level parameters of your dedicated server. For instance, your KVM-IP management console could be accessed with it.  - Billed by minute (The billing start when the server is delivered and stop when the server is deleted)  - IPv6, all servers are available with an IPv6 /128  - ReverseIP, You can configure your reverse IP (IPv4 and IPv6), you must register the server IP in your DNS records before calling the endpoint  - Basic monitoring with ping status  - IP failovers are not available in api v1, use the api v1alpha1  ## FAQ  ### How can I get my ssh key id ?  You can find your `$SCW_SECRET_KEY` and your `SCW_DEFAULT_ORGANIZATION_ID` at the following page: https://console.scaleway.com/project/credentials
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InlineObject10 {
    /// Please use `project_id` instead
    #[serde(rename = "organization_id", skip_serializing_if = "Option::is_none")]
    pub organization_id: Option<String>,
    /// The project ID on which to create the instance
    #[serde(rename = "project_id", skip_serializing_if = "Option::is_none")]
    pub project_id: Option<String>,
    /// Name of the instance
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Database engine of the database (PostgreSQL, MySQL, ...)
    #[serde(rename = "engine")]
    pub engine: String,
    /// Name of the user created when the instance is created
    #[serde(rename = "user_name")]
    pub user_name: String,
    /// Password of the user
    #[serde(rename = "password")]
    pub password: String,
    /// Type of node to use for the instance
    #[serde(rename = "node_type")]
    pub node_type: String,
    /// Whether or not High-Availability is enabled
    #[serde(rename = "is_ha_cluster", skip_serializing_if = "Option::is_none")]
    pub is_ha_cluster: Option<bool>,
    /// Whether or not backups are disabled
    #[serde(rename = "disable_backup", skip_serializing_if = "Option::is_none")]
    pub disable_backup: Option<bool>,
    /// Tags to apply to the instance
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// List of engine settings to be set at database initialisation
    #[serde(rename = "init_settings", skip_serializing_if = "Option::is_none")]
    pub init_settings: Option<Vec<crate::models::ScalewayRdbV1InstanceSetting>>,
    /// Type of volume where data are stored (lssd, bssd, ...)
    #[serde(rename = "volume_type", skip_serializing_if = "Option::is_none")]
    pub volume_type: Option<VolumeType>,
    /// Volume size when volume_type is not lssd (in bytes)
    #[serde(rename = "volume_size", skip_serializing_if = "Option::is_none")]
    pub volume_size: Option<f32>,
}

impl InlineObject10 {
    pub fn new(
        engine: String,
        user_name: String,
        password: String,
        node_type: String,
    ) -> InlineObject10 {
        InlineObject10 {
            organization_id: None,
            project_id: None,
            name: None,
            engine,
            user_name,
            password,
            node_type,
            is_ha_cluster: None,
            disable_backup: None,
            tags: None,
            init_settings: None,
            volume_type: None,
            volume_size: None,
        }
    }
}

/// Type of volume where data are stored (lssd, bssd, ...)
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum VolumeType {
    #[serde(rename = "lssd")]
    Lssd,
    #[serde(rename = "bssd")]
    Bssd,
}
