<!--- Text to be prepended to generated README.md -->
[![build / test / fmt](https://github.com/Qovery/scaleway-api-rs/actions/workflows/rust.yml/badge.svg)](https://github.com/Qovery/scaleway-api-rs/actions/workflows/rust.yml)
[![crate publish](https://github.com/Qovery/scaleway-api-rs/actions/workflows/publish-crate.yml/badge.svg)](https://github.com/Qovery/scaleway-api-rs/actions/workflows/publish-crate.yml)
[![publish](https://img.shields.io/badge/rust--doc-latest-orange)](https://docs.rs/scaleway_api_rs/latest/scaleway_api_rs/)
[![Crates.io](https://img.shields.io/badge/crates.io-latest-orange)](https://crates.io/crates/scaleway_api_rs)


# Notes

This Scaleway API Crate is created and maintained by [Qovery](https://www.qovery.com) and used in production in the [Qovery Engine](https://github.com/Qovery/engine/).

This project relies on OpenAPI Generator, refers to [UPDATE.md](UPDATE.md) to update generated code.
# Rust API client for scaleway_api_rs

# Introduction

Bare metal as a service allows ordering a dedicated server on-demand like a cloud instance.
Dedicated servers could be used for large workloads, big data, those requiring more security, ….

This is the `v1` documentation, the `v1alpha1` version is available [here](/en/products/baremetal/api/v1alpha1).

## Technical Limitations

- Bare metal is only available in `fr-par-2` zone

- Installation is done by preseed (± 10min) (preseed: complete install from a virtual media)

- The list of OS is limited, you can install your own using the following tutorial: https://www.scaleway.com/en/docs/bare-metal-server-installation-kvm-over-ip/

## Features

- Install (Server is installed by preseed (preseed: complete install from a virtual media), you must define at least one ssh key to install your server)

- Start/Stop/Reboot

- Rescue Reboot, a rescue image is an operating system image designed to help you diagnose and fix an OS experiencing failures. When your server boot on rescue, you can mount your disks and start diagnosing/fixing your image.

- BMC access: Baseboard Management Controller (BMC) allows you to remotely access the low-level parameters of your dedicated server. For instance, your KVM-IP management console could be accessed with it.

- Billed by minute (The billing start when the server is delivered and stop when the server is deleted)

- IPv6, all servers are available with an IPv6 /128

- ReverseIP, You can configure your reverse IP (IPv4 and IPv6), you must register the server IP in your DNS records before calling the endpoint

- Basic monitoring with ping status

- IP failovers are not available in api v1, use the api v1alpha1

## FAQ

### How can I get my ssh key id ?

You can find your `$SCW_SECRET_KEY` and your `SCW_DEFAULT_ORGANIZATION_ID` at the following page: https://console.scaleway.com/project/credentials


## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: v1
- Package version: 0.1.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *https://api.scaleway.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ACLApi* | [**add_instance_acl_rules**](docs/ACLApi.md#add_instance_acl_rules) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/acls | Add an ACL instance to a given instance
*ACLApi* | [**delete_instance_acl_rules**](docs/ACLApi.md#delete_instance_acl_rules) | **DELETE** /rdb/v1/regions/{region}/instances/{instance_id}/acls | Delete ACL rules of a given instance
*ACLApi* | [**list_instance_acl_rules**](docs/ACLApi.md#list_instance_acl_rules) | **GET** /rdb/v1/regions/{region}/instances/{instance_id}/acls | List ACL rules of a given instance
*ACLApi* | [**set_instance_acl_rules**](docs/ACLApi.md#set_instance_acl_rules) | **PUT** /rdb/v1/regions/{region}/instances/{instance_id}/acls | Set ACL rules for a given instance
*BMCAccessApi* | [**get_bmc_access**](docs/BMCAccessApi.md#get_bmc_access) | **GET** /baremetal/v1/zones/{zone}/servers/{server_id}/bmc-access | Get BMC (Baseboard Management Controller) access for a given baremetal server
*BMCAccessApi* | [**start_bmc_access**](docs/BMCAccessApi.md#start_bmc_access) | **POST** /baremetal/v1/zones/{zone}/servers/{server_id}/bmc-access | Start BMC (Baseboard Management Controller) access for a given baremetal server
*BMCAccessApi* | [**stop_bmc_access**](docs/BMCAccessApi.md#stop_bmc_access) | **DELETE** /baremetal/v1/zones/{zone}/servers/{server_id}/bmc-access | Stop BMC (Baseboard Management Controller) access for a given baremetal server
*BackupsApi* | [**create_database_backup**](docs/BackupsApi.md#create_database_backup) | **POST** /rdb/v1/regions/{region}/backups | Create a database backup
*BackupsApi* | [**delete_database_backup**](docs/BackupsApi.md#delete_database_backup) | **DELETE** /rdb/v1/regions/{region}/backups/{database_backup_id} | Delete a database backup
*BackupsApi* | [**export_database_backup**](docs/BackupsApi.md#export_database_backup) | **POST** /rdb/v1/regions/{region}/backups/{database_backup_id}/export | Export a database backup
*BackupsApi* | [**get_database_backup**](docs/BackupsApi.md#get_database_backup) | **GET** /rdb/v1/regions/{region}/backups/{database_backup_id} | Get a database backup
*BackupsApi* | [**list_database_backups**](docs/BackupsApi.md#list_database_backups) | **GET** /rdb/v1/regions/{region}/backups | List database backups
*BackupsApi* | [**restore_database_backup**](docs/BackupsApi.md#restore_database_backup) | **POST** /rdb/v1/regions/{region}/backups/{database_backup_id}/restore | Restore a database backup
*BackupsApi* | [**update_database_backup**](docs/BackupsApi.md#update_database_backup) | **PATCH** /rdb/v1/regions/{region}/backups/{database_backup_id} | Update a database backup
*ClustersApi* | [**create_cluster**](docs/ClustersApi.md#create_cluster) | **POST** /k8s/v1/regions/{region}/clusters | Create a new cluster
*ClustersApi* | [**delete_cluster**](docs/ClustersApi.md#delete_cluster) | **DELETE** /k8s/v1/regions/{region}/clusters/{cluster_id} | Delete a cluster
*ClustersApi* | [**get_cluster**](docs/ClustersApi.md#get_cluster) | **GET** /k8s/v1/regions/{region}/clusters/{cluster_id} | Get a cluster
*ClustersApi* | [**get_cluster_kube_config**](docs/ClustersApi.md#get_cluster_kube_config) | **GET** /k8s/v1/regions/{region}/clusters/{cluster_id}/kubeconfig | Download the kubeconfig for a cluster
*ClustersApi* | [**list_cluster_available_versions**](docs/ClustersApi.md#list_cluster_available_versions) | **GET** /k8s/v1/regions/{region}/clusters/{cluster_id}/available-versions | List available versions for a cluster
*ClustersApi* | [**list_clusters**](docs/ClustersApi.md#list_clusters) | **GET** /k8s/v1/regions/{region}/clusters | List all the clusters
*ClustersApi* | [**reset_cluster_admin_token**](docs/ClustersApi.md#reset_cluster_admin_token) | **POST** /k8s/v1/regions/{region}/clusters/{cluster_id}/reset-admin-token | Reset the admin token of a cluster
*ClustersApi* | [**update_cluster**](docs/ClustersApi.md#update_cluster) | **PATCH** /k8s/v1/regions/{region}/clusters/{cluster_id} | Update a cluster
*ClustersApi* | [**upgrade_cluster**](docs/ClustersApi.md#upgrade_cluster) | **POST** /k8s/v1/regions/{region}/clusters/{cluster_id}/upgrade | Upgrade a cluster
*DNSZonesApi* | [**clone_dns_zone**](docs/DNSZonesApi.md#clone_dns_zone) | **POST** /domain/v2beta1/dns-zones/{dns_zone}/clone | Clone a DNS zone
*DNSZonesApi* | [**create_dns_zone**](docs/DNSZonesApi.md#create_dns_zone) | **POST** /domain/v2beta1/dns-zones | Create a DNS zone
*DNSZonesApi* | [**create_ssl_certificate**](docs/DNSZonesApi.md#create_ssl_certificate) | **POST** /domain/v2beta1/ssl-certificates | Create or return the zone TLS certificate
*DNSZonesApi* | [**delete_dns_zone**](docs/DNSZonesApi.md#delete_dns_zone) | **DELETE** /domain/v2beta1/dns-zones/{dns_zone} | Delete DNS zone
*DNSZonesApi* | [**delete_dns_zone_tsig_key**](docs/DNSZonesApi.md#delete_dns_zone_tsig_key) | **DELETE** /domain/v2beta1/dns-zones/{dns_zone}/tsig-key | Delete the DNS zone TSIG Key
*DNSZonesApi* | [**delete_ssl_certificate**](docs/DNSZonesApi.md#delete_ssl_certificate) | **DELETE** /domain/v2beta1/ssl-certificates/{dns_zone} | Delete an TLS certificate
*DNSZonesApi* | [**get_dns_zone_tsig_key**](docs/DNSZonesApi.md#get_dns_zone_tsig_key) | **GET** /domain/v2beta1/dns-zones/{dns_zone}/tsig-key | Get the DNS zone TSIG Key
*DNSZonesApi* | [**get_ssl_certificate**](docs/DNSZonesApi.md#get_ssl_certificate) | **GET** /domain/v2beta1/ssl-certificates/{dns_zone} | Get the zone TLS certificate if it exists
*DNSZonesApi* | [**list_dns_zones**](docs/DNSZonesApi.md#list_dns_zones) | **GET** /domain/v2beta1/dns-zones | List DNS zones
*DNSZonesApi* | [**list_ssl_certificates**](docs/DNSZonesApi.md#list_ssl_certificates) | **GET** /domain/v2beta1/ssl-certificates | List all user TLS certificates
*DNSZonesApi* | [**refresh_dns_zone**](docs/DNSZonesApi.md#refresh_dns_zone) | **POST** /domain/v2beta1/dns-zones/{dns_zone}/refresh | Refresh DNS zone
*DNSZonesApi* | [**update_dns_zone**](docs/DNSZonesApi.md#update_dns_zone) | **PATCH** /domain/v2beta1/dns-zones/{dns_zone} | Update a DNS zone
*DatabaseInstancesApi* | [**clone_instance**](docs/DatabaseInstancesApi.md#clone_instance) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/clone | Clone an instance
*DatabaseInstancesApi* | [**create_instance**](docs/DatabaseInstancesApi.md#create_instance) | **POST** /rdb/v1/regions/{region}/instances | Create an instance
*DatabaseInstancesApi* | [**delete_instance**](docs/DatabaseInstancesApi.md#delete_instance) | **DELETE** /rdb/v1/regions/{region}/instances/{instance_id} | Delete an instance
*DatabaseInstancesApi* | [**get_instance**](docs/DatabaseInstancesApi.md#get_instance) | **GET** /rdb/v1/regions/{region}/instances/{instance_id} | Get an instance
*DatabaseInstancesApi* | [**get_instance_certificate**](docs/DatabaseInstancesApi.md#get_instance_certificate) | **GET** /rdb/v1/regions/{region}/instances/{instance_id}/certificate | Get the TLS certificate of an instance
*DatabaseInstancesApi* | [**get_instance_log**](docs/DatabaseInstancesApi.md#get_instance_log) | **GET** /rdb/v1/regions/{region}/logs/{instance_log_id} | Get specific logs of a given instance
*DatabaseInstancesApi* | [**get_instance_metrics**](docs/DatabaseInstancesApi.md#get_instance_metrics) | **GET** /rdb/v1/regions/{region}/instances/{instance_id}/metrics | Get instance metrics
*DatabaseInstancesApi* | [**list_instance_logs**](docs/DatabaseInstancesApi.md#list_instance_logs) | **GET** /rdb/v1/regions/{region}/instances/{instance_id}/logs | List available logs of a given instance
*DatabaseInstancesApi* | [**list_instances**](docs/DatabaseInstancesApi.md#list_instances) | **GET** /rdb/v1/regions/{region}/instances | List instances
*DatabaseInstancesApi* | [**prepare_instance_logs**](docs/DatabaseInstancesApi.md#prepare_instance_logs) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/prepare-logs | Prepare logs of a given instance
*DatabaseInstancesApi* | [**update_instance**](docs/DatabaseInstancesApi.md#update_instance) | **PATCH** /rdb/v1/regions/{region}/instances/{instance_id} | Update an instance
*DatabaseInstancesApi* | [**upgrade_instance**](docs/DatabaseInstancesApi.md#upgrade_instance) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/upgrade | Upgrade an instance to an higher instance type
*DatabasesApi* | [**create_database**](docs/DatabasesApi.md#create_database) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/databases | Create a database in a given instance
*DatabasesApi* | [**delete_database**](docs/DatabasesApi.md#delete_database) | **DELETE** /rdb/v1/regions/{region}/instances/{instance_id}/databases/{name} | Delete a database in a given instance
*DatabasesApi* | [**list_databases**](docs/DatabasesApi.md#list_databases) | **GET** /rdb/v1/regions/{region}/instances/{instance_id}/databases | List all database in a given instance
*DefaultApi* | [**get_service_info**](docs/DefaultApi.md#get_service_info) | **GET** /rdb/v1/regions/{region} | 
*DefaultApi* | [**move_mac_addr**](docs/DefaultApi.md#move_mac_addr) | **POST** /flexible-ip/v1alpha1/zones/{zone}/fips/{fip_id}/mac/move | 
*DefaultApi* | [**renew_instance_certificate**](docs/DefaultApi.md#renew_instance_certificate) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/renew-certificate | 
*EnginesApi* | [**list_database_engines**](docs/EnginesApi.md#list_database_engines) | **GET** /rdb/v1/regions/{region}/database-engines | List available database engines
*FlexibleIPApi* | [**attach_flexible_ip**](docs/FlexibleIPApi.md#attach_flexible_ip) | **POST** /flexible-ip/v1alpha1/zones/{zone}/fips/attach | Attach a Flexible IP to a server
*FlexibleIPApi* | [**create_flexible_ip**](docs/FlexibleIPApi.md#create_flexible_ip) | **POST** /flexible-ip/v1alpha1/zones/{zone}/fips | Create a Flexible IP
*FlexibleIPApi* | [**delete_flexible_ip**](docs/FlexibleIPApi.md#delete_flexible_ip) | **DELETE** /flexible-ip/v1alpha1/zones/{zone}/fips/{fip_id} | Delete a Flexible IP
*FlexibleIPApi* | [**delete_mac_addr**](docs/FlexibleIPApi.md#delete_mac_addr) | **DELETE** /flexible-ip/v1alpha1/zones/{zone}/fips/{fip_id}/mac | Remove a virtual MAC from a Flexible IP
*FlexibleIPApi* | [**detach_flexible_ip**](docs/FlexibleIPApi.md#detach_flexible_ip) | **POST** /flexible-ip/v1alpha1/zones/{zone}/fips/detach | Detach a Flexible IP from a server
*FlexibleIPApi* | [**duplicate_mac_addr**](docs/FlexibleIPApi.md#duplicate_mac_addr) | **POST** /flexible-ip/v1alpha1/zones/{zone}/fips/{fip_id}/mac/duplicate | Duplicate a Virtual MAC
*FlexibleIPApi* | [**generate_mac_addr**](docs/FlexibleIPApi.md#generate_mac_addr) | **POST** /flexible-ip/v1alpha1/zones/{zone}/fips/{fip_id}/mac | Generate a virtual MAC on a given Flexible IP
*FlexibleIPApi* | [**get_flexible_ip**](docs/FlexibleIPApi.md#get_flexible_ip) | **GET** /flexible-ip/v1alpha1/zones/{zone}/fips/{fip_id} | Get a Flexible IP
*FlexibleIPApi* | [**list_flexible_ips**](docs/FlexibleIPApi.md#list_flexible_ips) | **GET** /flexible-ip/v1alpha1/zones/{zone}/fips | List Flexible IPs
*FlexibleIPApi* | [**update_flexible_ip**](docs/FlexibleIPApi.md#update_flexible_ip) | **PATCH** /flexible-ip/v1alpha1/zones/{zone}/fips/{fip_id} | Update a Flexible IP
*ImagesApi* | [**delete_image**](docs/ImagesApi.md#delete_image) | **DELETE** /registry/v1/regions/{region}/images/{image_id} | Delete an image
*ImagesApi* | [**get_image**](docs/ImagesApi.md#get_image) | **GET** /registry/v1/regions/{region}/images/{image_id} | Get a image
*ImagesApi* | [**list_images**](docs/ImagesApi.md#list_images) | **GET** /registry/v1/regions/{region}/images | List all your images
*ImagesApi* | [**update_image**](docs/ImagesApi.md#update_image) | **PATCH** /registry/v1/regions/{region}/images/{image_id} | Update an existing image
*ImportsExportsApi* | [**export_raw_dns_zone**](docs/ImportsExportsApi.md#export_raw_dns_zone) | **GET** /domain/v2beta1/dns-zones/{dns_zone}/raw | Export raw DNS zone
*ImportsExportsApi* | [**import_provider_dns_zone**](docs/ImportsExportsApi.md#import_provider_dns_zone) | **POST** /domain/v2beta1/dns-zones/{dns_zone}/import-provider | Import provider DNS zone
*ImportsExportsApi* | [**import_raw_dns_zone**](docs/ImportsExportsApi.md#import_raw_dns_zone) | **POST** /domain/v2beta1/dns-zones/{dns_zone}/raw | Import raw DNS zone
*InstanceSettingsApi* | [**add_instance_settings**](docs/InstanceSettingsApi.md#add_instance_settings) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/settings | Add an instance setting
*InstanceSettingsApi* | [**delete_instance_settings**](docs/InstanceSettingsApi.md#delete_instance_settings) | **DELETE** /rdb/v1/regions/{region}/instances/{instance_id}/settings | Delete an instance setting
*InstanceSettingsApi* | [**set_instance_settings**](docs/InstanceSettingsApi.md#set_instance_settings) | **PUT** /rdb/v1/regions/{region}/instances/{instance_id}/settings | Set a given instance setting
*NamespacesApi* | [**create_namespace**](docs/NamespacesApi.md#create_namespace) | **POST** /registry/v1/regions/{region}/namespaces | Create a new namespace
*NamespacesApi* | [**delete_namespace**](docs/NamespacesApi.md#delete_namespace) | **DELETE** /registry/v1/regions/{region}/namespaces/{namespace_id} | Delete an existing namespace
*NamespacesApi* | [**get_namespace**](docs/NamespacesApi.md#get_namespace) | **GET** /registry/v1/regions/{region}/namespaces/{namespace_id} | Get a namespace
*NamespacesApi* | [**list_namespaces**](docs/NamespacesApi.md#list_namespaces) | **GET** /registry/v1/regions/{region}/namespaces | List all your namespaces
*NamespacesApi* | [**update_namespace**](docs/NamespacesApi.md#update_namespace) | **PATCH** /registry/v1/regions/{region}/namespaces/{namespace_id} | Update an existing namespace
*NodeTypesApi* | [**list_node_types**](docs/NodeTypesApi.md#list_node_types) | **GET** /rdb/v1/regions/{region}/node-types | List available node types
*NodesApi* | [**get_node**](docs/NodesApi.md#get_node) | **GET** /k8s/v1/regions/{region}/nodes/{node_id} | Get a node in a cluster
*NodesApi* | [**list_nodes**](docs/NodesApi.md#list_nodes) | **GET** /k8s/v1/regions/{region}/clusters/{cluster_id}/nodes | List all the nodes in a cluster
*NodesApi* | [**reboot_node**](docs/NodesApi.md#reboot_node) | **POST** /k8s/v1/regions/{region}/nodes/{node_id}/reboot | Reboot a node in a cluster
*NodesApi* | [**replace_node**](docs/NodesApi.md#replace_node) | **POST** /k8s/v1/regions/{region}/nodes/{node_id}/replace | Replace a node in a cluster
*OSApi* | [**get_os**](docs/OSApi.md#get_os) | **GET** /baremetal/v1/zones/{zone}/os/{os_id} | Get an OS with a given ID
*OSApi* | [**list_os**](docs/OSApi.md#list_os) | **GET** /baremetal/v1/zones/{zone}/os | List all available OS that can be install on a baremetal server
*OffersApi* | [**get_offer**](docs/OffersApi.md#get_offer) | **GET** /baremetal/v1/zones/{zone}/offers/{offer_id} | Get offer
*OffersApi* | [**list_offers**](docs/OffersApi.md#list_offers) | **GET** /baremetal/v1/zones/{zone}/offers | List offers
*PoolsApi* | [**create_pool**](docs/PoolsApi.md#create_pool) | **POST** /k8s/v1/regions/{region}/clusters/{cluster_id}/pools | Create a new pool in a cluster
*PoolsApi* | [**delete_pool**](docs/PoolsApi.md#delete_pool) | **DELETE** /k8s/v1/regions/{region}/pools/{pool_id} | Delete a pool in a cluster
*PoolsApi* | [**get_pool**](docs/PoolsApi.md#get_pool) | **GET** /k8s/v1/regions/{region}/pools/{pool_id} | Get a pool in a cluster
*PoolsApi* | [**list_pools**](docs/PoolsApi.md#list_pools) | **GET** /k8s/v1/regions/{region}/clusters/{cluster_id}/pools | List all the pools in a cluster
*PoolsApi* | [**update_pool**](docs/PoolsApi.md#update_pool) | **PATCH** /k8s/v1/regions/{region}/pools/{pool_id} | Update a pool in a cluster
*PoolsApi* | [**upgrade_pool**](docs/PoolsApi.md#upgrade_pool) | **POST** /k8s/v1/regions/{region}/pools/{pool_id}/upgrade | Upgrade a pool in a cluster
*PrivateNetworksApi* | [**create_private_network**](docs/PrivateNetworksApi.md#create_private_network) | **POST** /vpc/v1/zones/{zone}/private-networks | Create a private network
*PrivateNetworksApi* | [**delete_private_network**](docs/PrivateNetworksApi.md#delete_private_network) | **DELETE** /vpc/v1/zones/{zone}/private-networks/{private_network_id} | Delete a private network
*PrivateNetworksApi* | [**get_private_network**](docs/PrivateNetworksApi.md#get_private_network) | **GET** /vpc/v1/zones/{zone}/private-networks/{private_network_id} | Get a private network
*PrivateNetworksApi* | [**list_private_networks**](docs/PrivateNetworksApi.md#list_private_networks) | **GET** /vpc/v1/zones/{zone}/private-networks | List private networks
*PrivateNetworksApi* | [**update_private_network**](docs/PrivateNetworksApi.md#update_private_network) | **PATCH** /vpc/v1/zones/{zone}/private-networks/{private_network_id} | Update private network
*PrivilegesApi* | [**list_privileges**](docs/PrivilegesApi.md#list_privileges) | **GET** /rdb/v1/regions/{region}/instances/{instance_id}/privileges | List privileges of a given user for a given database on a given instance
*PrivilegesApi* | [**set_privilege**](docs/PrivilegesApi.md#set_privilege) | **PUT** /rdb/v1/regions/{region}/instances/{instance_id}/privileges | Set privileges of a given user for a given database on a given instance
*RecordsApi* | [**clear_dns_zone_records**](docs/RecordsApi.md#clear_dns_zone_records) | **DELETE** /domain/v2beta1/dns-zones/{dns_zone}/records | Clear DNS zone records
*RecordsApi* | [**list_dns_zone_nameservers**](docs/RecordsApi.md#list_dns_zone_nameservers) | **GET** /domain/v2beta1/dns-zones/{dns_zone}/nameservers | List DNS zone nameservers
*RecordsApi* | [**list_dns_zone_records**](docs/RecordsApi.md#list_dns_zone_records) | **GET** /domain/v2beta1/dns-zones/{dns_zone}/records | List DNS zone records
*RecordsApi* | [**update_dns_zone_nameservers**](docs/RecordsApi.md#update_dns_zone_nameservers) | **PUT** /domain/v2beta1/dns-zones/{dns_zone}/nameservers | Update DNS zone nameservers
*RecordsApi* | [**update_dns_zone_records**](docs/RecordsApi.md#update_dns_zone_records) | **PATCH** /domain/v2beta1/dns-zones/{dns_zone}/records | Update DNS zone records
*ServersApi* | [**create_server**](docs/ServersApi.md#create_server) | **POST** /baremetal/v1/zones/{zone}/servers | Create a baremetal server
*ServersApi* | [**delete_server**](docs/ServersApi.md#delete_server) | **DELETE** /baremetal/v1/zones/{zone}/servers/{server_id} | Delete a baremetal server
*ServersApi* | [**get_server**](docs/ServersApi.md#get_server) | **GET** /baremetal/v1/zones/{zone}/servers/{server_id} | Get a specific baremetal server
*ServersApi* | [**get_server_metrics**](docs/ServersApi.md#get_server_metrics) | **GET** /baremetal/v1/zones/{zone}/servers/{server_id}/metrics | Return server metrics
*ServersApi* | [**install_server**](docs/ServersApi.md#install_server) | **POST** /baremetal/v1/zones/{zone}/servers/{server_id}/install | Install a baremetal server
*ServersApi* | [**list_server_events**](docs/ServersApi.md#list_server_events) | **GET** /baremetal/v1/zones/{zone}/servers/{server_id}/events | List server events
*ServersApi* | [**list_servers**](docs/ServersApi.md#list_servers) | **GET** /baremetal/v1/zones/{zone}/servers | List baremetal servers for organization
*ServersApi* | [**update_ip**](docs/ServersApi.md#update_ip) | **PATCH** /baremetal/v1/zones/{zone}/servers/{server_id}/ips/{ip_id} | Update IP
*ServersApi* | [**update_server**](docs/ServersApi.md#update_server) | **PATCH** /baremetal/v1/zones/{zone}/servers/{server_id} | Update a baremetal server
*ServersActionsApi* | [**reboot_server**](docs/ServersActionsApi.md#reboot_server) | **POST** /baremetal/v1/zones/{zone}/servers/{server_id}/reboot | Reboot a baremetal server
*ServersActionsApi* | [**start_server**](docs/ServersActionsApi.md#start_server) | **POST** /baremetal/v1/zones/{zone}/servers/{server_id}/start | Start a baremetal server
*ServersActionsApi* | [**stop_server**](docs/ServersActionsApi.md#stop_server) | **POST** /baremetal/v1/zones/{zone}/servers/{server_id}/stop | Stop a baremetal server
*SnapshotsApi* | [**create_instance_from_snapshot**](docs/SnapshotsApi.md#create_instance_from_snapshot) | **POST** /rdb/v1/regions/{region}/snapshots/{snapshot_id}/create-instance | Create a new instance from a given snapshot
*SnapshotsApi* | [**create_snapshot**](docs/SnapshotsApi.md#create_snapshot) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/snapshots | Create an instance snapshot
*SnapshotsApi* | [**delete_snapshot**](docs/SnapshotsApi.md#delete_snapshot) | **DELETE** /rdb/v1/regions/{region}/snapshots/{snapshot_id} | Delete an instance snapshot
*SnapshotsApi* | [**get_snapshot**](docs/SnapshotsApi.md#get_snapshot) | **GET** /rdb/v1/regions/{region}/snapshots/{snapshot_id} | Get an instance snapshot
*SnapshotsApi* | [**list_snapshots**](docs/SnapshotsApi.md#list_snapshots) | **GET** /rdb/v1/regions/{region}/snapshots | List instance snapshots
*SnapshotsApi* | [**update_snapshot**](docs/SnapshotsApi.md#update_snapshot) | **PATCH** /rdb/v1/regions/{region}/snapshots/{snapshot_id} | Update an instance snapshot
*TagsApi* | [**delete_tag**](docs/TagsApi.md#delete_tag) | **DELETE** /registry/v1/regions/{region}/tags/{tag_id} | Delete a tag
*TagsApi* | [**get_tag**](docs/TagsApi.md#get_tag) | **GET** /registry/v1/regions/{region}/tags/{tag_id} | Get a tag
*TagsApi* | [**list_tags**](docs/TagsApi.md#list_tags) | **GET** /registry/v1/regions/{region}/images/{image_id}/tags | List all your tags
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /rdb/v1/regions/{region}/instances/{instance_id}/users | Create a user on a given instance
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /rdb/v1/regions/{region}/instances/{instance_id}/users/{name} | Delete a user on a given instance
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /rdb/v1/regions/{region}/instances/{instance_id}/users | List users of a given instance
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PATCH** /rdb/v1/regions/{region}/instances/{instance_id}/users/{name} | Update a user on a given instance
*VersionsApi* | [**get_dns_zone_version_diff**](docs/VersionsApi.md#get_dns_zone_version_diff) | **GET** /domain/v2beta1/dns-zones/version/{dns_zone_version_id}/diff | Get DNS zone version diff
*VersionsApi* | [**get_version**](docs/VersionsApi.md#get_version) | **GET** /k8s/v1/regions/{region}/versions/{version_name} | Get details about a specific version
*VersionsApi* | [**list_dns_zone_version_records**](docs/VersionsApi.md#list_dns_zone_version_records) | **GET** /domain/v2beta1/dns-zones/version/{dns_zone_version_id} | List DNS zone version records
*VersionsApi* | [**list_dns_zone_versions**](docs/VersionsApi.md#list_dns_zone_versions) | **GET** /domain/v2beta1/dns-zones/{dns_zone}/versions | List DNS zone versions
*VersionsApi* | [**list_versions**](docs/VersionsApi.md#list_versions) | **GET** /k8s/v1/regions/{region}/versions | List all available versions
*VersionsApi* | [**restore_dns_zone_version**](docs/VersionsApi.md#restore_dns_zone_version) | **POST** /domain/v2beta1/dns-zones/version/{dns_zone_version_id}/restore | Restore DNS zone version


## Documentation For Models

 - [DomainV2beta1DnsZonesDnsZoneImportProviderOnlineV1](docs/DomainV2beta1DnsZonesDnsZoneImportProviderOnlineV1.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [InlineObject10](docs/InlineObject10.md)
 - [InlineObject11](docs/InlineObject11.md)
 - [InlineObject12](docs/InlineObject12.md)
 - [InlineObject13](docs/InlineObject13.md)
 - [InlineObject14](docs/InlineObject14.md)
 - [InlineObject15](docs/InlineObject15.md)
 - [InlineObject16](docs/InlineObject16.md)
 - [InlineObject17](docs/InlineObject17.md)
 - [InlineObject18](docs/InlineObject18.md)
 - [InlineObject19](docs/InlineObject19.md)
 - [InlineObject2](docs/InlineObject2.md)
 - [InlineObject20](docs/InlineObject20.md)
 - [InlineObject21](docs/InlineObject21.md)
 - [InlineObject22](docs/InlineObject22.md)
 - [InlineObject23](docs/InlineObject23.md)
 - [InlineObject24](docs/InlineObject24.md)
 - [InlineObject25](docs/InlineObject25.md)
 - [InlineObject26](docs/InlineObject26.md)
 - [InlineObject27](docs/InlineObject27.md)
 - [InlineObject28](docs/InlineObject28.md)
 - [InlineObject29](docs/InlineObject29.md)
 - [InlineObject3](docs/InlineObject3.md)
 - [InlineObject30](docs/InlineObject30.md)
 - [InlineObject31](docs/InlineObject31.md)
 - [InlineObject32](docs/InlineObject32.md)
 - [InlineObject33](docs/InlineObject33.md)
 - [InlineObject34](docs/InlineObject34.md)
 - [InlineObject35](docs/InlineObject35.md)
 - [InlineObject36](docs/InlineObject36.md)
 - [InlineObject37](docs/InlineObject37.md)
 - [InlineObject38](docs/InlineObject38.md)
 - [InlineObject39](docs/InlineObject39.md)
 - [InlineObject4](docs/InlineObject4.md)
 - [InlineObject40](docs/InlineObject40.md)
 - [InlineObject41](docs/InlineObject41.md)
 - [InlineObject42](docs/InlineObject42.md)
 - [InlineObject43](docs/InlineObject43.md)
 - [InlineObject44](docs/InlineObject44.md)
 - [InlineObject45](docs/InlineObject45.md)
 - [InlineObject46](docs/InlineObject46.md)
 - [InlineObject47](docs/InlineObject47.md)
 - [InlineObject48](docs/InlineObject48.md)
 - [InlineObject49](docs/InlineObject49.md)
 - [InlineObject5](docs/InlineObject5.md)
 - [InlineObject50](docs/InlineObject50.md)
 - [InlineObject51](docs/InlineObject51.md)
 - [InlineObject52](docs/InlineObject52.md)
 - [InlineObject53](docs/InlineObject53.md)
 - [InlineObject54](docs/InlineObject54.md)
 - [InlineObject6](docs/InlineObject6.md)
 - [InlineObject7](docs/InlineObject7.md)
 - [InlineObject8](docs/InlineObject8.md)
 - [InlineObject9](docs/InlineObject9.md)
 - [K8sV1RegionsRegionClustersAutoUpgrade](docs/K8sV1RegionsRegionClustersAutoUpgrade.md)
 - [K8sV1RegionsRegionClustersAutoUpgradeMaintenanceWindow](docs/K8sV1RegionsRegionClustersAutoUpgradeMaintenanceWindow.md)
 - [K8sV1RegionsRegionClustersAutoscalerConfig](docs/K8sV1RegionsRegionClustersAutoscalerConfig.md)
 - [K8sV1RegionsRegionClustersAutoscalerConfigScaleDownUtilizationThreshold](docs/K8sV1RegionsRegionClustersAutoscalerConfigScaleDownUtilizationThreshold.md)
 - [K8sV1RegionsRegionClustersClusterIdAutoUpgrade](docs/K8sV1RegionsRegionClustersClusterIdAutoUpgrade.md)
 - [K8sV1RegionsRegionClustersClusterIdAutoscalerConfig](docs/K8sV1RegionsRegionClustersClusterIdAutoscalerConfig.md)
 - [K8sV1RegionsRegionClustersClusterIdOpenIdConnectConfig](docs/K8sV1RegionsRegionClustersClusterIdOpenIdConnectConfig.md)
 - [K8sV1RegionsRegionClustersClusterIdPoolsUpgradePolicy](docs/K8sV1RegionsRegionClustersClusterIdPoolsUpgradePolicy.md)
 - [K8sV1RegionsRegionClustersOpenIdConnectConfig](docs/K8sV1RegionsRegionClustersOpenIdConnectConfig.md)
 - [K8sV1RegionsRegionPoolsPoolIdKubeletArgs](docs/K8sV1RegionsRegionPoolsPoolIdKubeletArgs.md)
 - [ScalewayBaremetalV1BmcAccess](docs/ScalewayBaremetalV1BmcAccess.md)
 - [ScalewayBaremetalV1Cpu](docs/ScalewayBaremetalV1Cpu.md)
 - [ScalewayBaremetalV1CreateServerRequestInstall](docs/ScalewayBaremetalV1CreateServerRequestInstall.md)
 - [ScalewayBaremetalV1Disk](docs/ScalewayBaremetalV1Disk.md)
 - [ScalewayBaremetalV1GetServerMetricsResponse](docs/ScalewayBaremetalV1GetServerMetricsResponse.md)
 - [ScalewayBaremetalV1GetServerMetricsResponsePings](docs/ScalewayBaremetalV1GetServerMetricsResponsePings.md)
 - [ScalewayBaremetalV1Ip](docs/ScalewayBaremetalV1Ip.md)
 - [ScalewayBaremetalV1ListOffersResponse](docs/ScalewayBaremetalV1ListOffersResponse.md)
 - [ScalewayBaremetalV1ListOsResponse](docs/ScalewayBaremetalV1ListOsResponse.md)
 - [ScalewayBaremetalV1ListServerEventsResponse](docs/ScalewayBaremetalV1ListServerEventsResponse.md)
 - [ScalewayBaremetalV1ListServersResponse](docs/ScalewayBaremetalV1ListServersResponse.md)
 - [ScalewayBaremetalV1Memory](docs/ScalewayBaremetalV1Memory.md)
 - [ScalewayBaremetalV1Offer](docs/ScalewayBaremetalV1Offer.md)
 - [ScalewayBaremetalV1OfferPricePerHour](docs/ScalewayBaremetalV1OfferPricePerHour.md)
 - [ScalewayBaremetalV1OfferPricePerMonth](docs/ScalewayBaremetalV1OfferPricePerMonth.md)
 - [ScalewayBaremetalV1Os](docs/ScalewayBaremetalV1Os.md)
 - [ScalewayBaremetalV1PersistentMemory](docs/ScalewayBaremetalV1PersistentMemory.md)
 - [ScalewayBaremetalV1RaidController](docs/ScalewayBaremetalV1RaidController.md)
 - [ScalewayBaremetalV1Server](docs/ScalewayBaremetalV1Server.md)
 - [ScalewayBaremetalV1ServerEvent](docs/ScalewayBaremetalV1ServerEvent.md)
 - [ScalewayBaremetalV1ServerInstall](docs/ScalewayBaremetalV1ServerInstall.md)
 - [ScalewayBaremetalV1ServerInstallStatus](docs/ScalewayBaremetalV1ServerInstallStatus.md)
 - [ScalewayDomainV2beta1DnsZone](docs/ScalewayDomainV2beta1DnsZone.md)
 - [ScalewayDomainV2beta1DnsZoneStatus](docs/ScalewayDomainV2beta1DnsZoneStatus.md)
 - [ScalewayDomainV2beta1DnsZoneVersion](docs/ScalewayDomainV2beta1DnsZoneVersion.md)
 - [ScalewayDomainV2beta1GetDnsZoneTsigKeyResponse](docs/ScalewayDomainV2beta1GetDnsZoneTsigKeyResponse.md)
 - [ScalewayDomainV2beta1GetDnsZoneVersionDiffResponse](docs/ScalewayDomainV2beta1GetDnsZoneVersionDiffResponse.md)
 - [ScalewayDomainV2beta1ImportProviderDnsZoneResponse](docs/ScalewayDomainV2beta1ImportProviderDnsZoneResponse.md)
 - [ScalewayDomainV2beta1ImportRawDnsZoneResponse](docs/ScalewayDomainV2beta1ImportRawDnsZoneResponse.md)
 - [ScalewayDomainV2beta1ListDnsZoneNameserversResponse](docs/ScalewayDomainV2beta1ListDnsZoneNameserversResponse.md)
 - [ScalewayDomainV2beta1ListDnsZoneRecordsResponse](docs/ScalewayDomainV2beta1ListDnsZoneRecordsResponse.md)
 - [ScalewayDomainV2beta1ListDnsZoneVersionRecordsResponse](docs/ScalewayDomainV2beta1ListDnsZoneVersionRecordsResponse.md)
 - [ScalewayDomainV2beta1ListDnsZoneVersionsResponse](docs/ScalewayDomainV2beta1ListDnsZoneVersionsResponse.md)
 - [ScalewayDomainV2beta1ListDnsZonesResponse](docs/ScalewayDomainV2beta1ListDnsZonesResponse.md)
 - [ScalewayDomainV2beta1ListSslCertificatesResponse](docs/ScalewayDomainV2beta1ListSslCertificatesResponse.md)
 - [ScalewayDomainV2beta1Nameserver](docs/ScalewayDomainV2beta1Nameserver.md)
 - [ScalewayDomainV2beta1RawFormat](docs/ScalewayDomainV2beta1RawFormat.md)
 - [ScalewayDomainV2beta1Record](docs/ScalewayDomainV2beta1Record.md)
 - [ScalewayDomainV2beta1RecordChange](docs/ScalewayDomainV2beta1RecordChange.md)
 - [ScalewayDomainV2beta1RecordChangeAdd](docs/ScalewayDomainV2beta1RecordChangeAdd.md)
 - [ScalewayDomainV2beta1RecordChangeDelete](docs/ScalewayDomainV2beta1RecordChangeDelete.md)
 - [ScalewayDomainV2beta1RecordChangeSet](docs/ScalewayDomainV2beta1RecordChangeSet.md)
 - [ScalewayDomainV2beta1RecordChangeSetIdFields](docs/ScalewayDomainV2beta1RecordChangeSetIdFields.md)
 - [ScalewayDomainV2beta1RecordGeoIpConfig](docs/ScalewayDomainV2beta1RecordGeoIpConfig.md)
 - [ScalewayDomainV2beta1RecordGeoIpConfigMatch](docs/ScalewayDomainV2beta1RecordGeoIpConfigMatch.md)
 - [ScalewayDomainV2beta1RecordHttpServiceConfig](docs/ScalewayDomainV2beta1RecordHttpServiceConfig.md)
 - [ScalewayDomainV2beta1RecordHttpServiceConfigStrategy](docs/ScalewayDomainV2beta1RecordHttpServiceConfigStrategy.md)
 - [ScalewayDomainV2beta1RecordType](docs/ScalewayDomainV2beta1RecordType.md)
 - [ScalewayDomainV2beta1RecordViewConfig](docs/ScalewayDomainV2beta1RecordViewConfig.md)
 - [ScalewayDomainV2beta1RecordViewConfigView](docs/ScalewayDomainV2beta1RecordViewConfigView.md)
 - [ScalewayDomainV2beta1RecordWeightedConfig](docs/ScalewayDomainV2beta1RecordWeightedConfig.md)
 - [ScalewayDomainV2beta1RecordWeightedConfigWeightedIp](docs/ScalewayDomainV2beta1RecordWeightedConfigWeightedIp.md)
 - [ScalewayDomainV2beta1RefreshDnsZoneResponse](docs/ScalewayDomainV2beta1RefreshDnsZoneResponse.md)
 - [ScalewayDomainV2beta1SslCertificate](docs/ScalewayDomainV2beta1SslCertificate.md)
 - [ScalewayDomainV2beta1SslCertificateStatus](docs/ScalewayDomainV2beta1SslCertificateStatus.md)
 - [ScalewayDomainV2beta1UpdateDnsZoneNameserversResponse](docs/ScalewayDomainV2beta1UpdateDnsZoneNameserversResponse.md)
 - [ScalewayDomainV2beta1UpdateDnsZoneRecordsResponse](docs/ScalewayDomainV2beta1UpdateDnsZoneRecordsResponse.md)
 - [ScalewayFlexibleIpV1alpha1AttachFlexibleIpsResponse](docs/ScalewayFlexibleIpV1alpha1AttachFlexibleIpsResponse.md)
 - [ScalewayFlexibleIpV1alpha1DetachFlexibleIpsResponse](docs/ScalewayFlexibleIpV1alpha1DetachFlexibleIpsResponse.md)
 - [ScalewayFlexibleIpV1alpha1FlexibleIp](docs/ScalewayFlexibleIpV1alpha1FlexibleIp.md)
 - [ScalewayFlexibleIpV1alpha1FlexibleIpMacAddress](docs/ScalewayFlexibleIpV1alpha1FlexibleIpMacAddress.md)
 - [ScalewayFlexibleIpV1alpha1FlexibleIpStatus](docs/ScalewayFlexibleIpV1alpha1FlexibleIpStatus.md)
 - [ScalewayFlexibleIpV1alpha1ListFlexibleIpsResponse](docs/ScalewayFlexibleIpV1alpha1ListFlexibleIpsResponse.md)
 - [ScalewayFlexibleIpV1alpha1MacAddressStatus](docs/ScalewayFlexibleIpV1alpha1MacAddressStatus.md)
 - [ScalewayFlexibleIpV1alpha1MacAddressType](docs/ScalewayFlexibleIpV1alpha1MacAddressType.md)
 - [ScalewayK8sV1Cluster](docs/ScalewayK8sV1Cluster.md)
 - [ScalewayK8sV1ClusterAutoUpgrade](docs/ScalewayK8sV1ClusterAutoUpgrade.md)
 - [ScalewayK8sV1ClusterAutoscalerConfig](docs/ScalewayK8sV1ClusterAutoscalerConfig.md)
 - [ScalewayK8sV1ClusterOpenIdConnectConfig](docs/ScalewayK8sV1ClusterOpenIdConnectConfig.md)
 - [ScalewayK8sV1Cni](docs/ScalewayK8sV1Cni.md)
 - [ScalewayK8sV1CreateClusterRequestPoolConfig](docs/ScalewayK8sV1CreateClusterRequestPoolConfig.md)
 - [ScalewayK8sV1CreateClusterRequestPoolConfigUpgradePolicy](docs/ScalewayK8sV1CreateClusterRequestPoolConfigUpgradePolicy.md)
 - [ScalewayK8sV1Ingress](docs/ScalewayK8sV1Ingress.md)
 - [ScalewayK8sV1ListClusterAvailableVersionsResponse](docs/ScalewayK8sV1ListClusterAvailableVersionsResponse.md)
 - [ScalewayK8sV1ListClustersResponse](docs/ScalewayK8sV1ListClustersResponse.md)
 - [ScalewayK8sV1ListNodesResponse](docs/ScalewayK8sV1ListNodesResponse.md)
 - [ScalewayK8sV1ListPoolsResponse](docs/ScalewayK8sV1ListPoolsResponse.md)
 - [ScalewayK8sV1ListVersionsResponse](docs/ScalewayK8sV1ListVersionsResponse.md)
 - [ScalewayK8sV1Node](docs/ScalewayK8sV1Node.md)
 - [ScalewayK8sV1Pool](docs/ScalewayK8sV1Pool.md)
 - [ScalewayK8sV1PoolUpgradePolicy](docs/ScalewayK8sV1PoolUpgradePolicy.md)
 - [ScalewayK8sV1Runtime](docs/ScalewayK8sV1Runtime.md)
 - [ScalewayK8sV1Version](docs/ScalewayK8sV1Version.md)
 - [ScalewayRdbV1AclRule](docs/ScalewayRdbV1AclRule.md)
 - [ScalewayRdbV1AclRuleAction](docs/ScalewayRdbV1AclRuleAction.md)
 - [ScalewayRdbV1AclRuleDirection](docs/ScalewayRdbV1AclRuleDirection.md)
 - [ScalewayRdbV1AclRuleProtocol](docs/ScalewayRdbV1AclRuleProtocol.md)
 - [ScalewayRdbV1AclRuleRequest](docs/ScalewayRdbV1AclRuleRequest.md)
 - [ScalewayRdbV1AddInstanceAclRulesResponse](docs/ScalewayRdbV1AddInstanceAclRulesResponse.md)
 - [ScalewayRdbV1AddInstanceSettingsResponse](docs/ScalewayRdbV1AddInstanceSettingsResponse.md)
 - [ScalewayRdbV1Database](docs/ScalewayRdbV1Database.md)
 - [ScalewayRdbV1DatabaseBackup](docs/ScalewayRdbV1DatabaseBackup.md)
 - [ScalewayRdbV1DatabaseEngine](docs/ScalewayRdbV1DatabaseEngine.md)
 - [ScalewayRdbV1DeleteInstanceAclRulesResponse](docs/ScalewayRdbV1DeleteInstanceAclRulesResponse.md)
 - [ScalewayRdbV1DeleteInstanceSettingsResponse](docs/ScalewayRdbV1DeleteInstanceSettingsResponse.md)
 - [ScalewayRdbV1Endpoint](docs/ScalewayRdbV1Endpoint.md)
 - [ScalewayRdbV1EngineSetting](docs/ScalewayRdbV1EngineSetting.md)
 - [ScalewayRdbV1EngineSettingFloatMax](docs/ScalewayRdbV1EngineSettingFloatMax.md)
 - [ScalewayRdbV1EngineSettingFloatMin](docs/ScalewayRdbV1EngineSettingFloatMin.md)
 - [ScalewayRdbV1EngineVersion](docs/ScalewayRdbV1EngineVersion.md)
 - [ScalewayRdbV1Instance](docs/ScalewayRdbV1Instance.md)
 - [ScalewayRdbV1InstanceBackupSchedule](docs/ScalewayRdbV1InstanceBackupSchedule.md)
 - [ScalewayRdbV1InstanceEndpoint](docs/ScalewayRdbV1InstanceEndpoint.md)
 - [ScalewayRdbV1InstanceLog](docs/ScalewayRdbV1InstanceLog.md)
 - [ScalewayRdbV1InstanceMetrics](docs/ScalewayRdbV1InstanceMetrics.md)
 - [ScalewayRdbV1InstanceSetting](docs/ScalewayRdbV1InstanceSetting.md)
 - [ScalewayRdbV1InstanceVolume](docs/ScalewayRdbV1InstanceVolume.md)
 - [ScalewayRdbV1ListDatabaseBackupsResponse](docs/ScalewayRdbV1ListDatabaseBackupsResponse.md)
 - [ScalewayRdbV1ListDatabaseEnginesResponse](docs/ScalewayRdbV1ListDatabaseEnginesResponse.md)
 - [ScalewayRdbV1ListDatabasesResponse](docs/ScalewayRdbV1ListDatabasesResponse.md)
 - [ScalewayRdbV1ListInstanceAclRulesResponse](docs/ScalewayRdbV1ListInstanceAclRulesResponse.md)
 - [ScalewayRdbV1ListInstanceLogsResponse](docs/ScalewayRdbV1ListInstanceLogsResponse.md)
 - [ScalewayRdbV1ListInstancesResponse](docs/ScalewayRdbV1ListInstancesResponse.md)
 - [ScalewayRdbV1ListNodeTypesResponse](docs/ScalewayRdbV1ListNodeTypesResponse.md)
 - [ScalewayRdbV1ListPrivilegesResponse](docs/ScalewayRdbV1ListPrivilegesResponse.md)
 - [ScalewayRdbV1ListSnapshotsResponse](docs/ScalewayRdbV1ListSnapshotsResponse.md)
 - [ScalewayRdbV1ListUsersResponse](docs/ScalewayRdbV1ListUsersResponse.md)
 - [ScalewayRdbV1NodeType](docs/ScalewayRdbV1NodeType.md)
 - [ScalewayRdbV1NodeTypeVolumeConstraint](docs/ScalewayRdbV1NodeTypeVolumeConstraint.md)
 - [ScalewayRdbV1NodeTypeVolumeType](docs/ScalewayRdbV1NodeTypeVolumeType.md)
 - [ScalewayRdbV1PrepareInstanceLogsResponse](docs/ScalewayRdbV1PrepareInstanceLogsResponse.md)
 - [ScalewayRdbV1Privilege](docs/ScalewayRdbV1Privilege.md)
 - [ScalewayRdbV1SetInstanceAclRulesResponse](docs/ScalewayRdbV1SetInstanceAclRulesResponse.md)
 - [ScalewayRdbV1SetInstanceSettingsResponse](docs/ScalewayRdbV1SetInstanceSettingsResponse.md)
 - [ScalewayRdbV1Snapshot](docs/ScalewayRdbV1Snapshot.md)
 - [ScalewayRdbV1User](docs/ScalewayRdbV1User.md)
 - [ScalewayRdbV1VolumeType](docs/ScalewayRdbV1VolumeType.md)
 - [ScalewayRegistryV1Image](docs/ScalewayRegistryV1Image.md)
 - [ScalewayRegistryV1ListImagesResponse](docs/ScalewayRegistryV1ListImagesResponse.md)
 - [ScalewayRegistryV1ListNamespacesResponse](docs/ScalewayRegistryV1ListNamespacesResponse.md)
 - [ScalewayRegistryV1ListTagsResponse](docs/ScalewayRegistryV1ListTagsResponse.md)
 - [ScalewayRegistryV1Namespace](docs/ScalewayRegistryV1Namespace.md)
 - [ScalewayRegistryV1Tag](docs/ScalewayRegistryV1Tag.md)
 - [ScalewayStdFile](docs/ScalewayStdFile.md)
 - [ScalewayStdServiceInfo](docs/ScalewayStdServiceInfo.md)
 - [ScalewayStdTimeSeries](docs/ScalewayStdTimeSeries.md)
 - [ScalewayStdTimeSeriesPoint](docs/ScalewayStdTimeSeriesPoint.md)
 - [ScalewayVpcV1ListPrivateNetworksResponse](docs/ScalewayVpcV1ListPrivateNetworksResponse.md)
 - [ScalewayVpcV1PrivateNetwork](docs/ScalewayVpcV1PrivateNetwork.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



