/*
 * Instance API
 *
 * # Introduction  ## Endpoints  Scaleway instance API can be reach on  - `https://api.scaleway.com/instance/v1/zones/fr-par-1` - `https://api.scaleway.com/instance/v1/zones/fr-par-2` - `https://api.scaleway.com/instance/v1/zones/nl-ams-1` - `https://api.scaleway.com/instance/v1/zones/pl-waw-1`  Older endpoints are still reachable but should not be used for new projects  - `https://cp-par1.scaleway.com` - `https://cp-ams1.scaleway.com`  <Example>  The following code is an example request to retrieve detailed information about a volume:  ``` % curl -H 'X-Auth-Token: xxxxxxxx-xxxx-xxxxx-xxxx-xxxxxxxxxxxxx' -H 'Content-Type: application/json' https://api.scaleway.com/instance/v1/zones/fr-par-1/volumes/f929fe39-63f8-4be8-a80e-1e9c8ae22a76 -i  HTTP/1.1 200 OK Server: nginx Date: Thu, 22 May 2014 07:55:00 GMT Content-Type: application/json Content-Length: 1345 Connection: keep-alive Strict-Transport-Security: max-age=86400  {   \"volumes\": [     {       \"export_uri\": null,       \"id\": \"f929fe39-63f8-4be8-a80e-1e9c8ae22a76\",       \"name\": \"volume-0-1\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 10000000000,       \"volume_type\": \"l_ssd\"     },     {       \"export_uri\": null,       \"id\": \"0facb6b5-b117-441a-81c1-f28b1d723779\",       \"name\": \"volume-0-2\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 20000000000,       \"volume_type\": \"l_ssd\"     }   ] } ```  </Example>  ## Pagination  Most of listing requests receive a paginated response.  **Paginated request**  Requests against paginated endpoints accept two `query` arguments:  - `page`, a positive integer to choose the page to return. - `per_page`, an positive integer lower or equal to 100 to select the number of   items to return. The default value is `50`.  Paginated endpoints usually also accept filters to search and sort results. These filters are documented along each endpoint documentation.  **Paginated response**  ```bash % curl -H 'X-Auth-Token: <token>' 'https://api.scaleway.com/instance/v1/zones/fr-par-1/images/?page=2&per_page=10' -i HTTP/1.0 200 OK [...] X-Total-Count: 209 [...] ```  The `X-Total-Count` header contains the total number of items for the resource.
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ScalewayK8sV1Cluster {
    /// The ID of the cluster
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The name of the cluster
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The status of the cluster
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<Status>,
    /// The Kubernetes version of the cluster
    #[serde(rename = "version", skip_serializing_if = "Option::is_none")]
    pub version: Option<String>,
    /// The region in which the cluster is
    #[serde(rename = "region", skip_serializing_if = "Option::is_none")]
    pub region: Option<String>,
    /// The ID of the organization owning the cluster
    #[serde(rename = "organization_id", skip_serializing_if = "Option::is_none")]
    pub organization_id: Option<String>,
    /// The ID of the project owning the cluster
    #[serde(rename = "project_id", skip_serializing_if = "Option::is_none")]
    pub project_id: Option<String>,
    /// The tags associated with the cluster
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// The Container Network Interface (CNI) plugin running in the cluster
    #[serde(rename = "cni", skip_serializing_if = "Option::is_none")]
    pub cni: Option<Cni>,
    /// The description of the cluster
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The Kubernetes API server URL of the cluster
    #[serde(rename = "cluster_url", skip_serializing_if = "Option::is_none")]
    pub cluster_url: Option<String>,
    /// The DNS wildcard resovling all the ready nodes of the cluster
    #[serde(rename = "dns_wildcard", skip_serializing_if = "Option::is_none")]
    pub dns_wildcard: Option<String>,
    /// The date at which the cluster was created
    #[serde(rename = "created_at", skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    /// The date at which the cluster was last updated
    #[serde(rename = "updated_at", skip_serializing_if = "Option::is_none")]
    pub updated_at: Option<String>,
    #[serde(rename = "autoscaler_config", skip_serializing_if = "Option::is_none")]
    pub autoscaler_config: Option<Box<crate::models::ScalewayK8sV1ClusterAutoscalerConfig>>,
    /// The enablement of the Kubernetes Dashboard in the cluster
    #[serde(rename = "dashboard_enabled", skip_serializing_if = "Option::is_none")]
    pub dashboard_enabled: Option<bool>,
    /// The ingress controller used in the cluster
    #[serde(rename = "ingress", skip_serializing_if = "Option::is_none")]
    pub ingress: Option<Ingress>,
    #[serde(rename = "auto_upgrade", skip_serializing_if = "Option::is_none")]
    pub auto_upgrade: Option<Box<crate::models::ScalewayK8sV1ClusterAutoUpgrade>>,
    /// True if a new Kubernetes version is available
    #[serde(rename = "upgrade_available", skip_serializing_if = "Option::is_none")]
    pub upgrade_available: Option<bool>,
    /// List of enabled feature gates
    #[serde(rename = "feature_gates", skip_serializing_if = "Option::is_none")]
    pub feature_gates: Option<Vec<String>>,
    /// List of enabled admission plugins
    #[serde(rename = "admission_plugins", skip_serializing_if = "Option::is_none")]
    pub admission_plugins: Option<Vec<String>>,
    #[serde(
        rename = "open_id_connect_config",
        skip_serializing_if = "Option::is_none"
    )]
    pub open_id_connect_config: Option<Box<crate::models::ScalewayK8sV1ClusterOpenIdConnectConfig>>,
    /// Additional Subject Alternative Names for the Kubernetes API server certificate
    #[serde(
        rename = "apiserver_cert_sans",
        skip_serializing_if = "Option::is_none"
    )]
    pub apiserver_cert_sans: Option<Vec<String>>,
}

impl ScalewayK8sV1Cluster {
    pub fn new() -> ScalewayK8sV1Cluster {
        ScalewayK8sV1Cluster {
            id: None,
            name: None,
            status: None,
            version: None,
            region: None,
            organization_id: None,
            project_id: None,
            tags: None,
            cni: None,
            description: None,
            cluster_url: None,
            dns_wildcard: None,
            created_at: None,
            updated_at: None,
            autoscaler_config: None,
            dashboard_enabled: None,
            ingress: None,
            auto_upgrade: None,
            upgrade_available: None,
            feature_gates: None,
            admission_plugins: None,
            open_id_connect_config: None,
            apiserver_cert_sans: None,
        }
    }
}

/// The status of the cluster
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Status {
    #[serde(rename = "unknown")]
    Unknown,
    #[serde(rename = "creating")]
    Creating,
    #[serde(rename = "ready")]
    Ready,
    #[serde(rename = "deleting")]
    Deleting,
    #[serde(rename = "deleted")]
    Deleted,
    #[serde(rename = "updating")]
    Updating,
    #[serde(rename = "locked")]
    Locked,
    #[serde(rename = "pool_required")]
    PoolRequired,
}
/// The Container Network Interface (CNI) plugin running in the cluster
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Cni {
    #[serde(rename = "unknown_cni")]
    UnknownCni,
    #[serde(rename = "cilium")]
    Cilium,
    #[serde(rename = "calico")]
    Calico,
    #[serde(rename = "weave")]
    Weave,
    #[serde(rename = "flannel")]
    Flannel,
    #[serde(rename = "kilo")]
    Kilo,
}
/// The ingress controller used in the cluster
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Ingress {
    #[serde(rename = "unknown_ingress")]
    UnknownIngress,
    #[serde(rename = "none")]
    None,
    #[serde(rename = "nginx")]
    Nginx,
    #[serde(rename = "traefik")]
    Traefik,
    #[serde(rename = "traefik2")]
    Traefik2,
}
