/*
 * Instance API
 *
 * # Introduction  ## Endpoints  Scaleway instance API can be reach on  - `https://api.scaleway.com/instance/v1/zones/fr-par-1` - `https://api.scaleway.com/instance/v1/zones/fr-par-2` - `https://api.scaleway.com/instance/v1/zones/nl-ams-1` - `https://api.scaleway.com/instance/v1/zones/pl-waw-1`  Older endpoints are still reachable but should not be used for new projects  - `https://cp-par1.scaleway.com` - `https://cp-ams1.scaleway.com`  <Example>  The following code is an example request to retrieve detailed information about a volume:  ``` % curl -H 'X-Auth-Token: xxxxxxxx-xxxx-xxxxx-xxxx-xxxxxxxxxxxxx' -H 'Content-Type: application/json' https://api.scaleway.com/instance/v1/zones/fr-par-1/volumes/f929fe39-63f8-4be8-a80e-1e9c8ae22a76 -i  HTTP/1.1 200 OK Server: nginx Date: Thu, 22 May 2014 07:55:00 GMT Content-Type: application/json Content-Length: 1345 Connection: keep-alive Strict-Transport-Security: max-age=86400  {   \"volumes\": [     {       \"export_uri\": null,       \"id\": \"f929fe39-63f8-4be8-a80e-1e9c8ae22a76\",       \"name\": \"volume-0-1\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 10000000000,       \"volume_type\": \"l_ssd\"     },     {       \"export_uri\": null,       \"id\": \"0facb6b5-b117-441a-81c1-f28b1d723779\",       \"name\": \"volume-0-2\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 20000000000,       \"volume_type\": \"l_ssd\"     }   ] } ```  </Example>  ## Pagination  Most of listing requests receive a paginated response.  **Paginated request**  Requests against paginated endpoints accept two `query` arguments:  - `page`, a positive integer to choose the page to return. - `per_page`, an positive integer lower or equal to 100 to select the number of   items to return. The default value is `50`.  Paginated endpoints usually also accept filters to search and sort results. These filters are documented along each endpoint documentation.  **Paginated response**  ```bash % curl -H 'X-Auth-Token: <token>' 'https://api.scaleway.com/instance/v1/zones/fr-par-1/images/?page=2&per_page=10' -i HTTP/1.0 200 OK [...] X-Total-Count: 209 [...] ```  The `X-Total-Count` header contains the total number of items for the resource.
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InlineObject25 {
    /// The organization ID where the cluster will be created
    #[serde(rename = "organization_id", skip_serializing_if = "Option::is_none")]
    pub organization_id: Option<String>,
    /// The project ID where the cluster will be created
    #[serde(rename = "project_id", skip_serializing_if = "Option::is_none")]
    pub project_id: Option<String>,
    /// The type of the cluster
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<String>,
    /// The name of the cluster
    #[serde(rename = "name")]
    pub name: String,
    /// The description of the cluster
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// The tags associated with the cluster
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// The Kubernetes version of the cluster
    #[serde(rename = "version")]
    pub version: String,
    /// The Container Network Interface (CNI) plugin that will run in the cluster
    #[serde(rename = "cni")]
    pub cni: Cni,
    /// The enablement of the Kubernetes Dashboard in the cluster
    #[serde(rename = "enable_dashboard", skip_serializing_if = "Option::is_none")]
    pub enable_dashboard: Option<bool>,
    /// The Ingress Controller that will run in the cluster
    #[serde(rename = "ingress", skip_serializing_if = "Option::is_none")]
    pub ingress: Option<Ingress>,
    /// The pools to be created along with the cluster
    #[serde(rename = "pools", skip_serializing_if = "Option::is_none")]
    pub pools: Option<Vec<crate::models::ScalewayK8sV1CreateClusterRequestPoolConfig>>,
    #[serde(rename = "autoscaler_config", skip_serializing_if = "Option::is_none")]
    pub autoscaler_config: Option<Box<crate::models::K8sV1RegionsRegionClustersAutoscalerConfig>>,
    #[serde(rename = "auto_upgrade", skip_serializing_if = "Option::is_none")]
    pub auto_upgrade: Option<Box<crate::models::K8sV1RegionsRegionClustersAutoUpgrade>>,
    /// List of feature gates to enable
    #[serde(rename = "feature_gates", skip_serializing_if = "Option::is_none")]
    pub feature_gates: Option<Vec<String>>,
    /// List of admission plugins to enable
    #[serde(rename = "admission_plugins", skip_serializing_if = "Option::is_none")]
    pub admission_plugins: Option<Vec<String>>,
    #[serde(
        rename = "open_id_connect_config",
        skip_serializing_if = "Option::is_none"
    )]
    pub open_id_connect_config:
        Option<Box<crate::models::K8sV1RegionsRegionClustersOpenIdConnectConfig>>,
    /// Additional Subject Alternative Names for the Kubernetes API server certificate
    #[serde(
        rename = "apiserver_cert_sans",
        skip_serializing_if = "Option::is_none"
    )]
    pub apiserver_cert_sans: Option<Vec<String>>,
}

impl InlineObject25 {
    pub fn new(name: String, version: String, cni: Cni) -> InlineObject25 {
        InlineObject25 {
            organization_id: None,
            project_id: None,
            _type: None,
            name,
            description: None,
            tags: None,
            version,
            cni,
            enable_dashboard: None,
            ingress: None,
            pools: None,
            autoscaler_config: None,
            auto_upgrade: None,
            feature_gates: None,
            admission_plugins: None,
            open_id_connect_config: None,
            apiserver_cert_sans: None,
        }
    }
}

/// The Container Network Interface (CNI) plugin that will run in the cluster
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Cni {
    #[serde(rename = "unknown_cni")]
    UnknownCni,
    #[serde(rename = "cilium")]
    Cilium,
    #[serde(rename = "calico")]
    Calico,
    #[serde(rename = "weave")]
    Weave,
    #[serde(rename = "flannel")]
    Flannel,
    #[serde(rename = "kilo")]
    Kilo,
}
/// The Ingress Controller that will run in the cluster
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Ingress {
    #[serde(rename = "unknown_ingress")]
    UnknownIngress,
    #[serde(rename = "none")]
    None,
    #[serde(rename = "nginx")]
    Nginx,
    #[serde(rename = "traefik")]
    Traefik,
    #[serde(rename = "traefik2")]
    Traefik2,
}
