/*
 * Instance API
 *
 * # Introduction  ## Endpoints  Scaleway instance API can be reach on  - `https://api.scaleway.com/instance/v1/zones/fr-par-1` - `https://api.scaleway.com/instance/v1/zones/fr-par-2` - `https://api.scaleway.com/instance/v1/zones/nl-ams-1` - `https://api.scaleway.com/instance/v1/zones/pl-waw-1`  Older endpoints are still reachable but should not be used for new projects  - `https://cp-par1.scaleway.com` - `https://cp-ams1.scaleway.com`  <Example>  The following code is an example request to retrieve detailed information about a volume:  ``` % curl -H 'X-Auth-Token: xxxxxxxx-xxxx-xxxxx-xxxx-xxxxxxxxxxxxx' -H 'Content-Type: application/json' https://api.scaleway.com/instance/v1/zones/fr-par-1/volumes/f929fe39-63f8-4be8-a80e-1e9c8ae22a76 -i  HTTP/1.1 200 OK Server: nginx Date: Thu, 22 May 2014 07:55:00 GMT Content-Type: application/json Content-Length: 1345 Connection: keep-alive Strict-Transport-Security: max-age=86400  {   \"volumes\": [     {       \"export_uri\": null,       \"id\": \"f929fe39-63f8-4be8-a80e-1e9c8ae22a76\",       \"name\": \"volume-0-1\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 10000000000,       \"volume_type\": \"l_ssd\"     },     {       \"export_uri\": null,       \"id\": \"0facb6b5-b117-441a-81c1-f28b1d723779\",       \"name\": \"volume-0-2\",       \"organization\": \"000a115d-2852-4b0a-9ce8-47f1134ba95a\",       \"server\": null,       \"size\": 20000000000,       \"volume_type\": \"l_ssd\"     }   ] } ```  </Example>  ## Pagination  Most of listing requests receive a paginated response.  **Paginated request**  Requests against paginated endpoints accept two `query` arguments:  - `page`, a positive integer to choose the page to return. - `per_page`, an positive integer lower or equal to 100 to select the number of   items to return. The default value is `50`.  Paginated endpoints usually also accept filters to search and sort results. These filters are documented along each endpoint documentation.  **Paginated response**  ```bash % curl -H 'X-Auth-Token: <token>' 'https://api.scaleway.com/instance/v1/zones/fr-par-1/images/?page=2&per_page=10' -i HTTP/1.0 200 OK [...] X-Total-Count: 209 [...] ```  The `X-Total-Count` header contains the total number of items for the resource.
 *
 * The version of the OpenAPI document: v1
 *
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct InlineObject13 {
    /// The server name
    #[serde(rename = "name")]
    pub name: String,
    /// Define if a dynamic IP is required for the instance
    #[serde(
        rename = "dynamic_ip_required",
        skip_serializing_if = "Option::is_none"
    )]
    pub dynamic_ip_required: Option<bool>,
    /// Define the server commercial type (i.e. GP1-S)
    #[serde(rename = "commercial_type")]
    pub commercial_type: String,
    /// The server image ID
    #[serde(rename = "image", skip_serializing_if = "Option::is_none")]
    pub image: Option<String>,
    /// The volumes attached to the server
    #[serde(rename = "volumes", skip_serializing_if = "Option::is_none")]
    pub volumes: Option<::std::collections::HashMap<String, serde_json::Value>>,
    /// True if IPv6 is enabled on the server
    #[serde(rename = "enable_ipv6", skip_serializing_if = "Option::is_none")]
    pub enable_ipv6: Option<bool>,
    /// The ID of the reserved IP to attach to the server
    #[serde(rename = "public_ip", skip_serializing_if = "Option::is_none")]
    pub public_ip: Option<String>,
    /// The boot type to use
    #[serde(rename = "boot_type", skip_serializing_if = "Option::is_none")]
    pub boot_type: Option<BootType>,
    /// The bootscript ID to use when `boot_type` is set to `bootscript`
    #[serde(rename = "bootscript", skip_serializing_if = "Option::is_none")]
    pub bootscript: Option<String>,
    /// The server organization ID
    #[serde(rename = "organization", skip_serializing_if = "Option::is_none")]
    pub organization: Option<String>,
    /// The server project ID
    #[serde(rename = "project", skip_serializing_if = "Option::is_none")]
    pub project: Option<String>,
    /// The server tags
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    /// The security group ID
    #[serde(rename = "security_group", skip_serializing_if = "Option::is_none")]
    pub security_group: Option<String>,
    /// Placement group ID if server must be part of a placement group
    #[serde(rename = "placement_group", skip_serializing_if = "Option::is_none")]
    pub placement_group: Option<String>,
}

impl InlineObject13 {
    pub fn new(name: String, commercial_type: String) -> InlineObject13 {
        InlineObject13 {
            name,
            dynamic_ip_required: None,
            commercial_type,
            image: None,
            volumes: None,
            enable_ipv6: None,
            public_ip: None,
            boot_type: None,
            bootscript: None,
            organization: None,
            project: None,
            tags: None,
            security_group: None,
            placement_group: None,
        }
    }
}

/// The boot type to use
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum BootType {
    #[serde(rename = "local")]
    Local,
    #[serde(rename = "bootscript")]
    Bootscript,
    #[serde(rename = "rescue")]
    Rescue,
}
